import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { GetResourcePolicy$ } from "../schemas/schemas_0";
export { $Command };
export class GetResourcePolicyCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
    OperationType: { type: "staticContextParams", value: `control` },
    ResourceARN: { type: "contextParams", name: "ResourceARN" },
})
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Kinesis_20131202", "GetResourcePolicy", {})
    .n("KinesisClient", "GetResourcePolicyCommand")
    .sc(GetResourcePolicy$)
    .build() {
}
