import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { PutResourcePolicy$ } from "../schemas/schemas_0";
export { $Command };
export class PutResourcePolicyCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
    OperationType: { type: "staticContextParams", value: `control` },
    ResourceARN: { type: "contextParams", name: "ResourceARN" },
})
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Kinesis_20131202", "PutResourcePolicy", {})
    .n("KinesisClient", "PutResourcePolicyCommand")
    .sc(PutResourcePolicy$)
    .build() {
}
