import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { SplitShard$ } from "../schemas/schemas_0";
export { $Command };
export class SplitShardCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
    OperationType: { type: "staticContextParams", value: `control` },
    StreamARN: { type: "contextParams", name: "StreamARN" },
})
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Kinesis_20131202", "SplitShard", {})
    .n("KinesisClient", "SplitShardCommand")
    .sc(SplitShard$)
    .build() {
}
