import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { StopStreamEncryption$ } from "../schemas/schemas_0";
export { $Command };
export class StopStreamEncryptionCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
    OperationType: { type: "staticContextParams", value: `control` },
    StreamARN: { type: "contextParams", name: "StreamARN" },
})
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Kinesis_20131202", "StopStreamEncryption", {})
    .n("KinesisClient", "StopStreamEncryptionCommand")
    .sc(StopStreamEncryption$)
    .build() {
}
