import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { SubscribeToShard$ } from "../schemas/schemas_0";
export { $Command };
export class SubscribeToShardCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
    OperationType: { type: "staticContextParams", value: `data` },
    ConsumerARN: { type: "contextParams", name: "ConsumerARN" },
})
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Kinesis_20131202", "SubscribeToShard", {
    eventStream: {
        output: true,
    },
})
    .n("KinesisClient", "SubscribeToShardCommand")
    .sc(SubscribeToShard$)
    .build() {
}
