import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { TagResource$ } from "../schemas/schemas_0";
export { $Command };
export class TagResourceCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
    OperationType: { type: "staticContextParams", value: `control` },
    ResourceARN: { type: "contextParams", name: "ResourceARN" },
})
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Kinesis_20131202", "TagResource", {})
    .n("KinesisClient", "TagResourceCommand")
    .sc(TagResource$)
    .build() {
}
