import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { UpdateMaxRecordSize$ } from "../schemas/schemas_0";
export { $Command };
export class UpdateMaxRecordSizeCommand extends $Command
    .classBuilder()
    .ep({
    ...commonParams,
    OperationType: { type: "staticContextParams", value: `control` },
    StreamARN: { type: "contextParams", name: "StreamARN" },
})
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("Kinesis_20131202", "UpdateMaxRecordSize", {})
    .n("KinesisClient", "UpdateMaxRecordSizeCommand")
    .sc(UpdateMaxRecordSize$)
    .build() {
}
