/**
 * @public
 * @enum
 */
export declare const ConsumerStatus: {
    readonly ACTIVE: "ACTIVE";
    readonly CREATING: "CREATING";
    readonly DELETING: "DELETING";
};
/**
 * @public
 */
export type ConsumerStatus = (typeof ConsumerStatus)[keyof typeof ConsumerStatus];
/**
 * @public
 * @enum
 */
export declare const StreamMode: {
    readonly ON_DEMAND: "ON_DEMAND";
    readonly PROVISIONED: "PROVISIONED";
};
/**
 * @public
 */
export type StreamMode = (typeof StreamMode)[keyof typeof StreamMode];
/**
 * @public
 * @enum
 */
export declare const MinimumThroughputBillingCommitmentOutputStatus: {
    readonly DISABLED: "DISABLED";
    readonly ENABLED: "ENABLED";
    readonly ENABLED_UNTIL_EARLIEST_ALLOWED_END: "ENABLED_UNTIL_EARLIEST_ALLOWED_END";
};
/**
 * @public
 */
export type MinimumThroughputBillingCommitmentOutputStatus = (typeof MinimumThroughputBillingCommitmentOutputStatus)[keyof typeof MinimumThroughputBillingCommitmentOutputStatus];
/**
 * @public
 * @enum
 */
export declare const EncryptionType: {
    readonly KMS: "KMS";
    readonly NONE: "NONE";
};
/**
 * @public
 */
export type EncryptionType = (typeof EncryptionType)[keyof typeof EncryptionType];
/**
 * @public
 * @enum
 */
export declare const MetricsName: {
    readonly ALL: "ALL";
    readonly INCOMING_BYTES: "IncomingBytes";
    readonly INCOMING_RECORDS: "IncomingRecords";
    readonly ITERATOR_AGE_MILLISECONDS: "IteratorAgeMilliseconds";
    readonly OUTGOING_BYTES: "OutgoingBytes";
    readonly OUTGOING_RECORDS: "OutgoingRecords";
    readonly READ_PROVISIONED_THROUGHPUT_EXCEEDED: "ReadProvisionedThroughputExceeded";
    readonly WRITE_PROVISIONED_THROUGHPUT_EXCEEDED: "WriteProvisionedThroughputExceeded";
};
/**
 * @public
 */
export type MetricsName = (typeof MetricsName)[keyof typeof MetricsName];
/**
 * @public
 * @enum
 */
export declare const StreamStatus: {
    readonly ACTIVE: "ACTIVE";
    readonly CREATING: "CREATING";
    readonly DELETING: "DELETING";
    readonly UPDATING: "UPDATING";
};
/**
 * @public
 */
export type StreamStatus = (typeof StreamStatus)[keyof typeof StreamStatus];
/**
 * @public
 * @enum
 */
export declare const ShardIteratorType: {
    readonly AFTER_SEQUENCE_NUMBER: "AFTER_SEQUENCE_NUMBER";
    readonly AT_SEQUENCE_NUMBER: "AT_SEQUENCE_NUMBER";
    readonly AT_TIMESTAMP: "AT_TIMESTAMP";
    readonly LATEST: "LATEST";
    readonly TRIM_HORIZON: "TRIM_HORIZON";
};
/**
 * @public
 */
export type ShardIteratorType = (typeof ShardIteratorType)[keyof typeof ShardIteratorType];
/**
 * @public
 * @enum
 */
export declare const ShardFilterType: {
    readonly AFTER_SHARD_ID: "AFTER_SHARD_ID";
    readonly AT_LATEST: "AT_LATEST";
    readonly AT_TIMESTAMP: "AT_TIMESTAMP";
    readonly AT_TRIM_HORIZON: "AT_TRIM_HORIZON";
    readonly FROM_TIMESTAMP: "FROM_TIMESTAMP";
    readonly FROM_TRIM_HORIZON: "FROM_TRIM_HORIZON";
};
/**
 * @public
 */
export type ShardFilterType = (typeof ShardFilterType)[keyof typeof ShardFilterType];
/**
 * @public
 * @enum
 */
export declare const MinimumThroughputBillingCommitmentInputStatus: {
    readonly DISABLED: "DISABLED";
    readonly ENABLED: "ENABLED";
};
/**
 * @public
 */
export type MinimumThroughputBillingCommitmentInputStatus = (typeof MinimumThroughputBillingCommitmentInputStatus)[keyof typeof MinimumThroughputBillingCommitmentInputStatus];
/**
 * @public
 * @enum
 */
export declare const ScalingType: {
    readonly UNIFORM_SCALING: "UNIFORM_SCALING";
};
/**
 * @public
 */
export type ScalingType = (typeof ScalingType)[keyof typeof ScalingType];
