import type { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { KinesisServiceException as __BaseException } from "./KinesisServiceException";
/**
 * <p>Specifies that you do not have the permissions required to perform this
 *             operation.</p>
 * @public
 */
export declare class AccessDeniedException extends __BaseException {
    readonly name: "AccessDeniedException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<AccessDeniedException, __BaseException>);
}
/**
 * <p>A specified parameter exceeds its restrictions, is not supported, or can't be used.
 *             For more information, see the returned message.</p>
 * @public
 */
export declare class InvalidArgumentException extends __BaseException {
    readonly name: "InvalidArgumentException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidArgumentException, __BaseException>);
}
/**
 * <p>The requested resource exceeds the maximum number allowed, or the number of concurrent
 *             stream requests exceeds the maximum number allowed. </p>
 * @public
 */
export declare class LimitExceededException extends __BaseException {
    readonly name: "LimitExceededException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<LimitExceededException, __BaseException>);
}
/**
 * <p>The resource is not available for this operation. For successful operation, the
 *             resource must be in the <code>ACTIVE</code> state.</p>
 * @public
 */
export declare class ResourceInUseException extends __BaseException {
    readonly name: "ResourceInUseException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ResourceInUseException, __BaseException>);
}
/**
 * <p>The requested resource could not be found. The stream might not be specified
 *             correctly.</p>
 * @public
 */
export declare class ResourceNotFoundException extends __BaseException {
    readonly name: "ResourceNotFoundException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ResourceNotFoundException, __BaseException>);
}
/**
 * <p>Specifies that you tried to invoke this API for a data stream with the on-demand
 *             capacity mode. This API is only supported for data streams with the provisioned capacity
 *             mode. </p>
 * @public
 */
export declare class ValidationException extends __BaseException {
    readonly name: "ValidationException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ValidationException, __BaseException>);
}
/**
 * <p>The provided iterator exceeds the maximum age allowed.</p>
 * @public
 */
export declare class ExpiredIteratorException extends __BaseException {
    readonly name: "ExpiredIteratorException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ExpiredIteratorException, __BaseException>);
}
/**
 * <p>The pagination token passed to the operation is expired.</p>
 * @public
 */
export declare class ExpiredNextTokenException extends __BaseException {
    readonly name: "ExpiredNextTokenException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ExpiredNextTokenException, __BaseException>);
}
/**
 * <p>The processing of the request failed because of an unknown error, exception, or
 *             failure.</p>
 * @public
 */
export declare class InternalFailureException extends __BaseException {
    readonly name: "InternalFailureException";
    readonly $fault: "server";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InternalFailureException, __BaseException>);
}
/**
 * <p>The ciphertext references a key that doesn't exist or that you don't have access
 *             to.</p>
 * @public
 */
export declare class KMSAccessDeniedException extends __BaseException {
    readonly name: "KMSAccessDeniedException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<KMSAccessDeniedException, __BaseException>);
}
/**
 * <p>The request was rejected because the specified customer master key (CMK) isn't
 *             enabled.</p>
 * @public
 */
export declare class KMSDisabledException extends __BaseException {
    readonly name: "KMSDisabledException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<KMSDisabledException, __BaseException>);
}
/**
 * <p>The request was rejected because the state of the specified resource isn't valid for
 *             this request. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">How Key State Affects Use of a
 *                 Customer Master Key</a> in the <i>Amazon Web Services Key Management
 *                 Service Developer Guide</i>.</p>
 * @public
 */
export declare class KMSInvalidStateException extends __BaseException {
    readonly name: "KMSInvalidStateException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<KMSInvalidStateException, __BaseException>);
}
/**
 * <p>The request was rejected because the specified entity or resource can't be
 *             found.</p>
 * @public
 */
export declare class KMSNotFoundException extends __BaseException {
    readonly name: "KMSNotFoundException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<KMSNotFoundException, __BaseException>);
}
/**
 * <p>The Amazon Web Services access key ID needs a subscription for the service.</p>
 * @public
 */
export declare class KMSOptInRequired extends __BaseException {
    readonly name: "KMSOptInRequired";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<KMSOptInRequired, __BaseException>);
}
/**
 * <p>The request was denied due to request throttling. For more information about
 *             throttling, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a> in
 *             the <i>Amazon Web Services Key Management Service Developer
 *             Guide</i>.</p>
 * @public
 */
export declare class KMSThrottlingException extends __BaseException {
    readonly name: "KMSThrottlingException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<KMSThrottlingException, __BaseException>);
}
/**
 * <p>The request rate for the stream is too high, or the requested data is too large for
 *             the available throughput. Reduce the frequency or size of your requests. For more
 *             information, see <a href="https://docs.aws.amazon.com/kinesis/latest/dev/service-sizes-and-limits.html">Streams Limits</a> in the
 *                 <i>Amazon Kinesis Data Streams Developer Guide</i>, and <a href="https://docs.aws.amazon.com/general/latest/gr/api-retries.html">Error Retries and
 *                 Exponential Backoff in Amazon Web Services</a> in the <i>Amazon Web Services General Reference</i>.</p>
 * @public
 */
export declare class ProvisionedThroughputExceededException extends __BaseException {
    readonly name: "ProvisionedThroughputExceededException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ProvisionedThroughputExceededException, __BaseException>);
}
