import {
  ConsumerStatus,
  EncryptionType,
  MetricsName,
  MinimumThroughputBillingCommitmentInputStatus,
  MinimumThroughputBillingCommitmentOutputStatus,
  ScalingType,
  ShardFilterType,
  ShardIteratorType,
  StreamMode,
  StreamStatus,
} from "./enums";
import {
  InternalFailureException,
  KMSAccessDeniedException,
  KMSDisabledException,
  KMSInvalidStateException,
  KMSNotFoundException,
  KMSOptInRequired,
  KMSThrottlingException,
  ResourceInUseException,
  ResourceNotFoundException,
} from "./errors";
export interface AddTagsToStreamInput {
  StreamName?: string | undefined;
  Tags: Record<string, string> | undefined;
  StreamARN?: string | undefined;
}
export interface HashKeyRange {
  StartingHashKey: string | undefined;
  EndingHashKey: string | undefined;
}
export interface ChildShard {
  ShardId: string | undefined;
  ParentShards: string[] | undefined;
  HashKeyRange: HashKeyRange | undefined;
}
export interface Consumer {
  ConsumerName: string | undefined;
  ConsumerARN: string | undefined;
  ConsumerStatus: ConsumerStatus | undefined;
  ConsumerCreationTimestamp: Date | undefined;
}
export interface ConsumerDescription {
  ConsumerName: string | undefined;
  ConsumerARN: string | undefined;
  ConsumerStatus: ConsumerStatus | undefined;
  ConsumerCreationTimestamp: Date | undefined;
  StreamARN: string | undefined;
}
export interface StreamModeDetails {
  StreamMode: StreamMode | undefined;
}
export interface CreateStreamInput {
  StreamName: string | undefined;
  ShardCount?: number | undefined;
  StreamModeDetails?: StreamModeDetails | undefined;
  Tags?: Record<string, string> | undefined;
  WarmThroughputMiBps?: number | undefined;
  MaxRecordSizeInKiB?: number | undefined;
}
export interface DecreaseStreamRetentionPeriodInput {
  StreamName?: string | undefined;
  RetentionPeriodHours: number | undefined;
  StreamARN?: string | undefined;
}
export interface DeleteResourcePolicyInput {
  ResourceARN: string | undefined;
}
export interface DeleteStreamInput {
  StreamName?: string | undefined;
  EnforceConsumerDeletion?: boolean | undefined;
  StreamARN?: string | undefined;
}
export interface DeregisterStreamConsumerInput {
  StreamARN?: string | undefined;
  ConsumerName?: string | undefined;
  ConsumerARN?: string | undefined;
}
export interface DescribeAccountSettingsInput {}
export interface MinimumThroughputBillingCommitmentOutput {
  Status: MinimumThroughputBillingCommitmentOutputStatus | undefined;
  StartedAt?: Date | undefined;
  EndedAt?: Date | undefined;
  EarliestAllowedEndAt?: Date | undefined;
}
export interface DescribeAccountSettingsOutput {
  MinimumThroughputBillingCommitment?:
    | MinimumThroughputBillingCommitmentOutput
    | undefined;
}
export interface DescribeLimitsInput {}
export interface DescribeLimitsOutput {
  ShardLimit: number | undefined;
  OpenShardCount: number | undefined;
  OnDemandStreamCount: number | undefined;
  OnDemandStreamCountLimit: number | undefined;
}
export interface DescribeStreamInput {
  StreamName?: string | undefined;
  Limit?: number | undefined;
  ExclusiveStartShardId?: string | undefined;
  StreamARN?: string | undefined;
}
export interface EnhancedMetrics {
  ShardLevelMetrics?: MetricsName[] | undefined;
}
export interface SequenceNumberRange {
  StartingSequenceNumber: string | undefined;
  EndingSequenceNumber?: string | undefined;
}
export interface Shard {
  ShardId: string | undefined;
  ParentShardId?: string | undefined;
  AdjacentParentShardId?: string | undefined;
  HashKeyRange: HashKeyRange | undefined;
  SequenceNumberRange: SequenceNumberRange | undefined;
}
export interface StreamDescription {
  StreamName: string | undefined;
  StreamARN: string | undefined;
  StreamStatus: StreamStatus | undefined;
  StreamModeDetails?: StreamModeDetails | undefined;
  Shards: Shard[] | undefined;
  HasMoreShards: boolean | undefined;
  RetentionPeriodHours: number | undefined;
  StreamCreationTimestamp: Date | undefined;
  EnhancedMonitoring: EnhancedMetrics[] | undefined;
  EncryptionType?: EncryptionType | undefined;
  KeyId?: string | undefined;
}
export interface DescribeStreamOutput {
  StreamDescription: StreamDescription | undefined;
}
export interface DescribeStreamConsumerInput {
  StreamARN?: string | undefined;
  ConsumerName?: string | undefined;
  ConsumerARN?: string | undefined;
}
export interface DescribeStreamConsumerOutput {
  ConsumerDescription: ConsumerDescription | undefined;
}
export interface DescribeStreamSummaryInput {
  StreamName?: string | undefined;
  StreamARN?: string | undefined;
}
export interface WarmThroughputObject {
  TargetMiBps?: number | undefined;
  CurrentMiBps?: number | undefined;
}
export interface StreamDescriptionSummary {
  StreamName: string | undefined;
  StreamARN: string | undefined;
  StreamStatus: StreamStatus | undefined;
  StreamModeDetails?: StreamModeDetails | undefined;
  RetentionPeriodHours: number | undefined;
  StreamCreationTimestamp: Date | undefined;
  EnhancedMonitoring: EnhancedMetrics[] | undefined;
  EncryptionType?: EncryptionType | undefined;
  KeyId?: string | undefined;
  OpenShardCount: number | undefined;
  ConsumerCount?: number | undefined;
  WarmThroughput?: WarmThroughputObject | undefined;
  MaxRecordSizeInKiB?: number | undefined;
}
export interface DescribeStreamSummaryOutput {
  StreamDescriptionSummary: StreamDescriptionSummary | undefined;
}
export interface DisableEnhancedMonitoringInput {
  StreamName?: string | undefined;
  ShardLevelMetrics: MetricsName[] | undefined;
  StreamARN?: string | undefined;
}
export interface EnhancedMonitoringOutput {
  StreamName?: string | undefined;
  CurrentShardLevelMetrics?: MetricsName[] | undefined;
  DesiredShardLevelMetrics?: MetricsName[] | undefined;
  StreamARN?: string | undefined;
}
export interface EnableEnhancedMonitoringInput {
  StreamName?: string | undefined;
  ShardLevelMetrics: MetricsName[] | undefined;
  StreamARN?: string | undefined;
}
export interface GetRecordsInput {
  ShardIterator: string | undefined;
  Limit?: number | undefined;
  StreamARN?: string | undefined;
}
export interface _Record {
  SequenceNumber: string | undefined;
  ApproximateArrivalTimestamp?: Date | undefined;
  Data: Uint8Array | undefined;
  PartitionKey: string | undefined;
  EncryptionType?: EncryptionType | undefined;
}
export interface GetRecordsOutput {
  Records: _Record[] | undefined;
  NextShardIterator?: string | undefined;
  MillisBehindLatest?: number | undefined;
  ChildShards?: ChildShard[] | undefined;
}
export interface GetResourcePolicyInput {
  ResourceARN: string | undefined;
}
export interface GetResourcePolicyOutput {
  Policy: string | undefined;
}
export interface GetShardIteratorInput {
  StreamName?: string | undefined;
  ShardId: string | undefined;
  ShardIteratorType: ShardIteratorType | undefined;
  StartingSequenceNumber?: string | undefined;
  Timestamp?: Date | undefined;
  StreamARN?: string | undefined;
}
export interface GetShardIteratorOutput {
  ShardIterator?: string | undefined;
}
export interface IncreaseStreamRetentionPeriodInput {
  StreamName?: string | undefined;
  RetentionPeriodHours: number | undefined;
  StreamARN?: string | undefined;
}
export interface ShardFilter {
  Type: ShardFilterType | undefined;
  ShardId?: string | undefined;
  Timestamp?: Date | undefined;
}
export interface ListShardsInput {
  StreamName?: string | undefined;
  NextToken?: string | undefined;
  ExclusiveStartShardId?: string | undefined;
  MaxResults?: number | undefined;
  StreamCreationTimestamp?: Date | undefined;
  ShardFilter?: ShardFilter | undefined;
  StreamARN?: string | undefined;
}
export interface ListShardsOutput {
  Shards?: Shard[] | undefined;
  NextToken?: string | undefined;
}
export interface ListStreamConsumersInput {
  StreamARN: string | undefined;
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
  StreamCreationTimestamp?: Date | undefined;
}
export interface ListStreamConsumersOutput {
  Consumers?: Consumer[] | undefined;
  NextToken?: string | undefined;
}
export interface ListStreamsInput {
  Limit?: number | undefined;
  ExclusiveStartStreamName?: string | undefined;
  NextToken?: string | undefined;
}
export interface StreamSummary {
  StreamName: string | undefined;
  StreamARN: string | undefined;
  StreamStatus: StreamStatus | undefined;
  StreamModeDetails?: StreamModeDetails | undefined;
  StreamCreationTimestamp?: Date | undefined;
}
export interface ListStreamsOutput {
  StreamNames: string[] | undefined;
  HasMoreStreams: boolean | undefined;
  NextToken?: string | undefined;
  StreamSummaries?: StreamSummary[] | undefined;
}
export interface ListTagsForResourceInput {
  ResourceARN: string | undefined;
}
export interface Tag {
  Key: string | undefined;
  Value?: string | undefined;
}
export interface ListTagsForResourceOutput {
  Tags?: Tag[] | undefined;
}
export interface ListTagsForStreamInput {
  StreamName?: string | undefined;
  ExclusiveStartTagKey?: string | undefined;
  Limit?: number | undefined;
  StreamARN?: string | undefined;
}
export interface ListTagsForStreamOutput {
  Tags: Tag[] | undefined;
  HasMoreTags: boolean | undefined;
}
export interface MergeShardsInput {
  StreamName?: string | undefined;
  ShardToMerge: string | undefined;
  AdjacentShardToMerge: string | undefined;
  StreamARN?: string | undefined;
}
export interface PutRecordInput {
  StreamName?: string | undefined;
  Data: Uint8Array | undefined;
  PartitionKey: string | undefined;
  ExplicitHashKey?: string | undefined;
  SequenceNumberForOrdering?: string | undefined;
  StreamARN?: string | undefined;
}
export interface PutRecordOutput {
  ShardId: string | undefined;
  SequenceNumber: string | undefined;
  EncryptionType?: EncryptionType | undefined;
}
export interface PutRecordsRequestEntry {
  Data: Uint8Array | undefined;
  ExplicitHashKey?: string | undefined;
  PartitionKey: string | undefined;
}
export interface PutRecordsInput {
  Records: PutRecordsRequestEntry[] | undefined;
  StreamName?: string | undefined;
  StreamARN?: string | undefined;
}
export interface PutRecordsResultEntry {
  SequenceNumber?: string | undefined;
  ShardId?: string | undefined;
  ErrorCode?: string | undefined;
  ErrorMessage?: string | undefined;
}
export interface PutRecordsOutput {
  FailedRecordCount?: number | undefined;
  Records: PutRecordsResultEntry[] | undefined;
  EncryptionType?: EncryptionType | undefined;
}
export interface PutResourcePolicyInput {
  ResourceARN: string | undefined;
  Policy: string | undefined;
}
export interface RegisterStreamConsumerInput {
  StreamARN: string | undefined;
  ConsumerName: string | undefined;
  Tags?: Record<string, string> | undefined;
}
export interface RegisterStreamConsumerOutput {
  Consumer: Consumer | undefined;
}
export interface RemoveTagsFromStreamInput {
  StreamName?: string | undefined;
  TagKeys: string[] | undefined;
  StreamARN?: string | undefined;
}
export interface SplitShardInput {
  StreamName?: string | undefined;
  ShardToSplit: string | undefined;
  NewStartingHashKey: string | undefined;
  StreamARN?: string | undefined;
}
export interface StartStreamEncryptionInput {
  StreamName?: string | undefined;
  EncryptionType: EncryptionType | undefined;
  KeyId: string | undefined;
  StreamARN?: string | undefined;
}
export interface StopStreamEncryptionInput {
  StreamName?: string | undefined;
  EncryptionType: EncryptionType | undefined;
  KeyId: string | undefined;
  StreamARN?: string | undefined;
}
export interface StartingPosition {
  Type: ShardIteratorType | undefined;
  SequenceNumber?: string | undefined;
  Timestamp?: Date | undefined;
}
export interface SubscribeToShardInput {
  ConsumerARN: string | undefined;
  ShardId: string | undefined;
  StartingPosition: StartingPosition | undefined;
}
export interface SubscribeToShardEvent {
  Records: _Record[] | undefined;
  ContinuationSequenceNumber: string | undefined;
  MillisBehindLatest: number | undefined;
  ChildShards?: ChildShard[] | undefined;
}
export type SubscribeToShardEventStream =
  | SubscribeToShardEventStream.InternalFailureExceptionMember
  | SubscribeToShardEventStream.KMSAccessDeniedExceptionMember
  | SubscribeToShardEventStream.KMSDisabledExceptionMember
  | SubscribeToShardEventStream.KMSInvalidStateExceptionMember
  | SubscribeToShardEventStream.KMSNotFoundExceptionMember
  | SubscribeToShardEventStream.KMSOptInRequiredMember
  | SubscribeToShardEventStream.KMSThrottlingExceptionMember
  | SubscribeToShardEventStream.ResourceInUseExceptionMember
  | SubscribeToShardEventStream.ResourceNotFoundExceptionMember
  | SubscribeToShardEventStream.SubscribeToShardEventMember
  | SubscribeToShardEventStream.$UnknownMember;
export declare namespace SubscribeToShardEventStream {
  interface SubscribeToShardEventMember {
    SubscribeToShardEvent: SubscribeToShardEvent;
    ResourceNotFoundException?: never;
    ResourceInUseException?: never;
    KMSDisabledException?: never;
    KMSInvalidStateException?: never;
    KMSAccessDeniedException?: never;
    KMSNotFoundException?: never;
    KMSOptInRequired?: never;
    KMSThrottlingException?: never;
    InternalFailureException?: never;
    $unknown?: never;
  }
  interface ResourceNotFoundExceptionMember {
    SubscribeToShardEvent?: never;
    ResourceNotFoundException: ResourceNotFoundException;
    ResourceInUseException?: never;
    KMSDisabledException?: never;
    KMSInvalidStateException?: never;
    KMSAccessDeniedException?: never;
    KMSNotFoundException?: never;
    KMSOptInRequired?: never;
    KMSThrottlingException?: never;
    InternalFailureException?: never;
    $unknown?: never;
  }
  interface ResourceInUseExceptionMember {
    SubscribeToShardEvent?: never;
    ResourceNotFoundException?: never;
    ResourceInUseException: ResourceInUseException;
    KMSDisabledException?: never;
    KMSInvalidStateException?: never;
    KMSAccessDeniedException?: never;
    KMSNotFoundException?: never;
    KMSOptInRequired?: never;
    KMSThrottlingException?: never;
    InternalFailureException?: never;
    $unknown?: never;
  }
  interface KMSDisabledExceptionMember {
    SubscribeToShardEvent?: never;
    ResourceNotFoundException?: never;
    ResourceInUseException?: never;
    KMSDisabledException: KMSDisabledException;
    KMSInvalidStateException?: never;
    KMSAccessDeniedException?: never;
    KMSNotFoundException?: never;
    KMSOptInRequired?: never;
    KMSThrottlingException?: never;
    InternalFailureException?: never;
    $unknown?: never;
  }
  interface KMSInvalidStateExceptionMember {
    SubscribeToShardEvent?: never;
    ResourceNotFoundException?: never;
    ResourceInUseException?: never;
    KMSDisabledException?: never;
    KMSInvalidStateException: KMSInvalidStateException;
    KMSAccessDeniedException?: never;
    KMSNotFoundException?: never;
    KMSOptInRequired?: never;
    KMSThrottlingException?: never;
    InternalFailureException?: never;
    $unknown?: never;
  }
  interface KMSAccessDeniedExceptionMember {
    SubscribeToShardEvent?: never;
    ResourceNotFoundException?: never;
    ResourceInUseException?: never;
    KMSDisabledException?: never;
    KMSInvalidStateException?: never;
    KMSAccessDeniedException: KMSAccessDeniedException;
    KMSNotFoundException?: never;
    KMSOptInRequired?: never;
    KMSThrottlingException?: never;
    InternalFailureException?: never;
    $unknown?: never;
  }
  interface KMSNotFoundExceptionMember {
    SubscribeToShardEvent?: never;
    ResourceNotFoundException?: never;
    ResourceInUseException?: never;
    KMSDisabledException?: never;
    KMSInvalidStateException?: never;
    KMSAccessDeniedException?: never;
    KMSNotFoundException: KMSNotFoundException;
    KMSOptInRequired?: never;
    KMSThrottlingException?: never;
    InternalFailureException?: never;
    $unknown?: never;
  }
  interface KMSOptInRequiredMember {
    SubscribeToShardEvent?: never;
    ResourceNotFoundException?: never;
    ResourceInUseException?: never;
    KMSDisabledException?: never;
    KMSInvalidStateException?: never;
    KMSAccessDeniedException?: never;
    KMSNotFoundException?: never;
    KMSOptInRequired: KMSOptInRequired;
    KMSThrottlingException?: never;
    InternalFailureException?: never;
    $unknown?: never;
  }
  interface KMSThrottlingExceptionMember {
    SubscribeToShardEvent?: never;
    ResourceNotFoundException?: never;
    ResourceInUseException?: never;
    KMSDisabledException?: never;
    KMSInvalidStateException?: never;
    KMSAccessDeniedException?: never;
    KMSNotFoundException?: never;
    KMSOptInRequired?: never;
    KMSThrottlingException: KMSThrottlingException;
    InternalFailureException?: never;
    $unknown?: never;
  }
  interface InternalFailureExceptionMember {
    SubscribeToShardEvent?: never;
    ResourceNotFoundException?: never;
    ResourceInUseException?: never;
    KMSDisabledException?: never;
    KMSInvalidStateException?: never;
    KMSAccessDeniedException?: never;
    KMSNotFoundException?: never;
    KMSOptInRequired?: never;
    KMSThrottlingException?: never;
    InternalFailureException: InternalFailureException;
    $unknown?: never;
  }
  interface $UnknownMember {
    SubscribeToShardEvent?: never;
    ResourceNotFoundException?: never;
    ResourceInUseException?: never;
    KMSDisabledException?: never;
    KMSInvalidStateException?: never;
    KMSAccessDeniedException?: never;
    KMSNotFoundException?: never;
    KMSOptInRequired?: never;
    KMSThrottlingException?: never;
    InternalFailureException?: never;
    $unknown: [string, any];
  }
  interface Visitor<T> {
    SubscribeToShardEvent: (value: SubscribeToShardEvent) => T;
    ResourceNotFoundException: (value: ResourceNotFoundException) => T;
    ResourceInUseException: (value: ResourceInUseException) => T;
    KMSDisabledException: (value: KMSDisabledException) => T;
    KMSInvalidStateException: (value: KMSInvalidStateException) => T;
    KMSAccessDeniedException: (value: KMSAccessDeniedException) => T;
    KMSNotFoundException: (value: KMSNotFoundException) => T;
    KMSOptInRequired: (value: KMSOptInRequired) => T;
    KMSThrottlingException: (value: KMSThrottlingException) => T;
    InternalFailureException: (value: InternalFailureException) => T;
    _: (name: string, value: any) => T;
  }
}
export interface SubscribeToShardOutput {
  EventStream: AsyncIterable<SubscribeToShardEventStream> | undefined;
}
export interface TagResourceInput {
  Tags: Record<string, string> | undefined;
  ResourceARN: string | undefined;
}
export interface UntagResourceInput {
  TagKeys: string[] | undefined;
  ResourceARN: string | undefined;
}
export interface MinimumThroughputBillingCommitmentInput {
  Status: MinimumThroughputBillingCommitmentInputStatus | undefined;
}
export interface UpdateAccountSettingsInput {
  MinimumThroughputBillingCommitment:
    | MinimumThroughputBillingCommitmentInput
    | undefined;
}
export interface UpdateAccountSettingsOutput {
  MinimumThroughputBillingCommitment?:
    | MinimumThroughputBillingCommitmentOutput
    | undefined;
}
export interface UpdateMaxRecordSizeInput {
  StreamARN?: string | undefined;
  MaxRecordSizeInKiB: number | undefined;
}
export interface UpdateShardCountInput {
  StreamName?: string | undefined;
  TargetShardCount: number | undefined;
  ScalingType: ScalingType | undefined;
  StreamARN?: string | undefined;
}
export interface UpdateShardCountOutput {
  StreamName?: string | undefined;
  CurrentShardCount?: number | undefined;
  TargetShardCount?: number | undefined;
  StreamARN?: string | undefined;
}
export interface UpdateStreamModeInput {
  StreamARN: string | undefined;
  StreamModeDetails: StreamModeDetails | undefined;
  WarmThroughputMiBps?: number | undefined;
}
export interface UpdateStreamWarmThroughputInput {
  StreamARN?: string | undefined;
  StreamName?: string | undefined;
  WarmThroughputMiBps: number | undefined;
}
export interface UpdateStreamWarmThroughputOutput {
  StreamARN?: string | undefined;
  StreamName?: string | undefined;
  WarmThroughput?: WarmThroughputObject | undefined;
}
