import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { CreatePlatformEndpoint$ } from "../schemas/schemas_0";
export { $Command };
export class CreatePlatformEndpointCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonSimpleNotificationService", "CreatePlatformEndpoint", {})
    .n("SNSClient", "CreatePlatformEndpointCommand")
    .sc(CreatePlatformEndpoint$)
    .build() {
}
