import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { RemovePermission$ } from "../schemas/schemas_0";
export { $Command };
export class RemovePermissionCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonSimpleNotificationService", "RemovePermission", {})
    .n("SNSClient", "RemovePermissionCommand")
    .sc(RemovePermission$)
    .build() {
}
