import { getEndpointPlugin } from "@smithy/middleware-endpoint";
import { Command as $Command } from "@smithy/smithy-client";
import { commonParams } from "../endpoint/EndpointParameters";
import { Unsubscribe$ } from "../schemas/schemas_0";
export { $Command };
export class UnsubscribeCommand extends $Command
    .classBuilder()
    .ep(commonParams)
    .m(function (Command, cs, config, o) {
    return [getEndpointPlugin(config, Command.getEndpointParameterInstructions())];
})
    .s("AmazonSimpleNotificationService", "Unsubscribe", {})
    .n("SNSClient", "UnsubscribeCommand")
    .sc(Unsubscribe$)
    .build() {
}
