import { type HostHeaderInputConfig, type HostHeaderResolvedConfig } from "@aws-sdk/middleware-host-header";
import { type UserAgentInputConfig, type UserAgentResolvedConfig } from "@aws-sdk/middleware-user-agent";
import { type RegionInputConfig, type RegionResolvedConfig } from "@smithy/config-resolver";
import { type EndpointInputConfig, type EndpointResolvedConfig } from "@smithy/middleware-endpoint";
import { type RetryInputConfig, type RetryResolvedConfig } from "@smithy/middleware-retry";
import type { HttpHandlerUserInput as __HttpHandlerUserInput } from "@smithy/protocol-http";
import { type DefaultsMode as __DefaultsMode, type SmithyConfiguration as __SmithyConfiguration, type SmithyResolvedConfiguration as __SmithyResolvedConfiguration, Client as __Client } from "@smithy/smithy-client";
import { type BodyLengthCalculator as __BodyLengthCalculator, type CheckOptionalClientConfig as __CheckOptionalClientConfig, type ChecksumConstructor as __ChecksumConstructor, type Decoder as __Decoder, type Encoder as __Encoder, type HashConstructor as __HashConstructor, type HttpHandlerOptions as __HttpHandlerOptions, type Logger as __Logger, type Provider as __Provider, type StreamCollector as __StreamCollector, type UrlParser as __UrlParser, AwsCredentialIdentityProvider, Provider, UserAgent as __UserAgent } from "@smithy/types";
import { type HttpAuthSchemeInputConfig, type HttpAuthSchemeResolvedConfig } from "./auth/httpAuthSchemeProvider";
import { AddPermissionCommandInput, AddPermissionCommandOutput } from "./commands/AddPermissionCommand";
import { CheckIfPhoneNumberIsOptedOutCommandInput, CheckIfPhoneNumberIsOptedOutCommandOutput } from "./commands/CheckIfPhoneNumberIsOptedOutCommand";
import { ConfirmSubscriptionCommandInput, ConfirmSubscriptionCommandOutput } from "./commands/ConfirmSubscriptionCommand";
import { CreatePlatformApplicationCommandInput, CreatePlatformApplicationCommandOutput } from "./commands/CreatePlatformApplicationCommand";
import { CreatePlatformEndpointCommandInput, CreatePlatformEndpointCommandOutput } from "./commands/CreatePlatformEndpointCommand";
import { CreateSMSSandboxPhoneNumberCommandInput, CreateSMSSandboxPhoneNumberCommandOutput } from "./commands/CreateSMSSandboxPhoneNumberCommand";
import { CreateTopicCommandInput, CreateTopicCommandOutput } from "./commands/CreateTopicCommand";
import { DeleteEndpointCommandInput, DeleteEndpointCommandOutput } from "./commands/DeleteEndpointCommand";
import { DeletePlatformApplicationCommandInput, DeletePlatformApplicationCommandOutput } from "./commands/DeletePlatformApplicationCommand";
import { DeleteSMSSandboxPhoneNumberCommandInput, DeleteSMSSandboxPhoneNumberCommandOutput } from "./commands/DeleteSMSSandboxPhoneNumberCommand";
import { DeleteTopicCommandInput, DeleteTopicCommandOutput } from "./commands/DeleteTopicCommand";
import { GetDataProtectionPolicyCommandInput, GetDataProtectionPolicyCommandOutput } from "./commands/GetDataProtectionPolicyCommand";
import { GetEndpointAttributesCommandInput, GetEndpointAttributesCommandOutput } from "./commands/GetEndpointAttributesCommand";
import { GetPlatformApplicationAttributesCommandInput, GetPlatformApplicationAttributesCommandOutput } from "./commands/GetPlatformApplicationAttributesCommand";
import { GetSMSAttributesCommandInput, GetSMSAttributesCommandOutput } from "./commands/GetSMSAttributesCommand";
import { GetSMSSandboxAccountStatusCommandInput, GetSMSSandboxAccountStatusCommandOutput } from "./commands/GetSMSSandboxAccountStatusCommand";
import { GetSubscriptionAttributesCommandInput, GetSubscriptionAttributesCommandOutput } from "./commands/GetSubscriptionAttributesCommand";
import { GetTopicAttributesCommandInput, GetTopicAttributesCommandOutput } from "./commands/GetTopicAttributesCommand";
import { ListEndpointsByPlatformApplicationCommandInput, ListEndpointsByPlatformApplicationCommandOutput } from "./commands/ListEndpointsByPlatformApplicationCommand";
import { ListOriginationNumbersCommandInput, ListOriginationNumbersCommandOutput } from "./commands/ListOriginationNumbersCommand";
import { ListPhoneNumbersOptedOutCommandInput, ListPhoneNumbersOptedOutCommandOutput } from "./commands/ListPhoneNumbersOptedOutCommand";
import { ListPlatformApplicationsCommandInput, ListPlatformApplicationsCommandOutput } from "./commands/ListPlatformApplicationsCommand";
import { ListSMSSandboxPhoneNumbersCommandInput, ListSMSSandboxPhoneNumbersCommandOutput } from "./commands/ListSMSSandboxPhoneNumbersCommand";
import { ListSubscriptionsByTopicCommandInput, ListSubscriptionsByTopicCommandOutput } from "./commands/ListSubscriptionsByTopicCommand";
import { ListSubscriptionsCommandInput, ListSubscriptionsCommandOutput } from "./commands/ListSubscriptionsCommand";
import { ListTagsForResourceCommandInput, ListTagsForResourceCommandOutput } from "./commands/ListTagsForResourceCommand";
import { ListTopicsCommandInput, ListTopicsCommandOutput } from "./commands/ListTopicsCommand";
import { OptInPhoneNumberCommandInput, OptInPhoneNumberCommandOutput } from "./commands/OptInPhoneNumberCommand";
import { PublishBatchCommandInput, PublishBatchCommandOutput } from "./commands/PublishBatchCommand";
import { PublishCommandInput, PublishCommandOutput } from "./commands/PublishCommand";
import { PutDataProtectionPolicyCommandInput, PutDataProtectionPolicyCommandOutput } from "./commands/PutDataProtectionPolicyCommand";
import { RemovePermissionCommandInput, RemovePermissionCommandOutput } from "./commands/RemovePermissionCommand";
import { SetEndpointAttributesCommandInput, SetEndpointAttributesCommandOutput } from "./commands/SetEndpointAttributesCommand";
import { SetPlatformApplicationAttributesCommandInput, SetPlatformApplicationAttributesCommandOutput } from "./commands/SetPlatformApplicationAttributesCommand";
import { SetSMSAttributesCommandInput, SetSMSAttributesCommandOutput } from "./commands/SetSMSAttributesCommand";
import { SetSubscriptionAttributesCommandInput, SetSubscriptionAttributesCommandOutput } from "./commands/SetSubscriptionAttributesCommand";
import { SetTopicAttributesCommandInput, SetTopicAttributesCommandOutput } from "./commands/SetTopicAttributesCommand";
import { SubscribeCommandInput, SubscribeCommandOutput } from "./commands/SubscribeCommand";
import { TagResourceCommandInput, TagResourceCommandOutput } from "./commands/TagResourceCommand";
import { UnsubscribeCommandInput, UnsubscribeCommandOutput } from "./commands/UnsubscribeCommand";
import { UntagResourceCommandInput, UntagResourceCommandOutput } from "./commands/UntagResourceCommand";
import { VerifySMSSandboxPhoneNumberCommandInput, VerifySMSSandboxPhoneNumberCommandOutput } from "./commands/VerifySMSSandboxPhoneNumberCommand";
import { ClientInputEndpointParameters, ClientResolvedEndpointParameters, EndpointParameters } from "./endpoint/EndpointParameters";
import { type RuntimeExtension, type RuntimeExtensionsConfig } from "./runtimeExtensions";
export { __Client };
/**
 * @public
 */
export type ServiceInputTypes = AddPermissionCommandInput | CheckIfPhoneNumberIsOptedOutCommandInput | ConfirmSubscriptionCommandInput | CreatePlatformApplicationCommandInput | CreatePlatformEndpointCommandInput | CreateSMSSandboxPhoneNumberCommandInput | CreateTopicCommandInput | DeleteEndpointCommandInput | DeletePlatformApplicationCommandInput | DeleteSMSSandboxPhoneNumberCommandInput | DeleteTopicCommandInput | GetDataProtectionPolicyCommandInput | GetEndpointAttributesCommandInput | GetPlatformApplicationAttributesCommandInput | GetSMSAttributesCommandInput | GetSMSSandboxAccountStatusCommandInput | GetSubscriptionAttributesCommandInput | GetTopicAttributesCommandInput | ListEndpointsByPlatformApplicationCommandInput | ListOriginationNumbersCommandInput | ListPhoneNumbersOptedOutCommandInput | ListPlatformApplicationsCommandInput | ListSMSSandboxPhoneNumbersCommandInput | ListSubscriptionsByTopicCommandInput | ListSubscriptionsCommandInput | ListTagsForResourceCommandInput | ListTopicsCommandInput | OptInPhoneNumberCommandInput | PublishBatchCommandInput | PublishCommandInput | PutDataProtectionPolicyCommandInput | RemovePermissionCommandInput | SetEndpointAttributesCommandInput | SetPlatformApplicationAttributesCommandInput | SetSMSAttributesCommandInput | SetSubscriptionAttributesCommandInput | SetTopicAttributesCommandInput | SubscribeCommandInput | TagResourceCommandInput | UnsubscribeCommandInput | UntagResourceCommandInput | VerifySMSSandboxPhoneNumberCommandInput;
/**
 * @public
 */
export type ServiceOutputTypes = AddPermissionCommandOutput | CheckIfPhoneNumberIsOptedOutCommandOutput | ConfirmSubscriptionCommandOutput | CreatePlatformApplicationCommandOutput | CreatePlatformEndpointCommandOutput | CreateSMSSandboxPhoneNumberCommandOutput | CreateTopicCommandOutput | DeleteEndpointCommandOutput | DeletePlatformApplicationCommandOutput | DeleteSMSSandboxPhoneNumberCommandOutput | DeleteTopicCommandOutput | GetDataProtectionPolicyCommandOutput | GetEndpointAttributesCommandOutput | GetPlatformApplicationAttributesCommandOutput | GetSMSAttributesCommandOutput | GetSMSSandboxAccountStatusCommandOutput | GetSubscriptionAttributesCommandOutput | GetTopicAttributesCommandOutput | ListEndpointsByPlatformApplicationCommandOutput | ListOriginationNumbersCommandOutput | ListPhoneNumbersOptedOutCommandOutput | ListPlatformApplicationsCommandOutput | ListSMSSandboxPhoneNumbersCommandOutput | ListSubscriptionsByTopicCommandOutput | ListSubscriptionsCommandOutput | ListTagsForResourceCommandOutput | ListTopicsCommandOutput | OptInPhoneNumberCommandOutput | PublishBatchCommandOutput | PublishCommandOutput | PutDataProtectionPolicyCommandOutput | RemovePermissionCommandOutput | SetEndpointAttributesCommandOutput | SetPlatformApplicationAttributesCommandOutput | SetSMSAttributesCommandOutput | SetSubscriptionAttributesCommandOutput | SetTopicAttributesCommandOutput | SubscribeCommandOutput | TagResourceCommandOutput | UnsubscribeCommandOutput | UntagResourceCommandOutput | VerifySMSSandboxPhoneNumberCommandOutput;
/**
 * @public
 */
export interface ClientDefaults extends Partial<__SmithyConfiguration<__HttpHandlerOptions>> {
    /**
     * The HTTP handler to use or its constructor options. Fetch in browser and Https in Nodejs.
     */
    requestHandler?: __HttpHandlerUserInput;
    /**
     * A constructor for a class implementing the {@link @smithy/types#ChecksumConstructor} interface
     * that computes the SHA-256 HMAC or checksum of a string or binary buffer.
     * @internal
     */
    sha256?: __ChecksumConstructor | __HashConstructor;
    /**
     * The function that will be used to convert strings into HTTP endpoints.
     * @internal
     */
    urlParser?: __UrlParser;
    /**
     * A function that can calculate the length of a request body.
     * @internal
     */
    bodyLengthChecker?: __BodyLengthCalculator;
    /**
     * A function that converts a stream into an array of bytes.
     * @internal
     */
    streamCollector?: __StreamCollector;
    /**
     * The function that will be used to convert a base64-encoded string to a byte array.
     * @internal
     */
    base64Decoder?: __Decoder;
    /**
     * The function that will be used to convert binary data to a base64-encoded string.
     * @internal
     */
    base64Encoder?: __Encoder;
    /**
     * The function that will be used to convert a UTF8-encoded string to a byte array.
     * @internal
     */
    utf8Decoder?: __Decoder;
    /**
     * The function that will be used to convert binary data to a UTF-8 encoded string.
     * @internal
     */
    utf8Encoder?: __Encoder;
    /**
     * The runtime environment.
     * @internal
     */
    runtime?: string;
    /**
     * Disable dynamically changing the endpoint of the client based on the hostPrefix
     * trait of an operation.
     */
    disableHostPrefix?: boolean;
    /**
     * Unique service identifier.
     * @internal
     */
    serviceId?: string;
    /**
     * Enables IPv6/IPv4 dualstack endpoint.
     */
    useDualstackEndpoint?: boolean | __Provider<boolean>;
    /**
     * Enables FIPS compatible endpoints.
     */
    useFipsEndpoint?: boolean | __Provider<boolean>;
    /**
     * The AWS region to which this client will send requests
     */
    region?: string | __Provider<string>;
    /**
     * Setting a client profile is similar to setting a value for the
     * AWS_PROFILE environment variable. Setting a profile on a client
     * in code only affects the single client instance, unlike AWS_PROFILE.
     *
     * When set, and only for environments where an AWS configuration
     * file exists, fields configurable by this file will be retrieved
     * from the specified profile within that file.
     * Conflicting code configuration and environment variables will
     * still have higher priority.
     *
     * For client credential resolution that involves checking the AWS
     * configuration file, the client's profile (this value) will be
     * used unless a different profile is set in the credential
     * provider options.
     *
     */
    profile?: string;
    /**
     * The provider populating default tracking information to be sent with `user-agent`, `x-amz-user-agent` header
     * @internal
     */
    defaultUserAgentProvider?: Provider<__UserAgent>;
    /**
     * Default credentials provider; Not available in browser runtime.
     * @deprecated
     * @internal
     */
    credentialDefaultProvider?: (input: any) => AwsCredentialIdentityProvider;
    /**
     * Value for how many times a request will be made at most in case of retry.
     */
    maxAttempts?: number | __Provider<number>;
    /**
     * Specifies which retry algorithm to use.
     * @see https://docs.aws.amazon.com/AWSJavaScriptSDK/v3/latest/Package/-smithy-util-retry/Enum/RETRY_MODES/
     *
     */
    retryMode?: string | __Provider<string>;
    /**
     * Optional logger for logging debug/info/warn/error.
     */
    logger?: __Logger;
    /**
     * Optional extensions
     */
    extensions?: RuntimeExtension[];
    /**
     * The {@link @smithy/smithy-client#DefaultsMode} that will be used to determine how certain default configuration options are resolved in the SDK.
     */
    defaultsMode?: __DefaultsMode | __Provider<__DefaultsMode>;
}
/**
 * @public
 */
export type SNSClientConfigType = Partial<__SmithyConfiguration<__HttpHandlerOptions>> & ClientDefaults & UserAgentInputConfig & RetryInputConfig & RegionInputConfig & HostHeaderInputConfig & EndpointInputConfig<EndpointParameters> & HttpAuthSchemeInputConfig & ClientInputEndpointParameters;
/**
 * @public
 *
 *  The configuration interface of SNSClient class constructor that set the region, credentials and other options.
 */
export interface SNSClientConfig extends SNSClientConfigType {
}
/**
 * @public
 */
export type SNSClientResolvedConfigType = __SmithyResolvedConfiguration<__HttpHandlerOptions> & Required<ClientDefaults> & RuntimeExtensionsConfig & UserAgentResolvedConfig & RetryResolvedConfig & RegionResolvedConfig & HostHeaderResolvedConfig & EndpointResolvedConfig<EndpointParameters> & HttpAuthSchemeResolvedConfig & ClientResolvedEndpointParameters;
/**
 * @public
 *
 *  The resolved configuration interface of SNSClient class. This is resolved and normalized from the {@link SNSClientConfig | constructor configuration interface}.
 */
export interface SNSClientResolvedConfig extends SNSClientResolvedConfigType {
}
/**
 * <fullname>Amazon Simple Notification Service</fullname>
 *          <p>Amazon Simple Notification Service (Amazon SNS) is a web service that enables you
 *             to build distributed web-enabled applications. Applications can use Amazon SNS to easily push
 *             real-time notification messages to interested subscribers over multiple delivery
 *             protocols. For more information about this product see the <a href="http://aws.amazon.com/sns/">Amazon SNS product page</a>. For detailed information about Amazon SNS features
 *             and their associated API calls, see the <a href="https://docs.aws.amazon.com/sns/latest/dg/">Amazon SNS Developer Guide</a>. </p>
 *          <p>For information on the permissions you need to use this API, see <a href="https://docs.aws.amazon.com/sns/latest/dg/sns-authentication-and-access-control.html">Identity and access management in Amazon SNS</a> in the <i>Amazon SNS Developer
 *                 Guide.</i>
 *          </p>
 *          <p>We also provide SDKs that enable you to access Amazon SNS from your preferred programming
 *             language. The SDKs contain functionality that automatically takes care of tasks such as:
 *             cryptographically signing your service requests, retrying requests, and handling error
 *             responses. For a list of available SDKs, go to <a href="http://aws.amazon.com/tools/">Tools for Amazon Web Services</a>. </p>
 * @public
 */
export declare class SNSClient extends __Client<__HttpHandlerOptions, ServiceInputTypes, ServiceOutputTypes, SNSClientResolvedConfig> {
    /**
     * The resolved configuration of SNSClient class. This is resolved and normalized from the {@link SNSClientConfig | constructor configuration interface}.
     */
    readonly config: SNSClientResolvedConfig;
    constructor(...[configuration]: __CheckOptionalClientConfig<SNSClientConfig>);
    /**
     * Destroy underlying resources, like sockets. It's usually not necessary to do this.
     * However in Node.js, it's best to explicitly shut down the client's agent when it is no longer needed.
     * Otherwise, sockets might stay open for quite a long time before the server terminates them.
     */
    destroy(): void;
}
