import type { ExceptionOptionType as __ExceptionOptionType } from "@smithy/smithy-client";
import { SNSServiceException as __BaseException } from "./SNSServiceException";
/**
 * <p>Indicates that the user has been denied access to the requested resource.</p>
 * @public
 */
export declare class AuthorizationErrorException extends __BaseException {
    readonly name: "AuthorizationErrorException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<AuthorizationErrorException, __BaseException>);
}
/**
 * <p>Indicates an internal service error.</p>
 * @public
 */
export declare class InternalErrorException extends __BaseException {
    readonly name: "InternalErrorException";
    readonly $fault: "server";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InternalErrorException, __BaseException>);
}
/**
 * <p>Indicates that a request parameter does not comply with the associated
 *             constraints.</p>
 * @public
 */
export declare class InvalidParameterException extends __BaseException {
    readonly name: "InvalidParameterException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidParameterException, __BaseException>);
}
/**
 * <p>Indicates that the requested resource does not exist.</p>
 * @public
 */
export declare class NotFoundException extends __BaseException {
    readonly name: "NotFoundException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<NotFoundException, __BaseException>);
}
/**
 * <p>Indicates that the rate at which requests have been submitted for this action exceeds the limit for your Amazon Web Services account.</p>
 * @public
 */
export declare class ThrottledException extends __BaseException {
    readonly name: "ThrottledException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ThrottledException, __BaseException>);
}
/**
 * <p>Indicates that the number of filter polices in your Amazon Web Services account exceeds the limit. To
 *             add more filter polices, submit an Amazon SNS Limit Increase case in the Amazon Web ServicesSupport
 *             Center.</p>
 * @public
 */
export declare class FilterPolicyLimitExceededException extends __BaseException {
    readonly name: "FilterPolicyLimitExceededException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<FilterPolicyLimitExceededException, __BaseException>);
}
/**
 * <p>Indicates that the request parameter has exceeded the maximum number of concurrent message replays.</p>
 * @public
 */
export declare class ReplayLimitExceededException extends __BaseException {
    readonly name: "ReplayLimitExceededException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ReplayLimitExceededException, __BaseException>);
}
/**
 * <p>Indicates that the customer already owns the maximum allowed number of
 *             subscriptions.</p>
 * @public
 */
export declare class SubscriptionLimitExceededException extends __BaseException {
    readonly name: "SubscriptionLimitExceededException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<SubscriptionLimitExceededException, __BaseException>);
}
/**
 * <p>Indicates that the specified phone number opted out of receiving SMS messages from
 *             your Amazon Web Services account. You can't send SMS messages to phone numbers that opt out.</p>
 * @public
 */
export declare class OptedOutException extends __BaseException {
    readonly name: "OptedOutException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<OptedOutException, __BaseException>);
}
/**
 * <p>Indicates that a request parameter does not comply with the associated
 *             constraints.</p>
 * @public
 */
export declare class UserErrorException extends __BaseException {
    readonly name: "UserErrorException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<UserErrorException, __BaseException>);
}
/**
 * <p>Can't perform multiple operations on a tag simultaneously. Perform the operations
 *             sequentially.</p>
 * @public
 */
export declare class ConcurrentAccessException extends __BaseException {
    readonly name: "ConcurrentAccessException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ConcurrentAccessException, __BaseException>);
}
/**
 * <p>The credential signature isn't valid. You must use an HTTPS endpoint and sign your
 *             request using Signature Version 4.</p>
 * @public
 */
export declare class InvalidSecurityException extends __BaseException {
    readonly name: "InvalidSecurityException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidSecurityException, __BaseException>);
}
/**
 * <p>A tag has been added to a resource with the same ARN as a deleted resource. Wait a
 *             short while and then retry the operation.</p>
 * @public
 */
export declare class StaleTagException extends __BaseException {
    readonly name: "StaleTagException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<StaleTagException, __BaseException>);
}
/**
 * <p>Can't add more than 50 tags to a topic.</p>
 * @public
 */
export declare class TagLimitExceededException extends __BaseException {
    readonly name: "TagLimitExceededException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TagLimitExceededException, __BaseException>);
}
/**
 * <p>The request doesn't comply with the IAM tag policy. Correct your request and then
 *             retry it.</p>
 * @public
 */
export declare class TagPolicyException extends __BaseException {
    readonly name: "TagPolicyException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TagPolicyException, __BaseException>);
}
/**
 * <p>Indicates that the customer already owns the maximum allowed number of topics.</p>
 * @public
 */
export declare class TopicLimitExceededException extends __BaseException {
    readonly name: "TopicLimitExceededException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TopicLimitExceededException, __BaseException>);
}
/**
 * <p>Can’t perform the action on the specified resource. Make sure that the resource
 *             exists.</p>
 * @public
 */
export declare class ResourceNotFoundException extends __BaseException {
    readonly name: "ResourceNotFoundException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ResourceNotFoundException, __BaseException>);
}
/**
 * <p>Indicates that the specified state is not a valid state for an event source.</p>
 * @public
 */
export declare class InvalidStateException extends __BaseException {
    readonly name: "InvalidStateException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidStateException, __BaseException>);
}
/**
 * <p>Indicates that a parameter in the request is invalid.</p>
 * @public
 */
export declare class ValidationException extends __BaseException {
    readonly name: "ValidationException";
    readonly $fault: "client";
    Message: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<ValidationException, __BaseException>);
}
/**
 * <p>Exception error indicating endpoint disabled.</p>
 * @public
 */
export declare class EndpointDisabledException extends __BaseException {
    readonly name: "EndpointDisabledException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<EndpointDisabledException, __BaseException>);
}
/**
 * <p>Indicates that a request parameter does not comply with the associated constraints.</p>
 * @public
 */
export declare class InvalidParameterValueException extends __BaseException {
    readonly name: "InvalidParameterValueException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidParameterValueException, __BaseException>);
}
/**
 * <p>The ciphertext references a key that doesn't exist or that you don't have access
 *             to.</p>
 * @public
 */
export declare class KMSAccessDeniedException extends __BaseException {
    readonly name: "KMSAccessDeniedException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<KMSAccessDeniedException, __BaseException>);
}
/**
 * <p>The request was rejected because the specified Amazon Web Services KMS key isn't
 *             enabled.</p>
 * @public
 */
export declare class KMSDisabledException extends __BaseException {
    readonly name: "KMSDisabledException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<KMSDisabledException, __BaseException>);
}
/**
 * <p>The request was rejected because the state of the specified resource isn't valid for
 *             this request. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html">Key states of Amazon Web Services KMS keys</a> in the <i>Key Management Service Developer
 *                 Guide</i>.</p>
 * @public
 */
export declare class KMSInvalidStateException extends __BaseException {
    readonly name: "KMSInvalidStateException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<KMSInvalidStateException, __BaseException>);
}
/**
 * <p>The request was rejected because the specified entity or resource can't be
 *             found.</p>
 * @public
 */
export declare class KMSNotFoundException extends __BaseException {
    readonly name: "KMSNotFoundException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<KMSNotFoundException, __BaseException>);
}
/**
 * <p>The Amazon Web Services access key ID needs a subscription for the service.</p>
 * @public
 */
export declare class KMSOptInRequired extends __BaseException {
    readonly name: "KMSOptInRequired";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<KMSOptInRequired, __BaseException>);
}
/**
 * <p>The request was denied due to request throttling. For more information about
 *             throttling, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/limits.html#requests-per-second">Limits</a> in
 *             the <i>Key Management Service Developer Guide.</i>
 *          </p>
 * @public
 */
export declare class KMSThrottlingException extends __BaseException {
    readonly name: "KMSThrottlingException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<KMSThrottlingException, __BaseException>);
}
/**
 * <p>Exception error indicating platform application disabled.</p>
 * @public
 */
export declare class PlatformApplicationDisabledException extends __BaseException {
    readonly name: "PlatformApplicationDisabledException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<PlatformApplicationDisabledException, __BaseException>);
}
/**
 * <p>Two or more batch entries in the request have the same <code>Id</code>.</p>
 * @public
 */
export declare class BatchEntryIdsNotDistinctException extends __BaseException {
    readonly name: "BatchEntryIdsNotDistinctException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<BatchEntryIdsNotDistinctException, __BaseException>);
}
/**
 * <p>The length of all the batch messages put together is more than the limit.</p>
 * @public
 */
export declare class BatchRequestTooLongException extends __BaseException {
    readonly name: "BatchRequestTooLongException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<BatchRequestTooLongException, __BaseException>);
}
/**
 * <p>The batch request doesn't contain any entries.</p>
 * @public
 */
export declare class EmptyBatchRequestException extends __BaseException {
    readonly name: "EmptyBatchRequestException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<EmptyBatchRequestException, __BaseException>);
}
/**
 * <p>The <code>Id</code> of a batch entry in a batch request doesn't abide by the specification. </p>
 * @public
 */
export declare class InvalidBatchEntryIdException extends __BaseException {
    readonly name: "InvalidBatchEntryIdException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<InvalidBatchEntryIdException, __BaseException>);
}
/**
 * <p> The batch request contains more entries than permissible (more than 10).</p>
 * @public
 */
export declare class TooManyEntriesInBatchRequestException extends __BaseException {
    readonly name: "TooManyEntriesInBatchRequestException";
    readonly $fault: "client";
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<TooManyEntriesInBatchRequestException, __BaseException>);
}
/**
 * <p>Indicates that the one-time password (OTP) used for verification is invalid.</p>
 * @public
 */
export declare class VerificationException extends __BaseException {
    readonly name: "VerificationException";
    readonly $fault: "client";
    Message: string | undefined;
    /**
     * <p>The status of the verification error.</p>
     * @public
     */
    Status: string | undefined;
    /**
     * @internal
     */
    constructor(opts: __ExceptionOptionType<VerificationException, __BaseException>);
}
