import {
  LanguageCodeString,
  NumberCapability,
  RouteType,
  SMSSandboxPhoneNumberVerificationStatus,
} from "./enums";
export interface AddPermissionInput {
  TopicArn: string | undefined;
  Label: string | undefined;
  AWSAccountId: string[] | undefined;
  ActionName: string[] | undefined;
}
export interface CheckIfPhoneNumberIsOptedOutInput {
  phoneNumber: string | undefined;
}
export interface CheckIfPhoneNumberIsOptedOutResponse {
  isOptedOut?: boolean | undefined;
}
export interface ConfirmSubscriptionInput {
  TopicArn: string | undefined;
  Token: string | undefined;
  AuthenticateOnUnsubscribe?: string | undefined;
}
export interface ConfirmSubscriptionResponse {
  SubscriptionArn?: string | undefined;
}
export interface CreatePlatformApplicationInput {
  Name: string | undefined;
  Platform: string | undefined;
  Attributes: Record<string, string> | undefined;
}
export interface CreatePlatformApplicationResponse {
  PlatformApplicationArn?: string | undefined;
}
export interface CreateEndpointResponse {
  EndpointArn?: string | undefined;
}
export interface CreatePlatformEndpointInput {
  PlatformApplicationArn: string | undefined;
  Token: string | undefined;
  CustomUserData?: string | undefined;
  Attributes?: Record<string, string> | undefined;
}
export interface CreateSMSSandboxPhoneNumberInput {
  PhoneNumber: string | undefined;
  LanguageCode?: LanguageCodeString | undefined;
}
export interface CreateSMSSandboxPhoneNumberResult {}
export interface Tag {
  Key: string | undefined;
  Value: string | undefined;
}
export interface CreateTopicInput {
  Name: string | undefined;
  Attributes?: Record<string, string> | undefined;
  Tags?: Tag[] | undefined;
  DataProtectionPolicy?: string | undefined;
}
export interface CreateTopicResponse {
  TopicArn?: string | undefined;
}
export interface DeleteEndpointInput {
  EndpointArn: string | undefined;
}
export interface DeletePlatformApplicationInput {
  PlatformApplicationArn: string | undefined;
}
export interface DeleteSMSSandboxPhoneNumberInput {
  PhoneNumber: string | undefined;
}
export interface DeleteSMSSandboxPhoneNumberResult {}
export interface DeleteTopicInput {
  TopicArn: string | undefined;
}
export interface GetDataProtectionPolicyInput {
  ResourceArn: string | undefined;
}
export interface GetDataProtectionPolicyResponse {
  DataProtectionPolicy?: string | undefined;
}
export interface GetEndpointAttributesInput {
  EndpointArn: string | undefined;
}
export interface GetEndpointAttributesResponse {
  Attributes?: Record<string, string> | undefined;
}
export interface GetPlatformApplicationAttributesInput {
  PlatformApplicationArn: string | undefined;
}
export interface GetPlatformApplicationAttributesResponse {
  Attributes?: Record<string, string> | undefined;
}
export interface GetSMSAttributesInput {
  attributes?: string[] | undefined;
}
export interface GetSMSAttributesResponse {
  attributes?: Record<string, string> | undefined;
}
export interface GetSMSSandboxAccountStatusInput {}
export interface GetSMSSandboxAccountStatusResult {
  IsInSandbox: boolean | undefined;
}
export interface GetSubscriptionAttributesInput {
  SubscriptionArn: string | undefined;
}
export interface GetSubscriptionAttributesResponse {
  Attributes?: Record<string, string> | undefined;
}
export interface GetTopicAttributesInput {
  TopicArn: string | undefined;
}
export interface GetTopicAttributesResponse {
  Attributes?: Record<string, string> | undefined;
}
export interface ListEndpointsByPlatformApplicationInput {
  PlatformApplicationArn: string | undefined;
  NextToken?: string | undefined;
}
export interface Endpoint {
  EndpointArn?: string | undefined;
  Attributes?: Record<string, string> | undefined;
}
export interface ListEndpointsByPlatformApplicationResponse {
  Endpoints?: Endpoint[] | undefined;
  NextToken?: string | undefined;
}
export interface ListOriginationNumbersRequest {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface PhoneNumberInformation {
  CreatedAt?: Date | undefined;
  PhoneNumber?: string | undefined;
  Status?: string | undefined;
  Iso2CountryCode?: string | undefined;
  RouteType?: RouteType | undefined;
  NumberCapabilities?: NumberCapability[] | undefined;
}
export interface ListOriginationNumbersResult {
  NextToken?: string | undefined;
  PhoneNumbers?: PhoneNumberInformation[] | undefined;
}
export interface ListPhoneNumbersOptedOutInput {
  nextToken?: string | undefined;
}
export interface ListPhoneNumbersOptedOutResponse {
  phoneNumbers?: string[] | undefined;
  nextToken?: string | undefined;
}
export interface ListPlatformApplicationsInput {
  NextToken?: string | undefined;
}
export interface PlatformApplication {
  PlatformApplicationArn?: string | undefined;
  Attributes?: Record<string, string> | undefined;
}
export interface ListPlatformApplicationsResponse {
  PlatformApplications?: PlatformApplication[] | undefined;
  NextToken?: string | undefined;
}
export interface ListSMSSandboxPhoneNumbersInput {
  NextToken?: string | undefined;
  MaxResults?: number | undefined;
}
export interface SMSSandboxPhoneNumber {
  PhoneNumber?: string | undefined;
  Status?: SMSSandboxPhoneNumberVerificationStatus | undefined;
}
export interface ListSMSSandboxPhoneNumbersResult {
  PhoneNumbers: SMSSandboxPhoneNumber[] | undefined;
  NextToken?: string | undefined;
}
export interface ListSubscriptionsInput {
  NextToken?: string | undefined;
}
export interface Subscription {
  SubscriptionArn?: string | undefined;
  Owner?: string | undefined;
  Protocol?: string | undefined;
  Endpoint?: string | undefined;
  TopicArn?: string | undefined;
}
export interface ListSubscriptionsResponse {
  Subscriptions?: Subscription[] | undefined;
  NextToken?: string | undefined;
}
export interface ListSubscriptionsByTopicInput {
  TopicArn: string | undefined;
  NextToken?: string | undefined;
}
export interface ListSubscriptionsByTopicResponse {
  Subscriptions?: Subscription[] | undefined;
  NextToken?: string | undefined;
}
export interface ListTagsForResourceRequest {
  ResourceArn: string | undefined;
}
export interface ListTagsForResourceResponse {
  Tags?: Tag[] | undefined;
}
export interface ListTopicsInput {
  NextToken?: string | undefined;
}
export interface Topic {
  TopicArn?: string | undefined;
}
export interface ListTopicsResponse {
  Topics?: Topic[] | undefined;
  NextToken?: string | undefined;
}
export interface OptInPhoneNumberInput {
  phoneNumber: string | undefined;
}
export interface OptInPhoneNumberResponse {}
export interface MessageAttributeValue {
  DataType: string | undefined;
  StringValue?: string | undefined;
  BinaryValue?: Uint8Array | undefined;
}
export interface PublishInput {
  TopicArn?: string | undefined;
  TargetArn?: string | undefined;
  PhoneNumber?: string | undefined;
  Message: string | undefined;
  Subject?: string | undefined;
  MessageStructure?: string | undefined;
  MessageAttributes?: Record<string, MessageAttributeValue> | undefined;
  MessageDeduplicationId?: string | undefined;
  MessageGroupId?: string | undefined;
}
export interface PublishResponse {
  MessageId?: string | undefined;
  SequenceNumber?: string | undefined;
}
export interface PublishBatchRequestEntry {
  Id: string | undefined;
  Message: string | undefined;
  Subject?: string | undefined;
  MessageStructure?: string | undefined;
  MessageAttributes?: Record<string, MessageAttributeValue> | undefined;
  MessageDeduplicationId?: string | undefined;
  MessageGroupId?: string | undefined;
}
export interface PublishBatchInput {
  TopicArn: string | undefined;
  PublishBatchRequestEntries: PublishBatchRequestEntry[] | undefined;
}
export interface BatchResultErrorEntry {
  Id: string | undefined;
  Code: string | undefined;
  Message?: string | undefined;
  SenderFault: boolean | undefined;
}
export interface PublishBatchResultEntry {
  Id?: string | undefined;
  MessageId?: string | undefined;
  SequenceNumber?: string | undefined;
}
export interface PublishBatchResponse {
  Successful?: PublishBatchResultEntry[] | undefined;
  Failed?: BatchResultErrorEntry[] | undefined;
}
export interface PutDataProtectionPolicyInput {
  ResourceArn: string | undefined;
  DataProtectionPolicy: string | undefined;
}
export interface RemovePermissionInput {
  TopicArn: string | undefined;
  Label: string | undefined;
}
export interface SetEndpointAttributesInput {
  EndpointArn: string | undefined;
  Attributes: Record<string, string> | undefined;
}
export interface SetPlatformApplicationAttributesInput {
  PlatformApplicationArn: string | undefined;
  Attributes: Record<string, string> | undefined;
}
export interface SetSMSAttributesInput {
  attributes: Record<string, string> | undefined;
}
export interface SetSMSAttributesResponse {}
export interface SetSubscriptionAttributesInput {
  SubscriptionArn: string | undefined;
  AttributeName: string | undefined;
  AttributeValue?: string | undefined;
}
export interface SetTopicAttributesInput {
  TopicArn: string | undefined;
  AttributeName: string | undefined;
  AttributeValue?: string | undefined;
}
export interface SubscribeInput {
  TopicArn: string | undefined;
  Protocol: string | undefined;
  Endpoint?: string | undefined;
  Attributes?: Record<string, string> | undefined;
  ReturnSubscriptionArn?: boolean | undefined;
}
export interface SubscribeResponse {
  SubscriptionArn?: string | undefined;
}
export interface TagResourceRequest {
  ResourceArn: string | undefined;
  Tags: Tag[] | undefined;
}
export interface TagResourceResponse {}
export interface UnsubscribeInput {
  SubscriptionArn: string | undefined;
}
export interface UntagResourceRequest {
  ResourceArn: string | undefined;
  TagKeys: string[] | undefined;
}
export interface UntagResourceResponse {}
export interface VerifySMSSandboxPhoneNumberInput {
  PhoneNumber: string | undefined;
  OneTimePassword: string | undefined;
}
export interface VerifySMSSandboxPhoneNumberResult {}
