import { MetadataServiceOptions } from "./MetadataServiceOptions";
/**
 * @public
 */
export declare class MetadataService {
    private disableFetchToken;
    private config;
    private retries;
    private backoffFn;
    private tokenTtl;
    private port?;
    /**
     * Creates a new MetadataService object with a given set of options.
     */
    constructor(options?: MetadataServiceOptions);
    private validateTokenTtl;
    private resolvePort;
    private createBackoffFunction;
    private sleep;
    private retryWithBackoff;
    private shouldNotRetry;
    request(path: string, options: {
        method?: string;
        headers?: Record<string, string>;
    }): Promise<string>;
    fetchMetadataToken(): Promise<string>;
    private fetchMetadataTokenInternal;
}
