import type { BaseResultSet, DataFormat, JSONHandling, ResponseHeaders, ResultJSONType, ResultStream, Row } from '@clickhouse/client-common';
import type { Readable } from 'stream';
import Stream from 'stream';
/** {@link Stream.Readable} with additional types for the `on(data)` method and the async iterator.
 * Everything else is an exact copy from stream.d.ts */
export type StreamReadable<T> = Omit<Stream.Readable, 'on'> & {
    [Symbol.asyncIterator](): NodeJS.AsyncIterator<T>;
    on(event: 'data', listener: (chunk: T) => void): Stream.Readable;
    on(event: 'close' | 'drain' | 'end' | 'finish' | 'pause' | 'readable' | 'resume' | 'unpipe', listener: () => void): Stream.Readable;
    on(event: 'error', listener: (err: Error) => void): Stream.Readable;
    on(event: 'pipe', listener: (src: Readable) => void): Stream.Readable;
    on(event: string | symbol, listener: (...args: any[]) => void): Stream.Readable;
};
export interface ResultSetOptions<Format extends DataFormat> {
    stream: Stream.Readable;
    format: Format;
    query_id: string;
    log_error: (error: Error) => void;
    response_headers: ResponseHeaders;
    jsonHandling?: JSONHandling;
}
export declare class ResultSet<Format extends DataFormat | unknown> implements BaseResultSet<Stream.Readable, Format> {
    private _stream;
    private readonly format;
    readonly query_id: string;
    readonly response_headers: ResponseHeaders;
    private readonly exceptionTag;
    private readonly log_error;
    private readonly jsonHandling;
    constructor(_stream: Stream.Readable, format: Format, query_id: string, log_error?: (error: Error) => void, _response_headers?: ResponseHeaders, jsonHandling?: JSONHandling);
    /** See {@link BaseResultSet.text}. */
    text(): Promise<string>;
    /** See {@link BaseResultSet.json}. */
    json<T>(): Promise<ResultJSONType<T, Format>>;
    /** See {@link BaseResultSet.stream}. */
    stream<T>(): ResultStream<Format, StreamReadable<Row<T, Format>[]>>;
    /** See {@link BaseResultSet.close}. */
    close(): void;
    /**
     * Closes the `ResultSet`.
     *
     * Automatically called when using `using` statement in supported environments.
     * @see {@link ResultSet.close}
     * @see https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Statements/using
     */
    [Symbol.dispose](): void;
    static instance<Format extends DataFormat>({ stream, format, query_id, log_error, response_headers, jsonHandling, }: ResultSetOptions<Format>): ResultSet<Format>;
}
