"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const winston_1 = __importDefault(require("winston"));
const IDBSQLLogger_1 = require("./contracts/IDBSQLLogger");
class DBSQLLogger {
    constructor({ level = IDBSQLLogger_1.LogLevel.info, filepath } = {}) {
        this.transports = {
            console: new winston_1.default.transports.Console({ handleExceptions: true, level }),
        };
        this.logger = winston_1.default.createLogger({
            transports: [this.transports.console],
        });
        if (filepath) {
            this.transports.file = new winston_1.default.transports.File({ filename: filepath, handleExceptions: true, level });
            this.logger.add(this.transports.file);
        }
    }
    async log(level, message) {
        this.logger.log({ level, message });
    }
    setLevel(level) {
        this.transports.console.level = level;
        if (this.transports.file) {
            this.transports.file.level = level;
        }
    }
}
exports.default = DBSQLLogger;
//# sourceMappingURL=DBSQLLogger.js.map