import { BaseClient } from 'openid-client';
import { OAuthScopes } from './OAuthScope';
import IClientContext from '../../../contracts/IClientContext';
export type DefaultOpenAuthUrlCallback = (authUrl: string) => Promise<void>;
export type OpenAuthUrlCallback = (authUrl: string, defaultOpenAuthUrl: DefaultOpenAuthUrlCallback) => Promise<void>;
export interface AuthorizationCodeOptions {
    client: BaseClient;
    ports: Array<number>;
    context: IClientContext;
    openAuthUrl?: OpenAuthUrlCallback;
}
export interface AuthorizationCodeFetchResult {
    code: string;
    verifier: string;
    redirectUri: string;
}
export default class AuthorizationCode {
    private readonly context;
    private readonly client;
    private readonly host;
    private readonly options;
    constructor(options: AuthorizationCodeOptions);
    fetch(scopes: OAuthScopes): Promise<AuthorizationCodeFetchResult>;
    private createServer;
    private createHttpServer;
    private startServer;
    private stopServer;
    private renderCallbackResponse;
}
