"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.OAuthFlow = void 0;
const OAuthPersistence_1 = require("./OAuthPersistence");
const OAuthManager_1 = __importStar(require("./OAuthManager"));
Object.defineProperty(exports, "OAuthFlow", { enumerable: true, get: function () { return OAuthManager_1.OAuthFlow; } });
const OAuthScope_1 = require("./OAuthScope");
class DatabricksOAuth {
    constructor(options) {
        this.defaultPersistence = new OAuthPersistence_1.OAuthPersistenceCache();
        this.context = options.context;
        this.options = options;
    }
    async authenticate() {
        var _a;
        const { host, scopes, headers } = this.options;
        const persistence = (_a = this.options.persistence) !== null && _a !== void 0 ? _a : this.defaultPersistence;
        let token = await persistence.read(host);
        if (!token) {
            token = await this.getManager().getToken(scopes !== null && scopes !== void 0 ? scopes : OAuthScope_1.defaultOAuthScopes);
        }
        token = await this.getManager().refreshAccessToken(token);
        await persistence.persist(host, token);
        return {
            ...headers,
            Authorization: `Bearer ${token.accessToken}`,
        };
    }
    getManager() {
        if (!this.manager) {
            this.manager = OAuthManager_1.default.getManager(this.options);
        }
        return this.manager;
    }
}
exports.default = DatabricksOAuth;
//# sourceMappingURL=index.js.map