/// <reference types="node" />
import { Readable, ReadableOptions } from 'node:stream';
import { TGetOperationStatusResp, TTableSchema } from '../../thrift/TCLIService_types';
import Status from '../dto/Status';
export type OperationStatusCallback = (progress: TGetOperationStatusResp) => unknown;
export interface WaitUntilReadyOptions {
    progress?: boolean;
    callback?: OperationStatusCallback;
}
export interface FinishedOptions extends WaitUntilReadyOptions {
}
export interface FetchOptions extends WaitUntilReadyOptions {
    maxRows?: number;
    disableBuffering?: boolean;
}
export interface GetSchemaOptions extends WaitUntilReadyOptions {
}
export interface IteratorOptions extends FetchOptions {
    autoClose?: boolean;
}
export interface IOperationChunksIterator extends AsyncIterableIterator<Array<object>> {
    readonly operation: IOperation;
}
export interface IOperationRowsIterator extends AsyncIterableIterator<object> {
    readonly operation: IOperation;
}
export interface NodeStreamOptions {
    mode?: 'chunks' | 'rows';
    iteratorOptions?: IteratorOptions;
    streamOptions?: ReadableOptions;
}
export default interface IOperation {
    /**
     * Operation identifier
     */
    readonly id: string;
    /**
     * Fetch a portion of data
     */
    fetchChunk(options?: FetchOptions): Promise<Array<object>>;
    /**
     * Fetch all the data
     */
    fetchAll(options?: FetchOptions): Promise<Array<object>>;
    /**
     * Request status of operation
     *
     * @param progress
     */
    status(progress?: boolean): Promise<TGetOperationStatusResp>;
    /**
     * Cancel operation
     */
    cancel(): Promise<Status>;
    /**
     * Close operation
     */
    close(): Promise<Status>;
    /**
     * Waits until operation is finished
     */
    finished(options?: FinishedOptions): Promise<void>;
    /**
     * Check if operation hasMoreRows
     */
    hasMoreRows(): Promise<boolean>;
    /**
     * Fetch schema
     */
    getSchema(options?: GetSchemaOptions): Promise<TTableSchema | null>;
    iterateChunks(options?: IteratorOptions): IOperationChunksIterator;
    iterateRows(options?: IteratorOptions): IOperationRowsIterator;
    toNodeStream(options?: NodeStreamOptions): Readable;
}
