"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const OpenSessionCommand_1 = __importDefault(require("./Commands/OpenSessionCommand"));
const CloseSessionCommand_1 = __importDefault(require("./Commands/CloseSessionCommand"));
const ExecuteStatementCommand_1 = __importDefault(require("./Commands/ExecuteStatementCommand"));
const GetResultSetMetadataCommand_1 = __importDefault(require("./Commands/GetResultSetMetadataCommand"));
const FetchResultsCommand_1 = __importDefault(require("./Commands/FetchResultsCommand"));
const GetInfoCommand_1 = __importDefault(require("./Commands/GetInfoCommand"));
const GetTypeInfoCommand_1 = __importDefault(require("./Commands/GetTypeInfoCommand"));
const GetCatalogsCommand_1 = __importDefault(require("./Commands/GetCatalogsCommand"));
const GetSchemasCommand_1 = __importDefault(require("./Commands/GetSchemasCommand"));
const GetTablesCommand_1 = __importDefault(require("./Commands/GetTablesCommand"));
const GetTableTypesCommand_1 = __importDefault(require("./Commands/GetTableTypesCommand"));
const GetColumnsCommand_1 = __importDefault(require("./Commands/GetColumnsCommand"));
const GetFunctionsCommand_1 = __importDefault(require("./Commands/GetFunctionsCommand"));
const GetPrimaryKeysCommand_1 = __importDefault(require("./Commands/GetPrimaryKeysCommand"));
const GetCrossReferenceCommand_1 = __importDefault(require("./Commands/GetCrossReferenceCommand"));
const GetOperationStatusCommand_1 = __importDefault(require("./Commands/GetOperationStatusCommand"));
const CancelOperationCommand_1 = __importDefault(require("./Commands/CancelOperationCommand"));
const CloseOperationCommand_1 = __importDefault(require("./Commands/CloseOperationCommand"));
const GetDelegationTokenCommand_1 = __importDefault(require("./Commands/GetDelegationTokenCommand"));
const CancelDelegationTokenCommand_1 = __importDefault(require("./Commands/CancelDelegationTokenCommand"));
const RenewDelegationTokenCommand_1 = __importDefault(require("./Commands/RenewDelegationTokenCommand"));
class HiveDriver {
    constructor(options) {
        this.context = options.context;
    }
    async openSession(request) {
        const client = await this.context.getClient();
        const action = new OpenSessionCommand_1.default(client, this.context);
        return action.execute(request);
    }
    async closeSession(request) {
        const client = await this.context.getClient();
        const command = new CloseSessionCommand_1.default(client, this.context);
        return command.execute(request);
    }
    async executeStatement(request) {
        const client = await this.context.getClient();
        const command = new ExecuteStatementCommand_1.default(client, this.context);
        return command.execute(request);
    }
    async getResultSetMetadata(request) {
        const client = await this.context.getClient();
        const command = new GetResultSetMetadataCommand_1.default(client, this.context);
        return command.execute(request);
    }
    async fetchResults(request) {
        const client = await this.context.getClient();
        const command = new FetchResultsCommand_1.default(client, this.context);
        return command.execute(request);
    }
    async getInfo(request) {
        const client = await this.context.getClient();
        const command = new GetInfoCommand_1.default(client, this.context);
        return command.execute(request);
    }
    async getTypeInfo(request) {
        const client = await this.context.getClient();
        const command = new GetTypeInfoCommand_1.default(client, this.context);
        return command.execute(request);
    }
    async getCatalogs(request) {
        const client = await this.context.getClient();
        const command = new GetCatalogsCommand_1.default(client, this.context);
        return command.execute(request);
    }
    async getSchemas(request) {
        const client = await this.context.getClient();
        const command = new GetSchemasCommand_1.default(client, this.context);
        return command.execute(request);
    }
    async getTables(request) {
        const client = await this.context.getClient();
        const command = new GetTablesCommand_1.default(client, this.context);
        return command.execute(request);
    }
    async getTableTypes(request) {
        const client = await this.context.getClient();
        const command = new GetTableTypesCommand_1.default(client, this.context);
        return command.execute(request);
    }
    async getColumns(request) {
        const client = await this.context.getClient();
        const command = new GetColumnsCommand_1.default(client, this.context);
        return command.execute(request);
    }
    async getFunctions(request) {
        const client = await this.context.getClient();
        const command = new GetFunctionsCommand_1.default(client, this.context);
        return command.execute(request);
    }
    async getPrimaryKeys(request) {
        const client = await this.context.getClient();
        const command = new GetPrimaryKeysCommand_1.default(client, this.context);
        return command.execute(request);
    }
    async getCrossReference(request) {
        const client = await this.context.getClient();
        const command = new GetCrossReferenceCommand_1.default(client, this.context);
        return command.execute(request);
    }
    async getOperationStatus(request) {
        const client = await this.context.getClient();
        const command = new GetOperationStatusCommand_1.default(client, this.context);
        return command.execute(request);
    }
    async cancelOperation(request) {
        const client = await this.context.getClient();
        const command = new CancelOperationCommand_1.default(client, this.context);
        return command.execute(request);
    }
    async closeOperation(request) {
        const client = await this.context.getClient();
        const command = new CloseOperationCommand_1.default(client, this.context);
        return command.execute(request);
    }
    async getDelegationToken(request) {
        const client = await this.context.getClient();
        const command = new GetDelegationTokenCommand_1.default(client, this.context);
        return command.execute(request);
    }
    async cancelDelegationToken(request) {
        const client = await this.context.getClient();
        const command = new CancelDelegationTokenCommand_1.default(client, this.context);
        return command.execute(request);
    }
    async renewDelegationToken(request) {
        const client = await this.context.getClient();
        const command = new RenewDelegationTokenCommand_1.default(client, this.context);
        return command.execute(request);
    }
}
exports.default = HiveDriver;
//# sourceMappingURL=HiveDriver.js.map