"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const utils_1 = require("./utils");
class JsonResultHandler {
    constructor(context, source, { schema }) {
        this.context = context;
        this.source = source;
        this.schema = (0, utils_1.getSchemaColumns)(schema);
    }
    async hasMore() {
        return this.source.hasMore();
    }
    async fetchNext(options) {
        if (this.schema.length === 0) {
            return [];
        }
        const data = await this.source.fetchNext(options);
        if (!data) {
            return [];
        }
        const columns = data.columns || [];
        return this.getRows(columns, this.schema);
    }
    getRows(columns, descriptors) {
        return descriptors.reduce((rows, descriptor) => this.getSchemaValues(descriptor, columns[descriptor.position - 1]).reduce((result, value, i) => {
            if (!result[i]) {
                result[i] = {};
            }
            const { columnName } = descriptor;
            result[i][columnName] = value;
            return result;
        }, rows), []);
    }
    getSchemaValues(descriptor, column) {
        var _a;
        const typeDescriptor = (_a = descriptor.typeDesc.types[0]) === null || _a === void 0 ? void 0 : _a.primitiveEntry;
        const columnValue = (0, utils_1.getColumnValue)(column);
        if (!columnValue) {
            return [];
        }
        return columnValue.values.map((value, i) => {
            if (columnValue.nulls && this.isNull(columnValue.nulls, i)) {
                return null;
            }
            return (0, utils_1.convertThriftValue)(typeDescriptor, value);
        });
    }
    isNull(nulls, i) {
        const byte = nulls[Math.floor(i / 8)];
        const ofs = 2 ** (i % 8);
        return (byte & ofs) !== 0;
    }
}
exports.default = JsonResultHandler;
//# sourceMappingURL=JsonResultHandler.js.map