"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class ResultSlicer {
    constructor(context, source) {
        this.remainingResults = [];
        this.context = context;
        this.source = source;
    }
    async hasMore() {
        if (this.remainingResults.length > 0) {
            return true;
        }
        return this.source.hasMore();
    }
    async fetchNext(options) {
        var _a;
        // If we're asked to not use buffer - first try to return whatever we have in buffer.
        // If buffer is empty - just proxy the call to underlying results provider
        if (options.disableBuffering) {
            if (this.remainingResults.length > 0) {
                const result = this.remainingResults;
                this.remainingResults = [];
                return result;
            }
            return this.source.fetchNext(options);
        }
        const result = [];
        let resultsCount = 0;
        // First, use remaining items from the previous fetch
        if (this.remainingResults.length > 0) {
            result.push(this.remainingResults);
            resultsCount += this.remainingResults.length;
            this.remainingResults = [];
        }
        // Fetch items from source results provider until we reach a requested count
        while (resultsCount < options.limit) {
            // eslint-disable-next-line no-await-in-loop
            const hasMore = await this.source.hasMore();
            if (!hasMore) {
                break;
            }
            // eslint-disable-next-line no-await-in-loop
            const chunk = await this.source.fetchNext(options);
            result.push(chunk);
            resultsCount += chunk.length;
        }
        // If we collected more results than requested, slice the excess items and store them for the next time
        if (resultsCount > options.limit) {
            const lastChunk = (_a = result.pop()) !== null && _a !== void 0 ? _a : [];
            const neededCount = options.limit - (resultsCount - lastChunk.length);
            result.push(lastChunk.splice(0, neededCount));
            this.remainingResults = lastChunk;
        }
        return result.flat();
    }
}
exports.default = ResultSlicer;
//# sourceMappingURL=ResultSlicer.js.map