"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
class CloseableCollection {
    constructor() {
        this.items = new Set();
    }
    add(item) {
        item.onClose = () => {
            this.delete(item);
        };
        this.items.add(item);
    }
    delete(item) {
        if (this.items.has(item)) {
            item.onClose = undefined;
        }
        this.items.delete(item);
    }
    async closeAll() {
        const items = [...this.items];
        for (const item of items) {
            await item.close(); // eslint-disable-line no-await-in-loop
            item.onClose = undefined;
            this.items.delete(item);
        }
    }
}
exports.default = CloseableCollection;
//# sourceMappingURL=CloseableCollection.js.map