import IOperation, { IOperationChunksIterator, IOperationRowsIterator, IteratorOptions } from '../contracts/IOperation';
declare abstract class OperationIterator<R> implements AsyncIterableIterator<R> {
    readonly operation: IOperation;
    protected readonly options?: IteratorOptions;
    constructor(operation: IOperation, options?: IteratorOptions);
    protected abstract getNext(): Promise<IteratorResult<R>>;
    [Symbol.asyncIterator](): this;
    next(): Promise<IteratorResult<R, any>>;
    return(value?: any): Promise<{
        done: boolean;
        value: any;
    }>;
}
export declare class OperationChunksIterator extends OperationIterator<Array<object>> implements IOperationChunksIterator {
    protected getNext(): Promise<IteratorResult<Array<object>>>;
}
export declare class OperationRowsIterator extends OperationIterator<object> implements IOperationRowsIterator {
    private chunk;
    private index;
    constructor(operation: IOperation, options?: IteratorOptions);
    protected getNext(): Promise<IteratorResult<object>>;
}
export {};
