import { TProtocolVersion } from '../../thrift/TCLIService_types';
/**
 * Protocol version information from Thrift TCLIService
 * Each version adds certain features to the Spark/Hive API
 *
 * Databricks only supports SPARK_CLI_SERVICE_PROTOCOL_V1 (0xA501) or higher
 */
/**
 * Check if the current protocol version supports a specific feature
 * @param serverProtocolVersion The protocol version received from server in TOpenSessionResp
 * @param requiredVersion The minimum protocol version required for a feature
 * @returns boolean indicating if the feature is supported
 */
export declare function isFeatureSupported(serverProtocolVersion: TProtocolVersion | undefined | null, requiredVersion: TProtocolVersion): boolean;
/**
 * Check if parameterized queries are supported
 * (Requires SPARK_CLI_SERVICE_PROTOCOL_V8 or higher)
 * @param serverProtocolVersion The protocol version from server
 * @returns boolean indicating if parameterized queries are supported
 */
export declare function supportsParameterizedQueries(serverProtocolVersion: TProtocolVersion | undefined | null): boolean;
/**
 * Check if async metadata operations are supported
 * (Requires SPARK_CLI_SERVICE_PROTOCOL_V6 or higher)
 * @param serverProtocolVersion The protocol version from server
 * @returns boolean indicating if async metadata operations are supported
 */
export declare function supportsAsyncMetadataOperations(serverProtocolVersion: TProtocolVersion | undefined | null): boolean;
/**
 * Check if result persistence mode is supported
 * (Requires SPARK_CLI_SERVICE_PROTOCOL_V7 or higher)
 * @param serverProtocolVersion The protocol version from server
 * @returns boolean indicating if result persistence mode is supported
 */
export declare function supportsResultPersistenceMode(serverProtocolVersion: TProtocolVersion | undefined | null): boolean;
/**
 * Check if Arrow compression is supported
 * (Requires SPARK_CLI_SERVICE_PROTOCOL_V6 or higher)
 * @param serverProtocolVersion The protocol version from server
 * @returns boolean indicating if compressed Arrow batches are supported
 */
export declare function supportsArrowCompression(serverProtocolVersion: TProtocolVersion | undefined | null): boolean;
/**
 * Check if Arrow metadata is supported
 * (Requires SPARK_CLI_SERVICE_PROTOCOL_V5 or higher)
 * @param serverProtocolVersion The protocol version from server
 * @returns boolean indicating if Arrow metadata is supported
 */
export declare function supportsArrowMetadata(serverProtocolVersion: TProtocolVersion | undefined | null): boolean;
/**
 * Check if multiple catalogs are supported
 * (Requires SPARK_CLI_SERVICE_PROTOCOL_V4 or higher)
 * @param serverProtocolVersion The protocol version from server
 * @returns boolean indicating if multiple catalogs are supported
 */
export declare function supportsMultipleCatalogs(serverProtocolVersion: TProtocolVersion | undefined | null): boolean;
/**
 * Check if cloud object storage fetching is supported
 * (Requires SPARK_CLI_SERVICE_PROTOCOL_V3 or higher)
 * @param serverProtocolVersion The protocol version from server
 * @returns boolean indicating if cloud fetching is supported
 */
export declare function supportsCloudFetch(serverProtocolVersion: TProtocolVersion | undefined | null): boolean;
