'use strict';

var CORE = require('@gitbeaker/core');
var requesterUtils = require('@gitbeaker/requester-utils');

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n.default = e;
  return Object.freeze(n);
}

var CORE__namespace = /*#__PURE__*/_interopNamespace(CORE);

// src/index.ts
async function processBody(response) {
  const contentType = (response.headers.get("content-type") || "").split(";")[0].trim();
  if (contentType === "application/json") {
    return response.json().then((v) => v || {});
  }
  if (contentType.startsWith("text/")) {
    return response.text().then((t) => t || "");
  }
  return response.blob();
}
function delay(ms) {
  return new Promise((resolve) => {
    setTimeout(resolve, ms);
  });
}
async function parseResponse(response, asStream = false) {
  const { status, headers: rawHeaders } = response;
  const headers = Object.fromEntries(rawHeaders.entries());
  let body;
  if (asStream) {
    body = response.body;
  } else {
    body = status === 204 ? null : await processBody(response);
  }
  return { body, headers, status };
}
async function throwFailedRequestError(request, response) {
  const content = await response.text();
  const contentType = response.headers.get("Content-Type");
  let description;
  if (contentType?.includes("application/json")) {
    const output = JSON.parse(content);
    const contentProperty = output?.error || output?.message || "";
    description = typeof contentProperty === "string" ? contentProperty : JSON.stringify(contentProperty);
  } else {
    description = content;
  }
  throw new requesterUtils.GitbeakerRequestError(description, {
    cause: {
      description,
      request,
      response
    }
  });
}
function getConditionalMode(endpoint) {
  if (endpoint.includes("repository/archive")) return "same-origin";
  return void 0;
}
async function defaultRequestHandler(endpoint, options) {
  const retryCodes = [429, 502];
  const maxRetries = 10;
  const { rateLimiters, agent, asStream, prefixUrl, searchParams, method, ...opts } = options || {};
  const rateLimit = requesterUtils.getMatchingRateLimiter(endpoint, rateLimiters, method);
  let lastStatus;
  let baseUrl;
  if (prefixUrl) baseUrl = prefixUrl.endsWith("/") ? prefixUrl : `${prefixUrl}/`;
  const url = new URL(endpoint, baseUrl);
  url.search = searchParams || "";
  const mode = getConditionalMode(endpoint);
  for (let i = 0; i < maxRetries; i += 1) {
    const request = new Request(url, { ...opts, method, mode });
    const fetchArgs = [request];
    if (agent) fetchArgs.push({ dispatcher: agent });
    await rateLimit();
    const response = await fetch(...fetchArgs).catch((e) => {
      if (e.name === "TimeoutError" || e.name === "AbortError") {
        throw new requesterUtils.GitbeakerTimeoutError("Query timeout was reached");
      }
      throw e;
    });
    if (response.ok) return parseResponse(response, asStream);
    if (!retryCodes.includes(response.status)) await throwFailedRequestError(request, response);
    lastStatus = response.status;
    await delay(2 ** i * 0.25);
    continue;
  }
  throw new requesterUtils.GitbeakerRetryError(
    `Could not successfully complete this request after ${maxRetries} retries, last status code: ${lastStatus}. ${lastStatus === 429 ? "Check the applicable rate limits for this endpoint" : "Verify the status of the endpoint"}.`
  );
}
var requesterFn = requesterUtils.createRequesterFn(
  (_, reqo) => Promise.resolve(reqo),
  defaultRequestHandler
);
var { AccessLevel, ...Resources } = CORE__namespace;
var API = requesterUtils.presetResourceArguments(Resources, { requesterFn });
var { Agents } = API;
var { AlertManagement } = API;
var { ApplicationAppearance } = API;
var { ApplicationPlanLimits } = API;
var { Applications } = API;
var { ApplicationSettings } = API;
var { ApplicationStatistics } = API;
var { AuditEvents } = API;
var { Avatar } = API;
var { Branches } = API;
var { BroadcastMessages } = API;
var { CodeSuggestions } = API;
var { CommitDiscussions } = API;
var { Commits } = API;
var { Composer } = API;
var { Conan } = API;
var { ContainerRegistry } = API;
var { DashboardAnnotations } = API;
var { Debian } = API;
var { DependencyProxy } = API;
var { DeployKeys } = API;
var { DeployTokens } = API;
var { Deployments } = API;
var { DockerfileTemplates } = API;
var { Environments } = API;
var { EpicAwardEmojis } = API;
var { EpicDiscussions } = API;
var { EpicIssues } = API;
var { EpicLabelEvents } = API;
var { EpicLinks } = API;
var { EpicNotes } = API;
var { Epics } = API;
var { ErrorTrackingClientKeys } = API;
var { ErrorTrackingSettings } = API;
var { Events } = API;
var { Experiments } = API;
var { ExternalStatusChecks } = API;
var { FeatureFlags } = API;
var { FeatureFlagUserLists } = API;
var { FreezePeriods } = API;
var { GeoNodes } = API;
var { GeoSites } = API;
var { GitignoreTemplates } = API;
var { GitLabCIYMLTemplates } = API;
var { GitlabPages } = API;
var { GoProxy } = API;
var { GroupAccessRequests } = API;
var { GroupAccessTokens } = API;
var { GroupActivityAnalytics } = API;
var { GroupBadges } = API;
var { GroupCustomAttributes } = API;
var { GroupDORA4Metrics } = API;
var { GroupEpicBoards } = API;
var { GroupHooks } = API;
var { GroupImportExports } = API;
var { GroupInvitations } = API;
var { GroupIssueBoards } = API;
var { GroupIterations } = API;
var { GroupLabels } = API;
var { GroupLDAPLinks } = API;
var { GroupMarkdownUploads } = API;
var { GroupMemberRoles } = API;
var { GroupMembers } = API;
var { GroupMilestones } = API;
var { GroupProtectedEnvironments } = API;
var { GroupPushRules } = API;
var { GroupRelationExports } = API;
var { GroupReleases } = API;
var { GroupRepositoryStorageMoves } = API;
var { Groups } = API;
var { GroupSAMLIdentities } = API;
var { GroupSAMLLinks } = API;
var { GroupSCIMIdentities } = API;
var { GroupServiceAccounts } = API;
var { GroupVariables } = API;
var { GroupWikis } = API;
var { Helm } = API;
var { Import } = API;
var { InstanceLevelCICDVariables } = API;
var { Integrations } = API;
var { IssueAwardEmojis } = API;
var { IssueDiscussions } = API;
var { IssueIterationEvents } = API;
var { IssueLabelEvents } = API;
var { IssueLinks } = API;
var { IssueMilestoneEvents } = API;
var { IssueNoteAwardEmojis } = API;
var { IssueNotes } = API;
var { Issues } = API;
var { IssuesStatistics } = API;
var { IssueStateEvents } = API;
var { IssueWeightEvents } = API;
var { JobArtifacts } = API;
var { Jobs } = API;
var { Keys } = API;
var { License } = API;
var { LicenseTemplates } = API;
var { LinkedEpics } = API;
var { Lint } = API;
var { Markdown } = API;
var { Maven } = API;
var { MergeRequestApprovals } = API;
var { MergeRequestAwardEmojis } = API;
var { MergeRequestContextCommits } = API;
var { MergeRequestDiscussions } = API;
var { MergeRequestDraftNotes } = API;
var { MergeRequestLabelEvents } = API;
var { MergeRequestMilestoneEvents } = API;
var { MergeRequestNoteAwardEmojis } = API;
var { MergeRequestNotes } = API;
var { MergeRequests } = API;
var { MergeTrains } = API;
var { Metadata } = API;
var { Migrations } = API;
var { Namespaces } = API;
var { NotificationSettings } = API;
var { NPM } = API;
var { NuGet } = API;
var { PackageRegistry } = API;
var { Packages } = API;
var { PagesDomains } = API;
var { PersonalAccessTokens } = API;
var { PipelineSchedules } = API;
var { PipelineScheduleVariables } = API;
var { Pipelines } = API;
var { PipelineTriggerTokens } = API;
var { ProductAnalytics } = API;
var { ProjectAccessRequests } = API;
var { ProjectAccessTokens } = API;
var { ProjectAliases } = API;
var { ProjectBadges } = API;
var { ProjectCustomAttributes } = API;
var { ProjectDORA4Metrics } = API;
var { ProjectHooks } = API;
var { ProjectImportExports } = API;
var { ProjectInvitations } = API;
var { ProjectIssueBoards } = API;
var { ProjectIterations } = API;
var { ProjectJobTokenScopes } = API;
var { ProjectLabels } = API;
var { ProjectMarkdownUploads } = API;
var { ProjectMembers } = API;
var { ProjectMilestones } = API;
var { ProjectProtectedEnvironments } = API;
var { ProjectPushRules } = API;
var { ProjectRelationsExport } = API;
var { ProjectReleases } = API;
var { ProjectRemoteMirrors } = API;
var { ProjectRepositoryStorageMoves } = API;
var { Projects } = API;
var { ProjectSnippetAwardEmojis } = API;
var { ProjectSnippetDiscussions } = API;
var { ProjectSnippetNotes } = API;
var { ProjectSnippets } = API;
var { ProjectStatistics } = API;
var { ProjectTemplates } = API;
var { ProjectTerraformState } = API;
var { ProjectVariables } = API;
var { ProjectVulnerabilities } = API;
var { ProjectWikis } = API;
var { ProtectedBranches } = API;
var { ProtectedTags } = API;
var { PyPI } = API;
var { ReleaseLinks } = API;
var { Repositories } = API;
var { RepositoryFiles } = API;
var { RepositorySubmodules } = API;
var { ResourceGroups } = API;
var { RubyGems } = API;
var { Runners } = API;
var { Search } = API;
var { SearchAdmin } = API;
var { SecureFiles } = API;
var { ServiceAccounts } = API;
var { ServiceData } = API;
var { SidekiqMetrics } = API;
var { SidekiqQueues } = API;
var { SnippetRepositoryStorageMoves } = API;
var { Snippets } = API;
var { Suggestions } = API;
var { SystemHooks } = API;
var { Tags } = API;
var { TodoLists } = API;
var { Topics } = API;
var { UserCustomAttributes } = API;
var { UserEmails } = API;
var { UserGPGKeys } = API;
var { UserImpersonationTokens } = API;
var { Users } = API;
var { UserSSHKeys } = API;
var { UserStarredMetricsDashboard } = API;
var { Gitlab } = API;

Object.defineProperty(exports, "GitbeakerRequestError", {
  enumerable: true,
  get: function () { return requesterUtils.GitbeakerRequestError; }
});
Object.defineProperty(exports, "GitbeakerRetryError", {
  enumerable: true,
  get: function () { return requesterUtils.GitbeakerRetryError; }
});
Object.defineProperty(exports, "GitbeakerTimeoutError", {
  enumerable: true,
  get: function () { return requesterUtils.GitbeakerTimeoutError; }
});
exports.AccessLevel = AccessLevel;
exports.Agents = Agents;
exports.AlertManagement = AlertManagement;
exports.ApplicationAppearance = ApplicationAppearance;
exports.ApplicationPlanLimits = ApplicationPlanLimits;
exports.ApplicationSettings = ApplicationSettings;
exports.ApplicationStatistics = ApplicationStatistics;
exports.Applications = Applications;
exports.AuditEvents = AuditEvents;
exports.Avatar = Avatar;
exports.Branches = Branches;
exports.BroadcastMessages = BroadcastMessages;
exports.CodeSuggestions = CodeSuggestions;
exports.CommitDiscussions = CommitDiscussions;
exports.Commits = Commits;
exports.Composer = Composer;
exports.Conan = Conan;
exports.ContainerRegistry = ContainerRegistry;
exports.DashboardAnnotations = DashboardAnnotations;
exports.Debian = Debian;
exports.DependencyProxy = DependencyProxy;
exports.DeployKeys = DeployKeys;
exports.DeployTokens = DeployTokens;
exports.Deployments = Deployments;
exports.DockerfileTemplates = DockerfileTemplates;
exports.Environments = Environments;
exports.EpicAwardEmojis = EpicAwardEmojis;
exports.EpicDiscussions = EpicDiscussions;
exports.EpicIssues = EpicIssues;
exports.EpicLabelEvents = EpicLabelEvents;
exports.EpicLinks = EpicLinks;
exports.EpicNotes = EpicNotes;
exports.Epics = Epics;
exports.ErrorTrackingClientKeys = ErrorTrackingClientKeys;
exports.ErrorTrackingSettings = ErrorTrackingSettings;
exports.Events = Events;
exports.Experiments = Experiments;
exports.ExternalStatusChecks = ExternalStatusChecks;
exports.FeatureFlagUserLists = FeatureFlagUserLists;
exports.FeatureFlags = FeatureFlags;
exports.FreezePeriods = FreezePeriods;
exports.GeoNodes = GeoNodes;
exports.GeoSites = GeoSites;
exports.GitLabCIYMLTemplates = GitLabCIYMLTemplates;
exports.GitignoreTemplates = GitignoreTemplates;
exports.Gitlab = Gitlab;
exports.GitlabPages = GitlabPages;
exports.GoProxy = GoProxy;
exports.GroupAccessRequests = GroupAccessRequests;
exports.GroupAccessTokens = GroupAccessTokens;
exports.GroupActivityAnalytics = GroupActivityAnalytics;
exports.GroupBadges = GroupBadges;
exports.GroupCustomAttributes = GroupCustomAttributes;
exports.GroupDORA4Metrics = GroupDORA4Metrics;
exports.GroupEpicBoards = GroupEpicBoards;
exports.GroupHooks = GroupHooks;
exports.GroupImportExports = GroupImportExports;
exports.GroupInvitations = GroupInvitations;
exports.GroupIssueBoards = GroupIssueBoards;
exports.GroupIterations = GroupIterations;
exports.GroupLDAPLinks = GroupLDAPLinks;
exports.GroupLabels = GroupLabels;
exports.GroupMarkdownUploads = GroupMarkdownUploads;
exports.GroupMemberRoles = GroupMemberRoles;
exports.GroupMembers = GroupMembers;
exports.GroupMilestones = GroupMilestones;
exports.GroupProtectedEnvironments = GroupProtectedEnvironments;
exports.GroupPushRules = GroupPushRules;
exports.GroupRelationExports = GroupRelationExports;
exports.GroupReleases = GroupReleases;
exports.GroupRepositoryStorageMoves = GroupRepositoryStorageMoves;
exports.GroupSAMLIdentities = GroupSAMLIdentities;
exports.GroupSAMLLinks = GroupSAMLLinks;
exports.GroupSCIMIdentities = GroupSCIMIdentities;
exports.GroupServiceAccounts = GroupServiceAccounts;
exports.GroupVariables = GroupVariables;
exports.GroupWikis = GroupWikis;
exports.Groups = Groups;
exports.Helm = Helm;
exports.Import = Import;
exports.InstanceLevelCICDVariables = InstanceLevelCICDVariables;
exports.Integrations = Integrations;
exports.IssueAwardEmojis = IssueAwardEmojis;
exports.IssueDiscussions = IssueDiscussions;
exports.IssueIterationEvents = IssueIterationEvents;
exports.IssueLabelEvents = IssueLabelEvents;
exports.IssueLinks = IssueLinks;
exports.IssueMilestoneEvents = IssueMilestoneEvents;
exports.IssueNoteAwardEmojis = IssueNoteAwardEmojis;
exports.IssueNotes = IssueNotes;
exports.IssueStateEvents = IssueStateEvents;
exports.IssueWeightEvents = IssueWeightEvents;
exports.Issues = Issues;
exports.IssuesStatistics = IssuesStatistics;
exports.JobArtifacts = JobArtifacts;
exports.Jobs = Jobs;
exports.Keys = Keys;
exports.License = License;
exports.LicenseTemplates = LicenseTemplates;
exports.LinkedEpics = LinkedEpics;
exports.Lint = Lint;
exports.Markdown = Markdown;
exports.Maven = Maven;
exports.MergeRequestApprovals = MergeRequestApprovals;
exports.MergeRequestAwardEmojis = MergeRequestAwardEmojis;
exports.MergeRequestContextCommits = MergeRequestContextCommits;
exports.MergeRequestDiscussions = MergeRequestDiscussions;
exports.MergeRequestDraftNotes = MergeRequestDraftNotes;
exports.MergeRequestLabelEvents = MergeRequestLabelEvents;
exports.MergeRequestMilestoneEvents = MergeRequestMilestoneEvents;
exports.MergeRequestNoteAwardEmojis = MergeRequestNoteAwardEmojis;
exports.MergeRequestNotes = MergeRequestNotes;
exports.MergeRequests = MergeRequests;
exports.MergeTrains = MergeTrains;
exports.Metadata = Metadata;
exports.Migrations = Migrations;
exports.NPM = NPM;
exports.Namespaces = Namespaces;
exports.NotificationSettings = NotificationSettings;
exports.NuGet = NuGet;
exports.PackageRegistry = PackageRegistry;
exports.Packages = Packages;
exports.PagesDomains = PagesDomains;
exports.PersonalAccessTokens = PersonalAccessTokens;
exports.PipelineScheduleVariables = PipelineScheduleVariables;
exports.PipelineSchedules = PipelineSchedules;
exports.PipelineTriggerTokens = PipelineTriggerTokens;
exports.Pipelines = Pipelines;
exports.ProductAnalytics = ProductAnalytics;
exports.ProjectAccessRequests = ProjectAccessRequests;
exports.ProjectAccessTokens = ProjectAccessTokens;
exports.ProjectAliases = ProjectAliases;
exports.ProjectBadges = ProjectBadges;
exports.ProjectCustomAttributes = ProjectCustomAttributes;
exports.ProjectDORA4Metrics = ProjectDORA4Metrics;
exports.ProjectHooks = ProjectHooks;
exports.ProjectImportExports = ProjectImportExports;
exports.ProjectInvitations = ProjectInvitations;
exports.ProjectIssueBoards = ProjectIssueBoards;
exports.ProjectIterations = ProjectIterations;
exports.ProjectJobTokenScopes = ProjectJobTokenScopes;
exports.ProjectLabels = ProjectLabels;
exports.ProjectMarkdownUploads = ProjectMarkdownUploads;
exports.ProjectMembers = ProjectMembers;
exports.ProjectMilestones = ProjectMilestones;
exports.ProjectProtectedEnvironments = ProjectProtectedEnvironments;
exports.ProjectPushRules = ProjectPushRules;
exports.ProjectRelationsExport = ProjectRelationsExport;
exports.ProjectReleases = ProjectReleases;
exports.ProjectRemoteMirrors = ProjectRemoteMirrors;
exports.ProjectRepositoryStorageMoves = ProjectRepositoryStorageMoves;
exports.ProjectSnippetAwardEmojis = ProjectSnippetAwardEmojis;
exports.ProjectSnippetDiscussions = ProjectSnippetDiscussions;
exports.ProjectSnippetNotes = ProjectSnippetNotes;
exports.ProjectSnippets = ProjectSnippets;
exports.ProjectStatistics = ProjectStatistics;
exports.ProjectTemplates = ProjectTemplates;
exports.ProjectTerraformState = ProjectTerraformState;
exports.ProjectVariables = ProjectVariables;
exports.ProjectVulnerabilities = ProjectVulnerabilities;
exports.ProjectWikis = ProjectWikis;
exports.Projects = Projects;
exports.ProtectedBranches = ProtectedBranches;
exports.ProtectedTags = ProtectedTags;
exports.PyPI = PyPI;
exports.ReleaseLinks = ReleaseLinks;
exports.Repositories = Repositories;
exports.RepositoryFiles = RepositoryFiles;
exports.RepositorySubmodules = RepositorySubmodules;
exports.ResourceGroups = ResourceGroups;
exports.RubyGems = RubyGems;
exports.Runners = Runners;
exports.Search = Search;
exports.SearchAdmin = SearchAdmin;
exports.SecureFiles = SecureFiles;
exports.ServiceAccounts = ServiceAccounts;
exports.ServiceData = ServiceData;
exports.SidekiqMetrics = SidekiqMetrics;
exports.SidekiqQueues = SidekiqQueues;
exports.SnippetRepositoryStorageMoves = SnippetRepositoryStorageMoves;
exports.Snippets = Snippets;
exports.Suggestions = Suggestions;
exports.SystemHooks = SystemHooks;
exports.Tags = Tags;
exports.TodoLists = TodoLists;
exports.Topics = Topics;
exports.UserCustomAttributes = UserCustomAttributes;
exports.UserEmails = UserEmails;
exports.UserGPGKeys = UserGPGKeys;
exports.UserImpersonationTokens = UserImpersonationTokens;
exports.UserSSHKeys = UserSSHKeys;
exports.UserStarredMetricsDashboard = UserStarredMetricsDashboard;
exports.Users = Users;
