import * as CORE from '@gitbeaker/core';
import { createRequesterFn, presetResourceArguments, getMatchingRateLimiter, GitbeakerTimeoutError, GitbeakerRetryError, GitbeakerRequestError } from '@gitbeaker/requester-utils';
export { GitbeakerRequestError, GitbeakerRetryError, GitbeakerTimeoutError } from '@gitbeaker/requester-utils';

// src/index.ts
async function processBody(response) {
  const contentType = (response.headers.get("content-type") || "").split(";")[0].trim();
  if (contentType === "application/json") {
    return response.json().then((v) => v || {});
  }
  if (contentType.startsWith("text/")) {
    return response.text().then((t) => t || "");
  }
  return response.blob();
}
function delay(ms) {
  return new Promise((resolve) => {
    setTimeout(resolve, ms);
  });
}
async function parseResponse(response, asStream = false) {
  const { status, headers: rawHeaders } = response;
  const headers = Object.fromEntries(rawHeaders.entries());
  let body;
  if (asStream) {
    body = response.body;
  } else {
    body = status === 204 ? null : await processBody(response);
  }
  return { body, headers, status };
}
async function throwFailedRequestError(request, response) {
  const content = await response.text();
  const contentType = response.headers.get("Content-Type");
  let description;
  if (contentType?.includes("application/json")) {
    const output = JSON.parse(content);
    const contentProperty = output?.error || output?.message || "";
    description = typeof contentProperty === "string" ? contentProperty : JSON.stringify(contentProperty);
  } else {
    description = content;
  }
  throw new GitbeakerRequestError(description, {
    cause: {
      description,
      request,
      response
    }
  });
}
function getConditionalMode(endpoint) {
  if (endpoint.includes("repository/archive")) return "same-origin";
  return void 0;
}
async function defaultRequestHandler(endpoint, options) {
  const retryCodes = [429, 502];
  const maxRetries = 10;
  const { rateLimiters, agent, asStream, prefixUrl, searchParams, method, ...opts } = options || {};
  const rateLimit = getMatchingRateLimiter(endpoint, rateLimiters, method);
  let lastStatus;
  let baseUrl;
  if (prefixUrl) baseUrl = prefixUrl.endsWith("/") ? prefixUrl : `${prefixUrl}/`;
  const url = new URL(endpoint, baseUrl);
  url.search = searchParams || "";
  const mode = getConditionalMode(endpoint);
  for (let i = 0; i < maxRetries; i += 1) {
    const request = new Request(url, { ...opts, method, mode });
    const fetchArgs = [request];
    if (agent) fetchArgs.push({ dispatcher: agent });
    await rateLimit();
    const response = await fetch(...fetchArgs).catch((e) => {
      if (e.name === "TimeoutError" || e.name === "AbortError") {
        throw new GitbeakerTimeoutError("Query timeout was reached");
      }
      throw e;
    });
    if (response.ok) return parseResponse(response, asStream);
    if (!retryCodes.includes(response.status)) await throwFailedRequestError(request, response);
    lastStatus = response.status;
    await delay(2 ** i * 0.25);
    continue;
  }
  throw new GitbeakerRetryError(
    `Could not successfully complete this request after ${maxRetries} retries, last status code: ${lastStatus}. ${lastStatus === 429 ? "Check the applicable rate limits for this endpoint" : "Verify the status of the endpoint"}.`
  );
}
var requesterFn = createRequesterFn(
  (_, reqo) => Promise.resolve(reqo),
  defaultRequestHandler
);
var { AccessLevel, ...Resources } = CORE;
var API = presetResourceArguments(Resources, { requesterFn });
var { Agents } = API;
var { AlertManagement } = API;
var { ApplicationAppearance } = API;
var { ApplicationPlanLimits } = API;
var { Applications } = API;
var { ApplicationSettings } = API;
var { ApplicationStatistics } = API;
var { AuditEvents } = API;
var { Avatar } = API;
var { Branches } = API;
var { BroadcastMessages } = API;
var { CodeSuggestions } = API;
var { CommitDiscussions } = API;
var { Commits } = API;
var { Composer } = API;
var { Conan } = API;
var { ContainerRegistry } = API;
var { DashboardAnnotations } = API;
var { Debian } = API;
var { DependencyProxy } = API;
var { DeployKeys } = API;
var { DeployTokens } = API;
var { Deployments } = API;
var { DockerfileTemplates } = API;
var { Environments } = API;
var { EpicAwardEmojis } = API;
var { EpicDiscussions } = API;
var { EpicIssues } = API;
var { EpicLabelEvents } = API;
var { EpicLinks } = API;
var { EpicNotes } = API;
var { Epics } = API;
var { ErrorTrackingClientKeys } = API;
var { ErrorTrackingSettings } = API;
var { Events } = API;
var { Experiments } = API;
var { ExternalStatusChecks } = API;
var { FeatureFlags } = API;
var { FeatureFlagUserLists } = API;
var { FreezePeriods } = API;
var { GeoNodes } = API;
var { GeoSites } = API;
var { GitignoreTemplates } = API;
var { GitLabCIYMLTemplates } = API;
var { GitlabPages } = API;
var { GoProxy } = API;
var { GroupAccessRequests } = API;
var { GroupAccessTokens } = API;
var { GroupActivityAnalytics } = API;
var { GroupBadges } = API;
var { GroupCustomAttributes } = API;
var { GroupDORA4Metrics } = API;
var { GroupEpicBoards } = API;
var { GroupHooks } = API;
var { GroupImportExports } = API;
var { GroupInvitations } = API;
var { GroupIssueBoards } = API;
var { GroupIterations } = API;
var { GroupLabels } = API;
var { GroupLDAPLinks } = API;
var { GroupMarkdownUploads } = API;
var { GroupMemberRoles } = API;
var { GroupMembers } = API;
var { GroupMilestones } = API;
var { GroupProtectedEnvironments } = API;
var { GroupPushRules } = API;
var { GroupRelationExports } = API;
var { GroupReleases } = API;
var { GroupRepositoryStorageMoves } = API;
var { Groups } = API;
var { GroupSAMLIdentities } = API;
var { GroupSAMLLinks } = API;
var { GroupSCIMIdentities } = API;
var { GroupServiceAccounts } = API;
var { GroupVariables } = API;
var { GroupWikis } = API;
var { Helm } = API;
var { Import } = API;
var { InstanceLevelCICDVariables } = API;
var { Integrations } = API;
var { IssueAwardEmojis } = API;
var { IssueDiscussions } = API;
var { IssueIterationEvents } = API;
var { IssueLabelEvents } = API;
var { IssueLinks } = API;
var { IssueMilestoneEvents } = API;
var { IssueNoteAwardEmojis } = API;
var { IssueNotes } = API;
var { Issues } = API;
var { IssuesStatistics } = API;
var { IssueStateEvents } = API;
var { IssueWeightEvents } = API;
var { JobArtifacts } = API;
var { Jobs } = API;
var { Keys } = API;
var { License } = API;
var { LicenseTemplates } = API;
var { LinkedEpics } = API;
var { Lint } = API;
var { Markdown } = API;
var { Maven } = API;
var { MergeRequestApprovals } = API;
var { MergeRequestAwardEmojis } = API;
var { MergeRequestContextCommits } = API;
var { MergeRequestDiscussions } = API;
var { MergeRequestDraftNotes } = API;
var { MergeRequestLabelEvents } = API;
var { MergeRequestMilestoneEvents } = API;
var { MergeRequestNoteAwardEmojis } = API;
var { MergeRequestNotes } = API;
var { MergeRequests } = API;
var { MergeTrains } = API;
var { Metadata } = API;
var { Migrations } = API;
var { Namespaces } = API;
var { NotificationSettings } = API;
var { NPM } = API;
var { NuGet } = API;
var { PackageRegistry } = API;
var { Packages } = API;
var { PagesDomains } = API;
var { PersonalAccessTokens } = API;
var { PipelineSchedules } = API;
var { PipelineScheduleVariables } = API;
var { Pipelines } = API;
var { PipelineTriggerTokens } = API;
var { ProductAnalytics } = API;
var { ProjectAccessRequests } = API;
var { ProjectAccessTokens } = API;
var { ProjectAliases } = API;
var { ProjectBadges } = API;
var { ProjectCustomAttributes } = API;
var { ProjectDORA4Metrics } = API;
var { ProjectHooks } = API;
var { ProjectImportExports } = API;
var { ProjectInvitations } = API;
var { ProjectIssueBoards } = API;
var { ProjectIterations } = API;
var { ProjectJobTokenScopes } = API;
var { ProjectLabels } = API;
var { ProjectMarkdownUploads } = API;
var { ProjectMembers } = API;
var { ProjectMilestones } = API;
var { ProjectProtectedEnvironments } = API;
var { ProjectPushRules } = API;
var { ProjectRelationsExport } = API;
var { ProjectReleases } = API;
var { ProjectRemoteMirrors } = API;
var { ProjectRepositoryStorageMoves } = API;
var { Projects } = API;
var { ProjectSnippetAwardEmojis } = API;
var { ProjectSnippetDiscussions } = API;
var { ProjectSnippetNotes } = API;
var { ProjectSnippets } = API;
var { ProjectStatistics } = API;
var { ProjectTemplates } = API;
var { ProjectTerraformState } = API;
var { ProjectVariables } = API;
var { ProjectVulnerabilities } = API;
var { ProjectWikis } = API;
var { ProtectedBranches } = API;
var { ProtectedTags } = API;
var { PyPI } = API;
var { ReleaseLinks } = API;
var { Repositories } = API;
var { RepositoryFiles } = API;
var { RepositorySubmodules } = API;
var { ResourceGroups } = API;
var { RubyGems } = API;
var { Runners } = API;
var { Search } = API;
var { SearchAdmin } = API;
var { SecureFiles } = API;
var { ServiceAccounts } = API;
var { ServiceData } = API;
var { SidekiqMetrics } = API;
var { SidekiqQueues } = API;
var { SnippetRepositoryStorageMoves } = API;
var { Snippets } = API;
var { Suggestions } = API;
var { SystemHooks } = API;
var { Tags } = API;
var { TodoLists } = API;
var { Topics } = API;
var { UserCustomAttributes } = API;
var { UserEmails } = API;
var { UserGPGKeys } = API;
var { UserImpersonationTokens } = API;
var { Users } = API;
var { UserSSHKeys } = API;
var { UserStarredMetricsDashboard } = API;
var { Gitlab } = API;

export { AccessLevel, Agents, AlertManagement, ApplicationAppearance, ApplicationPlanLimits, ApplicationSettings, ApplicationStatistics, Applications, AuditEvents, Avatar, Branches, BroadcastMessages, CodeSuggestions, CommitDiscussions, Commits, Composer, Conan, ContainerRegistry, DashboardAnnotations, Debian, DependencyProxy, DeployKeys, DeployTokens, Deployments, DockerfileTemplates, Environments, EpicAwardEmojis, EpicDiscussions, EpicIssues, EpicLabelEvents, EpicLinks, EpicNotes, Epics, ErrorTrackingClientKeys, ErrorTrackingSettings, Events, Experiments, ExternalStatusChecks, FeatureFlagUserLists, FeatureFlags, FreezePeriods, GeoNodes, GeoSites, GitLabCIYMLTemplates, GitignoreTemplates, Gitlab, GitlabPages, GoProxy, GroupAccessRequests, GroupAccessTokens, GroupActivityAnalytics, GroupBadges, GroupCustomAttributes, GroupDORA4Metrics, GroupEpicBoards, GroupHooks, GroupImportExports, GroupInvitations, GroupIssueBoards, GroupIterations, GroupLDAPLinks, GroupLabels, GroupMarkdownUploads, GroupMemberRoles, GroupMembers, GroupMilestones, GroupProtectedEnvironments, GroupPushRules, GroupRelationExports, GroupReleases, GroupRepositoryStorageMoves, GroupSAMLIdentities, GroupSAMLLinks, GroupSCIMIdentities, GroupServiceAccounts, GroupVariables, GroupWikis, Groups, Helm, Import, InstanceLevelCICDVariables, Integrations, IssueAwardEmojis, IssueDiscussions, IssueIterationEvents, IssueLabelEvents, IssueLinks, IssueMilestoneEvents, IssueNoteAwardEmojis, IssueNotes, IssueStateEvents, IssueWeightEvents, Issues, IssuesStatistics, JobArtifacts, Jobs, Keys, License, LicenseTemplates, LinkedEpics, Lint, Markdown, Maven, MergeRequestApprovals, MergeRequestAwardEmojis, MergeRequestContextCommits, MergeRequestDiscussions, MergeRequestDraftNotes, MergeRequestLabelEvents, MergeRequestMilestoneEvents, MergeRequestNoteAwardEmojis, MergeRequestNotes, MergeRequests, MergeTrains, Metadata, Migrations, NPM, Namespaces, NotificationSettings, NuGet, PackageRegistry, Packages, PagesDomains, PersonalAccessTokens, PipelineScheduleVariables, PipelineSchedules, PipelineTriggerTokens, Pipelines, ProductAnalytics, ProjectAccessRequests, ProjectAccessTokens, ProjectAliases, ProjectBadges, ProjectCustomAttributes, ProjectDORA4Metrics, ProjectHooks, ProjectImportExports, ProjectInvitations, ProjectIssueBoards, ProjectIterations, ProjectJobTokenScopes, ProjectLabels, ProjectMarkdownUploads, ProjectMembers, ProjectMilestones, ProjectProtectedEnvironments, ProjectPushRules, ProjectRelationsExport, ProjectReleases, ProjectRemoteMirrors, ProjectRepositoryStorageMoves, ProjectSnippetAwardEmojis, ProjectSnippetDiscussions, ProjectSnippetNotes, ProjectSnippets, ProjectStatistics, ProjectTemplates, ProjectTerraformState, ProjectVariables, ProjectVulnerabilities, ProjectWikis, Projects, ProtectedBranches, ProtectedTags, PyPI, ReleaseLinks, Repositories, RepositoryFiles, RepositorySubmodules, ResourceGroups, RubyGems, Runners, Search, SearchAdmin, SecureFiles, ServiceAccounts, ServiceData, SidekiqMetrics, SidekiqQueues, SnippetRepositoryStorageMoves, Snippets, Suggestions, SystemHooks, Tags, TodoLists, Topics, UserCustomAttributes, UserEmails, UserGPGKeys, UserImpersonationTokens, UserSSHKeys, UserStarredMetricsDashboard, Users };
