import { TypedDocumentNode as DocumentNode } from "@graphql-typed-document-node/core";
export declare type Maybe<T> = T | null;
export declare type Exact<T extends {
    [key: string]: unknown;
}> = {
    [K in keyof T]: T[K];
};
export declare type MakeOptional<T, K extends keyof T> = Omit<T, K> & {
    [SubKey in K]?: Maybe<T[SubKey]>;
};
export declare type MakeMaybe<T, K extends keyof T> = Omit<T, K> & {
    [SubKey in K]: Maybe<T[SubKey]>;
};
/** All built-in and custom scalars, mapped to their actual values */
export declare type Scalars = {
    ID: string;
    String: string;
    Boolean: boolean;
    Int: number;
    Float: number;
    /** Represents a date and time in ISO 8601 format. Accepts shortcuts like `2021` to represent midnight Fri Jan 01 2021. Also accepts ISO 8601 durations strings which are added to the current date to create the represented date (e.g '-P2W1D' represents the date that was two weeks and 1 day ago) */
    DateTime: Date;
    /** Represents a date and time in ISO 8601 format. Accepts shortcuts like `2021` to represent midnight Fri Jan 01 2021. Also accepts ISO 8601 durations strings which are added to the current date to create the represented date (e.g '-P2W1D' represents the date that was two weeks and 1 day ago) */
    DateTimeOrDuration: Date | string;
    /** Represents a duration in ISO 8601 format. Accepts ISO 8601 duration strings or integers in milliseconds. */
    Duration: any;
    /** The `JSON` scalar type represents arbitrary values as *stringified* JSON */
    JSON: Record<string, unknown>;
    /** The `JSONObject` scalar type represents arbitrary values as *embedded* JSON */
    JSONObject: any;
    /** Represents a date in ISO 8601 format. Accepts shortcuts like `2021` to represent midnight Fri Jan 01 2021. Also accepts ISO 8601 durations strings which are added to the current date to create the represented date (e.g '-P2W1D' represents the date that was two weeks and 1 day ago) */
    TimelessDate: any;
    /** Represents a date in ISO 8601 format or a duration. Accepts shortcuts like `2021` to represent midnight Fri Jan 01 2021. Also accepts ISO 8601 durations strings (e.g '-P2W1D'), which are not converted to dates. */
    TimelessDateOrDuration: any;
    /** A universally unique identifier as specified by RFC 4122. */
    UUID: any;
};
/** A bot actor is an actor that is not a user, but an application or integration. */
export declare type ActorBot = {
    __typename?: "ActorBot";
    /** A url pointing to the avatar representing this bot. */
    avatarUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["ID"]>;
    /** The display name of the bot. */
    name?: Maybe<Scalars["String"]>;
    /** The sub type of the bot. */
    subType?: Maybe<Scalars["String"]>;
    /** The type of bot. */
    type: Scalars["String"];
    /** The display name of the external user on behalf of which the bot acted. */
    userDisplayName?: Maybe<Scalars["String"]>;
};
export declare type AirbyteConfigurationInput = {
    /** Linear export API key. */
    apiKey: Scalars["String"];
};
/** An API key. Grants access to the user's resources. */
export declare type ApiKey = Node & {
    __typename?: "ApiKey";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The label of the API key. */
    label: Scalars["String"];
    /** The sync groups that this API key requests access to. If null, the API key has access to all sync groups the user has access to. The final set of sync groups is computed as the intersection of these requested groups with the user's base sync groups. */
    requestedSyncGroups?: Maybe<Array<Scalars["String"]>>;
    /** Scopes associated with the API key. */
    scope?: Maybe<Array<Scalars["String"]>>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type ApiKeyConnection = {
    __typename?: "ApiKeyConnection";
    edges: Array<ApiKeyEdge>;
    nodes: Array<ApiKey>;
    pageInfo: PageInfo;
};
export declare type ApiKeyCreateInput = {
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The API key value. */
    key: Scalars["String"];
    /** The label for the API key. */
    label: Scalars["String"];
    /** Scopes the API key has access to. Default is all scopes. */
    scope?: Maybe<Array<Scalars["String"]>>;
    /** List of team IDs to restrict this API key to. Default is all teams the user has access to. */
    teamIds?: Maybe<Array<Scalars["String"]>>;
};
export declare type ApiKeyEdge = {
    __typename?: "ApiKeyEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: ApiKey;
};
export declare type ApiKeyPayload = {
    __typename?: "ApiKeyPayload";
    /** The API key that was created. */
    apiKey: ApiKey;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type ApiKeyUpdateInput = {
    /** The new label for the API key. */
    label?: Maybe<Scalars["String"]>;
    /** Scopes the API key has access to. Default is all scopes. */
    scope?: Maybe<Array<Scalars["String"]>>;
    /** List of team IDs to restrict this API key to. Default is all teams the user has access to. */
    teamIds?: Maybe<Array<Scalars["String"]>>;
};
/** [INTERNAL] Details of the app user's existing token. */
export declare type AppUserAuthentication = {
    __typename?: "AppUserAuthentication";
    /** The user that authorized the application, if known. */
    authorizingUser?: Maybe<AuthorizingUser>;
    /** The timestamp at which the token was created. */
    createdAt: Scalars["DateTime"];
    /** Whether the application has requested custom sync groups. */
    requestedSyncGroups: Scalars["Boolean"];
    /** The scopes that the token has. */
    scope: Array<Scalars["String"]>;
};
/** Public information of the OAuth application. */
export declare type Application = {
    __typename?: "Application";
    /** OAuth application's client ID. */
    clientId: Scalars["String"];
    /** Information about the application. */
    description?: Maybe<Scalars["String"]>;
    /** Name of the developer. */
    developer: Scalars["String"];
    /** Url of the developer (homepage or docs). */
    developerUrl: Scalars["String"];
    /** OAuth application's ID. */
    id: Scalars["String"];
    /** Image of the application. */
    imageUrl?: Maybe<Scalars["String"]>;
    /** Application name. */
    name: Scalars["String"];
};
/** Customer approximate need count sorting options. */
export declare type ApproximateNeedCountSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
/** A generic payload return from entity archive or deletion mutations. */
export declare type ArchivePayload = {
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** Contains requested archived model objects. */
export declare type ArchiveResponse = {
    __typename?: "ArchiveResponse";
    /** A JSON serialized collection of model objects loaded from the archive */
    archive: Scalars["String"];
    /** The version of the remote database. Incremented by 1 for each migration run on the database. */
    databaseVersion: Scalars["Float"];
    /** Whether the dependencies for the model objects are included in the archive. */
    includesDependencies: Array<Scalars["String"]>;
    /** The total number of entities in the archive. */
    totalCount: Scalars["Float"];
};
export declare type AsksChannelConnectPayload = {
    __typename?: "AsksChannelConnectPayload";
    /** Whether the bot needs to be manually added to the channel. */
    addBot: Scalars["Boolean"];
    /** The integration that was created or updated. */
    integration?: Maybe<Integration>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** The new Asks Slack channel mapping for the connected channel. */
    mapping: SlackChannelNameMapping;
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** Issue assignee sorting options. */
export declare type AssigneeSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
/** Issue attachment (e.g. support ticket, pull request). */
export declare type Attachment = Node & {
    __typename?: "Attachment";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The body data of the attachment, if any. */
    bodyData?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The creator of the attachment. */
    creator?: Maybe<User>;
    /** The non-Linear user who created the attachment. */
    externalUserCreator?: Maybe<ExternalUser>;
    /** Indicates if attachments for the same source application should be grouped in the Linear UI. */
    groupBySource: Scalars["Boolean"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The issue this attachment belongs to. */
    issue: Issue;
    /** Custom metadata related to the attachment. */
    metadata: Scalars["JSONObject"];
    /** Information about the source which created the attachment. */
    source?: Maybe<Scalars["JSONObject"]>;
    /** An accessor helper to source.type, defines the source type of the attachment. */
    sourceType?: Maybe<Scalars["String"]>;
    /** Content for the subtitle line in the Linear attachment widget. */
    subtitle?: Maybe<Scalars["String"]>;
    /** Content for the title line in the Linear attachment widget. */
    title: Scalars["String"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** Location of the attachment which is also used as an identifier. */
    url: Scalars["String"];
};
/** Attachment collection filtering options. */
export declare type AttachmentCollectionFilter = {
    /** Compound filters, all of which need to be matched by the attachment. */
    and?: Maybe<Array<AttachmentCollectionFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the attachments creator must satisfy. */
    creator?: Maybe<NullableUserFilter>;
    /** Filters that needs to be matched by all attachments. */
    every?: Maybe<AttachmentFilter>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the collection length. */
    length?: Maybe<NumberComparator>;
    /** Compound filters, one of which need to be matched by the attachment. */
    or?: Maybe<Array<AttachmentCollectionFilter>>;
    /** Filters that needs to be matched by some attachments. */
    some?: Maybe<AttachmentFilter>;
    /** Comparator for the source type. */
    sourceType?: Maybe<SourceTypeComparator>;
    /** Comparator for the subtitle. */
    subtitle?: Maybe<NullableStringComparator>;
    /** Comparator for the title. */
    title?: Maybe<StringComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
    /** Comparator for the url. */
    url?: Maybe<StringComparator>;
};
export declare type AttachmentConnection = {
    __typename?: "AttachmentConnection";
    edges: Array<AttachmentEdge>;
    nodes: Array<Attachment>;
    pageInfo: PageInfo;
};
export declare type AttachmentCreateInput = {
    /** Create a linked comment with markdown body. */
    commentBody?: Maybe<Scalars["String"]>;
    /** [Internal] Create a linked comment with Prosemirror body. Please use `commentBody` instead. */
    commentBodyData?: Maybe<Scalars["JSONObject"]>;
    /** Create attachment as a user with the provided name. This option is only available to OAuth applications creating attachments in `actor=application` mode. */
    createAsUser?: Maybe<Scalars["String"]>;
    /** Indicates if attachments for the same source application should be grouped in the Linear UI. */
    groupBySource?: Maybe<Scalars["Boolean"]>;
    /** An icon url to display with the attachment. Should be of jpg or png format. Maximum of 1MB in size. Dimensions should be 20x20px for optimal display quality. */
    iconUrl?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The issue to associate the attachment with. */
    issueId: Scalars["String"];
    /** Attachment metadata object with string and number values. */
    metadata?: Maybe<Scalars["JSONObject"]>;
    /** The attachment subtitle. */
    subtitle?: Maybe<Scalars["String"]>;
    /** The attachment title. */
    title: Scalars["String"];
    /** Attachment location which is also used as an unique identifier for the attachment. If another attachment is created with the same `url` value, existing record is updated instead. */
    url: Scalars["String"];
};
export declare type AttachmentEdge = {
    __typename?: "AttachmentEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: Attachment;
};
/** Attachment filtering options. */
export declare type AttachmentFilter = {
    /** Compound filters, all of which need to be matched by the attachment. */
    and?: Maybe<Array<AttachmentFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the attachments creator must satisfy. */
    creator?: Maybe<NullableUserFilter>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Compound filters, one of which need to be matched by the attachment. */
    or?: Maybe<Array<AttachmentFilter>>;
    /** Comparator for the source type. */
    sourceType?: Maybe<SourceTypeComparator>;
    /** Comparator for the subtitle. */
    subtitle?: Maybe<NullableStringComparator>;
    /** Comparator for the title. */
    title?: Maybe<StringComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
    /** Comparator for the url. */
    url?: Maybe<StringComparator>;
};
export declare type AttachmentPayload = {
    __typename?: "AttachmentPayload";
    /** The issue attachment that was created. */
    attachment: Attachment;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type AttachmentSourcesPayload = {
    __typename?: "AttachmentSourcesPayload";
    /** A unique list of all source types used in this workspace. */
    sources: Scalars["JSONObject"];
};
export declare type AttachmentUpdateInput = {
    /** An icon url to display with the attachment. Should be of jpg or png format. Maximum of 1MB in size. Dimensions should be 20x20px for optimal display quality. */
    iconUrl?: Maybe<Scalars["String"]>;
    /** Attachment metadata object with string and number values. */
    metadata?: Maybe<Scalars["JSONObject"]>;
    /** The attachment subtitle. */
    subtitle?: Maybe<Scalars["String"]>;
    /** The attachment title. */
    title: Scalars["String"];
};
/** Workspace audit log entry object. */
export declare type AuditEntry = Node & {
    __typename?: "AuditEntry";
    /** The user that caused the audit entry to be created. */
    actor?: Maybe<User>;
    /** The ID of the user that caused the audit entry to be created. */
    actorId?: Maybe<Scalars["String"]>;
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** Country code of request resulting to audit entry. */
    countryCode?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** IP from actor when entry was recorded. */
    ip?: Maybe<Scalars["String"]>;
    /** Additional metadata related to the audit entry. */
    metadata?: Maybe<Scalars["JSONObject"]>;
    /** The organization the audit log belongs to. */
    organization?: Maybe<Organization>;
    /** Additional information related to the request which performed the action. */
    requestInformation?: Maybe<Scalars["JSONObject"]>;
    type: Scalars["String"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type AuditEntryConnection = {
    __typename?: "AuditEntryConnection";
    edges: Array<AuditEntryEdge>;
    nodes: Array<AuditEntry>;
    pageInfo: PageInfo;
};
export declare type AuditEntryEdge = {
    __typename?: "AuditEntryEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: AuditEntry;
};
/** Audit entry filtering options. */
export declare type AuditEntryFilter = {
    /** Filters that the audit entry actor must satisfy. */
    actor?: Maybe<NullableUserFilter>;
    /** Compound filters, all of which need to be matched by the issue. */
    and?: Maybe<Array<AuditEntryFilter>>;
    /** Comparator for the country code. */
    countryCode?: Maybe<StringComparator>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the IP address. */
    ip?: Maybe<StringComparator>;
    /** Compound filters, one of which need to be matched by the issue. */
    or?: Maybe<Array<AuditEntryFilter>>;
    /** Comparator for the type. */
    type?: Maybe<StringComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type AuditEntryType = {
    __typename?: "AuditEntryType";
    /** Description of the audit entry type. */
    description: Scalars["String"];
    /** The audit entry type. */
    type: Scalars["String"];
};
/** [INTERNAL] An OAuth userId/createdDate tuple */
export declare type AuthMembership = {
    __typename?: "AuthMembership";
    /** The user ID associated with the authorization */
    authorizingUserId?: Maybe<Scalars["String"]>;
    /** The date of the authorization */
    createdAt: Scalars["DateTime"];
    /** The user ID the authorization was done for */
    userId: Scalars["String"];
};
/** An organization. Organizations are root-level objects that contain users and teams. */
export declare type AuthOrganization = {
    __typename?: "AuthOrganization";
    /** Allowed authentication providers, empty array means all are allowed */
    allowedAuthServices: Array<Scalars["String"]>;
    /** The time at which deletion of the organization was requested. */
    deletionRequestedAt?: Maybe<Scalars["DateTime"]>;
    /** Whether the organization is enabled. Used as a superuser tool to lock down the org. */
    enabled: Scalars["Boolean"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The organization's logo URL. */
    logoUrl?: Maybe<Scalars["String"]>;
    /** The organization's name. */
    name: Scalars["String"];
    /** Previously used URL keys for the organization (last 3 are kept and redirected). */
    previousUrlKeys: Array<Scalars["String"]>;
    /** The region the organization is hosted in. */
    region: Scalars["String"];
    /** The feature release channel the organization belongs to. */
    releaseChannel: ReleaseChannel;
    /** Whether SAML authentication is enabled for organization. */
    samlEnabled: Scalars["Boolean"];
    /** [INTERNAL] SAML settings */
    samlSettings?: Maybe<Scalars["JSONObject"]>;
    /** Whether SCIM provisioning is enabled for organization. */
    scimEnabled: Scalars["Boolean"];
    /** The email domain or URL key for the organization. */
    serviceId: Scalars["String"];
    /** The organization's unique URL key. */
    urlKey: Scalars["String"];
    userCount: Scalars["Float"];
};
export declare type AuthResolverResponse = {
    __typename?: "AuthResolverResponse";
    /** Should the signup flow allow access for the domain. */
    allowDomainAccess?: Maybe<Scalars["Boolean"]>;
    /** List of organizations allowing this user account to join automatically. */
    availableOrganizations?: Maybe<Array<AuthOrganization>>;
    /** Email for the authenticated account. */
    email: Scalars["String"];
    /** User account ID. */
    id: Scalars["String"];
    /** ID of the organization last accessed by the user. */
    lastUsedOrganizationId?: Maybe<Scalars["String"]>;
    /** List of organization available to this user account but locked due to the current auth method. */
    lockedOrganizations?: Maybe<Array<AuthOrganization>>;
    /** List of locked users that are locked by login restrictions */
    lockedUsers: Array<AuthUser>;
    /**
     * Application token.
     * @deprecated Deprecated and not used anymore. Never populated.
     */
    token?: Maybe<Scalars["String"]>;
    /** List of active users that belong to the user account. */
    users: Array<AuthUser>;
};
/** A user that has access to the the resources of an organization. */
export declare type AuthUser = {
    __typename?: "AuthUser";
    /** Whether the user is active. */
    active: Scalars["Boolean"];
    /** An URL to the user's avatar image. */
    avatarUrl?: Maybe<Scalars["String"]>;
    /** The user's display (nick) name. Unique within each organization. */
    displayName: Scalars["String"];
    /** The user's email address. */
    email: Scalars["String"];
    id: Scalars["ID"];
    /** The user's full name. */
    name: Scalars["String"];
    /** Organization the user belongs to. */
    organization: AuthOrganization;
    /** Whether the user is an organization admin or guest on a database level. */
    role: UserRoleType;
    /** User account ID the user belongs to. */
    userAccountId: Scalars["String"];
};
/** Authentication session information. */
export declare type AuthenticationSessionResponse = {
    __typename?: "AuthenticationSessionResponse";
    /** Used web browser. */
    browserType?: Maybe<Scalars["String"]>;
    /** Client used for the session */
    client?: Maybe<Scalars["String"]>;
    /** Country codes of all seen locations. */
    countryCodes: Array<Scalars["String"]>;
    /** Date when the session was created. */
    createdAt: Scalars["DateTime"];
    id: Scalars["String"];
    /** IP address. */
    ip?: Maybe<Scalars["String"]>;
    /** Identifies the session used to make the request. */
    isCurrentSession: Scalars["Boolean"];
    /** When was the session last seen */
    lastActiveAt?: Maybe<Scalars["DateTime"]>;
    /** Human readable location */
    location?: Maybe<Scalars["String"]>;
    /** Location city name. */
    locationCity?: Maybe<Scalars["String"]>;
    /** Location country name. */
    locationCountry?: Maybe<Scalars["String"]>;
    /** Location country code. */
    locationCountryCode?: Maybe<Scalars["String"]>;
    /** Location region code. */
    locationRegionCode?: Maybe<Scalars["String"]>;
    /** Name of the session, derived from the client and operating system */
    name: Scalars["String"];
    /** Operating system used for the session */
    operatingSystem?: Maybe<Scalars["String"]>;
    /** Service used for logging in. */
    service?: Maybe<Scalars["String"]>;
    /** Type of application used to authenticate. */
    type: AuthenticationSessionType;
    /** Date when the session was last updated. */
    updatedAt: Scalars["DateTime"];
    /** Session's user-agent. */
    userAgent?: Maybe<Scalars["String"]>;
};
export declare enum AuthenticationSessionType {
    Android = "android",
    Desktop = "desktop",
    Ios = "ios",
    Web = "web"
}
/** [INTERNAL] Public information of the OAuth application, plus the authorized scopes for a given user. */
export declare type AuthorizedApplication = {
    __typename?: "AuthorizedApplication";
    /** OAuth application's ID. */
    appId: Scalars["String"];
    /** OAuth application's client ID. */
    clientId: Scalars["String"];
    /** Description of the application. */
    description?: Maybe<Scalars["String"]>;
    /** Developer of the application. */
    developer?: Maybe<Scalars["String"]>;
    /** Developer URL of the application. */
    developerUrl?: Maybe<Scalars["String"]>;
    /** Image of the application. */
    imageUrl?: Maybe<Scalars["String"]>;
    /** Application name. */
    name: Scalars["String"];
    /** Scopes that are authorized for this application for a given user. */
    scope: Array<Scalars["String"]>;
    /** Whether or not webhooks are enabled for the application. */
    webhooksEnabled: Scalars["Boolean"];
};
/** Details of the app user's authorizing user. */
export declare type AuthorizingUser = {
    __typename?: "AuthorizingUser";
    /** The user's display name. */
    displayName: Scalars["String"];
    /** The user's full name. */
    name: Scalars["String"];
};
/** Comparator for booleans. */
export declare type BooleanComparator = {
    /** Equals constraint. */
    eq?: Maybe<Scalars["Boolean"]>;
    /** Not equals constraint. */
    neq?: Maybe<Scalars["Boolean"]>;
};
/** A comment associated with an issue. */
export declare type Comment = Node & {
    __typename?: "Comment";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The comment content in markdown format. */
    body: Scalars["String"];
    /** [Internal] The comment content as a Prosemirror document. */
    bodyData: Scalars["String"];
    /** The bot that created the comment. */
    botActor?: Maybe<ActorBot>;
    /** The children of the comment. */
    children: CommentConnection;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The document content that the comment is associated with. */
    documentContent?: Maybe<DocumentContent>;
    /** The time user edited the comment. */
    editedAt?: Maybe<Scalars["DateTime"]>;
    /** The external thread that the comment is synced with. */
    externalThread?: Maybe<SyncedExternalThread>;
    /** The external user who wrote the comment. */
    externalUser?: Maybe<ExternalUser>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The initiative update that the comment is associated with. */
    initiativeUpdate?: Maybe<InitiativeUpdate>;
    /** The issue that the comment is associated with. */
    issue?: Maybe<Issue>;
    /** The parent comment under which the current comment is nested. */
    parent?: Maybe<Comment>;
    /** The post that the comment is associated with. */
    post?: Maybe<Post>;
    /** The project update that the comment is associated with. */
    projectUpdate?: Maybe<ProjectUpdate>;
    /** The text that this comment references. Only defined for inline comments. */
    quotedText?: Maybe<Scalars["String"]>;
    /** Emoji reaction summary, grouped by emoji type. */
    reactionData: Scalars["JSONObject"];
    /** Reactions associated with the comment. */
    reactions: Array<Reaction>;
    /** The time the resolvingUser resolved the thread. */
    resolvedAt?: Maybe<Scalars["DateTime"]>;
    /** The comment that resolved the thread. */
    resolvingComment?: Maybe<Comment>;
    /** The user that resolved the thread. */
    resolvingUser?: Maybe<User>;
    /** [Internal] A generated summary of the comment thread. */
    threadSummary?: Maybe<Scalars["JSONObject"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** Comment's URL. */
    url: Scalars["String"];
    /** The user who wrote the comment. */
    user?: Maybe<User>;
};
/** A comment associated with an issue. */
export declare type CommentChildrenArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CommentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** Comment filtering options. */
export declare type CommentCollectionFilter = {
    /** Compound filters, all of which need to be matched by the comment. */
    and?: Maybe<Array<CommentCollectionFilter>>;
    /** Comparator for the comment's body. */
    body?: Maybe<StringComparator>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the comment's document content must satisfy. */
    documentContent?: Maybe<NullableDocumentContentFilter>;
    /** Filters that needs to be matched by all comments. */
    every?: Maybe<CommentFilter>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Filters that the comment's issue must satisfy. */
    issue?: Maybe<NullableIssueFilter>;
    /** Comparator for the collection length. */
    length?: Maybe<NumberComparator>;
    /** Filters that the comment's customer needs must satisfy. */
    needs?: Maybe<CustomerNeedCollectionFilter>;
    /** Compound filters, one of which need to be matched by the comment. */
    or?: Maybe<Array<CommentCollectionFilter>>;
    /** Filters that the comment parent must satisfy. */
    parent?: Maybe<NullableCommentFilter>;
    /** Filters that the comment's project update must satisfy. */
    projectUpdate?: Maybe<NullableProjectUpdateFilter>;
    /** Filters that the comment's reactions must satisfy. */
    reactions?: Maybe<ReactionCollectionFilter>;
    /** Filters that needs to be matched by some comments. */
    some?: Maybe<CommentFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
    /** Filters that the comment's creator must satisfy. */
    user?: Maybe<UserFilter>;
};
export declare type CommentConnection = {
    __typename?: "CommentConnection";
    edges: Array<CommentEdge>;
    nodes: Array<Comment>;
    pageInfo: PageInfo;
};
export declare type CommentCreateInput = {
    /** The comment content in markdown format. */
    body?: Maybe<Scalars["String"]>;
    /** [Internal] The comment content as a Prosemirror document. */
    bodyData?: Maybe<Scalars["JSON"]>;
    /** Create comment as a user with the provided name. This option is only available to OAuth applications creating comments in `actor=application` mode. */
    createAsUser?: Maybe<Scalars["String"]>;
    /** Flag to indicate this comment should be created on the issue's synced Slack comment thread. If no synced Slack comment thread exists, the mutation will fail. */
    createOnSyncedSlackThread?: Maybe<Scalars["Boolean"]>;
    /** The date when the comment was created (e.g. if importing from another system). Must be a date in the past. If none is provided, the backend will generate the time as now. */
    createdAt?: Maybe<Scalars["DateTime"]>;
    /** Provide an external user avatar URL. Can only be used in conjunction with the `createAsUser` options. This option is only available to OAuth applications creating comments in `actor=application` mode. */
    displayIconUrl?: Maybe<Scalars["String"]>;
    /** Flag to prevent auto subscription to the issue the comment is created on. */
    doNotSubscribeToIssue?: Maybe<Scalars["Boolean"]>;
    /** The document content to associate the comment with. */
    documentContentId?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The initiative update to associate the comment with. */
    initiativeUpdateId?: Maybe<Scalars["String"]>;
    /** The issue to associate the comment with. */
    issueId?: Maybe<Scalars["String"]>;
    /** The parent comment under which to nest a current comment. */
    parentId?: Maybe<Scalars["String"]>;
    /** The post to associate the comment with. */
    postId?: Maybe<Scalars["String"]>;
    /** The project update to associate the comment with. */
    projectUpdateId?: Maybe<Scalars["String"]>;
    /** The text that this comment references. Only defined for inline comments. */
    quotedText?: Maybe<Scalars["String"]>;
    /** [INTERNAL] The identifiers of the users subscribing to this comment thread. */
    subscriberIds?: Maybe<Array<Scalars["String"]>>;
};
export declare type CommentEdge = {
    __typename?: "CommentEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: Comment;
};
/** Comment filtering options. */
export declare type CommentFilter = {
    /** Compound filters, all of which need to be matched by the comment. */
    and?: Maybe<Array<CommentFilter>>;
    /** Comparator for the comment's body. */
    body?: Maybe<StringComparator>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the comment's document content must satisfy. */
    documentContent?: Maybe<NullableDocumentContentFilter>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Filters that the comment's issue must satisfy. */
    issue?: Maybe<NullableIssueFilter>;
    /** Filters that the comment's customer needs must satisfy. */
    needs?: Maybe<CustomerNeedCollectionFilter>;
    /** Compound filters, one of which need to be matched by the comment. */
    or?: Maybe<Array<CommentFilter>>;
    /** Filters that the comment parent must satisfy. */
    parent?: Maybe<NullableCommentFilter>;
    /** Filters that the comment's project update must satisfy. */
    projectUpdate?: Maybe<NullableProjectUpdateFilter>;
    /** Filters that the comment's reactions must satisfy. */
    reactions?: Maybe<ReactionCollectionFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
    /** Filters that the comment's creator must satisfy. */
    user?: Maybe<UserFilter>;
};
export declare type CommentPayload = {
    __typename?: "CommentPayload";
    /** The comment that was created or updated. */
    comment: Comment;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type CommentUpdateInput = {
    /** The comment content. */
    body?: Maybe<Scalars["String"]>;
    /** [Internal] The comment content as a Prosemirror document. */
    bodyData?: Maybe<Scalars["JSON"]>;
    /** [INTERNAL] Flag to prevent auto subscription to the issue the comment is updated on. */
    doNotSubscribeToIssue?: Maybe<Scalars["Boolean"]>;
    /** The text that this comment references. Only defined for inline comments. */
    quotedText?: Maybe<Scalars["String"]>;
    /** [INTERNAL] The child comment that resolves this thread. */
    resolvingCommentId?: Maybe<Scalars["String"]>;
    /** [INTERNAL] The user who resolved this thread. */
    resolvingUserId?: Maybe<Scalars["String"]>;
    /** [INTERNAL] The identifiers of the users subscribing to this comment. */
    subscriberIds?: Maybe<Array<Scalars["String"]>>;
};
/** Issue completion date sorting options. */
export declare type CompletedAtSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
export declare type ContactCreateInput = {
    /** User's browser information. */
    browser?: Maybe<Scalars["String"]>;
    /** User's Linear client information. */
    clientVersion?: Maybe<Scalars["String"]>;
    /** User's device information. */
    device?: Maybe<Scalars["String"]>;
    /** How disappointed the user would be if they could no longer use Linear. */
    disappointmentRating?: Maybe<Scalars["Int"]>;
    /** The message the user sent. */
    message: Scalars["String"];
    /** User's operating system. */
    operatingSystem?: Maybe<Scalars["String"]>;
    /** The type of support contact. */
    type: Scalars["String"];
};
export declare type ContactPayload = {
    __typename?: "ContactPayload";
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** [INTERNAL] Input for sending a message to the Linear Sales team. */
export declare type ContactSalesCreateInput = {
    /** Size of the company. */
    companySize?: Maybe<Scalars["String"]>;
    /** Work email of the person requesting information. */
    email: Scalars["String"];
    /** The message the user sent. */
    message?: Maybe<Scalars["String"]>;
    /** Name of the person requesting information. */
    name: Scalars["String"];
};
/** [Internal] Comparator for content. */
export declare type ContentComparator = {
    /** [Internal] Contains constraint. */
    contains?: Maybe<Scalars["String"]>;
    /** [Internal] Not-contains constraint. */
    notContains?: Maybe<Scalars["String"]>;
};
export declare enum ContextViewType {
    ActiveCycle = "activeCycle",
    ActiveIssues = "activeIssues",
    Backlog = "backlog",
    Triage = "triage",
    UpcomingCycle = "upcomingCycle"
}
export declare type CreateCsvExportReportPayload = {
    __typename?: "CreateCsvExportReportPayload";
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type CreateOrJoinOrganizationResponse = {
    __typename?: "CreateOrJoinOrganizationResponse";
    organization: AuthOrganization;
    user: AuthUser;
};
export declare type CreateOrganizationInput = {
    /** Whether the organization should allow email domain access. */
    domainAccess?: Maybe<Scalars["Boolean"]>;
    /** The name of the organization. */
    name: Scalars["String"];
    /** The timezone of the organization, passed in by client. */
    timezone?: Maybe<Scalars["String"]>;
    /** The URL key of the organization. */
    urlKey: Scalars["String"];
    /** JSON serialized UTM parameters associated with the creation of the workspace. */
    utm?: Maybe<Scalars["String"]>;
};
/** Issue creation date sorting options. */
export declare type CreatedAtSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
/** A custom view that has been saved by a user. */
export declare type CustomView = Node & {
    __typename?: "CustomView";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The color of the icon of the custom view. */
    color?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who created the custom view. */
    creator: User;
    /** The description of the custom view. */
    description?: Maybe<Scalars["String"]>;
    /** The filter applied to feed items in the custom view. */
    feedItemFilterData?: Maybe<Scalars["JSONObject"]>;
    /** The filter applied to issues in the custom view. */
    filterData: Scalars["JSONObject"];
    /**
     * The filters applied to issues in the custom view.
     * @deprecated Will be replaced by `filterData` in a future update
     */
    filters: Scalars["JSONObject"];
    /** The icon of the custom view. */
    icon?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** Issues associated with the custom view. */
    issues: IssueConnection;
    /** The model name of the custom view. */
    modelName: Scalars["String"];
    /** The name of the custom view. */
    name: Scalars["String"];
    /** The organization of the custom view. */
    organization: Organization;
    /** The organizations default view preferences for this custom view. */
    organizationViewPreferences?: Maybe<ViewPreferences>;
    /** The user who owns the custom view. */
    owner: User;
    /** The filter applied to projects in the custom view. */
    projectFilterData?: Maybe<Scalars["JSONObject"]>;
    /** Projects associated with the custom view. */
    projects: ProjectConnection;
    /** Whether the custom view is shared with everyone in the organization. */
    shared: Scalars["Boolean"];
    /** The custom view's unique URL slug. */
    slugId?: Maybe<Scalars["String"]>;
    /** The team associated with the custom view. */
    team?: Maybe<Team>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The user who last updated the custom view. */
    updatedBy?: Maybe<User>;
    /** The current users view preferences for this custom view. */
    userViewPreferences?: Maybe<ViewPreferences>;
    /** The calculated view preferences values for this custom view. */
    viewPreferencesValues?: Maybe<ViewPreferencesValues>;
};
/** A custom view that has been saved by a user. */
export declare type CustomViewIssuesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
    sort?: Maybe<Array<IssueSortInput>>;
};
/** A custom view that has been saved by a user. */
export declare type CustomViewProjectsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type CustomViewConnection = {
    __typename?: "CustomViewConnection";
    edges: Array<CustomViewEdge>;
    nodes: Array<CustomView>;
    pageInfo: PageInfo;
};
export declare type CustomViewCreateInput = {
    /** The color of the icon of the custom view. */
    color?: Maybe<Scalars["String"]>;
    /** The description of the custom view. */
    description?: Maybe<Scalars["String"]>;
    /** The feed item filter applied to issues in the custom view. */
    feedItemFilterData?: Maybe<FeedItemFilter>;
    /** The filter applied to issues in the custom view. */
    filterData?: Maybe<IssueFilter>;
    /** The icon of the custom view. */
    icon?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The id of the initiative associated with the custom view. */
    initiativeId?: Maybe<Scalars["String"]>;
    /** The name of the custom view. */
    name: Scalars["String"];
    /** The owner of the custom view. */
    ownerId?: Maybe<Scalars["String"]>;
    /** The project filter applied to issues in the custom view. */
    projectFilterData?: Maybe<ProjectFilter>;
    /** The id of the project associated with the custom view. */
    projectId?: Maybe<Scalars["String"]>;
    /** Whether the custom view is shared with everyone in the organization. */
    shared?: Maybe<Scalars["Boolean"]>;
    /** The id of the team associated with the custom view. */
    teamId?: Maybe<Scalars["String"]>;
};
export declare type CustomViewEdge = {
    __typename?: "CustomViewEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: CustomView;
};
export declare type CustomViewHasSubscribersPayload = {
    __typename?: "CustomViewHasSubscribersPayload";
    /** Whether the custom view has subscribers. */
    hasSubscribers: Scalars["Boolean"];
};
/** A custom view notification subscription. */
export declare type CustomViewNotificationSubscription = Entity & Node & NotificationSubscription & {
    __typename?: "CustomViewNotificationSubscription";
    /** Whether the subscription is active or not. */
    active: Scalars["Boolean"];
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The type of view to which the notification subscription context is associated with. */
    contextViewType?: Maybe<ContextViewType>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The custom view subscribed to. */
    customView: CustomView;
    /** The customer associated with the notification subscription. */
    customer?: Maybe<Customer>;
    /** The contextual cycle view associated with the notification subscription. */
    cycle?: Maybe<Cycle>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The contextual initiative view associated with the notification subscription. */
    initiative?: Maybe<Initiative>;
    /** The contextual label view associated with the notification subscription. */
    label?: Maybe<IssueLabel>;
    /** The type of subscription. */
    notificationSubscriptionTypes: Array<Scalars["String"]>;
    /** The contextual project view associated with the notification subscription. */
    project?: Maybe<Project>;
    /** The user that subscribed to receive notifications. */
    subscriber: User;
    /** The team associated with the notification subscription. */
    team?: Maybe<Team>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The user view associated with the notification subscription. */
    user?: Maybe<User>;
    /** The type of user view to which the notification subscription context is associated with. */
    userContextViewType?: Maybe<UserContextViewType>;
};
export declare type CustomViewPayload = {
    __typename?: "CustomViewPayload";
    /** The custom view that was created or updated. */
    customView: CustomView;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type CustomViewSuggestionPayload = {
    __typename?: "CustomViewSuggestionPayload";
    /** The suggested view description. */
    description?: Maybe<Scalars["String"]>;
    /** The suggested view icon. */
    icon?: Maybe<Scalars["String"]>;
    /** The suggested view name. */
    name?: Maybe<Scalars["String"]>;
};
export declare type CustomViewUpdateInput = {
    /** The color of the icon of the custom view. */
    color?: Maybe<Scalars["String"]>;
    /** The description of the custom view. */
    description?: Maybe<Scalars["String"]>;
    /** The feed item filter applied to issues in the custom view. */
    feedItemFilterData?: Maybe<FeedItemFilter>;
    /** The filter applied to issues in the custom view. */
    filterData?: Maybe<IssueFilter>;
    /** The icon of the custom view. */
    icon?: Maybe<Scalars["String"]>;
    /** [Internal] The id of the initiative associated with the custom view. */
    initiativeId?: Maybe<Scalars["String"]>;
    /** The name of the custom view. */
    name?: Maybe<Scalars["String"]>;
    /** The owner of the custom view. */
    ownerId?: Maybe<Scalars["String"]>;
    /** The project filter applied to issues in the custom view. */
    projectFilterData?: Maybe<ProjectFilter>;
    /** [Internal] The id of the project associated with the custom view. */
    projectId?: Maybe<Scalars["String"]>;
    /** Whether the custom view is shared with everyone in the organization. */
    shared?: Maybe<Scalars["Boolean"]>;
    /** The id of the team associated with the custom view. */
    teamId?: Maybe<Scalars["String"]>;
};
/** A customer whose needs will be tied to issues or projects. */
export declare type Customer = Node & {
    __typename?: "Customer";
    /** The approximate number of needs of the customer. */
    approximateNeedCount: Scalars["Float"];
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The domains associated with this customer. */
    domains: Array<Scalars["String"]>;
    /** The ids of the customers in external systems. */
    externalIds: Array<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The integration that manages the Customer. */
    integration?: Maybe<Integration>;
    /** The customer's logo URL. */
    logoUrl?: Maybe<Scalars["String"]>;
    /** The ID of the main source, when a customer has multiple sources. Must be one of externalIds. */
    mainSourceId?: Maybe<Scalars["String"]>;
    /** The customer's name. */
    name: Scalars["String"];
    /** The user who owns the customer. */
    owner?: Maybe<User>;
    /** The annual revenue generated by the customer. */
    revenue?: Maybe<Scalars["Float"]>;
    /** The size of the customer. */
    size?: Maybe<Scalars["Float"]>;
    /** The ID of the Slack channel used to interact with the customer. */
    slackChannelId?: Maybe<Scalars["String"]>;
    /** The customer's unique URL slug. */
    slugId: Scalars["String"];
    /** The current status of the customer. */
    status: CustomerStatus;
    /** The tier of the customer. */
    tier?: Maybe<CustomerTier>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type CustomerConnection = {
    __typename?: "CustomerConnection";
    edges: Array<CustomerEdge>;
    nodes: Array<Customer>;
    pageInfo: PageInfo;
};
/** [ALPHA] Issue customer count sorting options. */
export declare type CustomerCountSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
export declare type CustomerCreateInput = {
    /** The domains associated with this customer. */
    domains?: Maybe<Array<Scalars["String"]>>;
    /** The ids of the customers in external systems. */
    externalIds?: Maybe<Array<Scalars["String"]>>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The URL of the customer's logo. */
    logoUrl?: Maybe<Scalars["String"]>;
    /** The main source of the customer, for customers with multiple sources. Must be one of externalIds. */
    mainSourceId?: Maybe<Scalars["String"]>;
    /** The name of the customer. */
    name: Scalars["String"];
    /** The user who owns the customer. */
    ownerId?: Maybe<Scalars["String"]>;
    /** The annual revenue generated by the customer. */
    revenue?: Maybe<Scalars["Int"]>;
    /** The size of the customer. */
    size?: Maybe<Scalars["Int"]>;
    /** The ID of the Slack channel used to interact with the customer. */
    slackChannelId?: Maybe<Scalars["String"]>;
    /** The status of the customer. */
    statusId?: Maybe<Scalars["String"]>;
    /** The tier of the customer customer. */
    tierId?: Maybe<Scalars["String"]>;
};
/** Customer creation date sorting options. */
export declare type CustomerCreatedAtSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
export declare type CustomerEdge = {
    __typename?: "CustomerEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: Customer;
};
/** Customer filtering options. */
export declare type CustomerFilter = {
    /** Compound filters, all of which need to be matched by the customer. */
    and?: Maybe<Array<CustomerFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the customer's domains. */
    domains?: Maybe<StringArrayComparator>;
    /** Comparator for the customer's external IDs. */
    externalIds?: Maybe<StringArrayComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the customer name. */
    name?: Maybe<StringComparator>;
    /** Filters that the customer's needs must satisfy. */
    needs?: Maybe<CustomerNeedCollectionFilter>;
    /** Compound filters, one of which need to be matched by the customer. */
    or?: Maybe<Array<CustomerFilter>>;
    /** Filters that the customer owner must satisfy. */
    owner?: Maybe<NullableUserFilter>;
    /** Comparator for the customer generated revenue. */
    revenue?: Maybe<NumberComparator>;
    /** Comparator for the customer size. */
    size?: Maybe<NumberComparator>;
    /** Comparator for the customer slack channel ID. */
    slackChannelId?: Maybe<StringComparator>;
    /** Filters that the customer's status must satisfy. */
    status?: Maybe<CustomerStatusFilter>;
    /** Filters that the customer's tier must satisfy. */
    tier?: Maybe<CustomerTierFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** [ALPHA] Issue customer important count sorting options. */
export declare type CustomerImportantCountSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
/** A customer need, expressed through a reference to an issue, project, or comment. */
export declare type CustomerNeed = Node & {
    __typename?: "CustomerNeed";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The attachment this need is referencing. */
    attachment?: Maybe<Attachment>;
    /** The need content in markdown format. */
    body?: Maybe<Scalars["String"]>;
    /** [Internal] The content of the need as a Prosemirror document. */
    bodyData?: Maybe<Scalars["String"]>;
    /** The comment this need is referencing. */
    comment?: Maybe<Comment>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The creator of the customer need. */
    creator?: Maybe<User>;
    /** The customer that this need is attached to. */
    customer?: Maybe<Customer>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The issue this need is referencing. */
    issue?: Maybe<Issue>;
    /** Whether the customer need is important or not. 0 = Not important, 1 = Important. */
    priority: Scalars["Float"];
    /** The project this need is referencing. */
    project?: Maybe<Project>;
    /** The project attachment this need is referencing. */
    projectAttachment?: Maybe<ProjectAttachment>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The URL of the underlying attachment, if any */
    url?: Maybe<Scalars["String"]>;
};
/** A generic payload return from entity archive mutations. */
export declare type CustomerNeedArchivePayload = ArchivePayload & {
    __typename?: "CustomerNeedArchivePayload";
    /** The archived/unarchived entity. Null if entity was deleted. */
    entity?: Maybe<CustomerNeed>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** Customer needs filtering options. */
export declare type CustomerNeedCollectionFilter = {
    /** Compound filters, all of which need to be matched by the customer needs. */
    and?: Maybe<Array<CustomerNeedCollectionFilter>>;
    /** Filters that the need's comment must satisfy. */
    comment?: Maybe<NullableCommentFilter>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the need's customer must satisfy. */
    customer?: Maybe<NullableCustomerFilter>;
    /** Filters that needs to be matched by all customer needs. */
    every?: Maybe<CustomerNeedFilter>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Filters that the need's issue must satisfy. */
    issue?: Maybe<NullableIssueFilter>;
    /** Comparator for the collection length. */
    length?: Maybe<NumberComparator>;
    /** Compound filters, one of which need to be matched by the customer needs. */
    or?: Maybe<Array<CustomerNeedCollectionFilter>>;
    /** Comparator for the customer need priority. */
    priority?: Maybe<NumberComparator>;
    /** Filters that the need's project must satisfy. */
    project?: Maybe<NullableProjectFilter>;
    /** Filters that needs to be matched by some customer needs. */
    some?: Maybe<CustomerNeedFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type CustomerNeedConnection = {
    __typename?: "CustomerNeedConnection";
    edges: Array<CustomerNeedEdge>;
    nodes: Array<CustomerNeed>;
    pageInfo: PageInfo;
};
export declare type CustomerNeedCreateFromAttachmentInput = {
    /** The attachment this need is created from. */
    attachmentId: Scalars["String"];
};
export declare type CustomerNeedCreateInput = {
    /** The attachment this need is referencing. */
    attachmentId?: Maybe<Scalars["String"]>;
    /** Optional URL for the attachment associated with the customer need. */
    attachmentUrl?: Maybe<Scalars["String"]>;
    /** The content of the need in markdown format. */
    body?: Maybe<Scalars["String"]>;
    /** [Internal] The content of the need as a Prosemirror document. */
    bodyData?: Maybe<Scalars["JSON"]>;
    /** The comment this need is referencing. */
    commentId?: Maybe<Scalars["String"]>;
    /** Create need as a user with the provided name. This option is only available to OAuth applications creating needs in `actor=application` mode. */
    createAsUser?: Maybe<Scalars["String"]>;
    /** The external ID of the customer the need belongs to. */
    customerExternalId?: Maybe<Scalars["String"]>;
    /** The uuid of the customer the need belongs to. */
    customerId?: Maybe<Scalars["String"]>;
    /** Provide an external user avatar URL. Can only be used in conjunction with the `createAsUser` options. This option is only available to OAuth applications creating needs in `actor=application` mode. */
    displayIconUrl?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The issue this need is referencing. */
    issueId?: Maybe<Scalars["String"]>;
    /** Whether the customer need is important or not. 0 = Not important, 1 = Important. */
    priority?: Maybe<Scalars["Float"]>;
    /** [INTERNAL] The project this need is referencing. */
    projectId?: Maybe<Scalars["String"]>;
};
export declare type CustomerNeedEdge = {
    __typename?: "CustomerNeedEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: CustomerNeed;
};
/** Customer filtering options. */
export declare type CustomerNeedFilter = {
    /** Compound filters, all of which need to be matched by the customer need. */
    and?: Maybe<Array<CustomerNeedFilter>>;
    /** Filters that the need's comment must satisfy. */
    comment?: Maybe<NullableCommentFilter>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the need's customer must satisfy. */
    customer?: Maybe<NullableCustomerFilter>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Filters that the need's issue must satisfy. */
    issue?: Maybe<NullableIssueFilter>;
    /** Compound filters, one of which need to be matched by the customer need. */
    or?: Maybe<Array<CustomerNeedFilter>>;
    /** Comparator for the customer need priority. */
    priority?: Maybe<NumberComparator>;
    /** Filters that the need's project must satisfy. */
    project?: Maybe<NullableProjectFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** [Internal] A customer need related notification. */
export declare type CustomerNeedNotification = Entity & Node & Notification & {
    __typename?: "CustomerNeedNotification";
    /** The user that caused the notification. */
    actor?: Maybe<User>;
    /** [Internal] Notification actor initials if avatar is not available. */
    actorAvatarColor: Scalars["String"];
    /** [Internal] Notification avatar URL. */
    actorAvatarUrl?: Maybe<Scalars["String"]>;
    /** [Internal] Notification actor initials if avatar is not available. */
    actorInitials?: Maybe<Scalars["String"]>;
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The bot that caused the notification. */
    botActor?: Maybe<ActorBot>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** Related customer need. */
    customerNeedId: Scalars["String"];
    /**
     * The time at when an email reminder for this notification was sent to the user. Null, if no email
     *     reminder has been sent.
     */
    emailedAt?: Maybe<Scalars["DateTime"]>;
    /** The external user that caused the notification. */
    externalUserActor?: Maybe<ExternalUser>;
    /** [Internal] Notifications with the same grouping key will be grouped together in the UI. */
    groupingKey: Scalars["String"];
    /** [Internal] Priority of the notification with the same grouping key. Higher number means higher priority. If priority is the same, notifications should be sorted by `createdAt`. */
    groupingPriority: Scalars["Float"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** [Internal] Inbox URL for the notification. */
    inboxUrl: Scalars["String"];
    /** [Internal] If notification actor was Linear. */
    isLinearActor: Scalars["Boolean"];
    /** [Internal] Issue's status type for issue notifications. */
    issueStatusType?: Maybe<Scalars["String"]>;
    /** [Internal] Project update health for new updates. */
    projectUpdateHealth?: Maybe<Scalars["String"]>;
    /** The time at when the user marked the notification as read. Null, if the the user hasn't read the notification */
    readAt?: Maybe<Scalars["DateTime"]>;
    /** The issue related to the notification. */
    relatedIssue?: Maybe<Issue>;
    /** The project related to the notification. */
    relatedProject?: Maybe<Project>;
    /** The time until a notification will be snoozed. After that it will appear in the inbox again. */
    snoozedUntilAt?: Maybe<Scalars["DateTime"]>;
    /** [Internal] Notification subtitle. */
    subtitle: Scalars["String"];
    /** [Internal] Notification title. */
    title: Scalars["String"];
    /** Notification type. */
    type: Scalars["String"];
    /** The time at which a notification was unsnoozed.. */
    unsnoozedAt?: Maybe<Scalars["DateTime"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** [Internal] URL to the target of the notification. */
    url: Scalars["String"];
    /** The user that received the notification. */
    user: User;
};
export declare type CustomerNeedPayload = {
    __typename?: "CustomerNeedPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** The customer need that was created or updated. */
    need: CustomerNeed;
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type CustomerNeedUpdateInput = {
    /** Whether to also update the priority of needs from the same customer on the same issue/project. */
    applyPriorityToRelatedNeeds?: Maybe<Scalars["Boolean"]>;
    /** Optional URL for the attachment associated with the customer need. */
    attachmentUrl?: Maybe<Scalars["String"]>;
    /** The content of the need in markdown format. */
    body?: Maybe<Scalars["String"]>;
    /** [Internal] The content of the need as a Prosemirror document. */
    bodyData?: Maybe<Scalars["JSON"]>;
    /** The external ID of the customer the need belongs to. */
    customerExternalId?: Maybe<Scalars["String"]>;
    /** The uuid of the customer the need belongs to. */
    customerId?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The issue this need is referencing. */
    issueId?: Maybe<Scalars["String"]>;
    /** Whether the customer need is important or not. 0 = Not important, 1 = Important. */
    priority?: Maybe<Scalars["Float"]>;
    /** [INTERNAL] The project this need is referencing. */
    projectId?: Maybe<Scalars["String"]>;
};
/** A customer notification subscription. */
export declare type CustomerNotificationSubscription = Entity & Node & NotificationSubscription & {
    __typename?: "CustomerNotificationSubscription";
    /** Whether the subscription is active or not. */
    active: Scalars["Boolean"];
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The type of view to which the notification subscription context is associated with. */
    contextViewType?: Maybe<ContextViewType>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The contextual custom view associated with the notification subscription. */
    customView?: Maybe<CustomView>;
    /** The customer subscribed to. */
    customer: Customer;
    /** The contextual cycle view associated with the notification subscription. */
    cycle?: Maybe<Cycle>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The contextual initiative view associated with the notification subscription. */
    initiative?: Maybe<Initiative>;
    /** The contextual label view associated with the notification subscription. */
    label?: Maybe<IssueLabel>;
    /** The type of subscription. */
    notificationSubscriptionTypes: Array<Scalars["String"]>;
    /** The contextual project view associated with the notification subscription. */
    project?: Maybe<Project>;
    /** The user that subscribed to receive notifications. */
    subscriber: User;
    /** The team associated with the notification subscription. */
    team?: Maybe<Team>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The user view associated with the notification subscription. */
    user?: Maybe<User>;
    /** The type of user view to which the notification subscription context is associated with. */
    userContextViewType?: Maybe<UserContextViewType>;
};
export declare type CustomerPayload = {
    __typename?: "CustomerPayload";
    /** The customer that was created or updated. */
    customer: Customer;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** [ALPHA] Issue customer revenue sorting options. */
export declare type CustomerRevenueSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
/** Issue customer sorting options. */
export declare type CustomerSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
/** Customer sorting options. */
export declare type CustomerSortInput = {
    /** Sort by approximate customer need count */
    approximateNeedCount?: Maybe<ApproximateNeedCountSort>;
    /** Sort by customer creation date */
    createdAt?: Maybe<CustomerCreatedAtSort>;
    /** Sort by name */
    name?: Maybe<NameSort>;
    /** Sort by owner name */
    owner?: Maybe<OwnerSort>;
    /** Sort by customer generated revenue */
    revenue?: Maybe<RevenueSort>;
    /** Sort by customer size */
    size?: Maybe<SizeSort>;
    /** Sort by customer status */
    status?: Maybe<CustomerStatusSort>;
    /** Sort by customer tier */
    tier?: Maybe<TierSort>;
};
/** A customer status. */
export declare type CustomerStatus = Node & {
    __typename?: "CustomerStatus";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The UI color of the status as a HEX string. */
    color: Scalars["String"];
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** Description of the status. */
    description?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The name of the status. */
    name: Scalars["String"];
    /** The position of the status in the workspace's customers flow. */
    position: Scalars["Float"];
    /** The type of the customer status. */
    type: CustomerStatusType;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type CustomerStatusConnection = {
    __typename?: "CustomerStatusConnection";
    edges: Array<CustomerStatusEdge>;
    nodes: Array<CustomerStatus>;
    pageInfo: PageInfo;
};
export declare type CustomerStatusEdge = {
    __typename?: "CustomerStatusEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: CustomerStatus;
};
/** Customer status filtering options. */
export declare type CustomerStatusFilter = {
    /** Compound filters, all of which need to be matched by the customer status. */
    and?: Maybe<Array<CustomerStatusFilter>>;
    /** Comparator for the customer status color. */
    color?: Maybe<StringComparator>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the customer status description. */
    description?: Maybe<StringComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the customer status name. */
    name?: Maybe<StringComparator>;
    /** Compound filters, one of which needs to be matched by the customer status. */
    or?: Maybe<Array<CustomerStatusFilter>>;
    /** Comparator for the customer status position. */
    position?: Maybe<NumberComparator>;
    /** Comparator for the customer status type. */
    type?: Maybe<StringComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** Customer status sorting options. */
export declare type CustomerStatusSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
/** A type of customer status. */
export declare enum CustomerStatusType {
    Active = "active",
    Inactive = "inactive"
}
/** A customer tier. */
export declare type CustomerTier = Node & {
    __typename?: "CustomerTier";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The UI color of the tier as a HEX string. */
    color: Scalars["String"];
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** Description of the tier. */
    description?: Maybe<Scalars["String"]>;
    /** The display name of the tier. */
    displayName: Scalars["String"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The name of the tier. */
    name: Scalars["String"];
    /** The position of the tier in the workspace's customers flow. */
    position: Scalars["Float"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type CustomerTierConnection = {
    __typename?: "CustomerTierConnection";
    edges: Array<CustomerTierEdge>;
    nodes: Array<CustomerTier>;
    pageInfo: PageInfo;
};
export declare type CustomerTierCreateInput = {
    /** The UI color of the tier as a HEX string. */
    color: Scalars["String"];
    /** Description of the tier. */
    description?: Maybe<Scalars["String"]>;
    /** The display name of the tier. */
    displayName?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The name of the tier. */
    name?: Maybe<Scalars["String"]>;
    /** The position of the tier in the workspace's customer flow. */
    position?: Maybe<Scalars["Float"]>;
};
export declare type CustomerTierEdge = {
    __typename?: "CustomerTierEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: CustomerTier;
};
/** Customer tier filtering options. */
export declare type CustomerTierFilter = {
    /** Compound filters, all of which need to be matched by the customer tier. */
    and?: Maybe<Array<CustomerTierFilter>>;
    /** Comparator for the customer tier color. */
    color?: Maybe<StringComparator>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the customer tier description. */
    description?: Maybe<StringComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the customer tier name. */
    name?: Maybe<StringComparator>;
    /** Compound filters, one of which needs to be matched by the customer tier. */
    or?: Maybe<Array<CustomerTierFilter>>;
    /** Comparator for the customer tier position. */
    position?: Maybe<NumberComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type CustomerTierPayload = {
    __typename?: "CustomerTierPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
    /** The customer tier that was created or updated. */
    tier: CustomerTier;
};
export declare type CustomerTierUpdateInput = {
    /** The UI color of the tier as a HEX string. */
    color?: Maybe<Scalars["String"]>;
    /** Description of the tier. */
    description?: Maybe<Scalars["String"]>;
    /** The display name of the tier. */
    displayName?: Maybe<Scalars["String"]>;
    /** The name of the tier. */
    name?: Maybe<Scalars["String"]>;
    /** The position of the tier in the workspace's customer flow. */
    position?: Maybe<Scalars["Float"]>;
};
export declare type CustomerUpdateInput = {
    /** The domains associated with this customer. */
    domains?: Maybe<Array<Scalars["String"]>>;
    /** The ids of the customers in external systems. */
    externalIds?: Maybe<Array<Scalars["String"]>>;
    /** The URL of the customer's logo. */
    logoUrl?: Maybe<Scalars["String"]>;
    /** The main source of the customer, for customers with multiple sources. Must be one of externalIds. */
    mainSourceId?: Maybe<Scalars["String"]>;
    /** The name of the customer. */
    name?: Maybe<Scalars["String"]>;
    /** The user who owns the customer. */
    ownerId?: Maybe<Scalars["String"]>;
    /** The annual revenue generated by the customer. */
    revenue?: Maybe<Scalars["Int"]>;
    /** The size of the customer. */
    size?: Maybe<Scalars["Int"]>;
    /** The ID of the Slack channel used to interact with the customer. */
    slackChannelId?: Maybe<Scalars["String"]>;
    /** The status of the customer. */
    statusId?: Maybe<Scalars["String"]>;
    /** The tier of the customer customer. */
    tierId?: Maybe<Scalars["String"]>;
};
export declare type CustomerUpsertInput = {
    /** The domains associated with this customer. */
    domains?: Maybe<Array<Scalars["String"]>>;
    /** The id of the customers in external systems. */
    externalId?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. */
    id?: Maybe<Scalars["String"]>;
    /** The URL of the customer's logo. */
    logoUrl?: Maybe<Scalars["String"]>;
    /** The name of the customer. */
    name?: Maybe<Scalars["String"]>;
    /** The user who owns the customer. */
    ownerId?: Maybe<Scalars["String"]>;
    /** The annual revenue generated by the customer. */
    revenue?: Maybe<Scalars["Int"]>;
    /** The size of the customer. */
    size?: Maybe<Scalars["Int"]>;
    /** The ID of the Slack channel used to interact with the customer. */
    slackChannelId?: Maybe<Scalars["String"]>;
    /** The status of the customer. */
    statusId?: Maybe<Scalars["String"]>;
    /** The tier of the customer. */
    tierId?: Maybe<Scalars["String"]>;
    /** The name tier of the customer. Will be created if doesn't exist */
    tierName?: Maybe<Scalars["String"]>;
};
/** A set of issues to be resolved in a specified amount of time. */
export declare type Cycle = Node & {
    __typename?: "Cycle";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the cycle was automatically archived by the auto pruning process. */
    autoArchivedAt?: Maybe<Scalars["DateTime"]>;
    /** The completion time of the cycle. If null, the cycle hasn't been completed. */
    completedAt?: Maybe<Scalars["DateTime"]>;
    /** The number of completed issues in the cycle after each day. */
    completedIssueCountHistory: Array<Scalars["Float"]>;
    /** The number of completed estimation points after each day. */
    completedScopeHistory: Array<Scalars["Float"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** [Internal] The current progress of the cycle. */
    currentProgress: Scalars["JSONObject"];
    /** The cycle's description. */
    description?: Maybe<Scalars["String"]>;
    /** The end time of the cycle. */
    endsAt: Scalars["DateTime"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The number of in progress estimation points after each day. */
    inProgressScopeHistory: Array<Scalars["Float"]>;
    /** The cycle inherited from. */
    inheritedFrom?: Maybe<Cycle>;
    /** The total number of issues in the cycle after each day. */
    issueCountHistory: Array<Scalars["Float"]>;
    /** Issues associated with the cycle. */
    issues: IssueConnection;
    /** The custom name of the cycle. */
    name?: Maybe<Scalars["String"]>;
    /** The number of the cycle. */
    number: Scalars["Float"];
    /** The overall progress of the cycle. This is the (completed estimate points + 0.25 * in progress estimate points) / total estimate points. */
    progress: Scalars["Float"];
    /** [Internal] The progress history of the cycle. */
    progressHistory: Scalars["JSONObject"];
    /** The total number of estimation points after each day. */
    scopeHistory: Array<Scalars["Float"]>;
    /** The start time of the cycle. */
    startsAt: Scalars["DateTime"];
    /** The team that the cycle is associated with. */
    team: Team;
    /** Issues that weren't completed when the cycle was closed. */
    uncompletedIssuesUponClose: IssueConnection;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
/** A set of issues to be resolved in a specified amount of time. */
export declare type CycleIssuesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A set of issues to be resolved in a specified amount of time. */
export declare type CycleUncompletedIssuesUponCloseArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A generic payload return from entity archive mutations. */
export declare type CycleArchivePayload = ArchivePayload & {
    __typename?: "CycleArchivePayload";
    /** The archived/unarchived entity. Null if entity was deleted. */
    entity?: Maybe<Cycle>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type CycleConnection = {
    __typename?: "CycleConnection";
    edges: Array<CycleEdge>;
    nodes: Array<Cycle>;
    pageInfo: PageInfo;
};
export declare type CycleCreateInput = {
    /** The completion time of the cycle. If null, the cycle hasn't been completed. */
    completedAt?: Maybe<Scalars["DateTime"]>;
    /** The description of the cycle. */
    description?: Maybe<Scalars["String"]>;
    /** The end date of the cycle. */
    endsAt: Scalars["DateTime"];
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The custom name of the cycle. */
    name?: Maybe<Scalars["String"]>;
    /** The start date of the cycle. */
    startsAt: Scalars["DateTime"];
    /** The team to associate the cycle with. */
    teamId: Scalars["String"];
};
export declare type CycleEdge = {
    __typename?: "CycleEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: Cycle;
};
/** Cycle filtering options. */
export declare type CycleFilter = {
    /** Compound filters, all of which need to be matched by the cycle. */
    and?: Maybe<Array<CycleFilter>>;
    /** Comparator for the cycle completed at date. */
    completedAt?: Maybe<DateComparator>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the cycle ends at date. */
    endsAt?: Maybe<DateComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the filtering active cycle. */
    isActive?: Maybe<BooleanComparator>;
    /** Comparator for the filtering future cycles. */
    isFuture?: Maybe<BooleanComparator>;
    /** Comparator for filtering for whether the cycle is currently in cooldown. */
    isInCooldown?: Maybe<BooleanComparator>;
    /** Comparator for the filtering next cycle. */
    isNext?: Maybe<BooleanComparator>;
    /** Comparator for the filtering past cycles. */
    isPast?: Maybe<BooleanComparator>;
    /** Comparator for the filtering previous cycle. */
    isPrevious?: Maybe<BooleanComparator>;
    /** Filters that the cycles issues must satisfy. */
    issues?: Maybe<IssueCollectionFilter>;
    /** Comparator for the cycle name. */
    name?: Maybe<StringComparator>;
    /** Comparator for the cycle number. */
    number?: Maybe<NumberComparator>;
    /** Compound filters, one of which need to be matched by the cycle. */
    or?: Maybe<Array<CycleFilter>>;
    /** Comparator for the cycle start date. */
    startsAt?: Maybe<DateComparator>;
    /** Filters that the cycles team must satisfy. */
    team?: Maybe<TeamFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** A cycle notification subscription. */
export declare type CycleNotificationSubscription = Entity & Node & NotificationSubscription & {
    __typename?: "CycleNotificationSubscription";
    /** Whether the subscription is active or not. */
    active: Scalars["Boolean"];
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The type of view to which the notification subscription context is associated with. */
    contextViewType?: Maybe<ContextViewType>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The contextual custom view associated with the notification subscription. */
    customView?: Maybe<CustomView>;
    /** The customer associated with the notification subscription. */
    customer?: Maybe<Customer>;
    /** The cycle subscribed to. */
    cycle: Cycle;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The contextual initiative view associated with the notification subscription. */
    initiative?: Maybe<Initiative>;
    /** The contextual label view associated with the notification subscription. */
    label?: Maybe<IssueLabel>;
    /** The type of subscription. */
    notificationSubscriptionTypes: Array<Scalars["String"]>;
    /** The contextual project view associated with the notification subscription. */
    project?: Maybe<Project>;
    /** The user that subscribed to receive notifications. */
    subscriber: User;
    /** The team associated with the notification subscription. */
    team?: Maybe<Team>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The user view associated with the notification subscription. */
    user?: Maybe<User>;
    /** The type of user view to which the notification subscription context is associated with. */
    userContextViewType?: Maybe<UserContextViewType>;
};
export declare type CyclePayload = {
    __typename?: "CyclePayload";
    /** The Cycle that was created or updated. */
    cycle?: Maybe<Cycle>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare enum CyclePeriod {
    After = "after",
    Before = "before",
    During = "during"
}
/** Comparator for period when issue was added to a cycle. */
export declare type CyclePeriodComparator = {
    /** Equals constraint. */
    eq?: Maybe<CyclePeriod>;
    /** In-array constraint. */
    in?: Maybe<Array<CyclePeriod>>;
    /** Not-equals constraint. */
    neq?: Maybe<CyclePeriod>;
    /** Not-in-array constraint. */
    nin?: Maybe<Array<CyclePeriod>>;
    /** Null constraint. Matches any non-null values if the given value is false, otherwise it matches null values. */
    null?: Maybe<Scalars["Boolean"]>;
};
/** Input for shifting all cycles from a certain cycle onwards by a certain number of days */
export declare type CycleShiftAllInput = {
    /** The number of days to shift the cycles by. */
    daysToShift: Scalars["Float"];
    /** The cycle ID at which to start the shift. */
    id: Scalars["String"];
};
/** Issue cycle sorting options. */
export declare type CycleSort = {
    /** When set to true, cycles will be ordered with a custom order. Current cycle comes first, followed by upcoming cycles in ASC order, followed by previous cycles in DESC order. */
    currentCycleFirst?: Maybe<Scalars["Boolean"]>;
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
export declare type CycleUpdateInput = {
    /** The end date of the cycle. */
    completedAt?: Maybe<Scalars["DateTime"]>;
    /** The description of the cycle. */
    description?: Maybe<Scalars["String"]>;
    /** The end date of the cycle. */
    endsAt?: Maybe<Scalars["DateTime"]>;
    /** The custom name of the cycle. */
    name?: Maybe<Scalars["String"]>;
    /** The start date of the cycle. */
    startsAt?: Maybe<Scalars["DateTime"]>;
};
/** [Internal] A dashboard, usually a collection of widgets to display several insights at once. */
export declare type Dashboard = Node & {
    __typename?: "Dashboard";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The color of the icon of the dashboard. */
    color?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who created the dashboard. */
    creator?: Maybe<User>;
    /** The description of the dashboard. */
    description?: Maybe<Scalars["String"]>;
    /** The icon of the dashboard. */
    icon?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The filter applied to all dashboard widgets showing issues data. */
    issueFilter?: Maybe<Scalars["JSONObject"]>;
    /** The layout of the widgets on the dashboard. */
    layout: Scalars["JSONObject"];
    /** The name of the dashboard. */
    name: Scalars["String"];
    /** The organization of the dashboard. */
    organization: Organization;
    /** The owner of the dashboard. */
    owner?: Maybe<User>;
    /** The filter applied to all dashboard widgets showing projects data. */
    projectFilter?: Maybe<Scalars["JSONObject"]>;
    /** Whether the dashboard is shared with everyone in the organization. */
    shared: Scalars["Boolean"];
    /** The dashboard's unique URL slug. */
    slugId: Scalars["String"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The user who last updated the dashboard. */
    updatedBy?: Maybe<User>;
    /** The widgets on the dashboard. */
    widgets: Scalars["JSONObject"];
};
/** Comparator for dates. */
export declare type DateComparator = {
    /** Equals constraint. */
    eq?: Maybe<Scalars["DateTimeOrDuration"]>;
    /** Greater-than constraint. Matches any values that are greater than the given value. */
    gt?: Maybe<Scalars["DateTimeOrDuration"]>;
    /** Greater-than-or-equal constraint. Matches any values that are greater than or equal to the given value. */
    gte?: Maybe<Scalars["DateTimeOrDuration"]>;
    /** In-array constraint. */
    in?: Maybe<Array<Scalars["DateTimeOrDuration"]>>;
    /** Less-than constraint. Matches any values that are less than the given value. */
    lt?: Maybe<Scalars["DateTimeOrDuration"]>;
    /** Less-than-or-equal constraint. Matches any values that are less than or equal to the given value. */
    lte?: Maybe<Scalars["DateTimeOrDuration"]>;
    /** Not-equals constraint. */
    neq?: Maybe<Scalars["DateTimeOrDuration"]>;
    /** Not-in-array constraint. */
    nin?: Maybe<Array<Scalars["DateTimeOrDuration"]>>;
};
/** By which resolution is a date defined. */
export declare enum DateResolutionType {
    HalfYear = "halfYear",
    Month = "month",
    Quarter = "quarter",
    Year = "year"
}
/** The day of the week. */
export declare enum Day {
    Friday = "Friday",
    Monday = "Monday",
    Saturday = "Saturday",
    Sunday = "Sunday",
    Thursday = "Thursday",
    Tuesday = "Tuesday",
    Wednesday = "Wednesday"
}
export declare type DeleteOrganizationInput = {
    /** The deletion code to confirm operation. */
    deletionCode: Scalars["String"];
};
/** A generic payload return from entity deletion mutations. */
export declare type DeletePayload = ArchivePayload & {
    __typename?: "DeletePayload";
    /** The identifier of the deleted entity. */
    entityId: Scalars["String"];
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** A document that can be attached to different entities. */
export declare type Document = Node & {
    __typename?: "Document";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The color of the icon. */
    color?: Maybe<Scalars["String"]>;
    /** Comments associated with the document. */
    comments: CommentConnection;
    /** The documents content in markdown format. */
    content?: Maybe<Scalars["String"]>;
    /** [Internal] The documents content as YJS state. */
    contentState?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who created the document. */
    creator?: Maybe<User>;
    /** The ID of the document content associated with the document. */
    documentContentId?: Maybe<Scalars["String"]>;
    /** The time at which the document was hidden. Null if the entity has not been hidden. */
    hiddenAt?: Maybe<Scalars["DateTime"]>;
    /** The icon of the document. */
    icon?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The initiative that the document is associated with. */
    initiative?: Maybe<Initiative>;
    /** The last template that was applied to this document. */
    lastAppliedTemplate?: Maybe<Template>;
    /** The project that the document is associated with. */
    project?: Maybe<Project>;
    /** The document's unique URL slug. */
    slugId: Scalars["String"];
    /** The order of the item in the resources list. */
    sortOrder: Scalars["Float"];
    /** [Internal] The team that the document is associated with. */
    team?: Maybe<Team>;
    /** The document title. */
    title: Scalars["String"];
    /** A flag that indicates whether the document is in the trash bin. */
    trashed?: Maybe<Scalars["Boolean"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The user who last updated the document. */
    updatedBy?: Maybe<User>;
    /** The canonical url for the document. */
    url: Scalars["String"];
};
/** A document that can be attached to different entities. */
export declare type DocumentCommentsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CommentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A generic payload return from entity archive mutations. */
export declare type DocumentArchivePayload = ArchivePayload & {
    __typename?: "DocumentArchivePayload";
    /** The archived/unarchived entity. Null if entity was deleted. */
    entity?: Maybe<Document>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type DocumentConnection = {
    __typename?: "DocumentConnection";
    edges: Array<DocumentEdge>;
    nodes: Array<Document>;
    pageInfo: PageInfo;
};
/** A document content for a project. */
export declare type DocumentContent = Node & {
    __typename?: "DocumentContent";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The document content in markdown format. */
    content?: Maybe<Scalars["String"]>;
    /** The document content state as a base64 encoded string. */
    contentState?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The document that the content is associated with. */
    document?: Maybe<Document>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The initiative that the content is associated with. */
    initiative?: Maybe<Initiative>;
    /** The issue that the content is associated with. */
    issue?: Maybe<Issue>;
    /** [ALPHA] The meeting that the content is associated with. */
    meeting?: Maybe<Meeting>;
    /** The project that the content is associated with. */
    project?: Maybe<Project>;
    /** The project milestone that the content is associated with. */
    projectMilestone?: Maybe<ProjectMilestone>;
    /** The time at which the document content was restored from a previous version. */
    restoredAt?: Maybe<Scalars["DateTime"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type DocumentContentHistoryPayload = {
    __typename?: "DocumentContentHistoryPayload";
    /** The document content history entries. */
    history: Array<DocumentContentHistoryType>;
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type DocumentContentHistoryType = {
    __typename?: "DocumentContentHistoryType";
    /** The ID of the author of the change. */
    actorIds?: Maybe<Array<Scalars["String"]>>;
    /** [Internal] The document content as Prosemirror document. */
    contentData?: Maybe<Scalars["JSON"]>;
    /** The date when the document content history snapshot was taken. This can be different than createdAt since the content is captured from its state at the previously known updatedAt timestamp in the case of an update. On document create, these timestamps can be the same. */
    contentDataSnapshotAt: Scalars["DateTime"];
    /** The date when the document content history entry was created. */
    createdAt: Scalars["DateTime"];
    /** The UUID of the document content history entry. */
    id: Scalars["String"];
};
export declare type DocumentCreateInput = {
    /** The color of the icon. */
    color?: Maybe<Scalars["String"]>;
    /** The document content as markdown. */
    content?: Maybe<Scalars["String"]>;
    /** The icon of the document. */
    icon?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** [Internal] Related initiative for the document. */
    initiativeId?: Maybe<Scalars["String"]>;
    /** The ID of the last template applied to the document. */
    lastAppliedTemplateId?: Maybe<Scalars["String"]>;
    /** Related project for the document. */
    projectId?: Maybe<Scalars["String"]>;
    /** [Internal] The resource folder containing the document. */
    resourceFolderId?: Maybe<Scalars["String"]>;
    /** The order of the item in the resources list. */
    sortOrder?: Maybe<Scalars["Float"]>;
    /** [INTERNAL] The identifiers of the users subscribing to this document. */
    subscriberIds?: Maybe<Array<Scalars["String"]>>;
    /** [Internal] Related team for the document. */
    teamId?: Maybe<Scalars["String"]>;
    /** The title of the document. */
    title: Scalars["String"];
};
export declare type DocumentEdge = {
    __typename?: "DocumentEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: Document;
};
/** Document filtering options. */
export declare type DocumentFilter = {
    /** Compound filters, all of which need to be matched by the document. */
    and?: Maybe<Array<DocumentFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the document's creator must satisfy. */
    creator?: Maybe<UserFilter>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Filters that the document's initiative must satisfy. */
    initiative?: Maybe<InitiativeFilter>;
    /** Compound filters, one of which need to be matched by the document. */
    or?: Maybe<Array<DocumentFilter>>;
    /** Filters that the document's project must satisfy. */
    project?: Maybe<ProjectFilter>;
    /** Comparator for the document slug ID. */
    slugId?: Maybe<StringComparator>;
    /** Comparator for the document title. */
    title?: Maybe<StringComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** A document related notification. */
export declare type DocumentNotification = Entity & Node & Notification & {
    __typename?: "DocumentNotification";
    /** The user that caused the notification. */
    actor?: Maybe<User>;
    /** [Internal] Notification actor initials if avatar is not available. */
    actorAvatarColor: Scalars["String"];
    /** [Internal] Notification avatar URL. */
    actorAvatarUrl?: Maybe<Scalars["String"]>;
    /** [Internal] Notification actor initials if avatar is not available. */
    actorInitials?: Maybe<Scalars["String"]>;
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The bot that caused the notification. */
    botActor?: Maybe<ActorBot>;
    /** Related comment ID. Null if the notification is not related to a comment. */
    commentId?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** Related document ID. */
    documentId: Scalars["String"];
    /**
     * The time at when an email reminder for this notification was sent to the user. Null, if no email
     *     reminder has been sent.
     */
    emailedAt?: Maybe<Scalars["DateTime"]>;
    /** The external user that caused the notification. */
    externalUserActor?: Maybe<ExternalUser>;
    /** [Internal] Notifications with the same grouping key will be grouped together in the UI. */
    groupingKey: Scalars["String"];
    /** [Internal] Priority of the notification with the same grouping key. Higher number means higher priority. If priority is the same, notifications should be sorted by `createdAt`. */
    groupingPriority: Scalars["Float"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** [Internal] Inbox URL for the notification. */
    inboxUrl: Scalars["String"];
    /** [Internal] If notification actor was Linear. */
    isLinearActor: Scalars["Boolean"];
    /** [Internal] Issue's status type for issue notifications. */
    issueStatusType?: Maybe<Scalars["String"]>;
    /** Related parent comment ID. Null if the notification is not related to a comment. */
    parentCommentId?: Maybe<Scalars["String"]>;
    /** [Internal] Project update health for new updates. */
    projectUpdateHealth?: Maybe<Scalars["String"]>;
    /** Name of the reaction emoji related to the notification. */
    reactionEmoji?: Maybe<Scalars["String"]>;
    /** The time at when the user marked the notification as read. Null, if the the user hasn't read the notification */
    readAt?: Maybe<Scalars["DateTime"]>;
    /** The time until a notification will be snoozed. After that it will appear in the inbox again. */
    snoozedUntilAt?: Maybe<Scalars["DateTime"]>;
    /** [Internal] Notification subtitle. */
    subtitle: Scalars["String"];
    /** [Internal] Notification title. */
    title: Scalars["String"];
    /** Notification type. */
    type: Scalars["String"];
    /** The time at which a notification was unsnoozed.. */
    unsnoozedAt?: Maybe<Scalars["DateTime"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** [Internal] URL to the target of the notification. */
    url: Scalars["String"];
    /** The user that received the notification. */
    user: User;
};
export declare type DocumentPayload = {
    __typename?: "DocumentPayload";
    /** The document that was created or updated. */
    document: Document;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type DocumentSearchPayload = {
    __typename?: "DocumentSearchPayload";
    /** Archived entities matching the search term along with all their dependencies. */
    archivePayload: ArchiveResponse;
    edges: Array<DocumentSearchResultEdge>;
    nodes: Array<DocumentSearchResult>;
    pageInfo: PageInfo;
    /** Total number of results for query without filters applied. */
    totalCount: Scalars["Float"];
};
export declare type DocumentSearchResult = Node & {
    __typename?: "DocumentSearchResult";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The color of the icon. */
    color?: Maybe<Scalars["String"]>;
    /** Comments associated with the document. */
    comments: CommentConnection;
    /** The documents content in markdown format. */
    content?: Maybe<Scalars["String"]>;
    /** [Internal] The documents content as YJS state. */
    contentState?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who created the document. */
    creator?: Maybe<User>;
    /** The ID of the document content associated with the document. */
    documentContentId?: Maybe<Scalars["String"]>;
    /** The time at which the document was hidden. Null if the entity has not been hidden. */
    hiddenAt?: Maybe<Scalars["DateTime"]>;
    /** The icon of the document. */
    icon?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The initiative that the document is associated with. */
    initiative?: Maybe<Initiative>;
    /** The last template that was applied to this document. */
    lastAppliedTemplate?: Maybe<Template>;
    /** Metadata related to search result. */
    metadata: Scalars["JSONObject"];
    /** The project that the document is associated with. */
    project?: Maybe<Project>;
    /** The document's unique URL slug. */
    slugId: Scalars["String"];
    /** The order of the item in the resources list. */
    sortOrder: Scalars["Float"];
    /** [Internal] The team that the document is associated with. */
    team?: Maybe<Team>;
    /** The document title. */
    title: Scalars["String"];
    /** A flag that indicates whether the document is in the trash bin. */
    trashed?: Maybe<Scalars["Boolean"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The user who last updated the document. */
    updatedBy?: Maybe<User>;
    /** The canonical url for the document. */
    url: Scalars["String"];
};
export declare type DocumentSearchResultCommentsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CommentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type DocumentSearchResultEdge = {
    __typename?: "DocumentSearchResultEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: DocumentSearchResult;
};
export declare type DocumentUpdateInput = {
    /** The color of the icon. */
    color?: Maybe<Scalars["String"]>;
    /** The document content as markdown. */
    content?: Maybe<Scalars["String"]>;
    /** The time at which the document was hidden. */
    hiddenAt?: Maybe<Scalars["DateTime"]>;
    /** The icon of the document. */
    icon?: Maybe<Scalars["String"]>;
    /** [Internal] Related initiative for the document. */
    initiativeId?: Maybe<Scalars["String"]>;
    /** The ID of the last template applied to the document. */
    lastAppliedTemplateId?: Maybe<Scalars["String"]>;
    /** Related project for the document. */
    projectId?: Maybe<Scalars["String"]>;
    /** [Internal] The resource folder containing the document. */
    resourceFolderId?: Maybe<Scalars["String"]>;
    /** The order of the item in the resources list. */
    sortOrder?: Maybe<Scalars["Float"]>;
    /** [INTERNAL] The identifiers of the users subscribing to this document. */
    subscriberIds?: Maybe<Array<Scalars["String"]>>;
    /** [Internal] Related team for the document. */
    teamId?: Maybe<Scalars["String"]>;
    /** The title of the document. */
    title?: Maybe<Scalars["String"]>;
    /** Whether the document has been trashed. */
    trashed?: Maybe<Scalars["Boolean"]>;
};
/** A general purpose draft. Used for comments, project updates, etc. */
export declare type Draft = Node & {
    __typename?: "Draft";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The text content as a Prosemirror document. */
    bodyData: Scalars["JSON"];
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The customer need that this draft is referencing. */
    customerNeed?: Maybe<CustomerNeed>;
    /** Additional properties for the draft. */
    data?: Maybe<Scalars["JSONObject"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The initiative for which this is a draft initiative update. */
    initiative?: Maybe<Initiative>;
    /** The initiative update for which this is a draft comment. */
    initiativeUpdate?: Maybe<InitiativeUpdate>;
    /** Whether the draft was autogenerated for the user. */
    isAutogenerated: Scalars["Boolean"];
    /** The issue for which this is a draft comment. */
    issue?: Maybe<Issue>;
    /** The comment for which this is a draft comment reply. */
    parentComment?: Maybe<Comment>;
    /** The post for which this is a draft comment. */
    post?: Maybe<Post>;
    /** The project for which this is a draft project update. */
    project?: Maybe<Project>;
    /** The project update for which this is a draft comment. */
    projectUpdate?: Maybe<ProjectUpdate>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The user who created the draft. */
    user: User;
    /** [INTERNAL] Whether the draft was ported from a local draft. */
    wasLocalDraft: Scalars["Boolean"];
};
export declare type DraftConnection = {
    __typename?: "DraftConnection";
    edges: Array<DraftEdge>;
    nodes: Array<Draft>;
    pageInfo: PageInfo;
};
export declare type DraftEdge = {
    __typename?: "DraftEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: Draft;
};
/** Issue due date sorting options. */
export declare type DueDateSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
/** An email address that can be used for submitting issues. */
export declare type EmailIntakeAddress = Node & {
    __typename?: "EmailIntakeAddress";
    /** Unique email address user name (before @) used for incoming email. */
    address: Scalars["String"];
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who created the email intake address. */
    creator?: Maybe<User>;
    /** Whether issues created from that email address will be turned into customer requests. */
    customerRequestsEnabled: Scalars["Boolean"];
    /** Whether the email address is enabled. */
    enabled: Scalars["Boolean"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The organization that the email address is associated with. */
    organization: Organization;
    /** Whether email replies are enabled. */
    repliesEnabled: Scalars["Boolean"];
    /** The team that the email address is associated with. */
    team?: Maybe<Team>;
    /** The template that the email address is associated with. */
    template?: Maybe<Template>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type EmailIntakeAddressCreateInput = {
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The identifier or key of the team this email address will intake issues for. */
    teamId?: Maybe<Scalars["String"]>;
    /** The identifier of the template this email address will intake issues for. */
    templateId?: Maybe<Scalars["String"]>;
};
export declare type EmailIntakeAddressPayload = {
    __typename?: "EmailIntakeAddressPayload";
    /** The email address that was created or updated. */
    emailIntakeAddress: EmailIntakeAddress;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type EmailIntakeAddressUpdateInput = {
    /** Whether customer requests are enabled. */
    customerRequestsEnabled?: Maybe<Scalars["Boolean"]>;
    /** Whether the email address is currently enabled. If set to false, the email address will be disabled and no longer accept incoming emails. */
    enabled?: Maybe<Scalars["Boolean"]>;
    /** Whether email replies are enabled. */
    repliesEnabled?: Maybe<Scalars["Boolean"]>;
};
export declare type EmailUnsubscribeInput = {
    /** The user's email validation token. */
    token: Scalars["String"];
    /** Email type to unsubscribed from. */
    type: Scalars["String"];
    /** The identifier of the user. */
    userId: Scalars["String"];
};
export declare type EmailUnsubscribePayload = {
    __typename?: "EmailUnsubscribePayload";
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type EmailUserAccountAuthChallengeInput = {
    /** Auth code for the client initiating the sequence. */
    clientAuthCode?: Maybe<Scalars["String"]>;
    /** The email for which to generate the magic login code. */
    email: Scalars["String"];
    /** The organization invite link to associate with this authentication. */
    inviteLink?: Maybe<Scalars["String"]>;
    /** Whether the login was requested from the desktop app. */
    isDesktop?: Maybe<Scalars["Boolean"]>;
    /** Whether to only return the login code. This is used by mobile apps to skip showing the login link. */
    loginCodeOnly?: Maybe<Scalars["Boolean"]>;
};
export declare type EmailUserAccountAuthChallengeResponse = {
    __typename?: "EmailUserAccountAuthChallengeResponse";
    /** Supported challenge for this user account. Can be either verificationCode or password. */
    authType: Scalars["String"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** A custom emoji. */
export declare type Emoji = Node & {
    __typename?: "Emoji";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who created the emoji. */
    creator?: Maybe<User>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The emoji's name. */
    name: Scalars["String"];
    /** The organization that the emoji belongs to. */
    organization: Organization;
    /** The source of the emoji. */
    source: Scalars["String"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The emoji image URL. */
    url: Scalars["String"];
};
export declare type EmojiConnection = {
    __typename?: "EmojiConnection";
    edges: Array<EmojiEdge>;
    nodes: Array<Emoji>;
    pageInfo: PageInfo;
};
export declare type EmojiCreateInput = {
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The name of the custom emoji. */
    name: Scalars["String"];
    /** The URL for the emoji. */
    url: Scalars["String"];
};
export declare type EmojiEdge = {
    __typename?: "EmojiEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: Emoji;
};
export declare type EmojiPayload = {
    __typename?: "EmojiPayload";
    /** The emoji that was created. */
    emoji: Emoji;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** A basic entity. */
export declare type Entity = {
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
/** An external link for an entity like initiative, etc... */
export declare type EntityExternalLink = Node & {
    __typename?: "EntityExternalLink";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who created the link. */
    creator: User;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The initiative that the link is associated with. */
    initiative?: Maybe<Initiative>;
    /** The link's label. */
    label: Scalars["String"];
    /** The order of the item in the resources list. */
    sortOrder: Scalars["Float"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The link's URL. */
    url: Scalars["String"];
};
export declare type EntityExternalLinkConnection = {
    __typename?: "EntityExternalLinkConnection";
    edges: Array<EntityExternalLinkEdge>;
    nodes: Array<EntityExternalLink>;
    pageInfo: PageInfo;
};
export declare type EntityExternalLinkCreateInput = {
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The initiative associated with the link. */
    initiativeId?: Maybe<Scalars["String"]>;
    /** The label for the link. */
    label: Scalars["String"];
    /** The project associated with the link. */
    projectId?: Maybe<Scalars["String"]>;
    /** [Internal] The resource folder containing the link. */
    resourceFolderId?: Maybe<Scalars["String"]>;
    /** The order of the item in the entities resources list. */
    sortOrder?: Maybe<Scalars["Float"]>;
    /** [Internal] The team associated with the link. */
    teamId?: Maybe<Scalars["String"]>;
    /** The URL of the link. */
    url: Scalars["String"];
};
export declare type EntityExternalLinkEdge = {
    __typename?: "EntityExternalLinkEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: EntityExternalLink;
};
export declare type EntityExternalLinkPayload = {
    __typename?: "EntityExternalLinkPayload";
    /** The link that was created or updated. */
    entityExternalLink: EntityExternalLink;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type EntityExternalLinkUpdateInput = {
    /** The label for the link. */
    label?: Maybe<Scalars["String"]>;
    /** [Internal] The resource folder containing the link. */
    resourceFolderId?: Maybe<Scalars["String"]>;
    /** The order of the item in the entities resources list. */
    sortOrder?: Maybe<Scalars["Float"]>;
    /** The URL of the link. */
    url?: Maybe<Scalars["String"]>;
};
/** Comparator for estimates. */
export declare type EstimateComparator = {
    /** Compound filters, one of which need to be matched by the estimate. */
    and?: Maybe<Array<NullableNumberComparator>>;
    /** Equals constraint. */
    eq?: Maybe<Scalars["Float"]>;
    /** Greater-than constraint. Matches any values that are greater than the given value. */
    gt?: Maybe<Scalars["Float"]>;
    /** Greater-than-or-equal constraint. Matches any values that are greater than or equal to the given value. */
    gte?: Maybe<Scalars["Float"]>;
    /** In-array constraint. */
    in?: Maybe<Array<Scalars["Float"]>>;
    /** Less-than constraint. Matches any values that are less than the given value. */
    lt?: Maybe<Scalars["Float"]>;
    /** Less-than-or-equal constraint. Matches any values that are less than or equal to the given value. */
    lte?: Maybe<Scalars["Float"]>;
    /** Not-equals constraint. */
    neq?: Maybe<Scalars["Float"]>;
    /** Not-in-array constraint. */
    nin?: Maybe<Array<Scalars["Float"]>>;
    /** Null constraint. Matches any non-null values if the given value is false, otherwise it matches null values. */
    null?: Maybe<Scalars["Boolean"]>;
    /** Compound filters, all of which need to be matched by the estimate. */
    or?: Maybe<Array<NullableNumberComparator>>;
};
/** Issue estimate sorting options. */
export declare type EstimateSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
/** An external authenticated (e.g., through Slack) user which doesn't have a Linear account, but can create and update entities in Linear from the external system that authenticated them. */
export declare type ExternalUser = Node & {
    __typename?: "ExternalUser";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** An URL to the external user's avatar image. */
    avatarUrl?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The external user's display name. Unique within each organization. Can match the display name of an actual user. */
    displayName: Scalars["String"];
    /** The external user's email address. */
    email?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The last time the external user was seen interacting with Linear. */
    lastSeen?: Maybe<Scalars["DateTime"]>;
    /** The external user's full name. */
    name: Scalars["String"];
    /** Organization the external user belongs to. */
    organization: Organization;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type ExternalUserConnection = {
    __typename?: "ExternalUserConnection";
    edges: Array<ExternalUserEdge>;
    nodes: Array<ExternalUser>;
    pageInfo: PageInfo;
};
export declare type ExternalUserEdge = {
    __typename?: "ExternalUserEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: ExternalUser;
};
/** A facet. Facets are joins between entities. A facet can tie a custom view to a project, or a a project to a roadmap for example. */
export declare type Facet = Node & {
    __typename?: "Facet";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The sort order of the facet. */
    sortOrder: Scalars["Float"];
    /** The owning feed user. */
    sourceFeedUser?: Maybe<User>;
    /** The owning initiative. */
    sourceInitiative?: Maybe<Initiative>;
    /** The owning organization. */
    sourceOrganization?: Maybe<Organization>;
    /** The owning page. */
    sourcePage?: Maybe<FacetPageSource>;
    /** The owning project. */
    sourceProject?: Maybe<Project>;
    /** The owning team. */
    sourceTeam?: Maybe<Team>;
    /** The targeted custom view. */
    targetCustomView?: Maybe<CustomView>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare enum FacetPageSource {
    Feed = "feed",
    Projects = "projects",
    TeamIssues = "teamIssues"
}
/** User favorites presented in the sidebar. */
export declare type Favorite = Node & {
    __typename?: "Favorite";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** Children of the favorite. Only applies to favorites of type folder. */
    children: FavoriteConnection;
    /** [Internal] Returns the color of the favorite's icon. Unavailable for avatars and views with fixed icons (e.g. cycle). */
    color?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The favorited custom view. */
    customView?: Maybe<CustomView>;
    /** The favorited customer. */
    customer?: Maybe<Customer>;
    /** The favorited cycle. */
    cycle?: Maybe<Cycle>;
    /** The favorited dashboard. */
    dashboard?: Maybe<Dashboard>;
    /** [Internal] Detail text for favorite's `title` (e.g. team's name for a project). */
    detail?: Maybe<Scalars["String"]>;
    /** The favorited document. */
    document?: Maybe<Document>;
    /** [INTERNAL] The favorited facet. */
    facet?: Maybe<Facet>;
    /** The name of the folder. Only applies to favorites of type folder. */
    folderName?: Maybe<Scalars["String"]>;
    /** [Internal] Name of the favorite's icon. Unavailable for standard views, issues, and avatars */
    icon?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The favorited initiative. */
    initiative?: Maybe<Initiative>;
    /** The targeted tab of the initiative. */
    initiativeTab?: Maybe<InitiativeTab>;
    /** The favorited issue. */
    issue?: Maybe<Issue>;
    /** The favorited label. */
    label?: Maybe<IssueLabel>;
    /** The owner of the favorite. */
    owner: User;
    /** The parent folder of the favorite. */
    parent?: Maybe<Favorite>;
    /** The team of the favorited predefined view. */
    predefinedViewTeam?: Maybe<Team>;
    /** The type of favorited predefined view. */
    predefinedViewType?: Maybe<Scalars["String"]>;
    /** The favorited project. */
    project?: Maybe<Project>;
    /** The targeted tab of the project. */
    projectTab?: Maybe<ProjectTab>;
    /** [DEPRECATED] The favorited team of the project. */
    projectTeam?: Maybe<Team>;
    /** The favorited roadmap. */
    roadmap?: Maybe<Roadmap>;
    /** The order of the item in the favorites list. */
    sortOrder: Scalars["Float"];
    /** [Internal] Favorite's title text (name of the favorite'd object or folder). */
    title: Scalars["String"];
    /** The type of the favorite. */
    type: Scalars["String"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** URL of the favorited entity. Folders return 'null' value. */
    url?: Maybe<Scalars["String"]>;
    /** The favorited user. */
    user?: Maybe<User>;
};
/** User favorites presented in the sidebar. */
export declare type FavoriteChildrenArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type FavoriteConnection = {
    __typename?: "FavoriteConnection";
    edges: Array<FavoriteEdge>;
    nodes: Array<Favorite>;
    pageInfo: PageInfo;
};
export declare type FavoriteCreateInput = {
    /** The identifier of the custom view to favorite. */
    customViewId?: Maybe<Scalars["String"]>;
    /** The identifier of the customer to favorite. */
    customerId?: Maybe<Scalars["String"]>;
    /** The identifier of the cycle to favorite. */
    cycleId?: Maybe<Scalars["String"]>;
    /** The identifier of the dashboard to favorite. */
    dashboardId?: Maybe<Scalars["String"]>;
    /** The identifier of the document to favorite. */
    documentId?: Maybe<Scalars["String"]>;
    /** The identifier of the facet to favorite. */
    facetId?: Maybe<Scalars["String"]>;
    /** The name of the favorite folder. */
    folderName?: Maybe<Scalars["String"]>;
    /** The identifier. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** [INTERNAL] The identifier of the initiative to favorite. */
    initiativeId?: Maybe<Scalars["String"]>;
    /** The tab of the initiative to favorite. */
    initiativeTab?: Maybe<InitiativeTab>;
    /** The identifier of the issue to favorite. */
    issueId?: Maybe<Scalars["String"]>;
    /** The identifier of the label to favorite. */
    labelId?: Maybe<Scalars["String"]>;
    /** The parent folder of the favorite. */
    parentId?: Maybe<Scalars["String"]>;
    /** The identifier of team for the predefined view to favorite. */
    predefinedViewTeamId?: Maybe<Scalars["String"]>;
    /** The type of the predefined view to favorite. */
    predefinedViewType?: Maybe<Scalars["String"]>;
    /** The identifier of the project to favorite. */
    projectId?: Maybe<Scalars["String"]>;
    /** The tab of the project to favorite. */
    projectTab?: Maybe<ProjectTab>;
    /** The identifier of the roadmap to favorite. */
    roadmapId?: Maybe<Scalars["String"]>;
    /** The position of the item in the favorites list. */
    sortOrder?: Maybe<Scalars["Float"]>;
    /** The identifier of the user to favorite. */
    userId?: Maybe<Scalars["String"]>;
};
export declare type FavoriteEdge = {
    __typename?: "FavoriteEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: Favorite;
};
export declare type FavoritePayload = {
    __typename?: "FavoritePayload";
    /** The object that was added as a favorite. */
    favorite: Favorite;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type FavoriteUpdateInput = {
    /** The name of the favorite folder. */
    folderName?: Maybe<Scalars["String"]>;
    /** The identifier (in UUID v4 format) of the folder to move the favorite under. */
    parentId?: Maybe<Scalars["String"]>;
    /** The position of the item in the favorites list. */
    sortOrder?: Maybe<Scalars["Float"]>;
};
/** Feed item filtering options */
export declare type FeedItemFilter = {
    /** Compound filters, all of which need to be matched by the feed item. */
    and?: Maybe<Array<FeedItemFilter>>;
    /** Filters that the feed item author must satisfy. */
    author?: Maybe<UserFilter>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Compound filters, one of which need to be matched by the feed item. */
    or?: Maybe<Array<FeedItemFilter>>;
    /** Filters that the feed item's project update must satisfy. */
    projectUpdate?: Maybe<ProjectUpdateFilter>;
    /** Filters that the related feed item initiatives must satisfy. */
    relatedInitiatives?: Maybe<InitiativeCollectionFilter>;
    /** Filters that the related feed item team must satisfy. */
    relatedTeams?: Maybe<TeamCollectionFilter>;
    /** Comparator for the project or initiative update health: onTrack, atRisk, offTrack */
    updateHealth?: Maybe<StringComparator>;
    /** Comparator for the update type: initiative, project */
    updateType?: Maybe<StringComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** Cadence to generate feed summary */
export declare enum FeedSummarySchedule {
    Daily = "daily",
    Never = "never",
    Weekly = "weekly"
}
/** By which resolution is frequency defined. */
export declare enum FrequencyResolutionType {
    Daily = "daily",
    Weekly = "weekly"
}
export declare type FrontAttachmentPayload = {
    __typename?: "FrontAttachmentPayload";
    /** The issue attachment that was created. */
    attachment: Attachment;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type FrontSettingsInput = {
    /** Whether a ticket should be automatically reopened when its linked Linear issue is cancelled. */
    automateTicketReopeningOnCancellation?: Maybe<Scalars["Boolean"]>;
    /** Whether a ticket should be automatically reopened when a comment is posted on its linked Linear issue */
    automateTicketReopeningOnComment?: Maybe<Scalars["Boolean"]>;
    /** Whether a ticket should be automatically reopened when its linked Linear issue is completed. */
    automateTicketReopeningOnCompletion?: Maybe<Scalars["Boolean"]>;
    /** Whether an internal message should be added when someone comments on an issue. */
    sendNoteOnComment?: Maybe<Scalars["Boolean"]>;
    /** Whether an internal message should be added when a Linear issue changes status (for status types except completed or canceled). */
    sendNoteOnStatusChange?: Maybe<Scalars["Boolean"]>;
};
/** A trigger that updates the issue status according to Git automations. */
export declare type GitAutomationState = Node & {
    __typename?: "GitAutomationState";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /**
     * [DEPRECATED] The target branch, if null, the automation will be triggered on any branch.
     * @deprecated Use targetBranch instead.
     */
    branchPattern?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The event that triggers the automation. */
    event: GitAutomationStates;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The associated workflow state. */
    state?: Maybe<WorkflowState>;
    /** The target branch associated to this automation state. */
    targetBranch?: Maybe<GitAutomationTargetBranch>;
    /** The team to which this automation state belongs. */
    team: Team;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type GitAutomationStateConnection = {
    __typename?: "GitAutomationStateConnection";
    edges: Array<GitAutomationStateEdge>;
    nodes: Array<GitAutomationState>;
    pageInfo: PageInfo;
};
export declare type GitAutomationStateCreateInput = {
    /** The event that triggers the automation. */
    event: GitAutomationStates;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The associated workflow state. If null, will override default behaviour and take no action. */
    stateId?: Maybe<Scalars["String"]>;
    /** The associated target branch. If null, all branches are targeted. */
    targetBranchId?: Maybe<Scalars["String"]>;
    /** The team associated with the automation state. */
    teamId: Scalars["String"];
};
export declare type GitAutomationStateEdge = {
    __typename?: "GitAutomationStateEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: GitAutomationState;
};
export declare type GitAutomationStatePayload = {
    __typename?: "GitAutomationStatePayload";
    /** The automation state that was created or updated. */
    gitAutomationState: GitAutomationState;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type GitAutomationStateUpdateInput = {
    /** The event that triggers the automation. */
    event?: Maybe<GitAutomationStates>;
    /** The associated workflow state. */
    stateId?: Maybe<Scalars["String"]>;
    /** The associated target branch. If null, all branches are targeted. */
    targetBranchId?: Maybe<Scalars["String"]>;
};
/** The various states of a pull/merge request. */
export declare enum GitAutomationStates {
    Draft = "draft",
    Merge = "merge",
    Mergeable = "mergeable",
    Review = "review",
    Start = "start"
}
/** A Git target branch for which there are automations (GitAutomationState). */
export declare type GitAutomationTargetBranch = Node & {
    __typename?: "GitAutomationTargetBranch";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** Automation states associated with the target branch. */
    automationStates: GitAutomationStateConnection;
    /** The target branch pattern. */
    branchPattern: Scalars["String"];
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** Whether the branch pattern is a regular expression. */
    isRegex: Scalars["Boolean"];
    /** The team to which this Git target branch automation belongs. */
    team: Team;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
/** A Git target branch for which there are automations (GitAutomationState). */
export declare type GitAutomationTargetBranchAutomationStatesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type GitAutomationTargetBranchCreateInput = {
    /** The target branch pattern. */
    branchPattern: Scalars["String"];
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** Whether the branch pattern is a regular expression. */
    isRegex?: Maybe<Scalars["Boolean"]>;
    /** The team associated with the Git target branch automation. */
    teamId: Scalars["String"];
};
export declare type GitAutomationTargetBranchPayload = {
    __typename?: "GitAutomationTargetBranchPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
    /** The Git target branch automation that was created or updated. */
    targetBranch: GitAutomationTargetBranch;
};
export declare type GitAutomationTargetBranchUpdateInput = {
    /** The target branch pattern. */
    branchPattern?: Maybe<Scalars["String"]>;
    /** Whether the branch pattern is a regular expression. */
    isRegex?: Maybe<Scalars["Boolean"]>;
};
export declare type GitHubCommitIntegrationPayload = {
    __typename?: "GitHubCommitIntegrationPayload";
    /** The integration that was created or updated. */
    integration?: Maybe<Integration>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
    /** The webhook secret to provide to GitHub. */
    webhookSecret: Scalars["String"];
};
export declare type GitHubEnterpriseServerInstallVerificationPayload = {
    __typename?: "GitHubEnterpriseServerInstallVerificationPayload";
    /** Has the install been successful. */
    success: Scalars["Boolean"];
};
export declare type GitHubEnterpriseServerPayload = {
    __typename?: "GitHubEnterpriseServerPayload";
    /** The app install address. */
    installUrl: Scalars["String"];
    /** The integration that was created or updated. */
    integration?: Maybe<Integration>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** The setup address. */
    setupUrl: Scalars["String"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
    /** The webhook secret to provide to GitHub. */
    webhookSecret: Scalars["String"];
};
export declare type GitHubImportSettingsInput = {
    /** A map storing all available issue labels per repository */
    labels?: Maybe<Scalars["JSONObject"]>;
    /** The avatar URL for the GitHub organization. */
    orgAvatarUrl: Scalars["String"];
    /** The GitHub organization's name. */
    orgLogin: Scalars["String"];
    /** The type of Github org */
    orgType: GithubOrgType;
    /** The names of the repositories connected for the GitHub integration. */
    repositories: Array<GitHubRepoInput>;
};
export declare type GitHubPersonalSettingsInput = {
    /** The GitHub user's name. */
    login: Scalars["String"];
};
export declare type GitHubRepoInput = {
    /** Whether the repository is archived. */
    archived?: Maybe<Scalars["Boolean"]>;
    /** The full name of the repository. */
    fullName: Scalars["String"];
    /** The GitHub repo id. */
    id: Scalars["Float"];
};
export declare type GitHubRepoMappingInput = {
    /** Whether the sync for this mapping is bidirectional. */
    bidirectional?: Maybe<Scalars["Boolean"]>;
    /** Whether this mapping is the default one for issue creation. */
    default?: Maybe<Scalars["Boolean"]>;
    /** Labels to filter incoming GitHub issue creation by. */
    gitHubLabels?: Maybe<Array<Scalars["String"]>>;
    /** The GitHub repo id. */
    gitHubRepoId: Scalars["Float"];
    /** The unique identifier for this mapping. */
    id: Scalars["String"];
    /** The Linear team id to map to the given project. */
    linearTeamId: Scalars["String"];
};
export declare type GitHubSettingsInput = {
    /** The avatar URL for the GitHub organization. */
    orgAvatarUrl?: Maybe<Scalars["String"]>;
    /** The GitHub organization's name. */
    orgLogin: Scalars["String"];
    /** The type of Github org */
    orgType?: Maybe<GithubOrgType>;
    pullRequestReviewTool?: Maybe<PullRequestReviewTool>;
    /** The names of the repositories connected for the GitHub integration. */
    repositories?: Maybe<Array<GitHubRepoInput>>;
    /** Mapping of team to repository for syncing. */
    repositoriesMapping?: Maybe<Array<GitHubRepoMappingInput>>;
};
export declare type GitLabIntegrationCreatePayload = {
    __typename?: "GitLabIntegrationCreatePayload";
    /** The integration that was created or updated. */
    integration?: Maybe<Integration>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
    /** The webhook secret to provide to GitLab. */
    webhookSecret: Scalars["String"];
};
export declare type GitLabSettingsInput = {
    /** The ISO timestamp the GitLab access token expires. */
    expiresAt?: Maybe<Scalars["String"]>;
    /** Whether the token is limited to a read-only scope. */
    readonly?: Maybe<Scalars["Boolean"]>;
    /** The self-hosted URL of the GitLab instance. */
    url?: Maybe<Scalars["String"]>;
};
/** [Internal] The kind of link between an issue and a pull request. */
export declare enum GitLinkKind {
    Closes = "closes",
    Contributes = "contributes",
    Links = "links"
}
export declare enum GithubOrgType {
    Organization = "organization",
    User = "user"
}
export declare type GoogleSheetsExportSettings = {
    /** Whether the export is enabled. */
    enabled?: Maybe<Scalars["Boolean"]>;
    /** The ID of the target sheet (tab) within the Google Sheet. */
    sheetId?: Maybe<Scalars["Float"]>;
    /** The ID of the exported Google Sheet. */
    spreadsheetId?: Maybe<Scalars["String"]>;
    /** The URL of the exported Google Sheet. */
    spreadsheetUrl?: Maybe<Scalars["String"]>;
    /** The date of the most recent export. */
    updatedAt?: Maybe<Scalars["DateTime"]>;
};
export declare type GoogleSheetsSettingsInput = {
    /** The export settings for issues. */
    issue?: Maybe<GoogleSheetsExportSettings>;
    /** The export settings for projects. */
    project?: Maybe<GoogleSheetsExportSettings>;
    /** [Deprecated] The ID of the target sheet (tab) within the Google Sheet. */
    sheetId?: Maybe<Scalars["Float"]>;
    /** [Deprecated] The ID of the exported Google Sheet. */
    spreadsheetId?: Maybe<Scalars["String"]>;
    /** [Deprecated] The URL of the exported Google Sheet. */
    spreadsheetUrl?: Maybe<Scalars["String"]>;
    /** [Deprecated] The date of the most recent export. */
    updatedIssuesAt?: Maybe<Scalars["DateTime"]>;
};
export declare type GoogleUserAccountAuthInput = {
    /** Code returned from Google's OAuth flow. */
    code: Scalars["String"];
    /** An optional parameter to disable new user signup and force login. Default: false. */
    disallowSignup?: Maybe<Scalars["Boolean"]>;
    /** An optional invite link for an organization used to populate available organizations. */
    inviteLink?: Maybe<Scalars["String"]>;
    /** The URI to redirect the user to. */
    redirectUri?: Maybe<Scalars["String"]>;
    /** The timezone of the user's browser. */
    timezone: Scalars["String"];
};
/** Comparator for identifiers. */
export declare type IdComparator = {
    /** Equals constraint. */
    eq?: Maybe<Scalars["ID"]>;
    /** In-array constraint. */
    in?: Maybe<Array<Scalars["ID"]>>;
    /** Not-equals constraint. */
    neq?: Maybe<Scalars["ID"]>;
    /** Not-in-array constraint. */
    nin?: Maybe<Array<Scalars["ID"]>>;
};
export declare type ImageUploadFromUrlPayload = {
    __typename?: "ImageUploadFromUrlPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
    /** The URL containing the image. */
    url?: Maybe<Scalars["String"]>;
};
export declare type InheritanceEntityMapping = {
    /** Mapping of the IssueLabel ID to the new IssueLabel name. */
    issueLabels?: Maybe<Scalars["JSONObject"]>;
    /** Mapping of the WorkflowState ID to the new WorkflowState ID. */
    workflowStates: Scalars["JSONObject"];
};
/** An initiative to group projects. */
export declare type Initiative = Node & {
    __typename?: "Initiative";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The initiative's color. */
    color?: Maybe<Scalars["String"]>;
    /** The time at which the initiative was moved into completed status. */
    completedAt?: Maybe<Scalars["DateTime"]>;
    /** The initiative's content in markdown format. */
    content?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who created the initiative. */
    creator?: Maybe<User>;
    /** The description of the initiative. */
    description?: Maybe<Scalars["String"]>;
    /** The resolution of the reminder frequency. */
    frequencyResolution: FrequencyResolutionType;
    /** The health of the initiative. */
    health?: Maybe<InitiativeUpdateHealthType>;
    /** The time at which the initiative health was updated. */
    healthUpdatedAt?: Maybe<Scalars["DateTime"]>;
    /** History entries associated with the initiative. */
    history: InitiativeHistoryConnection;
    /** The icon of the initiative. */
    icon?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** Settings for all integrations associated with that initiative. */
    integrationsSettings?: Maybe<IntegrationsSettings>;
    /** The last initiative update posted for this initiative. */
    lastUpdate?: Maybe<InitiativeUpdate>;
    /** Links associated with the initiative. */
    links: EntityExternalLinkConnection;
    /** The name of the initiative. */
    name: Scalars["String"];
    /** The organization of the initiative. */
    organization: Organization;
    /** The user who owns the initiative. */
    owner?: Maybe<User>;
    /** Projects associated with the initiative. */
    projects: ProjectConnection;
    /** The initiative's unique URL slug. */
    slugId: Scalars["String"];
    /** The sort order of the initiative within the organization. */
    sortOrder: Scalars["Float"];
    /** The time at which the initiative was moved into active status. */
    startedAt?: Maybe<Scalars["DateTime"]>;
    /** The status of the initiative. One of Planned, Active, Completed */
    status: InitiativeStatus;
    /** The estimated completion date of the initiative. */
    targetDate?: Maybe<Scalars["TimelessDate"]>;
    /** The resolution of the initiative's estimated completion date. */
    targetDateResolution?: Maybe<DateResolutionType>;
    /** A flag that indicates whether the initiative is in the trash bin. */
    trashed?: Maybe<Scalars["Boolean"]>;
    /** The frequency at which to prompt for updates. When not set, reminders are inherited from workspace. */
    updateReminderFrequency?: Maybe<Scalars["Float"]>;
    /** The n-weekly frequency at which to prompt for updates. When not set, reminders are inherited from workspace. */
    updateReminderFrequencyInWeeks?: Maybe<Scalars["Float"]>;
    /** The day at which to prompt for updates. */
    updateRemindersDay?: Maybe<Day>;
    /** The hour at which to prompt for updates. */
    updateRemindersHour?: Maybe<Scalars["Float"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** Initiative URL. */
    url: Scalars["String"];
};
/** An initiative to group projects. */
export declare type InitiativeHistoryArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An initiative to group projects. */
export declare type InitiativeLinksArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An initiative to group projects. */
export declare type InitiativeProjectsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A generic payload return from entity archive mutations. */
export declare type InitiativeArchivePayload = ArchivePayload & {
    __typename?: "InitiativeArchivePayload";
    /** The archived/unarchived entity. Null if entity was deleted. */
    entity?: Maybe<Initiative>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** Initiative collection filtering options. */
export declare type InitiativeCollectionFilter = {
    /** Filters that the initiative must be an ancestor of. */
    ancestors?: Maybe<InitiativeCollectionFilter>;
    /** Compound filters, all of which need to be matched by the initiative. */
    and?: Maybe<Array<InitiativeCollectionFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the initiative creator must satisfy. */
    creator?: Maybe<UserFilter>;
    /** Filters that needs to be matched by all initiatives. */
    every?: Maybe<InitiativeFilter>;
    /** Comparator for the initiative health: onTrack, atRisk, offTrack */
    health?: Maybe<StringComparator>;
    /** Comparator for the initiative health (with age): onTrack, atRisk, offTrack, outdated, noUpdate */
    healthWithAge?: Maybe<StringComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the collection length. */
    length?: Maybe<NumberComparator>;
    /** Comparator for the initiative name. */
    name?: Maybe<StringComparator>;
    /** Compound filters, one of which need to be matched by the initiative. */
    or?: Maybe<Array<InitiativeCollectionFilter>>;
    /** Filters that the initiative owner must satisfy. */
    owner?: Maybe<UserFilter>;
    /** Comparator for the initiative slug ID. */
    slugId?: Maybe<StringComparator>;
    /** Filters that needs to be matched by some initiatives. */
    some?: Maybe<InitiativeFilter>;
    /** Comparator for the initiative status: Planned, Active, Completed */
    status?: Maybe<StringComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type InitiativeConnection = {
    __typename?: "InitiativeConnection";
    edges: Array<InitiativeEdge>;
    nodes: Array<Initiative>;
    pageInfo: PageInfo;
};
/** The properties of the initiative to create. */
export declare type InitiativeCreateInput = {
    /** The initiative's color. */
    color?: Maybe<Scalars["String"]>;
    /** The initiative's content in markdown format. */
    content?: Maybe<Scalars["String"]>;
    /** The description of the initiative. */
    description?: Maybe<Scalars["String"]>;
    /** The initiative's icon. */
    icon?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The name of the initiative. */
    name: Scalars["String"];
    /** The owner of the initiative. */
    ownerId?: Maybe<Scalars["String"]>;
    /** The sort order of the initiative within the organization. */
    sortOrder?: Maybe<Scalars["Float"]>;
    /** The initiative's status. */
    status?: Maybe<InitiativeStatus>;
    /** The estimated completion date of the initiative. */
    targetDate?: Maybe<Scalars["TimelessDate"]>;
    /** The resolution of the initiative's estimated completion date. */
    targetDateResolution?: Maybe<DateResolutionType>;
};
export declare type InitiativeEdge = {
    __typename?: "InitiativeEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: Initiative;
};
/** Initiative filtering options. */
export declare type InitiativeFilter = {
    /** Filters that the initiative must be an ancestor of. */
    ancestors?: Maybe<InitiativeCollectionFilter>;
    /** Compound filters, all of which need to be matched by the initiative. */
    and?: Maybe<Array<InitiativeFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the initiative creator must satisfy. */
    creator?: Maybe<UserFilter>;
    /** Comparator for the initiative health: onTrack, atRisk, offTrack */
    health?: Maybe<StringComparator>;
    /** Comparator for the initiative health (with age): onTrack, atRisk, offTrack, outdated, noUpdate */
    healthWithAge?: Maybe<StringComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the initiative name. */
    name?: Maybe<StringComparator>;
    /** Compound filters, one of which need to be matched by the initiative. */
    or?: Maybe<Array<InitiativeFilter>>;
    /** Filters that the initiative owner must satisfy. */
    owner?: Maybe<UserFilter>;
    /** Comparator for the initiative slug ID. */
    slugId?: Maybe<StringComparator>;
    /** Comparator for the initiative status: Planned, Active, Completed */
    status?: Maybe<StringComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** A initiative history containing relevant change events. */
export declare type InitiativeHistory = Node & {
    __typename?: "InitiativeHistory";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The events that happened while recording that history. */
    entries: Scalars["JSONObject"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The initiative that the history is associated with. */
    initiative: Initiative;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type InitiativeHistoryConnection = {
    __typename?: "InitiativeHistoryConnection";
    edges: Array<InitiativeHistoryEdge>;
    nodes: Array<InitiativeHistory>;
    pageInfo: PageInfo;
};
export declare type InitiativeHistoryEdge = {
    __typename?: "InitiativeHistoryEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: InitiativeHistory;
};
/** An initiative related notification. */
export declare type InitiativeNotification = Entity & Node & Notification & {
    __typename?: "InitiativeNotification";
    /** The user that caused the notification. */
    actor?: Maybe<User>;
    /** [Internal] Notification actor initials if avatar is not available. */
    actorAvatarColor: Scalars["String"];
    /** [Internal] Notification avatar URL. */
    actorAvatarUrl?: Maybe<Scalars["String"]>;
    /** [Internal] Notification actor initials if avatar is not available. */
    actorInitials?: Maybe<Scalars["String"]>;
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The bot that caused the notification. */
    botActor?: Maybe<ActorBot>;
    /** Related comment ID. Null if the notification is not related to a comment. */
    commentId?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /**
     * The time at when an email reminder for this notification was sent to the user. Null, if no email
     *     reminder has been sent.
     */
    emailedAt?: Maybe<Scalars["DateTime"]>;
    /** The external user that caused the notification. */
    externalUserActor?: Maybe<ExternalUser>;
    /** [Internal] Notifications with the same grouping key will be grouped together in the UI. */
    groupingKey: Scalars["String"];
    /** [Internal] Priority of the notification with the same grouping key. Higher number means higher priority. If priority is the same, notifications should be sorted by `createdAt`. */
    groupingPriority: Scalars["Float"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** [Internal] Inbox URL for the notification. */
    inboxUrl: Scalars["String"];
    /** Related initiative ID. */
    initiativeId: Scalars["String"];
    /** Related initiative update ID. */
    initiativeUpdateId?: Maybe<Scalars["String"]>;
    /** [Internal] If notification actor was Linear. */
    isLinearActor: Scalars["Boolean"];
    /** [Internal] Issue's status type for issue notifications. */
    issueStatusType?: Maybe<Scalars["String"]>;
    /** Related parent comment ID. Null if the notification is not related to a comment. */
    parentCommentId?: Maybe<Scalars["String"]>;
    /** [Internal] Project update health for new updates. */
    projectUpdateHealth?: Maybe<Scalars["String"]>;
    /** Name of the reaction emoji related to the notification. */
    reactionEmoji?: Maybe<Scalars["String"]>;
    /** The time at when the user marked the notification as read. Null, if the the user hasn't read the notification */
    readAt?: Maybe<Scalars["DateTime"]>;
    /** The time until a notification will be snoozed. After that it will appear in the inbox again. */
    snoozedUntilAt?: Maybe<Scalars["DateTime"]>;
    /** [Internal] Notification subtitle. */
    subtitle: Scalars["String"];
    /** [Internal] Notification title. */
    title: Scalars["String"];
    /** Notification type. */
    type: Scalars["String"];
    /** The time at which a notification was unsnoozed.. */
    unsnoozedAt?: Maybe<Scalars["DateTime"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** [Internal] URL to the target of the notification. */
    url: Scalars["String"];
    /** The user that received the notification. */
    user: User;
};
/** An initiative notification subscription. */
export declare type InitiativeNotificationSubscription = Entity & Node & NotificationSubscription & {
    __typename?: "InitiativeNotificationSubscription";
    /** Whether the subscription is active or not. */
    active: Scalars["Boolean"];
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The type of view to which the notification subscription context is associated with. */
    contextViewType?: Maybe<ContextViewType>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The contextual custom view associated with the notification subscription. */
    customView?: Maybe<CustomView>;
    /** The customer associated with the notification subscription. */
    customer?: Maybe<Customer>;
    /** The contextual cycle view associated with the notification subscription. */
    cycle?: Maybe<Cycle>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The initiative subscribed to. */
    initiative: Initiative;
    /** The contextual label view associated with the notification subscription. */
    label?: Maybe<IssueLabel>;
    /** The type of subscription. */
    notificationSubscriptionTypes: Array<Scalars["String"]>;
    /** The contextual project view associated with the notification subscription. */
    project?: Maybe<Project>;
    /** The user that subscribed to receive notifications. */
    subscriber: User;
    /** The team associated with the notification subscription. */
    team?: Maybe<Team>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The user view associated with the notification subscription. */
    user?: Maybe<User>;
    /** The type of user view to which the notification subscription context is associated with. */
    userContextViewType?: Maybe<UserContextViewType>;
};
/** The payload returned by the initiative mutations. */
export declare type InitiativePayload = {
    __typename?: "InitiativePayload";
    /** The initiative that was created or updated. */
    initiative: Initiative;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** A relation representing the dependency between two initiatives. */
export declare type InitiativeRelation = Node & {
    __typename?: "InitiativeRelation";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The parent initiative. */
    initiative: Initiative;
    /** The child initiative. */
    relatedInitiative: Initiative;
    /** The sort order of the relation within the initiative. */
    sortOrder: Scalars["Float"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The last user who created or modified the relation. */
    user?: Maybe<User>;
};
export declare type InitiativeRelationConnection = {
    __typename?: "InitiativeRelationConnection";
    edges: Array<InitiativeRelationEdge>;
    nodes: Array<InitiativeRelation>;
    pageInfo: PageInfo;
};
export declare type InitiativeRelationCreateInput = {
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The identifier of the parent initiative. */
    initiativeId: Scalars["String"];
    /** The identifier of the child initiative. */
    relatedInitiativeId: Scalars["String"];
    /** The sort order of the initiative relation. */
    sortOrder?: Maybe<Scalars["Float"]>;
};
export declare type InitiativeRelationEdge = {
    __typename?: "InitiativeRelationEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: InitiativeRelation;
};
export declare type InitiativeRelationPayload = {
    __typename?: "InitiativeRelationPayload";
    /** The initiative relation that was created or updated. */
    initiativeRelation: InitiativeRelation;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** The properties of the initiativeRelation to update. */
export declare type InitiativeRelationUpdateInput = {
    /** The sort order of the initiative relation. */
    sortOrder?: Maybe<Scalars["Float"]>;
};
export declare enum InitiativeStatus {
    Active = "Active",
    Completed = "Completed",
    Planned = "Planned"
}
/** Different tabs available inside an initiative. */
export declare enum InitiativeTab {
    Overview = "overview",
    Projects = "projects"
}
/** Join table between projects and initiatives. */
export declare type InitiativeToProject = Node & {
    __typename?: "InitiativeToProject";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The initiative that the project is associated with. */
    initiative: Initiative;
    /** The project that the initiative is associated with. */
    project: Project;
    /** The sort order of the project within the initiative. */
    sortOrder: Scalars["String"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type InitiativeToProjectConnection = {
    __typename?: "InitiativeToProjectConnection";
    edges: Array<InitiativeToProjectEdge>;
    nodes: Array<InitiativeToProject>;
    pageInfo: PageInfo;
};
/** The properties of the initiativeToProject to create. */
export declare type InitiativeToProjectCreateInput = {
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The identifier of the initiative. */
    initiativeId: Scalars["String"];
    /** The identifier of the project. */
    projectId: Scalars["String"];
    /** The sort order for the project within its organization. */
    sortOrder?: Maybe<Scalars["Float"]>;
};
export declare type InitiativeToProjectEdge = {
    __typename?: "InitiativeToProjectEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: InitiativeToProject;
};
/** The result of a initiativeToProject mutation. */
export declare type InitiativeToProjectPayload = {
    __typename?: "InitiativeToProjectPayload";
    /** The initiativeToProject that was created or updated. */
    initiativeToProject: InitiativeToProject;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** The properties of the initiativeToProject to update. */
export declare type InitiativeToProjectUpdateInput = {
    /** The sort order for the project within its organization. */
    sortOrder?: Maybe<Scalars["Float"]>;
};
/** An initiative update. */
export declare type InitiativeUpdate = Node & {
    __typename?: "InitiativeUpdate";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The update content in markdown format. */
    body: Scalars["String"];
    /** [Internal] The content of the update as a Prosemirror document. */
    bodyData: Scalars["String"];
    /** Comments associated with the initiative update. */
    comments: CommentConnection;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The diff between the current update and the previous one. */
    diff?: Maybe<Scalars["JSONObject"]>;
    /** The diff between the current update and the previous one, formatted as markdown. */
    diffMarkdown?: Maybe<Scalars["String"]>;
    /** The time the update was edited. */
    editedAt?: Maybe<Scalars["DateTime"]>;
    /** The health at the time of the update. */
    health: InitiativeUpdateHealthType;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** [Internal] Serialized JSON representing current state of the initiative properties when posting the initiative update. */
    infoSnapshot?: Maybe<Scalars["JSONObject"]>;
    /** The initiative that the update is associated with. */
    initiative: Initiative;
    /** Whether initiative update diff should be hidden. */
    isDiffHidden: Scalars["Boolean"];
    /** Whether the initiative update is stale. */
    isStale: Scalars["Boolean"];
    /** Emoji reaction summary, grouped by emoji type. */
    reactionData: Scalars["JSONObject"];
    /** Reactions associated with the initiative update. */
    reactions: Array<Reaction>;
    /** The update's unique URL slug. */
    slugId: Scalars["String"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The URL to the initiative update. */
    url: Scalars["String"];
    /** The user who wrote the update. */
    user: User;
};
/** An initiative update. */
export declare type InitiativeUpdateCommentsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CommentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A generic payload return from entity archive mutations. */
export declare type InitiativeUpdateArchivePayload = ArchivePayload & {
    __typename?: "InitiativeUpdateArchivePayload";
    /** The archived/unarchived entity. Null if entity was deleted. */
    entity?: Maybe<InitiativeUpdate>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type InitiativeUpdateConnection = {
    __typename?: "InitiativeUpdateConnection";
    edges: Array<InitiativeUpdateEdge>;
    nodes: Array<InitiativeUpdate>;
    pageInfo: PageInfo;
};
export declare type InitiativeUpdateCreateInput = {
    /** The content of the update in markdown format. */
    body?: Maybe<Scalars["String"]>;
    /** [Internal] The content of the update as a Prosemirror document. */
    bodyData?: Maybe<Scalars["JSON"]>;
    /** The health of the initiative at the time of the update. */
    health?: Maybe<InitiativeUpdateHealthType>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The initiative to associate the update with. */
    initiativeId: Scalars["String"];
    /** Whether the diff between the current update and the previous one should be hidden. */
    isDiffHidden?: Maybe<Scalars["Boolean"]>;
};
export declare type InitiativeUpdateEdge = {
    __typename?: "InitiativeUpdateEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: InitiativeUpdate;
};
/** Options for filtering initiative updates. */
export declare type InitiativeUpdateFilter = {
    /** Compound filters, all of which need to be matched by the InitiativeUpdate. */
    and?: Maybe<Array<InitiativeUpdateFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Filters that the initiative update initiative must satisfy. */
    initiative?: Maybe<InitiativeFilter>;
    /** Compound filters, one of which need to be matched by the InitiativeUpdate. */
    or?: Maybe<Array<InitiativeUpdateFilter>>;
    /** Filters that the initiative updates reactions must satisfy. */
    reactions?: Maybe<ReactionCollectionFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
    /** Filters that the initiative update creator must satisfy. */
    user?: Maybe<UserFilter>;
};
/** The health type when the update is created. */
export declare enum InitiativeUpdateHealthType {
    AtRisk = "atRisk",
    OffTrack = "offTrack",
    OnTrack = "onTrack"
}
/** The properties of the initiative to update. */
export declare type InitiativeUpdateInput = {
    /** The initiative's color. */
    color?: Maybe<Scalars["String"]>;
    /** The initiative's content in markdown format. */
    content?: Maybe<Scalars["String"]>;
    /** The description of the initiative. */
    description?: Maybe<Scalars["String"]>;
    /** The frequency resolution. */
    frequencyResolution?: Maybe<FrequencyResolutionType>;
    /** The initiative's icon. */
    icon?: Maybe<Scalars["String"]>;
    /** The name of the initiative. */
    name?: Maybe<Scalars["String"]>;
    /** The owner of the initiative. */
    ownerId?: Maybe<Scalars["String"]>;
    /** The sort order of the initiative within the organization. */
    sortOrder?: Maybe<Scalars["Float"]>;
    /** The initiative's status. */
    status?: Maybe<InitiativeStatus>;
    /** The estimated completion date of the initiative. */
    targetDate?: Maybe<Scalars["TimelessDate"]>;
    /** The resolution of the initiative's estimated completion date. */
    targetDateResolution?: Maybe<DateResolutionType>;
    /** Whether the initiative has been trashed. */
    trashed?: Maybe<Scalars["Boolean"]>;
    /** The frequency at which to prompt for updates. When not set, reminders are inherited from workspace. */
    updateReminderFrequency?: Maybe<Scalars["Float"]>;
    /** The n-weekly frequency at which to prompt for updates. When not set, reminders are inherited from workspace. */
    updateReminderFrequencyInWeeks?: Maybe<Scalars["Float"]>;
    /** The day at which to prompt for updates. */
    updateRemindersDay?: Maybe<Day>;
    /** The hour at which to prompt for updates. */
    updateRemindersHour?: Maybe<Scalars["Int"]>;
};
export declare type InitiativeUpdatePayload = {
    __typename?: "InitiativeUpdatePayload";
    /** The initiative update that was created. */
    initiativeUpdate: InitiativeUpdate;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type InitiativeUpdateReminderPayload = {
    __typename?: "InitiativeUpdateReminderPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type InitiativeUpdateUpdateInput = {
    /** The content of the update in markdown format. */
    body?: Maybe<Scalars["String"]>;
    /** The content of the update as a Prosemirror document. */
    bodyData?: Maybe<Scalars["JSON"]>;
    /** The health of the initiative at the time of the update. */
    health?: Maybe<InitiativeUpdateHealthType>;
    /** Whether the diff between the current update and the previous one should be hidden. */
    isDiffHidden?: Maybe<Scalars["Boolean"]>;
};
/** An integration with an external service. */
export declare type Integration = Node & {
    __typename?: "Integration";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user that added the integration. */
    creator: User;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The organization that the integration is associated with. */
    organization: Organization;
    /** The integration's type. */
    service: Scalars["String"];
    /** The team that the integration is associated with. */
    team?: Maybe<Team>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type IntegrationConnection = {
    __typename?: "IntegrationConnection";
    edges: Array<IntegrationEdge>;
    nodes: Array<Integration>;
    pageInfo: PageInfo;
};
export declare type IntegrationEdge = {
    __typename?: "IntegrationEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: Integration;
};
export declare type IntegrationHasScopesPayload = {
    __typename?: "IntegrationHasScopesPayload";
    /** Whether the integration has the required scopes. */
    hasAllScopes: Scalars["Boolean"];
    /** The missing scopes. */
    missingScopes?: Maybe<Array<Scalars["String"]>>;
};
export declare type IntegrationPayload = {
    __typename?: "IntegrationPayload";
    /** The integration that was created or updated. */
    integration?: Maybe<Integration>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type IntegrationRequestInput = {
    /** Email associated with the request. */
    email?: Maybe<Scalars["String"]>;
    /** Name of the requested integration. */
    name: Scalars["String"];
};
export declare type IntegrationRequestPayload = {
    __typename?: "IntegrationRequestPayload";
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** Linear supported integration services. */
export declare enum IntegrationService {
    Airbyte = "airbyte",
    Discord = "discord",
    Email = "email",
    Figma = "figma",
    FigmaPlugin = "figmaPlugin",
    Front = "front",
    Github = "github",
    GithubCommit = "githubCommit",
    GithubEnterpriseServer = "githubEnterpriseServer",
    GithubImport = "githubImport",
    GithubPersonal = "githubPersonal",
    Gitlab = "gitlab",
    GoogleCalendarPersonal = "googleCalendarPersonal",
    GoogleSheets = "googleSheets",
    Intercom = "intercom",
    Jira = "jira",
    JiraPersonal = "jiraPersonal",
    LaunchDarkly = "launchDarkly",
    LaunchDarklyPersonal = "launchDarklyPersonal",
    Loom = "loom",
    Notion = "notion",
    Opsgenie = "opsgenie",
    PagerDuty = "pagerDuty",
    Salesforce = "salesforce",
    Sentry = "sentry",
    Slack = "slack",
    SlackAsks = "slackAsks",
    SlackCustomViewNotifications = "slackCustomViewNotifications",
    SlackInitiativePost = "slackInitiativePost",
    SlackOrgInitiativeUpdatesPost = "slackOrgInitiativeUpdatesPost",
    SlackOrgProjectUpdatesPost = "slackOrgProjectUpdatesPost",
    SlackPersonal = "slackPersonal",
    SlackPost = "slackPost",
    SlackProjectPost = "slackProjectPost",
    SlackProjectUpdatesPost = "slackProjectUpdatesPost",
    Zendesk = "zendesk"
}
export declare type IntegrationSettingsInput = {
    front?: Maybe<FrontSettingsInput>;
    gitHub?: Maybe<GitHubSettingsInput>;
    gitHubImport?: Maybe<GitHubImportSettingsInput>;
    gitHubPersonal?: Maybe<GitHubPersonalSettingsInput>;
    gitLab?: Maybe<GitLabSettingsInput>;
    googleSheets?: Maybe<GoogleSheetsSettingsInput>;
    intercom?: Maybe<IntercomSettingsInput>;
    jira?: Maybe<JiraSettingsInput>;
    jiraPersonal?: Maybe<JiraPersonalSettingsInput>;
    launchDarkly?: Maybe<LaunchDarklySettingsInput>;
    notion?: Maybe<NotionSettingsInput>;
    opsgenie?: Maybe<OpsgenieInput>;
    pagerDuty?: Maybe<PagerDutyInput>;
    sentry?: Maybe<SentrySettingsInput>;
    slack?: Maybe<SlackSettingsInput>;
    slackAsks?: Maybe<SlackAsksSettingsInput>;
    slackCustomViewNotifications?: Maybe<SlackPostSettingsInput>;
    slackInitiativePost?: Maybe<SlackPostSettingsInput>;
    slackOrgInitiativeUpdatesPost?: Maybe<SlackPostSettingsInput>;
    slackOrgProjectUpdatesPost?: Maybe<SlackPostSettingsInput>;
    slackPost?: Maybe<SlackPostSettingsInput>;
    slackProjectPost?: Maybe<SlackPostSettingsInput>;
    zendesk?: Maybe<ZendeskSettingsInput>;
};
/** Join table between templates and integrations. */
export declare type IntegrationTemplate = Node & {
    __typename?: "IntegrationTemplate";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** ID of the foreign entity in the external integration this template is for, e.g., Slack channel ID. */
    foreignEntityId?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The integration that the template is associated with. */
    integration: Integration;
    /** The template that the integration is associated with. */
    template: Template;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type IntegrationTemplateConnection = {
    __typename?: "IntegrationTemplateConnection";
    edges: Array<IntegrationTemplateEdge>;
    nodes: Array<IntegrationTemplate>;
    pageInfo: PageInfo;
};
export declare type IntegrationTemplateCreateInput = {
    /** The foreign identifier in the other service. */
    foreignEntityId?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The identifier of the integration. */
    integrationId: Scalars["String"];
    /** The identifier of the template. */
    templateId: Scalars["String"];
};
export declare type IntegrationTemplateEdge = {
    __typename?: "IntegrationTemplateEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: IntegrationTemplate;
};
export declare type IntegrationTemplatePayload = {
    __typename?: "IntegrationTemplatePayload";
    /** The IntegrationTemplate that was created or updated. */
    integrationTemplate: IntegrationTemplate;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type IntegrationUpdateInput = {
    /** The settings to update. */
    settings?: Maybe<IntegrationSettingsInput>;
};
/** The configuration of all integrations for different entities. */
export declare type IntegrationsSettings = Node & {
    __typename?: "IntegrationsSettings";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The type of view to which the integration settings context is associated with. */
    contextViewType?: Maybe<ContextViewType>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** Initiative which those settings apply to. */
    initiative?: Maybe<Initiative>;
    /** Project which those settings apply to. */
    project?: Maybe<Project>;
    /** Whether to send a Slack message when a initiate update is created. */
    slackInitiativeUpdateCreated?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when a new issue is added to triage. */
    slackIssueAddedToTriage?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when an issue is added to the custom view. */
    slackIssueAddedToView?: Maybe<Scalars["Boolean"]>;
    /**
     * Whether to send a Slack message when a new issue is created for the project or the team.
     * @deprecated No longer in use. Use `slackIssueAddedToView` instead.
     */
    slackIssueCreated?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when a comment is created on any of the project or team's issues. */
    slackIssueNewComment?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when an SLA is breached. */
    slackIssueSlaBreached?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when an SLA is at high risk. */
    slackIssueSlaHighRisk?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when any of the project or team's issues has a change in status. */
    slackIssueStatusChangedAll?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when any of the project or team's issues change to completed or cancelled. */
    slackIssueStatusChangedDone?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when a project update is created. */
    slackProjectUpdateCreated?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a new project update to team Slack channels. */
    slackProjectUpdateCreatedToTeam?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a new project update to workspace Slack channel. */
    slackProjectUpdateCreatedToWorkspace?: Maybe<Scalars["Boolean"]>;
    /** Team which those settings apply to. */
    team?: Maybe<Team>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type IntegrationsSettingsCreateInput = {
    /** The type of view to which the integration settings context is associated with. */
    contextViewType?: Maybe<ContextViewType>;
    /** The identifier of the custom view to create settings for. */
    customViewId?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The identifier of the initiative to create settings for. */
    initiativeId?: Maybe<Scalars["String"]>;
    /** The identifier of the project to create settings for. */
    projectId?: Maybe<Scalars["String"]>;
    /** Whether to send a Slack message when an initiative update is created. */
    slackInitiativeUpdateCreated?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when a new issue is added to triage. */
    slackIssueAddedToTriage?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when an issue is added to a view. */
    slackIssueAddedToView?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when a new issue is created for the project or the team. */
    slackIssueCreated?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when a comment is created on any of the project or team's issues. */
    slackIssueNewComment?: Maybe<Scalars["Boolean"]>;
    /** Whether to receive notification when an SLA has breached on Slack. */
    slackIssueSlaBreached?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when an SLA is at high risk. */
    slackIssueSlaHighRisk?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when any of the project or team's issues has a change in status. */
    slackIssueStatusChangedAll?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when any of the project or team's issues change to completed or cancelled. */
    slackIssueStatusChangedDone?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when a project update is created. */
    slackProjectUpdateCreated?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when a project update is created to team channels. */
    slackProjectUpdateCreatedToTeam?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when a project update is created to workspace channel. */
    slackProjectUpdateCreatedToWorkspace?: Maybe<Scalars["Boolean"]>;
    /** The identifier of the team to create settings for. */
    teamId?: Maybe<Scalars["String"]>;
};
export declare type IntegrationsSettingsPayload = {
    __typename?: "IntegrationsSettingsPayload";
    /** The settings that were created or updated. */
    integrationsSettings: IntegrationsSettings;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type IntegrationsSettingsUpdateInput = {
    /** Whether to send a Slack message when an initiative update is created. */
    slackInitiativeUpdateCreated?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when a new issue is added to triage. */
    slackIssueAddedToTriage?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when an issue is added to a view. */
    slackIssueAddedToView?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when a new issue is created for the project or the team. */
    slackIssueCreated?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when a comment is created on any of the project or team's issues. */
    slackIssueNewComment?: Maybe<Scalars["Boolean"]>;
    /** Whether to receive notification when an SLA has breached on Slack. */
    slackIssueSlaBreached?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when an SLA is at high risk. */
    slackIssueSlaHighRisk?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when any of the project or team's issues has a change in status. */
    slackIssueStatusChangedAll?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when any of the project or team's issues change to completed or cancelled. */
    slackIssueStatusChangedDone?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when a project update is created. */
    slackProjectUpdateCreated?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when a project update is created to team channels. */
    slackProjectUpdateCreatedToTeam?: Maybe<Scalars["Boolean"]>;
    /** Whether to send a Slack message when a project update is created to workspace channel. */
    slackProjectUpdateCreatedToWorkspace?: Maybe<Scalars["Boolean"]>;
};
export declare type IntercomSettingsInput = {
    /** Whether a ticket should be automatically reopened when its linked Linear issue is cancelled. */
    automateTicketReopeningOnCancellation?: Maybe<Scalars["Boolean"]>;
    /** Whether a ticket should be automatically reopened when a comment is posted on its linked Linear issue */
    automateTicketReopeningOnComment?: Maybe<Scalars["Boolean"]>;
    /** Whether a ticket should be automatically reopened when its linked Linear issue is completed. */
    automateTicketReopeningOnCompletion?: Maybe<Scalars["Boolean"]>;
    /** Whether an internal message should be added when someone comments on an issue. */
    sendNoteOnComment?: Maybe<Scalars["Boolean"]>;
    /** Whether an internal message should be added when a Linear issue changes status (for status types except completed or canceled). */
    sendNoteOnStatusChange?: Maybe<Scalars["Boolean"]>;
};
/** An issue. */
export declare type Issue = Node & {
    __typename?: "Issue";
    /** [Internal] The activity summary information for this issue. */
    activitySummary?: Maybe<Scalars["JSONObject"]>;
    /** The time at which the issue was added to a cycle. */
    addedToCycleAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the issue was added to a project. */
    addedToProjectAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the issue was added to a team. */
    addedToTeamAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The user to whom the issue is assigned to. */
    assignee?: Maybe<User>;
    /** Attachments associated with the issue. */
    attachments: AttachmentConnection;
    /** The time at which the issue was automatically archived by the auto pruning process. */
    autoArchivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the issue was automatically closed by the auto pruning process. */
    autoClosedAt?: Maybe<Scalars["DateTime"]>;
    /**
     * The order of the item in its column on the board.
     * @deprecated Will be removed in near future, please use `sortOrder` instead
     */
    boardOrder: Scalars["Float"];
    /** The bot that created the issue, if applicable. */
    botActor?: Maybe<ActorBot>;
    /** Suggested branch name for the issue. */
    branchName: Scalars["String"];
    /** The time at which the issue was moved into canceled state. */
    canceledAt?: Maybe<Scalars["DateTime"]>;
    /** Children of the issue. */
    children: IssueConnection;
    /** Comments associated with the issue. */
    comments: CommentConnection;
    /** The time at which the issue was moved into completed state. */
    completedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who created the issue. */
    creator?: Maybe<User>;
    /** Returns the number of Attachment resources which are created by customer support ticketing systems (e.g. Zendesk). */
    customerTicketCount: Scalars["Int"];
    /** The cycle that the issue is associated with. */
    cycle?: Maybe<Cycle>;
    /** The issue's description in markdown format. */
    description?: Maybe<Scalars["String"]>;
    /** [Internal] The issue's description content as YJS state. */
    descriptionState?: Maybe<Scalars["String"]>;
    /** [ALPHA] The document content representing this issue description. */
    documentContent?: Maybe<DocumentContent>;
    /** The date at which the issue is due. */
    dueDate?: Maybe<Scalars["TimelessDate"]>;
    /** The estimate of the complexity of the issue.. */
    estimate?: Maybe<Scalars["Float"]>;
    /** The external user who created the issue. */
    externalUserCreator?: Maybe<ExternalUser>;
    /** The users favorite associated with this issue. */
    favorite?: Maybe<Favorite>;
    /** History entries associated with the issue. */
    history: IssueHistoryConnection;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** Issue's human readable identifier (e.g. ENG-123). */
    identifier: Scalars["String"];
    /** Integration type that created this issue, if applicable. */
    integrationSourceType?: Maybe<IntegrationService>;
    /** Inverse relations associated with this issue. */
    inverseRelations: IssueRelationConnection;
    /** Id of the labels associated with this issue. */
    labelIds: Array<Scalars["String"]>;
    /** Labels associated with this issue. */
    labels: IssueLabelConnection;
    /** The last template that was applied to this issue. */
    lastAppliedTemplate?: Maybe<Template>;
    /** Customer needs associated with the issue. */
    needs: CustomerNeedConnection;
    /** The issue's unique number. */
    number: Scalars["Float"];
    /** The parent of the issue. */
    parent?: Maybe<Issue>;
    /** Previous identifiers of the issue if it has been moved between teams. */
    previousIdentifiers: Array<Scalars["String"]>;
    /** The priority of the issue. 0 = No priority, 1 = Urgent, 2 = High, 3 = Normal, 4 = Low. */
    priority: Scalars["Float"];
    /** Label for the priority. */
    priorityLabel: Scalars["String"];
    /** The order of the item in relation to other items in the organization, when ordered by priority. */
    prioritySortOrder: Scalars["Float"];
    /** The project that the issue is associated with. */
    project?: Maybe<Project>;
    /** The projectMilestone that the issue is associated with. */
    projectMilestone?: Maybe<ProjectMilestone>;
    /** Emoji reaction summary, grouped by emoji type. */
    reactionData: Scalars["JSONObject"];
    /** Reactions associated with the issue. */
    reactions: Array<Reaction>;
    /** The recurring issue template that created this issue. */
    recurringIssueTemplate?: Maybe<Template>;
    /** Relations associated with this issue. */
    relations: IssueRelationConnection;
    /** The time at which the issue's SLA will breach. */
    slaBreachesAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the issue's SLA will enter high risk state. */
    slaHighRiskAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the issue's SLA will enter medium risk state. */
    slaMediumRiskAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the issue's SLA began. */
    slaStartedAt?: Maybe<Scalars["DateTime"]>;
    /** The type of SLA set on the issue. Calendar days or business days. */
    slaType?: Maybe<Scalars["String"]>;
    /** The user who snoozed the issue. */
    snoozedBy?: Maybe<User>;
    /** The time until an issue will be snoozed in Triage view. */
    snoozedUntilAt?: Maybe<Scalars["DateTime"]>;
    /** The order of the item in relation to other items in the organization. */
    sortOrder: Scalars["Float"];
    /** The comment that this issue was created from. */
    sourceComment?: Maybe<Comment>;
    /** The time at which the issue was moved into started state. */
    startedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the issue entered triage. */
    startedTriageAt?: Maybe<Scalars["DateTime"]>;
    /** The workflow state that the issue is associated with. */
    state: WorkflowState;
    /** The order of the item in the sub-issue list. Only set if the issue has a parent. */
    subIssueSortOrder?: Maybe<Scalars["Float"]>;
    /** Users who are subscribed to the issue. */
    subscribers: UserConnection;
    /** [Internal] The time at which the most recent suggestions for this issue were generated. */
    suggestionsGeneratedAt?: Maybe<Scalars["DateTime"]>;
    /** The team that the issue is associated with. */
    team: Team;
    /** The issue's title. */
    title: Scalars["String"];
    /** A flag that indicates whether the issue is in the trash bin. */
    trashed?: Maybe<Scalars["Boolean"]>;
    /** The time at which the issue left triage. */
    triagedAt?: Maybe<Scalars["DateTime"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** Issue URL. */
    url: Scalars["String"];
};
/** An issue. */
export declare type IssueAttachmentsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<AttachmentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An issue. */
export declare type IssueChildrenArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An issue. */
export declare type IssueCommentsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CommentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An issue. */
export declare type IssueHistoryArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An issue. */
export declare type IssueInverseRelationsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An issue. */
export declare type IssueLabelsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueLabelFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An issue. */
export declare type IssueNeedsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CustomerNeedFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An issue. */
export declare type IssueRelationsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An issue. */
export declare type IssueSubscribersArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<UserFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeDisabled?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A generic payload return from entity archive mutations. */
export declare type IssueArchivePayload = ArchivePayload & {
    __typename?: "IssueArchivePayload";
    /** The archived/unarchived entity. Null if entity was deleted. */
    entity?: Maybe<Issue>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type IssueBatchCreateInput = {
    /** The issues to create. */
    issues: Array<IssueCreateInput>;
};
export declare type IssueBatchPayload = {
    __typename?: "IssueBatchPayload";
    /** The issues that were updated. */
    issues: Array<Issue>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** Issue filtering options. */
export declare type IssueCollectionFilter = {
    /** Comparator for the issues added to cycle at date. */
    addedToCycleAt?: Maybe<NullableDateComparator>;
    /** Comparator for the period when issue was added to a cycle. */
    addedToCyclePeriod?: Maybe<CyclePeriodComparator>;
    /** [Internal] Age (created -> now) comparator, defined if the issue is still open. */
    ageTime?: Maybe<NullableDurationComparator>;
    /** Compound filters, all of which need to be matched by the issue. */
    and?: Maybe<Array<IssueCollectionFilter>>;
    /** Comparator for the issues archived at date. */
    archivedAt?: Maybe<NullableDateComparator>;
    /** Filters that the issues assignee must satisfy. */
    assignee?: Maybe<NullableUserFilter>;
    /** Filters that the issues attachments must satisfy. */
    attachments?: Maybe<AttachmentCollectionFilter>;
    /** Comparator for the issues auto archived at date. */
    autoArchivedAt?: Maybe<NullableDateComparator>;
    /** Comparator for the issues auto closed at date. */
    autoClosedAt?: Maybe<NullableDateComparator>;
    /** Comparator for the issues canceled at date. */
    canceledAt?: Maybe<NullableDateComparator>;
    /** Filters that the child issues must satisfy. */
    children?: Maybe<IssueCollectionFilter>;
    /** Filters that the issues comments must satisfy. */
    comments?: Maybe<CommentCollectionFilter>;
    /** Comparator for the issues completed at date. */
    completedAt?: Maybe<NullableDateComparator>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the issues creator must satisfy. */
    creator?: Maybe<NullableUserFilter>;
    /** Count of customers */
    customerCount?: Maybe<NumberComparator>;
    /** Filters that the issues cycle must satisfy. */
    cycle?: Maybe<NullableCycleFilter>;
    /** [Internal] Cycle time (started -> completed) comparator. */
    cycleTime?: Maybe<NullableDurationComparator>;
    /** Comparator for the issues description. */
    description?: Maybe<NullableStringComparator>;
    /** Comparator for the issues due date. */
    dueDate?: Maybe<NullableTimelessDateComparator>;
    /** Comparator for the issues estimate. */
    estimate?: Maybe<EstimateComparator>;
    /** Filters that needs to be matched by all issues. */
    every?: Maybe<IssueFilter>;
    /** Comparator for filtering issues which are blocked. */
    hasBlockedByRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for filtering issues which are blocking. */
    hasBlockingRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for filtering issues which are duplicates. */
    hasDuplicateRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for filtering issues with relations. */
    hasRelatedRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Filters that issue labels must satisfy. */
    labels?: Maybe<IssueLabelCollectionFilter>;
    /** Filters that the last applied template must satisfy. */
    lastAppliedTemplate?: Maybe<NullableTemplateFilter>;
    /** [Internal] Lead time (created -> completed) comparator. */
    leadTime?: Maybe<NullableDurationComparator>;
    /** Comparator for the collection length. */
    length?: Maybe<NumberComparator>;
    /** Filters that the issue's customer needs must satisfy. */
    needs?: Maybe<CustomerNeedCollectionFilter>;
    /** Comparator for the issues number. */
    number?: Maybe<NumberComparator>;
    /** Compound filters, one of which need to be matched by the issue. */
    or?: Maybe<Array<IssueCollectionFilter>>;
    /** Filters that the issue parent must satisfy. */
    parent?: Maybe<NullableIssueFilter>;
    /** Comparator for the issues priority. */
    priority?: Maybe<NullableNumberComparator>;
    /** Filters that the issues project must satisfy. */
    project?: Maybe<NullableProjectFilter>;
    /** Filters that the issues project milestone must satisfy. */
    projectMilestone?: Maybe<NullableProjectMilestoneFilter>;
    /** Filters that the issues reactions must satisfy. */
    reactions?: Maybe<ReactionCollectionFilter>;
    /** [ALPHA] Filters that the recurring issue template must satisfy. */
    recurringIssueTemplate?: Maybe<NullableTemplateFilter>;
    /** [Internal] Comparator for the issues content. */
    searchableContent?: Maybe<ContentComparator>;
    /** Comparator for the issues sla status. */
    slaStatus?: Maybe<SlaStatusComparator>;
    /** Filters that the issues snoozer must satisfy. */
    snoozedBy?: Maybe<NullableUserFilter>;
    /** Comparator for the issues snoozed until date. */
    snoozedUntilAt?: Maybe<NullableDateComparator>;
    /** Filters that needs to be matched by some issues. */
    some?: Maybe<IssueFilter>;
    /** Filters that the source must satisfy. */
    sourceMetadata?: Maybe<SourceMetadataComparator>;
    /** Comparator for the issues started at date. */
    startedAt?: Maybe<NullableDateComparator>;
    /** Filters that the issues state must satisfy. */
    state?: Maybe<WorkflowStateFilter>;
    /** Filters that issue subscribers must satisfy. */
    subscribers?: Maybe<UserCollectionFilter>;
    /** Filters that the issues team must satisfy. */
    team?: Maybe<TeamFilter>;
    /** Comparator for the issues title. */
    title?: Maybe<StringComparator>;
    /** [Internal] Triage time (entered triaged -> triaged) comparator. */
    triageTime?: Maybe<NullableDurationComparator>;
    /** Comparator for the issues triaged at date. */
    triagedAt?: Maybe<NullableDateComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type IssueConnection = {
    __typename?: "IssueConnection";
    edges: Array<IssueEdge>;
    nodes: Array<Issue>;
    pageInfo: PageInfo;
};
export declare type IssueCreateInput = {
    /** The identifier of the user to assign the issue to. */
    assigneeId?: Maybe<Scalars["String"]>;
    /** The date when the issue was completed (e.g. if importing from another system). Must be a date in the past and after createdAt date. Cannot be provided with an incompatible workflow state. */
    completedAt?: Maybe<Scalars["DateTime"]>;
    /** Create issue as a user with the provided name. This option is only available to OAuth applications creating issues in `actor=application` mode. */
    createAsUser?: Maybe<Scalars["String"]>;
    /** The date when the issue was created (e.g. if importing from another system). Must be a date in the past. If none is provided, the backend will generate the time as now. */
    createdAt?: Maybe<Scalars["DateTime"]>;
    /** The cycle associated with the issue. */
    cycleId?: Maybe<Scalars["String"]>;
    /** The issue description in markdown format. */
    description?: Maybe<Scalars["String"]>;
    /** [Internal] The issue description as a Prosemirror document. */
    descriptionData?: Maybe<Scalars["JSON"]>;
    /** Provide an external user avatar URL. Can only be used in conjunction with the `createAsUser` options. This option is only available to OAuth applications creating comments in `actor=application` mode. */
    displayIconUrl?: Maybe<Scalars["String"]>;
    /** The date at which the issue is due. */
    dueDate?: Maybe<Scalars["TimelessDate"]>;
    /** The estimated complexity of the issue. */
    estimate?: Maybe<Scalars["Int"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The identifiers of the issue labels associated with this ticket. */
    labelIds?: Maybe<Array<Scalars["String"]>>;
    /** The ID of the last template applied to the issue. */
    lastAppliedTemplateId?: Maybe<Scalars["String"]>;
    /** The identifier of the parent issue. */
    parentId?: Maybe<Scalars["String"]>;
    /** Whether the passed sort order should be preserved. */
    preserveSortOrderOnCreate?: Maybe<Scalars["Boolean"]>;
    /** The priority of the issue. 0 = No priority, 1 = Urgent, 2 = High, 3 = Normal, 4 = Low. */
    priority?: Maybe<Scalars["Int"]>;
    /** The position of the issue related to other issues, when ordered by priority. */
    prioritySortOrder?: Maybe<Scalars["Float"]>;
    /** The project associated with the issue. */
    projectId?: Maybe<Scalars["String"]>;
    /** The project milestone associated with the issue. */
    projectMilestoneId?: Maybe<Scalars["String"]>;
    /** The comment the issue is referencing. */
    referenceCommentId?: Maybe<Scalars["String"]>;
    /** [Internal] The timestamp at which an issue will be considered in breach of SLA. */
    slaBreachesAt?: Maybe<Scalars["DateTime"]>;
    /** [Internal] The timestamp at which the issue's SLA was started. */
    slaStartedAt?: Maybe<Scalars["DateTime"]>;
    /** The SLA day count type for the issue. Whether SLA should be business days only or calendar days (default). */
    slaType?: Maybe<SLADayCountType>;
    /** The position of the issue related to other issues. */
    sortOrder?: Maybe<Scalars["Float"]>;
    /** The comment the issue is created from. */
    sourceCommentId?: Maybe<Scalars["String"]>;
    /** [Internal] The pull request comment the issue is created from. */
    sourcePullRequestCommentId?: Maybe<Scalars["String"]>;
    /** The team state of the issue. */
    stateId?: Maybe<Scalars["String"]>;
    /** The position of the issue in parent's sub-issue list. */
    subIssueSortOrder?: Maybe<Scalars["Float"]>;
    /** The identifiers of the users subscribing to this ticket. */
    subscriberIds?: Maybe<Array<Scalars["String"]>>;
    /** The identifier of the team associated with the issue. */
    teamId: Scalars["String"];
    /** The identifier of a template the issue should be created from. If other values are provided in the input, they will override template values. */
    templateId?: Maybe<Scalars["String"]>;
    /** The title of the issue. */
    title?: Maybe<Scalars["String"]>;
};
/** [Internal] A draft issue. */
export declare type IssueDraft = Node & {
    __typename?: "IssueDraft";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The user assigned to the draft. */
    assigneeId?: Maybe<Scalars["String"]>;
    /** Serialized array of JSONs representing attachments. */
    attachments?: Maybe<Scalars["JSONObject"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who created the draft. */
    creator: User;
    /** The cycle associated with the draft. */
    cycleId?: Maybe<Scalars["String"]>;
    /** The draft's description in markdown format. */
    description?: Maybe<Scalars["String"]>;
    /** [Internal] The draft's description as a Prosemirror document. */
    descriptionData?: Maybe<Scalars["JSON"]>;
    /** The date at which the issue would be due. */
    dueDate?: Maybe<Scalars["TimelessDate"]>;
    /** The estimate of the complexity of the draft. */
    estimate?: Maybe<Scalars["Float"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The IDs of labels added to the draft. */
    labelIds: Array<Scalars["String"]>;
    /** Serialized array of JSONs representing customer needs. */
    needs?: Maybe<Scalars["JSONObject"]>;
    /** The parent draft of the draft. */
    parent?: Maybe<IssueDraft>;
    /** The ID of the parent issue draft, if any. */
    parentId?: Maybe<Scalars["String"]>;
    /** The parent issue of the draft. */
    parentIssue?: Maybe<Issue>;
    /** The ID of the parent issue, if any. */
    parentIssueId?: Maybe<Scalars["String"]>;
    /** The priority of the draft. */
    priority: Scalars["Float"];
    /** Label for the priority. */
    priorityLabel: Scalars["String"];
    /** The project associated with the draft. */
    projectId?: Maybe<Scalars["String"]>;
    /** The project milestone associated with the draft. */
    projectMilestoneId?: Maybe<Scalars["String"]>;
    /** Serialized array of JSONs representing the recurring issue's schedule. */
    schedule?: Maybe<Scalars["JSONObject"]>;
    /** The ID of the comment that the draft was created from. */
    sourceCommentId?: Maybe<Scalars["String"]>;
    /** The workflow state associated with the draft. */
    stateId: Scalars["String"];
    /** The order of items in the sub-draft list. Only set if the draft has `parent` set. */
    subIssueSortOrder?: Maybe<Scalars["Float"]>;
    /** The team associated with the draft. */
    teamId: Scalars["String"];
    /** The draft's title. */
    title: Scalars["String"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type IssueDraftConnection = {
    __typename?: "IssueDraftConnection";
    edges: Array<IssueDraftEdge>;
    nodes: Array<IssueDraft>;
    pageInfo: PageInfo;
};
export declare type IssueDraftEdge = {
    __typename?: "IssueDraftEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: IssueDraft;
};
export declare type IssueEdge = {
    __typename?: "IssueEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: Issue;
};
/** Issue filtering options. */
export declare type IssueFilter = {
    /** Comparator for the issues added to cycle at date. */
    addedToCycleAt?: Maybe<NullableDateComparator>;
    /** Comparator for the period when issue was added to a cycle. */
    addedToCyclePeriod?: Maybe<CyclePeriodComparator>;
    /** [Internal] Age (created -> now) comparator, defined if the issue is still open. */
    ageTime?: Maybe<NullableDurationComparator>;
    /** Compound filters, all of which need to be matched by the issue. */
    and?: Maybe<Array<IssueFilter>>;
    /** Comparator for the issues archived at date. */
    archivedAt?: Maybe<NullableDateComparator>;
    /** Filters that the issues assignee must satisfy. */
    assignee?: Maybe<NullableUserFilter>;
    /** Filters that the issues attachments must satisfy. */
    attachments?: Maybe<AttachmentCollectionFilter>;
    /** Comparator for the issues auto archived at date. */
    autoArchivedAt?: Maybe<NullableDateComparator>;
    /** Comparator for the issues auto closed at date. */
    autoClosedAt?: Maybe<NullableDateComparator>;
    /** Comparator for the issues canceled at date. */
    canceledAt?: Maybe<NullableDateComparator>;
    /** Filters that the child issues must satisfy. */
    children?: Maybe<IssueCollectionFilter>;
    /** Filters that the issues comments must satisfy. */
    comments?: Maybe<CommentCollectionFilter>;
    /** Comparator for the issues completed at date. */
    completedAt?: Maybe<NullableDateComparator>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the issues creator must satisfy. */
    creator?: Maybe<NullableUserFilter>;
    /** Count of customers */
    customerCount?: Maybe<NumberComparator>;
    /** Filters that the issues cycle must satisfy. */
    cycle?: Maybe<NullableCycleFilter>;
    /** [Internal] Cycle time (started -> completed) comparator. */
    cycleTime?: Maybe<NullableDurationComparator>;
    /** Comparator for the issues description. */
    description?: Maybe<NullableStringComparator>;
    /** Comparator for the issues due date. */
    dueDate?: Maybe<NullableTimelessDateComparator>;
    /** Comparator for the issues estimate. */
    estimate?: Maybe<EstimateComparator>;
    /** Comparator for filtering issues which are blocked. */
    hasBlockedByRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for filtering issues which are blocking. */
    hasBlockingRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for filtering issues which are duplicates. */
    hasDuplicateRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for filtering issues with relations. */
    hasRelatedRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Filters that issue labels must satisfy. */
    labels?: Maybe<IssueLabelCollectionFilter>;
    /** Filters that the last applied template must satisfy. */
    lastAppliedTemplate?: Maybe<NullableTemplateFilter>;
    /** [Internal] Lead time (created -> completed) comparator. */
    leadTime?: Maybe<NullableDurationComparator>;
    /** Filters that the issue's customer needs must satisfy. */
    needs?: Maybe<CustomerNeedCollectionFilter>;
    /** Comparator for the issues number. */
    number?: Maybe<NumberComparator>;
    /** Compound filters, one of which need to be matched by the issue. */
    or?: Maybe<Array<IssueFilter>>;
    /** Filters that the issue parent must satisfy. */
    parent?: Maybe<NullableIssueFilter>;
    /** Comparator for the issues priority. */
    priority?: Maybe<NullableNumberComparator>;
    /** Filters that the issues project must satisfy. */
    project?: Maybe<NullableProjectFilter>;
    /** Filters that the issues project milestone must satisfy. */
    projectMilestone?: Maybe<NullableProjectMilestoneFilter>;
    /** Filters that the issues reactions must satisfy. */
    reactions?: Maybe<ReactionCollectionFilter>;
    /** [ALPHA] Filters that the recurring issue template must satisfy. */
    recurringIssueTemplate?: Maybe<NullableTemplateFilter>;
    /** [Internal] Comparator for the issues content. */
    searchableContent?: Maybe<ContentComparator>;
    /** Comparator for the issues sla status. */
    slaStatus?: Maybe<SlaStatusComparator>;
    /** Filters that the issues snoozer must satisfy. */
    snoozedBy?: Maybe<NullableUserFilter>;
    /** Comparator for the issues snoozed until date. */
    snoozedUntilAt?: Maybe<NullableDateComparator>;
    /** Filters that the source must satisfy. */
    sourceMetadata?: Maybe<SourceMetadataComparator>;
    /** Comparator for the issues started at date. */
    startedAt?: Maybe<NullableDateComparator>;
    /** Filters that the issues state must satisfy. */
    state?: Maybe<WorkflowStateFilter>;
    /** Filters that issue subscribers must satisfy. */
    subscribers?: Maybe<UserCollectionFilter>;
    /** Filters that the issues team must satisfy. */
    team?: Maybe<TeamFilter>;
    /** Comparator for the issues title. */
    title?: Maybe<StringComparator>;
    /** [Internal] Triage time (entered triaged -> triaged) comparator. */
    triageTime?: Maybe<NullableDurationComparator>;
    /** Comparator for the issues triaged at date. */
    triagedAt?: Maybe<NullableDateComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type IssueFilterSuggestionPayload = {
    __typename?: "IssueFilterSuggestionPayload";
    /** The json filter that is suggested. */
    filter?: Maybe<Scalars["JSONObject"]>;
    /** The log id of the prompt, that created this filter. */
    logId?: Maybe<Scalars["String"]>;
};
/** A record of changes to an issue. */
export declare type IssueHistory = Node & {
    __typename?: "IssueHistory";
    /** The actor that performed the actions. This field may be empty in the case of integrations or automations. */
    actor?: Maybe<User>;
    /** The id of user who made these changes. If null, possibly means that the change made by an integration. */
    actorId?: Maybe<Scalars["String"]>;
    /**
     * The actors that performed the actions. This field may be empty in the case of integrations or automations.
     * @deprecated Use `actor` and `descriptionUpdatedBy` instead.
     */
    actors?: Maybe<Array<User>>;
    /** ID's of labels that were added. */
    addedLabelIds?: Maybe<Array<Scalars["String"]>>;
    /** The labels that were added to the issue. */
    addedLabels?: Maybe<Array<IssueLabel>>;
    /** Whether the issue is archived at the time of this history entry. */
    archived?: Maybe<Scalars["Boolean"]>;
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The linked attachment. */
    attachment?: Maybe<Attachment>;
    /** The id of linked attachment. */
    attachmentId?: Maybe<Scalars["String"]>;
    /** Whether the issue was auto-archived. */
    autoArchived?: Maybe<Scalars["Boolean"]>;
    /** Whether the issue was auto-closed. */
    autoClosed?: Maybe<Scalars["Boolean"]>;
    /** The bot that performed the action. */
    botActor?: Maybe<ActorBot>;
    /** [Internal] Serialized JSON representing changes for certain non-relational properties. */
    changes?: Maybe<Scalars["JSONObject"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The id of linked customer need. */
    customerNeedId?: Maybe<Scalars["String"]>;
    /** The actors that edited the description of the issue, if any. */
    descriptionUpdatedBy?: Maybe<Array<User>>;
    /** The user that was unassigned from the issue. */
    fromAssignee?: Maybe<User>;
    /** The id of user from whom the issue was re-assigned from. */
    fromAssigneeId?: Maybe<Scalars["String"]>;
    /** The cycle that the issue was moved from. */
    fromCycle?: Maybe<Cycle>;
    /** The id of previous cycle of the issue. */
    fromCycleId?: Maybe<Scalars["String"]>;
    /** What the due date was changed from. */
    fromDueDate?: Maybe<Scalars["TimelessDate"]>;
    /** What the estimate was changed from. */
    fromEstimate?: Maybe<Scalars["Float"]>;
    /** The parent issue that the issue was moved from. */
    fromParent?: Maybe<Issue>;
    /** The id of previous parent of the issue. */
    fromParentId?: Maybe<Scalars["String"]>;
    /** What the priority was changed from. */
    fromPriority?: Maybe<Scalars["Float"]>;
    /** The project that the issue was moved from. */
    fromProject?: Maybe<Project>;
    /** The id of previous project of the issue. */
    fromProjectId?: Maybe<Scalars["String"]>;
    /** The state that the issue was moved from. */
    fromState?: Maybe<WorkflowState>;
    /** The id of previous workflow state of the issue. */
    fromStateId?: Maybe<Scalars["String"]>;
    /** The team that the issue was moved from. */
    fromTeam?: Maybe<Team>;
    /** The id of team from which the issue was moved from. */
    fromTeamId?: Maybe<Scalars["String"]>;
    /** What the title was changed from. */
    fromTitle?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The issue that was changed. */
    issue: Issue;
    /** The import record. */
    issueImport?: Maybe<IssueImport>;
    /** Changed issue relationships. */
    relationChanges?: Maybe<Array<IssueRelationHistoryPayload>>;
    /** ID's of labels that were removed. */
    removedLabelIds?: Maybe<Array<Scalars["String"]>>;
    /** The labels that were removed from the issue. */
    removedLabels?: Maybe<Array<IssueLabel>>;
    /** The user that was assigned to the issue. */
    toAssignee?: Maybe<User>;
    /** The id of user to whom the issue was assigned to. */
    toAssigneeId?: Maybe<Scalars["String"]>;
    /** The new project created from the issue. */
    toConvertedProject?: Maybe<Project>;
    /** The id of new project created from the issue. */
    toConvertedProjectId?: Maybe<Scalars["String"]>;
    /** The cycle that the issue was moved to. */
    toCycle?: Maybe<Cycle>;
    /** The id of new cycle of the issue. */
    toCycleId?: Maybe<Scalars["String"]>;
    /** What the due date was changed to. */
    toDueDate?: Maybe<Scalars["TimelessDate"]>;
    /** What the estimate was changed to. */
    toEstimate?: Maybe<Scalars["Float"]>;
    /** The parent issue that the issue was moved to. */
    toParent?: Maybe<Issue>;
    /** The id of new parent of the issue. */
    toParentId?: Maybe<Scalars["String"]>;
    /** What the priority was changed to. */
    toPriority?: Maybe<Scalars["Float"]>;
    /** The project that the issue was moved to. */
    toProject?: Maybe<Project>;
    /** The id of new project of the issue. */
    toProjectId?: Maybe<Scalars["String"]>;
    /** The state that the issue was moved to. */
    toState?: Maybe<WorkflowState>;
    /** The id of new workflow state of the issue. */
    toStateId?: Maybe<Scalars["String"]>;
    /** The team that the issue was moved to. */
    toTeam?: Maybe<Team>;
    /** The id of team to which the issue was moved to. */
    toTeamId?: Maybe<Scalars["String"]>;
    /** What the title was changed to. */
    toTitle?: Maybe<Scalars["String"]>;
    /** Whether the issue was trashed or un-trashed. */
    trashed?: Maybe<Scalars["Boolean"]>;
    /** The users that were notified of the issue. */
    triageResponsibilityNotifiedUsers?: Maybe<Array<User>>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** Whether the issue's description was updated. */
    updatedDescription?: Maybe<Scalars["Boolean"]>;
};
export declare type IssueHistoryConnection = {
    __typename?: "IssueHistoryConnection";
    edges: Array<IssueHistoryEdge>;
    nodes: Array<IssueHistory>;
    pageInfo: PageInfo;
};
export declare type IssueHistoryEdge = {
    __typename?: "IssueHistoryEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: IssueHistory;
};
/** An import job for data from an external service. */
export declare type IssueImport = Node & {
    __typename?: "IssueImport";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The id for the user that started the job. */
    creatorId: Scalars["String"];
    /** File URL for the uploaded CSV for the import, if there is one. */
    csvFileUrl?: Maybe<Scalars["String"]>;
    /** The display name of the import service. */
    displayName: Scalars["String"];
    /** User readable error message, if one has occurred during the import. */
    error?: Maybe<Scalars["String"]>;
    /** Error code and metadata, if one has occurred during the import. */
    errorMetadata?: Maybe<Scalars["JSONObject"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The data mapping configuration for the import job. */
    mapping?: Maybe<Scalars["JSONObject"]>;
    /** Current step progress in % (0-100). */
    progress?: Maybe<Scalars["Float"]>;
    /** The service from which data will be imported. */
    service: Scalars["String"];
    /** Metadata related to import service. */
    serviceMetadata?: Maybe<Scalars["JSONObject"]>;
    /** The status for the import job. */
    status: Scalars["String"];
    /** New team's name in cases when teamId not set. */
    teamName?: Maybe<Scalars["String"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type IssueImportCheckPayload = {
    __typename?: "IssueImportCheckPayload";
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type IssueImportDeletePayload = {
    __typename?: "IssueImportDeletePayload";
    /** The import job that was deleted. */
    issueImport?: Maybe<IssueImport>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** Whether a custom JQL query is valid or not */
export declare type IssueImportJqlCheckPayload = {
    __typename?: "IssueImportJqlCheckPayload";
    /** Returns an approximate number of issues matching the JQL query, if available */
    count?: Maybe<Scalars["Float"]>;
    /** An error message returned by Jira when validating the JQL query. */
    error?: Maybe<Scalars["String"]>;
    /** Returns true if the JQL query has been validated successfully, false otherwise */
    success: Scalars["Boolean"];
};
export declare type IssueImportPayload = {
    __typename?: "IssueImportPayload";
    /** The import job that was created or updated. */
    issueImport?: Maybe<IssueImport>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** Whether an issue import can be synced at the end of an import or not */
export declare type IssueImportSyncCheckPayload = {
    __typename?: "IssueImportSyncCheckPayload";
    /** Returns true if the import can be synced, false otherwise */
    canSync: Scalars["Boolean"];
    /** An error message with a root cause of why the import cannot be synced */
    error?: Maybe<Scalars["String"]>;
};
export declare type IssueImportUpdateInput = {
    /** The mapping configuration for the import. */
    mapping: Scalars["JSONObject"];
};
/** Labels that can be associated with issues. */
export declare type IssueLabel = Node & {
    __typename?: "IssueLabel";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** Children of the label. */
    children: IssueLabelConnection;
    /** The label's color as a HEX string. */
    color: Scalars["String"];
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who created the label. */
    creator?: Maybe<User>;
    /** The label's description. */
    description?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The original label inherited from. */
    inheritedFrom?: Maybe<IssueLabel>;
    /** Whether this label is considered to be a group. */
    isGroup: Scalars["Boolean"];
    /** Issues associated with the label. */
    issues: IssueConnection;
    /** The label's name. */
    name: Scalars["String"];
    /** @deprecated Workspace labels are identified by their team being null. */
    organization: Organization;
    /** The parent label. */
    parent?: Maybe<IssueLabel>;
    /** The team that the label is associated with. If null, the label is associated with the global workspace. */
    team?: Maybe<Team>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
/** Labels that can be associated with issues. */
export declare type IssueLabelChildrenArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueLabelFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** Labels that can be associated with issues. */
export declare type IssueLabelIssuesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** Issue label filtering options. */
export declare type IssueLabelCollectionFilter = {
    /** Compound filters, all of which need to be matched by the label. */
    and?: Maybe<Array<IssueLabelCollectionFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the issue labels creator must satisfy. */
    creator?: Maybe<NullableUserFilter>;
    /** Filters that needs to be matched by all issue labels. */
    every?: Maybe<IssueLabelFilter>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for whether the label is a group label. */
    isGroup?: Maybe<BooleanComparator>;
    /** Comparator for the collection length. */
    length?: Maybe<NumberComparator>;
    /** Comparator for the name. */
    name?: Maybe<StringComparator>;
    /** Compound filters, one of which need to be matched by the label. */
    or?: Maybe<Array<IssueLabelCollectionFilter>>;
    /** Filters that the issue label's parent label must satisfy. */
    parent?: Maybe<IssueLabelFilter>;
    /** Filters that needs to be matched by some issue labels. */
    some?: Maybe<IssueLabelFilter>;
    /** Filters that the issue labels team must satisfy. */
    team?: Maybe<NullableTeamFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type IssueLabelConnection = {
    __typename?: "IssueLabelConnection";
    edges: Array<IssueLabelEdge>;
    nodes: Array<IssueLabel>;
    pageInfo: PageInfo;
};
export declare type IssueLabelCreateInput = {
    /** The color of the label. */
    color?: Maybe<Scalars["String"]>;
    /** The description of the label. */
    description?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** Whether the label is a group. */
    isGroup?: Maybe<Scalars["Boolean"]>;
    /** The name of the label. */
    name: Scalars["String"];
    /** The identifier of the parent label. */
    parentId?: Maybe<Scalars["String"]>;
    /** The team associated with the label. If not given, the label will be associated with the entire workspace. */
    teamId?: Maybe<Scalars["String"]>;
};
export declare type IssueLabelEdge = {
    __typename?: "IssueLabelEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: IssueLabel;
};
/** Issue label filtering options. */
export declare type IssueLabelFilter = {
    /** Compound filters, all of which need to be matched by the label. */
    and?: Maybe<Array<IssueLabelFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the issue labels creator must satisfy. */
    creator?: Maybe<NullableUserFilter>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for whether the label is a group label. */
    isGroup?: Maybe<BooleanComparator>;
    /** Comparator for the name. */
    name?: Maybe<StringComparator>;
    /** Compound filters, one of which need to be matched by the label. */
    or?: Maybe<Array<IssueLabelFilter>>;
    /** Filters that the issue label's parent label must satisfy. */
    parent?: Maybe<IssueLabelFilter>;
    /** Filters that the issue labels team must satisfy. */
    team?: Maybe<NullableTeamFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type IssueLabelPayload = {
    __typename?: "IssueLabelPayload";
    /** The label that was created or updated. */
    issueLabel: IssueLabel;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type IssueLabelUpdateInput = {
    /** The color of the label. */
    color?: Maybe<Scalars["String"]>;
    /** The description of the label. */
    description?: Maybe<Scalars["String"]>;
    /** The name of the label. */
    name?: Maybe<Scalars["String"]>;
    /** The identifier of the parent label. */
    parentId?: Maybe<Scalars["String"]>;
};
/** An issue related notification. */
export declare type IssueNotification = Entity & Node & Notification & {
    __typename?: "IssueNotification";
    /** The user that caused the notification. */
    actor?: Maybe<User>;
    /** [Internal] Notification actor initials if avatar is not available. */
    actorAvatarColor: Scalars["String"];
    /** [Internal] Notification avatar URL. */
    actorAvatarUrl?: Maybe<Scalars["String"]>;
    /** [Internal] Notification actor initials if avatar is not available. */
    actorInitials?: Maybe<Scalars["String"]>;
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The bot that caused the notification. */
    botActor?: Maybe<ActorBot>;
    /** The comment related to the notification. */
    comment?: Maybe<Comment>;
    /** Related comment ID. Null if the notification is not related to a comment. */
    commentId?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /**
     * The time at when an email reminder for this notification was sent to the user. Null, if no email
     *     reminder has been sent.
     */
    emailedAt?: Maybe<Scalars["DateTime"]>;
    /** The external user that caused the notification. */
    externalUserActor?: Maybe<ExternalUser>;
    /** [Internal] Notifications with the same grouping key will be grouped together in the UI. */
    groupingKey: Scalars["String"];
    /** [Internal] Priority of the notification with the same grouping key. Higher number means higher priority. If priority is the same, notifications should be sorted by `createdAt`. */
    groupingPriority: Scalars["Float"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** [Internal] Inbox URL for the notification. */
    inboxUrl: Scalars["String"];
    /** [Internal] If notification actor was Linear. */
    isLinearActor: Scalars["Boolean"];
    /** The issue related to the notification. */
    issue: Issue;
    /** Related issue ID. */
    issueId: Scalars["String"];
    /** [Internal] Issue's status type for issue notifications. */
    issueStatusType?: Maybe<Scalars["String"]>;
    /** The parent comment related to the notification, if a notification is a reply comment notification. */
    parentComment?: Maybe<Comment>;
    /** Related parent comment ID. Null if the notification is not related to a comment. */
    parentCommentId?: Maybe<Scalars["String"]>;
    /** [Internal] Project update health for new updates. */
    projectUpdateHealth?: Maybe<Scalars["String"]>;
    /** Name of the reaction emoji related to the notification. */
    reactionEmoji?: Maybe<Scalars["String"]>;
    /** The time at when the user marked the notification as read. Null, if the the user hasn't read the notification */
    readAt?: Maybe<Scalars["DateTime"]>;
    /** The time until a notification will be snoozed. After that it will appear in the inbox again. */
    snoozedUntilAt?: Maybe<Scalars["DateTime"]>;
    /** The subscriptions related to the notification. */
    subscriptions?: Maybe<Array<NotificationSubscription>>;
    /** [Internal] Notification subtitle. */
    subtitle: Scalars["String"];
    /** The team related to the issue notification. */
    team: Team;
    /** [Internal] Notification title. */
    title: Scalars["String"];
    /** Notification type. */
    type: Scalars["String"];
    /** The time at which a notification was unsnoozed.. */
    unsnoozedAt?: Maybe<Scalars["DateTime"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** [Internal] URL to the target of the notification. */
    url: Scalars["String"];
    /** The user that received the notification. */
    user: User;
};
export declare type IssuePayload = {
    __typename?: "IssuePayload";
    /** The issue that was created or updated. */
    issue?: Maybe<Issue>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type IssuePriorityValue = {
    __typename?: "IssuePriorityValue";
    /** Priority's label. */
    label: Scalars["String"];
    /** Priority's number value. */
    priority: Scalars["Int"];
};
/** A relation between two issues. */
export declare type IssueRelation = Node & {
    __typename?: "IssueRelation";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The issue whose relationship is being described. */
    issue: Issue;
    /** The related issue. */
    relatedIssue: Issue;
    /** The relationship of the issue with the related issue. */
    type: Scalars["String"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type IssueRelationConnection = {
    __typename?: "IssueRelationConnection";
    edges: Array<IssueRelationEdge>;
    nodes: Array<IssueRelation>;
    pageInfo: PageInfo;
};
export declare type IssueRelationCreateInput = {
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The identifier of the issue that is related to another issue. */
    issueId: Scalars["String"];
    /** The identifier of the related issue. */
    relatedIssueId: Scalars["String"];
    /** The type of relation of the issue to the related issue. */
    type: IssueRelationType;
};
export declare type IssueRelationEdge = {
    __typename?: "IssueRelationEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: IssueRelation;
};
/** Issue relation history's payload. */
export declare type IssueRelationHistoryPayload = {
    __typename?: "IssueRelationHistoryPayload";
    /** The identifier of the related issue. */
    identifier: Scalars["String"];
    /** The type of the change. */
    type: Scalars["String"];
};
export declare type IssueRelationPayload = {
    __typename?: "IssueRelationPayload";
    /** The issue relation that was created or updated. */
    issueRelation: IssueRelation;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** The type of the issue relation. */
export declare enum IssueRelationType {
    Blocks = "blocks",
    Duplicate = "duplicate",
    Related = "related",
    Similar = "similar"
}
export declare type IssueRelationUpdateInput = {
    /** The identifier of the issue that is related to another issue. */
    issueId?: Maybe<Scalars["String"]>;
    /** The identifier of the related issue. */
    relatedIssueId?: Maybe<Scalars["String"]>;
    /** The type of relation of the issue to the related issue. */
    type?: Maybe<Scalars["String"]>;
};
export declare type IssueSearchPayload = {
    __typename?: "IssueSearchPayload";
    /** Archived entities matching the search term along with all their dependencies. */
    archivePayload: ArchiveResponse;
    edges: Array<IssueSearchResultEdge>;
    nodes: Array<IssueSearchResult>;
    pageInfo: PageInfo;
    /** Total number of results for query without filters applied. */
    totalCount: Scalars["Float"];
};
export declare type IssueSearchResult = Node & {
    __typename?: "IssueSearchResult";
    /** [Internal] The activity summary information for this issue. */
    activitySummary?: Maybe<Scalars["JSONObject"]>;
    /** The time at which the issue was added to a cycle. */
    addedToCycleAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the issue was added to a project. */
    addedToProjectAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the issue was added to a team. */
    addedToTeamAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The user to whom the issue is assigned to. */
    assignee?: Maybe<User>;
    /** Attachments associated with the issue. */
    attachments: AttachmentConnection;
    /** The time at which the issue was automatically archived by the auto pruning process. */
    autoArchivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the issue was automatically closed by the auto pruning process. */
    autoClosedAt?: Maybe<Scalars["DateTime"]>;
    /**
     * The order of the item in its column on the board.
     * @deprecated Will be removed in near future, please use `sortOrder` instead
     */
    boardOrder: Scalars["Float"];
    /** The bot that created the issue, if applicable. */
    botActor?: Maybe<ActorBot>;
    /** Suggested branch name for the issue. */
    branchName: Scalars["String"];
    /** The time at which the issue was moved into canceled state. */
    canceledAt?: Maybe<Scalars["DateTime"]>;
    /** Children of the issue. */
    children: IssueConnection;
    /** Comments associated with the issue. */
    comments: CommentConnection;
    /** The time at which the issue was moved into completed state. */
    completedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who created the issue. */
    creator?: Maybe<User>;
    /** Returns the number of Attachment resources which are created by customer support ticketing systems (e.g. Zendesk). */
    customerTicketCount: Scalars["Int"];
    /** The cycle that the issue is associated with. */
    cycle?: Maybe<Cycle>;
    /** The issue's description in markdown format. */
    description?: Maybe<Scalars["String"]>;
    /** [Internal] The issue's description content as YJS state. */
    descriptionState?: Maybe<Scalars["String"]>;
    /** [ALPHA] The document content representing this issue description. */
    documentContent?: Maybe<DocumentContent>;
    /** The date at which the issue is due. */
    dueDate?: Maybe<Scalars["TimelessDate"]>;
    /** The estimate of the complexity of the issue.. */
    estimate?: Maybe<Scalars["Float"]>;
    /** The external user who created the issue. */
    externalUserCreator?: Maybe<ExternalUser>;
    /** The users favorite associated with this issue. */
    favorite?: Maybe<Favorite>;
    /** History entries associated with the issue. */
    history: IssueHistoryConnection;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** Issue's human readable identifier (e.g. ENG-123). */
    identifier: Scalars["String"];
    /** Integration type that created this issue, if applicable. */
    integrationSourceType?: Maybe<IntegrationService>;
    /** Inverse relations associated with this issue. */
    inverseRelations: IssueRelationConnection;
    /** Id of the labels associated with this issue. */
    labelIds: Array<Scalars["String"]>;
    /** Labels associated with this issue. */
    labels: IssueLabelConnection;
    /** The last template that was applied to this issue. */
    lastAppliedTemplate?: Maybe<Template>;
    /** Metadata related to search result. */
    metadata: Scalars["JSONObject"];
    /** Customer needs associated with the issue. */
    needs: CustomerNeedConnection;
    /** The issue's unique number. */
    number: Scalars["Float"];
    /** The parent of the issue. */
    parent?: Maybe<Issue>;
    /** Previous identifiers of the issue if it has been moved between teams. */
    previousIdentifiers: Array<Scalars["String"]>;
    /** The priority of the issue. 0 = No priority, 1 = Urgent, 2 = High, 3 = Normal, 4 = Low. */
    priority: Scalars["Float"];
    /** Label for the priority. */
    priorityLabel: Scalars["String"];
    /** The order of the item in relation to other items in the organization, when ordered by priority. */
    prioritySortOrder: Scalars["Float"];
    /** The project that the issue is associated with. */
    project?: Maybe<Project>;
    /** The projectMilestone that the issue is associated with. */
    projectMilestone?: Maybe<ProjectMilestone>;
    /** Emoji reaction summary, grouped by emoji type. */
    reactionData: Scalars["JSONObject"];
    /** Reactions associated with the issue. */
    reactions: Array<Reaction>;
    /** The recurring issue template that created this issue. */
    recurringIssueTemplate?: Maybe<Template>;
    /** Relations associated with this issue. */
    relations: IssueRelationConnection;
    /** The time at which the issue's SLA will breach. */
    slaBreachesAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the issue's SLA will enter high risk state. */
    slaHighRiskAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the issue's SLA will enter medium risk state. */
    slaMediumRiskAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the issue's SLA began. */
    slaStartedAt?: Maybe<Scalars["DateTime"]>;
    /** The type of SLA set on the issue. Calendar days or business days. */
    slaType?: Maybe<Scalars["String"]>;
    /** The user who snoozed the issue. */
    snoozedBy?: Maybe<User>;
    /** The time until an issue will be snoozed in Triage view. */
    snoozedUntilAt?: Maybe<Scalars["DateTime"]>;
    /** The order of the item in relation to other items in the organization. */
    sortOrder: Scalars["Float"];
    /** The comment that this issue was created from. */
    sourceComment?: Maybe<Comment>;
    /** The time at which the issue was moved into started state. */
    startedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the issue entered triage. */
    startedTriageAt?: Maybe<Scalars["DateTime"]>;
    /** The workflow state that the issue is associated with. */
    state: WorkflowState;
    /** The order of the item in the sub-issue list. Only set if the issue has a parent. */
    subIssueSortOrder?: Maybe<Scalars["Float"]>;
    /** Users who are subscribed to the issue. */
    subscribers: UserConnection;
    /** [Internal] The time at which the most recent suggestions for this issue were generated. */
    suggestionsGeneratedAt?: Maybe<Scalars["DateTime"]>;
    /** The team that the issue is associated with. */
    team: Team;
    /** The issue's title. */
    title: Scalars["String"];
    /** A flag that indicates whether the issue is in the trash bin. */
    trashed?: Maybe<Scalars["Boolean"]>;
    /** The time at which the issue left triage. */
    triagedAt?: Maybe<Scalars["DateTime"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** Issue URL. */
    url: Scalars["String"];
};
export declare type IssueSearchResultAttachmentsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<AttachmentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type IssueSearchResultChildrenArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type IssueSearchResultCommentsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CommentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type IssueSearchResultHistoryArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type IssueSearchResultInverseRelationsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type IssueSearchResultLabelsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueLabelFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type IssueSearchResultNeedsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CustomerNeedFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type IssueSearchResultRelationsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type IssueSearchResultSubscribersArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<UserFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeDisabled?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type IssueSearchResultEdge = {
    __typename?: "IssueSearchResultEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: IssueSearchResult;
};
/** Issue sorting options. */
export declare type IssueSortInput = {
    /** Sort by assignee name */
    assignee?: Maybe<AssigneeSort>;
    /** Sort by issue completion date */
    completedAt?: Maybe<CompletedAtSort>;
    /** Sort by issue creation date */
    createdAt?: Maybe<CreatedAtSort>;
    /** Sort by customer name */
    customer?: Maybe<CustomerSort>;
    /** Sort by number of customers associated with the issue */
    customerCount?: Maybe<CustomerCountSort>;
    /** Sort by number of important customers associated with the issue */
    customerImportantCount?: Maybe<CustomerImportantCountSort>;
    /** Sort by customer revenue */
    customerRevenue?: Maybe<CustomerRevenueSort>;
    /** Sort by Cycle start date */
    cycle?: Maybe<CycleSort>;
    /** Sort by issue due date */
    dueDate?: Maybe<DueDateSort>;
    /** Sort by estimate */
    estimate?: Maybe<EstimateSort>;
    /** Sort by label */
    label?: Maybe<LabelSort>;
    /** Sort by label group */
    labelGroup?: Maybe<LabelGroupSort>;
    /** [ALPHA] Sort by number of links associated with the issue */
    linkCount?: Maybe<LinkCountSort>;
    /** Sort by manual order */
    manual?: Maybe<ManualSort>;
    /** Sort by Project Milestone target date */
    milestone?: Maybe<MilestoneSort>;
    /** Sort by priority */
    priority?: Maybe<PrioritySort>;
    /** Sort by Project name */
    project?: Maybe<ProjectSort>;
    /** Sort by the root issue */
    rootIssue?: Maybe<RootIssueSort>;
    /** Sort by SLA status */
    slaStatus?: Maybe<SlaStatusSort>;
    /** Sort by Team name */
    team?: Maybe<TeamSort>;
    /** Sort by issue title */
    title?: Maybe<TitleSort>;
    /** Sort by issue update date */
    updatedAt?: Maybe<UpdatedAtSort>;
    /** Sort by workflow state type */
    workflowState?: Maybe<WorkflowStateSort>;
};
export declare type IssueTitleSuggestionFromCustomerRequestPayload = {
    __typename?: "IssueTitleSuggestionFromCustomerRequestPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** [Internal] The log id of the ai response. */
    logId?: Maybe<Scalars["String"]>;
    /** The suggested issue title. */
    title: Scalars["String"];
};
export declare type IssueUpdateInput = {
    /** The identifiers of the issue labels to be added to this issue. */
    addedLabelIds?: Maybe<Array<Scalars["String"]>>;
    /** The identifier of the user to assign the issue to. */
    assigneeId?: Maybe<Scalars["String"]>;
    /** Whether the issue was automatically closed because its parent issue was closed. */
    autoClosedByParentClosing?: Maybe<Scalars["Boolean"]>;
    /** The cycle associated with the issue. */
    cycleId?: Maybe<Scalars["String"]>;
    /** The issue description in markdown format. */
    description?: Maybe<Scalars["String"]>;
    /** [Internal] The issue description as a Prosemirror document. */
    descriptionData?: Maybe<Scalars["JSON"]>;
    /** The date at which the issue is due. */
    dueDate?: Maybe<Scalars["TimelessDate"]>;
    /** The estimated complexity of the issue. */
    estimate?: Maybe<Scalars["Int"]>;
    /** The identifiers of the issue labels associated with this ticket. */
    labelIds?: Maybe<Array<Scalars["String"]>>;
    /** The ID of the last template applied to the issue. */
    lastAppliedTemplateId?: Maybe<Scalars["String"]>;
    /** The identifier of the parent issue. */
    parentId?: Maybe<Scalars["String"]>;
    /** The priority of the issue. 0 = No priority, 1 = Urgent, 2 = High, 3 = Normal, 4 = Low. */
    priority?: Maybe<Scalars["Int"]>;
    /** The position of the issue related to other issues, when ordered by priority. */
    prioritySortOrder?: Maybe<Scalars["Float"]>;
    /** The project associated with the issue. */
    projectId?: Maybe<Scalars["String"]>;
    /** The project milestone associated with the issue. */
    projectMilestoneId?: Maybe<Scalars["String"]>;
    /** The identifiers of the issue labels to be removed from this issue. */
    removedLabelIds?: Maybe<Array<Scalars["String"]>>;
    /** [Internal] The timestamp at which an issue will be considered in breach of SLA. */
    slaBreachesAt?: Maybe<Scalars["DateTime"]>;
    /** [Internal] The timestamp at which the issue's SLA was started. */
    slaStartedAt?: Maybe<Scalars["DateTime"]>;
    /** The SLA day count type for the issue. Whether SLA should be business days only or calendar days (default). */
    slaType?: Maybe<SLADayCountType>;
    /** The identifier of the user who snoozed the issue. */
    snoozedById?: Maybe<Scalars["String"]>;
    /** The time until an issue will be snoozed in Triage view. */
    snoozedUntilAt?: Maybe<Scalars["DateTime"]>;
    /** The position of the issue related to other issues. */
    sortOrder?: Maybe<Scalars["Float"]>;
    /** The team state of the issue. */
    stateId?: Maybe<Scalars["String"]>;
    /** The position of the issue in parent's sub-issue list. */
    subIssueSortOrder?: Maybe<Scalars["Float"]>;
    /** The identifiers of the users subscribing to this ticket. */
    subscriberIds?: Maybe<Array<Scalars["String"]>>;
    /** The identifier of the team associated with the issue. */
    teamId?: Maybe<Scalars["String"]>;
    /** The issue title. */
    title?: Maybe<Scalars["String"]>;
    /** Whether the issue has been trashed. */
    trashed?: Maybe<Scalars["Boolean"]>;
};
export declare type JiraConfigurationInput = {
    /** The Jira personal access token. */
    accessToken: Scalars["String"];
    /** The Jira user's email address. */
    email: Scalars["String"];
    /** The Jira installation hostname. */
    hostname: Scalars["String"];
    /** Whether this integration will be setup using the manual webhook flow. */
    manualSetup?: Maybe<Scalars["Boolean"]>;
};
export declare type JiraLinearMappingInput = {
    /** Whether the sync for this mapping is bidirectional. */
    bidirectional?: Maybe<Scalars["Boolean"]>;
    /** Whether this mapping is the default one for issue creation. */
    default?: Maybe<Scalars["Boolean"]>;
    /** The Jira id for this project. */
    jiraProjectId: Scalars["String"];
    /** The Linear team id to map to the given project. */
    linearTeamId: Scalars["String"];
};
export declare type JiraPersonalSettingsInput = {
    /** The name of the Jira site currently authorized through the integration. */
    siteName?: Maybe<Scalars["String"]>;
};
export declare type JiraProjectDataInput = {
    /** The Jira id for this project. */
    id: Scalars["String"];
    /** The Jira key for this project, such as ENG. */
    key: Scalars["String"];
    /** The Jira name for this project, such as Engineering. */
    name: Scalars["String"];
};
export declare type JiraSettingsInput = {
    /** Whether this integration is for Jira Server or not. */
    isJiraServer?: Maybe<Scalars["Boolean"]>;
    /** The label of the Jira instance, for visual identification purposes only */
    label?: Maybe<Scalars["String"]>;
    /** Whether this integration is using a manual setup flow. */
    manualSetup?: Maybe<Scalars["Boolean"]>;
    /** The mapping of Jira project id => Linear team id. */
    projectMapping?: Maybe<Array<JiraLinearMappingInput>>;
    /** The Jira projects for the organization. */
    projects: Array<JiraProjectDataInput>;
    /** Whether the user needs to provide setup information about the webhook to complete the integration setup. Only relevant for integrations that use a manual setup flow */
    setupPending?: Maybe<Scalars["Boolean"]>;
};
export declare type JiraUpdateInput = {
    /** The Jira personal access token. */
    accessToken?: Maybe<Scalars["String"]>;
    /** Whether to delete the current manual webhook configuration. */
    deleteWebhook?: Maybe<Scalars["Boolean"]>;
    /** The Jira user email address associated with the personal access token. */
    email?: Maybe<Scalars["String"]>;
    /** The id of the integration to update. */
    id: Scalars["String"];
    /** Whether to refresh Jira metadata for the integration. */
    updateMetadata?: Maybe<Scalars["Boolean"]>;
    /** Whether to refresh Jira Projects for the integration. */
    updateProjects?: Maybe<Scalars["Boolean"]>;
    /** Webhook secret for a new manual configuration. */
    webhookSecret?: Maybe<Scalars["String"]>;
};
export declare type JoinOrganizationInput = {
    /** An optional invite link for an organization. */
    inviteLink?: Maybe<Scalars["String"]>;
    /** The identifier of the organization. */
    organizationId: Scalars["String"];
};
/** Issue label-group sorting options. */
export declare type LabelGroupSort = {
    /** The label-group id to sort by */
    labelGroupId: Scalars["String"];
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
/** A label notification subscription. */
export declare type LabelNotificationSubscription = Entity & Node & NotificationSubscription & {
    __typename?: "LabelNotificationSubscription";
    /** Whether the subscription is active or not. */
    active: Scalars["Boolean"];
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The type of view to which the notification subscription context is associated with. */
    contextViewType?: Maybe<ContextViewType>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The contextual custom view associated with the notification subscription. */
    customView?: Maybe<CustomView>;
    /** The customer associated with the notification subscription. */
    customer?: Maybe<Customer>;
    /** The contextual cycle view associated with the notification subscription. */
    cycle?: Maybe<Cycle>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The contextual initiative view associated with the notification subscription. */
    initiative?: Maybe<Initiative>;
    /** The label subscribed to. */
    label: IssueLabel;
    /** The type of subscription. */
    notificationSubscriptionTypes: Array<Scalars["String"]>;
    /** The contextual project view associated with the notification subscription. */
    project?: Maybe<Project>;
    /** The user that subscribed to receive notifications. */
    subscriber: User;
    /** The team associated with the notification subscription. */
    team?: Maybe<Team>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The user view associated with the notification subscription. */
    user?: Maybe<User>;
    /** The type of user view to which the notification subscription context is associated with. */
    userContextViewType?: Maybe<UserContextViewType>;
};
/** Issue label sorting options. */
export declare type LabelSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
export declare type LaunchDarklySettingsInput = {
    /** The environment of the LaunchDarkly integration. */
    environment: Scalars["String"];
    /** The project key of the LaunchDarkly integration. */
    projectKey: Scalars["String"];
};
/** [ALPHA] Issue link count sorting options. */
export declare type LinkCountSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
export declare type LogoutResponse = {
    __typename?: "LogoutResponse";
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** Issue manual sorting options. */
export declare type ManualSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
/** A meeting that can be attached to different entities. */
export declare type Meeting = Node & {
    __typename?: "Meeting";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The color of the icon. */
    color?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who created the meeting. */
    creator?: Maybe<User>;
    /** The time at which the meeting is set to end. */
    endsAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the meeting was hidden. Null if the entity has not been hidden. */
    hiddenAt?: Maybe<Scalars["DateTime"]>;
    /** The icon of the meeting. */
    icon?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** [Internal] The initiative that the meeting is associated with. */
    initiative?: Maybe<Initiative>;
    /** The location of the meeting. */
    location?: Maybe<Scalars["String"]>;
    /** The meeting link of the meeting. */
    meetingLink?: Maybe<Scalars["String"]>;
    /** The project that the meeting is associated with. */
    project?: Maybe<Project>;
    /** Link to a recording of the meeting. */
    recordingLink?: Maybe<Scalars["String"]>;
    /** The order of the item in the resources list. */
    sortOrder: Scalars["Float"];
    /** The time at which the meeting is set to start. */
    startsAt?: Maybe<Scalars["DateTime"]>;
    /** The meeting title. */
    title: Scalars["String"];
    /** A flag that indicates whether the meeting is in the trash bin. */
    trashed?: Maybe<Scalars["Boolean"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The user who last updated the meeting. */
    updatedBy?: Maybe<User>;
};
/** Issue project milestone options. */
export declare type MilestoneSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
export declare type Mutation = {
    __typename?: "Mutation";
    /** Creates an integration api key for Airbyte to connect with Linear. */
    airbyteIntegrationConnect: IntegrationPayload;
    /** [INTERNAL] Creates a new API key. */
    apiKeyCreate: ApiKeyPayload;
    /** [INTERNAL] Deletes an API key. */
    apiKeyDelete: DeletePayload;
    /** [INTERNAL] Updates an API key's allowed teams. */
    apiKeyUpdate: ApiKeyPayload;
    /** Creates a new attachment, or updates existing if the same `url` and `issueId` is used. */
    attachmentCreate: AttachmentPayload;
    /** Deletes an issue attachment. */
    attachmentDelete: DeletePayload;
    /** Link an existing Discord message to an issue. */
    attachmentLinkDiscord: AttachmentPayload;
    /** Link an existing Front conversation to an issue. */
    attachmentLinkFront: FrontAttachmentPayload;
    /** Link a GitHub issue to a Linear issue. */
    attachmentLinkGitHubIssue: AttachmentPayload;
    /** Link a GitHub pull request to an issue. */
    attachmentLinkGitHubPR: AttachmentPayload;
    /** Link an existing GitLab MR to an issue. */
    attachmentLinkGitLabMR: AttachmentPayload;
    /** Link an existing Intercom conversation to an issue. */
    attachmentLinkIntercom: AttachmentPayload;
    /** Link an existing Jira issue to an issue. */
    attachmentLinkJiraIssue: AttachmentPayload;
    /** Link an existing Slack message to an issue. */
    attachmentLinkSlack: AttachmentPayload;
    /** Link any url to an issue. */
    attachmentLinkURL: AttachmentPayload;
    /** Link an existing Zendesk ticket to an issue. */
    attachmentLinkZendesk: AttachmentPayload;
    /** Begin syncing the thread for an existing Slack message attachment with a comment thread on its issue. */
    attachmentSyncToSlack: AttachmentPayload;
    /** Updates an existing issue attachment. */
    attachmentUpdate: AttachmentPayload;
    /** Creates a new comment. */
    commentCreate: CommentPayload;
    /** Deletes a comment. */
    commentDelete: DeletePayload;
    /** Resolves a comment. */
    commentResolve: CommentPayload;
    /** Unresolves a comment. */
    commentUnresolve: CommentPayload;
    /** Updates a comment. */
    commentUpdate: CommentPayload;
    /** Saves user message. */
    contactCreate: ContactPayload;
    /** [INTERNAL] Saves sales pricing inquiry to Front. */
    contactSalesCreate: ContactPayload;
    /** Create CSV export report for the organization. */
    createCsvExportReport: CreateCsvExportReportPayload;
    /** Create a notification to remind a user about an initiative update. */
    createInitiativeUpdateReminder: InitiativeUpdateReminderPayload;
    /** Creates an organization from onboarding. */
    createOrganizationFromOnboarding: CreateOrJoinOrganizationResponse;
    /** Create a notification to remind a user about a project update. */
    createProjectUpdateReminder: ProjectUpdateReminderPayload;
    /** Creates a new custom view. */
    customViewCreate: CustomViewPayload;
    /** Deletes a custom view. */
    customViewDelete: DeletePayload;
    /** Updates a custom view. */
    customViewUpdate: CustomViewPayload;
    /** Creates a new customer. */
    customerCreate: CustomerPayload;
    /** Deletes a customer. */
    customerDelete: DeletePayload;
    /** Merges two customers. */
    customerMerge: CustomerPayload;
    /** Archives a customer need. */
    customerNeedArchive: CustomerNeedArchivePayload;
    /** Creates a new customer need. */
    customerNeedCreate: CustomerNeedPayload;
    /** Creates a new customer need out of an attachment */
    customerNeedCreateFromAttachment: CustomerNeedPayload;
    /** Deletes a customer need. */
    customerNeedDelete: DeletePayload;
    /** Unarchives a customer need. */
    customerNeedUnarchive: CustomerNeedArchivePayload;
    /** Updates a customer need */
    customerNeedUpdate: CustomerNeedPayload;
    /** Creates a new customer tier. */
    customerTierCreate: CustomerTierPayload;
    /** Deletes a customer tier. */
    customerTierDelete: DeletePayload;
    /** Updates a customer tier. */
    customerTierUpdate: CustomerTierPayload;
    /** Updates a customer */
    customerUpdate: CustomerPayload;
    /** Upserts a customer, creating it if it doesn't exists, updating it otherwise. Matches against an existing customer with `id` or `externalId` */
    customerUpsert: CustomerPayload;
    /** Archives a cycle. */
    cycleArchive: CycleArchivePayload;
    /** Creates a new cycle. */
    cycleCreate: CyclePayload;
    /** Shifts all cycles starts and ends by a certain number of days, starting from the provided cycle onwards. */
    cycleShiftAll: CyclePayload;
    /** Shifts all cycles starts and ends by a certain number of days, starting from the provided cycle onwards. */
    cycleStartUpcomingCycleToday: CyclePayload;
    /** Updates a cycle. */
    cycleUpdate: CyclePayload;
    /** Creates a new document. */
    documentCreate: DocumentPayload;
    /** Deletes (trashes) a document. */
    documentDelete: DocumentArchivePayload;
    /** Restores a document. */
    documentUnarchive: DocumentArchivePayload;
    /** Updates a document. */
    documentUpdate: DocumentPayload;
    /** Creates a new email intake address. */
    emailIntakeAddressCreate: EmailIntakeAddressPayload;
    /** Deletes an email intake address object. */
    emailIntakeAddressDelete: DeletePayload;
    /** Rotates an existing email intake address. */
    emailIntakeAddressRotate: EmailIntakeAddressPayload;
    /** Updates an existing email intake address. */
    emailIntakeAddressUpdate: EmailIntakeAddressPayload;
    /** Authenticates a user account via email and authentication token. */
    emailTokenUserAccountAuth: AuthResolverResponse;
    /** Unsubscribes the user from one type of email. */
    emailUnsubscribe: EmailUnsubscribePayload;
    /** Finds or creates a new user account by email and sends an email with token. */
    emailUserAccountAuthChallenge: EmailUserAccountAuthChallengeResponse;
    /** Creates a custom emoji. */
    emojiCreate: EmojiPayload;
    /** Deletes an emoji. */
    emojiDelete: DeletePayload;
    /** Creates a new entity link. */
    entityExternalLinkCreate: EntityExternalLinkPayload;
    /** Deletes an entity link. */
    entityExternalLinkDelete: DeletePayload;
    /** Updates an entity link. */
    entityExternalLinkUpdate: EntityExternalLinkPayload;
    /** Creates a new favorite (project, cycle etc). */
    favoriteCreate: FavoritePayload;
    /** Deletes a favorite reference. */
    favoriteDelete: DeletePayload;
    /** Updates a favorite. */
    favoriteUpdate: FavoritePayload;
    /** XHR request payload to upload an images, video and other attachments directly to Linear's cloud storage. */
    fileUpload: UploadPayload;
    /** Creates a new automation state. */
    gitAutomationStateCreate: GitAutomationStatePayload;
    /** Archives an automation state. */
    gitAutomationStateDelete: DeletePayload;
    /** Updates an existing state. */
    gitAutomationStateUpdate: GitAutomationStatePayload;
    /** Creates a Git target branch automation. */
    gitAutomationTargetBranchCreate: GitAutomationTargetBranchPayload;
    /** Archives a Git target branch automation. */
    gitAutomationTargetBranchDelete: DeletePayload;
    /** Updates an existing Git target branch automation. */
    gitAutomationTargetBranchUpdate: GitAutomationTargetBranchPayload;
    /** Authenticate user account through Google OAuth. This is the 2nd step of OAuth flow. */
    googleUserAccountAuth: AuthResolverResponse;
    /** Upload an image from an URL to Linear. */
    imageUploadFromUrl: ImageUploadFromUrlPayload;
    /** XHR request payload to upload a file for import, directly to Linear's cloud storage. */
    importFileUpload: UploadPayload;
    /** Archives a initiative. */
    initiativeArchive: InitiativeArchivePayload;
    /** Creates a new initiative. */
    initiativeCreate: InitiativePayload;
    /** Deletes (trashes) an initiative. */
    initiativeDelete: DeletePayload;
    /** Creates a new initiative relation. */
    initiativeRelationCreate: InitiativeRelationPayload;
    /** Deletes an initiative relation. */
    initiativeRelationDelete: DeletePayload;
    /** Updates an initiative relation. */
    initiativeRelationUpdate: DeletePayload;
    /** Creates a new initiativeToProject join. */
    initiativeToProjectCreate: InitiativeToProjectPayload;
    /** Deletes a initiativeToProject. */
    initiativeToProjectDelete: DeletePayload;
    /** Updates a initiativeToProject. */
    initiativeToProjectUpdate: InitiativeToProjectPayload;
    /** Unarchives a initiative. */
    initiativeUnarchive: InitiativeArchivePayload;
    /** Updates a initiative. */
    initiativeUpdate: InitiativePayload;
    /** Archives an initiative update. */
    initiativeUpdateArchive: InitiativeUpdateArchivePayload;
    /** Creates a initiative update. */
    initiativeUpdateCreate: InitiativeUpdatePayload;
    /** Unarchives an initiative update. */
    initiativeUpdateUnarchive: InitiativeUpdateArchivePayload;
    /** Updates an update. */
    initiativeUpdateUpdate: InitiativeUpdatePayload;
    /** Archives an integration. */
    integrationArchive: DeletePayload;
    /** Connect a Slack channel to Asks. */
    integrationAsksConnectChannel: AsksChannelConnectPayload;
    /** Deletes an integration. */
    integrationDelete: DeletePayload;
    /** Integrates the organization with Discord. */
    integrationDiscord: IntegrationPayload;
    /** Integrates the organization with Figma. */
    integrationFigma: IntegrationPayload;
    /** Integrates the organization with Front. */
    integrationFront: IntegrationPayload;
    /** Connects the organization with a GitHub Enterprise Server. */
    integrationGitHubEnterpriseServerConnect: GitHubEnterpriseServerPayload;
    /** Connect your GitHub account to Linear. */
    integrationGitHubPersonal: IntegrationPayload;
    /** Generates a webhook for the GitHub commit integration. */
    integrationGithubCommitCreate: GitHubCommitIntegrationPayload;
    /** Connects the organization with the GitHub App. */
    integrationGithubConnect: IntegrationPayload;
    /** Connects the organization with the GitHub Import App. */
    integrationGithubImportConnect: IntegrationPayload;
    /** Refreshes the data for a GitHub import integration. */
    integrationGithubImportRefresh: IntegrationPayload;
    /** Connects the organization with a GitLab Access Token. */
    integrationGitlabConnect: GitLabIntegrationCreatePayload;
    /** [Internal] Connects the Google Calendar to the user to this Linear account via OAuth2. */
    integrationGoogleCalendarPersonalConnect: IntegrationPayload;
    /** Integrates the organization with Google Sheets. */
    integrationGoogleSheets: IntegrationPayload;
    /** Integrates the organization with Intercom. */
    integrationIntercom: IntegrationPayload;
    /** Disconnects the organization from Intercom. */
    integrationIntercomDelete: IntegrationPayload;
    /**
     * [DEPRECATED] Updates settings on the Intercom integration.
     * @deprecated This mutation is deprecated, please use `integrationSettingsUpdate` instead
     */
    integrationIntercomSettingsUpdate: IntegrationPayload;
    /** Connect your Jira account to Linear. */
    integrationJiraPersonal: IntegrationPayload;
    /** [INTERNAL] Updates a Jira Integration. */
    integrationJiraUpdate: IntegrationPayload;
    /** [INTERNAL] Integrates the organization with LaunchDarkly. */
    integrationLaunchDarklyConnect: IntegrationPayload;
    /** [INTERNAL] Integrates your personal account with LaunchDarkly. */
    integrationLaunchDarklyPersonalConnect: IntegrationPayload;
    /**
     * Enables Loom integration for the organization.
     * @deprecated Not available.
     */
    integrationLoom: IntegrationPayload;
    /** [INTERNAL] Integrates the organization with Opsgenie. */
    integrationOpsgenieConnect: IntegrationPayload;
    /** [INTERNAL] Refresh Opsgenie schedule mappings. */
    integrationOpsgenieRefreshScheduleMappings: IntegrationPayload;
    /** [INTERNAL] Integrates the organization with PagerDuty. */
    integrationPagerDutyConnect: IntegrationPayload;
    /** [INTERNAL] Refresh PagerDuty schedule mappings. */
    integrationPagerDutyRefreshScheduleMappings: IntegrationPayload;
    /** Requests a currently unavailable integration. */
    integrationRequest: IntegrationRequestPayload;
    /** Integrates the organization with Sentry. */
    integrationSentryConnect: IntegrationPayload;
    /**
     * [INTERNAL] Updates the integration settings.
     * @deprecated Use integrationUpdate instead.
     */
    integrationSettingsUpdate: IntegrationPayload;
    /** Integrates the organization with Slack. */
    integrationSlack: IntegrationPayload;
    /** Integrates the organization with the Slack Asks app. */
    integrationSlackAsks: IntegrationPayload;
    /** Slack integration for custom view notifications. */
    integrationSlackCustomViewNotifications: SlackChannelConnectPayload;
    /** Integrates a Slack Asks channel with a Customer. */
    integrationSlackCustomerChannelLink: SuccessPayload;
    /** Imports custom emojis from your Slack workspace. */
    integrationSlackImportEmojis: IntegrationPayload;
    /** [Internal] Slack integration for initiative notifications. */
    integrationSlackInitiativePost: SlackChannelConnectPayload;
    /** [Internal] Slack integration for organization level initiative update notifications. */
    integrationSlackOrgInitiativeUpdatesPost: SlackChannelConnectPayload;
    /** Slack integration for organization level project update notifications. */
    integrationSlackOrgProjectUpdatesPost: SlackChannelConnectPayload;
    /** Integrates your personal notifications with Slack. */
    integrationSlackPersonal: IntegrationPayload;
    /** Slack integration for team notifications. */
    integrationSlackPost: SlackChannelConnectPayload;
    /** Slack integration for project notifications. */
    integrationSlackProjectPost: SlackChannelConnectPayload;
    /** Creates a new integrationTemplate join. */
    integrationTemplateCreate: IntegrationTemplatePayload;
    /** Deletes a integrationTemplate. */
    integrationTemplateDelete: DeletePayload;
    /** [INTERNAL] Updates the integration. */
    integrationUpdate: IntegrationPayload;
    /** Integrates the organization with Zendesk. */
    integrationZendesk: IntegrationPayload;
    /** Creates new settings for one or more integrations. */
    integrationsSettingsCreate: IntegrationsSettingsPayload;
    /** Updates settings related to integrations for a project or a team. */
    integrationsSettingsUpdate: IntegrationsSettingsPayload;
    /** Adds a label to an issue. */
    issueAddLabel: IssuePayload;
    /** Archives an issue. */
    issueArchive: IssueArchivePayload;
    /** Creates a list of issues in one transaction. */
    issueBatchCreate: IssueBatchPayload;
    /** Updates multiple issues at once. */
    issueBatchUpdate: IssueBatchPayload;
    /** Creates a new issue. */
    issueCreate: IssuePayload;
    /** Deletes (trashes) an issue. */
    issueDelete: IssueArchivePayload;
    /** [INTERNAL] Updates an issue description from the Front app to handle Front attachments correctly. */
    issueDescriptionUpdateFromFront: IssuePayload;
    /** Kicks off an Asana import job. */
    issueImportCreateAsana: IssueImportPayload;
    /** Kicks off a Jira import job from a CSV. */
    issueImportCreateCSVJira: IssueImportPayload;
    /** Kicks off a Shortcut (formerly Clubhouse) import job. */
    issueImportCreateClubhouse: IssueImportPayload;
    /** Kicks off a GitHub import job. */
    issueImportCreateGithub: IssueImportPayload;
    /** Kicks off a Jira import job. */
    issueImportCreateJira: IssueImportPayload;
    /** [INTERNAL] Kicks off a Linear to Linear import job. */
    issueImportCreateLinearV2: IssueImportPayload;
    /** Deletes an import job. */
    issueImportDelete: IssueImportDeletePayload;
    /** Kicks off import processing. */
    issueImportProcess: IssueImportPayload;
    /** Updates the mapping for the issue import. */
    issueImportUpdate: IssueImportPayload;
    /** Creates a new label. */
    issueLabelCreate: IssueLabelPayload;
    /** Deletes an issue label. */
    issueLabelDelete: DeletePayload;
    /** Updates an label. */
    issueLabelUpdate: IssueLabelPayload;
    /** Creates a new issue relation. */
    issueRelationCreate: IssueRelationPayload;
    /** Deletes an issue relation. */
    issueRelationDelete: DeletePayload;
    /** Updates an issue relation. */
    issueRelationUpdate: IssueRelationPayload;
    /** Adds an issue reminder. Will cause a notification to be sent when the issue reminder time is reached. */
    issueReminder: IssuePayload;
    /** Removes a label from an issue. */
    issueRemoveLabel: IssuePayload;
    /** Subscribes a user to an issue. */
    issueSubscribe: IssuePayload;
    /** Unarchives an issue. */
    issueUnarchive: IssueArchivePayload;
    /** Unsubscribes a user from an issue. */
    issueUnsubscribe: IssuePayload;
    /** Updates an issue. */
    issueUpdate: IssuePayload;
    /** [INTERNAL] Connects the organization with a Jira Personal Access Token. */
    jiraIntegrationConnect: IntegrationPayload;
    /** Join an organization from onboarding. */
    joinOrganizationFromOnboarding: CreateOrJoinOrganizationResponse;
    /** Leave an organization. */
    leaveOrganization: CreateOrJoinOrganizationResponse;
    /** Logout the client. */
    logout: LogoutResponse;
    /** Logout all of user's sessions including the active one. */
    logoutAllSessions: LogoutResponse;
    /** Logout all of user's sessions excluding the current one. */
    logoutOtherSessions: LogoutResponse;
    /** Logout an individual session with its ID. */
    logoutSession: LogoutResponse;
    /** Archives a notification. */
    notificationArchive: NotificationArchivePayload;
    /** Archives a notification and all related notifications. */
    notificationArchiveAll: NotificationBatchActionPayload;
    /** Subscribes to or unsubscribes from a notification category for a given notification channel for the user */
    notificationCategoryChannelSubscriptionUpdate: UserSettingsPayload;
    /** Marks notification and all related notifications as read. */
    notificationMarkReadAll: NotificationBatchActionPayload;
    /** Marks notification and all related notifications as unread. */
    notificationMarkUnreadAll: NotificationBatchActionPayload;
    /** Snoozes a notification and all related notifications. */
    notificationSnoozeAll: NotificationBatchActionPayload;
    /** Creates a new notification subscription for a cycle, custom view, label, project or team. */
    notificationSubscriptionCreate: NotificationSubscriptionPayload;
    /**
     * Deletes a notification subscription reference.
     * @deprecated Update `notificationSubscription.active` to `false` instead.
     */
    notificationSubscriptionDelete: DeletePayload;
    /** Updates a notification subscription. */
    notificationSubscriptionUpdate: NotificationSubscriptionPayload;
    /** Unarchives a notification. */
    notificationUnarchive: NotificationArchivePayload;
    /** Unsnoozes a notification and all related notifications. */
    notificationUnsnoozeAll: NotificationBatchActionPayload;
    /** Updates a notification. */
    notificationUpdate: NotificationPayload;
    /** Cancels the deletion of an organization. Administrator privileges required. */
    organizationCancelDelete: OrganizationCancelDeletePayload;
    /** Delete's an organization. Administrator privileges required. */
    organizationDelete: OrganizationDeletePayload;
    /** Get an organization's delete confirmation token. Administrator privileges required. */
    organizationDeleteChallenge: OrganizationDeletePayload;
    /** [INTERNAL] Verifies a domain claim. */
    organizationDomainClaim: OrganizationDomainSimplePayload;
    /** [INTERNAL] Adds a domain to be allowed for an organization. */
    organizationDomainCreate: OrganizationDomainPayload;
    /** Deletes a domain. */
    organizationDomainDelete: DeletePayload;
    /** [INTERNAL] Updates an organization domain settings. */
    organizationDomainUpdate: OrganizationDomainPayload;
    /** [INTERNAL] Verifies a domain to be added to an organization. */
    organizationDomainVerify: OrganizationDomainPayload;
    /** Creates a new organization invite. */
    organizationInviteCreate: OrganizationInvitePayload;
    /** Deletes an organization invite. */
    organizationInviteDelete: DeletePayload;
    /** Updates an organization invite. */
    organizationInviteUpdate: OrganizationInvitePayload;
    /**
     * [DEPRECATED] Starts a trial for the organization. Administrator privileges required.
     * @deprecated Use organizationStartTrialForPlan
     */
    organizationStartTrial: OrganizationStartTrialPayload;
    /** Starts a trial for the organization on the specified plan type. Administrator privileges required. */
    organizationStartTrialForPlan: OrganizationStartTrialPayload;
    /** Updates the user's organization. */
    organizationUpdate: OrganizationPayload;
    /** [INTERNAL] Finish passkey login process. */
    passkeyLoginFinish: AuthResolverResponse;
    /** [INTERNAL] Starts passkey login process. */
    passkeyLoginStart: PasskeyLoginStartResponse;
    /** [Internal] Adds a label to a project. */
    projectAddLabel: ProjectPayload;
    /**
     * Archives a project.
     * @deprecated Deprecated in favor of projectDelete.
     */
    projectArchive: ProjectArchivePayload;
    /** Creates a new project. */
    projectCreate: ProjectPayload;
    /** Deletes (trashes) a project. */
    projectDelete: ProjectArchivePayload;
    /** Creates a new project milestone. */
    projectMilestoneCreate: ProjectMilestonePayload;
    /** Deletes a project milestone. */
    projectMilestoneDelete: DeletePayload;
    /** [Internal] Moves a project milestone to another project, can be called to undo a prior move. */
    projectMilestoneMove: ProjectMilestoneMovePayload;
    /** Updates a project milestone. */
    projectMilestoneUpdate: ProjectMilestonePayload;
    /** [INTERNAL] Updates all projects currently assigned to to a project status to a new project status. */
    projectReassignStatus: SuccessPayload;
    /** Creates a new project relation. */
    projectRelationCreate: ProjectRelationPayload;
    /** Deletes a project relation. */
    projectRelationDelete: DeletePayload;
    /** Updates a project relation. */
    projectRelationUpdate: ProjectRelationPayload;
    /** [Internal] Removes a label from a project. */
    projectRemoveLabel: ProjectPayload;
    /** Archives a project status. */
    projectStatusArchive: ProjectStatusArchivePayload;
    /** Creates a new project status. */
    projectStatusCreate: ProjectStatusPayload;
    /** Unarchives a project status. */
    projectStatusUnarchive: ProjectStatusArchivePayload;
    /** Updates a project status. */
    projectStatusUpdate: ProjectStatusPayload;
    /** Unarchives a project. */
    projectUnarchive: ProjectArchivePayload;
    /** Updates a project. */
    projectUpdate: ProjectPayload;
    /** Archives a project update. */
    projectUpdateArchive: ProjectUpdateArchivePayload;
    /** Creates a new project update. */
    projectUpdateCreate: ProjectUpdatePayload;
    /**
     * Deletes a project update.
     * @deprecated Use `projectUpdateArchive` instead.
     */
    projectUpdateDelete: DeletePayload;
    /** Unarchives a project update. */
    projectUpdateUnarchive: ProjectUpdateArchivePayload;
    /** Updates a project update. */
    projectUpdateUpdate: ProjectUpdatePayload;
    /** Creates a push subscription. */
    pushSubscriptionCreate: PushSubscriptionPayload;
    /** Deletes a push subscription. */
    pushSubscriptionDelete: PushSubscriptionPayload;
    /** Creates a new reaction. */
    reactionCreate: ReactionPayload;
    /** Deletes a reaction. */
    reactionDelete: DeletePayload;
    /** Manually update Google Sheets data. */
    refreshGoogleSheetsData: IntegrationPayload;
    /** Re-send an organization invite. */
    resendOrganizationInvite: DeletePayload;
    /** Re-send an organization invite tied to an email address. */
    resendOrganizationInviteByEmail: DeletePayload;
    /**
     * Archives a roadmap.
     * @deprecated Roadmaps are deprecated, use initiatives instead.
     */
    roadmapArchive: RoadmapArchivePayload;
    /**
     * Creates a new roadmap.
     * @deprecated Roadmaps are deprecated, use initiatives instead.
     */
    roadmapCreate: RoadmapPayload;
    /**
     * Deletes a roadmap.
     * @deprecated Roadmaps are deprecated, use initiatives instead.
     */
    roadmapDelete: DeletePayload;
    /** Creates a new roadmapToProject join. */
    roadmapToProjectCreate: RoadmapToProjectPayload;
    /** Deletes a roadmapToProject. */
    roadmapToProjectDelete: DeletePayload;
    /** Updates a roadmapToProject. */
    roadmapToProjectUpdate: RoadmapToProjectPayload;
    /**
     * Unarchives a roadmap.
     * @deprecated Roadmaps are deprecated, use initiatives instead.
     */
    roadmapUnarchive: RoadmapArchivePayload;
    /**
     * Updates a roadmap.
     * @deprecated Roadmaps are deprecated, use initiatives instead.
     */
    roadmapUpdate: RoadmapPayload;
    /** Authenticates a user account via email and authentication token for SAML. */
    samlTokenUserAccountAuth: AuthResolverResponse;
    /** Creates a new team. The user who creates the team will automatically be added as a member to the newly created team. */
    teamCreate: TeamPayload;
    /** Deletes team's cycles data */
    teamCyclesDelete: TeamPayload;
    /** Deletes a team. */
    teamDelete: DeletePayload;
    /** Deletes a previously used team key. */
    teamKeyDelete: DeletePayload;
    /** Creates a new team membership. */
    teamMembershipCreate: TeamMembershipPayload;
    /** Deletes a team membership. */
    teamMembershipDelete: DeletePayload;
    /** Updates a team membership. */
    teamMembershipUpdate: TeamMembershipPayload;
    /** Unarchives a team and cancels deletion. */
    teamUnarchive: TeamArchivePayload;
    /** Updates a team. */
    teamUpdate: TeamPayload;
    /** Creates a new template. */
    templateCreate: TemplatePayload;
    /** Deletes a template. */
    templateDelete: DeletePayload;
    /** Updates an existing template. */
    templateUpdate: TemplatePayload;
    /** Creates a new time schedule. */
    timeScheduleCreate: TimeSchedulePayload;
    /** Deletes a time schedule. */
    timeScheduleDelete: DeletePayload;
    /** Refresh the integration schedule information. */
    timeScheduleRefreshIntegrationSchedule: TimeSchedulePayload;
    /** Updates a time schedule. */
    timeScheduleUpdate: TimeSchedulePayload;
    /** Upsert an external time schedule. */
    timeScheduleUpsertExternal: TimeSchedulePayload;
    /** Creates a new triage responsibility. */
    triageResponsibilityCreate: TriageResponsibilityPayload;
    /** Deletes a triage responsibility. */
    triageResponsibilityDelete: DeletePayload;
    /** Updates an existing triage responsibility. */
    triageResponsibilityUpdate: TriageResponsibilityPayload;
    /** [Internal] Updates existing Slack integration scopes. */
    updateIntegrationSlackScopes: IntegrationPayload;
    /** [INTERNAL] Updates the summary of an issue. */
    updateIssueSummary: IssuePayload;
    /** Makes user a regular user. Can only be called by an admin. */
    userDemoteAdmin: UserAdminPayload;
    /** Makes user a guest. Can only be called by an admin. */
    userDemoteMember: UserAdminPayload;
    /** Connects the Discord user to this Linear account via OAuth2. */
    userDiscordConnect: UserPayload;
    /** Disconnects the external user from this Linear account. */
    userExternalUserDisconnect: UserPayload;
    /** Updates a user's settings flag. */
    userFlagUpdate: UserSettingsFlagPayload;
    /** Makes user an admin. Can only be called by an admin. */
    userPromoteAdmin: UserAdminPayload;
    /** Makes user a regular user. Can only be called by an admin. */
    userPromoteMember: UserAdminPayload;
    /** Resets user's setting flags. */
    userSettingsFlagsReset: UserSettingsFlagsResetPayload;
    /** Updates the user's settings. */
    userSettingsUpdate: UserSettingsPayload;
    /** Suspends a user. Can only be called by an admin. */
    userSuspend: UserAdminPayload;
    /** Un-suspends a user. Can only be called by an admin. */
    userUnsuspend: UserAdminPayload;
    /** Updates a user. Only available to organization admins and the user themselves. */
    userUpdate: UserPayload;
    /** Creates a new ViewPreferences object. */
    viewPreferencesCreate: ViewPreferencesPayload;
    /** Deletes a ViewPreferences. */
    viewPreferencesDelete: DeletePayload;
    /** Updates an existing ViewPreferences object. */
    viewPreferencesUpdate: ViewPreferencesPayload;
    /** Creates a new webhook. */
    webhookCreate: WebhookPayload;
    /** Deletes a Webhook. */
    webhookDelete: DeletePayload;
    /** Updates an existing Webhook. */
    webhookUpdate: WebhookPayload;
    /** Archives a state. Only states with issues that have all been archived can be archived. */
    workflowStateArchive: WorkflowStateArchivePayload;
    /** Creates a new state, adding it to the workflow of a team. */
    workflowStateCreate: WorkflowStatePayload;
    /** Updates a state. */
    workflowStateUpdate: WorkflowStatePayload;
};
export declare type MutationAirbyteIntegrationConnectArgs = {
    input: AirbyteConfigurationInput;
};
export declare type MutationApiKeyCreateArgs = {
    input: ApiKeyCreateInput;
};
export declare type MutationApiKeyDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationApiKeyUpdateArgs = {
    id: Scalars["String"];
    input: ApiKeyUpdateInput;
};
export declare type MutationAttachmentCreateArgs = {
    input: AttachmentCreateInput;
};
export declare type MutationAttachmentDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationAttachmentLinkDiscordArgs = {
    channelId: Scalars["String"];
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    messageId: Scalars["String"];
    title?: Maybe<Scalars["String"]>;
    url: Scalars["String"];
};
export declare type MutationAttachmentLinkFrontArgs = {
    conversationId: Scalars["String"];
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    title?: Maybe<Scalars["String"]>;
};
export declare type MutationAttachmentLinkGitHubIssueArgs = {
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    title?: Maybe<Scalars["String"]>;
    url: Scalars["String"];
};
export declare type MutationAttachmentLinkGitHubPrArgs = {
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    linkKind?: Maybe<GitLinkKind>;
    title?: Maybe<Scalars["String"]>;
    url: Scalars["String"];
};
export declare type MutationAttachmentLinkGitLabMrArgs = {
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    number: Scalars["Float"];
    projectPathWithNamespace: Scalars["String"];
    title?: Maybe<Scalars["String"]>;
    url: Scalars["String"];
};
export declare type MutationAttachmentLinkIntercomArgs = {
    conversationId: Scalars["String"];
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    partId?: Maybe<Scalars["String"]>;
    title?: Maybe<Scalars["String"]>;
};
export declare type MutationAttachmentLinkJiraIssueArgs = {
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    jiraIssueId: Scalars["String"];
    title?: Maybe<Scalars["String"]>;
    url?: Maybe<Scalars["String"]>;
};
export declare type MutationAttachmentLinkSlackArgs = {
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    syncToCommentThread?: Maybe<Scalars["Boolean"]>;
    title?: Maybe<Scalars["String"]>;
    url: Scalars["String"];
};
export declare type MutationAttachmentLinkUrlArgs = {
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    title?: Maybe<Scalars["String"]>;
    url: Scalars["String"];
};
export declare type MutationAttachmentLinkZendeskArgs = {
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    ticketId: Scalars["String"];
    title?: Maybe<Scalars["String"]>;
    url?: Maybe<Scalars["String"]>;
};
export declare type MutationAttachmentSyncToSlackArgs = {
    id: Scalars["String"];
};
export declare type MutationAttachmentUpdateArgs = {
    id: Scalars["String"];
    input: AttachmentUpdateInput;
};
export declare type MutationCommentCreateArgs = {
    input: CommentCreateInput;
};
export declare type MutationCommentDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationCommentResolveArgs = {
    id: Scalars["String"];
    resolvingCommentId?: Maybe<Scalars["String"]>;
};
export declare type MutationCommentUnresolveArgs = {
    id: Scalars["String"];
};
export declare type MutationCommentUpdateArgs = {
    id: Scalars["String"];
    input: CommentUpdateInput;
};
export declare type MutationContactCreateArgs = {
    input: ContactCreateInput;
};
export declare type MutationContactSalesCreateArgs = {
    input: ContactSalesCreateInput;
};
export declare type MutationCreateCsvExportReportArgs = {
    includePrivateTeamIds?: Maybe<Array<Scalars["String"]>>;
};
export declare type MutationCreateInitiativeUpdateReminderArgs = {
    initiativeId: Scalars["String"];
    userId?: Maybe<Scalars["String"]>;
};
export declare type MutationCreateOrganizationFromOnboardingArgs = {
    input: CreateOrganizationInput;
    survey?: Maybe<OnboardingCustomerSurvey>;
};
export declare type MutationCreateProjectUpdateReminderArgs = {
    projectId: Scalars["String"];
    userId?: Maybe<Scalars["String"]>;
};
export declare type MutationCustomViewCreateArgs = {
    input: CustomViewCreateInput;
};
export declare type MutationCustomViewDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationCustomViewUpdateArgs = {
    id: Scalars["String"];
    input: CustomViewUpdateInput;
};
export declare type MutationCustomerCreateArgs = {
    input: CustomerCreateInput;
};
export declare type MutationCustomerDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationCustomerMergeArgs = {
    sourceCustomerId: Scalars["String"];
    targetCustomerId: Scalars["String"];
};
export declare type MutationCustomerNeedArchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationCustomerNeedCreateArgs = {
    input: CustomerNeedCreateInput;
};
export declare type MutationCustomerNeedCreateFromAttachmentArgs = {
    input: CustomerNeedCreateFromAttachmentInput;
};
export declare type MutationCustomerNeedDeleteArgs = {
    id: Scalars["String"];
    keepAttachment?: Maybe<Scalars["Boolean"]>;
};
export declare type MutationCustomerNeedUnarchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationCustomerNeedUpdateArgs = {
    id: Scalars["String"];
    input: CustomerNeedUpdateInput;
};
export declare type MutationCustomerTierCreateArgs = {
    input: CustomerTierCreateInput;
};
export declare type MutationCustomerTierDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationCustomerTierUpdateArgs = {
    id: Scalars["String"];
    input: CustomerTierUpdateInput;
};
export declare type MutationCustomerUpdateArgs = {
    id: Scalars["String"];
    input: CustomerUpdateInput;
};
export declare type MutationCustomerUpsertArgs = {
    input: CustomerUpsertInput;
};
export declare type MutationCycleArchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationCycleCreateArgs = {
    input: CycleCreateInput;
};
export declare type MutationCycleShiftAllArgs = {
    input: CycleShiftAllInput;
};
export declare type MutationCycleStartUpcomingCycleTodayArgs = {
    id: Scalars["String"];
};
export declare type MutationCycleUpdateArgs = {
    id: Scalars["String"];
    input: CycleUpdateInput;
};
export declare type MutationDocumentCreateArgs = {
    input: DocumentCreateInput;
};
export declare type MutationDocumentDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationDocumentUnarchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationDocumentUpdateArgs = {
    id: Scalars["String"];
    input: DocumentUpdateInput;
};
export declare type MutationEmailIntakeAddressCreateArgs = {
    input: EmailIntakeAddressCreateInput;
};
export declare type MutationEmailIntakeAddressDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationEmailIntakeAddressRotateArgs = {
    id: Scalars["String"];
};
export declare type MutationEmailIntakeAddressUpdateArgs = {
    id: Scalars["String"];
    input: EmailIntakeAddressUpdateInput;
};
export declare type MutationEmailTokenUserAccountAuthArgs = {
    input: TokenUserAccountAuthInput;
};
export declare type MutationEmailUnsubscribeArgs = {
    input: EmailUnsubscribeInput;
};
export declare type MutationEmailUserAccountAuthChallengeArgs = {
    input: EmailUserAccountAuthChallengeInput;
};
export declare type MutationEmojiCreateArgs = {
    input: EmojiCreateInput;
};
export declare type MutationEmojiDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationEntityExternalLinkCreateArgs = {
    input: EntityExternalLinkCreateInput;
};
export declare type MutationEntityExternalLinkDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationEntityExternalLinkUpdateArgs = {
    id: Scalars["String"];
    input: EntityExternalLinkUpdateInput;
};
export declare type MutationFavoriteCreateArgs = {
    input: FavoriteCreateInput;
};
export declare type MutationFavoriteDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationFavoriteUpdateArgs = {
    id: Scalars["String"];
    input: FavoriteUpdateInput;
};
export declare type MutationFileUploadArgs = {
    contentType: Scalars["String"];
    filename: Scalars["String"];
    makePublic?: Maybe<Scalars["Boolean"]>;
    metaData?: Maybe<Scalars["JSON"]>;
    size: Scalars["Int"];
};
export declare type MutationGitAutomationStateCreateArgs = {
    input: GitAutomationStateCreateInput;
};
export declare type MutationGitAutomationStateDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationGitAutomationStateUpdateArgs = {
    id: Scalars["String"];
    input: GitAutomationStateUpdateInput;
};
export declare type MutationGitAutomationTargetBranchCreateArgs = {
    input: GitAutomationTargetBranchCreateInput;
};
export declare type MutationGitAutomationTargetBranchDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationGitAutomationTargetBranchUpdateArgs = {
    id: Scalars["String"];
    input: GitAutomationTargetBranchUpdateInput;
};
export declare type MutationGoogleUserAccountAuthArgs = {
    input: GoogleUserAccountAuthInput;
};
export declare type MutationImageUploadFromUrlArgs = {
    url: Scalars["String"];
};
export declare type MutationImportFileUploadArgs = {
    contentType: Scalars["String"];
    filename: Scalars["String"];
    metaData?: Maybe<Scalars["JSON"]>;
    size: Scalars["Int"];
};
export declare type MutationInitiativeArchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationInitiativeCreateArgs = {
    input: InitiativeCreateInput;
};
export declare type MutationInitiativeDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationInitiativeRelationCreateArgs = {
    input: InitiativeRelationCreateInput;
};
export declare type MutationInitiativeRelationDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationInitiativeRelationUpdateArgs = {
    id: Scalars["String"];
    input: InitiativeRelationUpdateInput;
};
export declare type MutationInitiativeToProjectCreateArgs = {
    input: InitiativeToProjectCreateInput;
};
export declare type MutationInitiativeToProjectDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationInitiativeToProjectUpdateArgs = {
    id: Scalars["String"];
    input: InitiativeToProjectUpdateInput;
};
export declare type MutationInitiativeUnarchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationInitiativeUpdateArgs = {
    id: Scalars["String"];
    input: InitiativeUpdateInput;
};
export declare type MutationInitiativeUpdateArchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationInitiativeUpdateCreateArgs = {
    input: InitiativeUpdateCreateInput;
};
export declare type MutationInitiativeUpdateUnarchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationInitiativeUpdateUpdateArgs = {
    id: Scalars["String"];
    input: InitiativeUpdateUpdateInput;
};
export declare type MutationIntegrationArchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationIntegrationAsksConnectChannelArgs = {
    code: Scalars["String"];
    redirectUri: Scalars["String"];
};
export declare type MutationIntegrationDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationIntegrationDiscordArgs = {
    code: Scalars["String"];
    redirectUri: Scalars["String"];
};
export declare type MutationIntegrationFigmaArgs = {
    code: Scalars["String"];
    redirectUri: Scalars["String"];
};
export declare type MutationIntegrationFrontArgs = {
    code: Scalars["String"];
    redirectUri: Scalars["String"];
};
export declare type MutationIntegrationGitHubEnterpriseServerConnectArgs = {
    githubUrl: Scalars["String"];
    organizationName?: Maybe<Scalars["String"]>;
};
export declare type MutationIntegrationGitHubPersonalArgs = {
    code: Scalars["String"];
};
export declare type MutationIntegrationGithubConnectArgs = {
    code: Scalars["String"];
    installationId: Scalars["String"];
};
export declare type MutationIntegrationGithubImportConnectArgs = {
    code: Scalars["String"];
    installationId: Scalars["String"];
};
export declare type MutationIntegrationGithubImportRefreshArgs = {
    id: Scalars["String"];
};
export declare type MutationIntegrationGitlabConnectArgs = {
    accessToken: Scalars["String"];
    gitlabUrl: Scalars["String"];
};
export declare type MutationIntegrationGoogleCalendarPersonalConnectArgs = {
    code: Scalars["String"];
};
export declare type MutationIntegrationGoogleSheetsArgs = {
    code: Scalars["String"];
};
export declare type MutationIntegrationIntercomArgs = {
    code: Scalars["String"];
    domainUrl?: Maybe<Scalars["String"]>;
    redirectUri: Scalars["String"];
};
export declare type MutationIntegrationIntercomSettingsUpdateArgs = {
    input: IntercomSettingsInput;
};
export declare type MutationIntegrationJiraPersonalArgs = {
    accessToken?: Maybe<Scalars["String"]>;
    code?: Maybe<Scalars["String"]>;
};
export declare type MutationIntegrationJiraUpdateArgs = {
    input: JiraUpdateInput;
};
export declare type MutationIntegrationLaunchDarklyConnectArgs = {
    code: Scalars["String"];
    environment: Scalars["String"];
    projectKey: Scalars["String"];
};
export declare type MutationIntegrationLaunchDarklyPersonalConnectArgs = {
    code: Scalars["String"];
};
export declare type MutationIntegrationOpsgenieConnectArgs = {
    apiKey: Scalars["String"];
};
export declare type MutationIntegrationPagerDutyConnectArgs = {
    code: Scalars["String"];
    redirectUri: Scalars["String"];
};
export declare type MutationIntegrationRequestArgs = {
    input: IntegrationRequestInput;
};
export declare type MutationIntegrationSentryConnectArgs = {
    code: Scalars["String"];
    installationId: Scalars["String"];
    organizationSlug: Scalars["String"];
};
export declare type MutationIntegrationSettingsUpdateArgs = {
    id: Scalars["String"];
    input: IntegrationSettingsInput;
};
export declare type MutationIntegrationSlackArgs = {
    code: Scalars["String"];
    redirectUri: Scalars["String"];
    shouldUseV2Auth?: Maybe<Scalars["Boolean"]>;
};
export declare type MutationIntegrationSlackAsksArgs = {
    code: Scalars["String"];
    redirectUri: Scalars["String"];
};
export declare type MutationIntegrationSlackCustomViewNotificationsArgs = {
    code: Scalars["String"];
    customViewId: Scalars["String"];
    redirectUri: Scalars["String"];
};
export declare type MutationIntegrationSlackCustomerChannelLinkArgs = {
    code: Scalars["String"];
    customerId: Scalars["String"];
    redirectUri: Scalars["String"];
};
export declare type MutationIntegrationSlackImportEmojisArgs = {
    code: Scalars["String"];
    redirectUri: Scalars["String"];
};
export declare type MutationIntegrationSlackInitiativePostArgs = {
    code: Scalars["String"];
    initiativeId: Scalars["String"];
    redirectUri: Scalars["String"];
};
export declare type MutationIntegrationSlackOrgInitiativeUpdatesPostArgs = {
    code: Scalars["String"];
    redirectUri: Scalars["String"];
};
export declare type MutationIntegrationSlackOrgProjectUpdatesPostArgs = {
    code: Scalars["String"];
    redirectUri: Scalars["String"];
};
export declare type MutationIntegrationSlackPersonalArgs = {
    code: Scalars["String"];
    redirectUri: Scalars["String"];
};
export declare type MutationIntegrationSlackPostArgs = {
    code: Scalars["String"];
    redirectUri: Scalars["String"];
    shouldUseV2Auth?: Maybe<Scalars["Boolean"]>;
    teamId: Scalars["String"];
};
export declare type MutationIntegrationSlackProjectPostArgs = {
    code: Scalars["String"];
    projectId: Scalars["String"];
    redirectUri: Scalars["String"];
    service: Scalars["String"];
};
export declare type MutationIntegrationTemplateCreateArgs = {
    input: IntegrationTemplateCreateInput;
};
export declare type MutationIntegrationTemplateDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationIntegrationUpdateArgs = {
    id: Scalars["String"];
    input: IntegrationUpdateInput;
};
export declare type MutationIntegrationZendeskArgs = {
    code: Scalars["String"];
    redirectUri: Scalars["String"];
    scope: Scalars["String"];
    subdomain: Scalars["String"];
};
export declare type MutationIntegrationsSettingsCreateArgs = {
    input: IntegrationsSettingsCreateInput;
};
export declare type MutationIntegrationsSettingsUpdateArgs = {
    id: Scalars["String"];
    input: IntegrationsSettingsUpdateInput;
};
export declare type MutationIssueAddLabelArgs = {
    id: Scalars["String"];
    labelId: Scalars["String"];
};
export declare type MutationIssueArchiveArgs = {
    id: Scalars["String"];
    trash?: Maybe<Scalars["Boolean"]>;
};
export declare type MutationIssueBatchCreateArgs = {
    input: IssueBatchCreateInput;
};
export declare type MutationIssueBatchUpdateArgs = {
    ids: Array<Scalars["UUID"]>;
    input: IssueUpdateInput;
};
export declare type MutationIssueCreateArgs = {
    input: IssueCreateInput;
};
export declare type MutationIssueDeleteArgs = {
    id: Scalars["String"];
    permanentlyDelete?: Maybe<Scalars["Boolean"]>;
};
export declare type MutationIssueDescriptionUpdateFromFrontArgs = {
    description: Scalars["String"];
    id: Scalars["String"];
};
export declare type MutationIssueImportCreateAsanaArgs = {
    asanaTeamName: Scalars["String"];
    asanaToken: Scalars["String"];
    id?: Maybe<Scalars["String"]>;
    includeClosedIssues?: Maybe<Scalars["Boolean"]>;
    instantProcess?: Maybe<Scalars["Boolean"]>;
    teamId?: Maybe<Scalars["String"]>;
    teamName?: Maybe<Scalars["String"]>;
};
export declare type MutationIssueImportCreateCsvJiraArgs = {
    csvUrl: Scalars["String"];
    jiraEmail?: Maybe<Scalars["String"]>;
    jiraHostname?: Maybe<Scalars["String"]>;
    jiraToken?: Maybe<Scalars["String"]>;
    teamId?: Maybe<Scalars["String"]>;
    teamName?: Maybe<Scalars["String"]>;
};
export declare type MutationIssueImportCreateClubhouseArgs = {
    clubhouseGroupName: Scalars["String"];
    clubhouseToken: Scalars["String"];
    id?: Maybe<Scalars["String"]>;
    includeClosedIssues?: Maybe<Scalars["Boolean"]>;
    instantProcess?: Maybe<Scalars["Boolean"]>;
    teamId?: Maybe<Scalars["String"]>;
    teamName?: Maybe<Scalars["String"]>;
};
export declare type MutationIssueImportCreateGithubArgs = {
    githubLabels?: Maybe<Array<Scalars["String"]>>;
    githubRepoIds?: Maybe<Array<Scalars["Int"]>>;
    includeClosedIssues?: Maybe<Scalars["Boolean"]>;
    instantProcess?: Maybe<Scalars["Boolean"]>;
    teamId?: Maybe<Scalars["String"]>;
    teamName?: Maybe<Scalars["String"]>;
};
export declare type MutationIssueImportCreateJiraArgs = {
    id?: Maybe<Scalars["String"]>;
    includeClosedIssues?: Maybe<Scalars["Boolean"]>;
    instantProcess?: Maybe<Scalars["Boolean"]>;
    jiraEmail: Scalars["String"];
    jiraHostname: Scalars["String"];
    jiraProject: Scalars["String"];
    jiraToken: Scalars["String"];
    jql?: Maybe<Scalars["String"]>;
    teamId?: Maybe<Scalars["String"]>;
    teamName?: Maybe<Scalars["String"]>;
};
export declare type MutationIssueImportCreateLinearV2Args = {
    id?: Maybe<Scalars["String"]>;
    linearSourceOrganizationId: Scalars["String"];
};
export declare type MutationIssueImportDeleteArgs = {
    issueImportId: Scalars["String"];
};
export declare type MutationIssueImportProcessArgs = {
    issueImportId: Scalars["String"];
    mapping: Scalars["JSONObject"];
};
export declare type MutationIssueImportUpdateArgs = {
    id: Scalars["String"];
    input: IssueImportUpdateInput;
};
export declare type MutationIssueLabelCreateArgs = {
    input: IssueLabelCreateInput;
    replaceTeamLabels?: Maybe<Scalars["Boolean"]>;
};
export declare type MutationIssueLabelDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationIssueLabelUpdateArgs = {
    id: Scalars["String"];
    input: IssueLabelUpdateInput;
    replaceTeamLabels?: Maybe<Scalars["Boolean"]>;
};
export declare type MutationIssueRelationCreateArgs = {
    input: IssueRelationCreateInput;
    overrideCreatedAt?: Maybe<Scalars["DateTime"]>;
};
export declare type MutationIssueRelationDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationIssueRelationUpdateArgs = {
    id: Scalars["String"];
    input: IssueRelationUpdateInput;
};
export declare type MutationIssueReminderArgs = {
    id: Scalars["String"];
    reminderAt: Scalars["DateTime"];
};
export declare type MutationIssueRemoveLabelArgs = {
    id: Scalars["String"];
    labelId: Scalars["String"];
};
export declare type MutationIssueSubscribeArgs = {
    id: Scalars["String"];
    userId?: Maybe<Scalars["String"]>;
};
export declare type MutationIssueUnarchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationIssueUnsubscribeArgs = {
    id: Scalars["String"];
    userId?: Maybe<Scalars["String"]>;
};
export declare type MutationIssueUpdateArgs = {
    id: Scalars["String"];
    input: IssueUpdateInput;
};
export declare type MutationJiraIntegrationConnectArgs = {
    input: JiraConfigurationInput;
};
export declare type MutationJoinOrganizationFromOnboardingArgs = {
    input: JoinOrganizationInput;
};
export declare type MutationLeaveOrganizationArgs = {
    organizationId: Scalars["String"];
};
export declare type MutationLogoutArgs = {
    reason?: Maybe<Scalars["String"]>;
};
export declare type MutationLogoutAllSessionsArgs = {
    reason?: Maybe<Scalars["String"]>;
};
export declare type MutationLogoutOtherSessionsArgs = {
    reason?: Maybe<Scalars["String"]>;
};
export declare type MutationLogoutSessionArgs = {
    sessionId: Scalars["String"];
};
export declare type MutationNotificationArchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationNotificationArchiveAllArgs = {
    input: NotificationEntityInput;
};
export declare type MutationNotificationCategoryChannelSubscriptionUpdateArgs = {
    category: NotificationCategory;
    channel: NotificationChannel;
    subscribe: Scalars["Boolean"];
};
export declare type MutationNotificationMarkReadAllArgs = {
    input: NotificationEntityInput;
    readAt: Scalars["DateTime"];
};
export declare type MutationNotificationMarkUnreadAllArgs = {
    input: NotificationEntityInput;
};
export declare type MutationNotificationSnoozeAllArgs = {
    input: NotificationEntityInput;
    snoozedUntilAt: Scalars["DateTime"];
};
export declare type MutationNotificationSubscriptionCreateArgs = {
    input: NotificationSubscriptionCreateInput;
};
export declare type MutationNotificationSubscriptionDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationNotificationSubscriptionUpdateArgs = {
    id: Scalars["String"];
    input: NotificationSubscriptionUpdateInput;
};
export declare type MutationNotificationUnarchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationNotificationUnsnoozeAllArgs = {
    input: NotificationEntityInput;
    unsnoozedAt: Scalars["DateTime"];
};
export declare type MutationNotificationUpdateArgs = {
    id: Scalars["String"];
    input: NotificationUpdateInput;
};
export declare type MutationOrganizationDeleteArgs = {
    input: DeleteOrganizationInput;
};
export declare type MutationOrganizationDomainClaimArgs = {
    id: Scalars["String"];
};
export declare type MutationOrganizationDomainCreateArgs = {
    input: OrganizationDomainCreateInput;
    triggerEmailVerification?: Maybe<Scalars["Boolean"]>;
};
export declare type MutationOrganizationDomainDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationOrganizationDomainUpdateArgs = {
    id: Scalars["String"];
    input: OrganizationDomainUpdateInput;
};
export declare type MutationOrganizationDomainVerifyArgs = {
    input: OrganizationDomainVerificationInput;
};
export declare type MutationOrganizationInviteCreateArgs = {
    input: OrganizationInviteCreateInput;
};
export declare type MutationOrganizationInviteDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationOrganizationInviteUpdateArgs = {
    id: Scalars["String"];
    input: OrganizationInviteUpdateInput;
};
export declare type MutationOrganizationStartTrialForPlanArgs = {
    input: OrganizationStartTrialInput;
};
export declare type MutationOrganizationUpdateArgs = {
    input: OrganizationUpdateInput;
};
export declare type MutationPasskeyLoginFinishArgs = {
    authId: Scalars["String"];
    response: Scalars["JSONObject"];
};
export declare type MutationPasskeyLoginStartArgs = {
    authId: Scalars["String"];
};
export declare type MutationProjectAddLabelArgs = {
    id: Scalars["String"];
    labelId: Scalars["String"];
};
export declare type MutationProjectArchiveArgs = {
    id: Scalars["String"];
    trash?: Maybe<Scalars["Boolean"]>;
};
export declare type MutationProjectCreateArgs = {
    connectSlackChannel?: Maybe<Scalars["Boolean"]>;
    input: ProjectCreateInput;
};
export declare type MutationProjectDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationProjectMilestoneCreateArgs = {
    input: ProjectMilestoneCreateInput;
};
export declare type MutationProjectMilestoneDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationProjectMilestoneMoveArgs = {
    id: Scalars["String"];
    input: ProjectMilestoneMoveInput;
};
export declare type MutationProjectMilestoneUpdateArgs = {
    id: Scalars["String"];
    input: ProjectMilestoneUpdateInput;
};
export declare type MutationProjectReassignStatusArgs = {
    newProjectStatusId: Scalars["String"];
    originalProjectStatusId: Scalars["String"];
};
export declare type MutationProjectRelationCreateArgs = {
    input: ProjectRelationCreateInput;
};
export declare type MutationProjectRelationDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationProjectRelationUpdateArgs = {
    id: Scalars["String"];
    input: ProjectRelationUpdateInput;
};
export declare type MutationProjectRemoveLabelArgs = {
    id: Scalars["String"];
    labelId: Scalars["String"];
};
export declare type MutationProjectStatusArchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationProjectStatusCreateArgs = {
    input: ProjectStatusCreateInput;
};
export declare type MutationProjectStatusUnarchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationProjectStatusUpdateArgs = {
    id: Scalars["String"];
    input: ProjectStatusUpdateInput;
};
export declare type MutationProjectUnarchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationProjectUpdateArgs = {
    id: Scalars["String"];
    input: ProjectUpdateInput;
};
export declare type MutationProjectUpdateArchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationProjectUpdateCreateArgs = {
    input: ProjectUpdateCreateInput;
};
export declare type MutationProjectUpdateDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationProjectUpdateUnarchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationProjectUpdateUpdateArgs = {
    id: Scalars["String"];
    input: ProjectUpdateUpdateInput;
};
export declare type MutationPushSubscriptionCreateArgs = {
    input: PushSubscriptionCreateInput;
};
export declare type MutationPushSubscriptionDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationReactionCreateArgs = {
    input: ReactionCreateInput;
};
export declare type MutationReactionDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationRefreshGoogleSheetsDataArgs = {
    id: Scalars["String"];
    type?: Maybe<Scalars["String"]>;
};
export declare type MutationResendOrganizationInviteArgs = {
    id: Scalars["String"];
};
export declare type MutationResendOrganizationInviteByEmailArgs = {
    email: Scalars["String"];
};
export declare type MutationRoadmapArchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationRoadmapCreateArgs = {
    input: RoadmapCreateInput;
};
export declare type MutationRoadmapDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationRoadmapToProjectCreateArgs = {
    input: RoadmapToProjectCreateInput;
};
export declare type MutationRoadmapToProjectDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationRoadmapToProjectUpdateArgs = {
    id: Scalars["String"];
    input: RoadmapToProjectUpdateInput;
};
export declare type MutationRoadmapUnarchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationRoadmapUpdateArgs = {
    id: Scalars["String"];
    input: RoadmapUpdateInput;
};
export declare type MutationSamlTokenUserAccountAuthArgs = {
    input: TokenUserAccountAuthInput;
};
export declare type MutationTeamCreateArgs = {
    copySettingsFromTeamId?: Maybe<Scalars["String"]>;
    input: TeamCreateInput;
};
export declare type MutationTeamCyclesDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationTeamDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationTeamKeyDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationTeamMembershipCreateArgs = {
    input: TeamMembershipCreateInput;
};
export declare type MutationTeamMembershipDeleteArgs = {
    alsoLeaveParentTeams?: Maybe<Scalars["Boolean"]>;
    id: Scalars["String"];
};
export declare type MutationTeamMembershipUpdateArgs = {
    id: Scalars["String"];
    input: TeamMembershipUpdateInput;
};
export declare type MutationTeamUnarchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationTeamUpdateArgs = {
    id: Scalars["String"];
    input: TeamUpdateInput;
    mapping?: Maybe<InheritanceEntityMapping>;
};
export declare type MutationTemplateCreateArgs = {
    input: TemplateCreateInput;
};
export declare type MutationTemplateDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationTemplateUpdateArgs = {
    id: Scalars["String"];
    input: TemplateUpdateInput;
};
export declare type MutationTimeScheduleCreateArgs = {
    input: TimeScheduleCreateInput;
};
export declare type MutationTimeScheduleDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationTimeScheduleRefreshIntegrationScheduleArgs = {
    id: Scalars["String"];
};
export declare type MutationTimeScheduleUpdateArgs = {
    id: Scalars["String"];
    input: TimeScheduleUpdateInput;
};
export declare type MutationTimeScheduleUpsertExternalArgs = {
    externalId: Scalars["String"];
    input: TimeScheduleUpdateInput;
};
export declare type MutationTriageResponsibilityCreateArgs = {
    input: TriageResponsibilityCreateInput;
};
export declare type MutationTriageResponsibilityDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationTriageResponsibilityUpdateArgs = {
    id: Scalars["String"];
    input: TriageResponsibilityUpdateInput;
};
export declare type MutationUpdateIntegrationSlackScopesArgs = {
    code: Scalars["String"];
    integrationId: Scalars["String"];
    redirectUri: Scalars["String"];
};
export declare type MutationUpdateIssueSummaryArgs = {
    id: Scalars["String"];
};
export declare type MutationUserDemoteAdminArgs = {
    id: Scalars["String"];
};
export declare type MutationUserDemoteMemberArgs = {
    id: Scalars["String"];
};
export declare type MutationUserDiscordConnectArgs = {
    code: Scalars["String"];
    redirectUri: Scalars["String"];
};
export declare type MutationUserExternalUserDisconnectArgs = {
    service: Scalars["String"];
};
export declare type MutationUserFlagUpdateArgs = {
    flag: UserFlagType;
    operation: UserFlagUpdateOperation;
};
export declare type MutationUserPromoteAdminArgs = {
    id: Scalars["String"];
};
export declare type MutationUserPromoteMemberArgs = {
    id: Scalars["String"];
};
export declare type MutationUserSettingsFlagsResetArgs = {
    flags?: Maybe<Array<UserFlagType>>;
};
export declare type MutationUserSettingsUpdateArgs = {
    id: Scalars["String"];
    input: UserSettingsUpdateInput;
};
export declare type MutationUserSuspendArgs = {
    id: Scalars["String"];
};
export declare type MutationUserUnsuspendArgs = {
    id: Scalars["String"];
};
export declare type MutationUserUpdateArgs = {
    id: Scalars["String"];
    input: UserUpdateInput;
};
export declare type MutationViewPreferencesCreateArgs = {
    input: ViewPreferencesCreateInput;
};
export declare type MutationViewPreferencesDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationViewPreferencesUpdateArgs = {
    id: Scalars["String"];
    input: ViewPreferencesUpdateInput;
};
export declare type MutationWebhookCreateArgs = {
    input: WebhookCreateInput;
};
export declare type MutationWebhookDeleteArgs = {
    id: Scalars["String"];
};
export declare type MutationWebhookUpdateArgs = {
    id: Scalars["String"];
    input: WebhookUpdateInput;
};
export declare type MutationWorkflowStateArchiveArgs = {
    id: Scalars["String"];
};
export declare type MutationWorkflowStateCreateArgs = {
    input: WorkflowStateCreateInput;
};
export declare type MutationWorkflowStateUpdateArgs = {
    id: Scalars["String"];
    input: WorkflowStateUpdateInput;
};
/** Customer name sorting options. */
export declare type NameSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
export declare type Node = {
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
};
/** A notification sent to a user. */
export declare type Notification = {
    /** The user that caused the notification. */
    actor?: Maybe<User>;
    /** [Internal] Notification actor initials if avatar is not available. */
    actorAvatarColor: Scalars["String"];
    /** [Internal] Notification avatar URL. */
    actorAvatarUrl?: Maybe<Scalars["String"]>;
    /** [Internal] Notification actor initials if avatar is not available. */
    actorInitials?: Maybe<Scalars["String"]>;
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The bot that caused the notification. */
    botActor?: Maybe<ActorBot>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /**
     * The time at when an email reminder for this notification was sent to the user. Null, if no email
     *     reminder has been sent.
     */
    emailedAt?: Maybe<Scalars["DateTime"]>;
    /** The external user that caused the notification. */
    externalUserActor?: Maybe<ExternalUser>;
    /** [Internal] Notifications with the same grouping key will be grouped together in the UI. */
    groupingKey: Scalars["String"];
    /** [Internal] Priority of the notification with the same grouping key. Higher number means higher priority. If priority is the same, notifications should be sorted by `createdAt`. */
    groupingPriority: Scalars["Float"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** [Internal] Inbox URL for the notification. */
    inboxUrl: Scalars["String"];
    /** [Internal] If notification actor was Linear. */
    isLinearActor: Scalars["Boolean"];
    /** [Internal] Issue's status type for issue notifications. */
    issueStatusType?: Maybe<Scalars["String"]>;
    /** [Internal] Project update health for new updates. */
    projectUpdateHealth?: Maybe<Scalars["String"]>;
    /** The time at when the user marked the notification as read. Null, if the the user hasn't read the notification */
    readAt?: Maybe<Scalars["DateTime"]>;
    /** The time until a notification will be snoozed. After that it will appear in the inbox again. */
    snoozedUntilAt?: Maybe<Scalars["DateTime"]>;
    /** [Internal] Notification subtitle. */
    subtitle: Scalars["String"];
    /** [Internal] Notification title. */
    title: Scalars["String"];
    /** Notification type. */
    type: Scalars["String"];
    /** The time at which a notification was unsnoozed.. */
    unsnoozedAt?: Maybe<Scalars["DateTime"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** [Internal] URL to the target of the notification. */
    url: Scalars["String"];
    /** The user that received the notification. */
    user: User;
};
/** A generic payload return from entity archive mutations. */
export declare type NotificationArchivePayload = ArchivePayload & {
    __typename?: "NotificationArchivePayload";
    /** The archived/unarchived entity. Null if entity was deleted. */
    entity?: Maybe<Notification>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type NotificationBatchActionPayload = {
    __typename?: "NotificationBatchActionPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** The notifications that were updated. */
    notifications: Array<Notification>;
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** The categories of notifications a user can subscribe to. */
export declare enum NotificationCategory {
    AppsAndIntegrations = "appsAndIntegrations",
    Assignments = "assignments",
    CommentsAndReplies = "commentsAndReplies",
    Customers = "customers",
    DocumentChanges = "documentChanges",
    Mentions = "mentions",
    PostsAndUpdates = "postsAndUpdates",
    Reactions = "reactions",
    Reminders = "reminders",
    Reviews = "reviews",
    StatusChanges = "statusChanges",
    Subscriptions = "subscriptions",
    System = "system",
    Triage = "triage"
}
/** A user's notification category preferences. */
export declare type NotificationCategoryPreferences = {
    __typename?: "NotificationCategoryPreferences";
    /** The preferences for notifications about apps and integrations. */
    appsAndIntegrations: NotificationChannelPreferences;
    /** The preferences for notifications about assignments. */
    assignments: NotificationChannelPreferences;
    /** The preferences for notifications about comments and replies. */
    commentsAndReplies: NotificationChannelPreferences;
    /** The preferences for customer notifications. */
    customers: NotificationChannelPreferences;
    /** The preferences for notifications about document changes. */
    documentChanges: NotificationChannelPreferences;
    /** The preferences for notifications about mentions. */
    mentions: NotificationChannelPreferences;
    /** The preferences for notifications about posts and updates. */
    postsAndUpdates: NotificationChannelPreferences;
    /** The preferences for notifications about reactions. */
    reactions: NotificationChannelPreferences;
    /** The preferences for notifications about reminders. */
    reminders: NotificationChannelPreferences;
    /** The preferences for notifications about reviews. */
    reviews: NotificationChannelPreferences;
    /** The preferences for notifications about status changes. */
    statusChanges: NotificationChannelPreferences;
    /** The preferences for notifications about subscriptions. */
    subscriptions: NotificationChannelPreferences;
    /** The preferences for system notifications. */
    system: NotificationChannelPreferences;
    /** The preferences for triage notifications. */
    triage: NotificationChannelPreferences;
};
export declare type NotificationCategoryPreferencesInput = {
    /** The preferences for notifications about apps and integrations. */
    appsAndIntegrations?: Maybe<PartialNotificationChannelPreferencesInput>;
    /** The preferences for notifications about assignments. */
    assignments?: Maybe<PartialNotificationChannelPreferencesInput>;
    /** The preferences for notifications about comments and replies. */
    commentsAndReplies?: Maybe<PartialNotificationChannelPreferencesInput>;
    /** The preferences for notifications about customers. */
    customers?: Maybe<PartialNotificationChannelPreferencesInput>;
    /** The preferences for notifications about document changes. */
    documentChanges?: Maybe<PartialNotificationChannelPreferencesInput>;
    /** The preferences for notifications about mentions. */
    mentions?: Maybe<PartialNotificationChannelPreferencesInput>;
    /** The preferences for notifications about posts and updates. */
    postsAndUpdates?: Maybe<PartialNotificationChannelPreferencesInput>;
    /** The preferences for notifications about reactions. */
    reactions?: Maybe<PartialNotificationChannelPreferencesInput>;
    /** The preferences for notifications about reminders. */
    reminders?: Maybe<PartialNotificationChannelPreferencesInput>;
    /** The preferences for notifications about reviews. */
    reviews?: Maybe<PartialNotificationChannelPreferencesInput>;
    /** The preferences for notifications about status changes. */
    statusChanges?: Maybe<PartialNotificationChannelPreferencesInput>;
    /** The preferences for notifications about subscriptions. */
    subscriptions?: Maybe<PartialNotificationChannelPreferencesInput>;
    /** The preferences for notifications about triage. */
    triage?: Maybe<PartialNotificationChannelPreferencesInput>;
};
/** The delivery channels a user can receive notifications in. */
export declare enum NotificationChannel {
    Desktop = "desktop",
    Email = "email",
    Mobile = "mobile",
    Slack = "slack"
}
/** A user's notification channel preferences, indicating if a channel is enabled or not */
export declare type NotificationChannelPreferences = {
    __typename?: "NotificationChannelPreferences";
    /** Whether notifications are currently enabled for desktop. */
    desktop: Scalars["Boolean"];
    /** Whether notifications are currently enabled for email. */
    email: Scalars["Boolean"];
    /** Whether notifications are currently enabled for mobile. */
    mobile: Scalars["Boolean"];
    /** Whether notifications are currently enabled for Slack. */
    slack: Scalars["Boolean"];
};
export declare type NotificationConnection = {
    __typename?: "NotificationConnection";
    edges: Array<NotificationEdge>;
    nodes: Array<Notification>;
    pageInfo: PageInfo;
};
/** A user's notification delivery preferences. */
export declare type NotificationDeliveryPreferences = {
    __typename?: "NotificationDeliveryPreferences";
    /** The delivery preferences for the mobile channel. */
    mobile?: Maybe<NotificationDeliveryPreferencesChannel>;
};
/** A user's notification delivery preferences. */
export declare type NotificationDeliveryPreferencesChannel = {
    __typename?: "NotificationDeliveryPreferencesChannel";
    /**
     * [DEPRECATED] Whether notifications are enabled for this channel. Use notificationChannelPreferences instead.
     * @deprecated This field has been replaced by notificationChannelPreferences
     */
    notificationsDisabled?: Maybe<Scalars["Boolean"]>;
    /** The schedule for notifications on this channel. */
    schedule?: Maybe<NotificationDeliveryPreferencesSchedule>;
};
export declare type NotificationDeliveryPreferencesChannelInput = {
    /** The schedule for notifications on this channel. */
    schedule?: Maybe<NotificationDeliveryPreferencesScheduleInput>;
};
/** A user's notification delivery schedule for a particular day. */
export declare type NotificationDeliveryPreferencesDay = {
    __typename?: "NotificationDeliveryPreferencesDay";
    /** The time notifications end. */
    end?: Maybe<Scalars["String"]>;
    /** The time notifications start. */
    start?: Maybe<Scalars["String"]>;
};
export declare type NotificationDeliveryPreferencesDayInput = {
    /** The time notifications end. */
    end?: Maybe<Scalars["String"]>;
    /** The time notifications start. */
    start?: Maybe<Scalars["String"]>;
};
export declare type NotificationDeliveryPreferencesInput = {
    /** The delivery preferences for the mobile channel. */
    mobile?: Maybe<NotificationDeliveryPreferencesChannelInput>;
};
/** A user's notification delivery schedule for a particular day. */
export declare type NotificationDeliveryPreferencesSchedule = {
    __typename?: "NotificationDeliveryPreferencesSchedule";
    /** Whether the schedule is disabled. */
    disabled?: Maybe<Scalars["Boolean"]>;
    /** Delivery preferences for Friday. */
    friday: NotificationDeliveryPreferencesDay;
    /** Delivery preferences for Monday. */
    monday: NotificationDeliveryPreferencesDay;
    /** Delivery preferences for Saturday. */
    saturday: NotificationDeliveryPreferencesDay;
    /** Delivery preferences for Sunday. */
    sunday: NotificationDeliveryPreferencesDay;
    /** Delivery preferences for Thursday. */
    thursday: NotificationDeliveryPreferencesDay;
    /** Delivery preferences for Tuesday. */
    tuesday: NotificationDeliveryPreferencesDay;
    /** Delivery preferences for Wednesday. */
    wednesday: NotificationDeliveryPreferencesDay;
};
export declare type NotificationDeliveryPreferencesScheduleInput = {
    /** Whether the schedule is disabled. */
    disabled?: Maybe<Scalars["Boolean"]>;
    /** Delivery preferences for Friday. */
    friday: NotificationDeliveryPreferencesDayInput;
    /** Delivery preferences for Monday. */
    monday: NotificationDeliveryPreferencesDayInput;
    /** Delivery preferences for Saturday. */
    saturday: NotificationDeliveryPreferencesDayInput;
    /** Delivery preferences for Sunday. */
    sunday: NotificationDeliveryPreferencesDayInput;
    /** Delivery preferences for Thursday. */
    thursday: NotificationDeliveryPreferencesDayInput;
    /** Delivery preferences for Tuesday. */
    tuesday: NotificationDeliveryPreferencesDayInput;
    /** Delivery preferences for Wednesday. */
    wednesday: NotificationDeliveryPreferencesDayInput;
};
export declare type NotificationEdge = {
    __typename?: "NotificationEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: Notification;
};
/** Describes the type and id of the entity to target for notifications. */
export declare type NotificationEntityInput = {
    /** The id of the notification. */
    id?: Maybe<Scalars["String"]>;
    /** The id of the initiative related to the notification. */
    initiativeId?: Maybe<Scalars["String"]>;
    /** The id of the initiative update related to the notification. */
    initiativeUpdateId?: Maybe<Scalars["String"]>;
    /** The id of the issue related to the notification. */
    issueId?: Maybe<Scalars["String"]>;
    /** The id of the OAuth client approval related to the notification. */
    oauthClientApprovalId?: Maybe<Scalars["String"]>;
    /** [DEPRECATED] The id of the project related to the notification. */
    projectId?: Maybe<Scalars["String"]>;
    /** The id of the project update related to the notification. */
    projectUpdateId?: Maybe<Scalars["String"]>;
};
/** Notification filtering options. */
export declare type NotificationFilter = {
    /** Compound filters, all of which need to be matched by the notification. */
    and?: Maybe<Array<NotificationFilter>>;
    /** Comparator for the archived at date. */
    archivedAt?: Maybe<DateComparator>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Compound filters, one of which need to be matched by the notification. */
    or?: Maybe<Array<NotificationFilter>>;
    /** Comparator for the notification type. */
    type?: Maybe<StringComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type NotificationPayload = {
    __typename?: "NotificationPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** The notification that was created or updated. */
    notification: Notification;
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** Notification subscriptions for models. */
export declare type NotificationSubscription = {
    /** Whether the subscription is active or not. */
    active: Scalars["Boolean"];
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The type of view to which the notification subscription context is associated with. */
    contextViewType?: Maybe<ContextViewType>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The contextual custom view associated with the notification subscription. */
    customView?: Maybe<CustomView>;
    /** The customer associated with the notification subscription. */
    customer?: Maybe<Customer>;
    /** The contextual cycle view associated with the notification subscription. */
    cycle?: Maybe<Cycle>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The contextual initiative view associated with the notification subscription. */
    initiative?: Maybe<Initiative>;
    /** The contextual label view associated with the notification subscription. */
    label?: Maybe<IssueLabel>;
    /** The contextual project view associated with the notification subscription. */
    project?: Maybe<Project>;
    /** The user that subscribed to receive notifications. */
    subscriber: User;
    /** The team associated with the notification subscription. */
    team?: Maybe<Team>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The user view associated with the notification subscription. */
    user?: Maybe<User>;
    /** The type of user view to which the notification subscription context is associated with. */
    userContextViewType?: Maybe<UserContextViewType>;
};
export declare type NotificationSubscriptionConnection = {
    __typename?: "NotificationSubscriptionConnection";
    edges: Array<NotificationSubscriptionEdge>;
    nodes: Array<NotificationSubscription>;
    pageInfo: PageInfo;
};
export declare type NotificationSubscriptionCreateInput = {
    /** Whether the subscription is active. */
    active?: Maybe<Scalars["Boolean"]>;
    /** The type of view to which the notification subscription context is associated with. */
    contextViewType?: Maybe<ContextViewType>;
    /** The identifier of the custom view to subscribe to. */
    customViewId?: Maybe<Scalars["String"]>;
    /** The identifier of the customer to subscribe to. */
    customerId?: Maybe<Scalars["String"]>;
    /** The identifier of the cycle to subscribe to. */
    cycleId?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The identifier of the initiative to subscribe to. */
    initiativeId?: Maybe<Scalars["String"]>;
    /** The identifier of the label to subscribe to. */
    labelId?: Maybe<Scalars["String"]>;
    /** The types of notifications of the subscription. */
    notificationSubscriptionTypes?: Maybe<Array<Scalars["String"]>>;
    /** The identifier of the project to subscribe to. */
    projectId?: Maybe<Scalars["String"]>;
    /** The identifier of the team to subscribe to. */
    teamId?: Maybe<Scalars["String"]>;
    /** The type of user view to which the notification subscription context is associated with. */
    userContextViewType?: Maybe<UserContextViewType>;
    /** The identifier of the user to subscribe to. */
    userId?: Maybe<Scalars["String"]>;
};
export declare type NotificationSubscriptionEdge = {
    __typename?: "NotificationSubscriptionEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: NotificationSubscription;
};
export declare type NotificationSubscriptionPayload = {
    __typename?: "NotificationSubscriptionPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** The notification subscription that was created or updated. */
    notificationSubscription: NotificationSubscription;
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type NotificationSubscriptionUpdateInput = {
    /** Whether the subscription is active. */
    active?: Maybe<Scalars["Boolean"]>;
    /** The types of notifications of the subscription. */
    notificationSubscriptionTypes?: Maybe<Array<Scalars["String"]>>;
};
export declare type NotificationUpdateInput = {
    /** The id of the project update related to the notification. */
    initiativeUpdateId?: Maybe<Scalars["String"]>;
    /** The id of the project update related to the notification. */
    projectUpdateId?: Maybe<Scalars["String"]>;
    /** The time when notification was marked as read. */
    readAt?: Maybe<Scalars["DateTime"]>;
    /** The time until a notification will be snoozed. After that it will appear in the inbox again. */
    snoozedUntilAt?: Maybe<Scalars["DateTime"]>;
};
export declare type NotionSettingsInput = {
    /** The ID of the Notion workspace being connected. */
    workspaceId: Scalars["String"];
    /** The name of the Notion workspace being connected. */
    workspaceName: Scalars["String"];
};
/** Comment filtering options. */
export declare type NullableCommentFilter = {
    /** Compound filters, all of which need to be matched by the comment. */
    and?: Maybe<Array<NullableCommentFilter>>;
    /** Comparator for the comment's body. */
    body?: Maybe<StringComparator>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the comment's document content must satisfy. */
    documentContent?: Maybe<NullableDocumentContentFilter>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Filters that the comment's issue must satisfy. */
    issue?: Maybe<NullableIssueFilter>;
    /** Filters that the comment's customer needs must satisfy. */
    needs?: Maybe<CustomerNeedCollectionFilter>;
    /** Filter based on the existence of the relation. */
    null?: Maybe<Scalars["Boolean"]>;
    /** Compound filters, one of which need to be matched by the comment. */
    or?: Maybe<Array<NullableCommentFilter>>;
    /** Filters that the comment parent must satisfy. */
    parent?: Maybe<NullableCommentFilter>;
    /** Filters that the comment's project update must satisfy. */
    projectUpdate?: Maybe<NullableProjectUpdateFilter>;
    /** Filters that the comment's reactions must satisfy. */
    reactions?: Maybe<ReactionCollectionFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
    /** Filters that the comment's creator must satisfy. */
    user?: Maybe<UserFilter>;
};
/** Customer filtering options. */
export declare type NullableCustomerFilter = {
    /** Compound filters, all of which need to be matched by the customer. */
    and?: Maybe<Array<NullableCustomerFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the customer's domains. */
    domains?: Maybe<StringArrayComparator>;
    /** Comparator for the customer's external IDs. */
    externalIds?: Maybe<StringArrayComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the customer name. */
    name?: Maybe<StringComparator>;
    /** Filters that the customer's needs must satisfy. */
    needs?: Maybe<CustomerNeedCollectionFilter>;
    /** Filter based on the existence of the relation. */
    null?: Maybe<Scalars["Boolean"]>;
    /** Compound filters, one of which need to be matched by the customer. */
    or?: Maybe<Array<NullableCustomerFilter>>;
    /** Filters that the customer owner must satisfy. */
    owner?: Maybe<NullableUserFilter>;
    /** Comparator for the customer generated revenue. */
    revenue?: Maybe<NumberComparator>;
    /** Comparator for the customer size. */
    size?: Maybe<NumberComparator>;
    /** Comparator for the customer slack channel ID. */
    slackChannelId?: Maybe<StringComparator>;
    /** Filters that the customer's status must satisfy. */
    status?: Maybe<CustomerStatusFilter>;
    /** Filters that the customer's tier must satisfy. */
    tier?: Maybe<CustomerTierFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** Cycle filtering options. */
export declare type NullableCycleFilter = {
    /** Compound filters, all of which need to be matched by the cycle. */
    and?: Maybe<Array<NullableCycleFilter>>;
    /** Comparator for the cycle completed at date. */
    completedAt?: Maybe<DateComparator>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the cycle ends at date. */
    endsAt?: Maybe<DateComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the filtering active cycle. */
    isActive?: Maybe<BooleanComparator>;
    /** Comparator for the filtering future cycles. */
    isFuture?: Maybe<BooleanComparator>;
    /** Comparator for filtering for whether the cycle is currently in cooldown. */
    isInCooldown?: Maybe<BooleanComparator>;
    /** Comparator for the filtering next cycle. */
    isNext?: Maybe<BooleanComparator>;
    /** Comparator for the filtering past cycles. */
    isPast?: Maybe<BooleanComparator>;
    /** Comparator for the filtering previous cycle. */
    isPrevious?: Maybe<BooleanComparator>;
    /** Filters that the cycles issues must satisfy. */
    issues?: Maybe<IssueCollectionFilter>;
    /** Comparator for the cycle name. */
    name?: Maybe<StringComparator>;
    /** Filter based on the existence of the relation. */
    null?: Maybe<Scalars["Boolean"]>;
    /** Comparator for the cycle number. */
    number?: Maybe<NumberComparator>;
    /** Compound filters, one of which need to be matched by the cycle. */
    or?: Maybe<Array<NullableCycleFilter>>;
    /** Comparator for the cycle start date. */
    startsAt?: Maybe<DateComparator>;
    /** Filters that the cycles team must satisfy. */
    team?: Maybe<TeamFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** Comparator for optional dates. */
export declare type NullableDateComparator = {
    /** Equals constraint. */
    eq?: Maybe<Scalars["DateTimeOrDuration"]>;
    /** Greater-than constraint. Matches any values that are greater than the given value. */
    gt?: Maybe<Scalars["DateTimeOrDuration"]>;
    /** Greater-than-or-equal constraint. Matches any values that are greater than or equal to the given value. */
    gte?: Maybe<Scalars["DateTimeOrDuration"]>;
    /** In-array constraint. */
    in?: Maybe<Array<Scalars["DateTimeOrDuration"]>>;
    /** Less-than constraint. Matches any values that are less than the given value. */
    lt?: Maybe<Scalars["DateTimeOrDuration"]>;
    /** Less-than-or-equal constraint. Matches any values that are less than or equal to the given value. */
    lte?: Maybe<Scalars["DateTimeOrDuration"]>;
    /** Not-equals constraint. */
    neq?: Maybe<Scalars["DateTimeOrDuration"]>;
    /** Not-in-array constraint. */
    nin?: Maybe<Array<Scalars["DateTimeOrDuration"]>>;
    /** Null constraint. Matches any non-null values if the given value is false, otherwise it matches null values. */
    null?: Maybe<Scalars["Boolean"]>;
};
/** Document content filtering options. */
export declare type NullableDocumentContentFilter = {
    /** Compound filters, all of which need to be matched by the user. */
    and?: Maybe<Array<NullableDocumentContentFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the document content document must satisfy. */
    document?: Maybe<DocumentFilter>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Filter based on the existence of the relation. */
    null?: Maybe<Scalars["Boolean"]>;
    /** Compound filters, one of which need to be matched by the user. */
    or?: Maybe<Array<NullableDocumentContentFilter>>;
    /** Filters that the document content project must satisfy. */
    project?: Maybe<ProjectFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** Nullable comparator for optional durations. */
export declare type NullableDurationComparator = {
    /** Equals constraint. */
    eq?: Maybe<Scalars["Duration"]>;
    /** Greater-than constraint. Matches any values that are greater than the given value. */
    gt?: Maybe<Scalars["Duration"]>;
    /** Greater-than-or-equal constraint. Matches any values that are greater than or equal to the given value. */
    gte?: Maybe<Scalars["Duration"]>;
    /** In-array constraint. */
    in?: Maybe<Array<Scalars["Duration"]>>;
    /** Less-than constraint. Matches any values that are less than the given value. */
    lt?: Maybe<Scalars["Duration"]>;
    /** Less-than-or-equal constraint. Matches any values that are less than or equal to the given value. */
    lte?: Maybe<Scalars["Duration"]>;
    /** Not-equals constraint. */
    neq?: Maybe<Scalars["Duration"]>;
    /** Not-in-array constraint. */
    nin?: Maybe<Array<Scalars["Duration"]>>;
    /** Null constraint. Matches any non-null values if the given value is false, otherwise it matches null values. */
    null?: Maybe<Scalars["Boolean"]>;
};
/** Issue filtering options. */
export declare type NullableIssueFilter = {
    /** Comparator for the issues added to cycle at date. */
    addedToCycleAt?: Maybe<NullableDateComparator>;
    /** Comparator for the period when issue was added to a cycle. */
    addedToCyclePeriod?: Maybe<CyclePeriodComparator>;
    /** [Internal] Age (created -> now) comparator, defined if the issue is still open. */
    ageTime?: Maybe<NullableDurationComparator>;
    /** Compound filters, all of which need to be matched by the issue. */
    and?: Maybe<Array<NullableIssueFilter>>;
    /** Comparator for the issues archived at date. */
    archivedAt?: Maybe<NullableDateComparator>;
    /** Filters that the issues assignee must satisfy. */
    assignee?: Maybe<NullableUserFilter>;
    /** Filters that the issues attachments must satisfy. */
    attachments?: Maybe<AttachmentCollectionFilter>;
    /** Comparator for the issues auto archived at date. */
    autoArchivedAt?: Maybe<NullableDateComparator>;
    /** Comparator for the issues auto closed at date. */
    autoClosedAt?: Maybe<NullableDateComparator>;
    /** Comparator for the issues canceled at date. */
    canceledAt?: Maybe<NullableDateComparator>;
    /** Filters that the child issues must satisfy. */
    children?: Maybe<IssueCollectionFilter>;
    /** Filters that the issues comments must satisfy. */
    comments?: Maybe<CommentCollectionFilter>;
    /** Comparator for the issues completed at date. */
    completedAt?: Maybe<NullableDateComparator>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the issues creator must satisfy. */
    creator?: Maybe<NullableUserFilter>;
    /** Count of customers */
    customerCount?: Maybe<NumberComparator>;
    /** Filters that the issues cycle must satisfy. */
    cycle?: Maybe<NullableCycleFilter>;
    /** [Internal] Cycle time (started -> completed) comparator. */
    cycleTime?: Maybe<NullableDurationComparator>;
    /** Comparator for the issues description. */
    description?: Maybe<NullableStringComparator>;
    /** Comparator for the issues due date. */
    dueDate?: Maybe<NullableTimelessDateComparator>;
    /** Comparator for the issues estimate. */
    estimate?: Maybe<EstimateComparator>;
    /** Comparator for filtering issues which are blocked. */
    hasBlockedByRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for filtering issues which are blocking. */
    hasBlockingRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for filtering issues which are duplicates. */
    hasDuplicateRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for filtering issues with relations. */
    hasRelatedRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Filters that issue labels must satisfy. */
    labels?: Maybe<IssueLabelCollectionFilter>;
    /** Filters that the last applied template must satisfy. */
    lastAppliedTemplate?: Maybe<NullableTemplateFilter>;
    /** [Internal] Lead time (created -> completed) comparator. */
    leadTime?: Maybe<NullableDurationComparator>;
    /** Filters that the issue's customer needs must satisfy. */
    needs?: Maybe<CustomerNeedCollectionFilter>;
    /** Filter based on the existence of the relation. */
    null?: Maybe<Scalars["Boolean"]>;
    /** Comparator for the issues number. */
    number?: Maybe<NumberComparator>;
    /** Compound filters, one of which need to be matched by the issue. */
    or?: Maybe<Array<NullableIssueFilter>>;
    /** Filters that the issue parent must satisfy. */
    parent?: Maybe<NullableIssueFilter>;
    /** Comparator for the issues priority. */
    priority?: Maybe<NullableNumberComparator>;
    /** Filters that the issues project must satisfy. */
    project?: Maybe<NullableProjectFilter>;
    /** Filters that the issues project milestone must satisfy. */
    projectMilestone?: Maybe<NullableProjectMilestoneFilter>;
    /** Filters that the issues reactions must satisfy. */
    reactions?: Maybe<ReactionCollectionFilter>;
    /** [ALPHA] Filters that the recurring issue template must satisfy. */
    recurringIssueTemplate?: Maybe<NullableTemplateFilter>;
    /** [Internal] Comparator for the issues content. */
    searchableContent?: Maybe<ContentComparator>;
    /** Comparator for the issues sla status. */
    slaStatus?: Maybe<SlaStatusComparator>;
    /** Filters that the issues snoozer must satisfy. */
    snoozedBy?: Maybe<NullableUserFilter>;
    /** Comparator for the issues snoozed until date. */
    snoozedUntilAt?: Maybe<NullableDateComparator>;
    /** Filters that the source must satisfy. */
    sourceMetadata?: Maybe<SourceMetadataComparator>;
    /** Comparator for the issues started at date. */
    startedAt?: Maybe<NullableDateComparator>;
    /** Filters that the issues state must satisfy. */
    state?: Maybe<WorkflowStateFilter>;
    /** Filters that issue subscribers must satisfy. */
    subscribers?: Maybe<UserCollectionFilter>;
    /** Filters that the issues team must satisfy. */
    team?: Maybe<TeamFilter>;
    /** Comparator for the issues title. */
    title?: Maybe<StringComparator>;
    /** [Internal] Triage time (entered triaged -> triaged) comparator. */
    triageTime?: Maybe<NullableDurationComparator>;
    /** Comparator for the issues triaged at date. */
    triagedAt?: Maybe<NullableDateComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** Comparator for optional numbers. */
export declare type NullableNumberComparator = {
    /** Equals constraint. */
    eq?: Maybe<Scalars["Float"]>;
    /** Greater-than constraint. Matches any values that are greater than the given value. */
    gt?: Maybe<Scalars["Float"]>;
    /** Greater-than-or-equal constraint. Matches any values that are greater than or equal to the given value. */
    gte?: Maybe<Scalars["Float"]>;
    /** In-array constraint. */
    in?: Maybe<Array<Scalars["Float"]>>;
    /** Less-than constraint. Matches any values that are less than the given value. */
    lt?: Maybe<Scalars["Float"]>;
    /** Less-than-or-equal constraint. Matches any values that are less than or equal to the given value. */
    lte?: Maybe<Scalars["Float"]>;
    /** Not-equals constraint. */
    neq?: Maybe<Scalars["Float"]>;
    /** Not-in-array constraint. */
    nin?: Maybe<Array<Scalars["Float"]>>;
    /** Null constraint. Matches any non-null values if the given value is false, otherwise it matches null values. */
    null?: Maybe<Scalars["Boolean"]>;
};
/** Project filtering options. */
export declare type NullableProjectFilter = {
    /** Filters that the project's team must satisfy. */
    accessibleTeams?: Maybe<TeamCollectionFilter>;
    /** Compound filters, all of which need to be matched by the project. */
    and?: Maybe<Array<NullableProjectFilter>>;
    /** Comparator for the project cancelation date. */
    canceledAt?: Maybe<NullableDateComparator>;
    /** Comparator for the project completion date. */
    completedAt?: Maybe<NullableDateComparator>;
    /** Filters that the project's completed milestones must satisfy. */
    completedProjectMilestones?: Maybe<ProjectMilestoneCollectionFilter>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the projects creator must satisfy. */
    creator?: Maybe<UserFilter>;
    /** Count of customers */
    customerCount?: Maybe<NumberComparator>;
    /** Comparator for filtering projects which are blocked. */
    hasBlockedByRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for filtering projects which are blocking. */
    hasBlockingRelations?: Maybe<RelationExistsComparator>;
    /** [Deprecated] Comparator for filtering projects which this is depended on by. */
    hasDependedOnByRelations?: Maybe<RelationExistsComparator>;
    /** [Deprecated]Comparator for filtering projects which this depends on. */
    hasDependsOnRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for filtering projects with relations. */
    hasRelatedRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for filtering projects with violated dependencies. */
    hasViolatedRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for the project health: onTrack, atRisk, offTrack */
    health?: Maybe<StringComparator>;
    /** Comparator for the project health (with age): onTrack, atRisk, offTrack, outdated, noUpdate */
    healthWithAge?: Maybe<StringComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Filters that the projects initiatives must satisfy. */
    initiatives?: Maybe<InitiativeCollectionFilter>;
    /** Filters that the projects issues must satisfy. */
    issues?: Maybe<IssueCollectionFilter>;
    /** [Internal] Filters that project labels must satisfy. */
    labels?: Maybe<ProjectLabelCollectionFilter>;
    /** Filters that the last applied template must satisfy. */
    lastAppliedTemplate?: Maybe<NullableTemplateFilter>;
    /** Filters that the projects lead must satisfy. */
    lead?: Maybe<NullableUserFilter>;
    /** Filters that the projects members must satisfy. */
    members?: Maybe<UserCollectionFilter>;
    /** Comparator for the project name. */
    name?: Maybe<StringComparator>;
    /** Filters that the project's customer needs must satisfy. */
    needs?: Maybe<CustomerNeedCollectionFilter>;
    /** Filters that the project's next milestone must satisfy. */
    nextProjectMilestone?: Maybe<ProjectMilestoneFilter>;
    /** Filter based on the existence of the relation. */
    null?: Maybe<Scalars["Boolean"]>;
    /** Compound filters, one of which need to be matched by the project. */
    or?: Maybe<Array<NullableProjectFilter>>;
    /** Comparator for the projects priority. */
    priority?: Maybe<NullableNumberComparator>;
    /** Filters that the project's milestones must satisfy. */
    projectMilestones?: Maybe<ProjectMilestoneCollectionFilter>;
    /** Comparator for the project updates. */
    projectUpdates?: Maybe<ProjectUpdatesCollectionFilter>;
    /** Filters that the projects roadmaps must satisfy. */
    roadmaps?: Maybe<RoadmapCollectionFilter>;
    /** [Internal] Comparator for the project's content. */
    searchableContent?: Maybe<ContentComparator>;
    /** Comparator for the project slug ID. */
    slugId?: Maybe<StringComparator>;
    /** Comparator for the project start date. */
    startDate?: Maybe<NullableDateComparator>;
    /** [DEPRECATED] Comparator for the project state. */
    state?: Maybe<StringComparator>;
    /** Filters that the project's status must satisfy. */
    status?: Maybe<ProjectStatusFilter>;
    /** Comparator for the project target date. */
    targetDate?: Maybe<NullableDateComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** Project milestone filtering options. */
export declare type NullableProjectMilestoneFilter = {
    /** Compound filters, all of which need to be matched by the project milestone. */
    and?: Maybe<Array<NullableProjectMilestoneFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the project milestone name. */
    name?: Maybe<NullableStringComparator>;
    /** Filter based on the existence of the relation. */
    null?: Maybe<Scalars["Boolean"]>;
    /** Compound filters, one of which need to be matched by the project milestone. */
    or?: Maybe<Array<NullableProjectMilestoneFilter>>;
    /** Comparator for the project milestone target date. */
    targetDate?: Maybe<NullableDateComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** Nullable project update filtering options. */
export declare type NullableProjectUpdateFilter = {
    /** Compound filters, all of which need to be matched by the project update. */
    and?: Maybe<Array<NullableProjectUpdateFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Filter based on the existence of the relation. */
    null?: Maybe<Scalars["Boolean"]>;
    /** Compound filters, one of which need to be matched by the project update. */
    or?: Maybe<Array<NullableProjectUpdateFilter>>;
    /** Filters that the project update project must satisfy. */
    project?: Maybe<ProjectFilter>;
    /** Filters that the project updates reactions must satisfy. */
    reactions?: Maybe<ReactionCollectionFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
    /** Filters that the project update creator must satisfy. */
    user?: Maybe<UserFilter>;
};
/** Comparator for optional strings. */
export declare type NullableStringComparator = {
    /** Contains constraint. Matches any values that contain the given string. */
    contains?: Maybe<Scalars["String"]>;
    /** Contains case insensitive constraint. Matches any values that contain the given string case insensitive. */
    containsIgnoreCase?: Maybe<Scalars["String"]>;
    /** Contains case and accent insensitive constraint. Matches any values that contain the given string case and accent insensitive. */
    containsIgnoreCaseAndAccent?: Maybe<Scalars["String"]>;
    /** Ends with constraint. Matches any values that end with the given string. */
    endsWith?: Maybe<Scalars["String"]>;
    /** Equals constraint. */
    eq?: Maybe<Scalars["String"]>;
    /** Equals case insensitive. Matches any values that matches the given string case insensitive. */
    eqIgnoreCase?: Maybe<Scalars["String"]>;
    /** In-array constraint. */
    in?: Maybe<Array<Scalars["String"]>>;
    /** Not-equals constraint. */
    neq?: Maybe<Scalars["String"]>;
    /** Not-equals case insensitive. Matches any values that don't match the given string case insensitive. */
    neqIgnoreCase?: Maybe<Scalars["String"]>;
    /** Not-in-array constraint. */
    nin?: Maybe<Array<Scalars["String"]>>;
    /** Doesn't contain constraint. Matches any values that don't contain the given string. */
    notContains?: Maybe<Scalars["String"]>;
    /** Doesn't contain case insensitive constraint. Matches any values that don't contain the given string case insensitive. */
    notContainsIgnoreCase?: Maybe<Scalars["String"]>;
    /** Doesn't end with constraint. Matches any values that don't end with the given string. */
    notEndsWith?: Maybe<Scalars["String"]>;
    /** Doesn't start with constraint. Matches any values that don't start with the given string. */
    notStartsWith?: Maybe<Scalars["String"]>;
    /** Null constraint. Matches any non-null values if the given value is false, otherwise it matches null values. */
    null?: Maybe<Scalars["Boolean"]>;
    /** Starts with constraint. Matches any values that start with the given string. */
    startsWith?: Maybe<Scalars["String"]>;
    /** Starts with case insensitive constraint. Matches any values that start with the given string. */
    startsWithIgnoreCase?: Maybe<Scalars["String"]>;
};
/** Team filtering options. */
export declare type NullableTeamFilter = {
    /** Compound filters, all of which need to be matched by the team. */
    and?: Maybe<Array<NullableTeamFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the team description. */
    description?: Maybe<NullableStringComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Filters that the teams issues must satisfy. */
    issues?: Maybe<IssueCollectionFilter>;
    /** Comparator for the team key. */
    key?: Maybe<StringComparator>;
    /** Comparator for the team name. */
    name?: Maybe<StringComparator>;
    /** Filter based on the existence of the relation. */
    null?: Maybe<Scalars["Boolean"]>;
    /** Compound filters, one of which need to be matched by the team. */
    or?: Maybe<Array<NullableTeamFilter>>;
    /** Filters that the teams parent must satisfy. */
    parent?: Maybe<NullableTeamFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** Template filtering options. */
export declare type NullableTemplateFilter = {
    /** Compound filters, all of which need to be matched by the template. */
    and?: Maybe<Array<NullableTemplateFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the template's name. */
    name?: Maybe<StringComparator>;
    /** Filter based on the existence of the relation. */
    null?: Maybe<Scalars["Boolean"]>;
    /** Compound filters, one of which need to be matched by the template. */
    or?: Maybe<Array<NullableTemplateFilter>>;
    /** Comparator for the template's type. */
    type?: Maybe<StringComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** Comparator for optional timeless dates. */
export declare type NullableTimelessDateComparator = {
    /** Equals constraint. */
    eq?: Maybe<Scalars["TimelessDateOrDuration"]>;
    /** Greater-than constraint. Matches any values that are greater than the given value. */
    gt?: Maybe<Scalars["TimelessDateOrDuration"]>;
    /** Greater-than-or-equal constraint. Matches any values that are greater than or equal to the given value. */
    gte?: Maybe<Scalars["TimelessDateOrDuration"]>;
    /** In-array constraint. */
    in?: Maybe<Array<Scalars["TimelessDateOrDuration"]>>;
    /** Less-than constraint. Matches any values that are less than the given value. */
    lt?: Maybe<Scalars["TimelessDateOrDuration"]>;
    /** Less-than-or-equal constraint. Matches any values that are less than or equal to the given value. */
    lte?: Maybe<Scalars["TimelessDateOrDuration"]>;
    /** Not-equals constraint. */
    neq?: Maybe<Scalars["TimelessDateOrDuration"]>;
    /** Not-in-array constraint. */
    nin?: Maybe<Array<Scalars["TimelessDateOrDuration"]>>;
    /** Null constraint. Matches any non-null values if the given value is false, otherwise it matches null values. */
    null?: Maybe<Scalars["Boolean"]>;
};
/** User filtering options. */
export declare type NullableUserFilter = {
    /** Comparator for the user's activity status. */
    active?: Maybe<BooleanComparator>;
    /** Comparator for the user's admin status. */
    admin?: Maybe<BooleanComparator>;
    /** Compound filters, all of which need to be matched by the user. */
    and?: Maybe<Array<NullableUserFilter>>;
    /** Comparator for the user's app status. */
    app?: Maybe<BooleanComparator>;
    /** Filters that the users assigned issues must satisfy. */
    assignedIssues?: Maybe<IssueCollectionFilter>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the user's display name. */
    displayName?: Maybe<StringComparator>;
    /** Comparator for the user's email. */
    email?: Maybe<StringComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the user's invited status. */
    invited?: Maybe<BooleanComparator>;
    /** Filter based on the currently authenticated user. Set to true to filter for the authenticated user, false for any other user. */
    isMe?: Maybe<BooleanComparator>;
    /** Comparator for the user's name. */
    name?: Maybe<StringComparator>;
    /** Filter based on the existence of the relation. */
    null?: Maybe<Scalars["Boolean"]>;
    /** Compound filters, one of which need to be matched by the user. */
    or?: Maybe<Array<NullableUserFilter>>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** Comparator for numbers. */
export declare type NumberComparator = {
    /** Equals constraint. */
    eq?: Maybe<Scalars["Float"]>;
    /** Greater-than constraint. Matches any values that are greater than the given value. */
    gt?: Maybe<Scalars["Float"]>;
    /** Greater-than-or-equal constraint. Matches any values that are greater than or equal to the given value. */
    gte?: Maybe<Scalars["Float"]>;
    /** In-array constraint. */
    in?: Maybe<Array<Scalars["Float"]>>;
    /** Less-than constraint. Matches any values that are less than the given value. */
    lt?: Maybe<Scalars["Float"]>;
    /** Less-than-or-equal constraint. Matches any values that are less than or equal to the given value. */
    lte?: Maybe<Scalars["Float"]>;
    /** Not-equals constraint. */
    neq?: Maybe<Scalars["Float"]>;
    /** Not-in-array constraint. */
    nin?: Maybe<Array<Scalars["Float"]>>;
};
/** The different requests statuses possible for an OAuth client approval request. */
export declare enum OAuthClientApprovalStatus {
    Approved = "approved",
    Denied = "denied",
    Requested = "requested"
}
/** Request to install OAuth clients on organizations and the response to the request. */
export declare type OauthClientApproval = Node & {
    __typename?: "OauthClientApproval";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The reason the request for the OAuth client approval was denied. */
    denyReason?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The uuid of the OAuth client being requested for installation. */
    oauthClientId: Scalars["String"];
    /** The reason the person wants to install this OAuth client. */
    requestReason?: Maybe<Scalars["String"]>;
    /** The person who requested installing the OAuth client. */
    requesterId: Scalars["String"];
    /** The person who responded to the request to install the OAuth client. */
    responderId?: Maybe<Scalars["String"]>;
    /** The scopes the app has requested. */
    scopes: Array<Scalars["String"]>;
    /** The status for the OAuth client approval request. */
    status: OAuthClientApprovalStatus;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
/** An oauth client approval related notification. */
export declare type OauthClientApprovalNotification = Entity & Node & Notification & {
    __typename?: "OauthClientApprovalNotification";
    /** The user that caused the notification. */
    actor?: Maybe<User>;
    /** [Internal] Notification actor initials if avatar is not available. */
    actorAvatarColor: Scalars["String"];
    /** [Internal] Notification avatar URL. */
    actorAvatarUrl?: Maybe<Scalars["String"]>;
    /** [Internal] Notification actor initials if avatar is not available. */
    actorInitials?: Maybe<Scalars["String"]>;
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The bot that caused the notification. */
    botActor?: Maybe<ActorBot>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /**
     * The time at when an email reminder for this notification was sent to the user. Null, if no email
     *     reminder has been sent.
     */
    emailedAt?: Maybe<Scalars["DateTime"]>;
    /** The external user that caused the notification. */
    externalUserActor?: Maybe<ExternalUser>;
    /** [Internal] Notifications with the same grouping key will be grouped together in the UI. */
    groupingKey: Scalars["String"];
    /** [Internal] Priority of the notification with the same grouping key. Higher number means higher priority. If priority is the same, notifications should be sorted by `createdAt`. */
    groupingPriority: Scalars["Float"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** [Internal] Inbox URL for the notification. */
    inboxUrl: Scalars["String"];
    /** [Internal] If notification actor was Linear. */
    isLinearActor: Scalars["Boolean"];
    /** [Internal] Issue's status type for issue notifications. */
    issueStatusType?: Maybe<Scalars["String"]>;
    /** The OAuth client approval request related to the notification. */
    oauthClientApproval: OauthClientApproval;
    /** Related OAuth client approval request ID. */
    oauthClientApprovalId: Scalars["String"];
    /** [Internal] Project update health for new updates. */
    projectUpdateHealth?: Maybe<Scalars["String"]>;
    /** The time at when the user marked the notification as read. Null, if the the user hasn't read the notification */
    readAt?: Maybe<Scalars["DateTime"]>;
    /** The time until a notification will be snoozed. After that it will appear in the inbox again. */
    snoozedUntilAt?: Maybe<Scalars["DateTime"]>;
    /** [Internal] Notification subtitle. */
    subtitle: Scalars["String"];
    /** [Internal] Notification title. */
    title: Scalars["String"];
    /** Notification type. */
    type: Scalars["String"];
    /** The time at which a notification was unsnoozed.. */
    unsnoozedAt?: Maybe<Scalars["DateTime"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** [Internal] URL to the target of the notification. */
    url: Scalars["String"];
    /** The user that received the notification. */
    user: User;
};
export declare type OnboardingCustomerSurvey = {
    companyRole?: Maybe<Scalars["String"]>;
    companySize?: Maybe<Scalars["String"]>;
};
export declare type OpsgenieInput = {
    /** The date when the Opsgenie API failed with an unauthorized error. */
    apiFailedWithUnauthorizedErrorAt?: Maybe<Scalars["DateTime"]>;
};
/** An organization. Organizations are root-level objects that contain user accounts and teams. */
export declare type Organization = Node & {
    __typename?: "Organization";
    /** Whether member users are allowed to send invites. */
    allowMembersToInvite?: Maybe<Scalars["Boolean"]>;
    /** Allowed authentication providers, empty array means all are allowed. */
    allowedAuthServices: Array<Scalars["String"]>;
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** Number of issues in the organization. */
    createdIssueCount: Scalars["Int"];
    /** Number of customers in the organization. */
    customerCount: Scalars["Int"];
    /** Configuration settings for the Customers feature. */
    customersConfiguration: Scalars["JSONObject"];
    /** Whether the organization is using Customers. */
    customersEnabled: Scalars["Boolean"];
    /** Default schedule for how often feed summaries are generated. */
    defaultFeedSummarySchedule?: Maybe<FeedSummarySchedule>;
    /** The time at which deletion of the organization was requested. */
    deletionRequestedAt?: Maybe<Scalars["DateTime"]>;
    /** Whether the organization has enabled the feed feature. */
    feedEnabled: Scalars["Boolean"];
    /** The month at which the fiscal year starts. Defaults to January (0). */
    fiscalYearStartMonth: Scalars["Float"];
    /** How git branches are formatted. If null, default formatting will be used. */
    gitBranchFormat?: Maybe<Scalars["String"]>;
    /** Whether the Git integration linkback messages should be sent to private repositories. */
    gitLinkbackMessagesEnabled: Scalars["Boolean"];
    /** Whether the Git integration linkback messages should be sent to public repositories. */
    gitPublicLinkbackMessagesEnabled: Scalars["Boolean"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The n-weekly frequency at which to prompt for initiative updates. When not set, reminders are off. */
    initiativeUpdateReminderFrequencyInWeeks?: Maybe<Scalars["Float"]>;
    /** The day at which to prompt for initiative updates. */
    initiativeUpdateRemindersDay: Day;
    /** The hour at which to prompt for initiative updates. */
    initiativeUpdateRemindersHour: Scalars["Float"];
    /** Integrations associated with the organization. */
    integrations: IntegrationConnection;
    /** IP restriction configurations. */
    ipRestrictions?: Maybe<Array<OrganizationIpRestriction>>;
    /** Labels associated with the organization. */
    labels: IssueLabelConnection;
    /** The organization's logo URL. */
    logoUrl?: Maybe<Scalars["String"]>;
    /** The organization's name. */
    name: Scalars["String"];
    /** Rolling 30-day total upload volume for the organization, in megabytes. */
    periodUploadVolume: Scalars["Float"];
    /** Previously used URL keys for the organization (last 3 are kept and redirected). */
    previousUrlKeys: Array<Scalars["String"]>;
    /** [Internal] Project labels associated with the organization. */
    projectLabels: ProjectLabelConnection;
    /** The organization's project statuses. */
    projectStatuses: Array<ProjectStatus>;
    /** The n-weekly frequency at which to prompt for project updates. When not set, reminders are off. */
    projectUpdateReminderFrequencyInWeeks?: Maybe<Scalars["Float"]>;
    /** The day at which to prompt for project updates. */
    projectUpdateRemindersDay: Day;
    /** The hour at which to prompt for project updates. */
    projectUpdateRemindersHour: Scalars["Float"];
    /**
     * [DEPRECATED] The frequency at which to prompt for project updates.
     * @deprecated Use organization.projectUpdatesReminderFrequencyInWeeks instead
     */
    projectUpdatesReminderFrequency: ProjectUpdateReminderFrequency;
    /** The feature release channel the organization belongs to. */
    releaseChannel: ReleaseChannel;
    /** Whether team creation is restricted to admins. */
    restrictTeamCreationToAdmins?: Maybe<Scalars["Boolean"]>;
    /** Whether the organization is using a roadmap. */
    roadmapEnabled: Scalars["Boolean"];
    /** Whether SAML authentication is enabled for organization. */
    samlEnabled: Scalars["Boolean"];
    /** [INTERNAL] SAML settings. */
    samlSettings?: Maybe<Scalars["JSONObject"]>;
    /** Whether SCIM provisioning is enabled for organization. */
    scimEnabled: Scalars["Boolean"];
    /** [INTERNAL] SCIM settings. */
    scimSettings?: Maybe<Scalars["JSONObject"]>;
    /**
     * [DEPRECATED] Which day count to use for SLA calculations.
     * @deprecated No longer in use
     */
    slaDayCount: SLADayCountType;
    /** The organization's subscription to a paid plan. */
    subscription?: Maybe<PaidSubscription>;
    /** Teams associated with the organization. */
    teams: TeamConnection;
    /** Templates associated with the organization. */
    templates: TemplateConnection;
    /** [ALPHA] Theme settings for the organization. */
    themeSettings?: Maybe<Scalars["JSONObject"]>;
    /** The time at which the trial will end. */
    trialEndsAt?: Maybe<Scalars["DateTime"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The organization's unique URL key. */
    urlKey: Scalars["String"];
    /** Number of active users in the organization. */
    userCount: Scalars["Int"];
    /** Users associated with the organization. */
    users: UserConnection;
    /** [Internal] The list of working days. Sunday is 0, Monday is 1, etc. */
    workingDays: Array<Scalars["Float"]>;
};
/** An organization. Organizations are root-level objects that contain user accounts and teams. */
export declare type OrganizationIntegrationsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An organization. Organizations are root-level objects that contain user accounts and teams. */
export declare type OrganizationLabelsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueLabelFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An organization. Organizations are root-level objects that contain user accounts and teams. */
export declare type OrganizationProjectLabelsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectLabelFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An organization. Organizations are root-level objects that contain user accounts and teams. */
export declare type OrganizationTeamsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<TeamFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An organization. Organizations are root-level objects that contain user accounts and teams. */
export declare type OrganizationTemplatesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<NullableTemplateFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An organization. Organizations are root-level objects that contain user accounts and teams. */
export declare type OrganizationUsersArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeDisabled?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type OrganizationAcceptedOrExpiredInviteDetailsPayload = {
    __typename?: "OrganizationAcceptedOrExpiredInviteDetailsPayload";
    /** The status of the invite. */
    status: OrganizationInviteStatus;
};
export declare type OrganizationCancelDeletePayload = {
    __typename?: "OrganizationCancelDeletePayload";
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type OrganizationDeletePayload = {
    __typename?: "OrganizationDeletePayload";
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** Defines the use of a domain by an organization. */
export declare type OrganizationDomain = Node & {
    __typename?: "OrganizationDomain";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** What type of auth is the domain used for. */
    authType: OrganizationDomainAuthType;
    /** Whether the domains was claimed by the organization through DNS verification. */
    claimed?: Maybe<Scalars["Boolean"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who added the domain. */
    creator?: Maybe<User>;
    /** Prevent users with this domain to create new workspaces. */
    disableOrganizationCreation?: Maybe<Scalars["Boolean"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** Domain name. */
    name: Scalars["String"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** E-mail used to verify this domain. */
    verificationEmail?: Maybe<Scalars["String"]>;
    /** Is this domain verified. */
    verified: Scalars["Boolean"];
};
/** What type of auth is the domain used for. */
export declare enum OrganizationDomainAuthType {
    General = "general",
    Saml = "saml"
}
/** [INTERNAL] Domain claim request response. */
export declare type OrganizationDomainClaimPayload = {
    __typename?: "OrganizationDomainClaimPayload";
    /** String to put into DNS for verification. */
    verificationString: Scalars["String"];
};
export declare type OrganizationDomainCreateInput = {
    /** The authentication type this domain is for. */
    authType?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The domain name to add. */
    name: Scalars["String"];
    /** The email address to which to send the verification code. */
    verificationEmail?: Maybe<Scalars["String"]>;
};
/** [INTERNAL] Organization domain operation response. */
export declare type OrganizationDomainPayload = {
    __typename?: "OrganizationDomainPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** The organization domain that was created or updated. */
    organizationDomain: OrganizationDomain;
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** [INTERNAL] Organization domain operation response. */
export declare type OrganizationDomainSimplePayload = {
    __typename?: "OrganizationDomainSimplePayload";
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type OrganizationDomainUpdateInput = {
    /** Prevent users with this domain to create new workspaces. Only allowed to set on claimed domains! */
    disableOrganizationCreation?: Maybe<Scalars["Boolean"]>;
};
export declare type OrganizationDomainVerificationInput = {
    /** The identifier in UUID v4 format of the domain being verified. */
    organizationDomainId: Scalars["String"];
    /** The verification code sent via email. */
    verificationCode: Scalars["String"];
};
export declare type OrganizationExistsPayload = {
    __typename?: "OrganizationExistsPayload";
    /** Whether the organization exists. */
    exists: Scalars["Boolean"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** An invitation to the organization that has been sent via email. */
export declare type OrganizationInvite = Node & {
    __typename?: "OrganizationInvite";
    /** The time at which the invite was accepted. Null, if the invite hasn't been accepted. */
    acceptedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The invitees email address. */
    email: Scalars["String"];
    /** The time at which the invite will be expiring. Null, if the invite shouldn't expire. */
    expiresAt?: Maybe<Scalars["DateTime"]>;
    /** The invite was sent to external address. */
    external: Scalars["Boolean"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The user who has accepted the invite. Null, if the invite hasn't been accepted. */
    invitee?: Maybe<User>;
    /** The user who created the invitation. */
    inviter: User;
    /** Extra metadata associated with the organization invite. */
    metadata?: Maybe<Scalars["JSONObject"]>;
    /** The organization that the invite is associated with. */
    organization: Organization;
    /** The user role that the invitee will receive upon accepting the invite. */
    role: UserRoleType;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type OrganizationInviteConnection = {
    __typename?: "OrganizationInviteConnection";
    edges: Array<OrganizationInviteEdge>;
    nodes: Array<OrganizationInvite>;
    pageInfo: PageInfo;
};
export declare type OrganizationInviteCreateInput = {
    /** The email of the invitee. */
    email: Scalars["String"];
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** [INTERNAL] Optional metadata about the invite. */
    metadata?: Maybe<Scalars["JSONObject"]>;
    /** What user role the invite should grant. */
    role?: Maybe<UserRoleType>;
    /** The teams that the user has been invited to. */
    teamIds?: Maybe<Array<Scalars["String"]>>;
};
export declare type OrganizationInviteDetailsPayload = OrganizationAcceptedOrExpiredInviteDetailsPayload | OrganizationInviteFullDetailsPayload;
export declare type OrganizationInviteEdge = {
    __typename?: "OrganizationInviteEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: OrganizationInvite;
};
export declare type OrganizationInviteFullDetailsPayload = {
    __typename?: "OrganizationInviteFullDetailsPayload";
    /** Whether the invite has already been accepted. */
    accepted: Scalars["Boolean"];
    /** Allowed authentication providers, empty array means all are allowed. */
    allowedAuthServices: Array<Scalars["String"]>;
    /** When the invite was created. */
    createdAt: Scalars["DateTime"];
    /** The email of the invitee. */
    email: Scalars["String"];
    /** Whether the invite has expired. */
    expired: Scalars["Boolean"];
    /** The name of the inviter. */
    inviter: Scalars["String"];
    /** ID of the workspace the invite is for. */
    organizationId: Scalars["String"];
    /** URL of the workspace logo the invite is for. */
    organizationLogoUrl?: Maybe<Scalars["String"]>;
    /** Name of the workspace the invite is for. */
    organizationName: Scalars["String"];
    /** What user role the invite should grant. */
    role: UserRoleType;
    /** The status of the invite. */
    status: OrganizationInviteStatus;
};
export declare type OrganizationInvitePayload = {
    __typename?: "OrganizationInvitePayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** The organization invite that was created or updated. */
    organizationInvite: OrganizationInvite;
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** The different statuses possible for an organization invite. */
export declare enum OrganizationInviteStatus {
    Accepted = "accepted",
    Expired = "expired",
    Pending = "pending"
}
export declare type OrganizationInviteUpdateInput = {
    /** The teams that the user has been invited to. */
    teamIds: Array<Scalars["String"]>;
};
export declare type OrganizationIpRestriction = {
    __typename?: "OrganizationIpRestriction";
    /** Optional restriction description. */
    description?: Maybe<Scalars["String"]>;
    /** Whether the restriction is enabled. */
    enabled: Scalars["Boolean"];
    /** IP range in CIDR format. */
    range: Scalars["String"];
    /** Restriction type. */
    type: Scalars["String"];
};
/** [INTERNAL] Organization IP restriction configuration. */
export declare type OrganizationIpRestrictionInput = {
    /** Optional restriction description. */
    description?: Maybe<Scalars["String"]>;
    /** Whether the restriction is enabled. */
    enabled: Scalars["Boolean"];
    /** IP range in CIDR format. */
    range: Scalars["String"];
    /** Restriction type. */
    type: Scalars["String"];
};
export declare type OrganizationMeta = {
    __typename?: "OrganizationMeta";
    /** Allowed authentication providers, empty array means all are allowed. */
    allowedAuthServices: Array<Scalars["String"]>;
    /** The region the organization is hosted in. */
    region: Scalars["String"];
};
export declare type OrganizationPayload = {
    __typename?: "OrganizationPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** The organization that was created or updated. */
    organization?: Maybe<Organization>;
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type OrganizationStartTrialInput = {
    /** The plan type to trial. */
    planType: Scalars["String"];
};
export declare type OrganizationStartTrialPayload = {
    __typename?: "OrganizationStartTrialPayload";
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type OrganizationUpdateInput = {
    /** [INTERNAL] Whether the organization has enabled the AI add-on. */
    aiAddonEnabled?: Maybe<Scalars["Boolean"]>;
    /** Whether member users are allowed to send invites. */
    allowMembersToInvite?: Maybe<Scalars["Boolean"]>;
    /** List of services that are allowed to be used for login. */
    allowedAuthServices?: Maybe<Array<Scalars["String"]>>;
    /** [INTERNAL] Configuration settings for the Customers feature. */
    customersConfiguration?: Maybe<Scalars["JSONObject"]>;
    /** [INTERNAL] Whether the organization is using customers. */
    customersEnabled?: Maybe<Scalars["Boolean"]>;
    /** Default schedule for how often feed summaries are generated. */
    defaultFeedSummarySchedule?: Maybe<FeedSummarySchedule>;
    /** Whether the organization has enabled the feed feature. */
    feedEnabled?: Maybe<Scalars["Boolean"]>;
    /** The month at which the fiscal year starts. */
    fiscalYearStartMonth?: Maybe<Scalars["Float"]>;
    /** How git branches are formatted. If null, default formatting will be used. */
    gitBranchFormat?: Maybe<Scalars["String"]>;
    /** Whether the Git integration linkback messages should be sent for private repositories. */
    gitLinkbackMessagesEnabled?: Maybe<Scalars["Boolean"]>;
    /** Whether the Git integration linkback messages should be sent for public repositories. */
    gitPublicLinkbackMessagesEnabled?: Maybe<Scalars["Boolean"]>;
    /** [ALPHA] The n-weekly frequency at which to prompt for initiative updates. */
    initiativeUpdateReminderFrequencyInWeeks?: Maybe<Scalars["Float"]>;
    /** [ALPHA] The day at which initiative updates are sent. */
    initiativeUpdateRemindersDay?: Maybe<Day>;
    /** [ALPHA] The hour at which initiative updates are sent. */
    initiativeUpdateRemindersHour?: Maybe<Scalars["Float"]>;
    /** IP restriction configurations controlling allowed access the workspace. */
    ipRestrictions?: Maybe<Array<OrganizationIpRestrictionInput>>;
    /** The logo of the organization. */
    logoUrl?: Maybe<Scalars["String"]>;
    /** The name of the organization. */
    name?: Maybe<Scalars["String"]>;
    /** Whether the organization has opted for having to approve all OAuth applications for install. */
    oauthAppReview?: Maybe<Scalars["Boolean"]>;
    /** The n-weekly frequency at which to prompt for project updates. */
    projectUpdateReminderFrequencyInWeeks?: Maybe<Scalars["Float"]>;
    /** The day at which project updates are sent. */
    projectUpdateRemindersDay?: Maybe<Day>;
    /** The hour at which project updates are sent. */
    projectUpdateRemindersHour?: Maybe<Scalars["Float"]>;
    /** Whether the organization has opted for reduced customer support attachment information. */
    reducedPersonalInformation?: Maybe<Scalars["Boolean"]>;
    /** Whether team creation is restricted to admins. */
    restrictTeamCreationToAdmins?: Maybe<Scalars["Boolean"]>;
    /** Whether the organization is using roadmap. */
    roadmapEnabled?: Maybe<Scalars["Boolean"]>;
    /** Internal. Whether SLAs have been enabled for the organization. */
    slaEnabled?: Maybe<Scalars["Boolean"]>;
    /** [ALPHA] Theme settings for the organization. */
    themeSettings?: Maybe<Scalars["JSONObject"]>;
    /** The URL key of the organization. */
    urlKey?: Maybe<Scalars["String"]>;
    /** [Internal] The list of working days. Sunday is 0, Monday is 1, etc. */
    workingDays?: Maybe<Array<Scalars["Float"]>>;
};
/** Customer owner sorting options. */
export declare type OwnerSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
export declare type PageInfo = {
    __typename?: "PageInfo";
    /** Cursor representing the last result in the paginated results. */
    endCursor?: Maybe<Scalars["String"]>;
    /** Indicates if there are more results when paginating forward. */
    hasNextPage: Scalars["Boolean"];
    /** Indicates if there are more results when paginating backward. */
    hasPreviousPage: Scalars["Boolean"];
    /** Cursor representing the first result in the paginated results. */
    startCursor?: Maybe<Scalars["String"]>;
};
export declare type PagerDutyInput = {
    /** The date when the PagerDuty API failed with an unauthorized error. */
    apiFailedWithUnauthorizedErrorAt?: Maybe<Scalars["DateTime"]>;
};
/** How to treat NULL values, whether they should appear first or last */
export declare enum PaginationNulls {
    First = "first",
    Last = "last"
}
/** By which field should the pagination order by */
export declare enum PaginationOrderBy {
    CreatedAt = "createdAt",
    UpdatedAt = "updatedAt"
}
/** Whether to sort in ascending or descending order */
export declare enum PaginationSortOrder {
    Ascending = "Ascending",
    Descending = "Descending"
}
/** The paid subscription of an organization. */
export declare type PaidSubscription = Node & {
    __typename?: "PaidSubscription";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The date the subscription is scheduled to be canceled, if any. */
    cancelAt?: Maybe<Scalars["DateTime"]>;
    /** The date the subscription was canceled, if any. */
    canceledAt?: Maybe<Scalars["DateTime"]>;
    /** The collection method for this subscription, either automatically charged or invoiced. */
    collectionMethod: Scalars["String"];
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The creator of the subscription. */
    creator?: Maybe<User>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The date the subscription will be billed next. */
    nextBillingAt?: Maybe<Scalars["DateTime"]>;
    /** The organization that the subscription is associated with. */
    organization: Organization;
    /** The subscription type of a pending change. Null if no change pending. */
    pendingChangeType?: Maybe<Scalars["String"]>;
    /** The number of seats in the subscription. */
    seats: Scalars["Float"];
    /** The maximum number of seats that will be billed in the subscription. */
    seatsMaximum?: Maybe<Scalars["Float"]>;
    /** The minimum number of seats that will be billed in the subscription. */
    seatsMinimum?: Maybe<Scalars["Float"]>;
    /** The subscription type. */
    type: Scalars["String"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type PartialNotificationChannelPreferencesInput = {
    /** Whether notifications are currently enabled for desktop. */
    desktop?: Maybe<Scalars["Boolean"]>;
    /** Whether notifications are currently enabled for email. */
    email?: Maybe<Scalars["Boolean"]>;
    /** Whether notifications are currently enabled for mobile. */
    mobile?: Maybe<Scalars["Boolean"]>;
    /** Whether notifications are currently enabled for Slack. */
    slack?: Maybe<Scalars["Boolean"]>;
};
export declare type PasskeyLoginStartResponse = {
    __typename?: "PasskeyLoginStartResponse";
    options: Scalars["JSONObject"];
    success: Scalars["Boolean"];
};
/** [Internal] A generic post. */
export declare type Post = Node & {
    __typename?: "Post";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The update content summarized for audio consumption. */
    audioSummary?: Maybe<Scalars["String"]>;
    /** The update content in markdown format. */
    body: Scalars["String"];
    /** [Internal] The content of the post as a Prosemirror document. */
    bodyData: Scalars["String"];
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who wrote the post. */
    creator?: Maybe<User>;
    /** The time the post was edited. */
    editedAt?: Maybe<Scalars["DateTime"]>;
    /** The log id of the ai response. */
    evalLogId?: Maybe<Scalars["String"]>;
    /** Schedule used to create a post summary. */
    feedSummaryScheduleAtCreate?: Maybe<FeedSummarySchedule>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** Emoji reaction summary, grouped by emoji type. */
    reactionData: Scalars["JSONObject"];
    /** The post's unique URL slug. */
    slugId: Scalars["String"];
    /** The team that the post is associated with. */
    team?: Maybe<Team>;
    /** The post's title. */
    title?: Maybe<Scalars["String"]>;
    /** A URL of the TTL (text-to-language) for the body. */
    ttlUrl?: Maybe<Scalars["String"]>;
    /** The type of the post. */
    type?: Maybe<PostType>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The user that the post is associated with. */
    user?: Maybe<User>;
    /** [Internal] The written update data used to compose the written post. */
    writtenSummaryData?: Maybe<Scalars["JSONObject"]>;
};
/** [Internal] A post related notification. */
export declare type PostNotification = Entity & Node & Notification & {
    __typename?: "PostNotification";
    /** The user that caused the notification. */
    actor?: Maybe<User>;
    /** [Internal] Notification actor initials if avatar is not available. */
    actorAvatarColor: Scalars["String"];
    /** [Internal] Notification avatar URL. */
    actorAvatarUrl?: Maybe<Scalars["String"]>;
    /** [Internal] Notification actor initials if avatar is not available. */
    actorInitials?: Maybe<Scalars["String"]>;
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The bot that caused the notification. */
    botActor?: Maybe<ActorBot>;
    /** Related comment ID. Null if the notification is not related to a comment. */
    commentId?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /**
     * The time at when an email reminder for this notification was sent to the user. Null, if no email
     *     reminder has been sent.
     */
    emailedAt?: Maybe<Scalars["DateTime"]>;
    /** The external user that caused the notification. */
    externalUserActor?: Maybe<ExternalUser>;
    /** [Internal] Notifications with the same grouping key will be grouped together in the UI. */
    groupingKey: Scalars["String"];
    /** [Internal] Priority of the notification with the same grouping key. Higher number means higher priority. If priority is the same, notifications should be sorted by `createdAt`. */
    groupingPriority: Scalars["Float"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** [Internal] Inbox URL for the notification. */
    inboxUrl: Scalars["String"];
    /** [Internal] If notification actor was Linear. */
    isLinearActor: Scalars["Boolean"];
    /** [Internal] Issue's status type for issue notifications. */
    issueStatusType?: Maybe<Scalars["String"]>;
    /** Related parent comment ID. Null if the notification is not related to a comment. */
    parentCommentId?: Maybe<Scalars["String"]>;
    /** Related post ID. */
    postId: Scalars["String"];
    /** [Internal] Project update health for new updates. */
    projectUpdateHealth?: Maybe<Scalars["String"]>;
    /** Name of the reaction emoji related to the notification. */
    reactionEmoji?: Maybe<Scalars["String"]>;
    /** The time at when the user marked the notification as read. Null, if the the user hasn't read the notification */
    readAt?: Maybe<Scalars["DateTime"]>;
    /** The time until a notification will be snoozed. After that it will appear in the inbox again. */
    snoozedUntilAt?: Maybe<Scalars["DateTime"]>;
    /** [Internal] Notification subtitle. */
    subtitle: Scalars["String"];
    /** [Internal] Notification title. */
    title: Scalars["String"];
    /** Notification type. */
    type: Scalars["String"];
    /** The time at which a notification was unsnoozed.. */
    unsnoozedAt?: Maybe<Scalars["DateTime"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** [Internal] URL to the target of the notification. */
    url: Scalars["String"];
    /** The user that received the notification. */
    user: User;
};
/** Type of Post */
export declare enum PostType {
    Summary = "summary",
    Update = "update"
}
/** Issue priority sorting options. */
export declare type PrioritySort = {
    /** Whether to consider no priority as the highest or lowest priority */
    noPriorityFirst?: Maybe<Scalars["Boolean"]>;
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
/** [Internal] The scope of product intelligence suggestion data for a team. */
export declare enum ProductIntelligenceScope {
    None = "none",
    Team = "team",
    TeamHierarchy = "teamHierarchy",
    Workspace = "workspace"
}
/** A project. */
export declare type Project = Node & {
    __typename?: "Project";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the project was automatically archived by the auto pruning process. */
    autoArchivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the project was moved into canceled state. */
    canceledAt?: Maybe<Scalars["DateTime"]>;
    /** The project's color. */
    color: Scalars["String"];
    /** Comments associated with the project overview. */
    comments: CommentConnection;
    /** The time at which the project was moved into completed state. */
    completedAt?: Maybe<Scalars["DateTime"]>;
    /** The number of completed issues in the project after each week. */
    completedIssueCountHistory: Array<Scalars["Float"]>;
    /** The number of completed estimation points after each week. */
    completedScopeHistory: Array<Scalars["Float"]>;
    /** The project's content in markdown format. */
    content?: Maybe<Scalars["String"]>;
    /** [Internal] The project's content as YJS state. */
    contentState?: Maybe<Scalars["String"]>;
    /** The project was created based on this issue. */
    convertedFromIssue?: Maybe<Issue>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who created the project. */
    creator?: Maybe<User>;
    /** [INTERNAL] The current progress of the project. */
    currentProgress: Scalars["JSONObject"];
    /** The project's description. */
    description: Scalars["String"];
    /** The content of the project description. */
    documentContent?: Maybe<DocumentContent>;
    /** Documents associated with the project. */
    documents: DocumentConnection;
    /** External links associated with the project. */
    externalLinks: EntityExternalLinkConnection;
    /** The user's favorite associated with this project. */
    favorite?: Maybe<Favorite>;
    /** The resolution of the reminder frequency. */
    frequencyResolution: FrequencyResolutionType;
    /** The health of the project. */
    health?: Maybe<ProjectUpdateHealthType>;
    /** The time at which the project health was updated. */
    healthUpdatedAt?: Maybe<Scalars["DateTime"]>;
    /** History entries associated with the project. */
    history: ProjectHistoryConnection;
    /** The icon of the project. */
    icon?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The number of in progress estimation points after each week. */
    inProgressScopeHistory: Array<Scalars["Float"]>;
    /** Initiatives that this project belongs to. */
    initiatives: InitiativeConnection;
    /** Settings for all integrations associated with that project. */
    integrationsSettings?: Maybe<IntegrationsSettings>;
    /** Inverse relations associated with this project. */
    inverseRelations: ProjectRelationConnection;
    /** The total number of issues in the project after each week. */
    issueCountHistory: Array<Scalars["Float"]>;
    /** Issues associated with the project. */
    issues: IssueConnection;
    /** Id of the labels associated with this project. */
    labelIds: Array<Scalars["String"]>;
    /** [Internal] Labels associated with this project. */
    labels: ProjectLabelConnection;
    /** The last template that was applied to this project. */
    lastAppliedTemplate?: Maybe<Template>;
    /** The last project update posted for this project. */
    lastUpdate?: Maybe<ProjectUpdate>;
    /** The project lead. */
    lead?: Maybe<User>;
    /** Users that are members of the project. */
    members: UserConnection;
    /** The project's name. */
    name: Scalars["String"];
    /** Customer needs associated with the project. */
    needs: CustomerNeedConnection;
    /** The priority of the project. 0 = No priority, 1 = Urgent, 2 = High, 3 = Normal, 4 = Low. */
    priority: Scalars["Int"];
    /** The priority of the project as a label. */
    priorityLabel: Scalars["String"];
    /** The sort order for the project within the organization, when ordered by priority. */
    prioritySortOrder: Scalars["Float"];
    /** The overall progress of the project. This is the (completed estimate points + 0.25 * in progress estimate points) / total estimate points. */
    progress: Scalars["Float"];
    /** [INTERNAL] The progress history of the project. */
    progressHistory: Scalars["JSONObject"];
    /** Milestones associated with the project. */
    projectMilestones: ProjectMilestoneConnection;
    /** The time until which project update reminders are paused. */
    projectUpdateRemindersPausedUntilAt?: Maybe<Scalars["DateTime"]>;
    /** Project updates associated with the project. */
    projectUpdates: ProjectUpdateConnection;
    /** Relations associated with this project. */
    relations: ProjectRelationConnection;
    /** The overall scope (total estimate points) of the project. */
    scope: Scalars["Float"];
    /** The total number of estimation points after each week. */
    scopeHistory: Array<Scalars["Float"]>;
    /**
     * Whether to send new issue comment notifications to Slack.
     * @deprecated No longer in use
     */
    slackIssueComments: Scalars["Boolean"];
    /**
     * Whether to send new issue status updates to Slack.
     * @deprecated No longer is use
     */
    slackIssueStatuses: Scalars["Boolean"];
    /**
     * Whether to send new issue notifications to Slack.
     * @deprecated No longer in use
     */
    slackNewIssue: Scalars["Boolean"];
    /** The project's unique URL slug. */
    slugId: Scalars["String"];
    /** The sort order for the project within the organization. */
    sortOrder: Scalars["Float"];
    /** The estimated start date of the project. */
    startDate?: Maybe<Scalars["TimelessDate"]>;
    /** The resolution of the project's start date. */
    startDateResolution?: Maybe<DateResolutionType>;
    /** The time at which the project was moved into started state. */
    startedAt?: Maybe<Scalars["DateTime"]>;
    /**
     * [DEPRECATED] The type of the state.
     * @deprecated Use project.status instead
     */
    state: Scalars["String"];
    /** The status that the project is associated with. */
    status: ProjectStatus;
    /** The estimated completion date of the project. */
    targetDate?: Maybe<Scalars["TimelessDate"]>;
    /** The resolution of the project's estimated completion date. */
    targetDateResolution?: Maybe<DateResolutionType>;
    /** Teams associated with this project. */
    teams: TeamConnection;
    /** A flag that indicates whether the project is in the trash bin. */
    trashed?: Maybe<Scalars["Boolean"]>;
    /** The frequency at which to prompt for updates. When not set, reminders are inherited from workspace. */
    updateReminderFrequency?: Maybe<Scalars["Float"]>;
    /** The n-weekly frequency at which to prompt for updates. When not set, reminders are inherited from workspace. */
    updateReminderFrequencyInWeeks?: Maybe<Scalars["Float"]>;
    /** The day at which to prompt for updates. */
    updateRemindersDay?: Maybe<Day>;
    /** The hour at which to prompt for updates. */
    updateRemindersHour?: Maybe<Scalars["Float"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** Project URL. */
    url: Scalars["String"];
};
/** A project. */
export declare type ProjectCommentsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CommentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A project. */
export declare type ProjectDocumentsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<DocumentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A project. */
export declare type ProjectExternalLinksArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A project. */
export declare type ProjectHistoryArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A project. */
export declare type ProjectInitiativesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A project. */
export declare type ProjectInverseRelationsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A project. */
export declare type ProjectIssuesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A project. */
export declare type ProjectLabelsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectLabelFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A project. */
export declare type ProjectMembersArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<UserFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeDisabled?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A project. */
export declare type ProjectNeedsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CustomerNeedFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A project. */
export declare type ProjectProjectMilestonesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectMilestoneFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A project. */
export declare type ProjectProjectUpdatesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A project. */
export declare type ProjectRelationsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A project. */
export declare type ProjectTeamsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<TeamFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A generic payload return from entity archive mutations. */
export declare type ProjectArchivePayload = ArchivePayload & {
    __typename?: "ProjectArchivePayload";
    /** The archived/unarchived entity. Null if entity was deleted. */
    entity?: Maybe<Project>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** [INTERNAL] Project attachment */
export declare type ProjectAttachment = Node & {
    __typename?: "ProjectAttachment";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The creator of the attachment. */
    creator?: Maybe<User>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** Custom metadata related to the attachment. */
    metadata: Scalars["JSONObject"];
    /** Information about the external source which created the attachment. */
    source?: Maybe<Scalars["JSONObject"]>;
    /** An accessor helper to source.type, defines the source type of the attachment. */
    sourceType?: Maybe<Scalars["String"]>;
    /** Optional subtitle of the attachment */
    subtitle?: Maybe<Scalars["String"]>;
    /** Title of the attachment. */
    title: Scalars["String"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** URL of the attachment. */
    url: Scalars["String"];
};
/** Project filtering options. */
export declare type ProjectCollectionFilter = {
    /** Filters that the project's team must satisfy. */
    accessibleTeams?: Maybe<TeamCollectionFilter>;
    /** Compound filters, all of which need to be matched by the project. */
    and?: Maybe<Array<ProjectCollectionFilter>>;
    /** Comparator for the project cancelation date. */
    canceledAt?: Maybe<NullableDateComparator>;
    /** Comparator for the project completion date. */
    completedAt?: Maybe<NullableDateComparator>;
    /** Filters that the project's completed milestones must satisfy. */
    completedProjectMilestones?: Maybe<ProjectMilestoneCollectionFilter>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the projects creator must satisfy. */
    creator?: Maybe<UserFilter>;
    /** Count of customers */
    customerCount?: Maybe<NumberComparator>;
    /** Filters that needs to be matched by all projects. */
    every?: Maybe<ProjectFilter>;
    /** Comparator for filtering projects which are blocked. */
    hasBlockedByRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for filtering projects which are blocking. */
    hasBlockingRelations?: Maybe<RelationExistsComparator>;
    /** [Deprecated] Comparator for filtering projects which this is depended on by. */
    hasDependedOnByRelations?: Maybe<RelationExistsComparator>;
    /** [Deprecated]Comparator for filtering projects which this depends on. */
    hasDependsOnRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for filtering projects with relations. */
    hasRelatedRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for filtering projects with violated dependencies. */
    hasViolatedRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for the project health: onTrack, atRisk, offTrack */
    health?: Maybe<StringComparator>;
    /** Comparator for the project health (with age): onTrack, atRisk, offTrack, outdated, noUpdate */
    healthWithAge?: Maybe<StringComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Filters that the projects initiatives must satisfy. */
    initiatives?: Maybe<InitiativeCollectionFilter>;
    /** Filters that the projects issues must satisfy. */
    issues?: Maybe<IssueCollectionFilter>;
    /** [Internal] Filters that project labels must satisfy. */
    labels?: Maybe<ProjectLabelCollectionFilter>;
    /** Filters that the last applied template must satisfy. */
    lastAppliedTemplate?: Maybe<NullableTemplateFilter>;
    /** Filters that the projects lead must satisfy. */
    lead?: Maybe<NullableUserFilter>;
    /** Comparator for the collection length. */
    length?: Maybe<NumberComparator>;
    /** Filters that the projects members must satisfy. */
    members?: Maybe<UserCollectionFilter>;
    /** Comparator for the project name. */
    name?: Maybe<StringComparator>;
    /** Filters that the project's customer needs must satisfy. */
    needs?: Maybe<CustomerNeedCollectionFilter>;
    /** Filters that the project's next milestone must satisfy. */
    nextProjectMilestone?: Maybe<ProjectMilestoneFilter>;
    /** Compound filters, one of which need to be matched by the project. */
    or?: Maybe<Array<ProjectCollectionFilter>>;
    /** Comparator for the projects priority. */
    priority?: Maybe<NullableNumberComparator>;
    /** Filters that the project's milestones must satisfy. */
    projectMilestones?: Maybe<ProjectMilestoneCollectionFilter>;
    /** Comparator for the project updates. */
    projectUpdates?: Maybe<ProjectUpdatesCollectionFilter>;
    /** Filters that the projects roadmaps must satisfy. */
    roadmaps?: Maybe<RoadmapCollectionFilter>;
    /** [Internal] Comparator for the project's content. */
    searchableContent?: Maybe<ContentComparator>;
    /** Comparator for the project slug ID. */
    slugId?: Maybe<StringComparator>;
    /** Filters that needs to be matched by some projects. */
    some?: Maybe<ProjectFilter>;
    /** Comparator for the project start date. */
    startDate?: Maybe<NullableDateComparator>;
    /** [DEPRECATED] Comparator for the project state. */
    state?: Maybe<StringComparator>;
    /** Filters that the project's status must satisfy. */
    status?: Maybe<ProjectStatusFilter>;
    /** Comparator for the project target date. */
    targetDate?: Maybe<NullableDateComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type ProjectConnection = {
    __typename?: "ProjectConnection";
    edges: Array<ProjectEdge>;
    nodes: Array<Project>;
    pageInfo: PageInfo;
};
export declare type ProjectCreateInput = {
    /** The color of the project. */
    color?: Maybe<Scalars["String"]>;
    /** The project content as markdown. */
    content?: Maybe<Scalars["String"]>;
    /** The ID of the issue from which that project is created. */
    convertedFromIssueId?: Maybe<Scalars["String"]>;
    /** The description for the project. */
    description?: Maybe<Scalars["String"]>;
    /** The icon of the project. */
    icon?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** [Internal]The identifiers of the project labels associated with this project. */
    labelIds?: Maybe<Array<Scalars["String"]>>;
    /** The ID of the last template applied to the project. */
    lastAppliedTemplateId?: Maybe<Scalars["String"]>;
    /** The identifier of the project lead. */
    leadId?: Maybe<Scalars["String"]>;
    /** The identifiers of the members of this project. */
    memberIds?: Maybe<Array<Scalars["String"]>>;
    /** The name of the project. */
    name: Scalars["String"];
    /** The priority of the project. 0 = No priority, 1 = Urgent, 2 = High, 3 = Normal, 4 = Low. */
    priority?: Maybe<Scalars["Int"]>;
    /** The sort order for the project within shared views, when ordered by priority. */
    prioritySortOrder?: Maybe<Scalars["Float"]>;
    /** The sort order for the project within shared views. */
    sortOrder?: Maybe<Scalars["Float"]>;
    /** The planned start date of the project. */
    startDate?: Maybe<Scalars["TimelessDate"]>;
    /** The resolution of the project's start date. */
    startDateResolution?: Maybe<DateResolutionType>;
    /** The ID of the project status. */
    statusId?: Maybe<Scalars["String"]>;
    /** The planned target date of the project. */
    targetDate?: Maybe<Scalars["TimelessDate"]>;
    /** The resolution of the project's estimated completion date. */
    targetDateResolution?: Maybe<DateResolutionType>;
    /** The identifiers of the teams this project is associated with. */
    teamIds: Array<Scalars["String"]>;
};
export declare type ProjectEdge = {
    __typename?: "ProjectEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: Project;
};
/** Project filtering options. */
export declare type ProjectFilter = {
    /** Filters that the project's team must satisfy. */
    accessibleTeams?: Maybe<TeamCollectionFilter>;
    /** Compound filters, all of which need to be matched by the project. */
    and?: Maybe<Array<ProjectFilter>>;
    /** Comparator for the project cancelation date. */
    canceledAt?: Maybe<NullableDateComparator>;
    /** Comparator for the project completion date. */
    completedAt?: Maybe<NullableDateComparator>;
    /** Filters that the project's completed milestones must satisfy. */
    completedProjectMilestones?: Maybe<ProjectMilestoneCollectionFilter>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the projects creator must satisfy. */
    creator?: Maybe<UserFilter>;
    /** Count of customers */
    customerCount?: Maybe<NumberComparator>;
    /** Comparator for filtering projects which are blocked. */
    hasBlockedByRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for filtering projects which are blocking. */
    hasBlockingRelations?: Maybe<RelationExistsComparator>;
    /** [Deprecated] Comparator for filtering projects which this is depended on by. */
    hasDependedOnByRelations?: Maybe<RelationExistsComparator>;
    /** [Deprecated]Comparator for filtering projects which this depends on. */
    hasDependsOnRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for filtering projects with relations. */
    hasRelatedRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for filtering projects with violated dependencies. */
    hasViolatedRelations?: Maybe<RelationExistsComparator>;
    /** Comparator for the project health: onTrack, atRisk, offTrack */
    health?: Maybe<StringComparator>;
    /** Comparator for the project health (with age): onTrack, atRisk, offTrack, outdated, noUpdate */
    healthWithAge?: Maybe<StringComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Filters that the projects initiatives must satisfy. */
    initiatives?: Maybe<InitiativeCollectionFilter>;
    /** Filters that the projects issues must satisfy. */
    issues?: Maybe<IssueCollectionFilter>;
    /** [Internal] Filters that project labels must satisfy. */
    labels?: Maybe<ProjectLabelCollectionFilter>;
    /** Filters that the last applied template must satisfy. */
    lastAppliedTemplate?: Maybe<NullableTemplateFilter>;
    /** Filters that the projects lead must satisfy. */
    lead?: Maybe<NullableUserFilter>;
    /** Filters that the projects members must satisfy. */
    members?: Maybe<UserCollectionFilter>;
    /** Comparator for the project name. */
    name?: Maybe<StringComparator>;
    /** Filters that the project's customer needs must satisfy. */
    needs?: Maybe<CustomerNeedCollectionFilter>;
    /** Filters that the project's next milestone must satisfy. */
    nextProjectMilestone?: Maybe<ProjectMilestoneFilter>;
    /** Compound filters, one of which need to be matched by the project. */
    or?: Maybe<Array<ProjectFilter>>;
    /** Comparator for the projects priority. */
    priority?: Maybe<NullableNumberComparator>;
    /** Filters that the project's milestones must satisfy. */
    projectMilestones?: Maybe<ProjectMilestoneCollectionFilter>;
    /** Comparator for the project updates. */
    projectUpdates?: Maybe<ProjectUpdatesCollectionFilter>;
    /** Filters that the projects roadmaps must satisfy. */
    roadmaps?: Maybe<RoadmapCollectionFilter>;
    /** [Internal] Comparator for the project's content. */
    searchableContent?: Maybe<ContentComparator>;
    /** Comparator for the project slug ID. */
    slugId?: Maybe<StringComparator>;
    /** Comparator for the project start date. */
    startDate?: Maybe<NullableDateComparator>;
    /** [DEPRECATED] Comparator for the project state. */
    state?: Maybe<StringComparator>;
    /** Filters that the project's status must satisfy. */
    status?: Maybe<ProjectStatusFilter>;
    /** Comparator for the project target date. */
    targetDate?: Maybe<NullableDateComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type ProjectFilterSuggestionPayload = {
    __typename?: "ProjectFilterSuggestionPayload";
    /** The json filter that is suggested. */
    filter?: Maybe<Scalars["JSONObject"]>;
    /** The log id of the prompt, that created this filter. */
    logId?: Maybe<Scalars["String"]>;
};
/** An history associated with a project. */
export declare type ProjectHistory = Node & {
    __typename?: "ProjectHistory";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The events that happened while recording that history. */
    entries: Scalars["JSONObject"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The project that the history is associated with. */
    project: Project;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type ProjectHistoryConnection = {
    __typename?: "ProjectHistoryConnection";
    edges: Array<ProjectHistoryEdge>;
    nodes: Array<ProjectHistory>;
    pageInfo: PageInfo;
};
export declare type ProjectHistoryEdge = {
    __typename?: "ProjectHistoryEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: ProjectHistory;
};
/** [Internal] Labels that can be associated with projects. */
export declare type ProjectLabel = Node & {
    __typename?: "ProjectLabel";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The label's color as a HEX string. */
    color: Scalars["String"];
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who created the label. */
    creator?: Maybe<User>;
    /** The label's description. */
    description?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** Whether the label is a group. */
    isGroup: Scalars["Boolean"];
    /** The label's name. */
    name: Scalars["String"];
    organization: Organization;
    /** The parent label. */
    parent?: Maybe<ProjectLabel>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
/** Project label filtering options. */
export declare type ProjectLabelCollectionFilter = {
    /** Compound filters, all of which need to be matched by the label. */
    and?: Maybe<Array<ProjectLabelCollectionFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the project labels creator must satisfy. */
    creator?: Maybe<NullableUserFilter>;
    /** Filters that needs to be matched by all project labels. */
    every?: Maybe<ProjectLabelFilter>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for whether the label is a group label. */
    isGroup?: Maybe<BooleanComparator>;
    /** Comparator for the collection length. */
    length?: Maybe<NumberComparator>;
    /** Comparator for the name. */
    name?: Maybe<StringComparator>;
    /** Compound filters, one of which need to be matched by the label. */
    or?: Maybe<Array<ProjectLabelCollectionFilter>>;
    /** Filters that the project label's parent label must satisfy. */
    parent?: Maybe<ProjectLabelFilter>;
    /** Filters that needs to be matched by some project labels. */
    some?: Maybe<ProjectLabelCollectionFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type ProjectLabelConnection = {
    __typename?: "ProjectLabelConnection";
    edges: Array<ProjectLabelEdge>;
    nodes: Array<ProjectLabel>;
    pageInfo: PageInfo;
};
export declare type ProjectLabelEdge = {
    __typename?: "ProjectLabelEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: ProjectLabel;
};
/** [Internal] Project label filtering options. */
export declare type ProjectLabelFilter = {
    /** Compound filters, all of which need to be matched by the label. */
    and?: Maybe<Array<ProjectLabelFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the project labels creator must satisfy. */
    creator?: Maybe<NullableUserFilter>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for whether the label is a group label. */
    isGroup?: Maybe<BooleanComparator>;
    /** Comparator for the name. */
    name?: Maybe<StringComparator>;
    /** Compound filters, one of which need to be matched by the label. */
    or?: Maybe<Array<ProjectLabelFilter>>;
    /** Filters that the project label's parent label must satisfy. */
    parent?: Maybe<ProjectLabelFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** A milestone for a project. */
export declare type ProjectMilestone = Node & {
    __typename?: "ProjectMilestone";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** [Internal] The current progress of the project milestone. */
    currentProgress: Scalars["JSONObject"];
    /** The project milestone's description in markdown format. */
    description?: Maybe<Scalars["String"]>;
    /** [Internal] The project milestone's description as YJS state. */
    descriptionState?: Maybe<Scalars["String"]>;
    /** The content of the project milestone description. */
    documentContent?: Maybe<DocumentContent>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** Issues associated with the project milestone. */
    issues: IssueConnection;
    /** The name of the project milestone. */
    name: Scalars["String"];
    /** The progress % of the project milestone. */
    progress: Scalars["Float"];
    /** [Internal] The progress history of the project milestone. */
    progressHistory: Scalars["JSONObject"];
    /** The project of the milestone. */
    project: Project;
    /** The order of the milestone in relation to other milestones within a project. */
    sortOrder: Scalars["Float"];
    /** The status of the project milestone. */
    status: ProjectMilestoneStatus;
    /** The planned completion date of the milestone. */
    targetDate?: Maybe<Scalars["TimelessDate"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
/** A milestone for a project. */
export declare type ProjectMilestoneIssuesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** Milestone collection filtering options. */
export declare type ProjectMilestoneCollectionFilter = {
    /** Compound filters, all of which need to be matched by the milestone. */
    and?: Maybe<Array<ProjectMilestoneCollectionFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that needs to be matched by all milestones. */
    every?: Maybe<ProjectMilestoneFilter>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the collection length. */
    length?: Maybe<NumberComparator>;
    /** Comparator for the project milestone name. */
    name?: Maybe<NullableStringComparator>;
    /** Compound filters, one of which need to be matched by the milestone. */
    or?: Maybe<Array<ProjectMilestoneCollectionFilter>>;
    /** Filters that needs to be matched by some milestones. */
    some?: Maybe<ProjectMilestoneFilter>;
    /** Comparator for the project milestone target date. */
    targetDate?: Maybe<NullableDateComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type ProjectMilestoneConnection = {
    __typename?: "ProjectMilestoneConnection";
    edges: Array<ProjectMilestoneEdge>;
    nodes: Array<ProjectMilestone>;
    pageInfo: PageInfo;
};
export declare type ProjectMilestoneCreateInput = {
    /** The description of the project milestone in markdown format. */
    description?: Maybe<Scalars["String"]>;
    /** [Internal] The description of the project milestone as a Prosemirror document. */
    descriptionData?: Maybe<Scalars["JSONObject"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The name of the project milestone. */
    name: Scalars["String"];
    /** Related project for the project milestone. */
    projectId: Scalars["String"];
    /** The sort order for the project milestone within a project. */
    sortOrder?: Maybe<Scalars["Float"]>;
    /** The planned target date of the project milestone. */
    targetDate?: Maybe<Scalars["TimelessDate"]>;
};
export declare type ProjectMilestoneEdge = {
    __typename?: "ProjectMilestoneEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: ProjectMilestone;
};
/** Project milestone filtering options. */
export declare type ProjectMilestoneFilter = {
    /** Compound filters, all of which need to be matched by the project milestone. */
    and?: Maybe<Array<ProjectMilestoneFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the project milestone name. */
    name?: Maybe<NullableStringComparator>;
    /** Compound filters, one of which need to be matched by the project milestone. */
    or?: Maybe<Array<ProjectMilestoneFilter>>;
    /** Comparator for the project milestone target date. */
    targetDate?: Maybe<NullableDateComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type ProjectMilestoneMoveInput = {
    /** Whether to add each milestone issue's team to the project. This is needed when there is a mismatch between a project's teams and the milestone's issues' teams. Either this or newIssueTeamId is required in that situation to resolve constraints. */
    addIssueTeamToProject?: Maybe<Scalars["Boolean"]>;
    /** The team id to move the attached issues to. This is needed when there is a mismatch between a project's teams and the milestone's issues' teams. Either this or addIssueTeamToProject is required in that situation to resolve constraints. */
    newIssueTeamId?: Maybe<Scalars["String"]>;
    /** The identifier of the project to move the milestone to. */
    projectId: Scalars["String"];
    /** A list of issue id to team ids, used for undoing a previous milestone move where the specified issues were moved from the specified teams. */
    undoIssueTeamIds?: Maybe<Array<ProjectMilestoneMoveIssueToTeamInput>>;
    /** A mapping of project id to a previous set of team ids, used for undoing a previous milestone move where the specified teams were added to the project. */
    undoProjectTeamIds?: Maybe<ProjectMilestoneMoveProjectTeamsInput>;
};
export declare type ProjectMilestoneMoveIssueToTeam = {
    __typename?: "ProjectMilestoneMoveIssueToTeam";
    /** The issue id in this relationship, you can use * as wildcard if all issues are being moved to the same team */
    issueId: Scalars["String"];
    /** The team id in this relationship */
    teamId: Scalars["String"];
};
/** [Internal] Used for ProjectMilestoneMoveInput to describe a mapping between an issue and its team. */
export declare type ProjectMilestoneMoveIssueToTeamInput = {
    /** The issue id in this relationship, you can use * as wildcard if all issues are being moved to the same team */
    issueId: Scalars["String"];
    /** The team id in this relationship */
    teamId: Scalars["String"];
};
export declare type ProjectMilestoneMovePayload = {
    __typename?: "ProjectMilestoneMovePayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** A snapshot of the issues that were moved to new teams, if the user selected to do it, containing an array of mappings between an issue and its previous team. Store on the client to use for undoing a previous milestone move. */
    previousIssueTeamIds?: Maybe<Array<ProjectMilestoneMoveIssueToTeam>>;
    /** A snapshot of the project that had new teams added to it, if the user selected to do it, containing an array of mappings between a project and its previous teams. Store on the client to use for undoing a previous milestone move. */
    previousProjectTeamIds?: Maybe<ProjectMilestoneMoveProjectTeams>;
    /** The project milestone that was created or updated. */
    projectMilestone: ProjectMilestone;
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type ProjectMilestoneMoveProjectTeams = {
    __typename?: "ProjectMilestoneMoveProjectTeams";
    /** The project id */
    projectId: Scalars["String"];
    /** The team ids for the project */
    teamIds: Array<Scalars["String"]>;
};
/** [Internal] Used for ProjectMilestoneMoveInput to describe a snapshot of a project and its team ids */
export declare type ProjectMilestoneMoveProjectTeamsInput = {
    /** The project id */
    projectId: Scalars["String"];
    /** The team ids for the project */
    teamIds: Array<Scalars["String"]>;
};
export declare type ProjectMilestonePayload = {
    __typename?: "ProjectMilestonePayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** The project milestone that was created or updated. */
    projectMilestone: ProjectMilestone;
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** The status of a project milestone. */
export declare enum ProjectMilestoneStatus {
    Done = "done",
    Next = "next",
    Overdue = "overdue",
    Unstarted = "unstarted"
}
export declare type ProjectMilestoneUpdateInput = {
    /** The description of the project milestone in markdown format. */
    description?: Maybe<Scalars["String"]>;
    /** [Internal] The description of the project milestone as a Prosemirror document. */
    descriptionData?: Maybe<Scalars["JSONObject"]>;
    /** The name of the project milestone. */
    name?: Maybe<Scalars["String"]>;
    /** Related project for the project milestone. */
    projectId?: Maybe<Scalars["String"]>;
    /** The sort order for the project milestone within a project. */
    sortOrder?: Maybe<Scalars["Float"]>;
    /** The planned target date of the project milestone. */
    targetDate?: Maybe<Scalars["TimelessDate"]>;
};
/** A project related notification. */
export declare type ProjectNotification = Entity & Node & Notification & {
    __typename?: "ProjectNotification";
    /** The user that caused the notification. */
    actor?: Maybe<User>;
    /** [Internal] Notification actor initials if avatar is not available. */
    actorAvatarColor: Scalars["String"];
    /** [Internal] Notification avatar URL. */
    actorAvatarUrl?: Maybe<Scalars["String"]>;
    /** [Internal] Notification actor initials if avatar is not available. */
    actorInitials?: Maybe<Scalars["String"]>;
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The bot that caused the notification. */
    botActor?: Maybe<ActorBot>;
    /** The comment related to the notification. */
    comment?: Maybe<Comment>;
    /** Related comment ID. Null if the notification is not related to a comment. */
    commentId?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The document related to the notification. */
    document?: Maybe<Document>;
    /**
     * The time at when an email reminder for this notification was sent to the user. Null, if no email
     *     reminder has been sent.
     */
    emailedAt?: Maybe<Scalars["DateTime"]>;
    /** The external user that caused the notification. */
    externalUserActor?: Maybe<ExternalUser>;
    /** [Internal] Notifications with the same grouping key will be grouped together in the UI. */
    groupingKey: Scalars["String"];
    /** [Internal] Priority of the notification with the same grouping key. Higher number means higher priority. If priority is the same, notifications should be sorted by `createdAt`. */
    groupingPriority: Scalars["Float"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** [Internal] Inbox URL for the notification. */
    inboxUrl: Scalars["String"];
    /** The initiative related to the notification. */
    initiative?: Maybe<Initiative>;
    /** The initiative update related to the notification. */
    initiativeUpdate?: Maybe<InitiativeUpdate>;
    /** [Internal] If notification actor was Linear. */
    isLinearActor: Scalars["Boolean"];
    /** [Internal] Issue's status type for issue notifications. */
    issueStatusType?: Maybe<Scalars["String"]>;
    /** The parent comment related to the notification, if a notification is a reply comment notification. */
    parentComment?: Maybe<Comment>;
    /** Related parent comment ID. Null if the notification is not related to a comment. */
    parentCommentId?: Maybe<Scalars["String"]>;
    /** The project related to the notification. */
    project: Project;
    /** Related project ID. */
    projectId: Scalars["String"];
    /** Related project milestone ID. */
    projectMilestoneId?: Maybe<Scalars["String"]>;
    /** The project update related to the notification. */
    projectUpdate?: Maybe<ProjectUpdate>;
    /** [Internal] Project update health for new updates. */
    projectUpdateHealth?: Maybe<Scalars["String"]>;
    /** Related project update ID. */
    projectUpdateId?: Maybe<Scalars["String"]>;
    /** Name of the reaction emoji related to the notification. */
    reactionEmoji?: Maybe<Scalars["String"]>;
    /** The time at when the user marked the notification as read. Null, if the the user hasn't read the notification */
    readAt?: Maybe<Scalars["DateTime"]>;
    /** The time until a notification will be snoozed. After that it will appear in the inbox again. */
    snoozedUntilAt?: Maybe<Scalars["DateTime"]>;
    /** [Internal] Notification subtitle. */
    subtitle: Scalars["String"];
    /** [Internal] Notification title. */
    title: Scalars["String"];
    /** Notification type. */
    type: Scalars["String"];
    /** The time at which a notification was unsnoozed.. */
    unsnoozedAt?: Maybe<Scalars["DateTime"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** [Internal] URL to the target of the notification. */
    url: Scalars["String"];
    /** The user that received the notification. */
    user: User;
};
/** A project notification subscription. */
export declare type ProjectNotificationSubscription = Entity & Node & NotificationSubscription & {
    __typename?: "ProjectNotificationSubscription";
    /** Whether the subscription is active or not. */
    active: Scalars["Boolean"];
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The type of view to which the notification subscription context is associated with. */
    contextViewType?: Maybe<ContextViewType>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The contextual custom view associated with the notification subscription. */
    customView?: Maybe<CustomView>;
    /** The customer associated with the notification subscription. */
    customer?: Maybe<Customer>;
    /** The contextual cycle view associated with the notification subscription. */
    cycle?: Maybe<Cycle>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The contextual initiative view associated with the notification subscription. */
    initiative?: Maybe<Initiative>;
    /** The contextual label view associated with the notification subscription. */
    label?: Maybe<IssueLabel>;
    /** The type of subscription. */
    notificationSubscriptionTypes: Array<Scalars["String"]>;
    /** The project subscribed to. */
    project: Project;
    /** The user that subscribed to receive notifications. */
    subscriber: User;
    /** The team associated with the notification subscription. */
    team?: Maybe<Team>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The user view associated with the notification subscription. */
    user?: Maybe<User>;
    /** The type of user view to which the notification subscription context is associated with. */
    userContextViewType?: Maybe<UserContextViewType>;
};
export declare type ProjectPayload = {
    __typename?: "ProjectPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** The project that was created or updated. */
    project?: Maybe<Project>;
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** A relation between two projects. */
export declare type ProjectRelation = Node & {
    __typename?: "ProjectRelation";
    /** The type of anchor on the project end of the relation. */
    anchorType: Scalars["String"];
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The project whose relationship is being described. */
    project: Project;
    /** The milestone within the project whose relationship is being described. */
    projectMilestone?: Maybe<ProjectMilestone>;
    /** The type of anchor on the relatedProject end of the relation. */
    relatedAnchorType: Scalars["String"];
    /** The related project. */
    relatedProject: Project;
    /** The milestone within the related project whose relationship is being described. */
    relatedProjectMilestone?: Maybe<ProjectMilestone>;
    /** The relationship of the project with the related project. */
    type: Scalars["String"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The last user who created or modified the relation. */
    user?: Maybe<User>;
};
export declare type ProjectRelationConnection = {
    __typename?: "ProjectRelationConnection";
    edges: Array<ProjectRelationEdge>;
    nodes: Array<ProjectRelation>;
    pageInfo: PageInfo;
};
export declare type ProjectRelationCreateInput = {
    /** The type of the anchor for the project. */
    anchorType: Scalars["String"];
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The identifier of the project that is related to another project. */
    projectId: Scalars["String"];
    /** The identifier of the project milestone. */
    projectMilestoneId?: Maybe<Scalars["String"]>;
    /** The type of the anchor for the related project. */
    relatedAnchorType: Scalars["String"];
    /** The identifier of the related project. */
    relatedProjectId: Scalars["String"];
    /** The identifier of the related project milestone. */
    relatedProjectMilestoneId?: Maybe<Scalars["String"]>;
    /** The type of relation of the project to the related project. */
    type: Scalars["String"];
};
export declare type ProjectRelationEdge = {
    __typename?: "ProjectRelationEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: ProjectRelation;
};
export declare type ProjectRelationPayload = {
    __typename?: "ProjectRelationPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** The project relation that was created or updated. */
    projectRelation: ProjectRelation;
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type ProjectRelationUpdateInput = {
    /** The type of the anchor for the project. */
    anchorType?: Maybe<Scalars["String"]>;
    /** The identifier of the project that is related to another project. */
    projectId?: Maybe<Scalars["String"]>;
    /** The identifier of the project milestone. */
    projectMilestoneId?: Maybe<Scalars["String"]>;
    /** The type of the anchor for the related project. */
    relatedAnchorType?: Maybe<Scalars["String"]>;
    /** The identifier of the related project. */
    relatedProjectId?: Maybe<Scalars["String"]>;
    /** The identifier of the related project milestone. */
    relatedProjectMilestoneId?: Maybe<Scalars["String"]>;
    /** The type of relation of the project to the related project. */
    type?: Maybe<Scalars["String"]>;
};
export declare type ProjectSearchPayload = {
    __typename?: "ProjectSearchPayload";
    /** Archived entities matching the search term along with all their dependencies. */
    archivePayload: ArchiveResponse;
    edges: Array<ProjectSearchResultEdge>;
    nodes: Array<ProjectSearchResult>;
    pageInfo: PageInfo;
    /** Total number of results for query without filters applied. */
    totalCount: Scalars["Float"];
};
export declare type ProjectSearchResult = Node & {
    __typename?: "ProjectSearchResult";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the project was automatically archived by the auto pruning process. */
    autoArchivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the project was moved into canceled state. */
    canceledAt?: Maybe<Scalars["DateTime"]>;
    /** The project's color. */
    color: Scalars["String"];
    /** Comments associated with the project overview. */
    comments: CommentConnection;
    /** The time at which the project was moved into completed state. */
    completedAt?: Maybe<Scalars["DateTime"]>;
    /** The number of completed issues in the project after each week. */
    completedIssueCountHistory: Array<Scalars["Float"]>;
    /** The number of completed estimation points after each week. */
    completedScopeHistory: Array<Scalars["Float"]>;
    /** The project's content in markdown format. */
    content?: Maybe<Scalars["String"]>;
    /** [Internal] The project's content as YJS state. */
    contentState?: Maybe<Scalars["String"]>;
    /** The project was created based on this issue. */
    convertedFromIssue?: Maybe<Issue>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who created the project. */
    creator?: Maybe<User>;
    /** [INTERNAL] The current progress of the project. */
    currentProgress: Scalars["JSONObject"];
    /** The project's description. */
    description: Scalars["String"];
    /** The content of the project description. */
    documentContent?: Maybe<DocumentContent>;
    /** Documents associated with the project. */
    documents: DocumentConnection;
    /** External links associated with the project. */
    externalLinks: EntityExternalLinkConnection;
    /** The user's favorite associated with this project. */
    favorite?: Maybe<Favorite>;
    /** The resolution of the reminder frequency. */
    frequencyResolution: FrequencyResolutionType;
    /** The health of the project. */
    health?: Maybe<ProjectUpdateHealthType>;
    /** The time at which the project health was updated. */
    healthUpdatedAt?: Maybe<Scalars["DateTime"]>;
    /** History entries associated with the project. */
    history: ProjectHistoryConnection;
    /** The icon of the project. */
    icon?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The number of in progress estimation points after each week. */
    inProgressScopeHistory: Array<Scalars["Float"]>;
    /** Initiatives that this project belongs to. */
    initiatives: InitiativeConnection;
    /** Settings for all integrations associated with that project. */
    integrationsSettings?: Maybe<IntegrationsSettings>;
    /** Inverse relations associated with this project. */
    inverseRelations: ProjectRelationConnection;
    /** The total number of issues in the project after each week. */
    issueCountHistory: Array<Scalars["Float"]>;
    /** Issues associated with the project. */
    issues: IssueConnection;
    /** Id of the labels associated with this project. */
    labelIds: Array<Scalars["String"]>;
    /** [Internal] Labels associated with this project. */
    labels: ProjectLabelConnection;
    /** The last template that was applied to this project. */
    lastAppliedTemplate?: Maybe<Template>;
    /** The last project update posted for this project. */
    lastUpdate?: Maybe<ProjectUpdate>;
    /** The project lead. */
    lead?: Maybe<User>;
    /** Users that are members of the project. */
    members: UserConnection;
    /** Metadata related to search result. */
    metadata: Scalars["JSONObject"];
    /** The project's name. */
    name: Scalars["String"];
    /** Customer needs associated with the project. */
    needs: CustomerNeedConnection;
    /** The priority of the project. 0 = No priority, 1 = Urgent, 2 = High, 3 = Normal, 4 = Low. */
    priority: Scalars["Int"];
    /** The priority of the project as a label. */
    priorityLabel: Scalars["String"];
    /** The sort order for the project within the organization, when ordered by priority. */
    prioritySortOrder: Scalars["Float"];
    /** The overall progress of the project. This is the (completed estimate points + 0.25 * in progress estimate points) / total estimate points. */
    progress: Scalars["Float"];
    /** [INTERNAL] The progress history of the project. */
    progressHistory: Scalars["JSONObject"];
    /** Milestones associated with the project. */
    projectMilestones: ProjectMilestoneConnection;
    /** The time until which project update reminders are paused. */
    projectUpdateRemindersPausedUntilAt?: Maybe<Scalars["DateTime"]>;
    /** Project updates associated with the project. */
    projectUpdates: ProjectUpdateConnection;
    /** Relations associated with this project. */
    relations: ProjectRelationConnection;
    /** The overall scope (total estimate points) of the project. */
    scope: Scalars["Float"];
    /** The total number of estimation points after each week. */
    scopeHistory: Array<Scalars["Float"]>;
    /**
     * Whether to send new issue comment notifications to Slack.
     * @deprecated No longer in use
     */
    slackIssueComments: Scalars["Boolean"];
    /**
     * Whether to send new issue status updates to Slack.
     * @deprecated No longer is use
     */
    slackIssueStatuses: Scalars["Boolean"];
    /**
     * Whether to send new issue notifications to Slack.
     * @deprecated No longer in use
     */
    slackNewIssue: Scalars["Boolean"];
    /** The project's unique URL slug. */
    slugId: Scalars["String"];
    /** The sort order for the project within the organization. */
    sortOrder: Scalars["Float"];
    /** The estimated start date of the project. */
    startDate?: Maybe<Scalars["TimelessDate"]>;
    /** The resolution of the project's start date. */
    startDateResolution?: Maybe<DateResolutionType>;
    /** The time at which the project was moved into started state. */
    startedAt?: Maybe<Scalars["DateTime"]>;
    /**
     * [DEPRECATED] The type of the state.
     * @deprecated Use project.status instead
     */
    state: Scalars["String"];
    /** The status that the project is associated with. */
    status: ProjectStatus;
    /** The estimated completion date of the project. */
    targetDate?: Maybe<Scalars["TimelessDate"]>;
    /** The resolution of the project's estimated completion date. */
    targetDateResolution?: Maybe<DateResolutionType>;
    /** Teams associated with this project. */
    teams: TeamConnection;
    /** A flag that indicates whether the project is in the trash bin. */
    trashed?: Maybe<Scalars["Boolean"]>;
    /** The frequency at which to prompt for updates. When not set, reminders are inherited from workspace. */
    updateReminderFrequency?: Maybe<Scalars["Float"]>;
    /** The n-weekly frequency at which to prompt for updates. When not set, reminders are inherited from workspace. */
    updateReminderFrequencyInWeeks?: Maybe<Scalars["Float"]>;
    /** The day at which to prompt for updates. */
    updateRemindersDay?: Maybe<Day>;
    /** The hour at which to prompt for updates. */
    updateRemindersHour?: Maybe<Scalars["Float"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** Project URL. */
    url: Scalars["String"];
};
export declare type ProjectSearchResultCommentsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CommentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type ProjectSearchResultDocumentsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<DocumentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type ProjectSearchResultExternalLinksArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type ProjectSearchResultHistoryArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type ProjectSearchResultInitiativesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type ProjectSearchResultInverseRelationsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type ProjectSearchResultIssuesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type ProjectSearchResultLabelsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectLabelFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type ProjectSearchResultMembersArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<UserFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeDisabled?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type ProjectSearchResultNeedsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CustomerNeedFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type ProjectSearchResultProjectMilestonesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectMilestoneFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type ProjectSearchResultProjectUpdatesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type ProjectSearchResultRelationsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type ProjectSearchResultTeamsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<TeamFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type ProjectSearchResultEdge = {
    __typename?: "ProjectSearchResultEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: ProjectSearchResult;
};
/** Issue project sorting options. */
export declare type ProjectSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
/** A project status. */
export declare type ProjectStatus = Node & {
    __typename?: "ProjectStatus";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The UI color of the status as a HEX string. */
    color: Scalars["String"];
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** Description of the status. */
    description?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** Whether or not a project can be in this status indefinitely. */
    indefinite: Scalars["Boolean"];
    /** The name of the status. */
    name: Scalars["String"];
    /** The position of the status in the workspace's project flow. */
    position: Scalars["Float"];
    /** The type of the project status. */
    type: ProjectStatusType;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
/** A generic payload return from entity archive mutations. */
export declare type ProjectStatusArchivePayload = ArchivePayload & {
    __typename?: "ProjectStatusArchivePayload";
    /** The archived/unarchived entity. Null if entity was deleted. */
    entity?: Maybe<ProjectStatus>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type ProjectStatusConnection = {
    __typename?: "ProjectStatusConnection";
    edges: Array<ProjectStatusEdge>;
    nodes: Array<ProjectStatus>;
    pageInfo: PageInfo;
};
export declare type ProjectStatusCountPayload = {
    __typename?: "ProjectStatusCountPayload";
    /** Total number of projects using this project status that are not visible to the user because they are in an archived team. */
    archivedTeamCount: Scalars["Float"];
    /** Total number of projects using this project status. */
    count: Scalars["Float"];
    /** Total number of projects using this project status that are not visible to the user because they are in a private team. */
    privateCount: Scalars["Float"];
};
export declare type ProjectStatusCreateInput = {
    /** The UI color of the status as a HEX string. */
    color: Scalars["String"];
    /** Description of the status. */
    description?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** Whether or not a project can be in this status indefinitely. */
    indefinite?: Maybe<Scalars["Boolean"]>;
    /** The name of the status. */
    name: Scalars["String"];
    /** The position of the status in the workspace's project flow. */
    position: Scalars["Float"];
    /** The type of the project status. */
    type: ProjectStatusType;
};
export declare type ProjectStatusEdge = {
    __typename?: "ProjectStatusEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: ProjectStatus;
};
/** Project status filtering options. */
export declare type ProjectStatusFilter = {
    /** Compound filters, all of which need to be matched by the project status. */
    and?: Maybe<Array<ProjectStatusFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the project status description. */
    description?: Maybe<StringComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the project status name. */
    name?: Maybe<StringComparator>;
    /** Compound filters, one of which needs to be matched by the project status. */
    or?: Maybe<Array<ProjectStatusFilter>>;
    /** Comparator for the project status position. */
    position?: Maybe<NumberComparator>;
    /** Filters that the project status projects must satisfy. */
    projects?: Maybe<ProjectCollectionFilter>;
    /** Comparator for the project status type. */
    type?: Maybe<StringComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type ProjectStatusPayload = {
    __typename?: "ProjectStatusPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** The project status that was created or updated. */
    status: ProjectStatus;
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** A type of project status. */
export declare enum ProjectStatusType {
    Backlog = "backlog",
    Canceled = "canceled",
    Completed = "completed",
    Paused = "paused",
    Planned = "planned",
    Started = "started"
}
export declare type ProjectStatusUpdateInput = {
    /** The UI color of the status as a HEX string. */
    color?: Maybe<Scalars["String"]>;
    /** Description of the status. */
    description?: Maybe<Scalars["String"]>;
    /** Whether or not a project can be in this status indefinitely. */
    indefinite?: Maybe<Scalars["Boolean"]>;
    /** The name of the status. */
    name?: Maybe<Scalars["String"]>;
    /** The position of the status in the workspace's project flow. */
    position?: Maybe<Scalars["Float"]>;
    /** The type of the project status. */
    type?: Maybe<ProjectStatusType>;
};
/** Different tabs available inside a project. */
export declare enum ProjectTab {
    Customers = "customers",
    Documents = "documents",
    Issues = "issues"
}
/** An update associated with a project. */
export declare type ProjectUpdate = Node & {
    __typename?: "ProjectUpdate";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The update content in markdown format. */
    body: Scalars["String"];
    /** [Internal] The content of the update as a Prosemirror document. */
    bodyData: Scalars["String"];
    /** Comments associated with the project update. */
    comments: CommentConnection;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The diff between the current update and the previous one. */
    diff?: Maybe<Scalars["JSONObject"]>;
    /** The diff between the current update and the previous one, formatted as markdown. */
    diffMarkdown?: Maybe<Scalars["String"]>;
    /** The time the update was edited. */
    editedAt?: Maybe<Scalars["DateTime"]>;
    /** The health of the project at the time of the update. */
    health: ProjectUpdateHealthType;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** [Internal] Serialized JSON representing current state of the project properties when posting the project update. */
    infoSnapshot?: Maybe<Scalars["JSONObject"]>;
    /** Whether project update diff should be hidden. */
    isDiffHidden: Scalars["Boolean"];
    /** Whether the project update is stale. */
    isStale: Scalars["Boolean"];
    /** The project that the update is associated with. */
    project: Project;
    /** Emoji reaction summary, grouped by emoji type. */
    reactionData: Scalars["JSONObject"];
    /** Reactions associated with the project update. */
    reactions: Array<Reaction>;
    /** The update's unique URL slug. */
    slugId: Scalars["String"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The URL to the project update. */
    url: Scalars["String"];
    /** The user who wrote the update. */
    user: User;
};
/** An update associated with a project. */
export declare type ProjectUpdateCommentsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CommentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A generic payload return from entity archive mutations. */
export declare type ProjectUpdateArchivePayload = ArchivePayload & {
    __typename?: "ProjectUpdateArchivePayload";
    /** The archived/unarchived entity. Null if entity was deleted. */
    entity?: Maybe<ProjectUpdate>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type ProjectUpdateConnection = {
    __typename?: "ProjectUpdateConnection";
    edges: Array<ProjectUpdateEdge>;
    nodes: Array<ProjectUpdate>;
    pageInfo: PageInfo;
};
export declare type ProjectUpdateCreateInput = {
    /** The content of the project update in markdown format. */
    body?: Maybe<Scalars["String"]>;
    /** [Internal] The content of the project update as a Prosemirror document. */
    bodyData?: Maybe<Scalars["JSON"]>;
    /** The health of the project at the time of the update. */
    health?: Maybe<ProjectUpdateHealthType>;
    /** The identifier. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** Whether the diff between the current update and the previous one should be hidden. */
    isDiffHidden?: Maybe<Scalars["Boolean"]>;
    /** The project to associate the project update with. */
    projectId: Scalars["String"];
};
export declare type ProjectUpdateEdge = {
    __typename?: "ProjectUpdateEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: ProjectUpdate;
};
/** Options for filtering project updates. */
export declare type ProjectUpdateFilter = {
    /** Compound filters, all of which need to be matched by the ProjectUpdate. */
    and?: Maybe<Array<ProjectUpdateFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Compound filters, one of which need to be matched by the ProjectUpdate. */
    or?: Maybe<Array<ProjectUpdateFilter>>;
    /** Filters that the project update project must satisfy. */
    project?: Maybe<ProjectFilter>;
    /** Filters that the project updates reactions must satisfy. */
    reactions?: Maybe<ReactionCollectionFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
    /** Filters that the project update creator must satisfy. */
    user?: Maybe<UserFilter>;
};
/** The health type when the project update is created. */
export declare enum ProjectUpdateHealthType {
    AtRisk = "atRisk",
    OffTrack = "offTrack",
    OnTrack = "onTrack"
}
export declare type ProjectUpdateInput = {
    /** The date when the project was canceled. */
    canceledAt?: Maybe<Scalars["DateTime"]>;
    /** The color of the project. */
    color?: Maybe<Scalars["String"]>;
    /** The date when the project was completed. */
    completedAt?: Maybe<Scalars["DateTime"]>;
    /** The project content as markdown. */
    content?: Maybe<Scalars["String"]>;
    /** The ID of the issue from which that project is created. */
    convertedFromIssueId?: Maybe<Scalars["String"]>;
    /** The description for the project. */
    description?: Maybe<Scalars["String"]>;
    /** The frequency resolution. */
    frequencyResolution?: Maybe<FrequencyResolutionType>;
    /** The icon of the project. */
    icon?: Maybe<Scalars["String"]>;
    /** [Internal] The identifiers of the project labels associated with this project. */
    labelIds?: Maybe<Array<Scalars["String"]>>;
    /** The ID of the last template applied to the project. */
    lastAppliedTemplateId?: Maybe<Scalars["String"]>;
    /** The identifier of the project lead. */
    leadId?: Maybe<Scalars["String"]>;
    /** The identifiers of the members of this project. */
    memberIds?: Maybe<Array<Scalars["String"]>>;
    /** The name of the project. */
    name?: Maybe<Scalars["String"]>;
    /** The priority of the project. 0 = No priority, 1 = Urgent, 2 = High, 3 = Normal, 4 = Low. */
    priority?: Maybe<Scalars["Int"]>;
    /** The sort order for the project within shared views, when ordered by priority. */
    prioritySortOrder?: Maybe<Scalars["Float"]>;
    /** The time until which project update reminders are paused. */
    projectUpdateRemindersPausedUntilAt?: Maybe<Scalars["DateTime"]>;
    /** Whether to send new issue comment notifications to Slack. */
    slackIssueComments?: Maybe<Scalars["Boolean"]>;
    /** Whether to send issue status update notifications to Slack. */
    slackIssueStatuses?: Maybe<Scalars["Boolean"]>;
    /** Whether to send new issue notifications to Slack. */
    slackNewIssue?: Maybe<Scalars["Boolean"]>;
    /** The sort order for the project in shared views. */
    sortOrder?: Maybe<Scalars["Float"]>;
    /** The planned start date of the project. */
    startDate?: Maybe<Scalars["TimelessDate"]>;
    /** The resolution of the project's start date. */
    startDateResolution?: Maybe<DateResolutionType>;
    /** The ID of the project status. */
    statusId?: Maybe<Scalars["String"]>;
    /** The planned target date of the project. */
    targetDate?: Maybe<Scalars["TimelessDate"]>;
    /** The resolution of the project's estimated completion date. */
    targetDateResolution?: Maybe<DateResolutionType>;
    /** The identifiers of the teams this project is associated with. */
    teamIds?: Maybe<Array<Scalars["String"]>>;
    /** Whether the project has been trashed. */
    trashed?: Maybe<Scalars["Boolean"]>;
    /** The frequency at which to prompt for updates. When not set, reminders are inherited from workspace. */
    updateReminderFrequency?: Maybe<Scalars["Float"]>;
    /** The n-weekly frequency at which to prompt for updates. When not set, reminders are inherited from workspace. */
    updateReminderFrequencyInWeeks?: Maybe<Scalars["Float"]>;
    /** The day at which to prompt for updates. */
    updateRemindersDay?: Maybe<Day>;
    /** The hour at which to prompt for updates. */
    updateRemindersHour?: Maybe<Scalars["Int"]>;
};
export declare type ProjectUpdatePayload = {
    __typename?: "ProjectUpdatePayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** The project update that was created or updated. */
    projectUpdate: ProjectUpdate;
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** The frequency at which to send project update reminders. */
export declare enum ProjectUpdateReminderFrequency {
    Month = "month",
    Never = "never",
    TwoWeeks = "twoWeeks",
    Week = "week"
}
export declare type ProjectUpdateReminderPayload = {
    __typename?: "ProjectUpdateReminderPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type ProjectUpdateUpdateInput = {
    /** The content of the project update in markdown format. */
    body?: Maybe<Scalars["String"]>;
    /** The content of the project update as a Prosemirror document. */
    bodyData?: Maybe<Scalars["JSON"]>;
    /** The health of the project at the time of the update. */
    health?: Maybe<ProjectUpdateHealthType>;
    /** Whether the diff between the current update and the previous one should be hidden. */
    isDiffHidden?: Maybe<Scalars["Boolean"]>;
};
/** Collection filtering options for filtering projects by project updates. */
export declare type ProjectUpdatesCollectionFilter = {
    /** Compound filters, all of which need to be matched by the project update. */
    and?: Maybe<Array<ProjectUpdatesCollectionFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that needs to be matched by all updates. */
    every?: Maybe<ProjectUpdatesFilter>;
    /** Comparator for the project update health. */
    health?: Maybe<StringComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the collection length. */
    length?: Maybe<NumberComparator>;
    /** Compound filters, one of which need to be matched by the update. */
    or?: Maybe<Array<ProjectUpdatesCollectionFilter>>;
    /** Filters that needs to be matched by some updates. */
    some?: Maybe<ProjectUpdatesFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** Options for filtering projects by project updates. */
export declare type ProjectUpdatesFilter = {
    /** Compound filters, all of which need to be matched by the project updates. */
    and?: Maybe<Array<ProjectUpdatesFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the project update health. */
    health?: Maybe<StringComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Compound filters, one of which need to be matched by the project updates. */
    or?: Maybe<Array<ProjectUpdatesFilter>>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** [Internal] A pull request in a version control system. */
export declare type PullRequest = Node & {
    __typename?: "PullRequest";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The number of the pull request in the version control system. */
    number: Scalars["Float"];
    /** The source branch of the pull request. */
    sourceBranch: Scalars["String"];
    /** The status of the pull request. */
    status: PullRequestStatus;
    /** The target branch of the pull request. */
    targetBranch: Scalars["String"];
    /** The title of the pull request. */
    title: Scalars["String"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The URL of the pull request in the version control system. */
    url: Scalars["String"];
};
/** [Internal] A pull request related notification. */
export declare type PullRequestNotification = Entity & Node & Notification & {
    __typename?: "PullRequestNotification";
    /** The user that caused the notification. */
    actor?: Maybe<User>;
    /** [Internal] Notification actor initials if avatar is not available. */
    actorAvatarColor: Scalars["String"];
    /** [Internal] Notification avatar URL. */
    actorAvatarUrl?: Maybe<Scalars["String"]>;
    /** [Internal] Notification actor initials if avatar is not available. */
    actorInitials?: Maybe<Scalars["String"]>;
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The bot that caused the notification. */
    botActor?: Maybe<ActorBot>;
    /** Related comment ID. Null if the notification is not related to a comment. */
    commentId?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /**
     * The time at when an email reminder for this notification was sent to the user. Null, if no email
     *     reminder has been sent.
     */
    emailedAt?: Maybe<Scalars["DateTime"]>;
    /** The external user that caused the notification. */
    externalUserActor?: Maybe<ExternalUser>;
    /** [Internal] Notifications with the same grouping key will be grouped together in the UI. */
    groupingKey: Scalars["String"];
    /** [Internal] Priority of the notification with the same grouping key. Higher number means higher priority. If priority is the same, notifications should be sorted by `createdAt`. */
    groupingPriority: Scalars["Float"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** [Internal] Inbox URL for the notification. */
    inboxUrl: Scalars["String"];
    /** [Internal] If notification actor was Linear. */
    isLinearActor: Scalars["Boolean"];
    /** [Internal] Issue's status type for issue notifications. */
    issueStatusType?: Maybe<Scalars["String"]>;
    /** Related parent comment ID. Null if the notification is not related to a comment. */
    parentCommentId?: Maybe<Scalars["String"]>;
    /** [Internal] Project update health for new updates. */
    projectUpdateHealth?: Maybe<Scalars["String"]>;
    /** The pull request related to the notification. */
    pullRequest: PullRequest;
    /** Related pull request. */
    pullRequestId: Scalars["String"];
    /** Name of the reaction emoji related to the notification. */
    reactionEmoji?: Maybe<Scalars["String"]>;
    /** The time at when the user marked the notification as read. Null, if the the user hasn't read the notification */
    readAt?: Maybe<Scalars["DateTime"]>;
    /** The time until a notification will be snoozed. After that it will appear in the inbox again. */
    snoozedUntilAt?: Maybe<Scalars["DateTime"]>;
    /** [Internal] Notification subtitle. */
    subtitle: Scalars["String"];
    /** [Internal] Notification title. */
    title: Scalars["String"];
    /** Notification type. */
    type: Scalars["String"];
    /** The time at which a notification was unsnoozed.. */
    unsnoozedAt?: Maybe<Scalars["DateTime"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** [Internal] URL to the target of the notification. */
    url: Scalars["String"];
    /** The user that received the notification. */
    user: User;
};
export declare enum PullRequestReviewTool {
    Graphite = "graphite",
    Source = "source"
}
/** The status of a pull request. */
export declare enum PullRequestStatus {
    Approved = "approved",
    Closed = "closed",
    Draft = "draft",
    InReview = "inReview",
    Merged = "merged",
    Open = "open"
}
/** A user's web or mobile push notification subscription. */
export declare type PushSubscription = Node & {
    __typename?: "PushSubscription";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type PushSubscriptionCreateInput = {
    /** The data of the subscription in stringified JSON format. */
    data: Scalars["String"];
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** Whether this is a subscription payload for Google Cloud Messaging or Apple Push Notification service. */
    type?: Maybe<PushSubscriptionType>;
};
export declare type PushSubscriptionPayload = {
    __typename?: "PushSubscriptionPayload";
    /** The push subscription that was created or updated. */
    entity: PushSubscription;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type PushSubscriptionTestPayload = {
    __typename?: "PushSubscriptionTestPayload";
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** The different push subscription types. */
export declare enum PushSubscriptionType {
    Apple = "apple",
    AppleDevelopment = "appleDevelopment",
    Firebase = "firebase",
    Web = "web"
}
export declare type Query = {
    __typename?: "Query";
    /** All teams you the user can administrate. Administrable teams are teams whose settings the user can change, but to whose issues the user doesn't necessarily have access to. */
    administrableTeams: TeamConnection;
    /** All API keys for the user. */
    apiKeys: ApiKeyConnection;
    /** Get basic information for an application. */
    applicationInfo: Application;
    /** [INTERNAL] Get basic information for a list of applications. */
    applicationInfoByIds: Array<Application>;
    /** [INTERNAL] Get information for a list of applications with memberships */
    applicationInfoWithMembershipsByIds: Array<WorkspaceAuthorizedApplication>;
    /** Get information for an application and whether a user has approved it for the given scopes. */
    applicationWithAuthorization: UserAuthorizedApplication;
    /** [Internal] All archived teams of the organization. */
    archivedTeams: Array<Team>;
    /**
     * One specific issue attachment.
     * [Deprecated] 'url' can no longer be used as the 'id' parameter. Use 'attachmentsForUrl' instead
     */
    attachment: Attachment;
    /**
     * Query an issue by its associated attachment, and its id.
     * @deprecated Will be removed in near future, please use `attachmentsForURL` to get attachments and their issues instead.
     */
    attachmentIssue: Issue;
    /** [Internal] Get a list of all unique attachment sources in the workspace. */
    attachmentSources: AttachmentSourcesPayload;
    /**
     * All issue attachments.
     *
     * To get attachments for a given URL, use `attachmentsForURL` query.
     */
    attachments: AttachmentConnection;
    /** Returns issue attachments for a given `url`. */
    attachmentsForURL: AttachmentConnection;
    /** All audit log entries. */
    auditEntries: AuditEntryConnection;
    /** List of audit entry types. */
    auditEntryTypes: Array<AuditEntryType>;
    /** User's active sessions. */
    authenticationSessions: Array<AuthenticationSessionResponse>;
    /** [INTERNAL] Get all authorized applications for a user. */
    authorizedApplications: Array<AuthorizedApplication>;
    /** Fetch users belonging to this user account. */
    availableUsers: AuthResolverResponse;
    /** A specific comment. */
    comment: Comment;
    /** All comments. */
    comments: CommentConnection;
    /** One specific custom view. */
    customView: CustomView;
    /** [INTERNAL] Suggests metadata for a view based on it's filters. */
    customViewDetailsSuggestion: CustomViewSuggestionPayload;
    /** Whether a custom view has other subscribers than the current user in the organization. */
    customViewHasSubscribers: CustomViewHasSubscribersPayload;
    /** Custom views for the user. */
    customViews: CustomViewConnection;
    /** One specific customer. */
    customer: Customer;
    /** One specific customer need */
    customerNeed: CustomerNeed;
    /** All customer needs. */
    customerNeeds: CustomerNeedConnection;
    /** One specific customer status. */
    customerStatus: CustomerStatus;
    /** All customer statuses. */
    customerStatuses: CustomerStatusConnection;
    /** One specific customer tier. */
    customerTier: CustomerTier;
    /** All customer tiers. */
    customerTiers: CustomerTierConnection;
    /** All customers. */
    customers: CustomerConnection;
    /** One specific cycle. */
    cycle: Cycle;
    /** All cycles. */
    cycles: CycleConnection;
    /** One specific document. */
    document: Document;
    /** A collection of document content history entries. */
    documentContentHistory: DocumentContentHistoryPayload;
    /** All documents in the workspace. */
    documents: DocumentConnection;
    /** A specific emoji. */
    emoji: Emoji;
    /** All custom emojis. */
    emojis: EmojiConnection;
    /** One specific entity link. */
    entityExternalLink: EntityExternalLink;
    /** One specific external user. */
    externalUser: ExternalUser;
    /** All external users for the organization. */
    externalUsers: ExternalUserConnection;
    /** [INTERNAL] Webhook failure events for webhooks that belong to an OAuth application. (last 50) */
    failuresForOauthWebhooks: Array<WebhookFailureEvent>;
    /** One specific favorite. */
    favorite: Favorite;
    /** The user's favorites. */
    favorites: FavoriteConnection;
    /** One specific initiative. */
    initiative: Initiative;
    /** One specific initiative relation. */
    initiativeRelation: ProjectRelation;
    /** All initiative relationships. */
    initiativeRelations: InitiativeRelationConnection;
    /** One specific initiativeToProject. */
    initiativeToProject: InitiativeToProject;
    /** returns a list of initiative to project entities. */
    initiativeToProjects: InitiativeToProjectConnection;
    /** A specific  initiative update. */
    initiativeUpdate: InitiativeUpdate;
    /** All  InitiativeUpdates. */
    initiativeUpdates: InitiativeUpdateConnection;
    /** All initiatives in the workspace. */
    initiatives: InitiativeConnection;
    /** One specific integration. */
    integration: Integration;
    /** Checks if the integration has all required scopes. */
    integrationHasScopes: IntegrationHasScopesPayload;
    /** One specific integrationTemplate. */
    integrationTemplate: IntegrationTemplate;
    /** Template and integration connections. */
    integrationTemplates: IntegrationTemplateConnection;
    /** All integrations. */
    integrations: IntegrationConnection;
    /** One specific set of settings. */
    integrationsSettings: IntegrationsSettings;
    /** One specific issue. */
    issue: Issue;
    /** Find issues that are related to a given Figma file key. */
    issueFigmaFileKeySearch: IssueConnection;
    /** Suggests filters for an issue view based on a text prompt. */
    issueFilterSuggestion: IssueFilterSuggestionPayload;
    /** Checks a CSV file validity against a specific import service. */
    issueImportCheckCSV: IssueImportCheckPayload;
    /** Checks whether it will be possible to setup sync for this project or repository at the end of import */
    issueImportCheckSync: IssueImportSyncCheckPayload;
    /** Checks whether a custom JQL query is valid and can be used to filter issues of a Jira import */
    issueImportJqlCheck: IssueImportJqlCheckPayload;
    /** One specific label. */
    issueLabel: IssueLabel;
    /** All issue labels. */
    issueLabels: IssueLabelConnection;
    /** Issue priority values and corresponding labels. */
    issuePriorityValues: Array<IssuePriorityValue>;
    /** One specific issue relation. */
    issueRelation: IssueRelation;
    /** All issue relationships. */
    issueRelations: IssueRelationConnection;
    /** [DEPRECATED] Search issues. This endpoint is deprecated and will be removed in the future – use `searchIssues` instead. */
    issueSearch: IssueConnection;
    /** Suggests issue title based on a customer request. */
    issueTitleSuggestionFromCustomerRequest: IssueTitleSuggestionFromCustomerRequestPayload;
    /** Find issue based on the VCS branch name. */
    issueVcsBranchSearch?: Maybe<Issue>;
    /** All issues. */
    issues: IssueConnection;
    /** One specific notification. */
    notification: Notification;
    /** One specific notification subscription. */
    notificationSubscription: NotificationSubscription;
    /** The user's notification subscriptions. */
    notificationSubscriptions: NotificationSubscriptionConnection;
    /** All notifications. */
    notifications: NotificationConnection;
    /** [Internal] A number of unread notifications. */
    notificationsUnreadCount: Scalars["Int"];
    /** The user's organization. */
    organization: Organization;
    /** [INTERNAL] Checks whether the domain can be claimed. */
    organizationDomainClaimRequest: OrganizationDomainClaimPayload;
    /** Does the organization exist. */
    organizationExists: OrganizationExistsPayload;
    /** One specific organization invite. */
    organizationInvite: OrganizationInvite;
    /** One specific organization invite. */
    organizationInviteDetails: OrganizationInviteDetailsPayload;
    /** All invites for the organization. */
    organizationInvites: OrganizationInviteConnection;
    /** [INTERNAL] Get organization metadata by urlKey or organization id. */
    organizationMeta?: Maybe<OrganizationMeta>;
    /** One specific project. */
    project: Project;
    /** Suggests filters for a project view based on a text prompt. */
    projectFilterSuggestion: ProjectFilterSuggestionPayload;
    /** One specific project milestone. */
    projectMilestone: ProjectMilestone;
    /** All milestones for the project. */
    projectMilestones: ProjectMilestoneConnection;
    /** One specific project relation. */
    projectRelation: ProjectRelation;
    /** All project relationships. */
    projectRelations: ProjectRelationConnection;
    /** One specific project status. */
    projectStatus: ProjectStatus;
    /** [INTERNAL] Count of projects using this project status across the organization. */
    projectStatusProjectCount: ProjectStatusCountPayload;
    /** All project statuses. */
    projectStatuses: ProjectStatusConnection;
    /** A specific project update. */
    projectUpdate: ProjectUpdate;
    /** All project updates. */
    projectUpdates: ProjectUpdateConnection;
    /** All projects. */
    projects: ProjectConnection;
    /** Sends a test push message. */
    pushSubscriptionTest: PushSubscriptionTestPayload;
    /** The status of the rate limiter. */
    rateLimitStatus: RateLimitPayload;
    /**
     * One specific roadmap.
     * @deprecated Roadmaps are deprecated, use initiatives instead.
     */
    roadmap: Roadmap;
    /** One specific roadmapToProject. */
    roadmapToProject: RoadmapToProject;
    /** Custom views for the user. */
    roadmapToProjects: RoadmapToProjectConnection;
    /**
     * All roadmaps in the workspace.
     * @deprecated Roadmaps are deprecated, use initiatives instead.
     */
    roadmaps: RoadmapConnection;
    /** Search documents. */
    searchDocuments: DocumentSearchPayload;
    /** Search issues. */
    searchIssues: IssueSearchPayload;
    /** Search projects. */
    searchProjects: ProjectSearchPayload;
    /** [ALPHA] Search for various resources using natural language. */
    semanticSearch: SemanticSearchPayload;
    /** Fetch SSO login URL for the email provided. */
    ssoUrlFromEmail: SsoUrlFromEmailResponse;
    /** [Internal] AI summary of the latest project updates for the given projects */
    summarizeProjectUpdates: SummaryPayload;
    /** One specific team. */
    team: Team;
    /** One specific team membership. */
    teamMembership: TeamMembership;
    /** All team memberships. */
    teamMemberships: TeamMembershipConnection;
    /** All teams whose issues can be accessed by the user. This might be different from `administrableTeams`, which also includes teams whose settings can be changed by the user. */
    teams: TeamConnection;
    /** A specific template. */
    template: Template;
    /** All templates from all users. */
    templates: Array<Template>;
    /** Returns all templates that are associated with the integration type. */
    templatesForIntegration: Array<Template>;
    /** A specific time schedule. */
    timeSchedule: TimeSchedule;
    /** All time schedules. */
    timeSchedules: TimeScheduleConnection;
    /** All triage responsibilities. */
    triageResponsibilities: TriageResponsibilityConnection;
    /** A specific triage responsibility. */
    triageResponsibility: TriageResponsibility;
    /** One specific user. */
    user: User;
    /** The user's settings. */
    userSettings: UserSettings;
    /** All users for the organization. */
    users: UserConnection;
    /** Verify that we received the correct response from the GitHub Enterprise Server. */
    verifyGitHubEnterpriseServerInstallation: GitHubEnterpriseServerInstallVerificationPayload;
    /** The currently authenticated user. */
    viewer: User;
    /** A specific webhook. */
    webhook: Webhook;
    /** All webhooks. */
    webhooks: WebhookConnection;
    /** One specific state. */
    workflowState: WorkflowState;
    /** All issue workflow states. */
    workflowStates: WorkflowStateConnection;
    /** [INTERNAL] Get a specific non-internal authorized application (with limited fields) for a workspace */
    workspaceAuthorizedApplication: WorkspaceAuthorizedApplicationWithMemberships;
    /** [INTERNAL] Get non-internal authorized applications (with limited fields) for a workspace */
    workspaceAuthorizedApplications: Array<WorkspaceAuthorizedApplication>;
};
export declare type QueryAdministrableTeamsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<TeamFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryApiKeysArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryApplicationInfoArgs = {
    clientId: Scalars["String"];
};
export declare type QueryApplicationInfoByIdsArgs = {
    ids: Array<Scalars["String"]>;
};
export declare type QueryApplicationInfoWithMembershipsByIdsArgs = {
    clientIds: Array<Scalars["String"]>;
};
export declare type QueryApplicationWithAuthorizationArgs = {
    actor?: Maybe<Scalars["String"]>;
    clientId: Scalars["String"];
    redirectUri?: Maybe<Scalars["String"]>;
    scope: Array<Scalars["String"]>;
};
export declare type QueryAttachmentArgs = {
    id: Scalars["String"];
};
export declare type QueryAttachmentIssueArgs = {
    id: Scalars["String"];
};
export declare type QueryAttachmentSourcesArgs = {
    teamId?: Maybe<Scalars["String"]>;
};
export declare type QueryAttachmentsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<AttachmentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryAttachmentsForUrlArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
    url: Scalars["String"];
};
export declare type QueryAuditEntriesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<AuditEntryFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryCommentArgs = {
    hash?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
};
export declare type QueryCommentsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CommentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryCustomViewArgs = {
    id: Scalars["String"];
};
export declare type QueryCustomViewDetailsSuggestionArgs = {
    filter: Scalars["JSONObject"];
    modelName?: Maybe<Scalars["String"]>;
};
export declare type QueryCustomViewHasSubscribersArgs = {
    id: Scalars["String"];
};
export declare type QueryCustomViewsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryCustomerArgs = {
    id: Scalars["String"];
};
export declare type QueryCustomerNeedArgs = {
    hash?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
};
export declare type QueryCustomerNeedsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CustomerNeedFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryCustomerStatusArgs = {
    id: Scalars["String"];
};
export declare type QueryCustomerStatusesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryCustomerTierArgs = {
    id: Scalars["String"];
};
export declare type QueryCustomerTiersArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryCustomersArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CustomerFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
    sorts?: Maybe<Array<CustomerSortInput>>;
};
export declare type QueryCycleArgs = {
    id: Scalars["String"];
};
export declare type QueryCyclesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CycleFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryDocumentArgs = {
    id: Scalars["String"];
};
export declare type QueryDocumentContentHistoryArgs = {
    id: Scalars["String"];
};
export declare type QueryDocumentsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<DocumentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryEmojiArgs = {
    id: Scalars["String"];
};
export declare type QueryEmojisArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryEntityExternalLinkArgs = {
    id: Scalars["String"];
};
export declare type QueryExternalUserArgs = {
    id: Scalars["String"];
};
export declare type QueryExternalUsersArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryFailuresForOauthWebhooksArgs = {
    oauthClientId: Scalars["String"];
};
export declare type QueryFavoriteArgs = {
    id: Scalars["String"];
};
export declare type QueryFavoritesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryInitiativeArgs = {
    id: Scalars["String"];
};
export declare type QueryInitiativeRelationArgs = {
    id: Scalars["String"];
};
export declare type QueryInitiativeRelationsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryInitiativeToProjectArgs = {
    id: Scalars["String"];
};
export declare type QueryInitiativeToProjectsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryInitiativeUpdateArgs = {
    id: Scalars["String"];
};
export declare type QueryInitiativeUpdatesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<InitiativeUpdateFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryInitiativesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<InitiativeFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryIntegrationArgs = {
    id: Scalars["String"];
};
export declare type QueryIntegrationHasScopesArgs = {
    integrationId: Scalars["String"];
    scopes: Array<Scalars["String"]>;
};
export declare type QueryIntegrationTemplateArgs = {
    id: Scalars["String"];
};
export declare type QueryIntegrationTemplatesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryIntegrationsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryIntegrationsSettingsArgs = {
    id: Scalars["String"];
};
export declare type QueryIssueArgs = {
    id: Scalars["String"];
};
export declare type QueryIssueFigmaFileKeySearchArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    fileKey: Scalars["String"];
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryIssueFilterSuggestionArgs = {
    projectId?: Maybe<Scalars["String"]>;
    prompt: Scalars["String"];
};
export declare type QueryIssueImportCheckCsvArgs = {
    csvUrl: Scalars["String"];
    service: Scalars["String"];
};
export declare type QueryIssueImportCheckSyncArgs = {
    issueImportId: Scalars["String"];
};
export declare type QueryIssueImportJqlCheckArgs = {
    jiraEmail: Scalars["String"];
    jiraHostname: Scalars["String"];
    jiraProject: Scalars["String"];
    jiraToken: Scalars["String"];
    jql: Scalars["String"];
};
export declare type QueryIssueLabelArgs = {
    id: Scalars["String"];
};
export declare type QueryIssueLabelsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueLabelFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryIssueRelationArgs = {
    id: Scalars["String"];
};
export declare type QueryIssueRelationsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryIssueSearchArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
    query?: Maybe<Scalars["String"]>;
};
export declare type QueryIssueTitleSuggestionFromCustomerRequestArgs = {
    request: Scalars["String"];
};
export declare type QueryIssueVcsBranchSearchArgs = {
    branchName: Scalars["String"];
};
export declare type QueryIssuesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
    sort?: Maybe<Array<IssueSortInput>>;
};
export declare type QueryNotificationArgs = {
    id: Scalars["String"];
};
export declare type QueryNotificationSubscriptionArgs = {
    id: Scalars["String"];
};
export declare type QueryNotificationSubscriptionsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryNotificationsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<NotificationFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryOrganizationDomainClaimRequestArgs = {
    id: Scalars["String"];
};
export declare type QueryOrganizationExistsArgs = {
    urlKey: Scalars["String"];
};
export declare type QueryOrganizationInviteArgs = {
    id: Scalars["String"];
};
export declare type QueryOrganizationInviteDetailsArgs = {
    id: Scalars["String"];
};
export declare type QueryOrganizationInvitesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryOrganizationMetaArgs = {
    urlKey: Scalars["String"];
};
export declare type QueryProjectArgs = {
    id: Scalars["String"];
};
export declare type QueryProjectFilterSuggestionArgs = {
    prompt: Scalars["String"];
};
export declare type QueryProjectMilestoneArgs = {
    id: Scalars["String"];
};
export declare type QueryProjectMilestonesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectMilestoneFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryProjectRelationArgs = {
    id: Scalars["String"];
};
export declare type QueryProjectRelationsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryProjectStatusArgs = {
    id: Scalars["String"];
};
export declare type QueryProjectStatusProjectCountArgs = {
    id: Scalars["String"];
};
export declare type QueryProjectStatusesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryProjectUpdateArgs = {
    id: Scalars["String"];
};
export declare type QueryProjectUpdatesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectUpdateFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryProjectsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryPushSubscriptionTestArgs = {
    sendStrategy?: Maybe<SendStrategy>;
    targetMobile?: Maybe<Scalars["Boolean"]>;
};
export declare type QueryRoadmapArgs = {
    id: Scalars["String"];
};
export declare type QueryRoadmapToProjectArgs = {
    id: Scalars["String"];
};
export declare type QueryRoadmapToProjectsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryRoadmapsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QuerySearchDocumentsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeComments?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
    teamId?: Maybe<Scalars["String"]>;
    term: Scalars["String"];
};
export declare type QuerySearchIssuesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeComments?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
    teamId?: Maybe<Scalars["String"]>;
    term: Scalars["String"];
};
export declare type QuerySearchProjectsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeComments?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
    teamId?: Maybe<Scalars["String"]>;
    term: Scalars["String"];
};
export declare type QuerySemanticSearchArgs = {
    includeArchived?: Maybe<Scalars["Boolean"]>;
    maxResults?: Maybe<Scalars["Int"]>;
    query: Scalars["String"];
    types?: Maybe<Array<SemanticSearchResultType>>;
};
export declare type QuerySsoUrlFromEmailArgs = {
    email: Scalars["String"];
    isDesktop?: Maybe<Scalars["Boolean"]>;
};
export declare type QuerySummarizeProjectUpdatesArgs = {
    ids: Array<Scalars["String"]>;
};
export declare type QueryTeamArgs = {
    id: Scalars["String"];
};
export declare type QueryTeamMembershipArgs = {
    id: Scalars["String"];
};
export declare type QueryTeamMembershipsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryTeamsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<TeamFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryTemplateArgs = {
    id: Scalars["String"];
};
export declare type QueryTemplatesForIntegrationArgs = {
    integrationType: Scalars["String"];
};
export declare type QueryTimeScheduleArgs = {
    id: Scalars["String"];
};
export declare type QueryTimeSchedulesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryTriageResponsibilitiesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryTriageResponsibilityArgs = {
    id: Scalars["String"];
};
export declare type QueryUserArgs = {
    id: Scalars["String"];
};
export declare type QueryUsersArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<UserFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeDisabled?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryWebhookArgs = {
    id: Scalars["String"];
};
export declare type QueryWebhooksArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryWorkflowStateArgs = {
    id: Scalars["String"];
};
export declare type QueryWorkflowStatesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<WorkflowStateFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type QueryWorkspaceAuthorizedApplicationArgs = {
    clientId: Scalars["String"];
};
export declare type RateLimitPayload = {
    __typename?: "RateLimitPayload";
    /** The identifier we rate limit on. */
    identifier?: Maybe<Scalars["String"]>;
    /** The kind of rate limit selected for this request. */
    kind: Scalars["String"];
    /** The state of the rate limit. */
    limits: Array<RateLimitResultPayload>;
};
export declare type RateLimitResultPayload = {
    __typename?: "RateLimitResultPayload";
    /** The total allowed quantity for this type of limit. */
    allowedAmount: Scalars["Float"];
    /** The period in which the rate limit is fully replenished in ms. */
    period: Scalars["Float"];
    /** The remaining quantity for this type of limit after this request. */
    remainingAmount: Scalars["Float"];
    /** The requested quantity for this type of limit. */
    requestedAmount: Scalars["Float"];
    /** The timestamp after the rate limit is fully replenished as a UNIX timestamp. */
    reset: Scalars["Float"];
    /** What is being rate limited. */
    type: Scalars["String"];
};
/** A reaction associated with a comment or a project update. */
export declare type Reaction = Node & {
    __typename?: "Reaction";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The comment that the reaction is associated with. */
    comment?: Maybe<Comment>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** Name of the reaction's emoji. */
    emoji: Scalars["String"];
    /** The external user that created the reaction. */
    externalUser?: Maybe<ExternalUser>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The initiative update that the reaction is associated with. */
    initiativeUpdate?: Maybe<InitiativeUpdate>;
    /** The issue that the reaction is associated with. */
    issue?: Maybe<Issue>;
    /** The post that the reaction is associated with. */
    post?: Maybe<Post>;
    /** The project update that the reaction is associated with. */
    projectUpdate?: Maybe<ProjectUpdate>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The user that created the reaction. */
    user?: Maybe<User>;
};
/** Reaction filtering options. */
export declare type ReactionCollectionFilter = {
    /** Compound filters, all of which need to be matched by the reaction. */
    and?: Maybe<Array<ReactionCollectionFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the reactions custom emoji. */
    customEmojiId?: Maybe<IdComparator>;
    /** Comparator for the reactions emoji. */
    emoji?: Maybe<StringComparator>;
    /** Filters that needs to be matched by all reactions. */
    every?: Maybe<ReactionFilter>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the collection length. */
    length?: Maybe<NumberComparator>;
    /** Compound filters, one of which need to be matched by the reaction. */
    or?: Maybe<Array<ReactionCollectionFilter>>;
    /** Filters that needs to be matched by some reactions. */
    some?: Maybe<ReactionFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type ReactionCreateInput = {
    /** The comment to associate the reaction with. */
    commentId?: Maybe<Scalars["String"]>;
    /** The emoji the user reacted with. */
    emoji: Scalars["String"];
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The update to associate the reaction with. */
    initiativeUpdateId?: Maybe<Scalars["String"]>;
    /** The issue to associate the reaction with. */
    issueId?: Maybe<Scalars["String"]>;
    /** [Internal] The post to associate the reaction with. */
    postId?: Maybe<Scalars["String"]>;
    /** The project update to associate the reaction with. */
    projectUpdateId?: Maybe<Scalars["String"]>;
    /** [Internal] The pull request comment to associate the reaction with. */
    pullRequestCommentId?: Maybe<Scalars["String"]>;
    /** [Internal] The pull request to associate the reaction with. */
    pullRequestId?: Maybe<Scalars["String"]>;
};
/** Reaction filtering options. */
export declare type ReactionFilter = {
    /** Compound filters, all of which need to be matched by the reaction. */
    and?: Maybe<Array<ReactionFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the reactions custom emoji. */
    customEmojiId?: Maybe<IdComparator>;
    /** Comparator for the reactions emoji. */
    emoji?: Maybe<StringComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Compound filters, one of which need to be matched by the reaction. */
    or?: Maybe<Array<ReactionFilter>>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type ReactionPayload = {
    __typename?: "ReactionPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    reaction: Reaction;
    success: Scalars["Boolean"];
};
/** Comparator for relation existence. */
export declare type RelationExistsComparator = {
    /** Equals constraint. */
    eq?: Maybe<Scalars["Boolean"]>;
    /** Not equals constraint. */
    neq?: Maybe<Scalars["Boolean"]>;
};
/** Features release channel. */
export declare enum ReleaseChannel {
    Beta = "beta",
    Development = "development",
    Internal = "internal",
    PreRelease = "preRelease",
    Public = "public"
}
/** Customer revenue sorting options. */
export declare type RevenueSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
/** A roadmap for projects. */
export declare type Roadmap = Node & {
    __typename?: "Roadmap";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The roadmap's color. */
    color?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who created the roadmap. */
    creator: User;
    /** The description of the roadmap. */
    description?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The name of the roadmap. */
    name: Scalars["String"];
    /** The organization of the roadmap. */
    organization: Organization;
    /** The user who owns the roadmap. */
    owner?: Maybe<User>;
    /** Projects associated with the roadmap. */
    projects: ProjectConnection;
    /** The roadmap's unique URL slug. */
    slugId: Scalars["String"];
    /** The sort order of the roadmap within the organization. */
    sortOrder: Scalars["Float"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The canonical url for the roadmap. */
    url: Scalars["String"];
};
/** A roadmap for projects. */
export declare type RoadmapProjectsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A generic payload return from entity archive mutations. */
export declare type RoadmapArchivePayload = ArchivePayload & {
    __typename?: "RoadmapArchivePayload";
    /** The archived/unarchived entity. Null if entity was deleted. */
    entity?: Maybe<Roadmap>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** Roadmap collection filtering options. */
export declare type RoadmapCollectionFilter = {
    /** Compound filters, all of which need to be matched by the roadmap. */
    and?: Maybe<Array<RoadmapCollectionFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the roadmap creator must satisfy. */
    creator?: Maybe<UserFilter>;
    /** Filters that needs to be matched by all roadmaps. */
    every?: Maybe<RoadmapFilter>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the collection length. */
    length?: Maybe<NumberComparator>;
    /** Comparator for the roadmap name. */
    name?: Maybe<StringComparator>;
    /** Compound filters, one of which need to be matched by the roadmap. */
    or?: Maybe<Array<RoadmapCollectionFilter>>;
    /** Comparator for the roadmap slug ID. */
    slugId?: Maybe<StringComparator>;
    /** Filters that needs to be matched by some roadmaps. */
    some?: Maybe<RoadmapFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type RoadmapConnection = {
    __typename?: "RoadmapConnection";
    edges: Array<RoadmapEdge>;
    nodes: Array<Roadmap>;
    pageInfo: PageInfo;
};
export declare type RoadmapCreateInput = {
    /** The roadmap's color. */
    color?: Maybe<Scalars["String"]>;
    /** The description of the roadmap. */
    description?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The name of the roadmap. */
    name: Scalars["String"];
    /** The owner of the roadmap. */
    ownerId?: Maybe<Scalars["String"]>;
    /** The sort order of the roadmap within the organization. */
    sortOrder?: Maybe<Scalars["Float"]>;
};
export declare type RoadmapEdge = {
    __typename?: "RoadmapEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: Roadmap;
};
/** Roadmap filtering options. */
export declare type RoadmapFilter = {
    /** Compound filters, all of which need to be matched by the roadmap. */
    and?: Maybe<Array<RoadmapFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that the roadmap creator must satisfy. */
    creator?: Maybe<UserFilter>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the roadmap name. */
    name?: Maybe<StringComparator>;
    /** Compound filters, one of which need to be matched by the roadmap. */
    or?: Maybe<Array<RoadmapFilter>>;
    /** Comparator for the roadmap slug ID. */
    slugId?: Maybe<StringComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type RoadmapPayload = {
    __typename?: "RoadmapPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** The roadmap that was created or updated. */
    roadmap: Roadmap;
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** Join table between projects and roadmaps. */
export declare type RoadmapToProject = Node & {
    __typename?: "RoadmapToProject";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The project that the roadmap is associated with. */
    project: Project;
    /** The roadmap that the project is associated with. */
    roadmap: Roadmap;
    /** The sort order of the project within the roadmap. */
    sortOrder: Scalars["String"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type RoadmapToProjectConnection = {
    __typename?: "RoadmapToProjectConnection";
    edges: Array<RoadmapToProjectEdge>;
    nodes: Array<RoadmapToProject>;
    pageInfo: PageInfo;
};
export declare type RoadmapToProjectCreateInput = {
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The identifier of the project. */
    projectId: Scalars["String"];
    /** The identifier of the roadmap. */
    roadmapId: Scalars["String"];
    /** The sort order for the project within its organization. */
    sortOrder?: Maybe<Scalars["Float"]>;
};
export declare type RoadmapToProjectEdge = {
    __typename?: "RoadmapToProjectEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: RoadmapToProject;
};
export declare type RoadmapToProjectPayload = {
    __typename?: "RoadmapToProjectPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** The roadmapToProject that was created or updated. */
    roadmapToProject: RoadmapToProject;
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type RoadmapToProjectUpdateInput = {
    /** The sort order for the project within its organization. */
    sortOrder?: Maybe<Scalars["Float"]>;
};
export declare type RoadmapUpdateInput = {
    /** The roadmap's color. */
    color?: Maybe<Scalars["String"]>;
    /** The description of the roadmap. */
    description?: Maybe<Scalars["String"]>;
    /** The name of the roadmap. */
    name?: Maybe<Scalars["String"]>;
    /** The owner of the roadmap. */
    ownerId?: Maybe<Scalars["String"]>;
    /** The sort order of the roadmap within the organization. */
    sortOrder?: Maybe<Scalars["Float"]>;
};
/** Issue root-issue sorting options. */
export declare type RootIssueSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
    /** The sort to apply to the root issues */
    sort: IssueSortInput;
};
export declare enum SLADayCountType {
    All = "all",
    OnlyBusinessDays = "onlyBusinessDays"
}
/** [ALPHA] Payload returned by semantic search. */
export declare type SemanticSearchPayload = {
    __typename?: "SemanticSearchPayload";
    enabled: Scalars["Boolean"];
    results: Array<SemanticSearchResult>;
};
/** [ALPHA] A semantic search result reference. */
export declare type SemanticSearchResult = Node & {
    __typename?: "SemanticSearchResult";
    /** The document related to the semantic search result. */
    document?: Maybe<Document>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The initiative related to the semantic search result. */
    initiative?: Maybe<Initiative>;
    /** The issue related to the semantic search result. */
    issue?: Maybe<Issue>;
    /** The project related to the semantic search result. */
    project?: Maybe<Project>;
    /** The type of the semantic search result. */
    type: SemanticSearchResultType;
};
/** [ALPHA] The type of the semantic search result. */
export declare enum SemanticSearchResultType {
    Document = "document",
    Initiative = "initiative",
    Issue = "issue",
    Project = "project"
}
export declare enum SendStrategy {
    Desktop = "desktop",
    DesktopAndPush = "desktopAndPush",
    DesktopThenPush = "desktopThenPush",
    Push = "push"
}
export declare type SentrySettingsInput = {
    /** The ID of the Sentry organization being connected. */
    organizationId: Scalars["ID"];
    /** The slug of the Sentry organization being connected. */
    organizationSlug: Scalars["String"];
    /** Whether Sentry issues resolving completes Linear issues. */
    resolvingCompletesIssues: Scalars["Boolean"];
    /** Whether Sentry issues unresolving reopens Linear issues. */
    unresolvingReopensIssues: Scalars["Boolean"];
};
/** Customer size sorting options. */
export declare type SizeSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
export declare enum SlaStatus {
    Breached = "Breached",
    Completed = "Completed",
    Failed = "Failed",
    HighRisk = "HighRisk",
    LowRisk = "LowRisk",
    MediumRisk = "MediumRisk"
}
/** Comparator for sla status. */
export declare type SlaStatusComparator = {
    /** Equals constraint. */
    eq?: Maybe<SlaStatus>;
    /** In-array constraint. */
    in?: Maybe<Array<SlaStatus>>;
    /** Not-equals constraint. */
    neq?: Maybe<SlaStatus>;
    /** Not-in-array constraint. */
    nin?: Maybe<Array<SlaStatus>>;
    /** Null constraint. Matches any non-null values if the given value is false, otherwise it matches null values. */
    null?: Maybe<Scalars["Boolean"]>;
};
/** Issue SLA status sorting options. */
export declare type SlaStatusSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
export declare type SlackAsksSettingsInput = {
    /** The user role type that is allowed to manage Asks settings. */
    canAdministrate: UserRoleType;
    /** Enterprise id of the connected Slack enterprise */
    enterpriseId?: Maybe<Scalars["String"]>;
    /** Enterprise name of the connected Slack enterprise */
    enterpriseName?: Maybe<Scalars["String"]>;
    /** Whether to show unfurl previews in Slack */
    shouldUnfurl?: Maybe<Scalars["Boolean"]>;
    /** The mapping of Slack channel ID => Slack channel name for connected channels. */
    slackChannelMapping?: Maybe<Array<SlackChannelNameMappingInput>>;
    /** Slack workspace id */
    teamId?: Maybe<Scalars["String"]>;
    /** Slack workspace name */
    teamName?: Maybe<Scalars["String"]>;
};
/** Tuple for mapping Slack channel IDs to names. */
export declare type SlackAsksTeamSettings = {
    __typename?: "SlackAsksTeamSettings";
    /** Whether the default Asks template is enabled in the given channel for this team. */
    hasDefaultAsk: Scalars["Boolean"];
    /** The Linear team ID. */
    id: Scalars["String"];
};
export declare type SlackAsksTeamSettingsInput = {
    /** Whether the default Asks template is enabled in the given channel for this team. */
    hasDefaultAsk: Scalars["Boolean"];
    /** The Linear team ID. */
    id: Scalars["String"];
};
export declare type SlackChannelConnectPayload = {
    __typename?: "SlackChannelConnectPayload";
    /** Whether the bot needs to be manually added to the channel. */
    addBot: Scalars["Boolean"];
    /** The integration that was created or updated. */
    integration?: Maybe<Integration>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether it's recommended to connect main Slack integration. */
    nudgeToConnectMainSlackIntegration?: Maybe<Scalars["Boolean"]>;
    /** Whether it's recommended to update main Slack integration. */
    nudgeToUpdateMainSlackIntegration?: Maybe<Scalars["Boolean"]>;
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** Object for mapping Slack channel IDs to names and other settings. */
export declare type SlackChannelNameMapping = {
    __typename?: "SlackChannelNameMapping";
    /** Whether or not to use AI to generate titles for Asks created in this channel. */
    aiTitles?: Maybe<Scalars["Boolean"]>;
    /** Whether or not @-mentioning the bot should automatically create an Ask with the message. */
    autoCreateOnBotMention?: Maybe<Scalars["Boolean"]>;
    /** Whether or not using the :ticket: emoji in this channel should automatically create Asks. */
    autoCreateOnEmoji?: Maybe<Scalars["Boolean"]>;
    /** Whether or not top-level messages in this channel should automatically create Asks. */
    autoCreateOnMessage?: Maybe<Scalars["Boolean"]>;
    /** The optional template ID to use for Asks auto-created in this channel. If not set, auto-created Asks won't use any template. */
    autoCreateTemplateId?: Maybe<Scalars["String"]>;
    /** Whether or not the Linear Asks bot has been added to this Slack channel. */
    botAdded?: Maybe<Scalars["Boolean"]>;
    /** The Slack channel ID. */
    id: Scalars["String"];
    /** Whether or not the Slack channel is private. */
    isPrivate?: Maybe<Scalars["Boolean"]>;
    /** Whether or not the Slack channel is shared with an external org. */
    isShared?: Maybe<Scalars["Boolean"]>;
    /** The Slack channel name. */
    name: Scalars["String"];
    /** Whether or not synced Slack threads should be updated with a message when their Ask is accepted from triage. */
    postAcceptedFromTriageUpdates?: Maybe<Scalars["Boolean"]>;
    /** Whether or not synced Slack threads should be updated with a message and emoji when their Ask is canceled. */
    postCancellationUpdates?: Maybe<Scalars["Boolean"]>;
    /** Whether or not synced Slack threads should be updated with a message and emoji when their Ask is completed. */
    postCompletionUpdates?: Maybe<Scalars["Boolean"]>;
    /** Which teams are connected to the channel and settings for those teams. */
    teams: Array<SlackAsksTeamSettings>;
};
export declare type SlackChannelNameMappingInput = {
    /** Whether or not to use AI to generate titles for Asks created in this channel. */
    aiTitles?: Maybe<Scalars["Boolean"]>;
    /** Whether or not @-mentioning the bot should automatically create an Ask with the message. */
    autoCreateOnBotMention?: Maybe<Scalars["Boolean"]>;
    /** Whether or not using the :ticket: emoji in this channel should automatically create Asks. */
    autoCreateOnEmoji?: Maybe<Scalars["Boolean"]>;
    /** Whether or not top-level messages in this channel should automatically create Asks. */
    autoCreateOnMessage?: Maybe<Scalars["Boolean"]>;
    /** The optional template ID to use for Asks auto-created in this channel. If not set, auto-created Asks won't use any template. */
    autoCreateTemplateId?: Maybe<Scalars["String"]>;
    /** Whether or not the Linear Asks bot has been added to this Slack channel. */
    botAdded?: Maybe<Scalars["Boolean"]>;
    /** The Slack channel ID. */
    id: Scalars["String"];
    /** Whether or not the Slack channel is private. */
    isPrivate?: Maybe<Scalars["Boolean"]>;
    /** Whether or not the Slack channel is shared with an external org. */
    isShared?: Maybe<Scalars["Boolean"]>;
    /** The Slack channel name. */
    name: Scalars["String"];
    /** Whether or not synced Slack threads should be updated with a message when their Ask is accepted from triage. */
    postAcceptedFromTriageUpdates?: Maybe<Scalars["Boolean"]>;
    /** Whether or not synced Slack threads should be updated with a message and emoji when their Ask is canceled. */
    postCancellationUpdates?: Maybe<Scalars["Boolean"]>;
    /** Whether or not synced Slack threads should be updated with a message and emoji when their Ask is completed. */
    postCompletionUpdates?: Maybe<Scalars["Boolean"]>;
    /** Which teams are connected to the channel and settings for those teams. */
    teams: Array<SlackAsksTeamSettingsInput>;
};
export declare enum SlackChannelType {
    DirectMessage = "DirectMessage",
    MultiPersonDirectMessage = "MultiPersonDirectMessage",
    Private = "Private",
    Public = "Public"
}
export declare type SlackPostSettingsInput = {
    channel: Scalars["String"];
    channelId: Scalars["String"];
    channelType?: Maybe<SlackChannelType>;
    configurationUrl: Scalars["String"];
    /** Slack workspace id */
    teamId?: Maybe<Scalars["String"]>;
};
export declare type SlackSettingsInput = {
    /** Enterprise id of the connected Slack enterprise */
    enterpriseId?: Maybe<Scalars["String"]>;
    /** Enterprise name of the connected Slack enterprise */
    enterpriseName?: Maybe<Scalars["String"]>;
    /** Whether Linear should automatically respond with issue unfurls when an issue identifier is mentioned in a Slack message. */
    linkOnIssueIdMention: Scalars["Boolean"];
    /** Whether to show unfurl previews in Slack */
    shouldUnfurl?: Maybe<Scalars["Boolean"]>;
    /** Slack workspace id */
    teamId?: Maybe<Scalars["String"]>;
    /** Slack workspace name */
    teamName?: Maybe<Scalars["String"]>;
};
/** Comparator for issue source type. */
export declare type SourceMetadataComparator = {
    /** Equals constraint. */
    eq?: Maybe<Scalars["String"]>;
    /** In-array constraint. */
    in?: Maybe<Array<Scalars["String"]>>;
    /** Not-equals constraint. */
    neq?: Maybe<Scalars["String"]>;
    /** Not-in-array constraint. */
    nin?: Maybe<Array<Scalars["String"]>>;
    /** Null constraint. Matches any non-null values if the given value is false, otherwise it matches null values. */
    null?: Maybe<Scalars["Boolean"]>;
    /** Compound filters, all of which need to be matched by the sub type. */
    subType?: Maybe<SubTypeComparator>;
};
/** Comparator for `sourceType` field. */
export declare type SourceTypeComparator = {
    /** Contains constraint. Matches any values that contain the given string. */
    contains?: Maybe<Scalars["String"]>;
    /** Contains case insensitive constraint. Matches any values that contain the given string case insensitive. */
    containsIgnoreCase?: Maybe<Scalars["String"]>;
    /** Contains case and accent insensitive constraint. Matches any values that contain the given string case and accent insensitive. */
    containsIgnoreCaseAndAccent?: Maybe<Scalars["String"]>;
    /** Ends with constraint. Matches any values that end with the given string. */
    endsWith?: Maybe<Scalars["String"]>;
    /** Equals constraint. */
    eq?: Maybe<Scalars["String"]>;
    /** Equals case insensitive. Matches any values that matches the given string case insensitive. */
    eqIgnoreCase?: Maybe<Scalars["String"]>;
    /** In-array constraint. */
    in?: Maybe<Array<Scalars["String"]>>;
    /** Not-equals constraint. */
    neq?: Maybe<Scalars["String"]>;
    /** Not-equals case insensitive. Matches any values that don't match the given string case insensitive. */
    neqIgnoreCase?: Maybe<Scalars["String"]>;
    /** Not-in-array constraint. */
    nin?: Maybe<Array<Scalars["String"]>>;
    /** Doesn't contain constraint. Matches any values that don't contain the given string. */
    notContains?: Maybe<Scalars["String"]>;
    /** Doesn't contain case insensitive constraint. Matches any values that don't contain the given string case insensitive. */
    notContainsIgnoreCase?: Maybe<Scalars["String"]>;
    /** Doesn't end with constraint. Matches any values that don't end with the given string. */
    notEndsWith?: Maybe<Scalars["String"]>;
    /** Doesn't start with constraint. Matches any values that don't start with the given string. */
    notStartsWith?: Maybe<Scalars["String"]>;
    /** Starts with constraint. Matches any values that start with the given string. */
    startsWith?: Maybe<Scalars["String"]>;
    /** Starts with case insensitive constraint. Matches any values that start with the given string. */
    startsWithIgnoreCase?: Maybe<Scalars["String"]>;
};
export declare type SsoUrlFromEmailResponse = {
    __typename?: "SsoUrlFromEmailResponse";
    /** SAML SSO sign-in URL. */
    samlSsoUrl: Scalars["String"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** Comparator for strings. */
export declare type StringArrayComparator = {
    /** Compound filters, all of which need to be matched. */
    every?: Maybe<StringItemComparator>;
    /** Length of the array. Matches any values that have the given length. */
    length?: Maybe<NumberComparator>;
    /** Compound filters, one of which needs to be matched. */
    some?: Maybe<StringItemComparator>;
};
/** Comparator for strings. */
export declare type StringComparator = {
    /** Contains constraint. Matches any values that contain the given string. */
    contains?: Maybe<Scalars["String"]>;
    /** Contains case insensitive constraint. Matches any values that contain the given string case insensitive. */
    containsIgnoreCase?: Maybe<Scalars["String"]>;
    /** Contains case and accent insensitive constraint. Matches any values that contain the given string case and accent insensitive. */
    containsIgnoreCaseAndAccent?: Maybe<Scalars["String"]>;
    /** Ends with constraint. Matches any values that end with the given string. */
    endsWith?: Maybe<Scalars["String"]>;
    /** Equals constraint. */
    eq?: Maybe<Scalars["String"]>;
    /** Equals case insensitive. Matches any values that matches the given string case insensitive. */
    eqIgnoreCase?: Maybe<Scalars["String"]>;
    /** In-array constraint. */
    in?: Maybe<Array<Scalars["String"]>>;
    /** Not-equals constraint. */
    neq?: Maybe<Scalars["String"]>;
    /** Not-equals case insensitive. Matches any values that don't match the given string case insensitive. */
    neqIgnoreCase?: Maybe<Scalars["String"]>;
    /** Not-in-array constraint. */
    nin?: Maybe<Array<Scalars["String"]>>;
    /** Doesn't contain constraint. Matches any values that don't contain the given string. */
    notContains?: Maybe<Scalars["String"]>;
    /** Doesn't contain case insensitive constraint. Matches any values that don't contain the given string case insensitive. */
    notContainsIgnoreCase?: Maybe<Scalars["String"]>;
    /** Doesn't end with constraint. Matches any values that don't end with the given string. */
    notEndsWith?: Maybe<Scalars["String"]>;
    /** Doesn't start with constraint. Matches any values that don't start with the given string. */
    notStartsWith?: Maybe<Scalars["String"]>;
    /** Starts with constraint. Matches any values that start with the given string. */
    startsWith?: Maybe<Scalars["String"]>;
    /** Starts with case insensitive constraint. Matches any values that start with the given string. */
    startsWithIgnoreCase?: Maybe<Scalars["String"]>;
};
/** Comparator for strings in arrays. */
export declare type StringItemComparator = {
    /** Contains constraint. Matches any values that contain the given string. */
    contains?: Maybe<Scalars["String"]>;
    /** Contains case insensitive constraint. Matches any values that contain the given string case insensitive. */
    containsIgnoreCase?: Maybe<Scalars["String"]>;
    /** Contains case and accent insensitive constraint. Matches any values that contain the given string case and accent insensitive. */
    containsIgnoreCaseAndAccent?: Maybe<Scalars["String"]>;
    /** Ends with constraint. Matches any values that end with the given string. */
    endsWith?: Maybe<Scalars["String"]>;
    /** Equals constraint. */
    eq?: Maybe<Scalars["String"]>;
    /** Equals case insensitive. Matches any values that matches the given string case insensitive. */
    eqIgnoreCase?: Maybe<Scalars["String"]>;
    /** In-array constraint. */
    in?: Maybe<Array<Scalars["String"]>>;
    /** Not-equals constraint. */
    neq?: Maybe<Scalars["String"]>;
    /** Not-equals case insensitive. Matches any values that don't match the given string case insensitive. */
    neqIgnoreCase?: Maybe<Scalars["String"]>;
    /** Not-in-array constraint. */
    nin?: Maybe<Array<Scalars["String"]>>;
    /** Doesn't contain constraint. Matches any values that don't contain the given string. */
    notContains?: Maybe<Scalars["String"]>;
    /** Doesn't contain case insensitive constraint. Matches any values that don't contain the given string case insensitive. */
    notContainsIgnoreCase?: Maybe<Scalars["String"]>;
    /** Doesn't end with constraint. Matches any values that don't end with the given string. */
    notEndsWith?: Maybe<Scalars["String"]>;
    /** Doesn't start with constraint. Matches any values that don't start with the given string. */
    notStartsWith?: Maybe<Scalars["String"]>;
    /** Starts with constraint. Matches any values that start with the given string. */
    startsWith?: Maybe<Scalars["String"]>;
    /** Starts with case insensitive constraint. Matches any values that start with the given string. */
    startsWithIgnoreCase?: Maybe<Scalars["String"]>;
};
/** Comparator for source type. */
export declare type SubTypeComparator = {
    /** Equals constraint. */
    eq?: Maybe<Scalars["String"]>;
    /** In-array constraint. */
    in?: Maybe<Array<Scalars["String"]>>;
    /** Not-equals constraint. */
    neq?: Maybe<Scalars["String"]>;
    /** Not-in-array constraint. */
    nin?: Maybe<Array<Scalars["String"]>>;
    /** Null constraint. Matches any non-null values if the given value is false, otherwise it matches null values. */
    null?: Maybe<Scalars["Boolean"]>;
};
export declare type SuccessPayload = {
    __typename?: "SuccessPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type SummaryPayload = {
    __typename?: "SummaryPayload";
    /** Summary for project updates. */
    summary: Scalars["String"];
};
/** A comment thread that is synced with an external source. */
export declare type SyncedExternalThread = {
    __typename?: "SyncedExternalThread";
    /** The display name of the thread. */
    displayName?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["ID"]>;
    /** Whether this thread is syncing with the external service. */
    isConnected: Scalars["Boolean"];
    /** Whether the current user has the corresponding personal integration connected for the external service. */
    isPersonalIntegrationConnected: Scalars["Boolean"];
    /** Whether a connected personal integration is required to comment in this thread. */
    isPersonalIntegrationRequired: Scalars["Boolean"];
    /** The display name of the source. */
    name?: Maybe<Scalars["String"]>;
    /** The sub type of the external source. */
    subType?: Maybe<Scalars["String"]>;
    /** The type of the external source. */
    type: Scalars["String"];
    /** The external url of the thread. */
    url?: Maybe<Scalars["String"]>;
};
/** An organizational unit that contains issues. */
export declare type Team = Node & {
    __typename?: "Team";
    /** Team's currently active cycle. */
    activeCycle?: Maybe<Cycle>;
    /** Whether to enable resolved thread AI summaries. */
    aiThreadSummariesEnabled: Scalars["Boolean"];
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** Period after which automatically closed and completed issues are automatically archived in months. */
    autoArchivePeriod: Scalars["Float"];
    /** Whether child issues should automatically close when their parent issue is closed */
    autoCloseChildIssues?: Maybe<Scalars["Boolean"]>;
    /** Whether parent issues should automatically close when all child issues are closed */
    autoCloseParentIssues?: Maybe<Scalars["Boolean"]>;
    /** Period after which issues are automatically closed in months. Null/undefined means disabled. */
    autoClosePeriod?: Maybe<Scalars["Float"]>;
    /** The canceled workflow state which auto closed issues will be set to. Defaults to the first canceled state. */
    autoCloseStateId?: Maybe<Scalars["String"]>;
    /** [Internal] The team's sub-teams. */
    children: Array<Team>;
    /** The team's color. */
    color?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** [Internal] The current progress of the team. */
    currentProgress: Scalars["JSONObject"];
    /** Calendar feed URL (iCal) for cycles. */
    cycleCalenderUrl: Scalars["String"];
    /** The cooldown time after each cycle in weeks. */
    cycleCooldownTime: Scalars["Float"];
    /** The duration of a cycle in weeks. */
    cycleDuration: Scalars["Float"];
    /** Auto assign completed issues to current cycle. */
    cycleIssueAutoAssignCompleted: Scalars["Boolean"];
    /** Auto assign started issues to current cycle. */
    cycleIssueAutoAssignStarted: Scalars["Boolean"];
    /** Auto assign issues to current cycle if in active status. */
    cycleLockToActive: Scalars["Boolean"];
    /** The day of the week that a new cycle starts. */
    cycleStartDay: Scalars["Float"];
    /** Cycles associated with the team. */
    cycles: CycleConnection;
    /** Whether the team uses cycles. */
    cyclesEnabled: Scalars["Boolean"];
    /** What to use as a default estimate for unestimated issues. */
    defaultIssueEstimate: Scalars["Float"];
    /** The default workflow state into which issues are set when they are opened by team members. */
    defaultIssueState?: Maybe<WorkflowState>;
    /** The default template to use for new projects created for the team. */
    defaultProjectTemplate?: Maybe<Template>;
    /** The default template to use for new issues created by members of the team. */
    defaultTemplateForMembers?: Maybe<Template>;
    /**
     * The id of the default template to use for new issues created by members of the team.
     * @deprecated Use defaultTemplateForMembers instead
     */
    defaultTemplateForMembersId?: Maybe<Scalars["String"]>;
    /** The default template to use for new issues created by non-members of the team. */
    defaultTemplateForNonMembers?: Maybe<Template>;
    /**
     * The id of the default template to use for new issues created by non-members of the team.
     * @deprecated Use defaultTemplateForNonMembers instead
     */
    defaultTemplateForNonMembersId?: Maybe<Scalars["String"]>;
    /** The team's description. */
    description?: Maybe<Scalars["String"]>;
    /** The name of the team including it's parent team name if it has one. */
    displayName: Scalars["String"];
    /**
     * The workflow state into which issues are moved when a PR has been opened as draft.
     * @deprecated Use team.gitAutomationStates instead.
     */
    draftWorkflowState?: Maybe<WorkflowState>;
    /** [Internal] Facets associated with the team. */
    facets: Array<Facet>;
    /** The Git automation states for the team. */
    gitAutomationStates: GitAutomationStateConnection;
    /** Whether to group recent issue history entries. */
    groupIssueHistory: Scalars["Boolean"];
    /** The icon of the team. */
    icon?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** Whether the team should inherit its estimation settings from its parent. Only applies to sub-teams. */
    inheritIssueEstimation: Scalars["Boolean"];
    /** Whether the team should inherit its workflow statuses from its parent. Only applies to sub-teams. */
    inheritWorkflowStatuses: Scalars["Boolean"];
    /** Settings for all integrations associated with that team. */
    integrationsSettings?: Maybe<IntegrationsSettings>;
    /** Unique hash for the team to be used in invite URLs. */
    inviteHash: Scalars["String"];
    /** Number of issues in the team. */
    issueCount: Scalars["Int"];
    /** Whether to allow zeros in issues estimates. */
    issueEstimationAllowZero: Scalars["Boolean"];
    /** Whether to add additional points to the estimate scale. */
    issueEstimationExtended: Scalars["Boolean"];
    /** The issue estimation type to use. Must be one of "notUsed", "exponential", "fibonacci", "linear", "tShirt". */
    issueEstimationType: Scalars["String"];
    /**
     * [DEPRECATED] Whether issues without priority should be sorted first.
     * @deprecated This setting is no longer in use.
     */
    issueOrderingNoPriorityFirst: Scalars["Boolean"];
    /**
     * [DEPRECATED] Whether to move issues to bottom of the column when changing state.
     * @deprecated Use setIssueSortOrderOnStateChange instead.
     */
    issueSortOrderDefaultToBottom: Scalars["Boolean"];
    /** Issues associated with the team. */
    issues: IssueConnection;
    /** [Internal] Whether new users should join this team by default. */
    joinByDefault?: Maybe<Scalars["Boolean"]>;
    /** The team's unique key. The key is used in URLs. */
    key: Scalars["String"];
    /** Labels associated with the team. */
    labels: IssueLabelConnection;
    /** The workflow state into which issues are moved when they are marked as a duplicate of another issue. Defaults to the first canceled state. */
    markedAsDuplicateWorkflowState?: Maybe<WorkflowState>;
    /** Users who are members of this team. */
    members: UserConnection;
    /** [ALPHA] The membership of the given user in the team. */
    membership?: Maybe<TeamMembership>;
    /** Memberships associated with the team. For easier access of the same data, use `members` query. */
    memberships: TeamMembershipConnection;
    /**
     * The workflow state into which issues are moved when a PR has been merged.
     * @deprecated Use team.gitAutomationStates instead.
     */
    mergeWorkflowState?: Maybe<WorkflowState>;
    /**
     * The workflow state into which issues are moved when a PR is ready to be merged.
     * @deprecated Use team.gitAutomationStates instead.
     */
    mergeableWorkflowState?: Maybe<WorkflowState>;
    /** The team's name. */
    name: Scalars["String"];
    /** The organization that the team is associated with. */
    organization: Organization;
    /** [Internal] The team's parent team. */
    parent?: Maybe<Team>;
    /** [Internal] Posts associated with the team. */
    posts: Array<Post>;
    /** Whether the team is private or not. */
    private: Scalars["Boolean"];
    /** [Internal] The progress history of the team. */
    progressHistory: Scalars["JSONObject"];
    /** Projects associated with the team. */
    projects: ProjectConnection;
    /** Whether an issue needs to have a priority set before leaving triage. */
    requirePriorityToLeaveTriage: Scalars["Boolean"];
    /**
     * The workflow state into which issues are moved when a review has been requested for the PR.
     * @deprecated Use team.gitAutomationStates instead.
     */
    reviewWorkflowState?: Maybe<WorkflowState>;
    /** The SCIM group name for the team. */
    scimGroupName?: Maybe<Scalars["String"]>;
    /** Whether the team is managed by SCIM integration. */
    scimManaged: Scalars["Boolean"];
    /** Where to move issues when changing state. */
    setIssueSortOrderOnStateChange: Scalars["String"];
    /**
     * Whether to send new issue comment notifications to Slack.
     * @deprecated No longer in use
     */
    slackIssueComments: Scalars["Boolean"];
    /**
     * Whether to send new issue status updates to Slack.
     * @deprecated No longer in use
     */
    slackIssueStatuses: Scalars["Boolean"];
    /**
     * Whether to send new issue notifications to Slack.
     * @deprecated No longer is use
     */
    slackNewIssue: Scalars["Boolean"];
    /**
     * The workflow state into which issues are moved when a PR has been opened.
     * @deprecated Use team.gitAutomationStates instead.
     */
    startWorkflowState?: Maybe<WorkflowState>;
    /** The states that define the workflow associated with the team. */
    states: WorkflowStateConnection;
    /** Templates associated with the team. */
    templates: TemplateConnection;
    /** The timezone of the team. Defaults to "America/Los_Angeles" */
    timezone: Scalars["String"];
    /** Whether triage mode is enabled for the team or not. */
    triageEnabled: Scalars["Boolean"];
    /** The workflow state into which issues are set when they are opened by non-team members or integrations if triage is enabled. */
    triageIssueState?: Maybe<WorkflowState>;
    /** Team's triage responsibility. */
    triageResponsibility?: Maybe<TriageResponsibility>;
    /** How many upcoming cycles to create. */
    upcomingCycleCount: Scalars["Float"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** Webhooks associated with the team. */
    webhooks: WebhookConnection;
};
/** An organizational unit that contains issues. */
export declare type TeamCyclesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CycleFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An organizational unit that contains issues. */
export declare type TeamGitAutomationStatesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An organizational unit that contains issues. */
export declare type TeamIssueCountArgs = {
    includeArchived?: Maybe<Scalars["Boolean"]>;
};
/** An organizational unit that contains issues. */
export declare type TeamIssuesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeSubTeams?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An organizational unit that contains issues. */
export declare type TeamLabelsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueLabelFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An organizational unit that contains issues. */
export declare type TeamMembersArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<UserFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeDisabled?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An organizational unit that contains issues. */
export declare type TeamMembershipArgs = {
    userId: Scalars["String"];
};
/** An organizational unit that contains issues. */
export declare type TeamMembershipsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An organizational unit that contains issues. */
export declare type TeamProjectsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeSubTeams?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An organizational unit that contains issues. */
export declare type TeamStatesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<WorkflowStateFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An organizational unit that contains issues. */
export declare type TeamTemplatesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<NullableTemplateFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** An organizational unit that contains issues. */
export declare type TeamWebhooksArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A generic payload return from entity archive mutations. */
export declare type TeamArchivePayload = ArchivePayload & {
    __typename?: "TeamArchivePayload";
    /** The archived/unarchived entity. Null if entity was deleted. */
    entity?: Maybe<Team>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** Team collection filtering options. */
export declare type TeamCollectionFilter = {
    /** Compound filters, all of which need to be matched by the team. */
    and?: Maybe<Array<TeamCollectionFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Filters that needs to be matched by all teams. */
    every?: Maybe<TeamFilter>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the collection length. */
    length?: Maybe<NumberComparator>;
    /** Compound filters, one of which need to be matched by the team. */
    or?: Maybe<Array<TeamCollectionFilter>>;
    /** Filters that needs to be matched by some teams. */
    some?: Maybe<TeamFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type TeamConnection = {
    __typename?: "TeamConnection";
    edges: Array<TeamEdge>;
    nodes: Array<Team>;
    pageInfo: PageInfo;
};
export declare type TeamCreateInput = {
    /** Period after which closed and completed issues are automatically archived, in months. 0 means disabled. */
    autoArchivePeriod?: Maybe<Scalars["Float"]>;
    /** Period after which issues are automatically closed, in months. */
    autoClosePeriod?: Maybe<Scalars["Float"]>;
    /** The canceled workflow state which auto closed issues will be set to. */
    autoCloseStateId?: Maybe<Scalars["String"]>;
    /** The color of the team. */
    color?: Maybe<Scalars["String"]>;
    /** The cooldown time after each cycle in weeks. */
    cycleCooldownTime?: Maybe<Scalars["Int"]>;
    /** The duration of each cycle in weeks. */
    cycleDuration?: Maybe<Scalars["Int"]>;
    /** Auto assign completed issues to current active cycle setting. */
    cycleIssueAutoAssignCompleted?: Maybe<Scalars["Boolean"]>;
    /** Auto assign started issues to current active cycle setting. */
    cycleIssueAutoAssignStarted?: Maybe<Scalars["Boolean"]>;
    /** Only allow issues issues with cycles in Active Issues. */
    cycleLockToActive?: Maybe<Scalars["Boolean"]>;
    /** The day of the week that a new cycle starts. */
    cycleStartDay?: Maybe<Scalars["Float"]>;
    /** Whether the team uses cycles. */
    cyclesEnabled?: Maybe<Scalars["Boolean"]>;
    /** What to use as an default estimate for unestimated issues. */
    defaultIssueEstimate?: Maybe<Scalars["Float"]>;
    /** The identifier of the default project template of this team. */
    defaultProjectTemplateId?: Maybe<Scalars["String"]>;
    /** The identifier of the default template for members of this team. */
    defaultTemplateForMembersId?: Maybe<Scalars["String"]>;
    /** The identifier of the default template for non-members of this team. */
    defaultTemplateForNonMembersId?: Maybe<Scalars["String"]>;
    /** The description of the team. */
    description?: Maybe<Scalars["String"]>;
    /** Whether to group recent issue history entries. */
    groupIssueHistory?: Maybe<Scalars["Boolean"]>;
    /** The icon of the team. */
    icon?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** Whether the team should inherit estimation settings from its parent. Only applies to sub-teams. */
    inheritIssueEstimation?: Maybe<Scalars["Boolean"]>;
    /** [Internal] Whether the team should inherit workflow statuses from its parent. */
    inheritWorkflowStatuses?: Maybe<Scalars["Boolean"]>;
    /** Whether to allow zeros in issues estimates. */
    issueEstimationAllowZero?: Maybe<Scalars["Boolean"]>;
    /** Whether to add additional points to the estimate scale. */
    issueEstimationExtended?: Maybe<Scalars["Boolean"]>;
    /** The issue estimation type to use. Must be one of "notUsed", "exponential", "fibonacci", "linear", "tShirt". */
    issueEstimationType?: Maybe<Scalars["String"]>;
    /** The key of the team. If not given, the key will be generated based on the name of the team. */
    key?: Maybe<Scalars["String"]>;
    /** The workflow state into which issues are moved when they are marked as a duplicate of another issue. */
    markedAsDuplicateWorkflowStateId?: Maybe<Scalars["String"]>;
    /** The name of the team. */
    name: Scalars["String"];
    /** The parent team ID. */
    parentId?: Maybe<Scalars["String"]>;
    /** Internal. Whether the team is private or not. */
    private?: Maybe<Scalars["Boolean"]>;
    /** [Internal] The scope of product intelligence suggestion data for the team. */
    productIntelligenceScope?: Maybe<ProductIntelligenceScope>;
    /** Whether an issue needs to have a priority set before leaving triage. */
    requirePriorityToLeaveTriage?: Maybe<Scalars["Boolean"]>;
    /** Whether to move issues to bottom of the column when changing state. */
    setIssueSortOrderOnStateChange?: Maybe<Scalars["String"]>;
    /** The timezone of the team. */
    timezone?: Maybe<Scalars["String"]>;
    /** Whether triage mode is enabled for the team. */
    triageEnabled?: Maybe<Scalars["Boolean"]>;
    /** How many upcoming cycles to create. */
    upcomingCycleCount?: Maybe<Scalars["Float"]>;
};
export declare type TeamEdge = {
    __typename?: "TeamEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: Team;
};
/** Team filtering options. */
export declare type TeamFilter = {
    /** Compound filters, all of which need to be matched by the team. */
    and?: Maybe<Array<TeamFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the team description. */
    description?: Maybe<NullableStringComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Filters that the teams issues must satisfy. */
    issues?: Maybe<IssueCollectionFilter>;
    /** Comparator for the team key. */
    key?: Maybe<StringComparator>;
    /** Comparator for the team name. */
    name?: Maybe<StringComparator>;
    /** Compound filters, one of which need to be matched by the team. */
    or?: Maybe<Array<TeamFilter>>;
    /** Filters that the teams parent must satisfy. */
    parent?: Maybe<NullableTeamFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** Defines the membership of a user to a team. */
export declare type TeamMembership = Node & {
    __typename?: "TeamMembership";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** Whether the user is the owner of the team. */
    owner: Scalars["Boolean"];
    /** The order of the item in the users team list. */
    sortOrder: Scalars["Float"];
    /** The team that the membership is associated with. */
    team: Team;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The user that the membership is associated with. */
    user: User;
};
export declare type TeamMembershipConnection = {
    __typename?: "TeamMembershipConnection";
    edges: Array<TeamMembershipEdge>;
    nodes: Array<TeamMembership>;
    pageInfo: PageInfo;
};
export declare type TeamMembershipCreateInput = {
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** Internal. Whether the user is the owner of the team. */
    owner?: Maybe<Scalars["Boolean"]>;
    /** The position of the item in the users list. */
    sortOrder?: Maybe<Scalars["Float"]>;
    /** The identifier of the team associated with the membership. */
    teamId: Scalars["String"];
    /** The identifier of the user associated with the membership. */
    userId: Scalars["String"];
};
export declare type TeamMembershipEdge = {
    __typename?: "TeamMembershipEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: TeamMembership;
};
export declare type TeamMembershipPayload = {
    __typename?: "TeamMembershipPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
    /** The team membership that was created or updated. */
    teamMembership?: Maybe<TeamMembership>;
};
export declare type TeamMembershipUpdateInput = {
    /** Internal. Whether the user is the owner of the team. */
    owner?: Maybe<Scalars["Boolean"]>;
    /** The position of the item in the users list. */
    sortOrder?: Maybe<Scalars["Float"]>;
};
/** A team notification subscription. */
export declare type TeamNotificationSubscription = Entity & Node & NotificationSubscription & {
    __typename?: "TeamNotificationSubscription";
    /** Whether the subscription is active or not. */
    active: Scalars["Boolean"];
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The type of view to which the notification subscription context is associated with. */
    contextViewType?: Maybe<ContextViewType>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The contextual custom view associated with the notification subscription. */
    customView?: Maybe<CustomView>;
    /** The customer associated with the notification subscription. */
    customer?: Maybe<Customer>;
    /** The contextual cycle view associated with the notification subscription. */
    cycle?: Maybe<Cycle>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The contextual initiative view associated with the notification subscription. */
    initiative?: Maybe<Initiative>;
    /** The contextual label view associated with the notification subscription. */
    label?: Maybe<IssueLabel>;
    /** The type of subscription. */
    notificationSubscriptionTypes: Array<Scalars["String"]>;
    /** The contextual project view associated with the notification subscription. */
    project?: Maybe<Project>;
    /** The user that subscribed to receive notifications. */
    subscriber: User;
    /** The team subscribed to. */
    team: Team;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The user view associated with the notification subscription. */
    user?: Maybe<User>;
    /** The type of user view to which the notification subscription context is associated with. */
    userContextViewType?: Maybe<UserContextViewType>;
};
export declare type TeamPayload = {
    __typename?: "TeamPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
    /** The team that was created or updated. */
    team?: Maybe<Team>;
};
/** Issue team sorting options. */
export declare type TeamSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
export declare type TeamUpdateInput = {
    /** Whether to enable resolved thread AI summaries. */
    aiThreadSummariesEnabled?: Maybe<Scalars["Boolean"]>;
    /** Period after which closed and completed issues are automatically archived, in months. */
    autoArchivePeriod?: Maybe<Scalars["Float"]>;
    /** [INTERNAL] Whether to automatically close all sub-issues when a parent issue in this team is closed. */
    autoCloseChildIssues?: Maybe<Scalars["Boolean"]>;
    /** [INTERNAL] Whether to automatically close a parent issue in this team if all its sub-issues are closed. */
    autoCloseParentIssues?: Maybe<Scalars["Boolean"]>;
    /** Period after which issues are automatically closed, in months. */
    autoClosePeriod?: Maybe<Scalars["Float"]>;
    /** The canceled workflow state which auto closed issues will be set to. */
    autoCloseStateId?: Maybe<Scalars["String"]>;
    /** The color of the team. */
    color?: Maybe<Scalars["String"]>;
    /** The cooldown time after each cycle in weeks. */
    cycleCooldownTime?: Maybe<Scalars["Int"]>;
    /** The duration of each cycle in weeks. */
    cycleDuration?: Maybe<Scalars["Int"]>;
    /** The date to begin cycles on. */
    cycleEnabledStartDate?: Maybe<Scalars["DateTime"]>;
    /** Auto assign completed issues to current active cycle setting. */
    cycleIssueAutoAssignCompleted?: Maybe<Scalars["Boolean"]>;
    /** Auto assign started issues to current active cycle setting. */
    cycleIssueAutoAssignStarted?: Maybe<Scalars["Boolean"]>;
    /** Only allow issues with cycles in Active Issues. */
    cycleLockToActive?: Maybe<Scalars["Boolean"]>;
    /** The day of the week that a new cycle starts. */
    cycleStartDay?: Maybe<Scalars["Float"]>;
    /** Whether the team uses cycles. */
    cyclesEnabled?: Maybe<Scalars["Boolean"]>;
    /** What to use as an default estimate for unestimated issues. */
    defaultIssueEstimate?: Maybe<Scalars["Float"]>;
    /** Default status for newly created issues. */
    defaultIssueStateId?: Maybe<Scalars["String"]>;
    /** The identifier of the default project template of this team. */
    defaultProjectTemplateId?: Maybe<Scalars["String"]>;
    /** The identifier of the default template for members of this team. */
    defaultTemplateForMembersId?: Maybe<Scalars["String"]>;
    /** The identifier of the default template for non-members of this team. */
    defaultTemplateForNonMembersId?: Maybe<Scalars["String"]>;
    /** The description of the team. */
    description?: Maybe<Scalars["String"]>;
    /** Whether to group recent issue history entries. */
    groupIssueHistory?: Maybe<Scalars["Boolean"]>;
    /** The icon of the team. */
    icon?: Maybe<Scalars["String"]>;
    /** Whether the team should inherit estimation settings from its parent. Only applies to sub-teams. */
    inheritIssueEstimation?: Maybe<Scalars["Boolean"]>;
    /** [Internal] Whether the team should inherit workflow statuses from its parent. */
    inheritWorkflowStatuses?: Maybe<Scalars["Boolean"]>;
    /** Whether to allow zeros in issues estimates. */
    issueEstimationAllowZero?: Maybe<Scalars["Boolean"]>;
    /** Whether to add additional points to the estimate scale. */
    issueEstimationExtended?: Maybe<Scalars["Boolean"]>;
    /** The issue estimation type to use. Must be one of "notUsed", "exponential", "fibonacci", "linear", "tShirt". */
    issueEstimationType?: Maybe<Scalars["String"]>;
    /** Whether new users should join this team by default. Mutation restricted to workspace admins! */
    joinByDefault?: Maybe<Scalars["Boolean"]>;
    /** The key of the team. */
    key?: Maybe<Scalars["String"]>;
    /** The workflow state into which issues are moved when they are marked as a duplicate of another issue. */
    markedAsDuplicateWorkflowStateId?: Maybe<Scalars["String"]>;
    /** The name of the team. */
    name?: Maybe<Scalars["String"]>;
    /** The parent team ID. */
    parentId?: Maybe<Scalars["String"]>;
    /** Whether the team is private or not. */
    private?: Maybe<Scalars["Boolean"]>;
    /** [Internal] The scope of product intelligence suggestion data for the team. */
    productIntelligenceScope?: Maybe<ProductIntelligenceScope>;
    /** Whether an issue needs to have a priority set before leaving triage. */
    requirePriorityToLeaveTriage?: Maybe<Scalars["Boolean"]>;
    /** Whether the team is managed by SCIM integration. Mutation restricted to workspace admins and only unsetting is allowed! */
    scimManaged?: Maybe<Scalars["Boolean"]>;
    /** Whether to move issues to bottom of the column when changing state. */
    setIssueSortOrderOnStateChange?: Maybe<Scalars["String"]>;
    /** Whether to send new issue comment notifications to Slack. */
    slackIssueComments?: Maybe<Scalars["Boolean"]>;
    /** Whether to send issue status update notifications to Slack. */
    slackIssueStatuses?: Maybe<Scalars["Boolean"]>;
    /** Whether to send new issue notifications to Slack. */
    slackNewIssue?: Maybe<Scalars["Boolean"]>;
    /** The timezone of the team. */
    timezone?: Maybe<Scalars["String"]>;
    /** Whether triage mode is enabled for the team. */
    triageEnabled?: Maybe<Scalars["Boolean"]>;
    /** How many upcoming cycles to create. */
    upcomingCycleCount?: Maybe<Scalars["Float"]>;
};
/** A template object used for creating entities faster. */
export declare type Template = Node & {
    __typename?: "Template";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who created the template. */
    creator?: Maybe<User>;
    /** Template description. */
    description?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The original template inherited from. */
    inheritedFrom?: Maybe<Template>;
    /** The user who last updated the template. */
    lastUpdatedBy?: Maybe<User>;
    /** The name of the template. */
    name: Scalars["String"];
    /** The organization that the template is associated with. If null, the template is associated with a particular team. */
    organization: Organization;
    /** The sort order of the template. */
    sortOrder: Scalars["Float"];
    /** The team that the template is associated with. If null, the template is global to the workspace. */
    team?: Maybe<Team>;
    /** Template data. */
    templateData: Scalars["JSON"];
    /** The entity type this template is for. */
    type: Scalars["String"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type TemplateConnection = {
    __typename?: "TemplateConnection";
    edges: Array<TemplateEdge>;
    nodes: Array<Template>;
    pageInfo: PageInfo;
};
export declare type TemplateCreateInput = {
    /** The template description. */
    description?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The template name. */
    name: Scalars["String"];
    /** The position of the template in the templates list. */
    sortOrder?: Maybe<Scalars["Float"]>;
    /** The identifier or key of the team associated with the template. If not given, the template will be shared across all teams. */
    teamId?: Maybe<Scalars["String"]>;
    /** The template data as JSON encoded attributes of the type of entity, such as an issue. */
    templateData: Scalars["JSON"];
    /** The template type, e.g. 'issue'. */
    type: Scalars["String"];
};
export declare type TemplateEdge = {
    __typename?: "TemplateEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: Template;
};
export declare type TemplatePayload = {
    __typename?: "TemplatePayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
    /** The template that was created or updated. */
    template: Template;
};
export declare type TemplateUpdateInput = {
    /** The template description. */
    description?: Maybe<Scalars["String"]>;
    /** The template name. */
    name?: Maybe<Scalars["String"]>;
    /** The position of the template in the templates list. */
    sortOrder?: Maybe<Scalars["Float"]>;
    /** The identifier or key of the team associated with the template. If set to null, the template will be shared across all teams. */
    teamId?: Maybe<Scalars["String"]>;
    /** The template data as JSON encoded attributes of the type of entity, such as an issue. */
    templateData?: Maybe<Scalars["JSON"]>;
};
/** Customer tier sorting options. */
export declare type TierSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
/** A time schedule. */
export declare type TimeSchedule = Node & {
    __typename?: "TimeSchedule";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The schedule entries. */
    entries?: Maybe<Array<TimeScheduleEntry>>;
    /** The identifier of the external schedule. */
    externalId?: Maybe<Scalars["String"]>;
    /** The URL to the external schedule. */
    externalUrl?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The identifier of the Linear integration populating the schedule. */
    integration?: Maybe<Integration>;
    /** The name of the schedule. */
    name: Scalars["String"];
    /** The organization of the schedule. */
    organization: Organization;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
export declare type TimeScheduleConnection = {
    __typename?: "TimeScheduleConnection";
    edges: Array<TimeScheduleEdge>;
    nodes: Array<TimeSchedule>;
    pageInfo: PageInfo;
};
export declare type TimeScheduleCreateInput = {
    /** The schedule entries. */
    entries: Array<TimeScheduleEntryInput>;
    /** The unique identifier of the external schedule. */
    externalId?: Maybe<Scalars["String"]>;
    /** The URL to the external schedule. */
    externalUrl?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The name of the schedule. */
    name: Scalars["String"];
};
export declare type TimeScheduleEdge = {
    __typename?: "TimeScheduleEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: TimeSchedule;
};
export declare type TimeScheduleEntry = {
    __typename?: "TimeScheduleEntry";
    /** The end date of the schedule in ISO 8601 date-time format. */
    endsAt: Scalars["DateTime"];
    /** The start date of the schedule in ISO 8601 date-time format. */
    startsAt: Scalars["DateTime"];
    /** The email, name or reference to the user on schedule. This is used in case the external user could not be mapped to a Linear user id. */
    userEmail?: Maybe<Scalars["String"]>;
    /** The Linear user id of the user on schedule. If the user cannot be mapped to a Linear user then `userEmail` can be used as a reference. */
    userId?: Maybe<Scalars["String"]>;
};
export declare type TimeScheduleEntryInput = {
    /** The end date of the schedule in ISO 8601 date-time format. */
    endsAt: Scalars["DateTime"];
    /** The start date of the schedule in ISO 8601 date-time format. */
    startsAt: Scalars["DateTime"];
    /** The email, name or reference to the user on schedule. This is used in case the external user could not be mapped to a Linear user id. */
    userEmail?: Maybe<Scalars["String"]>;
    /** The Linear user id of the user on schedule. If the user cannot be mapped to a Linear user then `userEmail` can be used as a reference. */
    userId?: Maybe<Scalars["String"]>;
};
export declare type TimeSchedulePayload = {
    __typename?: "TimeSchedulePayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
    timeSchedule: TimeSchedule;
};
export declare type TimeScheduleUpdateInput = {
    /** The schedule entries. */
    entries?: Maybe<Array<TimeScheduleEntryInput>>;
    /** The unique identifier of the external schedule. */
    externalId?: Maybe<Scalars["String"]>;
    /** The URL to the external schedule. */
    externalUrl?: Maybe<Scalars["String"]>;
    /** The name of the schedule. */
    name?: Maybe<Scalars["String"]>;
};
/** Issue title sorting options. */
export declare type TitleSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
export declare type TokenUserAccountAuthInput = {
    /** The email which to login via the magic login code. */
    email: Scalars["String"];
    /** An optional invite link for an organization. */
    inviteLink?: Maybe<Scalars["String"]>;
    /** The timezone of the user's browser. */
    timezone: Scalars["String"];
    /** The magic login code. */
    token: Scalars["String"];
};
/** A team's triage responsibility. */
export declare type TriageResponsibility = Node & {
    __typename?: "TriageResponsibility";
    /** The action to take when an issue is added to triage. */
    action: TriageResponsibilityAction;
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user currently responsible for triage. */
    currentUser?: Maybe<User>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** Set of users used for triage responsibility. */
    manualSelection?: Maybe<TriageResponsibilityManualSelection>;
    /** The team to which the triage responsibility belongs to. */
    team: Team;
    /** The time schedule used for scheduling. */
    timeSchedule?: Maybe<TimeSchedule>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
/** Which action should be taken after an issue is added to triage. */
export declare enum TriageResponsibilityAction {
    Assign = "assign",
    Notify = "notify"
}
export declare type TriageResponsibilityConnection = {
    __typename?: "TriageResponsibilityConnection";
    edges: Array<TriageResponsibilityEdge>;
    nodes: Array<TriageResponsibility>;
    pageInfo: PageInfo;
};
export declare type TriageResponsibilityCreateInput = {
    /** The action to take when an issue is added to triage. */
    action: Scalars["String"];
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The manual selection of users responsible for triage. */
    manualSelection?: Maybe<TriageResponsibilityManualSelectionInput>;
    /** The identifier of the team associated with the triage responsibility. */
    teamId: Scalars["String"];
    /** The identifier of the time schedule used for scheduling triage responsibility */
    timeScheduleId?: Maybe<Scalars["String"]>;
};
export declare type TriageResponsibilityEdge = {
    __typename?: "TriageResponsibilityEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: TriageResponsibility;
};
export declare type TriageResponsibilityManualSelection = {
    __typename?: "TriageResponsibilityManualSelection";
    /** [Internal] The index of the current userId used for the assign action when having more than one user. */
    assignmentIndex?: Maybe<Scalars["Int"]>;
    /** The set of users responsible for triage. */
    userIds: Array<Scalars["String"]>;
};
/** Manual triage responsibility using a set of users. */
export declare type TriageResponsibilityManualSelectionInput = {
    /** [Internal] The index of the current userId used for the assign action when having more than one user. */
    assignmentIndex?: Maybe<Scalars["Int"]>;
    /** The set of users responsible for triage. */
    userIds: Array<Scalars["String"]>;
};
export declare type TriageResponsibilityPayload = {
    __typename?: "TriageResponsibilityPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
    triageResponsibility: TriageResponsibility;
};
export declare type TriageResponsibilityUpdateInput = {
    /** The action to take when an issue is added to triage. */
    action?: Maybe<Scalars["String"]>;
    /** The manual selection of users responsible for triage. */
    manualSelection?: Maybe<TriageResponsibilityManualSelectionInput>;
    /** The identifier of the time schedule used for scheduling triage responsibility. */
    timeScheduleId?: Maybe<Scalars["String"]>;
};
/** Issue update date sorting options. */
export declare type UpdatedAtSort = {
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
/** Object representing Google Cloud upload policy, plus additional data. */
export declare type UploadFile = {
    __typename?: "UploadFile";
    /** The asset URL for the uploaded file. (assigned automatically). */
    assetUrl: Scalars["String"];
    /** The content type. */
    contentType: Scalars["String"];
    /** The filename. */
    filename: Scalars["String"];
    headers: Array<UploadFileHeader>;
    metaData?: Maybe<Scalars["JSONObject"]>;
    /** The size of the uploaded file. */
    size: Scalars["Int"];
    /** The signed URL the for the uploaded file. (assigned automatically). */
    uploadUrl: Scalars["String"];
};
export declare type UploadFileHeader = {
    __typename?: "UploadFileHeader";
    /** Upload file header key. */
    key: Scalars["String"];
    /** Upload file header value. */
    value: Scalars["String"];
};
export declare type UploadPayload = {
    __typename?: "UploadPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
    /** Object describing the file to be uploaded. */
    uploadFile?: Maybe<UploadFile>;
};
/** A user that has access to the the resources of an organization. */
export declare type User = Node & {
    __typename?: "User";
    /** Whether the user account is active or disabled (suspended). */
    active: Scalars["Boolean"];
    /** Whether the user is an organization administrator. */
    admin: Scalars["Boolean"];
    /** Whether the user is an app. */
    app: Scalars["Boolean"];
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** Issues assigned to the user. */
    assignedIssues: IssueConnection;
    /** The background color of the avatar for users without set avatar. */
    avatarBackgroundColor: Scalars["String"];
    /** An URL to the user's avatar image. */
    avatarUrl?: Maybe<Scalars["String"]>;
    /** [DEPRECATED] Hash for the user to be used in calendar URLs. */
    calendarHash?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** Number of issues created. */
    createdIssueCount: Scalars["Int"];
    /** Issues created by the user. */
    createdIssues: IssueConnection;
    /** A short description of the user, either its title or bio. */
    description?: Maybe<Scalars["String"]>;
    /** Reason why is the account disabled. */
    disableReason?: Maybe<Scalars["String"]>;
    /** The user's display (nick) name. Unique within each organization. */
    displayName: Scalars["String"];
    /** The user's drafts */
    drafts: DraftConnection;
    /** The user's email address. */
    email: Scalars["String"];
    /** Whether the user is a guest in the workspace and limited to accessing a subset of teams. */
    guest: Scalars["Boolean"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The initials of the user. */
    initials: Scalars["String"];
    /** Unique hash for the user to be used in invite URLs. */
    inviteHash: Scalars["String"];
    /** Whether the user is the currently authenticated user. */
    isMe: Scalars["Boolean"];
    /** The user's issue drafts */
    issueDrafts: IssueDraftConnection;
    /** The last time the user was seen online. */
    lastSeen?: Maybe<Scalars["DateTime"]>;
    /** The user's full name. */
    name: Scalars["String"];
    /** Organization the user belongs to. */
    organization: Organization;
    /** The emoji to represent the user current status. */
    statusEmoji?: Maybe<Scalars["String"]>;
    /** The label of the user current status. */
    statusLabel?: Maybe<Scalars["String"]>;
    /** A date at which the user current status should be cleared. */
    statusUntilAt?: Maybe<Scalars["DateTime"]>;
    /** Memberships associated with the user. For easier access of the same data, use `teams` query. */
    teamMemberships: TeamMembershipConnection;
    /** Teams the user is part of. */
    teams: TeamConnection;
    /** The local timezone of the user. */
    timezone?: Maybe<Scalars["String"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** User's profile URL. */
    url: Scalars["String"];
};
/** A user that has access to the the resources of an organization. */
export declare type UserAssignedIssuesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A user that has access to the the resources of an organization. */
export declare type UserCreatedIssuesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A user that has access to the the resources of an organization. */
export declare type UserDraftsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A user that has access to the the resources of an organization. */
export declare type UserIssueDraftsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A user that has access to the the resources of an organization. */
export declare type UserTeamMembershipsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A user that has access to the the resources of an organization. */
export declare type UserTeamsArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<TeamFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
export declare type UserAdminPayload = {
    __typename?: "UserAdminPayload";
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
/** Public information of the OAuth application, plus whether the application has been authorized for the given scopes. */
export declare type UserAuthorizedApplication = {
    __typename?: "UserAuthorizedApplication";
    /** Details of the app user's existing token, if any. */
    appUserAuthentication?: Maybe<AppUserAuthentication>;
    /** Error associated with the application needing to be requested for approval in the workspace. */
    approvalErrorCode?: Maybe<Scalars["String"]>;
    /** OAuth application's client ID. */
    clientId: Scalars["String"];
    /** Whether the application was created by Linear. */
    createdByLinear: Scalars["Boolean"];
    /** Information about the application. */
    description?: Maybe<Scalars["String"]>;
    /** Name of the developer. */
    developer: Scalars["String"];
    /** Url of the developer (homepage or docs). */
    developerUrl: Scalars["String"];
    /** OAuth application's ID. */
    id: Scalars["String"];
    /** Image of the application. */
    imageUrl?: Maybe<Scalars["String"]>;
    /** Whether the user has authorized the application for the given scopes. */
    isAuthorized: Scalars["Boolean"];
    /** Application name. */
    name: Scalars["String"];
    /** Whether or not webhooks are enabled for the application. */
    webhooksEnabled: Scalars["Boolean"];
};
/** User filtering options. */
export declare type UserCollectionFilter = {
    /** Comparator for the user's activity status. */
    active?: Maybe<BooleanComparator>;
    /** Comparator for the user's admin status. */
    admin?: Maybe<BooleanComparator>;
    /** Compound filters, all of which need to be matched by the user. */
    and?: Maybe<Array<UserCollectionFilter>>;
    /** Comparator for the user's app status. */
    app?: Maybe<BooleanComparator>;
    /** Filters that the users assigned issues must satisfy. */
    assignedIssues?: Maybe<IssueCollectionFilter>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the user's display name. */
    displayName?: Maybe<StringComparator>;
    /** Comparator for the user's email. */
    email?: Maybe<StringComparator>;
    /** Filters that needs to be matched by all users. */
    every?: Maybe<UserFilter>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the user's invited status. */
    invited?: Maybe<BooleanComparator>;
    /** Filter based on the currently authenticated user. Set to true to filter for the authenticated user, false for any other user. */
    isMe?: Maybe<BooleanComparator>;
    /** Comparator for the collection length. */
    length?: Maybe<NumberComparator>;
    /** Comparator for the user's name. */
    name?: Maybe<StringComparator>;
    /** Compound filters, one of which need to be matched by the user. */
    or?: Maybe<Array<UserCollectionFilter>>;
    /** Filters that needs to be matched by some users. */
    some?: Maybe<UserFilter>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type UserConnection = {
    __typename?: "UserConnection";
    edges: Array<UserEdge>;
    nodes: Array<User>;
    pageInfo: PageInfo;
};
export declare enum UserContextViewType {
    Assigned = "assigned"
}
export declare type UserEdge = {
    __typename?: "UserEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: User;
};
/** User filtering options. */
export declare type UserFilter = {
    /** Comparator for the user's activity status. */
    active?: Maybe<BooleanComparator>;
    /** Comparator for the user's admin status. */
    admin?: Maybe<BooleanComparator>;
    /** Compound filters, all of which need to be matched by the user. */
    and?: Maybe<Array<UserFilter>>;
    /** Comparator for the user's app status. */
    app?: Maybe<BooleanComparator>;
    /** Filters that the users assigned issues must satisfy. */
    assignedIssues?: Maybe<IssueCollectionFilter>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the user's display name. */
    displayName?: Maybe<StringComparator>;
    /** Comparator for the user's email. */
    email?: Maybe<StringComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Comparator for the user's invited status. */
    invited?: Maybe<BooleanComparator>;
    /** Filter based on the currently authenticated user. Set to true to filter for the authenticated user, false for any other user. */
    isMe?: Maybe<BooleanComparator>;
    /** Comparator for the user's name. */
    name?: Maybe<StringComparator>;
    /** Compound filters, one of which need to be matched by the user. */
    or?: Maybe<Array<UserFilter>>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
/** The types of flags that the user can have. */
export declare enum UserFlagType {
    All = "all",
    AnalyticsWelcomeDismissed = "analyticsWelcomeDismissed",
    CanPlaySnake = "canPlaySnake",
    CanPlayTetris = "canPlayTetris",
    CommandMenuClearShortcutTip = "commandMenuClearShortcutTip",
    CompletedOnboarding = "completedOnboarding",
    CycleWelcomeDismissed = "cycleWelcomeDismissed",
    DesktopDownloadToastDismissed = "desktopDownloadToastDismissed",
    DesktopInstalled = "desktopInstalled",
    DesktopTabsOnboardingDismissed = "desktopTabsOnboardingDismissed",
    DueDateShortcutMigration = "dueDateShortcutMigration",
    EditorSlashCommandUsed = "editorSlashCommandUsed",
    EmptyActiveIssuesDismissed = "emptyActiveIssuesDismissed",
    EmptyBacklogDismissed = "emptyBacklogDismissed",
    EmptyCustomViewsDismissed = "emptyCustomViewsDismissed",
    EmptyMyIssuesDismissed = "emptyMyIssuesDismissed",
    EmptyParagraphSlashCommandTip = "emptyParagraphSlashCommandTip",
    FigmaPluginBannerDismissed = "figmaPluginBannerDismissed",
    FigmaPromptDismissed = "figmaPromptDismissed",
    HelpIslandFeatureInsightsDismissed = "helpIslandFeatureInsightsDismissed",
    ImportBannerDismissed = "importBannerDismissed",
    InitiativesBannerDismissed = "initiativesBannerDismissed",
    InsightsHelpDismissed = "insightsHelpDismissed",
    InsightsWelcomeDismissed = "insightsWelcomeDismissed",
    IssueLabelSuggestionUsed = "issueLabelSuggestionUsed",
    IssueMovePromptCompleted = "issueMovePromptCompleted",
    JoinTeamIntroductionDismissed = "joinTeamIntroductionDismissed",
    ListSelectionTip = "listSelectionTip",
    MigrateThemePreference = "migrateThemePreference",
    MilestoneOnboardingIsSeenAndDismissed = "milestoneOnboardingIsSeenAndDismissed",
    ProjectBacklogWelcomeDismissed = "projectBacklogWelcomeDismissed",
    ProjectBoardOnboardingIsSeenAndDismissed = "projectBoardOnboardingIsSeenAndDismissed",
    ProjectUpdatesWelcomeDismissed = "projectUpdatesWelcomeDismissed",
    ProjectWelcomeDismissed = "projectWelcomeDismissed",
    PulseWelcomeDismissed = "pulseWelcomeDismissed",
    RewindBannerDismissed = "rewindBannerDismissed",
    SlackCommentReactionTipShown = "slackCommentReactionTipShown",
    TeamsPageIntroductionDismissed = "teamsPageIntroductionDismissed",
    ThreadedCommentsNudgeIsSeen = "threadedCommentsNudgeIsSeen",
    TriageWelcomeDismissed = "triageWelcomeDismissed",
    TryCyclesDismissed = "tryCyclesDismissed",
    TryGithubDismissed = "tryGithubDismissed",
    TryInvitePeopleDismissed = "tryInvitePeopleDismissed",
    TryRoadmapsDismissed = "tryRoadmapsDismissed",
    TryTriageDismissed = "tryTriageDismissed",
    UpdatedSlackThreadSyncIntegration = "updatedSlackThreadSyncIntegration"
}
/** Operations that can be applied to UserFlagType. */
export declare enum UserFlagUpdateOperation {
    Clear = "clear",
    Decr = "decr",
    Incr = "incr",
    Lock = "lock"
}
/** A user notification subscription. */
export declare type UserNotificationSubscription = Entity & Node & NotificationSubscription & {
    __typename?: "UserNotificationSubscription";
    /** Whether the subscription is active or not. */
    active: Scalars["Boolean"];
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The type of view to which the notification subscription context is associated with. */
    contextViewType?: Maybe<ContextViewType>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The contextual custom view associated with the notification subscription. */
    customView?: Maybe<CustomView>;
    /** The customer associated with the notification subscription. */
    customer?: Maybe<Customer>;
    /** The contextual cycle view associated with the notification subscription. */
    cycle?: Maybe<Cycle>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The contextual initiative view associated with the notification subscription. */
    initiative?: Maybe<Initiative>;
    /** The contextual label view associated with the notification subscription. */
    label?: Maybe<IssueLabel>;
    /** The type of subscription. */
    notificationSubscriptionTypes: Array<Scalars["String"]>;
    /** The contextual project view associated with the notification subscription. */
    project?: Maybe<Project>;
    /** The user that subscribed to receive notifications. */
    subscriber: User;
    /** The team associated with the notification subscription. */
    team?: Maybe<Team>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The user subscribed to. */
    user: User;
    /** The type of user view to which the notification subscription context is associated with. */
    userContextViewType?: Maybe<UserContextViewType>;
};
export declare type UserPayload = {
    __typename?: "UserPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
    /** The user that was created or updated. */
    user?: Maybe<User>;
};
/** The different permission roles available to users on an organization. */
export declare enum UserRoleType {
    Admin = "admin",
    App = "app",
    Guest = "guest",
    User = "user"
}
/** The settings of a user as a JSON object. */
export declare type UserSettings = Node & {
    __typename?: "UserSettings";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** Whether to auto-assign newly created issues to the current user by default. */
    autoAssignToSelf: Scalars["Boolean"];
    /** Hash for the user to be used in calendar URLs. */
    calendarHash?: Maybe<Scalars["String"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The user's notification category preferences. */
    notificationCategoryPreferences: NotificationCategoryPreferences;
    /** The user's notification channel preferences. */
    notificationChannelPreferences: NotificationChannelPreferences;
    /** The notification delivery preferences for the user. Note: notificationDisabled field is deprecated in favor of notificationChannelPreferences. */
    notificationDeliveryPreferences: NotificationDeliveryPreferences;
    /** Whether to show full user names instead of display names. */
    showFullUserNames: Scalars["Boolean"];
    /** Whether this user is subscribed to changelog email or not. */
    subscribedToChangelog: Scalars["Boolean"];
    /** Whether this user is subscribed to DPA emails or not. */
    subscribedToDPA: Scalars["Boolean"];
    /** Whether this user is subscribed to invite accepted emails or not. */
    subscribedToInviteAccepted: Scalars["Boolean"];
    /** Whether this user is subscribed to privacy and legal update emails or not. */
    subscribedToPrivacyLegalUpdates: Scalars["Boolean"];
    /**
     * The email types the user has unsubscribed from.
     * @deprecated Use individual subscription fields instead. This field's value is now outdated.
     */
    unsubscribedFrom: Array<Scalars["String"]>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The user associated with these settings. */
    user: User;
};
export declare type UserSettingsFlagPayload = {
    __typename?: "UserSettingsFlagPayload";
    /** The flag key which was updated. */
    flag?: Maybe<Scalars["String"]>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
    /** The flag value after update. */
    value?: Maybe<Scalars["Int"]>;
};
export declare type UserSettingsFlagsResetPayload = {
    __typename?: "UserSettingsFlagsResetPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type UserSettingsPayload = {
    __typename?: "UserSettingsPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
    /** The user's settings. */
    userSettings: UserSettings;
};
export declare type UserSettingsUpdateInput = {
    /** [Internal] How often to generate a feed summary. */
    feedSummarySchedule?: Maybe<FeedSummarySchedule>;
    /** The user's notification category preferences. */
    notificationCategoryPreferences?: Maybe<NotificationCategoryPreferencesInput>;
    /** The user's notification channel preferences. */
    notificationChannelPreferences?: Maybe<PartialNotificationChannelPreferencesInput>;
    /** The user's notification delivery preferences. */
    notificationDeliveryPreferences?: Maybe<NotificationDeliveryPreferencesInput>;
    /** The user's settings. */
    settings?: Maybe<Scalars["JSONObject"]>;
    /** Whether this user is subscribed to changelog email or not. */
    subscribedToChangelog?: Maybe<Scalars["Boolean"]>;
    /** Whether this user is subscribed to DPA emails or not. */
    subscribedToDPA?: Maybe<Scalars["Boolean"]>;
    /** Whether this user is subscribed to invite accepted emails or not. */
    subscribedToInviteAccepted?: Maybe<Scalars["Boolean"]>;
    /** Whether this user is subscribed to privacy and legal update emails or not. */
    subscribedToPrivacyLegalUpdates?: Maybe<Scalars["Boolean"]>;
    /** [Internal] The user's usage warning history. */
    usageWarningHistory?: Maybe<Scalars["JSONObject"]>;
};
export declare type UserUpdateInput = {
    /** The avatar image URL of the user. */
    avatarUrl?: Maybe<Scalars["String"]>;
    /** The user description or a short bio. */
    description?: Maybe<Scalars["String"]>;
    /** The display name of the user. */
    displayName?: Maybe<Scalars["String"]>;
    /** The name of the user. */
    name?: Maybe<Scalars["String"]>;
    /** The emoji part of the user status. */
    statusEmoji?: Maybe<Scalars["String"]>;
    /** The label part of the user status. */
    statusLabel?: Maybe<Scalars["String"]>;
    /** When the user status should be cleared. */
    statusUntilAt?: Maybe<Scalars["DateTime"]>;
    /** The local timezone of the user. */
    timezone?: Maybe<Scalars["String"]>;
};
/** View preferences. */
export declare type ViewPreferences = Node & {
    __typename?: "ViewPreferences";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The view preferences */
    preferences: ViewPreferencesValues;
    /** The view preference type. */
    type: Scalars["String"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** The view type. */
    viewType: Scalars["String"];
};
export declare type ViewPreferencesCreateInput = {
    /** The custom view these view preferences are associated with. */
    customViewId?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** [Internal] The initiative these view preferences are associated with. */
    initiativeId?: Maybe<Scalars["String"]>;
    /** The default parameters for the insight on that view. */
    insights?: Maybe<Scalars["JSONObject"]>;
    /** The label these view preferences are associated with. */
    labelId?: Maybe<Scalars["String"]>;
    /** View preferences object. */
    preferences: Scalars["JSONObject"];
    /** The project these view preferences are associated with. */
    projectId?: Maybe<Scalars["String"]>;
    /** [Internal] The project label these view preferences are associated with. */
    projectLabelId?: Maybe<Scalars["String"]>;
    /** The roadmap these view preferences are associated with. */
    roadmapId?: Maybe<Scalars["String"]>;
    /** The team these view preferences are associated with. */
    teamId?: Maybe<Scalars["String"]>;
    /** The type of view preferences (either user or organization level preferences). */
    type: ViewPreferencesType;
    /** The user profile these view preferences are associated with. */
    userId?: Maybe<Scalars["String"]>;
    /** The view type of the view preferences are associated with. */
    viewType: ViewType;
};
export declare type ViewPreferencesPayload = {
    __typename?: "ViewPreferencesPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
    /** The view preferences entity being mutated. */
    viewPreferences: ViewPreferences;
};
/** The type of view preferences (either user or organization level preferences). */
export declare enum ViewPreferencesType {
    Organization = "organization",
    User = "user"
}
export declare type ViewPreferencesUpdateInput = {
    /** The default parameters for the insight on that view. */
    insights?: Maybe<Scalars["JSONObject"]>;
    /** View preferences. */
    preferences?: Maybe<Scalars["JSONObject"]>;
};
export declare type ViewPreferencesValues = {
    __typename?: "ViewPreferencesValues";
    /** The issue grouping. */
    issueGrouping?: Maybe<Scalars["String"]>;
    /** Whether to show completed issues. */
    showCompletedIssues?: Maybe<Scalars["String"]>;
    /** The issue ordering. */
    viewOrdering?: Maybe<Scalars["String"]>;
};
/** The client view this custom view is targeting. */
export declare enum ViewType {
    ActiveIssues = "activeIssues",
    AllIssues = "allIssues",
    Archive = "archive",
    Backlog = "backlog",
    Board = "board",
    CompletedCycle = "completedCycle",
    CustomRoadmap = "customRoadmap",
    CustomView = "customView",
    CustomViews = "customViews",
    Customer = "customer",
    Customers = "customers",
    Cycle = "cycle",
    EmbeddedCustomerNeeds = "embeddedCustomerNeeds",
    FeedAll = "feedAll",
    FeedCreated = "feedCreated",
    FeedFollowing = "feedFollowing",
    FeedPopular = "feedPopular",
    Inbox = "inbox",
    Initiative = "initiative",
    InitiativeOverview = "initiativeOverview",
    InitiativeOverviewSubInitiatives = "initiativeOverviewSubInitiatives",
    Initiatives = "initiatives",
    InitiativesCompleted = "initiativesCompleted",
    InitiativesPlanned = "initiativesPlanned",
    IssueIdentifiers = "issueIdentifiers",
    Label = "label",
    MyIssues = "myIssues",
    MyIssuesActivity = "myIssuesActivity",
    MyIssuesCreatedByMe = "myIssuesCreatedByMe",
    MyIssuesSubscribedTo = "myIssuesSubscribedTo",
    MyReviews = "myReviews",
    Project = "project",
    ProjectCustomerNeeds = "projectCustomerNeeds",
    ProjectDocuments = "projectDocuments",
    ProjectLabel = "projectLabel",
    Projects = "projects",
    ProjectsAll = "projectsAll",
    ProjectsBacklog = "projectsBacklog",
    ProjectsClosed = "projectsClosed",
    QuickView = "quickView",
    Reviews = "reviews",
    Roadmap = "roadmap",
    RoadmapAll = "roadmapAll",
    RoadmapBacklog = "roadmapBacklog",
    RoadmapClosed = "roadmapClosed",
    Roadmaps = "roadmaps",
    Search = "search",
    SplitSearch = "splitSearch",
    SubIssues = "subIssues",
    Teams = "teams",
    Triage = "triage",
    UserProfile = "userProfile",
    UserProfileCreatedByUser = "userProfileCreatedByUser",
    WorkspaceMembers = "workspaceMembers"
}
/** A webhook used to send HTTP notifications over data updates. */
export declare type Webhook = Node & {
    __typename?: "Webhook";
    /** Whether the Webhook is enabled for all public teams, including teams created after the webhook was created. */
    allPublicTeams: Scalars["Boolean"];
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The user who created the webhook. */
    creator?: Maybe<User>;
    /** Whether the Webhook is enabled. */
    enabled: Scalars["Boolean"];
    /** [INTERNAL] Webhook failure events associated with the webhook (last 50). */
    failures: Array<WebhookFailureEvent>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** Webhook label. */
    label?: Maybe<Scalars["String"]>;
    /** The resource types this webhook is subscribed to. */
    resourceTypes: Array<Scalars["String"]>;
    /** Secret token for verifying the origin on the recipient side. */
    secret?: Maybe<Scalars["String"]>;
    /** The team that the webhook is associated with. If null, the webhook is associated with all public teams of the organization or multiple teams. */
    team?: Maybe<Team>;
    /** [INTERNAL] The teams that the webhook is associated with. Used to represent a webhook that targets multiple teams, potentially in addition to all public teams of the organization. */
    teamIds?: Maybe<Array<Scalars["String"]>>;
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
    /** Webhook URL. */
    url?: Maybe<Scalars["String"]>;
};
export declare type WebhookConnection = {
    __typename?: "WebhookConnection";
    edges: Array<WebhookEdge>;
    nodes: Array<Webhook>;
    pageInfo: PageInfo;
};
export declare type WebhookCreateInput = {
    /** Whether this webhook is enabled for all public teams. */
    allPublicTeams?: Maybe<Scalars["Boolean"]>;
    /** Whether this webhook is enabled. */
    enabled?: Maybe<Scalars["Boolean"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** Label for the webhook. */
    label?: Maybe<Scalars["String"]>;
    /** List of resources the webhook should subscribe to. */
    resourceTypes: Array<Scalars["String"]>;
    /** A secret token used to sign the webhook payload. */
    secret?: Maybe<Scalars["String"]>;
    /** The identifier or key of the team associated with the Webhook. */
    teamId?: Maybe<Scalars["String"]>;
    /** The URL that will be called on data changes. */
    url: Scalars["String"];
};
export declare type WebhookEdge = {
    __typename?: "WebhookEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: Webhook;
};
/** Entity representing a webhook execution failure. */
export declare type WebhookFailureEvent = {
    __typename?: "WebhookFailureEvent";
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** The unique execution ID of the webhook push. This is retained between retries of the same push. */
    executionId: Scalars["String"];
    /** The HTTP status code returned by the recipient. */
    httpStatus?: Maybe<Scalars["Float"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The HTTP response body returned by the recipient or error occured. */
    responseOrError?: Maybe<Scalars["String"]>;
    /** The URL that the webhook was trying to push to. */
    url: Scalars["String"];
    /** The webhook that this failure event is associated with. */
    webhook: Webhook;
};
export declare type WebhookPayload = {
    __typename?: "WebhookPayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
    /** The webhook entity being mutated. */
    webhook: Webhook;
};
export declare type WebhookUpdateInput = {
    /** Whether this webhook is enabled. */
    enabled?: Maybe<Scalars["Boolean"]>;
    /** Label for the webhook. */
    label?: Maybe<Scalars["String"]>;
    /** List of resources the webhook should subscribe to. */
    resourceTypes?: Maybe<Array<Scalars["String"]>>;
    /** A secret token used to sign the webhook payload. */
    secret?: Maybe<Scalars["String"]>;
    /** The URL that will be called on data changes. */
    url?: Maybe<Scalars["String"]>;
};
/** A state in a team workflow. */
export declare type WorkflowState = Node & {
    __typename?: "WorkflowState";
    /** The time at which the entity was archived. Null if the entity has not been archived. */
    archivedAt?: Maybe<Scalars["DateTime"]>;
    /** The state's UI color as a HEX string. */
    color: Scalars["String"];
    /** The time at which the entity was created. */
    createdAt: Scalars["DateTime"];
    /** Description of the state. */
    description?: Maybe<Scalars["String"]>;
    /** The unique identifier of the entity. */
    id: Scalars["ID"];
    /** The state inherited from */
    inheritedFrom?: Maybe<WorkflowState>;
    /** Issues belonging in this state. */
    issues: IssueConnection;
    /** The state's name. */
    name: Scalars["String"];
    /** The position of the state in the team flow. */
    position: Scalars["Float"];
    /** The team to which this state belongs to. */
    team: Team;
    /** The type of the state. One of "triage", "backlog", "unstarted", "started", "completed", "canceled". */
    type: Scalars["String"];
    /**
     * The last time at which the entity was meaningfully updated. This is the same as the creation time if the entity hasn't
     *     been updated after creation.
     */
    updatedAt: Scalars["DateTime"];
};
/** A state in a team workflow. */
export declare type WorkflowStateIssuesArgs = {
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
};
/** A generic payload return from entity archive mutations. */
export declare type WorkflowStateArchivePayload = ArchivePayload & {
    __typename?: "WorkflowStateArchivePayload";
    /** The archived/unarchived entity. Null if entity was deleted. */
    entity?: Maybe<WorkflowState>;
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
};
export declare type WorkflowStateConnection = {
    __typename?: "WorkflowStateConnection";
    edges: Array<WorkflowStateEdge>;
    nodes: Array<WorkflowState>;
    pageInfo: PageInfo;
};
export declare type WorkflowStateCreateInput = {
    /** The color of the state. */
    color: Scalars["String"];
    /** The description of the state. */
    description?: Maybe<Scalars["String"]>;
    /** The identifier in UUID v4 format. If none is provided, the backend will generate one. */
    id?: Maybe<Scalars["String"]>;
    /** The name of the state. */
    name: Scalars["String"];
    /** The position of the state. */
    position?: Maybe<Scalars["Float"]>;
    /** The team associated with the state. */
    teamId: Scalars["String"];
    /** The workflow type. */
    type: Scalars["String"];
};
export declare type WorkflowStateEdge = {
    __typename?: "WorkflowStateEdge";
    /** Used in `before` and `after` args */
    cursor: Scalars["String"];
    node: WorkflowState;
};
/** Workflow state filtering options. */
export declare type WorkflowStateFilter = {
    /** Compound filters, all of which need to be matched by the workflow state. */
    and?: Maybe<Array<WorkflowStateFilter>>;
    /** Comparator for the created at date. */
    createdAt?: Maybe<DateComparator>;
    /** Comparator for the workflow state description. */
    description?: Maybe<StringComparator>;
    /** Comparator for the identifier. */
    id?: Maybe<IdComparator>;
    /** Filters that the workflow states issues must satisfy. */
    issues?: Maybe<IssueCollectionFilter>;
    /** Comparator for the workflow state name. */
    name?: Maybe<StringComparator>;
    /** Compound filters, one of which need to be matched by the workflow state. */
    or?: Maybe<Array<WorkflowStateFilter>>;
    /** Comparator for the workflow state position. */
    position?: Maybe<NumberComparator>;
    /** Filters that the workflow states team must satisfy. */
    team?: Maybe<TeamFilter>;
    /** Comparator for the workflow state type. */
    type?: Maybe<StringComparator>;
    /** Comparator for the updated at date. */
    updatedAt?: Maybe<DateComparator>;
};
export declare type WorkflowStatePayload = {
    __typename?: "WorkflowStatePayload";
    /** The identifier of the last sync operation. */
    lastSyncId: Scalars["Float"];
    /** Whether the operation was successful. */
    success: Scalars["Boolean"];
    /** The state that was created or updated. */
    workflowState: WorkflowState;
};
/** Issue workflow state sorting options. */
export declare type WorkflowStateSort = {
    /** Whether to sort closed issues by recency */
    closedIssuesOrderedByRecency?: Maybe<Scalars["Boolean"]>;
    /** Whether nulls should be sorted first or last */
    nulls?: Maybe<PaginationNulls>;
    /** The order for the individual sort */
    order?: Maybe<PaginationSortOrder>;
};
export declare type WorkflowStateUpdateInput = {
    /** The color of the state. */
    color?: Maybe<Scalars["String"]>;
    /** The description of the state. */
    description?: Maybe<Scalars["String"]>;
    /** The name of the state. */
    name?: Maybe<Scalars["String"]>;
    /** The position of the state. */
    position?: Maybe<Scalars["Float"]>;
};
/** [INTERNAL] Public information of the OAuth application, plus the userIds and scopes for those users. */
export declare type WorkspaceAuthorizedApplication = {
    __typename?: "WorkspaceAuthorizedApplication";
    /** OAuth application's ID. */
    appId: Scalars["String"];
    /** OAuth application's client ID. */
    clientId: Scalars["String"];
    /** Description of the application. */
    description?: Maybe<Scalars["String"]>;
    /** Developer of the application. */
    developer?: Maybe<Scalars["String"]>;
    /** Developer URL of the application. */
    developerUrl?: Maybe<Scalars["String"]>;
    /** Image of the application. */
    imageUrl?: Maybe<Scalars["String"]>;
    /** UserIds and membership dates of everyone who has authorized the application with the set of scopes. */
    memberships: Array<AuthMembership>;
    /** Application name. */
    name: Scalars["String"];
    /** Scopes that are authorized for this application for a given user. */
    scope: Array<Scalars["String"]>;
    /** Total number of members that authorized the application. */
    totalMembers: Scalars["Float"];
    /** Whether or not webhooks are enabled for the application. */
    webhooksEnabled: Scalars["Boolean"];
};
/** [INTERNAL] Public information of the OAuth application with its memberships */
export declare type WorkspaceAuthorizedApplicationWithMemberships = {
    __typename?: "WorkspaceAuthorizedApplicationWithMemberships";
    /** Details of the OAuth application */
    client: AuthorizedApplication;
    /** UserIds and membership dates of everyone who has authorized the application */
    memberships: Array<AuthMembership>;
};
export declare type ZendeskSettingsInput = {
    /** Whether a ticket should be automatically reopened when its linked Linear issue is cancelled. */
    automateTicketReopeningOnCancellation?: Maybe<Scalars["Boolean"]>;
    /** Whether a ticket should be automatically reopened when a comment is posted on its linked Linear issue */
    automateTicketReopeningOnComment?: Maybe<Scalars["Boolean"]>;
    /** Whether a ticket should be automatically reopened when its linked Linear issue is completed. */
    automateTicketReopeningOnCompletion?: Maybe<Scalars["Boolean"]>;
    /** The ID of the Linear bot user. */
    botUserId?: Maybe<Scalars["String"]>;
    /** [INTERNAL] Temporary flag indicating if the integration has the necessary scopes for Customers */
    canReadCustomers?: Maybe<Scalars["Boolean"]>;
    /** Whether an internal message should be added when someone comments on an issue. */
    sendNoteOnComment?: Maybe<Scalars["Boolean"]>;
    /** Whether an internal message should be added when a Linear issue changes status (for status types except completed or canceled). */
    sendNoteOnStatusChange?: Maybe<Scalars["Boolean"]>;
    /** The subdomain of the Zendesk organization being connected. */
    subdomain: Scalars["String"];
    /** The URL of the connected Zendesk organization. */
    url: Scalars["String"];
};
export declare type GitAutomationTargetBranchFragment = {
    __typename: "GitAutomationTargetBranch";
} & Pick<GitAutomationTargetBranch, "updatedAt" | "branchPattern" | "archivedAt" | "createdAt" | "id" | "isRegex"> & {
    team: {
        __typename?: "Team";
    } & Pick<Team, "id">;
};
declare type Entity_CustomViewNotificationSubscription_Fragment = {
    __typename: "CustomViewNotificationSubscription";
} & Pick<CustomViewNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "id">;
declare type Entity_CustomerNeedNotification_Fragment = {
    __typename: "CustomerNeedNotification";
} & Pick<CustomerNeedNotification, "updatedAt" | "archivedAt" | "createdAt" | "id">;
declare type Entity_CustomerNotificationSubscription_Fragment = {
    __typename: "CustomerNotificationSubscription";
} & Pick<CustomerNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "id">;
declare type Entity_CycleNotificationSubscription_Fragment = {
    __typename: "CycleNotificationSubscription";
} & Pick<CycleNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "id">;
declare type Entity_DocumentNotification_Fragment = {
    __typename: "DocumentNotification";
} & Pick<DocumentNotification, "updatedAt" | "archivedAt" | "createdAt" | "id">;
declare type Entity_InitiativeNotification_Fragment = {
    __typename: "InitiativeNotification";
} & Pick<InitiativeNotification, "updatedAt" | "archivedAt" | "createdAt" | "id">;
declare type Entity_InitiativeNotificationSubscription_Fragment = {
    __typename: "InitiativeNotificationSubscription";
} & Pick<InitiativeNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "id">;
declare type Entity_IssueNotification_Fragment = {
    __typename: "IssueNotification";
} & Pick<IssueNotification, "updatedAt" | "archivedAt" | "createdAt" | "id">;
declare type Entity_LabelNotificationSubscription_Fragment = {
    __typename: "LabelNotificationSubscription";
} & Pick<LabelNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "id">;
declare type Entity_OauthClientApprovalNotification_Fragment = {
    __typename: "OauthClientApprovalNotification";
} & Pick<OauthClientApprovalNotification, "updatedAt" | "archivedAt" | "createdAt" | "id">;
declare type Entity_PostNotification_Fragment = {
    __typename: "PostNotification";
} & Pick<PostNotification, "updatedAt" | "archivedAt" | "createdAt" | "id">;
declare type Entity_ProjectNotification_Fragment = {
    __typename: "ProjectNotification";
} & Pick<ProjectNotification, "updatedAt" | "archivedAt" | "createdAt" | "id">;
declare type Entity_ProjectNotificationSubscription_Fragment = {
    __typename: "ProjectNotificationSubscription";
} & Pick<ProjectNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "id">;
declare type Entity_PullRequestNotification_Fragment = {
    __typename: "PullRequestNotification";
} & Pick<PullRequestNotification, "updatedAt" | "archivedAt" | "createdAt" | "id">;
declare type Entity_TeamNotificationSubscription_Fragment = {
    __typename: "TeamNotificationSubscription";
} & Pick<TeamNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "id">;
declare type Entity_UserNotificationSubscription_Fragment = {
    __typename: "UserNotificationSubscription";
} & Pick<UserNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "id">;
export declare type EntityFragment = Entity_CustomViewNotificationSubscription_Fragment | Entity_CustomerNeedNotification_Fragment | Entity_CustomerNotificationSubscription_Fragment | Entity_CycleNotificationSubscription_Fragment | Entity_DocumentNotification_Fragment | Entity_InitiativeNotification_Fragment | Entity_InitiativeNotificationSubscription_Fragment | Entity_IssueNotification_Fragment | Entity_LabelNotificationSubscription_Fragment | Entity_OauthClientApprovalNotification_Fragment | Entity_PostNotification_Fragment | Entity_ProjectNotification_Fragment | Entity_ProjectNotificationSubscription_Fragment | Entity_PullRequestNotification_Fragment | Entity_TeamNotificationSubscription_Fragment | Entity_UserNotificationSubscription_Fragment;
export declare type ActorBotFragment = {
    __typename: "ActorBot";
} & Pick<ActorBot, "avatarUrl" | "name" | "userDisplayName" | "subType" | "type" | "id">;
export declare type CommentFragment = {
    __typename: "Comment";
} & Pick<Comment, "url" | "reactionData" | "body" | "updatedAt" | "quotedText" | "archivedAt" | "createdAt" | "resolvedAt" | "editedAt" | "id"> & {
    reactions: Array<{
        __typename?: "Reaction";
    } & ReactionFragment>;
    botActor?: Maybe<{
        __typename?: "ActorBot";
    } & ActorBotFragment>;
    resolvingComment?: Maybe<{
        __typename?: "Comment";
    } & Pick<Comment, "id">>;
    documentContent?: Maybe<{
        __typename?: "DocumentContent";
    } & DocumentContentFragment>;
    externalThread?: Maybe<{
        __typename?: "SyncedExternalThread";
    } & SyncedExternalThreadFragment>;
    externalUser?: Maybe<{
        __typename?: "ExternalUser";
    } & Pick<ExternalUser, "id">>;
    initiativeUpdate?: Maybe<{
        __typename?: "InitiativeUpdate";
    } & Pick<InitiativeUpdate, "id">>;
    issue?: Maybe<{
        __typename?: "Issue";
    } & Pick<Issue, "id">>;
    parent?: Maybe<{
        __typename?: "Comment";
    } & Pick<Comment, "id">>;
    projectUpdate?: Maybe<{
        __typename?: "ProjectUpdate";
    } & Pick<ProjectUpdate, "id">>;
    resolvingUser?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type SyncedExternalThreadFragment = {
    __typename: "SyncedExternalThread";
} & Pick<SyncedExternalThread, "name" | "displayName" | "url" | "subType" | "type" | "isPersonalIntegrationRequired" | "isPersonalIntegrationConnected" | "isConnected" | "id">;
export declare type EmojiFragment = {
    __typename: "Emoji";
} & Pick<Emoji, "url" | "name" | "updatedAt" | "source" | "archivedAt" | "createdAt" | "id"> & {
    creator?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type CustomViewNotificationSubscriptionFragment = {
    __typename: "CustomViewNotificationSubscription";
} & Pick<CustomViewNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "notificationSubscriptionTypes" | "userContextViewType" | "contextViewType" | "id" | "active"> & {
    cycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    label?: Maybe<{
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    customView: {
        __typename?: "CustomView";
    } & Pick<CustomView, "id">;
    customer?: Maybe<{
        __typename?: "Customer";
    } & Pick<Customer, "id">>;
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    subscriber: {
        __typename?: "User";
    } & Pick<User, "id">;
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type CustomViewFragment = {
    __typename: "CustomView";
} & Pick<CustomView, "color" | "slugId" | "description" | "feedItemFilterData" | "filterData" | "projectFilterData" | "filters" | "icon" | "updatedAt" | "modelName" | "name" | "archivedAt" | "createdAt" | "id" | "shared"> & {
    viewPreferencesValues?: Maybe<{
        __typename?: "ViewPreferencesValues";
    } & ViewPreferencesValuesFragment>;
    userViewPreferences?: Maybe<{
        __typename?: "ViewPreferences";
    } & ViewPreferencesFragment>;
    organizationViewPreferences?: Maybe<{
        __typename?: "ViewPreferences";
    } & ViewPreferencesFragment>;
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    creator: {
        __typename?: "User";
    } & Pick<User, "id">;
    updatedBy?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    owner: {
        __typename?: "User";
    } & Pick<User, "id">;
};
export declare type CustomerNeedFragment = {
    __typename: "CustomerNeed";
} & Pick<CustomerNeed, "url" | "updatedAt" | "body" | "archivedAt" | "createdAt" | "id" | "priority"> & {
    attachment?: Maybe<{
        __typename?: "Attachment";
    } & Pick<Attachment, "id">>;
    comment?: Maybe<{
        __typename?: "Comment";
    } & Pick<Comment, "id">>;
    creator?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    customer?: Maybe<{
        __typename?: "Customer";
    } & Pick<Customer, "id">>;
    issue?: Maybe<{
        __typename?: "Issue";
    } & Pick<Issue, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
};
export declare type CustomerNotificationSubscriptionFragment = {
    __typename: "CustomerNotificationSubscription";
} & Pick<CustomerNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "notificationSubscriptionTypes" | "userContextViewType" | "contextViewType" | "id" | "active"> & {
    customView?: Maybe<{
        __typename?: "CustomView";
    } & Pick<CustomView, "id">>;
    cycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    label?: Maybe<{
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    customer: {
        __typename?: "Customer";
    } & Pick<Customer, "id">;
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    subscriber: {
        __typename?: "User";
    } & Pick<User, "id">;
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type CustomerStatusFragment = {
    __typename: "CustomerStatus";
} & Pick<CustomerStatus, "description" | "color" | "updatedAt" | "name" | "position" | "archivedAt" | "createdAt" | "type" | "id">;
export declare type CustomerTierFragment = {
    __typename: "CustomerTier";
} & Pick<CustomerTier, "description" | "color" | "displayName" | "updatedAt" | "name" | "position" | "archivedAt" | "createdAt" | "id">;
export declare type CustomerFragment = {
    __typename: "Customer";
} & Pick<Customer, "slackChannelId" | "mainSourceId" | "revenue" | "approximateNeedCount" | "logoUrl" | "name" | "slugId" | "domains" | "externalIds" | "updatedAt" | "size" | "archivedAt" | "createdAt" | "id"> & {
    status: {
        __typename?: "CustomerStatus";
    } & Pick<CustomerStatus, "id">;
    integration?: Maybe<{
        __typename?: "Integration";
    } & Pick<Integration, "id">>;
    tier?: Maybe<{
        __typename?: "CustomerTier";
    } & Pick<CustomerTier, "id">>;
    owner?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type CycleNotificationSubscriptionFragment = {
    __typename: "CycleNotificationSubscription";
} & Pick<CycleNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "notificationSubscriptionTypes" | "userContextViewType" | "contextViewType" | "id" | "active"> & {
    customView?: Maybe<{
        __typename?: "CustomView";
    } & Pick<CustomView, "id">>;
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    label?: Maybe<{
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    customer?: Maybe<{
        __typename?: "Customer";
    } & Pick<Customer, "id">>;
    cycle: {
        __typename?: "Cycle";
    } & Pick<Cycle, "id">;
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    subscriber: {
        __typename?: "User";
    } & Pick<User, "id">;
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type DocumentContentFragment = {
    __typename: "DocumentContent";
} & Pick<DocumentContent, "content" | "contentState" | "updatedAt" | "restoredAt" | "archivedAt" | "createdAt" | "id"> & {
    document?: Maybe<{
        __typename?: "Document";
    } & Pick<Document, "id">>;
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    issue?: Maybe<{
        __typename?: "Issue";
    } & Pick<Issue, "id">>;
    projectMilestone?: Maybe<{
        __typename?: "ProjectMilestone";
    } & Pick<ProjectMilestone, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
};
export declare type DocumentNotificationFragment = {
    __typename: "DocumentNotification";
} & Pick<DocumentNotification, "reactionEmoji" | "type" | "commentId" | "documentId" | "parentCommentId" | "updatedAt" | "emailedAt" | "readAt" | "unsnoozedAt" | "archivedAt" | "createdAt" | "snoozedUntilAt" | "id"> & {
    botActor?: Maybe<{
        __typename?: "ActorBot";
    } & ActorBotFragment>;
    externalUserActor?: Maybe<{
        __typename?: "ExternalUser";
    } & Pick<ExternalUser, "id">>;
    actor?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
};
export declare type DocumentFragment = {
    __typename: "Document";
} & Pick<Document, "trashed" | "documentContentId" | "url" | "color" | "title" | "slugId" | "content" | "icon" | "updatedAt" | "sortOrder" | "hiddenAt" | "archivedAt" | "createdAt" | "id"> & {
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    lastAppliedTemplate?: Maybe<{
        __typename?: "Template";
    } & Pick<Template, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    creator?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    updatedBy?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type FacetFragment = {
    __typename: "Facet";
} & Pick<Facet, "updatedAt" | "sourcePage" | "sortOrder" | "archivedAt" | "createdAt" | "id"> & {
    sourceFeedUser?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    sourceInitiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    sourceProject?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    sourceTeam?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    targetCustomView?: Maybe<{
        __typename?: "CustomView";
    } & Pick<CustomView, "id">>;
};
export declare type DraftFragment = {
    __typename: "Draft";
} & Pick<Draft, "data" | "updatedAt" | "bodyData" | "archivedAt" | "createdAt" | "id" | "isAutogenerated"> & {
    parentComment?: Maybe<{
        __typename?: "Comment";
    } & Pick<Comment, "id">>;
    customerNeed?: Maybe<{
        __typename?: "CustomerNeed";
    } & Pick<CustomerNeed, "id">>;
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    initiativeUpdate?: Maybe<{
        __typename?: "InitiativeUpdate";
    } & Pick<InitiativeUpdate, "id">>;
    issue?: Maybe<{
        __typename?: "Issue";
    } & Pick<Issue, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    projectUpdate?: Maybe<{
        __typename?: "ProjectUpdate";
    } & Pick<ProjectUpdate, "id">>;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
};
export declare type CustomerNeedArchivePayloadFragment = {
    __typename: "CustomerNeedArchivePayload";
} & Pick<CustomerNeedArchivePayload, "lastSyncId" | "success"> & {
    entity?: Maybe<{
        __typename?: "CustomerNeed";
    } & Pick<CustomerNeed, "id">>;
};
export declare type CycleArchivePayloadFragment = {
    __typename: "CycleArchivePayload";
} & Pick<CycleArchivePayload, "lastSyncId" | "success"> & {
    entity?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
};
export declare type DocumentArchivePayloadFragment = {
    __typename: "DocumentArchivePayload";
} & Pick<DocumentArchivePayload, "lastSyncId" | "success"> & {
    entity?: Maybe<{
        __typename?: "Document";
    } & Pick<Document, "id">>;
};
export declare type InitiativeArchivePayloadFragment = {
    __typename: "InitiativeArchivePayload";
} & Pick<InitiativeArchivePayload, "lastSyncId" | "success"> & {
    entity?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
};
export declare type InitiativeUpdateArchivePayloadFragment = {
    __typename: "InitiativeUpdateArchivePayload";
} & Pick<InitiativeUpdateArchivePayload, "lastSyncId" | "success"> & {
    entity?: Maybe<{
        __typename?: "InitiativeUpdate";
    } & Pick<InitiativeUpdate, "id">>;
};
export declare type IssueArchivePayloadFragment = {
    __typename: "IssueArchivePayload";
} & Pick<IssueArchivePayload, "lastSyncId" | "success"> & {
    entity?: Maybe<{
        __typename?: "Issue";
    } & Pick<Issue, "id">>;
};
export declare type NotificationArchivePayloadFragment = {
    __typename: "NotificationArchivePayload";
} & Pick<NotificationArchivePayload, "lastSyncId" | "success"> & {
    entity?: Maybe<({
        __typename?: "CustomerNeedNotification";
    } & Notification_CustomerNeedNotification_Fragment) | ({
        __typename?: "DocumentNotification";
    } & Notification_DocumentNotification_Fragment) | ({
        __typename?: "InitiativeNotification";
    } & Notification_InitiativeNotification_Fragment) | ({
        __typename?: "IssueNotification";
    } & Notification_IssueNotification_Fragment) | ({
        __typename?: "OauthClientApprovalNotification";
    } & Notification_OauthClientApprovalNotification_Fragment) | ({
        __typename?: "PostNotification";
    } & Notification_PostNotification_Fragment) | ({
        __typename?: "ProjectNotification";
    } & Notification_ProjectNotification_Fragment) | ({
        __typename?: "PullRequestNotification";
    } & Notification_PullRequestNotification_Fragment)>;
};
export declare type ProjectArchivePayloadFragment = {
    __typename: "ProjectArchivePayload";
} & Pick<ProjectArchivePayload, "lastSyncId" | "success"> & {
    entity?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
};
export declare type ProjectStatusArchivePayloadFragment = {
    __typename: "ProjectStatusArchivePayload";
} & Pick<ProjectStatusArchivePayload, "lastSyncId" | "success"> & {
    entity?: Maybe<{
        __typename?: "ProjectStatus";
    } & Pick<ProjectStatus, "id">>;
};
export declare type ProjectUpdateArchivePayloadFragment = {
    __typename: "ProjectUpdateArchivePayload";
} & Pick<ProjectUpdateArchivePayload, "lastSyncId" | "success"> & {
    entity?: Maybe<{
        __typename?: "ProjectUpdate";
    } & Pick<ProjectUpdate, "id">>;
};
export declare type RoadmapArchivePayloadFragment = {
    __typename: "RoadmapArchivePayload";
} & Pick<RoadmapArchivePayload, "lastSyncId" | "success"> & {
    entity?: Maybe<{
        __typename?: "Roadmap";
    } & Pick<Roadmap, "id">>;
};
export declare type TeamArchivePayloadFragment = {
    __typename: "TeamArchivePayload";
} & Pick<TeamArchivePayload, "lastSyncId" | "success"> & {
    entity?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
};
export declare type WorkflowStateArchivePayloadFragment = {
    __typename: "WorkflowStateArchivePayload";
} & Pick<WorkflowStateArchivePayload, "lastSyncId" | "success"> & {
    entity?: Maybe<{
        __typename?: "WorkflowState";
    } & Pick<WorkflowState, "id">>;
};
declare type ArchivePayload_CustomerNeedArchivePayload_Fragment = {
    __typename: "CustomerNeedArchivePayload";
} & Pick<CustomerNeedArchivePayload, "lastSyncId" | "success"> & CustomerNeedArchivePayloadFragment;
declare type ArchivePayload_CycleArchivePayload_Fragment = {
    __typename: "CycleArchivePayload";
} & Pick<CycleArchivePayload, "lastSyncId" | "success"> & CycleArchivePayloadFragment;
declare type ArchivePayload_DeletePayload_Fragment = {
    __typename: "DeletePayload";
} & Pick<DeletePayload, "lastSyncId" | "success"> & DeletePayloadFragment;
declare type ArchivePayload_DocumentArchivePayload_Fragment = {
    __typename: "DocumentArchivePayload";
} & Pick<DocumentArchivePayload, "lastSyncId" | "success"> & DocumentArchivePayloadFragment;
declare type ArchivePayload_InitiativeArchivePayload_Fragment = {
    __typename: "InitiativeArchivePayload";
} & Pick<InitiativeArchivePayload, "lastSyncId" | "success"> & InitiativeArchivePayloadFragment;
declare type ArchivePayload_InitiativeUpdateArchivePayload_Fragment = {
    __typename: "InitiativeUpdateArchivePayload";
} & Pick<InitiativeUpdateArchivePayload, "lastSyncId" | "success"> & InitiativeUpdateArchivePayloadFragment;
declare type ArchivePayload_IssueArchivePayload_Fragment = {
    __typename: "IssueArchivePayload";
} & Pick<IssueArchivePayload, "lastSyncId" | "success"> & IssueArchivePayloadFragment;
declare type ArchivePayload_NotificationArchivePayload_Fragment = {
    __typename: "NotificationArchivePayload";
} & Pick<NotificationArchivePayload, "lastSyncId" | "success"> & NotificationArchivePayloadFragment;
declare type ArchivePayload_ProjectArchivePayload_Fragment = {
    __typename: "ProjectArchivePayload";
} & Pick<ProjectArchivePayload, "lastSyncId" | "success"> & ProjectArchivePayloadFragment;
declare type ArchivePayload_ProjectStatusArchivePayload_Fragment = {
    __typename: "ProjectStatusArchivePayload";
} & Pick<ProjectStatusArchivePayload, "lastSyncId" | "success"> & ProjectStatusArchivePayloadFragment;
declare type ArchivePayload_ProjectUpdateArchivePayload_Fragment = {
    __typename: "ProjectUpdateArchivePayload";
} & Pick<ProjectUpdateArchivePayload, "lastSyncId" | "success"> & ProjectUpdateArchivePayloadFragment;
declare type ArchivePayload_RoadmapArchivePayload_Fragment = {
    __typename: "RoadmapArchivePayload";
} & Pick<RoadmapArchivePayload, "lastSyncId" | "success"> & RoadmapArchivePayloadFragment;
declare type ArchivePayload_TeamArchivePayload_Fragment = {
    __typename: "TeamArchivePayload";
} & Pick<TeamArchivePayload, "lastSyncId" | "success"> & TeamArchivePayloadFragment;
declare type ArchivePayload_WorkflowStateArchivePayload_Fragment = {
    __typename: "WorkflowStateArchivePayload";
} & Pick<WorkflowStateArchivePayload, "lastSyncId" | "success"> & WorkflowStateArchivePayloadFragment;
export declare type ArchivePayloadFragment = ArchivePayload_CustomerNeedArchivePayload_Fragment | ArchivePayload_CycleArchivePayload_Fragment | ArchivePayload_DeletePayload_Fragment | ArchivePayload_DocumentArchivePayload_Fragment | ArchivePayload_InitiativeArchivePayload_Fragment | ArchivePayload_InitiativeUpdateArchivePayload_Fragment | ArchivePayload_IssueArchivePayload_Fragment | ArchivePayload_NotificationArchivePayload_Fragment | ArchivePayload_ProjectArchivePayload_Fragment | ArchivePayload_ProjectStatusArchivePayload_Fragment | ArchivePayload_ProjectUpdateArchivePayload_Fragment | ArchivePayload_RoadmapArchivePayload_Fragment | ArchivePayload_TeamArchivePayload_Fragment | ArchivePayload_WorkflowStateArchivePayload_Fragment;
export declare type DeletePayloadFragment = {
    __typename: "DeletePayload";
} & Pick<DeletePayload, "entityId" | "lastSyncId" | "success">;
export declare type InitiativeHistoryFragment = {
    __typename: "InitiativeHistory";
} & Pick<InitiativeHistory, "entries" | "updatedAt" | "archivedAt" | "createdAt" | "id"> & {
    initiative: {
        __typename?: "Initiative";
    } & Pick<Initiative, "id">;
};
export declare type LabelNotificationSubscriptionFragment = {
    __typename: "LabelNotificationSubscription";
} & Pick<LabelNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "notificationSubscriptionTypes" | "userContextViewType" | "contextViewType" | "id" | "active"> & {
    customView?: Maybe<{
        __typename?: "CustomView";
    } & Pick<CustomView, "id">>;
    cycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    customer?: Maybe<{
        __typename?: "Customer";
    } & Pick<Customer, "id">>;
    label: {
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">;
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    subscriber: {
        __typename?: "User";
    } & Pick<User, "id">;
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type MeetingFragment = {
    __typename: "Meeting";
} & Pick<Meeting, "trashed" | "recordingLink" | "color" | "icon" | "updatedAt" | "location" | "meetingLink" | "title" | "sortOrder" | "archivedAt" | "createdAt" | "endsAt" | "startsAt" | "hiddenAt" | "id"> & {
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    creator?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    updatedBy?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type ProjectMilestoneFragment = {
    __typename: "ProjectMilestone";
} & Pick<ProjectMilestone, "updatedAt" | "name" | "sortOrder" | "targetDate" | "progress" | "description" | "status" | "archivedAt" | "createdAt" | "id"> & {
    documentContent?: Maybe<{
        __typename?: "DocumentContent";
    } & DocumentContentFragment>;
    project: {
        __typename?: "Project";
    } & Pick<Project, "id">;
};
declare type Notification_CustomerNeedNotification_Fragment = {
    __typename: "CustomerNeedNotification";
} & Pick<CustomerNeedNotification, "type" | "updatedAt" | "emailedAt" | "readAt" | "unsnoozedAt" | "archivedAt" | "createdAt" | "snoozedUntilAt" | "id"> & {
    botActor?: Maybe<{
        __typename?: "ActorBot";
    } & ActorBotFragment>;
    externalUserActor?: Maybe<{
        __typename?: "ExternalUser";
    } & Pick<ExternalUser, "id">>;
    actor?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
};
declare type Notification_DocumentNotification_Fragment = {
    __typename: "DocumentNotification";
} & Pick<DocumentNotification, "type" | "updatedAt" | "emailedAt" | "readAt" | "unsnoozedAt" | "archivedAt" | "createdAt" | "snoozedUntilAt" | "id"> & {
    botActor?: Maybe<{
        __typename?: "ActorBot";
    } & ActorBotFragment>;
    externalUserActor?: Maybe<{
        __typename?: "ExternalUser";
    } & Pick<ExternalUser, "id">>;
    actor?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
} & DocumentNotificationFragment;
declare type Notification_InitiativeNotification_Fragment = {
    __typename: "InitiativeNotification";
} & Pick<InitiativeNotification, "type" | "updatedAt" | "emailedAt" | "readAt" | "unsnoozedAt" | "archivedAt" | "createdAt" | "snoozedUntilAt" | "id"> & {
    botActor?: Maybe<{
        __typename?: "ActorBot";
    } & ActorBotFragment>;
    externalUserActor?: Maybe<{
        __typename?: "ExternalUser";
    } & Pick<ExternalUser, "id">>;
    actor?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
} & InitiativeNotificationFragment;
declare type Notification_IssueNotification_Fragment = {
    __typename: "IssueNotification";
} & Pick<IssueNotification, "type" | "updatedAt" | "emailedAt" | "readAt" | "unsnoozedAt" | "archivedAt" | "createdAt" | "snoozedUntilAt" | "id"> & {
    botActor?: Maybe<{
        __typename?: "ActorBot";
    } & ActorBotFragment>;
    externalUserActor?: Maybe<{
        __typename?: "ExternalUser";
    } & Pick<ExternalUser, "id">>;
    actor?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
} & IssueNotificationFragment;
declare type Notification_OauthClientApprovalNotification_Fragment = {
    __typename: "OauthClientApprovalNotification";
} & Pick<OauthClientApprovalNotification, "type" | "updatedAt" | "emailedAt" | "readAt" | "unsnoozedAt" | "archivedAt" | "createdAt" | "snoozedUntilAt" | "id"> & {
    botActor?: Maybe<{
        __typename?: "ActorBot";
    } & ActorBotFragment>;
    externalUserActor?: Maybe<{
        __typename?: "ExternalUser";
    } & Pick<ExternalUser, "id">>;
    actor?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
} & OauthClientApprovalNotificationFragment;
declare type Notification_PostNotification_Fragment = {
    __typename: "PostNotification";
} & Pick<PostNotification, "type" | "updatedAt" | "emailedAt" | "readAt" | "unsnoozedAt" | "archivedAt" | "createdAt" | "snoozedUntilAt" | "id"> & {
    botActor?: Maybe<{
        __typename?: "ActorBot";
    } & ActorBotFragment>;
    externalUserActor?: Maybe<{
        __typename?: "ExternalUser";
    } & Pick<ExternalUser, "id">>;
    actor?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
};
declare type Notification_ProjectNotification_Fragment = {
    __typename: "ProjectNotification";
} & Pick<ProjectNotification, "type" | "updatedAt" | "emailedAt" | "readAt" | "unsnoozedAt" | "archivedAt" | "createdAt" | "snoozedUntilAt" | "id"> & {
    botActor?: Maybe<{
        __typename?: "ActorBot";
    } & ActorBotFragment>;
    externalUserActor?: Maybe<{
        __typename?: "ExternalUser";
    } & Pick<ExternalUser, "id">>;
    actor?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
} & ProjectNotificationFragment;
declare type Notification_PullRequestNotification_Fragment = {
    __typename: "PullRequestNotification";
} & Pick<PullRequestNotification, "type" | "updatedAt" | "emailedAt" | "readAt" | "unsnoozedAt" | "archivedAt" | "createdAt" | "snoozedUntilAt" | "id"> & {
    botActor?: Maybe<{
        __typename?: "ActorBot";
    } & ActorBotFragment>;
    externalUserActor?: Maybe<{
        __typename?: "ExternalUser";
    } & Pick<ExternalUser, "id">>;
    actor?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
};
export declare type NotificationFragment = Notification_CustomerNeedNotification_Fragment | Notification_DocumentNotification_Fragment | Notification_InitiativeNotification_Fragment | Notification_IssueNotification_Fragment | Notification_OauthClientApprovalNotification_Fragment | Notification_PostNotification_Fragment | Notification_ProjectNotification_Fragment | Notification_PullRequestNotification_Fragment;
export declare type ProjectNotificationSubscriptionFragment = {
    __typename: "ProjectNotificationSubscription";
} & Pick<ProjectNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "notificationSubscriptionTypes" | "userContextViewType" | "contextViewType" | "id" | "active"> & {
    customView?: Maybe<{
        __typename?: "CustomView";
    } & Pick<CustomView, "id">>;
    cycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    label?: Maybe<{
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">>;
    customer?: Maybe<{
        __typename?: "Customer";
    } & Pick<Customer, "id">>;
    project: {
        __typename?: "Project";
    } & Pick<Project, "id">;
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    subscriber: {
        __typename?: "User";
    } & Pick<User, "id">;
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type ProjectNotificationFragment = {
    __typename: "ProjectNotification";
} & Pick<ProjectNotification, "reactionEmoji" | "type" | "commentId" | "parentCommentId" | "projectId" | "projectMilestoneId" | "projectUpdateId" | "updatedAt" | "emailedAt" | "readAt" | "unsnoozedAt" | "archivedAt" | "createdAt" | "snoozedUntilAt" | "id"> & {
    botActor?: Maybe<{
        __typename?: "ActorBot";
    } & ActorBotFragment>;
    comment?: Maybe<{
        __typename?: "Comment";
    } & Pick<Comment, "id">>;
    document?: Maybe<{
        __typename?: "Document";
    } & Pick<Document, "id">>;
    externalUserActor?: Maybe<{
        __typename?: "ExternalUser";
    } & Pick<ExternalUser, "id">>;
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    initiativeUpdate?: Maybe<{
        __typename?: "InitiativeUpdate";
    } & Pick<InitiativeUpdate, "id">>;
    parentComment?: Maybe<{
        __typename?: "Comment";
    } & Pick<Comment, "id">>;
    project: {
        __typename?: "Project";
    } & Pick<Project, "id">;
    projectUpdate?: Maybe<{
        __typename?: "ProjectUpdate";
    } & Pick<ProjectUpdate, "id">>;
    actor?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
};
export declare type ProjectStatusFragment = {
    __typename: "ProjectStatus";
} & Pick<ProjectStatus, "description" | "color" | "updatedAt" | "name" | "position" | "archivedAt" | "createdAt" | "type" | "id" | "indefinite">;
export declare type ProjectFragment = {
    __typename: "Project";
} & Pick<Project, "trashed" | "labelIds" | "url" | "updateRemindersDay" | "targetDate" | "startDate" | "updateReminderFrequency" | "health" | "updateRemindersHour" | "icon" | "updatedAt" | "updateReminderFrequencyInWeeks" | "completedScopeHistory" | "completedIssueCountHistory" | "inProgressScopeHistory" | "progress" | "scope" | "priorityLabel" | "priority" | "color" | "content" | "description" | "name" | "slugId" | "targetDateResolution" | "startDateResolution" | "frequencyResolution" | "prioritySortOrder" | "sortOrder" | "archivedAt" | "createdAt" | "healthUpdatedAt" | "autoArchivedAt" | "canceledAt" | "completedAt" | "startedAt" | "projectUpdateRemindersPausedUntilAt" | "scopeHistory" | "issueCountHistory" | "id" | "slackIssueComments" | "slackNewIssue" | "slackIssueStatuses" | "state"> & {
    integrationsSettings?: Maybe<{
        __typename?: "IntegrationsSettings";
    } & Pick<IntegrationsSettings, "id">>;
    documentContent?: Maybe<{
        __typename?: "DocumentContent";
    } & DocumentContentFragment>;
    lastUpdate?: Maybe<{
        __typename?: "ProjectUpdate";
    } & Pick<ProjectUpdate, "id">>;
    lastAppliedTemplate?: Maybe<{
        __typename?: "Template";
    } & Pick<Template, "id">>;
    lead?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    convertedFromIssue?: Maybe<{
        __typename?: "Issue";
    } & Pick<Issue, "id">>;
    status: {
        __typename?: "ProjectStatus";
    } & Pick<ProjectStatus, "id">;
    creator?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    favorite?: Maybe<{
        __typename?: "Favorite";
    } & Pick<Favorite, "id">>;
};
export declare type ReactionFragment = {
    __typename: "Reaction";
} & Pick<Reaction, "emoji" | "updatedAt" | "archivedAt" | "createdAt" | "id"> & {
    comment?: Maybe<{
        __typename?: "Comment";
    } & Pick<Comment, "id">>;
    externalUser?: Maybe<{
        __typename?: "ExternalUser";
    } & Pick<ExternalUser, "id">>;
    initiativeUpdate?: Maybe<{
        __typename?: "InitiativeUpdate";
    } & Pick<InitiativeUpdate, "id">>;
    issue?: Maybe<{
        __typename?: "Issue";
    } & Pick<Issue, "id">>;
    projectUpdate?: Maybe<{
        __typename?: "ProjectUpdate";
    } & Pick<ProjectUpdate, "id">>;
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type IssueHistoryFragment = {
    __typename: "IssueHistory";
} & Pick<IssueHistory, "addedLabelIds" | "removedLabelIds" | "attachmentId" | "customerNeedId" | "toCycleId" | "toParentId" | "toConvertedProjectId" | "toProjectId" | "toStateId" | "fromCycleId" | "fromParentId" | "fromProjectId" | "fromStateId" | "fromTeamId" | "toTeamId" | "fromAssigneeId" | "toAssigneeId" | "actorId" | "updatedAt" | "archivedAt" | "createdAt" | "id" | "fromDueDate" | "toDueDate" | "fromEstimate" | "toEstimate" | "fromPriority" | "toPriority" | "fromTitle" | "toTitle" | "archived" | "autoArchived" | "autoClosed" | "trashed" | "updatedDescription"> & {
    relationChanges?: Maybe<Array<{
        __typename?: "IssueRelationHistoryPayload";
    } & IssueRelationHistoryPayloadFragment>>;
    actor?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    descriptionUpdatedBy?: Maybe<Array<{
        __typename?: "User";
    } & UserFragment>>;
    actors?: Maybe<Array<{
        __typename?: "User";
    } & UserFragment>>;
    botActor?: Maybe<{
        __typename?: "ActorBot";
    } & ActorBotFragment>;
    fromCycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    toCycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    issueImport?: Maybe<{
        __typename?: "IssueImport";
    } & IssueImportFragment>;
    issue: {
        __typename?: "Issue";
    } & Pick<Issue, "id">;
    addedLabels?: Maybe<Array<{
        __typename?: "IssueLabel";
    } & IssueLabelFragment>>;
    removedLabels?: Maybe<Array<{
        __typename?: "IssueLabel";
    } & IssueLabelFragment>>;
    attachment?: Maybe<{
        __typename?: "Attachment";
    } & Pick<Attachment, "id">>;
    toConvertedProject?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    fromParent?: Maybe<{
        __typename?: "Issue";
    } & Pick<Issue, "id">>;
    toParent?: Maybe<{
        __typename?: "Issue";
    } & Pick<Issue, "id">>;
    fromProject?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    toProject?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    fromState?: Maybe<{
        __typename?: "WorkflowState";
    } & Pick<WorkflowState, "id">>;
    toState?: Maybe<{
        __typename?: "WorkflowState";
    } & Pick<WorkflowState, "id">>;
    fromTeam?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    toTeam?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    toAssignee?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    fromAssignee?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    triageResponsibilityNotifiedUsers?: Maybe<Array<{
        __typename?: "User";
    } & UserFragment>>;
};
export declare type IssueRelationFragment = {
    __typename: "IssueRelation";
} & Pick<IssueRelation, "updatedAt" | "type" | "archivedAt" | "createdAt" | "id"> & {
    issue: {
        __typename?: "Issue";
    } & Pick<Issue, "id">;
    relatedIssue: {
        __typename?: "Issue";
    } & Pick<Issue, "id">;
};
export declare type ProjectRelationFragment = {
    __typename: "ProjectRelation";
} & Pick<ProjectRelation, "updatedAt" | "type" | "archivedAt" | "createdAt" | "anchorType" | "relatedAnchorType" | "id"> & {
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    projectMilestone?: Maybe<{
        __typename?: "ProjectMilestone";
    } & Pick<ProjectMilestone, "id">>;
    relatedProjectMilestone?: Maybe<{
        __typename?: "ProjectMilestone";
    } & Pick<ProjectMilestone, "id">>;
    project: {
        __typename?: "Project";
    } & Pick<Project, "id">;
    relatedProject: {
        __typename?: "Project";
    } & Pick<Project, "id">;
};
export declare type InitiativeRelationFragment = {
    __typename: "InitiativeRelation";
} & Pick<InitiativeRelation, "updatedAt" | "sortOrder" | "archivedAt" | "createdAt" | "id"> & {
    relatedInitiative: {
        __typename?: "Initiative";
    } & Pick<Initiative, "id">;
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    initiative: {
        __typename?: "Initiative";
    } & Pick<Initiative, "id">;
};
export declare type RoadmapFragment = {
    __typename: "Roadmap";
} & Pick<Roadmap, "url" | "description" | "updatedAt" | "name" | "color" | "slugId" | "sortOrder" | "archivedAt" | "createdAt" | "id"> & {
    creator: {
        __typename?: "User";
    } & Pick<User, "id">;
    owner?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type CycleFragment = {
    __typename: "Cycle";
} & Pick<Cycle, "completedAt" | "name" | "description" | "endsAt" | "updatedAt" | "completedScopeHistory" | "completedIssueCountHistory" | "inProgressScopeHistory" | "number" | "progress" | "startsAt" | "autoArchivedAt" | "archivedAt" | "createdAt" | "scopeHistory" | "issueCountHistory" | "id"> & {
    inheritedFrom?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    team: {
        __typename?: "Team";
    } & Pick<Team, "id">;
};
export declare type WorkflowStateFragment = {
    __typename: "WorkflowState";
} & Pick<WorkflowState, "description" | "updatedAt" | "position" | "color" | "name" | "archivedAt" | "createdAt" | "type" | "id"> & {
    inheritedFrom?: Maybe<{
        __typename?: "WorkflowState";
    } & Pick<WorkflowState, "id">>;
    team: {
        __typename?: "Team";
    } & Pick<Team, "id">;
};
export declare type TeamNotificationSubscriptionFragment = {
    __typename: "TeamNotificationSubscription";
} & Pick<TeamNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "notificationSubscriptionTypes" | "userContextViewType" | "contextViewType" | "id" | "active"> & {
    customView?: Maybe<{
        __typename?: "CustomView";
    } & Pick<CustomView, "id">>;
    cycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    label?: Maybe<{
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    customer?: Maybe<{
        __typename?: "Customer";
    } & Pick<Customer, "id">>;
    team: {
        __typename?: "Team";
    } & Pick<Team, "id">;
    subscriber: {
        __typename?: "User";
    } & Pick<User, "id">;
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type TriageResponsibilityFragment = {
    __typename: "TriageResponsibility";
} & Pick<TriageResponsibility, "action" | "updatedAt" | "archivedAt" | "createdAt" | "id"> & {
    manualSelection?: Maybe<{
        __typename?: "TriageResponsibilityManualSelection";
    } & TriageResponsibilityManualSelectionFragment>;
    team: {
        __typename?: "Team";
    } & Pick<Team, "id">;
    timeSchedule?: Maybe<{
        __typename?: "TimeSchedule";
    } & Pick<TimeSchedule, "id">>;
    currentUser?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type TemplateFragment = {
    __typename: "Template";
} & Pick<Template, "templateData" | "description" | "type" | "updatedAt" | "name" | "sortOrder" | "archivedAt" | "createdAt" | "id"> & {
    inheritedFrom?: Maybe<{
        __typename?: "Template";
    } & Pick<Template, "id">>;
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    creator?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    lastUpdatedBy?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type TimeScheduleFragment = {
    __typename: "TimeSchedule";
} & Pick<TimeSchedule, "externalUrl" | "externalId" | "updatedAt" | "name" | "archivedAt" | "createdAt" | "id"> & {
    integration?: Maybe<{
        __typename?: "Integration";
    } & Pick<Integration, "id">>;
    entries?: Maybe<Array<{
        __typename?: "TimeScheduleEntry";
    } & TimeScheduleEntryFragment>>;
};
export declare type GitAutomationStateFragment = {
    __typename: "GitAutomationState";
} & Pick<GitAutomationState, "event" | "updatedAt" | "archivedAt" | "createdAt" | "id" | "branchPattern"> & {
    state?: Maybe<{
        __typename?: "WorkflowState";
    } & Pick<WorkflowState, "id">>;
    targetBranch?: Maybe<{
        __typename?: "GitAutomationTargetBranch";
    } & GitAutomationTargetBranchFragment>;
    team: {
        __typename?: "Team";
    } & Pick<Team, "id">;
};
export declare type UserNotificationSubscriptionFragment = {
    __typename: "UserNotificationSubscription";
} & Pick<UserNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "notificationSubscriptionTypes" | "userContextViewType" | "contextViewType" | "id" | "active"> & {
    customView?: Maybe<{
        __typename?: "CustomView";
    } & Pick<CustomView, "id">>;
    cycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    label?: Maybe<{
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    customer?: Maybe<{
        __typename?: "Customer";
    } & Pick<Customer, "id">>;
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
    subscriber: {
        __typename?: "User";
    } & Pick<User, "id">;
};
export declare type AuthUserFragment = {
    __typename: "AuthUser";
} & Pick<AuthUser, "avatarUrl" | "displayName" | "email" | "name" | "userAccountId" | "active" | "role" | "id"> & {
    organization: {
        __typename?: "AuthOrganization";
    } & AuthOrganizationFragment;
};
export declare type UserFragment = {
    __typename: "User";
} & Pick<User, "statusUntilAt" | "description" | "avatarUrl" | "createdIssueCount" | "disableReason" | "avatarBackgroundColor" | "statusEmoji" | "initials" | "statusLabel" | "updatedAt" | "lastSeen" | "timezone" | "archivedAt" | "createdAt" | "id" | "displayName" | "email" | "name" | "inviteHash" | "url" | "active" | "guest" | "app" | "admin" | "isMe" | "calendarHash">;
export declare type NotificationCategoryPreferencesFragment = {
    __typename: "NotificationCategoryPreferences";
} & {
    customers: {
        __typename?: "NotificationChannelPreferences";
    } & NotificationChannelPreferencesFragment;
    appsAndIntegrations: {
        __typename?: "NotificationChannelPreferences";
    } & NotificationChannelPreferencesFragment;
    assignments: {
        __typename?: "NotificationChannelPreferences";
    } & NotificationChannelPreferencesFragment;
    commentsAndReplies: {
        __typename?: "NotificationChannelPreferences";
    } & NotificationChannelPreferencesFragment;
    documentChanges: {
        __typename?: "NotificationChannelPreferences";
    } & NotificationChannelPreferencesFragment;
    mentions: {
        __typename?: "NotificationChannelPreferences";
    } & NotificationChannelPreferencesFragment;
    postsAndUpdates: {
        __typename?: "NotificationChannelPreferences";
    } & NotificationChannelPreferencesFragment;
    reactions: {
        __typename?: "NotificationChannelPreferences";
    } & NotificationChannelPreferencesFragment;
    reminders: {
        __typename?: "NotificationChannelPreferences";
    } & NotificationChannelPreferencesFragment;
    reviews: {
        __typename?: "NotificationChannelPreferences";
    } & NotificationChannelPreferencesFragment;
    statusChanges: {
        __typename?: "NotificationChannelPreferences";
    } & NotificationChannelPreferencesFragment;
    subscriptions: {
        __typename?: "NotificationChannelPreferences";
    } & NotificationChannelPreferencesFragment;
    system: {
        __typename?: "NotificationChannelPreferences";
    } & NotificationChannelPreferencesFragment;
    triage: {
        __typename?: "NotificationChannelPreferences";
    } & NotificationChannelPreferencesFragment;
};
export declare type NotificationChannelPreferencesFragment = {
    __typename: "NotificationChannelPreferences";
} & Pick<NotificationChannelPreferences, "slack" | "desktop" | "email" | "mobile">;
export declare type NotificationDeliveryPreferencesFragment = {
    __typename: "NotificationDeliveryPreferences";
} & {
    mobile?: Maybe<{
        __typename?: "NotificationDeliveryPreferencesChannel";
    } & NotificationDeliveryPreferencesChannelFragment>;
};
export declare type NotificationDeliveryPreferencesChannelFragment = {
    __typename: "NotificationDeliveryPreferencesChannel";
} & Pick<NotificationDeliveryPreferencesChannel, "notificationsDisabled"> & {
    schedule?: Maybe<{
        __typename?: "NotificationDeliveryPreferencesSchedule";
    } & NotificationDeliveryPreferencesScheduleFragment>;
};
export declare type NotificationDeliveryPreferencesDayFragment = {
    __typename: "NotificationDeliveryPreferencesDay";
} & Pick<NotificationDeliveryPreferencesDay, "end" | "start">;
export declare type NotificationDeliveryPreferencesScheduleFragment = {
    __typename: "NotificationDeliveryPreferencesSchedule";
} & Pick<NotificationDeliveryPreferencesSchedule, "disabled"> & {
    friday: {
        __typename?: "NotificationDeliveryPreferencesDay";
    } & NotificationDeliveryPreferencesDayFragment;
    monday: {
        __typename?: "NotificationDeliveryPreferencesDay";
    } & NotificationDeliveryPreferencesDayFragment;
    saturday: {
        __typename?: "NotificationDeliveryPreferencesDay";
    } & NotificationDeliveryPreferencesDayFragment;
    sunday: {
        __typename?: "NotificationDeliveryPreferencesDay";
    } & NotificationDeliveryPreferencesDayFragment;
    thursday: {
        __typename?: "NotificationDeliveryPreferencesDay";
    } & NotificationDeliveryPreferencesDayFragment;
    tuesday: {
        __typename?: "NotificationDeliveryPreferencesDay";
    } & NotificationDeliveryPreferencesDayFragment;
    wednesday: {
        __typename?: "NotificationDeliveryPreferencesDay";
    } & NotificationDeliveryPreferencesDayFragment;
};
export declare type PushSubscriptionFragment = {
    __typename: "PushSubscription";
} & Pick<PushSubscription, "updatedAt" | "archivedAt" | "createdAt" | "id">;
export declare type WebhookFragment = {
    __typename: "Webhook";
} & Pick<Webhook, "secret" | "updatedAt" | "resourceTypes" | "archivedAt" | "createdAt" | "id" | "url" | "label" | "allPublicTeams" | "enabled"> & {
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    creator?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type ApiKeyFragment = {
    __typename: "ApiKey";
} & Pick<ApiKey, "scope" | "label" | "updatedAt" | "requestedSyncGroups" | "archivedAt" | "createdAt" | "id">;
export declare type EmailIntakeAddressFragment = {
    __typename: "EmailIntakeAddress";
} & Pick<EmailIntakeAddress, "updatedAt" | "archivedAt" | "createdAt" | "id" | "address" | "repliesEnabled" | "customerRequestsEnabled" | "enabled"> & {
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    template?: Maybe<{
        __typename?: "Template";
    } & Pick<Template, "id">>;
    creator?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type ExternalUserFragment = {
    __typename: "ExternalUser";
} & Pick<ExternalUser, "avatarUrl" | "displayName" | "email" | "name" | "updatedAt" | "lastSeen" | "archivedAt" | "createdAt" | "id">;
export declare type EntityExternalLinkFragment = {
    __typename: "EntityExternalLink";
} & Pick<EntityExternalLink, "updatedAt" | "url" | "label" | "sortOrder" | "archivedAt" | "createdAt" | "id"> & {
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    creator: {
        __typename?: "User";
    } & Pick<User, "id">;
};
export declare type ProjectHistoryFragment = {
    __typename: "ProjectHistory";
} & Pick<ProjectHistory, "entries" | "updatedAt" | "archivedAt" | "createdAt" | "id"> & {
    project: {
        __typename?: "Project";
    } & Pick<Project, "id">;
};
export declare type IssueImportFragment = {
    __typename: "IssueImport";
} & Pick<IssueImport, "progress" | "errorMetadata" | "csvFileUrl" | "serviceMetadata" | "teamName" | "mapping" | "displayName" | "creatorId" | "updatedAt" | "service" | "status" | "archivedAt" | "createdAt" | "id" | "error">;
export declare type InitiativeNotificationSubscriptionFragment = {
    __typename: "InitiativeNotificationSubscription";
} & Pick<InitiativeNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "notificationSubscriptionTypes" | "userContextViewType" | "contextViewType" | "id" | "active"> & {
    customView?: Maybe<{
        __typename?: "CustomView";
    } & Pick<CustomView, "id">>;
    cycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    label?: Maybe<{
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    customer?: Maybe<{
        __typename?: "Customer";
    } & Pick<Customer, "id">>;
    initiative: {
        __typename?: "Initiative";
    } & Pick<Initiative, "id">;
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    subscriber: {
        __typename?: "User";
    } & Pick<User, "id">;
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type InitiativeNotificationFragment = {
    __typename: "InitiativeNotification";
} & Pick<InitiativeNotification, "reactionEmoji" | "type" | "commentId" | "initiativeId" | "initiativeUpdateId" | "parentCommentId" | "updatedAt" | "emailedAt" | "readAt" | "unsnoozedAt" | "archivedAt" | "createdAt" | "snoozedUntilAt" | "id"> & {
    botActor?: Maybe<{
        __typename?: "ActorBot";
    } & ActorBotFragment>;
    externalUserActor?: Maybe<{
        __typename?: "ExternalUser";
    } & Pick<ExternalUser, "id">>;
    actor?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
};
export declare type InitiativeFragment = {
    __typename: "Initiative";
} & Pick<Initiative, "trashed" | "url" | "updateRemindersDay" | "description" | "targetDate" | "updateReminderFrequency" | "health" | "updateRemindersHour" | "icon" | "color" | "content" | "slugId" | "updatedAt" | "updateReminderFrequencyInWeeks" | "name" | "targetDateResolution" | "frequencyResolution" | "sortOrder" | "status" | "archivedAt" | "createdAt" | "healthUpdatedAt" | "startedAt" | "completedAt" | "id"> & {
    integrationsSettings?: Maybe<{
        __typename?: "IntegrationsSettings";
    } & Pick<IntegrationsSettings, "id">>;
    lastUpdate?: Maybe<{
        __typename?: "InitiativeUpdate";
    } & Pick<InitiativeUpdate, "id">>;
    creator?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    owner?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type InitiativeUpdateFragment = {
    __typename: "InitiativeUpdate";
} & Pick<InitiativeUpdate, "reactionData" | "url" | "diffMarkdown" | "diff" | "health" | "updatedAt" | "archivedAt" | "createdAt" | "editedAt" | "id" | "body" | "slugId" | "isDiffHidden" | "isStale"> & {
    reactions: Array<{
        __typename?: "Reaction";
    } & ReactionFragment>;
    initiative: {
        __typename?: "Initiative";
    } & Pick<Initiative, "id">;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
};
export declare type IntegrationFragment = {
    __typename: "Integration";
} & Pick<Integration, "service" | "updatedAt" | "archivedAt" | "createdAt" | "id"> & {
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    creator: {
        __typename?: "User";
    } & Pick<User, "id">;
};
export declare type OrganizationInviteFragment = {
    __typename: "OrganizationInvite";
} & Pick<OrganizationInvite, "metadata" | "external" | "email" | "updatedAt" | "archivedAt" | "createdAt" | "acceptedAt" | "expiresAt" | "id" | "role"> & {
    inviter: {
        __typename?: "User";
    } & Pick<User, "id">;
    invitee?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type IssueNotificationFragment = {
    __typename: "IssueNotification";
} & Pick<IssueNotification, "reactionEmoji" | "type" | "commentId" | "issueId" | "parentCommentId" | "updatedAt" | "emailedAt" | "readAt" | "unsnoozedAt" | "archivedAt" | "createdAt" | "snoozedUntilAt" | "id"> & {
    botActor?: Maybe<{
        __typename?: "ActorBot";
    } & ActorBotFragment>;
    comment?: Maybe<{
        __typename?: "Comment";
    } & Pick<Comment, "id">>;
    externalUserActor?: Maybe<{
        __typename?: "ExternalUser";
    } & Pick<ExternalUser, "id">>;
    issue: {
        __typename?: "Issue";
    } & Pick<Issue, "id">;
    parentComment?: Maybe<{
        __typename?: "Comment";
    } & Pick<Comment, "id">>;
    subscriptions?: Maybe<Array<({
        __typename?: "CustomViewNotificationSubscription";
    } & NotificationSubscription_CustomViewNotificationSubscription_Fragment) | ({
        __typename?: "CustomerNotificationSubscription";
    } & NotificationSubscription_CustomerNotificationSubscription_Fragment) | ({
        __typename?: "CycleNotificationSubscription";
    } & NotificationSubscription_CycleNotificationSubscription_Fragment) | ({
        __typename?: "InitiativeNotificationSubscription";
    } & NotificationSubscription_InitiativeNotificationSubscription_Fragment) | ({
        __typename?: "LabelNotificationSubscription";
    } & NotificationSubscription_LabelNotificationSubscription_Fragment) | ({
        __typename?: "ProjectNotificationSubscription";
    } & NotificationSubscription_ProjectNotificationSubscription_Fragment) | ({
        __typename?: "TeamNotificationSubscription";
    } & NotificationSubscription_TeamNotificationSubscription_Fragment) | ({
        __typename?: "UserNotificationSubscription";
    } & NotificationSubscription_UserNotificationSubscription_Fragment)>>;
    team: {
        __typename?: "Team";
    } & Pick<Team, "id">;
    actor?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
};
export declare type IssueFragment = {
    __typename: "Issue";
} & Pick<Issue, "trashed" | "reactionData" | "labelIds" | "integrationSourceType" | "url" | "identifier" | "priorityLabel" | "previousIdentifiers" | "customerTicketCount" | "branchName" | "dueDate" | "estimate" | "description" | "title" | "number" | "updatedAt" | "boardOrder" | "prioritySortOrder" | "sortOrder" | "subIssueSortOrder" | "priority" | "archivedAt" | "createdAt" | "startedTriageAt" | "triagedAt" | "addedToCycleAt" | "addedToProjectAt" | "addedToTeamAt" | "autoArchivedAt" | "autoClosedAt" | "canceledAt" | "completedAt" | "startedAt" | "slaStartedAt" | "slaBreachesAt" | "slaHighRiskAt" | "slaMediumRiskAt" | "snoozedUntilAt" | "slaType" | "id"> & {
    reactions: Array<{
        __typename?: "Reaction";
    } & ReactionFragment>;
    botActor?: Maybe<{
        __typename?: "ActorBot";
    } & ActorBotFragment>;
    sourceComment?: Maybe<{
        __typename?: "Comment";
    } & Pick<Comment, "id">>;
    cycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    externalUserCreator?: Maybe<{
        __typename?: "ExternalUser";
    } & Pick<ExternalUser, "id">>;
    lastAppliedTemplate?: Maybe<{
        __typename?: "Template";
    } & Pick<Template, "id">>;
    parent?: Maybe<{
        __typename?: "Issue";
    } & Pick<Issue, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    projectMilestone?: Maybe<{
        __typename?: "ProjectMilestone";
    } & Pick<ProjectMilestone, "id">>;
    recurringIssueTemplate?: Maybe<{
        __typename?: "Template";
    } & Pick<Template, "id">>;
    team: {
        __typename?: "Team";
    } & Pick<Team, "id">;
    assignee?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    creator?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    snoozedBy?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    favorite?: Maybe<{
        __typename?: "Favorite";
    } & Pick<Favorite, "id">>;
    state: {
        __typename?: "WorkflowState";
    } & Pick<WorkflowState, "id">;
};
export declare type OauthClientApprovalNotificationFragment = {
    __typename: "OauthClientApprovalNotification";
} & Pick<OauthClientApprovalNotification, "type" | "oauthClientApprovalId" | "updatedAt" | "emailedAt" | "readAt" | "unsnoozedAt" | "archivedAt" | "createdAt" | "snoozedUntilAt" | "id"> & {
    oauthClientApproval: {
        __typename?: "OauthClientApproval";
    } & OauthClientApprovalFragment;
    botActor?: Maybe<{
        __typename?: "ActorBot";
    } & ActorBotFragment>;
    externalUserActor?: Maybe<{
        __typename?: "ExternalUser";
    } & Pick<ExternalUser, "id">>;
    actor?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
};
export declare type OrganizationFragment = {
    __typename: "Organization";
} & Pick<Organization, "allowedAuthServices" | "customersConfiguration" | "defaultFeedSummarySchedule" | "gitBranchFormat" | "userCount" | "customerCount" | "createdIssueCount" | "previousUrlKeys" | "periodUploadVolume" | "initiativeUpdateRemindersDay" | "projectUpdateRemindersDay" | "releaseChannel" | "initiativeUpdateRemindersHour" | "projectUpdateRemindersHour" | "updatedAt" | "fiscalYearStartMonth" | "initiativeUpdateReminderFrequencyInWeeks" | "projectUpdateReminderFrequencyInWeeks" | "logoUrl" | "name" | "urlKey" | "deletionRequestedAt" | "archivedAt" | "createdAt" | "trialEndsAt" | "id" | "samlEnabled" | "scimEnabled" | "allowMembersToInvite" | "restrictTeamCreationToAdmins" | "gitLinkbackMessagesEnabled" | "gitPublicLinkbackMessagesEnabled" | "feedEnabled" | "customersEnabled" | "roadmapEnabled" | "projectUpdatesReminderFrequency" | "slaDayCount"> & {
    ipRestrictions?: Maybe<Array<{
        __typename?: "OrganizationIpRestriction";
    } & OrganizationIpRestrictionFragment>>;
    projectStatuses: Array<{
        __typename?: "ProjectStatus";
    } & ProjectStatusFragment>;
    subscription?: Maybe<{
        __typename?: "PaidSubscription";
    } & PaidSubscriptionFragment>;
};
export declare type AuthOrganizationFragment = {
    __typename: "AuthOrganization";
} & Pick<AuthOrganization, "allowedAuthServices" | "previousUrlKeys" | "serviceId" | "releaseChannel" | "logoUrl" | "name" | "urlKey" | "region" | "deletionRequestedAt" | "id" | "samlEnabled" | "scimEnabled" | "enabled" | "userCount">;
export declare type TeamFragment = {
    __typename: "Team";
} & Pick<Team, "cycleIssueAutoAssignCompleted" | "cycleLockToActive" | "cycleIssueAutoAssignStarted" | "cycleCalenderUrl" | "upcomingCycleCount" | "issueCount" | "autoArchivePeriod" | "autoClosePeriod" | "scimGroupName" | "autoCloseStateId" | "cycleCooldownTime" | "cycleStartDay" | "cycleDuration" | "icon" | "defaultTemplateForMembersId" | "defaultTemplateForNonMembersId" | "issueEstimationType" | "updatedAt" | "displayName" | "color" | "description" | "name" | "key" | "archivedAt" | "createdAt" | "timezone" | "id" | "inviteHash" | "defaultIssueEstimate" | "setIssueSortOrderOnStateChange" | "requirePriorityToLeaveTriage" | "autoCloseChildIssues" | "autoCloseParentIssues" | "scimManaged" | "private" | "inheritIssueEstimation" | "inheritWorkflowStatuses" | "cyclesEnabled" | "issueEstimationExtended" | "issueEstimationAllowZero" | "aiThreadSummariesEnabled" | "groupIssueHistory" | "slackIssueComments" | "slackNewIssue" | "slackIssueStatuses" | "triageEnabled" | "issueOrderingNoPriorityFirst" | "issueSortOrderDefaultToBottom"> & {
    integrationsSettings?: Maybe<{
        __typename?: "IntegrationsSettings";
    } & Pick<IntegrationsSettings, "id">>;
    activeCycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    triageResponsibility?: Maybe<{
        __typename?: "TriageResponsibility";
    } & Pick<TriageResponsibility, "id">>;
    defaultTemplateForMembers?: Maybe<{
        __typename?: "Template";
    } & Pick<Template, "id">>;
    defaultTemplateForNonMembers?: Maybe<{
        __typename?: "Template";
    } & Pick<Template, "id">>;
    defaultProjectTemplate?: Maybe<{
        __typename?: "Template";
    } & Pick<Template, "id">>;
    defaultIssueState?: Maybe<{
        __typename?: "WorkflowState";
    } & Pick<WorkflowState, "id">>;
    mergeWorkflowState?: Maybe<{
        __typename?: "WorkflowState";
    } & Pick<WorkflowState, "id">>;
    draftWorkflowState?: Maybe<{
        __typename?: "WorkflowState";
    } & Pick<WorkflowState, "id">>;
    startWorkflowState?: Maybe<{
        __typename?: "WorkflowState";
    } & Pick<WorkflowState, "id">>;
    mergeableWorkflowState?: Maybe<{
        __typename?: "WorkflowState";
    } & Pick<WorkflowState, "id">>;
    reviewWorkflowState?: Maybe<{
        __typename?: "WorkflowState";
    } & Pick<WorkflowState, "id">>;
    markedAsDuplicateWorkflowState?: Maybe<{
        __typename?: "WorkflowState";
    } & Pick<WorkflowState, "id">>;
    triageIssueState?: Maybe<{
        __typename?: "WorkflowState";
    } & Pick<WorkflowState, "id">>;
};
export declare type ProjectUpdateFragment = {
    __typename: "ProjectUpdate";
} & Pick<ProjectUpdate, "reactionData" | "url" | "diffMarkdown" | "diff" | "health" | "updatedAt" | "archivedAt" | "createdAt" | "editedAt" | "id" | "body" | "slugId" | "isDiffHidden" | "isStale"> & {
    reactions: Array<{
        __typename?: "Reaction";
    } & ReactionFragment>;
    project: {
        __typename?: "Project";
    } & Pick<Project, "id">;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
};
export declare type AuthenticationSessionResponseFragment = {
    __typename: "AuthenticationSessionResponse";
} & Pick<AuthenticationSessionResponse, "client" | "countryCodes" | "createdAt" | "updatedAt" | "location" | "ip" | "isCurrentSession" | "locationCity" | "locationCountryCode" | "locationCountry" | "locationRegionCode" | "name" | "operatingSystem" | "service" | "userAgent" | "type" | "browserType" | "lastActiveAt" | "id">;
export declare type ArchiveResponseFragment = {
    __typename: "ArchiveResponse";
} & Pick<ArchiveResponse, "archive" | "totalCount" | "databaseVersion" | "includesDependencies">;
export declare type TeamMembershipFragment = {
    __typename: "TeamMembership";
} & Pick<TeamMembership, "updatedAt" | "sortOrder" | "archivedAt" | "createdAt" | "id" | "owner"> & {
    team: {
        __typename?: "Team";
    } & Pick<Team, "id">;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
};
export declare type OrganizationDomainFragment = {
    __typename: "OrganizationDomain";
} & Pick<OrganizationDomain, "name" | "verificationEmail" | "verified" | "disableOrganizationCreation" | "updatedAt" | "archivedAt" | "createdAt" | "id" | "authType" | "claimed"> & {
    creator?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type AuthorizingUserFragment = {
    __typename: "AuthorizingUser";
} & Pick<AuthorizingUser, "displayName" | "name">;
export declare type WebhookFailureEventFragment = {
    __typename: "WebhookFailureEvent";
} & Pick<WebhookFailureEvent, "responseOrError" | "httpStatus" | "url" | "createdAt" | "executionId" | "id"> & {
    webhook: {
        __typename?: "Webhook";
    } & Pick<Webhook, "id">;
};
export declare type AttachmentFragment = {
    __typename: "Attachment";
} & Pick<Attachment, "sourceType" | "subtitle" | "title" | "metadata" | "groupBySource" | "source" | "url" | "bodyData" | "updatedAt" | "archivedAt" | "createdAt" | "id"> & {
    creator?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    issue: {
        __typename?: "Issue";
    } & Pick<Issue, "id">;
    externalUserCreator?: Maybe<{
        __typename?: "ExternalUser";
    } & Pick<ExternalUser, "id">>;
};
export declare type IssueRelationHistoryPayloadFragment = {
    __typename: "IssueRelationHistoryPayload";
} & Pick<IssueRelationHistoryPayload, "identifier" | "type">;
export declare type InitiativeToProjectFragment = {
    __typename: "InitiativeToProject";
} & Pick<InitiativeToProject, "updatedAt" | "sortOrder" | "archivedAt" | "createdAt" | "id"> & {
    initiative: {
        __typename?: "Initiative";
    } & Pick<Initiative, "id">;
    project: {
        __typename?: "Project";
    } & Pick<Project, "id">;
};
export declare type RoadmapToProjectFragment = {
    __typename: "RoadmapToProject";
} & Pick<RoadmapToProject, "updatedAt" | "sortOrder" | "archivedAt" | "createdAt" | "id"> & {
    project: {
        __typename?: "Project";
    } & Pick<Project, "id">;
    roadmap: {
        __typename?: "Roadmap";
    } & Pick<Roadmap, "id">;
};
export declare type IntegrationTemplateFragment = {
    __typename: "IntegrationTemplate";
} & Pick<IntegrationTemplate, "foreignEntityId" | "updatedAt" | "archivedAt" | "createdAt" | "id"> & {
    integration: {
        __typename?: "Integration";
    } & Pick<Integration, "id">;
    template: {
        __typename?: "Template";
    } & Pick<Template, "id">;
};
export declare type IssueLabelFragment = {
    __typename: "IssueLabel";
} & Pick<IssueLabel, "color" | "description" | "name" | "updatedAt" | "archivedAt" | "createdAt" | "id" | "isGroup"> & {
    inheritedFrom?: Maybe<{
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">>;
    parent?: Maybe<{
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">>;
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    creator?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
declare type NotificationSubscription_CustomViewNotificationSubscription_Fragment = {
    __typename: "CustomViewNotificationSubscription";
} & Pick<CustomViewNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "userContextViewType" | "contextViewType" | "id" | "active"> & {
    customView: {
        __typename?: "CustomView";
    } & Pick<CustomView, "id">;
    cycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    label?: Maybe<{
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    customer?: Maybe<{
        __typename?: "Customer";
    } & Pick<Customer, "id">>;
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    subscriber: {
        __typename?: "User";
    } & Pick<User, "id">;
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
declare type NotificationSubscription_CustomerNotificationSubscription_Fragment = {
    __typename: "CustomerNotificationSubscription";
} & Pick<CustomerNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "userContextViewType" | "contextViewType" | "id" | "active"> & {
    customView?: Maybe<{
        __typename?: "CustomView";
    } & Pick<CustomView, "id">>;
    cycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    label?: Maybe<{
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    customer: {
        __typename?: "Customer";
    } & Pick<Customer, "id">;
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    subscriber: {
        __typename?: "User";
    } & Pick<User, "id">;
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
declare type NotificationSubscription_CycleNotificationSubscription_Fragment = {
    __typename: "CycleNotificationSubscription";
} & Pick<CycleNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "userContextViewType" | "contextViewType" | "id" | "active"> & {
    customView?: Maybe<{
        __typename?: "CustomView";
    } & Pick<CustomView, "id">>;
    cycle: {
        __typename?: "Cycle";
    } & Pick<Cycle, "id">;
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    label?: Maybe<{
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    customer?: Maybe<{
        __typename?: "Customer";
    } & Pick<Customer, "id">>;
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    subscriber: {
        __typename?: "User";
    } & Pick<User, "id">;
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
declare type NotificationSubscription_InitiativeNotificationSubscription_Fragment = {
    __typename: "InitiativeNotificationSubscription";
} & Pick<InitiativeNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "userContextViewType" | "contextViewType" | "id" | "active"> & {
    customView?: Maybe<{
        __typename?: "CustomView";
    } & Pick<CustomView, "id">>;
    cycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    initiative: {
        __typename?: "Initiative";
    } & Pick<Initiative, "id">;
    label?: Maybe<{
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    customer?: Maybe<{
        __typename?: "Customer";
    } & Pick<Customer, "id">>;
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    subscriber: {
        __typename?: "User";
    } & Pick<User, "id">;
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
declare type NotificationSubscription_LabelNotificationSubscription_Fragment = {
    __typename: "LabelNotificationSubscription";
} & Pick<LabelNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "userContextViewType" | "contextViewType" | "id" | "active"> & {
    customView?: Maybe<{
        __typename?: "CustomView";
    } & Pick<CustomView, "id">>;
    cycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    label: {
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    customer?: Maybe<{
        __typename?: "Customer";
    } & Pick<Customer, "id">>;
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    subscriber: {
        __typename?: "User";
    } & Pick<User, "id">;
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
declare type NotificationSubscription_ProjectNotificationSubscription_Fragment = {
    __typename: "ProjectNotificationSubscription";
} & Pick<ProjectNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "userContextViewType" | "contextViewType" | "id" | "active"> & {
    customView?: Maybe<{
        __typename?: "CustomView";
    } & Pick<CustomView, "id">>;
    cycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    label?: Maybe<{
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">>;
    project: {
        __typename?: "Project";
    } & Pick<Project, "id">;
    customer?: Maybe<{
        __typename?: "Customer";
    } & Pick<Customer, "id">>;
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    subscriber: {
        __typename?: "User";
    } & Pick<User, "id">;
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
declare type NotificationSubscription_TeamNotificationSubscription_Fragment = {
    __typename: "TeamNotificationSubscription";
} & Pick<TeamNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "userContextViewType" | "contextViewType" | "id" | "active"> & {
    customView?: Maybe<{
        __typename?: "CustomView";
    } & Pick<CustomView, "id">>;
    cycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    label?: Maybe<{
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    customer?: Maybe<{
        __typename?: "Customer";
    } & Pick<Customer, "id">>;
    team: {
        __typename?: "Team";
    } & Pick<Team, "id">;
    subscriber: {
        __typename?: "User";
    } & Pick<User, "id">;
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
declare type NotificationSubscription_UserNotificationSubscription_Fragment = {
    __typename: "UserNotificationSubscription";
} & Pick<UserNotificationSubscription, "updatedAt" | "archivedAt" | "createdAt" | "userContextViewType" | "contextViewType" | "id" | "active"> & {
    customView?: Maybe<{
        __typename?: "CustomView";
    } & Pick<CustomView, "id">>;
    cycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    label?: Maybe<{
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    customer?: Maybe<{
        __typename?: "Customer";
    } & Pick<Customer, "id">>;
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    subscriber: {
        __typename?: "User";
    } & Pick<User, "id">;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
};
export declare type NotificationSubscriptionFragment = NotificationSubscription_CustomViewNotificationSubscription_Fragment | NotificationSubscription_CustomerNotificationSubscription_Fragment | NotificationSubscription_CycleNotificationSubscription_Fragment | NotificationSubscription_InitiativeNotificationSubscription_Fragment | NotificationSubscription_LabelNotificationSubscription_Fragment | NotificationSubscription_ProjectNotificationSubscription_Fragment | NotificationSubscription_TeamNotificationSubscription_Fragment | NotificationSubscription_UserNotificationSubscription_Fragment;
export declare type SlackChannelNameMappingFragment = {
    __typename: "SlackChannelNameMapping";
} & Pick<SlackChannelNameMapping, "id" | "name" | "autoCreateTemplateId" | "autoCreateOnBotMention" | "postCancellationUpdates" | "postCompletionUpdates" | "postAcceptedFromTriageUpdates" | "botAdded" | "isPrivate" | "isShared" | "aiTitles" | "autoCreateOnMessage" | "autoCreateOnEmoji"> & {
    teams: Array<{
        __typename?: "SlackAsksTeamSettings";
    } & SlackAsksTeamSettingsFragment>;
};
export declare type UploadFileFragment = {
    __typename: "UploadFile";
} & Pick<UploadFile, "assetUrl" | "contentType" | "filename" | "uploadUrl" | "size" | "metaData"> & {
    headers: Array<{
        __typename?: "UploadFileHeader";
    } & UploadFileHeaderFragment>;
};
export declare type UserAuthorizedApplicationFragment = {
    __typename: "UserAuthorizedApplication";
} & Pick<UserAuthorizedApplication, "name" | "approvalErrorCode" | "imageUrl" | "description" | "developer" | "id" | "clientId" | "developerUrl" | "webhooksEnabled" | "createdByLinear" | "isAuthorized">;
export declare type ApplicationFragment = {
    __typename: "Application";
} & Pick<Application, "name" | "imageUrl" | "description" | "developer" | "id" | "clientId" | "developerUrl">;
export declare type OauthClientApprovalFragment = {
    __typename: "OauthClientApproval";
} & Pick<OauthClientApproval, "updatedAt" | "requesterId" | "responderId" | "requestReason" | "denyReason" | "scopes" | "status" | "archivedAt" | "createdAt" | "id" | "oauthClientId">;
export declare type IntegrationsSettingsFragment = {
    __typename: "IntegrationsSettings";
} & Pick<IntegrationsSettings, "updatedAt" | "archivedAt" | "createdAt" | "contextViewType" | "id" | "slackIssueNewComment" | "slackInitiativeUpdateCreated" | "slackIssueAddedToTriage" | "slackIssueCreated" | "slackProjectUpdateCreated" | "slackIssueSlaHighRisk" | "slackIssueSlaBreached" | "slackIssueAddedToView" | "slackIssueStatusChangedDone" | "slackIssueStatusChangedAll" | "slackProjectUpdateCreatedToTeam" | "slackProjectUpdateCreatedToWorkspace"> & {
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
};
export declare type PaidSubscriptionFragment = {
    __typename: "PaidSubscription";
} & Pick<PaidSubscription, "collectionMethod" | "cancelAt" | "canceledAt" | "nextBillingAt" | "updatedAt" | "seatsMaximum" | "seatsMinimum" | "seats" | "pendingChangeType" | "type" | "archivedAt" | "createdAt" | "id"> & {
    creator?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type InitiativePayloadFragment = {
    __typename: "InitiativePayload";
} & Pick<InitiativePayload, "lastSyncId" | "success"> & {
    initiative: {
        __typename?: "Initiative";
    } & Pick<Initiative, "id">;
};
export declare type InitiativeToProjectPayloadFragment = {
    __typename: "InitiativeToProjectPayload";
} & Pick<InitiativeToProjectPayload, "lastSyncId" | "success"> & {
    initiativeToProject: {
        __typename?: "InitiativeToProject";
    } & Pick<InitiativeToProject, "id">;
};
export declare type UserSettingsFragment = {
    __typename: "UserSettings";
} & Pick<UserSettings, "calendarHash" | "unsubscribedFrom" | "updatedAt" | "archivedAt" | "createdAt" | "id" | "subscribedToDPA" | "subscribedToChangelog" | "subscribedToInviteAccepted" | "subscribedToPrivacyLegalUpdates" | "autoAssignToSelf" | "showFullUserNames"> & {
    notificationDeliveryPreferences: {
        __typename?: "NotificationDeliveryPreferences";
    } & NotificationDeliveryPreferencesFragment;
    user: {
        __typename?: "User";
    } & Pick<User, "id">;
    notificationCategoryPreferences: {
        __typename?: "NotificationCategoryPreferences";
    } & NotificationCategoryPreferencesFragment;
    notificationChannelPreferences: {
        __typename?: "NotificationChannelPreferences";
    } & NotificationChannelPreferencesFragment;
};
export declare type SlackAsksTeamSettingsFragment = {
    __typename: "SlackAsksTeamSettings";
} & Pick<SlackAsksTeamSettings, "id" | "hasDefaultAsk">;
export declare type FavoriteFragment = {
    __typename: "Favorite";
} & Pick<Favorite, "updatedAt" | "folderName" | "sortOrder" | "initiativeTab" | "projectTab" | "archivedAt" | "createdAt" | "predefinedViewType" | "type" | "id" | "url"> & {
    customView?: Maybe<{
        __typename?: "CustomView";
    } & Pick<CustomView, "id">>;
    customer?: Maybe<{
        __typename?: "Customer";
    } & Pick<Customer, "id">>;
    cycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    document?: Maybe<{
        __typename?: "Document";
    } & Pick<Document, "id">>;
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    issue?: Maybe<{
        __typename?: "Issue";
    } & Pick<Issue, "id">>;
    label?: Maybe<{
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    roadmap?: Maybe<{
        __typename?: "Roadmap";
    } & Pick<Roadmap, "id">>;
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    owner: {
        __typename?: "User";
    } & Pick<User, "id">;
    parent?: Maybe<{
        __typename?: "Favorite";
    } & Pick<Favorite, "id">>;
    predefinedViewTeam?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
    projectTeam?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
};
export declare type ViewPreferencesFragment = {
    __typename: "ViewPreferences";
} & Pick<ViewPreferences, "updatedAt" | "archivedAt" | "createdAt" | "id" | "type" | "viewType"> & {
    preferences: {
        __typename?: "ViewPreferencesValues";
    } & ViewPreferencesValuesFragment;
};
export declare type IssueImportJqlCheckPayloadFragment = {
    __typename: "IssueImportJqlCheckPayload";
} & Pick<IssueImportJqlCheckPayload, "error" | "count" | "success">;
export declare type IssueImportSyncCheckPayloadFragment = {
    __typename: "IssueImportSyncCheckPayload";
} & Pick<IssueImportSyncCheckPayload, "error" | "canSync">;
export declare type AuditEntryFragment = {
    __typename: "AuditEntry";
} & Pick<AuditEntry, "requestInformation" | "metadata" | "countryCode" | "ip" | "actorId" | "updatedAt" | "archivedAt" | "createdAt" | "id" | "type"> & {
    actor?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type ApiKeyConnectionFragment = {
    __typename: "ApiKeyConnection";
} & {
    nodes: Array<{
        __typename?: "ApiKey";
    } & ApiKeyFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type ApiKeyPayloadFragment = {
    __typename: "ApiKeyPayload";
} & Pick<ApiKeyPayload, "lastSyncId" | "success"> & {
    apiKey: {
        __typename?: "ApiKey";
    } & ApiKeyFragment;
};
export declare type AsksChannelConnectPayloadFragment = {
    __typename: "AsksChannelConnectPayload";
} & Pick<AsksChannelConnectPayload, "lastSyncId" | "addBot" | "success"> & {
    integration?: Maybe<{
        __typename?: "Integration";
    } & Pick<Integration, "id">>;
    mapping: {
        __typename?: "SlackChannelNameMapping";
    } & SlackChannelNameMappingFragment;
};
export declare type AttachmentConnectionFragment = {
    __typename: "AttachmentConnection";
} & {
    nodes: Array<{
        __typename?: "Attachment";
    } & AttachmentFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type AttachmentPayloadFragment = {
    __typename: "AttachmentPayload";
} & Pick<AttachmentPayload, "lastSyncId" | "success"> & {
    attachment: {
        __typename?: "Attachment";
    } & Pick<Attachment, "id">;
};
export declare type AttachmentSourcesPayloadFragment = {
    __typename: "AttachmentSourcesPayload";
} & Pick<AttachmentSourcesPayload, "sources">;
export declare type AuditEntryConnectionFragment = {
    __typename: "AuditEntryConnection";
} & {
    nodes: Array<{
        __typename?: "AuditEntry";
    } & AuditEntryFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type AuditEntryTypeFragment = {
    __typename: "AuditEntryType";
} & Pick<AuditEntryType, "description" | "type">;
export declare type AuthResolverResponseFragment = {
    __typename: "AuthResolverResponse";
} & Pick<AuthResolverResponse, "token" | "email" | "lastUsedOrganizationId" | "allowDomainAccess" | "id"> & {
    users: Array<{
        __typename?: "AuthUser";
    } & AuthUserFragment>;
    lockedUsers: Array<{
        __typename?: "AuthUser";
    } & AuthUserFragment>;
    lockedOrganizations?: Maybe<Array<{
        __typename?: "AuthOrganization";
    } & AuthOrganizationFragment>>;
    availableOrganizations?: Maybe<Array<{
        __typename?: "AuthOrganization";
    } & AuthOrganizationFragment>>;
};
export declare type CommentConnectionFragment = {
    __typename: "CommentConnection";
} & {
    nodes: Array<{
        __typename?: "Comment";
    } & CommentFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type CommentPayloadFragment = {
    __typename: "CommentPayload";
} & Pick<CommentPayload, "lastSyncId" | "success"> & {
    comment: {
        __typename?: "Comment";
    } & Pick<Comment, "id">;
};
export declare type ContactPayloadFragment = {
    __typename: "ContactPayload";
} & Pick<ContactPayload, "success">;
export declare type CreateCsvExportReportPayloadFragment = {
    __typename: "CreateCsvExportReportPayload";
} & Pick<CreateCsvExportReportPayload, "success">;
export declare type CreateOrJoinOrganizationResponseFragment = {
    __typename: "CreateOrJoinOrganizationResponse";
} & {
    organization: {
        __typename?: "AuthOrganization";
    } & AuthOrganizationFragment;
    user: {
        __typename?: "AuthUser";
    } & AuthUserFragment;
};
export declare type CustomViewConnectionFragment = {
    __typename: "CustomViewConnection";
} & {
    nodes: Array<{
        __typename?: "CustomView";
    } & CustomViewFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type CustomViewHasSubscribersPayloadFragment = {
    __typename: "CustomViewHasSubscribersPayload";
} & Pick<CustomViewHasSubscribersPayload, "hasSubscribers">;
export declare type CustomViewPayloadFragment = {
    __typename: "CustomViewPayload";
} & Pick<CustomViewPayload, "lastSyncId" | "success"> & {
    customView: {
        __typename?: "CustomView";
    } & Pick<CustomView, "id">;
};
export declare type CustomViewSuggestionPayloadFragment = {
    __typename: "CustomViewSuggestionPayload";
} & Pick<CustomViewSuggestionPayload, "description" | "icon" | "name">;
export declare type CustomerConnectionFragment = {
    __typename: "CustomerConnection";
} & {
    nodes: Array<{
        __typename?: "Customer";
    } & CustomerFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type CustomerNeedConnectionFragment = {
    __typename: "CustomerNeedConnection";
} & {
    nodes: Array<{
        __typename?: "CustomerNeed";
    } & CustomerNeedFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type CustomerNeedPayloadFragment = {
    __typename: "CustomerNeedPayload";
} & Pick<CustomerNeedPayload, "lastSyncId" | "success"> & {
    need: {
        __typename?: "CustomerNeed";
    } & Pick<CustomerNeed, "id">;
};
export declare type CustomerPayloadFragment = {
    __typename: "CustomerPayload";
} & Pick<CustomerPayload, "lastSyncId" | "success"> & {
    customer: {
        __typename?: "Customer";
    } & Pick<Customer, "id">;
};
export declare type CustomerStatusConnectionFragment = {
    __typename: "CustomerStatusConnection";
} & {
    nodes: Array<{
        __typename?: "CustomerStatus";
    } & CustomerStatusFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type CustomerTierConnectionFragment = {
    __typename: "CustomerTierConnection";
} & {
    nodes: Array<{
        __typename?: "CustomerTier";
    } & CustomerTierFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type CustomerTierPayloadFragment = {
    __typename: "CustomerTierPayload";
} & Pick<CustomerTierPayload, "lastSyncId" | "success"> & {
    tier: {
        __typename?: "CustomerTier";
    } & Pick<CustomerTier, "id">;
};
export declare type CycleConnectionFragment = {
    __typename: "CycleConnection";
} & {
    nodes: Array<{
        __typename?: "Cycle";
    } & CycleFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type CyclePayloadFragment = {
    __typename: "CyclePayload";
} & Pick<CyclePayload, "lastSyncId" | "success"> & {
    cycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
};
export declare type DocumentConnectionFragment = {
    __typename: "DocumentConnection";
} & {
    nodes: Array<{
        __typename?: "Document";
    } & DocumentFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type DocumentContentHistoryPayloadFragment = {
    __typename: "DocumentContentHistoryPayload";
} & Pick<DocumentContentHistoryPayload, "success"> & {
    history: Array<{
        __typename?: "DocumentContentHistoryType";
    } & DocumentContentHistoryTypeFragment>;
};
export declare type DocumentContentHistoryTypeFragment = {
    __typename: "DocumentContentHistoryType";
} & Pick<DocumentContentHistoryType, "actorIds" | "id" | "createdAt" | "contentDataSnapshotAt">;
export declare type DocumentPayloadFragment = {
    __typename: "DocumentPayload";
} & Pick<DocumentPayload, "lastSyncId" | "success"> & {
    document: {
        __typename?: "Document";
    } & Pick<Document, "id">;
};
export declare type DocumentSearchPayloadFragment = {
    __typename: "DocumentSearchPayload";
} & Pick<DocumentSearchPayload, "totalCount"> & {
    archivePayload: {
        __typename?: "ArchiveResponse";
    } & ArchiveResponseFragment;
    nodes: Array<{
        __typename?: "DocumentSearchResult";
    } & DocumentSearchResultFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type DocumentSearchResultFragment = {
    __typename: "DocumentSearchResult";
} & Pick<DocumentSearchResult, "trashed" | "metadata" | "documentContentId" | "url" | "color" | "title" | "slugId" | "content" | "icon" | "updatedAt" | "sortOrder" | "hiddenAt" | "archivedAt" | "createdAt" | "id"> & {
    initiative?: Maybe<{
        __typename?: "Initiative";
    } & Pick<Initiative, "id">>;
    lastAppliedTemplate?: Maybe<{
        __typename?: "Template";
    } & Pick<Template, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    creator?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    updatedBy?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type DraftConnectionFragment = {
    __typename: "DraftConnection";
} & {
    nodes: Array<{
        __typename?: "Draft";
    } & DraftFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type EmailIntakeAddressPayloadFragment = {
    __typename: "EmailIntakeAddressPayload";
} & Pick<EmailIntakeAddressPayload, "lastSyncId" | "success"> & {
    emailIntakeAddress: {
        __typename?: "EmailIntakeAddress";
    } & EmailIntakeAddressFragment;
};
export declare type EmailUnsubscribePayloadFragment = {
    __typename: "EmailUnsubscribePayload";
} & Pick<EmailUnsubscribePayload, "success">;
export declare type EmailUserAccountAuthChallengeResponseFragment = {
    __typename: "EmailUserAccountAuthChallengeResponse";
} & Pick<EmailUserAccountAuthChallengeResponse, "authType" | "success">;
export declare type EmojiConnectionFragment = {
    __typename: "EmojiConnection";
} & {
    nodes: Array<{
        __typename?: "Emoji";
    } & EmojiFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type EmojiPayloadFragment = {
    __typename: "EmojiPayload";
} & Pick<EmojiPayload, "lastSyncId" | "success"> & {
    emoji: {
        __typename?: "Emoji";
    } & Pick<Emoji, "id">;
};
export declare type EntityExternalLinkConnectionFragment = {
    __typename: "EntityExternalLinkConnection";
} & {
    nodes: Array<{
        __typename?: "EntityExternalLink";
    } & EntityExternalLinkFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type EntityExternalLinkPayloadFragment = {
    __typename: "EntityExternalLinkPayload";
} & Pick<EntityExternalLinkPayload, "lastSyncId" | "success"> & {
    entityExternalLink: {
        __typename?: "EntityExternalLink";
    } & Pick<EntityExternalLink, "id">;
};
export declare type ExternalUserConnectionFragment = {
    __typename: "ExternalUserConnection";
} & {
    nodes: Array<{
        __typename?: "ExternalUser";
    } & ExternalUserFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type FavoriteConnectionFragment = {
    __typename: "FavoriteConnection";
} & {
    nodes: Array<{
        __typename?: "Favorite";
    } & FavoriteFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type FavoritePayloadFragment = {
    __typename: "FavoritePayload";
} & Pick<FavoritePayload, "lastSyncId" | "success"> & {
    favorite: {
        __typename?: "Favorite";
    } & Pick<Favorite, "id">;
};
export declare type FrontAttachmentPayloadFragment = {
    __typename: "FrontAttachmentPayload";
} & Pick<FrontAttachmentPayload, "lastSyncId" | "success"> & {
    attachment: {
        __typename?: "Attachment";
    } & Pick<Attachment, "id">;
};
export declare type GitAutomationStateConnectionFragment = {
    __typename: "GitAutomationStateConnection";
} & {
    nodes: Array<{
        __typename?: "GitAutomationState";
    } & GitAutomationStateFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type GitAutomationStatePayloadFragment = {
    __typename: "GitAutomationStatePayload";
} & Pick<GitAutomationStatePayload, "lastSyncId" | "success"> & {
    gitAutomationState: {
        __typename?: "GitAutomationState";
    } & GitAutomationStateFragment;
};
export declare type GitAutomationTargetBranchPayloadFragment = {
    __typename: "GitAutomationTargetBranchPayload";
} & Pick<GitAutomationTargetBranchPayload, "lastSyncId" | "success"> & {
    targetBranch: {
        __typename?: "GitAutomationTargetBranch";
    } & GitAutomationTargetBranchFragment;
};
export declare type GitHubCommitIntegrationPayloadFragment = {
    __typename: "GitHubCommitIntegrationPayload";
} & Pick<GitHubCommitIntegrationPayload, "lastSyncId" | "webhookSecret" | "success"> & {
    integration?: Maybe<{
        __typename?: "Integration";
    } & Pick<Integration, "id">>;
};
export declare type GitHubEnterpriseServerInstallVerificationPayloadFragment = {
    __typename: "GitHubEnterpriseServerInstallVerificationPayload";
} & Pick<GitHubEnterpriseServerInstallVerificationPayload, "success">;
export declare type GitHubEnterpriseServerPayloadFragment = {
    __typename: "GitHubEnterpriseServerPayload";
} & Pick<GitHubEnterpriseServerPayload, "installUrl" | "lastSyncId" | "setupUrl" | "webhookSecret" | "success"> & {
    integration?: Maybe<{
        __typename?: "Integration";
    } & Pick<Integration, "id">>;
};
export declare type GitLabIntegrationCreatePayloadFragment = {
    __typename: "GitLabIntegrationCreatePayload";
} & Pick<GitLabIntegrationCreatePayload, "lastSyncId" | "webhookSecret" | "success"> & {
    integration?: Maybe<{
        __typename?: "Integration";
    } & Pick<Integration, "id">>;
};
export declare type ImageUploadFromUrlPayloadFragment = {
    __typename: "ImageUploadFromUrlPayload";
} & Pick<ImageUploadFromUrlPayload, "url" | "lastSyncId" | "success">;
export declare type InitiativeConnectionFragment = {
    __typename: "InitiativeConnection";
} & {
    nodes: Array<{
        __typename?: "Initiative";
    } & InitiativeFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type InitiativeHistoryConnectionFragment = {
    __typename: "InitiativeHistoryConnection";
} & {
    nodes: Array<{
        __typename?: "InitiativeHistory";
    } & InitiativeHistoryFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type InitiativeRelationConnectionFragment = {
    __typename: "InitiativeRelationConnection";
} & {
    nodes: Array<{
        __typename?: "InitiativeRelation";
    } & InitiativeRelationFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type InitiativeRelationPayloadFragment = {
    __typename: "InitiativeRelationPayload";
} & Pick<InitiativeRelationPayload, "lastSyncId" | "success"> & {
    initiativeRelation: {
        __typename?: "InitiativeRelation";
    } & InitiativeRelationFragment;
};
export declare type InitiativeToProjectConnectionFragment = {
    __typename: "InitiativeToProjectConnection";
} & {
    nodes: Array<{
        __typename?: "InitiativeToProject";
    } & InitiativeToProjectFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type InitiativeUpdateConnectionFragment = {
    __typename: "InitiativeUpdateConnection";
} & {
    nodes: Array<{
        __typename?: "InitiativeUpdate";
    } & InitiativeUpdateFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type InitiativeUpdatePayloadFragment = {
    __typename: "InitiativeUpdatePayload";
} & Pick<InitiativeUpdatePayload, "lastSyncId" | "success"> & {
    initiativeUpdate: {
        __typename?: "InitiativeUpdate";
    } & Pick<InitiativeUpdate, "id">;
};
export declare type InitiativeUpdateReminderPayloadFragment = {
    __typename: "InitiativeUpdateReminderPayload";
} & Pick<InitiativeUpdateReminderPayload, "lastSyncId" | "success">;
export declare type IntegrationConnectionFragment = {
    __typename: "IntegrationConnection";
} & {
    nodes: Array<{
        __typename?: "Integration";
    } & IntegrationFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type IntegrationHasScopesPayloadFragment = {
    __typename: "IntegrationHasScopesPayload";
} & Pick<IntegrationHasScopesPayload, "missingScopes" | "hasAllScopes">;
export declare type IntegrationPayloadFragment = {
    __typename: "IntegrationPayload";
} & Pick<IntegrationPayload, "lastSyncId" | "success"> & {
    integration?: Maybe<{
        __typename?: "Integration";
    } & Pick<Integration, "id">>;
};
export declare type IntegrationRequestPayloadFragment = {
    __typename: "IntegrationRequestPayload";
} & Pick<IntegrationRequestPayload, "success">;
export declare type IntegrationTemplateConnectionFragment = {
    __typename: "IntegrationTemplateConnection";
} & {
    nodes: Array<{
        __typename?: "IntegrationTemplate";
    } & IntegrationTemplateFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type IntegrationTemplatePayloadFragment = {
    __typename: "IntegrationTemplatePayload";
} & Pick<IntegrationTemplatePayload, "lastSyncId" | "success"> & {
    integrationTemplate: {
        __typename?: "IntegrationTemplate";
    } & Pick<IntegrationTemplate, "id">;
};
export declare type IntegrationsSettingsPayloadFragment = {
    __typename: "IntegrationsSettingsPayload";
} & Pick<IntegrationsSettingsPayload, "lastSyncId" | "success"> & {
    integrationsSettings: {
        __typename?: "IntegrationsSettings";
    } & Pick<IntegrationsSettings, "id">;
};
export declare type IssueBatchPayloadFragment = {
    __typename: "IssueBatchPayload";
} & Pick<IssueBatchPayload, "lastSyncId" | "success"> & {
    issues: Array<{
        __typename?: "Issue";
    } & IssueFragment>;
};
export declare type IssueConnectionFragment = {
    __typename: "IssueConnection";
} & {
    nodes: Array<{
        __typename?: "Issue";
    } & IssueFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type IssueFilterSuggestionPayloadFragment = {
    __typename: "IssueFilterSuggestionPayload";
} & Pick<IssueFilterSuggestionPayload, "filter" | "logId">;
export declare type IssueHistoryConnectionFragment = {
    __typename: "IssueHistoryConnection";
} & {
    nodes: Array<{
        __typename?: "IssueHistory";
    } & IssueHistoryFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type IssueImportCheckPayloadFragment = {
    __typename: "IssueImportCheckPayload";
} & Pick<IssueImportCheckPayload, "success">;
export declare type IssueImportDeletePayloadFragment = {
    __typename: "IssueImportDeletePayload";
} & Pick<IssueImportDeletePayload, "lastSyncId" | "success"> & {
    issueImport?: Maybe<{
        __typename?: "IssueImport";
    } & IssueImportFragment>;
};
export declare type IssueImportPayloadFragment = {
    __typename: "IssueImportPayload";
} & Pick<IssueImportPayload, "lastSyncId" | "success"> & {
    issueImport?: Maybe<{
        __typename?: "IssueImport";
    } & IssueImportFragment>;
};
export declare type IssueLabelConnectionFragment = {
    __typename: "IssueLabelConnection";
} & {
    nodes: Array<{
        __typename?: "IssueLabel";
    } & IssueLabelFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type IssueLabelPayloadFragment = {
    __typename: "IssueLabelPayload";
} & Pick<IssueLabelPayload, "lastSyncId" | "success"> & {
    issueLabel: {
        __typename?: "IssueLabel";
    } & Pick<IssueLabel, "id">;
};
export declare type IssuePayloadFragment = {
    __typename: "IssuePayload";
} & Pick<IssuePayload, "lastSyncId" | "success"> & {
    issue?: Maybe<{
        __typename?: "Issue";
    } & Pick<Issue, "id">>;
};
export declare type IssuePriorityValueFragment = {
    __typename: "IssuePriorityValue";
} & Pick<IssuePriorityValue, "label" | "priority">;
export declare type IssueRelationConnectionFragment = {
    __typename: "IssueRelationConnection";
} & {
    nodes: Array<{
        __typename?: "IssueRelation";
    } & IssueRelationFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type IssueRelationPayloadFragment = {
    __typename: "IssueRelationPayload";
} & Pick<IssueRelationPayload, "lastSyncId" | "success"> & {
    issueRelation: {
        __typename?: "IssueRelation";
    } & Pick<IssueRelation, "id">;
};
export declare type IssueSearchPayloadFragment = {
    __typename: "IssueSearchPayload";
} & Pick<IssueSearchPayload, "totalCount"> & {
    archivePayload: {
        __typename?: "ArchiveResponse";
    } & ArchiveResponseFragment;
    nodes: Array<{
        __typename?: "IssueSearchResult";
    } & IssueSearchResultFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type IssueSearchResultFragment = {
    __typename: "IssueSearchResult";
} & Pick<IssueSearchResult, "trashed" | "reactionData" | "labelIds" | "integrationSourceType" | "url" | "identifier" | "priorityLabel" | "metadata" | "previousIdentifiers" | "customerTicketCount" | "branchName" | "dueDate" | "estimate" | "description" | "title" | "number" | "updatedAt" | "boardOrder" | "prioritySortOrder" | "sortOrder" | "subIssueSortOrder" | "priority" | "archivedAt" | "createdAt" | "startedTriageAt" | "triagedAt" | "addedToCycleAt" | "addedToProjectAt" | "addedToTeamAt" | "autoArchivedAt" | "autoClosedAt" | "canceledAt" | "completedAt" | "startedAt" | "slaStartedAt" | "slaBreachesAt" | "slaHighRiskAt" | "slaMediumRiskAt" | "snoozedUntilAt" | "slaType" | "id"> & {
    reactions: Array<{
        __typename?: "Reaction";
    } & ReactionFragment>;
    botActor?: Maybe<{
        __typename?: "ActorBot";
    } & ActorBotFragment>;
    sourceComment?: Maybe<{
        __typename?: "Comment";
    } & Pick<Comment, "id">>;
    cycle?: Maybe<{
        __typename?: "Cycle";
    } & Pick<Cycle, "id">>;
    externalUserCreator?: Maybe<{
        __typename?: "ExternalUser";
    } & Pick<ExternalUser, "id">>;
    lastAppliedTemplate?: Maybe<{
        __typename?: "Template";
    } & Pick<Template, "id">>;
    parent?: Maybe<{
        __typename?: "Issue";
    } & Pick<Issue, "id">>;
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
    projectMilestone?: Maybe<{
        __typename?: "ProjectMilestone";
    } & Pick<ProjectMilestone, "id">>;
    recurringIssueTemplate?: Maybe<{
        __typename?: "Template";
    } & Pick<Template, "id">>;
    team: {
        __typename?: "Team";
    } & Pick<Team, "id">;
    assignee?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    creator?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    snoozedBy?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    favorite?: Maybe<{
        __typename?: "Favorite";
    } & Pick<Favorite, "id">>;
    state: {
        __typename?: "WorkflowState";
    } & Pick<WorkflowState, "id">;
};
export declare type IssueTitleSuggestionFromCustomerRequestPayloadFragment = {
    __typename: "IssueTitleSuggestionFromCustomerRequestPayload";
} & Pick<IssueTitleSuggestionFromCustomerRequestPayload, "lastSyncId" | "title">;
export declare type LogoutResponseFragment = {
    __typename: "LogoutResponse";
} & Pick<LogoutResponse, "success">;
declare type Node_ApiKey_Fragment = {
    __typename: "ApiKey";
} & Pick<ApiKey, "id">;
declare type Node_Attachment_Fragment = {
    __typename: "Attachment";
} & Pick<Attachment, "id">;
declare type Node_AuditEntry_Fragment = {
    __typename: "AuditEntry";
} & Pick<AuditEntry, "id">;
declare type Node_Comment_Fragment = {
    __typename: "Comment";
} & Pick<Comment, "id">;
declare type Node_CustomView_Fragment = {
    __typename: "CustomView";
} & Pick<CustomView, "id">;
declare type Node_CustomViewNotificationSubscription_Fragment = {
    __typename: "CustomViewNotificationSubscription";
} & Pick<CustomViewNotificationSubscription, "id">;
declare type Node_Customer_Fragment = {
    __typename: "Customer";
} & Pick<Customer, "id">;
declare type Node_CustomerNeed_Fragment = {
    __typename: "CustomerNeed";
} & Pick<CustomerNeed, "id">;
declare type Node_CustomerNeedNotification_Fragment = {
    __typename: "CustomerNeedNotification";
} & Pick<CustomerNeedNotification, "id">;
declare type Node_CustomerNotificationSubscription_Fragment = {
    __typename: "CustomerNotificationSubscription";
} & Pick<CustomerNotificationSubscription, "id">;
declare type Node_CustomerStatus_Fragment = {
    __typename: "CustomerStatus";
} & Pick<CustomerStatus, "id">;
declare type Node_CustomerTier_Fragment = {
    __typename: "CustomerTier";
} & Pick<CustomerTier, "id">;
declare type Node_Cycle_Fragment = {
    __typename: "Cycle";
} & Pick<Cycle, "id">;
declare type Node_CycleNotificationSubscription_Fragment = {
    __typename: "CycleNotificationSubscription";
} & Pick<CycleNotificationSubscription, "id">;
declare type Node_Dashboard_Fragment = {
    __typename: "Dashboard";
} & Pick<Dashboard, "id">;
declare type Node_Document_Fragment = {
    __typename: "Document";
} & Pick<Document, "id">;
declare type Node_DocumentContent_Fragment = {
    __typename: "DocumentContent";
} & Pick<DocumentContent, "id">;
declare type Node_DocumentNotification_Fragment = {
    __typename: "DocumentNotification";
} & Pick<DocumentNotification, "id">;
declare type Node_DocumentSearchResult_Fragment = {
    __typename: "DocumentSearchResult";
} & Pick<DocumentSearchResult, "id">;
declare type Node_Draft_Fragment = {
    __typename: "Draft";
} & Pick<Draft, "id">;
declare type Node_EmailIntakeAddress_Fragment = {
    __typename: "EmailIntakeAddress";
} & Pick<EmailIntakeAddress, "id">;
declare type Node_Emoji_Fragment = {
    __typename: "Emoji";
} & Pick<Emoji, "id">;
declare type Node_EntityExternalLink_Fragment = {
    __typename: "EntityExternalLink";
} & Pick<EntityExternalLink, "id">;
declare type Node_ExternalUser_Fragment = {
    __typename: "ExternalUser";
} & Pick<ExternalUser, "id">;
declare type Node_Facet_Fragment = {
    __typename: "Facet";
} & Pick<Facet, "id">;
declare type Node_Favorite_Fragment = {
    __typename: "Favorite";
} & Pick<Favorite, "id">;
declare type Node_GitAutomationState_Fragment = {
    __typename: "GitAutomationState";
} & Pick<GitAutomationState, "id">;
declare type Node_GitAutomationTargetBranch_Fragment = {
    __typename: "GitAutomationTargetBranch";
} & Pick<GitAutomationTargetBranch, "id">;
declare type Node_Initiative_Fragment = {
    __typename: "Initiative";
} & Pick<Initiative, "id">;
declare type Node_InitiativeHistory_Fragment = {
    __typename: "InitiativeHistory";
} & Pick<InitiativeHistory, "id">;
declare type Node_InitiativeNotification_Fragment = {
    __typename: "InitiativeNotification";
} & Pick<InitiativeNotification, "id">;
declare type Node_InitiativeNotificationSubscription_Fragment = {
    __typename: "InitiativeNotificationSubscription";
} & Pick<InitiativeNotificationSubscription, "id">;
declare type Node_InitiativeRelation_Fragment = {
    __typename: "InitiativeRelation";
} & Pick<InitiativeRelation, "id">;
declare type Node_InitiativeToProject_Fragment = {
    __typename: "InitiativeToProject";
} & Pick<InitiativeToProject, "id">;
declare type Node_InitiativeUpdate_Fragment = {
    __typename: "InitiativeUpdate";
} & Pick<InitiativeUpdate, "id">;
declare type Node_Integration_Fragment = {
    __typename: "Integration";
} & Pick<Integration, "id">;
declare type Node_IntegrationTemplate_Fragment = {
    __typename: "IntegrationTemplate";
} & Pick<IntegrationTemplate, "id">;
declare type Node_IntegrationsSettings_Fragment = {
    __typename: "IntegrationsSettings";
} & Pick<IntegrationsSettings, "id">;
declare type Node_Issue_Fragment = {
    __typename: "Issue";
} & Pick<Issue, "id">;
declare type Node_IssueDraft_Fragment = {
    __typename: "IssueDraft";
} & Pick<IssueDraft, "id">;
declare type Node_IssueHistory_Fragment = {
    __typename: "IssueHistory";
} & Pick<IssueHistory, "id">;
declare type Node_IssueImport_Fragment = {
    __typename: "IssueImport";
} & Pick<IssueImport, "id">;
declare type Node_IssueLabel_Fragment = {
    __typename: "IssueLabel";
} & Pick<IssueLabel, "id">;
declare type Node_IssueNotification_Fragment = {
    __typename: "IssueNotification";
} & Pick<IssueNotification, "id">;
declare type Node_IssueRelation_Fragment = {
    __typename: "IssueRelation";
} & Pick<IssueRelation, "id">;
declare type Node_IssueSearchResult_Fragment = {
    __typename: "IssueSearchResult";
} & Pick<IssueSearchResult, "id">;
declare type Node_LabelNotificationSubscription_Fragment = {
    __typename: "LabelNotificationSubscription";
} & Pick<LabelNotificationSubscription, "id">;
declare type Node_Meeting_Fragment = {
    __typename: "Meeting";
} & Pick<Meeting, "id">;
declare type Node_OauthClientApproval_Fragment = {
    __typename: "OauthClientApproval";
} & Pick<OauthClientApproval, "id">;
declare type Node_OauthClientApprovalNotification_Fragment = {
    __typename: "OauthClientApprovalNotification";
} & Pick<OauthClientApprovalNotification, "id">;
declare type Node_Organization_Fragment = {
    __typename: "Organization";
} & Pick<Organization, "id">;
declare type Node_OrganizationDomain_Fragment = {
    __typename: "OrganizationDomain";
} & Pick<OrganizationDomain, "id">;
declare type Node_OrganizationInvite_Fragment = {
    __typename: "OrganizationInvite";
} & Pick<OrganizationInvite, "id">;
declare type Node_PaidSubscription_Fragment = {
    __typename: "PaidSubscription";
} & Pick<PaidSubscription, "id">;
declare type Node_Post_Fragment = {
    __typename: "Post";
} & Pick<Post, "id">;
declare type Node_PostNotification_Fragment = {
    __typename: "PostNotification";
} & Pick<PostNotification, "id">;
declare type Node_Project_Fragment = {
    __typename: "Project";
} & Pick<Project, "id">;
declare type Node_ProjectAttachment_Fragment = {
    __typename: "ProjectAttachment";
} & Pick<ProjectAttachment, "id">;
declare type Node_ProjectHistory_Fragment = {
    __typename: "ProjectHistory";
} & Pick<ProjectHistory, "id">;
declare type Node_ProjectLabel_Fragment = {
    __typename: "ProjectLabel";
} & Pick<ProjectLabel, "id">;
declare type Node_ProjectMilestone_Fragment = {
    __typename: "ProjectMilestone";
} & Pick<ProjectMilestone, "id">;
declare type Node_ProjectNotification_Fragment = {
    __typename: "ProjectNotification";
} & Pick<ProjectNotification, "id">;
declare type Node_ProjectNotificationSubscription_Fragment = {
    __typename: "ProjectNotificationSubscription";
} & Pick<ProjectNotificationSubscription, "id">;
declare type Node_ProjectRelation_Fragment = {
    __typename: "ProjectRelation";
} & Pick<ProjectRelation, "id">;
declare type Node_ProjectSearchResult_Fragment = {
    __typename: "ProjectSearchResult";
} & Pick<ProjectSearchResult, "id">;
declare type Node_ProjectStatus_Fragment = {
    __typename: "ProjectStatus";
} & Pick<ProjectStatus, "id">;
declare type Node_ProjectUpdate_Fragment = {
    __typename: "ProjectUpdate";
} & Pick<ProjectUpdate, "id">;
declare type Node_PullRequest_Fragment = {
    __typename: "PullRequest";
} & Pick<PullRequest, "id">;
declare type Node_PullRequestNotification_Fragment = {
    __typename: "PullRequestNotification";
} & Pick<PullRequestNotification, "id">;
declare type Node_PushSubscription_Fragment = {
    __typename: "PushSubscription";
} & Pick<PushSubscription, "id">;
declare type Node_Reaction_Fragment = {
    __typename: "Reaction";
} & Pick<Reaction, "id">;
declare type Node_Roadmap_Fragment = {
    __typename: "Roadmap";
} & Pick<Roadmap, "id">;
declare type Node_RoadmapToProject_Fragment = {
    __typename: "RoadmapToProject";
} & Pick<RoadmapToProject, "id">;
declare type Node_SemanticSearchResult_Fragment = {
    __typename: "SemanticSearchResult";
} & Pick<SemanticSearchResult, "id">;
declare type Node_Team_Fragment = {
    __typename: "Team";
} & Pick<Team, "id">;
declare type Node_TeamMembership_Fragment = {
    __typename: "TeamMembership";
} & Pick<TeamMembership, "id">;
declare type Node_TeamNotificationSubscription_Fragment = {
    __typename: "TeamNotificationSubscription";
} & Pick<TeamNotificationSubscription, "id">;
declare type Node_Template_Fragment = {
    __typename: "Template";
} & Pick<Template, "id">;
declare type Node_TimeSchedule_Fragment = {
    __typename: "TimeSchedule";
} & Pick<TimeSchedule, "id">;
declare type Node_TriageResponsibility_Fragment = {
    __typename: "TriageResponsibility";
} & Pick<TriageResponsibility, "id">;
declare type Node_User_Fragment = {
    __typename: "User";
} & Pick<User, "id">;
declare type Node_UserNotificationSubscription_Fragment = {
    __typename: "UserNotificationSubscription";
} & Pick<UserNotificationSubscription, "id">;
declare type Node_UserSettings_Fragment = {
    __typename: "UserSettings";
} & Pick<UserSettings, "id">;
declare type Node_ViewPreferences_Fragment = {
    __typename: "ViewPreferences";
} & Pick<ViewPreferences, "id">;
declare type Node_Webhook_Fragment = {
    __typename: "Webhook";
} & Pick<Webhook, "id">;
declare type Node_WorkflowState_Fragment = {
    __typename: "WorkflowState";
} & Pick<WorkflowState, "id">;
export declare type NodeFragment = Node_ApiKey_Fragment | Node_Attachment_Fragment | Node_AuditEntry_Fragment | Node_Comment_Fragment | Node_CustomView_Fragment | Node_CustomViewNotificationSubscription_Fragment | Node_Customer_Fragment | Node_CustomerNeed_Fragment | Node_CustomerNeedNotification_Fragment | Node_CustomerNotificationSubscription_Fragment | Node_CustomerStatus_Fragment | Node_CustomerTier_Fragment | Node_Cycle_Fragment | Node_CycleNotificationSubscription_Fragment | Node_Dashboard_Fragment | Node_Document_Fragment | Node_DocumentContent_Fragment | Node_DocumentNotification_Fragment | Node_DocumentSearchResult_Fragment | Node_Draft_Fragment | Node_EmailIntakeAddress_Fragment | Node_Emoji_Fragment | Node_EntityExternalLink_Fragment | Node_ExternalUser_Fragment | Node_Facet_Fragment | Node_Favorite_Fragment | Node_GitAutomationState_Fragment | Node_GitAutomationTargetBranch_Fragment | Node_Initiative_Fragment | Node_InitiativeHistory_Fragment | Node_InitiativeNotification_Fragment | Node_InitiativeNotificationSubscription_Fragment | Node_InitiativeRelation_Fragment | Node_InitiativeToProject_Fragment | Node_InitiativeUpdate_Fragment | Node_Integration_Fragment | Node_IntegrationTemplate_Fragment | Node_IntegrationsSettings_Fragment | Node_Issue_Fragment | Node_IssueDraft_Fragment | Node_IssueHistory_Fragment | Node_IssueImport_Fragment | Node_IssueLabel_Fragment | Node_IssueNotification_Fragment | Node_IssueRelation_Fragment | Node_IssueSearchResult_Fragment | Node_LabelNotificationSubscription_Fragment | Node_Meeting_Fragment | Node_OauthClientApproval_Fragment | Node_OauthClientApprovalNotification_Fragment | Node_Organization_Fragment | Node_OrganizationDomain_Fragment | Node_OrganizationInvite_Fragment | Node_PaidSubscription_Fragment | Node_Post_Fragment | Node_PostNotification_Fragment | Node_Project_Fragment | Node_ProjectAttachment_Fragment | Node_ProjectHistory_Fragment | Node_ProjectLabel_Fragment | Node_ProjectMilestone_Fragment | Node_ProjectNotification_Fragment | Node_ProjectNotificationSubscription_Fragment | Node_ProjectRelation_Fragment | Node_ProjectSearchResult_Fragment | Node_ProjectStatus_Fragment | Node_ProjectUpdate_Fragment | Node_PullRequest_Fragment | Node_PullRequestNotification_Fragment | Node_PushSubscription_Fragment | Node_Reaction_Fragment | Node_Roadmap_Fragment | Node_RoadmapToProject_Fragment | Node_SemanticSearchResult_Fragment | Node_Team_Fragment | Node_TeamMembership_Fragment | Node_TeamNotificationSubscription_Fragment | Node_Template_Fragment | Node_TimeSchedule_Fragment | Node_TriageResponsibility_Fragment | Node_User_Fragment | Node_UserNotificationSubscription_Fragment | Node_UserSettings_Fragment | Node_ViewPreferences_Fragment | Node_Webhook_Fragment | Node_WorkflowState_Fragment;
export declare type NotificationBatchActionPayloadFragment = {
    __typename: "NotificationBatchActionPayload";
} & Pick<NotificationBatchActionPayload, "lastSyncId" | "success"> & {
    notifications: Array<({
        __typename?: "CustomerNeedNotification";
    } & Notification_CustomerNeedNotification_Fragment) | ({
        __typename?: "DocumentNotification";
    } & Notification_DocumentNotification_Fragment) | ({
        __typename?: "InitiativeNotification";
    } & Notification_InitiativeNotification_Fragment) | ({
        __typename?: "IssueNotification";
    } & Notification_IssueNotification_Fragment) | ({
        __typename?: "OauthClientApprovalNotification";
    } & Notification_OauthClientApprovalNotification_Fragment) | ({
        __typename?: "PostNotification";
    } & Notification_PostNotification_Fragment) | ({
        __typename?: "ProjectNotification";
    } & Notification_ProjectNotification_Fragment) | ({
        __typename?: "PullRequestNotification";
    } & Notification_PullRequestNotification_Fragment)>;
};
export declare type NotificationConnectionFragment = {
    __typename: "NotificationConnection";
} & {
    nodes: Array<({
        __typename?: "CustomerNeedNotification";
    } & Notification_CustomerNeedNotification_Fragment) | ({
        __typename?: "DocumentNotification";
    } & Notification_DocumentNotification_Fragment) | ({
        __typename?: "InitiativeNotification";
    } & Notification_InitiativeNotification_Fragment) | ({
        __typename?: "IssueNotification";
    } & Notification_IssueNotification_Fragment) | ({
        __typename?: "OauthClientApprovalNotification";
    } & Notification_OauthClientApprovalNotification_Fragment) | ({
        __typename?: "PostNotification";
    } & Notification_PostNotification_Fragment) | ({
        __typename?: "ProjectNotification";
    } & Notification_ProjectNotification_Fragment) | ({
        __typename?: "PullRequestNotification";
    } & Notification_PullRequestNotification_Fragment)>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type NotificationPayloadFragment = {
    __typename: "NotificationPayload";
} & Pick<NotificationPayload, "lastSyncId" | "success"> & {
    notification: ({
        __typename?: "CustomerNeedNotification";
    } & Notification_CustomerNeedNotification_Fragment) | ({
        __typename?: "DocumentNotification";
    } & Notification_DocumentNotification_Fragment) | ({
        __typename?: "InitiativeNotification";
    } & Notification_InitiativeNotification_Fragment) | ({
        __typename?: "IssueNotification";
    } & Notification_IssueNotification_Fragment) | ({
        __typename?: "OauthClientApprovalNotification";
    } & Notification_OauthClientApprovalNotification_Fragment) | ({
        __typename?: "PostNotification";
    } & Notification_PostNotification_Fragment) | ({
        __typename?: "ProjectNotification";
    } & Notification_ProjectNotification_Fragment) | ({
        __typename?: "PullRequestNotification";
    } & Notification_PullRequestNotification_Fragment);
};
export declare type NotificationSubscriptionConnectionFragment = {
    __typename: "NotificationSubscriptionConnection";
} & {
    nodes: Array<({
        __typename?: "CustomViewNotificationSubscription";
    } & NotificationSubscription_CustomViewNotificationSubscription_Fragment) | ({
        __typename?: "CustomerNotificationSubscription";
    } & NotificationSubscription_CustomerNotificationSubscription_Fragment) | ({
        __typename?: "CycleNotificationSubscription";
    } & NotificationSubscription_CycleNotificationSubscription_Fragment) | ({
        __typename?: "InitiativeNotificationSubscription";
    } & NotificationSubscription_InitiativeNotificationSubscription_Fragment) | ({
        __typename?: "LabelNotificationSubscription";
    } & NotificationSubscription_LabelNotificationSubscription_Fragment) | ({
        __typename?: "ProjectNotificationSubscription";
    } & NotificationSubscription_ProjectNotificationSubscription_Fragment) | ({
        __typename?: "TeamNotificationSubscription";
    } & NotificationSubscription_TeamNotificationSubscription_Fragment) | ({
        __typename?: "UserNotificationSubscription";
    } & NotificationSubscription_UserNotificationSubscription_Fragment)>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type NotificationSubscriptionPayloadFragment = {
    __typename: "NotificationSubscriptionPayload";
} & Pick<NotificationSubscriptionPayload, "lastSyncId" | "success"> & {
    notificationSubscription: ({
        __typename?: "CustomViewNotificationSubscription";
    } & NotificationSubscription_CustomViewNotificationSubscription_Fragment) | ({
        __typename?: "CustomerNotificationSubscription";
    } & NotificationSubscription_CustomerNotificationSubscription_Fragment) | ({
        __typename?: "CycleNotificationSubscription";
    } & NotificationSubscription_CycleNotificationSubscription_Fragment) | ({
        __typename?: "InitiativeNotificationSubscription";
    } & NotificationSubscription_InitiativeNotificationSubscription_Fragment) | ({
        __typename?: "LabelNotificationSubscription";
    } & NotificationSubscription_LabelNotificationSubscription_Fragment) | ({
        __typename?: "ProjectNotificationSubscription";
    } & NotificationSubscription_ProjectNotificationSubscription_Fragment) | ({
        __typename?: "TeamNotificationSubscription";
    } & NotificationSubscription_TeamNotificationSubscription_Fragment) | ({
        __typename?: "UserNotificationSubscription";
    } & NotificationSubscription_UserNotificationSubscription_Fragment);
};
export declare type OrganizationAcceptedOrExpiredInviteDetailsPayloadFragment = {
    __typename: "OrganizationAcceptedOrExpiredInviteDetailsPayload";
} & Pick<OrganizationAcceptedOrExpiredInviteDetailsPayload, "status">;
export declare type OrganizationCancelDeletePayloadFragment = {
    __typename: "OrganizationCancelDeletePayload";
} & Pick<OrganizationCancelDeletePayload, "success">;
export declare type OrganizationDeletePayloadFragment = {
    __typename: "OrganizationDeletePayload";
} & Pick<OrganizationDeletePayload, "success">;
export declare type OrganizationExistsPayloadFragment = {
    __typename: "OrganizationExistsPayload";
} & Pick<OrganizationExistsPayload, "success" | "exists">;
export declare type OrganizationInviteConnectionFragment = {
    __typename: "OrganizationInviteConnection";
} & {
    nodes: Array<{
        __typename?: "OrganizationInvite";
    } & OrganizationInviteFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type OrganizationInviteFullDetailsPayloadFragment = {
    __typename: "OrganizationInviteFullDetailsPayload";
} & Pick<OrganizationInviteFullDetailsPayload, "allowedAuthServices" | "organizationId" | "organizationName" | "email" | "inviter" | "status" | "organizationLogoUrl" | "role" | "createdAt" | "accepted" | "expired">;
export declare type OrganizationInvitePayloadFragment = {
    __typename: "OrganizationInvitePayload";
} & Pick<OrganizationInvitePayload, "lastSyncId" | "success"> & {
    organizationInvite: {
        __typename?: "OrganizationInvite";
    } & Pick<OrganizationInvite, "id">;
};
export declare type OrganizationIpRestrictionFragment = {
    __typename: "OrganizationIpRestriction";
} & Pick<OrganizationIpRestriction, "range" | "description" | "type" | "enabled">;
export declare type OrganizationMetaFragment = {
    __typename: "OrganizationMeta";
} & Pick<OrganizationMeta, "allowedAuthServices" | "region">;
export declare type OrganizationPayloadFragment = {
    __typename: "OrganizationPayload";
} & Pick<OrganizationPayload, "lastSyncId" | "success">;
export declare type OrganizationStartTrialPayloadFragment = {
    __typename: "OrganizationStartTrialPayload";
} & Pick<OrganizationStartTrialPayload, "success">;
export declare type PageInfoFragment = {
    __typename: "PageInfo";
} & Pick<PageInfo, "startCursor" | "endCursor" | "hasPreviousPage" | "hasNextPage">;
export declare type PasskeyLoginStartResponseFragment = {
    __typename: "PasskeyLoginStartResponse";
} & Pick<PasskeyLoginStartResponse, "options" | "success">;
export declare type ProjectConnectionFragment = {
    __typename: "ProjectConnection";
} & {
    nodes: Array<{
        __typename?: "Project";
    } & ProjectFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type ProjectFilterSuggestionPayloadFragment = {
    __typename: "ProjectFilterSuggestionPayload";
} & Pick<ProjectFilterSuggestionPayload, "filter" | "logId">;
export declare type ProjectHistoryConnectionFragment = {
    __typename: "ProjectHistoryConnection";
} & {
    nodes: Array<{
        __typename?: "ProjectHistory";
    } & ProjectHistoryFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type ProjectMilestoneConnectionFragment = {
    __typename: "ProjectMilestoneConnection";
} & {
    nodes: Array<{
        __typename?: "ProjectMilestone";
    } & ProjectMilestoneFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type ProjectMilestoneMoveIssueToTeamFragment = {
    __typename: "ProjectMilestoneMoveIssueToTeam";
} & Pick<ProjectMilestoneMoveIssueToTeam, "issueId" | "teamId">;
export declare type ProjectMilestoneMovePayloadFragment = {
    __typename: "ProjectMilestoneMovePayload";
} & Pick<ProjectMilestoneMovePayload, "lastSyncId" | "success"> & {
    previousIssueTeamIds?: Maybe<Array<{
        __typename?: "ProjectMilestoneMoveIssueToTeam";
    } & ProjectMilestoneMoveIssueToTeamFragment>>;
    previousProjectTeamIds?: Maybe<{
        __typename?: "ProjectMilestoneMoveProjectTeams";
    } & ProjectMilestoneMoveProjectTeamsFragment>;
    projectMilestone: {
        __typename?: "ProjectMilestone";
    } & Pick<ProjectMilestone, "id">;
};
export declare type ProjectMilestoneMoveProjectTeamsFragment = {
    __typename: "ProjectMilestoneMoveProjectTeams";
} & Pick<ProjectMilestoneMoveProjectTeams, "projectId" | "teamIds">;
export declare type ProjectMilestonePayloadFragment = {
    __typename: "ProjectMilestonePayload";
} & Pick<ProjectMilestonePayload, "lastSyncId" | "success"> & {
    projectMilestone: {
        __typename?: "ProjectMilestone";
    } & Pick<ProjectMilestone, "id">;
};
export declare type ProjectPayloadFragment = {
    __typename: "ProjectPayload";
} & Pick<ProjectPayload, "lastSyncId" | "success"> & {
    project?: Maybe<{
        __typename?: "Project";
    } & Pick<Project, "id">>;
};
export declare type ProjectRelationConnectionFragment = {
    __typename: "ProjectRelationConnection";
} & {
    nodes: Array<{
        __typename?: "ProjectRelation";
    } & ProjectRelationFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type ProjectRelationPayloadFragment = {
    __typename: "ProjectRelationPayload";
} & Pick<ProjectRelationPayload, "lastSyncId" | "success"> & {
    projectRelation: {
        __typename?: "ProjectRelation";
    } & Pick<ProjectRelation, "id">;
};
export declare type ProjectSearchPayloadFragment = {
    __typename: "ProjectSearchPayload";
} & Pick<ProjectSearchPayload, "totalCount"> & {
    archivePayload: {
        __typename?: "ArchiveResponse";
    } & ArchiveResponseFragment;
    nodes: Array<{
        __typename?: "ProjectSearchResult";
    } & ProjectSearchResultFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type ProjectSearchResultFragment = {
    __typename: "ProjectSearchResult";
} & Pick<ProjectSearchResult, "trashed" | "labelIds" | "metadata" | "url" | "updateRemindersDay" | "targetDate" | "startDate" | "updateReminderFrequency" | "health" | "updateRemindersHour" | "icon" | "updatedAt" | "updateReminderFrequencyInWeeks" | "completedScopeHistory" | "completedIssueCountHistory" | "inProgressScopeHistory" | "progress" | "scope" | "priorityLabel" | "priority" | "color" | "content" | "description" | "name" | "slugId" | "targetDateResolution" | "startDateResolution" | "frequencyResolution" | "prioritySortOrder" | "sortOrder" | "archivedAt" | "createdAt" | "healthUpdatedAt" | "autoArchivedAt" | "canceledAt" | "completedAt" | "startedAt" | "projectUpdateRemindersPausedUntilAt" | "scopeHistory" | "issueCountHistory" | "id" | "slackIssueComments" | "slackNewIssue" | "slackIssueStatuses" | "state"> & {
    integrationsSettings?: Maybe<{
        __typename?: "IntegrationsSettings";
    } & Pick<IntegrationsSettings, "id">>;
    documentContent?: Maybe<{
        __typename?: "DocumentContent";
    } & DocumentContentFragment>;
    lastUpdate?: Maybe<{
        __typename?: "ProjectUpdate";
    } & Pick<ProjectUpdate, "id">>;
    lastAppliedTemplate?: Maybe<{
        __typename?: "Template";
    } & Pick<Template, "id">>;
    lead?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    convertedFromIssue?: Maybe<{
        __typename?: "Issue";
    } & Pick<Issue, "id">>;
    status: {
        __typename?: "ProjectStatus";
    } & Pick<ProjectStatus, "id">;
    creator?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
    favorite?: Maybe<{
        __typename?: "Favorite";
    } & Pick<Favorite, "id">>;
};
export declare type ProjectStatusConnectionFragment = {
    __typename: "ProjectStatusConnection";
} & {
    nodes: Array<{
        __typename?: "ProjectStatus";
    } & ProjectStatusFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type ProjectStatusCountPayloadFragment = {
    __typename: "ProjectStatusCountPayload";
} & Pick<ProjectStatusCountPayload, "privateCount" | "archivedTeamCount" | "count">;
export declare type ProjectStatusPayloadFragment = {
    __typename: "ProjectStatusPayload";
} & Pick<ProjectStatusPayload, "lastSyncId" | "success"> & {
    status: {
        __typename?: "ProjectStatus";
    } & Pick<ProjectStatus, "id">;
};
export declare type ProjectUpdateConnectionFragment = {
    __typename: "ProjectUpdateConnection";
} & {
    nodes: Array<{
        __typename?: "ProjectUpdate";
    } & ProjectUpdateFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type ProjectUpdatePayloadFragment = {
    __typename: "ProjectUpdatePayload";
} & Pick<ProjectUpdatePayload, "lastSyncId" | "success"> & {
    projectUpdate: {
        __typename?: "ProjectUpdate";
    } & Pick<ProjectUpdate, "id">;
};
export declare type ProjectUpdateReminderPayloadFragment = {
    __typename: "ProjectUpdateReminderPayload";
} & Pick<ProjectUpdateReminderPayload, "lastSyncId" | "success">;
export declare type PushSubscriptionPayloadFragment = {
    __typename: "PushSubscriptionPayload";
} & Pick<PushSubscriptionPayload, "lastSyncId" | "success"> & {
    entity: {
        __typename?: "PushSubscription";
    } & PushSubscriptionFragment;
};
export declare type PushSubscriptionTestPayloadFragment = {
    __typename: "PushSubscriptionTestPayload";
} & Pick<PushSubscriptionTestPayload, "success">;
export declare type RateLimitPayloadFragment = {
    __typename: "RateLimitPayload";
} & Pick<RateLimitPayload, "identifier" | "kind"> & {
    limits: Array<{
        __typename?: "RateLimitResultPayload";
    } & RateLimitResultPayloadFragment>;
};
export declare type RateLimitResultPayloadFragment = {
    __typename: "RateLimitResultPayload";
} & Pick<RateLimitResultPayload, "period" | "remainingAmount" | "requestedAmount" | "reset" | "allowedAmount" | "type">;
export declare type ReactionPayloadFragment = {
    __typename: "ReactionPayload";
} & Pick<ReactionPayload, "lastSyncId" | "success"> & {
    reaction: {
        __typename?: "Reaction";
    } & ReactionFragment;
};
export declare type RoadmapConnectionFragment = {
    __typename: "RoadmapConnection";
} & {
    nodes: Array<{
        __typename?: "Roadmap";
    } & RoadmapFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type RoadmapPayloadFragment = {
    __typename: "RoadmapPayload";
} & Pick<RoadmapPayload, "lastSyncId" | "success"> & {
    roadmap: {
        __typename?: "Roadmap";
    } & Pick<Roadmap, "id">;
};
export declare type RoadmapToProjectConnectionFragment = {
    __typename: "RoadmapToProjectConnection";
} & {
    nodes: Array<{
        __typename?: "RoadmapToProject";
    } & RoadmapToProjectFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type RoadmapToProjectPayloadFragment = {
    __typename: "RoadmapToProjectPayload";
} & Pick<RoadmapToProjectPayload, "lastSyncId" | "success"> & {
    roadmapToProject: {
        __typename?: "RoadmapToProject";
    } & Pick<RoadmapToProject, "id">;
};
export declare type SlackChannelConnectPayloadFragment = {
    __typename: "SlackChannelConnectPayload";
} & Pick<SlackChannelConnectPayload, "lastSyncId" | "nudgeToConnectMainSlackIntegration" | "nudgeToUpdateMainSlackIntegration" | "addBot" | "success"> & {
    integration?: Maybe<{
        __typename?: "Integration";
    } & Pick<Integration, "id">>;
};
export declare type SsoUrlFromEmailResponseFragment = {
    __typename: "SsoUrlFromEmailResponse";
} & Pick<SsoUrlFromEmailResponse, "samlSsoUrl" | "success">;
export declare type SuccessPayloadFragment = {
    __typename: "SuccessPayload";
} & Pick<SuccessPayload, "lastSyncId" | "success">;
export declare type SummaryPayloadFragment = {
    __typename: "SummaryPayload";
} & Pick<SummaryPayload, "summary">;
export declare type TeamConnectionFragment = {
    __typename: "TeamConnection";
} & {
    nodes: Array<{
        __typename?: "Team";
    } & TeamFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type TeamMembershipConnectionFragment = {
    __typename: "TeamMembershipConnection";
} & {
    nodes: Array<{
        __typename?: "TeamMembership";
    } & TeamMembershipFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type TeamMembershipPayloadFragment = {
    __typename: "TeamMembershipPayload";
} & Pick<TeamMembershipPayload, "lastSyncId" | "success"> & {
    teamMembership?: Maybe<{
        __typename?: "TeamMembership";
    } & Pick<TeamMembership, "id">>;
};
export declare type TeamPayloadFragment = {
    __typename: "TeamPayload";
} & Pick<TeamPayload, "lastSyncId" | "success"> & {
    team?: Maybe<{
        __typename?: "Team";
    } & Pick<Team, "id">>;
};
export declare type TemplateConnectionFragment = {
    __typename: "TemplateConnection";
} & {
    nodes: Array<{
        __typename?: "Template";
    } & TemplateFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type TemplatePayloadFragment = {
    __typename: "TemplatePayload";
} & Pick<TemplatePayload, "lastSyncId" | "success"> & {
    template: {
        __typename?: "Template";
    } & Pick<Template, "id">;
};
export declare type TimeScheduleConnectionFragment = {
    __typename: "TimeScheduleConnection";
} & {
    nodes: Array<{
        __typename?: "TimeSchedule";
    } & TimeScheduleFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type TimeScheduleEntryFragment = {
    __typename: "TimeScheduleEntry";
} & Pick<TimeScheduleEntry, "userId" | "userEmail" | "endsAt" | "startsAt">;
export declare type TimeSchedulePayloadFragment = {
    __typename: "TimeSchedulePayload";
} & Pick<TimeSchedulePayload, "lastSyncId" | "success"> & {
    timeSchedule: {
        __typename?: "TimeSchedule";
    } & Pick<TimeSchedule, "id">;
};
export declare type TriageResponsibilityConnectionFragment = {
    __typename: "TriageResponsibilityConnection";
} & {
    nodes: Array<{
        __typename?: "TriageResponsibility";
    } & TriageResponsibilityFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type TriageResponsibilityManualSelectionFragment = {
    __typename: "TriageResponsibilityManualSelection";
} & Pick<TriageResponsibilityManualSelection, "userIds">;
export declare type TriageResponsibilityPayloadFragment = {
    __typename: "TriageResponsibilityPayload";
} & Pick<TriageResponsibilityPayload, "lastSyncId" | "success"> & {
    triageResponsibility: {
        __typename?: "TriageResponsibility";
    } & Pick<TriageResponsibility, "id">;
};
export declare type UploadFileHeaderFragment = {
    __typename: "UploadFileHeader";
} & Pick<UploadFileHeader, "key" | "value">;
export declare type UploadPayloadFragment = {
    __typename: "UploadPayload";
} & Pick<UploadPayload, "lastSyncId" | "success"> & {
    uploadFile?: Maybe<{
        __typename?: "UploadFile";
    } & UploadFileFragment>;
};
export declare type UserAdminPayloadFragment = {
    __typename: "UserAdminPayload";
} & Pick<UserAdminPayload, "success">;
export declare type UserConnectionFragment = {
    __typename: "UserConnection";
} & {
    nodes: Array<{
        __typename?: "User";
    } & UserFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type UserPayloadFragment = {
    __typename: "UserPayload";
} & Pick<UserPayload, "lastSyncId" | "success"> & {
    user?: Maybe<{
        __typename?: "User";
    } & Pick<User, "id">>;
};
export declare type UserSettingsFlagPayloadFragment = {
    __typename: "UserSettingsFlagPayload";
} & Pick<UserSettingsFlagPayload, "flag" | "value" | "lastSyncId" | "success">;
export declare type UserSettingsFlagsResetPayloadFragment = {
    __typename: "UserSettingsFlagsResetPayload";
} & Pick<UserSettingsFlagsResetPayload, "lastSyncId" | "success">;
export declare type UserSettingsPayloadFragment = {
    __typename: "UserSettingsPayload";
} & Pick<UserSettingsPayload, "lastSyncId" | "success">;
export declare type ViewPreferencesPayloadFragment = {
    __typename: "ViewPreferencesPayload";
} & Pick<ViewPreferencesPayload, "lastSyncId" | "success"> & {
    viewPreferences: {
        __typename?: "ViewPreferences";
    } & ViewPreferencesFragment;
};
export declare type ViewPreferencesValuesFragment = {
    __typename: "ViewPreferencesValues";
} & Pick<ViewPreferencesValues, "issueGrouping" | "viewOrdering" | "showCompletedIssues">;
export declare type WebhookConnectionFragment = {
    __typename: "WebhookConnection";
} & {
    nodes: Array<{
        __typename?: "Webhook";
    } & WebhookFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type WebhookPayloadFragment = {
    __typename: "WebhookPayload";
} & Pick<WebhookPayload, "lastSyncId" | "success"> & {
    webhook: {
        __typename?: "Webhook";
    } & Pick<Webhook, "id">;
};
export declare type WorkflowStateConnectionFragment = {
    __typename: "WorkflowStateConnection";
} & {
    nodes: Array<{
        __typename?: "WorkflowState";
    } & WorkflowStateFragment>;
    pageInfo: {
        __typename?: "PageInfo";
    } & PageInfoFragment;
};
export declare type WorkflowStatePayloadFragment = {
    __typename: "WorkflowStatePayload";
} & Pick<WorkflowStatePayload, "lastSyncId" | "success"> & {
    workflowState: {
        __typename?: "WorkflowState";
    } & Pick<WorkflowState, "id">;
};
export declare type AdministrableTeamsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<TeamFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type AdministrableTeamsQuery = {
    __typename?: "Query";
} & {
    administrableTeams: {
        __typename?: "TeamConnection";
    } & TeamConnectionFragment;
};
export declare type ApiKeysQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type ApiKeysQuery = {
    __typename?: "Query";
} & {
    apiKeys: {
        __typename?: "ApiKeyConnection";
    } & ApiKeyConnectionFragment;
};
export declare type ApplicationInfoQueryVariables = Exact<{
    clientId: Scalars["String"];
}>;
export declare type ApplicationInfoQuery = {
    __typename?: "Query";
} & {
    applicationInfo: {
        __typename?: "Application";
    } & ApplicationFragment;
};
export declare type ApplicationWithAuthorizationQueryVariables = Exact<{
    actor?: Maybe<Scalars["String"]>;
    clientId: Scalars["String"];
    redirectUri?: Maybe<Scalars["String"]>;
    scope: Array<Scalars["String"]> | Scalars["String"];
}>;
export declare type ApplicationWithAuthorizationQuery = {
    __typename?: "Query";
} & {
    applicationWithAuthorization: {
        __typename?: "UserAuthorizedApplication";
    } & UserAuthorizedApplicationFragment;
};
export declare type AttachmentQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type AttachmentQuery = {
    __typename?: "Query";
} & {
    attachment: {
        __typename?: "Attachment";
    } & AttachmentFragment;
};
export declare type AttachmentIssueQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type AttachmentIssueQuery = {
    __typename?: "Query";
} & {
    attachmentIssue: {
        __typename?: "Issue";
    } & IssueFragment;
};
export declare type AttachmentIssue_AttachmentsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<AttachmentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type AttachmentIssue_AttachmentsQuery = {
    __typename?: "Query";
} & {
    attachmentIssue: {
        __typename?: "Issue";
    } & {
        attachments: {
            __typename?: "AttachmentConnection";
        } & AttachmentConnectionFragment;
    };
};
export declare type AttachmentIssue_BotActorQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type AttachmentIssue_BotActorQuery = {
    __typename?: "Query";
} & {
    attachmentIssue: {
        __typename?: "Issue";
    } & {
        botActor?: Maybe<{
            __typename?: "ActorBot";
        } & ActorBotFragment>;
    };
};
export declare type AttachmentIssue_ChildrenQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type AttachmentIssue_ChildrenQuery = {
    __typename?: "Query";
} & {
    attachmentIssue: {
        __typename?: "Issue";
    } & {
        children: {
            __typename?: "IssueConnection";
        } & IssueConnectionFragment;
    };
};
export declare type AttachmentIssue_CommentsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CommentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type AttachmentIssue_CommentsQuery = {
    __typename?: "Query";
} & {
    attachmentIssue: {
        __typename?: "Issue";
    } & {
        comments: {
            __typename?: "CommentConnection";
        } & CommentConnectionFragment;
    };
};
export declare type AttachmentIssue_HistoryQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type AttachmentIssue_HistoryQuery = {
    __typename?: "Query";
} & {
    attachmentIssue: {
        __typename?: "Issue";
    } & {
        history: {
            __typename?: "IssueHistoryConnection";
        } & IssueHistoryConnectionFragment;
    };
};
export declare type AttachmentIssue_InverseRelationsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type AttachmentIssue_InverseRelationsQuery = {
    __typename?: "Query";
} & {
    attachmentIssue: {
        __typename?: "Issue";
    } & {
        inverseRelations: {
            __typename?: "IssueRelationConnection";
        } & IssueRelationConnectionFragment;
    };
};
export declare type AttachmentIssue_LabelsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueLabelFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type AttachmentIssue_LabelsQuery = {
    __typename?: "Query";
} & {
    attachmentIssue: {
        __typename?: "Issue";
    } & {
        labels: {
            __typename?: "IssueLabelConnection";
        } & IssueLabelConnectionFragment;
    };
};
export declare type AttachmentIssue_NeedsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CustomerNeedFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type AttachmentIssue_NeedsQuery = {
    __typename?: "Query";
} & {
    attachmentIssue: {
        __typename?: "Issue";
    } & {
        needs: {
            __typename?: "CustomerNeedConnection";
        } & CustomerNeedConnectionFragment;
    };
};
export declare type AttachmentIssue_RelationsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type AttachmentIssue_RelationsQuery = {
    __typename?: "Query";
} & {
    attachmentIssue: {
        __typename?: "Issue";
    } & {
        relations: {
            __typename?: "IssueRelationConnection";
        } & IssueRelationConnectionFragment;
    };
};
export declare type AttachmentIssue_SubscribersQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<UserFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeDisabled?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type AttachmentIssue_SubscribersQuery = {
    __typename?: "Query";
} & {
    attachmentIssue: {
        __typename?: "Issue";
    } & {
        subscribers: {
            __typename?: "UserConnection";
        } & UserConnectionFragment;
    };
};
export declare type AttachmentsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<AttachmentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type AttachmentsQuery = {
    __typename?: "Query";
} & {
    attachments: {
        __typename?: "AttachmentConnection";
    } & AttachmentConnectionFragment;
};
export declare type AttachmentsForUrlQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
    url: Scalars["String"];
}>;
export declare type AttachmentsForUrlQuery = {
    __typename?: "Query";
} & {
    attachmentsForURL: {
        __typename?: "AttachmentConnection";
    } & AttachmentConnectionFragment;
};
export declare type AuditEntriesQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<AuditEntryFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type AuditEntriesQuery = {
    __typename?: "Query";
} & {
    auditEntries: {
        __typename?: "AuditEntryConnection";
    } & AuditEntryConnectionFragment;
};
export declare type AuditEntryTypesQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type AuditEntryTypesQuery = {
    __typename?: "Query";
} & {
    auditEntryTypes: Array<{
        __typename?: "AuditEntryType";
    } & AuditEntryTypeFragment>;
};
export declare type AuthenticationSessionsQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type AuthenticationSessionsQuery = {
    __typename?: "Query";
} & {
    authenticationSessions: Array<{
        __typename?: "AuthenticationSessionResponse";
    } & AuthenticationSessionResponseFragment>;
};
export declare type AvailableUsersQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type AvailableUsersQuery = {
    __typename?: "Query";
} & {
    availableUsers: {
        __typename?: "AuthResolverResponse";
    } & AuthResolverResponseFragment;
};
export declare type CommentQueryVariables = Exact<{
    hash?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
}>;
export declare type CommentQuery = {
    __typename?: "Query";
} & {
    comment: {
        __typename?: "Comment";
    } & CommentFragment;
};
export declare type Comment_BotActorQueryVariables = Exact<{
    hash?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
}>;
export declare type Comment_BotActorQuery = {
    __typename?: "Query";
} & {
    comment: {
        __typename?: "Comment";
    } & {
        botActor?: Maybe<{
            __typename?: "ActorBot";
        } & ActorBotFragment>;
    };
};
export declare type Comment_ChildrenQueryVariables = Exact<{
    hash?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CommentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Comment_ChildrenQuery = {
    __typename?: "Query";
} & {
    comment: {
        __typename?: "Comment";
    } & {
        children: {
            __typename?: "CommentConnection";
        } & CommentConnectionFragment;
    };
};
export declare type Comment_DocumentContentQueryVariables = Exact<{
    hash?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
}>;
export declare type Comment_DocumentContentQuery = {
    __typename?: "Query";
} & {
    comment: {
        __typename?: "Comment";
    } & {
        documentContent?: Maybe<{
            __typename?: "DocumentContent";
        } & DocumentContentFragment>;
    };
};
export declare type Comment_ExternalThreadQueryVariables = Exact<{
    hash?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
}>;
export declare type Comment_ExternalThreadQuery = {
    __typename?: "Query";
} & {
    comment: {
        __typename?: "Comment";
    } & {
        externalThread?: Maybe<{
            __typename?: "SyncedExternalThread";
        } & SyncedExternalThreadFragment>;
    };
};
export declare type CommentsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CommentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type CommentsQuery = {
    __typename?: "Query";
} & {
    comments: {
        __typename?: "CommentConnection";
    } & CommentConnectionFragment;
};
export declare type CustomViewQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type CustomViewQuery = {
    __typename?: "Query";
} & {
    customView: {
        __typename?: "CustomView";
    } & CustomViewFragment;
};
export declare type CustomView_IssuesQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
    sort?: Maybe<Array<IssueSortInput> | IssueSortInput>;
}>;
export declare type CustomView_IssuesQuery = {
    __typename?: "Query";
} & {
    customView: {
        __typename?: "CustomView";
    } & {
        issues: {
            __typename?: "IssueConnection";
        } & IssueConnectionFragment;
    };
};
export declare type CustomView_OrganizationViewPreferencesQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type CustomView_OrganizationViewPreferencesQuery = {
    __typename?: "Query";
} & {
    customView: {
        __typename?: "CustomView";
    } & {
        organizationViewPreferences?: Maybe<{
            __typename?: "ViewPreferences";
        } & ViewPreferencesFragment>;
    };
};
export declare type CustomView_OrganizationViewPreferences_PreferencesQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type CustomView_OrganizationViewPreferences_PreferencesQuery = {
    __typename?: "Query";
} & {
    customView: {
        __typename?: "CustomView";
    } & {
        organizationViewPreferences?: Maybe<{
            __typename?: "ViewPreferences";
        } & {
            preferences: {
                __typename?: "ViewPreferencesValues";
            } & ViewPreferencesValuesFragment;
        }>;
    };
};
export declare type CustomView_ProjectsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type CustomView_ProjectsQuery = {
    __typename?: "Query";
} & {
    customView: {
        __typename?: "CustomView";
    } & {
        projects: {
            __typename?: "ProjectConnection";
        } & ProjectConnectionFragment;
    };
};
export declare type CustomView_UserViewPreferencesQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type CustomView_UserViewPreferencesQuery = {
    __typename?: "Query";
} & {
    customView: {
        __typename?: "CustomView";
    } & {
        userViewPreferences?: Maybe<{
            __typename?: "ViewPreferences";
        } & ViewPreferencesFragment>;
    };
};
export declare type CustomView_UserViewPreferences_PreferencesQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type CustomView_UserViewPreferences_PreferencesQuery = {
    __typename?: "Query";
} & {
    customView: {
        __typename?: "CustomView";
    } & {
        userViewPreferences?: Maybe<{
            __typename?: "ViewPreferences";
        } & {
            preferences: {
                __typename?: "ViewPreferencesValues";
            } & ViewPreferencesValuesFragment;
        }>;
    };
};
export declare type CustomView_ViewPreferencesValuesQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type CustomView_ViewPreferencesValuesQuery = {
    __typename?: "Query";
} & {
    customView: {
        __typename?: "CustomView";
    } & {
        viewPreferencesValues?: Maybe<{
            __typename?: "ViewPreferencesValues";
        } & ViewPreferencesValuesFragment>;
    };
};
export declare type CustomViewHasSubscribersQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type CustomViewHasSubscribersQuery = {
    __typename?: "Query";
} & {
    customViewHasSubscribers: {
        __typename?: "CustomViewHasSubscribersPayload";
    } & CustomViewHasSubscribersPayloadFragment;
};
export declare type CustomViewsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type CustomViewsQuery = {
    __typename?: "Query";
} & {
    customViews: {
        __typename?: "CustomViewConnection";
    } & CustomViewConnectionFragment;
};
export declare type CustomerQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type CustomerQuery = {
    __typename?: "Query";
} & {
    customer: {
        __typename?: "Customer";
    } & CustomerFragment;
};
export declare type CustomerNeedQueryVariables = Exact<{
    hash?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
}>;
export declare type CustomerNeedQuery = {
    __typename?: "Query";
} & {
    customerNeed: {
        __typename?: "CustomerNeed";
    } & CustomerNeedFragment;
};
export declare type CustomerNeedsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CustomerNeedFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type CustomerNeedsQuery = {
    __typename?: "Query";
} & {
    customerNeeds: {
        __typename?: "CustomerNeedConnection";
    } & CustomerNeedConnectionFragment;
};
export declare type CustomerStatusQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type CustomerStatusQuery = {
    __typename?: "Query";
} & {
    customerStatus: {
        __typename?: "CustomerStatus";
    } & CustomerStatusFragment;
};
export declare type CustomerStatusesQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type CustomerStatusesQuery = {
    __typename?: "Query";
} & {
    customerStatuses: {
        __typename?: "CustomerStatusConnection";
    } & CustomerStatusConnectionFragment;
};
export declare type CustomerTierQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type CustomerTierQuery = {
    __typename?: "Query";
} & {
    customerTier: {
        __typename?: "CustomerTier";
    } & CustomerTierFragment;
};
export declare type CustomerTiersQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type CustomerTiersQuery = {
    __typename?: "Query";
} & {
    customerTiers: {
        __typename?: "CustomerTierConnection";
    } & CustomerTierConnectionFragment;
};
export declare type CustomersQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CustomerFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
    sorts?: Maybe<Array<CustomerSortInput> | CustomerSortInput>;
}>;
export declare type CustomersQuery = {
    __typename?: "Query";
} & {
    customers: {
        __typename?: "CustomerConnection";
    } & CustomerConnectionFragment;
};
export declare type CycleQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type CycleQuery = {
    __typename?: "Query";
} & {
    cycle: {
        __typename?: "Cycle";
    } & CycleFragment;
};
export declare type Cycle_IssuesQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Cycle_IssuesQuery = {
    __typename?: "Query";
} & {
    cycle: {
        __typename?: "Cycle";
    } & {
        issues: {
            __typename?: "IssueConnection";
        } & IssueConnectionFragment;
    };
};
export declare type Cycle_UncompletedIssuesUponCloseQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Cycle_UncompletedIssuesUponCloseQuery = {
    __typename?: "Query";
} & {
    cycle: {
        __typename?: "Cycle";
    } & {
        uncompletedIssuesUponClose: {
            __typename?: "IssueConnection";
        } & IssueConnectionFragment;
    };
};
export declare type CyclesQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CycleFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type CyclesQuery = {
    __typename?: "Query";
} & {
    cycles: {
        __typename?: "CycleConnection";
    } & CycleConnectionFragment;
};
export declare type DocumentQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DocumentQuery = {
    __typename?: "Query";
} & {
    document: {
        __typename?: "Document";
    } & DocumentFragment;
};
export declare type Document_CommentsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CommentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Document_CommentsQuery = {
    __typename?: "Query";
} & {
    document: {
        __typename?: "Document";
    } & {
        comments: {
            __typename?: "CommentConnection";
        } & CommentConnectionFragment;
    };
};
export declare type DocumentContentHistoryQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DocumentContentHistoryQuery = {
    __typename?: "Query";
} & {
    documentContentHistory: {
        __typename?: "DocumentContentHistoryPayload";
    } & DocumentContentHistoryPayloadFragment;
};
export declare type DocumentsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<DocumentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type DocumentsQuery = {
    __typename?: "Query";
} & {
    documents: {
        __typename?: "DocumentConnection";
    } & DocumentConnectionFragment;
};
export declare type EmojiQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type EmojiQuery = {
    __typename?: "Query";
} & {
    emoji: {
        __typename?: "Emoji";
    } & EmojiFragment;
};
export declare type EmojisQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type EmojisQuery = {
    __typename?: "Query";
} & {
    emojis: {
        __typename?: "EmojiConnection";
    } & EmojiConnectionFragment;
};
export declare type EntityExternalLinkQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type EntityExternalLinkQuery = {
    __typename?: "Query";
} & {
    entityExternalLink: {
        __typename?: "EntityExternalLink";
    } & EntityExternalLinkFragment;
};
export declare type ExternalUserQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type ExternalUserQuery = {
    __typename?: "Query";
} & {
    externalUser: {
        __typename?: "ExternalUser";
    } & ExternalUserFragment;
};
export declare type ExternalUsersQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type ExternalUsersQuery = {
    __typename?: "Query";
} & {
    externalUsers: {
        __typename?: "ExternalUserConnection";
    } & ExternalUserConnectionFragment;
};
export declare type FavoriteQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type FavoriteQuery = {
    __typename?: "Query";
} & {
    favorite: {
        __typename?: "Favorite";
    } & FavoriteFragment;
};
export declare type Favorite_ChildrenQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Favorite_ChildrenQuery = {
    __typename?: "Query";
} & {
    favorite: {
        __typename?: "Favorite";
    } & {
        children: {
            __typename?: "FavoriteConnection";
        } & FavoriteConnectionFragment;
    };
};
export declare type FavoritesQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type FavoritesQuery = {
    __typename?: "Query";
} & {
    favorites: {
        __typename?: "FavoriteConnection";
    } & FavoriteConnectionFragment;
};
export declare type InitiativeQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type InitiativeQuery = {
    __typename?: "Query";
} & {
    initiative: {
        __typename?: "Initiative";
    } & InitiativeFragment;
};
export declare type Initiative_HistoryQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Initiative_HistoryQuery = {
    __typename?: "Query";
} & {
    initiative: {
        __typename?: "Initiative";
    } & {
        history: {
            __typename?: "InitiativeHistoryConnection";
        } & InitiativeHistoryConnectionFragment;
    };
};
export declare type Initiative_LinksQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Initiative_LinksQuery = {
    __typename?: "Query";
} & {
    initiative: {
        __typename?: "Initiative";
    } & {
        links: {
            __typename?: "EntityExternalLinkConnection";
        } & EntityExternalLinkConnectionFragment;
    };
};
export declare type Initiative_ProjectsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Initiative_ProjectsQuery = {
    __typename?: "Query";
} & {
    initiative: {
        __typename?: "Initiative";
    } & {
        projects: {
            __typename?: "ProjectConnection";
        } & ProjectConnectionFragment;
    };
};
export declare type InitiativeRelationQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type InitiativeRelationQuery = {
    __typename?: "Query";
} & {
    initiativeRelation: {
        __typename?: "ProjectRelation";
    } & ProjectRelationFragment;
};
export declare type InitiativeRelationsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type InitiativeRelationsQuery = {
    __typename?: "Query";
} & {
    initiativeRelations: {
        __typename?: "InitiativeRelationConnection";
    } & InitiativeRelationConnectionFragment;
};
export declare type InitiativeToProjectQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type InitiativeToProjectQuery = {
    __typename?: "Query";
} & {
    initiativeToProject: {
        __typename?: "InitiativeToProject";
    } & InitiativeToProjectFragment;
};
export declare type InitiativeToProjectsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type InitiativeToProjectsQuery = {
    __typename?: "Query";
} & {
    initiativeToProjects: {
        __typename?: "InitiativeToProjectConnection";
    } & InitiativeToProjectConnectionFragment;
};
export declare type InitiativeUpdateQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type InitiativeUpdateQuery = {
    __typename?: "Query";
} & {
    initiativeUpdate: {
        __typename?: "InitiativeUpdate";
    } & InitiativeUpdateFragment;
};
export declare type InitiativeUpdate_CommentsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CommentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type InitiativeUpdate_CommentsQuery = {
    __typename?: "Query";
} & {
    initiativeUpdate: {
        __typename?: "InitiativeUpdate";
    } & {
        comments: {
            __typename?: "CommentConnection";
        } & CommentConnectionFragment;
    };
};
export declare type InitiativeUpdatesQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<InitiativeUpdateFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type InitiativeUpdatesQuery = {
    __typename?: "Query";
} & {
    initiativeUpdates: {
        __typename?: "InitiativeUpdateConnection";
    } & InitiativeUpdateConnectionFragment;
};
export declare type InitiativesQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<InitiativeFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type InitiativesQuery = {
    __typename?: "Query";
} & {
    initiatives: {
        __typename?: "InitiativeConnection";
    } & InitiativeConnectionFragment;
};
export declare type IntegrationQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type IntegrationQuery = {
    __typename?: "Query";
} & {
    integration: {
        __typename?: "Integration";
    } & IntegrationFragment;
};
export declare type IntegrationHasScopesQueryVariables = Exact<{
    integrationId: Scalars["String"];
    scopes: Array<Scalars["String"]> | Scalars["String"];
}>;
export declare type IntegrationHasScopesQuery = {
    __typename?: "Query";
} & {
    integrationHasScopes: {
        __typename?: "IntegrationHasScopesPayload";
    } & IntegrationHasScopesPayloadFragment;
};
export declare type IntegrationTemplateQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type IntegrationTemplateQuery = {
    __typename?: "Query";
} & {
    integrationTemplate: {
        __typename?: "IntegrationTemplate";
    } & IntegrationTemplateFragment;
};
export declare type IntegrationTemplatesQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type IntegrationTemplatesQuery = {
    __typename?: "Query";
} & {
    integrationTemplates: {
        __typename?: "IntegrationTemplateConnection";
    } & IntegrationTemplateConnectionFragment;
};
export declare type IntegrationsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type IntegrationsQuery = {
    __typename?: "Query";
} & {
    integrations: {
        __typename?: "IntegrationConnection";
    } & IntegrationConnectionFragment;
};
export declare type IntegrationsSettingsQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type IntegrationsSettingsQuery = {
    __typename?: "Query";
} & {
    integrationsSettings: {
        __typename?: "IntegrationsSettings";
    } & IntegrationsSettingsFragment;
};
export declare type IssueQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type IssueQuery = {
    __typename?: "Query";
} & {
    issue: {
        __typename?: "Issue";
    } & IssueFragment;
};
export declare type Issue_AttachmentsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<AttachmentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Issue_AttachmentsQuery = {
    __typename?: "Query";
} & {
    issue: {
        __typename?: "Issue";
    } & {
        attachments: {
            __typename?: "AttachmentConnection";
        } & AttachmentConnectionFragment;
    };
};
export declare type Issue_BotActorQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type Issue_BotActorQuery = {
    __typename?: "Query";
} & {
    issue: {
        __typename?: "Issue";
    } & {
        botActor?: Maybe<{
            __typename?: "ActorBot";
        } & ActorBotFragment>;
    };
};
export declare type Issue_ChildrenQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Issue_ChildrenQuery = {
    __typename?: "Query";
} & {
    issue: {
        __typename?: "Issue";
    } & {
        children: {
            __typename?: "IssueConnection";
        } & IssueConnectionFragment;
    };
};
export declare type Issue_CommentsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CommentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Issue_CommentsQuery = {
    __typename?: "Query";
} & {
    issue: {
        __typename?: "Issue";
    } & {
        comments: {
            __typename?: "CommentConnection";
        } & CommentConnectionFragment;
    };
};
export declare type Issue_HistoryQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Issue_HistoryQuery = {
    __typename?: "Query";
} & {
    issue: {
        __typename?: "Issue";
    } & {
        history: {
            __typename?: "IssueHistoryConnection";
        } & IssueHistoryConnectionFragment;
    };
};
export declare type Issue_InverseRelationsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Issue_InverseRelationsQuery = {
    __typename?: "Query";
} & {
    issue: {
        __typename?: "Issue";
    } & {
        inverseRelations: {
            __typename?: "IssueRelationConnection";
        } & IssueRelationConnectionFragment;
    };
};
export declare type Issue_LabelsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueLabelFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Issue_LabelsQuery = {
    __typename?: "Query";
} & {
    issue: {
        __typename?: "Issue";
    } & {
        labels: {
            __typename?: "IssueLabelConnection";
        } & IssueLabelConnectionFragment;
    };
};
export declare type Issue_NeedsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CustomerNeedFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Issue_NeedsQuery = {
    __typename?: "Query";
} & {
    issue: {
        __typename?: "Issue";
    } & {
        needs: {
            __typename?: "CustomerNeedConnection";
        } & CustomerNeedConnectionFragment;
    };
};
export declare type Issue_RelationsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Issue_RelationsQuery = {
    __typename?: "Query";
} & {
    issue: {
        __typename?: "Issue";
    } & {
        relations: {
            __typename?: "IssueRelationConnection";
        } & IssueRelationConnectionFragment;
    };
};
export declare type Issue_SubscribersQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<UserFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeDisabled?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Issue_SubscribersQuery = {
    __typename?: "Query";
} & {
    issue: {
        __typename?: "Issue";
    } & {
        subscribers: {
            __typename?: "UserConnection";
        } & UserConnectionFragment;
    };
};
export declare type IssueFigmaFileKeySearchQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    fileKey: Scalars["String"];
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type IssueFigmaFileKeySearchQuery = {
    __typename?: "Query";
} & {
    issueFigmaFileKeySearch: {
        __typename?: "IssueConnection";
    } & IssueConnectionFragment;
};
export declare type IssueFilterSuggestionQueryVariables = Exact<{
    projectId?: Maybe<Scalars["String"]>;
    prompt: Scalars["String"];
}>;
export declare type IssueFilterSuggestionQuery = {
    __typename?: "Query";
} & {
    issueFilterSuggestion: {
        __typename?: "IssueFilterSuggestionPayload";
    } & IssueFilterSuggestionPayloadFragment;
};
export declare type IssueImportCheckCsvQueryVariables = Exact<{
    csvUrl: Scalars["String"];
    service: Scalars["String"];
}>;
export declare type IssueImportCheckCsvQuery = {
    __typename?: "Query";
} & {
    issueImportCheckCSV: {
        __typename?: "IssueImportCheckPayload";
    } & IssueImportCheckPayloadFragment;
};
export declare type IssueImportCheckSyncQueryVariables = Exact<{
    issueImportId: Scalars["String"];
}>;
export declare type IssueImportCheckSyncQuery = {
    __typename?: "Query";
} & {
    issueImportCheckSync: {
        __typename?: "IssueImportSyncCheckPayload";
    } & IssueImportSyncCheckPayloadFragment;
};
export declare type IssueImportJqlCheckQueryVariables = Exact<{
    jiraEmail: Scalars["String"];
    jiraHostname: Scalars["String"];
    jiraProject: Scalars["String"];
    jiraToken: Scalars["String"];
    jql: Scalars["String"];
}>;
export declare type IssueImportJqlCheckQuery = {
    __typename?: "Query";
} & {
    issueImportJqlCheck: {
        __typename?: "IssueImportJqlCheckPayload";
    } & IssueImportJqlCheckPayloadFragment;
};
export declare type IssueLabelQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type IssueLabelQuery = {
    __typename?: "Query";
} & {
    issueLabel: {
        __typename?: "IssueLabel";
    } & IssueLabelFragment;
};
export declare type IssueLabel_ChildrenQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueLabelFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type IssueLabel_ChildrenQuery = {
    __typename?: "Query";
} & {
    issueLabel: {
        __typename?: "IssueLabel";
    } & {
        children: {
            __typename?: "IssueLabelConnection";
        } & IssueLabelConnectionFragment;
    };
};
export declare type IssueLabel_IssuesQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type IssueLabel_IssuesQuery = {
    __typename?: "Query";
} & {
    issueLabel: {
        __typename?: "IssueLabel";
    } & {
        issues: {
            __typename?: "IssueConnection";
        } & IssueConnectionFragment;
    };
};
export declare type IssueLabelsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueLabelFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type IssueLabelsQuery = {
    __typename?: "Query";
} & {
    issueLabels: {
        __typename?: "IssueLabelConnection";
    } & IssueLabelConnectionFragment;
};
export declare type IssuePriorityValuesQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type IssuePriorityValuesQuery = {
    __typename?: "Query";
} & {
    issuePriorityValues: Array<{
        __typename?: "IssuePriorityValue";
    } & IssuePriorityValueFragment>;
};
export declare type IssueRelationQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type IssueRelationQuery = {
    __typename?: "Query";
} & {
    issueRelation: {
        __typename?: "IssueRelation";
    } & IssueRelationFragment;
};
export declare type IssueRelationsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type IssueRelationsQuery = {
    __typename?: "Query";
} & {
    issueRelations: {
        __typename?: "IssueRelationConnection";
    } & IssueRelationConnectionFragment;
};
export declare type IssueSearchQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
    query?: Maybe<Scalars["String"]>;
}>;
export declare type IssueSearchQuery = {
    __typename?: "Query";
} & {
    issueSearch: {
        __typename?: "IssueConnection";
    } & IssueConnectionFragment;
};
export declare type IssueTitleSuggestionFromCustomerRequestQueryVariables = Exact<{
    request: Scalars["String"];
}>;
export declare type IssueTitleSuggestionFromCustomerRequestQuery = {
    __typename?: "Query";
} & {
    issueTitleSuggestionFromCustomerRequest: {
        __typename?: "IssueTitleSuggestionFromCustomerRequestPayload";
    } & IssueTitleSuggestionFromCustomerRequestPayloadFragment;
};
export declare type IssueVcsBranchSearchQueryVariables = Exact<{
    branchName: Scalars["String"];
}>;
export declare type IssueVcsBranchSearchQuery = {
    __typename?: "Query";
} & {
    issueVcsBranchSearch?: Maybe<{
        __typename?: "Issue";
    } & IssueFragment>;
};
export declare type IssueVcsBranchSearch_AttachmentsQueryVariables = Exact<{
    branchName: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<AttachmentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type IssueVcsBranchSearch_AttachmentsQuery = {
    __typename?: "Query";
} & {
    issueVcsBranchSearch?: Maybe<{
        __typename?: "Issue";
    } & {
        attachments: {
            __typename?: "AttachmentConnection";
        } & AttachmentConnectionFragment;
    }>;
};
export declare type IssueVcsBranchSearch_BotActorQueryVariables = Exact<{
    branchName: Scalars["String"];
}>;
export declare type IssueVcsBranchSearch_BotActorQuery = {
    __typename?: "Query";
} & {
    issueVcsBranchSearch?: Maybe<{
        __typename?: "Issue";
    } & {
        botActor?: Maybe<{
            __typename?: "ActorBot";
        } & ActorBotFragment>;
    }>;
};
export declare type IssueVcsBranchSearch_ChildrenQueryVariables = Exact<{
    branchName: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type IssueVcsBranchSearch_ChildrenQuery = {
    __typename?: "Query";
} & {
    issueVcsBranchSearch?: Maybe<{
        __typename?: "Issue";
    } & {
        children: {
            __typename?: "IssueConnection";
        } & IssueConnectionFragment;
    }>;
};
export declare type IssueVcsBranchSearch_CommentsQueryVariables = Exact<{
    branchName: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CommentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type IssueVcsBranchSearch_CommentsQuery = {
    __typename?: "Query";
} & {
    issueVcsBranchSearch?: Maybe<{
        __typename?: "Issue";
    } & {
        comments: {
            __typename?: "CommentConnection";
        } & CommentConnectionFragment;
    }>;
};
export declare type IssueVcsBranchSearch_HistoryQueryVariables = Exact<{
    branchName: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type IssueVcsBranchSearch_HistoryQuery = {
    __typename?: "Query";
} & {
    issueVcsBranchSearch?: Maybe<{
        __typename?: "Issue";
    } & {
        history: {
            __typename?: "IssueHistoryConnection";
        } & IssueHistoryConnectionFragment;
    }>;
};
export declare type IssueVcsBranchSearch_InverseRelationsQueryVariables = Exact<{
    branchName: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type IssueVcsBranchSearch_InverseRelationsQuery = {
    __typename?: "Query";
} & {
    issueVcsBranchSearch?: Maybe<{
        __typename?: "Issue";
    } & {
        inverseRelations: {
            __typename?: "IssueRelationConnection";
        } & IssueRelationConnectionFragment;
    }>;
};
export declare type IssueVcsBranchSearch_LabelsQueryVariables = Exact<{
    branchName: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueLabelFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type IssueVcsBranchSearch_LabelsQuery = {
    __typename?: "Query";
} & {
    issueVcsBranchSearch?: Maybe<{
        __typename?: "Issue";
    } & {
        labels: {
            __typename?: "IssueLabelConnection";
        } & IssueLabelConnectionFragment;
    }>;
};
export declare type IssueVcsBranchSearch_NeedsQueryVariables = Exact<{
    branchName: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CustomerNeedFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type IssueVcsBranchSearch_NeedsQuery = {
    __typename?: "Query";
} & {
    issueVcsBranchSearch?: Maybe<{
        __typename?: "Issue";
    } & {
        needs: {
            __typename?: "CustomerNeedConnection";
        } & CustomerNeedConnectionFragment;
    }>;
};
export declare type IssueVcsBranchSearch_RelationsQueryVariables = Exact<{
    branchName: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type IssueVcsBranchSearch_RelationsQuery = {
    __typename?: "Query";
} & {
    issueVcsBranchSearch?: Maybe<{
        __typename?: "Issue";
    } & {
        relations: {
            __typename?: "IssueRelationConnection";
        } & IssueRelationConnectionFragment;
    }>;
};
export declare type IssueVcsBranchSearch_SubscribersQueryVariables = Exact<{
    branchName: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<UserFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeDisabled?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type IssueVcsBranchSearch_SubscribersQuery = {
    __typename?: "Query";
} & {
    issueVcsBranchSearch?: Maybe<{
        __typename?: "Issue";
    } & {
        subscribers: {
            __typename?: "UserConnection";
        } & UserConnectionFragment;
    }>;
};
export declare type IssuesQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
    sort?: Maybe<Array<IssueSortInput> | IssueSortInput>;
}>;
export declare type IssuesQuery = {
    __typename?: "Query";
} & {
    issues: {
        __typename?: "IssueConnection";
    } & IssueConnectionFragment;
};
export declare type NotificationQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type NotificationQuery = {
    __typename?: "Query";
} & {
    notification: ({
        __typename?: "CustomerNeedNotification";
    } & Notification_CustomerNeedNotification_Fragment) | ({
        __typename?: "DocumentNotification";
    } & Notification_DocumentNotification_Fragment) | ({
        __typename?: "InitiativeNotification";
    } & Notification_InitiativeNotification_Fragment) | ({
        __typename?: "IssueNotification";
    } & Notification_IssueNotification_Fragment) | ({
        __typename?: "OauthClientApprovalNotification";
    } & Notification_OauthClientApprovalNotification_Fragment) | ({
        __typename?: "PostNotification";
    } & Notification_PostNotification_Fragment) | ({
        __typename?: "ProjectNotification";
    } & Notification_ProjectNotification_Fragment) | ({
        __typename?: "PullRequestNotification";
    } & Notification_PullRequestNotification_Fragment);
};
export declare type NotificationSubscriptionQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type NotificationSubscriptionQuery = {
    __typename?: "Query";
} & {
    notificationSubscription: ({
        __typename?: "CustomViewNotificationSubscription";
    } & NotificationSubscription_CustomViewNotificationSubscription_Fragment) | ({
        __typename?: "CustomerNotificationSubscription";
    } & NotificationSubscription_CustomerNotificationSubscription_Fragment) | ({
        __typename?: "CycleNotificationSubscription";
    } & NotificationSubscription_CycleNotificationSubscription_Fragment) | ({
        __typename?: "InitiativeNotificationSubscription";
    } & NotificationSubscription_InitiativeNotificationSubscription_Fragment) | ({
        __typename?: "LabelNotificationSubscription";
    } & NotificationSubscription_LabelNotificationSubscription_Fragment) | ({
        __typename?: "ProjectNotificationSubscription";
    } & NotificationSubscription_ProjectNotificationSubscription_Fragment) | ({
        __typename?: "TeamNotificationSubscription";
    } & NotificationSubscription_TeamNotificationSubscription_Fragment) | ({
        __typename?: "UserNotificationSubscription";
    } & NotificationSubscription_UserNotificationSubscription_Fragment);
};
export declare type NotificationSubscriptionsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type NotificationSubscriptionsQuery = {
    __typename?: "Query";
} & {
    notificationSubscriptions: {
        __typename?: "NotificationSubscriptionConnection";
    } & NotificationSubscriptionConnectionFragment;
};
export declare type NotificationsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<NotificationFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type NotificationsQuery = {
    __typename?: "Query";
} & {
    notifications: {
        __typename?: "NotificationConnection";
    } & NotificationConnectionFragment;
};
export declare type OrganizationQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type OrganizationQuery = {
    __typename?: "Query";
} & {
    organization: {
        __typename?: "Organization";
    } & OrganizationFragment;
};
export declare type Organization_IntegrationsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Organization_IntegrationsQuery = {
    __typename?: "Query";
} & {
    organization: {
        __typename?: "Organization";
    } & {
        integrations: {
            __typename?: "IntegrationConnection";
        } & IntegrationConnectionFragment;
    };
};
export declare type Organization_LabelsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueLabelFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Organization_LabelsQuery = {
    __typename?: "Query";
} & {
    organization: {
        __typename?: "Organization";
    } & {
        labels: {
            __typename?: "IssueLabelConnection";
        } & IssueLabelConnectionFragment;
    };
};
export declare type Organization_SubscriptionQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type Organization_SubscriptionQuery = {
    __typename?: "Query";
} & {
    organization: {
        __typename?: "Organization";
    } & {
        subscription?: Maybe<{
            __typename?: "PaidSubscription";
        } & PaidSubscriptionFragment>;
    };
};
export declare type Organization_TeamsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<TeamFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Organization_TeamsQuery = {
    __typename?: "Query";
} & {
    organization: {
        __typename?: "Organization";
    } & {
        teams: {
            __typename?: "TeamConnection";
        } & TeamConnectionFragment;
    };
};
export declare type Organization_TemplatesQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<NullableTemplateFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Organization_TemplatesQuery = {
    __typename?: "Query";
} & {
    organization: {
        __typename?: "Organization";
    } & {
        templates: {
            __typename?: "TemplateConnection";
        } & TemplateConnectionFragment;
    };
};
export declare type Organization_UsersQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeDisabled?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Organization_UsersQuery = {
    __typename?: "Query";
} & {
    organization: {
        __typename?: "Organization";
    } & {
        users: {
            __typename?: "UserConnection";
        } & UserConnectionFragment;
    };
};
export declare type OrganizationExistsQueryVariables = Exact<{
    urlKey: Scalars["String"];
}>;
export declare type OrganizationExistsQuery = {
    __typename?: "Query";
} & {
    organizationExists: {
        __typename?: "OrganizationExistsPayload";
    } & OrganizationExistsPayloadFragment;
};
export declare type OrganizationInviteQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type OrganizationInviteQuery = {
    __typename?: "Query";
} & {
    organizationInvite: {
        __typename?: "OrganizationInvite";
    } & OrganizationInviteFragment;
};
export declare type OrganizationInvitesQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type OrganizationInvitesQuery = {
    __typename?: "Query";
} & {
    organizationInvites: {
        __typename?: "OrganizationInviteConnection";
    } & OrganizationInviteConnectionFragment;
};
export declare type ProjectQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type ProjectQuery = {
    __typename?: "Query";
} & {
    project: {
        __typename?: "Project";
    } & ProjectFragment;
};
export declare type Project_CommentsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CommentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Project_CommentsQuery = {
    __typename?: "Query";
} & {
    project: {
        __typename?: "Project";
    } & {
        comments: {
            __typename?: "CommentConnection";
        } & CommentConnectionFragment;
    };
};
export declare type Project_DocumentContentQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type Project_DocumentContentQuery = {
    __typename?: "Query";
} & {
    project: {
        __typename?: "Project";
    } & {
        documentContent?: Maybe<{
            __typename?: "DocumentContent";
        } & DocumentContentFragment>;
    };
};
export declare type Project_DocumentsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<DocumentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Project_DocumentsQuery = {
    __typename?: "Query";
} & {
    project: {
        __typename?: "Project";
    } & {
        documents: {
            __typename?: "DocumentConnection";
        } & DocumentConnectionFragment;
    };
};
export declare type Project_ExternalLinksQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Project_ExternalLinksQuery = {
    __typename?: "Query";
} & {
    project: {
        __typename?: "Project";
    } & {
        externalLinks: {
            __typename?: "EntityExternalLinkConnection";
        } & EntityExternalLinkConnectionFragment;
    };
};
export declare type Project_HistoryQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Project_HistoryQuery = {
    __typename?: "Query";
} & {
    project: {
        __typename?: "Project";
    } & {
        history: {
            __typename?: "ProjectHistoryConnection";
        } & ProjectHistoryConnectionFragment;
    };
};
export declare type Project_InitiativesQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Project_InitiativesQuery = {
    __typename?: "Query";
} & {
    project: {
        __typename?: "Project";
    } & {
        initiatives: {
            __typename?: "InitiativeConnection";
        } & InitiativeConnectionFragment;
    };
};
export declare type Project_InverseRelationsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Project_InverseRelationsQuery = {
    __typename?: "Query";
} & {
    project: {
        __typename?: "Project";
    } & {
        inverseRelations: {
            __typename?: "ProjectRelationConnection";
        } & ProjectRelationConnectionFragment;
    };
};
export declare type Project_IssuesQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Project_IssuesQuery = {
    __typename?: "Query";
} & {
    project: {
        __typename?: "Project";
    } & {
        issues: {
            __typename?: "IssueConnection";
        } & IssueConnectionFragment;
    };
};
export declare type Project_MembersQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<UserFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeDisabled?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Project_MembersQuery = {
    __typename?: "Query";
} & {
    project: {
        __typename?: "Project";
    } & {
        members: {
            __typename?: "UserConnection";
        } & UserConnectionFragment;
    };
};
export declare type Project_NeedsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CustomerNeedFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Project_NeedsQuery = {
    __typename?: "Query";
} & {
    project: {
        __typename?: "Project";
    } & {
        needs: {
            __typename?: "CustomerNeedConnection";
        } & CustomerNeedConnectionFragment;
    };
};
export declare type Project_ProjectMilestonesQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectMilestoneFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Project_ProjectMilestonesQuery = {
    __typename?: "Query";
} & {
    project: {
        __typename?: "Project";
    } & {
        projectMilestones: {
            __typename?: "ProjectMilestoneConnection";
        } & ProjectMilestoneConnectionFragment;
    };
};
export declare type Project_ProjectUpdatesQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Project_ProjectUpdatesQuery = {
    __typename?: "Query";
} & {
    project: {
        __typename?: "Project";
    } & {
        projectUpdates: {
            __typename?: "ProjectUpdateConnection";
        } & ProjectUpdateConnectionFragment;
    };
};
export declare type Project_RelationsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Project_RelationsQuery = {
    __typename?: "Query";
} & {
    project: {
        __typename?: "Project";
    } & {
        relations: {
            __typename?: "ProjectRelationConnection";
        } & ProjectRelationConnectionFragment;
    };
};
export declare type Project_TeamsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<TeamFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Project_TeamsQuery = {
    __typename?: "Query";
} & {
    project: {
        __typename?: "Project";
    } & {
        teams: {
            __typename?: "TeamConnection";
        } & TeamConnectionFragment;
    };
};
export declare type ProjectFilterSuggestionQueryVariables = Exact<{
    prompt: Scalars["String"];
}>;
export declare type ProjectFilterSuggestionQuery = {
    __typename?: "Query";
} & {
    projectFilterSuggestion: {
        __typename?: "ProjectFilterSuggestionPayload";
    } & ProjectFilterSuggestionPayloadFragment;
};
export declare type ProjectMilestoneQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type ProjectMilestoneQuery = {
    __typename?: "Query";
} & {
    projectMilestone: {
        __typename?: "ProjectMilestone";
    } & ProjectMilestoneFragment;
};
export declare type ProjectMilestone_DocumentContentQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type ProjectMilestone_DocumentContentQuery = {
    __typename?: "Query";
} & {
    projectMilestone: {
        __typename?: "ProjectMilestone";
    } & {
        documentContent?: Maybe<{
            __typename?: "DocumentContent";
        } & DocumentContentFragment>;
    };
};
export declare type ProjectMilestone_IssuesQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type ProjectMilestone_IssuesQuery = {
    __typename?: "Query";
} & {
    projectMilestone: {
        __typename?: "ProjectMilestone";
    } & {
        issues: {
            __typename?: "IssueConnection";
        } & IssueConnectionFragment;
    };
};
export declare type ProjectMilestonesQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectMilestoneFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type ProjectMilestonesQuery = {
    __typename?: "Query";
} & {
    projectMilestones: {
        __typename?: "ProjectMilestoneConnection";
    } & ProjectMilestoneConnectionFragment;
};
export declare type ProjectRelationQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type ProjectRelationQuery = {
    __typename?: "Query";
} & {
    projectRelation: {
        __typename?: "ProjectRelation";
    } & ProjectRelationFragment;
};
export declare type ProjectRelationsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type ProjectRelationsQuery = {
    __typename?: "Query";
} & {
    projectRelations: {
        __typename?: "ProjectRelationConnection";
    } & ProjectRelationConnectionFragment;
};
export declare type ProjectStatusQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type ProjectStatusQuery = {
    __typename?: "Query";
} & {
    projectStatus: {
        __typename?: "ProjectStatus";
    } & ProjectStatusFragment;
};
export declare type ProjectStatusesQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type ProjectStatusesQuery = {
    __typename?: "Query";
} & {
    projectStatuses: {
        __typename?: "ProjectStatusConnection";
    } & ProjectStatusConnectionFragment;
};
export declare type ProjectUpdateQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type ProjectUpdateQuery = {
    __typename?: "Query";
} & {
    projectUpdate: {
        __typename?: "ProjectUpdate";
    } & ProjectUpdateFragment;
};
export declare type ProjectUpdate_CommentsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CommentFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type ProjectUpdate_CommentsQuery = {
    __typename?: "Query";
} & {
    projectUpdate: {
        __typename?: "ProjectUpdate";
    } & {
        comments: {
            __typename?: "CommentConnection";
        } & CommentConnectionFragment;
    };
};
export declare type ProjectUpdatesQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectUpdateFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type ProjectUpdatesQuery = {
    __typename?: "Query";
} & {
    projectUpdates: {
        __typename?: "ProjectUpdateConnection";
    } & ProjectUpdateConnectionFragment;
};
export declare type ProjectsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type ProjectsQuery = {
    __typename?: "Query";
} & {
    projects: {
        __typename?: "ProjectConnection";
    } & ProjectConnectionFragment;
};
export declare type PushSubscriptionTestQueryVariables = Exact<{
    sendStrategy?: Maybe<SendStrategy>;
    targetMobile?: Maybe<Scalars["Boolean"]>;
}>;
export declare type PushSubscriptionTestQuery = {
    __typename?: "Query";
} & {
    pushSubscriptionTest: {
        __typename?: "PushSubscriptionTestPayload";
    } & PushSubscriptionTestPayloadFragment;
};
export declare type RateLimitStatusQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type RateLimitStatusQuery = {
    __typename?: "Query";
} & {
    rateLimitStatus: {
        __typename?: "RateLimitPayload";
    } & RateLimitPayloadFragment;
};
export declare type RoadmapQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type RoadmapQuery = {
    __typename?: "Query";
} & {
    roadmap: {
        __typename?: "Roadmap";
    } & RoadmapFragment;
};
export declare type Roadmap_ProjectsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Roadmap_ProjectsQuery = {
    __typename?: "Query";
} & {
    roadmap: {
        __typename?: "Roadmap";
    } & {
        projects: {
            __typename?: "ProjectConnection";
        } & ProjectConnectionFragment;
    };
};
export declare type RoadmapToProjectQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type RoadmapToProjectQuery = {
    __typename?: "Query";
} & {
    roadmapToProject: {
        __typename?: "RoadmapToProject";
    } & RoadmapToProjectFragment;
};
export declare type RoadmapToProjectsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type RoadmapToProjectsQuery = {
    __typename?: "Query";
} & {
    roadmapToProjects: {
        __typename?: "RoadmapToProjectConnection";
    } & RoadmapToProjectConnectionFragment;
};
export declare type RoadmapsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type RoadmapsQuery = {
    __typename?: "Query";
} & {
    roadmaps: {
        __typename?: "RoadmapConnection";
    } & RoadmapConnectionFragment;
};
export declare type SearchDocumentsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeComments?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
    teamId?: Maybe<Scalars["String"]>;
    term: Scalars["String"];
}>;
export declare type SearchDocumentsQuery = {
    __typename?: "Query";
} & {
    searchDocuments: {
        __typename?: "DocumentSearchPayload";
    } & DocumentSearchPayloadFragment;
};
export declare type SearchDocuments_ArchivePayloadQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeComments?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
    teamId?: Maybe<Scalars["String"]>;
    term: Scalars["String"];
}>;
export declare type SearchDocuments_ArchivePayloadQuery = {
    __typename?: "Query";
} & {
    searchDocuments: {
        __typename?: "DocumentSearchPayload";
    } & {
        archivePayload: {
            __typename?: "ArchiveResponse";
        } & ArchiveResponseFragment;
    };
};
export declare type SearchIssuesQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeComments?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
    teamId?: Maybe<Scalars["String"]>;
    term: Scalars["String"];
}>;
export declare type SearchIssuesQuery = {
    __typename?: "Query";
} & {
    searchIssues: {
        __typename?: "IssueSearchPayload";
    } & IssueSearchPayloadFragment;
};
export declare type SearchIssues_ArchivePayloadQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeComments?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
    teamId?: Maybe<Scalars["String"]>;
    term: Scalars["String"];
}>;
export declare type SearchIssues_ArchivePayloadQuery = {
    __typename?: "Query";
} & {
    searchIssues: {
        __typename?: "IssueSearchPayload";
    } & {
        archivePayload: {
            __typename?: "ArchiveResponse";
        } & ArchiveResponseFragment;
    };
};
export declare type SearchProjectsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeComments?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
    teamId?: Maybe<Scalars["String"]>;
    term: Scalars["String"];
}>;
export declare type SearchProjectsQuery = {
    __typename?: "Query";
} & {
    searchProjects: {
        __typename?: "ProjectSearchPayload";
    } & ProjectSearchPayloadFragment;
};
export declare type SearchProjects_ArchivePayloadQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeComments?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
    teamId?: Maybe<Scalars["String"]>;
    term: Scalars["String"];
}>;
export declare type SearchProjects_ArchivePayloadQuery = {
    __typename?: "Query";
} & {
    searchProjects: {
        __typename?: "ProjectSearchPayload";
    } & {
        archivePayload: {
            __typename?: "ArchiveResponse";
        } & ArchiveResponseFragment;
    };
};
export declare type SsoUrlFromEmailQueryVariables = Exact<{
    email: Scalars["String"];
    isDesktop?: Maybe<Scalars["Boolean"]>;
}>;
export declare type SsoUrlFromEmailQuery = {
    __typename?: "Query";
} & {
    ssoUrlFromEmail: {
        __typename?: "SsoUrlFromEmailResponse";
    } & SsoUrlFromEmailResponseFragment;
};
export declare type TeamQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type TeamQuery = {
    __typename?: "Query";
} & {
    team: {
        __typename?: "Team";
    } & TeamFragment;
};
export declare type Team_CyclesQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<CycleFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Team_CyclesQuery = {
    __typename?: "Query";
} & {
    team: {
        __typename?: "Team";
    } & {
        cycles: {
            __typename?: "CycleConnection";
        } & CycleConnectionFragment;
    };
};
export declare type Team_GitAutomationStatesQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Team_GitAutomationStatesQuery = {
    __typename?: "Query";
} & {
    team: {
        __typename?: "Team";
    } & {
        gitAutomationStates: {
            __typename?: "GitAutomationStateConnection";
        } & GitAutomationStateConnectionFragment;
    };
};
export declare type Team_IssuesQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeSubTeams?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Team_IssuesQuery = {
    __typename?: "Query";
} & {
    team: {
        __typename?: "Team";
    } & {
        issues: {
            __typename?: "IssueConnection";
        } & IssueConnectionFragment;
    };
};
export declare type Team_LabelsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueLabelFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Team_LabelsQuery = {
    __typename?: "Query";
} & {
    team: {
        __typename?: "Team";
    } & {
        labels: {
            __typename?: "IssueLabelConnection";
        } & IssueLabelConnectionFragment;
    };
};
export declare type Team_MembersQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<UserFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeDisabled?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Team_MembersQuery = {
    __typename?: "Query";
} & {
    team: {
        __typename?: "Team";
    } & {
        members: {
            __typename?: "UserConnection";
        } & UserConnectionFragment;
    };
};
export declare type Team_MembershipsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Team_MembershipsQuery = {
    __typename?: "Query";
} & {
    team: {
        __typename?: "Team";
    } & {
        memberships: {
            __typename?: "TeamMembershipConnection";
        } & TeamMembershipConnectionFragment;
    };
};
export declare type Team_ProjectsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<ProjectFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeSubTeams?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Team_ProjectsQuery = {
    __typename?: "Query";
} & {
    team: {
        __typename?: "Team";
    } & {
        projects: {
            __typename?: "ProjectConnection";
        } & ProjectConnectionFragment;
    };
};
export declare type Team_StatesQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<WorkflowStateFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Team_StatesQuery = {
    __typename?: "Query";
} & {
    team: {
        __typename?: "Team";
    } & {
        states: {
            __typename?: "WorkflowStateConnection";
        } & WorkflowStateConnectionFragment;
    };
};
export declare type Team_TemplatesQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<NullableTemplateFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Team_TemplatesQuery = {
    __typename?: "Query";
} & {
    team: {
        __typename?: "Team";
    } & {
        templates: {
            __typename?: "TemplateConnection";
        } & TemplateConnectionFragment;
    };
};
export declare type Team_WebhooksQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Team_WebhooksQuery = {
    __typename?: "Query";
} & {
    team: {
        __typename?: "Team";
    } & {
        webhooks: {
            __typename?: "WebhookConnection";
        } & WebhookConnectionFragment;
    };
};
export declare type TeamMembershipQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type TeamMembershipQuery = {
    __typename?: "Query";
} & {
    teamMembership: {
        __typename?: "TeamMembership";
    } & TeamMembershipFragment;
};
export declare type TeamMembershipsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type TeamMembershipsQuery = {
    __typename?: "Query";
} & {
    teamMemberships: {
        __typename?: "TeamMembershipConnection";
    } & TeamMembershipConnectionFragment;
};
export declare type TeamsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<TeamFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type TeamsQuery = {
    __typename?: "Query";
} & {
    teams: {
        __typename?: "TeamConnection";
    } & TeamConnectionFragment;
};
export declare type TemplateQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type TemplateQuery = {
    __typename?: "Query";
} & {
    template: {
        __typename?: "Template";
    } & TemplateFragment;
};
export declare type TemplatesQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type TemplatesQuery = {
    __typename?: "Query";
} & {
    templates: Array<{
        __typename?: "Template";
    } & TemplateFragment>;
};
export declare type TemplatesForIntegrationQueryVariables = Exact<{
    integrationType: Scalars["String"];
}>;
export declare type TemplatesForIntegrationQuery = {
    __typename?: "Query";
} & {
    templatesForIntegration: Array<{
        __typename?: "Template";
    } & TemplateFragment>;
};
export declare type TimeScheduleQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type TimeScheduleQuery = {
    __typename?: "Query";
} & {
    timeSchedule: {
        __typename?: "TimeSchedule";
    } & TimeScheduleFragment;
};
export declare type TimeSchedulesQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type TimeSchedulesQuery = {
    __typename?: "Query";
} & {
    timeSchedules: {
        __typename?: "TimeScheduleConnection";
    } & TimeScheduleConnectionFragment;
};
export declare type TriageResponsibilitiesQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type TriageResponsibilitiesQuery = {
    __typename?: "Query";
} & {
    triageResponsibilities: {
        __typename?: "TriageResponsibilityConnection";
    } & TriageResponsibilityConnectionFragment;
};
export declare type TriageResponsibilityQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type TriageResponsibilityQuery = {
    __typename?: "Query";
} & {
    triageResponsibility: {
        __typename?: "TriageResponsibility";
    } & TriageResponsibilityFragment;
};
export declare type TriageResponsibility_ManualSelectionQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type TriageResponsibility_ManualSelectionQuery = {
    __typename?: "Query";
} & {
    triageResponsibility: {
        __typename?: "TriageResponsibility";
    } & {
        manualSelection?: Maybe<{
            __typename?: "TriageResponsibilityManualSelection";
        } & TriageResponsibilityManualSelectionFragment>;
    };
};
export declare type UserQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type UserQuery = {
    __typename?: "Query";
} & {
    user: {
        __typename?: "User";
    } & UserFragment;
};
export declare type User_AssignedIssuesQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type User_AssignedIssuesQuery = {
    __typename?: "Query";
} & {
    user: {
        __typename?: "User";
    } & {
        assignedIssues: {
            __typename?: "IssueConnection";
        } & IssueConnectionFragment;
    };
};
export declare type User_CreatedIssuesQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type User_CreatedIssuesQuery = {
    __typename?: "Query";
} & {
    user: {
        __typename?: "User";
    } & {
        createdIssues: {
            __typename?: "IssueConnection";
        } & IssueConnectionFragment;
    };
};
export declare type User_DraftsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type User_DraftsQuery = {
    __typename?: "Query";
} & {
    user: {
        __typename?: "User";
    } & {
        drafts: {
            __typename?: "DraftConnection";
        } & DraftConnectionFragment;
    };
};
export declare type User_TeamMembershipsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type User_TeamMembershipsQuery = {
    __typename?: "Query";
} & {
    user: {
        __typename?: "User";
    } & {
        teamMemberships: {
            __typename?: "TeamMembershipConnection";
        } & TeamMembershipConnectionFragment;
    };
};
export declare type User_TeamsQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<TeamFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type User_TeamsQuery = {
    __typename?: "Query";
} & {
    user: {
        __typename?: "User";
    } & {
        teams: {
            __typename?: "TeamConnection";
        } & TeamConnectionFragment;
    };
};
export declare type UserSettingsQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettingsQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & UserSettingsFragment;
};
export declare type UserSettings_NotificationCategoryPreferencesQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationCategoryPreferencesQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationCategoryPreferences: {
            __typename?: "NotificationCategoryPreferences";
        } & NotificationCategoryPreferencesFragment;
    };
};
export declare type UserSettings_NotificationCategoryPreferences_AppsAndIntegrationsQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationCategoryPreferences_AppsAndIntegrationsQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationCategoryPreferences: {
            __typename?: "NotificationCategoryPreferences";
        } & {
            appsAndIntegrations: {
                __typename?: "NotificationChannelPreferences";
            } & NotificationChannelPreferencesFragment;
        };
    };
};
export declare type UserSettings_NotificationCategoryPreferences_AssignmentsQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationCategoryPreferences_AssignmentsQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationCategoryPreferences: {
            __typename?: "NotificationCategoryPreferences";
        } & {
            assignments: {
                __typename?: "NotificationChannelPreferences";
            } & NotificationChannelPreferencesFragment;
        };
    };
};
export declare type UserSettings_NotificationCategoryPreferences_CommentsAndRepliesQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationCategoryPreferences_CommentsAndRepliesQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationCategoryPreferences: {
            __typename?: "NotificationCategoryPreferences";
        } & {
            commentsAndReplies: {
                __typename?: "NotificationChannelPreferences";
            } & NotificationChannelPreferencesFragment;
        };
    };
};
export declare type UserSettings_NotificationCategoryPreferences_CustomersQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationCategoryPreferences_CustomersQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationCategoryPreferences: {
            __typename?: "NotificationCategoryPreferences";
        } & {
            customers: {
                __typename?: "NotificationChannelPreferences";
            } & NotificationChannelPreferencesFragment;
        };
    };
};
export declare type UserSettings_NotificationCategoryPreferences_DocumentChangesQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationCategoryPreferences_DocumentChangesQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationCategoryPreferences: {
            __typename?: "NotificationCategoryPreferences";
        } & {
            documentChanges: {
                __typename?: "NotificationChannelPreferences";
            } & NotificationChannelPreferencesFragment;
        };
    };
};
export declare type UserSettings_NotificationCategoryPreferences_MentionsQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationCategoryPreferences_MentionsQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationCategoryPreferences: {
            __typename?: "NotificationCategoryPreferences";
        } & {
            mentions: {
                __typename?: "NotificationChannelPreferences";
            } & NotificationChannelPreferencesFragment;
        };
    };
};
export declare type UserSettings_NotificationCategoryPreferences_PostsAndUpdatesQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationCategoryPreferences_PostsAndUpdatesQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationCategoryPreferences: {
            __typename?: "NotificationCategoryPreferences";
        } & {
            postsAndUpdates: {
                __typename?: "NotificationChannelPreferences";
            } & NotificationChannelPreferencesFragment;
        };
    };
};
export declare type UserSettings_NotificationCategoryPreferences_ReactionsQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationCategoryPreferences_ReactionsQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationCategoryPreferences: {
            __typename?: "NotificationCategoryPreferences";
        } & {
            reactions: {
                __typename?: "NotificationChannelPreferences";
            } & NotificationChannelPreferencesFragment;
        };
    };
};
export declare type UserSettings_NotificationCategoryPreferences_RemindersQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationCategoryPreferences_RemindersQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationCategoryPreferences: {
            __typename?: "NotificationCategoryPreferences";
        } & {
            reminders: {
                __typename?: "NotificationChannelPreferences";
            } & NotificationChannelPreferencesFragment;
        };
    };
};
export declare type UserSettings_NotificationCategoryPreferences_ReviewsQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationCategoryPreferences_ReviewsQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationCategoryPreferences: {
            __typename?: "NotificationCategoryPreferences";
        } & {
            reviews: {
                __typename?: "NotificationChannelPreferences";
            } & NotificationChannelPreferencesFragment;
        };
    };
};
export declare type UserSettings_NotificationCategoryPreferences_StatusChangesQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationCategoryPreferences_StatusChangesQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationCategoryPreferences: {
            __typename?: "NotificationCategoryPreferences";
        } & {
            statusChanges: {
                __typename?: "NotificationChannelPreferences";
            } & NotificationChannelPreferencesFragment;
        };
    };
};
export declare type UserSettings_NotificationCategoryPreferences_SubscriptionsQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationCategoryPreferences_SubscriptionsQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationCategoryPreferences: {
            __typename?: "NotificationCategoryPreferences";
        } & {
            subscriptions: {
                __typename?: "NotificationChannelPreferences";
            } & NotificationChannelPreferencesFragment;
        };
    };
};
export declare type UserSettings_NotificationCategoryPreferences_SystemQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationCategoryPreferences_SystemQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationCategoryPreferences: {
            __typename?: "NotificationCategoryPreferences";
        } & {
            system: {
                __typename?: "NotificationChannelPreferences";
            } & NotificationChannelPreferencesFragment;
        };
    };
};
export declare type UserSettings_NotificationCategoryPreferences_TriageQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationCategoryPreferences_TriageQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationCategoryPreferences: {
            __typename?: "NotificationCategoryPreferences";
        } & {
            triage: {
                __typename?: "NotificationChannelPreferences";
            } & NotificationChannelPreferencesFragment;
        };
    };
};
export declare type UserSettings_NotificationChannelPreferencesQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationChannelPreferencesQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationChannelPreferences: {
            __typename?: "NotificationChannelPreferences";
        } & NotificationChannelPreferencesFragment;
    };
};
export declare type UserSettings_NotificationDeliveryPreferencesQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationDeliveryPreferencesQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationDeliveryPreferences: {
            __typename?: "NotificationDeliveryPreferences";
        } & NotificationDeliveryPreferencesFragment;
    };
};
export declare type UserSettings_NotificationDeliveryPreferences_MobileQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationDeliveryPreferences_MobileQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationDeliveryPreferences: {
            __typename?: "NotificationDeliveryPreferences";
        } & {
            mobile?: Maybe<{
                __typename?: "NotificationDeliveryPreferencesChannel";
            } & NotificationDeliveryPreferencesChannelFragment>;
        };
    };
};
export declare type UserSettings_NotificationDeliveryPreferences_Mobile_ScheduleQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationDeliveryPreferences_Mobile_ScheduleQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationDeliveryPreferences: {
            __typename?: "NotificationDeliveryPreferences";
        } & {
            mobile?: Maybe<{
                __typename?: "NotificationDeliveryPreferencesChannel";
            } & {
                schedule?: Maybe<{
                    __typename?: "NotificationDeliveryPreferencesSchedule";
                } & NotificationDeliveryPreferencesScheduleFragment>;
            }>;
        };
    };
};
export declare type UserSettings_NotificationDeliveryPreferences_Mobile_Schedule_FridayQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationDeliveryPreferences_Mobile_Schedule_FridayQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationDeliveryPreferences: {
            __typename?: "NotificationDeliveryPreferences";
        } & {
            mobile?: Maybe<{
                __typename?: "NotificationDeliveryPreferencesChannel";
            } & {
                schedule?: Maybe<{
                    __typename?: "NotificationDeliveryPreferencesSchedule";
                } & {
                    friday: {
                        __typename?: "NotificationDeliveryPreferencesDay";
                    } & NotificationDeliveryPreferencesDayFragment;
                }>;
            }>;
        };
    };
};
export declare type UserSettings_NotificationDeliveryPreferences_Mobile_Schedule_MondayQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationDeliveryPreferences_Mobile_Schedule_MondayQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationDeliveryPreferences: {
            __typename?: "NotificationDeliveryPreferences";
        } & {
            mobile?: Maybe<{
                __typename?: "NotificationDeliveryPreferencesChannel";
            } & {
                schedule?: Maybe<{
                    __typename?: "NotificationDeliveryPreferencesSchedule";
                } & {
                    monday: {
                        __typename?: "NotificationDeliveryPreferencesDay";
                    } & NotificationDeliveryPreferencesDayFragment;
                }>;
            }>;
        };
    };
};
export declare type UserSettings_NotificationDeliveryPreferences_Mobile_Schedule_SaturdayQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationDeliveryPreferences_Mobile_Schedule_SaturdayQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationDeliveryPreferences: {
            __typename?: "NotificationDeliveryPreferences";
        } & {
            mobile?: Maybe<{
                __typename?: "NotificationDeliveryPreferencesChannel";
            } & {
                schedule?: Maybe<{
                    __typename?: "NotificationDeliveryPreferencesSchedule";
                } & {
                    saturday: {
                        __typename?: "NotificationDeliveryPreferencesDay";
                    } & NotificationDeliveryPreferencesDayFragment;
                }>;
            }>;
        };
    };
};
export declare type UserSettings_NotificationDeliveryPreferences_Mobile_Schedule_SundayQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationDeliveryPreferences_Mobile_Schedule_SundayQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationDeliveryPreferences: {
            __typename?: "NotificationDeliveryPreferences";
        } & {
            mobile?: Maybe<{
                __typename?: "NotificationDeliveryPreferencesChannel";
            } & {
                schedule?: Maybe<{
                    __typename?: "NotificationDeliveryPreferencesSchedule";
                } & {
                    sunday: {
                        __typename?: "NotificationDeliveryPreferencesDay";
                    } & NotificationDeliveryPreferencesDayFragment;
                }>;
            }>;
        };
    };
};
export declare type UserSettings_NotificationDeliveryPreferences_Mobile_Schedule_ThursdayQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationDeliveryPreferences_Mobile_Schedule_ThursdayQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationDeliveryPreferences: {
            __typename?: "NotificationDeliveryPreferences";
        } & {
            mobile?: Maybe<{
                __typename?: "NotificationDeliveryPreferencesChannel";
            } & {
                schedule?: Maybe<{
                    __typename?: "NotificationDeliveryPreferencesSchedule";
                } & {
                    thursday: {
                        __typename?: "NotificationDeliveryPreferencesDay";
                    } & NotificationDeliveryPreferencesDayFragment;
                }>;
            }>;
        };
    };
};
export declare type UserSettings_NotificationDeliveryPreferences_Mobile_Schedule_TuesdayQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationDeliveryPreferences_Mobile_Schedule_TuesdayQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationDeliveryPreferences: {
            __typename?: "NotificationDeliveryPreferences";
        } & {
            mobile?: Maybe<{
                __typename?: "NotificationDeliveryPreferencesChannel";
            } & {
                schedule?: Maybe<{
                    __typename?: "NotificationDeliveryPreferencesSchedule";
                } & {
                    tuesday: {
                        __typename?: "NotificationDeliveryPreferencesDay";
                    } & NotificationDeliveryPreferencesDayFragment;
                }>;
            }>;
        };
    };
};
export declare type UserSettings_NotificationDeliveryPreferences_Mobile_Schedule_WednesdayQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type UserSettings_NotificationDeliveryPreferences_Mobile_Schedule_WednesdayQuery = {
    __typename?: "Query";
} & {
    userSettings: {
        __typename?: "UserSettings";
    } & {
        notificationDeliveryPreferences: {
            __typename?: "NotificationDeliveryPreferences";
        } & {
            mobile?: Maybe<{
                __typename?: "NotificationDeliveryPreferencesChannel";
            } & {
                schedule?: Maybe<{
                    __typename?: "NotificationDeliveryPreferencesSchedule";
                } & {
                    wednesday: {
                        __typename?: "NotificationDeliveryPreferencesDay";
                    } & NotificationDeliveryPreferencesDayFragment;
                }>;
            }>;
        };
    };
};
export declare type UsersQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<UserFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    includeDisabled?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type UsersQuery = {
    __typename?: "Query";
} & {
    users: {
        __typename?: "UserConnection";
    } & UserConnectionFragment;
};
export declare type VerifyGitHubEnterpriseServerInstallationQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type VerifyGitHubEnterpriseServerInstallationQuery = {
    __typename?: "Query";
} & {
    verifyGitHubEnterpriseServerInstallation: {
        __typename?: "GitHubEnterpriseServerInstallVerificationPayload";
    } & GitHubEnterpriseServerInstallVerificationPayloadFragment;
};
export declare type ViewerQueryVariables = Exact<{
    [key: string]: never;
}>;
export declare type ViewerQuery = {
    __typename?: "Query";
} & {
    viewer: {
        __typename?: "User";
    } & UserFragment;
};
export declare type Viewer_AssignedIssuesQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Viewer_AssignedIssuesQuery = {
    __typename?: "Query";
} & {
    viewer: {
        __typename?: "User";
    } & {
        assignedIssues: {
            __typename?: "IssueConnection";
        } & IssueConnectionFragment;
    };
};
export declare type Viewer_CreatedIssuesQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Viewer_CreatedIssuesQuery = {
    __typename?: "Query";
} & {
    viewer: {
        __typename?: "User";
    } & {
        createdIssues: {
            __typename?: "IssueConnection";
        } & IssueConnectionFragment;
    };
};
export declare type Viewer_DraftsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Viewer_DraftsQuery = {
    __typename?: "Query";
} & {
    viewer: {
        __typename?: "User";
    } & {
        drafts: {
            __typename?: "DraftConnection";
        } & DraftConnectionFragment;
    };
};
export declare type Viewer_TeamMembershipsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Viewer_TeamMembershipsQuery = {
    __typename?: "Query";
} & {
    viewer: {
        __typename?: "User";
    } & {
        teamMemberships: {
            __typename?: "TeamMembershipConnection";
        } & TeamMembershipConnectionFragment;
    };
};
export declare type Viewer_TeamsQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<TeamFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type Viewer_TeamsQuery = {
    __typename?: "Query";
} & {
    viewer: {
        __typename?: "User";
    } & {
        teams: {
            __typename?: "TeamConnection";
        } & TeamConnectionFragment;
    };
};
export declare type WebhookQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type WebhookQuery = {
    __typename?: "Query";
} & {
    webhook: {
        __typename?: "Webhook";
    } & WebhookFragment;
};
export declare type WebhooksQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type WebhooksQuery = {
    __typename?: "Query";
} & {
    webhooks: {
        __typename?: "WebhookConnection";
    } & WebhookConnectionFragment;
};
export declare type WorkflowStateQueryVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type WorkflowStateQuery = {
    __typename?: "Query";
} & {
    workflowState: {
        __typename?: "WorkflowState";
    } & WorkflowStateFragment;
};
export declare type WorkflowState_IssuesQueryVariables = Exact<{
    id: Scalars["String"];
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<IssueFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type WorkflowState_IssuesQuery = {
    __typename?: "Query";
} & {
    workflowState: {
        __typename?: "WorkflowState";
    } & {
        issues: {
            __typename?: "IssueConnection";
        } & IssueConnectionFragment;
    };
};
export declare type WorkflowStatesQueryVariables = Exact<{
    after?: Maybe<Scalars["String"]>;
    before?: Maybe<Scalars["String"]>;
    filter?: Maybe<WorkflowStateFilter>;
    first?: Maybe<Scalars["Int"]>;
    includeArchived?: Maybe<Scalars["Boolean"]>;
    last?: Maybe<Scalars["Int"]>;
    orderBy?: Maybe<PaginationOrderBy>;
}>;
export declare type WorkflowStatesQuery = {
    __typename?: "Query";
} & {
    workflowStates: {
        __typename?: "WorkflowStateConnection";
    } & WorkflowStateConnectionFragment;
};
export declare type AirbyteIntegrationConnectMutationVariables = Exact<{
    input: AirbyteConfigurationInput;
}>;
export declare type AirbyteIntegrationConnectMutation = {
    __typename?: "Mutation";
} & {
    airbyteIntegrationConnect: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type CreateAttachmentMutationVariables = Exact<{
    input: AttachmentCreateInput;
}>;
export declare type CreateAttachmentMutation = {
    __typename?: "Mutation";
} & {
    attachmentCreate: {
        __typename?: "AttachmentPayload";
    } & AttachmentPayloadFragment;
};
export declare type DeleteAttachmentMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteAttachmentMutation = {
    __typename?: "Mutation";
} & {
    attachmentDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type AttachmentLinkDiscordMutationVariables = Exact<{
    channelId: Scalars["String"];
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    messageId: Scalars["String"];
    title?: Maybe<Scalars["String"]>;
    url: Scalars["String"];
}>;
export declare type AttachmentLinkDiscordMutation = {
    __typename?: "Mutation";
} & {
    attachmentLinkDiscord: {
        __typename?: "AttachmentPayload";
    } & AttachmentPayloadFragment;
};
export declare type AttachmentLinkFrontMutationVariables = Exact<{
    conversationId: Scalars["String"];
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    title?: Maybe<Scalars["String"]>;
}>;
export declare type AttachmentLinkFrontMutation = {
    __typename?: "Mutation";
} & {
    attachmentLinkFront: {
        __typename?: "FrontAttachmentPayload";
    } & FrontAttachmentPayloadFragment;
};
export declare type AttachmentLinkGitHubIssueMutationVariables = Exact<{
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    title?: Maybe<Scalars["String"]>;
    url: Scalars["String"];
}>;
export declare type AttachmentLinkGitHubIssueMutation = {
    __typename?: "Mutation";
} & {
    attachmentLinkGitHubIssue: {
        __typename?: "AttachmentPayload";
    } & AttachmentPayloadFragment;
};
export declare type AttachmentLinkGitHubPrMutationVariables = Exact<{
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    linkKind?: Maybe<GitLinkKind>;
    title?: Maybe<Scalars["String"]>;
    url: Scalars["String"];
}>;
export declare type AttachmentLinkGitHubPrMutation = {
    __typename?: "Mutation";
} & {
    attachmentLinkGitHubPR: {
        __typename?: "AttachmentPayload";
    } & AttachmentPayloadFragment;
};
export declare type AttachmentLinkGitLabMrMutationVariables = Exact<{
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    number: Scalars["Float"];
    projectPathWithNamespace: Scalars["String"];
    title?: Maybe<Scalars["String"]>;
    url: Scalars["String"];
}>;
export declare type AttachmentLinkGitLabMrMutation = {
    __typename?: "Mutation";
} & {
    attachmentLinkGitLabMR: {
        __typename?: "AttachmentPayload";
    } & AttachmentPayloadFragment;
};
export declare type AttachmentLinkIntercomMutationVariables = Exact<{
    conversationId: Scalars["String"];
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    partId?: Maybe<Scalars["String"]>;
    title?: Maybe<Scalars["String"]>;
}>;
export declare type AttachmentLinkIntercomMutation = {
    __typename?: "Mutation";
} & {
    attachmentLinkIntercom: {
        __typename?: "AttachmentPayload";
    } & AttachmentPayloadFragment;
};
export declare type AttachmentLinkJiraIssueMutationVariables = Exact<{
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    jiraIssueId: Scalars["String"];
    title?: Maybe<Scalars["String"]>;
    url?: Maybe<Scalars["String"]>;
}>;
export declare type AttachmentLinkJiraIssueMutation = {
    __typename?: "Mutation";
} & {
    attachmentLinkJiraIssue: {
        __typename?: "AttachmentPayload";
    } & AttachmentPayloadFragment;
};
export declare type AttachmentLinkSlackMutationVariables = Exact<{
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    syncToCommentThread?: Maybe<Scalars["Boolean"]>;
    title?: Maybe<Scalars["String"]>;
    url: Scalars["String"];
}>;
export declare type AttachmentLinkSlackMutation = {
    __typename?: "Mutation";
} & {
    attachmentLinkSlack: {
        __typename?: "AttachmentPayload";
    } & AttachmentPayloadFragment;
};
export declare type AttachmentLinkUrlMutationVariables = Exact<{
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    title?: Maybe<Scalars["String"]>;
    url: Scalars["String"];
}>;
export declare type AttachmentLinkUrlMutation = {
    __typename?: "Mutation";
} & {
    attachmentLinkURL: {
        __typename?: "AttachmentPayload";
    } & AttachmentPayloadFragment;
};
export declare type AttachmentLinkZendeskMutationVariables = Exact<{
    createAsUser?: Maybe<Scalars["String"]>;
    displayIconUrl?: Maybe<Scalars["String"]>;
    id?: Maybe<Scalars["String"]>;
    issueId: Scalars["String"];
    ticketId: Scalars["String"];
    title?: Maybe<Scalars["String"]>;
    url?: Maybe<Scalars["String"]>;
}>;
export declare type AttachmentLinkZendeskMutation = {
    __typename?: "Mutation";
} & {
    attachmentLinkZendesk: {
        __typename?: "AttachmentPayload";
    } & AttachmentPayloadFragment;
};
export declare type AttachmentSyncToSlackMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type AttachmentSyncToSlackMutation = {
    __typename?: "Mutation";
} & {
    attachmentSyncToSlack: {
        __typename?: "AttachmentPayload";
    } & AttachmentPayloadFragment;
};
export declare type UpdateAttachmentMutationVariables = Exact<{
    id: Scalars["String"];
    input: AttachmentUpdateInput;
}>;
export declare type UpdateAttachmentMutation = {
    __typename?: "Mutation";
} & {
    attachmentUpdate: {
        __typename?: "AttachmentPayload";
    } & AttachmentPayloadFragment;
};
export declare type CreateCommentMutationVariables = Exact<{
    input: CommentCreateInput;
}>;
export declare type CreateCommentMutation = {
    __typename?: "Mutation";
} & {
    commentCreate: {
        __typename?: "CommentPayload";
    } & CommentPayloadFragment;
};
export declare type DeleteCommentMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteCommentMutation = {
    __typename?: "Mutation";
} & {
    commentDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type CommentResolveMutationVariables = Exact<{
    id: Scalars["String"];
    resolvingCommentId?: Maybe<Scalars["String"]>;
}>;
export declare type CommentResolveMutation = {
    __typename?: "Mutation";
} & {
    commentResolve: {
        __typename?: "CommentPayload";
    } & CommentPayloadFragment;
};
export declare type CommentUnresolveMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type CommentUnresolveMutation = {
    __typename?: "Mutation";
} & {
    commentUnresolve: {
        __typename?: "CommentPayload";
    } & CommentPayloadFragment;
};
export declare type UpdateCommentMutationVariables = Exact<{
    id: Scalars["String"];
    input: CommentUpdateInput;
}>;
export declare type UpdateCommentMutation = {
    __typename?: "Mutation";
} & {
    commentUpdate: {
        __typename?: "CommentPayload";
    } & CommentPayloadFragment;
};
export declare type CreateContactMutationVariables = Exact<{
    input: ContactCreateInput;
}>;
export declare type CreateContactMutation = {
    __typename?: "Mutation";
} & {
    contactCreate: {
        __typename?: "ContactPayload";
    } & ContactPayloadFragment;
};
export declare type CreateCsvExportReportMutationVariables = Exact<{
    includePrivateTeamIds?: Maybe<Array<Scalars["String"]> | Scalars["String"]>;
}>;
export declare type CreateCsvExportReportMutation = {
    __typename?: "Mutation";
} & {
    createCsvExportReport: {
        __typename?: "CreateCsvExportReportPayload";
    } & CreateCsvExportReportPayloadFragment;
};
export declare type CreateInitiativeUpdateReminderMutationVariables = Exact<{
    initiativeId: Scalars["String"];
    userId?: Maybe<Scalars["String"]>;
}>;
export declare type CreateInitiativeUpdateReminderMutation = {
    __typename?: "Mutation";
} & {
    createInitiativeUpdateReminder: {
        __typename?: "InitiativeUpdateReminderPayload";
    } & InitiativeUpdateReminderPayloadFragment;
};
export declare type CreateOrganizationFromOnboardingMutationVariables = Exact<{
    input: CreateOrganizationInput;
    survey?: Maybe<OnboardingCustomerSurvey>;
}>;
export declare type CreateOrganizationFromOnboardingMutation = {
    __typename?: "Mutation";
} & {
    createOrganizationFromOnboarding: {
        __typename?: "CreateOrJoinOrganizationResponse";
    } & CreateOrJoinOrganizationResponseFragment;
};
export declare type CreateProjectUpdateReminderMutationVariables = Exact<{
    projectId: Scalars["String"];
    userId?: Maybe<Scalars["String"]>;
}>;
export declare type CreateProjectUpdateReminderMutation = {
    __typename?: "Mutation";
} & {
    createProjectUpdateReminder: {
        __typename?: "ProjectUpdateReminderPayload";
    } & ProjectUpdateReminderPayloadFragment;
};
export declare type CreateCustomViewMutationVariables = Exact<{
    input: CustomViewCreateInput;
}>;
export declare type CreateCustomViewMutation = {
    __typename?: "Mutation";
} & {
    customViewCreate: {
        __typename?: "CustomViewPayload";
    } & CustomViewPayloadFragment;
};
export declare type DeleteCustomViewMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteCustomViewMutation = {
    __typename?: "Mutation";
} & {
    customViewDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type UpdateCustomViewMutationVariables = Exact<{
    id: Scalars["String"];
    input: CustomViewUpdateInput;
}>;
export declare type UpdateCustomViewMutation = {
    __typename?: "Mutation";
} & {
    customViewUpdate: {
        __typename?: "CustomViewPayload";
    } & CustomViewPayloadFragment;
};
export declare type CreateCustomerMutationVariables = Exact<{
    input: CustomerCreateInput;
}>;
export declare type CreateCustomerMutation = {
    __typename?: "Mutation";
} & {
    customerCreate: {
        __typename?: "CustomerPayload";
    } & CustomerPayloadFragment;
};
export declare type DeleteCustomerMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteCustomerMutation = {
    __typename?: "Mutation";
} & {
    customerDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type CustomerMergeMutationVariables = Exact<{
    sourceCustomerId: Scalars["String"];
    targetCustomerId: Scalars["String"];
}>;
export declare type CustomerMergeMutation = {
    __typename?: "Mutation";
} & {
    customerMerge: {
        __typename?: "CustomerPayload";
    } & CustomerPayloadFragment;
};
export declare type ArchiveCustomerNeedMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type ArchiveCustomerNeedMutation = {
    __typename?: "Mutation";
} & {
    customerNeedArchive: {
        __typename?: "CustomerNeedArchivePayload";
    } & CustomerNeedArchivePayloadFragment;
};
export declare type CreateCustomerNeedMutationVariables = Exact<{
    input: CustomerNeedCreateInput;
}>;
export declare type CreateCustomerNeedMutation = {
    __typename?: "Mutation";
} & {
    customerNeedCreate: {
        __typename?: "CustomerNeedPayload";
    } & CustomerNeedPayloadFragment;
};
export declare type CustomerNeedCreateFromAttachmentMutationVariables = Exact<{
    input: CustomerNeedCreateFromAttachmentInput;
}>;
export declare type CustomerNeedCreateFromAttachmentMutation = {
    __typename?: "Mutation";
} & {
    customerNeedCreateFromAttachment: {
        __typename?: "CustomerNeedPayload";
    } & CustomerNeedPayloadFragment;
};
export declare type DeleteCustomerNeedMutationVariables = Exact<{
    id: Scalars["String"];
    keepAttachment?: Maybe<Scalars["Boolean"]>;
}>;
export declare type DeleteCustomerNeedMutation = {
    __typename?: "Mutation";
} & {
    customerNeedDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type UnarchiveCustomerNeedMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type UnarchiveCustomerNeedMutation = {
    __typename?: "Mutation";
} & {
    customerNeedUnarchive: {
        __typename?: "CustomerNeedArchivePayload";
    } & CustomerNeedArchivePayloadFragment;
};
export declare type UpdateCustomerNeedMutationVariables = Exact<{
    id: Scalars["String"];
    input: CustomerNeedUpdateInput;
}>;
export declare type UpdateCustomerNeedMutation = {
    __typename?: "Mutation";
} & {
    customerNeedUpdate: {
        __typename?: "CustomerNeedPayload";
    } & CustomerNeedPayloadFragment;
};
export declare type CreateCustomerTierMutationVariables = Exact<{
    input: CustomerTierCreateInput;
}>;
export declare type CreateCustomerTierMutation = {
    __typename?: "Mutation";
} & {
    customerTierCreate: {
        __typename?: "CustomerTierPayload";
    } & CustomerTierPayloadFragment;
};
export declare type DeleteCustomerTierMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteCustomerTierMutation = {
    __typename?: "Mutation";
} & {
    customerTierDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type UpdateCustomerTierMutationVariables = Exact<{
    id: Scalars["String"];
    input: CustomerTierUpdateInput;
}>;
export declare type UpdateCustomerTierMutation = {
    __typename?: "Mutation";
} & {
    customerTierUpdate: {
        __typename?: "CustomerTierPayload";
    } & CustomerTierPayloadFragment;
};
export declare type UpdateCustomerMutationVariables = Exact<{
    id: Scalars["String"];
    input: CustomerUpdateInput;
}>;
export declare type UpdateCustomerMutation = {
    __typename?: "Mutation";
} & {
    customerUpdate: {
        __typename?: "CustomerPayload";
    } & CustomerPayloadFragment;
};
export declare type CustomerUpsertMutationVariables = Exact<{
    input: CustomerUpsertInput;
}>;
export declare type CustomerUpsertMutation = {
    __typename?: "Mutation";
} & {
    customerUpsert: {
        __typename?: "CustomerPayload";
    } & CustomerPayloadFragment;
};
export declare type ArchiveCycleMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type ArchiveCycleMutation = {
    __typename?: "Mutation";
} & {
    cycleArchive: {
        __typename?: "CycleArchivePayload";
    } & CycleArchivePayloadFragment;
};
export declare type CreateCycleMutationVariables = Exact<{
    input: CycleCreateInput;
}>;
export declare type CreateCycleMutation = {
    __typename?: "Mutation";
} & {
    cycleCreate: {
        __typename?: "CyclePayload";
    } & CyclePayloadFragment;
};
export declare type CycleShiftAllMutationVariables = Exact<{
    input: CycleShiftAllInput;
}>;
export declare type CycleShiftAllMutation = {
    __typename?: "Mutation";
} & {
    cycleShiftAll: {
        __typename?: "CyclePayload";
    } & CyclePayloadFragment;
};
export declare type CycleStartUpcomingCycleTodayMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type CycleStartUpcomingCycleTodayMutation = {
    __typename?: "Mutation";
} & {
    cycleStartUpcomingCycleToday: {
        __typename?: "CyclePayload";
    } & CyclePayloadFragment;
};
export declare type UpdateCycleMutationVariables = Exact<{
    id: Scalars["String"];
    input: CycleUpdateInput;
}>;
export declare type UpdateCycleMutation = {
    __typename?: "Mutation";
} & {
    cycleUpdate: {
        __typename?: "CyclePayload";
    } & CyclePayloadFragment;
};
export declare type CreateDocumentMutationVariables = Exact<{
    input: DocumentCreateInput;
}>;
export declare type CreateDocumentMutation = {
    __typename?: "Mutation";
} & {
    documentCreate: {
        __typename?: "DocumentPayload";
    } & DocumentPayloadFragment;
};
export declare type DeleteDocumentMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteDocumentMutation = {
    __typename?: "Mutation";
} & {
    documentDelete: {
        __typename?: "DocumentArchivePayload";
    } & DocumentArchivePayloadFragment;
};
export declare type UnarchiveDocumentMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type UnarchiveDocumentMutation = {
    __typename?: "Mutation";
} & {
    documentUnarchive: {
        __typename?: "DocumentArchivePayload";
    } & DocumentArchivePayloadFragment;
};
export declare type UpdateDocumentMutationVariables = Exact<{
    id: Scalars["String"];
    input: DocumentUpdateInput;
}>;
export declare type UpdateDocumentMutation = {
    __typename?: "Mutation";
} & {
    documentUpdate: {
        __typename?: "DocumentPayload";
    } & DocumentPayloadFragment;
};
export declare type CreateEmailIntakeAddressMutationVariables = Exact<{
    input: EmailIntakeAddressCreateInput;
}>;
export declare type CreateEmailIntakeAddressMutation = {
    __typename?: "Mutation";
} & {
    emailIntakeAddressCreate: {
        __typename?: "EmailIntakeAddressPayload";
    } & EmailIntakeAddressPayloadFragment;
};
export declare type DeleteEmailIntakeAddressMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteEmailIntakeAddressMutation = {
    __typename?: "Mutation";
} & {
    emailIntakeAddressDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type EmailIntakeAddressRotateMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type EmailIntakeAddressRotateMutation = {
    __typename?: "Mutation";
} & {
    emailIntakeAddressRotate: {
        __typename?: "EmailIntakeAddressPayload";
    } & EmailIntakeAddressPayloadFragment;
};
export declare type UpdateEmailIntakeAddressMutationVariables = Exact<{
    id: Scalars["String"];
    input: EmailIntakeAddressUpdateInput;
}>;
export declare type UpdateEmailIntakeAddressMutation = {
    __typename?: "Mutation";
} & {
    emailIntakeAddressUpdate: {
        __typename?: "EmailIntakeAddressPayload";
    } & EmailIntakeAddressPayloadFragment;
};
export declare type EmailTokenUserAccountAuthMutationVariables = Exact<{
    input: TokenUserAccountAuthInput;
}>;
export declare type EmailTokenUserAccountAuthMutation = {
    __typename?: "Mutation";
} & {
    emailTokenUserAccountAuth: {
        __typename?: "AuthResolverResponse";
    } & AuthResolverResponseFragment;
};
export declare type EmailUnsubscribeMutationVariables = Exact<{
    input: EmailUnsubscribeInput;
}>;
export declare type EmailUnsubscribeMutation = {
    __typename?: "Mutation";
} & {
    emailUnsubscribe: {
        __typename?: "EmailUnsubscribePayload";
    } & EmailUnsubscribePayloadFragment;
};
export declare type EmailUserAccountAuthChallengeMutationVariables = Exact<{
    input: EmailUserAccountAuthChallengeInput;
}>;
export declare type EmailUserAccountAuthChallengeMutation = {
    __typename?: "Mutation";
} & {
    emailUserAccountAuthChallenge: {
        __typename?: "EmailUserAccountAuthChallengeResponse";
    } & EmailUserAccountAuthChallengeResponseFragment;
};
export declare type CreateEmojiMutationVariables = Exact<{
    input: EmojiCreateInput;
}>;
export declare type CreateEmojiMutation = {
    __typename?: "Mutation";
} & {
    emojiCreate: {
        __typename?: "EmojiPayload";
    } & EmojiPayloadFragment;
};
export declare type DeleteEmojiMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteEmojiMutation = {
    __typename?: "Mutation";
} & {
    emojiDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type CreateEntityExternalLinkMutationVariables = Exact<{
    input: EntityExternalLinkCreateInput;
}>;
export declare type CreateEntityExternalLinkMutation = {
    __typename?: "Mutation";
} & {
    entityExternalLinkCreate: {
        __typename?: "EntityExternalLinkPayload";
    } & EntityExternalLinkPayloadFragment;
};
export declare type DeleteEntityExternalLinkMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteEntityExternalLinkMutation = {
    __typename?: "Mutation";
} & {
    entityExternalLinkDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type UpdateEntityExternalLinkMutationVariables = Exact<{
    id: Scalars["String"];
    input: EntityExternalLinkUpdateInput;
}>;
export declare type UpdateEntityExternalLinkMutation = {
    __typename?: "Mutation";
} & {
    entityExternalLinkUpdate: {
        __typename?: "EntityExternalLinkPayload";
    } & EntityExternalLinkPayloadFragment;
};
export declare type CreateFavoriteMutationVariables = Exact<{
    input: FavoriteCreateInput;
}>;
export declare type CreateFavoriteMutation = {
    __typename?: "Mutation";
} & {
    favoriteCreate: {
        __typename?: "FavoritePayload";
    } & FavoritePayloadFragment;
};
export declare type DeleteFavoriteMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteFavoriteMutation = {
    __typename?: "Mutation";
} & {
    favoriteDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type UpdateFavoriteMutationVariables = Exact<{
    id: Scalars["String"];
    input: FavoriteUpdateInput;
}>;
export declare type UpdateFavoriteMutation = {
    __typename?: "Mutation";
} & {
    favoriteUpdate: {
        __typename?: "FavoritePayload";
    } & FavoritePayloadFragment;
};
export declare type FileUploadMutationVariables = Exact<{
    contentType: Scalars["String"];
    filename: Scalars["String"];
    makePublic?: Maybe<Scalars["Boolean"]>;
    metaData?: Maybe<Scalars["JSON"]>;
    size: Scalars["Int"];
}>;
export declare type FileUploadMutation = {
    __typename?: "Mutation";
} & {
    fileUpload: {
        __typename?: "UploadPayload";
    } & UploadPayloadFragment;
};
export declare type CreateGitAutomationStateMutationVariables = Exact<{
    input: GitAutomationStateCreateInput;
}>;
export declare type CreateGitAutomationStateMutation = {
    __typename?: "Mutation";
} & {
    gitAutomationStateCreate: {
        __typename?: "GitAutomationStatePayload";
    } & GitAutomationStatePayloadFragment;
};
export declare type DeleteGitAutomationStateMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteGitAutomationStateMutation = {
    __typename?: "Mutation";
} & {
    gitAutomationStateDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type UpdateGitAutomationStateMutationVariables = Exact<{
    id: Scalars["String"];
    input: GitAutomationStateUpdateInput;
}>;
export declare type UpdateGitAutomationStateMutation = {
    __typename?: "Mutation";
} & {
    gitAutomationStateUpdate: {
        __typename?: "GitAutomationStatePayload";
    } & GitAutomationStatePayloadFragment;
};
export declare type CreateGitAutomationTargetBranchMutationVariables = Exact<{
    input: GitAutomationTargetBranchCreateInput;
}>;
export declare type CreateGitAutomationTargetBranchMutation = {
    __typename?: "Mutation";
} & {
    gitAutomationTargetBranchCreate: {
        __typename?: "GitAutomationTargetBranchPayload";
    } & GitAutomationTargetBranchPayloadFragment;
};
export declare type DeleteGitAutomationTargetBranchMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteGitAutomationTargetBranchMutation = {
    __typename?: "Mutation";
} & {
    gitAutomationTargetBranchDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type UpdateGitAutomationTargetBranchMutationVariables = Exact<{
    id: Scalars["String"];
    input: GitAutomationTargetBranchUpdateInput;
}>;
export declare type UpdateGitAutomationTargetBranchMutation = {
    __typename?: "Mutation";
} & {
    gitAutomationTargetBranchUpdate: {
        __typename?: "GitAutomationTargetBranchPayload";
    } & GitAutomationTargetBranchPayloadFragment;
};
export declare type GoogleUserAccountAuthMutationVariables = Exact<{
    input: GoogleUserAccountAuthInput;
}>;
export declare type GoogleUserAccountAuthMutation = {
    __typename?: "Mutation";
} & {
    googleUserAccountAuth: {
        __typename?: "AuthResolverResponse";
    } & AuthResolverResponseFragment;
};
export declare type ImageUploadFromUrlMutationVariables = Exact<{
    url: Scalars["String"];
}>;
export declare type ImageUploadFromUrlMutation = {
    __typename?: "Mutation";
} & {
    imageUploadFromUrl: {
        __typename?: "ImageUploadFromUrlPayload";
    } & ImageUploadFromUrlPayloadFragment;
};
export declare type ImportFileUploadMutationVariables = Exact<{
    contentType: Scalars["String"];
    filename: Scalars["String"];
    metaData?: Maybe<Scalars["JSON"]>;
    size: Scalars["Int"];
}>;
export declare type ImportFileUploadMutation = {
    __typename?: "Mutation";
} & {
    importFileUpload: {
        __typename?: "UploadPayload";
    } & UploadPayloadFragment;
};
export declare type ArchiveInitiativeMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type ArchiveInitiativeMutation = {
    __typename?: "Mutation";
} & {
    initiativeArchive: {
        __typename?: "InitiativeArchivePayload";
    } & InitiativeArchivePayloadFragment;
};
export declare type CreateInitiativeMutationVariables = Exact<{
    input: InitiativeCreateInput;
}>;
export declare type CreateInitiativeMutation = {
    __typename?: "Mutation";
} & {
    initiativeCreate: {
        __typename?: "InitiativePayload";
    } & InitiativePayloadFragment;
};
export declare type DeleteInitiativeMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteInitiativeMutation = {
    __typename?: "Mutation";
} & {
    initiativeDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type CreateInitiativeRelationMutationVariables = Exact<{
    input: InitiativeRelationCreateInput;
}>;
export declare type CreateInitiativeRelationMutation = {
    __typename?: "Mutation";
} & {
    initiativeRelationCreate: {
        __typename?: "InitiativeRelationPayload";
    } & InitiativeRelationPayloadFragment;
};
export declare type DeleteInitiativeRelationMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteInitiativeRelationMutation = {
    __typename?: "Mutation";
} & {
    initiativeRelationDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type UpdateInitiativeRelationMutationVariables = Exact<{
    id: Scalars["String"];
    input: InitiativeRelationUpdateInput;
}>;
export declare type UpdateInitiativeRelationMutation = {
    __typename?: "Mutation";
} & {
    initiativeRelationUpdate: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type CreateInitiativeToProjectMutationVariables = Exact<{
    input: InitiativeToProjectCreateInput;
}>;
export declare type CreateInitiativeToProjectMutation = {
    __typename?: "Mutation";
} & {
    initiativeToProjectCreate: {
        __typename?: "InitiativeToProjectPayload";
    } & InitiativeToProjectPayloadFragment;
};
export declare type DeleteInitiativeToProjectMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteInitiativeToProjectMutation = {
    __typename?: "Mutation";
} & {
    initiativeToProjectDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type UpdateInitiativeToProjectMutationVariables = Exact<{
    id: Scalars["String"];
    input: InitiativeToProjectUpdateInput;
}>;
export declare type UpdateInitiativeToProjectMutation = {
    __typename?: "Mutation";
} & {
    initiativeToProjectUpdate: {
        __typename?: "InitiativeToProjectPayload";
    } & InitiativeToProjectPayloadFragment;
};
export declare type UnarchiveInitiativeMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type UnarchiveInitiativeMutation = {
    __typename?: "Mutation";
} & {
    initiativeUnarchive: {
        __typename?: "InitiativeArchivePayload";
    } & InitiativeArchivePayloadFragment;
};
export declare type UpdateInitiativeMutationVariables = Exact<{
    id: Scalars["String"];
    input: InitiativeUpdateInput;
}>;
export declare type UpdateInitiativeMutation = {
    __typename?: "Mutation";
} & {
    initiativeUpdate: {
        __typename?: "InitiativePayload";
    } & InitiativePayloadFragment;
};
export declare type ArchiveInitiativeUpdateMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type ArchiveInitiativeUpdateMutation = {
    __typename?: "Mutation";
} & {
    initiativeUpdateArchive: {
        __typename?: "InitiativeUpdateArchivePayload";
    } & InitiativeUpdateArchivePayloadFragment;
};
export declare type CreateInitiativeUpdateMutationVariables = Exact<{
    input: InitiativeUpdateCreateInput;
}>;
export declare type CreateInitiativeUpdateMutation = {
    __typename?: "Mutation";
} & {
    initiativeUpdateCreate: {
        __typename?: "InitiativeUpdatePayload";
    } & InitiativeUpdatePayloadFragment;
};
export declare type UnarchiveInitiativeUpdateMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type UnarchiveInitiativeUpdateMutation = {
    __typename?: "Mutation";
} & {
    initiativeUpdateUnarchive: {
        __typename?: "InitiativeUpdateArchivePayload";
    } & InitiativeUpdateArchivePayloadFragment;
};
export declare type UpdateInitiativeUpdateMutationVariables = Exact<{
    id: Scalars["String"];
    input: InitiativeUpdateUpdateInput;
}>;
export declare type UpdateInitiativeUpdateMutation = {
    __typename?: "Mutation";
} & {
    initiativeUpdateUpdate: {
        __typename?: "InitiativeUpdatePayload";
    } & InitiativeUpdatePayloadFragment;
};
export declare type ArchiveIntegrationMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type ArchiveIntegrationMutation = {
    __typename?: "Mutation";
} & {
    integrationArchive: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type IntegrationAsksConnectChannelMutationVariables = Exact<{
    code: Scalars["String"];
    redirectUri: Scalars["String"];
}>;
export declare type IntegrationAsksConnectChannelMutation = {
    __typename?: "Mutation";
} & {
    integrationAsksConnectChannel: {
        __typename?: "AsksChannelConnectPayload";
    } & AsksChannelConnectPayloadFragment;
};
export declare type DeleteIntegrationMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteIntegrationMutation = {
    __typename?: "Mutation";
} & {
    integrationDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type IntegrationDiscordMutationVariables = Exact<{
    code: Scalars["String"];
    redirectUri: Scalars["String"];
}>;
export declare type IntegrationDiscordMutation = {
    __typename?: "Mutation";
} & {
    integrationDiscord: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type IntegrationFigmaMutationVariables = Exact<{
    code: Scalars["String"];
    redirectUri: Scalars["String"];
}>;
export declare type IntegrationFigmaMutation = {
    __typename?: "Mutation";
} & {
    integrationFigma: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type IntegrationFrontMutationVariables = Exact<{
    code: Scalars["String"];
    redirectUri: Scalars["String"];
}>;
export declare type IntegrationFrontMutation = {
    __typename?: "Mutation";
} & {
    integrationFront: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type IntegrationGitHubEnterpriseServerConnectMutationVariables = Exact<{
    githubUrl: Scalars["String"];
    organizationName?: Maybe<Scalars["String"]>;
}>;
export declare type IntegrationGitHubEnterpriseServerConnectMutation = {
    __typename?: "Mutation";
} & {
    integrationGitHubEnterpriseServerConnect: {
        __typename?: "GitHubEnterpriseServerPayload";
    } & GitHubEnterpriseServerPayloadFragment;
};
export declare type IntegrationGitHubPersonalMutationVariables = Exact<{
    code: Scalars["String"];
}>;
export declare type IntegrationGitHubPersonalMutation = {
    __typename?: "Mutation";
} & {
    integrationGitHubPersonal: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type CreateIntegrationGithubCommitMutationVariables = Exact<{
    [key: string]: never;
}>;
export declare type CreateIntegrationGithubCommitMutation = {
    __typename?: "Mutation";
} & {
    integrationGithubCommitCreate: {
        __typename?: "GitHubCommitIntegrationPayload";
    } & GitHubCommitIntegrationPayloadFragment;
};
export declare type IntegrationGithubConnectMutationVariables = Exact<{
    code: Scalars["String"];
    installationId: Scalars["String"];
}>;
export declare type IntegrationGithubConnectMutation = {
    __typename?: "Mutation";
} & {
    integrationGithubConnect: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type IntegrationGithubImportConnectMutationVariables = Exact<{
    code: Scalars["String"];
    installationId: Scalars["String"];
}>;
export declare type IntegrationGithubImportConnectMutation = {
    __typename?: "Mutation";
} & {
    integrationGithubImportConnect: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type IntegrationGithubImportRefreshMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type IntegrationGithubImportRefreshMutation = {
    __typename?: "Mutation";
} & {
    integrationGithubImportRefresh: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type IntegrationGitlabConnectMutationVariables = Exact<{
    accessToken: Scalars["String"];
    gitlabUrl: Scalars["String"];
}>;
export declare type IntegrationGitlabConnectMutation = {
    __typename?: "Mutation";
} & {
    integrationGitlabConnect: {
        __typename?: "GitLabIntegrationCreatePayload";
    } & GitLabIntegrationCreatePayloadFragment;
};
export declare type IntegrationGoogleSheetsMutationVariables = Exact<{
    code: Scalars["String"];
}>;
export declare type IntegrationGoogleSheetsMutation = {
    __typename?: "Mutation";
} & {
    integrationGoogleSheets: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type IntegrationIntercomMutationVariables = Exact<{
    code: Scalars["String"];
    domainUrl?: Maybe<Scalars["String"]>;
    redirectUri: Scalars["String"];
}>;
export declare type IntegrationIntercomMutation = {
    __typename?: "Mutation";
} & {
    integrationIntercom: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type DeleteIntegrationIntercomMutationVariables = Exact<{
    [key: string]: never;
}>;
export declare type DeleteIntegrationIntercomMutation = {
    __typename?: "Mutation";
} & {
    integrationIntercomDelete: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type UpdateIntegrationIntercomSettingsMutationVariables = Exact<{
    input: IntercomSettingsInput;
}>;
export declare type UpdateIntegrationIntercomSettingsMutation = {
    __typename?: "Mutation";
} & {
    integrationIntercomSettingsUpdate: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type IntegrationJiraPersonalMutationVariables = Exact<{
    accessToken?: Maybe<Scalars["String"]>;
    code?: Maybe<Scalars["String"]>;
}>;
export declare type IntegrationJiraPersonalMutation = {
    __typename?: "Mutation";
} & {
    integrationJiraPersonal: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type IntegrationLoomMutationVariables = Exact<{
    [key: string]: never;
}>;
export declare type IntegrationLoomMutation = {
    __typename?: "Mutation";
} & {
    integrationLoom: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type IntegrationRequestMutationVariables = Exact<{
    input: IntegrationRequestInput;
}>;
export declare type IntegrationRequestMutation = {
    __typename?: "Mutation";
} & {
    integrationRequest: {
        __typename?: "IntegrationRequestPayload";
    } & IntegrationRequestPayloadFragment;
};
export declare type IntegrationSentryConnectMutationVariables = Exact<{
    code: Scalars["String"];
    installationId: Scalars["String"];
    organizationSlug: Scalars["String"];
}>;
export declare type IntegrationSentryConnectMutation = {
    __typename?: "Mutation";
} & {
    integrationSentryConnect: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type IntegrationSlackMutationVariables = Exact<{
    code: Scalars["String"];
    redirectUri: Scalars["String"];
    shouldUseV2Auth?: Maybe<Scalars["Boolean"]>;
}>;
export declare type IntegrationSlackMutation = {
    __typename?: "Mutation";
} & {
    integrationSlack: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type IntegrationSlackAsksMutationVariables = Exact<{
    code: Scalars["String"];
    redirectUri: Scalars["String"];
}>;
export declare type IntegrationSlackAsksMutation = {
    __typename?: "Mutation";
} & {
    integrationSlackAsks: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type IntegrationSlackCustomViewNotificationsMutationVariables = Exact<{
    code: Scalars["String"];
    customViewId: Scalars["String"];
    redirectUri: Scalars["String"];
}>;
export declare type IntegrationSlackCustomViewNotificationsMutation = {
    __typename?: "Mutation";
} & {
    integrationSlackCustomViewNotifications: {
        __typename?: "SlackChannelConnectPayload";
    } & SlackChannelConnectPayloadFragment;
};
export declare type IntegrationSlackCustomerChannelLinkMutationVariables = Exact<{
    code: Scalars["String"];
    customerId: Scalars["String"];
    redirectUri: Scalars["String"];
}>;
export declare type IntegrationSlackCustomerChannelLinkMutation = {
    __typename?: "Mutation";
} & {
    integrationSlackCustomerChannelLink: {
        __typename?: "SuccessPayload";
    } & SuccessPayloadFragment;
};
export declare type IntegrationSlackImportEmojisMutationVariables = Exact<{
    code: Scalars["String"];
    redirectUri: Scalars["String"];
}>;
export declare type IntegrationSlackImportEmojisMutation = {
    __typename?: "Mutation";
} & {
    integrationSlackImportEmojis: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type IntegrationSlackOrgProjectUpdatesPostMutationVariables = Exact<{
    code: Scalars["String"];
    redirectUri: Scalars["String"];
}>;
export declare type IntegrationSlackOrgProjectUpdatesPostMutation = {
    __typename?: "Mutation";
} & {
    integrationSlackOrgProjectUpdatesPost: {
        __typename?: "SlackChannelConnectPayload";
    } & SlackChannelConnectPayloadFragment;
};
export declare type IntegrationSlackPersonalMutationVariables = Exact<{
    code: Scalars["String"];
    redirectUri: Scalars["String"];
}>;
export declare type IntegrationSlackPersonalMutation = {
    __typename?: "Mutation";
} & {
    integrationSlackPersonal: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type IntegrationSlackPostMutationVariables = Exact<{
    code: Scalars["String"];
    redirectUri: Scalars["String"];
    shouldUseV2Auth?: Maybe<Scalars["Boolean"]>;
    teamId: Scalars["String"];
}>;
export declare type IntegrationSlackPostMutation = {
    __typename?: "Mutation";
} & {
    integrationSlackPost: {
        __typename?: "SlackChannelConnectPayload";
    } & SlackChannelConnectPayloadFragment;
};
export declare type IntegrationSlackProjectPostMutationVariables = Exact<{
    code: Scalars["String"];
    projectId: Scalars["String"];
    redirectUri: Scalars["String"];
    service: Scalars["String"];
}>;
export declare type IntegrationSlackProjectPostMutation = {
    __typename?: "Mutation";
} & {
    integrationSlackProjectPost: {
        __typename?: "SlackChannelConnectPayload";
    } & SlackChannelConnectPayloadFragment;
};
export declare type CreateIntegrationTemplateMutationVariables = Exact<{
    input: IntegrationTemplateCreateInput;
}>;
export declare type CreateIntegrationTemplateMutation = {
    __typename?: "Mutation";
} & {
    integrationTemplateCreate: {
        __typename?: "IntegrationTemplatePayload";
    } & IntegrationTemplatePayloadFragment;
};
export declare type DeleteIntegrationTemplateMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteIntegrationTemplateMutation = {
    __typename?: "Mutation";
} & {
    integrationTemplateDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type IntegrationZendeskMutationVariables = Exact<{
    code: Scalars["String"];
    redirectUri: Scalars["String"];
    scope: Scalars["String"];
    subdomain: Scalars["String"];
}>;
export declare type IntegrationZendeskMutation = {
    __typename?: "Mutation";
} & {
    integrationZendesk: {
        __typename?: "IntegrationPayload";
    } & IntegrationPayloadFragment;
};
export declare type CreateIntegrationsSettingsMutationVariables = Exact<{
    input: IntegrationsSettingsCreateInput;
}>;
export declare type CreateIntegrationsSettingsMutation = {
    __typename?: "Mutation";
} & {
    integrationsSettingsCreate: {
        __typename?: "IntegrationsSettingsPayload";
    } & IntegrationsSettingsPayloadFragment;
};
export declare type UpdateIntegrationsSettingsMutationVariables = Exact<{
    id: Scalars["String"];
    input: IntegrationsSettingsUpdateInput;
}>;
export declare type UpdateIntegrationsSettingsMutation = {
    __typename?: "Mutation";
} & {
    integrationsSettingsUpdate: {
        __typename?: "IntegrationsSettingsPayload";
    } & IntegrationsSettingsPayloadFragment;
};
export declare type IssueAddLabelMutationVariables = Exact<{
    id: Scalars["String"];
    labelId: Scalars["String"];
}>;
export declare type IssueAddLabelMutation = {
    __typename?: "Mutation";
} & {
    issueAddLabel: {
        __typename?: "IssuePayload";
    } & IssuePayloadFragment;
};
export declare type ArchiveIssueMutationVariables = Exact<{
    id: Scalars["String"];
    trash?: Maybe<Scalars["Boolean"]>;
}>;
export declare type ArchiveIssueMutation = {
    __typename?: "Mutation";
} & {
    issueArchive: {
        __typename?: "IssueArchivePayload";
    } & IssueArchivePayloadFragment;
};
export declare type CreateIssueBatchMutationVariables = Exact<{
    input: IssueBatchCreateInput;
}>;
export declare type CreateIssueBatchMutation = {
    __typename?: "Mutation";
} & {
    issueBatchCreate: {
        __typename?: "IssueBatchPayload";
    } & IssueBatchPayloadFragment;
};
export declare type UpdateIssueBatchMutationVariables = Exact<{
    ids: Array<Scalars["UUID"]> | Scalars["UUID"];
    input: IssueUpdateInput;
}>;
export declare type UpdateIssueBatchMutation = {
    __typename?: "Mutation";
} & {
    issueBatchUpdate: {
        __typename?: "IssueBatchPayload";
    } & IssueBatchPayloadFragment;
};
export declare type CreateIssueMutationVariables = Exact<{
    input: IssueCreateInput;
}>;
export declare type CreateIssueMutation = {
    __typename?: "Mutation";
} & {
    issueCreate: {
        __typename?: "IssuePayload";
    } & IssuePayloadFragment;
};
export declare type DeleteIssueMutationVariables = Exact<{
    id: Scalars["String"];
    permanentlyDelete?: Maybe<Scalars["Boolean"]>;
}>;
export declare type DeleteIssueMutation = {
    __typename?: "Mutation";
} & {
    issueDelete: {
        __typename?: "IssueArchivePayload";
    } & IssueArchivePayloadFragment;
};
export declare type IssueImportCreateAsanaMutationVariables = Exact<{
    asanaTeamName: Scalars["String"];
    asanaToken: Scalars["String"];
    id?: Maybe<Scalars["String"]>;
    includeClosedIssues?: Maybe<Scalars["Boolean"]>;
    instantProcess?: Maybe<Scalars["Boolean"]>;
    teamId?: Maybe<Scalars["String"]>;
    teamName?: Maybe<Scalars["String"]>;
}>;
export declare type IssueImportCreateAsanaMutation = {
    __typename?: "Mutation";
} & {
    issueImportCreateAsana: {
        __typename?: "IssueImportPayload";
    } & IssueImportPayloadFragment;
};
export declare type IssueImportCreateCsvJiraMutationVariables = Exact<{
    csvUrl: Scalars["String"];
    jiraEmail?: Maybe<Scalars["String"]>;
    jiraHostname?: Maybe<Scalars["String"]>;
    jiraToken?: Maybe<Scalars["String"]>;
    teamId?: Maybe<Scalars["String"]>;
    teamName?: Maybe<Scalars["String"]>;
}>;
export declare type IssueImportCreateCsvJiraMutation = {
    __typename?: "Mutation";
} & {
    issueImportCreateCSVJira: {
        __typename?: "IssueImportPayload";
    } & IssueImportPayloadFragment;
};
export declare type IssueImportCreateClubhouseMutationVariables = Exact<{
    clubhouseGroupName: Scalars["String"];
    clubhouseToken: Scalars["String"];
    id?: Maybe<Scalars["String"]>;
    includeClosedIssues?: Maybe<Scalars["Boolean"]>;
    instantProcess?: Maybe<Scalars["Boolean"]>;
    teamId?: Maybe<Scalars["String"]>;
    teamName?: Maybe<Scalars["String"]>;
}>;
export declare type IssueImportCreateClubhouseMutation = {
    __typename?: "Mutation";
} & {
    issueImportCreateClubhouse: {
        __typename?: "IssueImportPayload";
    } & IssueImportPayloadFragment;
};
export declare type IssueImportCreateGithubMutationVariables = Exact<{
    githubLabels?: Maybe<Array<Scalars["String"]> | Scalars["String"]>;
    githubRepoIds?: Maybe<Array<Scalars["Int"]> | Scalars["Int"]>;
    includeClosedIssues?: Maybe<Scalars["Boolean"]>;
    instantProcess?: Maybe<Scalars["Boolean"]>;
    teamId?: Maybe<Scalars["String"]>;
    teamName?: Maybe<Scalars["String"]>;
}>;
export declare type IssueImportCreateGithubMutation = {
    __typename?: "Mutation";
} & {
    issueImportCreateGithub: {
        __typename?: "IssueImportPayload";
    } & IssueImportPayloadFragment;
};
export declare type IssueImportCreateJiraMutationVariables = Exact<{
    id?: Maybe<Scalars["String"]>;
    includeClosedIssues?: Maybe<Scalars["Boolean"]>;
    instantProcess?: Maybe<Scalars["Boolean"]>;
    jiraEmail: Scalars["String"];
    jiraHostname: Scalars["String"];
    jiraProject: Scalars["String"];
    jiraToken: Scalars["String"];
    jql?: Maybe<Scalars["String"]>;
    teamId?: Maybe<Scalars["String"]>;
    teamName?: Maybe<Scalars["String"]>;
}>;
export declare type IssueImportCreateJiraMutation = {
    __typename?: "Mutation";
} & {
    issueImportCreateJira: {
        __typename?: "IssueImportPayload";
    } & IssueImportPayloadFragment;
};
export declare type DeleteIssueImportMutationVariables = Exact<{
    issueImportId: Scalars["String"];
}>;
export declare type DeleteIssueImportMutation = {
    __typename?: "Mutation";
} & {
    issueImportDelete: {
        __typename?: "IssueImportDeletePayload";
    } & IssueImportDeletePayloadFragment;
};
export declare type IssueImportProcessMutationVariables = Exact<{
    issueImportId: Scalars["String"];
    mapping: Scalars["JSONObject"];
}>;
export declare type IssueImportProcessMutation = {
    __typename?: "Mutation";
} & {
    issueImportProcess: {
        __typename?: "IssueImportPayload";
    } & IssueImportPayloadFragment;
};
export declare type UpdateIssueImportMutationVariables = Exact<{
    id: Scalars["String"];
    input: IssueImportUpdateInput;
}>;
export declare type UpdateIssueImportMutation = {
    __typename?: "Mutation";
} & {
    issueImportUpdate: {
        __typename?: "IssueImportPayload";
    } & IssueImportPayloadFragment;
};
export declare type CreateIssueLabelMutationVariables = Exact<{
    input: IssueLabelCreateInput;
    replaceTeamLabels?: Maybe<Scalars["Boolean"]>;
}>;
export declare type CreateIssueLabelMutation = {
    __typename?: "Mutation";
} & {
    issueLabelCreate: {
        __typename?: "IssueLabelPayload";
    } & IssueLabelPayloadFragment;
};
export declare type DeleteIssueLabelMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteIssueLabelMutation = {
    __typename?: "Mutation";
} & {
    issueLabelDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type UpdateIssueLabelMutationVariables = Exact<{
    id: Scalars["String"];
    input: IssueLabelUpdateInput;
    replaceTeamLabels?: Maybe<Scalars["Boolean"]>;
}>;
export declare type UpdateIssueLabelMutation = {
    __typename?: "Mutation";
} & {
    issueLabelUpdate: {
        __typename?: "IssueLabelPayload";
    } & IssueLabelPayloadFragment;
};
export declare type CreateIssueRelationMutationVariables = Exact<{
    input: IssueRelationCreateInput;
    overrideCreatedAt?: Maybe<Scalars["DateTime"]>;
}>;
export declare type CreateIssueRelationMutation = {
    __typename?: "Mutation";
} & {
    issueRelationCreate: {
        __typename?: "IssueRelationPayload";
    } & IssueRelationPayloadFragment;
};
export declare type DeleteIssueRelationMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteIssueRelationMutation = {
    __typename?: "Mutation";
} & {
    issueRelationDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type UpdateIssueRelationMutationVariables = Exact<{
    id: Scalars["String"];
    input: IssueRelationUpdateInput;
}>;
export declare type UpdateIssueRelationMutation = {
    __typename?: "Mutation";
} & {
    issueRelationUpdate: {
        __typename?: "IssueRelationPayload";
    } & IssueRelationPayloadFragment;
};
export declare type IssueReminderMutationVariables = Exact<{
    id: Scalars["String"];
    reminderAt: Scalars["DateTime"];
}>;
export declare type IssueReminderMutation = {
    __typename?: "Mutation";
} & {
    issueReminder: {
        __typename?: "IssuePayload";
    } & IssuePayloadFragment;
};
export declare type IssueRemoveLabelMutationVariables = Exact<{
    id: Scalars["String"];
    labelId: Scalars["String"];
}>;
export declare type IssueRemoveLabelMutation = {
    __typename?: "Mutation";
} & {
    issueRemoveLabel: {
        __typename?: "IssuePayload";
    } & IssuePayloadFragment;
};
export declare type IssueSubscribeMutationVariables = Exact<{
    id: Scalars["String"];
    userId?: Maybe<Scalars["String"]>;
}>;
export declare type IssueSubscribeMutation = {
    __typename?: "Mutation";
} & {
    issueSubscribe: {
        __typename?: "IssuePayload";
    } & IssuePayloadFragment;
};
export declare type UnarchiveIssueMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type UnarchiveIssueMutation = {
    __typename?: "Mutation";
} & {
    issueUnarchive: {
        __typename?: "IssueArchivePayload";
    } & IssueArchivePayloadFragment;
};
export declare type IssueUnsubscribeMutationVariables = Exact<{
    id: Scalars["String"];
    userId?: Maybe<Scalars["String"]>;
}>;
export declare type IssueUnsubscribeMutation = {
    __typename?: "Mutation";
} & {
    issueUnsubscribe: {
        __typename?: "IssuePayload";
    } & IssuePayloadFragment;
};
export declare type UpdateIssueMutationVariables = Exact<{
    id: Scalars["String"];
    input: IssueUpdateInput;
}>;
export declare type UpdateIssueMutation = {
    __typename?: "Mutation";
} & {
    issueUpdate: {
        __typename?: "IssuePayload";
    } & IssuePayloadFragment;
};
export declare type JoinOrganizationFromOnboardingMutationVariables = Exact<{
    input: JoinOrganizationInput;
}>;
export declare type JoinOrganizationFromOnboardingMutation = {
    __typename?: "Mutation";
} & {
    joinOrganizationFromOnboarding: {
        __typename?: "CreateOrJoinOrganizationResponse";
    } & CreateOrJoinOrganizationResponseFragment;
};
export declare type LeaveOrganizationMutationVariables = Exact<{
    organizationId: Scalars["String"];
}>;
export declare type LeaveOrganizationMutation = {
    __typename?: "Mutation";
} & {
    leaveOrganization: {
        __typename?: "CreateOrJoinOrganizationResponse";
    } & CreateOrJoinOrganizationResponseFragment;
};
export declare type LogoutMutationVariables = Exact<{
    reason?: Maybe<Scalars["String"]>;
}>;
export declare type LogoutMutation = {
    __typename?: "Mutation";
} & {
    logout: {
        __typename?: "LogoutResponse";
    } & LogoutResponseFragment;
};
export declare type LogoutAllSessionsMutationVariables = Exact<{
    reason?: Maybe<Scalars["String"]>;
}>;
export declare type LogoutAllSessionsMutation = {
    __typename?: "Mutation";
} & {
    logoutAllSessions: {
        __typename?: "LogoutResponse";
    } & LogoutResponseFragment;
};
export declare type LogoutOtherSessionsMutationVariables = Exact<{
    reason?: Maybe<Scalars["String"]>;
}>;
export declare type LogoutOtherSessionsMutation = {
    __typename?: "Mutation";
} & {
    logoutOtherSessions: {
        __typename?: "LogoutResponse";
    } & LogoutResponseFragment;
};
export declare type LogoutSessionMutationVariables = Exact<{
    sessionId: Scalars["String"];
}>;
export declare type LogoutSessionMutation = {
    __typename?: "Mutation";
} & {
    logoutSession: {
        __typename?: "LogoutResponse";
    } & LogoutResponseFragment;
};
export declare type ArchiveNotificationMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type ArchiveNotificationMutation = {
    __typename?: "Mutation";
} & {
    notificationArchive: {
        __typename?: "NotificationArchivePayload";
    } & NotificationArchivePayloadFragment;
};
export declare type NotificationArchiveAllMutationVariables = Exact<{
    input: NotificationEntityInput;
}>;
export declare type NotificationArchiveAllMutation = {
    __typename?: "Mutation";
} & {
    notificationArchiveAll: {
        __typename?: "NotificationBatchActionPayload";
    } & NotificationBatchActionPayloadFragment;
};
export declare type UpdateNotificationCategoryChannelSubscriptionMutationVariables = Exact<{
    category: NotificationCategory;
    channel: NotificationChannel;
    subscribe: Scalars["Boolean"];
}>;
export declare type UpdateNotificationCategoryChannelSubscriptionMutation = {
    __typename?: "Mutation";
} & {
    notificationCategoryChannelSubscriptionUpdate: {
        __typename?: "UserSettingsPayload";
    } & UserSettingsPayloadFragment;
};
export declare type NotificationMarkReadAllMutationVariables = Exact<{
    input: NotificationEntityInput;
    readAt: Scalars["DateTime"];
}>;
export declare type NotificationMarkReadAllMutation = {
    __typename?: "Mutation";
} & {
    notificationMarkReadAll: {
        __typename?: "NotificationBatchActionPayload";
    } & NotificationBatchActionPayloadFragment;
};
export declare type NotificationMarkUnreadAllMutationVariables = Exact<{
    input: NotificationEntityInput;
}>;
export declare type NotificationMarkUnreadAllMutation = {
    __typename?: "Mutation";
} & {
    notificationMarkUnreadAll: {
        __typename?: "NotificationBatchActionPayload";
    } & NotificationBatchActionPayloadFragment;
};
export declare type NotificationSnoozeAllMutationVariables = Exact<{
    input: NotificationEntityInput;
    snoozedUntilAt: Scalars["DateTime"];
}>;
export declare type NotificationSnoozeAllMutation = {
    __typename?: "Mutation";
} & {
    notificationSnoozeAll: {
        __typename?: "NotificationBatchActionPayload";
    } & NotificationBatchActionPayloadFragment;
};
export declare type CreateNotificationSubscriptionMutationVariables = Exact<{
    input: NotificationSubscriptionCreateInput;
}>;
export declare type CreateNotificationSubscriptionMutation = {
    __typename?: "Mutation";
} & {
    notificationSubscriptionCreate: {
        __typename?: "NotificationSubscriptionPayload";
    } & NotificationSubscriptionPayloadFragment;
};
export declare type DeleteNotificationSubscriptionMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteNotificationSubscriptionMutation = {
    __typename?: "Mutation";
} & {
    notificationSubscriptionDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type UpdateNotificationSubscriptionMutationVariables = Exact<{
    id: Scalars["String"];
    input: NotificationSubscriptionUpdateInput;
}>;
export declare type UpdateNotificationSubscriptionMutation = {
    __typename?: "Mutation";
} & {
    notificationSubscriptionUpdate: {
        __typename?: "NotificationSubscriptionPayload";
    } & NotificationSubscriptionPayloadFragment;
};
export declare type UnarchiveNotificationMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type UnarchiveNotificationMutation = {
    __typename?: "Mutation";
} & {
    notificationUnarchive: {
        __typename?: "NotificationArchivePayload";
    } & NotificationArchivePayloadFragment;
};
export declare type NotificationUnsnoozeAllMutationVariables = Exact<{
    input: NotificationEntityInput;
    unsnoozedAt: Scalars["DateTime"];
}>;
export declare type NotificationUnsnoozeAllMutation = {
    __typename?: "Mutation";
} & {
    notificationUnsnoozeAll: {
        __typename?: "NotificationBatchActionPayload";
    } & NotificationBatchActionPayloadFragment;
};
export declare type UpdateNotificationMutationVariables = Exact<{
    id: Scalars["String"];
    input: NotificationUpdateInput;
}>;
export declare type UpdateNotificationMutation = {
    __typename?: "Mutation";
} & {
    notificationUpdate: {
        __typename?: "NotificationPayload";
    } & NotificationPayloadFragment;
};
export declare type DeleteOrganizationCancelMutationVariables = Exact<{
    [key: string]: never;
}>;
export declare type DeleteOrganizationCancelMutation = {
    __typename?: "Mutation";
} & {
    organizationCancelDelete: {
        __typename?: "OrganizationCancelDeletePayload";
    } & OrganizationCancelDeletePayloadFragment;
};
export declare type DeleteOrganizationMutationVariables = Exact<{
    input: DeleteOrganizationInput;
}>;
export declare type DeleteOrganizationMutation = {
    __typename?: "Mutation";
} & {
    organizationDelete: {
        __typename?: "OrganizationDeletePayload";
    } & OrganizationDeletePayloadFragment;
};
export declare type OrganizationDeleteChallengeMutationVariables = Exact<{
    [key: string]: never;
}>;
export declare type OrganizationDeleteChallengeMutation = {
    __typename?: "Mutation";
} & {
    organizationDeleteChallenge: {
        __typename?: "OrganizationDeletePayload";
    } & OrganizationDeletePayloadFragment;
};
export declare type DeleteOrganizationDomainMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteOrganizationDomainMutation = {
    __typename?: "Mutation";
} & {
    organizationDomainDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type CreateOrganizationInviteMutationVariables = Exact<{
    input: OrganizationInviteCreateInput;
}>;
export declare type CreateOrganizationInviteMutation = {
    __typename?: "Mutation";
} & {
    organizationInviteCreate: {
        __typename?: "OrganizationInvitePayload";
    } & OrganizationInvitePayloadFragment;
};
export declare type DeleteOrganizationInviteMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteOrganizationInviteMutation = {
    __typename?: "Mutation";
} & {
    organizationInviteDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type UpdateOrganizationInviteMutationVariables = Exact<{
    id: Scalars["String"];
    input: OrganizationInviteUpdateInput;
}>;
export declare type UpdateOrganizationInviteMutation = {
    __typename?: "Mutation";
} & {
    organizationInviteUpdate: {
        __typename?: "OrganizationInvitePayload";
    } & OrganizationInvitePayloadFragment;
};
export declare type OrganizationStartTrialMutationVariables = Exact<{
    [key: string]: never;
}>;
export declare type OrganizationStartTrialMutation = {
    __typename?: "Mutation";
} & {
    organizationStartTrial: {
        __typename?: "OrganizationStartTrialPayload";
    } & OrganizationStartTrialPayloadFragment;
};
export declare type OrganizationStartTrialForPlanMutationVariables = Exact<{
    input: OrganizationStartTrialInput;
}>;
export declare type OrganizationStartTrialForPlanMutation = {
    __typename?: "Mutation";
} & {
    organizationStartTrialForPlan: {
        __typename?: "OrganizationStartTrialPayload";
    } & OrganizationStartTrialPayloadFragment;
};
export declare type UpdateOrganizationMutationVariables = Exact<{
    input: OrganizationUpdateInput;
}>;
export declare type UpdateOrganizationMutation = {
    __typename?: "Mutation";
} & {
    organizationUpdate: {
        __typename?: "OrganizationPayload";
    } & OrganizationPayloadFragment;
};
export declare type ArchiveProjectMutationVariables = Exact<{
    id: Scalars["String"];
    trash?: Maybe<Scalars["Boolean"]>;
}>;
export declare type ArchiveProjectMutation = {
    __typename?: "Mutation";
} & {
    projectArchive: {
        __typename?: "ProjectArchivePayload";
    } & ProjectArchivePayloadFragment;
};
export declare type CreateProjectMutationVariables = Exact<{
    connectSlackChannel?: Maybe<Scalars["Boolean"]>;
    input: ProjectCreateInput;
}>;
export declare type CreateProjectMutation = {
    __typename?: "Mutation";
} & {
    projectCreate: {
        __typename?: "ProjectPayload";
    } & ProjectPayloadFragment;
};
export declare type DeleteProjectMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteProjectMutation = {
    __typename?: "Mutation";
} & {
    projectDelete: {
        __typename?: "ProjectArchivePayload";
    } & ProjectArchivePayloadFragment;
};
export declare type CreateProjectMilestoneMutationVariables = Exact<{
    input: ProjectMilestoneCreateInput;
}>;
export declare type CreateProjectMilestoneMutation = {
    __typename?: "Mutation";
} & {
    projectMilestoneCreate: {
        __typename?: "ProjectMilestonePayload";
    } & ProjectMilestonePayloadFragment;
};
export declare type DeleteProjectMilestoneMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteProjectMilestoneMutation = {
    __typename?: "Mutation";
} & {
    projectMilestoneDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type UpdateProjectMilestoneMutationVariables = Exact<{
    id: Scalars["String"];
    input: ProjectMilestoneUpdateInput;
}>;
export declare type UpdateProjectMilestoneMutation = {
    __typename?: "Mutation";
} & {
    projectMilestoneUpdate: {
        __typename?: "ProjectMilestonePayload";
    } & ProjectMilestonePayloadFragment;
};
export declare type CreateProjectRelationMutationVariables = Exact<{
    input: ProjectRelationCreateInput;
}>;
export declare type CreateProjectRelationMutation = {
    __typename?: "Mutation";
} & {
    projectRelationCreate: {
        __typename?: "ProjectRelationPayload";
    } & ProjectRelationPayloadFragment;
};
export declare type DeleteProjectRelationMutationVariables = Exact<{
    id: Scalars["String"];
}>;
export declare type DeleteProjectRelationMutation = {
    __typename?: "Mutation";
} & {
    projectRelationDelete: {
        __typename?: "DeletePayload";
    } & DeletePayloadFragment;
};
export declare type UpdateProjectRelationMutationVariables = Exact<{
    id: Scalars["String"];
    input: ProjectRelationUpdateInput;
}>;
export declare type UpdateProjectRelationMutation = {
    __typename?: "Mutation";
} & {
    projectRelationUpdate: {
        __typename?: "ProjectRelationPayload";
    } & ProjectRelationPayloadFragment;
};
export declare type ArchiveProjectStatusMutationVariables = Exact<