import Stream from 'stream';
import http from 'http';
import Url from 'url';
import https from 'https';
import zlib from 'zlib';
import crypto from 'crypto';

var AuthenticationSessionType;
(function (AuthenticationSessionType) {
    AuthenticationSessionType["Android"] = "android";
    AuthenticationSessionType["Desktop"] = "desktop";
    AuthenticationSessionType["Ios"] = "ios";
    AuthenticationSessionType["Web"] = "web";
})(AuthenticationSessionType || (AuthenticationSessionType = {}));
var ContextViewType;
(function (ContextViewType) {
    ContextViewType["ActiveCycle"] = "activeCycle";
    ContextViewType["ActiveIssues"] = "activeIssues";
    ContextViewType["Backlog"] = "backlog";
    ContextViewType["Triage"] = "triage";
    ContextViewType["UpcomingCycle"] = "upcomingCycle";
})(ContextViewType || (ContextViewType = {}));
/** A type of customer status. */
var CustomerStatusType;
(function (CustomerStatusType) {
    CustomerStatusType["Active"] = "active";
    CustomerStatusType["Inactive"] = "inactive";
})(CustomerStatusType || (CustomerStatusType = {}));
var CyclePeriod;
(function (CyclePeriod) {
    CyclePeriod["After"] = "after";
    CyclePeriod["Before"] = "before";
    CyclePeriod["During"] = "during";
})(CyclePeriod || (CyclePeriod = {}));
/** By which resolution is a date defined. */
var DateResolutionType;
(function (DateResolutionType) {
    DateResolutionType["HalfYear"] = "halfYear";
    DateResolutionType["Month"] = "month";
    DateResolutionType["Quarter"] = "quarter";
    DateResolutionType["Year"] = "year";
})(DateResolutionType || (DateResolutionType = {}));
/** The day of the week. */
var Day;
(function (Day) {
    Day["Friday"] = "Friday";
    Day["Monday"] = "Monday";
    Day["Saturday"] = "Saturday";
    Day["Sunday"] = "Sunday";
    Day["Thursday"] = "Thursday";
    Day["Tuesday"] = "Tuesday";
    Day["Wednesday"] = "Wednesday";
})(Day || (Day = {}));
var FacetPageSource;
(function (FacetPageSource) {
    FacetPageSource["Feed"] = "feed";
    FacetPageSource["Projects"] = "projects";
    FacetPageSource["TeamIssues"] = "teamIssues";
})(FacetPageSource || (FacetPageSource = {}));
/** Cadence to generate feed summary */
var FeedSummarySchedule;
(function (FeedSummarySchedule) {
    FeedSummarySchedule["Daily"] = "daily";
    FeedSummarySchedule["Never"] = "never";
    FeedSummarySchedule["Weekly"] = "weekly";
})(FeedSummarySchedule || (FeedSummarySchedule = {}));
/** By which resolution is frequency defined. */
var FrequencyResolutionType;
(function (FrequencyResolutionType) {
    FrequencyResolutionType["Daily"] = "daily";
    FrequencyResolutionType["Weekly"] = "weekly";
})(FrequencyResolutionType || (FrequencyResolutionType = {}));
/** The various states of a pull/merge request. */
var GitAutomationStates;
(function (GitAutomationStates) {
    GitAutomationStates["Draft"] = "draft";
    GitAutomationStates["Merge"] = "merge";
    GitAutomationStates["Mergeable"] = "mergeable";
    GitAutomationStates["Review"] = "review";
    GitAutomationStates["Start"] = "start";
})(GitAutomationStates || (GitAutomationStates = {}));
/** [Internal] The kind of link between an issue and a pull request. */
var GitLinkKind;
(function (GitLinkKind) {
    GitLinkKind["Closes"] = "closes";
    GitLinkKind["Contributes"] = "contributes";
    GitLinkKind["Links"] = "links";
})(GitLinkKind || (GitLinkKind = {}));
var GithubOrgType;
(function (GithubOrgType) {
    GithubOrgType["Organization"] = "organization";
    GithubOrgType["User"] = "user";
})(GithubOrgType || (GithubOrgType = {}));
var InitiativeStatus;
(function (InitiativeStatus) {
    InitiativeStatus["Active"] = "Active";
    InitiativeStatus["Completed"] = "Completed";
    InitiativeStatus["Planned"] = "Planned";
})(InitiativeStatus || (InitiativeStatus = {}));
/** Different tabs available inside an initiative. */
var InitiativeTab;
(function (InitiativeTab) {
    InitiativeTab["Overview"] = "overview";
    InitiativeTab["Projects"] = "projects";
})(InitiativeTab || (InitiativeTab = {}));
/** The health type when the update is created. */
var InitiativeUpdateHealthType;
(function (InitiativeUpdateHealthType) {
    InitiativeUpdateHealthType["AtRisk"] = "atRisk";
    InitiativeUpdateHealthType["OffTrack"] = "offTrack";
    InitiativeUpdateHealthType["OnTrack"] = "onTrack";
})(InitiativeUpdateHealthType || (InitiativeUpdateHealthType = {}));
/** Linear supported integration services. */
var IntegrationService;
(function (IntegrationService) {
    IntegrationService["Airbyte"] = "airbyte";
    IntegrationService["Discord"] = "discord";
    IntegrationService["Email"] = "email";
    IntegrationService["Figma"] = "figma";
    IntegrationService["FigmaPlugin"] = "figmaPlugin";
    IntegrationService["Front"] = "front";
    IntegrationService["Github"] = "github";
    IntegrationService["GithubCommit"] = "githubCommit";
    IntegrationService["GithubEnterpriseServer"] = "githubEnterpriseServer";
    IntegrationService["GithubImport"] = "githubImport";
    IntegrationService["GithubPersonal"] = "githubPersonal";
    IntegrationService["Gitlab"] = "gitlab";
    IntegrationService["GoogleCalendarPersonal"] = "googleCalendarPersonal";
    IntegrationService["GoogleSheets"] = "googleSheets";
    IntegrationService["Intercom"] = "intercom";
    IntegrationService["Jira"] = "jira";
    IntegrationService["JiraPersonal"] = "jiraPersonal";
    IntegrationService["LaunchDarkly"] = "launchDarkly";
    IntegrationService["LaunchDarklyPersonal"] = "launchDarklyPersonal";
    IntegrationService["Loom"] = "loom";
    IntegrationService["Notion"] = "notion";
    IntegrationService["Opsgenie"] = "opsgenie";
    IntegrationService["PagerDuty"] = "pagerDuty";
    IntegrationService["Salesforce"] = "salesforce";
    IntegrationService["Sentry"] = "sentry";
    IntegrationService["Slack"] = "slack";
    IntegrationService["SlackAsks"] = "slackAsks";
    IntegrationService["SlackCustomViewNotifications"] = "slackCustomViewNotifications";
    IntegrationService["SlackInitiativePost"] = "slackInitiativePost";
    IntegrationService["SlackOrgInitiativeUpdatesPost"] = "slackOrgInitiativeUpdatesPost";
    IntegrationService["SlackOrgProjectUpdatesPost"] = "slackOrgProjectUpdatesPost";
    IntegrationService["SlackPersonal"] = "slackPersonal";
    IntegrationService["SlackPost"] = "slackPost";
    IntegrationService["SlackProjectPost"] = "slackProjectPost";
    IntegrationService["SlackProjectUpdatesPost"] = "slackProjectUpdatesPost";
    IntegrationService["Zendesk"] = "zendesk";
})(IntegrationService || (IntegrationService = {}));
/** The type of the issue relation. */
var IssueRelationType;
(function (IssueRelationType) {
    IssueRelationType["Blocks"] = "blocks";
    IssueRelationType["Duplicate"] = "duplicate";
    IssueRelationType["Related"] = "related";
    IssueRelationType["Similar"] = "similar";
})(IssueRelationType || (IssueRelationType = {}));
/** The categories of notifications a user can subscribe to. */
var NotificationCategory;
(function (NotificationCategory) {
    NotificationCategory["AppsAndIntegrations"] = "appsAndIntegrations";
    NotificationCategory["Assignments"] = "assignments";
    NotificationCategory["CommentsAndReplies"] = "commentsAndReplies";
    NotificationCategory["Customers"] = "customers";
    NotificationCategory["DocumentChanges"] = "documentChanges";
    NotificationCategory["Mentions"] = "mentions";
    NotificationCategory["PostsAndUpdates"] = "postsAndUpdates";
    NotificationCategory["Reactions"] = "reactions";
    NotificationCategory["Reminders"] = "reminders";
    NotificationCategory["Reviews"] = "reviews";
    NotificationCategory["StatusChanges"] = "statusChanges";
    NotificationCategory["Subscriptions"] = "subscriptions";
    NotificationCategory["System"] = "system";
    NotificationCategory["Triage"] = "triage";
})(NotificationCategory || (NotificationCategory = {}));
/** The delivery channels a user can receive notifications in. */
var NotificationChannel;
(function (NotificationChannel) {
    NotificationChannel["Desktop"] = "desktop";
    NotificationChannel["Email"] = "email";
    NotificationChannel["Mobile"] = "mobile";
    NotificationChannel["Slack"] = "slack";
})(NotificationChannel || (NotificationChannel = {}));
/** The different requests statuses possible for an OAuth client approval request. */
var OAuthClientApprovalStatus;
(function (OAuthClientApprovalStatus) {
    OAuthClientApprovalStatus["Approved"] = "approved";
    OAuthClientApprovalStatus["Denied"] = "denied";
    OAuthClientApprovalStatus["Requested"] = "requested";
})(OAuthClientApprovalStatus || (OAuthClientApprovalStatus = {}));
/** What type of auth is the domain used for. */
var OrganizationDomainAuthType;
(function (OrganizationDomainAuthType) {
    OrganizationDomainAuthType["General"] = "general";
    OrganizationDomainAuthType["Saml"] = "saml";
})(OrganizationDomainAuthType || (OrganizationDomainAuthType = {}));
/** The different statuses possible for an organization invite. */
var OrganizationInviteStatus;
(function (OrganizationInviteStatus) {
    OrganizationInviteStatus["Accepted"] = "accepted";
    OrganizationInviteStatus["Expired"] = "expired";
    OrganizationInviteStatus["Pending"] = "pending";
})(OrganizationInviteStatus || (OrganizationInviteStatus = {}));
/** How to treat NULL values, whether they should appear first or last */
var PaginationNulls;
(function (PaginationNulls) {
    PaginationNulls["First"] = "first";
    PaginationNulls["Last"] = "last";
})(PaginationNulls || (PaginationNulls = {}));
/** By which field should the pagination order by */
var PaginationOrderBy;
(function (PaginationOrderBy) {
    PaginationOrderBy["CreatedAt"] = "createdAt";
    PaginationOrderBy["UpdatedAt"] = "updatedAt";
})(PaginationOrderBy || (PaginationOrderBy = {}));
/** Whether to sort in ascending or descending order */
var PaginationSortOrder;
(function (PaginationSortOrder) {
    PaginationSortOrder["Ascending"] = "Ascending";
    PaginationSortOrder["Descending"] = "Descending";
})(PaginationSortOrder || (PaginationSortOrder = {}));
/** Type of Post */
var PostType;
(function (PostType) {
    PostType["Summary"] = "summary";
    PostType["Update"] = "update";
})(PostType || (PostType = {}));
/** [Internal] The scope of product intelligence suggestion data for a team. */
var ProductIntelligenceScope;
(function (ProductIntelligenceScope) {
    ProductIntelligenceScope["None"] = "none";
    ProductIntelligenceScope["Team"] = "team";
    ProductIntelligenceScope["TeamHierarchy"] = "teamHierarchy";
    ProductIntelligenceScope["Workspace"] = "workspace";
})(ProductIntelligenceScope || (ProductIntelligenceScope = {}));
/** The status of a project milestone. */
var ProjectMilestoneStatus;
(function (ProjectMilestoneStatus) {
    ProjectMilestoneStatus["Done"] = "done";
    ProjectMilestoneStatus["Next"] = "next";
    ProjectMilestoneStatus["Overdue"] = "overdue";
    ProjectMilestoneStatus["Unstarted"] = "unstarted";
})(ProjectMilestoneStatus || (ProjectMilestoneStatus = {}));
/** A type of project status. */
var ProjectStatusType;
(function (ProjectStatusType) {
    ProjectStatusType["Backlog"] = "backlog";
    ProjectStatusType["Canceled"] = "canceled";
    ProjectStatusType["Completed"] = "completed";
    ProjectStatusType["Paused"] = "paused";
    ProjectStatusType["Planned"] = "planned";
    ProjectStatusType["Started"] = "started";
})(ProjectStatusType || (ProjectStatusType = {}));
/** Different tabs available inside a project. */
var ProjectTab;
(function (ProjectTab) {
    ProjectTab["Customers"] = "customers";
    ProjectTab["Documents"] = "documents";
    ProjectTab["Issues"] = "issues";
})(ProjectTab || (ProjectTab = {}));
/** The health type when the project update is created. */
var ProjectUpdateHealthType;
(function (ProjectUpdateHealthType) {
    ProjectUpdateHealthType["AtRisk"] = "atRisk";
    ProjectUpdateHealthType["OffTrack"] = "offTrack";
    ProjectUpdateHealthType["OnTrack"] = "onTrack";
})(ProjectUpdateHealthType || (ProjectUpdateHealthType = {}));
/** The frequency at which to send project update reminders. */
var ProjectUpdateReminderFrequency;
(function (ProjectUpdateReminderFrequency) {
    ProjectUpdateReminderFrequency["Month"] = "month";
    ProjectUpdateReminderFrequency["Never"] = "never";
    ProjectUpdateReminderFrequency["TwoWeeks"] = "twoWeeks";
    ProjectUpdateReminderFrequency["Week"] = "week";
})(ProjectUpdateReminderFrequency || (ProjectUpdateReminderFrequency = {}));
var PullRequestReviewTool;
(function (PullRequestReviewTool) {
    PullRequestReviewTool["Graphite"] = "graphite";
    PullRequestReviewTool["Source"] = "source";
})(PullRequestReviewTool || (PullRequestReviewTool = {}));
/** The status of a pull request. */
var PullRequestStatus;
(function (PullRequestStatus) {
    PullRequestStatus["Approved"] = "approved";
    PullRequestStatus["Closed"] = "closed";
    PullRequestStatus["Draft"] = "draft";
    PullRequestStatus["InReview"] = "inReview";
    PullRequestStatus["Merged"] = "merged";
    PullRequestStatus["Open"] = "open";
})(PullRequestStatus || (PullRequestStatus = {}));
/** The different push subscription types. */
var PushSubscriptionType;
(function (PushSubscriptionType) {
    PushSubscriptionType["Apple"] = "apple";
    PushSubscriptionType["AppleDevelopment"] = "appleDevelopment";
    PushSubscriptionType["Firebase"] = "firebase";
    PushSubscriptionType["Web"] = "web";
})(PushSubscriptionType || (PushSubscriptionType = {}));
/** Features release channel. */
var ReleaseChannel;
(function (ReleaseChannel) {
    ReleaseChannel["Beta"] = "beta";
    ReleaseChannel["Development"] = "development";
    ReleaseChannel["Internal"] = "internal";
    ReleaseChannel["PreRelease"] = "preRelease";
    ReleaseChannel["Public"] = "public";
})(ReleaseChannel || (ReleaseChannel = {}));
var SLADayCountType;
(function (SLADayCountType) {
    SLADayCountType["All"] = "all";
    SLADayCountType["OnlyBusinessDays"] = "onlyBusinessDays";
})(SLADayCountType || (SLADayCountType = {}));
/** [ALPHA] The type of the semantic search result. */
var SemanticSearchResultType;
(function (SemanticSearchResultType) {
    SemanticSearchResultType["Document"] = "document";
    SemanticSearchResultType["Initiative"] = "initiative";
    SemanticSearchResultType["Issue"] = "issue";
    SemanticSearchResultType["Project"] = "project";
})(SemanticSearchResultType || (SemanticSearchResultType = {}));
var SendStrategy;
(function (SendStrategy) {
    SendStrategy["Desktop"] = "desktop";
    SendStrategy["DesktopAndPush"] = "desktopAndPush";
    SendStrategy["DesktopThenPush"] = "desktopThenPush";
    SendStrategy["Push"] = "push";
})(SendStrategy || (SendStrategy = {}));
var SlaStatus;
(function (SlaStatus) {
    SlaStatus["Breached"] = "Breached";
    SlaStatus["Completed"] = "Completed";
    SlaStatus["Failed"] = "Failed";
    SlaStatus["HighRisk"] = "HighRisk";
    SlaStatus["LowRisk"] = "LowRisk";
    SlaStatus["MediumRisk"] = "MediumRisk";
})(SlaStatus || (SlaStatus = {}));
var SlackChannelType;
(function (SlackChannelType) {
    SlackChannelType["DirectMessage"] = "DirectMessage";
    SlackChannelType["MultiPersonDirectMessage"] = "MultiPersonDirectMessage";
    SlackChannelType["Private"] = "Private";
    SlackChannelType["Public"] = "Public";
})(SlackChannelType || (SlackChannelType = {}));
/** Which action should be taken after an issue is added to triage. */
var TriageResponsibilityAction;
(function (TriageResponsibilityAction) {
    TriageResponsibilityAction["Assign"] = "assign";
    TriageResponsibilityAction["Notify"] = "notify";
})(TriageResponsibilityAction || (TriageResponsibilityAction = {}));
var UserContextViewType;
(function (UserContextViewType) {
    UserContextViewType["Assigned"] = "assigned";
})(UserContextViewType || (UserContextViewType = {}));
/** The types of flags that the user can have. */
var UserFlagType;
(function (UserFlagType) {
    UserFlagType["All"] = "all";
    UserFlagType["AnalyticsWelcomeDismissed"] = "analyticsWelcomeDismissed";
    UserFlagType["CanPlaySnake"] = "canPlaySnake";
    UserFlagType["CanPlayTetris"] = "canPlayTetris";
    UserFlagType["CommandMenuClearShortcutTip"] = "commandMenuClearShortcutTip";
    UserFlagType["CompletedOnboarding"] = "completedOnboarding";
    UserFlagType["CycleWelcomeDismissed"] = "cycleWelcomeDismissed";
    UserFlagType["DesktopDownloadToastDismissed"] = "desktopDownloadToastDismissed";
    UserFlagType["DesktopInstalled"] = "desktopInstalled";
    UserFlagType["DesktopTabsOnboardingDismissed"] = "desktopTabsOnboardingDismissed";
    UserFlagType["DueDateShortcutMigration"] = "dueDateShortcutMigration";
    UserFlagType["EditorSlashCommandUsed"] = "editorSlashCommandUsed";
    UserFlagType["EmptyActiveIssuesDismissed"] = "emptyActiveIssuesDismissed";
    UserFlagType["EmptyBacklogDismissed"] = "emptyBacklogDismissed";
    UserFlagType["EmptyCustomViewsDismissed"] = "emptyCustomViewsDismissed";
    UserFlagType["EmptyMyIssuesDismissed"] = "emptyMyIssuesDismissed";
    UserFlagType["EmptyParagraphSlashCommandTip"] = "emptyParagraphSlashCommandTip";
    UserFlagType["FigmaPluginBannerDismissed"] = "figmaPluginBannerDismissed";
    UserFlagType["FigmaPromptDismissed"] = "figmaPromptDismissed";
    UserFlagType["HelpIslandFeatureInsightsDismissed"] = "helpIslandFeatureInsightsDismissed";
    UserFlagType["ImportBannerDismissed"] = "importBannerDismissed";
    UserFlagType["InitiativesBannerDismissed"] = "initiativesBannerDismissed";
    UserFlagType["InsightsHelpDismissed"] = "insightsHelpDismissed";
    UserFlagType["InsightsWelcomeDismissed"] = "insightsWelcomeDismissed";
    UserFlagType["IssueLabelSuggestionUsed"] = "issueLabelSuggestionUsed";
    UserFlagType["IssueMovePromptCompleted"] = "issueMovePromptCompleted";
    UserFlagType["JoinTeamIntroductionDismissed"] = "joinTeamIntroductionDismissed";
    UserFlagType["ListSelectionTip"] = "listSelectionTip";
    UserFlagType["MigrateThemePreference"] = "migrateThemePreference";
    UserFlagType["MilestoneOnboardingIsSeenAndDismissed"] = "milestoneOnboardingIsSeenAndDismissed";
    UserFlagType["ProjectBacklogWelcomeDismissed"] = "projectBacklogWelcomeDismissed";
    UserFlagType["ProjectBoardOnboardingIsSeenAndDismissed"] = "projectBoardOnboardingIsSeenAndDismissed";
    UserFlagType["ProjectUpdatesWelcomeDismissed"] = "projectUpdatesWelcomeDismissed";
    UserFlagType["ProjectWelcomeDismissed"] = "projectWelcomeDismissed";
    UserFlagType["PulseWelcomeDismissed"] = "pulseWelcomeDismissed";
    UserFlagType["RewindBannerDismissed"] = "rewindBannerDismissed";
    UserFlagType["SlackCommentReactionTipShown"] = "slackCommentReactionTipShown";
    UserFlagType["TeamsPageIntroductionDismissed"] = "teamsPageIntroductionDismissed";
    UserFlagType["ThreadedCommentsNudgeIsSeen"] = "threadedCommentsNudgeIsSeen";
    UserFlagType["TriageWelcomeDismissed"] = "triageWelcomeDismissed";
    UserFlagType["TryCyclesDismissed"] = "tryCyclesDismissed";
    UserFlagType["TryGithubDismissed"] = "tryGithubDismissed";
    UserFlagType["TryInvitePeopleDismissed"] = "tryInvitePeopleDismissed";
    UserFlagType["TryRoadmapsDismissed"] = "tryRoadmapsDismissed";
    UserFlagType["TryTriageDismissed"] = "tryTriageDismissed";
    UserFlagType["UpdatedSlackThreadSyncIntegration"] = "updatedSlackThreadSyncIntegration";
})(UserFlagType || (UserFlagType = {}));
/** Operations that can be applied to UserFlagType. */
var UserFlagUpdateOperation;
(function (UserFlagUpdateOperation) {
    UserFlagUpdateOperation["Clear"] = "clear";
    UserFlagUpdateOperation["Decr"] = "decr";
    UserFlagUpdateOperation["Incr"] = "incr";
    UserFlagUpdateOperation["Lock"] = "lock";
})(UserFlagUpdateOperation || (UserFlagUpdateOperation = {}));
/** The different permission roles available to users on an organization. */
var UserRoleType;
(function (UserRoleType) {
    UserRoleType["Admin"] = "admin";
    UserRoleType["App"] = "app";
    UserRoleType["Guest"] = "guest";
    UserRoleType["User"] = "user";
})(UserRoleType || (UserRoleType = {}));
/** The type of view preferences (either user or organization level preferences). */
var ViewPreferencesType;
(function (ViewPreferencesType) {
    ViewPreferencesType["Organization"] = "organization";
    ViewPreferencesType["User"] = "user";
})(ViewPreferencesType || (ViewPreferencesType = {}));
/** The client view this custom view is targeting. */
var ViewType;
(function (ViewType) {
    ViewType["ActiveIssues"] = "activeIssues";
    ViewType["AllIssues"] = "allIssues";
    ViewType["Archive"] = "archive";
    ViewType["Backlog"] = "backlog";
    ViewType["Board"] = "board";
    ViewType["CompletedCycle"] = "completedCycle";
    ViewType["CustomRoadmap"] = "customRoadmap";
    ViewType["CustomView"] = "customView";
    ViewType["CustomViews"] = "customViews";
    ViewType["Customer"] = "customer";
    ViewType["Customers"] = "customers";
    ViewType["Cycle"] = "cycle";
    ViewType["EmbeddedCustomerNeeds"] = "embeddedCustomerNeeds";
    ViewType["FeedAll"] = "feedAll";
    ViewType["FeedCreated"] = "feedCreated";
    ViewType["FeedFollowing"] = "feedFollowing";
    ViewType["FeedPopular"] = "feedPopular";
    ViewType["Inbox"] = "inbox";
    ViewType["Initiative"] = "initiative";
    ViewType["InitiativeOverview"] = "initiativeOverview";
    ViewType["InitiativeOverviewSubInitiatives"] = "initiativeOverviewSubInitiatives";
    ViewType["Initiatives"] = "initiatives";
    ViewType["InitiativesCompleted"] = "initiativesCompleted";
    ViewType["InitiativesPlanned"] = "initiativesPlanned";
    ViewType["IssueIdentifiers"] = "issueIdentifiers";
    ViewType["Label"] = "label";
    ViewType["MyIssues"] = "myIssues";
    ViewType["MyIssuesActivity"] = "myIssuesActivity";
    ViewType["MyIssuesCreatedByMe"] = "myIssuesCreatedByMe";
    ViewType["MyIssuesSubscribedTo"] = "myIssuesSubscribedTo";
    ViewType["MyReviews"] = "myReviews";
    ViewType["Project"] = "project";
    ViewType["ProjectCustomerNeeds"] = "projectCustomerNeeds";
    ViewType["ProjectDocuments"] = "projectDocuments";
    ViewType["ProjectLabel"] = "projectLabel";
    ViewType["Projects"] = "projects";
    ViewType["ProjectsAll"] = "projectsAll";
    ViewType["ProjectsBacklog"] = "projectsBacklog";
    ViewType["ProjectsClosed"] = "projectsClosed";
    ViewType["QuickView"] = "quickView";
    ViewType["Reviews"] = "reviews";
    ViewType["Roadmap"] = "roadmap";
    ViewType["RoadmapAll"] = "roadmapAll";
    ViewType["RoadmapBacklog"] = "roadmapBacklog";
    ViewType["RoadmapClosed"] = "roadmapClosed";
    ViewType["Roadmaps"] = "roadmaps";
    ViewType["Search"] = "search";
    ViewType["SplitSearch"] = "splitSearch";
    ViewType["SubIssues"] = "subIssues";
    ViewType["Teams"] = "teams";
    ViewType["Triage"] = "triage";
    ViewType["UserProfile"] = "userProfile";
    ViewType["UserProfileCreatedByUser"] = "userProfileCreatedByUser";
    ViewType["WorkspaceMembers"] = "workspaceMembers";
})(ViewType || (ViewType = {}));
const EntityFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Entity" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Entity" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const CustomViewNotificationSubscriptionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CustomViewNotificationSubscription" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CustomViewNotificationSubscription" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "cycle" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "label" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customView" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customer" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "notificationSubscriptionTypes" } },
                    { kind: "Field", name: { kind: "Name", value: "userContextViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "contextViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "subscriber" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "active" } },
                ],
            },
        },
    ],
};
const CustomerNotificationSubscriptionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CustomerNotificationSubscription" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CustomerNotificationSubscription" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customView" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "cycle" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "label" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customer" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "notificationSubscriptionTypes" } },
                    { kind: "Field", name: { kind: "Name", value: "userContextViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "contextViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "subscriber" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "active" } },
                ],
            },
        },
    ],
};
const CycleNotificationSubscriptionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CycleNotificationSubscription" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CycleNotificationSubscription" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customView" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "label" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customer" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "cycle" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "notificationSubscriptionTypes" } },
                    { kind: "Field", name: { kind: "Name", value: "userContextViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "contextViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "subscriber" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "active" } },
                ],
            },
        },
    ],
};
const FacetFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Facet" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Facet" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "sourceFeedUser" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "sourceInitiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "sourcePage" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "sourceProject" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "sourceTeam" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "sortOrder" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "targetCustomView" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const CustomerNeedArchivePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CustomerNeedArchivePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CustomerNeedArchivePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "entity" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const CycleArchivePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CycleArchivePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CycleArchivePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "entity" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const DeletePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "DeletePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "DeletePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "entityId" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const DocumentArchivePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "DocumentArchivePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "DocumentArchivePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "entity" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const InitiativeArchivePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "InitiativeArchivePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeArchivePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "entity" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const InitiativeUpdateArchivePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "InitiativeUpdateArchivePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeUpdateArchivePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "entity" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const IssueArchivePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueArchivePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueArchivePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "entity" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const ActorBotFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ActorBot" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ActorBot" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "avatarUrl" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "userDisplayName" } },
                    { kind: "Field", name: { kind: "Name", value: "subType" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const DocumentNotificationFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "DocumentNotification" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "DocumentNotification" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "reactionEmoji" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                    { kind: "Field", name: { kind: "Name", value: "commentId" } },
                    { kind: "Field", name: { kind: "Name", value: "documentId" } },
                    { kind: "Field", name: { kind: "Name", value: "parentCommentId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "botActor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ActorBot" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "externalUserActor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "emailedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "readAt" } },
                    { kind: "Field", name: { kind: "Name", value: "unsnoozedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "snoozedUntilAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "actor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const InitiativeNotificationFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "InitiativeNotification" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeNotification" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "reactionEmoji" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                    { kind: "Field", name: { kind: "Name", value: "commentId" } },
                    { kind: "Field", name: { kind: "Name", value: "initiativeId" } },
                    { kind: "Field", name: { kind: "Name", value: "initiativeUpdateId" } },
                    { kind: "Field", name: { kind: "Name", value: "parentCommentId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "botActor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ActorBot" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "externalUserActor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "emailedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "readAt" } },
                    { kind: "Field", name: { kind: "Name", value: "unsnoozedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "snoozedUntilAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "actor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const NotificationSubscriptionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "NotificationSubscription" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "NotificationSubscription" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customView" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "cycle" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "label" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customer" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "userContextViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "contextViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "subscriber" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "active" } },
                ],
            },
        },
    ],
};
const IssueNotificationFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueNotification" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueNotification" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "reactionEmoji" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                    { kind: "Field", name: { kind: "Name", value: "commentId" } },
                    { kind: "Field", name: { kind: "Name", value: "issueId" } },
                    { kind: "Field", name: { kind: "Name", value: "parentCommentId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "botActor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ActorBot" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "comment" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "externalUserActor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "parentComment" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "subscriptions" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationSubscription" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "emailedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "readAt" } },
                    { kind: "Field", name: { kind: "Name", value: "unsnoozedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "snoozedUntilAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "actor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const OauthClientApprovalFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "OauthClientApproval" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "OauthClientApproval" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "requesterId" } },
                    { kind: "Field", name: { kind: "Name", value: "responderId" } },
                    { kind: "Field", name: { kind: "Name", value: "requestReason" } },
                    { kind: "Field", name: { kind: "Name", value: "denyReason" } },
                    { kind: "Field", name: { kind: "Name", value: "scopes" } },
                    { kind: "Field", name: { kind: "Name", value: "status" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "oauthClientId" } },
                ],
            },
        },
    ],
};
const OauthClientApprovalNotificationFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "OauthClientApprovalNotification" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "OauthClientApprovalNotification" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                    { kind: "Field", name: { kind: "Name", value: "oauthClientApprovalId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "oauthClientApproval" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "OauthClientApproval" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "botActor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ActorBot" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "externalUserActor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "emailedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "readAt" } },
                    { kind: "Field", name: { kind: "Name", value: "unsnoozedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "snoozedUntilAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "actor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const ProjectNotificationFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectNotification" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectNotification" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "reactionEmoji" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                    { kind: "Field", name: { kind: "Name", value: "commentId" } },
                    { kind: "Field", name: { kind: "Name", value: "parentCommentId" } },
                    { kind: "Field", name: { kind: "Name", value: "projectId" } },
                    { kind: "Field", name: { kind: "Name", value: "projectMilestoneId" } },
                    { kind: "Field", name: { kind: "Name", value: "projectUpdateId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "botActor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ActorBot" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "comment" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "document" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "externalUserActor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiativeUpdate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "parentComment" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "projectUpdate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "emailedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "readAt" } },
                    { kind: "Field", name: { kind: "Name", value: "unsnoozedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "snoozedUntilAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "actor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const NotificationFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Notification" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Notification" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "botActor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ActorBot" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "externalUserActor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "emailedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "readAt" } },
                    { kind: "Field", name: { kind: "Name", value: "unsnoozedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "snoozedUntilAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "actor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "InlineFragment",
                        typeCondition: { kind: "NamedType", name: { kind: "Name", value: "DocumentNotification" } },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "DocumentNotification" } }],
                        },
                    },
                    {
                        kind: "InlineFragment",
                        typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeNotification" } },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "InitiativeNotification" } }],
                        },
                    },
                    {
                        kind: "InlineFragment",
                        typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueNotification" } },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueNotification" } }],
                        },
                    },
                    {
                        kind: "InlineFragment",
                        typeCondition: { kind: "NamedType", name: { kind: "Name", value: "OauthClientApprovalNotification" } },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                { kind: "FragmentSpread", name: { kind: "Name", value: "OauthClientApprovalNotification" } },
                            ],
                        },
                    },
                    {
                        kind: "InlineFragment",
                        typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectNotification" } },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ProjectNotification" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const NotificationArchivePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "NotificationArchivePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "NotificationArchivePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "entity" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Notification" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const ProjectArchivePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectArchivePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectArchivePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "entity" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const ProjectStatusArchivePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectStatusArchivePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectStatusArchivePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "entity" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const ProjectUpdateArchivePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectUpdateArchivePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectUpdateArchivePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "entity" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const RoadmapArchivePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "RoadmapArchivePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "RoadmapArchivePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "entity" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const TeamArchivePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "TeamArchivePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "TeamArchivePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "entity" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const WorkflowStateArchivePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "WorkflowStateArchivePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "WorkflowStateArchivePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "entity" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const ArchivePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ArchivePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ArchivePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                    {
                        kind: "InlineFragment",
                        typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CustomerNeedArchivePayload" } },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CustomerNeedArchivePayload" } }],
                        },
                    },
                    {
                        kind: "InlineFragment",
                        typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CycleArchivePayload" } },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CycleArchivePayload" } }],
                        },
                    },
                    {
                        kind: "InlineFragment",
                        typeCondition: { kind: "NamedType", name: { kind: "Name", value: "DeletePayload" } },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "DeletePayload" } }],
                        },
                    },
                    {
                        kind: "InlineFragment",
                        typeCondition: { kind: "NamedType", name: { kind: "Name", value: "DocumentArchivePayload" } },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "DocumentArchivePayload" } }],
                        },
                    },
                    {
                        kind: "InlineFragment",
                        typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeArchivePayload" } },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "InitiativeArchivePayload" } }],
                        },
                    },
                    {
                        kind: "InlineFragment",
                        typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeUpdateArchivePayload" } },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "InitiativeUpdateArchivePayload" } }],
                        },
                    },
                    {
                        kind: "InlineFragment",
                        typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueArchivePayload" } },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueArchivePayload" } }],
                        },
                    },
                    {
                        kind: "InlineFragment",
                        typeCondition: { kind: "NamedType", name: { kind: "Name", value: "NotificationArchivePayload" } },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationArchivePayload" } }],
                        },
                    },
                    {
                        kind: "InlineFragment",
                        typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectArchivePayload" } },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ProjectArchivePayload" } }],
                        },
                    },
                    {
                        kind: "InlineFragment",
                        typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectStatusArchivePayload" } },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ProjectStatusArchivePayload" } }],
                        },
                    },
                    {
                        kind: "InlineFragment",
                        typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectUpdateArchivePayload" } },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ProjectUpdateArchivePayload" } }],
                        },
                    },
                    {
                        kind: "InlineFragment",
                        typeCondition: { kind: "NamedType", name: { kind: "Name", value: "RoadmapArchivePayload" } },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "RoadmapArchivePayload" } }],
                        },
                    },
                    {
                        kind: "InlineFragment",
                        typeCondition: { kind: "NamedType", name: { kind: "Name", value: "TeamArchivePayload" } },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "TeamArchivePayload" } }],
                        },
                    },
                    {
                        kind: "InlineFragment",
                        typeCondition: { kind: "NamedType", name: { kind: "Name", value: "WorkflowStateArchivePayload" } },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "WorkflowStateArchivePayload" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const LabelNotificationSubscriptionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "LabelNotificationSubscription" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "LabelNotificationSubscription" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customView" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "cycle" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customer" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "label" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "notificationSubscriptionTypes" } },
                    { kind: "Field", name: { kind: "Name", value: "userContextViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "contextViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "subscriber" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "active" } },
                ],
            },
        },
    ],
};
const MeetingFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Meeting" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Meeting" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "trashed" } },
                    { kind: "Field", name: { kind: "Name", value: "recordingLink" } },
                    { kind: "Field", name: { kind: "Name", value: "color" } },
                    { kind: "Field", name: { kind: "Name", value: "icon" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "location" } },
                    { kind: "Field", name: { kind: "Name", value: "meetingLink" } },
                    { kind: "Field", name: { kind: "Name", value: "title" } },
                    { kind: "Field", name: { kind: "Name", value: "sortOrder" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "endsAt" } },
                    { kind: "Field", name: { kind: "Name", value: "startsAt" } },
                    { kind: "Field", name: { kind: "Name", value: "hiddenAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "updatedBy" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const ProjectNotificationSubscriptionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectNotificationSubscription" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectNotificationSubscription" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customView" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "cycle" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "label" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customer" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "notificationSubscriptionTypes" } },
                    { kind: "Field", name: { kind: "Name", value: "userContextViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "contextViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "subscriber" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "active" } },
                ],
            },
        },
    ],
};
const TeamNotificationSubscriptionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "TeamNotificationSubscription" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "TeamNotificationSubscription" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customView" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "cycle" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "label" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customer" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "notificationSubscriptionTypes" } },
                    { kind: "Field", name: { kind: "Name", value: "userContextViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "contextViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "subscriber" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "active" } },
                ],
            },
        },
    ],
};
const UserNotificationSubscriptionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "UserNotificationSubscription" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "UserNotificationSubscription" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customView" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "cycle" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "label" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customer" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "notificationSubscriptionTypes" } },
                    { kind: "Field", name: { kind: "Name", value: "userContextViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "contextViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "subscriber" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "active" } },
                ],
            },
        },
    ],
};
const InitiativeNotificationSubscriptionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "InitiativeNotificationSubscription" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeNotificationSubscription" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customView" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "cycle" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "label" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customer" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "notificationSubscriptionTypes" } },
                    { kind: "Field", name: { kind: "Name", value: "userContextViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "contextViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "subscriber" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "active" } },
                ],
            },
        },
    ],
};
const OrganizationIpRestrictionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "OrganizationIpRestriction" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "OrganizationIpRestriction" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "range" } },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                    { kind: "Field", name: { kind: "Name", value: "enabled" } },
                ],
            },
        },
    ],
};
const ProjectStatusFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectStatus" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectStatus" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "color" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "position" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "indefinite" } },
                ],
            },
        },
    ],
};
const PaidSubscriptionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "PaidSubscription" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "PaidSubscription" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "collectionMethod" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "cancelAt" } },
                    { kind: "Field", name: { kind: "Name", value: "canceledAt" } },
                    { kind: "Field", name: { kind: "Name", value: "nextBillingAt" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "seatsMaximum" } },
                    { kind: "Field", name: { kind: "Name", value: "seatsMinimum" } },
                    { kind: "Field", name: { kind: "Name", value: "seats" } },
                    { kind: "Field", name: { kind: "Name", value: "pendingChangeType" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const OrganizationFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Organization" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Organization" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "allowedAuthServices" } },
                    { kind: "Field", name: { kind: "Name", value: "customersConfiguration" } },
                    { kind: "Field", name: { kind: "Name", value: "defaultFeedSummarySchedule" } },
                    { kind: "Field", name: { kind: "Name", value: "gitBranchFormat" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "ipRestrictions" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "OrganizationIpRestriction" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "userCount" } },
                    { kind: "Field", name: { kind: "Name", value: "customerCount" } },
                    { kind: "Field", name: { kind: "Name", value: "createdIssueCount" } },
                    { kind: "Field", name: { kind: "Name", value: "previousUrlKeys" } },
                    { kind: "Field", name: { kind: "Name", value: "periodUploadVolume" } },
                    { kind: "Field", name: { kind: "Name", value: "initiativeUpdateRemindersDay" } },
                    { kind: "Field", name: { kind: "Name", value: "projectUpdateRemindersDay" } },
                    { kind: "Field", name: { kind: "Name", value: "releaseChannel" } },
                    { kind: "Field", name: { kind: "Name", value: "initiativeUpdateRemindersHour" } },
                    { kind: "Field", name: { kind: "Name", value: "projectUpdateRemindersHour" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "fiscalYearStartMonth" } },
                    { kind: "Field", name: { kind: "Name", value: "initiativeUpdateReminderFrequencyInWeeks" } },
                    { kind: "Field", name: { kind: "Name", value: "projectUpdateReminderFrequencyInWeeks" } },
                    { kind: "Field", name: { kind: "Name", value: "logoUrl" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "projectStatuses" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ProjectStatus" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "subscription" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PaidSubscription" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "urlKey" } },
                    { kind: "Field", name: { kind: "Name", value: "deletionRequestedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "trialEndsAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "samlEnabled" } },
                    { kind: "Field", name: { kind: "Name", value: "scimEnabled" } },
                    { kind: "Field", name: { kind: "Name", value: "allowMembersToInvite" } },
                    { kind: "Field", name: { kind: "Name", value: "restrictTeamCreationToAdmins" } },
                    { kind: "Field", name: { kind: "Name", value: "gitLinkbackMessagesEnabled" } },
                    { kind: "Field", name: { kind: "Name", value: "gitPublicLinkbackMessagesEnabled" } },
                    { kind: "Field", name: { kind: "Name", value: "feedEnabled" } },
                    { kind: "Field", name: { kind: "Name", value: "customersEnabled" } },
                    { kind: "Field", name: { kind: "Name", value: "roadmapEnabled" } },
                    { kind: "Field", name: { kind: "Name", value: "projectUpdatesReminderFrequency" } },
                    { kind: "Field", name: { kind: "Name", value: "slaDayCount" } },
                ],
            },
        },
    ],
};
const AuthenticationSessionResponseFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "AuthenticationSessionResponse" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "AuthenticationSessionResponse" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "client" } },
                    { kind: "Field", name: { kind: "Name", value: "countryCodes" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "location" } },
                    { kind: "Field", name: { kind: "Name", value: "ip" } },
                    { kind: "Field", name: { kind: "Name", value: "isCurrentSession" } },
                    { kind: "Field", name: { kind: "Name", value: "locationCity" } },
                    { kind: "Field", name: { kind: "Name", value: "locationCountryCode" } },
                    { kind: "Field", name: { kind: "Name", value: "locationCountry" } },
                    { kind: "Field", name: { kind: "Name", value: "locationRegionCode" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "operatingSystem" } },
                    { kind: "Field", name: { kind: "Name", value: "service" } },
                    { kind: "Field", name: { kind: "Name", value: "userAgent" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                    { kind: "Field", name: { kind: "Name", value: "browserType" } },
                    { kind: "Field", name: { kind: "Name", value: "lastActiveAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const OrganizationDomainFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "OrganizationDomain" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "OrganizationDomain" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "verificationEmail" } },
                    { kind: "Field", name: { kind: "Name", value: "verified" } },
                    { kind: "Field", name: { kind: "Name", value: "disableOrganizationCreation" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "authType" } },
                    { kind: "Field", name: { kind: "Name", value: "claimed" } },
                ],
            },
        },
    ],
};
const AuthorizingUserFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "AuthorizingUser" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "AuthorizingUser" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "displayName" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                ],
            },
        },
    ],
};
const WebhookFailureEventFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "WebhookFailureEvent" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "WebhookFailureEvent" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "responseOrError" } },
                    { kind: "Field", name: { kind: "Name", value: "httpStatus" } },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "executionId" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "webhook" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const UserAuthorizedApplicationFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "UserAuthorizedApplication" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "UserAuthorizedApplication" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "approvalErrorCode" } },
                    { kind: "Field", name: { kind: "Name", value: "imageUrl" } },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "developer" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "clientId" } },
                    { kind: "Field", name: { kind: "Name", value: "developerUrl" } },
                    { kind: "Field", name: { kind: "Name", value: "webhooksEnabled" } },
                    { kind: "Field", name: { kind: "Name", value: "createdByLinear" } },
                    { kind: "Field", name: { kind: "Name", value: "isAuthorized" } },
                ],
            },
        },
    ],
};
const ApplicationFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Application" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Application" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "imageUrl" } },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "developer" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "clientId" } },
                    { kind: "Field", name: { kind: "Name", value: "developerUrl" } },
                ],
            },
        },
    ],
};
const IntegrationsSettingsFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IntegrationsSettings" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IntegrationsSettings" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "contextViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "slackIssueNewComment" } },
                    { kind: "Field", name: { kind: "Name", value: "slackInitiativeUpdateCreated" } },
                    { kind: "Field", name: { kind: "Name", value: "slackIssueAddedToTriage" } },
                    { kind: "Field", name: { kind: "Name", value: "slackIssueCreated" } },
                    { kind: "Field", name: { kind: "Name", value: "slackProjectUpdateCreated" } },
                    { kind: "Field", name: { kind: "Name", value: "slackIssueSlaHighRisk" } },
                    { kind: "Field", name: { kind: "Name", value: "slackIssueSlaBreached" } },
                    { kind: "Field", name: { kind: "Name", value: "slackIssueAddedToView" } },
                    { kind: "Field", name: { kind: "Name", value: "slackIssueStatusChangedDone" } },
                    { kind: "Field", name: { kind: "Name", value: "slackIssueStatusChangedAll" } },
                    { kind: "Field", name: { kind: "Name", value: "slackProjectUpdateCreatedToTeam" } },
                    { kind: "Field", name: { kind: "Name", value: "slackProjectUpdateCreatedToWorkspace" } },
                ],
            },
        },
    ],
};
const InitiativePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "InitiativePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const InitiativeToProjectPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "InitiativeToProjectPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeToProjectPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiativeToProject" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const NotificationDeliveryPreferencesDayFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "NotificationDeliveryPreferencesDay" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "NotificationDeliveryPreferencesDay" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "end" } },
                    { kind: "Field", name: { kind: "Name", value: "start" } },
                ],
            },
        },
    ],
};
const NotificationDeliveryPreferencesScheduleFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "NotificationDeliveryPreferencesSchedule" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "NotificationDeliveryPreferencesSchedule" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "friday" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                { kind: "FragmentSpread", name: { kind: "Name", value: "NotificationDeliveryPreferencesDay" } },
                            ],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "monday" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                { kind: "FragmentSpread", name: { kind: "Name", value: "NotificationDeliveryPreferencesDay" } },
                            ],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "saturday" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                { kind: "FragmentSpread", name: { kind: "Name", value: "NotificationDeliveryPreferencesDay" } },
                            ],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "sunday" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                { kind: "FragmentSpread", name: { kind: "Name", value: "NotificationDeliveryPreferencesDay" } },
                            ],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "thursday" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                { kind: "FragmentSpread", name: { kind: "Name", value: "NotificationDeliveryPreferencesDay" } },
                            ],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "tuesday" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                { kind: "FragmentSpread", name: { kind: "Name", value: "NotificationDeliveryPreferencesDay" } },
                            ],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "wednesday" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                { kind: "FragmentSpread", name: { kind: "Name", value: "NotificationDeliveryPreferencesDay" } },
                            ],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "disabled" } },
                ],
            },
        },
    ],
};
const NotificationDeliveryPreferencesChannelFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "NotificationDeliveryPreferencesChannel" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "NotificationDeliveryPreferencesChannel" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "schedule" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                { kind: "FragmentSpread", name: { kind: "Name", value: "NotificationDeliveryPreferencesSchedule" } },
                            ],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "notificationsDisabled" } },
                ],
            },
        },
    ],
};
const NotificationDeliveryPreferencesFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "NotificationDeliveryPreferences" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "NotificationDeliveryPreferences" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "mobile" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                { kind: "FragmentSpread", name: { kind: "Name", value: "NotificationDeliveryPreferencesChannel" } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
};
const NotificationChannelPreferencesFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "NotificationChannelPreferences" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "NotificationChannelPreferences" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "slack" } },
                    { kind: "Field", name: { kind: "Name", value: "desktop" } },
                    { kind: "Field", name: { kind: "Name", value: "email" } },
                    { kind: "Field", name: { kind: "Name", value: "mobile" } },
                ],
            },
        },
    ],
};
const NotificationCategoryPreferencesFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "NotificationCategoryPreferences" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "NotificationCategoryPreferences" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customers" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationChannelPreferences" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "appsAndIntegrations" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationChannelPreferences" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "assignments" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationChannelPreferences" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "commentsAndReplies" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationChannelPreferences" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "documentChanges" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationChannelPreferences" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "mentions" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationChannelPreferences" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "postsAndUpdates" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationChannelPreferences" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "reactions" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationChannelPreferences" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "reminders" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationChannelPreferences" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "reviews" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationChannelPreferences" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "statusChanges" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationChannelPreferences" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "subscriptions" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationChannelPreferences" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "system" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationChannelPreferences" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "triage" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationChannelPreferences" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const UserSettingsFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "UserSettings" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "UserSettings" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "calendarHash" } },
                    { kind: "Field", name: { kind: "Name", value: "unsubscribedFrom" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "notificationDeliveryPreferences" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                { kind: "FragmentSpread", name: { kind: "Name", value: "NotificationDeliveryPreferences" } },
                            ],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "notificationCategoryPreferences" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                { kind: "FragmentSpread", name: { kind: "Name", value: "NotificationCategoryPreferences" } },
                            ],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "notificationChannelPreferences" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationChannelPreferences" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "subscribedToDPA" } },
                    { kind: "Field", name: { kind: "Name", value: "subscribedToChangelog" } },
                    { kind: "Field", name: { kind: "Name", value: "subscribedToInviteAccepted" } },
                    { kind: "Field", name: { kind: "Name", value: "subscribedToPrivacyLegalUpdates" } },
                    { kind: "Field", name: { kind: "Name", value: "autoAssignToSelf" } },
                    { kind: "Field", name: { kind: "Name", value: "showFullUserNames" } },
                ],
            },
        },
    ],
};
const IssueImportJqlCheckPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueImportJqlCheckPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueImportJqlCheckPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "error" } },
                    { kind: "Field", name: { kind: "Name", value: "count" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const IssueImportSyncCheckPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueImportSyncCheckPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueImportSyncCheckPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "error" } },
                    { kind: "Field", name: { kind: "Name", value: "canSync" } },
                ],
            },
        },
    ],
};
const ApiKeyFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ApiKey" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ApiKey" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "scope" } },
                    { kind: "Field", name: { kind: "Name", value: "label" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "requestedSyncGroups" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const PageInfoFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "PageInfo" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "PageInfo" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "startCursor" } },
                    { kind: "Field", name: { kind: "Name", value: "endCursor" } },
                    { kind: "Field", name: { kind: "Name", value: "hasPreviousPage" } },
                    { kind: "Field", name: { kind: "Name", value: "hasNextPage" } },
                ],
            },
        },
    ],
};
const ApiKeyConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ApiKeyConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ApiKeyConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ApiKey" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const ApiKeyPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ApiKeyPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ApiKeyPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "apiKey" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ApiKey" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const SlackAsksTeamSettingsFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "SlackAsksTeamSettings" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "SlackAsksTeamSettings" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "hasDefaultAsk" } },
                ],
            },
        },
    ],
};
const SlackChannelNameMappingFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "SlackChannelNameMapping" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "SlackChannelNameMapping" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "autoCreateTemplateId" } },
                    { kind: "Field", name: { kind: "Name", value: "autoCreateOnBotMention" } },
                    { kind: "Field", name: { kind: "Name", value: "postCancellationUpdates" } },
                    { kind: "Field", name: { kind: "Name", value: "postCompletionUpdates" } },
                    { kind: "Field", name: { kind: "Name", value: "postAcceptedFromTriageUpdates" } },
                    { kind: "Field", name: { kind: "Name", value: "botAdded" } },
                    { kind: "Field", name: { kind: "Name", value: "isPrivate" } },
                    { kind: "Field", name: { kind: "Name", value: "isShared" } },
                    { kind: "Field", name: { kind: "Name", value: "aiTitles" } },
                    { kind: "Field", name: { kind: "Name", value: "autoCreateOnMessage" } },
                    { kind: "Field", name: { kind: "Name", value: "autoCreateOnEmoji" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "teams" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "SlackAsksTeamSettings" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const AsksChannelConnectPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "AsksChannelConnectPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "AsksChannelConnectPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integration" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "mapping" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "SlackChannelNameMapping" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "addBot" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const AttachmentFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Attachment" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Attachment" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "sourceType" } },
                    { kind: "Field", name: { kind: "Name", value: "subtitle" } },
                    { kind: "Field", name: { kind: "Name", value: "title" } },
                    { kind: "Field", name: { kind: "Name", value: "metadata" } },
                    { kind: "Field", name: { kind: "Name", value: "groupBySource" } },
                    { kind: "Field", name: { kind: "Name", value: "source" } },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    { kind: "Field", name: { kind: "Name", value: "bodyData" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "externalUserCreator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const AttachmentConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "AttachmentConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "AttachmentConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Attachment" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const AttachmentPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "AttachmentPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "AttachmentPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "attachment" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const AttachmentSourcesPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "AttachmentSourcesPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "AttachmentSourcesPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "sources" } },
                ],
            },
        },
    ],
};
const AuditEntryFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "AuditEntry" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "AuditEntry" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "requestInformation" } },
                    { kind: "Field", name: { kind: "Name", value: "metadata" } },
                    { kind: "Field", name: { kind: "Name", value: "countryCode" } },
                    { kind: "Field", name: { kind: "Name", value: "ip" } },
                    { kind: "Field", name: { kind: "Name", value: "actorId" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "actor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                ],
            },
        },
    ],
};
const AuditEntryConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "AuditEntryConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "AuditEntryConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "AuditEntry" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const AuditEntryTypeFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "AuditEntryType" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "AuditEntryType" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                ],
            },
        },
    ],
};
const AuthOrganizationFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "AuthOrganization" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "AuthOrganization" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "allowedAuthServices" } },
                    { kind: "Field", name: { kind: "Name", value: "previousUrlKeys" } },
                    { kind: "Field", name: { kind: "Name", value: "serviceId" } },
                    { kind: "Field", name: { kind: "Name", value: "releaseChannel" } },
                    { kind: "Field", name: { kind: "Name", value: "logoUrl" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "urlKey" } },
                    { kind: "Field", name: { kind: "Name", value: "region" } },
                    { kind: "Field", name: { kind: "Name", value: "deletionRequestedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "samlEnabled" } },
                    { kind: "Field", name: { kind: "Name", value: "scimEnabled" } },
                    { kind: "Field", name: { kind: "Name", value: "enabled" } },
                    { kind: "Field", name: { kind: "Name", value: "userCount" } },
                ],
            },
        },
    ],
};
const AuthUserFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "AuthUser" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "AuthUser" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "avatarUrl" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "organization" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "AuthOrganization" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "displayName" } },
                    { kind: "Field", name: { kind: "Name", value: "email" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "userAccountId" } },
                    { kind: "Field", name: { kind: "Name", value: "active" } },
                    { kind: "Field", name: { kind: "Name", value: "role" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const AuthResolverResponseFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "AuthResolverResponse" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "AuthResolverResponse" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "token" } },
                    { kind: "Field", name: { kind: "Name", value: "email" } },
                    { kind: "Field", name: { kind: "Name", value: "lastUsedOrganizationId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "users" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "AuthUser" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "lockedUsers" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "AuthUser" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "lockedOrganizations" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "AuthOrganization" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "availableOrganizations" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "AuthOrganization" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "allowDomainAccess" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const ReactionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Reaction" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Reaction" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "emoji" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "comment" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "externalUser" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiativeUpdate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "projectUpdate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const DocumentContentFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "DocumentContent" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "DocumentContent" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "content" } },
                    { kind: "Field", name: { kind: "Name", value: "contentState" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "document" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "projectMilestone" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "restoredAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const SyncedExternalThreadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "SyncedExternalThread" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "SyncedExternalThread" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "displayName" } },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    { kind: "Field", name: { kind: "Name", value: "subType" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                    { kind: "Field", name: { kind: "Name", value: "isPersonalIntegrationRequired" } },
                    { kind: "Field", name: { kind: "Name", value: "isPersonalIntegrationConnected" } },
                    { kind: "Field", name: { kind: "Name", value: "isConnected" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const CommentFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Comment" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Comment" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    { kind: "Field", name: { kind: "Name", value: "reactionData" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "reactions" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Reaction" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "botActor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ActorBot" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "body" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "resolvingComment" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "documentContent" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "DocumentContent" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "externalThread" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "SyncedExternalThread" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "externalUser" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiativeUpdate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "parent" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "projectUpdate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "quotedText" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "resolvedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "editedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "resolvingUser" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const CommentConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CommentConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CommentConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Comment" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const CommentPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CommentPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CommentPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "comment" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const ContactPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ContactPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ContactPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const CreateCsvExportReportPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CreateCsvExportReportPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CreateCsvExportReportPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const CreateOrJoinOrganizationResponseFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CreateOrJoinOrganizationResponse" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CreateOrJoinOrganizationResponse" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "organization" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "AuthOrganization" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "AuthUser" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const ViewPreferencesValuesFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ViewPreferencesValues" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ViewPreferencesValues" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "issueGrouping" } },
                    { kind: "Field", name: { kind: "Name", value: "viewOrdering" } },
                    { kind: "Field", name: { kind: "Name", value: "showCompletedIssues" } },
                ],
            },
        },
    ],
};
const ViewPreferencesFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ViewPreferences" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ViewPreferences" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "preferences" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ViewPreferencesValues" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "viewType" } },
                ],
            },
        },
    ],
};
const CustomViewFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CustomView" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CustomView" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "viewPreferencesValues" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ViewPreferencesValues" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "color" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "userViewPreferences" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ViewPreferences" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "slugId" } },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "feedItemFilterData" } },
                    { kind: "Field", name: { kind: "Name", value: "filterData" } },
                    { kind: "Field", name: { kind: "Name", value: "projectFilterData" } },
                    { kind: "Field", name: { kind: "Name", value: "filters" } },
                    { kind: "Field", name: { kind: "Name", value: "icon" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "modelName" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "organizationViewPreferences" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ViewPreferences" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "updatedBy" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "owner" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "shared" } },
                ],
            },
        },
    ],
};
const CustomViewConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CustomViewConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CustomViewConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CustomView" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const CustomViewHasSubscribersPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CustomViewHasSubscribersPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CustomViewHasSubscribersPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "hasSubscribers" } },
                ],
            },
        },
    ],
};
const CustomViewPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CustomViewPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CustomViewPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customView" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const CustomViewSuggestionPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CustomViewSuggestionPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CustomViewSuggestionPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "icon" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                ],
            },
        },
    ],
};
const CustomerFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Customer" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Customer" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "slackChannelId" } },
                    { kind: "Field", name: { kind: "Name", value: "mainSourceId" } },
                    { kind: "Field", name: { kind: "Name", value: "revenue" } },
                    { kind: "Field", name: { kind: "Name", value: "approximateNeedCount" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "status" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "logoUrl" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "slugId" } },
                    { kind: "Field", name: { kind: "Name", value: "domains" } },
                    { kind: "Field", name: { kind: "Name", value: "externalIds" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integration" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "size" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "tier" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "owner" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const CustomerConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CustomerConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CustomerConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Customer" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const CustomerNeedFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CustomerNeed" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CustomerNeed" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "attachment" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "comment" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customer" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "body" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "priority" } },
                ],
            },
        },
    ],
};
const CustomerNeedConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CustomerNeedConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CustomerNeedConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CustomerNeed" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const CustomerNeedPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CustomerNeedPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CustomerNeedPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "need" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const CustomerPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CustomerPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CustomerPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customer" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const CustomerStatusFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CustomerStatus" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CustomerStatus" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "color" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "position" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const CustomerStatusConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CustomerStatusConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CustomerStatusConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CustomerStatus" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const CustomerTierFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CustomerTier" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CustomerTier" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "color" } },
                    { kind: "Field", name: { kind: "Name", value: "displayName" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "position" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const CustomerTierConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CustomerTierConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CustomerTierConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CustomerTier" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const CustomerTierPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CustomerTierPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CustomerTierPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "tier" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const CycleFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Cycle" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Cycle" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "completedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "inheritedFrom" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "endsAt" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "completedScopeHistory" } },
                    { kind: "Field", name: { kind: "Name", value: "completedIssueCountHistory" } },
                    { kind: "Field", name: { kind: "Name", value: "inProgressScopeHistory" } },
                    { kind: "Field", name: { kind: "Name", value: "number" } },
                    { kind: "Field", name: { kind: "Name", value: "progress" } },
                    { kind: "Field", name: { kind: "Name", value: "startsAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "autoArchivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "scopeHistory" } },
                    { kind: "Field", name: { kind: "Name", value: "issueCountHistory" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const CycleConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CycleConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CycleConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Cycle" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const CyclePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "CyclePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "CyclePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "cycle" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const DocumentFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Document" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Document" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "trashed" } },
                    { kind: "Field", name: { kind: "Name", value: "documentContentId" } },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    { kind: "Field", name: { kind: "Name", value: "color" } },
                    { kind: "Field", name: { kind: "Name", value: "title" } },
                    { kind: "Field", name: { kind: "Name", value: "slugId" } },
                    { kind: "Field", name: { kind: "Name", value: "content" } },
                    { kind: "Field", name: { kind: "Name", value: "icon" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "lastAppliedTemplate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "sortOrder" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "hiddenAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "updatedBy" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const DocumentConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "DocumentConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "DocumentConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Document" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const DocumentContentHistoryTypeFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "DocumentContentHistoryType" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "DocumentContentHistoryType" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "actorIds" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "contentDataSnapshotAt" } },
                ],
            },
        },
    ],
};
const DocumentContentHistoryPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "DocumentContentHistoryPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "DocumentContentHistoryPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "history" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "DocumentContentHistoryType" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const DocumentPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "DocumentPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "DocumentPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "document" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const ArchiveResponseFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ArchiveResponse" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ArchiveResponse" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "archive" } },
                    { kind: "Field", name: { kind: "Name", value: "totalCount" } },
                    { kind: "Field", name: { kind: "Name", value: "databaseVersion" } },
                    { kind: "Field", name: { kind: "Name", value: "includesDependencies" } },
                ],
            },
        },
    ],
};
const DocumentSearchResultFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "DocumentSearchResult" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "DocumentSearchResult" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "trashed" } },
                    { kind: "Field", name: { kind: "Name", value: "metadata" } },
                    { kind: "Field", name: { kind: "Name", value: "documentContentId" } },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    { kind: "Field", name: { kind: "Name", value: "color" } },
                    { kind: "Field", name: { kind: "Name", value: "title" } },
                    { kind: "Field", name: { kind: "Name", value: "slugId" } },
                    { kind: "Field", name: { kind: "Name", value: "content" } },
                    { kind: "Field", name: { kind: "Name", value: "icon" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "lastAppliedTemplate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "sortOrder" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "hiddenAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "updatedBy" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const DocumentSearchPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "DocumentSearchPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "DocumentSearchPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "archivePayload" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ArchiveResponse" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "totalCount" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "DocumentSearchResult" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const DraftFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Draft" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Draft" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "data" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "parentComment" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customerNeed" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiativeUpdate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "projectUpdate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "bodyData" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "isAutogenerated" } },
                ],
            },
        },
    ],
};
const DraftConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "DraftConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "DraftConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Draft" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const EmailIntakeAddressFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "EmailIntakeAddress" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "EmailIntakeAddress" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "template" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "address" } },
                    { kind: "Field", name: { kind: "Name", value: "repliesEnabled" } },
                    { kind: "Field", name: { kind: "Name", value: "customerRequestsEnabled" } },
                    { kind: "Field", name: { kind: "Name", value: "enabled" } },
                ],
            },
        },
    ],
};
const EmailIntakeAddressPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "EmailIntakeAddressPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "EmailIntakeAddressPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "emailIntakeAddress" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "EmailIntakeAddress" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const EmailUnsubscribePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "EmailUnsubscribePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "EmailUnsubscribePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const EmailUserAccountAuthChallengeResponseFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "EmailUserAccountAuthChallengeResponse" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "EmailUserAccountAuthChallengeResponse" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "authType" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const EmojiFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Emoji" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Emoji" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "source" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const EmojiConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "EmojiConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "EmojiConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Emoji" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const EmojiPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "EmojiPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "EmojiPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "emoji" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const EntityExternalLinkFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "EntityExternalLink" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "EntityExternalLink" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    { kind: "Field", name: { kind: "Name", value: "label" } },
                    { kind: "Field", name: { kind: "Name", value: "sortOrder" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const EntityExternalLinkConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "EntityExternalLinkConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "EntityExternalLinkConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "EntityExternalLink" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const EntityExternalLinkPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "EntityExternalLinkPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "EntityExternalLinkPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "entityExternalLink" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const ExternalUserFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ExternalUser" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ExternalUser" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "avatarUrl" } },
                    { kind: "Field", name: { kind: "Name", value: "displayName" } },
                    { kind: "Field", name: { kind: "Name", value: "email" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSeen" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const ExternalUserConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ExternalUserConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ExternalUserConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ExternalUser" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const FavoriteFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Favorite" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Favorite" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customView" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customer" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "cycle" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "document" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "label" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "roadmap" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "folderName" } },
                    { kind: "Field", name: { kind: "Name", value: "sortOrder" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "owner" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "parent" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "initiativeTab" } },
                    { kind: "Field", name: { kind: "Name", value: "projectTab" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "predefinedViewTeam" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "predefinedViewType" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "projectTeam" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const FavoriteConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "FavoriteConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "FavoriteConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Favorite" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const FavoritePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "FavoritePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "FavoritePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "favorite" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const FrontAttachmentPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "FrontAttachmentPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "FrontAttachmentPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "attachment" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const GitAutomationTargetBranchFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "GitAutomationTargetBranch" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "GitAutomationTargetBranch" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "branchPattern" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "isRegex" } },
                ],
            },
        },
    ],
};
const GitAutomationStateFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "GitAutomationState" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "GitAutomationState" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "state" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "event" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "targetBranch" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "GitAutomationTargetBranch" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "branchPattern" } },
                ],
            },
        },
    ],
};
const GitAutomationStateConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "GitAutomationStateConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "GitAutomationStateConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "GitAutomationState" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const GitAutomationStatePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "GitAutomationStatePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "GitAutomationStatePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "gitAutomationState" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "GitAutomationState" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const GitAutomationTargetBranchPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "GitAutomationTargetBranchPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "GitAutomationTargetBranchPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "targetBranch" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "GitAutomationTargetBranch" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const GitHubCommitIntegrationPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "GitHubCommitIntegrationPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "GitHubCommitIntegrationPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integration" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "webhookSecret" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const GitHubEnterpriseServerInstallVerificationPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "GitHubEnterpriseServerInstallVerificationPayload" },
            typeCondition: {
                kind: "NamedType",
                name: { kind: "Name", value: "GitHubEnterpriseServerInstallVerificationPayload" },
            },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const GitHubEnterpriseServerPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "GitHubEnterpriseServerPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "GitHubEnterpriseServerPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "installUrl" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integration" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "setupUrl" } },
                    { kind: "Field", name: { kind: "Name", value: "webhookSecret" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const GitLabIntegrationCreatePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "GitLabIntegrationCreatePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "GitLabIntegrationCreatePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integration" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "webhookSecret" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const ImageUploadFromUrlPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ImageUploadFromUrlPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ImageUploadFromUrlPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const InitiativeFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Initiative" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Initiative" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "trashed" } },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integrationsSettings" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updateRemindersDay" } },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "targetDate" } },
                    { kind: "Field", name: { kind: "Name", value: "updateReminderFrequency" } },
                    { kind: "Field", name: { kind: "Name", value: "health" } },
                    { kind: "Field", name: { kind: "Name", value: "updateRemindersHour" } },
                    { kind: "Field", name: { kind: "Name", value: "icon" } },
                    { kind: "Field", name: { kind: "Name", value: "color" } },
                    { kind: "Field", name: { kind: "Name", value: "content" } },
                    { kind: "Field", name: { kind: "Name", value: "slugId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "lastUpdate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "updateReminderFrequencyInWeeks" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "targetDateResolution" } },
                    { kind: "Field", name: { kind: "Name", value: "frequencyResolution" } },
                    { kind: "Field", name: { kind: "Name", value: "sortOrder" } },
                    { kind: "Field", name: { kind: "Name", value: "status" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "healthUpdatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "startedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "completedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "owner" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const InitiativeConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "InitiativeConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Initiative" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const InitiativeHistoryFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "InitiativeHistory" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeHistory" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "entries" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const InitiativeHistoryConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "InitiativeHistoryConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeHistoryConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "InitiativeHistory" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const InitiativeRelationFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "InitiativeRelation" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeRelation" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "relatedInitiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "sortOrder" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const InitiativeRelationConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "InitiativeRelationConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeRelationConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "InitiativeRelation" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const InitiativeRelationPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "InitiativeRelationPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeRelationPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiativeRelation" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "InitiativeRelation" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const InitiativeToProjectFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "InitiativeToProject" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeToProject" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "sortOrder" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const InitiativeToProjectConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "InitiativeToProjectConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeToProjectConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "InitiativeToProject" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const InitiativeUpdateFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "InitiativeUpdate" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeUpdate" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "reactionData" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "reactions" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Reaction" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    { kind: "Field", name: { kind: "Name", value: "diffMarkdown" } },
                    { kind: "Field", name: { kind: "Name", value: "diff" } },
                    { kind: "Field", name: { kind: "Name", value: "health" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "editedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "body" } },
                    { kind: "Field", name: { kind: "Name", value: "slugId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "isDiffHidden" } },
                    { kind: "Field", name: { kind: "Name", value: "isStale" } },
                ],
            },
        },
    ],
};
const InitiativeUpdateConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "InitiativeUpdateConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeUpdateConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "InitiativeUpdate" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const InitiativeUpdatePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "InitiativeUpdatePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeUpdatePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiativeUpdate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const InitiativeUpdateReminderPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "InitiativeUpdateReminderPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "InitiativeUpdateReminderPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const IntegrationFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Integration" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Integration" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "service" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const IntegrationConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IntegrationConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IntegrationConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Integration" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const IntegrationHasScopesPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IntegrationHasScopesPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IntegrationHasScopesPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "missingScopes" } },
                    { kind: "Field", name: { kind: "Name", value: "hasAllScopes" } },
                ],
            },
        },
    ],
};
const IntegrationPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IntegrationPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IntegrationPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integration" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const IntegrationRequestPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IntegrationRequestPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IntegrationRequestPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const IntegrationTemplateFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IntegrationTemplate" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IntegrationTemplate" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "foreignEntityId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integration" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "template" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const IntegrationTemplateConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IntegrationTemplateConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IntegrationTemplateConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IntegrationTemplate" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const IntegrationTemplatePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IntegrationTemplatePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IntegrationTemplatePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integrationTemplate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const IntegrationsSettingsPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IntegrationsSettingsPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IntegrationsSettingsPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integrationsSettings" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const IssueFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Issue" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Issue" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "trashed" } },
                    { kind: "Field", name: { kind: "Name", value: "reactionData" } },
                    { kind: "Field", name: { kind: "Name", value: "labelIds" } },
                    { kind: "Field", name: { kind: "Name", value: "integrationSourceType" } },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    { kind: "Field", name: { kind: "Name", value: "identifier" } },
                    { kind: "Field", name: { kind: "Name", value: "priorityLabel" } },
                    { kind: "Field", name: { kind: "Name", value: "previousIdentifiers" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "reactions" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Reaction" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "customerTicketCount" } },
                    { kind: "Field", name: { kind: "Name", value: "branchName" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "botActor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ActorBot" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "sourceComment" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "cycle" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "dueDate" } },
                    { kind: "Field", name: { kind: "Name", value: "estimate" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "externalUserCreator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "title" } },
                    { kind: "Field", name: { kind: "Name", value: "number" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "lastAppliedTemplate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "boardOrder" } },
                    { kind: "Field", name: { kind: "Name", value: "prioritySortOrder" } },
                    { kind: "Field", name: { kind: "Name", value: "sortOrder" } },
                    { kind: "Field", name: { kind: "Name", value: "subIssueSortOrder" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "parent" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "priority" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "projectMilestone" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "recurringIssueTemplate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "startedTriageAt" } },
                    { kind: "Field", name: { kind: "Name", value: "triagedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "addedToCycleAt" } },
                    { kind: "Field", name: { kind: "Name", value: "addedToProjectAt" } },
                    { kind: "Field", name: { kind: "Name", value: "addedToTeamAt" } },
                    { kind: "Field", name: { kind: "Name", value: "autoArchivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "autoClosedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "canceledAt" } },
                    { kind: "Field", name: { kind: "Name", value: "completedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "startedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "slaStartedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "slaBreachesAt" } },
                    { kind: "Field", name: { kind: "Name", value: "slaHighRiskAt" } },
                    { kind: "Field", name: { kind: "Name", value: "slaMediumRiskAt" } },
                    { kind: "Field", name: { kind: "Name", value: "snoozedUntilAt" } },
                    { kind: "Field", name: { kind: "Name", value: "slaType" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "assignee" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "snoozedBy" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "favorite" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "state" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const IssueBatchPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueBatchPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueBatchPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issues" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Issue" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const IssueConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Issue" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const IssueFilterSuggestionPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueFilterSuggestionPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueFilterSuggestionPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "filter" } },
                    { kind: "Field", name: { kind: "Name", value: "logId" } },
                ],
            },
        },
    ],
};
const IssueRelationHistoryPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueRelationHistoryPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueRelationHistoryPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "identifier" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                ],
            },
        },
    ],
};
const UserFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "User" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "User" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "statusUntilAt" } },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "avatarUrl" } },
                    { kind: "Field", name: { kind: "Name", value: "createdIssueCount" } },
                    { kind: "Field", name: { kind: "Name", value: "disableReason" } },
                    { kind: "Field", name: { kind: "Name", value: "avatarBackgroundColor" } },
                    { kind: "Field", name: { kind: "Name", value: "statusEmoji" } },
                    { kind: "Field", name: { kind: "Name", value: "initials" } },
                    { kind: "Field", name: { kind: "Name", value: "statusLabel" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSeen" } },
                    { kind: "Field", name: { kind: "Name", value: "timezone" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "displayName" } },
                    { kind: "Field", name: { kind: "Name", value: "email" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "inviteHash" } },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    { kind: "Field", name: { kind: "Name", value: "active" } },
                    { kind: "Field", name: { kind: "Name", value: "guest" } },
                    { kind: "Field", name: { kind: "Name", value: "app" } },
                    { kind: "Field", name: { kind: "Name", value: "admin" } },
                    { kind: "Field", name: { kind: "Name", value: "isMe" } },
                    { kind: "Field", name: { kind: "Name", value: "calendarHash" } },
                ],
            },
        },
    ],
};
const IssueImportFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueImport" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueImport" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "progress" } },
                    { kind: "Field", name: { kind: "Name", value: "errorMetadata" } },
                    { kind: "Field", name: { kind: "Name", value: "csvFileUrl" } },
                    { kind: "Field", name: { kind: "Name", value: "serviceMetadata" } },
                    { kind: "Field", name: { kind: "Name", value: "teamName" } },
                    { kind: "Field", name: { kind: "Name", value: "mapping" } },
                    { kind: "Field", name: { kind: "Name", value: "displayName" } },
                    { kind: "Field", name: { kind: "Name", value: "creatorId" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "service" } },
                    { kind: "Field", name: { kind: "Name", value: "status" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "error" } },
                ],
            },
        },
    ],
};
const IssueLabelFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueLabel" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueLabel" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "color" } },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "inheritedFrom" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "parent" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "isGroup" } },
                ],
            },
        },
    ],
};
const IssueHistoryFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueHistory" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueHistory" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "relationChanges" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueRelationHistoryPayload" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "addedLabelIds" } },
                    { kind: "Field", name: { kind: "Name", value: "removedLabelIds" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "actor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "descriptionUpdatedBy" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "User" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "actors" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "User" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "botActor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ActorBot" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "fromCycle" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "toCycle" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "attachmentId" } },
                    { kind: "Field", name: { kind: "Name", value: "customerNeedId" } },
                    { kind: "Field", name: { kind: "Name", value: "toCycleId" } },
                    { kind: "Field", name: { kind: "Name", value: "toParentId" } },
                    { kind: "Field", name: { kind: "Name", value: "toConvertedProjectId" } },
                    { kind: "Field", name: { kind: "Name", value: "toProjectId" } },
                    { kind: "Field", name: { kind: "Name", value: "toStateId" } },
                    { kind: "Field", name: { kind: "Name", value: "fromCycleId" } },
                    { kind: "Field", name: { kind: "Name", value: "fromParentId" } },
                    { kind: "Field", name: { kind: "Name", value: "fromProjectId" } },
                    { kind: "Field", name: { kind: "Name", value: "fromStateId" } },
                    { kind: "Field", name: { kind: "Name", value: "fromTeamId" } },
                    { kind: "Field", name: { kind: "Name", value: "toTeamId" } },
                    { kind: "Field", name: { kind: "Name", value: "fromAssigneeId" } },
                    { kind: "Field", name: { kind: "Name", value: "toAssigneeId" } },
                    { kind: "Field", name: { kind: "Name", value: "actorId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueImport" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueImport" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "addedLabels" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueLabel" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "removedLabels" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueLabel" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "attachment" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "toConvertedProject" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "fromParent" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "toParent" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "fromProject" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "toProject" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "fromState" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "toState" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "fromTeam" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "toTeam" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "toAssignee" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "fromAssignee" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "triageResponsibilityNotifiedUsers" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "User" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "fromDueDate" } },
                    { kind: "Field", name: { kind: "Name", value: "toDueDate" } },
                    { kind: "Field", name: { kind: "Name", value: "fromEstimate" } },
                    { kind: "Field", name: { kind: "Name", value: "toEstimate" } },
                    { kind: "Field", name: { kind: "Name", value: "fromPriority" } },
                    { kind: "Field", name: { kind: "Name", value: "toPriority" } },
                    { kind: "Field", name: { kind: "Name", value: "fromTitle" } },
                    { kind: "Field", name: { kind: "Name", value: "toTitle" } },
                    { kind: "Field", name: { kind: "Name", value: "archived" } },
                    { kind: "Field", name: { kind: "Name", value: "autoArchived" } },
                    { kind: "Field", name: { kind: "Name", value: "autoClosed" } },
                    { kind: "Field", name: { kind: "Name", value: "trashed" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedDescription" } },
                ],
            },
        },
    ],
};
const IssueHistoryConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueHistoryConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueHistoryConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueHistory" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const IssueImportCheckPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueImportCheckPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueImportCheckPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const IssueImportDeletePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueImportDeletePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueImportDeletePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueImport" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueImport" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const IssueImportPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueImportPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueImportPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueImport" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueImport" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const IssueLabelConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueLabelConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueLabelConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueLabel" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const IssueLabelPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueLabelPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueLabelPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueLabel" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const IssuePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssuePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssuePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const IssuePriorityValueFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssuePriorityValue" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssuePriorityValue" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "label" } },
                    { kind: "Field", name: { kind: "Name", value: "priority" } },
                ],
            },
        },
    ],
};
const IssueRelationFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueRelation" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueRelation" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "relatedIssue" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const IssueRelationConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueRelationConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueRelationConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueRelation" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const IssueRelationPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueRelationPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueRelationPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueRelation" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const IssueSearchResultFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueSearchResult" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueSearchResult" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "trashed" } },
                    { kind: "Field", name: { kind: "Name", value: "reactionData" } },
                    { kind: "Field", name: { kind: "Name", value: "labelIds" } },
                    { kind: "Field", name: { kind: "Name", value: "integrationSourceType" } },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    { kind: "Field", name: { kind: "Name", value: "identifier" } },
                    { kind: "Field", name: { kind: "Name", value: "priorityLabel" } },
                    { kind: "Field", name: { kind: "Name", value: "metadata" } },
                    { kind: "Field", name: { kind: "Name", value: "previousIdentifiers" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "reactions" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Reaction" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "customerTicketCount" } },
                    { kind: "Field", name: { kind: "Name", value: "branchName" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "botActor" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ActorBot" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "sourceComment" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "cycle" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "dueDate" } },
                    { kind: "Field", name: { kind: "Name", value: "estimate" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "externalUserCreator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "title" } },
                    { kind: "Field", name: { kind: "Name", value: "number" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "lastAppliedTemplate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "boardOrder" } },
                    { kind: "Field", name: { kind: "Name", value: "prioritySortOrder" } },
                    { kind: "Field", name: { kind: "Name", value: "sortOrder" } },
                    { kind: "Field", name: { kind: "Name", value: "subIssueSortOrder" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "parent" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "priority" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "projectMilestone" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "recurringIssueTemplate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "startedTriageAt" } },
                    { kind: "Field", name: { kind: "Name", value: "triagedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "addedToCycleAt" } },
                    { kind: "Field", name: { kind: "Name", value: "addedToProjectAt" } },
                    { kind: "Field", name: { kind: "Name", value: "addedToTeamAt" } },
                    { kind: "Field", name: { kind: "Name", value: "autoArchivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "autoClosedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "canceledAt" } },
                    { kind: "Field", name: { kind: "Name", value: "completedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "startedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "slaStartedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "slaBreachesAt" } },
                    { kind: "Field", name: { kind: "Name", value: "slaHighRiskAt" } },
                    { kind: "Field", name: { kind: "Name", value: "slaMediumRiskAt" } },
                    { kind: "Field", name: { kind: "Name", value: "snoozedUntilAt" } },
                    { kind: "Field", name: { kind: "Name", value: "slaType" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "assignee" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "snoozedBy" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "favorite" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "state" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const IssueSearchPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueSearchPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "IssueSearchPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "archivePayload" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ArchiveResponse" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "totalCount" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueSearchResult" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const IssueTitleSuggestionFromCustomerRequestPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "IssueTitleSuggestionFromCustomerRequestPayload" },
            typeCondition: {
                kind: "NamedType",
                name: { kind: "Name", value: "IssueTitleSuggestionFromCustomerRequestPayload" },
            },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "title" } },
                ],
            },
        },
    ],
};
const LogoutResponseFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "LogoutResponse" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "LogoutResponse" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const NodeFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Node" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Node" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const NotificationBatchActionPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "NotificationBatchActionPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "NotificationBatchActionPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "notifications" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Notification" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const NotificationConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "NotificationConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "NotificationConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Notification" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const NotificationPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "NotificationPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "NotificationPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "notification" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Notification" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const NotificationSubscriptionConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "NotificationSubscriptionConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "NotificationSubscriptionConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationSubscription" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const NotificationSubscriptionPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "NotificationSubscriptionPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "NotificationSubscriptionPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "notificationSubscription" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationSubscription" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const OrganizationAcceptedOrExpiredInviteDetailsPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "OrganizationAcceptedOrExpiredInviteDetailsPayload" },
            typeCondition: {
                kind: "NamedType",
                name: { kind: "Name", value: "OrganizationAcceptedOrExpiredInviteDetailsPayload" },
            },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "status" } },
                ],
            },
        },
    ],
};
const OrganizationCancelDeletePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "OrganizationCancelDeletePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "OrganizationCancelDeletePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const OrganizationDeletePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "OrganizationDeletePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "OrganizationDeletePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const OrganizationExistsPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "OrganizationExistsPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "OrganizationExistsPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                    { kind: "Field", name: { kind: "Name", value: "exists" } },
                ],
            },
        },
    ],
};
const OrganizationInviteFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "OrganizationInvite" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "OrganizationInvite" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "metadata" } },
                    { kind: "Field", name: { kind: "Name", value: "external" } },
                    { kind: "Field", name: { kind: "Name", value: "email" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "acceptedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "expiresAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "role" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "inviter" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "invitee" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const OrganizationInviteConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "OrganizationInviteConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "OrganizationInviteConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "OrganizationInvite" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const OrganizationInviteFullDetailsPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "OrganizationInviteFullDetailsPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "OrganizationInviteFullDetailsPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "allowedAuthServices" } },
                    { kind: "Field", name: { kind: "Name", value: "organizationId" } },
                    { kind: "Field", name: { kind: "Name", value: "organizationName" } },
                    { kind: "Field", name: { kind: "Name", value: "email" } },
                    { kind: "Field", name: { kind: "Name", value: "inviter" } },
                    { kind: "Field", name: { kind: "Name", value: "status" } },
                    { kind: "Field", name: { kind: "Name", value: "organizationLogoUrl" } },
                    { kind: "Field", name: { kind: "Name", value: "role" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "accepted" } },
                    { kind: "Field", name: { kind: "Name", value: "expired" } },
                ],
            },
        },
    ],
};
const OrganizationInvitePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "OrganizationInvitePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "OrganizationInvitePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "organizationInvite" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const OrganizationMetaFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "OrganizationMeta" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "OrganizationMeta" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "allowedAuthServices" } },
                    { kind: "Field", name: { kind: "Name", value: "region" } },
                ],
            },
        },
    ],
};
const OrganizationPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "OrganizationPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "OrganizationPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const OrganizationStartTrialPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "OrganizationStartTrialPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "OrganizationStartTrialPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const PasskeyLoginStartResponseFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "PasskeyLoginStartResponse" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "PasskeyLoginStartResponse" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "options" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const ProjectFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Project" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Project" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "trashed" } },
                    { kind: "Field", name: { kind: "Name", value: "labelIds" } },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integrationsSettings" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "documentContent" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "DocumentContent" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updateRemindersDay" } },
                    { kind: "Field", name: { kind: "Name", value: "targetDate" } },
                    { kind: "Field", name: { kind: "Name", value: "startDate" } },
                    { kind: "Field", name: { kind: "Name", value: "updateReminderFrequency" } },
                    { kind: "Field", name: { kind: "Name", value: "health" } },
                    { kind: "Field", name: { kind: "Name", value: "updateRemindersHour" } },
                    { kind: "Field", name: { kind: "Name", value: "icon" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "lastUpdate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "lastAppliedTemplate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "updateReminderFrequencyInWeeks" } },
                    { kind: "Field", name: { kind: "Name", value: "completedScopeHistory" } },
                    { kind: "Field", name: { kind: "Name", value: "completedIssueCountHistory" } },
                    { kind: "Field", name: { kind: "Name", value: "inProgressScopeHistory" } },
                    { kind: "Field", name: { kind: "Name", value: "progress" } },
                    { kind: "Field", name: { kind: "Name", value: "scope" } },
                    { kind: "Field", name: { kind: "Name", value: "priorityLabel" } },
                    { kind: "Field", name: { kind: "Name", value: "priority" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "lead" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "convertedFromIssue" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "color" } },
                    { kind: "Field", name: { kind: "Name", value: "content" } },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "slugId" } },
                    { kind: "Field", name: { kind: "Name", value: "targetDateResolution" } },
                    { kind: "Field", name: { kind: "Name", value: "startDateResolution" } },
                    { kind: "Field", name: { kind: "Name", value: "frequencyResolution" } },
                    { kind: "Field", name: { kind: "Name", value: "prioritySortOrder" } },
                    { kind: "Field", name: { kind: "Name", value: "sortOrder" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "status" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "healthUpdatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "autoArchivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "canceledAt" } },
                    { kind: "Field", name: { kind: "Name", value: "completedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "startedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "projectUpdateRemindersPausedUntilAt" } },
                    { kind: "Field", name: { kind: "Name", value: "scopeHistory" } },
                    { kind: "Field", name: { kind: "Name", value: "issueCountHistory" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "favorite" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "slackIssueComments" } },
                    { kind: "Field", name: { kind: "Name", value: "slackNewIssue" } },
                    { kind: "Field", name: { kind: "Name", value: "slackIssueStatuses" } },
                    { kind: "Field", name: { kind: "Name", value: "state" } },
                ],
            },
        },
    ],
};
const ProjectConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Project" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const ProjectFilterSuggestionPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectFilterSuggestionPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectFilterSuggestionPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "filter" } },
                    { kind: "Field", name: { kind: "Name", value: "logId" } },
                ],
            },
        },
    ],
};
const ProjectHistoryFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectHistory" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectHistory" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "entries" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const ProjectHistoryConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectHistoryConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectHistoryConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ProjectHistory" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const ProjectMilestoneFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectMilestone" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectMilestone" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "documentContent" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "DocumentContent" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "sortOrder" } },
                    { kind: "Field", name: { kind: "Name", value: "targetDate" } },
                    { kind: "Field", name: { kind: "Name", value: "progress" } },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "status" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const ProjectMilestoneConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectMilestoneConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectMilestoneConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ProjectMilestone" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const ProjectMilestoneMoveIssueToTeamFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectMilestoneMoveIssueToTeam" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectMilestoneMoveIssueToTeam" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "issueId" } },
                    { kind: "Field", name: { kind: "Name", value: "teamId" } },
                ],
            },
        },
    ],
};
const ProjectMilestoneMoveProjectTeamsFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectMilestoneMoveProjectTeams" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectMilestoneMoveProjectTeams" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "projectId" } },
                    { kind: "Field", name: { kind: "Name", value: "teamIds" } },
                ],
            },
        },
    ],
};
const ProjectMilestoneMovePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectMilestoneMovePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectMilestoneMovePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "previousIssueTeamIds" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                { kind: "FragmentSpread", name: { kind: "Name", value: "ProjectMilestoneMoveIssueToTeam" } },
                            ],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "previousProjectTeamIds" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                { kind: "FragmentSpread", name: { kind: "Name", value: "ProjectMilestoneMoveProjectTeams" } },
                            ],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "projectMilestone" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const ProjectMilestonePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectMilestonePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectMilestonePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "projectMilestone" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const ProjectPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const ProjectRelationFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectRelation" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectRelation" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "projectMilestone" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "relatedProjectMilestone" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "relatedProject" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "anchorType" } },
                    { kind: "Field", name: { kind: "Name", value: "relatedAnchorType" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const ProjectRelationConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectRelationConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectRelationConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ProjectRelation" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const ProjectRelationPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectRelationPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectRelationPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "projectRelation" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const ProjectSearchResultFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectSearchResult" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectSearchResult" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "trashed" } },
                    { kind: "Field", name: { kind: "Name", value: "labelIds" } },
                    { kind: "Field", name: { kind: "Name", value: "metadata" } },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integrationsSettings" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "documentContent" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "DocumentContent" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updateRemindersDay" } },
                    { kind: "Field", name: { kind: "Name", value: "targetDate" } },
                    { kind: "Field", name: { kind: "Name", value: "startDate" } },
                    { kind: "Field", name: { kind: "Name", value: "updateReminderFrequency" } },
                    { kind: "Field", name: { kind: "Name", value: "health" } },
                    { kind: "Field", name: { kind: "Name", value: "updateRemindersHour" } },
                    { kind: "Field", name: { kind: "Name", value: "icon" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "lastUpdate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "lastAppliedTemplate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "updateReminderFrequencyInWeeks" } },
                    { kind: "Field", name: { kind: "Name", value: "completedScopeHistory" } },
                    { kind: "Field", name: { kind: "Name", value: "completedIssueCountHistory" } },
                    { kind: "Field", name: { kind: "Name", value: "inProgressScopeHistory" } },
                    { kind: "Field", name: { kind: "Name", value: "progress" } },
                    { kind: "Field", name: { kind: "Name", value: "scope" } },
                    { kind: "Field", name: { kind: "Name", value: "priorityLabel" } },
                    { kind: "Field", name: { kind: "Name", value: "priority" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "lead" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "convertedFromIssue" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "color" } },
                    { kind: "Field", name: { kind: "Name", value: "content" } },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "slugId" } },
                    { kind: "Field", name: { kind: "Name", value: "targetDateResolution" } },
                    { kind: "Field", name: { kind: "Name", value: "startDateResolution" } },
                    { kind: "Field", name: { kind: "Name", value: "frequencyResolution" } },
                    { kind: "Field", name: { kind: "Name", value: "prioritySortOrder" } },
                    { kind: "Field", name: { kind: "Name", value: "sortOrder" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "status" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "healthUpdatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "autoArchivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "canceledAt" } },
                    { kind: "Field", name: { kind: "Name", value: "completedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "startedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "projectUpdateRemindersPausedUntilAt" } },
                    { kind: "Field", name: { kind: "Name", value: "scopeHistory" } },
                    { kind: "Field", name: { kind: "Name", value: "issueCountHistory" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "favorite" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "slackIssueComments" } },
                    { kind: "Field", name: { kind: "Name", value: "slackNewIssue" } },
                    { kind: "Field", name: { kind: "Name", value: "slackIssueStatuses" } },
                    { kind: "Field", name: { kind: "Name", value: "state" } },
                ],
            },
        },
    ],
};
const ProjectSearchPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectSearchPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectSearchPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "archivePayload" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ArchiveResponse" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "totalCount" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ProjectSearchResult" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const ProjectStatusConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectStatusConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectStatusConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ProjectStatus" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const ProjectStatusCountPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectStatusCountPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectStatusCountPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "privateCount" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedTeamCount" } },
                    { kind: "Field", name: { kind: "Name", value: "count" } },
                ],
            },
        },
    ],
};
const ProjectStatusPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectStatusPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectStatusPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "status" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const ProjectUpdateFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectUpdate" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectUpdate" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "reactionData" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "reactions" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Reaction" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    { kind: "Field", name: { kind: "Name", value: "diffMarkdown" } },
                    { kind: "Field", name: { kind: "Name", value: "diff" } },
                    { kind: "Field", name: { kind: "Name", value: "health" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "editedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    { kind: "Field", name: { kind: "Name", value: "body" } },
                    { kind: "Field", name: { kind: "Name", value: "slugId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "isDiffHidden" } },
                    { kind: "Field", name: { kind: "Name", value: "isStale" } },
                ],
            },
        },
    ],
};
const ProjectUpdateConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectUpdateConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectUpdateConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ProjectUpdate" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const ProjectUpdatePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectUpdatePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectUpdatePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "projectUpdate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const ProjectUpdateReminderPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ProjectUpdateReminderPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ProjectUpdateReminderPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const PushSubscriptionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "PushSubscription" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "PushSubscription" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const PushSubscriptionPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "PushSubscriptionPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "PushSubscriptionPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "entity" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PushSubscription" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const PushSubscriptionTestPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "PushSubscriptionTestPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "PushSubscriptionTestPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const RateLimitResultPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "RateLimitResultPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "RateLimitResultPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "period" } },
                    { kind: "Field", name: { kind: "Name", value: "remainingAmount" } },
                    { kind: "Field", name: { kind: "Name", value: "requestedAmount" } },
                    { kind: "Field", name: { kind: "Name", value: "reset" } },
                    { kind: "Field", name: { kind: "Name", value: "allowedAmount" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                ],
            },
        },
    ],
};
const RateLimitPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "RateLimitPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "RateLimitPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "identifier" } },
                    { kind: "Field", name: { kind: "Name", value: "kind" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "limits" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "RateLimitResultPayload" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const ReactionPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ReactionPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ReactionPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "reaction" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Reaction" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const RoadmapFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Roadmap" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Roadmap" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "color" } },
                    { kind: "Field", name: { kind: "Name", value: "slugId" } },
                    { kind: "Field", name: { kind: "Name", value: "sortOrder" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "owner" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const RoadmapConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "RoadmapConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "RoadmapConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Roadmap" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const RoadmapPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "RoadmapPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "RoadmapPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "roadmap" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const RoadmapToProjectFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "RoadmapToProject" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "RoadmapToProject" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "project" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "roadmap" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "sortOrder" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const RoadmapToProjectConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "RoadmapToProjectConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "RoadmapToProjectConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "RoadmapToProject" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const RoadmapToProjectPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "RoadmapToProjectPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "RoadmapToProjectPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "roadmapToProject" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const SlackChannelConnectPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "SlackChannelConnectPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "SlackChannelConnectPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integration" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "nudgeToConnectMainSlackIntegration" } },
                    { kind: "Field", name: { kind: "Name", value: "nudgeToUpdateMainSlackIntegration" } },
                    { kind: "Field", name: { kind: "Name", value: "addBot" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const SsoUrlFromEmailResponseFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "SsoUrlFromEmailResponse" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "SsoUrlFromEmailResponse" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "samlSsoUrl" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const SuccessPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "SuccessPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "SuccessPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const SummaryPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "SummaryPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "SummaryPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "summary" } },
                ],
            },
        },
    ],
};
const TeamFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Team" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Team" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "cycleIssueAutoAssignCompleted" } },
                    { kind: "Field", name: { kind: "Name", value: "cycleLockToActive" } },
                    { kind: "Field", name: { kind: "Name", value: "cycleIssueAutoAssignStarted" } },
                    { kind: "Field", name: { kind: "Name", value: "cycleCalenderUrl" } },
                    { kind: "Field", name: { kind: "Name", value: "upcomingCycleCount" } },
                    { kind: "Field", name: { kind: "Name", value: "issueCount" } },
                    { kind: "Field", name: { kind: "Name", value: "autoArchivePeriod" } },
                    { kind: "Field", name: { kind: "Name", value: "autoClosePeriod" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integrationsSettings" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "activeCycle" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "triageResponsibility" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "scimGroupName" } },
                    { kind: "Field", name: { kind: "Name", value: "autoCloseStateId" } },
                    { kind: "Field", name: { kind: "Name", value: "cycleCooldownTime" } },
                    { kind: "Field", name: { kind: "Name", value: "cycleStartDay" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "defaultTemplateForMembers" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "defaultTemplateForNonMembers" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "defaultProjectTemplate" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "defaultIssueState" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "cycleDuration" } },
                    { kind: "Field", name: { kind: "Name", value: "icon" } },
                    { kind: "Field", name: { kind: "Name", value: "defaultTemplateForMembersId" } },
                    { kind: "Field", name: { kind: "Name", value: "defaultTemplateForNonMembersId" } },
                    { kind: "Field", name: { kind: "Name", value: "issueEstimationType" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "displayName" } },
                    { kind: "Field", name: { kind: "Name", value: "color" } },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    { kind: "Field", name: { kind: "Name", value: "key" } },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "timezone" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "mergeWorkflowState" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "draftWorkflowState" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "startWorkflowState" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "mergeableWorkflowState" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "reviewWorkflowState" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "markedAsDuplicateWorkflowState" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "triageIssueState" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "inviteHash" } },
                    { kind: "Field", name: { kind: "Name", value: "defaultIssueEstimate" } },
                    { kind: "Field", name: { kind: "Name", value: "setIssueSortOrderOnStateChange" } },
                    { kind: "Field", name: { kind: "Name", value: "requirePriorityToLeaveTriage" } },
                    { kind: "Field", name: { kind: "Name", value: "autoCloseChildIssues" } },
                    { kind: "Field", name: { kind: "Name", value: "autoCloseParentIssues" } },
                    { kind: "Field", name: { kind: "Name", value: "scimManaged" } },
                    { kind: "Field", name: { kind: "Name", value: "private" } },
                    { kind: "Field", name: { kind: "Name", value: "inheritIssueEstimation" } },
                    { kind: "Field", name: { kind: "Name", value: "inheritWorkflowStatuses" } },
                    { kind: "Field", name: { kind: "Name", value: "cyclesEnabled" } },
                    { kind: "Field", name: { kind: "Name", value: "issueEstimationExtended" } },
                    { kind: "Field", name: { kind: "Name", value: "issueEstimationAllowZero" } },
                    { kind: "Field", name: { kind: "Name", value: "aiThreadSummariesEnabled" } },
                    { kind: "Field", name: { kind: "Name", value: "groupIssueHistory" } },
                    { kind: "Field", name: { kind: "Name", value: "slackIssueComments" } },
                    { kind: "Field", name: { kind: "Name", value: "slackNewIssue" } },
                    { kind: "Field", name: { kind: "Name", value: "slackIssueStatuses" } },
                    { kind: "Field", name: { kind: "Name", value: "triageEnabled" } },
                    { kind: "Field", name: { kind: "Name", value: "issueOrderingNoPriorityFirst" } },
                    { kind: "Field", name: { kind: "Name", value: "issueSortOrderDefaultToBottom" } },
                ],
            },
        },
    ],
};
const TeamConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "TeamConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "TeamConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Team" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const TeamMembershipFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "TeamMembership" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "TeamMembership" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "sortOrder" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "owner" } },
                ],
            },
        },
    ],
};
const TeamMembershipConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "TeamMembershipConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "TeamMembershipConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "TeamMembership" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const TeamMembershipPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "TeamMembershipPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "TeamMembershipPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "teamMembership" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const TeamPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "TeamPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "TeamPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const TemplateFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Template" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Template" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "templateData" } },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "inheritedFrom" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "sortOrder" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "lastUpdatedBy" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const TemplateConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "TemplateConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "TemplateConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Template" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const TemplatePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "TemplatePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "TemplatePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "template" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const TimeScheduleEntryFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "TimeScheduleEntry" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "TimeScheduleEntry" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "userId" } },
                    { kind: "Field", name: { kind: "Name", value: "userEmail" } },
                    { kind: "Field", name: { kind: "Name", value: "endsAt" } },
                    { kind: "Field", name: { kind: "Name", value: "startsAt" } },
                ],
            },
        },
    ],
};
const TimeScheduleFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "TimeSchedule" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "TimeSchedule" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "externalUrl" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integration" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "externalId" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "entries" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "TimeScheduleEntry" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const TimeScheduleConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "TimeScheduleConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "TimeScheduleConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "TimeSchedule" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const TimeSchedulePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "TimeSchedulePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "TimeSchedulePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "timeSchedule" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const TriageResponsibilityManualSelectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "TriageResponsibilityManualSelection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "TriageResponsibilityManualSelection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "userIds" } },
                ],
            },
        },
    ],
};
const TriageResponsibilityFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "TriageResponsibility" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "TriageResponsibility" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "manualSelection" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                { kind: "FragmentSpread", name: { kind: "Name", value: "TriageResponsibilityManualSelection" } },
                            ],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "action" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "timeSchedule" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "currentUser" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const TriageResponsibilityConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "TriageResponsibilityConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "TriageResponsibilityConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "TriageResponsibility" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const TriageResponsibilityPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "TriageResponsibilityPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "TriageResponsibilityPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "triageResponsibility" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const UploadFileHeaderFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "UploadFileHeader" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "UploadFileHeader" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "key" } },
                    { kind: "Field", name: { kind: "Name", value: "value" } },
                ],
            },
        },
    ],
};
const UploadFileFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "UploadFile" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "UploadFile" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "assetUrl" } },
                    { kind: "Field", name: { kind: "Name", value: "contentType" } },
                    { kind: "Field", name: { kind: "Name", value: "filename" } },
                    { kind: "Field", name: { kind: "Name", value: "uploadUrl" } },
                    { kind: "Field", name: { kind: "Name", value: "size" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "headers" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "UploadFileHeader" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "metaData" } },
                ],
            },
        },
    ],
};
const UploadPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "UploadPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "UploadPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "uploadFile" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "UploadFile" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const UserAdminPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "UserAdminPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "UserAdminPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const UserConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "UserConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "UserConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "User" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const UserPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "UserPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "UserPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "user" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const UserSettingsFlagPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "UserSettingsFlagPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "UserSettingsFlagPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "flag" } },
                    { kind: "Field", name: { kind: "Name", value: "value" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const UserSettingsFlagsResetPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "UserSettingsFlagsResetPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "UserSettingsFlagsResetPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const UserSettingsPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "UserSettingsPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "UserSettingsPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const ViewPreferencesPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "ViewPreferencesPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "ViewPreferencesPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "viewPreferences" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ViewPreferences" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const WebhookFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "Webhook" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "Webhook" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "secret" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "resourceTypes" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "creator" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "url" } },
                    { kind: "Field", name: { kind: "Name", value: "label" } },
                    { kind: "Field", name: { kind: "Name", value: "allPublicTeams" } },
                    { kind: "Field", name: { kind: "Name", value: "enabled" } },
                ],
            },
        },
    ],
};
const WebhookConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "WebhookConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "WebhookConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Webhook" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const WebhookPayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "WebhookPayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "WebhookPayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "webhook" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const WorkflowStateFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "WorkflowState" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "WorkflowState" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "description" } },
                    { kind: "Field", name: { kind: "Name", value: "updatedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "position" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "inheritedFrom" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "color" } },
                    { kind: "Field", name: { kind: "Name", value: "name" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "team" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "archivedAt" } },
                    { kind: "Field", name: { kind: "Name", value: "createdAt" } },
                    { kind: "Field", name: { kind: "Name", value: "type" } },
                    { kind: "Field", name: { kind: "Name", value: "id" } },
                ],
            },
        },
    ],
};
const WorkflowStateConnectionFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "WorkflowStateConnection" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "WorkflowStateConnection" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "nodes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "WorkflowState" } }],
                        },
                    },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "pageInfo" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "PageInfo" } }],
                        },
                    },
                ],
            },
        },
    ],
};
const WorkflowStatePayloadFragmentDoc = {
    kind: "Document",
    definitions: [
        {
            kind: "FragmentDefinition",
            name: { kind: "Name", value: "WorkflowStatePayload" },
            typeCondition: { kind: "NamedType", name: { kind: "Name", value: "WorkflowStatePayload" } },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    { kind: "Field", name: { kind: "Name", value: "__typename" } },
                    { kind: "Field", name: { kind: "Name", value: "lastSyncId" } },
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "workflowState" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "Field", name: { kind: "Name", value: "id" } }],
                        },
                    },
                    { kind: "Field", name: { kind: "Name", value: "success" } },
                ],
            },
        },
    ],
};
const AdministrableTeamsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "administrableTeams" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "TeamFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "administrableTeams" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "filter" },
                                value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "TeamConnection" } }],
                        },
                    },
                ],
            },
        },
        ...TeamConnectionFragmentDoc.definitions,
        ...TeamFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const ApiKeysDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "apiKeys" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "apiKeys" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ApiKeyConnection" } }],
                        },
                    },
                ],
            },
        },
        ...ApiKeyConnectionFragmentDoc.definitions,
        ...ApiKeyFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const ApplicationInfoDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "applicationInfo" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "clientId" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "applicationInfo" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "clientId" },
                                value: { kind: "Variable", name: { kind: "Name", value: "clientId" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Application" } }],
                        },
                    },
                ],
            },
        },
        ...ApplicationFragmentDoc.definitions,
    ],
};
const ApplicationWithAuthorizationDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "applicationWithAuthorization" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "actor" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "clientId" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "redirectUri" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "scope" } },
                    type: {
                        kind: "NonNullType",
                        type: {
                            kind: "ListType",
                            type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                        },
                    },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "applicationWithAuthorization" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "actor" },
                                value: { kind: "Variable", name: { kind: "Name", value: "actor" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "clientId" },
                                value: { kind: "Variable", name: { kind: "Name", value: "clientId" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "redirectUri" },
                                value: { kind: "Variable", name: { kind: "Name", value: "redirectUri" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "scope" },
                                value: { kind: "Variable", name: { kind: "Name", value: "scope" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "UserAuthorizedApplication" } }],
                        },
                    },
                ],
            },
        },
        ...UserAuthorizedApplicationFragmentDoc.definitions,
    ],
};
const AttachmentDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "attachment" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "attachment" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Attachment" } }],
                        },
                    },
                ],
            },
        },
        ...AttachmentFragmentDoc.definitions,
    ],
};
const AttachmentIssueDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "attachmentIssue" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "attachmentIssue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Issue" } }],
                        },
                    },
                ],
            },
        },
        ...IssueFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
    ],
};
const AttachmentIssue_AttachmentsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "attachmentIssue_attachments" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "AttachmentFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "attachmentIssue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "attachments" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "AttachmentConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...AttachmentConnectionFragmentDoc.definitions,
        ...AttachmentFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const AttachmentIssue_BotActorDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "attachmentIssue_botActor" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "attachmentIssue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "botActor" },
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ActorBot" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...ActorBotFragmentDoc.definitions,
    ],
};
const AttachmentIssue_ChildrenDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "attachmentIssue_children" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "IssueFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "attachmentIssue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "children" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueConnectionFragmentDoc.definitions,
        ...IssueFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const AttachmentIssue_CommentsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "attachmentIssue_comments" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "CommentFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "attachmentIssue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "comments" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CommentConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...CommentConnectionFragmentDoc.definitions,
        ...CommentFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...DocumentContentFragmentDoc.definitions,
        ...SyncedExternalThreadFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const AttachmentIssue_HistoryDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "attachmentIssue_history" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "attachmentIssue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "history" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueHistoryConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueHistoryConnectionFragmentDoc.definitions,
        ...IssueHistoryFragmentDoc.definitions,
        ...IssueRelationHistoryPayloadFragmentDoc.definitions,
        ...UserFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...IssueImportFragmentDoc.definitions,
        ...IssueLabelFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const AttachmentIssue_InverseRelationsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "attachmentIssue_inverseRelations" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "attachmentIssue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "inverseRelations" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueRelationConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueRelationConnectionFragmentDoc.definitions,
        ...IssueRelationFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const AttachmentIssue_LabelsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "attachmentIssue_labels" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "IssueLabelFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "attachmentIssue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "labels" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueLabelConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueLabelConnectionFragmentDoc.definitions,
        ...IssueLabelFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const AttachmentIssue_NeedsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "attachmentIssue_needs" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "CustomerNeedFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "attachmentIssue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "needs" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CustomerNeedConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...CustomerNeedConnectionFragmentDoc.definitions,
        ...CustomerNeedFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const AttachmentIssue_RelationsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "attachmentIssue_relations" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "attachmentIssue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "relations" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueRelationConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueRelationConnectionFragmentDoc.definitions,
        ...IssueRelationFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const AttachmentIssue_SubscribersDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "attachmentIssue_subscribers" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "UserFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeDisabled" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "attachmentIssue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "subscribers" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeDisabled" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeDisabled" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "UserConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...UserConnectionFragmentDoc.definitions,
        ...UserFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const AttachmentsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "attachments" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "AttachmentFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "attachments" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "filter" },
                                value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "AttachmentConnection" } }],
                        },
                    },
                ],
            },
        },
        ...AttachmentConnectionFragmentDoc.definitions,
        ...AttachmentFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const AttachmentsForUrlDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "attachmentsForURL" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "url" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "attachmentsForURL" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "url" },
                                value: { kind: "Variable", name: { kind: "Name", value: "url" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "AttachmentConnection" } }],
                        },
                    },
                ],
            },
        },
        ...AttachmentConnectionFragmentDoc.definitions,
        ...AttachmentFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const AuditEntriesDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "auditEntries" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "AuditEntryFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "auditEntries" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "filter" },
                                value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "AuditEntryConnection" } }],
                        },
                    },
                ],
            },
        },
        ...AuditEntryConnectionFragmentDoc.definitions,
        ...AuditEntryFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const AuditEntryTypesDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "auditEntryTypes" },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "auditEntryTypes" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "AuditEntryType" } }],
                        },
                    },
                ],
            },
        },
        ...AuditEntryTypeFragmentDoc.definitions,
    ],
};
const AuthenticationSessionsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "authenticationSessions" },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "authenticationSessions" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "AuthenticationSessionResponse" } }],
                        },
                    },
                ],
            },
        },
        ...AuthenticationSessionResponseFragmentDoc.definitions,
    ],
};
const AvailableUsersDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "availableUsers" },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "availableUsers" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "AuthResolverResponse" } }],
                        },
                    },
                ],
            },
        },
        ...AuthResolverResponseFragmentDoc.definitions,
        ...AuthUserFragmentDoc.definitions,
        ...AuthOrganizationFragmentDoc.definitions,
    ],
};
const CommentDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "comment" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "hash" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "comment" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "hash" },
                                value: { kind: "Variable", name: { kind: "Name", value: "hash" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Comment" } }],
                        },
                    },
                ],
            },
        },
        ...CommentFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...DocumentContentFragmentDoc.definitions,
        ...SyncedExternalThreadFragmentDoc.definitions,
    ],
};
const Comment_BotActorDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "comment_botActor" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "hash" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "comment" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "hash" },
                                value: { kind: "Variable", name: { kind: "Name", value: "hash" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "botActor" },
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ActorBot" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...ActorBotFragmentDoc.definitions,
    ],
};
const Comment_ChildrenDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "comment_children" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "hash" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "CommentFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "comment" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "hash" },
                                value: { kind: "Variable", name: { kind: "Name", value: "hash" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "children" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CommentConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...CommentConnectionFragmentDoc.definitions,
        ...CommentFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...DocumentContentFragmentDoc.definitions,
        ...SyncedExternalThreadFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const Comment_DocumentContentDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "comment_documentContent" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "hash" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "comment" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "hash" },
                                value: { kind: "Variable", name: { kind: "Name", value: "hash" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "documentContent" },
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "DocumentContent" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...DocumentContentFragmentDoc.definitions,
    ],
};
const Comment_ExternalThreadDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "comment_externalThread" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "hash" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "comment" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "hash" },
                                value: { kind: "Variable", name: { kind: "Name", value: "hash" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "externalThread" },
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "SyncedExternalThread" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...SyncedExternalThreadFragmentDoc.definitions,
    ],
};
const CommentsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "comments" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "CommentFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "comments" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "filter" },
                                value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CommentConnection" } }],
                        },
                    },
                ],
            },
        },
        ...CommentConnectionFragmentDoc.definitions,
        ...CommentFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...DocumentContentFragmentDoc.definitions,
        ...SyncedExternalThreadFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const CustomViewDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "customView" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customView" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CustomView" } }],
                        },
                    },
                ],
            },
        },
        ...CustomViewFragmentDoc.definitions,
        ...ViewPreferencesValuesFragmentDoc.definitions,
        ...ViewPreferencesFragmentDoc.definitions,
    ],
};
const CustomView_IssuesDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "customView_issues" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "IssueFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "sort" } },
                    type: {
                        kind: "ListType",
                        type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "IssueSortInput" } } },
                    },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customView" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "issues" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "sort" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "sort" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueConnectionFragmentDoc.definitions,
        ...IssueFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const CustomView_OrganizationViewPreferencesDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "customView_organizationViewPreferences" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customView" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "organizationViewPreferences" },
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ViewPreferences" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...ViewPreferencesFragmentDoc.definitions,
        ...ViewPreferencesValuesFragmentDoc.definitions,
    ],
};
const CustomView_OrganizationViewPreferences_PreferencesDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "customView_organizationViewPreferences_preferences" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customView" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "organizationViewPreferences" },
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [
                                            {
                                                kind: "Field",
                                                name: { kind: "Name", value: "preferences" },
                                                selectionSet: {
                                                    kind: "SelectionSet",
                                                    selections: [
                                                        { kind: "FragmentSpread", name: { kind: "Name", value: "ViewPreferencesValues" } },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...ViewPreferencesValuesFragmentDoc.definitions,
    ],
};
const CustomView_ProjectsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "customView_projects" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "ProjectFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customView" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "projects" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ProjectConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...ProjectConnectionFragmentDoc.definitions,
        ...ProjectFragmentDoc.definitions,
        ...DocumentContentFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const CustomView_UserViewPreferencesDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "customView_userViewPreferences" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customView" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "userViewPreferences" },
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ViewPreferences" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...ViewPreferencesFragmentDoc.definitions,
        ...ViewPreferencesValuesFragmentDoc.definitions,
    ],
};
const CustomView_UserViewPreferences_PreferencesDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "customView_userViewPreferences_preferences" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customView" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "userViewPreferences" },
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [
                                            {
                                                kind: "Field",
                                                name: { kind: "Name", value: "preferences" },
                                                selectionSet: {
                                                    kind: "SelectionSet",
                                                    selections: [
                                                        { kind: "FragmentSpread", name: { kind: "Name", value: "ViewPreferencesValues" } },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...ViewPreferencesValuesFragmentDoc.definitions,
    ],
};
const CustomView_ViewPreferencesValuesDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "customView_viewPreferencesValues" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customView" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "viewPreferencesValues" },
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ViewPreferencesValues" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...ViewPreferencesValuesFragmentDoc.definitions,
    ],
};
const CustomViewHasSubscribersDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "customViewHasSubscribers" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customViewHasSubscribers" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                { kind: "FragmentSpread", name: { kind: "Name", value: "CustomViewHasSubscribersPayload" } },
                            ],
                        },
                    },
                ],
            },
        },
        ...CustomViewHasSubscribersPayloadFragmentDoc.definitions,
    ],
};
const CustomViewsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "customViews" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customViews" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CustomViewConnection" } }],
                        },
                    },
                ],
            },
        },
        ...CustomViewConnectionFragmentDoc.definitions,
        ...CustomViewFragmentDoc.definitions,
        ...ViewPreferencesValuesFragmentDoc.definitions,
        ...ViewPreferencesFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const CustomerDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "customer" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customer" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Customer" } }],
                        },
                    },
                ],
            },
        },
        ...CustomerFragmentDoc.definitions,
    ],
};
const CustomerNeedDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "customerNeed" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "hash" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customerNeed" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "hash" },
                                value: { kind: "Variable", name: { kind: "Name", value: "hash" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CustomerNeed" } }],
                        },
                    },
                ],
            },
        },
        ...CustomerNeedFragmentDoc.definitions,
    ],
};
const CustomerNeedsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "customerNeeds" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "CustomerNeedFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customerNeeds" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "filter" },
                                value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CustomerNeedConnection" } }],
                        },
                    },
                ],
            },
        },
        ...CustomerNeedConnectionFragmentDoc.definitions,
        ...CustomerNeedFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const CustomerStatusDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "customerStatus" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customerStatus" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CustomerStatus" } }],
                        },
                    },
                ],
            },
        },
        ...CustomerStatusFragmentDoc.definitions,
    ],
};
const CustomerStatusesDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "customerStatuses" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customerStatuses" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CustomerStatusConnection" } }],
                        },
                    },
                ],
            },
        },
        ...CustomerStatusConnectionFragmentDoc.definitions,
        ...CustomerStatusFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const CustomerTierDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "customerTier" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customerTier" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CustomerTier" } }],
                        },
                    },
                ],
            },
        },
        ...CustomerTierFragmentDoc.definitions,
    ],
};
const CustomerTiersDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "customerTiers" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customerTiers" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CustomerTierConnection" } }],
                        },
                    },
                ],
            },
        },
        ...CustomerTierConnectionFragmentDoc.definitions,
        ...CustomerTierFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const CustomersDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "customers" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "CustomerFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "sorts" } },
                    type: {
                        kind: "ListType",
                        type: {
                            kind: "NonNullType",
                            type: { kind: "NamedType", name: { kind: "Name", value: "CustomerSortInput" } },
                        },
                    },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "customers" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "filter" },
                                value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "sorts" },
                                value: { kind: "Variable", name: { kind: "Name", value: "sorts" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CustomerConnection" } }],
                        },
                    },
                ],
            },
        },
        ...CustomerConnectionFragmentDoc.definitions,
        ...CustomerFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const CycleDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "cycle" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "cycle" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Cycle" } }],
                        },
                    },
                ],
            },
        },
        ...CycleFragmentDoc.definitions,
    ],
};
const Cycle_IssuesDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "cycle_issues" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "IssueFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "cycle" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "issues" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueConnectionFragmentDoc.definitions,
        ...IssueFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const Cycle_UncompletedIssuesUponCloseDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "cycle_uncompletedIssuesUponClose" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "IssueFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "cycle" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "uncompletedIssuesUponClose" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueConnectionFragmentDoc.definitions,
        ...IssueFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const CyclesDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "cycles" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "CycleFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "cycles" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "filter" },
                                value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CycleConnection" } }],
                        },
                    },
                ],
            },
        },
        ...CycleConnectionFragmentDoc.definitions,
        ...CycleFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const DocumentDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "document" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "document" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Document" } }],
                        },
                    },
                ],
            },
        },
        ...DocumentFragmentDoc.definitions,
    ],
};
const Document_CommentsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "document_comments" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "CommentFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "document" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "comments" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CommentConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...CommentConnectionFragmentDoc.definitions,
        ...CommentFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...DocumentContentFragmentDoc.definitions,
        ...SyncedExternalThreadFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const DocumentContentHistoryDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "documentContentHistory" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "documentContentHistory" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "DocumentContentHistoryPayload" } }],
                        },
                    },
                ],
            },
        },
        ...DocumentContentHistoryPayloadFragmentDoc.definitions,
        ...DocumentContentHistoryTypeFragmentDoc.definitions,
    ],
};
const DocumentsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "documents" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "DocumentFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "documents" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "filter" },
                                value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "DocumentConnection" } }],
                        },
                    },
                ],
            },
        },
        ...DocumentConnectionFragmentDoc.definitions,
        ...DocumentFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const EmojiDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "emoji" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "emoji" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Emoji" } }],
                        },
                    },
                ],
            },
        },
        ...EmojiFragmentDoc.definitions,
    ],
};
const EmojisDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "emojis" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "emojis" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "EmojiConnection" } }],
                        },
                    },
                ],
            },
        },
        ...EmojiConnectionFragmentDoc.definitions,
        ...EmojiFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const EntityExternalLinkDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "entityExternalLink" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "entityExternalLink" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "EntityExternalLink" } }],
                        },
                    },
                ],
            },
        },
        ...EntityExternalLinkFragmentDoc.definitions,
    ],
};
const ExternalUserDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "externalUser" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "externalUser" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ExternalUser" } }],
                        },
                    },
                ],
            },
        },
        ...ExternalUserFragmentDoc.definitions,
    ],
};
const ExternalUsersDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "externalUsers" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "externalUsers" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ExternalUserConnection" } }],
                        },
                    },
                ],
            },
        },
        ...ExternalUserConnectionFragmentDoc.definitions,
        ...ExternalUserFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const FavoriteDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "favorite" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "favorite" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Favorite" } }],
                        },
                    },
                ],
            },
        },
        ...FavoriteFragmentDoc.definitions,
    ],
};
const Favorite_ChildrenDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "favorite_children" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "favorite" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "children" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "FavoriteConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...FavoriteConnectionFragmentDoc.definitions,
        ...FavoriteFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const FavoritesDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "favorites" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "favorites" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "FavoriteConnection" } }],
                        },
                    },
                ],
            },
        },
        ...FavoriteConnectionFragmentDoc.definitions,
        ...FavoriteFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const InitiativeDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "initiative" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Initiative" } }],
                        },
                    },
                ],
            },
        },
        ...InitiativeFragmentDoc.definitions,
    ],
};
const Initiative_HistoryDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "initiative_history" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "history" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [
                                            { kind: "FragmentSpread", name: { kind: "Name", value: "InitiativeHistoryConnection" } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...InitiativeHistoryConnectionFragmentDoc.definitions,
        ...InitiativeHistoryFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const Initiative_LinksDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "initiative_links" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "links" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [
                                            { kind: "FragmentSpread", name: { kind: "Name", value: "EntityExternalLinkConnection" } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...EntityExternalLinkConnectionFragmentDoc.definitions,
        ...EntityExternalLinkFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const Initiative_ProjectsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "initiative_projects" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "ProjectFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiative" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "projects" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ProjectConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...ProjectConnectionFragmentDoc.definitions,
        ...ProjectFragmentDoc.definitions,
        ...DocumentContentFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const InitiativeRelationDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "initiativeRelation" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiativeRelation" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ProjectRelation" } }],
                        },
                    },
                ],
            },
        },
        ...ProjectRelationFragmentDoc.definitions,
    ],
};
const InitiativeRelationsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "initiativeRelations" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiativeRelations" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "InitiativeRelationConnection" } }],
                        },
                    },
                ],
            },
        },
        ...InitiativeRelationConnectionFragmentDoc.definitions,
        ...InitiativeRelationFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const InitiativeToProjectDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "initiativeToProject" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiativeToProject" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "InitiativeToProject" } }],
                        },
                    },
                ],
            },
        },
        ...InitiativeToProjectFragmentDoc.definitions,
    ],
};
const InitiativeToProjectsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "initiativeToProjects" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiativeToProjects" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "InitiativeToProjectConnection" } }],
                        },
                    },
                ],
            },
        },
        ...InitiativeToProjectConnectionFragmentDoc.definitions,
        ...InitiativeToProjectFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const InitiativeUpdateDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "initiativeUpdate" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiativeUpdate" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "InitiativeUpdate" } }],
                        },
                    },
                ],
            },
        },
        ...InitiativeUpdateFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
    ],
};
const InitiativeUpdate_CommentsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "initiativeUpdate_comments" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "CommentFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiativeUpdate" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "comments" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CommentConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...CommentConnectionFragmentDoc.definitions,
        ...CommentFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...DocumentContentFragmentDoc.definitions,
        ...SyncedExternalThreadFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const InitiativeUpdatesDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "initiativeUpdates" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "InitiativeUpdateFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiativeUpdates" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "filter" },
                                value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "InitiativeUpdateConnection" } }],
                        },
                    },
                ],
            },
        },
        ...InitiativeUpdateConnectionFragmentDoc.definitions,
        ...InitiativeUpdateFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const InitiativesDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "initiatives" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "InitiativeFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "initiatives" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "filter" },
                                value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "InitiativeConnection" } }],
                        },
                    },
                ],
            },
        },
        ...InitiativeConnectionFragmentDoc.definitions,
        ...InitiativeFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const IntegrationDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "integration" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integration" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Integration" } }],
                        },
                    },
                ],
            },
        },
        ...IntegrationFragmentDoc.definitions,
    ],
};
const IntegrationHasScopesDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "integrationHasScopes" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "integrationId" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "scopes" } },
                    type: {
                        kind: "NonNullType",
                        type: {
                            kind: "ListType",
                            type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                        },
                    },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integrationHasScopes" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "integrationId" },
                                value: { kind: "Variable", name: { kind: "Name", value: "integrationId" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "scopes" },
                                value: { kind: "Variable", name: { kind: "Name", value: "scopes" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IntegrationHasScopesPayload" } }],
                        },
                    },
                ],
            },
        },
        ...IntegrationHasScopesPayloadFragmentDoc.definitions,
    ],
};
const IntegrationTemplateDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "integrationTemplate" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integrationTemplate" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IntegrationTemplate" } }],
                        },
                    },
                ],
            },
        },
        ...IntegrationTemplateFragmentDoc.definitions,
    ],
};
const IntegrationTemplatesDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "integrationTemplates" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integrationTemplates" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IntegrationTemplateConnection" } }],
                        },
                    },
                ],
            },
        },
        ...IntegrationTemplateConnectionFragmentDoc.definitions,
        ...IntegrationTemplateFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const IntegrationsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "integrations" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integrations" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IntegrationConnection" } }],
                        },
                    },
                ],
            },
        },
        ...IntegrationConnectionFragmentDoc.definitions,
        ...IntegrationFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const IntegrationsSettingsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "integrationsSettings" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "integrationsSettings" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IntegrationsSettings" } }],
                        },
                    },
                ],
            },
        },
        ...IntegrationsSettingsFragmentDoc.definitions,
    ],
};
const IssueDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issue" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Issue" } }],
                        },
                    },
                ],
            },
        },
        ...IssueFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
    ],
};
const Issue_AttachmentsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issue_attachments" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "AttachmentFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "attachments" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "AttachmentConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...AttachmentConnectionFragmentDoc.definitions,
        ...AttachmentFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const Issue_BotActorDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issue_botActor" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "botActor" },
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ActorBot" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...ActorBotFragmentDoc.definitions,
    ],
};
const Issue_ChildrenDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issue_children" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "IssueFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "children" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueConnectionFragmentDoc.definitions,
        ...IssueFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const Issue_CommentsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issue_comments" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "CommentFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "comments" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CommentConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...CommentConnectionFragmentDoc.definitions,
        ...CommentFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...DocumentContentFragmentDoc.definitions,
        ...SyncedExternalThreadFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const Issue_HistoryDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issue_history" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "history" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueHistoryConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueHistoryConnectionFragmentDoc.definitions,
        ...IssueHistoryFragmentDoc.definitions,
        ...IssueRelationHistoryPayloadFragmentDoc.definitions,
        ...UserFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...IssueImportFragmentDoc.definitions,
        ...IssueLabelFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const Issue_InverseRelationsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issue_inverseRelations" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "inverseRelations" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueRelationConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueRelationConnectionFragmentDoc.definitions,
        ...IssueRelationFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const Issue_LabelsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issue_labels" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "IssueLabelFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "labels" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueLabelConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueLabelConnectionFragmentDoc.definitions,
        ...IssueLabelFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const Issue_NeedsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issue_needs" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "CustomerNeedFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "needs" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CustomerNeedConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...CustomerNeedConnectionFragmentDoc.definitions,
        ...CustomerNeedFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const Issue_RelationsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issue_relations" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "relations" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueRelationConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueRelationConnectionFragmentDoc.definitions,
        ...IssueRelationFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const Issue_SubscribersDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issue_subscribers" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "UserFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeDisabled" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issue" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "subscribers" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeDisabled" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeDisabled" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "UserConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...UserConnectionFragmentDoc.definitions,
        ...UserFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const IssueFigmaFileKeySearchDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueFigmaFileKeySearch" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "fileKey" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueFigmaFileKeySearch" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "fileKey" },
                                value: { kind: "Variable", name: { kind: "Name", value: "fileKey" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueConnection" } }],
                        },
                    },
                ],
            },
        },
        ...IssueConnectionFragmentDoc.definitions,
        ...IssueFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const IssueFilterSuggestionDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueFilterSuggestion" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "projectId" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "prompt" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueFilterSuggestion" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "projectId" },
                                value: { kind: "Variable", name: { kind: "Name", value: "projectId" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "prompt" },
                                value: { kind: "Variable", name: { kind: "Name", value: "prompt" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueFilterSuggestionPayload" } }],
                        },
                    },
                ],
            },
        },
        ...IssueFilterSuggestionPayloadFragmentDoc.definitions,
    ],
};
const IssueImportCheckCsvDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueImportCheckCSV" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "csvUrl" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "service" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueImportCheckCSV" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "csvUrl" },
                                value: { kind: "Variable", name: { kind: "Name", value: "csvUrl" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "service" },
                                value: { kind: "Variable", name: { kind: "Name", value: "service" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueImportCheckPayload" } }],
                        },
                    },
                ],
            },
        },
        ...IssueImportCheckPayloadFragmentDoc.definitions,
    ],
};
const IssueImportCheckSyncDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueImportCheckSync" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "issueImportId" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueImportCheckSync" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "issueImportId" },
                                value: { kind: "Variable", name: { kind: "Name", value: "issueImportId" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueImportSyncCheckPayload" } }],
                        },
                    },
                ],
            },
        },
        ...IssueImportSyncCheckPayloadFragmentDoc.definitions,
    ],
};
const IssueImportJqlCheckDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueImportJqlCheck" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "jiraEmail" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "jiraHostname" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "jiraProject" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "jiraToken" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "jql" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueImportJqlCheck" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "jiraEmail" },
                                value: { kind: "Variable", name: { kind: "Name", value: "jiraEmail" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "jiraHostname" },
                                value: { kind: "Variable", name: { kind: "Name", value: "jiraHostname" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "jiraProject" },
                                value: { kind: "Variable", name: { kind: "Name", value: "jiraProject" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "jiraToken" },
                                value: { kind: "Variable", name: { kind: "Name", value: "jiraToken" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "jql" },
                                value: { kind: "Variable", name: { kind: "Name", value: "jql" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueImportJqlCheckPayload" } }],
                        },
                    },
                ],
            },
        },
        ...IssueImportJqlCheckPayloadFragmentDoc.definitions,
    ],
};
const IssueLabelDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueLabel" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueLabel" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueLabel" } }],
                        },
                    },
                ],
            },
        },
        ...IssueLabelFragmentDoc.definitions,
    ],
};
const IssueLabel_ChildrenDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueLabel_children" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "IssueLabelFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueLabel" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "children" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueLabelConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueLabelConnectionFragmentDoc.definitions,
        ...IssueLabelFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const IssueLabel_IssuesDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueLabel_issues" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "IssueFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueLabel" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "issues" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueConnectionFragmentDoc.definitions,
        ...IssueFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const IssueLabelsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueLabels" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "IssueLabelFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueLabels" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "filter" },
                                value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueLabelConnection" } }],
                        },
                    },
                ],
            },
        },
        ...IssueLabelConnectionFragmentDoc.definitions,
        ...IssueLabelFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const IssuePriorityValuesDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issuePriorityValues" },
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issuePriorityValues" },
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssuePriorityValue" } }],
                        },
                    },
                ],
            },
        },
        ...IssuePriorityValueFragmentDoc.definitions,
    ],
};
const IssueRelationDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueRelation" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueRelation" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueRelation" } }],
                        },
                    },
                ],
            },
        },
        ...IssueRelationFragmentDoc.definitions,
    ],
};
const IssueRelationsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueRelations" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueRelations" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueRelationConnection" } }],
                        },
                    },
                ],
            },
        },
        ...IssueRelationConnectionFragmentDoc.definitions,
        ...IssueRelationFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const IssueSearchDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueSearch" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "IssueFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "query" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueSearch" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "filter" },
                                value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "query" },
                                value: { kind: "Variable", name: { kind: "Name", value: "query" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueConnection" } }],
                        },
                    },
                ],
            },
        },
        ...IssueConnectionFragmentDoc.definitions,
        ...IssueFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const IssueTitleSuggestionFromCustomerRequestDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueTitleSuggestionFromCustomerRequest" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "request" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueTitleSuggestionFromCustomerRequest" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "request" },
                                value: { kind: "Variable", name: { kind: "Name", value: "request" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "FragmentSpread",
                                    name: { kind: "Name", value: "IssueTitleSuggestionFromCustomerRequestPayload" },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueTitleSuggestionFromCustomerRequestPayloadFragmentDoc.definitions,
    ],
};
const IssueVcsBranchSearchDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueVcsBranchSearch" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueVcsBranchSearch" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "branchName" },
                                value: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Issue" } }],
                        },
                    },
                ],
            },
        },
        ...IssueFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
    ],
};
const IssueVcsBranchSearch_AttachmentsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueVcsBranchSearch_attachments" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "AttachmentFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueVcsBranchSearch" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "branchName" },
                                value: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "attachments" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "AttachmentConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...AttachmentConnectionFragmentDoc.definitions,
        ...AttachmentFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const IssueVcsBranchSearch_BotActorDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueVcsBranchSearch_botActor" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueVcsBranchSearch" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "branchName" },
                                value: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "botActor" },
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "ActorBot" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...ActorBotFragmentDoc.definitions,
    ],
};
const IssueVcsBranchSearch_ChildrenDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueVcsBranchSearch_children" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "IssueFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueVcsBranchSearch" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "branchName" },
                                value: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "children" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueConnectionFragmentDoc.definitions,
        ...IssueFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const IssueVcsBranchSearch_CommentsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueVcsBranchSearch_comments" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "CommentFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueVcsBranchSearch" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "branchName" },
                                value: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "comments" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CommentConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...CommentConnectionFragmentDoc.definitions,
        ...CommentFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...DocumentContentFragmentDoc.definitions,
        ...SyncedExternalThreadFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const IssueVcsBranchSearch_HistoryDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueVcsBranchSearch_history" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueVcsBranchSearch" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "branchName" },
                                value: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "history" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueHistoryConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueHistoryConnectionFragmentDoc.definitions,
        ...IssueHistoryFragmentDoc.definitions,
        ...IssueRelationHistoryPayloadFragmentDoc.definitions,
        ...UserFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...IssueImportFragmentDoc.definitions,
        ...IssueLabelFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const IssueVcsBranchSearch_InverseRelationsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueVcsBranchSearch_inverseRelations" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueVcsBranchSearch" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "branchName" },
                                value: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "inverseRelations" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueRelationConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueRelationConnectionFragmentDoc.definitions,
        ...IssueRelationFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const IssueVcsBranchSearch_LabelsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueVcsBranchSearch_labels" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "IssueLabelFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueVcsBranchSearch" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "branchName" },
                                value: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "labels" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueLabelConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueLabelConnectionFragmentDoc.definitions,
        ...IssueLabelFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const IssueVcsBranchSearch_NeedsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueVcsBranchSearch_needs" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "CustomerNeedFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueVcsBranchSearch" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "branchName" },
                                value: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "needs" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "CustomerNeedConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...CustomerNeedConnectionFragmentDoc.definitions,
        ...CustomerNeedFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const IssueVcsBranchSearch_RelationsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueVcsBranchSearch_relations" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueVcsBranchSearch" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "branchName" },
                                value: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "relations" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueRelationConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...IssueRelationConnectionFragmentDoc.definitions,
        ...IssueRelationFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const IssueVcsBranchSearch_SubscribersDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issueVcsBranchSearch_subscribers" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "UserFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeDisabled" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issueVcsBranchSearch" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "branchName" },
                                value: { kind: "Variable", name: { kind: "Name", value: "branchName" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                {
                                    kind: "Field",
                                    name: { kind: "Name", value: "subscribers" },
                                    arguments: [
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "after" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "before" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "filter" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "first" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeArchived" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "includeDisabled" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "includeDisabled" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "last" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                                        },
                                        {
                                            kind: "Argument",
                                            name: { kind: "Name", value: "orderBy" },
                                            value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: "SelectionSet",
                                        selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "UserConnection" } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        ...UserConnectionFragmentDoc.definitions,
        ...UserFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const IssuesDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "issues" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "IssueFilter" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "sort" } },
                    type: {
                        kind: "ListType",
                        type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "IssueSortInput" } } },
                    },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "issues" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "filter" },
                                value: { kind: "Variable", name: { kind: "Name", value: "filter" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "sort" },
                                value: { kind: "Variable", name: { kind: "Name", value: "sort" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "IssueConnection" } }],
                        },
                    },
                ],
            },
        },
        ...IssueConnectionFragmentDoc.definitions,
        ...IssueFragmentDoc.definitions,
        ...ReactionFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...PageInfoFragmentDoc.definitions,
    ],
};
const NotificationDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "notification" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "notification" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "Notification" } }],
                        },
                    },
                ],
            },
        },
        ...NotificationFragmentDoc.definitions,
        ...ActorBotFragmentDoc.definitions,
        ...DocumentNotificationFragmentDoc.definitions,
        ...InitiativeNotificationFragmentDoc.definitions,
        ...IssueNotificationFragmentDoc.definitions,
        ...NotificationSubscriptionFragmentDoc.definitions,
        ...OauthClientApprovalNotificationFragmentDoc.definitions,
        ...OauthClientApprovalFragmentDoc.definitions,
        ...ProjectNotificationFragmentDoc.definitions,
    ],
};
const NotificationSubscriptionDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "notificationSubscription" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "id" } },
                    type: { kind: "NonNullType", type: { kind: "NamedType", name: { kind: "Name", value: "String" } } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "notificationSubscription" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "id" },
                                value: { kind: "Variable", name: { kind: "Name", value: "id" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [{ kind: "FragmentSpread", name: { kind: "Name", value: "NotificationSubscription" } }],
                        },
                    },
                ],
            },
        },
        ...NotificationSubscriptionFragmentDoc.definitions,
    ],
};
const NotificationSubscriptionsDocument = {
    kind: "Document",
    definitions: [
        {
            kind: "OperationDefinition",
            operation: "query",
            name: { kind: "Name", value: "notificationSubscriptions" },
            variableDefinitions: [
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "after" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "before" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "String" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "first" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Boolean" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "last" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "Int" } },
                },
                {
                    kind: "VariableDefinition",
                    variable: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                    type: { kind: "NamedType", name: { kind: "Name", value: "PaginationOrderBy" } },
                },
            ],
            selectionSet: {
                kind: "SelectionSet",
                selections: [
                    {
                        kind: "Field",
                        name: { kind: "Name", value: "notificationSubscriptions" },
                        arguments: [
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "after" },
                                value: { kind: "Variable", name: { kind: "Name", value: "after" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "before" },
                                value: { kind: "Variable", name: { kind: "Name", value: "before" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "first" },
                                value: { kind: "Variable", name: { kind: "Name", value: "first" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "includeArchived" },
                                value: { kind: "Variable", name: { kind: "Name", value: "includeArchived" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "last" },
                                value: { kind: "Variable", name: { kind: "Name", value: "last" } },
                            },
                            {
                                kind: "Argument",
                                name: { kind: "Name", value: "orderBy" },
                                value: { kind: "Variable", name: { kind: "Name", value: "orderBy" } },
                            },
                        ],
                        selectionSet: {
                            kind: "SelectionSet",
                            selections: [
                                { kind: "FragmentSpread", name: { kind: "Name", value: "NotificationSubscriptionConnection" } },
                            ],
   