import type { Octokit } from "@octokit/core";
import type { App } from "./index.js";
import type { EachInstallationFunction, EachInstallationInterface } from "./types.js";
export declare function eachInstallationFactory(app: App): EachInstallationInterface<Octokit>;
export declare function eachInstallation(app: App, callback: EachInstallationFunction<Octokit>): Promise<void>;
export declare function eachInstallationIterator(app: App): {
    [Symbol.asyncIterator](): AsyncGenerator<{
        octokit: Octokit;
        installation: {
            id: number;
            account: ({
                name?: string | null | undefined;
                email?: string | null | undefined;
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string | null;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
                starred_at?: string | undefined;
            } & {
                description?: string | null | undefined;
                html_url: string;
                website_url?: string | null | undefined;
                id: number;
                node_id: string;
                name: string;
                slug: string;
                created_at: string | null;
                updated_at: string | null;
                avatar_url: string;
            }) | null;
            repository_selection: "all" | "selected";
            access_tokens_url: string;
            repositories_url: string;
            html_url: string;
            app_id: number;
            target_id: number;
            target_type: string;
            permissions: {
                actions?: "write" | "read" | undefined;
                administration?: "write" | "read" | undefined;
                checks?: "write" | "read" | undefined;
                contents?: "write" | "read" | undefined;
                deployments?: "write" | "read" | undefined;
                environments?: "write" | "read" | undefined;
                issues?: "write" | "read" | undefined;
                metadata?: "write" | "read" | undefined;
                packages?: "write" | "read" | undefined;
                pages?: "write" | "read" | undefined;
                pull_requests?: "write" | "read" | undefined;
                repository_hooks?: "write" | "read" | undefined;
                repository_projects?: "write" | "read" | "admin" | undefined;
                secret_scanning_alerts?: "write" | "read" | undefined;
                secrets?: "write" | "read" | undefined;
                security_events?: "write" | "read" | undefined;
                single_file?: "write" | "read" | undefined;
                statuses?: "write" | "read" | undefined;
                vulnerability_alerts?: "write" | "read" | undefined;
                workflows?: "write" | undefined;
                members?: "write" | "read" | undefined;
                organization_administration?: "write" | "read" | undefined;
                organization_custom_roles?: "write" | "read" | undefined;
                organization_announcement_banners?: "write" | "read" | undefined;
                organization_hooks?: "write" | "read" | undefined;
                organization_personal_access_tokens?: "write" | "read" | undefined;
                organization_personal_access_token_requests?: "write" | "read" | undefined;
                organization_plan?: "read" | undefined;
                organization_projects?: "write" | "read" | "admin" | undefined;
                organization_packages?: "write" | "read" | undefined;
                organization_secrets?: "write" | "read" | undefined;
                organization_self_hosted_runners?: "write" | "read" | undefined;
                organization_user_blocking?: "write" | "read" | undefined;
                team_discussions?: "write" | "read" | undefined;
            };
            events: string[];
            created_at: string;
            updated_at: string;
            single_file_name: string | null;
            has_multiple_single_files?: boolean | undefined;
            single_file_paths?: string[] | undefined;
            app_slug: string;
            suspended_by: {
                name?: string | null | undefined;
                email?: string | null | undefined;
                login: string;
                id: number;
                node_id: string;
                avatar_url: string;
                gravatar_id: string | null;
                url: string;
                html_url: string;
                followers_url: string;
                following_url: string;
                gists_url: string;
                starred_url: string;
                subscriptions_url: string;
                organizations_url: string;
                repos_url: string;
                events_url: string;
                received_events_url: string;
                type: string;
                site_admin: boolean;
                starred_at?: string | undefined;
            } | null;
            suspended_at: string | null;
            contact_email?: string | null | undefined;
        };
    }, void, unknown>;
};
