/* eslint-disable */
/**
 * This file was automatically generated by json-schema-to-typescript.
 * DO NOT MODIFY IT BY HAND. Instead, modify the source JSONSchema file,
 * and run json-schema-to-typescript to regenerate this file.
 */

export type Schema =
  | BranchProtectionConfigurationEvent
  | BranchProtectionRuleEvent
  | CheckRunEvent
  | CheckSuiteEvent
  | CodeScanningAlertEvent
  | CommitCommentEvent
  | CreateEvent
  | CustomPropertyEvent
  | CustomPropertyValuesEvent
  | DeleteEvent
  | DependabotAlertEvent
  | DeployKeyEvent
  | DeploymentEvent
  | DeploymentProtectionRuleEvent
  | DeploymentReviewEvent
  | DeploymentStatusEvent
  | DiscussionEvent
  | DiscussionCommentEvent
  | ForkEvent
  | GithubAppAuthorizationEvent
  | GollumEvent
  | InstallationEvent
  | InstallationRepositoriesEvent
  | InstallationTargetEvent
  | IssueCommentEvent
  | IssuesEvent
  | LabelEvent
  | MarketplacePurchaseEvent
  | MemberEvent
  | MembershipEvent
  | MergeGroupEvent
  | MetaEvent
  | MilestoneEvent
  | OrgBlockEvent
  | OrganizationEvent
  | PackageEvent
  | PageBuildEvent
  | PingEvent
  | ProjectEvent
  | ProjectCardEvent
  | ProjectColumnEvent
  | ProjectsV2ItemEvent
  | PublicEvent
  | PullRequestEvent
  | PullRequestReviewEvent
  | PullRequestReviewCommentEvent
  | PullRequestReviewThreadEvent
  | PushEvent
  | RegistryPackageEvent
  | ReleaseEvent
  | RepositoryEvent
  | RepositoryDispatchEvent
  | RepositoryImportEvent
  | RepositoryVulnerabilityAlertEvent
  | SecretScanningAlertEvent
  | SecretScanningAlertLocationEvent
  | SecurityAdvisoryEvent
  | SponsorshipEvent
  | StarEvent
  | StatusEvent
  | TeamEvent
  | TeamAddEvent
  | WatchEvent
  | WorkflowDispatchEvent
  | WorkflowJobEvent
  | WorkflowRunEvent;
export type BranchProtectionConfigurationEvent =
  | BranchProtectionConfigurationDisabledEvent
  | BranchProtectionConfigurationEnabledEvent;
export type BranchProtectionRuleEvent =
  | BranchProtectionRuleCreatedEvent
  | BranchProtectionRuleDeletedEvent
  | BranchProtectionRuleEditedEvent;
export type BranchProtectionRuleEnforcementLevel =
  | "off"
  | "non_admins"
  | "everyone";
export type BranchProtectionRuleNumber = number;
export type BranchProtectionRuleBoolean = boolean;
export type BranchProtectionRuleArray = string[];
export type CheckRunEvent =
  | CheckRunCompletedEvent
  | CheckRunCreatedEvent
  | CheckRunRequestedActionEvent
  | CheckRunRerequestedEvent;
export type CheckSuiteEvent =
  | CheckSuiteCompletedEvent
  | CheckSuiteRequestedEvent
  | CheckSuiteRerequestedEvent;
export type CodeScanningAlertEvent =
  | CodeScanningAlertAppearedInBranchEvent
  | CodeScanningAlertClosedByUserEvent
  | CodeScanningAlertCreatedEvent
  | CodeScanningAlertFixedEvent
  | CodeScanningAlertReopenedEvent
  | CodeScanningAlertReopenedByUserEvent;
export type CommitCommentEvent = CommitCommentCreatedEvent;
/**
 * How the author is associated with the repository.
 */
export type AuthorAssociation =
  | "COLLABORATOR"
  | "CONTRIBUTOR"
  | "FIRST_TIMER"
  | "FIRST_TIME_CONTRIBUTOR"
  | "MANNEQUIN"
  | "MEMBER"
  | "NONE"
  | "OWNER";
export type CustomPropertyEvent =
  | CustomPropertyCreatedEvent
  | CustomPropertyDeletedEvent;
export type CustomPropertyValuesEvent = CustomPropertyValuesUpdatedEvent;
export type DependabotAlertEvent =
  | DependabotAlertCreatedEvent
  | DependabotAlertDismissedEvent
  | DependabotAlertFixedEvent
  | DependabotAlertReintroducedEvent
  | DependabotAlertReopenedEvent;
export type DeployKeyEvent = DeployKeyCreatedEvent | DeployKeyDeletedEvent;
export type DeploymentEvent = DeploymentCreatedEvent;
export type DeploymentProtectionRuleEvent =
  DeploymentProtectionRuleRequestedEvent;
export type DeploymentReviewEvent =
  | DeploymentReviewApprovedEvent
  | DeploymentReviewRejectedEvent
  | DeploymentReviewRequestedEvent;
export type DeploymentStatusEvent = DeploymentStatusCreatedEvent;
export type DiscussionEvent =
  | DiscussionAnsweredEvent
  | DiscussionCategoryChangedEvent
  | DiscussionCreatedEvent
  | DiscussionDeletedEvent
  | DiscussionEditedEvent
  | DiscussionLabeledEvent
  | DiscussionLockedEvent
  | DiscussionPinnedEvent
  | DiscussionTransferredEvent
  | DiscussionUnansweredEvent
  | DiscussionUnlabeledEvent
  | DiscussionUnlockedEvent
  | DiscussionUnpinnedEvent;
export type DiscussionCommentEvent =
  | DiscussionCommentCreatedEvent
  | DiscussionCommentDeletedEvent
  | DiscussionCommentEditedEvent;
export type GithubAppAuthorizationEvent = GithubAppAuthorizationRevokedEvent;
export type InstallationEvent =
  | InstallationCreatedEvent
  | InstallationDeletedEvent
  | InstallationNewPermissionsAcceptedEvent
  | InstallationSuspendEvent
  | InstallationUnsuspendEvent;
export type InstallationRepositoriesEvent =
  | InstallationRepositoriesAddedEvent
  | InstallationRepositoriesRemovedEvent;
export type InstallationTargetEvent = InstallationTargetRenamedEvent;
export type IssueCommentEvent =
  | IssueCommentCreatedEvent
  | IssueCommentDeletedEvent
  | IssueCommentEditedEvent;
export type IssuesEvent =
  | IssuesAssignedEvent
  | IssuesClosedEvent
  | IssuesDeletedEvent
  | IssuesDemilestonedEvent
  | IssuesEditedEvent
  | IssuesLabeledEvent
  | IssuesLockedEvent
  | IssuesMilestonedEvent
  | IssuesOpenedEvent
  | IssuesPinnedEvent
  | IssuesReopenedEvent
  | IssuesTransferredEvent
  | IssuesUnassignedEvent
  | IssuesUnlabeledEvent
  | IssuesUnlockedEvent
  | IssuesUnpinnedEvent;
export type LabelEvent =
  | LabelCreatedEvent
  | LabelDeletedEvent
  | LabelEditedEvent;
export type MarketplacePurchaseEvent =
  | MarketplacePurchaseCancelledEvent
  | MarketplacePurchaseChangedEvent
  | MarketplacePurchasePendingChangeEvent
  | MarketplacePurchasePendingChangeCancelledEvent
  | MarketplacePurchasePurchasedEvent;
export type MemberEvent =
  | MemberAddedEvent
  | MemberEditedEvent
  | MemberRemovedEvent;
export type MembershipEvent = MembershipAddedEvent | MembershipRemovedEvent;
export type MergeGroupEvent =
  | MergeGroupChecksRequestedEvent
  | MergeGroupDestroyedEvent;
export type MetaEvent = MetaDeletedEvent;
export type WebhookEvents =
  | (
      | "branch_protection_rule"
      | "check_run"
      | "check_suite"
      | "code_scanning_alert"
      | "commit_comment"
      | "create"
      | "delete"
      | "deployment"
      | "deployment_status"
      | "deploy_key"
      | "discussion"
      | "discussion_comment"
      | "fork"
      | "gollum"
      | "issues"
      | "issue_comment"
      | "label"
      | "member"
      | "membership"
      | "meta"
      | "milestone"
      | "organization"
      | "org_block"
      | "package"
      | "page_build"
      | "project"
      | "projects_v2_item"
      | "project_card"
      | "project_column"
      | "public"
      | "pull_request"
      | "pull_request_review"
      | "pull_request_review_comment"
      | "pull_request_review_thread"
      | "push"
      | "registry_package"
      | "release"
      | "repository"
      | "repository_import"
      | "repository_vulnerability_alert"
      | "secret_scanning_alert"
      | "secret_scanning_alert_location"
      | "security_and_analysis"
      | "star"
      | "status"
      | "team"
      | "team_add"
      | "watch"
      | "workflow_job"
      | "workflow_run"
    )[]
  | ["*"];
export type MilestoneEvent =
  | MilestoneClosedEvent
  | MilestoneCreatedEvent
  | MilestoneDeletedEvent
  | MilestoneEditedEvent
  | MilestoneOpenedEvent;
export type OrgBlockEvent = OrgBlockBlockedEvent | OrgBlockUnblockedEvent;
export type OrganizationEvent =
  | OrganizationDeletedEvent
  | OrganizationMemberAddedEvent
  | OrganizationMemberInvitedEvent
  | OrganizationMemberRemovedEvent
  | OrganizationRenamedEvent;
export type PackageEvent = PackagePublishedEvent | PackageUpdatedEvent;
export type ProjectEvent =
  | ProjectClosedEvent
  | ProjectCreatedEvent
  | ProjectDeletedEvent
  | ProjectEditedEvent
  | ProjectReopenedEvent;
export type ProjectCardEvent =
  | ProjectCardConvertedEvent
  | ProjectCardCreatedEvent
  | ProjectCardDeletedEvent
  | ProjectCardEditedEvent
  | ProjectCardMovedEvent;
export type ProjectColumnEvent =
  | ProjectColumnCreatedEvent
  | ProjectColumnDeletedEvent
  | ProjectColumnEditedEvent
  | ProjectColumnMovedEvent;
export type ProjectsV2ItemEvent =
  | ProjectsV2ItemArchivedEvent
  | ProjectsV2ItemConvertedEvent
  | ProjectsV2ItemCreatedEvent
  | ProjectsV2ItemDeletedEvent
  | ProjectsV2ItemEditedEvent
  | ProjectsV2ItemReorderedEvent
  | ProjectsV2ItemRestoredEvent;
export type PullRequestEvent =
  | PullRequestAssignedEvent
  | PullRequestAutoMergeDisabledEvent
  | PullRequestAutoMergeEnabledEvent
  | PullRequestClosedEvent
  | PullRequestConvertedToDraftEvent
  | PullRequestDemilestonedEvent
  | PullRequestDequeuedEvent
  | PullRequestEditedEvent
  | PullRequestEnqueuedEvent
  | PullRequestLabeledEvent
  | PullRequestLockedEvent
  | PullRequestMilestonedEvent
  | PullRequestOpenedEvent
  | PullRequestReadyForReviewEvent
  | PullRequestReopenedEvent
  | PullRequestReviewRequestRemovedEvent
  | PullRequestReviewRequestedEvent
  | PullRequestSynchronizeEvent
  | PullRequestUnassignedEvent
  | PullRequestUnlabeledEvent
  | PullRequestUnlockedEvent;
export type PullRequestReviewRequestRemovedEvent =
  | {
      action: "review_request_removed";
      /**
       * The pull request number.
       */
      number: number;
      pull_request: PullRequest;
      requested_reviewer: User;
      repository: Repository;
      installation?: InstallationLite;
      organization?: Organization;
      sender: User;
    }
  | {
      action: "review_request_removed";
      /**
       * The pull request number.
       */
      number: number;
      pull_request: PullRequest;
      requested_team: Team;
      repository: Repository;
      installation?: InstallationLite;
      organization?: Organization;
      sender: User;
    };
export type PullRequestReviewRequestedEvent =
  | {
      action: "review_requested";
      /**
       * The pull request number.
       */
      number: number;
      pull_request: PullRequest;
      requested_reviewer: User;
      repository: Repository;
      installation?: InstallationLite;
      organization?: Organization;
      sender: User;
    }
  | {
      action: "review_requested";
      /**
       * The pull request number.
       */
      number: number;
      pull_request: PullRequest;
      requested_team: Team;
      repository: Repository;
      installation?: InstallationLite;
      organization?: Organization;
      sender: User;
    };
export type PullRequestReviewEvent =
  | PullRequestReviewDismissedEvent
  | PullRequestReviewEditedEvent
  | PullRequestReviewSubmittedEvent;
export type PullRequestReviewCommentEvent =
  | PullRequestReviewCommentCreatedEvent
  | PullRequestReviewCommentDeletedEvent
  | PullRequestReviewCommentEditedEvent;
export type PullRequestReviewThreadEvent =
  | PullRequestReviewThreadResolvedEvent
  | PullRequestReviewThreadUnresolvedEvent;
export type RegistryPackageEvent =
  | RegistryPackagePublishedEvent
  | RegistryPackageUpdatedEvent;
export type ReleaseEvent =
  | ReleaseCreatedEvent
  | ReleaseDeletedEvent
  | ReleaseEditedEvent
  | ReleasePrereleasedEvent
  | ReleasePublishedEvent
  | ReleaseReleasedEvent
  | ReleaseUnpublishedEvent;
export type RepositoryEvent =
  | RepositoryArchivedEvent
  | RepositoryCreatedEvent
  | RepositoryDeletedEvent
  | RepositoryEditedEvent
  | RepositoryPrivatizedEvent
  | RepositoryPublicizedEvent
  | RepositoryRenamedEvent
  | RepositoryTransferredEvent
  | RepositoryUnarchivedEvent;
export type RepositoryVulnerabilityAlertEvent =
  | RepositoryVulnerabilityAlertCreateEvent
  | RepositoryVulnerabilityAlertDismissEvent
  | RepositoryVulnerabilityAlertReopenEvent
  | RepositoryVulnerabilityAlertResolveEvent;
export type SecretScanningAlertEvent =
  | SecretScanningAlertCreatedEvent
  | SecretScanningAlertReopenedEvent
  | SecretScanningAlertResolvedEvent
  | SecretScanningAlertRevokedEvent;
export type SecretScanningAlertLocationEvent =
  SecretScanningAlertLocationCreatedEvent;
export type SecretScanningLocation =
  | {
      /**
       * The location type. Because secrets may be found in different types of resources (ie. code, comments, issues), this field identifies the type of resource where the secret was found.
       */
      type: "commit";
      details: SecretScanningLocationCommit;
    }
  | {
      /**
       * The location type. Because secrets may be found in different types of resources (ie. code, comments, issues), this field identifies the type of resource where the secret was found.
       */
      type: "issue_title";
      details: SecretScanningLocationIssueTitle;
    }
  | {
      /**
       * The location type. Because secrets may be found in different types of resources (ie. code, comments, issues), this field identifies the type of resource where the secret was found.
       */
      type: "issue_body";
      details: SecretScanningLocationIssueBody;
    }
  | {
      /**
       * The location type. Because secrets may be found in different types of resources (ie. code, comments, issues), this field identifies the type of resource where the secret was found.
       */
      type: "issue_comment";
      details: SecretScanningLocationIssueComment;
    };
export type SecurityAdvisoryEvent =
  | SecurityAdvisoryPerformedEvent
  | SecurityAdvisoryPublishedEvent
  | SecurityAdvisoryUpdatedEvent
  | SecurityAdvisoryWithdrawnEvent;
export type SponsorshipEvent =
  | SponsorshipCancelledEvent
  | SponsorshipCreatedEvent
  | SponsorshipEditedEvent
  | SponsorshipPendingCancellationEvent
  | SponsorshipPendingTierChangeEvent
  | SponsorshipTierChangedEvent;
export type StarEvent = StarCreatedEvent | StarDeletedEvent;
export type TeamEvent =
  | TeamAddedToRepositoryEvent
  | TeamCreatedEvent
  | TeamDeletedEvent
  | TeamEditedEvent
  | TeamRemovedFromRepositoryEvent;
export type WatchEvent = WatchStartedEvent;
export type WorkflowJobEvent =
  | WorkflowJobCompletedEvent
  | WorkflowJobInProgressEvent
  | WorkflowJobQueuedEvent
  | WorkflowJobWaitingEvent;
export type WorkflowStep =
  | WorkflowStepInProgress
  | WorkflowStepQueued
  | WorkflowStepCompleted;
export type WorkflowRunEvent =
  | WorkflowRunCompletedEvent
  | WorkflowRunInProgressEvent
  | WorkflowRunRequestedEvent;

export interface BranchProtectionConfigurationDisabledEvent {
  action: "disabled";
  installation?: InstallationLite;
  organization?: Organization;
  repository: Repository;
  sender: User;
}
/**
 * Installation
 */
export interface InstallationLite {
  /**
   * The ID of the installation.
   */
  id: number;
  node_id: string;
}
export interface Organization {
  login: string;
  id: number;
  node_id: string;
  url: string;
  html_url?: string;
  repos_url: string;
  events_url: string;
  hooks_url: string;
  issues_url: string;
  members_url: string;
  public_members_url: string;
  avatar_url: string;
  description: string | null;
}
/**
 * A git repository
 */
export interface Repository {
  /**
   * Unique identifier of the repository
   */
  id: number;
  /**
   * The GraphQL identifier of the repository.
   */
  node_id: string;
  /**
   * The name of the repository.
   */
  name: string;
  /**
   * The full, globally unique, name of the repository.
   */
  full_name: string;
  /**
   * Whether the repository is private or public.
   */
  private: boolean;
  owner: User;
  /**
   * The URL to view the repository on GitHub.com.
   */
  html_url: string;
  /**
   * The repository description.
   */
  description: string | null;
  /**
   * Whether the repository is a fork.
   */
  fork: boolean;
  /**
   * The URL to get more information about the repository from the GitHub API.
   */
  url: string;
  /**
   * The API URL to list the forks of the repository.
   */
  forks_url: string;
  /**
   * A template for the API URL to get information about deploy keys on the repository.
   */
  keys_url: string;
  /**
   * A template for the API URL to get information about collaborators of the repository.
   */
  collaborators_url: string;
  /**
   * The API URL to list the teams on the repository.
   */
  teams_url: string;
  /**
   * The API URL to list the hooks on the repository.
   */
  hooks_url: string;
  /**
   * A template for the API URL to get information about issue events on the repository.
   */
  issue_events_url: string;
  /**
   * The API URL to list the events of the repository.
   */
  events_url: string;
  /**
   * A template for the API URL to list the available assignees for issues in the repository.
   */
  assignees_url: string;
  /**
   * A template for the API URL to get information about branches in the repository.
   */
  branches_url: string;
  /**
   * The API URL to get information about tags on the repository.
   */
  tags_url: string;
  /**
   * A template for the API URL to create or retrieve a raw Git blob in the repository.
   */
  blobs_url: string;
  /**
   * A template for the API URL to get information about Git tags of the repository.
   */
  git_tags_url: string;
  /**
   * A template for the API URL to get information about Git refs of the repository.
   */
  git_refs_url: string;
  /**
   * A template for the API URL to create or retrieve a raw Git tree of the repository.
   */
  trees_url: string;
  /**
   * A template for the API URL to get information about statuses of a commit.
   */
  statuses_url: string;
  /**
   * The API URL to get information about the languages of the repository.
   */
  languages_url: string;
  /**
   * The API URL to list the stargazers on the repository.
   */
  stargazers_url: string;
  /**
   * A template for the API URL to list the contributors to the repository.
   */
  contributors_url: string;
  /**
   * The API URL to list the subscribers on the repository.
   */
  subscribers_url: string;
  /**
   * The API URL to subscribe to notifications for this repository.
   */
  subscription_url: string;
  /**
   * A template for the API URL to get information about commits on the repository.
   */
  commits_url: string;
  /**
   * A template for the API URL to get information about Git commits of the repository.
   */
  git_commits_url: string;
  /**
   * A template for the API URL to get information about comments on the repository.
   */
  comments_url: string;
  /**
   * A template for the API URL to get information about issue comments on the repository.
   */
  issue_comment_url: string;
  /**
   * A template for the API URL to get the contents of the repository.
   */
  contents_url: string;
  /**
   * A template for the API URL to compare two commits or refs.
   */
  compare_url: string;
  /**
   * The API URL to merge branches in the repository.
   */
  merges_url: string;
  /**
   * A template for the API URL to download the repository as an archive.
   */
  archive_url: string;
  /**
   * The API URL to list the downloads on the repository.
   */
  downloads_url: string;
  /**
   * A template for the API URL to get information about issues on the repository.
   */
  issues_url: string;
  /**
   * A template for the API URL to get information about pull requests on the repository.
   */
  pulls_url: string;
  /**
   * A template for the API URL to get information about milestones of the repository.
   */
  milestones_url: string;
  /**
   * A template for the API URL to get information about notifications on the repository.
   */
  notifications_url: string;
  /**
   * A template for the API URL to get information about labels of the repository.
   */
  labels_url: string;
  /**
   * A template for the API URL to get information about releases on the repository.
   */
  releases_url: string;
  /**
   * The API URL to list the deployments of the repository.
   */
  deployments_url: string;
  created_at: number | string;
  updated_at: string;
  pushed_at: number | string | null;
  git_url: string;
  ssh_url: string;
  clone_url: string;
  svn_url: string;
  homepage: string | null;
  size: number;
  stargazers_count: number;
  watchers_count: number;
  language: string | null;
  /**
   * Whether issues are enabled.
   */
  has_issues: boolean;
  /**
   * Whether projects are enabled.
   */
  has_projects: boolean;
  /**
   * Whether downloads are enabled.
   */
  has_downloads: boolean;
  /**
   * Whether the wiki is enabled.
   */
  has_wiki: boolean;
  has_pages: boolean;
  /**
   * Whether discussions are enabled.
   */
  has_discussions?: boolean;
  forks_count: number;
  mirror_url: string | null;
  /**
   * Whether the repository is archived.
   */
  archived: boolean;
  /**
   * Returns whether or not this repository is disabled.
   */
  disabled?: boolean;
  open_issues_count: number;
  license: License | null;
  forks: number;
  open_issues: number;
  watchers: number;
  stargazers?: number;
  /**
   * The default branch of the repository.
   */
  default_branch: string;
  /**
   * Whether to allow squash merges for pull requests.
   */
  allow_squash_merge?: boolean;
  /**
   * Whether to allow merge commits for pull requests.
   */
  allow_merge_commit?: boolean;
  /**
   * Whether to allow rebase merges for pull requests.
   */
  allow_rebase_merge?: boolean;
  /**
   * Whether to allow auto-merge for pull requests.
   */
  allow_auto_merge?: boolean;
  /**
   * Whether to allow private forks
   */
  allow_forking?: boolean;
  allow_update_branch?: boolean;
  use_squash_pr_title_as_default?: boolean;
  squash_merge_commit_message?: string;
  squash_merge_commit_title?: string;
  merge_commit_message?: string;
  merge_commit_title?: string;
  is_template: boolean;
  web_commit_signoff_required: boolean;
  topics: string[];
  visibility: "public" | "private" | "internal";
  /**
   * Whether to delete head branches when pull requests are merged
   */
  delete_branch_on_merge?: boolean;
  master_branch?: string;
  permissions?: {
    pull: boolean;
    push: boolean;
    admin: boolean;
    maintain?: boolean;
    triage?: boolean;
  };
  public?: boolean;
  organization?: string;
  custom_properties: {
    [k: string]: null | string | string[];
  };
}
export interface User {
  login: string;
  id: number;
  node_id: string;
  name?: string;
  email?: string | null;
  avatar_url: string;
  gravatar_id: string;
  url: string;
  html_url: string;
  followers_url: string;
  following_url: string;
  gists_url: string;
  starred_url: string;
  subscriptions_url: string;
  organizations_url: string;
  repos_url: string;
  events_url: string;
  received_events_url: string;
  type: "Bot" | "User" | "Organization";
  site_admin: boolean;
}
export interface License {
  key: string;
  name: string;
  spdx_id: string;
  url: string | null;
  node_id: string;
}
export interface BranchProtectionConfigurationEnabledEvent {
  action: "enabled";
  installation?: InstallationLite;
  organization?: Organization;
  repository: Repository;
  sender: User;
}
/**
 * Activity related to a branch protection rule. For more information, see "[About branch protection rules](https://docs.github.com/en/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-rules)."
 */
export interface BranchProtectionRuleCreatedEvent {
  action: "created";
  rule: BranchProtectionRule;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
/**
 * The branch protection rule. Includes a `name` and all the [branch protection settings](https://docs.github.com/en/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-settings) applied to branches that match the name. Binary settings are boolean. Multi-level configurations are one of `off`, `non_admins`, or `everyone`. Actor and build lists are arrays of strings.
 */
export interface BranchProtectionRule {
  id: number;
  repository_id: number;
  name: string;
  created_at: string;
  updated_at: string;
  pull_request_reviews_enforcement_level: BranchProtectionRuleEnforcementLevel;
  required_approving_review_count: BranchProtectionRuleNumber;
  dismiss_stale_reviews_on_push: BranchProtectionRuleBoolean;
  require_code_owner_review: BranchProtectionRuleBoolean;
  authorized_dismissal_actors_only: BranchProtectionRuleBoolean;
  ignore_approvals_from_contributors: BranchProtectionRuleBoolean;
  require_last_push_approval?: BranchProtectionRuleBoolean;
  required_status_checks: BranchProtectionRuleArray;
  required_status_checks_enforcement_level: BranchProtectionRuleEnforcementLevel;
  strict_required_status_checks_policy: BranchProtectionRuleBoolean;
  signature_requirement_enforcement_level: BranchProtectionRuleEnforcementLevel;
  linear_history_requirement_enforcement_level: BranchProtectionRuleEnforcementLevel;
  admin_enforced: BranchProtectionRuleBoolean;
  create_protected?: BranchProtectionRuleBoolean;
  allow_force_pushes_enforcement_level: BranchProtectionRuleEnforcementLevel;
  allow_deletions_enforcement_level: BranchProtectionRuleEnforcementLevel;
  merge_queue_enforcement_level: BranchProtectionRuleEnforcementLevel;
  required_deployments_enforcement_level: BranchProtectionRuleEnforcementLevel;
  required_conversation_resolution_level: BranchProtectionRuleEnforcementLevel;
  authorized_actors_only: BranchProtectionRuleBoolean;
  authorized_actor_names: BranchProtectionRuleArray;
}
/**
 * Activity related to a branch protection rule. For more information, see "[About branch protection rules](https://docs.github.com/en/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-rules)."
 */
export interface BranchProtectionRuleDeletedEvent {
  action: "deleted";
  rule: BranchProtectionRule;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
/**
 * Activity related to a branch protection rule. For more information, see "[About branch protection rules](https://docs.github.com/en/github/administering-a-repository/defining-the-mergeability-of-pull-requests/about-protected-branches#about-branch-protection-rules)."
 */
export interface BranchProtectionRuleEditedEvent {
  action: "edited";
  rule: BranchProtectionRule;
  /**
   * If the action was `edited`, the changes to the rule.
   */
  changes?: {
    admin_enforced?: {
      from: BranchProtectionRuleBoolean;
    };
    allow_deletions_enforcement_level?: {
      from: BranchProtectionRuleEnforcementLevel | null;
    };
    allow_force_pushes_enforcement_level?: {
      from: BranchProtectionRuleEnforcementLevel;
    };
    authorized_actors_only?: {
      from: BranchProtectionRuleBoolean;
    };
    authorized_actor_names?: {
      from: BranchProtectionRuleArray;
    };
    authorized_dismissal_actors_only?: {
      from: BranchProtectionRuleBoolean | null;
    };
    dismiss_stale_reviews_on_push?: {
      from: BranchProtectionRuleBoolean;
    };
    pull_request_reviews_enforcement_level?: {
      from: BranchProtectionRuleEnforcementLevel;
    };
    require_code_owner_review?: {
      from: BranchProtectionRuleBoolean;
    };
    required_approving_review_count?: {
      from: BranchProtectionRuleNumber;
    };
    required_conversation_resolution_level?: {
      from: BranchProtectionRuleEnforcementLevel;
    };
    required_deployments_enforcement_level?: {
      from: BranchProtectionRuleEnforcementLevel;
    };
    required_status_checks?: {
      from: BranchProtectionRuleArray;
    };
    required_status_checks_enforcement_level?: {
      from: BranchProtectionRuleEnforcementLevel;
    };
    signature_requirement_enforcement_level?: {
      from: BranchProtectionRuleEnforcementLevel;
    };
    linear_history_requirement_enforcement_level?: {
      from: BranchProtectionRuleEnforcementLevel;
    };
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface CheckRunCompletedEvent {
  action: "completed";
  /**
   * The [check_run](https://docs.github.com/en/rest/reference/checks#get-a-check-run).
   */
  check_run: {
    /**
     * The id of the check.
     */
    id: number;
    node_id?: string;
    /**
     * The SHA of the commit that is being checked.
     */
    head_sha: string;
    external_id: string;
    url: string;
    html_url: string;
    details_url?: string;
    /**
     * The current status of the check run. Can be `queued`, `in_progress`, or `completed`.
     */
    status: "completed";
    /**
     * The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.
     */
    conclusion:
      | "success"
      | "failure"
      | "neutral"
      | "cancelled"
      | "timed_out"
      | "action_required"
      | "stale"
      | "skipped"
      | null;
    /**
     * The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    started_at: string;
    /**
     * The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    completed_at: string;
    output: {
      title?: string | null;
      summary: string | null;
      text: string | null;
      annotations_count: number;
      annotations_url: string;
    };
    /**
     * The name of the check run.
     */
    name: string;
    check_suite: {
      /**
       * The id of the check suite that this check run is part of.
       */
      id: number;
      node_id?: string;
      head_branch: string | null;
      /**
       * The SHA of the head commit that is being checked.
       */
      head_sha: string;
      status: "in_progress" | "completed" | "queued";
      conclusion:
        | "success"
        | "failure"
        | "neutral"
        | "cancelled"
        | "timed_out"
        | "action_required"
        | "stale"
        | null;
      url: string;
      before: string | null;
      after: string | null;
      /**
       * An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_branch`.
       *
       * **Note:**
       *
       * *   The `head_sha` of the check suite can differ from the `sha` of the pull request if subsequent pushes are made into the PR.
       * *   When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.
       */
      pull_requests: CheckRunPullRequest[];
      deployment?: CheckRunDeployment;
      app: App;
      created_at: string;
      updated_at: string;
    };
    app: App;
    pull_requests: CheckRunPullRequest[];
    deployment?: CheckRunDeployment;
  };
  /**
   * The action requested by the user.
   */
  requested_action?: {
    /**
     * The integrator reference of the action requested by the user.
     */
    identifier?: string;
  } | null;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface CheckRunPullRequest {
  url: string;
  id: number;
  number: number;
  head: {
    ref: string;
    sha: string;
    repo: RepoRef;
  };
  base: {
    ref: string;
    sha: string;
    repo: RepoRef;
  };
}
export interface RepoRef {
  id: number;
  url: string;
  name: string;
}
/**
 * A deployment to a repository environment. This will only be populated if the check run was created by a GitHub Actions workflow job that references an environment.
 */
export interface CheckRunDeployment {
  url: string;
  id: number;
  node_id: string;
  task: string;
  original_environment: string;
  environment: string;
  description: string | null;
  created_at: string;
  updated_at: string;
  statuses_url: string;
  repository_url: string;
}
/**
 * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
 */
export interface App {
  /**
   * Unique identifier of the GitHub app
   */
  id: number;
  /**
   * The slug name of the GitHub app
   */
  slug?: string;
  node_id: string;
  owner: User;
  /**
   * The name of the GitHub app
   */
  name: string;
  description: string | null;
  external_url: string;
  html_url: string;
  created_at: string;
  updated_at: string;
  /**
   * The set of permissions for the GitHub app
   */
  permissions?: {
    actions?: "read" | "write";
    administration?: "read" | "write";
    blocking?: "read" | "write";
    checks?: "read" | "write";
    content_references?: "read" | "write";
    contents?: "read" | "write";
    deployments?: "read" | "write";
    discussions?: "read" | "write";
    emails?: "read" | "write";
    environments?: "read" | "write";
    followers?: "read" | "write";
    gpg_keys?: "read" | "write";
    interaction_limits?: "read" | "write";
    issues?: "read" | "write";
    keys?: "read" | "write";
    members?: "read" | "write";
    merge_queues?: "read" | "write";
    metadata?: "read" | "write";
    organization_administration?: "read" | "write";
    organization_hooks?: "read" | "write";
    organization_packages?: "read" | "write";
    organization_plan?: "read" | "write";
    organization_projects?: "read" | "write";
    organization_secrets?: "read" | "write";
    organization_self_hosted_runners?: "read" | "write";
    organization_user_blocking?: "read" | "write";
    packages?: "read" | "write";
    pages?: "read" | "write";
    plan?: "read" | "write";
    pull_requests?: "read" | "write";
    repository_hooks?: "read" | "write";
    repository_projects?: "read" | "write";
    secret_scanning_alerts?: "read" | "write";
    secrets?: "read" | "write";
    security_events?: "read" | "write";
    security_scanning_alert?: "read" | "write";
    single_file?: "read" | "write";
    starring?: "read" | "write";
    statuses?: "read" | "write";
    team_discussions?: "read" | "write";
    vulnerability_alerts?: "read" | "write";
    watching?: "read" | "write";
    workflows?: "read" | "write";
  };
  /**
   * The list of events for the GitHub app
   */
  events?: (
    | "branch_protection_rule"
    | "check_run"
    | "check_suite"
    | "code_scanning_alert"
    | "commit_comment"
    | "create"
    | "delete"
    | "dependabot_alert"
    | "deployment"
    | "deployment_protection_rule"
    | "deployment_review"
    | "deployment_status"
    | "deploy_key"
    | "discussion"
    | "discussion_comment"
    | "fork"
    | "gollum"
    | "issues"
    | "issue_comment"
    | "label"
    | "member"
    | "membership"
    | "merge_group"
    | "merge_queue_entry"
    | "milestone"
    | "organization"
    | "org_block"
    | "page_build"
    | "project"
    | "projects_v2_item"
    | "project_card"
    | "project_column"
    | "public"
    | "pull_request"
    | "pull_request_review"
    | "pull_request_review_comment"
    | "pull_request_review_thread"
    | "push"
    | "registry_package"
    | "release"
    | "repository"
    | "repository_dispatch"
    | "repository_ruleset"
    | "secret_scanning_alert"
    | "secret_scanning_alert_location"
    | "security_and_analysis"
    | "star"
    | "status"
    | "team"
    | "team_add"
    | "watch"
    | "workflow_dispatch"
    | "workflow_job"
    | "workflow_run"
  )[];
}
export interface CheckRunCreatedEvent {
  action: "created";
  /**
   * The [check_run](https://docs.github.com/en/rest/reference/checks#get-a-check-run).
   */
  check_run: {
    /**
     * The id of the check.
     */
    id: number;
    node_id?: string;
    /**
     * The SHA of the commit that is being checked.
     */
    head_sha: string;
    external_id: string;
    url: string;
    html_url: string;
    details_url?: string;
    /**
     * The current status of the check run. Can be `queued`, `in_progress`, or `completed`.
     */
    status: "queued" | "in_progress" | "completed" | "waiting";
    /**
     * The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.
     */
    conclusion:
      | "success"
      | "failure"
      | "neutral"
      | "cancelled"
      | "timed_out"
      | "action_required"
      | "stale"
      | "skipped"
      | null;
    /**
     * The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    started_at: string;
    /**
     * The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    completed_at: string | null;
    output: {
      title?: string | null;
      summary: string | null;
      text: string | null;
      annotations_count: number;
      annotations_url: string;
    };
    /**
     * The name of the check run.
     */
    name: string;
    check_suite: {
      /**
       * The id of the check suite that this check run is part of.
       */
      id: number;
      node_id?: string;
      head_branch: string | null;
      /**
       * The SHA of the head commit that is being checked.
       */
      head_sha: string;
      status: "queued" | "in_progress" | "completed";
      conclusion:
        | "success"
        | "failure"
        | "neutral"
        | "cancelled"
        | "timed_out"
        | "action_required"
        | "stale"
        | null;
      url: string;
      before: string | null;
      after: string | null;
      /**
       * An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_branch`.
       *
       * **Note:**
       *
       * *   The `head_sha` of the check suite can differ from the `sha` of the pull request if subsequent pushes are made into the PR.
       * *   When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.
       */
      pull_requests: CheckRunPullRequest[];
      deployment?: CheckRunDeployment;
      app: App;
      created_at: string;
      updated_at: string;
    };
    app: App;
    pull_requests: CheckRunPullRequest[];
    deployment?: CheckRunDeployment;
  };
  /**
   * The action requested by the user.
   */
  requested_action?: {
    /**
     * The integrator reference of the action requested by the user.
     */
    identifier?: string;
  } | null;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface CheckRunRequestedActionEvent {
  action: "requested_action";
  /**
   * The [check_run](https://docs.github.com/en/rest/reference/checks#get-a-check-run).
   */
  check_run: {
    /**
     * The id of the check.
     */
    id: number;
    node_id?: string;
    /**
     * The SHA of the commit that is being checked.
     */
    head_sha: string;
    external_id: string;
    url: string;
    html_url: string;
    details_url?: string;
    /**
     * The current status of the check run. Can be `queued`, `in_progress`, or `completed`.
     */
    status: "queued" | "in_progress" | "completed";
    /**
     * The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.
     */
    conclusion:
      | "success"
      | "failure"
      | "neutral"
      | "cancelled"
      | "timed_out"
      | "action_required"
      | "stale"
      | "skipped"
      | null;
    /**
     * The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    started_at: string;
    /**
     * The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    completed_at: string | null;
    output: {
      title?: string | null;
      summary: string | null;
      text: string | null;
      annotations_count: number;
      annotations_url: string;
    };
    /**
     * The name of the check run.
     */
    name: string;
    check_suite: {
      /**
       * The id of the check suite that this check run is part of.
       */
      id: number;
      node_id?: string;
      head_branch: string | null;
      /**
       * The SHA of the head commit that is being checked.
       */
      head_sha: string;
      status: "queued" | "in_progress" | "completed" | "waiting";
      conclusion:
        | "success"
        | "failure"
        | "neutral"
        | "cancelled"
        | "timed_out"
        | "action_required"
        | "stale"
        | null;
      url: string;
      before: string | null;
      after: string | null;
      /**
       * An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_branch`.
       *
       * **Note:**
       *
       * *   The `head_sha` of the check suite can differ from the `sha` of the pull request if subsequent pushes are made into the PR.
       * *   When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.
       */
      pull_requests: CheckRunPullRequest[];
      deployment?: CheckRunDeployment;
      app: App;
      created_at: string;
      updated_at: string;
    };
    app: App;
    pull_requests: CheckRunPullRequest[];
    deployment?: CheckRunDeployment;
  };
  /**
   * The action requested by the user.
   */
  requested_action: {
    /**
     * The integrator reference of the action requested by the user.
     */
    identifier?: string;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface CheckRunRerequestedEvent {
  action: "rerequested";
  /**
   * The [check_run](https://docs.github.com/en/rest/reference/checks#get-a-check-run).
   */
  check_run: {
    /**
     * The id of the check.
     */
    id: number;
    node_id?: string;
    /**
     * The SHA of the commit that is being checked.
     */
    head_sha: string;
    external_id: string;
    url: string;
    html_url: string;
    details_url?: string;
    /**
     * The phase of the lifecycle that the check is currently in.
     */
    status: "completed";
    /**
     * The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has `completed`.
     */
    conclusion:
      | "success"
      | "failure"
      | "neutral"
      | "cancelled"
      | "timed_out"
      | "action_required"
      | "stale"
      | "skipped"
      | null;
    /**
     * The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    started_at: string;
    /**
     * The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    completed_at: string;
    output: {
      title?: string | null;
      summary: string | null;
      text: string | null;
      annotations_count: number;
      annotations_url: string;
    };
    /**
     * The name of the check.
     */
    name: string;
    check_suite: {
      /**
       * The id of the check suite that this check run is part of.
       */
      id: number;
      node_id?: string;
      head_branch: string | null;
      /**
       * The SHA of the head commit that is being checked.
       */
      head_sha: string;
      status: "completed";
      conclusion:
        | "success"
        | "failure"
        | "neutral"
        | "cancelled"
        | "timed_out"
        | "action_required"
        | "stale";
      url: string;
      before: string | null;
      after: string | null;
      /**
       * An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_branch`.
       *
       * **Note:**
       *
       * *   The `head_sha` of the check suite can differ from the `sha` of the pull request if subsequent pushes are made into the PR.
       * *   When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.
       */
      pull_requests: CheckRunPullRequest[];
      deployment?: CheckRunDeployment;
      app: App;
      created_at: string;
      updated_at: string;
    };
    app: App;
    pull_requests: CheckRunPullRequest[];
    deployment?: CheckRunDeployment;
  };
  /**
   * The action requested by the user.
   */
  requested_action?: {
    /**
     * The integrator reference of the action requested by the user.
     */
    identifier?: string;
  } | null;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface CheckSuiteCompletedEvent {
  action: "completed";
  /**
   * The [check_suite](https://docs.github.com/en/rest/reference/checks#suites).
   */
  check_suite: {
    id: number;
    node_id: string;
    /**
     * The head branch name the changes are on.
     */
    head_branch: string | null;
    /**
     * The SHA of the head commit that is being checked.
     */
    head_sha: string;
    /**
     * The summary status for all check runs that are part of the check suite. Can be `queued`, `requested`, `in_progress`, or `completed`.
     */
    status: "requested" | "in_progress" | "completed" | "queued" | null;
    /**
     * The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has `completed`.
     */
    conclusion:
      | "success"
      | "failure"
      | "neutral"
      | "cancelled"
      | "timed_out"
      | "action_required"
      | "stale"
      | null;
    /**
     * URL that points to the check suite API resource.
     */
    url: string;
    before: string | null;
    after: string | null;
    /**
     * An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.
     */
    pull_requests: CheckRunPullRequest[];
    app: App;
    created_at: string;
    updated_at: string;
    runs_rerequestable?: boolean;
    rerequestable?: boolean;
    latest_check_runs_count: number;
    check_runs_url: string;
    head_commit: SimpleCommit;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface SimpleCommit {
  id: string;
  tree_id: string;
  message: string;
  timestamp: string;
  author: Committer;
  committer: Committer;
}
/**
 * Metaproperties for Git author/committer information.
 */
export interface Committer {
  /**
   * The git author's name.
   */
  name: string;
  /**
   * The git author's email address.
   */
  email: string | null;
  date?: string;
  username?: string;
}
export interface CheckSuiteRequestedEvent {
  action: "requested";
  /**
   * The [check_suite](https://docs.github.com/en/rest/reference/checks#suites).
   */
  check_suite: {
    id: number;
    node_id: string;
    /**
     * The head branch name the changes are on.
     */
    head_branch: string | null;
    /**
     * The SHA of the head commit that is being checked.
     */
    head_sha: string;
    /**
     * The summary status for all check runs that are part of the check suite. Can be `queued`, `requested`, `in_progress`, or `completed`.
     */
    status: "requested" | "in_progress" | "completed" | "queued" | null;
    /**
     * The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`,` neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.
     */
    conclusion:
      | "success"
      | "failure"
      | "neutral"
      | "cancelled"
      | "timed_out"
      | "action_required"
      | "stale"
      | null;
    /**
     * URL that points to the check suite API resource.
     */
    url: string;
    before: string | null;
    after: string | null;
    /**
     * An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.
     */
    pull_requests: CheckRunPullRequest[];
    app: App;
    created_at: string;
    updated_at: string;
    runs_rerequestable?: boolean;
    rerequestable?: boolean;
    latest_check_runs_count: number;
    check_runs_url: string;
    head_commit: SimpleCommit;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface CheckSuiteRerequestedEvent {
  action: "rerequested";
  /**
   * The [check_suite](https://docs.github.com/en/rest/reference/checks#suites).
   */
  check_suite: {
    id: number;
    node_id: string;
    /**
     * The head branch name the changes are on.
     */
    head_branch: string | null;
    /**
     * The SHA of the head commit that is being checked.
     */
    head_sha: string;
    /**
     * The summary status for all check runs that are part of the check suite. Can be `queued`, `requested`, `in_progress`, or `completed`.
     */
    status: "requested" | "in_progress" | "completed" | "queued" | null;
    /**
     * The summary conclusion for all check runs that are part of the check suite. Can be one of `success`, `failure`,` neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.
     */
    conclusion:
      | "success"
      | "failure"
      | "neutral"
      | "cancelled"
      | "timed_out"
      | "action_required"
      | "stale"
      | null;
    /**
     * URL that points to the check suite API resource.
     */
    url: string;
    before: string | null;
    after: string | null;
    /**
     * An array of pull requests that match this check suite. A pull request matches a check suite if they have the same `head_sha` and `head_branch`. When the check suite's `head_branch` is in a forked repository it will be `null` and the `pull_requests` array will be empty.
     */
    pull_requests: CheckRunPullRequest[];
    app: App;
    created_at: string;
    updated_at: string;
    latest_check_runs_count: number;
    check_runs_url: string;
    head_commit: SimpleCommit;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface CodeScanningAlertAppearedInBranchEvent {
  action: "appeared_in_branch";
  /**
   * The code scanning alert involved in the event.
   */
  alert: {
    /**
     * The code scanning alert number.
     */
    number: number;
    /**
     * The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
     */
    created_at: string;
    /**
     * The REST API URL of the alert resource.
     */
    url: string;
    /**
     * The GitHub URL of the alert resource.
     */
    html_url: string;
    instances: AlertInstance[];
    most_recent_instance?: AlertInstance;
    /**
     * State of a code scanning alert.
     */
    state: "open" | "dismissed" | "fixed";
    dismissed_by: User | null;
    /**
     * The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    dismissed_at: string | null;
    /**
     * The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
     */
    dismissed_reason: "false positive" | "won't fix" | "used in tests" | null;
    rule: {
      /**
       * A unique identifier for the rule used to detect the alert.
       */
      id: string;
      /**
       * The severity of the alert.
       */
      severity: "none" | "note" | "warning" | "error" | null;
      /**
       * A short description of the rule used to detect the alert.
       */
      description: string;
    };
    tool: {
      /**
       * The name of the tool used to generate the code scanning analysis alert.
       */
      name: string;
      /**
       * The version of the tool used to detect the alert.
       */
      version: string | null;
    };
  };
  /**
   * The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  ref: string;
  /**
   * The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  commit_oid: string;
  repository: Repository;
  sender: GitHubOrg;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface AlertInstance {
  /**
   * The full Git reference, formatted as `refs/heads/<branch name>`.
   */
  ref: string;
  /**
   * Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
   */
  analysis_key: string;
  /**
   * Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
   */
  environment: string;
  /**
   * State of a code scanning alert.
   */
  state: "open" | "dismissed" | "fixed";
  commit_sha?: string;
  message?: {
    text?: string;
  };
  location?: {
    path?: string;
    start_line?: number;
    end_line?: number;
    start_column?: number;
    end_column?: number;
  };
  classifications?: string[];
}
export interface GitHubOrg {
  login: "github";
  id: 9919;
  node_id: "MDEyOk9yZ2FuaXphdGlvbjk5MTk=";
  name?: "GitHub";
  email?: null;
  avatar_url: "https://avatars.githubusercontent.com/u/9919?v=4";
  gravatar_id: "";
  url: "https://api.github.com/users/github";
  html_url: "https://github.com/github";
  followers_url: "https://api.github.com/users/github/followers";
  following_url: "https://api.github.com/users/github/following{/other_user}";
  gists_url: "https://api.github.com/users/github/gists{/gist_id}";
  starred_url: "https://api.github.com/users/github/starred{/owner}{/repo}";
  subscriptions_url: "https://api.github.com/users/github/subscriptions";
  organizations_url: "https://api.github.com/users/github/orgs";
  repos_url: "https://api.github.com/users/github/repos";
  events_url: "https://api.github.com/users/github/events{/privacy}";
  received_events_url: "https://api.github.com/users/github/received_events";
  type: "Organization";
  site_admin: false;
}
export interface CodeScanningAlertClosedByUserEvent {
  action: "closed_by_user";
  /**
   * The code scanning alert involved in the event.
   */
  alert: {
    /**
     * The code scanning alert number.
     */
    number: number;
    /**
     * The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
     */
    created_at: string;
    /**
     * The REST API URL of the alert resource.
     */
    url: string;
    /**
     * The GitHub URL of the alert resource.
     */
    html_url: string;
    instances: (AlertInstance & {
      state: "dismissed";
    })[];
    most_recent_instance?: AlertInstance;
    /**
     * State of a code scanning alert.
     */
    state: "dismissed";
    dismissed_by: User;
    /**
     * The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    dismissed_at: string;
    /**
     * The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
     */
    dismissed_reason: "false positive" | "won't fix" | "used in tests" | null;
    rule: {
      /**
       * A unique identifier for the rule used to detect the alert.
       */
      id: string;
      /**
       * The severity of the alert.
       */
      severity: "none" | "note" | "warning" | "error" | null;
      /**
       * A short description of the rule used to detect the alert.
       */
      description: string;
      name?: string;
      full_description?: string;
      tags?: null;
      help?: null;
    };
    tool: {
      /**
       * The name of the tool used to generate the code scanning analysis alert.
       */
      name: string;
      /**
       * The version of the tool used to detect the alert.
       */
      version: string | null;
      guid?: string | null;
    };
  };
  /**
   * The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  ref: string;
  /**
   * The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  commit_oid: string;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface CodeScanningAlertCreatedEvent {
  action: "created";
  /**
   * The code scanning alert involved in the event.
   */
  alert: {
    /**
     * The code scanning alert number.
     */
    number: number;
    /**
     * The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
     */
    created_at: string;
    /**
     * The REST API URL of the alert resource.
     */
    url: string;
    /**
     * The GitHub URL of the alert resource.
     */
    html_url: string;
    instances: (AlertInstance & {
      state: "open" | "dismissed";
    })[];
    most_recent_instance?: AlertInstance;
    /**
     * State of a code scanning alert.
     */
    state: "open" | "dismissed";
    dismissed_by: null;
    /**
     * The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    dismissed_at: null;
    /**
     * The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
     */
    dismissed_reason: null;
    rule: {
      /**
       * A unique identifier for the rule used to detect the alert.
       */
      id: string;
      /**
       * The severity of the alert.
       */
      severity: "none" | "note" | "warning" | "error" | null;
      /**
       * A short description of the rule used to detect the alert.
       */
      description: string;
      name?: string;
      full_description?: string;
      tags?: null;
      help?: null;
    };
    tool: {
      /**
       * The name of the tool used to generate the code scanning analysis alert.
       */
      name: string;
      /**
       * The version of the tool used to detect the alert.
       */
      version: string | null;
      guid?: string | null;
    };
  };
  /**
   * The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  ref: string;
  /**
   * The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  commit_oid: string;
  repository: Repository;
  sender: GitHubOrg;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface CodeScanningAlertFixedEvent {
  action: "fixed";
  /**
   * The code scanning alert involved in the event.
   */
  alert: {
    /**
     * The code scanning alert number.
     */
    number: number;
    /**
     * The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
     */
    created_at: string;
    /**
     * The REST API URL of the alert resource.
     */
    url: string;
    /**
     * The GitHub URL of the alert resource.
     */
    html_url: string;
    instances: (AlertInstance & {
      state: "fixed";
    })[];
    /**
     * State of a code scanning alert.
     */
    state: "fixed";
    dismissed_by: User | null;
    /**
     * The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    dismissed_at: string | null;
    /**
     * The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
     */
    dismissed_reason: "false positive" | "won't fix" | "used in tests" | null;
    rule: {
      /**
       * A unique identifier for the rule used to detect the alert.
       */
      id: string;
      /**
       * The severity of the alert.
       */
      severity: "none" | "note" | "warning" | "error" | null;
      /**
       * A short description of the rule used to detect the alert.
       */
      description: string;
      name?: string;
      full_description?: string;
      tags?: null;
      help?: null;
    };
    tool: {
      /**
       * The name of the tool used to generate the code scanning analysis alert.
       */
      name: string;
      /**
       * The version of the tool used to detect the alert.
       */
      version: string | null;
      guid?: string | null;
    };
    most_recent_instance?: AlertInstance;
    instances_url?: string;
  };
  /**
   * The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  ref: string;
  /**
   * The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  commit_oid: string;
  repository: Repository;
  sender: GitHubOrg;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface CodeScanningAlertReopenedEvent {
  action: "reopened";
  /**
   * The code scanning alert involved in the event.
   */
  alert: {
    /**
     * The code scanning alert number.
     */
    number: number;
    /**
     * The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
     */
    created_at: string;
    /**
     * The REST API URL of the alert resource.
     */
    url: string;
    /**
     * The GitHub URL of the alert resource.
     */
    html_url: string;
    instances: (AlertInstance & {
      state: "open";
    })[];
    most_recent_instance?: AlertInstance;
    /**
     * State of a code scanning alert.
     */
    state: "open" | "dismissed" | "fixed";
    dismissed_by: null;
    /**
     * The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    dismissed_at: null;
    /**
     * The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
     */
    dismissed_reason: null;
    rule: {
      /**
       * A unique identifier for the rule used to detect the alert.
       */
      id: string;
      /**
       * The severity of the alert.
       */
      severity: "none" | "note" | "warning" | "error" | null;
      /**
       * A short description of the rule used to detect the alert.
       */
      description: string;
      name?: string;
      full_description?: string;
      tags?: null;
      help?: null;
    };
    tool: {
      /**
       * The name of the tool used to generate the code scanning analysis alert.
       */
      name: string;
      /**
       * The version of the tool used to detect the alert.
       */
      version: string | null;
      guid?: string | null;
    };
  };
  /**
   * The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  ref: string;
  /**
   * The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  commit_oid: string;
  repository: Repository;
  sender: GitHubOrg;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface CodeScanningAlertReopenedByUserEvent {
  action: "reopened_by_user";
  /**
   * The code scanning alert involved in the event.
   */
  alert: {
    /**
     * The code scanning alert number.
     */
    number: number;
    /**
     * The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ.`
     */
    created_at: string;
    /**
     * The REST API URL of the alert resource.
     */
    url: string;
    /**
     * The GitHub URL of the alert resource.
     */
    html_url: string;
    instances: (AlertInstance & {
      state: "open";
    })[];
    most_recent_instance?: AlertInstance;
    /**
     * State of a code scanning alert.
     */
    state: "open";
    dismissed_by: null;
    /**
     * The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    dismissed_at: null;
    /**
     * The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
     */
    dismissed_reason: null;
    rule: {
      /**
       * A unique identifier for the rule used to detect the alert.
       */
      id: string;
      /**
       * The severity of the alert.
       */
      severity: "none" | "note" | "warning" | "error" | null;
      /**
       * A short description of the rule used to detect the alert.
       */
      description: string;
    };
    tool: {
      /**
       * The name of the tool used to generate the code scanning analysis alert.
       */
      name: string;
      /**
       * The version of the tool used to detect the alert.
       */
      version: string | null;
    };
  };
  /**
   * The Git reference of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  ref: string;
  /**
   * The commit SHA of the code scanning alert. When the action is `reopened_by_user` or `closed_by_user`, the event was triggered by the `sender` and this value will be empty.
   */
  commit_oid: string;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
/**
 * A commit comment is created. The type of activity is specified in the `action` property.
 */
export interface CommitCommentCreatedEvent {
  /**
   * The action performed. Can be `created`.
   */
  action: "created";
  /**
   * The [commit comment](https://docs.github.com/en/rest/reference/repos#get-a-commit-comment) resource.
   */
  comment: {
    url: string;
    html_url: string;
    /**
     * The ID of the commit comment.
     */
    id: number;
    /**
     * The node ID of the commit comment.
     */
    node_id: string;
    user: User;
    /**
     * The line index in the diff to which the comment applies.
     */
    position: number | null;
    /**
     * The line of the blob to which the comment applies. The last line of the range for a multi-line comment
     */
    line: number | null;
    /**
     * The relative path of the file to which the comment applies.
     */
    path: string | null;
    /**
     * The SHA of the commit to which the comment applies.
     */
    commit_id: string;
    created_at: string;
    updated_at: string;
    author_association: AuthorAssociation;
    /**
     * The text of the comment.
     */
    body: string;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
/**
 * A Git branch or tag is created.
 */
export interface CreateEvent {
  /**
   * The [`git ref`](https://docs.github.com/en/rest/reference/git#get-a-reference) resource.
   */
  ref: string;
  /**
   * The type of Git ref object created in the repository. Can be either `branch` or `tag`.
   */
  ref_type: "tag" | "branch";
  /**
   * The name of the repository's default branch (usually `main`).
   */
  master_branch: string;
  /**
   * The repository's current description.
   */
  description: string | null;
  /**
   * The pusher type for the event. Can be either `user` or a deploy key.
   */
  pusher_type: string;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface CustomPropertyCreatedEvent {
  action: "created";
  definition: OrganizationCustomProperty;
  installation?: InstallationLite;
  organization: Organization;
  sender?: User;
}
/**
 * Custom property defined on an organization
 */
export interface OrganizationCustomProperty {
  /**
   * The name of the property
   */
  property_name: string;
  /**
   * The type of the value for the property
   */
  value_type: "string" | "single_select";
  /**
   * Whether the property is required.
   */
  required?: boolean;
  /**
   * Default value of the property
   */
  default_value?: string | null;
  /**
   * Short description of the property
   */
  description?: string | null;
  /**
   * An ordered list of the allowed values of the property.
   * The property can have up to 200 allowed values.
   *
   * @maxItems 200
   */
  allowed_values?: string[] | null;
  /**
   * Who can edit the values of the property
   */
  values_editable_by?: "org_actors" | "org_and_repo_actors" | null;
}
export interface CustomPropertyDeletedEvent {
  action: "deleted";
  definition: {
    /**
     * The name of the property that was deleted.
     */
    property_name: string;
  };
  installation?: InstallationLite;
  organization: Organization;
  sender?: User;
}
export interface CustomPropertyValuesUpdatedEvent {
  action: "updated";
  installation?: InstallationLite;
  repository: Repository;
  organization: Organization;
  sender: User;
  /**
   * The new custom property values for the repository.
   */
  new_property_values: CustomPropertyValue[];
  /**
   * The old custom property values for the repository.
   */
  old_property_values: CustomPropertyValue[];
}
/**
 * Custom property name and associated value
 */
export interface CustomPropertyValue {
  /**
   * The name of the property
   */
  property_name: string;
  /**
   * The value assigned to the property
   */
  value: string | string[] | null;
}
/**
 * A Git branch or tag is deleted.
 */
export interface DeleteEvent {
  /**
   * The [`git ref`](https://docs.github.com/en/rest/reference/git#get-a-reference) resource.
   */
  ref: string;
  /**
   * The type of Git ref object deleted in the repository. Can be either `branch` or `tag`.
   */
  ref_type: "tag" | "branch";
  /**
   * The pusher type for the event. Can be either `user` or a deploy key.
   */
  pusher_type: string;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DependabotAlertCreatedEvent {
  action: "created";
  alert: DependabotAlert & {
    state: "open";
    fixed_at: null;
    dismissed_at: null;
    dismissed_by: null;
    dismissed_reason: null;
    dismissed_comment: null;
  };
  repository: Repository;
  sender: GitHubOrg;
  installation?: InstallationLite;
  organization?: Organization;
}
/**
 * A Dependabot alert.
 */
export interface DependabotAlert {
  /**
   * The security alert number.
   */
  number: number;
  /**
   * The state of the Dependabot alert.
   */
  state: "dismissed" | "fixed" | "open" | "auto_dismissed";
  /**
   * Details for the vulnerable dependency.
   */
  dependency: {
    package: DependabotAlertPackage;
    /**
     * The full path to the dependency manifest file, relative to the root of the repository.
     */
    manifest_path: string;
    /**
     * The execution scope of the vulnerable dependency.
     */
    scope: "development" | "runtime" | null;
  };
  /**
   * Details for the GitHub Security Advisory.
   */
  security_advisory: {
    /**
     * Details for the GitHub Security Advisory.
     */
    ghsa_id: string;
    /**
     * The unique CVE ID assigned to the advisory.
     */
    cve_id: string | null;
    /**
     * A short, plain text summary of the advisory.
     */
    summary: string;
    /**
     * A long-form Markdown-supported description of the advisory.
     */
    description: string;
    /**
     * Vulnerable version range information for the advisory.
     */
    vulnerabilities: {
      package: DependabotAlertPackage;
      /**
       * The severity of the vulnerability.
       */
      severity: "low" | "medium" | "high" | "critical";
      /**
       * Conditions that identify vulnerable versions of this vulnerability's package.
       */
      vulnerable_version_range: string;
      /**
       * Details pertaining to the package version that patches this vulnerability.
       */
      first_patched_version: {
        /**
         * The package version that patches this vulnerability.
         */
        identifier: string;
      };
    }[];
    /**
     * The severity of the advisory.
     */
    severity: "low" | "medium" | "high" | "critical";
    cvss: SecurityAdvisoryCvss;
    /**
     * Details for the advisory pertaining to Common Weakness Enumeration.
     */
    cwes: SecurityAdvisoryCwes[];
    /**
     * Values that identify this advisory among security information sources.
     */
    identifiers: {
      /**
       * The type of advisory identifier.
       */
      type: "CVE" | "GHSA";
      /**
       * The value of the advisory identifer.
       */
      value: string;
    }[];
    /**
     * Links to additional advisory information.
     */
    references: {
      /**
       * The URL of the reference.
       */
      url: string;
    }[];
    /**
     * The time that the advisory was published in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    published_at: string;
    /**
     * The time that the advisory was last modified in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    updated_at: string;
    /**
     * The time that the advisory was withdrawn in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    withdrawn_at: string | null;
  };
  /**
   * Details pertaining to one vulnerable version range for the advisory.
   */
  security_vulnerability: {
    package: DependabotAlertPackage;
    /**
     * The severity of the vulnerability.
     */
    severity: "low" | "medium" | "high" | "critical";
    /**
     * Conditions that identify vulnerable versions of this vulnerability's package.
     */
    vulnerable_version_range: string;
    /**
     * Details pertaining to the package version that patches this vulnerability.
     */
    first_patched_version: {
      /**
       * The package version that patches this vulnerability.
       */
      identifier: string;
    };
  };
  /**
   * The REST API URL of the alert resource.
   */
  url: string;
  /**
   * The GitHub URL of the alert resource.
   */
  html_url: string;
  /**
   * The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  created_at: string;
  /**
   * The time that the alert was last updated in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  updated_at: string;
  /**
   * The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  dismissed_at: string | null;
  /**
   * The time that the alert was auto-dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  auto_dismissed_at?: string | null;
  dismissed_by: User | null;
  /**
   * The reason that the alert was dismissed.
   */
  dismissed_reason:
    | "fix_started"
    | "inaccurate"
    | "no_bandwidth"
    | "not_used"
    | "tolerable_risk"
    | null;
  /**
   * An optional comment associated with the alert's dismissal.
   */
  dismissed_comment: string | null;
  /**
   * The time that the alert was no longer detected and was considered fixed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  fixed_at: string | null;
}
/**
 * Details for the vulnerable package.
 */
export interface DependabotAlertPackage {
  /**
   * The unique package name within its ecosystem.
   */
  name: string;
  /**
   * The package's language or package management ecosystem.
   */
  ecosystem: string;
}
/**
 * Details for the advisory pertaining to the Common Vulnerability Scoring System.
 */
export interface SecurityAdvisoryCvss {
  /**
   * The overall CVSS score of the advisory.
   */
  score: number;
  /**
   * The full CVSS vector string for the advisory.
   */
  vector_string: string | null;
}
/**
 * A CWE weakness assigned to the advisory.
 */
export interface SecurityAdvisoryCwes {
  /**
   * The unique CWE ID.
   */
  cwe_id: string;
  /**
   * The short, plain text name of the CWE.
   */
  name: string;
}
export interface DependabotAlertDismissedEvent {
  action: "dismissed";
  alert: DependabotAlert & {
    state: "dismissed";
    dismissed_at: string;
    dismissed_by: User;
    dismissed_reason:
      | "fix_started"
      | "inaccurate"
      | "no_bandwidth"
      | "not_used"
      | "tolerable_risk";
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DependabotAlertFixedEvent {
  action: "fixed";
  alert: DependabotAlert & {
    state: "fixed";
    fixed_at: string;
  };
  repository: Repository;
  sender: GitHubOrg;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DependabotAlertReintroducedEvent {
  action: "reintroduced";
  alert: DependabotAlert;
  repository: Repository;
  sender: GitHubOrg;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DependabotAlertReopenedEvent {
  action: "reopened";
  alert: DependabotAlert;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DeployKeyCreatedEvent {
  action: "created";
  /**
   * The [`deploy key`](https://docs.github.com/en/rest/reference/deployments#get-a-deploy-key) resource.
   */
  key: {
    id: number;
    key: string;
    url: string;
    title: string;
    verified: boolean;
    created_at: string;
    read_only: boolean;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DeployKeyDeletedEvent {
  action: "deleted";
  /**
   * The [`deploy key`](https://docs.github.com/en/rest/reference/deployments#get-a-deploy-key) resource.
   */
  key: {
    id: number;
    key: string;
    url: string;
    title: string;
    verified: boolean;
    created_at: string;
    read_only: boolean;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DeploymentCreatedEvent {
  action: "created";
  deployment: Deployment;
  workflow: Workflow | null;
  workflow_run: DeploymentWorkflowRun | null;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
/**
 * The [deployment](https://docs.github.com/en/rest/reference/deployments#list-deployments).
 */
export interface Deployment {
  url: string;
  /**
   * Unique identifier of the deployment
   */
  id: number;
  node_id: string;
  sha: string;
  /**
   * The ref to deploy. This can be a branch, tag, or sha.
   */
  ref: string;
  /**
   * Parameter to specify a task to execute
   */
  task: string;
  payload: {
    [k: string]: unknown;
  };
  original_environment: string;
  /**
   * Name of the target deployment environment.
   */
  environment: string;
  /**
   * Specifies if the given environment will no longer exist at some point in the future. Default: false.
   */
  transient_environment?: boolean;
  /**
   * Specifies if the given environment is one that end-users directly interact with. Default: false.
   */
  production_environment?: boolean;
  description: string | null;
  creator: User;
  created_at: string;
  updated_at: string;
  statuses_url: string;
  repository_url: string;
  performed_via_github_app?: App | null;
}
export interface Workflow {
  badge_url: string;
  created_at: string;
  html_url: string;
  id: number;
  name: string;
  node_id: string;
  path: string;
  state: string;
  updated_at: string;
  url: string;
}
export interface DeploymentWorkflowRun {
  id: number;
  name: string;
  path?: string;
  display_title?: string;
  node_id: string;
  head_branch: string;
  head_sha: string;
  run_number: number;
  event: string;
  status: "requested" | "in_progress" | "completed" | "queued";
  conclusion:
    | "success"
    | "failure"
    | "neutral"
    | "cancelled"
    | "timed_out"
    | "action_required"
    | "stale"
    | null;
  workflow_id: number;
  check_suite_id: number;
  check_suite_node_id: string;
  url: string;
  html_url: string;
  pull_requests: CheckRunPullRequest[];
  created_at: string;
  updated_at: string;
  actor: User;
  triggering_actor: User;
  run_attempt: number;
  run_started_at: string;
  referenced_workflows?: ReferencedWorkflow[];
}
/**
 * A workflow referenced/reused by the initial caller workflow
 */
export interface ReferencedWorkflow {
  path: string;
  sha: string;
  ref?: string;
}
export interface DeploymentProtectionRuleRequestedEvent {
  action: "requested";
  /**
   * The name of the environment that has the deployment protection rule.
   */
  environment?: string;
  /**
   * The event that triggered the deployment protection rule.
   */
  event?: string;
  /**
   * The URL to review the deployment protection rule.
   */
  deployment_callback_url?: string;
  deployment?: Deployment;
  pull_requests?: PullRequest[];
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface PullRequest {
  url: string;
  id: number;
  node_id: string;
  html_url: string;
  diff_url: string;
  patch_url: string;
  issue_url: string;
  /**
   * Number uniquely identifying the pull request within its repository.
   */
  number: number;
  /**
   * State of this Pull Request. Either `open` or `closed`.
   */
  state: "open" | "closed";
  locked: boolean;
  /**
   * The title of the pull request.
   */
  title: string;
  user: User;
  body: string | null;
  created_at: string;
  updated_at: string;
  closed_at: string | null;
  merged_at: string | null;
  merge_commit_sha: string | null;
  assignee: User | null;
  assignees: User[];
  requested_reviewers: (User | Team)[];
  requested_teams: Team[];
  labels: Label[];
  milestone: Milestone | null;
  commits_url: string;
  review_comments_url: string;
  review_comment_url: string;
  comments_url: string;
  statuses_url: string;
  head: {
    label: string;
    ref: string;
    sha: string;
    user: User;
    repo: Repository | null;
  };
  base: {
    label: string;
    ref: string;
    sha: string;
    user: User;
    repo: Repository;
  };
  _links: {
    self: Link;
    html: Link;
    issue: Link;
    comments: Link;
    review_comments: Link;
    review_comment: Link;
    commits: Link;
    statuses: Link;
  };
  author_association: AuthorAssociation;
  auto_merge: PullRequestAutoMerge | null;
  active_lock_reason: "resolved" | "off-topic" | "too heated" | "spam" | null;
  /**
   * Indicates whether or not the pull request is a draft.
   */
  draft: boolean;
  merged: boolean | null;
  mergeable: boolean | null;
  rebaseable: boolean | null;
  mergeable_state: string;
  merged_by: User | null;
  comments: number;
  review_comments: number;
  /**
   * Indicates whether maintainers can modify the pull request.
   */
  maintainer_can_modify: boolean;
  commits: number;
  additions: number;
  deletions: number;
  changed_files: number;
}
/**
 * Groups of organization members that gives permissions on specified repositories.
 */
export interface Team {
  /**
   * Name of the team
   */
  name: string;
  /**
   * Unique identifier of the team
   */
  id: number;
  node_id: string;
  slug: string;
  /**
   * Description of the team
   */
  description: string | null;
  privacy: "open" | "closed" | "secret";
  /**
   * URL for the team
   */
  url: string;
  html_url: string;
  members_url: string;
  repositories_url: string;
  /**
   * Permission that the team will have for its repositories
   */
  permission: string;
  parent?: {
    /**
     * Name of the team
     */
    name: string;
    /**
     * Unique identifier of the team
     */
    id: number;
    node_id: string;
    slug: string;
    /**
     * Description of the team
     */
    description: string | null;
    privacy: "open" | "closed" | "secret";
    /**
     * URL for the team
     */
    url: string;
    html_url: string;
    members_url: string;
    repositories_url: string;
    /**
     * Permission that the team will have for its repositories
     */
    permission: string;
    /**
     * Whether team members will receive notifications when their team is @mentioned
     */
    notification_setting?: "notifications_enabled" | "notifications_disabled";
  } | null;
  /**
   * Whether team members will receive notifications when their team is @mentioned
   */
  notification_setting?: "notifications_enabled" | "notifications_disabled";
}
export interface Label {
  id: number;
  node_id: string;
  /**
   * URL for the label
   */
  url: string;
  /**
   * The name of the label.
   */
  name: string;
  description: string | null;
  /**
   * 6-character hex code, without the leading #, identifying the color
   */
  color: string;
  default: boolean;
}
/**
 * A collection of related issues and pull requests.
 */
export interface Milestone {
  url: string;
  html_url: string;
  labels_url: string;
  id: number;
  node_id: string;
  /**
   * The number of the milestone.
   */
  number: number;
  /**
   * The title of the milestone.
   */
  title: string;
  description: string | null;
  creator: User;
  open_issues: number;
  closed_issues: number;
  /**
   * The state of the milestone.
   */
  state: "open" | "closed";
  created_at: string;
  updated_at: string;
  due_on: string | null;
  closed_at: string | null;
}
export interface Link {
  href: string;
}
/**
 * The status of auto merging a pull request.
 */
export interface PullRequestAutoMerge {
  enabled_by: User | null;
  /**
   * The merge method to use.
   */
  merge_method: "merge" | "squash" | "rebase";
  /**
   * Title for the merge commit message.
   */
  commit_title: string | null;
  /**
   * Commit message for the merge commit.
   */
  commit_message: string | null;
}
export interface DeploymentReviewApprovedEvent {
  action: "approved";
  workflow_run: WorkflowRun;
  since: string;
  workflow_job_run?: {
    id: number;
    name: string;
    status: "queued" | "in_progress" | "completed" | "waiting";
    conclusion: "success" | "failure" | "cancelled" | "skipped" | null;
    html_url: string;
    created_at: string;
    updated_at: string;
    environment: string;
  };
  workflow_job_runs?: {
    id: number;
    name: string;
    status: "queued" | "in_progress" | "completed" | "waiting";
    conclusion: "success" | "failure" | "cancelled" | "skipped" | null;
    html_url: string;
    created_at: string;
    updated_at: string;
    environment: string;
  }[];
  reviewers?: (
    | {
        type: "User";
        reviewer: User;
      }
    | {
        type: "Team";
        reviewer: Team;
      }
  )[];
  approver?: User;
  comment?: string;
  repository: Repository;
  organization: Organization;
  sender: User;
  installation?: InstallationLite;
}
export interface WorkflowRun {
  /**
   * The URL to the artifacts for the workflow run.
   */
  artifacts_url: string;
  /**
   * The URL to cancel the workflow run.
   */
  cancel_url: string;
  /**
   * The URL to the associated check suite.
   */
  check_suite_url: string;
  /**
   * The ID of the associated check suite.
   */
  check_suite_id: number;
  /**
   * The node ID of the associated check suite.
   */
  check_suite_node_id: string;
  conclusion:
    | "success"
    | "failure"
    | "neutral"
    | "cancelled"
    | "timed_out"
    | "action_required"
    | "stale"
    | "skipped"
    | null;
  created_at: string;
  event: string;
  head_branch: string;
  head_commit: SimpleCommit;
  head_repository: RepositoryLite;
  /**
   * The SHA of the head commit that points to the version of the workflow being run.
   */
  head_sha: string;
  /**
   * The full path of the workflow
   */
  path: string;
  display_title: string;
  html_url: string;
  /**
   * The ID of the workflow run.
   */
  id: number;
  /**
   * The URL to the jobs for the workflow run.
   */
  jobs_url: string;
  /**
   * The URL to download the logs for the workflow run.
   */
  logs_url: string;
  node_id: string;
  /**
   * The name of the workflow run.
   */
  name: string;
  pull_requests: {
    url: string;
    id: number;
    number: number;
    head: {
      ref: string;
      sha: string;
      repo: RepoRef;
    };
    base: {
      ref: string;
      sha: string;
      repo: RepoRef;
    };
  }[];
  repository: RepositoryLite;
  /**
   * The URL to rerun the workflow run.
   */
  rerun_url: string;
  /**
   * The auto incrementing run number for the workflow run.
   */
  run_number: number;
  status: "requested" | "in_progress" | "completed" | "queued" | "waiting";
  updated_at: string;
  /**
   * The URL to the workflow run.
   */
  url: string;
  /**
   * The ID of the parent workflow.
   */
  workflow_id: number;
  /**
   * The URL to the workflow.
   */
  workflow_url: string;
  /**
   * Attempt number of the run, 1 for first attempt and higher if the workflow was re-run.
   */
  run_attempt: number;
  referenced_workflows?: ReferencedWorkflow[];
  /**
   * The start time of the latest run. Resets on re-run.
   */
  run_started_at: string;
  /**
   * The URL to the previous attempted run of this workflow, if one exists.
   */
  previous_attempt_url: string | null;
  actor: User;
  triggering_actor: User;
}
export interface RepositoryLite {
  /**
   * A template for the API URL to download the repository as an archive.
   */
  archive_url: string;
  /**
   * A template for the API URL to list the available assignees for issues in the repository.
   */
  assignees_url: string;
  /**
   * A template for the API URL to create or retrieve a raw Git blob in the repository.
   */
  blobs_url: string;
  /**
   * A template for the API URL to get information about branches in the repository.
   */
  branches_url: string;
  /**
   * A template for the API URL to get information about collaborators of the repository.
   */
  collaborators_url: string;
  /**
   * A template for the API URL to get information about comments on the repository.
   */
  comments_url: string;
  /**
   * A template for the API URL to get information about commits on the repository.
   */
  commits_url: string;
  /**
   * A template for the API URL to compare two commits or refs.
   */
  compare_url: string;
  /**
   * A template for the API URL to get the contents of the repository.
   */
  contents_url: string;
  /**
   * A template for the API URL to list the contributors to the repository.
   */
  contributors_url: string;
  /**
   * The API URL to list the deployments of the repository.
   */
  deployments_url: string;
  /**
   * The repository description.
   */
  description: string | null;
  /**
   * The API URL to list the downloads on the repository.
   */
  downloads_url: string;
  /**
   * The API URL to list the events of the repository.
   */
  events_url: string;
  /**
   * Whether the repository is a fork.
   */
  fork: boolean;
  /**
   * The API URL to list the forks of the repository.
   */
  forks_url: string;
  /**
   * The full, globally unique, name of the repository.
   */
  full_name: string;
  /**
   * A template for the API URL to get information about Git commits of the repository.
   */
  git_commits_url: string;
  /**
   * A template for the API URL to get information about Git refs of the repository.
   */
  git_refs_url: string;
  /**
   * A template for the API URL to get information about Git tags of the repository.
   */
  git_tags_url: string;
  /**
   * The API URL to list the hooks on the repository.
   */
  hooks_url: string;
  /**
   * The URL to view the repository on GitHub.com.
   */
  html_url: string;
  /**
   * Unique identifier of the repository
   */
  id: number;
  /**
   * A template for the API URL to get information about issue comments on the repository.
   */
  issue_comment_url: string;
  /**
   * A template for the API URL to get information about issue events on the repository.
   */
  issue_events_url: string;
  /**
   * A template for the API URL to get information about issues on the repository.
   */
  issues_url: string;
  /**
   * A template for the API URL to get information about deploy keys on the repository.
   */
  keys_url: string;
  /**
   * A template for the API URL to get information about labels of the repository.
   */
  labels_url: string;
  /**
   * The API URL to get information about the languages of the repository.
   */
  languages_url: string;
  /**
   * The API URL to merge branches in the repository.
   */
  merges_url: string;
  /**
   * A template for the API URL to get information about milestones of the repository.
   */
  milestones_url: string;
  /**
   * The name of the repository.
   */
  name: string;
  /**
   * The GraphQL identifier of the repository.
   */
  node_id: string;
  /**
   * A template for the API URL to get information about notifications on the repository.
   */
  notifications_url: string;
  owner: User;
  /**
   * Whether the repository is private or public.
   */
  private: boolean;
  /**
   * A template for the API URL to get information about pull requests on the repository.
   */
  pulls_url: string;
  /**
   * A template for the API URL to get information about releases on the repository.
   */
  releases_url: string;
  /**
   * The API URL to list the stargazers on the repository.
   */
  stargazers_url: string;
  /**
   * A template for the API URL to get information about statuses of a commit.
   */
  statuses_url: string;
  /**
   * The API URL to list the subscribers on the repository.
   */
  subscribers_url: string;
  /**
   * The API URL to subscribe to notifications for this repository.
   */
  subscription_url: string;
  /**
   * The API URL to get information about tags on the repository.
   */
  tags_url: string;
  /**
   * The API URL to list the teams on the repository.
   */
  teams_url: string;
  /**
   * A template for the API URL to create or retrieve a raw Git tree of the repository.
   */
  trees_url: string;
  /**
   * The URL to get more information about the repository from the GitHub API.
   */
  url: string;
}
export interface DeploymentReviewRejectedEvent {
  action: "rejected";
  workflow_run: WorkflowRun;
  since: string;
  workflow_job_run?: {
    id: number;
    name: string;
    status: "queued" | "in_progress" | "completed" | "waiting";
    conclusion: "success" | "failure" | "cancelled" | "skipped" | null;
    html_url: string;
    created_at: string;
    updated_at: string;
    environment: string;
  };
  workflow_job_runs?: {
    id: number;
    name: string;
    status: "queued" | "in_progress" | "completed" | "waiting";
    conclusion: "success" | "failure" | "cancelled" | "skipped" | null;
    html_url: string;
    created_at: string;
    updated_at: string;
    environment: string;
  }[];
  reviewers?: (
    | {
        type: "User";
        reviewer: User;
      }
    | {
        type: "Team";
        reviewer: Team;
      }
  )[];
  approver?: User;
  comment?: string;
  repository: Repository;
  organization: Organization;
  sender: User;
  installation?: InstallationLite;
}
export interface DeploymentReviewRequestedEvent {
  action: "requested";
  workflow_run: WorkflowRun | null;
  since: string;
  workflow_job_run: {
    id: number;
    name: string;
    status: "queued" | "in_progress" | "completed" | "waiting";
    conclusion: "success" | "failure" | "cancelled" | "skipped" | null;
    html_url: string;
    created_at: string;
    updated_at: string;
    environment: string;
  };
  environment: string;
  reviewers: (
    | {
        type: "User";
        reviewer: User;
      }
    | {
        type: "Team";
        reviewer: Team;
      }
  )[];
  requestor: User;
  repository: Repository;
  organization: Organization;
  sender: User;
  installation?: InstallationLite;
}
export interface DeploymentStatusCreatedEvent {
  action: "created";
  /**
   * The [deployment status](https://docs.github.com/en/rest/reference/deployments#list-deployment-statuses).
   */
  deployment_status: {
    url: string;
    id: number;
    node_id: string;
    /**
     * The new state. Can be `pending`, `success`, `failure`, or `error`.
     */
    state:
      | "pending"
      | "in_progress"
      | "success"
      | "failure"
      | "error"
      | "waiting"
      | "queued";
    creator: User;
    /**
     * The optional human-readable description added to the status.
     */
    description: string;
    environment: string;
    environment_url?: string | "";
    log_url?: string;
    /**
     * The optional link added to the status.
     */
    target_url: string;
    created_at: string;
    updated_at: string;
    deployment_url: string;
    repository_url: string;
    performed_via_github_app?: App | null;
  };
  deployment: Deployment;
  check_run?: {
    /**
     * The id of the check.
     */
    id: number;
    /**
     * The name of the check run.
     */
    name: string;
    node_id: string;
    /**
     * The SHA of the commit that is being checked.
     */
    head_sha: string;
    external_id: string;
    url: string;
    html_url: string;
    details_url: string;
    /**
     * The current status of the check run. Can be `queued`, `in_progress`, or `completed`.
     */
    status: "queued" | "in_progress" | "completed" | "waiting";
    /**
     * The result of the completed check run. Can be one of `success`, `failure`, `neutral`, `cancelled`, `timed_out`, `action_required` or `stale`. This value will be `null` until the check run has completed.
     */
    conclusion:
      | "success"
      | "failure"
      | "neutral"
      | "cancelled"
      | "timed_out"
      | "action_required"
      | "stale"
      | "skipped"
      | null;
    started_at: string;
    completed_at: string | null;
  };
  workflow_run?: DeploymentWorkflowRun;
  workflow?: Workflow;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DiscussionAnsweredEvent {
  action: "answered";
  discussion: Discussion & {
    category: {
      is_answerable: true;
    };
    answer_html_url: string;
    answer_chosen_at: string;
    answer_chosen_by: User;
  };
  answer: {
    id: number;
    node_id: string;
    html_url: string;
    parent_id: null;
    child_comment_count: number;
    repository_url: string;
    discussion_id: number;
    author_association: AuthorAssociation;
    user: User;
    created_at: string;
    updated_at: string;
    body: string;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface Discussion {
  repository_url: string;
  category: DiscussionCategory;
  answer_html_url: string | null;
  answer_chosen_at: string | null;
  answer_chosen_by: User | null;
  html_url: string;
  id: number;
  node_id: string;
  number: number;
  /**
   * The discussion post's title.
   */
  title: string;
  user: User;
  state: "open" | "locked" | "converting";
  locked: boolean;
  comments: number;
  created_at: string;
  updated_at: string;
  author_association: AuthorAssociation;
  active_lock_reason: string | null;
  /**
   * The discussion post's body text.
   */
  body: string;
  reactions?: Reactions;
}
export interface DiscussionCategory {
  id: number;
  node_id: string;
  repository_id: number;
  emoji: string;
  name: string;
  description: string;
  created_at: string;
  updated_at: string;
  slug: string;
  is_answerable: boolean;
}
export interface Reactions {
  url: string;
  total_count: number;
  "+1": number;
  "-1": number;
  laugh: number;
  hooray: number;
  confused: number;
  heart: number;
  rocket: number;
  eyes: number;
}
export interface DiscussionCategoryChangedEvent {
  changes: {
    category: {
      from: DiscussionCategory;
    };
  };
  action: "category_changed";
  discussion: Discussion;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DiscussionCreatedEvent {
  action: "created";
  discussion: Discussion & {
    state: "open" | "converting";
    locked: false;
    answer_html_url: null;
    answer_chosen_at: null;
    answer_chosen_by: null;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DiscussionDeletedEvent {
  action: "deleted";
  discussion: Discussion;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DiscussionEditedEvent {
  changes?: {
    title?: {
      from: string;
    };
    body?: {
      from: string;
    };
  };
  action: "edited";
  discussion: Discussion;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DiscussionLabeledEvent {
  action: "labeled";
  discussion: Discussion;
  label: Label;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DiscussionLockedEvent {
  action: "locked";
  discussion: Discussion & {
    state: "locked";
    locked: true;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DiscussionPinnedEvent {
  action: "pinned";
  discussion: Discussion;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DiscussionTransferredEvent {
  changes: {
    new_discussion: Discussion;
    new_repository: Repository;
  };
  action: "transferred";
  discussion: Discussion;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DiscussionUnansweredEvent {
  action: "unanswered";
  discussion: Discussion & {
    category: {
      is_answerable: true;
    };
    answer_html_url: null;
    answer_chosen_at: null;
    answer_chosen_by: null;
  };
  old_answer: {
    id: number;
    node_id: string;
    html_url: string;
    parent_id: null;
    child_comment_count: number;
    repository_url: string;
    discussion_id: number;
    author_association: AuthorAssociation;
    user: User;
    created_at: string;
    updated_at: string;
    body: string;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DiscussionUnlabeledEvent {
  action: "unlabeled";
  discussion: Discussion;
  label: Label;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DiscussionUnlockedEvent {
  action: "unlocked";
  discussion: Discussion & {
    state: "open";
    locked: false;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DiscussionUnpinnedEvent {
  action: "unpinned";
  discussion: Discussion;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface DiscussionCommentCreatedEvent {
  action: "created";
  comment: {
    id: number;
    node_id: string;
    html_url: string;
    parent_id: number | null;
    child_comment_count: number;
    repository_url: string;
    discussion_id: number;
    author_association: AuthorAssociation;
    user: User;
    created_at: string;
    updated_at: string;
    /**
     * The main text of the comment.
     */
    body: string;
    reactions: Reactions;
  };
  discussion: Discussion;
  repository: Repository;
  sender: User;
  installation: InstallationLite;
  organization?: Organization;
}
export interface DiscussionCommentDeletedEvent {
  action: "deleted";
  comment: {
    id: number;
    node_id: string;
    html_url: string;
    parent_id: number | null;
    child_comment_count: number;
    repository_url: string;
    discussion_id: number;
    author_association: AuthorAssociation;
    user: User;
    created_at: string;
    updated_at: string;
    /**
     * The main text of the comment.
     */
    body: string;
    reactions: Reactions;
  };
  discussion: Discussion;
  repository: Repository;
  sender: User;
  installation: InstallationLite;
  organization?: Organization;
}
export interface DiscussionCommentEditedEvent {
  changes: {
    body: {
      from: string;
    };
  };
  action: "edited";
  comment: {
    id: number;
    node_id: string;
    html_url: string;
    parent_id: number | null;
    child_comment_count: number;
    repository_url: string;
    discussion_id: number;
    author_association: AuthorAssociation;
    user: User;
    created_at: string;
    updated_at: string;
    /**
     * The main text of the comment.
     */
    body: string;
    reactions: Reactions;
  };
  discussion: Discussion;
  repository: Repository;
  sender: User;
  installation: InstallationLite;
  organization?: Organization;
}
/**
 * A user forks a repository.
 */
export interface ForkEvent {
  /**
   * The created [`repository`](https://docs.github.com/en/rest/reference/repos#get-a-repository) resource.
   */
  forkee: Repository & {
    fork?: true;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface GithubAppAuthorizationRevokedEvent {
  action: "revoked";
  sender: User;
}
/**
 * A wiki page is created or updated.
 */
export interface GollumEvent {
  /**
   * The pages that were updated.
   */
  pages: {
    /**
     * The name of the page.
     */
    page_name: string;
    /**
     * The current page title.
     */
    title: string;
    summary: null;
    /**
     * The action that was performed on the page. Can be `created` or `edited`.
     */
    action: "created" | "edited";
    /**
     * The latest commit SHA of the page.
     */
    sha: string;
    /**
     * Points to the HTML wiki page.
     */
    html_url: string;
  }[];
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface InstallationCreatedEvent {
  action: "created";
  installation: Installation;
  /**
   * An array of repository objects that the installation can access.
   */
  repositories?: {
    /**
     * Unique identifier of the repository
     */
    id: number;
    node_id: string;
    /**
     * The name of the repository.
     */
    name: string;
    full_name: string;
    /**
     * Whether the repository is private or public.
     */
    private: boolean;
  }[];
  requester?: User;
  sender: User;
}
/**
 * The GitHub App installation.
 */
export interface Installation {
  /**
   * The ID of the installation.
   */
  id: number;
  account: User;
  /**
   * Describe whether all repositories have been selected or there's a selection involved
   */
  repository_selection: "all" | "selected";
  access_tokens_url: string;
  repositories_url: string;
  html_url: string;
  app_id: number;
  app_slug?: string;
  /**
   * The ID of the user or organization this token is being scoped to.
   */
  target_id: number;
  target_type: "User" | "Organization";
  permissions: {
    /**
     * The level of permission granted to the access token for GitHub Actions workflows, workflow runs, and artifacts.
     */
    actions?: "read" | "write";
    /**
     * The level of permission granted to the access token for repository creation, deletion, settings, teams, and collaborators creation.
     */
    administration?: "read" | "write";
    blocking?: "read" | "write";
    /**
     * The level of permission granted to the access token for checks on code.
     */
    checks?: "read" | "write";
    content_references?: "read" | "write";
    /**
     * The level of permission granted to the access token for repository contents, commits, branches, downloads, releases, and merges.
     */
    contents?: "read" | "write";
    /**
     * The level of permission granted to the access token for deployments and deployment statuses.
     */
    deployments?: "read" | "write";
    discussions?: "read" | "write";
    emails?: "read" | "write";
    /**
     * The level of permission granted to the access token for managing repository environments.
     */
    environments?: "read" | "write";
    /**
     * The level of permission granted to the access token for issues and related comments, assignees, labels, and milestones.
     */
    issues?: "read" | "write";
    /**
     * The level of permission granted to the access token for organization teams and members.
     */
    members?: "read" | "write";
    merge_queues?: "read" | "write";
    /**
     * The level of permission granted to the access token to search repositories, list collaborators, and access repository metadata.
     */
    metadata?: "read" | "write";
    /**
     * The level of permission granted to the access token to manage access to an organization.
     */
    organization_administration?: "read" | "write";
    organization_events?: "read" | "write";
    /**
     * The level of permission granted to the access token to manage the post-receive hooks for an organization.
     */
    organization_hooks?: "read" | "write";
    /**
     * The level of permission granted to the access token for organization packages published to GitHub Packages.
     */
    organization_packages?: "read" | "write";
    /**
     * The level of permission granted to the access token for viewing an organization's plan.
     */
    organization_plan?: "read" | "write";
    /**
     * The level of permission granted to the access token to manage organization projects and projects beta (where available).
     */
    organization_projects?: "read" | "write";
    /**
     * The level of permission granted to the access token to manage organization secrets.
     */
    organization_secrets?: "read" | "write";
    /**
     * The level of permission granted to the access token to view and manage GitHub Actions self-hosted runners available to an organization.
     */
    organization_self_hosted_runners?: "read" | "write";
    /**
     * The level of permission granted to the access token to view and manage users blocked by the organization.
     */
    organization_user_blocking?: "read" | "write";
    /**
     * The level of permission granted to the access token for packages published to GitHub Packages.
     */
    packages?: "read" | "write";
    /**
     * The level of permission granted to the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds.
     */
    pages?: "read" | "write";
    /**
     * The level of permission granted to the access token for pull requests and related comments, assignees, labels, milestones, and merges.
     */
    pull_requests?: "read" | "write";
    /**
     * The level of permission granted to the access token to manage the post-receive hooks for a repository.
     */
    repository_hooks?: "read" | "write";
    /**
     * The level of permission granted to the access token to manage repository projects, columns, and cards.
     */
    repository_projects?: "read" | "write";
    /**
     * The level of permission granted to the access token to view and manage secret scanning alerts.
     */
    secret_scanning_alerts?: "read" | "write";
    /**
     * The level of permission granted to the access token to manage repository secrets.
     */
    secrets?: "read" | "write";
    /**
     * The level of permission granted to the access token to view and manage security events like code scanning alerts.
     */
    security_events?: "read" | "write";
    security_scanning_alert?: "read" | "write";
    /**
     * The level of permission granted to the access token to manage just a single file.
     */
    single_file?: "read" | "write";
    /**
     * The level of permission granted to the access token for commit statuses.
     */
    statuses?: "read" | "write";
    /**
     * The level of permission granted to the access token to manage team discussions and related comments.
     */
    team_discussions?: "read" | "write";
    /**
     * The level of permission granted to the access token to manage Dependabot alerts.
     */
    vulnerability_alerts?: "read" | "write";
    /**
     * The level of permission granted to the access token to update GitHub Actions workflow files.
     */
    workflows?: "read" | "write";
  };
  events: (
    | "branch_protection_rule"
    | "check_run"
    | "check_suite"
    | "code_scanning_alert"
    | "commit_comment"
    | "create"
    | "delete"
    | "deployment"
    | "deployment_review"
    | "deployment_status"
    | "deploy_key"
    | "discussion"
    | "discussion_comment"
    | "fork"
    | "gollum"
    | "issues"
    | "issue_comment"
    | "label"
    | "member"
    | "membership"
    | "merge_group"
    | "merge_queue_entry"
    | "milestone"
    | "organization"
    | "org_block"
    | "page_build"
    | "project"
    | "projects_v2_item"
    | "project_card"
    | "project_column"
    | "public"
    | "pull_request"
    | "pull_request_review"
    | "pull_request_review_comment"
    | "pull_request_review_thread"
    | "push"
    | "registry_package"
    | "release"
    | "repository"
    | "repository_dispatch"
    | "secret_scanning_alert"
    | "secret_scanning_alert_location"
    | "security_and_analysis"
    | "star"
    | "status"
    | "team"
    | "team_add"
    | "watch"
    | "workflow_dispatch"
    | "workflow_job"
    | "workflow_run"
  )[];
  created_at: string | number;
  updated_at: string | number;
  single_file_name: string | null;
  has_multiple_single_files?: boolean;
  single_file_paths?: string[];
  suspended_by: User | null;
  suspended_at: string | null;
}
export interface InstallationDeletedEvent {
  action: "deleted";
  installation: Installation;
  /**
   * An array of repository objects that the installation can access.
   */
  repositories?: {
    /**
     * Unique identifier of the repository
     */
    id: number;
    node_id: string;
    /**
     * The name of the repository.
     */
    name: string;
    full_name: string;
    /**
     * Whether the repository is private or public.
     */
    private: boolean;
  }[];
  requester?: null;
  sender: User;
}
export interface InstallationNewPermissionsAcceptedEvent {
  action: "new_permissions_accepted";
  installation: Installation;
  /**
   * An array of repository objects that the installation can access.
   */
  repositories?: {
    /**
     * Unique identifier of the repository
     */
    id: number;
    node_id: string;
    /**
     * The name of the repository.
     */
    name: string;
    full_name: string;
    /**
     * Whether the repository is private or public.
     */
    private: boolean;
  }[];
  requester?: null;
  sender: User;
}
export interface InstallationSuspendEvent {
  action: "suspend";
  installation: Installation & {
    suspended_by: User;
    suspended_at: string;
  };
  /**
   * An array of repository objects that the installation can access.
   */
  repositories?: {
    /**
     * Unique identifier of the repository
     */
    id: number;
    node_id: string;
    /**
     * The name of the repository.
     */
    name: string;
    full_name: string;
    /**
     * Whether the repository is private or public.
     */
    private: boolean;
  }[];
  requester?: null;
  sender: User;
}
export interface InstallationUnsuspendEvent {
  action: "unsuspend";
  installation: Installation & {
    suspended_by: null;
    suspended_at: null;
  };
  /**
   * An array of repository objects that the installation can access.
   */
  repositories?: {
    /**
     * Unique identifier of the repository
     */
    id: number;
    node_id: string;
    /**
     * The name of the repository.
     */
    name: string;
    full_name: string;
    /**
     * Whether the repository is private or public.
     */
    private: boolean;
  }[];
  requester?: null;
  sender: User;
}
export interface InstallationRepositoriesAddedEvent {
  action: "added";
  installation: Installation;
  /**
   * Describe whether all repositories have been selected or there's a selection involved
   */
  repository_selection: "all" | "selected";
  /**
   * An array of repository objects, which were added to the installation.
   */
  repositories_added: {
    /**
     * Unique identifier of the repository
     */
    id: number;
    node_id: string;
    /**
     * The name of the repository.
     */
    name: string;
    full_name: string;
    /**
     * Whether the repository is private or public.
     */
    private: boolean;
  }[];
  /**
   * An array of repository objects, which were removed from the installation.
   *
   * @maxItems 0
   */
  repositories_removed: [];
  requester: User | null;
  sender: User;
}
export interface InstallationRepositoriesRemovedEvent {
  action: "removed";
  installation: Installation;
  /**
   * Describe whether all repositories have been selected or there's a selection involved
   */
  repository_selection: "all" | "selected";
  /**
   * An array of repository objects, which were added to the installation.
   *
   * @maxItems 0
   */
  repositories_added: [];
  /**
   * An array of repository objects, which were removed from the installation.
   */
  repositories_removed: {
    /**
     * Unique identifier of the repository
     */
    id: number;
    node_id: string;
    /**
     * The name of the repository.
     */
    name: string;
    full_name: string;
    /**
     * Whether the repository is private or public.
     */
    private: boolean;
  }[];
  requester: User | null;
  sender: User;
}
/**
 * Somebody renamed the user or organization account that a GitHub App is installed on.
 */
export interface InstallationTargetRenamedEvent {
  changes: {
    login?: {
      from: string;
    };
    slug?: {
      from: string;
    };
  };
  action: "renamed";
  account: {
    avatar_url: string;
    created_at?: string;
    description?: null;
    events_url?: string;
    followers?: number;
    followers_url?: string;
    following?: number;
    following_url?: string;
    gists_url?: string;
    gravatar_id?: string;
    has_organization_projects?: boolean;
    has_repository_projects?: boolean;
    hooks_url?: string;
    html_url: string;
    id: number;
    is_verified?: boolean;
    issues_url?: string;
    login?: string;
    members_url?: string;
    name?: string;
    node_id: string;
    organizations_url?: string;
    public_gists?: number;
    public_members_url?: string;
    public_repos?: number;
    received_events_url?: string;
    repos_url?: string;
    site_admin?: boolean;
    slug?: string;
    starred_url?: string;
    subscriptions_url?: string;
    type?: "Bot" | "User" | "Organization";
    updated_at?: string;
    url?: string;
    website_url?: null;
  };
  repository?: Repository;
  sender?: User;
  installation: InstallationLite;
  organization?: Organization;
  target_type: string;
}
export interface IssueCommentCreatedEvent {
  action: "created";
  /**
   * The [issue](https://docs.github.com/en/rest/reference/issues) the comment belongs to.
   */
  issue: Issue & {
    assignee: User | null;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state: "open" | "closed";
    locked: boolean;
    labels: Label[];
  };
  comment: IssueComment;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
/**
 * The [issue](https://docs.github.com/en/rest/reference/issues) itself.
 */
export interface Issue {
  /**
   * URL for the issue
   */
  url: string;
  repository_url: string;
  labels_url: string;
  comments_url: string;
  events_url: string;
  html_url: string;
  id: number;
  node_id: string;
  /**
   * Number uniquely identifying the issue within its repository
   */
  number: number;
  /**
   * Title of the issue
   */
  title: string;
  user: User;
  labels?: Label[];
  /**
   * State of the issue; either 'open' or 'closed'
   */
  state?: "open" | "closed";
  locked?: boolean;
  assignee?: User | null;
  assignees: User[];
  milestone: Milestone | null;
  comments: number;
  created_at: string;
  updated_at: string;
  closed_at: string | null;
  author_association: AuthorAssociation;
  active_lock_reason: "resolved" | "off-topic" | "too heated" | "spam" | null;
  draft?: boolean;
  performed_via_github_app?: App | null;
  pull_request?: {
    url?: string;
    html_url?: string;
    diff_url?: string;
    patch_url?: string;
    merged_at?: string | null;
  };
  /**
   * Contents of the issue
   */
  body: string | null;
  reactions: Reactions;
  timeline_url?: string;
  /**
   * The reason for the current state
   */
  state_reason?: string | null;
}
/**
 * The [comment](https://docs.github.com/en/rest/reference/issues#comments) itself.
 */
export interface IssueComment {
  /**
   * URL for the issue comment
   */
  url: string;
  html_url: string;
  issue_url: string;
  /**
   * Unique identifier of the issue comment
   */
  id: number;
  node_id: string;
  user: User;
  created_at: string;
  updated_at: string;
  author_association: AuthorAssociation;
  /**
   * Contents of the issue comment
   */
  body: string;
  reactions: Reactions;
  performed_via_github_app: App | null;
}
export interface IssueCommentDeletedEvent {
  action: "deleted";
  /**
   * The [issue](https://docs.github.com/en/rest/reference/issues) the comment belongs to.
   */
  issue: Issue & {
    assignee: User | null;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state: "open" | "closed";
    locked: boolean;
    labels: Label[];
  };
  comment: IssueComment;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface IssueCommentEditedEvent {
  action: "edited";
  /**
   * The changes to the comment.
   */
  changes: {
    body?: {
      /**
       * The previous version of the body.
       */
      from: string;
    };
  };
  /**
   * The [issue](https://docs.github.com/en/rest/reference/issues) the comment belongs to.
   */
  issue: Issue & {
    assignee: User | null;
    /**
     * State of the issue; either 'open' or 'closed'
     */
    state: "open" | "closed";
    locked: boolean;
    labels: Label[];
  };
  comment: IssueComment;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
/**
 * Activity related to an issue. The type of activity is specified in the action property.
 */
export interface IssuesAssignedEvent {
  /**
   * The action that was performed.
   */
  action: "assigned";
  issue: Issue;
  /**
   * The optional user who was assigned or unassigned from the issue.
   */
  assignee?: User | null;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface IssuesClosedEvent {
  /**
   * The action that was performed.
   */
  action: "closed";
  /**
   * The [issue](https://docs.github.com/en/rest/reference/issues) itself.
   */
  issue: Issue & {
    state: "closed";
    closed_at: string;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface IssuesDeletedEvent {
  action: "deleted";
  issue: Issue;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface IssuesDemilestonedEvent {
  action: "demilestoned";
  issue: Issue & {
    milestone: null;
  };
  milestone: Milestone;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface IssuesEditedEvent {
  action: "edited";
  issue: Issue;
  label?: Label;
  /**
   * The changes to the issue.
   */
  changes: {
    body?: {
      /**
       * The previous version of the body.
       */
      from: string;
    };
    title?: {
      /**
       * The previous version of the title.
       */
      from: string;
    };
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface IssuesLabeledEvent {
  action: "labeled";
  issue: Issue;
  label?: Label;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface IssuesLockedEvent {
  action: "locked";
  issue: Issue & {
    locked: true;
    active_lock_reason: "resolved" | "off-topic" | "too heated" | "spam" | null;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface IssuesMilestonedEvent {
  action: "milestoned";
  issue: Issue & {
    milestone: Milestone;
  };
  milestone: Milestone;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface IssuesOpenedEvent {
  action: "opened";
  changes?: {
    old_issue: Issue;
    old_repository: Repository;
  };
  issue: Issue & {
    state: "open";
    closed_at: null;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface IssuesPinnedEvent {
  action: "pinned";
  issue: Issue;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface IssuesReopenedEvent {
  action: "reopened";
  issue: Issue & {
    state: "open";
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface IssuesTransferredEvent {
  action: "transferred";
  changes: {
    new_issue: Issue;
    new_repository: Repository;
  };
  issue: Issue;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface IssuesUnassignedEvent {
  /**
   * The action that was performed.
   */
  action: "unassigned";
  issue: Issue;
  /**
   * The optional user who was assigned or unassigned from the issue.
   */
  assignee?: User | null;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface IssuesUnlabeledEvent {
  action: "unlabeled";
  issue: Issue;
  label?: Label;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface IssuesUnlockedEvent {
  action: "unlocked";
  issue: Issue & {
    locked: false;
    active_lock_reason: null;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface IssuesUnpinnedEvent {
  action: "unpinned";
  issue: Issue;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface LabelCreatedEvent {
  action: "created";
  label: Label;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface LabelDeletedEvent {
  action: "deleted";
  label: Label;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface LabelEditedEvent {
  action: "edited";
  label: Label;
  /**
   * The changes to the label if the action was `edited`.
   */
  changes?: {
    color?: {
      /**
       * The previous version of the color if the action was `edited`.
       */
      from: string;
    };
    name?: {
      /**
       * The previous version of the name if the action was `edited`.
       */
      from: string;
    };
    description?: {
      /**
       * The previous version of the description if the action was `edited`.
       */
      from: string;
    };
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface MarketplacePurchaseCancelledEvent {
  action: "cancelled";
  effective_date: string;
  sender: {
    login: string;
    id: number;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
    email: string;
  };
  marketplace_purchase: MarketplacePurchase & {
    next_billing_date: string;
  };
  previous_marketplace_purchase?: MarketplacePurchase;
}
export interface MarketplacePurchase {
  account: {
    type: string;
    id: number;
    node_id: string;
    login: string;
    organization_billing_email: string;
  };
  billing_cycle: string;
  unit_count: number;
  on_free_trial: boolean;
  free_trial_ends_on: string | null;
  next_billing_date?: string;
  plan: {
    id: number;
    name: string;
    description: string;
    monthly_price_in_cents: number;
    yearly_price_in_cents: number;
    price_model: string;
    has_free_trial: boolean;
    unit_name: string | null;
    bullets: string[];
  };
}
export interface MarketplacePurchaseChangedEvent {
  action: "changed";
  effective_date: string;
  sender: {
    login: string;
    id: number;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
    email: string;
  };
  marketplace_purchase: MarketplacePurchase & {
    next_billing_date: string;
  };
  previous_marketplace_purchase?: MarketplacePurchase;
}
export interface MarketplacePurchasePendingChangeEvent {
  action: "pending_change";
  effective_date: string;
  sender: {
    login: string;
    id: number;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
    email: string;
  };
  marketplace_purchase: MarketplacePurchase & {
    next_billing_date: string;
  };
  previous_marketplace_purchase?: MarketplacePurchase;
}
export interface MarketplacePurchasePendingChangeCancelledEvent {
  action: "pending_change_cancelled";
  effective_date: string;
  sender: {
    login: string;
    id: number;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
    email: string;
  };
  marketplace_purchase: MarketplacePurchase & {
    next_billing_date: string;
  };
  previous_marketplace_purchase?: MarketplacePurchase;
}
export interface MarketplacePurchasePurchasedEvent {
  action: "purchased";
  effective_date: string;
  sender: {
    login: string;
    id: number;
    avatar_url: string;
    gravatar_id: string;
    url: string;
    html_url: string;
    followers_url: string;
    following_url: string;
    gists_url: string;
    starred_url: string;
    subscriptions_url: string;
    organizations_url: string;
    repos_url: string;
    events_url: string;
    received_events_url: string;
    type: string;
    site_admin: boolean;
    email: string;
  };
  marketplace_purchase: MarketplacePurchase & {
    next_billing_date: string;
  };
  previous_marketplace_purchase?: MarketplacePurchase;
}
/**
 * Activity related to repository collaborators. The type of activity is specified in the action property.
 */
export interface MemberAddedEvent {
  action: "added";
  changes?: {
    permission?: {
      to: "write" | "admin";
    };
  };
  member: User;
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface MemberEditedEvent {
  action: "edited";
  member: User;
  /**
   * The changes to the collaborator permissions
   */
  changes: {
    old_permission: {
      /**
       * The previous permissions of the collaborator if the action was edited.
       */
      from: string;
    };
  };
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface MemberRemovedEvent {
  action: "removed";
  member: User;
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface MembershipAddedEvent {
  action: "added";
  /**
   * The scope of the membership. Currently, can only be `team`.
   */
  scope: "team";
  member: User;
  sender: User;
  team: Team;
  organization: Organization;
  installation?: InstallationLite;
}
export interface MembershipRemovedEvent {
  action: "removed";
  /**
   * The scope of the membership. Currently, can only be `team`.
   */
  scope: "team" | "organization";
  member: User;
  sender: User;
  /**
   * The [team](https://docs.github.com/en/rest/reference/teams) for the membership.
   */
  team:
    | Team
    | {
        id: number;
        name: string;
        deleted?: boolean;
      };
  organization: Organization;
  installation?: InstallationLite;
}
export interface MergeGroupChecksRequestedEvent {
  action: "checks_requested";
  /**
   * The merge group.
   */
  merge_group: {
    /**
     * The SHA of the merge group.
     */
    head_sha: string;
    /**
     * The full ref of the merge group.
     */
    head_ref: string;
    /**
     * The full ref of the branch the merge group will be merged into.
     */
    base_ref: string;
    /**
     * The SHA of the merge group's parent commit.
     */
    base_sha: string;
    /**
     * An expanded representation of the `head_sha` commit.
     */
    head_commit: {
      id: string;
      tree_id: string;
      message: string;
      timestamp: string;
      author: {
        name: string;
        email: string;
      };
      committer: {
        name: string;
        email: string;
      };
    };
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface MergeGroupDestroyedEvent {
  action: "destroyed";
  /**
   * The merge group.
   */
  merge_group: {
    /**
     * The SHA of the merge group.
     */
    head_sha: string;
    /**
     * The full ref of the merge group.
     */
    head_ref: string;
    /**
     * The full ref of the branch the merge group will be merged into.
     */
    base_ref: string;
    /**
     * The SHA of the merge group's parent commit.
     */
    base_sha: string;
    /**
     * An expanded representation of the `head_sha` commit.
     */
    head_commit: {
      id: string;
      tree_id: string;
      message: string;
      timestamp: string;
      author: {
        name: string;
        email: string;
      };
      committer: {
        name: string;
        email: string;
      };
    };
  };
  reason: "dequeued" | "invalidated" | "merged";
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface MetaDeletedEvent {
  action: "deleted";
  /**
   * The id of the modified webhook.
   */
  hook_id: number;
  /**
   * The modified webhook. This will contain different keys based on the type of webhook it is: repository, organization, business, app, or GitHub Marketplace.
   */
  hook: {
    type: string;
    id: number;
    name: string;
    active: boolean;
    events: WebhookEvents;
    /**
     * Configuration object of the webhook
     */
    config: {
      /**
       * The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.
       */
      content_type: "json" | "form";
      /**
       * If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).
       */
      secret?: string;
      /**
       * The URL to which the payloads will be delivered.
       */
      url: string;
      /**
       * Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`.
       */
      insecure_ssl: "0" | "1";
    };
    updated_at: string;
    created_at: string;
  };
  repository: Repository;
  sender: User;
}
export interface MilestoneClosedEvent {
  action: "closed";
  milestone: Milestone & {
    state: "closed";
    closed_at: string;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface MilestoneCreatedEvent {
  action: "created";
  milestone: Milestone & {
    state: "open";
    closed_at: null;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface MilestoneDeletedEvent {
  action: "deleted";
  milestone: Milestone;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface MilestoneEditedEvent {
  action: "edited";
  /**
   * The changes to the milestone if the action was `edited`.
   */
  changes: {
    description?: {
      /**
       * The previous version of the description if the action was `edited`.
       */
      from: string;
    };
    due_on?: {
      /**
       * The previous version of the due date if the action was `edited`.
       */
      from: string;
    };
    title?: {
      /**
       * The previous version of the title if the action was `edited`.
       */
      from: string;
    };
  };
  milestone: Milestone;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface MilestoneOpenedEvent {
  action: "opened";
  milestone: Milestone & {
    state: "open";
    closed_at: null;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface OrgBlockBlockedEvent {
  action: "blocked";
  blocked_user: User;
  sender: User;
  installation?: InstallationLite;
  organization: Organization;
}
export interface OrgBlockUnblockedEvent {
  action: "unblocked";
  blocked_user: User;
  sender: User;
  installation?: InstallationLite;
  organization: Organization;
}
export interface OrganizationDeletedEvent {
  action: "deleted";
  membership?: Membership;
  sender: User;
  installation?: InstallationLite;
  organization: Organization;
}
/**
 * The membership between the user and the organization. Not present when the action is `member_invited`.
 */
export interface Membership {
  url: string;
  /**
   * The state of the user's membership in the team.
   */
  state: string;
  /**
   * The role of the user in the team.
   */
  role: string;
  organization_url: string;
  user: User;
}
export interface OrganizationMemberAddedEvent {
  action: "member_added";
  membership: Membership;
  sender: User;
  installation?: InstallationLite;
  organization: Organization;
}
export interface OrganizationMemberInvitedEvent {
  action: "member_invited";
  /**
   * The invitation for the user or email if the action is `member_invited`.
   */
  invitation: {
    id: number;
    node_id: string;
    login: string;
    email: string | null;
    role: string;
    created_at: string;
    failed_at: string | null;
    failed_reason: string | null;
    inviter: User;
    team_count: number;
    invitation_teams_url: string;
  };
  user: User;
  sender: User;
  installation?: InstallationLite;
  organization: Organization;
}
export interface OrganizationMemberRemovedEvent {
  action: "member_removed";
  membership: Membership;
  sender: User;
  installation?: InstallationLite;
  organization: Organization;
}
export interface OrganizationRenamedEvent {
  changes: {
    login: {
      from: string;
    };
  };
  action: "renamed";
  sender: User;
  installation?: InstallationLite;
  organization: Organization;
}
export interface PackagePublishedEvent {
  action: "published";
  /**
   * Information about the package.
   */
  package: {
    /**
     * Unique identifier of the package.
     */
    id: number;
    /**
     * The name of the package.
     */
    name: string;
    namespace: string;
    description: string | null;
    ecosystem: string;
    /**
     * The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
     */
    package_type:
      | "npm"
      | "maven"
      | "rubygems"
      | "docker"
      | "nuget"
      | "CONTAINER";
    html_url: string;
    created_at: string;
    updated_at: string;
    owner: User;
    /**
     * A version of a software package
     */
    package_version: {
      /**
       * Unique identifier of the package version.
       */
      id: number;
      version: string;
      summary: string;
      /**
       * The name of the package version.
       */
      name: string;
      description: string;
      body?:
        | string
        | {
            repository: {
              repository: Repository;
            };
            info: {
              type: string;
              oid: string;
              mode: number;
              name: string;
              path: string;
              size: number | null;
              collection: boolean;
            };
            attributes: {};
            _formatted: boolean;
          };
      body_html?: string;
      release?: {
        url: string;
        html_url: string;
        id: number;
        tag_name: string;
        target_commitish: string;
        name: string;
        draft: boolean;
        author: User;
        prerelease: boolean;
        created_at: string;
        published_at: string;
      };
      manifest?: string;
      html_url: string;
      tag_name?: string;
      target_commitish?: string;
      target_oid?: string;
      draft?: boolean;
      prerelease?: boolean;
      created_at?: string;
      updated_at?: string;
      /**
       * Package Version Metadata
       */
      metadata: unknown[];
      container_metadata?: {
        labels?: {
          [k: string]: unknown;
        } | null;
        manifest?: {
          [k: string]: unknown;
        } | null;
        tag?: {
          digest?: string;
          name?: string;
        };
      } | null;
      docker_metadata?: unknown[];
      npm_metadata?: PackageNPMMetadata | null;
      nuget_metadata?: PackageNugetMetadata[] | null;
      rubygems_metadata?: unknown[];
      package_files: {
        download_url: string;
        id: number;
        name: string;
        sha256: string;
        sha1: string;
        md5: string;
        content_type: string;
        state: string;
        size: number;
        created_at: string;
        updated_at: string;
      }[];
      package_url?: string;
      author?: User;
      source_url?: string;
      installation_command: string;
    } | null;
    registry: {
      about_url: string;
      name: string;
      type: string;
      url: string;
      vendor: string;
    };
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface PackageNPMMetadata {
  name?: string;
  version?: string;
  npm_user?: string;
  author?: {
    [k: string]: string;
  } | null;
  bugs?: {
    [k: string]: string;
  } | null;
  dependencies?: {
    [k: string]: string;
  };
  dev_dependencies?: {
    [k: string]: string;
  };
  peer_dependencies?: {
    [k: string]: string;
  };
  optional_dependencies?: {
    [k: string]: string;
  };
  description?: string;
  dist?: {
    [k: string]: string;
  } | null;
  git_head?: string;
  homepage?: string;
  license?: string;
  main?: string;
  repository?: {
    [k: string]: string;
  } | null;
  scripts?: {
    [k: string]: unknown;
  };
  id?: string;
  node_version?: string;
  npm_version?: string;
  has_shrinkwrap?: boolean;
  maintainers?: {
    [k: string]: unknown;
  }[];
  contributors?: {
    [k: string]: unknown;
  }[];
  engines?: {
    [k: string]: string;
  };
  keywords?: string[];
  files?: string[];
  bin?: {
    [k: string]: unknown;
  };
  man?: {
    [k: string]: unknown;
  };
  directories?: {
    [k: string]: string;
  } | null;
  os?: string[];
  cpu?: string[];
  readme?: string;
  installation_command?: string;
  release_id?: number;
  commit_oid?: string;
  published_via_actions?: boolean;
  deleted_by_id?: number;
}
export interface PackageNugetMetadata {
  id?: string | number;
  name?: string;
  value?:
    | boolean
    | string
    | number
    | {
        url?: string;
        branch?: string;
        commit?: string;
        type?: string;
      };
}
export interface PackageUpdatedEvent {
  action: "updated";
  /**
   * Information about the package.
   */
  package: {
    /**
     * Unique identifier of the package.
     */
    id: number;
    /**
     * The name of the package.
     */
    name: string;
    namespace: string;
    description: string | null;
    ecosystem: string;
    package_type:
      | "npm"
      | "maven"
      | "rubygems"
      | "docker"
      | "nuget"
      | "CONTAINER";
    html_url: string;
    created_at: string;
    updated_at: string;
    owner: User;
    /**
     * A version of a software package
     */
    package_version: {
      /**
       * Unique identifier of the package version.
       */
      id: number;
      version: string;
      summary: string;
      /**
       * The name of the package version.
       */
      name: string;
      description: string;
      body?:
        | string
        | {
            repository: {
              repository: Repository;
            };
            info: {
              type: string;
              oid: string;
              mode: number;
              name: string;
              path: string;
              size: number | null;
              collection: boolean;
            };
            attributes: {};
            _formatted: boolean;
          };
      body_html?: string;
      release?: {
        url: string;
        html_url: string;
        id: number;
        tag_name: string;
        target_commitish: string;
        name: string;
        draft: boolean;
        author: User;
        prerelease: boolean;
        created_at: string;
        published_at: string;
      };
      manifest?: string;
      html_url: string;
      tag_name?: string;
      target_commitish?: string;
      target_oid?: string;
      draft?: boolean;
      prerelease?: boolean;
      created_at?: string;
      updated_at?: string;
      /**
       * Package Version Metadata
       */
      metadata: unknown[];
      container_metadata?: {
        labels?: {
          [k: string]: unknown;
        } | null;
        manifest?: {
          [k: string]: unknown;
        } | null;
        tag?: {
          digest?: string;
          name?: string;
        };
      } | null;
      docker_metadata?: unknown[];
      npm_metadata?: PackageNPMMetadata | null;
      nuget_metadata?: PackageNugetMetadata[] | null;
      rubygems_metadata?: unknown[];
      package_files: {
        download_url: string;
        id: number;
        name: string;
        sha256: string;
        sha1: string;
        md5: string;
        content_type: string;
        state: string;
        size: number;
        created_at: string;
        updated_at: string;
      }[];
      package_url?: string;
      author?: User;
      source_url?: string;
      installation_command: string;
    } | null;
    registry: {
      about_url: string;
      name: string;
      type: string;
      url: string;
      vendor: string;
    };
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
/**
 * Page Build
 */
export interface PageBuildEvent {
  id: number;
  /**
   * The [List GitHub Pages builds](https://docs.github.com/en/rest/reference/repos#list-github-pages-builds) itself.
   */
  build: {
    url: string;
    status: string;
    error: {
      message: string | null;
    };
    pusher: User;
    commit: string;
    duration: number;
    created_at: string;
    updated_at: string;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface PingEvent {
  zen: string;
  /**
   * The ID of the webhook that triggered the ping.
   */
  hook_id: number;
  /**
   * The [webhook configuration](https://docs.github.com/en/rest/reference/repos#get-a-repository-webhook).
   */
  hook: {
    type: "Repository" | "Organization" | "App";
    id: number;
    name: string;
    active: boolean;
    /**
     * When you register a new GitHub App, GitHub sends a ping event to the **webhook URL** you specified during registration. The event contains the `app_id`, which is required for [authenticating](https://docs.github.com/en/apps/building-integrations/setting-up-and-registering-github-apps/about-authentication-options-for-github-apps) an app.
     */
    app_id?: number;
    events: WebhookEvents;
    /**
     * Configuration object of the webhook
     */
    config: {
      /**
       * The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.
       */
      content_type: "json" | "form";
      /**
       * If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).
       */
      secret?: string;
      /**
       * The URL to which the payloads will be delivered.
       */
      url: string;
      /**
       * Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`.
       */
      insecure_ssl: "0" | "1";
    };
    updated_at: string;
    created_at: string;
    url: string;
    test_url?: string;
    ping_url: string;
    deliveries_url: string;
    last_response?: {
      code: null;
      status: string;
      message: null;
    };
  };
  repository?: Repository;
  sender?: User;
  organization?: Organization;
}
export interface ProjectClosedEvent {
  action: "closed";
  project: Project;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface Project {
  owner_url: string;
  url: string;
  html_url: string;
  columns_url: string;
  id: number;
  node_id: string;
  /**
   * Name of the project
   */
  name: string;
  /**
   * Body of the project
   */
  body: string | null;
  number: number;
  /**
   * State of the project; either 'open' or 'closed'
   */
  state: "open" | "closed";
  creator: User;
  created_at: string;
  updated_at: string;
}
export interface ProjectCreatedEvent {
  action: "created";
  project: Project;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface ProjectDeletedEvent {
  action: "deleted";
  project: Project;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface ProjectEditedEvent {
  action: "edited";
  /**
   * The changes to the project if the action was `edited`.
   */
  changes?: {
    name?: {
      /**
       * The changes to the project if the action was `edited`.
       */
      from: string;
    };
    body?: {
      /**
       * The previous version of the body if the action was `edited`.
       */
      from: string;
    };
  };
  project: Project;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface ProjectReopenedEvent {
  action: "reopened";
  project: Project;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface ProjectCardConvertedEvent {
  action: "converted";
  changes: {
    note: {
      from: string;
    };
  };
  project_card: ProjectCard;
  repository?: Repository;
  sender: User;
  organization?: Organization;
  installation?: InstallationLite;
}
export interface ProjectCard {
  url: string;
  project_url: string;
  column_url: string;
  column_id: number;
  /**
   * The project card's ID
   */
  id: number;
  node_id: string;
  note: string | null;
  /**
   * Whether or not the card is archived
   */
  archived: boolean;
  creator: User;
  created_at: string;
  updated_at: string;
  content_url?: string;
  after_id?: string | number | null;
}
export interface ProjectCardCreatedEvent {
  action: "created";
  project_card: ProjectCard;
  repository?: Repository;
  sender: User;
  organization?: Organization;
  installation?: InstallationLite;
}
export interface ProjectCardDeletedEvent {
  action: "deleted";
  project_card: ProjectCard;
  repository?: Repository;
  sender: User;
  organization?: Organization;
  installation?: InstallationLite;
}
export interface ProjectCardEditedEvent {
  action: "edited";
  changes: {
    note: {
      from: string;
    };
  };
  project_card: ProjectCard;
  repository?: Repository;
  sender: User;
  organization?: Organization;
  installation?: InstallationLite;
}
export interface ProjectCardMovedEvent {
  action: "moved";
  changes?: {
    column_id: {
      from: number;
    };
  };
  project_card: ProjectCard & {
    after_id: number | null;
  };
  repository?: Repository;
  sender: User;
  organization?: Organization;
  installation?: InstallationLite;
}
export interface ProjectColumnCreatedEvent {
  action: "created";
  project_column: ProjectColumn;
  repository?: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface ProjectColumn {
  url: string;
  project_url: string;
  cards_url: string;
  /**
   * The unique identifier of the project column
   */
  id: number;
  node_id: string;
  /**
   * Name of the project column
   */
  name: string;
  created_at: string;
  updated_at: string;
}
export interface ProjectColumnDeletedEvent {
  action: "deleted";
  project_column: ProjectColumn;
  repository?: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface ProjectColumnEditedEvent {
  action: "edited";
  changes: {
    name?: {
      from: string;
    };
  };
  project_column: ProjectColumn;
  repository?: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface ProjectColumnMovedEvent {
  action: "moved";
  project_column: ProjectColumn;
  repository?: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface ProjectsV2ItemArchivedEvent {
  changes: {
    archived_at: {
      from: null;
      to: string;
    };
  };
  action: "archived";
  projects_v2_item: ProjectsV2Item & {
    archived_at: string;
  };
  sender: User;
  organization?: Organization;
  installation?: InstallationLite;
}
/**
 * The project item itself. To find more information about the project item, you can use `node_id` (the node ID of the project item) and `project_node_id` (the node ID of the project) to query information in the GraphQL API. For more information, see "[Using the API to manage projects](https://docs.github.com/en/issues/trying-out-the-new-projects-experience/using-the-api-to-manage-projects)."
 */
export interface ProjectsV2Item {
  id: number;
  node_id: string;
  project_node_id: string;
  content_node_id: string;
  content_type: "DraftIssue" | "Issue" | "PullRequest";
  creator: User;
  created_at: string;
  updated_at: string;
  archived_at: string | null;
}
export interface ProjectsV2ItemConvertedEvent {
  changes: {
    content_type: {
      from: "DraftIssue";
      to: "Issue";
    };
  };
  action: "converted";
  projects_v2_item: ProjectsV2Item & {
    content_type: "Issue";
  };
  sender: User;
  organization?: Organization;
  installation?: InstallationLite;
}
export interface ProjectsV2ItemCreatedEvent {
  action: "created";
  projects_v2_item: ProjectsV2Item & {
    archived_at: null;
  };
  sender: User;
  organization?: Organization;
  installation?: InstallationLite;
}
export interface ProjectsV2ItemDeletedEvent {
  action: "deleted";
  projects_v2_item: ProjectsV2Item;
  sender: User;
  organization?: Organization;
  installation?: InstallationLite;
}
export interface ProjectsV2ItemEditedEvent {
  changes: {
    field_value: {
      field_type: "single_select" | "date" | "number" | "text" | "iteration";
      field_node_id: string;
    };
  };
  action: "edited";
  projects_v2_item: ProjectsV2Item;
  sender: User;
  organization?: Organization;
  installation?: InstallationLite;
}
export interface ProjectsV2ItemReorderedEvent {
  changes: {
    previous_projects_v2_item_node_id: {
      from: string;
      to: string | null;
    };
  };
  action: "reordered";
  projects_v2_item: ProjectsV2Item;
  sender: User;
  organization?: Organization;
  installation?: InstallationLite;
}
export interface ProjectsV2ItemRestoredEvent {
  changes: {
    archived_at: {
      from: string;
      to: null;
    };
  };
  action: "restored";
  projects_v2_item: ProjectsV2Item & {
    archived_at: null;
  };
  sender: User;
  organization?: Organization;
  installation?: InstallationLite;
}
/**
 * When a private repository is made public.
 */
export interface PublicEvent {
  repository: Repository & {
    private: false;
  };
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface PullRequestAssignedEvent {
  action: "assigned";
  /**
   * The pull request number.
   */
  number: number;
  pull_request: PullRequest;
  assignee: User;
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestAutoMergeDisabledEvent {
  action: "auto_merge_disabled";
  number: number;
  pull_request: PullRequest;
  reason: string;
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestAutoMergeEnabledEvent {
  action: "auto_merge_enabled";
  number: number;
  pull_request: PullRequest;
  reason: string;
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestClosedEvent {
  action: "closed";
  /**
   * The pull request number.
   */
  number: number;
  pull_request: PullRequest & {
    /**
     * State of this Pull Request. Either `open` or `closed`.
     */
    state: "closed";
    closed_at: string;
    merged: boolean;
  };
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestConvertedToDraftEvent {
  action: "converted_to_draft";
  /**
   * The pull request number.
   */
  number: number;
  pull_request: PullRequest & {
    closed_at: null;
    merged_at: null;
    /**
     * Indicates whether or not the pull request is a draft.
     */
    draft: true;
    merged: false;
    merged_by: null;
  };
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestDemilestonedEvent {
  action: "demilestoned";
  /**
   * The pull request number.
   */
  number: number;
  pull_request: PullRequest & {
    milestone: Milestone;
  };
  milestone: Milestone;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface PullRequestDequeuedEvent {
  action: "dequeued";
  /**
   * The pull request number.
   */
  number: number;
  /**
   * The reason the pull request was removed from a merge queue.
   */
  reason: string;
  pull_request: PullRequest;
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestEditedEvent {
  action: "edited";
  /**
   * The pull request number.
   */
  number: number;
  /**
   * The changes to the comment if the action was `edited`.
   */
  changes: {
    body?: {
      /**
       * The previous version of the body if the action was `edited`.
       */
      from: string;
    };
    title?: {
      /**
       * The previous version of the title if the action was `edited`.
       */
      from: string;
    };
    base?: {
      ref: {
        from: string;
      };
      sha: {
        from: string;
      };
    };
  };
  pull_request: PullRequest;
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestEnqueuedEvent {
  action: "enqueued";
  /**
   * The pull request number.
   */
  number: number;
  pull_request: PullRequest;
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestLabeledEvent {
  action: "labeled";
  /**
   * The pull request number.
   */
  number: number;
  pull_request: PullRequest;
  label: Label;
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestLockedEvent {
  action: "locked";
  /**
   * The pull request number.
   */
  number: number;
  pull_request: PullRequest;
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestMilestonedEvent {
  action: "milestoned";
  /**
   * The pull request number.
   */
  number: number;
  pull_request: PullRequest & {
    milestone: Milestone;
  };
  milestone: Milestone;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface PullRequestOpenedEvent {
  action: "opened";
  /**
   * The pull request number.
   */
  number: number;
  pull_request: PullRequest & {
    state: "open";
    closed_at: null;
    merged_at: null;
    active_lock_reason: null;
    merged_by: null;
  };
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestReadyForReviewEvent {
  action: "ready_for_review";
  /**
   * The pull request number.
   */
  number: number;
  pull_request: PullRequest & {
    state: "open";
    closed_at: null;
    merged_at: null;
    /**
     * Indicates whether or not the pull request is a draft.
     */
    draft: false;
    merged: boolean;
    merged_by: null;
  };
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestReopenedEvent {
  action: "reopened";
  /**
   * The pull request number.
   */
  number: number;
  pull_request: PullRequest & {
    state: "open";
    closed_at: null;
    merged_at: null;
    merged: boolean;
    merged_by: null;
  };
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestSynchronizeEvent {
  action: "synchronize";
  /**
   * The pull request number.
   */
  number: number;
  before: string;
  after: string;
  pull_request: PullRequest;
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestUnassignedEvent {
  action: "unassigned";
  /**
   * The pull request number.
   */
  number: number;
  pull_request: PullRequest;
  assignee: User;
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestUnlabeledEvent {
  action: "unlabeled";
  /**
   * The pull request number.
   */
  number: number;
  pull_request: PullRequest;
  label: Label;
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestUnlockedEvent {
  action: "unlocked";
  /**
   * The pull request number.
   */
  number: number;
  pull_request: PullRequest;
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestReviewDismissedEvent {
  action: "dismissed";
  review: PullRequestReview & {
    state: "dismissed";
  };
  pull_request: SimplePullRequest;
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
/**
 * The review that was affected.
 */
export interface PullRequestReview {
  /**
   * Unique identifier of the review
   */
  id: number;
  node_id: string;
  user: User;
  /**
   * The text of the review.
   */
  body: string | null;
  /**
   * A commit SHA for the review.
   */
  commit_id: string;
  submitted_at: string | null;
  state: "commented" | "changes_requested" | "approved" | "dismissed";
  html_url: string;
  pull_request_url: string;
  author_association: AuthorAssociation;
  _links: {
    html: Link;
    pull_request: Link;
  };
}
export interface SimplePullRequest {
  url: string;
  id: number;
  node_id: string;
  html_url: string;
  diff_url: string;
  patch_url: string;
  issue_url: string;
  number: number;
  state: "open" | "closed";
  locked: boolean;
  title: string;
  user: User;
  body: string | null;
  created_at: string;
  updated_at: string;
  closed_at: string | null;
  merged_at: string | null;
  merge_commit_sha: string | null;
  assignee: User | null;
  assignees: User[];
  requested_reviewers: (User | Team)[];
  requested_teams: Team[];
  labels: Label[];
  milestone: Milestone | null;
  draft: boolean;
  commits_url: string;
  review_comments_url: string;
  review_comment_url: string;
  comments_url: string;
  statuses_url: string;
  head: {
    label: string;
    ref: string;
    sha: string;
    user: User;
    repo: Repository;
  };
  base: {
    label: string;
    ref: string;
    sha: string;
    user: User;
    repo: Repository;
  };
  _links: {
    self: Link;
    html: Link;
    issue: Link;
    comments: Link;
    review_comments: Link;
    review_comment: Link;
    commits: Link;
    statuses: Link;
  };
  author_association: AuthorAssociation;
  auto_merge: PullRequestAutoMerge | null;
  active_lock_reason: "resolved" | "off-topic" | "too heated" | "spam" | null;
}
export interface PullRequestReviewEditedEvent {
  action: "edited";
  changes: {
    body?: {
      /**
       * The previous version of the body if the action was `edited`.
       */
      from: string;
    };
  };
  review: PullRequestReview;
  pull_request: SimplePullRequest;
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestReviewSubmittedEvent {
  action: "submitted";
  review: PullRequestReview;
  pull_request: SimplePullRequest;
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestReviewCommentCreatedEvent {
  action: "created";
  comment: PullRequestReviewComment;
  pull_request: {
    url: string;
    id: number;
    node_id: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    number: number;
    state: "open" | "closed";
    locked: boolean;
    title: string;
    user: User;
    body: string | null;
    created_at: string;
    updated_at: string;
    closed_at: string | null;
    merged_at: string | null;
    merge_commit_sha: string | null;
    assignee: User | null;
    assignees: User[];
    requested_reviewers: (User | Team)[];
    requested_teams: Team[];
    labels: Label[];
    milestone: Milestone | null;
    draft?: boolean;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    head: {
      label: string;
      ref: string;
      sha: string;
      user: User;
      repo: Repository;
    };
    base: {
      label: string;
      ref: string;
      sha: string;
      user: User;
      repo: Repository;
    };
    _links: {
      self: Link;
      html: Link;
      issue: Link;
      comments: Link;
      review_comments: Link;
      review_comment: Link;
      commits: Link;
      statuses: Link;
    };
    auto_merge?: PullRequestAutoMerge | null;
    author_association: AuthorAssociation;
    active_lock_reason: "resolved" | "off-topic" | "too heated" | "spam" | null;
  };
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
/**
 * The [comment](https://docs.github.com/en/rest/reference/pulls#comments) itself.
 */
export interface PullRequestReviewComment {
  /**
   * URL for the pull request review comment
   */
  url: string;
  /**
   * The ID of the pull request review to which the comment belongs.
   */
  pull_request_review_id: number;
  /**
   * The ID of the pull request review comment.
   */
  id: number;
  /**
   * The node ID of the pull request review comment.
   */
  node_id: string;
  /**
   * The diff of the line that the comment refers to.
   */
  diff_hunk: string;
  /**
   * The relative path of the file to which the comment applies.
   */
  path: string;
  /**
   * The line index in the diff to which the comment applies.
   */
  position: number | null;
  /**
   * The index of the original line in the diff to which the comment applies.
   */
  original_position: number;
  /**
   * The SHA of the commit to which the comment applies.
   */
  commit_id: string;
  /**
   * The SHA of the original commit to which the comment applies.
   */
  original_commit_id: string;
  user: User;
  /**
   * The text of the comment.
   */
  body: string;
  created_at: string;
  updated_at: string;
  /**
   * HTML URL for the pull request review comment.
   */
  html_url: string;
  /**
   * URL for the pull request that the review comment belongs to.
   */
  pull_request_url: string;
  author_association: AuthorAssociation;
  _links: {
    self: Link;
    html: Link;
    pull_request: Link;
  };
  reactions: Reactions;
  /**
   * The first line of the range for a multi-line comment.
   */
  start_line: number | null;
  /**
   * The first line of the range for a multi-line comment.
   */
  original_start_line: number | null;
  /**
   * The side of the first line of the range for a multi-line comment.
   */
  start_side: "LEFT" | "RIGHT" | null;
  /**
   * The line of the blob to which the comment applies. The last line of the range for a multi-line comment
   */
  line: number | null;
  /**
   * The line of the blob to which the comment applies. The last line of the range for a multi-line comment
   */
  original_line: number;
  /**
   * The side of the first line of the range for a multi-line comment.
   */
  side: "LEFT" | "RIGHT";
  /**
   * The comment ID to reply to.
   */
  in_reply_to_id?: number;
  /**
   * The level at which the comment is targeted, can be a diff line or a file.
   */
  subject_type?: "line" | "file";
}
export interface PullRequestReviewCommentDeletedEvent {
  action: "deleted";
  comment: PullRequestReviewComment;
  pull_request: {
    url: string;
    id: number;
    node_id: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    number: number;
    state: "open" | "closed";
    locked: boolean;
    title: string;
    user: User;
    body: string | null;
    created_at: string;
    updated_at: string;
    closed_at: string | null;
    merged_at: string | null;
    merge_commit_sha: string | null;
    assignee: User | null;
    assignees: User[];
    requested_reviewers: (User | Team)[];
    requested_teams: Team[];
    labels: Label[];
    milestone: Milestone | null;
    draft?: boolean;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    head: {
      label: string;
      ref: string;
      sha: string;
      user: User;
      repo: Repository;
    };
    base: {
      label: string;
      ref: string;
      sha: string;
      user: User;
      repo: Repository;
    };
    _links: {
      self: Link;
      html: Link;
      issue: Link;
      comments: Link;
      review_comments: Link;
      review_comment: Link;
      commits: Link;
      statuses: Link;
    };
    auto_merge?: PullRequestAutoMerge | null;
    author_association: AuthorAssociation;
    active_lock_reason: "resolved" | "off-topic" | "too heated" | "spam" | null;
  };
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestReviewCommentEditedEvent {
  action: "edited";
  /**
   * The changes to the comment.
   */
  changes: {
    body?: {
      /**
       * The previous version of the body.
       */
      from: string;
    };
  };
  comment: PullRequestReviewComment;
  pull_request: {
    url: string;
    id: number;
    node_id: string;
    html_url: string;
    diff_url: string;
    patch_url: string;
    issue_url: string;
    number: number;
    state: "open" | "closed";
    locked: boolean;
    title: string;
    user: User;
    body: string | null;
    created_at: string;
    updated_at: string;
    closed_at: string | null;
    merged_at: string | null;
    merge_commit_sha: string | null;
    assignee: User | null;
    assignees: User[];
    requested_reviewers: (User | Team)[];
    requested_teams: Team[];
    labels: Label[];
    milestone: Milestone | null;
    draft?: boolean;
    commits_url: string;
    review_comments_url: string;
    review_comment_url: string;
    comments_url: string;
    statuses_url: string;
    head: {
      label: string;
      ref: string;
      sha: string;
      user: User;
      repo: Repository;
    };
    base: {
      label: string;
      ref: string;
      sha: string;
      user: User;
      repo: Repository;
    };
    _links: {
      self: Link;
      html: Link;
      issue: Link;
      comments: Link;
      review_comments: Link;
      review_comment: Link;
      commits: Link;
      statuses: Link;
    };
    auto_merge?: PullRequestAutoMerge | null;
    author_association: AuthorAssociation;
    active_lock_reason: "resolved" | "off-topic" | "too heated" | "spam" | null;
  };
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestReviewThreadResolvedEvent {
  action: "resolved";
  thread: {
    node_id: string;
    comments: PullRequestReviewComment[];
  };
  pull_request: SimplePullRequest;
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PullRequestReviewThreadUnresolvedEvent {
  action: "unresolved";
  thread: {
    node_id: string;
    comments: PullRequestReviewComment[];
  };
  pull_request: SimplePullRequest;
  repository: Repository;
  installation?: InstallationLite;
  organization?: Organization;
  sender: User;
}
export interface PushEvent {
  /**
   * The full git ref that was pushed. Example: `refs/heads/main` or `refs/tags/v3.14.1`.
   */
  ref: string;
  /**
   * The SHA of the most recent commit on `ref` before the push.
   */
  before: string;
  /**
   * The SHA of the most recent commit on `ref` after the push.
   */
  after: string;
  /**
   * Whether this push created the `ref`.
   */
  created: boolean;
  /**
   * Whether this push deleted the `ref`.
   */
  deleted: boolean;
  /**
   * Whether this push was a force push of the `ref`.
   */
  forced: boolean;
  base_ref: string | null;
  /**
   * URL that shows the changes in this `ref` update, from the `before` commit to the `after` commit. For a newly created `ref` that is directly based on the default branch, this is the comparison between the head of the default branch and the `after` commit. Otherwise, this shows all commits until the `after` commit.
   */
  compare: string;
  /**
   * An array of commit objects describing the pushed commits. (Pushed commits are all commits that are included in the `compare` between the `before` commit and the `after` commit.) The array includes a maximum of 20 commits. If necessary, you can use the [Commits API](https://docs.github.com/en/rest/reference/repos#commits) to fetch additional commits. This limit is applied to timeline events only and isn't applied to webhook deliveries.
   */
  commits: Commit[];
  /**
   * For pushes where `after` is or points to a commit object, an expanded representation of that commit. For pushes where `after` refers to an annotated tag object, an expanded representation of the commit pointed to by the annotated tag.
   */
  head_commit: Commit | null;
  repository: Repository;
  pusher: Committer;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface Commit {
  id: string;
  tree_id: string;
  /**
   * Whether this commit is distinct from any that have been pushed before.
   */
  distinct: boolean;
  /**
   * The commit message.
   */
  message: string;
  /**
   * The ISO 8601 timestamp of the commit.
   */
  timestamp: string;
  /**
   * URL that points to the commit API resource.
   */
  url: string;
  author: Committer;
  committer: Committer;
  /**
   * An array of files added in the commit. For extremely large commits where GitHub is unable to calculate this list in a timely manner, this may be empty even if files were added.
   */
  added: string[];
  /**
   * An array of files modified by the commit. For extremely large commits where GitHub is unable to calculate this list in a timely manner, this may be empty even if files were modified.
   */
  modified: string[];
  /**
   * An array of files removed in the commit. For extremely large commits where GitHub is unable to calculate this list in a timely manner, this may be empty even if files were removed.
   */
  removed: string[];
}
export interface RegistryPackagePublishedEvent {
  action: "published";
  /**
   * Information about the package.
   */
  registry_package: {
    /**
     * Unique identifier of the package.
     */
    id: number;
    /**
     * The name of the package.
     */
    name: string;
    namespace: string;
    description: string | null;
    ecosystem: string;
    /**
     * The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
     */
    package_type:
      | "npm"
      | "maven"
      | "rubygems"
      | "docker"
      | "nuget"
      | "CONTAINER";
    html_url: string;
    created_at: string;
    updated_at: string | null;
    owner: User;
    /**
     * A version of a software package
     */
    package_version: {
      /**
       * Unique identifier of the package version.
       */
      id: number;
      version: string;
      summary: string;
      /**
       * The name of the package version.
       */
      name: string;
      description: string;
      body?:
        | string
        | {
            repository: {
              repository: Repository;
            };
            info: {
              type: string;
              oid: string;
              mode: number;
              name: string;
              path: string;
              size: number | null;
              collection: boolean | null;
            };
            attributes?: {
              [k: string]: unknown;
            };
            _formatted?: boolean;
          };
      body_html?: string;
      release?: {
        url: string;
        html_url: string;
        id: number;
        tag_name: string;
        target_commitish: string;
        name: string;
        draft: boolean;
        author: User;
        prerelease: boolean;
        created_at: string;
        published_at: string;
      };
      manifest?: string;
      html_url: string;
      tag_name?: string;
      target_commitish?: string;
      target_oid?: string;
      draft?: boolean;
      prerelease?: boolean;
      created_at?: string;
      updated_at?: string;
      /**
       * Package Version Metadata
       */
      metadata: unknown[];
      docker_metadata?: unknown[];
      container_metadata?: {
        labels?: {
          description?: string;
          source?: string;
          revision?: string;
          image_url?: string;
          licenses?: string;
          all_labels?: {
            [k: string]: string;
          };
        } | null;
        manifest?: {
          digest?: string;
          media_type?: string;
          uri?: string;
          size?: number;
          config?: {
            digest?: string;
            media_type?: string;
            size?: number;
          };
          layers?: {
            digest?: string;
            media_type?: string;
            size?: number;
          }[];
        } | null;
        tag?: {
          digest?: string;
          name?: string;
        };
      };
      npm_metadata?: PackageNPMMetadata | null;
      nuget_metadata?: PackageNugetMetadata[] | null;
      rubygems_metadata?: unknown[];
      package_files: {
        download_url: string;
        id: number;
        name: string;
        sha256: string;
        sha1: string;
        md5: string;
        content_type: string;
        state: string;
        size: number;
        created_at: string;
        updated_at: string;
      }[];
      package_url?: string;
      author?: {
        avatar_url: string;
        events_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        gravatar_id: string;
        html_url: string;
        id: number;
        login: string;
        node_id: string;
        organizations_url: string;
        received_events_url: string;
        repos_url: string;
        site_admin: boolean;
        starred_url: string;
        subscriptions_url: string;
        type: string;
        url: string;
      };
      source_url?: string;
      installation_command: string;
    } | null;
    registry: {
      about_url: string;
      name: string;
      type: string;
      url: string;
      vendor: string;
    };
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface RegistryPackageUpdatedEvent {
  action: "updated";
  /**
   * Information about the package.
   */
  registry_package: {
    /**
     * Unique identifier of the package.
     */
    id: number;
    /**
     * The name of the package.
     */
    name: string;
    namespace: string;
    description: string | null;
    ecosystem: string;
    /**
     * The type of supported package. Packages in GitHub's Gradle registry have the type `maven`. Docker images pushed to GitHub's Container registry (`ghcr.io`) have the type `container`. You can use the type `docker` to find images that were pushed to GitHub's Docker registry (`docker.pkg.github.com`), even if these have now been migrated to the Container registry.
     */
    package_type:
      | "npm"
      | "maven"
      | "rubygems"
      | "docker"
      | "nuget"
      | "CONTAINER";
    html_url: string;
    created_at: string;
    updated_at: string | null;
    owner: User;
    /**
     * A version of a software package
     */
    package_version: {
      /**
       * Unique identifier of the package version.
       */
      id: number;
      version: string;
      summary: string;
      /**
       * The name of the package version.
       */
      name: string;
      description: string;
      body?:
        | string
        | {
            repository: {
              repository: Repository;
            };
            info: {
              type: string;
              oid: string;
              mode: number;
              name: string;
              path: string;
              size: number | null;
              collection: boolean | null;
            };
            attributes?: {
              [k: string]: unknown;
            };
            _formatted?: boolean;
          };
      body_html?: string;
      release?: {
        url: string;
        html_url: string;
        id: number;
        tag_name: string;
        target_commitish: string;
        name: string;
        draft: boolean;
        author: User;
        prerelease: boolean;
        created_at: string;
        published_at: string;
      };
      manifest?: string;
      html_url: string;
      tag_name?: string;
      target_commitish?: string;
      target_oid?: string;
      draft?: boolean;
      prerelease?: boolean;
      created_at?: string;
      updated_at?: string;
      /**
       * Package Version Metadata
       */
      metadata: unknown[];
      docker_metadata?: unknown[];
      container_metadata?: {
        labels?: {
          description?: string;
          source?: string;
          revision?: string;
          image_url?: string;
          licenses?: string;
          all_labels?: {
            [k: string]: string;
          };
        } | null;
        manifest?: {
          digest?: string;
          media_type?: string;
          uri?: string;
          size?: number;
          config?: {
            digest?: string;
            media_type?: string;
            size?: number;
          };
          layers?: {
            digest?: string;
            media_type?: string;
            size?: number;
          }[];
        } | null;
        tag?: {
          digest?: string;
          name?: string;
        };
      };
      npm_metadata?: PackageNPMMetadata | null;
      nuget_metadata?: PackageNugetMetadata[] | null;
      rubygems_metadata?: unknown[];
      package_files: {
        download_url: string;
        id: number;
        name: string;
        sha256: string;
        sha1: string;
        md5: string;
        content_type: string;
        state: string;
        size: number;
        created_at: string;
        updated_at: string;
      }[];
      package_url?: string;
      author?: {
        avatar_url: string;
        events_url: string;
        followers_url: string;
        following_url: string;
        gists_url: string;
        gravatar_id: string;
        html_url: string;
        id: number;
        login: string;
        node_id: string;
        organizations_url: string;
        received_events_url: string;
        repos_url: string;
        site_admin: boolean;
        starred_url: string;
        subscriptions_url: string;
        type: string;
        url: string;
      };
      source_url?: string;
      installation_command: string;
    } | null;
    registry: {
      about_url: string;
      name: string;
      type: string;
      url: string;
      vendor: string;
    };
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface ReleaseCreatedEvent {
  action: "created";
  release: Release;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
/**
 * The [release](https://docs.github.com/en/rest/reference/repos/#get-a-release) object.
 */
export interface Release {
  url: string;
  assets_url: string;
  upload_url: string;
  html_url: string;
  id: number;
  node_id: string;
  /**
   * The name of the tag.
   */
  tag_name: string;
  /**
   * Specifies the commitish value that determines where the Git tag is created from.
   */
  target_commitish: string;
  name: string;
  /**
   * Whether the release is a draft or published
   */
  draft: boolean;
  author: User;
  /**
   * Whether the release is identified as a prerelease or a full release.
   */
  prerelease: boolean;
  created_at: string | null;
  published_at: string | null;
  assets: ReleaseAsset[];
  tarball_url: string | null;
  zipball_url: string | null;
  body: string;
  mentions_count?: number;
  reactions?: Reactions;
  discussion_url?: string;
}
/**
 * Data related to a release.
 */
export interface ReleaseAsset {
  url: string;
  browser_download_url: string;
  id: number;
  node_id: string;
  /**
   * The file name of the asset.
   */
  name: string;
  label: string | null;
  /**
   * State of the release asset.
   */
  state: "uploaded";
  content_type: string;
  size: number;
  download_count: number;
  created_at: string;
  updated_at: string;
  uploader?: User;
}
export interface ReleaseDeletedEvent {
  action: "deleted";
  release: Release;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface ReleaseEditedEvent {
  action: "edited";
  changes: {
    body?: {
      /**
       * The previous version of the body if the action was `edited`.
       */
      from: string;
    };
    name?: {
      /**
       * The previous version of the name if the action was `edited`.
       */
      from: string;
    };
  };
  release: Release;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface ReleasePrereleasedEvent {
  action: "prereleased";
  release: Release & {
    /**
     * Whether the release is identified as a prerelease or a full release.
     */
    prerelease: true;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface ReleasePublishedEvent {
  action: "published";
  release: Release & {
    published_at: string;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface ReleaseReleasedEvent {
  action: "released";
  release: Release;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface ReleaseUnpublishedEvent {
  action: "unpublished";
  release: Release & {
    published_at: null;
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface RepositoryArchivedEvent {
  action: "archived";
  repository: Repository & {
    /**
     * Whether the repository is archived.
     */
    archived: true;
  };
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface RepositoryCreatedEvent {
  action: "created";
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface RepositoryDeletedEvent {
  action: "deleted";
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface RepositoryEditedEvent {
  action: "edited";
  changes: {
    description?: {
      from: string | null;
    };
    default_branch?: {
      from: string;
    };
    homepage?: {
      from: string | null;
    };
    topics?: {
      from: string[];
    };
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface RepositoryPrivatizedEvent {
  action: "privatized";
  repository: Repository & {
    /**
     * Whether the repository is private or public.
     */
    private: true;
  };
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface RepositoryPublicizedEvent {
  action: "publicized";
  repository: Repository & {
    /**
     * Whether the repository is private or public.
     */
    private: false;
  };
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface RepositoryRenamedEvent {
  action: "renamed";
  changes: {
    repository: {
      name: {
        from: string;
      };
    };
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface RepositoryTransferredEvent {
  action: "transferred";
  changes: {
    owner: {
      from: {
        user?: User;
      };
    };
  };
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface RepositoryUnarchivedEvent {
  action: "unarchived";
  repository: Repository & {
    /**
     * Whether the repository is archived.
     */
    archived: false;
  };
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface RepositoryDispatchEvent {
  action: string;
  branch: string;
  client_payload: {
    [k: string]: unknown;
  };
  repository: Repository;
  sender: User;
  installation: InstallationLite;
  organization?: Organization;
}
export interface RepositoryImportEvent {
  status: "success" | "cancelled" | "failure";
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface RepositoryVulnerabilityAlertCreateEvent {
  action: "create";
  alert: RepositoryVulnerabilityAlertAlert & {
    state: "open";
  };
  repository: Repository;
  sender: GitHubOrg;
  organization?: Organization;
}
/**
 * The security alert of the vulnerable dependency.
 */
export interface RepositoryVulnerabilityAlertAlert {
  id: number;
  number: number;
  node_id: string;
  state: "open" | "dismissed" | "fixed";
  affected_range: string;
  affected_package_name: string;
  dismisser?: User;
  dismiss_reason?: string;
  dismissed_at?: string;
  severity: string;
  ghsa_id: string;
  external_reference: string;
  external_identifier: string;
  fixed_in?: string;
  fixed_at?: string;
  fix_reason?: string;
  created_at: string;
}
export interface RepositoryVulnerabilityAlertDismissEvent {
  action: "dismiss";
  alert: RepositoryVulnerabilityAlertAlert & {
    dismisser: User;
    dismiss_reason: string;
    dismissed_at: string;
    state: "dismissed";
  };
  repository: Repository;
  sender: GitHubOrg;
  organization?: Organization;
}
export interface RepositoryVulnerabilityAlertReopenEvent {
  action: "reopen";
  alert: RepositoryVulnerabilityAlertAlert & {
    state: "open";
  };
  repository: Repository;
  sender: GitHubOrg;
  organization?: Organization;
}
export interface RepositoryVulnerabilityAlertResolveEvent {
  action: "resolve";
  alert: RepositoryVulnerabilityAlertAlert & {
    state: "fixed";
    fixed_at: string;
    fix_reason: string;
    fixed_in: string;
  };
  repository: Repository;
  sender: GitHubOrg;
  organization?: Organization;
}
export interface SecretScanningAlertCreatedEvent {
  action: "created";
  alert: SecretScanningAlert & {
    resolution: null;
    resolved_by: null;
    resolved_at: null;
  };
  repository: Repository;
  organization?: Organization;
  installation?: InstallationLite;
}
export interface SecretScanningAlert {
  /**
   * The security alert number.
   */
  number: number;
  /**
   * The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  created_at: string;
  updated_at: string | null;
  /**
   * The REST API URL of the alert resource.
   */
  url: string;
  /**
   * The GitHub URL of the alert resource.
   */
  html_url: string;
  /**
   * The REST API URL of the code locations for this alert.
   */
  locations_url?: string;
  state: "open" | "resolved";
  /**
   * **Required when the `state` is `resolved`.** The reason for resolving the alert.
   */
  resolution:
    | "false_positive"
    | "wont_fix"
    | "revoked"
    | "used_in_tests"
    | null;
  /**
   * The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  resolved_at: string | null;
  resolved_by: User | null;
  /**
   * An optional comment to resolve an alert.
   */
  resolution_comment?: string | null;
  /**
   * The type of secret that secret scanning detected.
   */
  secret_type: string;
  /**
   * User-friendly name for the detected secret, matching the `secret_type`.
   * For a list of built-in patterns, see "[Secret scanning patterns](https://docs.github.com/code-security/secret-scanning/secret-scanning-patterns#supported-secrets-for-advanced-security)."
   */
  secret_type_display_name?: string;
  /**
   * The secret that was detected.
   */
  secret?: string;
  /**
   * Whether push protection was bypassed for the detected secret.
   */
  push_protection_bypassed?: boolean | null;
  push_protection_bypassed_by?: User | null;
  /**
   * The time that push protection was bypassed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
   */
  push_protection_bypassed_at?: string | null;
}
export interface SecretScanningAlertReopenedEvent {
  action: "reopened";
  /**
   * The secret scanning alert involved in the event.
   */
  alert: {
    number: number;
    secret_type: string;
    resolution: null;
    resolved_by: null;
    resolved_at: null;
  };
  repository: Repository;
  organization?: Organization;
  installation?: InstallationLite;
  sender: User;
}
export interface SecretScanningAlertResolvedEvent {
  action: "resolved";
  alert: SecretScanningAlert & {
    resolution: "false_positive" | "wont_fix" | "revoked" | "used_in_tests";
    resolved_by: User;
    resolved_at: string;
  };
  repository: Repository;
  organization?: Organization;
  installation?: InstallationLite;
  sender: User;
}
export interface SecretScanningAlertRevokedEvent {
  action: "revoked";
  alert: SecretScanningAlert & {
    resolution: "revoked";
    resolved_by: User;
    resolved_at: string;
  };
  repository: Repository;
  organization?: Organization;
  installation?: InstallationLite;
  sender: User;
}
export interface SecretScanningAlertLocationCreatedEvent {
  action: "created";
  alert: SecretScanningAlert;
  location: SecretScanningLocation;
  repository: Repository;
  sender: User;
  organization?: Organization;
  installation?: InstallationLite;
}
/**
 * Represents a 'commit' secret scanning location type. This location type shows that a secret was detected inside a commit to a repository.
 */
export interface SecretScanningLocationCommit {
  /**
   * The file path in the repository
   */
  path: string;
  /**
   * Line number at which the secret starts in the file
   */
  start_line: number;
  /**
   * Line number at which the secret ends in the file
   */
  end_line: number;
  /**
   * The column at which the secret starts within the start line when the file is interpreted as 8BIT ASCII
   */
  start_column: number;
  /**
   * The column at which the secret ends within the end line when the file is interpreted as 8BIT ASCII
   */
  end_column: number;
  /**
   * SHA-1 hash ID of the associated blob
   */
  blob_sha: string;
  /**
   * The API URL to get the associated blob resource
   */
  blob_url: string;
  /**
   * SHA-1 hash ID of the associated commit
   */
  commit_sha: string;
  /**
   * The API URL to get the associated commit resource
   */
  commit_url: string;
}
/**
 * Represents an 'issue_title' secret scanning location type. This location type shows that a secret was detected in the title of an issue.
 */
export interface SecretScanningLocationIssueTitle {
  /**
   * The API URL to get the issue where the secret was detected.
   */
  issue_title_url: string;
}
/**
 * Represents an 'issue_body' secret scanning location type. This location type shows that a secret was detected in the body of an issue.
 */
export interface SecretScanningLocationIssueBody {
  /**
   * The API URL to get the issue where the secret was detected.
   */
  issue_body_url: string;
}
/**
 * Represents an 'issue_comment' secret scanning location type. This location type shows that a secret was detected in a comment on an issue.
 */
export interface SecretScanningLocationIssueComment {
  /**
   * The API URL to get the issue comment where the secret was detected.
   */
  issue_comment_url: string;
}
export interface SecurityAdvisoryPerformedEvent {
  action: "performed";
  /**
   * The details of the security advisory, including summary, description, and severity.
   */
  security_advisory: {
    cvss: {
      vector_string: string | null;
      score: number;
    };
    cwes: {
      cwe_id: string;
      name: string;
    }[];
    ghsa_id: string;
    cve_id: string | null;
    summary: string;
    description: string;
    severity: string;
    identifiers: {
      value: string;
      type: string;
    }[];
    references: {
      url: string;
    }[];
    published_at: string;
    updated_at: string;
    withdrawn_at: string | null;
    vulnerabilities: {
      package: {
        ecosystem: string;
        name: string;
      };
      severity: string;
      vulnerable_version_range: string;
      first_patched_version: {
        identifier: string;
      } | null;
    }[];
  };
}
export interface SecurityAdvisoryPublishedEvent {
  action: "published";
  /**
   * The details of the security advisory, including summary, description, and severity.
   */
  security_advisory: {
    cvss: {
      vector_string: string | null;
      score: number;
    };
    cwes: {
      cwe_id: string;
      name: string;
    }[];
    ghsa_id: string;
    cve_id: string | null;
    summary: string;
    description: string;
    severity: string;
    identifiers: {
      value: string;
      type: string;
    }[];
    references: {
      url: string;
    }[];
    published_at: string;
    updated_at: string;
    withdrawn_at: string | null;
    vulnerabilities: {
      package: {
        ecosystem: string;
        name: string;
      };
      severity: string;
      vulnerable_version_range: string;
      first_patched_version: {
        identifier: string;
      } | null;
    }[];
  };
}
export interface SecurityAdvisoryUpdatedEvent {
  action: "updated";
  /**
   * The details of the security advisory, including summary, description, and severity.
   */
  security_advisory: {
    cvss: {
      vector_string: string | null;
      score: number;
    };
    cwes: {
      cwe_id: string;
      name: string;
    }[];
    ghsa_id: string;
    cve_id: string | null;
    summary: string;
    description: string;
    severity: string;
    identifiers: {
      value: string;
      type: string;
    }[];
    references: {
      url: string;
    }[];
    published_at: string;
    updated_at: string;
    withdrawn_at: string | null;
    vulnerabilities: {
      package: {
        ecosystem: string;
        name: string;
      };
      severity: string;
      vulnerable_version_range: string;
      first_patched_version: {
        identifier: string;
      } | null;
    }[];
  };
}
export interface SecurityAdvisoryWithdrawnEvent {
  action: "withdrawn";
  /**
   * The details of the security advisory, including summary, description, and severity.
   */
  security_advisory: {
    cvss: {
      vector_string: string | null;
      score: number;
    };
    cwes: {
      cwe_id: string;
      name: string;
    }[];
    ghsa_id: string;
    cve_id: string | null;
    summary: string;
    description: string;
    severity: string;
    identifiers: {
      value: string;
      type: string;
    }[];
    references: {
      url: string;
    }[];
    published_at: string;
    updated_at: string;
    withdrawn_at: string;
    vulnerabilities: {
      package: {
        ecosystem: string;
        name: string;
      };
      severity: string;
      vulnerable_version_range: string;
      first_patched_version: {
        identifier: string;
      } | null;
    }[];
  };
}
export interface SponsorshipCancelledEvent {
  action: "cancelled";
  sponsorship: {
    node_id: string;
    created_at: string;
    sponsorable: User;
    sponsor: User;
    privacy_level: string;
    tier: SponsorshipTier;
  };
  sender: User;
}
/**
 * The `tier_changed` and `pending_tier_change` will include the original tier before the change or pending change. For more information, see the pending tier change payload.
 */
export interface SponsorshipTier {
  node_id: string;
  created_at: string;
  description: string;
  monthly_price_in_cents: number;
  monthly_price_in_dollars: number;
  name: string;
  is_one_time: boolean;
  is_custom_amount: boolean;
}
export interface SponsorshipCreatedEvent {
  action: "created";
  sponsorship: {
    node_id: string;
    created_at: string;
    sponsorable: User;
    sponsor: User;
    privacy_level: string;
    tier: SponsorshipTier;
  };
  sender: User;
}
export interface SponsorshipEditedEvent {
  action: "edited";
  sponsorship: {
    node_id: string;
    created_at: string;
    sponsorable: User;
    sponsor: User;
    privacy_level: string;
    tier: SponsorshipTier;
  };
  changes: {
    privacy_level?: {
      /**
       * The `edited` event types include the details about the change when someone edits a sponsorship to change the privacy.
       */
      from: string;
    };
  };
  sender: User;
}
export interface SponsorshipPendingCancellationEvent {
  action: "pending_cancellation";
  sponsorship: {
    node_id: string;
    created_at: string;
    sponsorable: User;
    sponsor: User;
    privacy_level: string;
    tier: SponsorshipTier;
  };
  /**
   * The `pending_cancellation` and `pending_tier_change` event types will include the date the cancellation or tier change will take effect.
   */
  effective_date?: string;
  sender: User;
}
export interface SponsorshipPendingTierChangeEvent {
  action: "pending_tier_change";
  sponsorship: {
    node_id: string;
    created_at: string;
    sponsorable: User;
    sponsor: User;
    privacy_level: string;
    tier: SponsorshipTier;
  };
  /**
   * The `pending_cancellation` and `pending_tier_change` event types will include the date the cancellation or tier change will take effect.
   */
  effective_date?: string;
  changes: {
    tier: {
      from: SponsorshipTier;
    };
  };
  sender: User;
}
export interface SponsorshipTierChangedEvent {
  action: "tier_changed";
  sponsorship: {
    node_id: string;
    created_at: string;
    sponsorable: User;
    sponsor: User;
    privacy_level: string;
    tier: SponsorshipTier;
  };
  changes: {
    tier: {
      from: SponsorshipTier;
    };
  };
  sender: User;
}
export interface StarCreatedEvent {
  action: "created";
  /**
   * The time the star was created. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. Will be `null` for the `deleted` action.
   */
  starred_at: string;
  repository: Repository;
  sender: User;
  organization?: Organization;
  installation?: InstallationLite;
}
export interface StarDeletedEvent {
  action: "deleted";
  /**
   * The time the star was created. This is a timestamp in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`. Will be `null` for the `deleted` action.
   */
  starred_at: null;
  repository: Repository;
  sender: User;
  organization?: Organization;
  installation?: InstallationLite;
}
export interface StatusEvent {
  /**
   * The unique identifier of the status.
   */
  id: number;
  /**
   * The Commit SHA.
   */
  sha: string;
  name: string;
  avatar_url?: string | null;
  /**
   * The optional link added to the status.
   */
  target_url: string | null;
  context: string;
  /**
   * The optional human-readable description added to the status.
   */
  description: string | null;
  /**
   * The new state. Can be `pending`, `success`, `failure`, or `error`.
   */
  state: "pending" | "success" | "failure" | "error";
  commit: {
    sha: string;
    node_id: string;
    commit: {
      author: Committer & {
        date: string;
      };
      committer: Committer & {
        date: string;
      };
      message: string;
      tree: {
        sha: string;
        url: string;
      };
      url: string;
      comment_count: number;
      verification: {
        verified: boolean;
        reason:
          | "expired_key"
          | "not_signing_key"
          | "gpgverify_error"
          | "gpgverify_unavailable"
          | "unsigned"
          | "unknown_signature_type"
          | "no_user"
          | "unverified_email"
          | "bad_email"
          | "unknown_key"
          | "malformed_signature"
          | "invalid"
          | "valid";
        signature: string | null;
        payload: string | null;
      };
    };
    url: string;
    html_url: string;
    comments_url: string;
    author: User | null;
    committer: User | null;
    parents: {
      sha: string;
      url: string;
      html_url: string;
    }[];
  };
  /**
   * An array of branch objects containing the status' SHA. Each branch contains the given SHA, but the SHA may or may not be the head of the branch. The array includes a maximum of 10 branches.
   */
  branches: {
    name: string;
    commit: {
      sha: string;
      url: string;
    };
    protected: boolean;
  }[];
  created_at: string;
  updated_at: string;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface TeamAddedToRepositoryEvent {
  action: "added_to_repository";
  team: Team;
  repository?: Repository;
  sender: User;
  organization: Organization;
  installation?: InstallationLite;
}
export interface TeamCreatedEvent {
  action: "created";
  team: Team;
  repository?: Repository;
  sender: User;
  organization: Organization;
  installation?: InstallationLite;
}
export interface TeamDeletedEvent {
  action: "deleted";
  team: Team;
  repository?: Repository;
  sender: User;
  organization: Organization;
  installation?: InstallationLite;
}
export interface TeamEditedEvent {
  action: "edited";
  /**
   * The changes to the team if the action was `edited`.
   */
  changes: {
    description?: {
      /**
       * The previous version of the description if the action was `edited`.
       */
      from: string;
    };
    name?: {
      /**
       * The previous version of the name if the action was `edited`.
       */
      from: string;
    };
    privacy?: {
      /**
       * The previous version of the team's privacy if the action was `edited`.
       */
      from: string;
    };
    repository?: {
      permissions: {
        from: {
          /**
           * The previous version of the team member's `admin` permission on a repository, if the action was `edited`.
           */
          admin?: boolean;
          /**
           * The previous version of the team member's `pull` permission on a repository, if the action was `edited`.
           */
          pull?: boolean;
          /**
           * The previous version of the team member's `push` permission on a repository, if the action was `edited`.
           */
          push?: boolean;
        };
      };
    };
  };
  team: Team;
  repository?: Repository;
  sender: User;
  organization: Organization;
  installation?: InstallationLite;
}
export interface TeamRemovedFromRepositoryEvent {
  action: "removed_from_repository";
  team: Team;
  repository?: Repository;
  sender: User;
  organization: Organization;
  installation?: InstallationLite;
}
export interface TeamAddEvent {
  team: Team;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization: Organization;
}
export interface WatchStartedEvent {
  action: "started";
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
}
export interface WorkflowDispatchEvent {
  /**
   * Inputs to the workflow. Each key represents the name of the input while it's value represents the value of that input.
   */
  inputs: {
    [k: string]: unknown;
  } | null;
  /**
   * The branch ref from which the workflow was run.
   */
  ref: string;
  repository: Repository;
  sender: User;
  installation?: InstallationLite;
  organization?: Organization;
  /**
   * Relative path to the workflow file which contains the workflow.
   */
  workflow: string;
}
export interface WorkflowJobCompletedEvent {
  action: "completed";
  organization?: Organization;
  installation?: InstallationLite;
  repository: Repository;
  sender: User;
  deployment?: Deployment;
  workflow_job: WorkflowJob & {
    conclusion: "success" | "failure" | "cancelled" | "skipped";
  };
}
/**
 * The workflow job. Many `workflow_job` keys, such as `head_sha`, `conclusion`, and `started_at` are the same as those in a [`check_run`](#check_run) object.
 */
export interface WorkflowJob {
  id: number;
  run_id: number;
  run_attempt: number;
  run_url: string;
  head_sha: string;
  node_id: string;
  name: string;
  check_run_url: string;
  html_url: string;
  url: string;
  /**
   * The current status of the job. Can be `queued`, `in_progress`, or `completed`.
   */
  status: "queued" | "in_progress" | "completed" | "waiting";
  steps: WorkflowStep[];
  conclusion: "success" | "failure" | "cancelled" | "skipped" | null;
  /**
   * Custom labels for the job. Specified by the [`"runs-on"` attribute](https://docs.github.com/en/actions/reference/workflow-syntax-for-github-actions#jobsjob_idruns-on) in the workflow YAML.
   */
  labels: string[];
  /**
   * The ID of the runner that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.
   */
  runner_id: number | null;
  /**
   * The name of the runner that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.
   */
  runner_name: string | null;
  /**
   * The ID of the runner group that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.
   */
  runner_group_id: number | null;
  /**
   * The name of the runner group that is running this job. This will be `null` as long as `workflow_job[status]` is `queued`.
   */
  runner_group_name: string | null;
  started_at: string;
  completed_at: string | null;
  /**
   * The name of the workflow.
   */
  workflow_name: string | null;
  /**
   * The name of the current branch.
   */
  head_branch: string | null;
  created_at: string;
}
export interface WorkflowStepInProgress {
  name: string;
  status: "in_progress";
  conclusion: null;
  number: number;
  started_at: string;
  completed_at: null;
}
export interface WorkflowStepQueued {
  name: string;
  status: "queued";
  conclusion: null;
  number: number;
  started_at: null;
  completed_at: null;
}
export interface WorkflowStepCompleted {
  name: string;
  status: "completed";
  conclusion: "failure" | "skipped" | "success" | "cancelled";
  number: number;
  started_at: string;
  completed_at: string;
}
export interface WorkflowJobInProgressEvent {
  action: "in_progress";
  organization?: Organization;
  installation?: InstallationLite;
  repository: Repository;
  sender: User;
  deployment?: Deployment;
  workflow_job: WorkflowJob & {
    status: "queued" | "in_progress";
  };
}
export interface WorkflowJobQueuedEvent {
  action: "queued";
  organization?: Organization;
  installation?: InstallationLite;
  repository: Repository;
  sender: User;
  deployment?: Deployment;
  workflow_job: WorkflowJob & {
    status: "queued" | "waiting";
  };
}
export interface WorkflowJobWaitingEvent {
  action: "waiting";
  organization?: Organization;
  installation?: InstallationLite;
  repository: Repository;
  sender: User;
  deployment?: Deployment;
  workflow_job: WorkflowJob & {
    status: "waiting";
  };
}
export interface WorkflowRunCompletedEvent {
  action: "completed";
  organization?: Organization;
  repository: Repository;
  sender: User;
  workflow: Workflow;
  workflow_run: WorkflowRun & {
    conclusion:
      | "success"
      | "failure"
      | "neutral"
      | "cancelled"
      | "timed_out"
      | "action_required"
      | "stale"
      | "skipped";
  };
  installation?: InstallationLite;
}
export interface WorkflowRunInProgressEvent {
  action: "in_progress";
  organization?: Organization;
  repository: Repository;
  sender: User;
  workflow: Workflow;
  workflow_run: WorkflowRun;
  installation?: InstallationLite;
}
export interface WorkflowRunRequestedEvent {
  action: "requested";
  organization?: Organization;
  repository: Repository;
  sender: User;
  workflow: Workflow;
  workflow_run: WorkflowRun;
  installation?: InstallationLite;
}

export interface EventPayloadMap {
  branch_protection_configuration: BranchProtectionConfigurationEvent;
  branch_protection_rule: BranchProtectionRuleEvent;
  check_run: CheckRunEvent;
  check_suite: CheckSuiteEvent;
  code_scanning_alert: CodeScanningAlertEvent;
  commit_comment: CommitCommentEvent;
  create: CreateEvent;
  custom_property: CustomPropertyEvent;
  custom_property_values: CustomPropertyValuesEvent;
  delete: DeleteEvent;
  dependabot_alert: DependabotAlertEvent;
  deploy_key: DeployKeyEvent;
  deployment: DeploymentEvent;
  deployment_protection_rule: DeploymentProtectionRuleEvent;
  deployment_review: DeploymentReviewEvent;
  deployment_status: DeploymentStatusEvent;
  discussion: DiscussionEvent;
  discussion_comment: DiscussionCommentEvent;
  fork: ForkEvent;
  github_app_authorization: GithubAppAuthorizationEvent;
  gollum: GollumEvent;
  installation: InstallationEvent;
  installation_repositories: InstallationRepositoriesEvent;
  installation_target: InstallationTargetEvent;
  issue_comment: IssueCommentEvent;
  issues: IssuesEvent;
  label: LabelEvent;
  marketplace_purchase: MarketplacePurchaseEvent;
  member: MemberEvent;
  membership: MembershipEvent;
  merge_group: MergeGroupEvent;
  meta: MetaEvent;
  milestone: MilestoneEvent;
  org_block: OrgBlockEvent;
  organization: OrganizationEvent;
  package: PackageEvent;
  page_build: PageBuildEvent;
  ping: PingEvent;
  project: ProjectEvent;
  project_card: ProjectCardEvent;
  project_column: ProjectColumnEvent;
  projects_v2_item: ProjectsV2ItemEvent;
  public: PublicEvent;
  pull_request: PullRequestEvent;
  pull_request_review: PullRequestReviewEvent;
  pull_request_review_comment: PullRequestReviewCommentEvent;
  pull_request_review_thread: PullRequestReviewThreadEvent;
  push: PushEvent;
  registry_package: RegistryPackageEvent;
  release: ReleaseEvent;
  repository: RepositoryEvent;
  repository_dispatch: RepositoryDispatchEvent;
  repository_import: RepositoryImportEvent;
  repository_vulnerability_alert: RepositoryVulnerabilityAlertEvent;
  secret_scanning_alert: SecretScanningAlertEvent;
  secret_scanning_alert_location: SecretScanningAlertLocationEvent;
  security_advisory: SecurityAdvisoryEvent;
  sponsorship: SponsorshipEvent;
  star: StarEvent;
  status: StatusEvent;
  team: TeamEvent;
  team_add: TeamAddEvent;
  watch: WatchEvent;
  workflow_dispatch: WorkflowDispatchEvent;
  workflow_job: WorkflowJobEvent;
  workflow_run: WorkflowRunEvent;
}

export type Asset = ReleaseAsset;
export type WebhookEvent = Schema;
export type WebhookEventMap = EventPayloadMap;
export type WebhookEventName = keyof EventPayloadMap;
