var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};

// src/button.tsx
import * as React from "react";

// src/utils/parse-padding.ts
function convertToPx(value) {
  let px = 0;
  if (!value) {
    return px;
  }
  if (typeof value === "number") {
    return value;
  }
  const matches = /^([\d.]+)(px|em|rem|%)$/.exec(value);
  if (matches && matches.length === 3) {
    const numValue = parseFloat(matches[1]);
    const unit = matches[2];
    switch (unit) {
      case "px":
        return numValue;
      case "em":
      case "rem":
        px = numValue * 16;
        return px;
      case "%":
        px = numValue / 100 * 600;
        return px;
      default:
        return numValue;
    }
  } else {
    return 0;
  }
}
function parsePadding({
  padding = "",
  paddingTop,
  paddingRight,
  paddingBottom,
  paddingLeft
}) {
  let pt = 0;
  let pr = 0;
  let pb = 0;
  let pl = 0;
  if (typeof padding === "number") {
    pt = padding;
    pr = padding;
    pb = padding;
    pl = padding;
  } else {
    const values = padding.split(/\s+/);
    switch (values.length) {
      case 1:
        pt = convertToPx(values[0]);
        pr = convertToPx(values[0]);
        pb = convertToPx(values[0]);
        pl = convertToPx(values[0]);
        break;
      case 2:
        pt = convertToPx(values[0]);
        pb = convertToPx(values[0]);
        pr = convertToPx(values[1]);
        pl = convertToPx(values[1]);
        break;
      case 3:
        pt = convertToPx(values[0]);
        pr = convertToPx(values[1]);
        pl = convertToPx(values[1]);
        pb = convertToPx(values[2]);
        break;
      case 4:
        pt = convertToPx(values[0]);
        pr = convertToPx(values[1]);
        pb = convertToPx(values[2]);
        pl = convertToPx(values[3]);
        break;
      default:
        break;
    }
  }
  return {
    pt: paddingTop ? convertToPx(paddingTop) : pt,
    pr: paddingRight ? convertToPx(paddingRight) : pr,
    pb: paddingBottom ? convertToPx(paddingBottom) : pb,
    pl: paddingLeft ? convertToPx(paddingLeft) : pl
  };
}

// src/utils/px-to-pt.ts
var pxToPt = (px) => typeof px === "number" && !isNaN(Number(px)) ? px * 3 / 4 : null;

// src/button.tsx
import { jsx, jsxs } from "react/jsx-runtime";
var maxFontWidth = 5;
function computeFontWidthAndSpaceCount(expectedWidth) {
  if (expectedWidth === 0) return [0, 0];
  let smallestSpaceCount = 0;
  const computeRequiredFontWidth = () => {
    if (smallestSpaceCount > 0) {
      return expectedWidth / smallestSpaceCount / 2;
    }
    return Infinity;
  };
  while (computeRequiredFontWidth() > maxFontWidth) {
    smallestSpaceCount++;
  }
  return [computeRequiredFontWidth(), smallestSpaceCount];
}
var Button = React.forwardRef(
  (_a, ref) => {
    var _b = _a, { children, style, target = "_blank" } = _b, props = __objRest(_b, ["children", "style", "target"]);
    var _a2, _b2, _c, _d;
    const { pt, pr, pb, pl } = parsePadding({
      padding: style == null ? void 0 : style.padding,
      paddingLeft: (_a2 = style == null ? void 0 : style.paddingLeft) != null ? _a2 : style == null ? void 0 : style.paddingInline,
      paddingRight: (_b2 = style == null ? void 0 : style.paddingRight) != null ? _b2 : style == null ? void 0 : style.paddingInline,
      paddingTop: (_c = style == null ? void 0 : style.paddingTop) != null ? _c : style == null ? void 0 : style.paddingBlock,
      paddingBottom: (_d = style == null ? void 0 : style.paddingBottom) != null ? _d : style == null ? void 0 : style.paddingBlock
    });
    const y = pt + pb;
    const textRaise = pxToPt(y);
    const [plFontWidth, plSpaceCount] = computeFontWidthAndSpaceCount(pl);
    const [prFontWidth, prSpaceCount] = computeFontWidthAndSpaceCount(pr);
    return /* @__PURE__ */ jsxs(
      "a",
      __spreadProps(__spreadValues({}, props), {
        ref,
        style: buttonStyle(__spreadProps(__spreadValues({}, style), { pt, pr, pb, pl })),
        target,
        children: [
          /* @__PURE__ */ jsx(
            "span",
            {
              dangerouslySetInnerHTML: {
                // The `&#8202;` is as close to `1px` of an empty character as we can get, then, we use the `mso-font-width`
                // to scale it according to what padding the developer wants. `mso-font-width` also does not allow for percentages
                // >= 500% so we need to add extra spaces accordingly.
                //
                // See https://github.com/resend/react-email/issues/1512 for why we do not use letter-spacing instead.
                __html: `<!--[if mso]><i style="mso-font-width:${plFontWidth * 100}%;mso-text-raise:${textRaise}" hidden>${"&#8202;".repeat(
                  plSpaceCount
                )}</i><![endif]-->`
              }
            }
          ),
          /* @__PURE__ */ jsx("span", { style: buttonTextStyle(pb), children }),
          /* @__PURE__ */ jsx(
            "span",
            {
              dangerouslySetInnerHTML: {
                __html: `<!--[if mso]><i style="mso-font-width:${prFontWidth * 100}%" hidden>${"&#8202;".repeat(
                  prSpaceCount
                )}&#8203;</i><![endif]-->`
              }
            }
          )
        ]
      })
    );
  }
);
Button.displayName = "Button";
var buttonStyle = (style) => {
  const _a = style || {}, { pt, pr, pb, pl } = _a, rest = __objRest(_a, ["pt", "pr", "pb", "pl"]);
  return __spreadProps(__spreadValues({
    lineHeight: "100%",
    textDecoration: "none",
    display: "inline-block",
    maxWidth: "100%",
    msoPaddingAlt: "0px"
  }, rest), {
    padding: `${pt}px ${pr}px ${pb}px ${pl}px`
  });
};
var buttonTextStyle = (pb) => {
  return {
    maxWidth: "100%",
    display: "inline-block",
    lineHeight: "120%",
    msoPaddingAlt: "0px",
    msoTextRaise: pxToPt(pb || 0)
  };
};
export {
  Button
};
