"use strict";
var __create = Object.create;
var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(
  // If the importer is in node compatibility mode or this is not an ESM
  // file that has been converted to a CommonJS file using a Babel-
  // compatible transform (i.e. "__esModule" has not been set), then set
  // "default" to the CommonJS "module.exports" for node compatibility.
  isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target,
  mod
));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var index_exports = {};
__export(index_exports, {
  Text: () => Text
});
module.exports = __toCommonJS(index_exports);

// src/text.tsx
var React = __toESM(require("react"));

// src/utils/compute-margins.ts
function parseMarginValue(value) {
  if (typeof value === "number")
    return {
      marginTop: value,
      marginBottom: value,
      marginLeft: value,
      marginRight: value
    };
  if (typeof value === "string") {
    const values = value.toString().trim().split(/\s+/);
    if (values.length === 1) {
      return {
        marginTop: values[0],
        marginBottom: values[0],
        marginLeft: values[0],
        marginRight: values[0]
      };
    }
    if (values.length === 2) {
      return {
        marginTop: values[0],
        marginRight: values[1],
        marginBottom: values[0],
        marginLeft: values[1]
      };
    }
    if (values.length === 3) {
      return {
        marginTop: values[0],
        marginRight: values[1],
        marginBottom: values[2],
        marginLeft: values[1]
      };
    }
    if (values.length === 4) {
      return {
        marginTop: values[0],
        marginRight: values[1],
        marginBottom: values[2],
        marginLeft: values[3]
      };
    }
  }
  return {
    marginTop: void 0,
    marginBottom: void 0,
    marginLeft: void 0,
    marginRight: void 0
  };
}
function computeMargins(properties) {
  let result = {
    marginTop: void 0,
    marginRight: void 0,
    marginBottom: void 0,
    marginLeft: void 0
  };
  for (const [key, value] of Object.entries(properties)) {
    if (key === "margin") {
      result = parseMarginValue(value);
    } else if (key === "marginTop") {
      result.marginTop = value;
    } else if (key === "marginRight") {
      result.marginRight = value;
    } else if (key === "marginBottom") {
      result.marginBottom = value;
    } else if (key === "marginLeft") {
      result.marginLeft = value;
    }
  }
  return result;
}

// src/text.tsx
var import_jsx_runtime = require("react/jsx-runtime");
var Text = React.forwardRef(
  (_a, ref) => {
    var _b = _a, { style } = _b, props = __objRest(_b, ["style"]);
    let modifiedStyle = {};
    if (modifiedStyle.marginBottom === void 0) {
      modifiedStyle.marginBottom = "16px";
    }
    if (modifiedStyle.marginTop === void 0) {
      modifiedStyle.marginTop = "16px";
    }
    modifiedStyle = __spreadValues(__spreadValues({}, modifiedStyle), style);
    const margins = computeMargins(modifiedStyle);
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      "p",
      __spreadProps(__spreadValues({}, props), {
        ref,
        style: __spreadValues(__spreadValues({
          fontSize: "14px",
          lineHeight: "24px"
        }, style), margins)
      })
    );
  }
);
Text.displayName = "Text";
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  Text
});
