var __defProp = Object.defineProperty;
var __defProps = Object.defineProperties;
var __getOwnPropDescs = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps = (a, b) => __defProps(a, __getOwnPropDescs(b));
var __objRest = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};

// src/text.tsx
import * as React from "react";

// src/utils/compute-margins.ts
function parseMarginValue(value) {
  if (typeof value === "number")
    return {
      marginTop: value,
      marginBottom: value,
      marginLeft: value,
      marginRight: value
    };
  if (typeof value === "string") {
    const values = value.toString().trim().split(/\s+/);
    if (values.length === 1) {
      return {
        marginTop: values[0],
        marginBottom: values[0],
        marginLeft: values[0],
        marginRight: values[0]
      };
    }
    if (values.length === 2) {
      return {
        marginTop: values[0],
        marginRight: values[1],
        marginBottom: values[0],
        marginLeft: values[1]
      };
    }
    if (values.length === 3) {
      return {
        marginTop: values[0],
        marginRight: values[1],
        marginBottom: values[2],
        marginLeft: values[1]
      };
    }
    if (values.length === 4) {
      return {
        marginTop: values[0],
        marginRight: values[1],
        marginBottom: values[2],
        marginLeft: values[3]
      };
    }
  }
  return {
    marginTop: void 0,
    marginBottom: void 0,
    marginLeft: void 0,
    marginRight: void 0
  };
}
function computeMargins(properties) {
  let result = {
    marginTop: void 0,
    marginRight: void 0,
    marginBottom: void 0,
    marginLeft: void 0
  };
  for (const [key, value] of Object.entries(properties)) {
    if (key === "margin") {
      result = parseMarginValue(value);
    } else if (key === "marginTop") {
      result.marginTop = value;
    } else if (key === "marginRight") {
      result.marginRight = value;
    } else if (key === "marginBottom") {
      result.marginBottom = value;
    } else if (key === "marginLeft") {
      result.marginLeft = value;
    }
  }
  return result;
}

// src/text.tsx
import { jsx } from "react/jsx-runtime";
var Text = React.forwardRef(
  (_a, ref) => {
    var _b = _a, { style } = _b, props = __objRest(_b, ["style"]);
    let modifiedStyle = {};
    if (modifiedStyle.marginBottom === void 0) {
      modifiedStyle.marginBottom = "16px";
    }
    if (modifiedStyle.marginTop === void 0) {
      modifiedStyle.marginTop = "16px";
    }
    modifiedStyle = __spreadValues(__spreadValues({}, modifiedStyle), style);
    const margins = computeMargins(modifiedStyle);
    return /* @__PURE__ */ jsx(
      "p",
      __spreadProps(__spreadValues({}, props), {
        ref,
        style: __spreadValues(__spreadValues({
          fontSize: "14px",
          lineHeight: "24px"
        }, style), margins)
      })
    );
  }
);
Text.displayName = "Text";
export {
  Text
};
