Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });

const core = require('@sentry/core');
const Sentry = require('@sentry/node');
const sentryNestCoreInstrumentation = require('./sentry-nest-core-instrumentation.js');
const sentryNestEventInstrumentation = require('./sentry-nest-event-instrumentation.js');
const sentryNestInstrumentation = require('./sentry-nest-instrumentation.js');

const INTEGRATION_NAME = 'Nest';

const instrumentNestCore = Sentry.generateInstrumentOnce('Nest-Core', () => {
  return new sentryNestCoreInstrumentation.NestInstrumentation();
});

const instrumentNestCommon = Sentry.generateInstrumentOnce('Nest-Common', () => {
  return new sentryNestInstrumentation.SentryNestInstrumentation();
});

const instrumentNestEvent = Sentry.generateInstrumentOnce('Nest-Event', () => {
  return new sentryNestEventInstrumentation.SentryNestEventInstrumentation();
});

const instrumentNest = Object.assign(
  () => {
    instrumentNestCore();
    instrumentNestCommon();
    instrumentNestEvent();
  },
  { id: INTEGRATION_NAME },
);

/**
 * Integration capturing tracing data for NestJS.
 */
const nestIntegration = core.defineIntegration(() => {
  return {
    name: INTEGRATION_NAME,
    setupOnce() {
      instrumentNest();
    },
  };
});

exports.instrumentNest = instrumentNest;
exports.nestIntegration = nestIntegration;
//# sourceMappingURL=nest.js.map
