import { defineIntegration } from '@sentry/core';
import { generateInstrumentOnce } from '@sentry/node';
import { NestInstrumentation } from './sentry-nest-core-instrumentation.js';
import { SentryNestEventInstrumentation } from './sentry-nest-event-instrumentation.js';
import { SentryNestInstrumentation } from './sentry-nest-instrumentation.js';

const INTEGRATION_NAME = 'Nest';

const instrumentNestCore = generateInstrumentOnce('Nest-Core', () => {
  return new NestInstrumentation();
});

const instrumentNestCommon = generateInstrumentOnce('Nest-Common', () => {
  return new SentryNestInstrumentation();
});

const instrumentNestEvent = generateInstrumentOnce('Nest-Event', () => {
  return new SentryNestEventInstrumentation();
});

const instrumentNest = Object.assign(
  () => {
    instrumentNestCore();
    instrumentNestCommon();
    instrumentNestEvent();
  },
  { id: INTEGRATION_NAME },
);

/**
 * Integration capturing tracing data for NestJS.
 */
const nestIntegration = defineIntegration(() => {
  return {
    name: INTEGRATION_NAME,
    setupOnce() {
      instrumentNest();
    },
  };
});

export { instrumentNest, nestIntegration };
//# sourceMappingURL=nest.js.map
