import * as api from '@opentelemetry/api';
import { InstrumentationBase, InstrumentationNodeModuleDefinition, InstrumentationNodeModuleFile, isWrapped } from '@opentelemetry/instrumentation';
import { ATTR_HTTP_ROUTE, SEMATTRS_HTTP_URL, ATTR_HTTP_REQUEST_METHOD } from '@opentelemetry/semantic-conventions';
import { SDK_VERSION } from '@sentry/core';

const supportedVersions = ['>=4.0.0 <12'];
const COMPONENT = '@nestjs/core';

var AttributeNames; (function (AttributeNames) {
  const VERSION = 'nestjs.version'; AttributeNames["VERSION"] = VERSION;
  const TYPE = 'nestjs.type'; AttributeNames["TYPE"] = TYPE;
  const MODULE = 'nestjs.module'; AttributeNames["MODULE"] = MODULE;
  const CONTROLLER = 'nestjs.controller'; AttributeNames["CONTROLLER"] = CONTROLLER;
  const CALLBACK = 'nestjs.callback'; AttributeNames["CALLBACK"] = CALLBACK;
  const PIPES = 'nestjs.pipes'; AttributeNames["PIPES"] = PIPES;
  const INTERCEPTORS = 'nestjs.interceptors'; AttributeNames["INTERCEPTORS"] = INTERCEPTORS;
  const GUARDS = 'nestjs.guards'; AttributeNames["GUARDS"] = GUARDS;
})(AttributeNames || (AttributeNames = {}));

var NestType; (function (NestType) {
  const APP_CREATION = 'app_creation'; NestType["APP_CREATION"] = APP_CREATION;
  const REQUEST_CONTEXT = 'request_context'; NestType["REQUEST_CONTEXT"] = REQUEST_CONTEXT;
  const REQUEST_HANDLER = 'handler'; NestType["REQUEST_HANDLER"] = REQUEST_HANDLER;
})(NestType || (NestType = {}));

/**
 *
 */
class NestInstrumentation extends InstrumentationBase {
   constructor(config = {}) {
    super('sentry-nestjs', SDK_VERSION, config);
  }

  /**
   *
   */
   init() {
    const module = new InstrumentationNodeModuleDefinition(COMPONENT, supportedVersions);

    module.files.push(
      this._getNestFactoryFileInstrumentation(supportedVersions),
      this._getRouterExecutionContextFileInstrumentation(supportedVersions),
    );

    return module;
  }

  /**
   *
   */
   _getNestFactoryFileInstrumentation(versions) {
    return new InstrumentationNodeModuleFile(
      '@nestjs/core/nest-factory.js',
      versions,
      // todo
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      (NestFactoryStatic, moduleVersion) => {
        this._ensureWrapped(
          // todo
          // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
          NestFactoryStatic.NestFactoryStatic.prototype,
          'create',
          createWrapNestFactoryCreate(this.tracer, moduleVersion),
        );
        return NestFactoryStatic;
      },
      // todo
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      (NestFactoryStatic) => {
        // todo
        // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
        this._unwrap(NestFactoryStatic.NestFactoryStatic.prototype, 'create');
      },
    );
  }

  /**
   *
   */
   _getRouterExecutionContextFileInstrumentation(versions) {
    return new InstrumentationNodeModuleFile(
      '@nestjs/core/router/router-execution-context.js',
      versions,
      // todo
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      (RouterExecutionContext, moduleVersion) => {
        this._ensureWrapped(
          // todo
          // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
          RouterExecutionContext.RouterExecutionContext.prototype,
          'create',
          createWrapCreateHandler(this.tracer, moduleVersion),
        );
        return RouterExecutionContext;
      },
      // todo
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      (RouterExecutionContext) => {
        // todo
        // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
        this._unwrap(RouterExecutionContext.RouterExecutionContext.prototype, 'create');
      },
    );
  }

  /**
   *
   */
  // todo
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
   _ensureWrapped(obj, methodName, wrapper) {
    // todo
    // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
    if (isWrapped(obj[methodName])) {
      this._unwrap(obj, methodName);
    }
    this._wrap(obj, methodName, wrapper);
  }
}

function createWrapNestFactoryCreate(tracer, moduleVersion) {
  return function wrapCreate(original) {
    return function createWithTrace(

      // todo
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      nestModule,
      /* serverOrOptions */
    ) {
      const span = tracer.startSpan('Create Nest App', {
        attributes: {
          component: COMPONENT,
          [AttributeNames.TYPE]: NestType.APP_CREATION,
          [AttributeNames.VERSION]: moduleVersion,
          // todo
          // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
          [AttributeNames.MODULE]: nestModule.name,
        },
      });
      const spanContext = api.trace.setSpan(api.context.active(), span);

      return api.context.with(spanContext, async () => {
        try {
          // todo
          // eslint-disable-next-line prefer-rest-params, @typescript-eslint/no-explicit-any
          return await original.apply(this, arguments );
          // todo
          // eslint-disable-next-line @typescript-eslint/no-explicit-any
        } catch (e) {
          throw addError(span, e);
        } finally {
          span.end();
        }
      });
    };
  };
}

function createWrapCreateHandler(tracer, moduleVersion) {
  return function wrapCreateHandler(original) {
    return function createHandlerWithTrace(

      instance,
      // todo
      // eslint-disable-next-line @typescript-eslint/no-explicit-any
      callback,
    ) {
      // todo
      // eslint-disable-next-line prefer-rest-params
      arguments[1] = createWrapHandler(tracer, moduleVersion, callback);
      // todo
      // eslint-disable-next-line prefer-rest-params, @typescript-eslint/no-explicit-any
      const handler = original.apply(this, arguments );
      const callbackName = callback.name;
      const instanceName =
        // todo
        // eslint-disable-next-line @typescript-eslint/prefer-optional-chain
        instance.constructor && instance.constructor.name ? instance.constructor.name : 'UnnamedInstance';
      const spanName = callbackName ? `${instanceName}.${callbackName}` : instanceName;

      // todo
      // eslint-disable-next-line @typescript-eslint/no-unused-vars, @typescript-eslint/no-explicit-any
      return function ( req, res, next) {
        const span = tracer.startSpan(spanName, {
          attributes: {
            component: COMPONENT,
            [AttributeNames.VERSION]: moduleVersion,
            [AttributeNames.TYPE]: NestType.REQUEST_CONTEXT,
            // todo
            // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
            [ATTR_HTTP_REQUEST_METHOD]: req.method,
            // todo
            // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access, deprecation/deprecation
            [SEMATTRS_HTTP_URL]: req.originalUrl || req.url,
            // todo
            // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
            [ATTR_HTTP_ROUTE]: req.route?.path || req.routeOptions?.url || req.routerPath,
            [AttributeNames.CONTROLLER]: instanceName,
            [AttributeNames.CALLBACK]: callbackName,
          },
        });
        const spanContext = api.trace.setSpan(api.context.active(), span);

        return api.context.with(spanContext, async () => {
          try {
            // todo
            // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access, prefer-rest-params
            return await handler.apply(this, arguments );
            // todo
            // eslint-disable-next-line @typescript-eslint/no-explicit-any
          } catch (e) {
            throw addError(span, e);
          } finally {
            span.end();
          }
        });
      };
    };
  };
}

function createWrapHandler(
  tracer,
  moduleVersion,
  // todo
  // eslint-disable-next-line @typescript-eslint/ban-types
  handler,
  // todo
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
) {
  const spanName = handler.name || 'anonymous nest handler';
  const options = {
    attributes: {
      component: COMPONENT,
      [AttributeNames.VERSION]: moduleVersion,
      [AttributeNames.TYPE]: NestType.REQUEST_HANDLER,
      [AttributeNames.CALLBACK]: handler.name,
    },
  };
  // todo
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  const wrappedHandler = function () {
    const span = tracer.startSpan(spanName, options);
    const spanContext = api.trace.setSpan(api.context.active(), span);

    return api.context.with(spanContext, async () => {
      try {
        // todo
        // eslint-disable-next-line prefer-rest-params
        return await handler.apply(this, arguments);
        // todo
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
      } catch (e) {
        throw addError(span, e);
      } finally {
        span.end();
      }
    });
  };

  if (handler.name) {
    Object.defineProperty(wrappedHandler, 'name', { value: handler.name });
  }

  // Get the current metadata and set onto the wrapper to ensure other decorators ( ie: NestJS EventPattern / RolesGuard )
  // won't be affected by the use of this instrumentation
  Reflect.getMetadataKeys(handler).forEach(metadataKey => {
    Reflect.defineMetadata(metadataKey, Reflect.getMetadata(metadataKey, handler), wrappedHandler);
  });
  return wrappedHandler;
}

const addError = (span, error) => {
  span.recordException(error);
  span.setStatus({ code: api.SpanStatusCode.ERROR, message: error.message });
  return error;
};

export { NestInstrumentation, NestType };
//# sourceMappingURL=sentry-nest-core-instrumentation.js.map
