import { applySdkMetadata, spanToJSON, SEMANTIC_ATTRIBUTE_SENTRY_OP, SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN } from '@sentry/core';
import { getDefaultIntegrations as getDefaultIntegrations$1, init as init$1 } from '@sentry/node';
import { nestIntegration } from './integrations/nest.js';

/**
 * Initializes the NestJS SDK
 */
function init(options = {}) {
  const opts = {
    defaultIntegrations: getDefaultIntegrations(options),
    ...options,
  };

  applySdkMetadata(opts, 'nestjs');

  const client = init$1(opts);

  if (client) {
    client.on('spanStart', span => {
      // The NestInstrumentation has no requestHook, so we add NestJS-specific attributes here
      addNestSpanAttributes(span);
    });
  }

  return client;
}

/** Get the default integrations for the NestJS SDK. */
function getDefaultIntegrations(options) {
  return [nestIntegration(), ...getDefaultIntegrations$1(options)];
}

function addNestSpanAttributes(span) {
  const attributes = spanToJSON(span).data;

  // this is one of: app_creation, request_context, handler
  const type = attributes['nestjs.type'];

  // Only set the NestJS attributes for spans that are created by the NestJS instrumentation and for spans that do not have an op already.
  if (type && !attributes[SEMANTIC_ATTRIBUTE_SENTRY_OP]) {
    span.setAttributes({
      [SEMANTIC_ATTRIBUTE_SENTRY_ORIGIN]: 'auto.http.otel.nestjs',
      [SEMANTIC_ATTRIBUTE_SENTRY_OP]: `${type}.nestjs`,
    });
  }
}

export { getDefaultIntegrations, init };
//# sourceMappingURL=sdk.js.map
