import type { MonitorConfig } from '@sentry/core';
/**
 * A decorator wrapping the native nest Cron decorator, sending check-ins to Sentry.
 */
export declare const SentryCron: (monitorSlug: string, monitorConfig?: MonitorConfig) => MethodDecorator;
/**
 * A decorator usable to wrap arbitrary functions with spans.
 */
export declare function SentryTraced(op?: string): (_target: unknown, propertyKey: string, descriptor: PropertyDescriptor) => PropertyDescriptor;
/**
 * A decorator to wrap user-defined exception filters and add Sentry error reporting.
 */
export declare function SentryExceptionCaptured(): (target: unknown, propertyKey: string, descriptor: PropertyDescriptor) => PropertyDescriptor;
//# sourceMappingURL=decorators.d.ts.map