import type { ArgumentsHost, DynamicModule, HttpServer } from '@nestjs/common';
import { BaseExceptionFilter } from '@nestjs/core';
/**
 * Global filter to handle exceptions and report them to Sentry.
 */
declare class SentryGlobalFilter extends BaseExceptionFilter {
    readonly __SENTRY_INTERNAL__: boolean;
    private readonly _logger;
    constructor(applicationRef?: HttpServer);
    /**
     * Catches exceptions and reports them to Sentry unless they are expected errors.
     */
    catch(exception: unknown, host: ArgumentsHost): void;
}
export { SentryGlobalFilter };
/**
 * Set up a root module that can be injected in nest applications.
 */
declare class SentryModule {
    /**
     * Configures the module as the root module in a Nest.js application.
     */
    static forRoot(): DynamicModule;
}
export { SentryModule };
//# sourceMappingURL=setup.d.ts.map