import type { ReadableSpan } from '@opentelemetry/sdk-trace-base';
import type { TransactionEvent } from '@sentry/core';
import type { SpanNode } from './utils/groupSpansWithParents';
type SpanNodeCompleted = SpanNode & {
    span: ReadableSpan;
};
/**
 * A Sentry-specific exporter that converts OpenTelemetry Spans to Sentry Spans & Transactions.
 */
export declare class SentrySpanExporter {
    private _flushTimeout;
    private _finishedSpanBuckets;
    private _finishedSpanBucketSize;
    private _spansToBucketEntry;
    private _lastCleanupTimestampInS;
    private _sentSpans;
    constructor(options?: {
        /** Lower bound of time in seconds until spans that are buffered but have not been sent as part of a transaction get cleared from memory. */
        timeout?: number;
    });
    /**
     * Check if a span with the given ID has already been sent using the `_sentSpans` as a cache.
     * Purges "expired" spans from the cache upon checking.
     * @param spanId The span id to check.
     * @returns Whether the span is already sent in the past X seconds.
     */
    isSpanAlreadySent(spanId: string): boolean;
    /** Remove "expired" span id entries from the _sentSpans cache. */
    flushSentSpanCache(): void;
    /** Check if a node is a completed root node or a node whose parent has already been sent */
    nodeIsCompletedRootNode(node: SpanNode): node is SpanNodeCompleted;
    /** Get all completed root nodes from a list of nodes */
    getCompletedRootNodes(nodes: SpanNode[]): SpanNodeCompleted[];
    /** Export a single span. */
    export(span: ReadableSpan): void;
    /** Try to flush any pending spans immediately. */
    flush(): void;
    /** Clear the exporter. */
    clear(): void;
    /** Clear the flush timeout. */
    private _clearTimeout;
    /**
     * Send the given spans, but only if they are part of a finished transaction.
     *
     * Returns the sent spans.
     * Spans remain unsent when their parent span is not yet finished.
     * This will happen regularly, as child spans are generally finished before their parents.
     * But it _could_ also happen because, for whatever reason, a parent span was lost.
     * In this case, we'll eventually need to clean this up.
     */
    private _maybeSend;
}
/** Exported only for tests. */
export declare function createTransactionForOtelSpan(span: ReadableSpan): TransactionEvent;
export {};
//# sourceMappingURL=spanExporter.d.ts.map