"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name16 in all)
    __defProp(target, name16, { get: all[name16], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);

// src/index.ts
var src_exports = {};
__export(src_exports, {
  AISDKError: () => import_provider17.AISDKError,
  APICallError: () => import_provider17.APICallError,
  AbstractChat: () => AbstractChat,
  DefaultChatTransport: () => DefaultChatTransport,
  DirectChatTransport: () => DirectChatTransport,
  DownloadError: () => import_provider_utils.DownloadError,
  EmptyResponseBodyError: () => import_provider17.EmptyResponseBodyError,
  Experimental_Agent: () => ToolLoopAgent,
  HttpChatTransport: () => HttpChatTransport,
  InvalidArgumentError: () => InvalidArgumentError,
  InvalidDataContentError: () => InvalidDataContentError,
  InvalidMessageRoleError: () => InvalidMessageRoleError,
  InvalidPromptError: () => import_provider17.InvalidPromptError,
  InvalidResponseDataError: () => import_provider17.InvalidResponseDataError,
  InvalidStreamPartError: () => InvalidStreamPartError,
  InvalidToolApprovalError: () => InvalidToolApprovalError,
  InvalidToolInputError: () => InvalidToolInputError,
  JSONParseError: () => import_provider17.JSONParseError,
  JsonToSseTransformStream: () => JsonToSseTransformStream,
  LoadAPIKeyError: () => import_provider17.LoadAPIKeyError,
  LoadSettingError: () => import_provider17.LoadSettingError,
  MessageConversionError: () => MessageConversionError,
  NoContentGeneratedError: () => import_provider17.NoContentGeneratedError,
  NoImageGeneratedError: () => NoImageGeneratedError,
  NoObjectGeneratedError: () => NoObjectGeneratedError,
  NoOutputGeneratedError: () => NoOutputGeneratedError,
  NoSpeechGeneratedError: () => NoSpeechGeneratedError,
  NoSuchModelError: () => import_provider17.NoSuchModelError,
  NoSuchProviderError: () => NoSuchProviderError,
  NoSuchToolError: () => NoSuchToolError,
  Output: () => output_exports,
  RetryError: () => RetryError,
  SerialJobExecutor: () => SerialJobExecutor,
  TextStreamChatTransport: () => TextStreamChatTransport,
  TooManyEmbeddingValuesForCallError: () => import_provider17.TooManyEmbeddingValuesForCallError,
  ToolCallNotFoundForApprovalError: () => ToolCallNotFoundForApprovalError,
  ToolCallRepairError: () => ToolCallRepairError,
  ToolLoopAgent: () => ToolLoopAgent,
  TypeValidationError: () => import_provider17.TypeValidationError,
  UI_MESSAGE_STREAM_HEADERS: () => UI_MESSAGE_STREAM_HEADERS,
  UnsupportedFunctionalityError: () => import_provider17.UnsupportedFunctionalityError,
  UnsupportedModelVersionError: () => UnsupportedModelVersionError,
  addToolInputExamplesMiddleware: () => addToolInputExamplesMiddleware,
  asSchema: () => import_provider_utils38.asSchema,
  assistantModelMessageSchema: () => assistantModelMessageSchema,
  callCompletionApi: () => callCompletionApi,
  consumeStream: () => consumeStream,
  convertFileListToFileUIParts: () => convertFileListToFileUIParts,
  convertToModelMessages: () => convertToModelMessages,
  cosineSimilarity: () => cosineSimilarity,
  createAgentUIStream: () => createAgentUIStream,
  createAgentUIStreamResponse: () => createAgentUIStreamResponse,
  createGateway: () => import_gateway3.createGateway,
  createIdGenerator: () => import_provider_utils38.createIdGenerator,
  createProviderRegistry: () => createProviderRegistry,
  createTextStreamResponse: () => createTextStreamResponse,
  createUIMessageStream: () => createUIMessageStream,
  createUIMessageStreamResponse: () => createUIMessageStreamResponse,
  customProvider: () => customProvider,
  defaultEmbeddingSettingsMiddleware: () => defaultEmbeddingSettingsMiddleware,
  defaultSettingsMiddleware: () => defaultSettingsMiddleware,
  dynamicTool: () => import_provider_utils38.dynamicTool,
  embed: () => embed,
  embedMany: () => embedMany,
  experimental_createProviderRegistry: () => experimental_createProviderRegistry,
  experimental_customProvider: () => experimental_customProvider,
  experimental_generateImage: () => experimental_generateImage,
  experimental_generateSpeech: () => generateSpeech,
  experimental_transcribe: () => transcribe,
  extractReasoningMiddleware: () => extractReasoningMiddleware,
  gateway: () => import_gateway3.gateway,
  generateId: () => import_provider_utils38.generateId,
  generateImage: () => generateImage,
  generateObject: () => generateObject,
  generateText: () => generateText,
  getStaticToolName: () => getStaticToolName,
  getTextFromDataUrl: () => getTextFromDataUrl,
  getToolName: () => getToolName,
  getToolOrDynamicToolName: () => getToolOrDynamicToolName,
  getTotalTimeoutMs: () => getTotalTimeoutMs,
  hasToolCall: () => hasToolCall,
  isDataUIPart: () => isDataUIPart,
  isDeepEqualData: () => isDeepEqualData,
  isFileUIPart: () => isFileUIPart,
  isReasoningUIPart: () => isReasoningUIPart,
  isStaticToolUIPart: () => isStaticToolUIPart,
  isTextUIPart: () => isTextUIPart,
  isToolOrDynamicToolUIPart: () => isToolOrDynamicToolUIPart,
  isToolUIPart: () => isToolUIPart,
  jsonSchema: () => import_provider_utils38.jsonSchema,
  lastAssistantMessageIsCompleteWithApprovalResponses: () => lastAssistantMessageIsCompleteWithApprovalResponses,
  lastAssistantMessageIsCompleteWithToolCalls: () => lastAssistantMessageIsCompleteWithToolCalls,
  modelMessageSchema: () => modelMessageSchema,
  parseJsonEventStream: () => import_provider_utils38.parseJsonEventStream,
  parsePartialJson: () => parsePartialJson,
  pipeAgentUIStreamToResponse: () => pipeAgentUIStreamToResponse,
  pipeTextStreamToResponse: () => pipeTextStreamToResponse,
  pipeUIMessageStreamToResponse: () => pipeUIMessageStreamToResponse,
  pruneMessages: () => pruneMessages,
  readUIMessageStream: () => readUIMessageStream,
  rerank: () => rerank,
  safeValidateUIMessages: () => safeValidateUIMessages,
  simulateReadableStream: () => simulateReadableStream,
  simulateStreamingMiddleware: () => simulateStreamingMiddleware,
  smoothStream: () => smoothStream,
  stepCountIs: () => stepCountIs,
  streamObject: () => streamObject,
  streamText: () => streamText,
  systemModelMessageSchema: () => systemModelMessageSchema,
  tool: () => import_provider_utils38.tool,
  toolModelMessageSchema: () => toolModelMessageSchema,
  uiMessageChunkSchema: () => uiMessageChunkSchema,
  userModelMessageSchema: () => userModelMessageSchema,
  validateUIMessages: () => validateUIMessages,
  wrapEmbeddingModel: () => wrapEmbeddingModel,
  wrapImageModel: () => wrapImageModel,
  wrapLanguageModel: () => wrapLanguageModel,
  wrapProvider: () => wrapProvider,
  zodSchema: () => import_provider_utils38.zodSchema
});
module.exports = __toCommonJS(src_exports);
var import_gateway3 = require("@ai-sdk/gateway");
var import_provider_utils38 = require("@ai-sdk/provider-utils");

// src/generate-text/generate-text.ts
var import_provider_utils15 = require("@ai-sdk/provider-utils");

// src/error/index.ts
var import_provider17 = require("@ai-sdk/provider");

// src/error/invalid-argument-error.ts
var import_provider = require("@ai-sdk/provider");
var name = "AI_InvalidArgumentError";
var marker = `vercel.ai.error.${name}`;
var symbol = Symbol.for(marker);
var _a;
var InvalidArgumentError = class extends import_provider.AISDKError {
  constructor({
    parameter,
    value,
    message
  }) {
    super({
      name,
      message: `Invalid argument for parameter ${parameter}: ${message}`
    });
    this[_a] = true;
    this.parameter = parameter;
    this.value = value;
  }
  static isInstance(error) {
    return import_provider.AISDKError.hasMarker(error, marker);
  }
};
_a = symbol;

// src/error/invalid-stream-part-error.ts
var import_provider2 = require("@ai-sdk/provider");
var name2 = "AI_InvalidStreamPartError";
var marker2 = `vercel.ai.error.${name2}`;
var symbol2 = Symbol.for(marker2);
var _a2;
var InvalidStreamPartError = class extends import_provider2.AISDKError {
  constructor({
    chunk,
    message
  }) {
    super({ name: name2, message });
    this[_a2] = true;
    this.chunk = chunk;
  }
  static isInstance(error) {
    return import_provider2.AISDKError.hasMarker(error, marker2);
  }
};
_a2 = symbol2;

// src/error/invalid-tool-approval-error.ts
var import_provider3 = require("@ai-sdk/provider");
var name3 = "AI_InvalidToolApprovalError";
var marker3 = `vercel.ai.error.${name3}`;
var symbol3 = Symbol.for(marker3);
var _a3;
var InvalidToolApprovalError = class extends import_provider3.AISDKError {
  constructor({ approvalId }) {
    super({
      name: name3,
      message: `Tool approval response references unknown approvalId: "${approvalId}". No matching tool-approval-request found in message history.`
    });
    this[_a3] = true;
    this.approvalId = approvalId;
  }
  static isInstance(error) {
    return import_provider3.AISDKError.hasMarker(error, marker3);
  }
};
_a3 = symbol3;

// src/error/invalid-tool-input-error.ts
var import_provider4 = require("@ai-sdk/provider");
var name4 = "AI_InvalidToolInputError";
var marker4 = `vercel.ai.error.${name4}`;
var symbol4 = Symbol.for(marker4);
var _a4;
var InvalidToolInputError = class extends import_provider4.AISDKError {
  constructor({
    toolInput,
    toolName,
    cause,
    message = `Invalid input for tool ${toolName}: ${(0, import_provider4.getErrorMessage)(cause)}`
  }) {
    super({ name: name4, message, cause });
    this[_a4] = true;
    this.toolInput = toolInput;
    this.toolName = toolName;
  }
  static isInstance(error) {
    return import_provider4.AISDKError.hasMarker(error, marker4);
  }
};
_a4 = symbol4;

// src/error/tool-call-not-found-for-approval-error.ts
var import_provider5 = require("@ai-sdk/provider");
var name5 = "AI_ToolCallNotFoundForApprovalError";
var marker5 = `vercel.ai.error.${name5}`;
var symbol5 = Symbol.for(marker5);
var _a5;
var ToolCallNotFoundForApprovalError = class extends import_provider5.AISDKError {
  constructor({
    toolCallId,
    approvalId
  }) {
    super({
      name: name5,
      message: `Tool call "${toolCallId}" not found for approval request "${approvalId}".`
    });
    this[_a5] = true;
    this.toolCallId = toolCallId;
    this.approvalId = approvalId;
  }
  static isInstance(error) {
    return import_provider5.AISDKError.hasMarker(error, marker5);
  }
};
_a5 = symbol5;

// src/error/no-image-generated-error.ts
var import_provider6 = require("@ai-sdk/provider");
var name6 = "AI_NoImageGeneratedError";
var marker6 = `vercel.ai.error.${name6}`;
var symbol6 = Symbol.for(marker6);
var _a6;
var NoImageGeneratedError = class extends import_provider6.AISDKError {
  constructor({
    message = "No image generated.",
    cause,
    responses
  }) {
    super({ name: name6, message, cause });
    this[_a6] = true;
    this.responses = responses;
  }
  static isInstance(error) {
    return import_provider6.AISDKError.hasMarker(error, marker6);
  }
};
_a6 = symbol6;

// src/error/no-object-generated-error.ts
var import_provider7 = require("@ai-sdk/provider");
var name7 = "AI_NoObjectGeneratedError";
var marker7 = `vercel.ai.error.${name7}`;
var symbol7 = Symbol.for(marker7);
var _a7;
var NoObjectGeneratedError = class extends import_provider7.AISDKError {
  constructor({
    message = "No object generated.",
    cause,
    text: text2,
    response,
    usage,
    finishReason
  }) {
    super({ name: name7, message, cause });
    this[_a7] = true;
    this.text = text2;
    this.response = response;
    this.usage = usage;
    this.finishReason = finishReason;
  }
  static isInstance(error) {
    return import_provider7.AISDKError.hasMarker(error, marker7);
  }
};
_a7 = symbol7;

// src/error/no-output-generated-error.ts
var import_provider8 = require("@ai-sdk/provider");
var name8 = "AI_NoOutputGeneratedError";
var marker8 = `vercel.ai.error.${name8}`;
var symbol8 = Symbol.for(marker8);
var _a8;
var NoOutputGeneratedError = class extends import_provider8.AISDKError {
  // used in isInstance
  constructor({
    message = "No output generated.",
    cause
  } = {}) {
    super({ name: name8, message, cause });
    this[_a8] = true;
  }
  static isInstance(error) {
    return import_provider8.AISDKError.hasMarker(error, marker8);
  }
};
_a8 = symbol8;

// src/error/no-speech-generated-error.ts
var import_provider9 = require("@ai-sdk/provider");
var NoSpeechGeneratedError = class extends import_provider9.AISDKError {
  constructor(options) {
    super({
      name: "AI_NoSpeechGeneratedError",
      message: "No speech audio generated."
    });
    this.responses = options.responses;
  }
};

// src/error/no-such-tool-error.ts
var import_provider10 = require("@ai-sdk/provider");
var name9 = "AI_NoSuchToolError";
var marker9 = `vercel.ai.error.${name9}`;
var symbol9 = Symbol.for(marker9);
var _a9;
var NoSuchToolError = class extends import_provider10.AISDKError {
  constructor({
    toolName,
    availableTools = void 0,
    message = `Model tried to call unavailable tool '${toolName}'. ${availableTools === void 0 ? "No tools are available." : `Available tools: ${availableTools.join(", ")}.`}`
  }) {
    super({ name: name9, message });
    this[_a9] = true;
    this.toolName = toolName;
    this.availableTools = availableTools;
  }
  static isInstance(error) {
    return import_provider10.AISDKError.hasMarker(error, marker9);
  }
};
_a9 = symbol9;

// src/error/tool-call-repair-error.ts
var import_provider11 = require("@ai-sdk/provider");
var name10 = "AI_ToolCallRepairError";
var marker10 = `vercel.ai.error.${name10}`;
var symbol10 = Symbol.for(marker10);
var _a10;
var ToolCallRepairError = class extends import_provider11.AISDKError {
  constructor({
    cause,
    originalError,
    message = `Error repairing tool call: ${(0, import_provider11.getErrorMessage)(cause)}`
  }) {
    super({ name: name10, message, cause });
    this[_a10] = true;
    this.originalError = originalError;
  }
  static isInstance(error) {
    return import_provider11.AISDKError.hasMarker(error, marker10);
  }
};
_a10 = symbol10;

// src/error/unsupported-model-version-error.ts
var import_provider12 = require("@ai-sdk/provider");
var UnsupportedModelVersionError = class extends import_provider12.AISDKError {
  constructor(options) {
    super({
      name: "AI_UnsupportedModelVersionError",
      message: `Unsupported model version ${options.version} for provider "${options.provider}" and model "${options.modelId}". AI SDK 5 only supports models that implement specification version "v2".`
    });
    this.version = options.version;
    this.provider = options.provider;
    this.modelId = options.modelId;
  }
};

// src/prompt/invalid-data-content-error.ts
var import_provider13 = require("@ai-sdk/provider");
var name11 = "AI_InvalidDataContentError";
var marker11 = `vercel.ai.error.${name11}`;
var symbol11 = Symbol.for(marker11);
var _a11;
var InvalidDataContentError = class extends import_provider13.AISDKError {
  constructor({
    content,
    cause,
    message = `Invalid data content. Expected a base64 string, Uint8Array, ArrayBuffer, or Buffer, but got ${typeof content}.`
  }) {
    super({ name: name11, message, cause });
    this[_a11] = true;
    this.content = content;
  }
  static isInstance(error) {
    return import_provider13.AISDKError.hasMarker(error, marker11);
  }
};
_a11 = symbol11;

// src/prompt/invalid-message-role-error.ts
var import_provider14 = require("@ai-sdk/provider");
var name12 = "AI_InvalidMessageRoleError";
var marker12 = `vercel.ai.error.${name12}`;
var symbol12 = Symbol.for(marker12);
var _a12;
var InvalidMessageRoleError = class extends import_provider14.AISDKError {
  constructor({
    role,
    message = `Invalid message role: '${role}'. Must be one of: "system", "user", "assistant", "tool".`
  }) {
    super({ name: name12, message });
    this[_a12] = true;
    this.role = role;
  }
  static isInstance(error) {
    return import_provider14.AISDKError.hasMarker(error, marker12);
  }
};
_a12 = symbol12;

// src/prompt/message-conversion-error.ts
var import_provider15 = require("@ai-sdk/provider");
var name13 = "AI_MessageConversionError";
var marker13 = `vercel.ai.error.${name13}`;
var symbol13 = Symbol.for(marker13);
var _a13;
var MessageConversionError = class extends import_provider15.AISDKError {
  constructor({
    originalMessage,
    message
  }) {
    super({ name: name13, message });
    this[_a13] = true;
    this.originalMessage = originalMessage;
  }
  static isInstance(error) {
    return import_provider15.AISDKError.hasMarker(error, marker13);
  }
};
_a13 = symbol13;

// src/error/index.ts
var import_provider_utils = require("@ai-sdk/provider-utils");

// src/util/retry-error.ts
var import_provider16 = require("@ai-sdk/provider");
var name14 = "AI_RetryError";
var marker14 = `vercel.ai.error.${name14}`;
var symbol14 = Symbol.for(marker14);
var _a14;
var RetryError = class extends import_provider16.AISDKError {
  constructor({
    message,
    reason,
    errors
  }) {
    super({ name: name14, message });
    this[_a14] = true;
    this.reason = reason;
    this.errors = errors;
    this.lastError = errors[errors.length - 1];
  }
  static isInstance(error) {
    return import_provider16.AISDKError.hasMarker(error, marker14);
  }
};
_a14 = symbol14;

// src/logger/log-warnings.ts
function formatWarning({
  warning,
  provider,
  model
}) {
  const prefix = `AI SDK Warning (${provider} / ${model}):`;
  switch (warning.type) {
    case "unsupported": {
      let message = `${prefix} The feature "${warning.feature}" is not supported.`;
      if (warning.details) {
        message += ` ${warning.details}`;
      }
      return message;
    }
    case "compatibility": {
      let message = `${prefix} The feature "${warning.feature}" is used in a compatibility mode.`;
      if (warning.details) {
        message += ` ${warning.details}`;
      }
      return message;
    }
    case "other": {
      return `${prefix} ${warning.message}`;
    }
    default: {
      return `${prefix} ${JSON.stringify(warning, null, 2)}`;
    }
  }
}
var FIRST_WARNING_INFO_MESSAGE = "AI SDK Warning System: To turn off warning logging, set the AI_SDK_LOG_WARNINGS global to false.";
var hasLoggedBefore = false;
var logWarnings = (options) => {
  if (options.warnings.length === 0) {
    return;
  }
  const logger = globalThis.AI_SDK_LOG_WARNINGS;
  if (logger === false) {
    return;
  }
  if (typeof logger === "function") {
    logger(options);
    return;
  }
  if (!hasLoggedBefore) {
    hasLoggedBefore = true;
    console.info(FIRST_WARNING_INFO_MESSAGE);
  }
  for (const warning of options.warnings) {
    console.warn(
      formatWarning({
        warning,
        provider: options.provider,
        model: options.model
      })
    );
  }
};

// src/model/resolve-model.ts
var import_gateway = require("@ai-sdk/gateway");

// src/util/log-v2-compatibility-warning.ts
function logV2CompatibilityWarning({
  provider,
  modelId
}) {
  logWarnings({
    warnings: [
      {
        type: "compatibility",
        feature: "specificationVersion",
        details: `Using v2 specification compatibility mode. Some features may not be available.`
      }
    ],
    provider,
    model: modelId
  });
}

// src/model/as-embedding-model-v3.ts
function asEmbeddingModelV3(model) {
  if (model.specificationVersion === "v3") {
    return model;
  }
  logV2CompatibilityWarning({
    provider: model.provider,
    modelId: model.modelId
  });
  return new Proxy(model, {
    get(target, prop) {
      if (prop === "specificationVersion")
        return "v3";
      return target[prop];
    }
  });
}

// src/model/as-image-model-v3.ts
function asImageModelV3(model) {
  if (model.specificationVersion === "v3") {
    return model;
  }
  logV2CompatibilityWarning({
    provider: model.provider,
    modelId: model.modelId
  });
  return new Proxy(model, {
    get(target, prop) {
      if (prop === "specificationVersion")
        return "v3";
      return target[prop];
    }
  });
}

// src/model/as-language-model-v3.ts
function asLanguageModelV3(model) {
  if (model.specificationVersion === "v3") {
    return model;
  }
  logV2CompatibilityWarning({
    provider: model.provider,
    modelId: model.modelId
  });
  return new Proxy(model, {
    get(target, prop) {
      switch (prop) {
        case "specificationVersion":
          return "v3";
        case "doGenerate":
          return async (...args) => {
            const result = await target.doGenerate(...args);
            return {
              ...result,
              finishReason: convertV2FinishReasonToV3(result.finishReason),
              usage: convertV2UsageToV3(result.usage)
            };
          };
        case "doStream":
          return async (...args) => {
            const result = await target.doStream(...args);
            return {
              ...result,
              stream: convertV2StreamToV3(result.stream)
            };
          };
        default:
          return target[prop];
      }
    }
  });
}
function convertV2StreamToV3(stream) {
  return stream.pipeThrough(
    new TransformStream({
      transform(chunk, controller) {
        switch (chunk.type) {
          case "finish":
            controller.enqueue({
              ...chunk,
              finishReason: convertV2FinishReasonToV3(chunk.finishReason),
              usage: convertV2UsageToV3(chunk.usage)
            });
            break;
          default:
            controller.enqueue(chunk);
            break;
        }
      }
    })
  );
}
function convertV2FinishReasonToV3(finishReason) {
  return {
    unified: finishReason === "unknown" ? "other" : finishReason,
    raw: void 0
  };
}
function convertV2UsageToV3(usage) {
  return {
    inputTokens: {
      total: usage.inputTokens,
      noCache: void 0,
      cacheRead: usage.cachedInputTokens,
      cacheWrite: void 0
    },
    outputTokens: {
      total: usage.outputTokens,
      text: void 0,
      reasoning: usage.reasoningTokens
    }
  };
}

// src/model/as-speech-model-v3.ts
function asSpeechModelV3(model) {
  if (model.specificationVersion === "v3") {
    return model;
  }
  logV2CompatibilityWarning({
    provider: model.provider,
    modelId: model.modelId
  });
  return new Proxy(model, {
    get(target, prop) {
      if (prop === "specificationVersion")
        return "v3";
      return target[prop];
    }
  });
}

// src/model/as-transcription-model-v3.ts
function asTranscriptionModelV3(model) {
  if (model.specificationVersion === "v3") {
    return model;
  }
  logV2CompatibilityWarning({
    provider: model.provider,
    modelId: model.modelId
  });
  return new Proxy(model, {
    get(target, prop) {
      if (prop === "specificationVersion")
        return "v3";
      return target[prop];
    }
  });
}

// src/model/resolve-model.ts
function resolveLanguageModel(model) {
  if (typeof model !== "string") {
    if (model.specificationVersion !== "v3" && model.specificationVersion !== "v2") {
      const unsupportedModel = model;
      throw new UnsupportedModelVersionError({
        version: unsupportedModel.specificationVersion,
        provider: unsupportedModel.provider,
        modelId: unsupportedModel.modelId
      });
    }
    return asLanguageModelV3(model);
  }
  return getGlobalProvider().languageModel(model);
}
function resolveEmbeddingModel(model) {
  if (typeof model !== "string") {
    if (model.specificationVersion !== "v3" && model.specificationVersion !== "v2") {
      const unsupportedModel = model;
      throw new UnsupportedModelVersionError({
        version: unsupportedModel.specificationVersion,
        provider: unsupportedModel.provider,
        modelId: unsupportedModel.modelId
      });
    }
    return asEmbeddingModelV3(model);
  }
  return getGlobalProvider().embeddingModel(model);
}
function resolveTranscriptionModel(model) {
  var _a16, _b;
  if (typeof model !== "string") {
    if (model.specificationVersion !== "v3" && model.specificationVersion !== "v2") {
      const unsupportedModel = model;
      throw new UnsupportedModelVersionError({
        version: unsupportedModel.specificationVersion,
        provider: unsupportedModel.provider,
        modelId: unsupportedModel.modelId
      });
    }
    return asTranscriptionModelV3(model);
  }
  return (_b = (_a16 = getGlobalProvider()).transcriptionModel) == null ? void 0 : _b.call(_a16, model);
}
function resolveSpeechModel(model) {
  var _a16, _b;
  if (typeof model !== "string") {
    if (model.specificationVersion !== "v3" && model.specificationVersion !== "v2") {
      const unsupportedModel = model;
      throw new UnsupportedModelVersionError({
        version: unsupportedModel.specificationVersion,
        provider: unsupportedModel.provider,
        modelId: unsupportedModel.modelId
      });
    }
    return asSpeechModelV3(model);
  }
  return (_b = (_a16 = getGlobalProvider()).speechModel) == null ? void 0 : _b.call(_a16, model);
}
function resolveImageModel(model) {
  if (typeof model !== "string") {
    if (model.specificationVersion !== "v3" && model.specificationVersion !== "v2") {
      const unsupportedModel = model;
      throw new UnsupportedModelVersionError({
        version: unsupportedModel.specificationVersion,
        provider: unsupportedModel.provider,
        modelId: unsupportedModel.modelId
      });
    }
    return asImageModelV3(model);
  }
  return getGlobalProvider().imageModel(model);
}
function getGlobalProvider() {
  var _a16;
  return (_a16 = globalThis.AI_SDK_DEFAULT_PROVIDER) != null ? _a16 : import_gateway.gateway;
}

// src/prompt/call-settings.ts
function getTotalTimeoutMs(timeout) {
  if (timeout == null) {
    return void 0;
  }
  if (typeof timeout === "number") {
    return timeout;
  }
  return timeout.totalMs;
}

// src/prompt/convert-to-language-model-prompt.ts
var import_provider_utils6 = require("@ai-sdk/provider-utils");

// src/util/detect-media-type.ts
var import_provider_utils2 = require("@ai-sdk/provider-utils");
var imageMediaTypeSignatures = [
  {
    mediaType: "image/gif",
    bytesPrefix: [71, 73, 70]
    // GIF
  },
  {
    mediaType: "image/png",
    bytesPrefix: [137, 80, 78, 71]
    // PNG
  },
  {
    mediaType: "image/jpeg",
    bytesPrefix: [255, 216]
    // JPEG
  },
  {
    mediaType: "image/webp",
    bytesPrefix: [
      82,
      73,
      70,
      70,
      // "RIFF"
      null,
      null,
      null,
      null,
      // file size (variable)
      87,
      69,
      66,
      80
      // "WEBP"
    ]
  },
  {
    mediaType: "image/bmp",
    bytesPrefix: [66, 77]
  },
  {
    mediaType: "image/tiff",
    bytesPrefix: [73, 73, 42, 0]
  },
  {
    mediaType: "image/tiff",
    bytesPrefix: [77, 77, 0, 42]
  },
  {
    mediaType: "image/avif",
    bytesPrefix: [
      0,
      0,
      0,
      32,
      102,
      116,
      121,
      112,
      97,
      118,
      105,
      102
    ]
  },
  {
    mediaType: "image/heic",
    bytesPrefix: [
      0,
      0,
      0,
      32,
      102,
      116,
      121,
      112,
      104,
      101,
      105,
      99
    ]
  }
];
var audioMediaTypeSignatures = [
  {
    mediaType: "audio/mpeg",
    bytesPrefix: [255, 251]
  },
  {
    mediaType: "audio/mpeg",
    bytesPrefix: [255, 250]
  },
  {
    mediaType: "audio/mpeg",
    bytesPrefix: [255, 243]
  },
  {
    mediaType: "audio/mpeg",
    bytesPrefix: [255, 242]
  },
  {
    mediaType: "audio/mpeg",
    bytesPrefix: [255, 227]
  },
  {
    mediaType: "audio/mpeg",
    bytesPrefix: [255, 226]
  },
  {
    mediaType: "audio/wav",
    bytesPrefix: [
      82,
      // R
      73,
      // I
      70,
      // F
      70,
      // F
      null,
      null,
      null,
      null,
      87,
      // W
      65,
      // A
      86,
      // V
      69
      // E
    ]
  },
  {
    mediaType: "audio/ogg",
    bytesPrefix: [79, 103, 103, 83]
  },
  {
    mediaType: "audio/flac",
    bytesPrefix: [102, 76, 97, 67]
  },
  {
    mediaType: "audio/aac",
    bytesPrefix: [64, 21, 0, 0]
  },
  {
    mediaType: "audio/mp4",
    bytesPrefix: [102, 116, 121, 112]
  },
  {
    mediaType: "audio/webm",
    bytesPrefix: [26, 69, 223, 163]
  }
];
var stripID3 = (data) => {
  const bytes = typeof data === "string" ? (0, import_provider_utils2.convertBase64ToUint8Array)(data) : data;
  const id3Size = (bytes[6] & 127) << 21 | (bytes[7] & 127) << 14 | (bytes[8] & 127) << 7 | bytes[9] & 127;
  return bytes.slice(id3Size + 10);
};
function stripID3TagsIfPresent(data) {
  const hasId3 = typeof data === "string" && data.startsWith("SUQz") || typeof data !== "string" && data.length > 10 && data[0] === 73 && // 'I'
  data[1] === 68 && // 'D'
  data[2] === 51;
  return hasId3 ? stripID3(data) : data;
}
function detectMediaType({
  data,
  signatures
}) {
  const processedData = stripID3TagsIfPresent(data);
  const bytes = typeof processedData === "string" ? (0, import_provider_utils2.convertBase64ToUint8Array)(
    processedData.substring(0, Math.min(processedData.length, 24))
  ) : processedData;
  for (const signature of signatures) {
    if (bytes.length >= signature.bytesPrefix.length && signature.bytesPrefix.every(
      (byte, index) => byte === null || bytes[index] === byte
    )) {
      return signature.mediaType;
    }
  }
  return void 0;
}

// src/util/download/download.ts
var import_provider_utils3 = require("@ai-sdk/provider-utils");
var import_provider_utils4 = require("@ai-sdk/provider-utils");

// src/version.ts
var VERSION = true ? "6.0.22" : "0.0.0-test";

// src/util/download/download.ts
var download = async ({ url }) => {
  var _a16;
  const urlText = url.toString();
  try {
    const response = await fetch(urlText, {
      headers: (0, import_provider_utils4.withUserAgentSuffix)(
        {},
        `ai-sdk/${VERSION}`,
        (0, import_provider_utils4.getRuntimeEnvironmentUserAgent)()
      )
    });
    if (!response.ok) {
      throw new import_provider_utils3.DownloadError({
        url: urlText,
        statusCode: response.status,
        statusText: response.statusText
      });
    }
    return {
      data: new Uint8Array(await response.arrayBuffer()),
      mediaType: (_a16 = response.headers.get("content-type")) != null ? _a16 : void 0
    };
  } catch (error) {
    if (import_provider_utils3.DownloadError.isInstance(error)) {
      throw error;
    }
    throw new import_provider_utils3.DownloadError({ url: urlText, cause: error });
  }
};

// src/util/download/download-function.ts
var createDefaultDownloadFunction = (download2 = download) => (requestedDownloads) => Promise.all(
  requestedDownloads.map(
    async (requestedDownload) => requestedDownload.isUrlSupportedByModel ? null : download2(requestedDownload)
  )
);

// src/prompt/data-content.ts
var import_provider18 = require("@ai-sdk/provider");
var import_provider_utils5 = require("@ai-sdk/provider-utils");
var import_v4 = require("zod/v4");

// src/prompt/split-data-url.ts
function splitDataUrl(dataUrl) {
  try {
    const [header, base64Content] = dataUrl.split(",");
    return {
      mediaType: header.split(";")[0].split(":")[1],
      base64Content
    };
  } catch (error) {
    return {
      mediaType: void 0,
      base64Content: void 0
    };
  }
}

// src/prompt/data-content.ts
var dataContentSchema = import_v4.z.union([
  import_v4.z.string(),
  import_v4.z.instanceof(Uint8Array),
  import_v4.z.instanceof(ArrayBuffer),
  import_v4.z.custom(
    // Buffer might not be available in some environments such as CloudFlare:
    (value) => {
      var _a16, _b;
      return (_b = (_a16 = globalThis.Buffer) == null ? void 0 : _a16.isBuffer(value)) != null ? _b : false;
    },
    { message: "Must be a Buffer" }
  )
]);
function convertToLanguageModelV3DataContent(content) {
  if (content instanceof Uint8Array) {
    return { data: content, mediaType: void 0 };
  }
  if (content instanceof ArrayBuffer) {
    return { data: new Uint8Array(content), mediaType: void 0 };
  }
  if (typeof content === "string") {
    try {
      content = new URL(content);
    } catch (error) {
    }
  }
  if (content instanceof URL && content.protocol === "data:") {
    const { mediaType: dataUrlMediaType, base64Content } = splitDataUrl(
      content.toString()
    );
    if (dataUrlMediaType == null || base64Content == null) {
      throw new import_provider18.AISDKError({
        name: "InvalidDataContentError",
        message: `Invalid data URL format in content ${content.toString()}`
      });
    }
    return { data: base64Content, mediaType: dataUrlMediaType };
  }
  return { data: content, mediaType: void 0 };
}
function convertDataContentToBase64String(content) {
  if (typeof content === "string") {
    return content;
  }
  if (content instanceof ArrayBuffer) {
    return (0, import_provider_utils5.convertUint8ArrayToBase64)(new Uint8Array(content));
  }
  return (0, import_provider_utils5.convertUint8ArrayToBase64)(content);
}
function convertDataContentToUint8Array(content) {
  if (content instanceof Uint8Array) {
    return content;
  }
  if (typeof content === "string") {
    try {
      return (0, import_provider_utils5.convertBase64ToUint8Array)(content);
    } catch (error) {
      throw new InvalidDataContentError({
        message: "Invalid data content. Content string is not a base64-encoded media.",
        content,
        cause: error
      });
    }
  }
  if (content instanceof ArrayBuffer) {
    return new Uint8Array(content);
  }
  throw new InvalidDataContentError({ content });
}

// src/util/as-array.ts
function asArray(value) {
  return value === void 0 ? [] : Array.isArray(value) ? value : [value];
}

// src/prompt/convert-to-language-model-prompt.ts
async function convertToLanguageModelPrompt({
  prompt,
  supportedUrls,
  download: download2 = createDefaultDownloadFunction()
}) {
  const downloadedAssets = await downloadAssets(
    prompt.messages,
    download2,
    supportedUrls
  );
  const messages = [
    ...prompt.system != null ? typeof prompt.system === "string" ? [{ role: "system", content: prompt.system }] : asArray(prompt.system).map((message) => ({
      role: "system",
      content: message.content,
      providerOptions: message.providerOptions
    })) : [],
    ...prompt.messages.map(
      (message) => convertToLanguageModelMessage({ message, downloadedAssets })
    )
  ];
  const combinedMessages = [];
  for (const message of messages) {
    if (message.role !== "tool") {
      combinedMessages.push(message);
      continue;
    }
    const lastCombinedMessage = combinedMessages.at(-1);
    if ((lastCombinedMessage == null ? void 0 : lastCombinedMessage.role) === "tool") {
      lastCombinedMessage.content.push(...message.content);
    } else {
      combinedMessages.push(message);
    }
  }
  return combinedMessages;
}
function convertToLanguageModelMessage({
  message,
  downloadedAssets
}) {
  const role = message.role;
  switch (role) {
    case "system": {
      return {
        role: "system",
        content: message.content,
        providerOptions: message.providerOptions
      };
    }
    case "user": {
      if (typeof message.content === "string") {
        return {
          role: "user",
          content: [{ type: "text", text: message.content }],
          providerOptions: message.providerOptions
        };
      }
      return {
        role: "user",
        content: message.content.map((part) => convertPartToLanguageModelPart(part, downloadedAssets)).filter((part) => part.type !== "text" || part.text !== ""),
        providerOptions: message.providerOptions
      };
    }
    case "assistant": {
      if (typeof message.content === "string") {
        return {
          role: "assistant",
          content: [{ type: "text", text: message.content }],
          providerOptions: message.providerOptions
        };
      }
      return {
        role: "assistant",
        content: message.content.filter(
          // remove empty text parts (no text, and no provider options):
          (part) => part.type !== "text" || part.text !== "" || part.providerOptions != null
        ).filter(
          (part) => part.type !== "tool-approval-request"
        ).map((part) => {
          const providerOptions = part.providerOptions;
          switch (part.type) {
            case "file": {
              const { data, mediaType } = convertToLanguageModelV3DataContent(
                part.data
              );
              return {
                type: "file",
                data,
                filename: part.filename,
                mediaType: mediaType != null ? mediaType : part.mediaType,
                providerOptions
              };
            }
            case "reasoning": {
              return {
                type: "reasoning",
                text: part.text,
                providerOptions
              };
            }
            case "text": {
              return {
                type: "text",
                text: part.text,
                providerOptions
              };
            }
            case "tool-call": {
              return {
                type: "tool-call",
                toolCallId: part.toolCallId,
                toolName: part.toolName,
                input: part.input,
                providerExecuted: part.providerExecuted,
                providerOptions
              };
            }
            case "tool-result": {
              return {
                type: "tool-result",
                toolCallId: part.toolCallId,
                toolName: part.toolName,
                output: mapToolResultOutput(part.output),
                providerOptions
              };
            }
          }
        }),
        providerOptions: message.providerOptions
      };
    }
    case "tool": {
      return {
        role: "tool",
        content: message.content.filter(
          // Only include tool-approval-response for provider-executed tools
          (part) => part.type !== "tool-approval-response" || part.providerExecuted
        ).map((part) => {
          switch (part.type) {
            case "tool-result": {
              return {
                type: "tool-result",
                toolCallId: part.toolCallId,
                toolName: part.toolName,
                output: mapToolResultOutput(part.output),
                providerOptions: part.providerOptions
              };
            }
            case "tool-approval-response": {
              return {
                type: "tool-approval-response",
                approvalId: part.approvalId,
                approved: part.approved,
                reason: part.reason
              };
            }
          }
        }),
        providerOptions: message.providerOptions
      };
    }
    default: {
      const _exhaustiveCheck = role;
      throw new InvalidMessageRoleError({ role: _exhaustiveCheck });
    }
  }
}
async function downloadAssets(messages, download2, supportedUrls) {
  const plannedDownloads = messages.filter((message) => message.role === "user").map((message) => message.content).filter(
    (content) => Array.isArray(content)
  ).flat().filter(
    (part) => part.type === "image" || part.type === "file"
  ).map((part) => {
    var _a16;
    const mediaType = (_a16 = part.mediaType) != null ? _a16 : part.type === "image" ? "image/*" : void 0;
    let data = part.type === "image" ? part.image : part.data;
    if (typeof data === "string") {
      try {
        data = new URL(data);
      } catch (ignored) {
      }
    }
    return { mediaType, data };
  }).filter(
    (part) => part.data instanceof URL
  ).map((part) => ({
    url: part.data,
    isUrlSupportedByModel: part.mediaType != null && (0, import_provider_utils6.isUrlSupported)({
      url: part.data.toString(),
      mediaType: part.mediaType,
      supportedUrls
    })
  }));
  const downloadedFiles = await download2(plannedDownloads);
  return Object.fromEntries(
    downloadedFiles.map(
      (file, index) => file == null ? null : [
        plannedDownloads[index].url.toString(),
        { data: file.data, mediaType: file.mediaType }
      ]
    ).filter((file) => file != null)
  );
}
function convertPartToLanguageModelPart(part, downloadedAssets) {
  var _a16;
  if (part.type === "text") {
    return {
      type: "text",
      text: part.text,
      providerOptions: part.providerOptions
    };
  }
  let originalData;
  const type = part.type;
  switch (type) {
    case "image":
      originalData = part.image;
      break;
    case "file":
      originalData = part.data;
      break;
    default:
      throw new Error(`Unsupported part type: ${type}`);
  }
  const { data: convertedData, mediaType: convertedMediaType } = convertToLanguageModelV3DataContent(originalData);
  let mediaType = convertedMediaType != null ? convertedMediaType : part.mediaType;
  let data = convertedData;
  if (data instanceof URL) {
    const downloadedFile = downloadedAssets[data.toString()];
    if (downloadedFile) {
      data = downloadedFile.data;
      mediaType != null ? mediaType : mediaType = downloadedFile.mediaType;
    }
  }
  switch (type) {
    case "image": {
      if (data instanceof Uint8Array || typeof data === "string") {
        mediaType = (_a16 = detectMediaType({ data, signatures: imageMediaTypeSignatures })) != null ? _a16 : mediaType;
      }
      return {
        type: "file",
        mediaType: mediaType != null ? mediaType : "image/*",
        // any image
        filename: void 0,
        data,
        providerOptions: part.providerOptions
      };
    }
    case "file": {
      if (mediaType == null) {
        throw new Error(`Media type is missing for file part`);
      }
      return {
        type: "file",
        mediaType,
        filename: part.filename,
        data,
        providerOptions: part.providerOptions
      };
    }
  }
}
function mapToolResultOutput(output) {
  if (output.type !== "content") {
    return output;
  }
  return {
    type: "content",
    value: output.value.map((item) => {
      if (item.type !== "media") {
        return item;
      }
      if (item.mediaType.startsWith("image/")) {
        return {
          type: "image-data",
          data: item.data,
          mediaType: item.mediaType
        };
      }
      return {
        type: "file-data",
        data: item.data,
        mediaType: item.mediaType
      };
    })
  };
}

// src/prompt/create-tool-model-output.ts
var import_provider19 = require("@ai-sdk/provider");
async function createToolModelOutput({
  toolCallId,
  input,
  output,
  tool: tool2,
  errorMode
}) {
  if (errorMode === "text") {
    return { type: "error-text", value: (0, import_provider19.getErrorMessage)(output) };
  } else if (errorMode === "json") {
    return { type: "error-json", value: toJSONValue(output) };
  }
  if (tool2 == null ? void 0 : tool2.toModelOutput) {
    return await tool2.toModelOutput({ toolCallId, input, output });
  }
  return typeof output === "string" ? { type: "text", value: output } : { type: "json", value: toJSONValue(output) };
}
function toJSONValue(value) {
  return value === void 0 ? null : value;
}

// src/prompt/prepare-call-settings.ts
function prepareCallSettings({
  maxOutputTokens,
  temperature,
  topP,
  topK,
  presencePenalty,
  frequencyPenalty,
  seed,
  stopSequences
}) {
  if (maxOutputTokens != null) {
    if (!Number.isInteger(maxOutputTokens)) {
      throw new InvalidArgumentError({
        parameter: "maxOutputTokens",
        value: maxOutputTokens,
        message: "maxOutputTokens must be an integer"
      });
    }
    if (maxOutputTokens < 1) {
      throw new InvalidArgumentError({
        parameter: "maxOutputTokens",
        value: maxOutputTokens,
        message: "maxOutputTokens must be >= 1"
      });
    }
  }
  if (temperature != null) {
    if (typeof temperature !== "number") {
      throw new InvalidArgumentError({
        parameter: "temperature",
        value: temperature,
        message: "temperature must be a number"
      });
    }
  }
  if (topP != null) {
    if (typeof topP !== "number") {
      throw new InvalidArgumentError({
        parameter: "topP",
        value: topP,
        message: "topP must be a number"
      });
    }
  }
  if (topK != null) {
    if (typeof topK !== "number") {
      throw new InvalidArgumentError({
        parameter: "topK",
        value: topK,
        message: "topK must be a number"
      });
    }
  }
  if (presencePenalty != null) {
    if (typeof presencePenalty !== "number") {
      throw new InvalidArgumentError({
        parameter: "presencePenalty",
        value: presencePenalty,
        message: "presencePenalty must be a number"
      });
    }
  }
  if (frequencyPenalty != null) {
    if (typeof frequencyPenalty !== "number") {
      throw new InvalidArgumentError({
        parameter: "frequencyPenalty",
        value: frequencyPenalty,
        message: "frequencyPenalty must be a number"
      });
    }
  }
  if (seed != null) {
    if (!Number.isInteger(seed)) {
      throw new InvalidArgumentError({
        parameter: "seed",
        value: seed,
        message: "seed must be an integer"
      });
    }
  }
  return {
    maxOutputTokens,
    temperature,
    topP,
    topK,
    presencePenalty,
    frequencyPenalty,
    stopSequences,
    seed
  };
}

// src/prompt/prepare-tools-and-tool-choice.ts
var import_provider_utils7 = require("@ai-sdk/provider-utils");

// src/util/is-non-empty-object.ts
function isNonEmptyObject(object2) {
  return object2 != null && Object.keys(object2).length > 0;
}

// src/prompt/prepare-tools-and-tool-choice.ts
async function prepareToolsAndToolChoice({
  tools,
  toolChoice,
  activeTools
}) {
  if (!isNonEmptyObject(tools)) {
    return {
      tools: void 0,
      toolChoice: void 0
    };
  }
  const filteredTools = activeTools != null ? Object.entries(tools).filter(
    ([name16]) => activeTools.includes(name16)
  ) : Object.entries(tools);
  const languageModelTools = [];
  for (const [name16, tool2] of filteredTools) {
    const toolType = tool2.type;
    switch (toolType) {
      case void 0:
      case "dynamic":
      case "function":
        languageModelTools.push({
          type: "function",
          name: name16,
          description: tool2.description,
          inputSchema: await (0, import_provider_utils7.asSchema)(tool2.inputSchema).jsonSchema,
          ...tool2.inputExamples != null ? { inputExamples: tool2.inputExamples } : {},
          providerOptions: tool2.providerOptions,
          ...tool2.strict != null ? { strict: tool2.strict } : {}
        });
        break;
      case "provider":
        languageModelTools.push({
          type: "provider",
          name: name16,
          id: tool2.id,
          args: tool2.args
        });
        break;
      default: {
        const exhaustiveCheck = toolType;
        throw new Error(`Unsupported tool type: ${exhaustiveCheck}`);
      }
    }
  }
  return {
    tools: languageModelTools,
    toolChoice: toolChoice == null ? { type: "auto" } : typeof toolChoice === "string" ? { type: toolChoice } : { type: "tool", toolName: toolChoice.toolName }
  };
}

// src/prompt/standardize-prompt.ts
var import_provider20 = require("@ai-sdk/provider");
var import_provider_utils8 = require("@ai-sdk/provider-utils");
var import_v46 = require("zod/v4");

// src/prompt/message.ts
var import_v45 = require("zod/v4");

// src/types/provider-metadata.ts
var import_v43 = require("zod/v4");

// src/types/json-value.ts
var import_v42 = require("zod/v4");
var jsonValueSchema = import_v42.z.lazy(
  () => import_v42.z.union([
    import_v42.z.null(),
    import_v42.z.string(),
    import_v42.z.number(),
    import_v42.z.boolean(),
    import_v42.z.record(import_v42.z.string(), jsonValueSchema.optional()),
    import_v42.z.array(jsonValueSchema)
  ])
);

// src/types/provider-metadata.ts
var providerMetadataSchema = import_v43.z.record(
  import_v43.z.string(),
  import_v43.z.record(import_v43.z.string(), jsonValueSchema.optional())
);

// src/prompt/content-part.ts
var import_v44 = require("zod/v4");
var textPartSchema = import_v44.z.object({
  type: import_v44.z.literal("text"),
  text: import_v44.z.string(),
  providerOptions: providerMetadataSchema.optional()
});
var imagePartSchema = import_v44.z.object({
  type: import_v44.z.literal("image"),
  image: import_v44.z.union([dataContentSchema, import_v44.z.instanceof(URL)]),
  mediaType: import_v44.z.string().optional(),
  providerOptions: providerMetadataSchema.optional()
});
var filePartSchema = import_v44.z.object({
  type: import_v44.z.literal("file"),
  data: import_v44.z.union([dataContentSchema, import_v44.z.instanceof(URL)]),
  filename: import_v44.z.string().optional(),
  mediaType: import_v44.z.string(),
  providerOptions: providerMetadataSchema.optional()
});
var reasoningPartSchema = import_v44.z.object({
  type: import_v44.z.literal("reasoning"),
  text: import_v44.z.string(),
  providerOptions: providerMetadataSchema.optional()
});
var toolCallPartSchema = import_v44.z.object({
  type: import_v44.z.literal("tool-call"),
  toolCallId: import_v44.z.string(),
  toolName: import_v44.z.string(),
  input: import_v44.z.unknown(),
  providerOptions: providerMetadataSchema.optional(),
  providerExecuted: import_v44.z.boolean().optional()
});
var outputSchema = import_v44.z.discriminatedUnion(
  "type",
  [
    import_v44.z.object({
      type: import_v44.z.literal("text"),
      value: import_v44.z.string(),
      providerOptions: providerMetadataSchema.optional()
    }),
    import_v44.z.object({
      type: import_v44.z.literal("json"),
      value: jsonValueSchema,
      providerOptions: providerMetadataSchema.optional()
    }),
    import_v44.z.object({
      type: import_v44.z.literal("execution-denied"),
      reason: import_v44.z.string().optional(),
      providerOptions: providerMetadataSchema.optional()
    }),
    import_v44.z.object({
      type: import_v44.z.literal("error-text"),
      value: import_v44.z.string(),
      providerOptions: providerMetadataSchema.optional()
    }),
    import_v44.z.object({
      type: import_v44.z.literal("error-json"),
      value: jsonValueSchema,
      providerOptions: providerMetadataSchema.optional()
    }),
    import_v44.z.object({
      type: import_v44.z.literal("content"),
      value: import_v44.z.array(
        import_v44.z.union([
          import_v44.z.object({
            type: import_v44.z.literal("text"),
            text: import_v44.z.string(),
            providerOptions: providerMetadataSchema.optional()
          }),
          import_v44.z.object({
            type: import_v44.z.literal("media"),
            data: import_v44.z.string(),
            mediaType: import_v44.z.string()
          }),
          import_v44.z.object({
            type: import_v44.z.literal("file-data"),
            data: import_v44.z.string(),
            mediaType: import_v44.z.string(),
            filename: import_v44.z.string().optional(),
            providerOptions: providerMetadataSchema.optional()
          }),
          import_v44.z.object({
            type: import_v44.z.literal("file-url"),
            url: import_v44.z.string(),
            providerOptions: providerMetadataSchema.optional()
          }),
          import_v44.z.object({
            type: import_v44.z.literal("file-id"),
            fileId: import_v44.z.union([import_v44.z.string(), import_v44.z.record(import_v44.z.string(), import_v44.z.string())]),
            providerOptions: providerMetadataSchema.optional()
          }),
          import_v44.z.object({
            type: import_v44.z.literal("image-data"),
            data: import_v44.z.string(),
            mediaType: import_v44.z.string(),
            providerOptions: providerMetadataSchema.optional()
          }),
          import_v44.z.object({
            type: import_v44.z.literal("image-url"),
            url: import_v44.z.string(),
            providerOptions: providerMetadataSchema.optional()
          }),
          import_v44.z.object({
            type: import_v44.z.literal("image-file-id"),
            fileId: import_v44.z.union([import_v44.z.string(), import_v44.z.record(import_v44.z.string(), import_v44.z.string())]),
            providerOptions: providerMetadataSchema.optional()
          }),
          import_v44.z.object({
            type: import_v44.z.literal("custom"),
            providerOptions: providerMetadataSchema.optional()
          })
        ])
      )
    })
  ]
);
var toolResultPartSchema = import_v44.z.object({
  type: import_v44.z.literal("tool-result"),
  toolCallId: import_v44.z.string(),
  toolName: import_v44.z.string(),
  output: outputSchema,
  providerOptions: providerMetadataSchema.optional()
});
var toolApprovalRequestSchema = import_v44.z.object({
  type: import_v44.z.literal("tool-approval-request"),
  approvalId: import_v44.z.string(),
  toolCallId: import_v44.z.string()
});
var toolApprovalResponseSchema = import_v44.z.object({
  type: import_v44.z.literal("tool-approval-response"),
  approvalId: import_v44.z.string(),
  approved: import_v44.z.boolean(),
  reason: import_v44.z.string().optional()
});

// src/prompt/message.ts
var systemModelMessageSchema = import_v45.z.object(
  {
    role: import_v45.z.literal("system"),
    content: import_v45.z.string(),
    providerOptions: providerMetadataSchema.optional()
  }
);
var userModelMessageSchema = import_v45.z.object({
  role: import_v45.z.literal("user"),
  content: import_v45.z.union([
    import_v45.z.string(),
    import_v45.z.array(import_v45.z.union([textPartSchema, imagePartSchema, filePartSchema]))
  ]),
  providerOptions: providerMetadataSchema.optional()
});
var assistantModelMessageSchema = import_v45.z.object({
  role: import_v45.z.literal("assistant"),
  content: import_v45.z.union([
    import_v45.z.string(),
    import_v45.z.array(
      import_v45.z.union([
        textPartSchema,
        filePartSchema,
        reasoningPartSchema,
        toolCallPartSchema,
        toolResultPartSchema,
        toolApprovalRequestSchema
      ])
    )
  ]),
  providerOptions: providerMetadataSchema.optional()
});
var toolModelMessageSchema = import_v45.z.object({
  role: import_v45.z.literal("tool"),
  content: import_v45.z.array(import_v45.z.union([toolResultPartSchema, toolApprovalResponseSchema])),
  providerOptions: providerMetadataSchema.optional()
});
var modelMessageSchema = import_v45.z.union([
  systemModelMessageSchema,
  userModelMessageSchema,
  assistantModelMessageSchema,
  toolModelMessageSchema
]);

// src/prompt/standardize-prompt.ts
async function standardizePrompt(prompt) {
  if (prompt.prompt == null && prompt.messages == null) {
    throw new import_provider20.InvalidPromptError({
      prompt,
      message: "prompt or messages must be defined"
    });
  }
  if (prompt.prompt != null && prompt.messages != null) {
    throw new import_provider20.InvalidPromptError({
      prompt,
      message: "prompt and messages cannot be defined at the same time"
    });
  }
  if (prompt.system != null && typeof prompt.system !== "string" && !asArray(prompt.system).every(
    (message) => typeof message === "object" && message !== null && "role" in message && message.role === "system"
  )) {
    throw new import_provider20.InvalidPromptError({
      prompt,
      message: "system must be a string, SystemModelMessage, or array of SystemModelMessage"
    });
  }
  let messages;
  if (prompt.prompt != null && typeof prompt.prompt === "string") {
    messages = [{ role: "user", content: prompt.prompt }];
  } else if (prompt.prompt != null && Array.isArray(prompt.prompt)) {
    messages = prompt.prompt;
  } else if (prompt.messages != null) {
    messages = prompt.messages;
  } else {
    throw new import_provider20.InvalidPromptError({
      prompt,
      message: "prompt or messages must be defined"
    });
  }
  if (messages.length === 0) {
    throw new import_provider20.InvalidPromptError({
      prompt,
      message: "messages must not be empty"
    });
  }
  const validationResult = await (0, import_provider_utils8.safeValidateTypes)({
    value: messages,
    schema: import_v46.z.array(modelMessageSchema)
  });
  if (!validationResult.success) {
    throw new import_provider20.InvalidPromptError({
      prompt,
      message: "The messages do not match the ModelMessage[] schema.",
      cause: validationResult.error
    });
  }
  return {
    messages,
    system: prompt.system
  };
}

// src/prompt/wrap-gateway-error.ts
var import_gateway2 = require("@ai-sdk/gateway");
var import_provider21 = require("@ai-sdk/provider");
function wrapGatewayError(error) {
  if (!import_gateway2.GatewayAuthenticationError.isInstance(error))
    return error;
  const isProductionEnv = (process == null ? void 0 : process.env.NODE_ENV) === "production";
  const moreInfoURL = "https://ai-sdk.dev/unauthenticated-ai-gateway";
  if (isProductionEnv) {
    return new import_provider21.AISDKError({
      name: "GatewayError",
      message: `Unauthenticated. Configure AI_GATEWAY_API_KEY or use a provider module. Learn more: ${moreInfoURL}`
    });
  }
  return Object.assign(
    new Error(`\x1B[1m\x1B[31mUnauthenticated request to AI Gateway.\x1B[0m

To authenticate, set the \x1B[33mAI_GATEWAY_API_KEY\x1B[0m environment variable with your API key.

Alternatively, you can use a provider module instead of the AI Gateway.

Learn more: \x1B[34m${moreInfoURL}\x1B[0m

`),
    { name: "GatewayAuthenticationError" }
  );
}

// src/telemetry/assemble-operation-name.ts
function assembleOperationName({
  operationId,
  telemetry
}) {
  return {
    // standardized operation and resource name:
    "operation.name": `${operationId}${(telemetry == null ? void 0 : telemetry.functionId) != null ? ` ${telemetry.functionId}` : ""}`,
    "resource.name": telemetry == null ? void 0 : telemetry.functionId,
    // detailed, AI SDK specific data:
    "ai.operationId": operationId,
    "ai.telemetry.functionId": telemetry == null ? void 0 : telemetry.functionId
  };
}

// src/telemetry/get-base-telemetry-attributes.ts
function getBaseTelemetryAttributes({
  model,
  settings,
  telemetry,
  headers
}) {
  var _a16;
  return {
    "ai.model.provider": model.provider,
    "ai.model.id": model.modelId,
    // settings:
    ...Object.entries(settings).reduce((attributes, [key, value]) => {
      if (key === "timeout") {
        const totalTimeoutMs = getTotalTimeoutMs(
          value
        );
        if (totalTimeoutMs != null) {
          attributes[`ai.settings.${key}`] = totalTimeoutMs;
        }
      } else {
        attributes[`ai.settings.${key}`] = value;
      }
      return attributes;
    }, {}),
    // add metadata as attributes:
    ...Object.entries((_a16 = telemetry == null ? void 0 : telemetry.metadata) != null ? _a16 : {}).reduce(
      (attributes, [key, value]) => {
        attributes[`ai.telemetry.metadata.${key}`] = value;
        return attributes;
      },
      {}
    ),
    // request headers
    ...Object.entries(headers != null ? headers : {}).reduce((attributes, [key, value]) => {
      if (value !== void 0) {
        attributes[`ai.request.headers.${key}`] = value;
      }
      return attributes;
    }, {})
  };
}

// src/telemetry/get-tracer.ts
var import_api = require("@opentelemetry/api");

// src/telemetry/noop-tracer.ts
var noopTracer = {
  startSpan() {
    return noopSpan;
  },
  startActiveSpan(name16, arg1, arg2, arg3) {
    if (typeof arg1 === "function") {
      return arg1(noopSpan);
    }
    if (typeof arg2 === "function") {
      return arg2(noopSpan);
    }
    if (typeof arg3 === "function") {
      return arg3(noopSpan);
    }
  }
};
var noopSpan = {
  spanContext() {
    return noopSpanContext;
  },
  setAttribute() {
    return this;
  },
  setAttributes() {
    return this;
  },
  addEvent() {
    return this;
  },
  addLink() {
    return this;
  },
  addLinks() {
    return this;
  },
  setStatus() {
    return this;
  },
  updateName() {
    return this;
  },
  end() {
    return this;
  },
  isRecording() {
    return false;
  },
  recordException() {
    return this;
  }
};
var noopSpanContext = {
  traceId: "",
  spanId: "",
  traceFlags: 0
};

// src/telemetry/get-tracer.ts
function getTracer({
  isEnabled = false,
  tracer
} = {}) {
  if (!isEnabled) {
    return noopTracer;
  }
  if (tracer) {
    return tracer;
  }
  return import_api.trace.getTracer("ai");
}

// src/telemetry/record-span.ts
var import_api2 = require("@opentelemetry/api");
async function recordSpan({
  name: name16,
  tracer,
  attributes,
  fn,
  endWhenDone = true
}) {
  return tracer.startActiveSpan(
    name16,
    { attributes: await attributes },
    async (span) => {
      try {
        const result = await fn(span);
        if (endWhenDone) {
          span.end();
        }
        return result;
      } catch (error) {
        try {
          recordErrorOnSpan(span, error);
        } finally {
          span.end();
        }
        throw error;
      }
    }
  );
}
function recordErrorOnSpan(span, error) {
  if (error instanceof Error) {
    span.recordException({
      name: error.name,
      message: error.message,
      stack: error.stack
    });
    span.setStatus({
      code: import_api2.SpanStatusCode.ERROR,
      message: error.message
    });
  } else {
    span.setStatus({ code: import_api2.SpanStatusCode.ERROR });
  }
}

// src/telemetry/select-telemetry-attributes.ts
async function selectTelemetryAttributes({
  telemetry,
  attributes
}) {
  if ((telemetry == null ? void 0 : telemetry.isEnabled) !== true) {
    return {};
  }
  const resultAttributes = {};
  for (const [key, value] of Object.entries(attributes)) {
    if (value == null) {
      continue;
    }
    if (typeof value === "object" && "input" in value && typeof value.input === "function") {
      if ((telemetry == null ? void 0 : telemetry.recordInputs) === false) {
        continue;
      }
      const result = await value.input();
      if (result != null) {
        resultAttributes[key] = result;
      }
      continue;
    }
    if (typeof value === "object" && "output" in value && typeof value.output === "function") {
      if ((telemetry == null ? void 0 : telemetry.recordOutputs) === false) {
        continue;
      }
      const result = await value.output();
      if (result != null) {
        resultAttributes[key] = result;
      }
      continue;
    }
    resultAttributes[key] = value;
  }
  return resultAttributes;
}

// src/telemetry/stringify-for-telemetry.ts
function stringifyForTelemetry(prompt) {
  return JSON.stringify(
    prompt.map((message) => ({
      ...message,
      content: typeof message.content === "string" ? message.content : message.content.map(
        (part) => part.type === "file" ? {
          ...part,
          data: part.data instanceof Uint8Array ? convertDataContentToBase64String(part.data) : part.data
        } : part
      )
    }))
  );
}

// src/types/usage.ts
function asLanguageModelUsage(usage) {
  return {
    inputTokens: usage.inputTokens.total,
    inputTokenDetails: {
      noCacheTokens: usage.inputTokens.noCache,
      cacheReadTokens: usage.inputTokens.cacheRead,
      cacheWriteTokens: usage.inputTokens.cacheWrite
    },
    outputTokens: usage.outputTokens.total,
    outputTokenDetails: {
      textTokens: usage.outputTokens.text,
      reasoningTokens: usage.outputTokens.reasoning
    },
    totalTokens: addTokenCounts(
      usage.inputTokens.total,
      usage.outputTokens.total
    ),
    raw: usage.raw,
    reasoningTokens: usage.outputTokens.reasoning,
    cachedInputTokens: usage.inputTokens.cacheRead
  };
}
function createNullLanguageModelUsage() {
  return {
    inputTokens: void 0,
    inputTokenDetails: {
      noCacheTokens: void 0,
      cacheReadTokens: void 0,
      cacheWriteTokens: void 0
    },
    outputTokens: void 0,
    outputTokenDetails: {
      textTokens: void 0,
      reasoningTokens: void 0
    },
    totalTokens: void 0,
    raw: void 0
  };
}
function addLanguageModelUsage(usage1, usage2) {
  var _a16, _b, _c, _d, _e, _f, _g, _h, _i, _j;
  return {
    inputTokens: addTokenCounts(usage1.inputTokens, usage2.inputTokens),
    inputTokenDetails: {
      noCacheTokens: addTokenCounts(
        (_a16 = usage1.inputTokenDetails) == null ? void 0 : _a16.noCacheTokens,
        (_b = usage2.inputTokenDetails) == null ? void 0 : _b.noCacheTokens
      ),
      cacheReadTokens: addTokenCounts(
        (_c = usage1.inputTokenDetails) == null ? void 0 : _c.cacheReadTokens,
        (_d = usage2.inputTokenDetails) == null ? void 0 : _d.cacheReadTokens
      ),
      cacheWriteTokens: addTokenCounts(
        (_e = usage1.inputTokenDetails) == null ? void 0 : _e.cacheWriteTokens,
        (_f = usage2.inputTokenDetails) == null ? void 0 : _f.cacheWriteTokens
      )
    },
    outputTokens: addTokenCounts(usage1.outputTokens, usage2.outputTokens),
    outputTokenDetails: {
      textTokens: addTokenCounts(
        (_g = usage1.outputTokenDetails) == null ? void 0 : _g.textTokens,
        (_h = usage2.outputTokenDetails) == null ? void 0 : _h.textTokens
      ),
      reasoningTokens: addTokenCounts(
        (_i = usage1.outputTokenDetails) == null ? void 0 : _i.reasoningTokens,
        (_j = usage2.outputTokenDetails) == null ? void 0 : _j.reasoningTokens
      )
    },
    totalTokens: addTokenCounts(usage1.totalTokens, usage2.totalTokens),
    reasoningTokens: addTokenCounts(
      usage1.reasoningTokens,
      usage2.reasoningTokens
    ),
    cachedInputTokens: addTokenCounts(
      usage1.cachedInputTokens,
      usage2.cachedInputTokens
    )
  };
}
function addTokenCounts(tokenCount1, tokenCount2) {
  return tokenCount1 == null && tokenCount2 == null ? void 0 : (tokenCount1 != null ? tokenCount1 : 0) + (tokenCount2 != null ? tokenCount2 : 0);
}
function addImageModelUsage(usage1, usage2) {
  return {
    inputTokens: addTokenCounts(usage1.inputTokens, usage2.inputTokens),
    outputTokens: addTokenCounts(usage1.outputTokens, usage2.outputTokens),
    totalTokens: addTokenCounts(usage1.totalTokens, usage2.totalTokens)
  };
}

// src/util/merge-objects.ts
function mergeObjects(base, overrides) {
  if (base === void 0 && overrides === void 0) {
    return void 0;
  }
  if (base === void 0) {
    return overrides;
  }
  if (overrides === void 0) {
    return base;
  }
  const result = { ...base };
  for (const key in overrides) {
    if (Object.prototype.hasOwnProperty.call(overrides, key)) {
      const overridesValue = overrides[key];
      if (overridesValue === void 0)
        continue;
      const baseValue = key in base ? base[key] : void 0;
      const isSourceObject = overridesValue !== null && typeof overridesValue === "object" && !Array.isArray(overridesValue) && !(overridesValue instanceof Date) && !(overridesValue instanceof RegExp);
      const isTargetObject = baseValue !== null && baseValue !== void 0 && typeof baseValue === "object" && !Array.isArray(baseValue) && !(baseValue instanceof Date) && !(baseValue instanceof RegExp);
      if (isSourceObject && isTargetObject) {
        result[key] = mergeObjects(
          baseValue,
          overridesValue
        );
      } else {
        result[key] = overridesValue;
      }
    }
  }
  return result;
}

// src/util/retry-with-exponential-backoff.ts
var import_provider22 = require("@ai-sdk/provider");
var import_provider_utils9 = require("@ai-sdk/provider-utils");
function getRetryDelayInMs({
  error,
  exponentialBackoffDelay
}) {
  const headers = error.responseHeaders;
  if (!headers)
    return exponentialBackoffDelay;
  let ms;
  const retryAfterMs = headers["retry-after-ms"];
  if (retryAfterMs) {
    const timeoutMs = parseFloat(retryAfterMs);
    if (!Number.isNaN(timeoutMs)) {
      ms = timeoutMs;
    }
  }
  const retryAfter = headers["retry-after"];
  if (retryAfter && ms === void 0) {
    const timeoutSeconds = parseFloat(retryAfter);
    if (!Number.isNaN(timeoutSeconds)) {
      ms = timeoutSeconds * 1e3;
    } else {
      ms = Date.parse(retryAfter) - Date.now();
    }
  }
  if (ms != null && !Number.isNaN(ms) && 0 <= ms && (ms < 60 * 1e3 || ms < exponentialBackoffDelay)) {
    return ms;
  }
  return exponentialBackoffDelay;
}
var retryWithExponentialBackoffRespectingRetryHeaders = ({
  maxRetries = 2,
  initialDelayInMs = 2e3,
  backoffFactor = 2,
  abortSignal
} = {}) => async (f) => _retryWithExponentialBackoff(f, {
  maxRetries,
  delayInMs: initialDelayInMs,
  backoffFactor,
  abortSignal
});
async function _retryWithExponentialBackoff(f, {
  maxRetries,
  delayInMs,
  backoffFactor,
  abortSignal
}, errors = []) {
  try {
    return await f();
  } catch (error) {
    if ((0, import_provider_utils9.isAbortError)(error)) {
      throw error;
    }
    if (maxRetries === 0) {
      throw error;
    }
    const errorMessage = (0, import_provider_utils9.getErrorMessage)(error);
    const newErrors = [...errors, error];
    const tryNumber = newErrors.length;
    if (tryNumber > maxRetries) {
      throw new RetryError({
        message: `Failed after ${tryNumber} attempts. Last error: ${errorMessage}`,
        reason: "maxRetriesExceeded",
        errors: newErrors
      });
    }
    if (error instanceof Error && import_provider22.APICallError.isInstance(error) && error.isRetryable === true && tryNumber <= maxRetries) {
      await (0, import_provider_utils9.delay)(
        getRetryDelayInMs({
          error,
          exponentialBackoffDelay: delayInMs
        }),
        { abortSignal }
      );
      return _retryWithExponentialBackoff(
        f,
        {
          maxRetries,
          delayInMs: backoffFactor * delayInMs,
          backoffFactor,
          abortSignal
        },
        newErrors
      );
    }
    if (tryNumber === 1) {
      throw error;
    }
    throw new RetryError({
      message: `Failed after ${tryNumber} attempts with non-retryable error: '${errorMessage}'`,
      reason: "errorNotRetryable",
      errors: newErrors
    });
  }
}

// src/util/prepare-retries.ts
function prepareRetries({
  maxRetries,
  abortSignal
}) {
  if (maxRetries != null) {
    if (!Number.isInteger(maxRetries)) {
      throw new InvalidArgumentError({
        parameter: "maxRetries",
        value: maxRetries,
        message: "maxRetries must be an integer"
      });
    }
    if (maxRetries < 0) {
      throw new InvalidArgumentError({
        parameter: "maxRetries",
        value: maxRetries,
        message: "maxRetries must be >= 0"
      });
    }
  }
  const maxRetriesResult = maxRetries != null ? maxRetries : 2;
  return {
    maxRetries: maxRetriesResult,
    retry: retryWithExponentialBackoffRespectingRetryHeaders({
      maxRetries: maxRetriesResult,
      abortSignal
    })
  };
}

// src/generate-text/collect-tool-approvals.ts
function collectToolApprovals({
  messages
}) {
  const lastMessage = messages.at(-1);
  if ((lastMessage == null ? void 0 : lastMessage.role) != "tool") {
    return {
      approvedToolApprovals: [],
      deniedToolApprovals: []
    };
  }
  const toolCallsByToolCallId = {};
  for (const message of messages) {
    if (message.role === "assistant" && typeof message.content !== "string") {
      const content = message.content;
      for (const part of content) {
        if (part.type === "tool-call") {
          toolCallsByToolCallId[part.toolCallId] = part;
        }
      }
    }
  }
  const toolApprovalRequestsByApprovalId = {};
  for (const message of messages) {
    if (message.role === "assistant" && typeof message.content !== "string") {
      const content = message.content;
      for (const part of content) {
        if (part.type === "tool-approval-request") {
          toolApprovalRequestsByApprovalId[part.approvalId] = part;
        }
      }
    }
  }
  const toolResults = {};
  for (const part of lastMessage.content) {
    if (part.type === "tool-result") {
      toolResults[part.toolCallId] = part;
    }
  }
  const approvedToolApprovals = [];
  const deniedToolApprovals = [];
  const approvalResponses = lastMessage.content.filter(
    (part) => part.type === "tool-approval-response"
  );
  for (const approvalResponse of approvalResponses) {
    const approvalRequest = toolApprovalRequestsByApprovalId[approvalResponse.approvalId];
    if (approvalRequest == null) {
      throw new InvalidToolApprovalError({
        approvalId: approvalResponse.approvalId
      });
    }
    if (toolResults[approvalRequest.toolCallId] != null) {
      continue;
    }
    const toolCall = toolCallsByToolCallId[approvalRequest.toolCallId];
    if (toolCall == null) {
      throw new ToolCallNotFoundForApprovalError({
        toolCallId: approvalRequest.toolCallId,
        approvalId: approvalRequest.approvalId
      });
    }
    const approval = {
      approvalRequest,
      approvalResponse,
      toolCall
    };
    if (approvalResponse.approved) {
      approvedToolApprovals.push(approval);
    } else {
      deniedToolApprovals.push(approval);
    }
  }
  return { approvedToolApprovals, deniedToolApprovals };
}

// src/generate-text/execute-tool-call.ts
var import_provider_utils10 = require("@ai-sdk/provider-utils");
async function executeToolCall({
  toolCall,
  tools,
  tracer,
  telemetry,
  messages,
  abortSignal,
  experimental_context,
  onPreliminaryToolResult
}) {
  const { toolName, toolCallId, input } = toolCall;
  const tool2 = tools == null ? void 0 : tools[toolName];
  if ((tool2 == null ? void 0 : tool2.execute) == null) {
    return void 0;
  }
  return recordSpan({
    name: "ai.toolCall",
    attributes: selectTelemetryAttributes({
      telemetry,
      attributes: {
        ...assembleOperationName({
          operationId: "ai.toolCall",
          telemetry
        }),
        "ai.toolCall.name": toolName,
        "ai.toolCall.id": toolCallId,
        "ai.toolCall.args": {
          output: () => JSON.stringify(input)
        }
      }
    }),
    tracer,
    fn: async (span) => {
      let output;
      try {
        const stream = (0, import_provider_utils10.executeTool)({
          execute: tool2.execute.bind(tool2),
          input,
          options: {
            toolCallId,
            messages,
            abortSignal,
            experimental_context
          }
        });
        for await (const part of stream) {
          if (part.type === "preliminary") {
            onPreliminaryToolResult == null ? void 0 : onPreliminaryToolResult({
              ...toolCall,
              type: "tool-result",
              output: part.output,
              preliminary: true
            });
          } else {
            output = part.output;
          }
        }
      } catch (error) {
        recordErrorOnSpan(span, error);
        return {
          type: "tool-error",
          toolCallId,
          toolName,
          input,
          error,
          dynamic: tool2.type === "dynamic",
          ...toolCall.providerMetadata != null ? { providerMetadata: toolCall.providerMetadata } : {}
        };
      }
      try {
        span.setAttributes(
          await selectTelemetryAttributes({
            telemetry,
            attributes: {
              "ai.toolCall.result": {
                output: () => JSON.stringify(output)
              }
            }
          })
        );
      } catch (ignored) {
      }
      return {
        type: "tool-result",
        toolCallId,
        toolName,
        input,
        output,
        dynamic: tool2.type === "dynamic",
        ...toolCall.providerMetadata != null ? { providerMetadata: toolCall.providerMetadata } : {}
      };
    }
  });
}

// src/generate-text/extract-text-content.ts
function extractTextContent(content) {
  const parts = content.filter(
    (content2) => content2.type === "text"
  );
  if (parts.length === 0) {
    return void 0;
  }
  return parts.map((content2) => content2.text).join("");
}

// src/generate-text/generated-file.ts
var import_provider_utils11 = require("@ai-sdk/provider-utils");
var DefaultGeneratedFile = class {
  constructor({
    data,
    mediaType
  }) {
    const isUint8Array = data instanceof Uint8Array;
    this.base64Data = isUint8Array ? void 0 : data;
    this.uint8ArrayData = isUint8Array ? data : void 0;
    this.mediaType = mediaType;
  }
  // lazy conversion with caching to avoid unnecessary conversion overhead:
  get base64() {
    if (this.base64Data == null) {
      this.base64Data = (0, import_provider_utils11.convertUint8ArrayToBase64)(this.uint8ArrayData);
    }
    return this.base64Data;
  }
  // lazy conversion with caching to avoid unnecessary conversion overhead:
  get uint8Array() {
    if (this.uint8ArrayData == null) {
      this.uint8ArrayData = (0, import_provider_utils11.convertBase64ToUint8Array)(this.base64Data);
    }
    return this.uint8ArrayData;
  }
};
var DefaultGeneratedFileWithType = class extends DefaultGeneratedFile {
  constructor(options) {
    super(options);
    this.type = "file";
  }
};

// src/generate-text/is-approval-needed.ts
async function isApprovalNeeded({
  tool: tool2,
  toolCall,
  messages,
  experimental_context
}) {
  if (tool2.needsApproval == null) {
    return false;
  }
  if (typeof tool2.needsApproval === "boolean") {
    return tool2.needsApproval;
  }
  return await tool2.needsApproval(toolCall.input, {
    toolCallId: toolCall.toolCallId,
    messages,
    experimental_context
  });
}

// src/generate-text/output.ts
var output_exports = {};
__export(output_exports, {
  array: () => array,
  choice: () => choice,
  json: () => json,
  object: () => object,
  text: () => text
});
var import_provider23 = require("@ai-sdk/provider");
var import_provider_utils13 = require("@ai-sdk/provider-utils");

// src/util/parse-partial-json.ts
var import_provider_utils12 = require("@ai-sdk/provider-utils");

// src/util/fix-json.ts
function fixJson(input) {
  const stack = ["ROOT"];
  let lastValidIndex = -1;
  let literalStart = null;
  function processValueStart(char, i, swapState) {
    {
      switch (char) {
        case '"': {
          lastValidIndex = i;
          stack.pop();
          stack.push(swapState);
          stack.push("INSIDE_STRING");
          break;
        }
        case "f":
        case "t":
        case "n": {
          lastValidIndex = i;
          literalStart = i;
          stack.pop();
          stack.push(swapState);
          stack.push("INSIDE_LITERAL");
          break;
        }
        case "-": {
          stack.pop();
          stack.push(swapState);
          stack.push("INSIDE_NUMBER");
          break;
        }
        case "0":
        case "1":
        case "2":
        case "3":
        case "4":
        case "5":
        case "6":
        case "7":
        case "8":
        case "9": {
          lastValidIndex = i;
          stack.pop();
          stack.push(swapState);
          stack.push("INSIDE_NUMBER");
          break;
        }
        case "{": {
          lastValidIndex = i;
          stack.pop();
          stack.push(swapState);
          stack.push("INSIDE_OBJECT_START");
          break;
        }
        case "[": {
          lastValidIndex = i;
          stack.pop();
          stack.push(swapState);
          stack.push("INSIDE_ARRAY_START");
          break;
        }
      }
    }
  }
  function processAfterObjectValue(char, i) {
    switch (char) {
      case ",": {
        stack.pop();
        stack.push("INSIDE_OBJECT_AFTER_COMMA");
        break;
      }
      case "}": {
        lastValidIndex = i;
        stack.pop();
        break;
      }
    }
  }
  function processAfterArrayValue(char, i) {
    switch (char) {
      case ",": {
        stack.pop();
        stack.push("INSIDE_ARRAY_AFTER_COMMA");
        break;
      }
      case "]": {
        lastValidIndex = i;
        stack.pop();
        break;
      }
    }
  }
  for (let i = 0; i < input.length; i++) {
    const char = input[i];
    const currentState = stack[stack.length - 1];
    switch (currentState) {
      case "ROOT":
        processValueStart(char, i, "FINISH");
        break;
      case "INSIDE_OBJECT_START": {
        switch (char) {
          case '"': {
            stack.pop();
            stack.push("INSIDE_OBJECT_KEY");
            break;
          }
          case "}": {
            lastValidIndex = i;
            stack.pop();
            break;
          }
        }
        break;
      }
      case "INSIDE_OBJECT_AFTER_COMMA": {
        switch (char) {
          case '"': {
            stack.pop();
            stack.push("INSIDE_OBJECT_KEY");
            break;
          }
        }
        break;
      }
      case "INSIDE_OBJECT_KEY": {
        switch (char) {
          case '"': {
            stack.pop();
            stack.push("INSIDE_OBJECT_AFTER_KEY");
            break;
          }
        }
        break;
      }
      case "INSIDE_OBJECT_AFTER_KEY": {
        switch (char) {
          case ":": {
            stack.pop();
            stack.push("INSIDE_OBJECT_BEFORE_VALUE");
            break;
          }
        }
        break;
      }
      case "INSIDE_OBJECT_BEFORE_VALUE": {
        processValueStart(char, i, "INSIDE_OBJECT_AFTER_VALUE");
        break;
      }
      case "INSIDE_OBJECT_AFTER_VALUE": {
        processAfterObjectValue(char, i);
        break;
      }
      case "INSIDE_STRING": {
        switch (char) {
          case '"': {
            stack.pop();
            lastValidIndex = i;
            break;
          }
          case "\\": {
            stack.push("INSIDE_STRING_ESCAPE");
            break;
          }
          default: {
            lastValidIndex = i;
          }
        }
        break;
      }
      case "INSIDE_ARRAY_START": {
        switch (char) {
          case "]": {
            lastValidIndex = i;
            stack.pop();
            break;
          }
          default: {
            lastValidIndex = i;
            processValueStart(char, i, "INSIDE_ARRAY_AFTER_VALUE");
            break;
          }
        }
        break;
      }
      case "INSIDE_ARRAY_AFTER_VALUE": {
        switch (char) {
          case ",": {
            stack.pop();
            stack.push("INSIDE_ARRAY_AFTER_COMMA");
            break;
          }
          case "]": {
            lastValidIndex = i;
            stack.pop();
            break;
          }
          default: {
            lastValidIndex = i;
            break;
          }
        }
        break;
      }
      case "INSIDE_ARRAY_AFTER_COMMA": {
        processValueStart(char, i, "INSIDE_ARRAY_AFTER_VALUE");
        break;
      }
      case "INSIDE_STRING_ESCAPE": {
        stack.pop();
        lastValidIndex = i;
        break;
      }
      case "INSIDE_NUMBER": {
        switch (char) {
          case "0":
          case "1":
          case "2":
          case "3":
          case "4":
          case "5":
          case "6":
          case "7":
          case "8":
          case "9": {
            lastValidIndex = i;
            break;
          }
          case "e":
          case "E":
          case "-":
          case ".": {
            break;
          }
          case ",": {
            stack.pop();
            if (stack[stack.length - 1] === "INSIDE_ARRAY_AFTER_VALUE") {
              processAfterArrayValue(char, i);
            }
            if (stack[stack.length - 1] === "INSIDE_OBJECT_AFTER_VALUE") {
              processAfterObjectValue(char, i);
            }
            break;
          }
          case "}": {
            stack.pop();
            if (stack[stack.length - 1] === "INSIDE_OBJECT_AFTER_VALUE") {
              processAfterObjectValue(char, i);
            }
            break;
          }
          case "]": {
            stack.pop();
            if (stack[stack.length - 1] === "INSIDE_ARRAY_AFTER_VALUE") {
              processAfterArrayValue(char, i);
            }
            break;
          }
          default: {
            stack.pop();
            break;
          }
        }
        break;
      }
      case "INSIDE_LITERAL": {
        const partialLiteral = input.substring(literalStart, i + 1);
        if (!"false".startsWith(partialLiteral) && !"true".startsWith(partialLiteral) && !"null".startsWith(partialLiteral)) {
          stack.pop();
          if (stack[stack.length - 1] === "INSIDE_OBJECT_AFTER_VALUE") {
            processAfterObjectValue(char, i);
          } else if (stack[stack.length - 1] === "INSIDE_ARRAY_AFTER_VALUE") {
            processAfterArrayValue(char, i);
          }
        } else {
          lastValidIndex = i;
        }
        break;
      }
    }
  }
  let result = input.slice(0, lastValidIndex + 1);
  for (let i = stack.length - 1; i >= 0; i--) {
    const state = stack[i];
    switch (state) {
      case "INSIDE_STRING": {
        result += '"';
        break;
      }
      case "INSIDE_OBJECT_KEY":
      case "INSIDE_OBJECT_AFTER_KEY":
      case "INSIDE_OBJECT_AFTER_COMMA":
      case "INSIDE_OBJECT_START":
      case "INSIDE_OBJECT_BEFORE_VALUE":
      case "INSIDE_OBJECT_AFTER_VALUE": {
        result += "}";
        break;
      }
      case "INSIDE_ARRAY_START":
      case "INSIDE_ARRAY_AFTER_COMMA":
      case "INSIDE_ARRAY_AFTER_VALUE": {
        result += "]";
        break;
      }
      case "INSIDE_LITERAL": {
        const partialLiteral = input.substring(literalStart, input.length);
        if ("true".startsWith(partialLiteral)) {
          result += "true".slice(partialLiteral.length);
        } else if ("false".startsWith(partialLiteral)) {
          result += "false".slice(partialLiteral.length);
        } else if ("null".startsWith(partialLiteral)) {
          result += "null".slice(partialLiteral.length);
        }
      }
    }
  }
  return result;
}

// src/util/parse-partial-json.ts
async function parsePartialJson(jsonText) {
  if (jsonText === void 0) {
    return { value: void 0, state: "undefined-input" };
  }
  let result = await (0, import_provider_utils12.safeParseJSON)({ text: jsonText });
  if (result.success) {
    return { value: result.value, state: "successful-parse" };
  }
  result = await (0, import_provider_utils12.safeParseJSON)({ text: fixJson(jsonText) });
  if (result.success) {
    return { value: result.value, state: "repaired-parse" };
  }
  return { value: void 0, state: "failed-parse" };
}

// src/generate-text/output.ts
var text = () => ({
  responseFormat: Promise.resolve({ type: "text" }),
  async parseCompleteOutput({ text: text2 }) {
    return text2;
  },
  async parsePartialOutput({ text: text2 }) {
    return { partial: text2 };
  }
});
var object = ({
  schema: inputSchema,
  name: name16,
  description
}) => {
  const schema = (0, import_provider_utils13.asSchema)(inputSchema);
  return {
    responseFormat: (0, import_provider_utils13.resolve)(schema.jsonSchema).then((jsonSchema2) => ({
      type: "json",
      schema: jsonSchema2,
      ...name16 != null && { name: name16 },
      ...description != null && { description }
    })),
    async parseCompleteOutput({ text: text2 }, context) {
      const parseResult = await (0, import_provider_utils13.safeParseJSON)({ text: text2 });
      if (!parseResult.success) {
        throw new NoObjectGeneratedError({
          message: "No object generated: could not parse the response.",
          cause: parseResult.error,
          text: text2,
          response: context.response,
          usage: context.usage,
          finishReason: context.finishReason
        });
      }
      const validationResult = await (0, import_provider_utils13.safeValidateTypes)({
        value: parseResult.value,
        schema
      });
      if (!validationResult.success) {
        throw new NoObjectGeneratedError({
          message: "No object generated: response did not match schema.",
          cause: validationResult.error,
          text: text2,
          response: context.response,
          usage: context.usage,
          finishReason: context.finishReason
        });
      }
      return validationResult.value;
    },
    async parsePartialOutput({ text: text2 }) {
      const result = await parsePartialJson(text2);
      switch (result.state) {
        case "failed-parse":
        case "undefined-input": {
          return void 0;
        }
        case "repaired-parse":
        case "successful-parse": {
          return {
            // Note: currently no validation of partial results:
            partial: result.value
          };
        }
      }
    }
  };
};
var array = ({
  element: inputElementSchema,
  name: name16,
  description
}) => {
  const elementSchema = (0, import_provider_utils13.asSchema)(inputElementSchema);
  return {
    // JSON schema that describes an array of elements:
    responseFormat: (0, import_provider_utils13.resolve)(elementSchema.jsonSchema).then((jsonSchema2) => {
      const { $schema, ...itemSchema } = jsonSchema2;
      return {
        type: "json",
        schema: {
          $schema: "http://json-schema.org/draft-07/schema#",
          type: "object",
          properties: {
            elements: { type: "array", items: itemSchema }
          },
          required: ["elements"],
          additionalProperties: false
        },
        ...name16 != null && { name: name16 },
        ...description != null && { description }
      };
    }),
    async parseCompleteOutput({ text: text2 }, context) {
      const parseResult = await (0, import_provider_utils13.safeParseJSON)({ text: text2 });
      if (!parseResult.success) {
        throw new NoObjectGeneratedError({
          message: "No object generated: could not parse the response.",
          cause: parseResult.error,
          text: text2,
          response: context.response,
          usage: context.usage,
          finishReason: context.finishReason
        });
      }
      const outerValue = parseResult.value;
      if (outerValue == null || typeof outerValue !== "object" || !("elements" in outerValue) || !Array.isArray(outerValue.elements)) {
        throw new NoObjectGeneratedError({
          message: "No object generated: response did not match schema.",
          cause: new import_provider23.TypeValidationError({
            value: outerValue,
            cause: "response must be an object with an elements array"
          }),
          text: text2,
          response: context.response,
          usage: context.usage,
          finishReason: context.finishReason
        });
      }
      for (const element of outerValue.elements) {
        const validationResult = await (0, import_provider_utils13.safeValidateTypes)({
          value: element,
          schema: elementSchema
        });
        if (!validationResult.success) {
          throw new NoObjectGeneratedError({
            message: "No object generated: response did not match schema.",
            cause: validationResult.error,
            text: text2,
            response: context.response,
            usage: context.usage,
            finishReason: context.finishReason
          });
        }
      }
      return outerValue.elements;
    },
    async parsePartialOutput({ text: text2 }) {
      const result = await parsePartialJson(text2);
      switch (result.state) {
        case "failed-parse":
        case "undefined-input": {
          return void 0;
        }
        case "repaired-parse":
        case "successful-parse": {
          const outerValue = result.value;
          if (outerValue == null || typeof outerValue !== "object" || !("elements" in outerValue) || !Array.isArray(outerValue.elements)) {
            return void 0;
          }
          const rawElements = result.state === "repaired-parse" && outerValue.elements.length > 0 ? outerValue.elements.slice(0, -1) : outerValue.elements;
          const parsedElements = [];
          for (const rawElement of rawElements) {
            const validationResult = await (0, import_provider_utils13.safeValidateTypes)({
              value: rawElement,
              schema: elementSchema
            });
            if (validationResult.success) {
              parsedElements.push(validationResult.value);
            }
          }
          return { partial: parsedElements };
        }
      }
    }
  };
};
var choice = ({
  options: choiceOptions,
  name: name16,
  description
}) => {
  return {
    // JSON schema that describes an enumeration:
    responseFormat: Promise.resolve({
      type: "json",
      schema: {
        $schema: "http://json-schema.org/draft-07/schema#",
        type: "object",
        properties: {
          result: { type: "string", enum: choiceOptions }
        },
        required: ["result"],
        additionalProperties: false
      },
      ...name16 != null && { name: name16 },
      ...description != null && { description }
    }),
    async parseCompleteOutput({ text: text2 }, context) {
      const parseResult = await (0, import_provider_utils13.safeParseJSON)({ text: text2 });
      if (!parseResult.success) {
        throw new NoObjectGeneratedError({
          message: "No object generated: could not parse the response.",
          cause: parseResult.error,
          text: text2,
          response: context.response,
          usage: context.usage,
          finishReason: context.finishReason
        });
      }
      const outerValue = parseResult.value;
      if (outerValue == null || typeof outerValue !== "object" || !("result" in outerValue) || typeof outerValue.result !== "string" || !choiceOptions.includes(outerValue.result)) {
        throw new NoObjectGeneratedError({
          message: "No object generated: response did not match schema.",
          cause: new import_provider23.TypeValidationError({
            value: outerValue,
            cause: "response must be an object that contains a choice value."
          }),
          text: text2,
          response: context.response,
          usage: context.usage,
          finishReason: context.finishReason
        });
      }
      return outerValue.result;
    },
    async parsePartialOutput({ text: text2 }) {
      const result = await parsePartialJson(text2);
      switch (result.state) {
        case "failed-parse":
        case "undefined-input": {
          return void 0;
        }
        case "repaired-parse":
        case "successful-parse": {
          const outerValue = result.value;
          if (outerValue == null || typeof outerValue !== "object" || !("result" in outerValue) || typeof outerValue.result !== "string") {
            return void 0;
          }
          const potentialMatches = choiceOptions.filter(
            (choiceOption) => choiceOption.startsWith(outerValue.result)
          );
          if (result.state === "successful-parse") {
            return potentialMatches.includes(outerValue.result) ? { partial: outerValue.result } : void 0;
          } else {
            return potentialMatches.length === 1 ? { partial: potentialMatches[0] } : void 0;
          }
        }
      }
    }
  };
};
var json = ({
  name: name16,
  description
} = {}) => {
  return {
    responseFormat: Promise.resolve({
      type: "json",
      ...name16 != null && { name: name16 },
      ...description != null && { description }
    }),
    async parseCompleteOutput({ text: text2 }, context) {
      const parseResult = await (0, import_provider_utils13.safeParseJSON)({ text: text2 });
      if (!parseResult.success) {
        throw new NoObjectGeneratedError({
          message: "No object generated: could not parse the response.",
          cause: parseResult.error,
          text: text2,
          response: context.response,
          usage: context.usage,
          finishReason: context.finishReason
        });
      }
      return parseResult.value;
    },
    async parsePartialOutput({ text: text2 }) {
      const result = await parsePartialJson(text2);
      switch (result.state) {
        case "failed-parse":
        case "undefined-input": {
          return void 0;
        }
        case "repaired-parse":
        case "successful-parse": {
          return result.value === void 0 ? void 0 : { partial: result.value };
        }
      }
    }
  };
};

// src/generate-text/parse-tool-call.ts
var import_provider_utils14 = require("@ai-sdk/provider-utils");
async function parseToolCall({
  toolCall,
  tools,
  repairToolCall,
  system,
  messages
}) {
  var _a16;
  try {
    if (tools == null) {
      if (toolCall.providerExecuted && toolCall.dynamic) {
        return await parseProviderExecutedDynamicToolCall(toolCall);
      }
      throw new NoSuchToolError({ toolName: toolCall.toolName });
    }
    try {
      return await doParseToolCall({ toolCall, tools });
    } catch (error) {
      if (repairToolCall == null || !(NoSuchToolError.isInstance(error) || InvalidToolInputError.isInstance(error))) {
        throw error;
      }
      let repairedToolCall = null;
      try {
        repairedToolCall = await repairToolCall({
          toolCall,
          tools,
          inputSchema: async ({ toolName }) => {
            const { inputSchema } = tools[toolName];
            return await (0, import_provider_utils14.asSchema)(inputSchema).jsonSchema;
          },
          system,
          messages,
          error
        });
      } catch (repairError) {
        throw new ToolCallRepairError({
          cause: repairError,
          originalError: error
        });
      }
      if (repairedToolCall == null) {
        throw error;
      }
      return await doParseToolCall({ toolCall: repairedToolCall, tools });
    }
  } catch (error) {
    const parsedInput = await (0, import_provider_utils14.safeParseJSON)({ text: toolCall.input });
    const input = parsedInput.success ? parsedInput.value : toolCall.input;
    return {
      type: "tool-call",
      toolCallId: toolCall.toolCallId,
      toolName: toolCall.toolName,
      input,
      dynamic: true,
      invalid: true,
      error,
      title: (_a16 = tools == null ? void 0 : tools[toolCall.toolName]) == null ? void 0 : _a16.title,
      providerExecuted: toolCall.providerExecuted,
      providerMetadata: toolCall.providerMetadata
    };
  }
}
async function parseProviderExecutedDynamicToolCall(toolCall) {
  const parseResult = toolCall.input.trim() === "" ? { success: true, value: {} } : await (0, import_provider_utils14.safeParseJSON)({ text: toolCall.input });
  if (parseResult.success === false) {
    throw new InvalidToolInputError({
      toolName: toolCall.toolName,
      toolInput: toolCall.input,
      cause: parseResult.error
    });
  }
  return {
    type: "tool-call",
    toolCallId: toolCall.toolCallId,
    toolName: toolCall.toolName,
    input: parseResult.value,
    providerExecuted: true,
    dynamic: true,
    providerMetadata: toolCall.providerMetadata
  };
}
async function doParseToolCall({
  toolCall,
  tools
}) {
  const toolName = toolCall.toolName;
  const tool2 = tools[toolName];
  if (tool2 == null) {
    if (toolCall.providerExecuted && toolCall.dynamic) {
      return await parseProviderExecutedDynamicToolCall(toolCall);
    }
    throw new NoSuchToolError({
      toolName: toolCall.toolName,
      availableTools: Object.keys(tools)
    });
  }
  const schema = (0, import_provider_utils14.asSchema)(tool2.inputSchema);
  const parseResult = toolCall.input.trim() === "" ? await (0, import_provider_utils14.safeValidateTypes)({ value: {}, schema }) : await (0, import_provider_utils14.safeParseJSON)({ text: toolCall.input, schema });
  if (parseResult.success === false) {
    throw new InvalidToolInputError({
      toolName,
      toolInput: toolCall.input,
      cause: parseResult.error
    });
  }
  return tool2.type === "dynamic" ? {
    type: "tool-call",
    toolCallId: toolCall.toolCallId,
    toolName: toolCall.toolName,
    input: parseResult.value,
    providerExecuted: toolCall.providerExecuted,
    providerMetadata: toolCall.providerMetadata,
    dynamic: true,
    title: tool2.title
  } : {
    type: "tool-call",
    toolCallId: toolCall.toolCallId,
    toolName,
    input: parseResult.value,
    providerExecuted: toolCall.providerExecuted,
    providerMetadata: toolCall.providerMetadata,
    title: tool2.title
  };
}

// src/generate-text/step-result.ts
var DefaultStepResult = class {
  constructor({
    content,
    finishReason,
    rawFinishReason,
    usage,
    warnings,
    request,
    response,
    providerMetadata
  }) {
    this.content = content;
    this.finishReason = finishReason;
    this.rawFinishReason = rawFinishReason;
    this.usage = usage;
    this.warnings = warnings;
    this.request = request;
    this.response = response;
    this.providerMetadata = providerMetadata;
  }
  get text() {
    return this.content.filter((part) => part.type === "text").map((part) => part.text).join("");
  }
  get reasoning() {
    return this.content.filter((part) => part.type === "reasoning");
  }
  get reasoningText() {
    return this.reasoning.length === 0 ? void 0 : this.reasoning.map((part) => part.text).join("");
  }
  get files() {
    return this.content.filter((part) => part.type === "file").map((part) => part.file);
  }
  get sources() {
    return this.content.filter((part) => part.type === "source");
  }
  get toolCalls() {
    return this.content.filter((part) => part.type === "tool-call");
  }
  get staticToolCalls() {
    return this.toolCalls.filter(
      (toolCall) => toolCall.dynamic !== true
    );
  }
  get dynamicToolCalls() {
    return this.toolCalls.filter(
      (toolCall) => toolCall.dynamic === true
    );
  }
  get toolResults() {
    return this.content.filter((part) => part.type === "tool-result");
  }
  get staticToolResults() {
    return this.toolResults.filter(
      (toolResult) => toolResult.dynamic !== true
    );
  }
  get dynamicToolResults() {
    return this.toolResults.filter(
      (toolResult) => toolResult.dynamic === true
    );
  }
};

// src/generate-text/stop-condition.ts
function stepCountIs(stepCount) {
  return ({ steps }) => steps.length === stepCount;
}
function hasToolCall(toolName) {
  return ({ steps }) => {
    var _a16, _b, _c;
    return (_c = (_b = (_a16 = steps[steps.length - 1]) == null ? void 0 : _a16.toolCalls) == null ? void 0 : _b.some(
      (toolCall) => toolCall.toolName === toolName
    )) != null ? _c : false;
  };
}
async function isStopConditionMet({
  stopConditions,
  steps
}) {
  return (await Promise.all(stopConditions.map((condition) => condition({ steps })))).some((result) => result);
}

// src/generate-text/to-response-messages.ts
async function toResponseMessages({
  content: inputContent,
  tools
}) {
  const responseMessages = [];
  const content = [];
  for (const part of inputContent) {
    if (part.type === "source") {
      continue;
    }
    if ((part.type === "tool-result" || part.type === "tool-error") && !part.providerExecuted) {
      continue;
    }
    if (part.type === "text" && part.text.length === 0) {
      continue;
    }
    switch (part.type) {
      case "text":
        content.push({
          type: "text",
          text: part.text,
          providerOptions: part.providerMetadata
        });
        break;
      case "reasoning":
        content.push({
          type: "reasoning",
          text: part.text,
          providerOptions: part.providerMetadata
        });
        break;
      case "file":
        content.push({
          type: "file",
          data: part.file.base64,
          mediaType: part.file.mediaType,
          providerOptions: part.providerMetadata
        });
        break;
      case "tool-call":
        content.push({
          type: "tool-call",
          toolCallId: part.toolCallId,
          toolName: part.toolName,
          input: part.input,
          providerExecuted: part.providerExecuted,
          providerOptions: part.providerMetadata
        });
        break;
      case "tool-result": {
        const output = await createToolModelOutput({
          toolCallId: part.toolCallId,
          input: part.input,
          tool: tools == null ? void 0 : tools[part.toolName],
          output: part.output,
          errorMode: "none"
        });
        content.push({
          type: "tool-result",
          toolCallId: part.toolCallId,
          toolName: part.toolName,
          output,
          providerOptions: part.providerMetadata
        });
        break;
      }
      case "tool-error": {
        const output = await createToolModelOutput({
          toolCallId: part.toolCallId,
          input: part.input,
          tool: tools == null ? void 0 : tools[part.toolName],
          output: part.error,
          errorMode: "json"
        });
        content.push({
          type: "tool-result",
          toolCallId: part.toolCallId,
          toolName: part.toolName,
          output,
          providerOptions: part.providerMetadata
        });
        break;
      }
      case "tool-approval-request":
        content.push({
          type: "tool-approval-request",
          approvalId: part.approvalId,
          toolCallId: part.toolCall.toolCallId
        });
        break;
    }
  }
  if (content.length > 0) {
    responseMessages.push({
      role: "assistant",
      content
    });
  }
  const toolResultContent = [];
  for (const part of inputContent) {
    if (!(part.type === "tool-result" || part.type === "tool-error") || part.providerExecuted) {
      continue;
    }
    const output = await createToolModelOutput({
      toolCallId: part.toolCallId,
      input: part.input,
      tool: tools == null ? void 0 : tools[part.toolName],
      output: part.type === "tool-result" ? part.output : part.error,
      errorMode: part.type === "tool-error" ? "text" : "none"
    });
    toolResultContent.push({
      type: "tool-result",
      toolCallId: part.toolCallId,
      toolName: part.toolName,
      output,
      ...part.providerMetadata != null ? { providerOptions: part.providerMetadata } : {}
    });
  }
  if (toolResultContent.length > 0) {
    responseMessages.push({
      role: "tool",
      content: toolResultContent
    });
  }
  return responseMessages;
}

// src/util/merge-abort-signals.ts
function mergeAbortSignals(...signals) {
  const validSignals = signals.filter(
    (signal) => signal != null
  );
  if (validSignals.length === 0) {
    return void 0;
  }
  if (validSignals.length === 1) {
    return validSignals[0];
  }
  const controller = new AbortController();
  for (const signal of validSignals) {
    if (signal.aborted) {
      controller.abort(signal.reason);
      return controller.signal;
    }
    signal.addEventListener(
      "abort",
      () => {
        controller.abort(signal.reason);
      },
      { once: true }
    );
  }
  return controller.signal;
}

// src/generate-text/generate-text.ts
var originalGenerateId = (0, import_provider_utils15.createIdGenerator)({
  prefix: "aitxt",
  size: 24
});
async function generateText({
  model: modelArg,
  tools,
  toolChoice,
  system,
  prompt,
  messages,
  maxRetries: maxRetriesArg,
  abortSignal,
  timeout,
  headers,
  stopWhen = stepCountIs(1),
  experimental_output,
  output = experimental_output,
  experimental_telemetry: telemetry,
  providerOptions,
  experimental_activeTools,
  activeTools = experimental_activeTools,
  experimental_prepareStep,
  prepareStep = experimental_prepareStep,
  experimental_repairToolCall: repairToolCall,
  experimental_download: download2,
  experimental_context,
  _internal: { generateId: generateId2 = originalGenerateId } = {},
  onStepFinish,
  onFinish,
  ...settings
}) {
  const model = resolveLanguageModel(modelArg);
  const stopConditions = asArray(stopWhen);
  const totalTimeoutMs = getTotalTimeoutMs(timeout);
  const mergedAbortSignal = mergeAbortSignals(
    abortSignal,
    totalTimeoutMs != null ? AbortSignal.timeout(totalTimeoutMs) : void 0
  );
  const { maxRetries, retry } = prepareRetries({
    maxRetries: maxRetriesArg,
    abortSignal: mergedAbortSignal
  });
  const callSettings = prepareCallSettings(settings);
  const headersWithUserAgent = (0, import_provider_utils15.withUserAgentSuffix)(
    headers != null ? headers : {},
    `ai/${VERSION}`
  );
  const baseTelemetryAttributes = getBaseTelemetryAttributes({
    model,
    telemetry,
    headers: headersWithUserAgent,
    settings: { ...callSettings, maxRetries }
  });
  const initialPrompt = await standardizePrompt({
    system,
    prompt,
    messages
  });
  const tracer = getTracer(telemetry);
  try {
    return await recordSpan({
      name: "ai.generateText",
      attributes: selectTelemetryAttributes({
        telemetry,
        attributes: {
          ...assembleOperationName({
            operationId: "ai.generateText",
            telemetry
          }),
          ...baseTelemetryAttributes,
          // model:
          "ai.model.provider": model.provider,
          "ai.model.id": model.modelId,
          // specific settings that only make sense on the outer level:
          "ai.prompt": {
            input: () => JSON.stringify({ system, prompt, messages })
          }
        }
      }),
      tracer,
      fn: async (span) => {
        var _a16, _b, _c, _d, _e, _f, _g, _h;
        const initialMessages = initialPrompt.messages;
        const responseMessages = [];
        const { approvedToolApprovals, deniedToolApprovals } = collectToolApprovals({ messages: initialMessages });
        const localApprovedToolApprovals = approvedToolApprovals.filter(
          (toolApproval) => !toolApproval.toolCall.providerExecuted
        );
        if (deniedToolApprovals.length > 0 || localApprovedToolApprovals.length > 0) {
          const toolOutputs = await executeTools({
            toolCalls: localApprovedToolApprovals.map(
              (toolApproval) => toolApproval.toolCall
            ),
            tools,
            tracer,
            telemetry,
            messages: initialMessages,
            abortSignal: mergedAbortSignal,
            experimental_context
          });
          const toolContent = [];
          for (const output2 of toolOutputs) {
            const modelOutput = await createToolModelOutput({
              toolCallId: output2.toolCallId,
              input: output2.input,
              tool: tools == null ? void 0 : tools[output2.toolName],
              output: output2.type === "tool-result" ? output2.output : output2.error,
              errorMode: output2.type === "tool-error" ? "json" : "none"
            });
            toolContent.push({
              type: "tool-result",
              toolCallId: output2.toolCallId,
              toolName: output2.toolName,
              output: modelOutput
            });
          }
          for (const toolApproval of deniedToolApprovals) {
            toolContent.push({
              type: "tool-result",
              toolCallId: toolApproval.toolCall.toolCallId,
              toolName: toolApproval.toolCall.toolName,
              output: {
                type: "execution-denied",
                reason: toolApproval.approvalResponse.reason,
                // For provider-executed tools, include approvalId so provider can correlate
                ...toolApproval.toolCall.providerExecuted && {
                  providerOptions: {
                    openai: {
                      approvalId: toolApproval.approvalResponse.approvalId
                    }
                  }
                }
              }
            });
          }
          responseMessages.push({
            role: "tool",
            content: toolContent
          });
        }
        const providerExecutedToolApprovals = [
          ...approvedToolApprovals,
          ...deniedToolApprovals
        ].filter((toolApproval) => toolApproval.toolCall.providerExecuted);
        if (providerExecutedToolApprovals.length > 0) {
          responseMessages.push({
            role: "tool",
            content: providerExecutedToolApprovals.map(
              (toolApproval) => ({
                type: "tool-approval-response",
                approvalId: toolApproval.approvalResponse.approvalId,
                approved: toolApproval.approvalResponse.approved,
                reason: toolApproval.approvalResponse.reason,
                providerExecuted: true
              })
            )
          });
        }
        const callSettings2 = prepareCallSettings(settings);
        let currentModelResponse;
        let clientToolCalls = [];
        let clientToolOutputs = [];
        const steps = [];
        const pendingDeferredToolCalls = /* @__PURE__ */ new Map();
        do {
          const stepInputMessages = [...initialMessages, ...responseMessages];
          const prepareStepResult = await (prepareStep == null ? void 0 : prepareStep({
            model,
            steps,
            stepNumber: steps.length,
            messages: stepInputMessages,
            experimental_context
          }));
          const stepModel = resolveLanguageModel(
            (_a16 = prepareStepResult == null ? void 0 : prepareStepResult.model) != null ? _a16 : model
          );
          const promptMessages = await convertToLanguageModelPrompt({
            prompt: {
              system: (_b = prepareStepResult == null ? void 0 : prepareStepResult.system) != null ? _b : initialPrompt.system,
              messages: (_c = prepareStepResult == null ? void 0 : prepareStepResult.messages) != null ? _c : stepInputMessages
            },
            supportedUrls: await stepModel.supportedUrls,
            download: download2
          });
          experimental_context = (_d = prepareStepResult == null ? void 0 : prepareStepResult.experimental_context) != null ? _d : experimental_context;
          const { toolChoice: stepToolChoice, tools: stepTools } = await prepareToolsAndToolChoice({
            tools,
            toolChoice: (_e = prepareStepResult == null ? void 0 : prepareStepResult.toolChoice) != null ? _e : toolChoice,
            activeTools: (_f = prepareStepResult == null ? void 0 : prepareStepResult.activeTools) != null ? _f : activeTools
          });
          currentModelResponse = await retry(
            () => {
              var _a17;
              return recordSpan({
                name: "ai.generateText.doGenerate",
                attributes: selectTelemetryAttributes({
                  telemetry,
                  attributes: {
                    ...assembleOperationName({
                      operationId: "ai.generateText.doGenerate",
                      telemetry
                    }),
                    ...baseTelemetryAttributes,
                    // model:
                    "ai.model.provider": stepModel.provider,
                    "ai.model.id": stepModel.modelId,
                    // prompt:
                    "ai.prompt.messages": {
                      input: () => stringifyForTelemetry(promptMessages)
                    },
                    "ai.prompt.tools": {
                      // convert the language model level tools:
                      input: () => stepTools == null ? void 0 : stepTools.map((tool2) => JSON.stringify(tool2))
                    },
                    "ai.prompt.toolChoice": {
                      input: () => stepToolChoice != null ? JSON.stringify(stepToolChoice) : void 0
                    },
                    // standardized gen-ai llm span attributes:
                    "gen_ai.system": stepModel.provider,
                    "gen_ai.request.model": stepModel.modelId,
                    "gen_ai.request.frequency_penalty": settings.frequencyPenalty,
                    "gen_ai.request.max_tokens": settings.maxOutputTokens,
                    "gen_ai.request.presence_penalty": settings.presencePenalty,
                    "gen_ai.request.stop_sequences": settings.stopSequences,
                    "gen_ai.request.temperature": (_a17 = settings.temperature) != null ? _a17 : void 0,
                    "gen_ai.request.top_k": settings.topK,
                    "gen_ai.request.top_p": settings.topP
                  }
                }),
                tracer,
                fn: async (span2) => {
                  var _a18, _b2, _c2, _d2, _e2, _f2, _g2, _h2;
                  const stepProviderOptions = mergeObjects(
                    providerOptions,
                    prepareStepResult == null ? void 0 : prepareStepResult.providerOptions
                  );
                  const result = await stepModel.doGenerate({
                    ...callSettings2,
                    tools: stepTools,
                    toolChoice: stepToolChoice,
                    responseFormat: await (output == null ? void 0 : output.responseFormat),
                    prompt: promptMessages,
                    providerOptions: stepProviderOptions,
                    abortSignal: mergedAbortSignal,
                    headers: headersWithUserAgent
                  });
                  const responseData = {
                    id: (_b2 = (_a18 = result.response) == null ? void 0 : _a18.id) != null ? _b2 : generateId2(),
                    timestamp: (_d2 = (_c2 = result.response) == null ? void 0 : _c2.timestamp) != null ? _d2 : /* @__PURE__ */ new Date(),
                    modelId: (_f2 = (_e2 = result.response) == null ? void 0 : _e2.modelId) != null ? _f2 : stepModel.modelId,
                    headers: (_g2 = result.response) == null ? void 0 : _g2.headers,
                    body: (_h2 = result.response) == null ? void 0 : _h2.body
                  };
                  span2.setAttributes(
                    await selectTelemetryAttributes({
                      telemetry,
                      attributes: {
                        "ai.response.finishReason": result.finishReason.unified,
                        "ai.response.text": {
                          output: () => extractTextContent(result.content)
                        },
                        "ai.response.toolCalls": {
                          output: () => {
                            const toolCalls = asToolCalls(result.content);
                            return toolCalls == null ? void 0 : JSON.stringify(toolCalls);
                          }
                        },
                        "ai.response.id": responseData.id,
                        "ai.response.model": responseData.modelId,
                        "ai.response.timestamp": responseData.timestamp.toISOString(),
                        "ai.response.providerMetadata": JSON.stringify(
                          result.providerMetadata
                        ),
                        // TODO rename telemetry attributes to inputTokens and outputTokens
                        "ai.usage.promptTokens": result.usage.inputTokens.total,
                        "ai.usage.completionTokens": result.usage.outputTokens.total,
                        // standardized gen-ai llm span attributes:
                        "gen_ai.response.finish_reasons": [
                          result.finishReason.unified
                        ],
                        "gen_ai.response.id": responseData.id,
                        "gen_ai.response.model": responseData.modelId,
                        "gen_ai.usage.input_tokens": result.usage.inputTokens.total,
                        "gen_ai.usage.output_tokens": result.usage.outputTokens.total
                      }
                    })
                  );
                  return { ...result, response: responseData };
                }
              });
            }
          );
          const stepToolCalls = await Promise.all(
            currentModelResponse.content.filter(
              (part) => part.type === "tool-call"
            ).map(
              (toolCall) => parseToolCall({
                toolCall,
                tools,
                repairToolCall,
                system,
                messages: stepInputMessages
              })
            )
          );
          const toolApprovalRequests = {};
          for (const toolCall of stepToolCalls) {
            if (toolCall.invalid) {
              continue;
            }
            const tool2 = tools == null ? void 0 : tools[toolCall.toolName];
            if (tool2 == null) {
              continue;
            }
            if ((tool2 == null ? void 0 : tool2.onInputAvailable) != null) {
              await tool2.onInputAvailable({
                input: toolCall.input,
                toolCallId: toolCall.toolCallId,
                messages: stepInputMessages,
                abortSignal: mergedAbortSignal,
                experimental_context
              });
            }
            if (await isApprovalNeeded({
              tool: tool2,
              toolCall,
              messages: stepInputMessages,
              experimental_context
            })) {
              toolApprovalRequests[toolCall.toolCallId] = {
                type: "tool-approval-request",
                approvalId: generateId2(),
                toolCall
              };
            }
          }
          const invalidToolCalls = stepToolCalls.filter(
            (toolCall) => toolCall.invalid && toolCall.dynamic
          );
          clientToolOutputs = [];
          for (const toolCall of invalidToolCalls) {
            clientToolOutputs.push({
              type: "tool-error",
              toolCallId: toolCall.toolCallId,
              toolName: toolCall.toolName,
              input: toolCall.input,
              error: (0, import_provider_utils15.getErrorMessage)(toolCall.error),
              dynamic: true
            });
          }
          clientToolCalls = stepToolCalls.filter(
            (toolCall) => !toolCall.providerExecuted
          );
          if (tools != null) {
            clientToolOutputs.push(
              ...await executeTools({
                toolCalls: clientToolCalls.filter(
                  (toolCall) => !toolCall.invalid && toolApprovalRequests[toolCall.toolCallId] == null
                ),
                tools,
                tracer,
                telemetry,
                messages: stepInputMessages,
                abortSignal: mergedAbortSignal,
                experimental_context
              })
            );
          }
          for (const toolCall of stepToolCalls) {
            if (!toolCall.providerExecuted)
              continue;
            const tool2 = tools == null ? void 0 : tools[toolCall.toolName];
            if ((tool2 == null ? void 0 : tool2.type) === "provider" && tool2.supportsDeferredResults) {
              const hasResultInResponse = currentModelResponse.content.some(
                (part) => part.type === "tool-result" && part.toolCallId === toolCall.toolCallId
              );
              if (!hasResultInResponse) {
                pendingDeferredToolCalls.set(toolCall.toolCallId, {
                  toolName: toolCall.toolName
                });
              }
            }
          }
          for (const part of currentModelResponse.content) {
            if (part.type === "tool-result") {
              pendingDeferredToolCalls.delete(part.toolCallId);
            }
          }
          const stepContent = asContent({
            content: currentModelResponse.content,
            toolCalls: stepToolCalls,
            toolOutputs: clientToolOutputs,
            toolApprovalRequests: Object.values(toolApprovalRequests),
            tools
          });
          responseMessages.push(
            ...await toResponseMessages({
              content: stepContent,
              tools
            })
          );
          const currentStepResult = new DefaultStepResult({
            content: stepContent,
            finishReason: currentModelResponse.finishReason.unified,
            rawFinishReason: currentModelResponse.finishReason.raw,
            usage: asLanguageModelUsage(currentModelResponse.usage),
            warnings: currentModelResponse.warnings,
            providerMetadata: currentModelResponse.providerMetadata,
            request: (_g = currentModelResponse.request) != null ? _g : {},
            response: {
              ...currentModelResponse.response,
              // deep clone msgs to avoid mutating past messages in multi-step:
              messages: structuredClone(responseMessages)
            }
          });
          logWarnings({
            warnings: (_h = currentModelResponse.warnings) != null ? _h : [],
            provider: stepModel.provider,
            model: stepModel.modelId
          });
          steps.push(currentStepResult);
          await (onStepFinish == null ? void 0 : onStepFinish(currentStepResult));
        } while (
          // Continue if:
          // 1. There are client tool calls that have all been executed, OR
          // 2. There are pending deferred results from provider-executed tools
          (clientToolCalls.length > 0 && clientToolOutputs.length === clientToolCalls.length || pendingDeferredToolCalls.size > 0) && // continue until a stop condition is met:
          !await isStopConditionMet({ stopConditions, steps })
        );
        span.setAttributes(
          await selectTelemetryAttributes({
            telemetry,
            attributes: {
              "ai.response.finishReason": currentModelResponse.finishReason.unified,
              "ai.response.text": {
                output: () => extractTextContent(currentModelResponse.content)
              },
              "ai.response.toolCalls": {
                output: () => {
                  const toolCalls = asToolCalls(currentModelResponse.content);
                  return toolCalls == null ? void 0 : JSON.stringify(toolCalls);
                }
              },
              "ai.response.providerMetadata": JSON.stringify(
                currentModelResponse.providerMetadata
              ),
              // TODO rename telemetry attributes to inputTokens and outputTokens
              "ai.usage.promptTokens": currentModelResponse.usage.inputTokens.total,
              "ai.usage.completionTokens": currentModelResponse.usage.outputTokens.total
            }
          })
        );
        const lastStep = steps[steps.length - 1];
        const totalUsage = steps.reduce(
          (totalUsage2, step) => {
            return addLanguageModelUsage(totalUsage2, step.usage);
          },
          {
            inputTokens: void 0,
            outputTokens: void 0,
            totalTokens: void 0,
            reasoningTokens: void 0,
            cachedInputTokens: void 0
          }
        );
        await (onFinish == null ? void 0 : onFinish({
          finishReason: lastStep.finishReason,
          rawFinishReason: lastStep.rawFinishReason,
          usage: lastStep.usage,
          content: lastStep.content,
          text: lastStep.text,
          reasoningText: lastStep.reasoningText,
          reasoning: lastStep.reasoning,
          files: lastStep.files,
          sources: lastStep.sources,
          toolCalls: lastStep.toolCalls,
          staticToolCalls: lastStep.staticToolCalls,
          dynamicToolCalls: lastStep.dynamicToolCalls,
          toolResults: lastStep.toolResults,
          staticToolResults: lastStep.staticToolResults,
          dynamicToolResults: lastStep.dynamicToolResults,
          request: lastStep.request,
          response: lastStep.response,
          warnings: lastStep.warnings,
          providerMetadata: lastStep.providerMetadata,
          steps,
          totalUsage,
          experimental_context
        }));
        let resolvedOutput;
        if (lastStep.finishReason === "stop") {
          const outputSpecification = output != null ? output : text();
          resolvedOutput = await outputSpecification.parseCompleteOutput(
            { text: lastStep.text },
            {
              response: lastStep.response,
              usage: lastStep.usage,
              finishReason: lastStep.finishReason
            }
          );
        }
        return new DefaultGenerateTextResult({
          steps,
          totalUsage,
          output: resolvedOutput
        });
      }
    });
  } catch (error) {
    throw wrapGatewayError(error);
  }
}
async function executeTools({
  toolCalls,
  tools,
  tracer,
  telemetry,
  messages,
  abortSignal,
  experimental_context
}) {
  const toolOutputs = await Promise.all(
    toolCalls.map(
      async (toolCall) => executeToolCall({
        toolCall,
        tools,
        tracer,
        telemetry,
        messages,
        abortSignal,
        experimental_context
      })
    )
  );
  return toolOutputs.filter(
    (output) => output != null
  );
}
var DefaultGenerateTextResult = class {
  constructor(options) {
    this.steps = options.steps;
    this._output = options.output;
    this.totalUsage = options.totalUsage;
  }
  get finalStep() {
    return this.steps[this.steps.length - 1];
  }
  get content() {
    return this.finalStep.content;
  }
  get text() {
    return this.finalStep.text;
  }
  get files() {
    return this.finalStep.files;
  }
  get reasoningText() {
    return this.finalStep.reasoningText;
  }
  get reasoning() {
    return this.finalStep.reasoning;
  }
  get toolCalls() {
    return this.finalStep.toolCalls;
  }
  get staticToolCalls() {
    return this.finalStep.staticToolCalls;
  }
  get dynamicToolCalls() {
    return this.finalStep.dynamicToolCalls;
  }
  get toolResults() {
    return this.finalStep.toolResults;
  }
  get staticToolResults() {
    return this.finalStep.staticToolResults;
  }
  get dynamicToolResults() {
    return this.finalStep.dynamicToolResults;
  }
  get sources() {
    return this.finalStep.sources;
  }
  get finishReason() {
    return this.finalStep.finishReason;
  }
  get rawFinishReason() {
    return this.finalStep.rawFinishReason;
  }
  get warnings() {
    return this.finalStep.warnings;
  }
  get providerMetadata() {
    return this.finalStep.providerMetadata;
  }
  get response() {
    return this.finalStep.response;
  }
  get request() {
    return this.finalStep.request;
  }
  get usage() {
    return this.finalStep.usage;
  }
  get experimental_output() {
    return this.output;
  }
  get output() {
    if (this._output == null) {
      throw new NoOutputGeneratedError();
    }
    return this._output;
  }
};
function asToolCalls(content) {
  const parts = content.filter(
    (part) => part.type === "tool-call"
  );
  if (parts.length === 0) {
    return void 0;
  }
  return parts.map((toolCall) => ({
    toolCallId: toolCall.toolCallId,
    toolName: toolCall.toolName,
    input: toolCall.input
  }));
}
function asContent({
  content,
  toolCalls,
  toolOutputs,
  toolApprovalRequests,
  tools
}) {
  const contentParts = [];
  for (const part of content) {
    switch (part.type) {
      case "text":
      case "reasoning":
      case "source":
        contentParts.push(part);
        break;
      case "file": {
        contentParts.push({
          type: "file",
          file: new DefaultGeneratedFile(part),
          ...part.providerMetadata != null ? { providerMetadata: part.providerMetadata } : {}
        });
        break;
      }
      case "tool-call": {
        contentParts.push(
          toolCalls.find((toolCall) => toolCall.toolCallId === part.toolCallId)
        );
        break;
      }
      case "tool-result": {
        const toolCall = toolCalls.find(
          (toolCall2) => toolCall2.toolCallId === part.toolCallId
        );
        if (toolCall == null) {
          const tool2 = tools == null ? void 0 : tools[part.toolName];
          const supportsDeferredResults = (tool2 == null ? void 0 : tool2.type) === "provider" && tool2.supportsDeferredResults;
          if (!supportsDeferredResults) {
            throw new Error(`Tool call ${part.toolCallId} not found.`);
          }
          if (part.isError) {
            contentParts.push({
              type: "tool-error",
              toolCallId: part.toolCallId,
              toolName: part.toolName,
              input: void 0,
              error: part.result,
              providerExecuted: true,
              dynamic: part.dynamic
            });
          } else {
            contentParts.push({
              type: "tool-result",
              toolCallId: part.toolCallId,
              toolName: part.toolName,
              input: void 0,
              output: part.result,
              providerExecuted: true,
              dynamic: part.dynamic
            });
          }
          break;
        }
        if (part.isError) {
          contentParts.push({
            type: "tool-error",
            toolCallId: part.toolCallId,
            toolName: part.toolName,
            input: toolCall.input,
            error: part.result,
            providerExecuted: true,
            dynamic: toolCall.dynamic
          });
        } else {
          contentParts.push({
            type: "tool-result",
            toolCallId: part.toolCallId,
            toolName: part.toolName,
            input: toolCall.input,
            output: part.result,
            providerExecuted: true,
            dynamic: toolCall.dynamic
          });
        }
        break;
      }
      case "tool-approval-request": {
        const toolCall = toolCalls.find(
          (toolCall2) => toolCall2.toolCallId === part.toolCallId
        );
        if (toolCall == null) {
          throw new ToolCallNotFoundForApprovalError({
            toolCallId: part.toolCallId,
            approvalId: part.approvalId
          });
        }
        contentParts.push({
          type: "tool-approval-request",
          approvalId: part.approvalId,
          toolCall
        });
        break;
      }
    }
  }
  return [...contentParts, ...toolOutputs, ...toolApprovalRequests];
}

// src/generate-text/stream-text.ts
var import_provider24 = require("@ai-sdk/provider");
var import_provider_utils19 = require("@ai-sdk/provider-utils");

// src/util/prepare-headers.ts
function prepareHeaders(headers, defaultHeaders) {
  const responseHeaders = new Headers(headers != null ? headers : {});
  for (const [key, value] of Object.entries(defaultHeaders)) {
    if (!responseHeaders.has(key)) {
      responseHeaders.set(key, value);
    }
  }
  return responseHeaders;
}

// src/text-stream/create-text-stream-response.ts
function createTextStreamResponse({
  status,
  statusText,
  headers,
  textStream
}) {
  return new Response(textStream.pipeThrough(new TextEncoderStream()), {
    status: status != null ? status : 200,
    statusText,
    headers: prepareHeaders(headers, {
      "content-type": "text/plain; charset=utf-8"
    })
  });
}

// src/util/write-to-server-response.ts
function writeToServerResponse({
  response,
  status,
  statusText,
  headers,
  stream
}) {
  const statusCode = status != null ? status : 200;
  if (statusText !== void 0) {
    response.writeHead(statusCode, statusText, headers);
  } else {
    response.writeHead(statusCode, headers);
  }
  const reader = stream.getReader();
  const read = async () => {
    try {
      while (true) {
        const { done, value } = await reader.read();
        if (done)
          break;
        const canContinue = response.write(value);
        if (!canContinue) {
          await new Promise((resolve3) => {
            response.once("drain", resolve3);
          });
        }
      }
    } catch (error) {
      throw error;
    } finally {
      response.end();
    }
  };
  read();
}

// src/text-stream/pipe-text-stream-to-response.ts
function pipeTextStreamToResponse({
  response,
  status,
  statusText,
  headers,
  textStream
}) {
  writeToServerResponse({
    response,
    status,
    statusText,
    headers: Object.fromEntries(
      prepareHeaders(headers, {
        "content-type": "text/plain; charset=utf-8"
      }).entries()
    ),
    stream: textStream.pipeThrough(new TextEncoderStream())
  });
}

// src/ui-message-stream/json-to-sse-transform-stream.ts
var JsonToSseTransformStream = class extends TransformStream {
  constructor() {
    super({
      transform(part, controller) {
        controller.enqueue(`data: ${JSON.stringify(part)}

`);
      },
      flush(controller) {
        controller.enqueue("data: [DONE]\n\n");
      }
    });
  }
};

// src/ui-message-stream/ui-message-stream-headers.ts
var UI_MESSAGE_STREAM_HEADERS = {
  "content-type": "text/event-stream",
  "cache-control": "no-cache",
  connection: "keep-alive",
  "x-vercel-ai-ui-message-stream": "v1",
  "x-accel-buffering": "no"
  // disable nginx buffering
};

// src/ui-message-stream/create-ui-message-stream-response.ts
function createUIMessageStreamResponse({
  status,
  statusText,
  headers,
  stream,
  consumeSseStream
}) {
  let sseStream = stream.pipeThrough(new JsonToSseTransformStream());
  if (consumeSseStream) {
    const [stream1, stream2] = sseStream.tee();
    sseStream = stream1;
    consumeSseStream({ stream: stream2 });
  }
  return new Response(sseStream.pipeThrough(new TextEncoderStream()), {
    status,
    statusText,
    headers: prepareHeaders(headers, UI_MESSAGE_STREAM_HEADERS)
  });
}

// src/ui-message-stream/get-response-ui-message-id.ts
function getResponseUIMessageId({
  originalMessages,
  responseMessageId
}) {
  if (originalMessages == null) {
    return void 0;
  }
  const lastMessage = originalMessages[originalMessages.length - 1];
  return (lastMessage == null ? void 0 : lastMessage.role) === "assistant" ? lastMessage.id : typeof responseMessageId === "function" ? responseMessageId() : responseMessageId;
}

// src/ui/process-ui-message-stream.ts
var import_provider_utils17 = require("@ai-sdk/provider-utils");

// src/ui-message-stream/ui-message-chunks.ts
var import_v47 = require("zod/v4");
var import_provider_utils16 = require("@ai-sdk/provider-utils");
var uiMessageChunkSchema = (0, import_provider_utils16.lazySchema)(
  () => (0, import_provider_utils16.zodSchema)(
    import_v47.z.union([
      import_v47.z.strictObject({
        type: import_v47.z.literal("text-start"),
        id: import_v47.z.string(),
        providerMetadata: providerMetadataSchema.optional()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("text-delta"),
        id: import_v47.z.string(),
        delta: import_v47.z.string(),
        providerMetadata: providerMetadataSchema.optional()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("text-end"),
        id: import_v47.z.string(),
        providerMetadata: providerMetadataSchema.optional()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("error"),
        errorText: import_v47.z.string()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("tool-input-start"),
        toolCallId: import_v47.z.string(),
        toolName: import_v47.z.string(),
        providerExecuted: import_v47.z.boolean().optional(),
        dynamic: import_v47.z.boolean().optional(),
        title: import_v47.z.string().optional()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("tool-input-delta"),
        toolCallId: import_v47.z.string(),
        inputTextDelta: import_v47.z.string()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("tool-input-available"),
        toolCallId: import_v47.z.string(),
        toolName: import_v47.z.string(),
        input: import_v47.z.unknown(),
        providerExecuted: import_v47.z.boolean().optional(),
        providerMetadata: providerMetadataSchema.optional(),
        dynamic: import_v47.z.boolean().optional(),
        title: import_v47.z.string().optional()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("tool-input-error"),
        toolCallId: import_v47.z.string(),
        toolName: import_v47.z.string(),
        input: import_v47.z.unknown(),
        providerExecuted: import_v47.z.boolean().optional(),
        providerMetadata: providerMetadataSchema.optional(),
        dynamic: import_v47.z.boolean().optional(),
        errorText: import_v47.z.string(),
        title: import_v47.z.string().optional()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("tool-approval-request"),
        approvalId: import_v47.z.string(),
        toolCallId: import_v47.z.string()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("tool-output-available"),
        toolCallId: import_v47.z.string(),
        output: import_v47.z.unknown(),
        providerExecuted: import_v47.z.boolean().optional(),
        dynamic: import_v47.z.boolean().optional(),
        preliminary: import_v47.z.boolean().optional()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("tool-output-error"),
        toolCallId: import_v47.z.string(),
        errorText: import_v47.z.string(),
        providerExecuted: import_v47.z.boolean().optional(),
        dynamic: import_v47.z.boolean().optional()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("tool-output-denied"),
        toolCallId: import_v47.z.string()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("reasoning-start"),
        id: import_v47.z.string(),
        providerMetadata: providerMetadataSchema.optional()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("reasoning-delta"),
        id: import_v47.z.string(),
        delta: import_v47.z.string(),
        providerMetadata: providerMetadataSchema.optional()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("reasoning-end"),
        id: import_v47.z.string(),
        providerMetadata: providerMetadataSchema.optional()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("source-url"),
        sourceId: import_v47.z.string(),
        url: import_v47.z.string(),
        title: import_v47.z.string().optional(),
        providerMetadata: providerMetadataSchema.optional()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("source-document"),
        sourceId: import_v47.z.string(),
        mediaType: import_v47.z.string(),
        title: import_v47.z.string(),
        filename: import_v47.z.string().optional(),
        providerMetadata: providerMetadataSchema.optional()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("file"),
        url: import_v47.z.string(),
        mediaType: import_v47.z.string(),
        providerMetadata: providerMetadataSchema.optional()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.custom(
          (value) => typeof value === "string" && value.startsWith("data-"),
          { message: 'Type must start with "data-"' }
        ),
        id: import_v47.z.string().optional(),
        data: import_v47.z.unknown(),
        transient: import_v47.z.boolean().optional()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("start-step")
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("finish-step")
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("start"),
        messageId: import_v47.z.string().optional(),
        messageMetadata: import_v47.z.unknown().optional()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("finish"),
        finishReason: import_v47.z.enum([
          "stop",
          "length",
          "content-filter",
          "tool-calls",
          "error",
          "other"
        ]).optional(),
        messageMetadata: import_v47.z.unknown().optional()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("abort"),
        reason: import_v47.z.string().optional()
      }),
      import_v47.z.strictObject({
        type: import_v47.z.literal("message-metadata"),
        messageMetadata: import_v47.z.unknown()
      })
    ])
  )
);
function isDataUIMessageChunk(chunk) {
  return chunk.type.startsWith("data-");
}

// src/ui/ui-messages.ts
function isDataUIPart(part) {
  return part.type.startsWith("data-");
}
function isTextUIPart(part) {
  return part.type === "text";
}
function isFileUIPart(part) {
  return part.type === "file";
}
function isReasoningUIPart(part) {
  return part.type === "reasoning";
}
function isStaticToolUIPart(part) {
  return part.type.startsWith("tool-");
}
function isDynamicToolUIPart(part) {
  return part.type === "dynamic-tool";
}
function isToolUIPart(part) {
  return isStaticToolUIPart(part) || isDynamicToolUIPart(part);
}
var isToolOrDynamicToolUIPart = isToolUIPart;
function getStaticToolName(part) {
  return part.type.split("-").slice(1).join("-");
}
function getToolName(part) {
  return isDynamicToolUIPart(part) ? part.toolName : getStaticToolName(part);
}
var getToolOrDynamicToolName = getToolName;

// src/ui/process-ui-message-stream.ts
function createStreamingUIMessageState({
  lastMessage,
  messageId
}) {
  return {
    message: (lastMessage == null ? void 0 : lastMessage.role) === "assistant" ? lastMessage : {
      id: messageId,
      metadata: void 0,
      role: "assistant",
      parts: []
    },
    activeTextParts: {},
    activeReasoningParts: {},
    partialToolCalls: {}
  };
}
function processUIMessageStream({
  stream,
  messageMetadataSchema,
  dataPartSchemas,
  runUpdateMessageJob,
  onError,
  onToolCall,
  onData
}) {
  return stream.pipeThrough(
    new TransformStream({
      async transform(chunk, controller) {
        await runUpdateMessageJob(async ({ state, write }) => {
          var _a16, _b, _c, _d;
          function getToolInvocation(toolCallId) {
            const toolInvocations = state.message.parts.filter(isToolUIPart);
            const toolInvocation = toolInvocations.find(
              (invocation) => invocation.toolCallId === toolCallId
            );
            if (toolInvocation == null) {
              throw new Error(
                `no tool invocation found for tool call ${toolCallId}`
              );
            }
            return toolInvocation;
          }
          function updateToolPart(options) {
            var _a17;
            const part = state.message.parts.find(
              (part2) => isStaticToolUIPart(part2) && part2.toolCallId === options.toolCallId
            );
            const anyOptions = options;
            const anyPart = part;
            if (part != null) {
              part.state = options.state;
              anyPart.input = anyOptions.input;
              anyPart.output = anyOptions.output;
              anyPart.errorText = anyOptions.errorText;
              anyPart.rawInput = anyOptions.rawInput;
              anyPart.preliminary = anyOptions.preliminary;
              if (options.title !== void 0) {
                anyPart.title = options.title;
              }
              anyPart.providerExecuted = (_a17 = anyOptions.providerExecuted) != null ? _a17 : part.providerExecuted;
              if (anyOptions.providerMetadata != null && part.state === "input-available") {
                part.callProviderMetadata = anyOptions.providerMetadata;
              }
            } else {
              state.message.parts.push({
                type: `tool-${options.toolName}`,
                toolCallId: options.toolCallId,
                state: options.state,
                title: options.title,
                input: anyOptions.input,
                output: anyOptions.output,
                rawInput: anyOptions.rawInput,
                errorText: anyOptions.errorText,
                providerExecuted: anyOptions.providerExecuted,
                preliminary: anyOptions.preliminary,
                ...anyOptions.providerMetadata != null ? { callProviderMetadata: anyOptions.providerMetadata } : {}
              });
            }
          }
          function updateDynamicToolPart(options) {
            var _a17, _b2;
            const part = state.message.parts.find(
              (part2) => part2.type === "dynamic-tool" && part2.toolCallId === options.toolCallId
            );
            const anyOptions = options;
            const anyPart = part;
            if (part != null) {
              part.state = options.state;
              anyPart.toolName = options.toolName;
              anyPart.input = anyOptions.input;
              anyPart.output = anyOptions.output;
              anyPart.errorText = anyOptions.errorText;
              anyPart.rawInput = (_a17 = anyOptions.rawInput) != null ? _a17 : anyPart.rawInput;
              anyPart.preliminary = anyOptions.preliminary;
              if (options.title !== void 0) {
                anyPart.title = options.title;
              }
              anyPart.providerExecuted = (_b2 = anyOptions.providerExecuted) != null ? _b2 : part.providerExecuted;
              if (anyOptions.providerMetadata != null && part.state === "input-available") {
                part.callProviderMetadata = anyOptions.providerMetadata;
              }
            } else {
              state.message.parts.push({
                type: "dynamic-tool",
                toolName: options.toolName,
                toolCallId: options.toolCallId,
                state: options.state,
                input: anyOptions.input,
                output: anyOptions.output,
                errorText: anyOptions.errorText,
                preliminary: anyOptions.preliminary,
                providerExecuted: anyOptions.providerExecuted,
                title: options.title,
                ...anyOptions.providerMetadata != null ? { callProviderMetadata: anyOptions.providerMetadata } : {}
              });
            }
          }
          async function updateMessageMetadata(metadata) {
            if (metadata != null) {
              const mergedMetadata = state.message.metadata != null ? mergeObjects(state.message.metadata, metadata) : metadata;
              if (messageMetadataSchema != null) {
                await (0, import_provider_utils17.validateTypes)({
                  value: mergedMetadata,
                  schema: messageMetadataSchema
                });
              }
              state.message.metadata = mergedMetadata;
            }
          }
          switch (chunk.type) {
            case "text-start": {
              const textPart = {
                type: "text",
                text: "",
                providerMetadata: chunk.providerMetadata,
                state: "streaming"
              };
              state.activeTextParts[chunk.id] = textPart;
              state.message.parts.push(textPart);
              write();
              break;
            }
            case "text-delta": {
              const textPart = state.activeTextParts[chunk.id];
              textPart.text += chunk.delta;
              textPart.providerMetadata = (_a16 = chunk.providerMetadata) != null ? _a16 : textPart.providerMetadata;
              write();
              break;
            }
            case "text-end": {
              const textPart = state.activeTextParts[chunk.id];
              textPart.state = "done";
              textPart.providerMetadata = (_b = chunk.providerMetadata) != null ? _b : textPart.providerMetadata;
              delete state.activeTextParts[chunk.id];
              write();
              break;
            }
            case "reasoning-start": {
              const reasoningPart = {
                type: "reasoning",
                text: "",
                providerMetadata: chunk.providerMetadata,
                state: "streaming"
              };
              state.activeReasoningParts[chunk.id] = reasoningPart;
              state.message.parts.push(reasoningPart);
              write();
              break;
            }
            case "reasoning-delta": {
              const reasoningPart = state.activeReasoningParts[chunk.id];
              reasoningPart.text += chunk.delta;
              reasoningPart.providerMetadata = (_c = chunk.providerMetadata) != null ? _c : reasoningPart.providerMetadata;
              write();
              break;
            }
            case "reasoning-end": {
              const reasoningPart = state.activeReasoningParts[chunk.id];
              reasoningPart.providerMetadata = (_d = chunk.providerMetadata) != null ? _d : reasoningPart.providerMetadata;
              reasoningPart.state = "done";
              delete state.activeReasoningParts[chunk.id];
              write();
              break;
            }
            case "file": {
              state.message.parts.push({
                type: "file",
                mediaType: chunk.mediaType,
                url: chunk.url
              });
              write();
              break;
            }
            case "source-url": {
              state.message.parts.push({
                type: "source-url",
                sourceId: chunk.sourceId,
                url: chunk.url,
                title: chunk.title,
                providerMetadata: chunk.providerMetadata
              });
              write();
              break;
            }
            case "source-document": {
              state.message.parts.push({
                type: "source-document",
                sourceId: chunk.sourceId,
                mediaType: chunk.mediaType,
                title: chunk.title,
                filename: chunk.filename,
                providerMetadata: chunk.providerMetadata
              });
              write();
              break;
            }
            case "tool-input-start": {
              const toolInvocations = state.message.parts.filter(isStaticToolUIPart);
              state.partialToolCalls[chunk.toolCallId] = {
                text: "",
                toolName: chunk.toolName,
                index: toolInvocations.length,
                dynamic: chunk.dynamic,
                title: chunk.title
              };
              if (chunk.dynamic) {
                updateDynamicToolPart({
                  toolCallId: chunk.toolCallId,
                  toolName: chunk.toolName,
                  state: "input-streaming",
                  input: void 0,
                  providerExecuted: chunk.providerExecuted,
                  title: chunk.title
                });
              } else {
                updateToolPart({
                  toolCallId: chunk.toolCallId,
                  toolName: chunk.toolName,
                  state: "input-streaming",
                  input: void 0,
                  providerExecuted: chunk.providerExecuted,
                  title: chunk.title
                });
              }
              write();
              break;
            }
            case "tool-input-delta": {
              const partialToolCall = state.partialToolCalls[chunk.toolCallId];
              partialToolCall.text += chunk.inputTextDelta;
              const { value: partialArgs } = await parsePartialJson(
                partialToolCall.text
              );
              if (partialToolCall.dynamic) {
                updateDynamicToolPart({
                  toolCallId: chunk.toolCallId,
                  toolName: partialToolCall.toolName,
                  state: "input-streaming",
                  input: partialArgs,
                  title: partialToolCall.title
                });
              } else {
                updateToolPart({
                  toolCallId: chunk.toolCallId,
                  toolName: partialToolCall.toolName,
                  state: "input-streaming",
                  input: partialArgs,
                  title: partialToolCall.title
                });
              }
              write();
              break;
            }
            case "tool-input-available": {
              if (chunk.dynamic) {
                updateDynamicToolPart({
                  toolCallId: chunk.toolCallId,
                  toolName: chunk.toolName,
                  state: "input-available",
                  input: chunk.input,
                  providerExecuted: chunk.providerExecuted,
                  providerMetadata: chunk.providerMetadata,
                  title: chunk.title
                });
              } else {
                updateToolPart({
                  toolCallId: chunk.toolCallId,
                  toolName: chunk.toolName,
                  state: "input-available",
                  input: chunk.input,
                  providerExecuted: chunk.providerExecuted,
                  providerMetadata: chunk.providerMetadata,
                  title: chunk.title
                });
              }
              write();
              if (onToolCall && !chunk.providerExecuted) {
                await onToolCall({
                  toolCall: chunk
                });
              }
              break;
            }
            case "tool-input-error": {
              if (chunk.dynamic) {
                updateDynamicToolPart({
                  toolCallId: chunk.toolCallId,
                  toolName: chunk.toolName,
                  state: "output-error",
                  input: chunk.input,
                  errorText: chunk.errorText,
                  providerExecuted: chunk.providerExecuted,
                  providerMetadata: chunk.providerMetadata
                });
              } else {
                updateToolPart({
                  toolCallId: chunk.toolCallId,
                  toolName: chunk.toolName,
                  state: "output-error",
                  input: void 0,
                  rawInput: chunk.input,
                  errorText: chunk.errorText,
                  providerExecuted: chunk.providerExecuted,
                  providerMetadata: chunk.providerMetadata
                });
              }
              write();
              break;
            }
            case "tool-approval-request": {
              const toolInvocation = getToolInvocation(chunk.toolCallId);
              toolInvocation.state = "approval-requested";
              toolInvocation.approval = { id: chunk.approvalId };
              write();
              break;
            }
            case "tool-output-denied": {
              const toolInvocation = getToolInvocation(chunk.toolCallId);
              toolInvocation.state = "output-denied";
              write();
              break;
            }
            case "tool-output-available": {
              const toolInvocation = getToolInvocation(chunk.toolCallId);
              if (toolInvocation.type === "dynamic-tool") {
                updateDynamicToolPart({
                  toolCallId: chunk.toolCallId,
                  toolName: toolInvocation.toolName,
                  state: "output-available",
                  input: toolInvocation.input,
                  output: chunk.output,
                  preliminary: chunk.preliminary,
                  providerExecuted: chunk.providerExecuted,
                  title: toolInvocation.title
                });
              } else {
                updateToolPart({
                  toolCallId: chunk.toolCallId,
                  toolName: getStaticToolName(toolInvocation),
                  state: "output-available",
                  input: toolInvocation.input,
                  output: chunk.output,
                  providerExecuted: chunk.providerExecuted,
                  preliminary: chunk.preliminary,
                  title: toolInvocation.title
                });
              }
              write();
              break;
            }
            case "tool-output-error": {
              const toolInvocation = getToolInvocation(chunk.toolCallId);
              if (toolInvocation.type === "dynamic-tool") {
                updateDynamicToolPart({
                  toolCallId: chunk.toolCallId,
                  toolName: toolInvocation.toolName,
                  state: "output-error",
                  input: toolInvocation.input,
                  errorText: chunk.errorText,
                  providerExecuted: chunk.providerExecuted,
                  title: toolInvocation.title
                });
              } else {
                updateToolPart({
                  toolCallId: chunk.toolCallId,
                  toolName: getStaticToolName(toolInvocation),
                  state: "output-error",
                  input: toolInvocation.input,
                  rawInput: toolInvocation.rawInput,
                  errorText: chunk.errorText,
                  providerExecuted: chunk.providerExecuted,
                  title: toolInvocation.title
                });
              }
              write();
              break;
            }
            case "start-step": {
              state.message.parts.push({ type: "step-start" });
              break;
            }
            case "finish-step": {
              state.activeTextParts = {};
              state.activeReasoningParts = {};
              break;
            }
            case "start": {
              if (chunk.messageId != null) {
                state.message.id = chunk.messageId;
              }
              await updateMessageMetadata(chunk.messageMetadata);
              if (chunk.messageId != null || chunk.messageMetadata != null) {
                write();
              }
              break;
            }
            case "finish": {
              if (chunk.finishReason != null) {
                state.finishReason = chunk.finishReason;
              }
              await updateMessageMetadata(chunk.messageMetadata);
              if (chunk.messageMetadata != null) {
                write();
              }
              break;
            }
            case "message-metadata": {
              await updateMessageMetadata(chunk.messageMetadata);
              if (chunk.messageMetadata != null) {
                write();
              }
              break;
            }
            case "error": {
              onError == null ? void 0 : onError(new Error(chunk.errorText));
              break;
            }
            default: {
              if (isDataUIMessageChunk(chunk)) {
                if ((dataPartSchemas == null ? void 0 : dataPartSchemas[chunk.type]) != null) {
                  await (0, import_provider_utils17.validateTypes)({
                    value: chunk.data,
                    schema: dataPartSchemas[chunk.type]
                  });
                }
                const dataChunk = chunk;
                if (dataChunk.transient) {
                  onData == null ? void 0 : onData(dataChunk);
                  break;
                }
                const existingUIPart = dataChunk.id != null ? state.message.parts.find(
                  (chunkArg) => dataChunk.type === chunkArg.type && dataChunk.id === chunkArg.id
                ) : void 0;
                if (existingUIPart != null) {
                  existingUIPart.data = dataChunk.data;
                } else {
                  state.message.parts.push(dataChunk);
                }
                onData == null ? void 0 : onData(dataChunk);
                write();
              }
            }
          }
          controller.enqueue(chunk);
        });
      }
    })
  );
}

// src/ui-message-stream/handle-ui-message-stream-finish.ts
function handleUIMessageStreamFinish({
  messageId,
  originalMessages = [],
  onFinish,
  onError,
  stream
}) {
  let lastMessage = originalMessages == null ? void 0 : originalMessages[originalMessages.length - 1];
  if ((lastMessage == null ? void 0 : lastMessage.role) !== "assistant") {
    lastMessage = void 0;
  } else {
    messageId = lastMessage.id;
  }
  let isAborted = false;
  const idInjectedStream = stream.pipeThrough(
    new TransformStream({
      transform(chunk, controller) {
        if (chunk.type === "start") {
          const startChunk = chunk;
          if (startChunk.messageId == null && messageId != null) {
            startChunk.messageId = messageId;
          }
        }
        if (chunk.type === "abort") {
          isAborted = true;
        }
        controller.enqueue(chunk);
      }
    })
  );
  if (onFinish == null) {
    return idInjectedStream;
  }
  const state = createStreamingUIMessageState({
    lastMessage: lastMessage ? structuredClone(lastMessage) : void 0,
    messageId: messageId != null ? messageId : ""
    // will be overridden by the stream
  });
  const runUpdateMessageJob = async (job) => {
    await job({ state, write: () => {
    } });
  };
  let finishCalled = false;
  const callOnFinish = async () => {
    if (finishCalled || !onFinish) {
      return;
    }
    finishCalled = true;
    const isContinuation = state.message.id === (lastMessage == null ? void 0 : lastMessage.id);
    await onFinish({
      isAborted,
      isContinuation,
      responseMessage: state.message,
      messages: [
        ...isContinuation ? originalMessages.slice(0, -1) : originalMessages,
        state.message
      ],
      finishReason: state.finishReason
    });
  };
  return processUIMessageStream({
    stream: idInjectedStream,
    runUpdateMessageJob,
    onError
  }).pipeThrough(
    new TransformStream({
      transform(chunk, controller) {
        controller.enqueue(chunk);
      },
      // @ts-expect-error cancel is still new and missing from types https://developer.mozilla.org/en-US/docs/Web/API/TransformStream#browser_compatibility
      async cancel() {
        await callOnFinish();
      },
      async flush() {
        await callOnFinish();
      }
    })
  );
}

// src/ui-message-stream/pipe-ui-message-stream-to-response.ts
function pipeUIMessageStreamToResponse({
  response,
  status,
  statusText,
  headers,
  stream,
  consumeSseStream
}) {
  let sseStream = stream.pipeThrough(new JsonToSseTransformStream());
  if (consumeSseStream) {
    const [stream1, stream2] = sseStream.tee();
    sseStream = stream1;
    consumeSseStream({ stream: stream2 });
  }
  writeToServerResponse({
    response,
    status,
    statusText,
    headers: Object.fromEntries(
      prepareHeaders(headers, UI_MESSAGE_STREAM_HEADERS).entries()
    ),
    stream: sseStream.pipeThrough(new TextEncoderStream())
  });
}

// src/util/async-iterable-stream.ts
function createAsyncIterableStream(source) {
  const stream = source.pipeThrough(new TransformStream());
  stream[Symbol.asyncIterator] = function() {
    const reader = this.getReader();
    let finished = false;
    async function cleanup(cancelStream) {
      var _a16;
      finished = true;
      try {
        if (cancelStream) {
          await ((_a16 = reader.cancel) == null ? void 0 : _a16.call(reader));
        }
      } finally {
        try {
          reader.releaseLock();
        } catch (e) {
        }
      }
    }
    return {
      /**
       * Reads the next chunk from the stream.
       * @returns A promise resolving to the next IteratorResult.
       */
      async next() {
        if (finished) {
          return { done: true, value: void 0 };
        }
        const { done, value } = await reader.read();
        if (done) {
          await cleanup(true);
          return { done: true, value: void 0 };
        }
        return { done: false, value };
      },
      /**
       * Called on early exit (e.g., break from for-await).
       * Ensures the stream is cancelled and resources are released.
       * @returns A promise resolving to a completed IteratorResult.
       */
      async return() {
        await cleanup(true);
        return { done: true, value: void 0 };
      },
      /**
       * Called on early exit with error.
       * Ensures the stream is cancelled and resources are released, then rethrows the error.
       * @param err The error to throw.
       * @returns A promise that rejects with the provided error.
       */
      async throw(err) {
        await cleanup(true);
        throw err;
      }
    };
  };
  return stream;
}

// src/util/consume-stream.ts
async function consumeStream({
  stream,
  onError
}) {
  const reader = stream.getReader();
  try {
    while (true) {
      const { done } = await reader.read();
      if (done)
        break;
    }
  } catch (error) {
    onError == null ? void 0 : onError(error);
  } finally {
    reader.releaseLock();
  }
}

// src/util/create-resolvable-promise.ts
function createResolvablePromise() {
  let resolve3;
  let reject;
  const promise = new Promise((res, rej) => {
    resolve3 = res;
    reject = rej;
  });
  return {
    promise,
    resolve: resolve3,
    reject
  };
}

// src/util/create-stitchable-stream.ts
function createStitchableStream() {
  let innerStreamReaders = [];
  let controller = null;
  let isClosed = false;
  let waitForNewStream = createResolvablePromise();
  const terminate = () => {
    isClosed = true;
    waitForNewStream.resolve();
    innerStreamReaders.forEach((reader) => reader.cancel());
    innerStreamReaders = [];
    controller == null ? void 0 : controller.close();
  };
  const processPull = async () => {
    if (isClosed && innerStreamReaders.length === 0) {
      controller == null ? void 0 : controller.close();
      return;
    }
    if (innerStreamReaders.length === 0) {
      waitForNewStream = createResolvablePromise();
      await waitForNewStream.promise;
      return processPull();
    }
    try {
      const { value, done } = await innerStreamReaders[0].read();
      if (done) {
        innerStreamReaders.shift();
        if (innerStreamReaders.length === 0 && isClosed) {
          controller == null ? void 0 : controller.close();
        } else {
          await processPull();
        }
      } else {
        controller == null ? void 0 : controller.enqueue(value);
      }
    } catch (error) {
      controller == null ? void 0 : controller.error(error);
      innerStreamReaders.shift();
      terminate();
    }
  };
  return {
    stream: new ReadableStream({
      start(controllerParam) {
        controller = controllerParam;
      },
      pull: processPull,
      async cancel() {
        for (const reader of innerStreamReaders) {
          await reader.cancel();
        }
        innerStreamReaders = [];
        isClosed = true;
      }
    }),
    addStream: (innerStream) => {
      if (isClosed) {
        throw new Error("Cannot add inner stream: outer stream is closed");
      }
      innerStreamReaders.push(innerStream.getReader());
      waitForNewStream.resolve();
    },
    /**
     * Gracefully close the outer stream. This will let the inner streams
     * finish processing and then close the outer stream.
     */
    close: () => {
      isClosed = true;
      waitForNewStream.resolve();
      if (innerStreamReaders.length === 0) {
        controller == null ? void 0 : controller.close();
      }
    },
    /**
     * Immediately close the outer stream. This will cancel all inner streams
     * and close the outer stream.
     */
    terminate
  };
}

// src/util/now.ts
function now() {
  var _a16, _b;
  return (_b = (_a16 = globalThis == null ? void 0 : globalThis.performance) == null ? void 0 : _a16.now()) != null ? _b : Date.now();
}

// src/generate-text/run-tools-transformation.ts
var import_provider_utils18 = require("@ai-sdk/provider-utils");
function runToolsTransformation({
  tools,
  generatorStream,
  tracer,
  telemetry,
  system,
  messages,
  abortSignal,
  repairToolCall,
  experimental_context,
  generateId: generateId2
}) {
  let toolResultsStreamController = null;
  const toolResultsStream = new ReadableStream({
    start(controller) {
      toolResultsStreamController = controller;
    }
  });
  const outstandingToolResults = /* @__PURE__ */ new Set();
  const toolInputs = /* @__PURE__ */ new Map();
  const toolCallsByToolCallId = /* @__PURE__ */ new Map();
  let canClose = false;
  let finishChunk = void 0;
  function attemptClose() {
    if (canClose && outstandingToolResults.size === 0) {
      if (finishChunk != null) {
        toolResultsStreamController.enqueue(finishChunk);
      }
      toolResultsStreamController.close();
    }
  }
  const forwardStream = new TransformStream({
    async transform(chunk, controller) {
      const chunkType = chunk.type;
      switch (chunkType) {
        case "stream-start":
        case "text-start":
        case "text-delta":
        case "text-end":
        case "reasoning-start":
        case "reasoning-delta":
        case "reasoning-end":
        case "tool-input-start":
        case "tool-input-delta":
        case "tool-input-end":
        case "source":
        case "response-metadata":
        case "error":
        case "raw": {
          controller.enqueue(chunk);
          break;
        }
        case "file": {
          controller.enqueue({
            type: "file",
            file: new DefaultGeneratedFileWithType({
              data: chunk.data,
              mediaType: chunk.mediaType
            })
          });
          break;
        }
        case "finish": {
          finishChunk = {
            type: "finish",
            finishReason: chunk.finishReason.unified,
            rawFinishReason: chunk.finishReason.raw,
            usage: asLanguageModelUsage(chunk.usage),
            providerMetadata: chunk.providerMetadata
          };
          break;
        }
        case "tool-approval-request": {
          const toolCall = toolCallsByToolCallId.get(chunk.toolCallId);
          if (toolCall == null) {
            toolResultsStreamController.enqueue({
              type: "error",
              error: new ToolCallNotFoundForApprovalError({
                toolCallId: chunk.toolCallId,
                approvalId: chunk.approvalId
              })
            });
            break;
          }
          controller.enqueue({
            type: "tool-approval-request",
            approvalId: chunk.approvalId,
            toolCall
          });
          break;
        }
        case "tool-call": {
          try {
            const toolCall = await parseToolCall({
              toolCall: chunk,
              tools,
              repairToolCall,
              system,
              messages
            });
            toolCallsByToolCallId.set(toolCall.toolCallId, toolCall);
            controller.enqueue(toolCall);
            if (toolCall.invalid) {
              toolResultsStreamController.enqueue({
                type: "tool-error",
                toolCallId: toolCall.toolCallId,
                toolName: toolCall.toolName,
                input: toolCall.input,
                error: (0, import_provider_utils18.getErrorMessage)(toolCall.error),
                dynamic: true,
                title: toolCall.title
              });
              break;
            }
            const tool2 = tools == null ? void 0 : tools[toolCall.toolName];
            if (tool2 == null) {
              break;
            }
            if (tool2.onInputAvailable != null) {
              await tool2.onInputAvailable({
                input: toolCall.input,
                toolCallId: toolCall.toolCallId,
                messages,
                abortSignal,
                experimental_context
              });
            }
            if (await isApprovalNeeded({
              tool: tool2,
              toolCall,
              messages,
              experimental_context
            })) {
              toolResultsStreamController.enqueue({
                type: "tool-approval-request",
                approvalId: generateId2(),
                toolCall
              });
              break;
            }
            toolInputs.set(toolCall.toolCallId, toolCall.input);
            if (tool2.execute != null && toolCall.providerExecuted !== true) {
              const toolExecutionId = generateId2();
              outstandingToolResults.add(toolExecutionId);
              executeToolCall({
                toolCall,
                tools,
                tracer,
                telemetry,
                messages,
                abortSignal,
                experimental_context,
                onPreliminaryToolResult: (result) => {
                  toolResultsStreamController.enqueue(result);
                }
              }).then((result) => {
                toolResultsStreamController.enqueue(result);
              }).catch((error) => {
                toolResultsStreamController.enqueue({
                  type: "error",
                  error
                });
              }).finally(() => {
                outstandingToolResults.delete(toolExecutionId);
                attemptClose();
              });
            }
          } catch (error) {
            toolResultsStreamController.enqueue({ type: "error", error });
          }
          break;
        }
        case "tool-result": {
          const toolName = chunk.toolName;
          if (chunk.isError) {
            toolResultsStreamController.enqueue({
              type: "tool-error",
              toolCallId: chunk.toolCallId,
              toolName,
              input: toolInputs.get(chunk.toolCallId),
              providerExecuted: true,
              error: chunk.result,
              dynamic: chunk.dynamic
            });
          } else {
            controller.enqueue({
              type: "tool-result",
              toolCallId: chunk.toolCallId,
              toolName,
              input: toolInputs.get(chunk.toolCallId),
              output: chunk.result,
              providerExecuted: true,
              dynamic: chunk.dynamic
            });
          }
          break;
        }
        default: {
          const _exhaustiveCheck = chunkType;
          throw new Error(`Unhandled chunk type: ${_exhaustiveCheck}`);
        }
      }
    },
    flush() {
      canClose = true;
      attemptClose();
    }
  });
  return new ReadableStream({
    async start(controller) {
      return Promise.all([
        generatorStream.pipeThrough(forwardStream).pipeTo(
          new WritableStream({
            write(chunk) {
              controller.enqueue(chunk);
            },
            close() {
            }
          })
        ),
        toolResultsStream.pipeTo(
          new WritableStream({
            write(chunk) {
              controller.enqueue(chunk);
            },
            close() {
              controller.close();
            }
          })
        )
      ]);
    }
  });
}

// src/generate-text/stream-text.ts
var originalGenerateId2 = (0, import_provider_utils19.createIdGenerator)({
  prefix: "aitxt",
  size: 24
});
function streamText({
  model,
  tools,
  toolChoice,
  system,
  prompt,
  messages,
  maxRetries,
  abortSignal,
  timeout,
  headers,
  stopWhen = stepCountIs(1),
  experimental_output,
  output = experimental_output,
  experimental_telemetry: telemetry,
  prepareStep,
  providerOptions,
  experimental_activeTools,
  activeTools = experimental_activeTools,
  experimental_repairToolCall: repairToolCall,
  experimental_transform: transform,
  experimental_download: download2,
  includeRawChunks = false,
  onChunk,
  onError = ({ error }) => {
    console.error(error);
  },
  onFinish,
  onAbort,
  onStepFinish,
  experimental_context,
  _internal: { now: now2 = now, generateId: generateId2 = originalGenerateId2 } = {},
  ...settings
}) {
  const totalTimeoutMs = getTotalTimeoutMs(timeout);
  return new DefaultStreamTextResult({
    model: resolveLanguageModel(model),
    telemetry,
    headers,
    settings,
    maxRetries,
    abortSignal: mergeAbortSignals(
      abortSignal,
      totalTimeoutMs != null ? AbortSignal.timeout(totalTimeoutMs) : void 0
    ),
    system,
    prompt,
    messages,
    tools,
    toolChoice,
    transforms: asArray(transform),
    activeTools,
    repairToolCall,
    stopConditions: asArray(stopWhen),
    output,
    providerOptions,
    prepareStep,
    includeRawChunks,
    onChunk,
    onError,
    onFinish,
    onAbort,
    onStepFinish,
    now: now2,
    generateId: generateId2,
    experimental_context,
    download: download2
  });
}
function createOutputTransformStream(output) {
  let firstTextChunkId = void 0;
  let text2 = "";
  let textChunk = "";
  let textProviderMetadata = void 0;
  let lastPublishedJson = "";
  function publishTextChunk({
    controller,
    partialOutput = void 0
  }) {
    controller.enqueue({
      part: {
        type: "text-delta",
        id: firstTextChunkId,
        text: textChunk,
        providerMetadata: textProviderMetadata
      },
      partialOutput
    });
    textChunk = "";
  }
  return new TransformStream({
    async transform(chunk, controller) {
      var _a16;
      if (chunk.type === "finish-step" && textChunk.length > 0) {
        publishTextChunk({ controller });
      }
      if (chunk.type !== "text-delta" && chunk.type !== "text-start" && chunk.type !== "text-end") {
        controller.enqueue({ part: chunk, partialOutput: void 0 });
        return;
      }
      if (firstTextChunkId == null) {
        firstTextChunkId = chunk.id;
      } else if (chunk.id !== firstTextChunkId) {
        controller.enqueue({ part: chunk, partialOutput: void 0 });
        return;
      }
      if (chunk.type === "text-start") {
        controller.enqueue({ part: chunk, partialOutput: void 0 });
        return;
      }
      if (chunk.type === "text-end") {
        if (textChunk.length > 0) {
          publishTextChunk({ controller });
        }
        controller.enqueue({ part: chunk, partialOutput: void 0 });
        return;
      }
      text2 += chunk.text;
      textChunk += chunk.text;
      textProviderMetadata = (_a16 = chunk.providerMetadata) != null ? _a16 : textProviderMetadata;
      const result = await output.parsePartialOutput({ text: text2 });
      if (result !== void 0) {
        const currentJson = JSON.stringify(result.partial);
        if (currentJson !== lastPublishedJson) {
          publishTextChunk({ controller, partialOutput: result.partial });
          lastPublishedJson = currentJson;
        }
      }
    }
  });
}
var DefaultStreamTextResult = class {
  constructor({
    model,
    telemetry,
    headers,
    settings,
    maxRetries: maxRetriesArg,
    abortSignal,
    system,
    prompt,
    messages,
    tools,
    toolChoice,
    transforms,
    activeTools,
    repairToolCall,
    stopConditions,
    output,
    providerOptions,
    prepareStep,
    includeRawChunks,
    now: now2,
    generateId: generateId2,
    onChunk,
    onError,
    onFinish,
    onAbort,
    onStepFinish,
    experimental_context,
    download: download2
  }) {
    this._totalUsage = new import_provider_utils19.DelayedPromise();
    this._finishReason = new import_provider_utils19.DelayedPromise();
    this._rawFinishReason = new import_provider_utils19.DelayedPromise();
    this._steps = new import_provider_utils19.DelayedPromise();
    this.outputSpecification = output;
    this.includeRawChunks = includeRawChunks;
    this.tools = tools;
    let stepFinish;
    let recordedContent = [];
    const recordedResponseMessages = [];
    let recordedFinishReason = void 0;
    let recordedRawFinishReason = void 0;
    let recordedTotalUsage = void 0;
    let recordedRequest = {};
    let recordedWarnings = [];
    const recordedSteps = [];
    const pendingDeferredToolCalls = /* @__PURE__ */ new Map();
    let rootSpan;
    let activeTextContent = {};
    let activeReasoningContent = {};
    const eventProcessor = new TransformStream({
      async transform(chunk, controller) {
        var _a16, _b, _c, _d;
        controller.enqueue(chunk);
        const { part } = chunk;
        if (part.type === "text-delta" || part.type === "reasoning-delta" || part.type === "source" || part.type === "tool-call" || part.type === "tool-result" || part.type === "tool-input-start" || part.type === "tool-input-delta" || part.type === "raw") {
          await (onChunk == null ? void 0 : onChunk({ chunk: part }));
        }
        if (part.type === "error") {
          await onError({ error: wrapGatewayError(part.error) });
        }
        if (part.type === "text-start") {
          activeTextContent[part.id] = {
            type: "text",
            text: "",
            providerMetadata: part.providerMetadata
          };
          recordedContent.push(activeTextContent[part.id]);
        }
        if (part.type === "text-delta") {
          const activeText = activeTextContent[part.id];
          if (activeText == null) {
            controller.enqueue({
              part: {
                type: "error",
                error: `text part ${part.id} not found`
              },
              partialOutput: void 0
            });
            return;
          }
          activeText.text += part.text;
          activeText.providerMetadata = (_a16 = part.providerMetadata) != null ? _a16 : activeText.providerMetadata;
        }
        if (part.type === "text-end") {
          const activeText = activeTextContent[part.id];
          if (activeText == null) {
            controller.enqueue({
              part: {
                type: "error",
                error: `text part ${part.id} not found`
              },
              partialOutput: void 0
            });
            return;
          }
          activeText.providerMetadata = (_b = part.providerMetadata) != null ? _b : activeText.providerMetadata;
          delete activeTextContent[part.id];
        }
        if (part.type === "reasoning-start") {
          activeReasoningContent[part.id] = {
            type: "reasoning",
            text: "",
            providerMetadata: part.providerMetadata
          };
          recordedContent.push(activeReasoningContent[part.id]);
        }
        if (part.type === "reasoning-delta") {
          const activeReasoning = activeReasoningContent[part.id];
          if (activeReasoning == null) {
            controller.enqueue({
              part: {
                type: "error",
                error: `reasoning part ${part.id} not found`
              },
              partialOutput: void 0
            });
            return;
          }
          activeReasoning.text += part.text;
          activeReasoning.providerMetadata = (_c = part.providerMetadata) != null ? _c : activeReasoning.providerMetadata;
        }
        if (part.type === "reasoning-end") {
          const activeReasoning = activeReasoningContent[part.id];
          if (activeReasoning == null) {
            controller.enqueue({
              part: {
                type: "error",
                error: `reasoning part ${part.id} not found`
              },
              partialOutput: void 0
            });
            return;
          }
          activeReasoning.providerMetadata = (_d = part.providerMetadata) != null ? _d : activeReasoning.providerMetadata;
          delete activeReasoningContent[part.id];
        }
        if (part.type === "file") {
          recordedContent.push({ type: "file", file: part.file });
        }
        if (part.type === "source") {
          recordedContent.push(part);
        }
        if (part.type === "tool-call") {
          recordedContent.push(part);
        }
        if (part.type === "tool-result" && !part.preliminary) {
          recordedContent.push(part);
        }
        if (part.type === "tool-approval-request") {
          recordedContent.push(part);
        }
        if (part.type === "tool-error") {
          recordedContent.push(part);
        }
        if (part.type === "start-step") {
          recordedContent = [];
          activeReasoningContent = {};
          activeTextContent = {};
          recordedRequest = part.request;
          recordedWarnings = part.warnings;
        }
        if (part.type === "finish-step") {
          const stepMessages = await toResponseMessages({
            content: recordedContent,
            tools
          });
          const currentStepResult = new DefaultStepResult({
            content: recordedContent,
            finishReason: part.finishReason,
            rawFinishReason: part.rawFinishReason,
            usage: part.usage,
            warnings: recordedWarnings,
            request: recordedRequest,
            response: {
              ...part.response,
              messages: [...recordedResponseMessages, ...stepMessages]
            },
            providerMetadata: part.providerMetadata
          });
          await (onStepFinish == null ? void 0 : onStepFinish(currentStepResult));
          logWarnings({
            warnings: recordedWarnings,
            provider: model.provider,
            model: model.modelId
          });
          recordedSteps.push(currentStepResult);
          recordedResponseMessages.push(...stepMessages);
          stepFinish.resolve();
        }
        if (part.type === "finish") {
          recordedTotalUsage = part.totalUsage;
          recordedFinishReason = part.finishReason;
          recordedRawFinishReason = part.rawFinishReason;
        }
      },
      async flush(controller) {
        try {
          if (recordedSteps.length === 0) {
            const error = (abortSignal == null ? void 0 : abortSignal.aborted) ? abortSignal.reason : new NoOutputGeneratedError({
              message: "No output generated. Check the stream for errors."
            });
            self._finishReason.reject(error);
            self._rawFinishReason.reject(error);
            self._totalUsage.reject(error);
            self._steps.reject(error);
            return;
          }
          const finishReason = recordedFinishReason != null ? recordedFinishReason : "other";
          const totalUsage = recordedTotalUsage != null ? recordedTotalUsage : createNullLanguageModelUsage();
          self._finishReason.resolve(finishReason);
          self._rawFinishReason.resolve(recordedRawFinishReason);
          self._totalUsage.resolve(totalUsage);
          self._steps.resolve(recordedSteps);
          const finalStep = recordedSteps[recordedSteps.length - 1];
          await (onFinish == null ? void 0 : onFinish({
            finishReason: finalStep.finishReason,
            rawFinishReason: finalStep.rawFinishReason,
            totalUsage,
            usage: finalStep.usage,
            content: finalStep.content,
            text: finalStep.text,
            reasoningText: finalStep.reasoningText,
            reasoning: finalStep.reasoning,
            files: finalStep.files,
            sources: finalStep.sources,
            toolCalls: finalStep.toolCalls,
            staticToolCalls: finalStep.staticToolCalls,
            dynamicToolCalls: finalStep.dynamicToolCalls,
            toolResults: finalStep.toolResults,
            staticToolResults: finalStep.staticToolResults,
            dynamicToolResults: finalStep.dynamicToolResults,
            request: finalStep.request,
            response: finalStep.response,
            warnings: finalStep.warnings,
            providerMetadata: finalStep.providerMetadata,
            steps: recordedSteps,
            experimental_context
          }));
          rootSpan.setAttributes(
            await selectTelemetryAttributes({
              telemetry,
              attributes: {
                "ai.response.finishReason": finishReason,
                "ai.response.text": { output: () => finalStep.text },
                "ai.response.toolCalls": {
                  output: () => {
                    var _a16;
                    return ((_a16 = finalStep.toolCalls) == null ? void 0 : _a16.length) ? JSON.stringify(finalStep.toolCalls) : void 0;
                  }
                },
                "ai.response.providerMetadata": JSON.stringify(
                  finalStep.providerMetadata
                ),
                "ai.usage.inputTokens": totalUsage.inputTokens,
                "ai.usage.outputTokens": totalUsage.outputTokens,
                "ai.usage.totalTokens": totalUsage.totalTokens,
                "ai.usage.reasoningTokens": totalUsage.reasoningTokens,
                "ai.usage.cachedInputTokens": totalUsage.cachedInputTokens
              }
            })
          );
        } catch (error) {
          controller.error(error);
        } finally {
          rootSpan.end();
        }
      }
    });
    const stitchableStream = createStitchableStream();
    this.addStream = stitchableStream.addStream;
    this.closeStream = stitchableStream.close;
    const reader = stitchableStream.stream.getReader();
    let stream = new ReadableStream({
      async start(controller) {
        controller.enqueue({ type: "start" });
      },
      async pull(controller) {
        function abort() {
          onAbort == null ? void 0 : onAbort({ steps: recordedSteps });
          controller.enqueue({
            type: "abort",
            // The `reason` is usually of type DOMException, but it can also be of any type,
            // so we use getErrorMessage for serialization because it is already designed to accept values of the unknown type.
            // See: https://developer.mozilla.org/en-US/docs/Web/API/AbortSignal/reason
            ...(abortSignal == null ? void 0 : abortSignal.reason) !== void 0 ? { reason: (0, import_provider24.getErrorMessage)(abortSignal.reason) } : {}
          });
          controller.close();
        }
        try {
          const { done, value } = await reader.read();
          if (done) {
            controller.close();
            return;
          }
          if (abortSignal == null ? void 0 : abortSignal.aborted) {
            abort();
            return;
          }
          controller.enqueue(value);
        } catch (error) {
          if ((0, import_provider_utils19.isAbortError)(error) && (abortSignal == null ? void 0 : abortSignal.aborted)) {
            abort();
          } else {
            controller.error(error);
          }
        }
      },
      cancel(reason) {
        return stitchableStream.stream.cancel(reason);
      }
    });
    for (const transform of transforms) {
      stream = stream.pipeThrough(
        transform({
          tools,
          stopStream() {
            stitchableStream.terminate();
          }
        })
      );
    }
    this.baseStream = stream.pipeThrough(createOutputTransformStream(output != null ? output : text())).pipeThrough(eventProcessor);
    const { maxRetries, retry } = prepareRetries({
      maxRetries: maxRetriesArg,
      abortSignal
    });
    const tracer = getTracer(telemetry);
    const callSettings = prepareCallSettings(settings);
    const baseTelemetryAttributes = getBaseTelemetryAttributes({
      model,
      telemetry,
      headers,
      settings: { ...callSettings, maxRetries }
    });
    const self = this;
    recordSpan({
      name: "ai.streamText",
      attributes: selectTelemetryAttributes({
        telemetry,
        attributes: {
          ...assembleOperationName({ operationId: "ai.streamText", telemetry }),
          ...baseTelemetryAttributes,
          // specific settings that only make sense on the outer level:
          "ai.prompt": {
            input: () => JSON.stringify({ system, prompt, messages })
          }
        }
      }),
      tracer,
      endWhenDone: false,
      fn: async (rootSpanArg) => {
        rootSpan = rootSpanArg;
        const initialPrompt = await standardizePrompt({
          system,
          prompt,
          messages
        });
        const initialMessages = initialPrompt.messages;
        const initialResponseMessages = [];
        const { approvedToolApprovals, deniedToolApprovals } = collectToolApprovals({ messages: initialMessages });
        if (deniedToolApprovals.length > 0 || approvedToolApprovals.length > 0) {
          const providerExecutedToolApprovals = [
            ...approvedToolApprovals,
            ...deniedToolApprovals
          ].filter((toolApproval) => toolApproval.toolCall.providerExecuted);
          const localApprovedToolApprovals = approvedToolApprovals.filter(
            (toolApproval) => !toolApproval.toolCall.providerExecuted
          );
          const localDeniedToolApprovals = deniedToolApprovals.filter(
            (toolApproval) => !toolApproval.toolCall.providerExecuted
          );
          const deniedProviderExecutedToolApprovals = deniedToolApprovals.filter(
            (toolApproval) => toolApproval.toolCall.providerExecuted
          );
          let toolExecutionStepStreamController;
          const toolExecutionStepStream = new ReadableStream({
            start(controller) {
              toolExecutionStepStreamController = controller;
            }
          });
          self.addStream(toolExecutionStepStream);
          try {
            for (const toolApproval of [
              ...localDeniedToolApprovals,
              ...deniedProviderExecutedToolApprovals
            ]) {
              toolExecutionStepStreamController == null ? void 0 : toolExecutionStepStreamController.enqueue({
                type: "tool-output-denied",
                toolCallId: toolApproval.toolCall.toolCallId,
                toolName: toolApproval.toolCall.toolName
              });
            }
            const toolOutputs = [];
            await Promise.all(
              localApprovedToolApprovals.map(async (toolApproval) => {
                const result = await executeToolCall({
                  toolCall: toolApproval.toolCall,
                  tools,
                  tracer,
                  telemetry,
                  messages: initialMessages,
                  abortSignal,
                  experimental_context,
                  onPreliminaryToolResult: (result2) => {
                    toolExecutionStepStreamController == null ? void 0 : toolExecutionStepStreamController.enqueue(result2);
                  }
                });
                if (result != null) {
                  toolExecutionStepStreamController == null ? void 0 : toolExecutionStepStreamController.enqueue(result);
                  toolOutputs.push(result);
                }
              })
            );
            if (providerExecutedToolApprovals.length > 0) {
              initialResponseMessages.push({
                role: "tool",
                content: providerExecutedToolApprovals.map(
                  (toolApproval) => ({
                    type: "tool-approval-response",
                    approvalId: toolApproval.approvalResponse.approvalId,
                    approved: toolApproval.approvalResponse.approved,
                    reason: toolApproval.approvalResponse.reason,
                    providerExecuted: true
                  })
                )
              });
            }
            if (toolOutputs.length > 0 || localDeniedToolApprovals.length > 0) {
              const localToolContent = [];
              for (const output2 of toolOutputs) {
                localToolContent.push({
                  type: "tool-result",
                  toolCallId: output2.toolCallId,
                  toolName: output2.toolName,
                  output: await createToolModelOutput({
                    toolCallId: output2.toolCallId,
                    input: output2.input,
                    tool: tools == null ? void 0 : tools[output2.toolName],
                    output: output2.type === "tool-result" ? output2.output : output2.error,
                    errorMode: output2.type === "tool-error" ? "json" : "none"
                  })
                });
              }
              for (const toolApproval of localDeniedToolApprovals) {
                localToolContent.push({
                  type: "tool-result",
                  toolCallId: toolApproval.toolCall.toolCallId,
                  toolName: toolApproval.toolCall.toolName,
                  output: {
                    type: "execution-denied",
                    reason: toolApproval.approvalResponse.reason
                  }
                });
              }
              initialResponseMessages.push({
                role: "tool",
                content: localToolContent
              });
            }
          } finally {
            toolExecutionStepStreamController == null ? void 0 : toolExecutionStepStreamController.close();
          }
        }
        recordedResponseMessages.push(...initialResponseMessages);
        async function streamStep({
          currentStep,
          responseMessages,
          usage
        }) {
          var _a16, _b, _c, _d, _e, _f;
          const includeRawChunks2 = self.includeRawChunks;
          stepFinish = new import_provider_utils19.DelayedPromise();
          const stepInputMessages = [...initialMessages, ...responseMessages];
          const prepareStepResult = await (prepareStep == null ? void 0 : prepareStep({
            model,
            steps: recordedSteps,
            stepNumber: recordedSteps.length,
            messages: stepInputMessages,
            experimental_context
          }));
          const stepModel = resolveLanguageModel(
            (_a16 = prepareStepResult == null ? void 0 : prepareStepResult.model) != null ? _a16 : model
          );
          const promptMessages = await convertToLanguageModelPrompt({
            prompt: {
              system: (_b = prepareStepResult == null ? void 0 : prepareStepResult.system) != null ? _b : initialPrompt.system,
              messages: (_c = prepareStepResult == null ? void 0 : prepareStepResult.messages) != null ? _c : stepInputMessages
            },
            supportedUrls: await stepModel.supportedUrls,
            download: download2
          });
          const { toolChoice: stepToolChoice, tools: stepTools } = await prepareToolsAndToolChoice({
            tools,
            toolChoice: (_d = prepareStepResult == null ? void 0 : prepareStepResult.toolChoice) != null ? _d : toolChoice,
            activeTools: (_e = prepareStepResult == null ? void 0 : prepareStepResult.activeTools) != null ? _e : activeTools
          });
          experimental_context = (_f = prepareStepResult == null ? void 0 : prepareStepResult.experimental_context) != null ? _f : experimental_context;
          const stepProviderOptions = mergeObjects(
            providerOptions,
            prepareStepResult == null ? void 0 : prepareStepResult.providerOptions
          );
          const {
            result: { stream: stream2, response, request },
            doStreamSpan,
            startTimestampMs
          } = await retry(
            () => recordSpan({
              name: "ai.streamText.doStream",
              attributes: selectTelemetryAttributes({
                telemetry,
                attributes: {
                  ...assembleOperationName({
                    operationId: "ai.streamText.doStream",
                    telemetry
                  }),
                  ...baseTelemetryAttributes,
                  // model:
                  "ai.model.provider": stepModel.provider,
                  "ai.model.id": stepModel.modelId,
                  // prompt:
                  "ai.prompt.messages": {
                    input: () => stringifyForTelemetry(promptMessages)
                  },
                  "ai.prompt.tools": {
                    // convert the language model level tools:
                    input: () => stepTools == null ? void 0 : stepTools.map((tool2) => JSON.stringify(tool2))
                  },
                  "ai.prompt.toolChoice": {
                    input: () => stepToolChoice != null ? JSON.stringify(stepToolChoice) : void 0
                  },
                  // standardized gen-ai llm span attributes:
                  "gen_ai.system": stepModel.provider,
                  "gen_ai.request.model": stepModel.modelId,
                  "gen_ai.request.frequency_penalty": callSettings.frequencyPenalty,
                  "gen_ai.request.max_tokens": callSettings.maxOutputTokens,
                  "gen_ai.request.presence_penalty": callSettings.presencePenalty,
                  "gen_ai.request.stop_sequences": callSettings.stopSequences,
                  "gen_ai.request.temperature": callSettings.temperature,
                  "gen_ai.request.top_k": callSettings.topK,
                  "gen_ai.request.top_p": callSettings.topP
                }
              }),
              tracer,
              endWhenDone: false,
              fn: async (doStreamSpan2) => ({
                startTimestampMs: now2(),
                // get before the call
                doStreamSpan: doStreamSpan2,
                result: await stepModel.doStream({
                  ...callSettings,
                  tools: stepTools,
                  toolChoice: stepToolChoice,
                  responseFormat: await (output == null ? void 0 : output.responseFormat),
                  prompt: promptMessages,
                  providerOptions: stepProviderOptions,
                  abortSignal,
                  headers,
                  includeRawChunks: includeRawChunks2
                })
              })
            })
          );
          const streamWithToolResults = runToolsTransformation({
            tools,
            generatorStream: stream2,
            tracer,
            telemetry,
            system,
            messages: stepInputMessages,
            repairToolCall,
            abortSignal,
            experimental_context,
            generateId: generateId2
          });
          const stepRequest = request != null ? request : {};
          const stepToolCalls = [];
          const stepToolOutputs = [];
          let warnings;
          const activeToolCallToolNames = {};
          let stepFinishReason = "other";
          let stepRawFinishReason = void 0;
          let stepUsage = createNullLanguageModelUsage();
          let stepProviderMetadata;
          let stepFirstChunk = true;
          let stepResponse = {
            id: generateId2(),
            timestamp: /* @__PURE__ */ new Date(),
            modelId: model.modelId
          };
          let activeText = "";
          self.addStream(
            streamWithToolResults.pipeThrough(
              new TransformStream({
                async transform(chunk, controller) {
                  var _a17, _b2, _c2, _d2, _e2;
                  if (chunk.type === "stream-start") {
                    warnings = chunk.warnings;
                    return;
                  }
                  if (stepFirstChunk) {
                    const msToFirstChunk = now2() - startTimestampMs;
                    stepFirstChunk = false;
                    doStreamSpan.addEvent("ai.stream.firstChunk", {
                      "ai.response.msToFirstChunk": msToFirstChunk
                    });
                    doStreamSpan.setAttributes({
                      "ai.response.msToFirstChunk": msToFirstChunk
                    });
                    controller.enqueue({
                      type: "start-step",
                      request: stepRequest,
                      warnings: warnings != null ? warnings : []
                    });
                  }
                  const chunkType = chunk.type;
                  switch (chunkType) {
                    case "tool-approval-request":
                    case "text-start":
                    case "text-end": {
                      controller.enqueue(chunk);
                      break;
                    }
                    case "text-delta": {
                      if (chunk.delta.length > 0) {
                        controller.enqueue({
                          type: "text-delta",
                          id: chunk.id,
                          text: chunk.delta,
                          providerMetadata: chunk.providerMetadata
                        });
                        activeText += chunk.delta;
                      }
                      break;
                    }
                    case "reasoning-start":
                    case "reasoning-end": {
                      controller.enqueue(chunk);
                      break;
                    }
                    case "reasoning-delta": {
                      controller.enqueue({
                        type: "reasoning-delta",
                        id: chunk.id,
                        text: chunk.delta,
                        providerMetadata: chunk.providerMetadata
                      });
                      break;
                    }
                    case "tool-call": {
                      controller.enqueue(chunk);
                      stepToolCalls.push(chunk);
                      break;
                    }
                    case "tool-result": {
                      controller.enqueue(chunk);
                      if (!chunk.preliminary) {
                        stepToolOutputs.push(chunk);
                      }
                      break;
                    }
                    case "tool-error": {
                      controller.enqueue(chunk);
                      stepToolOutputs.push(chunk);
                      break;
                    }
                    case "response-metadata": {
                      stepResponse = {
                        id: (_a17 = chunk.id) != null ? _a17 : stepResponse.id,
                        timestamp: (_b2 = chunk.timestamp) != null ? _b2 : stepResponse.timestamp,
                        modelId: (_c2 = chunk.modelId) != null ? _c2 : stepResponse.modelId
                      };
                      break;
                    }
                    case "finish": {
                      stepUsage = chunk.usage;
                      stepFinishReason = chunk.finishReason;
                      stepRawFinishReason = chunk.rawFinishReason;
                      stepProviderMetadata = chunk.providerMetadata;
                      const msToFinish = now2() - startTimestampMs;
                      doStreamSpan.addEvent("ai.stream.finish");
                      doStreamSpan.setAttributes({
                        "ai.response.msToFinish": msToFinish,
                        "ai.response.avgOutputTokensPerSecond": 1e3 * ((_d2 = stepUsage.outputTokens) != null ? _d2 : 0) / msToFinish
                      });
                      break;
                    }
                    case "file": {
                      controller.enqueue(chunk);
                      break;
                    }
                    case "source": {
                      controller.enqueue(chunk);
                      break;
                    }
                    case "tool-input-start": {
                      activeToolCallToolNames[chunk.id] = chunk.toolName;
                      const tool2 = tools == null ? void 0 : tools[chunk.toolName];
                      if ((tool2 == null ? void 0 : tool2.onInputStart) != null) {
                        await tool2.onInputStart({
                          toolCallId: chunk.id,
                          messages: stepInputMessages,
                          abortSignal,
                          experimental_context
                        });
                      }
                      controller.enqueue({
                        ...chunk,
                        dynamic: (_e2 = chunk.dynamic) != null ? _e2 : (tool2 == null ? void 0 : tool2.type) === "dynamic",
                        title: tool2 == null ? void 0 : tool2.title
                      });
                      break;
                    }
                    case "tool-input-end": {
                      delete activeToolCallToolNames[chunk.id];
                      controller.enqueue(chunk);
                      break;
                    }
                    case "tool-input-delta": {
                      const toolName = activeToolCallToolNames[chunk.id];
                      const tool2 = tools == null ? void 0 : tools[toolName];
                      if ((tool2 == null ? void 0 : tool2.onInputDelta) != null) {
                        await tool2.onInputDelta({
                          inputTextDelta: chunk.delta,
                          toolCallId: chunk.id,
                          messages: stepInputMessages,
                          abortSignal,
                          experimental_context
                        });
                      }
                      controller.enqueue(chunk);
                      break;
                    }
                    case "error": {
                      controller.enqueue(chunk);
                      stepFinishReason = "error";
                      break;
                    }
                    case "raw": {
                      if (includeRawChunks2) {
                        controller.enqueue(chunk);
                      }
                      break;
                    }
                    default: {
                      const exhaustiveCheck = chunkType;
                      throw new Error(`Unknown chunk type: ${exhaustiveCheck}`);
                    }
                  }
                },
                // invoke onFinish callback and resolve toolResults promise when the stream is about to close:
                async flush(controller) {
                  const stepToolCallsJson = stepToolCalls.length > 0 ? JSON.stringify(stepToolCalls) : void 0;
                  try {
                    doStreamSpan.setAttributes(
                      await selectTelemetryAttributes({
                        telemetry,
                        attributes: {
                          "ai.response.finishReason": stepFinishReason,
                          "ai.response.text": {
                            output: () => activeText
                          },
                          "ai.response.toolCalls": {
                            output: () => stepToolCallsJson
                          },
                          "ai.response.id": stepResponse.id,
                          "ai.response.model": stepResponse.modelId,
                          "ai.response.timestamp": stepResponse.timestamp.toISOString(),
                          "ai.response.providerMetadata": JSON.stringify(stepProviderMetadata),
                          "ai.usage.inputTokens": stepUsage.inputTokens,
                          "ai.usage.outputTokens": stepUsage.outputTokens,
                          "ai.usage.totalTokens": stepUsage.totalTokens,
                          "ai.usage.reasoningTokens": stepUsage.reasoningTokens,
                          "ai.usage.cachedInputTokens": stepUsage.cachedInputTokens,
                          // standardized gen-ai llm span attributes:
                          "gen_ai.response.finish_reasons": [stepFinishReason],
                          "gen_ai.response.id": stepResponse.id,
                          "gen_ai.response.model": stepResponse.modelId,
                          "gen_ai.usage.input_tokens": stepUsage.inputTokens,
                          "gen_ai.usage.output_tokens": stepUsage.outputTokens
                        }
                      })
                    );
                  } catch (error) {
                  } finally {
                    doStreamSpan.end();
                  }
                  controller.enqueue({
                    type: "finish-step",
                    finishReason: stepFinishReason,
                    rawFinishReason: stepRawFinishReason,
                    usage: stepUsage,
                    providerMetadata: stepProviderMetadata,
                    response: {
                      ...stepResponse,
                      headers: response == null ? void 0 : response.headers
                    }
                  });
                  const combinedUsage = addLanguageModelUsage(usage, stepUsage);
                  await stepFinish.promise;
                  const clientToolCalls = stepToolCalls.filter(
                    (toolCall) => toolCall.providerExecuted !== true
                  );
                  const clientToolOutputs = stepToolOutputs.filter(
                    (toolOutput) => toolOutput.providerExecuted !== true
                  );
                  for (const toolCall of stepToolCalls) {
                    if (toolCall.providerExecuted !== true)
                      continue;
                    const tool2 = tools == null ? void 0 : tools[toolCall.toolName];
                    if ((tool2 == null ? void 0 : tool2.type) === "provider" && tool2.supportsDeferredResults) {
                      const hasResultInStep = stepToolOutputs.some(
                        (output2) => output2.type === "tool-result" && output2.toolCallId === toolCall.toolCallId
                      );
                      if (!hasResultInStep) {
                        pendingDeferredToolCalls.set(toolCall.toolCallId, {
                          toolName: toolCall.toolName
                        });
                      }
                    }
                  }
                  for (const output2 of stepToolOutputs) {
                    if (output2.type === "tool-result") {
                      pendingDeferredToolCalls.delete(output2.toolCallId);
                    }
                  }
                  if (
                    // Continue if:
                    // 1. There are client tool calls that have all been executed, OR
                    // 2. There are pending deferred results from provider-executed tools
                    (clientToolCalls.length > 0 && clientToolOutputs.length === clientToolCalls.length || pendingDeferredToolCalls.size > 0) && // continue until a stop condition is met:
                    !await isStopConditionMet({
                      stopConditions,
                      steps: recordedSteps
                    })
                  ) {
                    responseMessages.push(
                      ...await toResponseMessages({
                        content: (
                          // use transformed content to create the messages for the next step:
                          recordedSteps[recordedSteps.length - 1].content
                        ),
                        tools
                      })
                    );
                    try {
                      await streamStep({
                        currentStep: currentStep + 1,
                        responseMessages,
                        usage: combinedUsage
                      });
                    } catch (error) {
                      controller.enqueue({
                        type: "error",
                        error
                      });
                      self.closeStream();
                    }
                  } else {
                    controller.enqueue({
                      type: "finish",
                      finishReason: stepFinishReason,
                      rawFinishReason: stepRawFinishReason,
                      totalUsage: combinedUsage
                    });
                    self.closeStream();
                  }
                }
              })
            )
          );
        }
        await streamStep({
          currentStep: 0,
          responseMessages: initialResponseMessages,
          usage: createNullLanguageModelUsage()
        });
      }
    }).catch((error) => {
      self.addStream(
        new ReadableStream({
          start(controller) {
            controller.enqueue({ type: "error", error });
            controller.close();
          }
        })
      );
      self.closeStream();
    });
  }
  get steps() {
    this.consumeStream();
    return this._steps.promise;
  }
  get finalStep() {
    return this.steps.then((steps) => steps[steps.length - 1]);
  }
  get content() {
    return this.finalStep.then((step) => step.content);
  }
  get warnings() {
    return this.finalStep.then((step) => step.warnings);
  }
  get providerMetadata() {
    return this.finalStep.then((step) => step.providerMetadata);
  }
  get text() {
    return this.finalStep.then((step) => step.text);
  }
  get reasoningText() {
    return this.finalStep.then((step) => step.reasoningText);
  }
  get reasoning() {
    return this.finalStep.then((step) => step.reasoning);
  }
  get sources() {
    return this.finalStep.then((step) => step.sources);
  }
  get files() {
    return this.finalStep.then((step) => step.files);
  }
  get toolCalls() {
    return this.finalStep.then((step) => step.toolCalls);
  }
  get staticToolCalls() {
    return this.finalStep.then((step) => step.staticToolCalls);
  }
  get dynamicToolCalls() {
    return this.finalStep.then((step) => step.dynamicToolCalls);
  }
  get toolResults() {
    return this.finalStep.then((step) => step.toolResults);
  }
  get staticToolResults() {
    return this.finalStep.then((step) => step.staticToolResults);
  }
  get dynamicToolResults() {
    return this.finalStep.then((step) => step.dynamicToolResults);
  }
  get usage() {
    return this.finalStep.then((step) => step.usage);
  }
  get request() {
    return this.finalStep.then((step) => step.request);
  }
  get response() {
    return this.finalStep.then((step) => step.response);
  }
  get totalUsage() {
    this.consumeStream();
    return this._totalUsage.promise;
  }
  get finishReason() {
    this.consumeStream();
    return this._finishReason.promise;
  }
  get rawFinishReason() {
    this.consumeStream();
    return this._rawFinishReason.promise;
  }
  /**
  Split out a new stream from the original stream.
  The original stream is replaced to allow for further splitting,
  since we do not know how many times the stream will be split.
  
  Note: this leads to buffering the stream content on the server.
  However, the LLM results are expected to be small enough to not cause issues.
     */
  teeStream() {
    const [stream1, stream2] = this.baseStream.tee();
    this.baseStream = stream2;
    return stream1;
  }
  get textStream() {
    return createAsyncIterableStream(
      this.teeStream().pipeThrough(
        new TransformStream({
          transform({ part }, controller) {
            if (part.type === "text-delta") {
              controller.enqueue(part.text);
            }
          }
        })
      )
    );
  }
  get fullStream() {
    return createAsyncIterableStream(
      this.teeStream().pipeThrough(
        new TransformStream({
          transform({ part }, controller) {
            controller.enqueue(part);
          }
        })
      )
    );
  }
  async consumeStream(options) {
    var _a16;
    try {
      await consumeStream({
        stream: this.fullStream,
        onError: options == null ? void 0 : options.onError
      });
    } catch (error) {
      (_a16 = options == null ? void 0 : options.onError) == null ? void 0 : _a16.call(options, error);
    }
  }
  get experimental_partialOutputStream() {
    return this.partialOutputStream;
  }
  get partialOutputStream() {
    return createAsyncIterableStream(
      this.teeStream().pipeThrough(
        new TransformStream({
          transform({ partialOutput }, controller) {
            if (partialOutput != null) {
              controller.enqueue(partialOutput);
            }
          }
        })
      )
    );
  }
  get output() {
    return this.finalStep.then((step) => {
      var _a16;
      const output = (_a16 = this.outputSpecification) != null ? _a16 : text();
      return output.parseCompleteOutput(
        { text: step.text },
        {
          response: step.response,
          usage: step.usage,
          finishReason: step.finishReason
        }
      );
    });
  }
  toUIMessageStream({
    originalMessages,
    generateMessageId,
    onFinish,
    messageMetadata,
    sendReasoning = true,
    sendSources = false,
    sendStart = true,
    sendFinish = true,
    onError = import_provider24.getErrorMessage
  } = {}) {
    const responseMessageId = generateMessageId != null ? getResponseUIMessageId({
      originalMessages,
      responseMessageId: generateMessageId
    }) : void 0;
    const isDynamic = (part) => {
      var _a16;
      const tool2 = (_a16 = this.tools) == null ? void 0 : _a16[part.toolName];
      if (tool2 == null) {
        return part.dynamic;
      }
      return (tool2 == null ? void 0 : tool2.type) === "dynamic" ? true : void 0;
    };
    const baseStream = this.fullStream.pipeThrough(
      new TransformStream({
        transform: async (part, controller) => {
          const messageMetadataValue = messageMetadata == null ? void 0 : messageMetadata({ part });
          const partType = part.type;
          switch (partType) {
            case "text-start": {
              controller.enqueue({
                type: "text-start",
                id: part.id,
                ...part.providerMetadata != null ? { providerMetadata: part.providerMetadata } : {}
              });
              break;
            }
            case "text-delta": {
              controller.enqueue({
                type: "text-delta",
                id: part.id,
                delta: part.text,
                ...part.providerMetadata != null ? { providerMetadata: part.providerMetadata } : {}
              });
              break;
            }
            case "text-end": {
              controller.enqueue({
                type: "text-end",
                id: part.id,
                ...part.providerMetadata != null ? { providerMetadata: part.providerMetadata } : {}
              });
              break;
            }
            case "reasoning-start": {
              controller.enqueue({
                type: "reasoning-start",
                id: part.id,
                ...part.providerMetadata != null ? { providerMetadata: part.providerMetadata } : {}
              });
              break;
            }
            case "reasoning-delta": {
              if (sendReasoning) {
                controller.enqueue({
                  type: "reasoning-delta",
                  id: part.id,
                  delta: part.text,
                  ...part.providerMetadata != null ? { providerMetadata: part.providerMetadata } : {}
                });
              }
              break;
            }
            case "reasoning-end": {
              controller.enqueue({
                type: "reasoning-end",
                id: part.id,
                ...part.providerMetadata != null ? { providerMetadata: part.providerMetadata } : {}
              });
              break;
            }
            case "file": {
              controller.enqueue({
                type: "file",
                mediaType: part.file.mediaType,
                url: `data:${part.file.mediaType};base64,${part.file.base64}`
              });
              break;
            }
            case "source": {
              if (sendSources && part.sourceType === "url") {
                controller.enqueue({
                  type: "source-url",
                  sourceId: part.id,
                  url: part.url,
                  title: part.title,
                  ...part.providerMetadata != null ? { providerMetadata: part.providerMetadata } : {}
                });
              }
              if (sendSources && part.sourceType === "document") {
                controller.enqueue({
                  type: "source-document",
                  sourceId: part.id,
                  mediaType: part.mediaType,
                  title: part.title,
                  filename: part.filename,
                  ...part.providerMetadata != null ? { providerMetadata: part.providerMetadata } : {}
                });
              }
              break;
            }
            case "tool-input-start": {
              const dynamic = isDynamic(part);
              controller.enqueue({
                type: "tool-input-start",
                toolCallId: part.id,
                toolName: part.toolName,
                ...part.providerExecuted != null ? { providerExecuted: part.providerExecuted } : {},
                ...dynamic != null ? { dynamic } : {},
                ...part.title != null ? { title: part.title } : {}
              });
              break;
            }
            case "tool-input-delta": {
              controller.enqueue({
                type: "tool-input-delta",
                toolCallId: part.id,
                inputTextDelta: part.delta
              });
              break;
            }
            case "tool-call": {
              const dynamic = isDynamic(part);
              if (part.invalid) {
                controller.enqueue({
                  type: "tool-input-error",
                  toolCallId: part.toolCallId,
                  toolName: part.toolName,
                  input: part.input,
                  ...part.providerExecuted != null ? { providerExecuted: part.providerExecuted } : {},
                  ...part.providerMetadata != null ? { providerMetadata: part.providerMetadata } : {},
                  ...dynamic != null ? { dynamic } : {},
                  errorText: onError(part.error),
                  ...part.title != null ? { title: part.title } : {}
                });
              } else {
                controller.enqueue({
                  type: "tool-input-available",
                  toolCallId: part.toolCallId,
                  toolName: part.toolName,
                  input: part.input,
                  ...part.providerExecuted != null ? { providerExecuted: part.providerExecuted } : {},
                  ...part.providerMetadata != null ? { providerMetadata: part.providerMetadata } : {},
                  ...dynamic != null ? { dynamic } : {},
                  ...part.title != null ? { title: part.title } : {}
                });
              }
              break;
            }
            case "tool-approval-request": {
              controller.enqueue({
                type: "tool-approval-request",
                approvalId: part.approvalId,
                toolCallId: part.toolCall.toolCallId
              });
              break;
            }
            case "tool-result": {
              const dynamic = isDynamic(part);
              controller.enqueue({
                type: "tool-output-available",
                toolCallId: part.toolCallId,
                output: part.output,
                ...part.providerExecuted != null ? { providerExecuted: part.providerExecuted } : {},
                ...part.preliminary != null ? { preliminary: part.preliminary } : {},
                ...dynamic != null ? { dynamic } : {}
              });
              break;
            }
            case "tool-error": {
              const dynamic = isDynamic(part);
              controller.enqueue({
                type: "tool-output-error",
                toolCallId: part.toolCallId,
                errorText: onError(part.error),
                ...part.providerExecuted != null ? { providerExecuted: part.providerExecuted } : {},
                ...dynamic != null ? { dynamic } : {}
              });
              break;
            }
            case "tool-output-denied": {
              controller.enqueue({
                type: "tool-output-denied",
                toolCallId: part.toolCallId
              });
              break;
            }
            case "error": {
              controller.enqueue({
                type: "error",
                errorText: onError(part.error)
              });
              break;
            }
            case "start-step": {
              controller.enqueue({ type: "start-step" });
              break;
            }
            case "finish-step": {
              controller.enqueue({ type: "finish-step" });
              break;
            }
            case "start": {
              if (sendStart) {
                controller.enqueue({
                  type: "start",
                  ...messageMetadataValue != null ? { messageMetadata: messageMetadataValue } : {},
                  ...responseMessageId != null ? { messageId: responseMessageId } : {}
                });
              }
              break;
            }
            case "finish": {
              if (sendFinish) {
                controller.enqueue({
                  type: "finish",
                  finishReason: part.finishReason,
                  ...messageMetadataValue != null ? { messageMetadata: messageMetadataValue } : {}
                });
              }
              break;
            }
            case "abort": {
              controller.enqueue(part);
              break;
            }
            case "tool-input-end": {
              break;
            }
            case "raw": {
              break;
            }
            default: {
              const exhaustiveCheck = partType;
              throw new Error(`Unknown chunk type: ${exhaustiveCheck}`);
            }
          }
          if (messageMetadataValue != null && partType !== "start" && partType !== "finish") {
            controller.enqueue({
              type: "message-metadata",
              messageMetadata: messageMetadataValue
            });
          }
        }
      })
    );
    return createAsyncIterableStream(
      handleUIMessageStreamFinish({
        stream: baseStream,
        messageId: responseMessageId != null ? responseMessageId : generateMessageId == null ? void 0 : generateMessageId(),
        originalMessages,
        onFinish,
        onError
      })
    );
  }
  pipeUIMessageStreamToResponse(response, {
    originalMessages,
    generateMessageId,
    onFinish,
    messageMetadata,
    sendReasoning,
    sendSources,
    sendFinish,
    sendStart,
    onError,
    ...init
  } = {}) {
    pipeUIMessageStreamToResponse({
      response,
      stream: this.toUIMessageStream({
        originalMessages,
        generateMessageId,
        onFinish,
        messageMetadata,
        sendReasoning,
        sendSources,
        sendFinish,
        sendStart,
        onError
      }),
      ...init
    });
  }
  pipeTextStreamToResponse(response, init) {
    pipeTextStreamToResponse({
      response,
      textStream: this.textStream,
      ...init
    });
  }
  toUIMessageStreamResponse({
    originalMessages,
    generateMessageId,
    onFinish,
    messageMetadata,
    sendReasoning,
    sendSources,
    sendFinish,
    sendStart,
    onError,
    ...init
  } = {}) {
    return createUIMessageStreamResponse({
      stream: this.toUIMessageStream({
        originalMessages,
        generateMessageId,
        onFinish,
        messageMetadata,
        sendReasoning,
        sendSources,
        sendFinish,
        sendStart,
        onError
      }),
      ...init
    });
  }
  toTextStreamResponse(init) {
    return createTextStreamResponse({
      textStream: this.textStream,
      ...init
    });
  }
};

// src/agent/tool-loop-agent.ts
var ToolLoopAgent = class {
  constructor(settings) {
    this.version = "agent-v1";
    this.settings = settings;
  }
  /**
   * The id of the agent.
   */
  get id() {
    return this.settings.id;
  }
  /**
   * The tools that the agent can use.
   */
  get tools() {
    return this.settings.tools;
  }
  async prepareCall(options) {
    var _a16, _b, _c, _d;
    const baseCallArgs = {
      ...this.settings,
      stopWhen: (_a16 = this.settings.stopWhen) != null ? _a16 : stepCountIs(20),
      ...options
    };
    const preparedCallArgs = (_d = await ((_c = (_b = this.settings).prepareCall) == null ? void 0 : _c.call(_b, baseCallArgs))) != null ? _d : baseCallArgs;
    const { instructions, messages, prompt, ...callArgs } = preparedCallArgs;
    return {
      ...callArgs,
      // restore prompt types
      ...{ system: instructions, messages, prompt }
    };
  }
  /**
   * Generates an output from the agent (non-streaming).
   */
  async generate({
    abortSignal,
    timeout,
    ...options
  }) {
    return generateText({
      ...await this.prepareCall(options),
      abortSignal,
      timeout
    });
  }
  /**
   * Streams an output from the agent (streaming).
   */
  async stream({
    abortSignal,
    timeout,
    experimental_transform,
    ...options
  }) {
    return streamText({
      ...await this.prepareCall(options),
      abortSignal,
      timeout,
      experimental_transform
    });
  }
};

// src/ui-message-stream/create-ui-message-stream.ts
var import_provider_utils20 = require("@ai-sdk/provider-utils");
function createUIMessageStream({
  execute,
  onError = import_provider_utils20.getErrorMessage,
  originalMessages,
  onFinish,
  generateId: generateId2 = import_provider_utils20.generateId
}) {
  let controller;
  const ongoingStreamPromises = [];
  const stream = new ReadableStream({
    start(controllerArg) {
      controller = controllerArg;
    }
  });
  function safeEnqueue(data) {
    try {
      controller.enqueue(data);
    } catch (error) {
    }
  }
  try {
    const result = execute({
      writer: {
        write(part) {
          safeEnqueue(part);
        },
        merge(streamArg) {
          ongoingStreamPromises.push(
            (async () => {
              const reader = streamArg.getReader();
              while (true) {
                const { done, value } = await reader.read();
                if (done)
                  break;
                safeEnqueue(value);
              }
            })().catch((error) => {
              safeEnqueue({
                type: "error",
                errorText: onError(error)
              });
            })
          );
        },
        onError
      }
    });
    if (result) {
      ongoingStreamPromises.push(
        result.catch((error) => {
          safeEnqueue({
            type: "error",
            errorText: onError(error)
          });
        })
      );
    }
  } catch (error) {
    safeEnqueue({
      type: "error",
      errorText: onError(error)
    });
  }
  const waitForStreams = new Promise(async (resolve3) => {
    while (ongoingStreamPromises.length > 0) {
      await ongoingStreamPromises.shift();
    }
    resolve3();
  });
  waitForStreams.finally(() => {
    try {
      controller.close();
    } catch (error) {
    }
  });
  return handleUIMessageStreamFinish({
    stream,
    messageId: generateId2(),
    originalMessages,
    onFinish,
    onError
  });
}

// src/ui-message-stream/read-ui-message-stream.ts
function readUIMessageStream({
  message,
  stream,
  onError,
  terminateOnError = false
}) {
  var _a16;
  let controller;
  let hasErrored = false;
  const outputStream = new ReadableStream({
    start(controllerParam) {
      controller = controllerParam;
    }
  });
  const state = createStreamingUIMessageState({
    messageId: (_a16 = message == null ? void 0 : message.id) != null ? _a16 : "",
    lastMessage: message
  });
  const handleError = (error) => {
    onError == null ? void 0 : onError(error);
    if (!hasErrored && terminateOnError) {
      hasErrored = true;
      controller == null ? void 0 : controller.error(error);
    }
  };
  consumeStream({
    stream: processUIMessageStream({
      stream,
      runUpdateMessageJob(job) {
        return job({
          state,
          write: () => {
            controller == null ? void 0 : controller.enqueue(structuredClone(state.message));
          }
        });
      },
      onError: handleError
    }),
    onError: handleError
  }).finally(() => {
    if (!hasErrored) {
      controller == null ? void 0 : controller.close();
    }
  });
  return createAsyncIterableStream(outputStream);
}

// src/ui/convert-to-model-messages.ts
var import_provider_utils21 = require("@ai-sdk/provider-utils");
async function convertToModelMessages(messages, options) {
  const modelMessages = [];
  if (options == null ? void 0 : options.ignoreIncompleteToolCalls) {
    messages = messages.map((message) => ({
      ...message,
      parts: message.parts.filter(
        (part) => !isToolUIPart(part) || part.state !== "input-streaming" && part.state !== "input-available"
      )
    }));
  }
  for (const message of messages) {
    switch (message.role) {
      case "system": {
        const textParts = message.parts.filter(
          (part) => part.type === "text"
        );
        const providerMetadata = textParts.reduce((acc, part) => {
          if (part.providerMetadata != null) {
            return { ...acc, ...part.providerMetadata };
          }
          return acc;
        }, {});
        modelMessages.push({
          role: "system",
          content: textParts.map((part) => part.text).join(""),
          ...Object.keys(providerMetadata).length > 0 ? { providerOptions: providerMetadata } : {}
        });
        break;
      }
      case "user": {
        modelMessages.push({
          role: "user",
          content: message.parts.map((part) => {
            var _a16;
            if (isTextUIPart(part)) {
              return {
                type: "text",
                text: part.text,
                ...part.providerMetadata != null ? { providerOptions: part.providerMetadata } : {}
              };
            }
            if (isFileUIPart(part)) {
              return {
                type: "file",
                mediaType: part.mediaType,
                filename: part.filename,
                data: part.url,
                ...part.providerMetadata != null ? { providerOptions: part.providerMetadata } : {}
              };
            }
            if (isDataUIPart(part)) {
              return (_a16 = options == null ? void 0 : options.convertDataPart) == null ? void 0 : _a16.call(
                options,
                part
              );
            }
          }).filter(import_provider_utils21.isNonNullable)
        });
        break;
      }
      case "assistant": {
        if (message.parts != null) {
          let block = [];
          async function processBlock() {
            var _a16, _b, _c, _d, _e, _f;
            if (block.length === 0) {
              return;
            }
            const content = [];
            for (const part of block) {
              if (isTextUIPart(part)) {
                content.push({
                  type: "text",
                  text: part.text,
                  ...part.providerMetadata != null ? { providerOptions: part.providerMetadata } : {}
                });
              } else if (isFileUIPart(part)) {
                content.push({
                  type: "file",
                  mediaType: part.mediaType,
                  filename: part.filename,
                  data: part.url
                });
              } else if (isReasoningUIPart(part)) {
                content.push({
                  type: "reasoning",
                  text: part.text,
                  providerOptions: part.providerMetadata
                });
              } else if (isToolUIPart(part)) {
                const toolName = getToolName(part);
                if (part.state !== "input-streaming") {
                  content.push({
                    type: "tool-call",
                    toolCallId: part.toolCallId,
                    toolName,
                    input: part.state === "output-error" ? (_a16 = part.input) != null ? _a16 : "rawInput" in part ? part.rawInput : void 0 : part.input,
                    providerExecuted: part.providerExecuted,
                    ...part.callProviderMetadata != null ? { providerOptions: part.callProviderMetadata } : {}
                  });
                  if (part.approval != null) {
                    content.push({
                      type: "tool-approval-request",
                      approvalId: part.approval.id,
                      toolCallId: part.toolCallId
                    });
                  }
                  if (part.providerExecuted === true && part.state !== "approval-responded" && (part.state === "output-available" || part.state === "output-error")) {
                    content.push({
                      type: "tool-result",
                      toolCallId: part.toolCallId,
                      toolName,
                      output: await createToolModelOutput({
                        toolCallId: part.toolCallId,
                        input: part.input,
                        output: part.state === "output-error" ? part.errorText : part.output,
                        tool: (_b = options == null ? void 0 : options.tools) == null ? void 0 : _b[toolName],
                        errorMode: part.state === "output-error" ? "json" : "none"
                      }),
                      ...part.callProviderMetadata != null ? { providerOptions: part.callProviderMetadata } : {}
                    });
                  }
                }
              } else if (isDataUIPart(part)) {
                const dataPart = (_c = options == null ? void 0 : options.convertDataPart) == null ? void 0 : _c.call(
                  options,
                  part
                );
                if (dataPart != null) {
                  content.push(dataPart);
                }
              } else {
                const _exhaustiveCheck = part;
                throw new Error(`Unsupported part: ${_exhaustiveCheck}`);
              }
            }
            modelMessages.push({
              role: "assistant",
              content
            });
            const toolParts = block.filter(
              (part) => {
                var _a17;
                return isToolUIPart(part) && (part.providerExecuted !== true || ((_a17 = part.approval) == null ? void 0 : _a17.approved) != null);
              }
            );
            if (toolParts.length > 0) {
              {
                const content2 = [];
                for (const toolPart of toolParts) {
                  if (((_d = toolPart.approval) == null ? void 0 : _d.approved) != null) {
                    content2.push({
                      type: "tool-approval-response",
                      approvalId: toolPart.approval.id,
                      approved: toolPart.approval.approved,
                      reason: toolPart.approval.reason,
                      providerExecuted: toolPart.providerExecuted
                    });
                  }
                  if (toolPart.providerExecuted === true) {
                    continue;
                  }
                  switch (toolPart.state) {
                    case "output-denied": {
                      content2.push({
                        type: "tool-result",
                        toolCallId: toolPart.toolCallId,
                        toolName: getToolName(toolPart),
                        output: {
                          type: "error-text",
                          value: (_e = toolPart.approval.reason) != null ? _e : "Tool execution denied."
                        },
                        ...toolPart.callProviderMetadata != null ? { providerOptions: toolPart.callProviderMetadata } : {}
                      });
                      break;
                    }
                    case "output-error":
                    case "output-available": {
                      const toolName = getToolName(toolPart);
                      content2.push({
                        type: "tool-result",
                        toolCallId: toolPart.toolCallId,
                        toolName,
                        output: await createToolModelOutput({
                          toolCallId: toolPart.toolCallId,
                          input: toolPart.input,
                          output: toolPart.state === "output-error" ? toolPart.errorText : toolPart.output,
                          tool: (_f = options == null ? void 0 : options.tools) == null ? void 0 : _f[toolName],
                          errorMode: toolPart.state === "output-error" ? "text" : "none"
                        }),
                        ...toolPart.callProviderMetadata != null ? { providerOptions: toolPart.callProviderMetadata } : {}
                      });
                      break;
                    }
                  }
                }
                if (content2.length > 0) {
                  modelMessages.push({
                    role: "tool",
                    content: content2
                  });
                }
              }
            }
            block = [];
          }
          for (const part of message.parts) {
            if (isTextUIPart(part) || isReasoningUIPart(part) || isFileUIPart(part) || isToolUIPart(part) || isDataUIPart(part)) {
              block.push(part);
            } else if (part.type === "step-start") {
              await processBlock();
            }
          }
          await processBlock();
          break;
        }
        break;
      }
      default: {
        const _exhaustiveCheck = message.role;
        throw new MessageConversionError({
          originalMessage: message,
          message: `Unsupported role: ${_exhaustiveCheck}`
        });
      }
    }
  }
  return modelMessages;
}

// src/ui/validate-ui-messages.ts
var import_provider25 = require("@ai-sdk/provider");
var import_provider_utils22 = require("@ai-sdk/provider-utils");
var import_v48 = require("zod/v4");
var uiMessagesSchema = (0, import_provider_utils22.lazySchema)(
  () => (0, import_provider_utils22.zodSchema)(
    import_v48.z.array(
      import_v48.z.object({
        id: import_v48.z.string(),
        role: import_v48.z.enum(["system", "user", "assistant"]),
        metadata: import_v48.z.unknown().optional(),
        parts: import_v48.z.array(
          import_v48.z.union([
            import_v48.z.object({
              type: import_v48.z.literal("text"),
              text: import_v48.z.string(),
              state: import_v48.z.enum(["streaming", "done"]).optional(),
              providerMetadata: providerMetadataSchema.optional()
            }),
            import_v48.z.object({
              type: import_v48.z.literal("reasoning"),
              text: import_v48.z.string(),
              state: import_v48.z.enum(["streaming", "done"]).optional(),
              providerMetadata: providerMetadataSchema.optional()
            }),
            import_v48.z.object({
              type: import_v48.z.literal("source-url"),
              sourceId: import_v48.z.string(),
              url: import_v48.z.string(),
              title: import_v48.z.string().optional(),
              providerMetadata: providerMetadataSchema.optional()
            }),
            import_v48.z.object({
              type: import_v48.z.literal("source-document"),
              sourceId: import_v48.z.string(),
              mediaType: import_v48.z.string(),
              title: import_v48.z.string(),
              filename: import_v48.z.string().optional(),
              providerMetadata: providerMetadataSchema.optional()
            }),
            import_v48.z.object({
              type: import_v48.z.literal("file"),
              mediaType: import_v48.z.string(),
              filename: import_v48.z.string().optional(),
              url: import_v48.z.string(),
              providerMetadata: providerMetadataSchema.optional()
            }),
            import_v48.z.object({
              type: import_v48.z.literal("step-start")
            }),
            import_v48.z.object({
              type: import_v48.z.string().startsWith("data-"),
              id: import_v48.z.string().optional(),
              data: import_v48.z.unknown()
            }),
            import_v48.z.object({
              type: import_v48.z.literal("dynamic-tool"),
              toolName: import_v48.z.string(),
              toolCallId: import_v48.z.string(),
              state: import_v48.z.literal("input-streaming"),
              input: import_v48.z.unknown().optional(),
              providerExecuted: import_v48.z.boolean().optional(),
              output: import_v48.z.never().optional(),
              errorText: import_v48.z.never().optional(),
              approval: import_v48.z.never().optional()
            }),
            import_v48.z.object({
              type: import_v48.z.literal("dynamic-tool"),
              toolName: import_v48.z.string(),
              toolCallId: import_v48.z.string(),
              state: import_v48.z.literal("input-available"),
              input: import_v48.z.unknown(),
              providerExecuted: import_v48.z.boolean().optional(),
              output: import_v48.z.never().optional(),
              errorText: import_v48.z.never().optional(),
              callProviderMetadata: providerMetadataSchema.optional(),
              approval: import_v48.z.never().optional()
            }),
            import_v48.z.object({
              type: import_v48.z.literal("dynamic-tool"),
              toolName: import_v48.z.string(),
              toolCallId: import_v48.z.string(),
              state: import_v48.z.literal("approval-requested"),
              input: import_v48.z.unknown(),
              providerExecuted: import_v48.z.boolean().optional(),
              output: import_v48.z.never().optional(),
              errorText: import_v48.z.never().optional(),
              callProviderMetadata: providerMetadataSchema.optional(),
              approval: import_v48.z.object({
                id: import_v48.z.string(),
                approved: import_v48.z.never().optional(),
                reason: import_v48.z.never().optional()
              })
            }),
            import_v48.z.object({
              type: import_v48.z.literal("dynamic-tool"),
              toolName: import_v48.z.string(),
              toolCallId: import_v48.z.string(),
              state: import_v48.z.literal("approval-responded"),
              input: import_v48.z.unknown(),
              providerExecuted: import_v48.z.boolean().optional(),
              output: import_v48.z.never().optional(),
              errorText: import_v48.z.never().optional(),
              callProviderMetadata: providerMetadataSchema.optional(),
              approval: import_v48.z.object({
                id: import_v48.z.string(),
                approved: import_v48.z.boolean(),
                reason: import_v48.z.string().optional()
              })
            }),
            import_v48.z.object({
              type: import_v48.z.literal("dynamic-tool"),
              toolName: import_v48.z.string(),
              toolCallId: import_v48.z.string(),
              state: import_v48.z.literal("output-available"),
              input: import_v48.z.unknown(),
              providerExecuted: import_v48.z.boolean().optional(),
              output: import_v48.z.unknown(),
              errorText: import_v48.z.never().optional(),
              callProviderMetadata: providerMetadataSchema.optional(),
              preliminary: import_v48.z.boolean().optional(),
              approval: import_v48.z.object({
                id: import_v48.z.string(),
                approved: import_v48.z.literal(true),
                reason: import_v48.z.string().optional()
              }).optional()
            }),
            import_v48.z.object({
              type: import_v48.z.literal("dynamic-tool"),
              toolName: import_v48.z.string(),
              toolCallId: import_v48.z.string(),
              state: import_v48.z.literal("output-error"),
              input: import_v48.z.unknown(),
              rawInput: import_v48.z.unknown().optional(),
              providerExecuted: import_v48.z.boolean().optional(),
              output: import_v48.z.never().optional(),
              errorText: import_v48.z.string(),
              callProviderMetadata: providerMetadataSchema.optional(),
              approval: import_v48.z.object({
                id: import_v48.z.string(),
                approved: import_v48.z.literal(true),
                reason: import_v48.z.string().optional()
              }).optional()
            }),
            import_v48.z.object({
              type: import_v48.z.literal("dynamic-tool"),
              toolName: import_v48.z.string(),
              toolCallId: import_v48.z.string(),
              state: import_v48.z.literal("output-denied"),
              input: import_v48.z.unknown(),
              providerExecuted: import_v48.z.boolean().optional(),
              output: import_v48.z.never().optional(),
              errorText: import_v48.z.never().optional(),
              callProviderMetadata: providerMetadataSchema.optional(),
              approval: import_v48.z.object({
                id: import_v48.z.string(),
                approved: import_v48.z.literal(false),
                reason: import_v48.z.string().optional()
              })
            }),
            import_v48.z.object({
              type: import_v48.z.string().startsWith("tool-"),
              toolCallId: import_v48.z.string(),
              state: import_v48.z.literal("input-streaming"),
              providerExecuted: import_v48.z.boolean().optional(),
              input: import_v48.z.unknown().optional(),
              output: import_v48.z.never().optional(),
              errorText: import_v48.z.never().optional(),
              approval: import_v48.z.never().optional()
            }),
            import_v48.z.object({
              type: import_v48.z.string().startsWith("tool-"),
              toolCallId: import_v48.z.string(),
              state: import_v48.z.literal("input-available"),
              providerExecuted: import_v48.z.boolean().optional(),
              input: import_v48.z.unknown(),
              output: import_v48.z.never().optional(),
              errorText: import_v48.z.never().optional(),
              callProviderMetadata: providerMetadataSchema.optional(),
              approval: import_v48.z.never().optional()
            }),
            import_v48.z.object({
              type: import_v48.z.string().startsWith("tool-"),
              toolCallId: import_v48.z.string(),
              state: import_v48.z.literal("approval-requested"),
              input: import_v48.z.unknown(),
              providerExecuted: import_v48.z.boolean().optional(),
              output: import_v48.z.never().optional(),
              errorText: import_v48.z.never().optional(),
              callProviderMetadata: providerMetadataSchema.optional(),
              approval: import_v48.z.object({
                id: import_v48.z.string(),
                approved: import_v48.z.never().optional(),
                reason: import_v48.z.never().optional()
              })
            }),
            import_v48.z.object({
              type: import_v48.z.string().startsWith("tool-"),
              toolCallId: import_v48.z.string(),
              state: import_v48.z.literal("approval-responded"),
              input: import_v48.z.unknown(),
              providerExecuted: import_v48.z.boolean().optional(),
              output: import_v48.z.never().optional(),
              errorText: import_v48.z.never().optional(),
              callProviderMetadata: providerMetadataSchema.optional(),
              approval: import_v48.z.object({
                id: import_v48.z.string(),
                approved: import_v48.z.boolean(),
                reason: import_v48.z.string().optional()
              })
            }),
            import_v48.z.object({
              type: import_v48.z.string().startsWith("tool-"),
              toolCallId: import_v48.z.string(),
              state: import_v48.z.literal("output-available"),
              providerExecuted: import_v48.z.boolean().optional(),
              input: import_v48.z.unknown(),
              output: import_v48.z.unknown(),
              errorText: import_v48.z.never().optional(),
              callProviderMetadata: providerMetadataSchema.optional(),
              preliminary: import_v48.z.boolean().optional(),
              approval: import_v48.z.object({
                id: import_v48.z.string(),
                approved: import_v48.z.literal(true),
                reason: import_v48.z.string().optional()
              }).optional()
            }),
            import_v48.z.object({
              type: import_v48.z.string().startsWith("tool-"),
              toolCallId: import_v48.z.string(),
              state: import_v48.z.literal("output-error"),
              providerExecuted: import_v48.z.boolean().optional(),
              input: import_v48.z.unknown(),
              rawInput: import_v48.z.unknown().optional(),
              output: import_v48.z.never().optional(),
              errorText: import_v48.z.string(),
              callProviderMetadata: providerMetadataSchema.optional(),
              approval: import_v48.z.object({
                id: import_v48.z.string(),
                approved: import_v48.z.literal(true),
                reason: import_v48.z.string().optional()
              }).optional()
            }),
            import_v48.z.object({
              type: import_v48.z.string().startsWith("tool-"),
              toolCallId: import_v48.z.string(),
              state: import_v48.z.literal("output-denied"),
              providerExecuted: import_v48.z.boolean().optional(),
              input: import_v48.z.unknown(),
              output: import_v48.z.never().optional(),
              errorText: import_v48.z.never().optional(),
              callProviderMetadata: providerMetadataSchema.optional(),
              approval: import_v48.z.object({
                id: import_v48.z.string(),
                approved: import_v48.z.literal(false),
                reason: import_v48.z.string().optional()
              })
            })
          ])
        ).nonempty("Message must contain at least one part")
      })
    ).nonempty("Messages array must not be empty")
  )
);
async function safeValidateUIMessages({
  messages,
  metadataSchema,
  dataSchemas,
  tools
}) {
  try {
    if (messages == null) {
      return {
        success: false,
        error: new InvalidArgumentError({
          parameter: "messages",
          value: messages,
          message: "messages parameter must be provided"
        })
      };
    }
    const validatedMessages = await (0, import_provider_utils22.validateTypes)({
      value: messages,
      schema: uiMessagesSchema
    });
    if (metadataSchema) {
      for (const message of validatedMessages) {
        await (0, import_provider_utils22.validateTypes)({
          value: message.metadata,
          schema: metadataSchema
        });
      }
    }
    if (dataSchemas) {
      for (const message of validatedMessages) {
        const dataParts = message.parts.filter(
          (part) => part.type.startsWith("data-")
        );
        for (const dataPart of dataParts) {
          const dataName = dataPart.type.slice(5);
          const dataSchema = dataSchemas[dataName];
          if (!dataSchema) {
            return {
              success: false,
              error: new import_provider25.TypeValidationError({
                value: dataPart.data,
                cause: `No data schema found for data part ${dataName}`
              })
            };
          }
          await (0, import_provider_utils22.validateTypes)({
            value: dataPart.data,
            schema: dataSchema
          });
        }
      }
    }
    if (tools) {
      for (const message of validatedMessages) {
        const toolParts = message.parts.filter(
          (part) => part.type.startsWith("tool-")
        );
        for (const toolPart of toolParts) {
          const toolName = toolPart.type.slice(5);
          const tool2 = tools[toolName];
          if (!tool2) {
            return {
              success: false,
              error: new import_provider25.TypeValidationError({
                value: toolPart.input,
                cause: `No tool schema found for tool part ${toolName}`
              })
            };
          }
          if (toolPart.state === "input-available" || toolPart.state === "output-available" || toolPart.state === "output-error" && toolPart.input !== void 0) {
            await (0, import_provider_utils22.validateTypes)({
              value: toolPart.input,
              schema: tool2.inputSchema
            });
          }
          if (toolPart.state === "output-available" && tool2.outputSchema) {
            await (0, import_provider_utils22.validateTypes)({
              value: toolPart.output,
              schema: tool2.outputSchema
            });
          }
        }
      }
    }
    return {
      success: true,
      data: validatedMessages
    };
  } catch (error) {
    const err = error;
    return {
      success: false,
      error: err
    };
  }
}
async function validateUIMessages({
  messages,
  metadataSchema,
  dataSchemas,
  tools
}) {
  const response = await safeValidateUIMessages({
    messages,
    metadataSchema,
    dataSchemas,
    tools
  });
  if (!response.success)
    throw response.error;
  return response.data;
}

// src/agent/create-agent-ui-stream.ts
async function createAgentUIStream({
  agent,
  uiMessages,
  options,
  abortSignal,
  timeout,
  experimental_transform,
  ...uiMessageStreamOptions
}) {
  const validatedMessages = await validateUIMessages({
    messages: uiMessages,
    tools: agent.tools
  });
  const modelMessages = await convertToModelMessages(validatedMessages, {
    tools: agent.tools
  });
  const result = await agent.stream({
    prompt: modelMessages,
    options,
    abortSignal,
    timeout,
    experimental_transform
  });
  return result.toUIMessageStream(uiMessageStreamOptions);
}

// src/agent/create-agent-ui-stream-response.ts
async function createAgentUIStreamResponse({
  headers,
  status,
  statusText,
  consumeSseStream,
  ...options
}) {
  return createUIMessageStreamResponse({
    headers,
    status,
    statusText,
    consumeSseStream,
    stream: await createAgentUIStream(options)
  });
}

// src/agent/pipe-agent-ui-stream-to-response.ts
async function pipeAgentUIStreamToResponse({
  response,
  headers,
  status,
  statusText,
  consumeSseStream,
  ...options
}) {
  pipeUIMessageStreamToResponse({
    response,
    headers,
    status,
    statusText,
    consumeSseStream,
    stream: await createAgentUIStream(options)
  });
}

// src/embed/embed.ts
var import_provider_utils23 = require("@ai-sdk/provider-utils");
async function embed({
  model: modelArg,
  value,
  providerOptions,
  maxRetries: maxRetriesArg,
  abortSignal,
  headers,
  experimental_telemetry: telemetry
}) {
  const model = resolveEmbeddingModel(modelArg);
  const { maxRetries, retry } = prepareRetries({
    maxRetries: maxRetriesArg,
    abortSignal
  });
  const headersWithUserAgent = (0, import_provider_utils23.withUserAgentSuffix)(
    headers != null ? headers : {},
    `ai/${VERSION}`
  );
  const baseTelemetryAttributes = getBaseTelemetryAttributes({
    model,
    telemetry,
    headers: headersWithUserAgent,
    settings: { maxRetries }
  });
  const tracer = getTracer(telemetry);
  return recordSpan({
    name: "ai.embed",
    attributes: selectTelemetryAttributes({
      telemetry,
      attributes: {
        ...assembleOperationName({ operationId: "ai.embed", telemetry }),
        ...baseTelemetryAttributes,
        "ai.value": { input: () => JSON.stringify(value) }
      }
    }),
    tracer,
    fn: async (span) => {
      const { embedding, usage, warnings, response, providerMetadata } = await retry(
        () => (
          // nested spans to align with the embedMany telemetry data:
          recordSpan({
            name: "ai.embed.doEmbed",
            attributes: selectTelemetryAttributes({
              telemetry,
              attributes: {
                ...assembleOperationName({
                  operationId: "ai.embed.doEmbed",
                  telemetry
                }),
                ...baseTelemetryAttributes,
                // specific settings that only make sense on the outer level:
                "ai.values": { input: () => [JSON.stringify(value)] }
              }
            }),
            tracer,
            fn: async (doEmbedSpan) => {
              var _a16;
              const modelResponse = await model.doEmbed({
                values: [value],
                abortSignal,
                headers: headersWithUserAgent,
                providerOptions
              });
              const embedding2 = modelResponse.embeddings[0];
              const usage2 = (_a16 = modelResponse.usage) != null ? _a16 : { tokens: NaN };
              doEmbedSpan.setAttributes(
                await selectTelemetryAttributes({
                  telemetry,
                  attributes: {
                    "ai.embeddings": {
                      output: () => modelResponse.embeddings.map(
                        (embedding3) => JSON.stringify(embedding3)
                      )
                    },
                    "ai.usage.tokens": usage2.tokens
                  }
                })
              );
              return {
                embedding: embedding2,
                usage: usage2,
                warnings: modelResponse.warnings,
                providerMetadata: modelResponse.providerMetadata,
                response: modelResponse.response
              };
            }
          })
        )
      );
      span.setAttributes(
        await selectTelemetryAttributes({
          telemetry,
          attributes: {
            "ai.embedding": { output: () => JSON.stringify(embedding) },
            "ai.usage.tokens": usage.tokens
          }
        })
      );
      logWarnings({ warnings, provider: model.provider, model: model.modelId });
      return new DefaultEmbedResult({
        value,
        embedding,
        usage,
        warnings,
        providerMetadata,
        response
      });
    }
  });
}
var DefaultEmbedResult = class {
  constructor(options) {
    this.value = options.value;
    this.embedding = options.embedding;
    this.usage = options.usage;
    this.warnings = options.warnings;
    this.providerMetadata = options.providerMetadata;
    this.response = options.response;
  }
};

// src/embed/embed-many.ts
var import_provider_utils24 = require("@ai-sdk/provider-utils");

// src/util/split-array.ts
function splitArray(array2, chunkSize) {
  if (chunkSize <= 0) {
    throw new Error("chunkSize must be greater than 0");
  }
  const result = [];
  for (let i = 0; i < array2.length; i += chunkSize) {
    result.push(array2.slice(i, i + chunkSize));
  }
  return result;
}

// src/embed/embed-many.ts
async function embedMany({
  model: modelArg,
  values,
  maxParallelCalls = Infinity,
  maxRetries: maxRetriesArg,
  abortSignal,
  headers,
  providerOptions,
  experimental_telemetry: telemetry
}) {
  const model = resolveEmbeddingModel(modelArg);
  const { maxRetries, retry } = prepareRetries({
    maxRetries: maxRetriesArg,
    abortSignal
  });
  const headersWithUserAgent = (0, import_provider_utils24.withUserAgentSuffix)(
    headers != null ? headers : {},
    `ai/${VERSION}`
  );
  const baseTelemetryAttributes = getBaseTelemetryAttributes({
    model,
    telemetry,
    headers: headersWithUserAgent,
    settings: { maxRetries }
  });
  const tracer = getTracer(telemetry);
  return recordSpan({
    name: "ai.embedMany",
    attributes: selectTelemetryAttributes({
      telemetry,
      attributes: {
        ...assembleOperationName({ operationId: "ai.embedMany", telemetry }),
        ...baseTelemetryAttributes,
        // specific settings that only make sense on the outer level:
        "ai.values": {
          input: () => values.map((value) => JSON.stringify(value))
        }
      }
    }),
    tracer,
    fn: async (span) => {
      var _a16;
      const [maxEmbeddingsPerCall, supportsParallelCalls] = await Promise.all([
        model.maxEmbeddingsPerCall,
        model.supportsParallelCalls
      ]);
      if (maxEmbeddingsPerCall == null || maxEmbeddingsPerCall === Infinity) {
        const { embeddings: embeddings2, usage, warnings: warnings2, response, providerMetadata: providerMetadata2 } = await retry(() => {
          return recordSpan({
            name: "ai.embedMany.doEmbed",
            attributes: selectTelemetryAttributes({
              telemetry,
              attributes: {
                ...assembleOperationName({
                  operationId: "ai.embedMany.doEmbed",
                  telemetry
                }),
                ...baseTelemetryAttributes,
                // specific settings that only make sense on the outer level:
                "ai.values": {
                  input: () => values.map((value) => JSON.stringify(value))
                }
              }
            }),
            tracer,
            fn: async (doEmbedSpan) => {
              var _a17;
              const modelResponse = await model.doEmbed({
                values,
                abortSignal,
                headers: headersWithUserAgent,
                providerOptions
              });
              const embeddings3 = modelResponse.embeddings;
              const usage2 = (_a17 = modelResponse.usage) != null ? _a17 : { tokens: NaN };
              doEmbedSpan.setAttributes(
                await selectTelemetryAttributes({
                  telemetry,
                  attributes: {
                    "ai.embeddings": {
                      output: () => embeddings3.map(
                        (embedding) => JSON.stringify(embedding)
                      )
                    },
                    "ai.usage.tokens": usage2.tokens
                  }
                })
              );
              return {
                embeddings: embeddings3,
                usage: usage2,
                warnings: modelResponse.warnings,
                providerMetadata: modelResponse.providerMetadata,
                response: modelResponse.response
              };
            }
          });
        });
        span.setAttributes(
          await selectTelemetryAttributes({
            telemetry,
            attributes: {
              "ai.embeddings": {
                output: () => embeddings2.map((embedding) => JSON.stringify(embedding))
              },
              "ai.usage.tokens": usage.tokens
            }
          })
        );
        logWarnings({
          warnings: warnings2,
          provider: model.provider,
          model: model.modelId
        });
        return new DefaultEmbedManyResult({
          values,
          embeddings: embeddings2,
          usage,
          warnings: warnings2,
          providerMetadata: providerMetadata2,
          responses: [response]
        });
      }
      const valueChunks = splitArray(values, maxEmbeddingsPerCall);
      const embeddings = [];
      const warnings = [];
      const responses = [];
      let tokens = 0;
      let providerMetadata;
      const parallelChunks = splitArray(
        valueChunks,
        supportsParallelCalls ? maxParallelCalls : 1
      );
      for (const parallelChunk of parallelChunks) {
        const results = await Promise.all(
          parallelChunk.map((chunk) => {
            return retry(() => {
              return recordSpan({
                name: "ai.embedMany.doEmbed",
                attributes: selectTelemetryAttributes({
                  telemetry,
                  attributes: {
                    ...assembleOperationName({
                      operationId: "ai.embedMany.doEmbed",
                      telemetry
                    }),
                    ...baseTelemetryAttributes,
                    // specific settings that only make sense on the outer level:
                    "ai.values": {
                      input: () => chunk.map((value) => JSON.stringify(value))
                    }
                  }
                }),
                tracer,
                fn: async (doEmbedSpan) => {
                  var _a17;
                  const modelResponse = await model.doEmbed({
                    values: chunk,
                    abortSignal,
                    headers: headersWithUserAgent,
                    providerOptions
                  });
                  const embeddings2 = modelResponse.embeddings;
                  const usage = (_a17 = modelResponse.usage) != null ? _a17 : { tokens: NaN };
                  doEmbedSpan.setAttributes(
                    await selectTelemetryAttributes({
                      telemetry,
                      attributes: {
                        "ai.embeddings": {
                          output: () => embeddings2.map(
                            (embedding) => JSON.stringify(embedding)
                          )
                        },
                        "ai.usage.tokens": usage.tokens
                      }
                    })
                  );
                  return {
                    embeddings: embeddings2,
                    usage,
                    warnings: modelResponse.warnings,
                    providerMetadata: modelResponse.providerMetadata,
                    response: modelResponse.response
                  };
                }
              });
            });
          })
        );
        for (const result of results) {
          embeddings.push(...result.embeddings);
          warnings.push(...result.warnings);
          responses.push(result.response);
          tokens += result.usage.tokens;
          if (result.providerMetadata) {
            if (!providerMetadata) {
              providerMetadata = { ...result.providerMetadata };
            } else {
              for (const [providerName, metadata] of Object.entries(
                result.providerMetadata
              )) {
                providerMetadata[providerName] = {
                  ...(_a16 = providerMetadata[providerName]) != null ? _a16 : {},
                  ...metadata
                };
              }
            }
          }
        }
      }
      span.setAttributes(
        await selectTelemetryAttributes({
          telemetry,
          attributes: {
            "ai.embeddings": {
              output: () => embeddings.map((embedding) => JSON.stringify(embedding))
            },
            "ai.usage.tokens": tokens
          }
        })
      );
      logWarnings({
        warnings,
        provider: model.provider,
        model: model.modelId
      });
      return new DefaultEmbedManyResult({
        values,
        embeddings,
        usage: { tokens },
        warnings,
        providerMetadata,
        responses
      });
    }
  });
}
var DefaultEmbedManyResult = class {
  constructor(options) {
    this.values = options.values;
    this.embeddings = options.embeddings;
    this.usage = options.usage;
    this.warnings = options.warnings;
    this.providerMetadata = options.providerMetadata;
    this.responses = options.responses;
  }
};

// src/generate-image/generate-image.ts
var import_provider_utils25 = require("@ai-sdk/provider-utils");
async function generateImage({
  model: modelArg,
  prompt: promptArg,
  n = 1,
  maxImagesPerCall,
  size,
  aspectRatio,
  seed,
  providerOptions,
  maxRetries: maxRetriesArg,
  abortSignal,
  headers
}) {
  var _a16, _b;
  const model = resolveImageModel(modelArg);
  const headersWithUserAgent = (0, import_provider_utils25.withUserAgentSuffix)(
    headers != null ? headers : {},
    `ai/${VERSION}`
  );
  const { retry } = prepareRetries({
    maxRetries: maxRetriesArg,
    abortSignal
  });
  const maxImagesPerCallWithDefault = (_a16 = maxImagesPerCall != null ? maxImagesPerCall : await invokeModelMaxImagesPerCall(model)) != null ? _a16 : 1;
  const callCount = Math.ceil(n / maxImagesPerCallWithDefault);
  const callImageCounts = Array.from({ length: callCount }, (_, i) => {
    if (i < callCount - 1) {
      return maxImagesPerCallWithDefault;
    }
    const remainder = n % maxImagesPerCallWithDefault;
    return remainder === 0 ? maxImagesPerCallWithDefault : remainder;
  });
  const results = await Promise.all(
    callImageCounts.map(
      async (callImageCount) => retry(() => {
        const { prompt, files, mask } = normalizePrompt(promptArg);
        return model.doGenerate({
          prompt,
          files,
          mask,
          n: callImageCount,
          abortSignal,
          headers: headersWithUserAgent,
          size,
          aspectRatio,
          seed,
          providerOptions: providerOptions != null ? providerOptions : {}
        });
      })
    )
  );
  const images = [];
  const warnings = [];
  const responses = [];
  const providerMetadata = {};
  let totalUsage = {
    inputTokens: void 0,
    outputTokens: void 0,
    totalTokens: void 0
  };
  for (const result of results) {
    images.push(
      ...result.images.map(
        (image) => {
          var _a17;
          return new DefaultGeneratedFile({
            data: image,
            mediaType: (_a17 = detectMediaType({
              data: image,
              signatures: imageMediaTypeSignatures
            })) != null ? _a17 : "image/png"
          });
        }
      )
    );
    warnings.push(...result.warnings);
    if (result.usage != null) {
      totalUsage = addImageModelUsage(totalUsage, result.usage);
    }
    if (result.providerMetadata) {
      for (const [providerName, metadata] of Object.entries(result.providerMetadata)) {
        if (providerName === "gateway") {
          const currentEntry = providerMetadata[providerName];
          if (currentEntry != null && typeof currentEntry === "object") {
            providerMetadata[providerName] = {
              ...currentEntry,
              ...metadata
            };
          } else {
            providerMetadata[providerName] = metadata;
          }
          const imagesValue = providerMetadata[providerName].images;
          if (Array.isArray(imagesValue) && imagesValue.length === 0) {
            delete providerMetadata[providerName].images;
          }
        } else {
          (_b = providerMetadata[providerName]) != null ? _b : providerMetadata[providerName] = { images: [] };
          providerMetadata[providerName].images.push(
            ...result.providerMetadata[providerName].images
          );
        }
      }
    }
    responses.push(result.response);
  }
  logWarnings({ warnings, provider: model.provider, model: model.modelId });
  if (!images.length) {
    throw new NoImageGeneratedError({ responses });
  }
  return new DefaultGenerateImageResult({
    images,
    warnings,
    responses,
    providerMetadata,
    usage: totalUsage
  });
}
var DefaultGenerateImageResult = class {
  constructor(options) {
    this.images = options.images;
    this.warnings = options.warnings;
    this.responses = options.responses;
    this.providerMetadata = options.providerMetadata;
    this.usage = options.usage;
  }
  get image() {
    return this.images[0];
  }
};
async function invokeModelMaxImagesPerCall(model) {
  const isFunction = model.maxImagesPerCall instanceof Function;
  if (!isFunction) {
    return model.maxImagesPerCall;
  }
  return model.maxImagesPerCall({
    modelId: model.modelId
  });
}
function normalizePrompt(prompt) {
  if (typeof prompt === "string") {
    return { prompt, files: void 0, mask: void 0 };
  }
  return {
    prompt: prompt.text,
    files: prompt.images.map(toImageModelV3File),
    mask: prompt.mask ? toImageModelV3File(prompt.mask) : void 0
  };
}
function toImageModelV3File(dataContent) {
  if (typeof dataContent === "string" && dataContent.startsWith("http")) {
    return {
      type: "url",
      url: dataContent
    };
  }
  if (typeof dataContent === "string" && dataContent.startsWith("data:")) {
    const { mediaType: dataUrlMediaType, base64Content } = splitDataUrl(dataContent);
    if (base64Content != null) {
      const uint8Data2 = (0, import_provider_utils25.convertBase64ToUint8Array)(base64Content);
      return {
        type: "file",
        data: uint8Data2,
        mediaType: dataUrlMediaType || detectMediaType({
          data: uint8Data2,
          signatures: imageMediaTypeSignatures
        }) || "image/png"
      };
    }
  }
  const uint8Data = convertDataContentToUint8Array(dataContent);
  return {
    type: "file",
    data: uint8Data,
    mediaType: detectMediaType({
      data: uint8Data,
      signatures: imageMediaTypeSignatures
    }) || "image/png"
  };
}

// src/generate-image/index.ts
var experimental_generateImage = generateImage;

// src/generate-object/generate-object.ts
var import_provider_utils28 = require("@ai-sdk/provider-utils");

// src/generate-text/extract-reasoning-content.ts
function extractReasoningContent(content) {
  const parts = content.filter(
    (content2) => content2.type === "reasoning"
  );
  return parts.length === 0 ? void 0 : parts.map((content2) => content2.text).join("\n");
}

// src/generate-object/output-strategy.ts
var import_provider26 = require("@ai-sdk/provider");
var import_provider_utils26 = require("@ai-sdk/provider-utils");
var noSchemaOutputStrategy = {
  type: "no-schema",
  jsonSchema: async () => void 0,
  async validatePartialResult({ value, textDelta }) {
    return { success: true, value: { partial: value, textDelta } };
  },
  async validateFinalResult(value, context) {
    return value === void 0 ? {
      success: false,
      error: new NoObjectGeneratedError({
        message: "No object generated: response did not match schema.",
        text: context.text,
        response: context.response,
        usage: context.usage,
        finishReason: context.finishReason
      })
    } : { success: true, value };
  },
  createElementStream() {
    throw new import_provider26.UnsupportedFunctionalityError({
      functionality: "element streams in no-schema mode"
    });
  }
};
var objectOutputStrategy = (schema) => ({
  type: "object",
  jsonSchema: async () => await schema.jsonSchema,
  async validatePartialResult({ value, textDelta }) {
    return {
      success: true,
      value: {
        // Note: currently no validation of partial results:
        partial: value,
        textDelta
      }
    };
  },
  async validateFinalResult(value) {
    return (0, import_provider_utils26.safeValidateTypes)({ value, schema });
  },
  createElementStream() {
    throw new import_provider26.UnsupportedFunctionalityError({
      functionality: "element streams in object mode"
    });
  }
});
var arrayOutputStrategy = (schema) => {
  return {
    type: "array",
    // wrap in object that contains array of elements, since most LLMs will not
    // be able to generate an array directly:
    // possible future optimization: use arrays directly when model supports grammar-guided generation
    jsonSchema: async () => {
      const { $schema, ...itemSchema } = await schema.jsonSchema;
      return {
        $schema: "http://json-schema.org/draft-07/schema#",
        type: "object",
        properties: {
          elements: { type: "array", items: itemSchema }
        },
        required: ["elements"],
        additionalProperties: false
      };
    },
    async validatePartialResult({
      value,
      latestObject,
      isFirstDelta,
      isFinalDelta
    }) {
      var _a16;
      if (!(0, import_provider26.isJSONObject)(value) || !(0, import_provider26.isJSONArray)(value.elements)) {
        return {
          success: false,
          error: new import_provider26.TypeValidationError({
            value,
            cause: "value must be an object that contains an array of elements"
          })
        };
      }
      const inputArray = value.elements;
      const resultArray = [];
      for (let i = 0; i < inputArray.length; i++) {
        const element = inputArray[i];
        const result = await (0, import_provider_utils26.safeValidateTypes)({ value: element, schema });
        if (i === inputArray.length - 1 && !isFinalDelta) {
          continue;
        }
        if (!result.success) {
          return result;
        }
        resultArray.push(result.value);
      }
      const publishedElementCount = (_a16 = latestObject == null ? void 0 : latestObject.length) != null ? _a16 : 0;
      let textDelta = "";
      if (isFirstDelta) {
        textDelta += "[";
      }
      if (publishedElementCount > 0) {
        textDelta += ",";
      }
      textDelta += resultArray.slice(publishedElementCount).map((element) => JSON.stringify(element)).join(",");
      if (isFinalDelta) {
        textDelta += "]";
      }
      return {
        success: true,
        value: {
          partial: resultArray,
          textDelta
        }
      };
    },
    async validateFinalResult(value) {
      if (!(0, import_provider26.isJSONObject)(value) || !(0, import_provider26.isJSONArray)(value.elements)) {
        return {
          success: false,
          error: new import_provider26.TypeValidationError({
            value,
            cause: "value must be an object that contains an array of elements"
          })
        };
      }
      const inputArray = value.elements;
      for (const element of inputArray) {
        const result = await (0, import_provider_utils26.safeValidateTypes)({ value: element, schema });
        if (!result.success) {
          return result;
        }
      }
      return { success: true, value: inputArray };
    },
    createElementStream(originalStream) {
      let publishedElements = 0;
      return createAsyncIterableStream(
        originalStream.pipeThrough(
          new TransformStream({
            transform(chunk, controller) {
              switch (chunk.type) {
                case "object": {
                  const array2 = chunk.object;
                  for (; publishedElements < array2.length; publishedElements++) {
                    controller.enqueue(array2[publishedElements]);
                  }
                  break;
                }
                case "text-delta":
                case "finish":
                case "error":
                  break;
                default: {
                  const _exhaustiveCheck = chunk;
                  throw new Error(
                    `Unsupported chunk type: ${_exhaustiveCheck}`
                  );
                }
              }
            }
          })
        )
      );
    }
  };
};
var enumOutputStrategy = (enumValues) => {
  return {
    type: "enum",
    // wrap in object that contains result, since most LLMs will not
    // be able to generate an enum value directly:
    // possible future optimization: use enums directly when model supports top-level enums
    jsonSchema: async () => ({
      $schema: "http://json-schema.org/draft-07/schema#",
      type: "object",
      properties: {
        result: { type: "string", enum: enumValues }
      },
      required: ["result"],
      additionalProperties: false
    }),
    async validateFinalResult(value) {
      if (!(0, import_provider26.isJSONObject)(value) || typeof value.result !== "string") {
        return {
          success: false,
          error: new import_provider26.TypeValidationError({
            value,
            cause: 'value must be an object that contains a string in the "result" property.'
          })
        };
      }
      const result = value.result;
      return enumValues.includes(result) ? { success: true, value: result } : {
        success: false,
        error: new import_provider26.TypeValidationError({
          value,
          cause: "value must be a string in the enum"
        })
      };
    },
    async validatePartialResult({ value, textDelta }) {
      if (!(0, import_provider26.isJSONObject)(value) || typeof value.result !== "string") {
        return {
          success: false,
          error: new import_provider26.TypeValidationError({
            value,
            cause: 'value must be an object that contains a string in the "result" property.'
          })
        };
      }
      const result = value.result;
      const possibleEnumValues = enumValues.filter(
        (enumValue) => enumValue.startsWith(result)
      );
      if (value.result.length === 0 || possibleEnumValues.length === 0) {
        return {
          success: false,
          error: new import_provider26.TypeValidationError({
            value,
            cause: "value must be a string in the enum"
          })
        };
      }
      return {
        success: true,
        value: {
          partial: possibleEnumValues.length > 1 ? result : possibleEnumValues[0],
          textDelta
        }
      };
    },
    createElementStream() {
      throw new import_provider26.UnsupportedFunctionalityError({
        functionality: "element streams in enum mode"
      });
    }
  };
};
function getOutputStrategy({
  output,
  schema,
  enumValues
}) {
  switch (output) {
    case "object":
      return objectOutputStrategy((0, import_provider_utils26.asSchema)(schema));
    case "array":
      return arrayOutputStrategy((0, import_provider_utils26.asSchema)(schema));
    case "enum":
      return enumOutputStrategy(enumValues);
    case "no-schema":
      return noSchemaOutputStrategy;
    default: {
      const _exhaustiveCheck = output;
      throw new Error(`Unsupported output: ${_exhaustiveCheck}`);
    }
  }
}

// src/generate-object/parse-and-validate-object-result.ts
var import_provider27 = require("@ai-sdk/provider");
var import_provider_utils27 = require("@ai-sdk/provider-utils");
async function parseAndValidateObjectResult(result, outputStrategy, context) {
  const parseResult = await (0, import_provider_utils27.safeParseJSON)({ text: result });
  if (!parseResult.success) {
    throw new NoObjectGeneratedError({
      message: "No object generated: could not parse the response.",
      cause: parseResult.error,
      text: result,
      response: context.response,
      usage: context.usage,
      finishReason: context.finishReason
    });
  }
  const validationResult = await outputStrategy.validateFinalResult(
    parseResult.value,
    {
      text: result,
      response: context.response,
      usage: context.usage
    }
  );
  if (!validationResult.success) {
    throw new NoObjectGeneratedError({
      message: "No object generated: response did not match schema.",
      cause: validationResult.error,
      text: result,
      response: context.response,
      usage: context.usage,
      finishReason: context.finishReason
    });
  }
  return validationResult.value;
}
async function parseAndValidateObjectResultWithRepair(result, outputStrategy, repairText, context) {
  try {
    return await parseAndValidateObjectResult(result, outputStrategy, context);
  } catch (error) {
    if (repairText != null && NoObjectGeneratedError.isInstance(error) && (import_provider27.JSONParseError.isInstance(error.cause) || import_provider27.TypeValidationError.isInstance(error.cause))) {
      const repairedText = await repairText({
        text: result,
        error: error.cause
      });
      if (repairedText === null) {
        throw error;
      }
      return await parseAndValidateObjectResult(
        repairedText,
        outputStrategy,
        context
      );
    }
    throw error;
  }
}

// src/generate-object/validate-object-generation-input.ts
function validateObjectGenerationInput({
  output,
  schema,
  schemaName,
  schemaDescription,
  enumValues
}) {
  if (output != null && output !== "object" && output !== "array" && output !== "enum" && output !== "no-schema") {
    throw new InvalidArgumentError({
      parameter: "output",
      value: output,
      message: "Invalid output type."
    });
  }
  if (output === "no-schema") {
    if (schema != null) {
      throw new InvalidArgumentError({
        parameter: "schema",
        value: schema,
        message: "Schema is not supported for no-schema output."
      });
    }
    if (schemaDescription != null) {
      throw new InvalidArgumentError({
        parameter: "schemaDescription",
        value: schemaDescription,
        message: "Schema description is not supported for no-schema output."
      });
    }
    if (schemaName != null) {
      throw new InvalidArgumentError({
        parameter: "schemaName",
        value: schemaName,
        message: "Schema name is not supported for no-schema output."
      });
    }
    if (enumValues != null) {
      throw new InvalidArgumentError({
        parameter: "enumValues",
        value: enumValues,
        message: "Enum values are not supported for no-schema output."
      });
    }
  }
  if (output === "object") {
    if (schema == null) {
      throw new InvalidArgumentError({
        parameter: "schema",
        value: schema,
        message: "Schema is required for object output."
      });
    }
    if (enumValues != null) {
      throw new InvalidArgumentError({
        parameter: "enumValues",
        value: enumValues,
        message: "Enum values are not supported for object output."
      });
    }
  }
  if (output === "array") {
    if (schema == null) {
      throw new InvalidArgumentError({
        parameter: "schema",
        value: schema,
        message: "Element schema is required for array output."
      });
    }
    if (enumValues != null) {
      throw new InvalidArgumentError({
        parameter: "enumValues",
        value: enumValues,
        message: "Enum values are not supported for array output."
      });
    }
  }
  if (output === "enum") {
    if (schema != null) {
      throw new InvalidArgumentError({
        parameter: "schema",
        value: schema,
        message: "Schema is not supported for enum output."
      });
    }
    if (schemaDescription != null) {
      throw new InvalidArgumentError({
        parameter: "schemaDescription",
        value: schemaDescription,
        message: "Schema description is not supported for enum output."
      });
    }
    if (schemaName != null) {
      throw new InvalidArgumentError({
        parameter: "schemaName",
        value: schemaName,
        message: "Schema name is not supported for enum output."
      });
    }
    if (enumValues == null) {
      throw new InvalidArgumentError({
        parameter: "enumValues",
        value: enumValues,
        message: "Enum values are required for enum output."
      });
    }
    for (const value of enumValues) {
      if (typeof value !== "string") {
        throw new InvalidArgumentError({
          parameter: "enumValues",
          value,
          message: "Enum values must be strings."
        });
      }
    }
  }
}

// src/generate-object/generate-object.ts
var originalGenerateId3 = (0, import_provider_utils28.createIdGenerator)({ prefix: "aiobj", size: 24 });
async function generateObject(options) {
  const {
    model: modelArg,
    output = "object",
    system,
    prompt,
    messages,
    maxRetries: maxRetriesArg,
    abortSignal,
    headers,
    experimental_repairText: repairText,
    experimental_telemetry: telemetry,
    experimental_download: download2,
    providerOptions,
    _internal: {
      generateId: generateId2 = originalGenerateId3,
      currentDate = () => /* @__PURE__ */ new Date()
    } = {},
    ...settings
  } = options;
  const model = resolveLanguageModel(modelArg);
  const enumValues = "enum" in options ? options.enum : void 0;
  const {
    schema: inputSchema,
    schemaDescription,
    schemaName
  } = "schema" in options ? options : {};
  validateObjectGenerationInput({
    output,
    schema: inputSchema,
    schemaName,
    schemaDescription,
    enumValues
  });
  const { maxRetries, retry } = prepareRetries({
    maxRetries: maxRetriesArg,
    abortSignal
  });
  const outputStrategy = getOutputStrategy({
    output,
    schema: inputSchema,
    enumValues
  });
  const callSettings = prepareCallSettings(settings);
  const headersWithUserAgent = (0, import_provider_utils28.withUserAgentSuffix)(
    headers != null ? headers : {},
    `ai/${VERSION}`
  );
  const baseTelemetryAttributes = getBaseTelemetryAttributes({
    model,
    telemetry,
    headers: headersWithUserAgent,
    settings: { ...callSettings, maxRetries }
  });
  const tracer = getTracer(telemetry);
  const jsonSchema2 = await outputStrategy.jsonSchema();
  try {
    return await recordSpan({
      name: "ai.generateObject",
      attributes: selectTelemetryAttributes({
        telemetry,
        attributes: {
          ...assembleOperationName({
            operationId: "ai.generateObject",
            telemetry
          }),
          ...baseTelemetryAttributes,
          // specific settings that only make sense on the outer level:
          "ai.prompt": {
            input: () => JSON.stringify({ system, prompt, messages })
          },
          "ai.schema": jsonSchema2 != null ? { input: () => JSON.stringify(jsonSchema2) } : void 0,
          "ai.schema.name": schemaName,
          "ai.schema.description": schemaDescription,
          "ai.settings.output": outputStrategy.type
        }
      }),
      tracer,
      fn: async (span) => {
        var _a16;
        let result;
        let finishReason;
        let usage;
        let warnings;
        let response;
        let request;
        let resultProviderMetadata;
        let reasoning;
        const standardizedPrompt = await standardizePrompt({
          system,
          prompt,
          messages
        });
        const promptMessages = await convertToLanguageModelPrompt({
          prompt: standardizedPrompt,
          supportedUrls: await model.supportedUrls,
          download: download2
        });
        const generateResult = await retry(
          () => recordSpan({
            name: "ai.generateObject.doGenerate",
            attributes: selectTelemetryAttributes({
              telemetry,
              attributes: {
                ...assembleOperationName({
                  operationId: "ai.generateObject.doGenerate",
                  telemetry
                }),
                ...baseTelemetryAttributes,
                "ai.prompt.messages": {
                  input: () => stringifyForTelemetry(promptMessages)
                },
                // standardized gen-ai llm span attributes:
                "gen_ai.system": model.provider,
                "gen_ai.request.model": model.modelId,
                "gen_ai.request.frequency_penalty": callSettings.frequencyPenalty,
                "gen_ai.request.max_tokens": callSettings.maxOutputTokens,
                "gen_ai.request.presence_penalty": callSettings.presencePenalty,
                "gen_ai.request.temperature": callSettings.temperature,
                "gen_ai.request.top_k": callSettings.topK,
                "gen_ai.request.top_p": callSettings.topP
              }
            }),
            tracer,
            fn: async (span2) => {
              var _a17, _b, _c, _d, _e, _f, _g, _h;
              const result2 = await model.doGenerate({
                responseFormat: {
                  type: "json",
                  schema: jsonSchema2,
                  name: schemaName,
                  description: schemaDescription
                },
                ...prepareCallSettings(settings),
                prompt: promptMessages,
                providerOptions,
                abortSignal,
                headers: headersWithUserAgent
              });
              const responseData = {
                id: (_b = (_a17 = result2.response) == null ? void 0 : _a17.id) != null ? _b : generateId2(),
                timestamp: (_d = (_c = result2.response) == null ? void 0 : _c.timestamp) != null ? _d : currentDate(),
                modelId: (_f = (_e = result2.response) == null ? void 0 : _e.modelId) != null ? _f : model.modelId,
                headers: (_g = result2.response) == null ? void 0 : _g.headers,
                body: (_h = result2.response) == null ? void 0 : _h.body
              };
              const text2 = extractTextContent(result2.content);
              const reasoning2 = extractReasoningContent(result2.content);
              if (text2 === void 0) {
                throw new NoObjectGeneratedError({
                  message: "No object generated: the model did not return a response.",
                  response: responseData,
                  usage: asLanguageModelUsage(result2.usage),
                  finishReason: result2.finishReason.unified
                });
              }
              span2.setAttributes(
                await selectTelemetryAttributes({
                  telemetry,
                  attributes: {
                    "ai.response.finishReason": result2.finishReason.unified,
                    "ai.response.object": { output: () => text2 },
                    "ai.response.id": responseData.id,
                    "ai.response.model": responseData.modelId,
                    "ai.response.timestamp": responseData.timestamp.toISOString(),
                    "ai.response.providerMetadata": JSON.stringify(
                      result2.providerMetadata
                    ),
                    // TODO rename telemetry attributes to inputTokens and outputTokens
                    "ai.usage.promptTokens": result2.usage.inputTokens.total,
                    "ai.usage.completionTokens": result2.usage.outputTokens.total,
                    // standardized gen-ai llm span attributes:
                    "gen_ai.response.finish_reasons": [
                      result2.finishReason.unified
                    ],
                    "gen_ai.response.id": responseData.id,
                    "gen_ai.response.model": responseData.modelId,
                    "gen_ai.usage.input_tokens": result2.usage.inputTokens.total,
                    "gen_ai.usage.output_tokens": result2.usage.outputTokens.total
                  }
                })
              );
              return {
                ...result2,
                objectText: text2,
                reasoning: reasoning2,
                responseData
              };
            }
          })
        );
        result = generateResult.objectText;
        finishReason = generateResult.finishReason.unified;
        usage = asLanguageModelUsage(generateResult.usage);
        warnings = generateResult.warnings;
        resultProviderMetadata = generateResult.providerMetadata;
        request = (_a16 = generateResult.request) != null ? _a16 : {};
        response = generateResult.responseData;
        reasoning = generateResult.reasoning;
        logWarnings({
          warnings,
          provider: model.provider,
          model: model.modelId
        });
        const object2 = await parseAndValidateObjectResultWithRepair(
          result,
          outputStrategy,
          repairText,
          {
            response,
            usage,
            finishReason
          }
        );
        span.setAttributes(
          await selectTelemetryAttributes({
            telemetry,
            attributes: {
              "ai.response.finishReason": finishReason,
              "ai.response.object": {
                output: () => JSON.stringify(object2)
              },
              "ai.response.providerMetadata": JSON.stringify(
                resultProviderMetadata
              ),
              // TODO rename telemetry attributes to inputTokens and outputTokens
              "ai.usage.promptTokens": usage.inputTokens,
              "ai.usage.completionTokens": usage.outputTokens
            }
          })
        );
        return new DefaultGenerateObjectResult({
          object: object2,
          reasoning,
          finishReason,
          usage,
          warnings,
          request,
          response,
          providerMetadata: resultProviderMetadata
        });
      }
    });
  } catch (error) {
    throw wrapGatewayError(error);
  }
}
var DefaultGenerateObjectResult = class {
  constructor(options) {
    this.object = options.object;
    this.finishReason = options.finishReason;
    this.usage = options.usage;
    this.warnings = options.warnings;
    this.providerMetadata = options.providerMetadata;
    this.response = options.response;
    this.request = options.request;
    this.reasoning = options.reasoning;
  }
  toJsonResponse(init) {
    var _a16;
    return new Response(JSON.stringify(this.object), {
      status: (_a16 = init == null ? void 0 : init.status) != null ? _a16 : 200,
      headers: prepareHeaders(init == null ? void 0 : init.headers, {
        "content-type": "application/json; charset=utf-8"
      })
    });
  }
};

// src/generate-object/stream-object.ts
var import_provider_utils30 = require("@ai-sdk/provider-utils");

// src/util/cosine-similarity.ts
function cosineSimilarity(vector1, vector2) {
  if (vector1.length !== vector2.length) {
    throw new InvalidArgumentError({
      parameter: "vector1,vector2",
      value: { vector1Length: vector1.length, vector2Length: vector2.length },
      message: `Vectors must have the same length`
    });
  }
  const n = vector1.length;
  if (n === 0) {
    return 0;
  }
  let magnitudeSquared1 = 0;
  let magnitudeSquared2 = 0;
  let dotProduct = 0;
  for (let i = 0; i < n; i++) {
    const value1 = vector1[i];
    const value2 = vector2[i];
    magnitudeSquared1 += value1 * value1;
    magnitudeSquared2 += value2 * value2;
    dotProduct += value1 * value2;
  }
  return magnitudeSquared1 === 0 || magnitudeSquared2 === 0 ? 0 : dotProduct / (Math.sqrt(magnitudeSquared1) * Math.sqrt(magnitudeSquared2));
}

// src/util/data-url.ts
function getTextFromDataUrl(dataUrl) {
  const [header, base64Content] = dataUrl.split(",");
  const mediaType = header.split(";")[0].split(":")[1];
  if (mediaType == null || base64Content == null) {
    throw new Error("Invalid data URL format");
  }
  try {
    return window.atob(base64Content);
  } catch (error) {
    throw new Error(`Error decoding data URL`);
  }
}

// src/util/is-deep-equal-data.ts
function isDeepEqualData(obj1, obj2) {
  if (obj1 === obj2)
    return true;
  if (obj1 == null || obj2 == null)
    return false;
  if (typeof obj1 !== "object" && typeof obj2 !== "object")
    return obj1 === obj2;
  if (obj1.constructor !== obj2.constructor)
    return false;
  if (obj1 instanceof Date && obj2 instanceof Date) {
    return obj1.getTime() === obj2.getTime();
  }
  if (Array.isArray(obj1)) {
    if (obj1.length !== obj2.length)
      return false;
    for (let i = 0; i < obj1.length; i++) {
      if (!isDeepEqualData(obj1[i], obj2[i]))
        return false;
    }
    return true;
  }
  const keys1 = Object.keys(obj1);
  const keys2 = Object.keys(obj2);
  if (keys1.length !== keys2.length)
    return false;
  for (const key of keys1) {
    if (!keys2.includes(key))
      return false;
    if (!isDeepEqualData(obj1[key], obj2[key]))
      return false;
  }
  return true;
}

// src/util/serial-job-executor.ts
var SerialJobExecutor = class {
  constructor() {
    this.queue = [];
    this.isProcessing = false;
  }
  async processQueue() {
    if (this.isProcessing) {
      return;
    }
    this.isProcessing = true;
    while (this.queue.length > 0) {
      await this.queue[0]();
      this.queue.shift();
    }
    this.isProcessing = false;
  }
  async run(job) {
    return new Promise((resolve3, reject) => {
      this.queue.push(async () => {
        try {
          await job();
          resolve3();
        } catch (error) {
          reject(error);
        }
      });
      void this.processQueue();
    });
  }
};

// src/util/simulate-readable-stream.ts
var import_provider_utils29 = require("@ai-sdk/provider-utils");
function simulateReadableStream({
  chunks,
  initialDelayInMs = 0,
  chunkDelayInMs = 0,
  _internal
}) {
  var _a16;
  const delay2 = (_a16 = _internal == null ? void 0 : _internal.delay) != null ? _a16 : import_provider_utils29.delay;
  let index = 0;
  return new ReadableStream({
    async pull(controller) {
      if (index < chunks.length) {
        await delay2(index === 0 ? initialDelayInMs : chunkDelayInMs);
        controller.enqueue(chunks[index++]);
      } else {
        controller.close();
      }
    }
  });
}

// src/generate-object/stream-object.ts
var originalGenerateId4 = (0, import_provider_utils30.createIdGenerator)({ prefix: "aiobj", size: 24 });
function streamObject(options) {
  const {
    model,
    output = "object",
    system,
    prompt,
    messages,
    maxRetries,
    abortSignal,
    headers,
    experimental_repairText: repairText,
    experimental_telemetry: telemetry,
    experimental_download: download2,
    providerOptions,
    onError = ({ error }) => {
      console.error(error);
    },
    onFinish,
    _internal: {
      generateId: generateId2 = originalGenerateId4,
      currentDate = () => /* @__PURE__ */ new Date(),
      now: now2 = now
    } = {},
    ...settings
  } = options;
  const enumValues = "enum" in options && options.enum ? options.enum : void 0;
  const {
    schema: inputSchema,
    schemaDescription,
    schemaName
  } = "schema" in options ? options : {};
  validateObjectGenerationInput({
    output,
    schema: inputSchema,
    schemaName,
    schemaDescription,
    enumValues
  });
  const outputStrategy = getOutputStrategy({
    output,
    schema: inputSchema,
    enumValues
  });
  return new DefaultStreamObjectResult({
    model,
    telemetry,
    headers,
    settings,
    maxRetries,
    abortSignal,
    outputStrategy,
    system,
    prompt,
    messages,
    schemaName,
    schemaDescription,
    providerOptions,
    repairText,
    onError,
    onFinish,
    download: download2,
    generateId: generateId2,
    currentDate,
    now: now2
  });
}
var DefaultStreamObjectResult = class {
  constructor({
    model: modelArg,
    headers,
    telemetry,
    settings,
    maxRetries: maxRetriesArg,
    abortSignal,
    outputStrategy,
    system,
    prompt,
    messages,
    schemaName,
    schemaDescription,
    providerOptions,
    repairText,
    onError,
    onFinish,
    download: download2,
    generateId: generateId2,
    currentDate,
    now: now2
  }) {
    this._object = new import_provider_utils30.DelayedPromise();
    this._usage = new import_provider_utils30.DelayedPromise();
    this._providerMetadata = new import_provider_utils30.DelayedPromise();
    this._warnings = new import_provider_utils30.DelayedPromise();
    this._request = new import_provider_utils30.DelayedPromise();
    this._response = new import_provider_utils30.DelayedPromise();
    this._finishReason = new import_provider_utils30.DelayedPromise();
    const model = resolveLanguageModel(modelArg);
    const { maxRetries, retry } = prepareRetries({
      maxRetries: maxRetriesArg,
      abortSignal
    });
    const callSettings = prepareCallSettings(settings);
    const baseTelemetryAttributes = getBaseTelemetryAttributes({
      model,
      telemetry,
      headers,
      settings: { ...callSettings, maxRetries }
    });
    const tracer = getTracer(telemetry);
    const self = this;
    const stitchableStream = createStitchableStream();
    const eventProcessor = new TransformStream({
      transform(chunk, controller) {
        controller.enqueue(chunk);
        if (chunk.type === "error") {
          onError({ error: wrapGatewayError(chunk.error) });
        }
      }
    });
    this.baseStream = stitchableStream.stream.pipeThrough(eventProcessor);
    recordSpan({
      name: "ai.streamObject",
      attributes: selectTelemetryAttributes({
        telemetry,
        attributes: {
          ...assembleOperationName({
            operationId: "ai.streamObject",
            telemetry
          }),
          ...baseTelemetryAttributes,
          // specific settings that only make sense on the outer level:
          "ai.prompt": {
            input: () => JSON.stringify({ system, prompt, messages })
          },
          "ai.schema": {
            input: async () => JSON.stringify(await outputStrategy.jsonSchema())
          },
          "ai.schema.name": schemaName,
          "ai.schema.description": schemaDescription,
          "ai.settings.output": outputStrategy.type
        }
      }),
      tracer,
      endWhenDone: false,
      fn: async (rootSpan) => {
        const standardizedPrompt = await standardizePrompt({
          system,
          prompt,
          messages
        });
        const callOptions = {
          responseFormat: {
            type: "json",
            schema: await outputStrategy.jsonSchema(),
            name: schemaName,
            description: schemaDescription
          },
          ...prepareCallSettings(settings),
          prompt: await convertToLanguageModelPrompt({
            prompt: standardizedPrompt,
            supportedUrls: await model.supportedUrls,
            download: download2
          }),
          providerOptions,
          abortSignal,
          headers,
          includeRawChunks: false
        };
        const transformer = {
          transform: (chunk, controller) => {
            switch (chunk.type) {
              case "text-delta":
                controller.enqueue(chunk.delta);
                break;
              case "response-metadata":
              case "finish":
              case "error":
              case "stream-start":
                controller.enqueue(chunk);
                break;
            }
          }
        };
        const {
          result: { stream, response, request },
          doStreamSpan,
          startTimestampMs
        } = await retry(
          () => recordSpan({
            name: "ai.streamObject.doStream",
            attributes: selectTelemetryAttributes({
              telemetry,
              attributes: {
                ...assembleOperationName({
                  operationId: "ai.streamObject.doStream",
                  telemetry
                }),
                ...baseTelemetryAttributes,
                "ai.prompt.messages": {
                  input: () => stringifyForTelemetry(callOptions.prompt)
                },
                // standardized gen-ai llm span attributes:
                "gen_ai.system": model.provider,
                "gen_ai.request.model": model.modelId,
                "gen_ai.request.frequency_penalty": callSettings.frequencyPenalty,
                "gen_ai.request.max_tokens": callSettings.maxOutputTokens,
                "gen_ai.request.presence_penalty": callSettings.presencePenalty,
                "gen_ai.request.temperature": callSettings.temperature,
                "gen_ai.request.top_k": callSettings.topK,
                "gen_ai.request.top_p": callSettings.topP
              }
            }),
            tracer,
            endWhenDone: false,
            fn: async (doStreamSpan2) => ({
              startTimestampMs: now2(),
              doStreamSpan: doStreamSpan2,
              result: await model.doStream(callOptions)
            })
          })
        );
        self._request.resolve(request != null ? request : {});
        let warnings;
        let usage = createNullLanguageModelUsage();
        let finishReason;
        let providerMetadata;
        let object2;
        let error;
        let accumulatedText = "";
        let textDelta = "";
        let fullResponse = {
          id: generateId2(),
          timestamp: currentDate(),
          modelId: model.modelId
        };
        let latestObjectJson = void 0;
        let latestObject = void 0;
        let isFirstChunk = true;
        let isFirstDelta = true;
        const transformedStream = stream.pipeThrough(new TransformStream(transformer)).pipeThrough(
          new TransformStream({
            async transform(chunk, controller) {
              var _a16, _b, _c;
              if (typeof chunk === "object" && chunk.type === "stream-start") {
                warnings = chunk.warnings;
                return;
              }
              if (isFirstChunk) {
                const msToFirstChunk = now2() - startTimestampMs;
                isFirstChunk = false;
                doStreamSpan.addEvent("ai.stream.firstChunk", {
                  "ai.stream.msToFirstChunk": msToFirstChunk
                });
                doStreamSpan.setAttributes({
                  "ai.stream.msToFirstChunk": msToFirstChunk
                });
              }
              if (typeof chunk === "string") {
                accumulatedText += chunk;
                textDelta += chunk;
                const { value: currentObjectJson, state: parseState } = await parsePartialJson(accumulatedText);
                if (currentObjectJson !== void 0 && !isDeepEqualData(latestObjectJson, currentObjectJson)) {
                  const validationResult = await outputStrategy.validatePartialResult({
                    value: currentObjectJson,
                    textDelta,
                    latestObject,
                    isFirstDelta,
                    isFinalDelta: parseState === "successful-parse"
                  });
                  if (validationResult.success && !isDeepEqualData(
                    latestObject,
                    validationResult.value.partial
                  )) {
                    latestObjectJson = currentObjectJson;
                    latestObject = validationResult.value.partial;
                    controller.enqueue({
                      type: "object",
                      object: latestObject
                    });
                    controller.enqueue({
                      type: "text-delta",
                      textDelta: validationResult.value.textDelta
                    });
                    textDelta = "";
                    isFirstDelta = false;
                  }
                }
                return;
              }
              switch (chunk.type) {
                case "response-metadata": {
                  fullResponse = {
                    id: (_a16 = chunk.id) != null ? _a16 : fullResponse.id,
                    timestamp: (_b = chunk.timestamp) != null ? _b : fullResponse.timestamp,
                    modelId: (_c = chunk.modelId) != null ? _c : fullResponse.modelId
                  };
                  break;
                }
                case "finish": {
                  if (textDelta !== "") {
                    controller.enqueue({ type: "text-delta", textDelta });
                  }
                  finishReason = chunk.finishReason.unified;
                  usage = asLanguageModelUsage(chunk.usage);
                  providerMetadata = chunk.providerMetadata;
                  controller.enqueue({
                    ...chunk,
                    finishReason: chunk.finishReason.unified,
                    usage,
                    response: fullResponse
                  });
                  logWarnings({
                    warnings: warnings != null ? warnings : [],
                    provider: model.provider,
                    model: model.modelId
                  });
                  self._usage.resolve(usage);
                  self._providerMetadata.resolve(providerMetadata);
                  self._warnings.resolve(warnings);
                  self._response.resolve({
                    ...fullResponse,
                    headers: response == null ? void 0 : response.headers
                  });
                  self._finishReason.resolve(finishReason != null ? finishReason : "other");
                  try {
                    object2 = await parseAndValidateObjectResultWithRepair(
                      accumulatedText,
                      outputStrategy,
                      repairText,
                      {
                        response: fullResponse,
                        usage,
                        finishReason
                      }
                    );
                    self._object.resolve(object2);
                  } catch (e) {
                    error = e;
                    self._object.reject(e);
                  }
                  break;
                }
                default: {
                  controller.enqueue(chunk);
                  break;
                }
              }
            },
            // invoke onFinish callback and resolve toolResults promise when the stream is about to close:
            async flush(controller) {
              try {
                const finalUsage = usage != null ? usage : {
                  promptTokens: NaN,
                  completionTokens: NaN,
                  totalTokens: NaN
                };
                doStreamSpan.setAttributes(
                  await selectTelemetryAttributes({
                    telemetry,
                    attributes: {
                      "ai.response.finishReason": finishReason,
                      "ai.response.object": {
                        output: () => JSON.stringify(object2)
                      },
                      "ai.response.id": fullResponse.id,
                      "ai.response.model": fullResponse.modelId,
                      "ai.response.timestamp": fullResponse.timestamp.toISOString(),
                      "ai.response.providerMetadata": JSON.stringify(providerMetadata),
                      "ai.usage.inputTokens": finalUsage.inputTokens,
                      "ai.usage.outputTokens": finalUsage.outputTokens,
                      "ai.usage.totalTokens": finalUsage.totalTokens,
                      "ai.usage.reasoningTokens": finalUsage.reasoningTokens,
                      "ai.usage.cachedInputTokens": finalUsage.cachedInputTokens,
                      // standardized gen-ai llm span attributes:
                      "gen_ai.response.finish_reasons": [finishReason],
                      "gen_ai.response.id": fullResponse.id,
                      "gen_ai.response.model": fullResponse.modelId,
                      "gen_ai.usage.input_tokens": finalUsage.inputTokens,
                      "gen_ai.usage.output_tokens": finalUsage.outputTokens
                    }
                  })
                );
                doStreamSpan.end();
                rootSpan.setAttributes(
                  await selectTelemetryAttributes({
                    telemetry,
                    attributes: {
                      "ai.usage.inputTokens": finalUsage.inputTokens,
                      "ai.usage.outputTokens": finalUsage.outputTokens,
                      "ai.usage.totalTokens": finalUsage.totalTokens,
                      "ai.usage.reasoningTokens": finalUsage.reasoningTokens,
                      "ai.usage.cachedInputTokens": finalUsage.cachedInputTokens,
                      "ai.response.object": {
                        output: () => JSON.stringify(object2)
                      },
                      "ai.response.providerMetadata": JSON.stringify(providerMetadata)
                    }
                  })
                );
                await (onFinish == null ? void 0 : onFinish({
                  usage: finalUsage,
                  object: object2,
                  error,
                  response: {
                    ...fullResponse,
                    headers: response == null ? void 0 : response.headers
                  },
                  warnings,
                  providerMetadata
                }));
              } catch (error2) {
                controller.enqueue({ type: "error", error: error2 });
              } finally {
                rootSpan.end();
              }
            }
          })
        );
        stitchableStream.addStream(transformedStream);
      }
    }).catch((error) => {
      stitchableStream.addStream(
        new ReadableStream({
          start(controller) {
            controller.enqueue({ type: "error", error });
            controller.close();
          }
        })
      );
    }).finally(() => {
      stitchableStream.close();
    });
    this.outputStrategy = outputStrategy;
  }
  get object() {
    return this._object.promise;
  }
  get usage() {
    return this._usage.promise;
  }
  get providerMetadata() {
    return this._providerMetadata.promise;
  }
  get warnings() {
    return this._warnings.promise;
  }
  get request() {
    return this._request.promise;
  }
  get response() {
    return this._response.promise;
  }
  get finishReason() {
    return this._finishReason.promise;
  }
  get partialObjectStream() {
    return createAsyncIterableStream(
      this.baseStream.pipeThrough(
        new TransformStream({
          transform(chunk, controller) {
            switch (chunk.type) {
              case "object":
                controller.enqueue(chunk.object);
                break;
              case "text-delta":
              case "finish":
              case "error":
                break;
              default: {
                const _exhaustiveCheck = chunk;
                throw new Error(`Unsupported chunk type: ${_exhaustiveCheck}`);
              }
            }
          }
        })
      )
    );
  }
  get elementStream() {
    return this.outputStrategy.createElementStream(this.baseStream);
  }
  get textStream() {
    return createAsyncIterableStream(
      this.baseStream.pipeThrough(
        new TransformStream({
          transform(chunk, controller) {
            switch (chunk.type) {
              case "text-delta":
                controller.enqueue(chunk.textDelta);
                break;
              case "object":
              case "finish":
              case "error":
                break;
              default: {
                const _exhaustiveCheck = chunk;
                throw new Error(`Unsupported chunk type: ${_exhaustiveCheck}`);
              }
            }
          }
        })
      )
    );
  }
  get fullStream() {
    return createAsyncIterableStream(this.baseStream);
  }
  pipeTextStreamToResponse(response, init) {
    pipeTextStreamToResponse({
      response,
      textStream: this.textStream,
      ...init
    });
  }
  toTextStreamResponse(init) {
    return createTextStreamResponse({
      textStream: this.textStream,
      ...init
    });
  }
};

// src/generate-speech/generate-speech.ts
var import_provider_utils31 = require("@ai-sdk/provider-utils");

// src/generate-speech/generated-audio-file.ts
var DefaultGeneratedAudioFile = class extends DefaultGeneratedFile {
  constructor({
    data,
    mediaType
  }) {
    super({ data, mediaType });
    let format = "mp3";
    if (mediaType) {
      const mediaTypeParts = mediaType.split("/");
      if (mediaTypeParts.length === 2) {
        if (mediaType !== "audio/mpeg") {
          format = mediaTypeParts[1];
        }
      }
    }
    if (!format) {
      throw new Error(
        "Audio format must be provided or determinable from media type"
      );
    }
    this.format = format;
  }
};

// src/generate-speech/generate-speech.ts
async function generateSpeech({
  model,
  text: text2,
  voice,
  outputFormat,
  instructions,
  speed,
  language,
  providerOptions = {},
  maxRetries: maxRetriesArg,
  abortSignal,
  headers
}) {
  var _a16;
  const resolvedModel = resolveSpeechModel(model);
  if (!resolvedModel) {
    throw new Error("Model could not be resolved");
  }
  const headersWithUserAgent = (0, import_provider_utils31.withUserAgentSuffix)(
    headers != null ? headers : {},
    `ai/${VERSION}`
  );
  const { retry } = prepareRetries({
    maxRetries: maxRetriesArg,
    abortSignal
  });
  const result = await retry(
    () => resolvedModel.doGenerate({
      text: text2,
      voice,
      outputFormat,
      instructions,
      speed,
      language,
      abortSignal,
      headers: headersWithUserAgent,
      providerOptions
    })
  );
  if (!result.audio || result.audio.length === 0) {
    throw new NoSpeechGeneratedError({ responses: [result.response] });
  }
  logWarnings({
    warnings: result.warnings,
    provider: resolvedModel.provider,
    model: resolvedModel.modelId
  });
  return new DefaultSpeechResult({
    audio: new DefaultGeneratedAudioFile({
      data: result.audio,
      mediaType: (_a16 = detectMediaType({
        data: result.audio,
        signatures: audioMediaTypeSignatures
      })) != null ? _a16 : "audio/mp3"
    }),
    warnings: result.warnings,
    responses: [result.response],
    providerMetadata: result.providerMetadata
  });
}
var DefaultSpeechResult = class {
  constructor(options) {
    var _a16;
    this.audio = options.audio;
    this.warnings = options.warnings;
    this.responses = options.responses;
    this.providerMetadata = (_a16 = options.providerMetadata) != null ? _a16 : {};
  }
};

// src/generate-text/prune-messages.ts
function pruneMessages({
  messages,
  reasoning = "none",
  toolCalls = [],
  emptyMessages = "remove"
}) {
  if (reasoning === "all" || reasoning === "before-last-message") {
    messages = messages.map((message, messageIndex) => {
      if (message.role !== "assistant" || typeof message.content === "string" || reasoning === "before-last-message" && messageIndex === messages.length - 1) {
        return message;
      }
      return {
        ...message,
        content: message.content.filter((part) => part.type !== "reasoning")
      };
    });
  }
  if (toolCalls === "none") {
    toolCalls = [];
  } else if (toolCalls === "all") {
    toolCalls = [{ type: "all" }];
  } else if (toolCalls === "before-last-message") {
    toolCalls = [{ type: "before-last-message" }];
  } else if (typeof toolCalls === "string") {
    toolCalls = [{ type: toolCalls }];
  }
  for (const toolCall of toolCalls) {
    const keepLastMessagesCount = toolCall.type === "all" ? void 0 : toolCall.type === "before-last-message" ? 1 : Number(
      toolCall.type.slice("before-last-".length).slice(0, -"-messages".length)
    );
    const keptToolCallIds = /* @__PURE__ */ new Set();
    const keptApprovalIds = /* @__PURE__ */ new Set();
    if (keepLastMessagesCount != null) {
      for (const message of messages.slice(-keepLastMessagesCount)) {
        if ((message.role === "assistant" || message.role === "tool") && typeof message.content !== "string") {
          for (const part of message.content) {
            if (part.type === "tool-call" || part.type === "tool-result") {
              keptToolCallIds.add(part.toolCallId);
            } else if (part.type === "tool-approval-request" || part.type === "tool-approval-response") {
              keptApprovalIds.add(part.approvalId);
            }
          }
        }
      }
    }
    messages = messages.map((message, messageIndex) => {
      if (message.role !== "assistant" && message.role !== "tool" || typeof message.content === "string" || keepLastMessagesCount && messageIndex >= messages.length - keepLastMessagesCount) {
        return message;
      }
      const toolCallIdToToolName = {};
      const approvalIdToToolName = {};
      return {
        ...message,
        content: message.content.filter((part) => {
          if (part.type !== "tool-call" && part.type !== "tool-result" && part.type !== "tool-approval-request" && part.type !== "tool-approval-response") {
            return true;
          }
          if (part.type === "tool-call") {
            toolCallIdToToolName[part.toolCallId] = part.toolName;
          } else if (part.type === "tool-approval-request") {
            approvalIdToToolName[part.approvalId] = toolCallIdToToolName[part.toolCallId];
          }
          if ((part.type === "tool-call" || part.type === "tool-result") && keptToolCallIds.has(part.toolCallId) || (part.type === "tool-approval-request" || part.type === "tool-approval-response") && keptApprovalIds.has(part.approvalId)) {
            return true;
          }
          return toolCall.tools != null && !toolCall.tools.includes(
            part.type === "tool-call" || part.type === "tool-result" ? part.toolName : approvalIdToToolName[part.approvalId]
          );
        })
      };
    });
  }
  if (emptyMessages === "remove") {
    messages = messages.filter((message) => message.content.length > 0);
  }
  return messages;
}

// src/generate-text/smooth-stream.ts
var import_provider_utils32 = require("@ai-sdk/provider-utils");
var import_provider28 = require("@ai-sdk/provider");
var CHUNKING_REGEXPS = {
  word: /\S+\s+/m,
  line: /\n+/m
};
function smoothStream({
  delayInMs = 10,
  chunking = "word",
  _internal: { delay: delay2 = import_provider_utils32.delay } = {}
} = {}) {
  let detectChunk;
  if (typeof chunking === "function") {
    detectChunk = (buffer) => {
      const match = chunking(buffer);
      if (match == null) {
        return null;
      }
      if (!match.length) {
        throw new Error(`Chunking function must return a non-empty string.`);
      }
      if (!buffer.startsWith(match)) {
        throw new Error(
          `Chunking function must return a match that is a prefix of the buffer. Received: "${match}" expected to start with "${buffer}"`
        );
      }
      return match;
    };
  } else {
    const chunkingRegex = typeof chunking === "string" ? CHUNKING_REGEXPS[chunking] : chunking;
    if (chunkingRegex == null) {
      throw new import_provider28.InvalidArgumentError({
        argument: "chunking",
        message: `Chunking must be "word" or "line" or a RegExp. Received: ${chunking}`
      });
    }
    detectChunk = (buffer) => {
      const match = chunkingRegex.exec(buffer);
      if (!match) {
        return null;
      }
      return buffer.slice(0, match.index) + (match == null ? void 0 : match[0]);
    };
  }
  return () => {
    let buffer = "";
    let id = "";
    let type = void 0;
    function flushBuffer(controller) {
      if (buffer.length > 0 && type !== void 0) {
        controller.enqueue({ type, text: buffer, id });
        buffer = "";
      }
    }
    return new TransformStream({
      async transform(chunk, controller) {
        if (chunk.type !== "text-delta" && chunk.type !== "reasoning-delta") {
          flushBuffer(controller);
          controller.enqueue(chunk);
          return;
        }
        if ((chunk.type !== type || chunk.id !== id) && buffer.length > 0) {
          flushBuffer(controller);
        }
        buffer += chunk.text;
        id = chunk.id;
        type = chunk.type;
        let match;
        while ((match = detectChunk(buffer)) != null) {
          controller.enqueue({ type, text: match, id });
          buffer = buffer.slice(match.length);
          await delay2(delayInMs);
        }
      }
    });
  };
}

// src/middleware/default-embedding-settings-middleware.ts
function defaultEmbeddingSettingsMiddleware({
  settings
}) {
  return {
    specificationVersion: "v3",
    transformParams: async ({ params }) => {
      return mergeObjects(settings, params);
    }
  };
}

// src/middleware/default-settings-middleware.ts
function defaultSettingsMiddleware({
  settings
}) {
  return {
    specificationVersion: "v3",
    transformParams: async ({ params }) => {
      return mergeObjects(settings, params);
    }
  };
}

// src/util/get-potential-start-index.ts
function getPotentialStartIndex(text2, searchedText) {
  if (searchedText.length === 0) {
    return null;
  }
  const directIndex = text2.indexOf(searchedText);
  if (directIndex !== -1) {
    return directIndex;
  }
  for (let i = text2.length - 1; i >= 0; i--) {
    const suffix = text2.substring(i);
    if (searchedText.startsWith(suffix)) {
      return i;
    }
  }
  return null;
}

// src/middleware/extract-reasoning-middleware.ts
function extractReasoningMiddleware({
  tagName,
  separator = "\n",
  startWithReasoning = false
}) {
  const openingTag = `<${tagName}>`;
  const closingTag = `</${tagName}>`;
  return {
    specificationVersion: "v3",
    wrapGenerate: async ({ doGenerate }) => {
      const { content, ...rest } = await doGenerate();
      const transformedContent = [];
      for (const part of content) {
        if (part.type !== "text") {
          transformedContent.push(part);
          continue;
        }
        const text2 = startWithReasoning ? openingTag + part.text : part.text;
        const regexp = new RegExp(`${openingTag}(.*?)${closingTag}`, "gs");
        const matches = Array.from(text2.matchAll(regexp));
        if (!matches.length) {
          transformedContent.push(part);
          continue;
        }
        const reasoningText = matches.map((match) => match[1]).join(separator);
        let textWithoutReasoning = text2;
        for (let i = matches.length - 1; i >= 0; i--) {
          const match = matches[i];
          const beforeMatch = textWithoutReasoning.slice(0, match.index);
          const afterMatch = textWithoutReasoning.slice(
            match.index + match[0].length
          );
          textWithoutReasoning = beforeMatch + (beforeMatch.length > 0 && afterMatch.length > 0 ? separator : "") + afterMatch;
        }
        transformedContent.push({
          type: "reasoning",
          text: reasoningText
        });
        transformedContent.push({
          type: "text",
          text: textWithoutReasoning
        });
      }
      return { content: transformedContent, ...rest };
    },
    wrapStream: async ({ doStream }) => {
      const { stream, ...rest } = await doStream();
      const reasoningExtractions = {};
      let delayedTextStart;
      return {
        stream: stream.pipeThrough(
          new TransformStream({
            transform: (chunk, controller) => {
              if (chunk.type === "text-start") {
                delayedTextStart = chunk;
                return;
              }
              if (chunk.type === "text-end" && delayedTextStart) {
                controller.enqueue(delayedTextStart);
                delayedTextStart = void 0;
              }
              if (chunk.type !== "text-delta") {
                controller.enqueue(chunk);
                return;
              }
              if (reasoningExtractions[chunk.id] == null) {
                reasoningExtractions[chunk.id] = {
                  isFirstReasoning: true,
                  isFirstText: true,
                  afterSwitch: false,
                  isReasoning: startWithReasoning,
                  buffer: "",
                  idCounter: 0,
                  textId: chunk.id
                };
              }
              const activeExtraction = reasoningExtractions[chunk.id];
              activeExtraction.buffer += chunk.delta;
              function publish(text2) {
                if (text2.length > 0) {
                  const prefix = activeExtraction.afterSwitch && (activeExtraction.isReasoning ? !activeExtraction.isFirstReasoning : !activeExtraction.isFirstText) ? separator : "";
                  if (activeExtraction.isReasoning && (activeExtraction.afterSwitch || activeExtraction.isFirstReasoning)) {
                    controller.enqueue({
                      type: "reasoning-start",
                      id: `reasoning-${activeExtraction.idCounter}`
                    });
                  }
                  if (activeExtraction.isReasoning) {
                    controller.enqueue({
                      type: "reasoning-delta",
                      delta: prefix + text2,
                      id: `reasoning-${activeExtraction.idCounter}`
                    });
                  } else {
                    if (delayedTextStart) {
                      controller.enqueue(delayedTextStart);
                      delayedTextStart = void 0;
                    }
                    controller.enqueue({
                      type: "text-delta",
                      delta: prefix + text2,
                      id: activeExtraction.textId
                    });
                  }
                  activeExtraction.afterSwitch = false;
                  if (activeExtraction.isReasoning) {
                    activeExtraction.isFirstReasoning = false;
                  } else {
                    activeExtraction.isFirstText = false;
                  }
                }
              }
              do {
                const nextTag = activeExtraction.isReasoning ? closingTag : openingTag;
                const startIndex = getPotentialStartIndex(
                  activeExtraction.buffer,
                  nextTag
                );
                if (startIndex == null) {
                  publish(activeExtraction.buffer);
                  activeExtraction.buffer = "";
                  break;
                }
                publish(activeExtraction.buffer.slice(0, startIndex));
                const foundFullMatch = startIndex + nextTag.length <= activeExtraction.buffer.length;
                if (foundFullMatch) {
                  activeExtraction.buffer = activeExtraction.buffer.slice(
                    startIndex + nextTag.length
                  );
                  if (activeExtraction.isReasoning) {
                    controller.enqueue({
                      type: "reasoning-end",
                      id: `reasoning-${activeExtraction.idCounter++}`
                    });
                  }
                  activeExtraction.isReasoning = !activeExtraction.isReasoning;
                  activeExtraction.afterSwitch = true;
                } else {
                  activeExtraction.buffer = activeExtraction.buffer.slice(startIndex);
                  break;
                }
              } while (true);
            }
          })
        ),
        ...rest
      };
    }
  };
}

// src/middleware/simulate-streaming-middleware.ts
function simulateStreamingMiddleware() {
  return {
    specificationVersion: "v3",
    wrapStream: async ({ doGenerate }) => {
      const result = await doGenerate();
      let id = 0;
      const simulatedStream = new ReadableStream({
        start(controller) {
          controller.enqueue({
            type: "stream-start",
            warnings: result.warnings
          });
          controller.enqueue({ type: "response-metadata", ...result.response });
          for (const part of result.content) {
            switch (part.type) {
              case "text": {
                if (part.text.length > 0) {
                  controller.enqueue({ type: "text-start", id: String(id) });
                  controller.enqueue({
                    type: "text-delta",
                    id: String(id),
                    delta: part.text
                  });
                  controller.enqueue({ type: "text-end", id: String(id) });
                  id++;
                }
                break;
              }
              case "reasoning": {
                controller.enqueue({
                  type: "reasoning-start",
                  id: String(id),
                  providerMetadata: part.providerMetadata
                });
                controller.enqueue({
                  type: "reasoning-delta",
                  id: String(id),
                  delta: part.text
                });
                controller.enqueue({ type: "reasoning-end", id: String(id) });
                id++;
                break;
              }
              default: {
                controller.enqueue(part);
                break;
              }
            }
          }
          controller.enqueue({
            type: "finish",
            finishReason: result.finishReason,
            usage: result.usage,
            providerMetadata: result.providerMetadata
          });
          controller.close();
        }
      });
      return {
        stream: simulatedStream,
        request: result.request,
        response: result.response
      };
    }
  };
}

// src/middleware/add-tool-input-examples-middleware.ts
function defaultFormatExample(example) {
  return JSON.stringify(example.input);
}
function addToolInputExamplesMiddleware({
  prefix = "Input Examples:",
  format = defaultFormatExample,
  remove = true
} = {}) {
  return {
    specificationVersion: "v3",
    transformParams: async ({ params }) => {
      var _a16;
      if (!((_a16 = params.tools) == null ? void 0 : _a16.length)) {
        return params;
      }
      const transformedTools = params.tools.map((tool2) => {
        var _a17;
        if (tool2.type !== "function" || !((_a17 = tool2.inputExamples) == null ? void 0 : _a17.length)) {
          return tool2;
        }
        const formattedExamples = tool2.inputExamples.map((example, index) => format(example, index)).join("\n");
        const examplesSection = `${prefix}
${formattedExamples}`;
        const toolDescription = tool2.description ? `${tool2.description}

${examplesSection}` : examplesSection;
        return {
          ...tool2,
          description: toolDescription,
          inputExamples: remove ? void 0 : tool2.inputExamples
        };
      });
      return {
        ...params,
        tools: transformedTools
      };
    }
  };
}

// src/middleware/wrap-language-model.ts
var wrapLanguageModel = ({
  model,
  middleware: middlewareArg,
  modelId,
  providerId
}) => {
  return [...asArray(middlewareArg)].reverse().reduce((wrappedModel, middleware) => {
    return doWrap({ model: wrappedModel, middleware, modelId, providerId });
  }, model);
};
var doWrap = ({
  model,
  middleware: {
    transformParams,
    wrapGenerate,
    wrapStream,
    overrideProvider,
    overrideModelId,
    overrideSupportedUrls
  },
  modelId,
  providerId
}) => {
  var _a16, _b, _c;
  async function doTransform({
    params,
    type
  }) {
    return transformParams ? await transformParams({ params, type, model }) : params;
  }
  return {
    specificationVersion: "v3",
    provider: (_a16 = providerId != null ? providerId : overrideProvider == null ? void 0 : overrideProvider({ model })) != null ? _a16 : model.provider,
    modelId: (_b = modelId != null ? modelId : overrideModelId == null ? void 0 : overrideModelId({ model })) != null ? _b : model.modelId,
    supportedUrls: (_c = overrideSupportedUrls == null ? void 0 : overrideSupportedUrls({ model })) != null ? _c : model.supportedUrls,
    async doGenerate(params) {
      const transformedParams = await doTransform({ params, type: "generate" });
      const doGenerate = async () => model.doGenerate(transformedParams);
      const doStream = async () => model.doStream(transformedParams);
      return wrapGenerate ? wrapGenerate({
        doGenerate,
        doStream,
        params: transformedParams,
        model
      }) : doGenerate();
    },
    async doStream(params) {
      const transformedParams = await doTransform({ params, type: "stream" });
      const doGenerate = async () => model.doGenerate(transformedParams);
      const doStream = async () => model.doStream(transformedParams);
      return wrapStream ? wrapStream({ doGenerate, doStream, params: transformedParams, model }) : doStream();
    }
  };
};

// src/middleware/wrap-embedding-model.ts
var wrapEmbeddingModel = ({
  model,
  middleware: middlewareArg,
  modelId,
  providerId
}) => {
  return [...asArray(middlewareArg)].reverse().reduce((wrappedModel, middleware) => {
    return doWrap2({ model: wrappedModel, middleware, modelId, providerId });
  }, model);
};
var doWrap2 = ({
  model,
  middleware: {
    transformParams,
    wrapEmbed,
    overrideProvider,
    overrideModelId,
    overrideMaxEmbeddingsPerCall,
    overrideSupportsParallelCalls
  },
  modelId,
  providerId
}) => {
  var _a16, _b, _c, _d;
  async function doTransform({
    params
  }) {
    return transformParams ? await transformParams({ params, model }) : params;
  }
  return {
    specificationVersion: "v3",
    provider: (_a16 = providerId != null ? providerId : overrideProvider == null ? void 0 : overrideProvider({ model })) != null ? _a16 : model.provider,
    modelId: (_b = modelId != null ? modelId : overrideModelId == null ? void 0 : overrideModelId({ model })) != null ? _b : model.modelId,
    maxEmbeddingsPerCall: (_c = overrideMaxEmbeddingsPerCall == null ? void 0 : overrideMaxEmbeddingsPerCall({ model })) != null ? _c : model.maxEmbeddingsPerCall,
    supportsParallelCalls: (_d = overrideSupportsParallelCalls == null ? void 0 : overrideSupportsParallelCalls({ model })) != null ? _d : model.supportsParallelCalls,
    async doEmbed(params) {
      const transformedParams = await doTransform({ params });
      const doEmbed = async () => model.doEmbed(transformedParams);
      return wrapEmbed ? wrapEmbed({
        doEmbed,
        params: transformedParams,
        model
      }) : doEmbed();
    }
  };
};

// src/middleware/wrap-image-model.ts
var wrapImageModel = ({
  model,
  middleware: middlewareArg,
  modelId,
  providerId
}) => {
  return [...asArray(middlewareArg)].reverse().reduce((wrappedModel, middleware) => {
    return doWrap3({ model: wrappedModel, middleware, modelId, providerId });
  }, model);
};
var doWrap3 = ({
  model,
  middleware: {
    transformParams,
    wrapGenerate,
    overrideProvider,
    overrideModelId,
    overrideMaxImagesPerCall
  },
  modelId,
  providerId
}) => {
  var _a16, _b, _c;
  async function doTransform({ params }) {
    return transformParams ? await transformParams({ params, model }) : params;
  }
  const maxImagesPerCallRaw = (_a16 = overrideMaxImagesPerCall == null ? void 0 : overrideMaxImagesPerCall({ model })) != null ? _a16 : model.maxImagesPerCall;
  const maxImagesPerCall = maxImagesPerCallRaw instanceof Function ? maxImagesPerCallRaw.bind(model) : maxImagesPerCallRaw;
  return {
    specificationVersion: "v3",
    provider: (_b = providerId != null ? providerId : overrideProvider == null ? void 0 : overrideProvider({ model })) != null ? _b : model.provider,
    modelId: (_c = modelId != null ? modelId : overrideModelId == null ? void 0 : overrideModelId({ model })) != null ? _c : model.modelId,
    maxImagesPerCall,
    async doGenerate(params) {
      const transformedParams = await doTransform({ params });
      const doGenerate = async () => model.doGenerate(transformedParams);
      return wrapGenerate ? wrapGenerate({
        doGenerate,
        params: transformedParams,
        model
      }) : doGenerate();
    }
  };
};

// src/model/as-provider-v3.ts
function asProviderV3(provider) {
  if ("specificationVersion" in provider && provider.specificationVersion === "v3") {
    return provider;
  }
  const v2Provider = provider;
  return {
    specificationVersion: "v3",
    languageModel: (modelId) => asLanguageModelV3(v2Provider.languageModel(modelId)),
    embeddingModel: (modelId) => asEmbeddingModelV3(v2Provider.textEmbeddingModel(modelId)),
    imageModel: (modelId) => asImageModelV3(v2Provider.imageModel(modelId)),
    transcriptionModel: v2Provider.transcriptionModel ? (modelId) => asTranscriptionModelV3(v2Provider.transcriptionModel(modelId)) : void 0,
    speechModel: v2Provider.speechModel ? (modelId) => asSpeechModelV3(v2Provider.speechModel(modelId)) : void 0,
    rerankingModel: void 0
    // v2 providers don't have reranking models
  };
}

// src/middleware/wrap-provider.ts
function wrapProvider({
  provider,
  languageModelMiddleware,
  imageModelMiddleware
}) {
  const providerV3 = asProviderV3(provider);
  return {
    specificationVersion: "v3",
    languageModel: (modelId) => wrapLanguageModel({
      model: providerV3.languageModel(modelId),
      middleware: languageModelMiddleware
    }),
    embeddingModel: providerV3.embeddingModel,
    imageModel: (modelId) => {
      let model = providerV3.imageModel(modelId);
      if (imageModelMiddleware != null) {
        model = wrapImageModel({ model, middleware: imageModelMiddleware });
      }
      return model;
    },
    transcriptionModel: providerV3.transcriptionModel,
    speechModel: providerV3.speechModel,
    rerankingModel: providerV3.rerankingModel
  };
}

// src/registry/custom-provider.ts
var import_provider29 = require("@ai-sdk/provider");
function customProvider({
  languageModels,
  embeddingModels,
  imageModels,
  transcriptionModels,
  speechModels,
  rerankingModels,
  fallbackProvider: fallbackProviderArg
}) {
  const fallbackProvider = fallbackProviderArg ? asProviderV3(fallbackProviderArg) : void 0;
  return {
    specificationVersion: "v3",
    languageModel(modelId) {
      if (languageModels != null && modelId in languageModels) {
        return languageModels[modelId];
      }
      if (fallbackProvider) {
        return fallbackProvider.languageModel(modelId);
      }
      throw new import_provider29.NoSuchModelError({ modelId, modelType: "languageModel" });
    },
    embeddingModel(modelId) {
      if (embeddingModels != null && modelId in embeddingModels) {
        return embeddingModels[modelId];
      }
      if (fallbackProvider) {
        return fallbackProvider.embeddingModel(modelId);
      }
      throw new import_provider29.NoSuchModelError({ modelId, modelType: "embeddingModel" });
    },
    imageModel(modelId) {
      if (imageModels != null && modelId in imageModels) {
        return imageModels[modelId];
      }
      if (fallbackProvider == null ? void 0 : fallbackProvider.imageModel) {
        return fallbackProvider.imageModel(modelId);
      }
      throw new import_provider29.NoSuchModelError({ modelId, modelType: "imageModel" });
    },
    transcriptionModel(modelId) {
      if (transcriptionModels != null && modelId in transcriptionModels) {
        return transcriptionModels[modelId];
      }
      if (fallbackProvider == null ? void 0 : fallbackProvider.transcriptionModel) {
        return fallbackProvider.transcriptionModel(modelId);
      }
      throw new import_provider29.NoSuchModelError({ modelId, modelType: "transcriptionModel" });
    },
    speechModel(modelId) {
      if (speechModels != null && modelId in speechModels) {
        return speechModels[modelId];
      }
      if (fallbackProvider == null ? void 0 : fallbackProvider.speechModel) {
        return fallbackProvider.speechModel(modelId);
      }
      throw new import_provider29.NoSuchModelError({ modelId, modelType: "speechModel" });
    },
    rerankingModel(modelId) {
      if (rerankingModels != null && modelId in rerankingModels) {
        return rerankingModels[modelId];
      }
      if (fallbackProvider == null ? void 0 : fallbackProvider.rerankingModel) {
        return fallbackProvider.rerankingModel(modelId);
      }
      throw new import_provider29.NoSuchModelError({ modelId, modelType: "rerankingModel" });
    }
  };
}
var experimental_customProvider = customProvider;

// src/registry/no-such-provider-error.ts
var import_provider30 = require("@ai-sdk/provider");
var name15 = "AI_NoSuchProviderError";
var marker15 = `vercel.ai.error.${name15}`;
var symbol15 = Symbol.for(marker15);
var _a15;
var NoSuchProviderError = class extends import_provider30.NoSuchModelError {
  constructor({
    modelId,
    modelType,
    providerId,
    availableProviders,
    message = `No such provider: ${providerId} (available providers: ${availableProviders.join()})`
  }) {
    super({ errorName: name15, modelId, modelType, message });
    this[_a15] = true;
    this.providerId = providerId;
    this.availableProviders = availableProviders;
  }
  static isInstance(error) {
    return import_provider30.AISDKError.hasMarker(error, marker15);
  }
};
_a15 = symbol15;

// src/registry/provider-registry.ts
var import_provider31 = require("@ai-sdk/provider");
function createProviderRegistry(providers, {
  separator = ":",
  languageModelMiddleware,
  imageModelMiddleware
} = {}) {
  const registry = new DefaultProviderRegistry({
    separator,
    languageModelMiddleware,
    imageModelMiddleware
  });
  for (const [id, provider] of Object.entries(providers)) {
    registry.registerProvider({ id, provider });
  }
  return registry;
}
var experimental_createProviderRegistry = createProviderRegistry;
var DefaultProviderRegistry = class {
  constructor({
    separator,
    languageModelMiddleware,
    imageModelMiddleware
  }) {
    this.providers = {};
    this.separator = separator;
    this.languageModelMiddleware = languageModelMiddleware;
    this.imageModelMiddleware = imageModelMiddleware;
  }
  registerProvider({
    id,
    provider
  }) {
    this.providers[id] = provider;
  }
  getProvider(id, modelType) {
    const provider = this.providers[id];
    if (provider == null) {
      throw new NoSuchProviderError({
        modelId: id,
        modelType,
        providerId: id,
        availableProviders: Object.keys(this.providers)
      });
    }
    return provider;
  }
  splitId(id, modelType) {
    const index = id.indexOf(this.separator);
    if (index === -1) {
      throw new import_provider31.NoSuchModelError({
        modelId: id,
        modelType,
        message: `Invalid ${modelType} id for registry: ${id} (must be in the format "providerId${this.separator}modelId")`
      });
    }
    return [id.slice(0, index), id.slice(index + this.separator.length)];
  }
  languageModel(id) {
    var _a16, _b;
    const [providerId, modelId] = this.splitId(id, "languageModel");
    let model = (_b = (_a16 = this.getProvider(providerId, "languageModel")).languageModel) == null ? void 0 : _b.call(
      _a16,
      modelId
    );
    if (model == null) {
      throw new import_provider31.NoSuchModelError({ modelId: id, modelType: "languageModel" });
    }
    if (this.languageModelMiddleware != null) {
      model = wrapLanguageModel({
        model,
        middleware: this.languageModelMiddleware
      });
    }
    return model;
  }
  embeddingModel(id) {
    var _a16;
    const [providerId, modelId] = this.splitId(id, "embeddingModel");
    const provider = this.getProvider(providerId, "embeddingModel");
    const model = (_a16 = provider.embeddingModel) == null ? void 0 : _a16.call(provider, modelId);
    if (model == null) {
      throw new import_provider31.NoSuchModelError({
        modelId: id,
        modelType: "embeddingModel"
      });
    }
    return model;
  }
  imageModel(id) {
    var _a16;
    const [providerId, modelId] = this.splitId(id, "imageModel");
    const provider = this.getProvider(providerId, "imageModel");
    let model = (_a16 = provider.imageModel) == null ? void 0 : _a16.call(provider, modelId);
    if (model == null) {
      throw new import_provider31.NoSuchModelError({ modelId: id, modelType: "imageModel" });
    }
    if (this.imageModelMiddleware != null) {
      model = wrapImageModel({
        model,
        middleware: this.imageModelMiddleware
      });
    }
    return model;
  }
  transcriptionModel(id) {
    var _a16;
    const [providerId, modelId] = this.splitId(id, "transcriptionModel");
    const provider = this.getProvider(providerId, "transcriptionModel");
    const model = (_a16 = provider.transcriptionModel) == null ? void 0 : _a16.call(provider, modelId);
    if (model == null) {
      throw new import_provider31.NoSuchModelError({
        modelId: id,
        modelType: "transcriptionModel"
      });
    }
    return model;
  }
  speechModel(id) {
    var _a16;
    const [providerId, modelId] = this.splitId(id, "speechModel");
    const provider = this.getProvider(providerId, "speechModel");
    const model = (_a16 = provider.speechModel) == null ? void 0 : _a16.call(provider, modelId);
    if (model == null) {
      throw new import_provider31.NoSuchModelError({ modelId: id, modelType: "speechModel" });
    }
    return model;
  }
  rerankingModel(id) {
    var _a16;
    const [providerId, modelId] = this.splitId(id, "rerankingModel");
    const provider = this.getProvider(providerId, "rerankingModel");
    const model = (_a16 = provider.rerankingModel) == null ? void 0 : _a16.call(provider, modelId);
    if (model == null) {
      throw new import_provider31.NoSuchModelError({ modelId: id, modelType: "rerankingModel" });
    }
    return model;
  }
};

// src/rerank/rerank.ts
async function rerank({
  model,
  documents,
  query,
  topN,
  maxRetries: maxRetriesArg,
  abortSignal,
  headers,
  providerOptions,
  experimental_telemetry: telemetry
}) {
  if (documents.length === 0) {
    return new DefaultRerankResult({
      originalDocuments: [],
      ranking: [],
      providerMetadata: void 0,
      response: {
        timestamp: /* @__PURE__ */ new Date(),
        modelId: model.modelId
      }
    });
  }
  const { maxRetries, retry } = prepareRetries({
    maxRetries: maxRetriesArg,
    abortSignal
  });
  const documentsToSend = typeof documents[0] === "string" ? { type: "text", values: documents } : { type: "object", values: documents };
  const baseTelemetryAttributes = getBaseTelemetryAttributes({
    model,
    telemetry,
    headers,
    settings: { maxRetries }
  });
  const tracer = getTracer(telemetry);
  return recordSpan({
    name: "ai.rerank",
    attributes: selectTelemetryAttributes({
      telemetry,
      attributes: {
        ...assembleOperationName({ operationId: "ai.rerank", telemetry }),
        ...baseTelemetryAttributes,
        "ai.documents": {
          input: () => documents.map((document) => JSON.stringify(document))
        }
      }
    }),
    tracer,
    fn: async () => {
      var _a16, _b;
      const { ranking, response, providerMetadata, warnings } = await retry(
        () => recordSpan({
          name: "ai.rerank.doRerank",
          attributes: selectTelemetryAttributes({
            telemetry,
            attributes: {
              ...assembleOperationName({
                operationId: "ai.rerank.doRerank",
                telemetry
              }),
              ...baseTelemetryAttributes,
              // specific settings that only make sense on the outer level:
              "ai.documents": {
                input: () => documents.map((document) => JSON.stringify(document))
              }
            }
          }),
          tracer,
          fn: async (doRerankSpan) => {
            const modelResponse = await model.doRerank({
              documents: documentsToSend,
              query,
              topN,
              providerOptions,
              abortSignal,
              headers
            });
            const ranking2 = modelResponse.ranking;
            doRerankSpan.setAttributes(
              await selectTelemetryAttributes({
                telemetry,
                attributes: {
                  "ai.ranking.type": documentsToSend.type,
                  "ai.ranking": {
                    output: () => ranking2.map((ranking3) => JSON.stringify(ranking3))
                  }
                }
              })
            );
            return {
              ranking: ranking2,
              providerMetadata: modelResponse.providerMetadata,
              response: modelResponse.response,
              warnings: modelResponse.warnings
            };
          }
        })
      );
      logWarnings({
        warnings: warnings != null ? warnings : [],
        provider: model.provider,
        model: model.modelId
      });
      return new DefaultRerankResult({
        originalDocuments: documents,
        ranking: ranking.map((ranking2) => ({
          originalIndex: ranking2.index,
          score: ranking2.relevanceScore,
          document: documents[ranking2.index]
        })),
        providerMetadata,
        response: {
          id: response == null ? void 0 : response.id,
          timestamp: (_a16 = response == null ? void 0 : response.timestamp) != null ? _a16 : /* @__PURE__ */ new Date(),
          modelId: (_b = response == null ? void 0 : response.modelId) != null ? _b : model.modelId,
          headers: response == null ? void 0 : response.headers,
          body: response == null ? void 0 : response.body
        }
      });
    }
  });
}
var DefaultRerankResult = class {
  constructor(options) {
    this.originalDocuments = options.originalDocuments;
    this.ranking = options.ranking;
    this.response = options.response;
    this.providerMetadata = options.providerMetadata;
  }
  get rerankedDocuments() {
    return this.ranking.map((ranking) => ranking.document);
  }
};

// src/transcribe/transcribe.ts
var import_provider_utils33 = require("@ai-sdk/provider-utils");

// src/error/no-transcript-generated-error.ts
var import_provider32 = require("@ai-sdk/provider");
var NoTranscriptGeneratedError = class extends import_provider32.AISDKError {
  constructor(options) {
    super({
      name: "AI_NoTranscriptGeneratedError",
      message: "No transcript generated."
    });
    this.responses = options.responses;
  }
};

// src/transcribe/transcribe.ts
async function transcribe({
  model,
  audio,
  providerOptions = {},
  maxRetries: maxRetriesArg,
  abortSignal,
  headers
}) {
  const resolvedModel = resolveTranscriptionModel(model);
  if (!resolvedModel) {
    throw new Error("Model could not be resolved");
  }
  const { retry } = prepareRetries({
    maxRetries: maxRetriesArg,
    abortSignal
  });
  const headersWithUserAgent = (0, import_provider_utils33.withUserAgentSuffix)(
    headers != null ? headers : {},
    `ai/${VERSION}`
  );
  const audioData = audio instanceof URL ? (await download({ url: audio })).data : convertDataContentToUint8Array(audio);
  const result = await retry(
    () => {
      var _a16;
      return resolvedModel.doGenerate({
        audio: audioData,
        abortSignal,
        headers: headersWithUserAgent,
        providerOptions,
        mediaType: (_a16 = detectMediaType({
          data: audioData,
          signatures: audioMediaTypeSignatures
        })) != null ? _a16 : "audio/wav"
      });
    }
  );
  logWarnings({
    warnings: result.warnings,
    provider: resolvedModel.provider,
    model: resolvedModel.modelId
  });
  if (!result.text) {
    throw new NoTranscriptGeneratedError({ responses: [result.response] });
  }
  return new DefaultTranscriptionResult({
    text: result.text,
    segments: result.segments,
    language: result.language,
    durationInSeconds: result.durationInSeconds,
    warnings: result.warnings,
    responses: [result.response],
    providerMetadata: result.providerMetadata
  });
}
var DefaultTranscriptionResult = class {
  constructor(options) {
    var _a16;
    this.text = options.text;
    this.segments = options.segments;
    this.language = options.language;
    this.durationInSeconds = options.durationInSeconds;
    this.warnings = options.warnings;
    this.responses = options.responses;
    this.providerMetadata = (_a16 = options.providerMetadata) != null ? _a16 : {};
  }
};

// src/ui/call-completion-api.ts
var import_provider_utils34 = require("@ai-sdk/provider-utils");

// src/ui/process-text-stream.ts
async function processTextStream({
  stream,
  onTextPart
}) {
  const reader = stream.pipeThrough(new TextDecoderStream()).getReader();
  while (true) {
    const { done, value } = await reader.read();
    if (done) {
      break;
    }
    await onTextPart(value);
  }
}

// src/ui/call-completion-api.ts
var getOriginalFetch = () => fetch;
async function callCompletionApi({
  api,
  prompt,
  credentials,
  headers,
  body,
  streamProtocol = "data",
  setCompletion,
  setLoading,
  setError,
  setAbortController,
  onFinish,
  onError,
  fetch: fetch2 = getOriginalFetch()
}) {
  var _a16;
  try {
    setLoading(true);
    setError(void 0);
    const abortController = new AbortController();
    setAbortController(abortController);
    setCompletion("");
    const response = await fetch2(api, {
      method: "POST",
      body: JSON.stringify({
        prompt,
        ...body
      }),
      credentials,
      headers: (0, import_provider_utils34.withUserAgentSuffix)(
        {
          "Content-Type": "application/json",
          ...headers
        },
        `ai-sdk/${VERSION}`,
        (0, import_provider_utils34.getRuntimeEnvironmentUserAgent)()
      ),
      signal: abortController.signal
    }).catch((err) => {
      throw err;
    });
    if (!response.ok) {
      throw new Error(
        (_a16 = await response.text()) != null ? _a16 : "Failed to fetch the chat response."
      );
    }
    if (!response.body) {
      throw new Error("The response body is empty.");
    }
    let result = "";
    switch (streamProtocol) {
      case "text": {
        await processTextStream({
          stream: response.body,
          onTextPart: (chunk) => {
            result += chunk;
            setCompletion(result);
          }
        });
        break;
      }
      case "data": {
        await consumeStream({
          stream: (0, import_provider_utils34.parseJsonEventStream)({
            stream: response.body,
            schema: uiMessageChunkSchema
          }).pipeThrough(
            new TransformStream({
              async transform(part) {
                if (!part.success) {
                  throw part.error;
                }
                const streamPart = part.value;
                if (streamPart.type === "text-delta") {
                  result += streamPart.delta;
                  setCompletion(result);
                } else if (streamPart.type === "error") {
                  throw new Error(streamPart.errorText);
                }
              }
            })
          ),
          onError: (error) => {
            throw error;
          }
        });
        break;
      }
      default: {
        const exhaustiveCheck = streamProtocol;
        throw new Error(`Unknown stream protocol: ${exhaustiveCheck}`);
      }
    }
    if (onFinish) {
      onFinish(prompt, result);
    }
    setAbortController(null);
    return result;
  } catch (err) {
    if (err.name === "AbortError") {
      setAbortController(null);
      return null;
    }
    if (err instanceof Error) {
      if (onError) {
        onError(err);
      }
    }
    setError(err);
  } finally {
    setLoading(false);
  }
}

// src/ui/chat.ts
var import_provider_utils37 = require("@ai-sdk/provider-utils");

// src/ui/convert-file-list-to-file-ui-parts.ts
async function convertFileListToFileUIParts(files) {
  if (files == null) {
    return [];
  }
  if (!globalThis.FileList || !(files instanceof globalThis.FileList)) {
    throw new Error("FileList is not supported in the current environment");
  }
  return Promise.all(
    Array.from(files).map(async (file) => {
      const { name: name16, type } = file;
      const dataUrl = await new Promise((resolve3, reject) => {
        const reader = new FileReader();
        reader.onload = (readerEvent) => {
          var _a16;
          resolve3((_a16 = readerEvent.target) == null ? void 0 : _a16.result);
        };
        reader.onerror = (error) => reject(error);
        reader.readAsDataURL(file);
      });
      return {
        type: "file",
        mediaType: type,
        filename: name16,
        url: dataUrl
      };
    })
  );
}

// src/ui/default-chat-transport.ts
var import_provider_utils36 = require("@ai-sdk/provider-utils");

// src/ui/http-chat-transport.ts
var import_provider_utils35 = require("@ai-sdk/provider-utils");
var HttpChatTransport = class {
  constructor({
    api = "/api/chat",
    credentials,
    headers,
    body,
    fetch: fetch2,
    prepareSendMessagesRequest,
    prepareReconnectToStreamRequest
  }) {
    this.api = api;
    this.credentials = credentials;
    this.headers = headers;
    this.body = body;
    this.fetch = fetch2;
    this.prepareSendMessagesRequest = prepareSendMessagesRequest;
    this.prepareReconnectToStreamRequest = prepareReconnectToStreamRequest;
  }
  async sendMessages({
    abortSignal,
    ...options
  }) {
    var _a16, _b, _c, _d, _e;
    const resolvedBody = await (0, import_provider_utils35.resolve)(this.body);
    const resolvedHeaders = await (0, import_provider_utils35.resolve)(this.headers);
    const resolvedCredentials = await (0, import_provider_utils35.resolve)(this.credentials);
    const baseHeaders = {
      ...(0, import_provider_utils35.normalizeHeaders)(resolvedHeaders),
      ...(0, import_provider_utils35.normalizeHeaders)(options.headers)
    };
    const preparedRequest = await ((_a16 = this.prepareSendMessagesRequest) == null ? void 0 : _a16.call(this, {
      api: this.api,
      id: options.chatId,
      messages: options.messages,
      body: { ...resolvedBody, ...options.body },
      headers: baseHeaders,
      credentials: resolvedCredentials,
      requestMetadata: options.metadata,
      trigger: options.trigger,
      messageId: options.messageId
    }));
    const api = (_b = preparedRequest == null ? void 0 : preparedRequest.api) != null ? _b : this.api;
    const headers = (preparedRequest == null ? void 0 : preparedRequest.headers) !== void 0 ? (0, import_provider_utils35.normalizeHeaders)(preparedRequest.headers) : baseHeaders;
    const body = (preparedRequest == null ? void 0 : preparedRequest.body) !== void 0 ? preparedRequest.body : {
      ...resolvedBody,
      ...options.body,
      id: options.chatId,
      messages: options.messages,
      trigger: options.trigger,
      messageId: options.messageId
    };
    const credentials = (_c = preparedRequest == null ? void 0 : preparedRequest.credentials) != null ? _c : resolvedCredentials;
    const fetch2 = (_d = this.fetch) != null ? _d : globalThis.fetch;
    const response = await fetch2(api, {
      method: "POST",
      headers: (0, import_provider_utils35.withUserAgentSuffix)(
        {
          "Content-Type": "application/json",
          ...headers
        },
        `ai-sdk/${VERSION}`,
        (0, import_provider_utils35.getRuntimeEnvironmentUserAgent)()
      ),
      body: JSON.stringify(body),
      credentials,
      signal: abortSignal
    });
    if (!response.ok) {
      throw new Error(
        (_e = await response.text()) != null ? _e : "Failed to fetch the chat response."
      );
    }
    if (!response.body) {
      throw new Error("The response body is empty.");
    }
    return this.processResponseStream(response.body);
  }
  async reconnectToStream(options) {
    var _a16, _b, _c, _d, _e;
    const resolvedBody = await (0, import_provider_utils35.resolve)(this.body);
    const resolvedHeaders = await (0, import_provider_utils35.resolve)(this.headers);
    const resolvedCredentials = await (0, import_provider_utils35.resolve)(this.credentials);
    const baseHeaders = {
      ...(0, import_provider_utils35.normalizeHeaders)(resolvedHeaders),
      ...(0, import_provider_utils35.normalizeHeaders)(options.headers)
    };
    const preparedRequest = await ((_a16 = this.prepareReconnectToStreamRequest) == null ? void 0 : _a16.call(this, {
      api: this.api,
      id: options.chatId,
      body: { ...resolvedBody, ...options.body },
      headers: baseHeaders,
      credentials: resolvedCredentials,
      requestMetadata: options.metadata
    }));
    const api = (_b = preparedRequest == null ? void 0 : preparedRequest.api) != null ? _b : `${this.api}/${options.chatId}/stream`;
    const headers = (preparedRequest == null ? void 0 : preparedRequest.headers) !== void 0 ? (0, import_provider_utils35.normalizeHeaders)(preparedRequest.headers) : baseHeaders;
    const credentials = (_c = preparedRequest == null ? void 0 : preparedRequest.credentials) != null ? _c : resolvedCredentials;
    const fetch2 = (_d = this.fetch) != null ? _d : globalThis.fetch;
    const response = await fetch2(api, {
      method: "GET",
      headers: (0, import_provider_utils35.withUserAgentSuffix)(
        headers,
        `ai-sdk/${VERSION}`,
        (0, import_provider_utils35.getRuntimeEnvironmentUserAgent)()
      ),
      credentials
    });
    if (response.status === 204) {
      return null;
    }
    if (!response.ok) {
      throw new Error(
        (_e = await response.text()) != null ? _e : "Failed to fetch the chat response."
      );
    }
    if (!response.body) {
      throw new Error("The response body is empty.");
    }
    return this.processResponseStream(response.body);
  }
};

// src/ui/default-chat-transport.ts
var DefaultChatTransport = class extends HttpChatTransport {
  constructor(options = {}) {
    super(options);
  }
  processResponseStream(stream) {
    return (0, import_provider_utils36.parseJsonEventStream)({
      stream,
      schema: uiMessageChunkSchema
    }).pipeThrough(
      new TransformStream({
        async transform(chunk, controller) {
          if (!chunk.success) {
            throw chunk.error;
          }
          controller.enqueue(chunk.value);
        }
      })
    );
  }
};

// src/ui/chat.ts
var AbstractChat = class {
  constructor({
    generateId: generateId2 = import_provider_utils37.generateId,
    id = generateId2(),
    transport = new DefaultChatTransport(),
    messageMetadataSchema,
    dataPartSchemas,
    state,
    onError,
    onToolCall,
    onFinish,
    onData,
    sendAutomaticallyWhen
  }) {
    this.activeResponse = void 0;
    this.jobExecutor = new SerialJobExecutor();
    /**
     * Appends or replaces a user message to the chat list. This triggers the API call to fetch
     * the assistant's response.
     *
     * If a messageId is provided, the message will be replaced.
     */
    this.sendMessage = async (message, options) => {
      var _a16, _b, _c, _d;
      if (message == null) {
        await this.makeRequest({
          trigger: "submit-message",
          messageId: (_a16 = this.lastMessage) == null ? void 0 : _a16.id,
          ...options
        });
        return;
      }
      let uiMessage;
      if ("text" in message || "files" in message) {
        const fileParts = Array.isArray(message.files) ? message.files : await convertFileListToFileUIParts(message.files);
        uiMessage = {
          parts: [
            ...fileParts,
            ..."text" in message && message.text != null ? [{ type: "text", text: message.text }] : []
          ]
        };
      } else {
        uiMessage = message;
      }
      if (message.messageId != null) {
        const messageIndex = this.state.messages.findIndex(
          (m) => m.id === message.messageId
        );
        if (messageIndex === -1) {
          throw new Error(`message with id ${message.messageId} not found`);
        }
        if (this.state.messages[messageIndex].role !== "user") {
          throw new Error(
            `message with id ${message.messageId} is not a user message`
          );
        }
        this.state.messages = this.state.messages.slice(0, messageIndex + 1);
        this.state.replaceMessage(messageIndex, {
          ...uiMessage,
          id: message.messageId,
          role: (_b = uiMessage.role) != null ? _b : "user",
          metadata: message.metadata
        });
      } else {
        this.state.pushMessage({
          ...uiMessage,
          id: (_c = uiMessage.id) != null ? _c : this.generateId(),
          role: (_d = uiMessage.role) != null ? _d : "user",
          metadata: message.metadata
        });
      }
      await this.makeRequest({
        trigger: "submit-message",
        messageId: message.messageId,
        ...options
      });
    };
    /**
     * Regenerate the assistant message with the provided message id.
     * If no message id is provided, the last assistant message will be regenerated.
     */
    this.regenerate = async ({
      messageId,
      ...options
    } = {}) => {
      const messageIndex = messageId == null ? this.state.messages.length - 1 : this.state.messages.findIndex((message) => message.id === messageId);
      if (messageIndex === -1) {
        throw new Error(`message ${messageId} not found`);
      }
      this.state.messages = this.state.messages.slice(
        0,
        // if the message is a user message, we need to include it in the request:
        this.messages[messageIndex].role === "assistant" ? messageIndex : messageIndex + 1
      );
      await this.makeRequest({
        trigger: "regenerate-message",
        messageId,
        ...options
      });
    };
    /**
     * Attempt to resume an ongoing streaming response.
     */
    this.resumeStream = async (options = {}) => {
      await this.makeRequest({ trigger: "resume-stream", ...options });
    };
    /**
     * Clear the error state and set the status to ready if the chat is in an error state.
     */
    this.clearError = () => {
      if (this.status === "error") {
        this.state.error = void 0;
        this.setStatus({ status: "ready" });
      }
    };
    this.addToolApprovalResponse = async ({
      id,
      approved,
      reason
    }) => this.jobExecutor.run(async () => {
      var _a16, _b;
      const messages = this.state.messages;
      const lastMessage = messages[messages.length - 1];
      const updatePart = (part) => isToolUIPart(part) && part.state === "approval-requested" && part.approval.id === id ? {
        ...part,
        state: "approval-responded",
        approval: { id, approved, reason }
      } : part;
      this.state.replaceMessage(messages.length - 1, {
        ...lastMessage,
        parts: lastMessage.parts.map(updatePart)
      });
      if (this.activeResponse) {
        this.activeResponse.state.message.parts = this.activeResponse.state.message.parts.map(updatePart);
      }
      if (this.status !== "streaming" && this.status !== "submitted" && ((_a16 = this.sendAutomaticallyWhen) == null ? void 0 : _a16.call(this, { messages: this.state.messages }))) {
        this.makeRequest({
          trigger: "submit-message",
          messageId: (_b = this.lastMessage) == null ? void 0 : _b.id
        });
      }
    });
    this.addToolOutput = async ({
      state = "output-available",
      tool: tool2,
      toolCallId,
      output,
      errorText
    }) => this.jobExecutor.run(async () => {
      var _a16, _b;
      const messages = this.state.messages;
      const lastMessage = messages[messages.length - 1];
      const updatePart = (part) => isToolUIPart(part) && part.toolCallId === toolCallId ? { ...part, state, output, errorText } : part;
      this.state.replaceMessage(messages.length - 1, {
        ...lastMessage,
        parts: lastMessage.parts.map(updatePart)
      });
      if (this.activeResponse) {
        this.activeResponse.state.message.parts = this.activeResponse.state.message.parts.map(updatePart);
      }
      if (this.status !== "streaming" && this.status !== "submitted" && ((_a16 = this.sendAutomaticallyWhen) == null ? void 0 : _a16.call(this, { messages: this.state.messages }))) {
        this.makeRequest({
          trigger: "submit-message",
          messageId: (_b = this.lastMessage) == null ? void 0 : _b.id
        });
      }
    });
    /** @deprecated Use addToolOutput */
    this.addToolResult = this.addToolOutput;
    /**
     * Abort the current request immediately, keep the generated tokens if any.
     */
    this.stop = async () => {
      var _a16;
      if (this.status !== "streaming" && this.status !== "submitted")
        return;
      if ((_a16 = this.activeResponse) == null ? void 0 : _a16.abortController) {
        this.activeResponse.abortController.abort();
      }
    };
    this.id = id;
    this.transport = transport;
    this.generateId = generateId2;
    this.messageMetadataSchema = messageMetadataSchema;
    this.dataPartSchemas = dataPartSchemas;
    this.state = state;
    this.onError = onError;
    this.onToolCall = onToolCall;
    this.onFinish = onFinish;
    this.onData = onData;
    this.sendAutomaticallyWhen = sendAutomaticallyWhen;
  }
  /**
   * Hook status:
   *
   * - `submitted`: The message has been sent to the API and we're awaiting the start of the response stream.
   * - `streaming`: The response is actively streaming in from the API, receiving chunks of data.
   * - `ready`: The full response has been received and processed; a new user message can be submitted.
   * - `error`: An error occurred during the API request, preventing successful completion.
   */
  get status() {
    return this.state.status;
  }
  setStatus({
    status,
    error
  }) {
    if (this.status === status)
      return;
    this.state.status = status;
    this.state.error = error;
  }
  get error() {
    return this.state.error;
  }
  get messages() {
    return this.state.messages;
  }
  get lastMessage() {
    return this.state.messages[this.state.messages.length - 1];
  }
  set messages(messages) {
    this.state.messages = messages;
  }
  async makeRequest({
    trigger,
    metadata,
    headers,
    body,
    messageId
  }) {
    var _a16, _b, _c, _d;
    this.setStatus({ status: "submitted", error: void 0 });
    const lastMessage = this.lastMessage;
    let isAbort = false;
    let isDisconnect = false;
    let isError = false;
    try {
      const activeResponse = {
        state: createStreamingUIMessageState({
          lastMessage: this.state.snapshot(lastMessage),
          messageId: this.generateId()
        }),
        abortController: new AbortController()
      };
      activeResponse.abortController.signal.addEventListener("abort", () => {
        isAbort = true;
      });
      this.activeResponse = activeResponse;
      let stream;
      if (trigger === "resume-stream") {
        const reconnect = await this.transport.reconnectToStream({
          chatId: this.id,
          metadata,
          headers,
          body
        });
        if (reconnect == null) {
          this.setStatus({ status: "ready" });
          return;
        }
        stream = reconnect;
      } else {
        stream = await this.transport.sendMessages({
          chatId: this.id,
          messages: this.state.messages,
          abortSignal: activeResponse.abortController.signal,
          metadata,
          headers,
          body,
          trigger,
          messageId
        });
      }
      const runUpdateMessageJob = (job) => (
        // serialize the job execution to avoid race conditions:
        this.jobExecutor.run(
          () => job({
            state: activeResponse.state,
            write: () => {
              var _a17;
              this.setStatus({ status: "streaming" });
              const replaceLastMessage = activeResponse.state.message.id === ((_a17 = this.lastMessage) == null ? void 0 : _a17.id);
              if (replaceLastMessage) {
                this.state.replaceMessage(
                  this.state.messages.length - 1,
                  activeResponse.state.message
                );
              } else {
                this.state.pushMessage(activeResponse.state.message);
              }
            }
          })
        )
      );
      await consumeStream({
        stream: processUIMessageStream({
          stream,
          onToolCall: this.onToolCall,
          onData: this.onData,
          messageMetadataSchema: this.messageMetadataSchema,
          dataPartSchemas: this.dataPartSchemas,
          runUpdateMessageJob,
          onError: (error) => {
            throw error;
          }
        }),
        onError: (error) => {
          throw error;
        }
      });
      this.setStatus({ status: "ready" });
    } catch (err) {
      if (isAbort || err.name === "AbortError") {
        isAbort = true;
        this.setStatus({ status: "ready" });
        return null;
      }
      isError = true;
      if (err instanceof TypeError && (err.message.toLowerCase().includes("fetch") || err.message.toLowerCase().includes("network"))) {
        isDisconnect = true;
      }
      if (this.onError && err instanceof Error) {
        this.onError(err);
      }
      this.setStatus({ status: "error", error: err });
    } finally {
      try {
        (_b = this.onFinish) == null ? void 0 : _b.call(this, {
          message: this.activeResponse.state.message,
          messages: this.state.messages,
          isAbort,
          isDisconnect,
          isError,
          finishReason: (_a16 = this.activeResponse) == null ? void 0 : _a16.state.finishReason
        });
      } catch (err) {
        console.error(err);
      }
      this.activeResponse = void 0;
    }
    if (((_c = this.sendAutomaticallyWhen) == null ? void 0 : _c.call(this, { messages: this.state.messages })) && !isError) {
      await this.makeRequest({
        trigger: "submit-message",
        messageId: (_d = this.lastMessage) == null ? void 0 : _d.id,
        metadata,
        headers,
        body
      });
    }
  }
};

// src/ui/direct-chat-transport.ts
var DirectChatTransport = class {
  constructor({
    agent,
    options,
    ...uiMessageStreamOptions
  }) {
    this.agent = agent;
    this.agentOptions = options;
    this.uiMessageStreamOptions = uiMessageStreamOptions;
  }
  async sendMessages({
    messages,
    abortSignal
  }) {
    const validatedMessages = await validateUIMessages({
      messages,
      tools: this.agent.tools
    });
    const modelMessages = await convertToModelMessages(validatedMessages, {
      tools: this.agent.tools
    });
    const result = await this.agent.stream({
      prompt: modelMessages,
      abortSignal,
      ...this.agentOptions !== void 0 ? { options: this.agentOptions } : {}
    });
    return result.toUIMessageStream(this.uiMessageStreamOptions);
  }
  /**
   * Direct transport does not support reconnection since there is no
   * persistent server-side stream to reconnect to.
   *
   * @returns Always returns `null`
   */
  async reconnectToStream(_options) {
    return null;
  }
};

// src/ui/last-assistant-message-is-complete-with-approval-responses.ts
function lastAssistantMessageIsCompleteWithApprovalResponses({
  messages
}) {
  const message = messages[messages.length - 1];
  if (!message) {
    return false;
  }
  if (message.role !== "assistant") {
    return false;
  }
  const lastStepStartIndex = message.parts.reduce((lastIndex, part, index) => {
    return part.type === "step-start" ? index : lastIndex;
  }, -1);
  const lastStepToolInvocations = message.parts.slice(lastStepStartIndex + 1).filter(isToolUIPart).filter((part) => !part.providerExecuted);
  return (
    // has at least one tool approval response
    lastStepToolInvocations.filter((part) => part.state === "approval-responded").length > 0 && // all tool approvals must have a response
    lastStepToolInvocations.every(
      (part) => part.state === "output-available" || part.state === "output-error" || part.state === "approval-responded"
    )
  );
}

// src/ui/last-assistant-message-is-complete-with-tool-calls.ts
function lastAssistantMessageIsCompleteWithToolCalls({
  messages
}) {
  const message = messages[messages.length - 1];
  if (!message) {
    return false;
  }
  if (message.role !== "assistant") {
    return false;
  }
  const lastStepStartIndex = message.parts.reduce((lastIndex, part, index) => {
    return part.type === "step-start" ? index : lastIndex;
  }, -1);
  const lastStepToolInvocations = message.parts.slice(lastStepStartIndex + 1).filter(isToolUIPart).filter((part) => !part.providerExecuted);
  return lastStepToolInvocations.length > 0 && lastStepToolInvocations.every(
    (part) => part.state === "output-available" || part.state === "output-error"
  );
}

// src/ui/transform-text-to-ui-message-stream.ts
function transformTextToUiMessageStream({
  stream
}) {
  return stream.pipeThrough(
    new TransformStream({
      start(controller) {
        controller.enqueue({ type: "start" });
        controller.enqueue({ type: "start-step" });
        controller.enqueue({ type: "text-start", id: "text-1" });
      },
      async transform(part, controller) {
        controller.enqueue({ type: "text-delta", id: "text-1", delta: part });
      },
      async flush(controller) {
        controller.enqueue({ type: "text-end", id: "text-1" });
        controller.enqueue({ type: "finish-step" });
        controller.enqueue({ type: "finish" });
      }
    })
  );
}

// src/ui/text-stream-chat-transport.ts
var TextStreamChatTransport = class extends HttpChatTransport {
  constructor(options = {}) {
    super(options);
  }
  processResponseStream(stream) {
    return transformTextToUiMessageStream({
      stream: stream.pipeThrough(new TextDecoderStream())
    });
  }
};
// Annotate the CommonJS export names for ESM import in node:
0 && (module.exports = {
  AISDKError,
  APICallError,
  AbstractChat,
  DefaultChatTransport,
  DirectChatTransport,
  DownloadError,
  EmptyResponseBodyError,
  Experimental_Agent,
  HttpChatTransport,
  InvalidArgumentError,
  InvalidDataContentError,
  InvalidMessageRoleError,
  InvalidPromptError,
  InvalidResponseDataError,
  InvalidStreamPartError,
  InvalidToolApprovalError,
  InvalidToolInputError,
  JSONParseError,
  JsonToSseTransformStream,
  LoadAPIKeyError,
  LoadSettingError,
  MessageConversionError,
  NoContentGeneratedError,
  NoImageGeneratedError,
  NoObjectGeneratedError,
  NoOutputGeneratedError,
  NoSpeechGeneratedError,
  NoSuchModelError,
  NoSuchProviderError,
  NoSuchToolError,
  Output,
  RetryError,
  SerialJobExecutor,
  TextStreamChatTransport,
  TooManyEmbeddingValuesForCallError,
  ToolCallNotFoundForApprovalError,
  ToolCallRepairError,
  ToolLoopAgent,
  TypeValidationError,
  UI_MESSAGE_STREAM_HEADERS,
  UnsupportedFunctionalityError,
  UnsupportedModelVersionError,
  addToolInputExamplesMiddleware,
  asSchema,
  assistantModelMessageSchema,
  callCompletionApi,
  consumeStream,
  convertFileListToFileUIParts,
  convertToModelMessages,
  cosineSimilarity,
  createAgentUIStream,
  createAgentUIStreamResponse,
  createGateway,
  createIdGenerator,
  createProviderRegistry,
  createTextStreamResponse,
  createUIMessageStream,
  createUIMessageStreamResponse,
  customProvider,
  defaultEmbeddingSettingsMiddleware,
  defaultSettingsMiddleware,
  dynamicTool,
  embed,
  embedMany,
  experimental_createProviderRegistry,
  experimental_customProvider,
  experimental_generateImage,
  experimental_generateSpeech,
  experimental_transcribe,
  extractReasoningMiddleware,
  gateway,
  generateId,
  generateImage,
  generateObject,
  generateText,
  getStaticToolName,
  getTextFromDataUrl,
  getToolName,
  getToolOrDynamicToolName,
  getTotalTimeoutMs,
  hasToolCall,
  isDataUIPart,
  isDeepEqualData,
  isFileUIPart,
  isReasoningUIPart,
  isStaticToolUIPart,
  isTextUIPart,
  isToolOrDynamicToolUIPart,
  isToolUIPart,
  jsonSchema,
  lastAssistantMessageIsCompleteWithApprovalResponses,
  lastAssistantMessageIsCompleteWithToolCalls,
  modelMessageSchema,
  parseJsonEventStream,
  parsePartialJson,
  pipeAgentUIStreamToResponse,
  pipeTextStreamToResponse,
  pipeUIMessageStreamToResponse,
  pruneMessages,
  readUIMessageStream,
  rerank,
  safeValidateUIMessages,
  simulateReadableStream,
  simulateStreamingMiddleware,
  smoothStream,
  stepCountIs,
  streamObject,
  streamText,
  systemModelMessageSchema,
  tool,
  toolModelMessageSchema,
  uiMessageChunkSchema,
  userModelMessageSchema,
  validateUIMessages,
  wrapEmbeddingModel,
  wrapImageModel,
  wrapLanguageModel,
  wrapProvider,
  zodSchema
});
//# sourceMappingURL=index.js.map