import { JsonObject } from "./safe-json-parse.js";
export declare const supportedSignatureAlgorithms: readonly ["RS256", "RS384", "RS512"];
export type SupportedSignatureAlgorithm = typeof supportedSignatureAlgorithms[number];
interface JwtHeaderStandardFields {
    alg?: SupportedSignatureAlgorithm | string;
    kid?: string;
}
export type JwtHeader = JwtHeaderStandardFields & JsonObject;
interface JwtPayloadStandardFields {
    exp?: number;
    iss?: string;
    sub?: string;
    aud?: string | string[];
    nbf?: number;
    iat?: number;
    scope?: string;
    jti?: string;
}
export type JwtPayload = JwtPayloadStandardFields & JsonObject;
export interface Jwt {
    header: JwtHeader;
    payload: JwtPayload;
}
export type CognitoIdOrAccessTokenPayload<IssuerConfig, VerifyProps> = VerifyProps extends {
    tokenUse: null;
} ? CognitoJwtPayload : VerifyProps extends {
    tokenUse: "id";
} ? CognitoIdTokenPayload : VerifyProps extends {
    tokenUse: "access";
} ? CognitoAccessTokenPayload : IssuerConfig extends {
    tokenUse: "id";
} ? CognitoIdTokenPayload : IssuerConfig extends {
    tokenUse: "access";
} ? CognitoAccessTokenPayload : CognitoJwtPayload;
interface CognitoJwtFields {
    token_use: "access" | "id";
    "cognito:groups"?: string[];
    sub: string;
    iss: string;
    exp: number;
    iat: number;
    auth_time: number;
    jti: string;
    origin_jti: string;
}
export type CognitoJwtPayload = CognitoJwtFields & JsonObject;
interface CognitoIdTokenFields extends CognitoJwtFields {
    token_use: "id";
    aud: string;
    at_hash: string;
    "cognito:username": string;
    email_verified: boolean;
    phone_number_verified: boolean;
    identities: {
        userId: string;
        providerName: string;
        providerType: string;
        issuer: null;
        primary: string;
        dateCreated: string;
    }[];
    "cognito:roles": string[];
    "cognito:preferred_role": string;
}
export type CognitoIdTokenPayload = CognitoIdTokenFields & JsonObject;
interface CognitoAccessTokenFields extends CognitoJwtFields {
    token_use: "access";
    client_id: string;
    version: number;
    username: string;
    scope: string;
}
export type CognitoAccessTokenPayload = CognitoAccessTokenFields & JsonObject;
export interface CognitoJwt {
    header: JwtHeader;
    payload: CognitoAccessTokenPayload | CognitoIdTokenPayload;
}
export {};
