# create-frame [![NPM version](https://img.shields.io/npm/v/create-frame.svg?style=flat)](https://www.npmjs.com/package/create-frame) [![NPM downloads](https://img.shields.io/npm/dm/create-frame.svg?style=flat)](https://npmjs.org/package/create-frame) [![Build Status](https://img.shields.io/travis/jonschlinkert/create-frame.svg?style=flat)](https://travis-ci.org/jonschlinkert/create-frame)

Easily add private variables to handlebars block helpers.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save create-frame
```

## Usage

```js
var createFrame = require('create-frame');
```

## Example

Create private variables from options hash arguments.

**Template**

The `@post` variable inside the block is created by the `post` hash argument. So the context of `@post` is the `this` object that is passed to the block.

```handlebars
{{#block post=this}}
<h1>{{@post.title}}</h1>
{{/block}}
```

**Helper**

The following helper uses `createFrame`, then it extends the "frame" with hash arguments.

```js
handlebars.registerHelper('block', function (options) {
  var frame = createFrame(options.data);
  // extend the frame with hash arguments
  frame.extend(options.hash);
  return options.fn(options, {data: frame});
});

var fn = handlebars.compile(str);
fn({title: 'My Blog Post'});
```

## About

### Related projects

* [assemble](https://www.npmjs.com/package/assemble): Get the rocks out of your socks! Assemble makes you fast at creating web projects… [more](https://github.com/assemble/assemble) | [homepage](https://github.com/assemble/assemble "Get the rocks out of your socks! Assemble makes you fast at creating web projects. Assemble is used by thousands of projects for rapid prototyping, creating themes, scaffolds, boilerplates, e-books, UI components, API documentation, blogs, building websit")
* [handlebars-helpers](https://www.npmjs.com/package/handlebars-helpers): More than 130 Handlebars helpers in ~20 categories. Helpers can be used with Assemble, Generate… [more](https://github.com/assemble/handlebars-helpers) | [homepage](https://github.com/assemble/handlebars-helpers "More than 130 Handlebars helpers in ~20 categories. Helpers can be used with Assemble, Generate, Verb, Ghost, gulp-handlebars, grunt-handlebars, consolidate, or any node.js/Handlebars project.")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Building docs

_(This document was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme) (a [verb](https://github.com/verbose/verb) generator), please don't edit the readme directly. Any changes to the readme must be made in [.verb.md](.verb.md).)_

To generate the readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install -g verb verb-generate-readme && verb
```

### Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

### License

Copyright © 2016, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT license](https://github.com/jonschlinkert/create-frame/blob/master/LICENSE).

***

_This file was generated by [verb](https://github.com/verbose/verb), v0.9.0, on July 21, 2016._