import createClient from 'openapi-fetch';
import { Transport, Client } from '@connectrpc/connect';
import { Message } from '@bufbuild/protobuf';
import { GenService, GenMessage } from '@bufbuild/protobuf/codegenv2';

/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */
interface paths {
    "/sandboxes": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** @description List all running sandboxes */
        get: {
            parameters: {
                query?: {
                    /** @description Metadata query used to filter the sandboxes (e.g. "user=abc&app=prod"). Each key and values must be URL encoded. */
                    metadata?: string;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description Successfully returned all running sandboxes */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["ListedSandbox"][];
                    };
                };
                400: components["responses"]["400"];
                401: components["responses"]["401"];
                500: components["responses"]["500"];
            };
        };
        put?: never;
        /** @description Create a sandbox from the template */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["NewSandbox"];
                };
            };
            responses: {
                /** @description The sandbox was created successfully */
                201: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["Sandbox"];
                    };
                };
                400: components["responses"]["400"];
                401: components["responses"]["401"];
                500: components["responses"]["500"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/sandboxes/{sandboxID}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** @description Get a sandbox by id */
        get: {
            parameters: {
                query?: never;
                header?: never;
                path: {
                    sandboxID: components["parameters"]["sandboxID"];
                };
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description Successfully returned the sandbox */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["SandboxDetail"];
                    };
                };
                401: components["responses"]["401"];
                404: components["responses"]["404"];
                500: components["responses"]["500"];
            };
        };
        put?: never;
        post?: never;
        /** @description Kill a sandbox */
        delete: {
            parameters: {
                query?: never;
                header?: never;
                path: {
                    sandboxID: components["parameters"]["sandboxID"];
                };
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description The sandbox was killed successfully */
                204: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content?: never;
                };
                401: components["responses"]["401"];
                404: components["responses"]["404"];
                500: components["responses"]["500"];
            };
        };
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/sandboxes/{sandboxID}/logs": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** @description Get sandbox logs */
        get: {
            parameters: {
                query?: {
                    /** @description Maximum number of logs that should be returned */
                    limit?: number;
                    /** @description Starting timestamp of the logs that should be returned in milliseconds */
                    start?: number;
                };
                header?: never;
                path: {
                    sandboxID: components["parameters"]["sandboxID"];
                };
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description Successfully returned the sandbox logs */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["SandboxLogs"];
                    };
                };
                401: components["responses"]["401"];
                404: components["responses"]["404"];
                500: components["responses"]["500"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/sandboxes/{sandboxID}/metrics": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** @description Get sandbox metrics */
        get: {
            parameters: {
                query?: {
                    end?: number;
                    /** @description Starting timestamp of the metrics that should be returned in milliseconds */
                    start?: number;
                };
                header?: never;
                path: {
                    sandboxID: components["parameters"]["sandboxID"];
                };
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description Successfully returned the sandbox metrics */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["SandboxMetric"][];
                    };
                };
                400: components["responses"]["400"];
                401: components["responses"]["401"];
                404: components["responses"]["404"];
                500: components["responses"]["500"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/sandboxes/{sandboxID}/pause": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** @description Pause the sandbox */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path: {
                    sandboxID: components["parameters"]["sandboxID"];
                };
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description The sandbox was paused successfully and can be resumed */
                204: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content?: never;
                };
                401: components["responses"]["401"];
                404: components["responses"]["404"];
                409: components["responses"]["409"];
                500: components["responses"]["500"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/sandboxes/{sandboxID}/refreshes": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** @description Refresh the sandbox extending its time to live */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path: {
                    sandboxID: components["parameters"]["sandboxID"];
                };
                cookie?: never;
            };
            requestBody?: {
                content: {
                    "application/json": {
                        /** @description Duration for which the sandbox should be kept alive in seconds */
                        duration?: number;
                    };
                };
            };
            responses: {
                /** @description Successfully refreshed the sandbox */
                204: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content?: never;
                };
                401: components["responses"]["401"];
                404: components["responses"]["404"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/sandboxes/{sandboxID}/resume": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** @description Resume the sandbox */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path: {
                    sandboxID: components["parameters"]["sandboxID"];
                };
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["ResumedSandbox"];
                };
            };
            responses: {
                /** @description The sandbox was resumed successfully */
                201: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["Sandbox"];
                    };
                };
                401: components["responses"]["401"];
                404: components["responses"]["404"];
                409: components["responses"]["409"];
                500: components["responses"]["500"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/sandboxes/{sandboxID}/timeout": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** @description Set the timeout for the sandbox. The sandbox will expire x seconds from the time of the request. Calling this method multiple times overwrites the TTL, each time using the current timestamp as the starting point to measure the timeout duration. */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path: {
                    sandboxID: components["parameters"]["sandboxID"];
                };
                cookie?: never;
            };
            requestBody?: {
                content: {
                    "application/json": {
                        /**
                         * Format: int32
                         * @description Timeout in seconds from the current time after which the sandbox should expire
                         */
                        timeout: number;
                    };
                };
            };
            responses: {
                /** @description Successfully set the sandbox timeout */
                204: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content?: never;
                };
                401: components["responses"]["401"];
                404: components["responses"]["404"];
                500: components["responses"]["500"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/sandboxes/metrics": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** @description List metrics for given sandboxes */
        get: {
            parameters: {
                query: {
                    /** @description Comma-separated list of sandbox IDs to get metrics for */
                    sandbox_ids: string[];
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description Successfully returned all running sandboxes with metrics */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["SandboxesWithMetrics"];
                    };
                };
                400: components["responses"]["400"];
                401: components["responses"]["401"];
                500: components["responses"]["500"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/teams": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** @description List all teams */
        get: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description Successfully returned all teams */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["Team"][];
                    };
                };
                401: components["responses"]["401"];
                500: components["responses"]["500"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/templates": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** @description List all templates */
        get: {
            parameters: {
                query?: {
                    teamID?: string;
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description Successfully returned all templates */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["Template"][];
                    };
                };
                401: components["responses"]["401"];
                500: components["responses"]["500"];
            };
        };
        put?: never;
        /** @description Create a new template */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["TemplateBuildRequest"];
                };
            };
            responses: {
                /** @description The build was accepted */
                202: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["Template"];
                    };
                };
                400: components["responses"]["400"];
                401: components["responses"]["401"];
                500: components["responses"]["500"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/templates/{templateID}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** @description Rebuild an template */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path: {
                    templateID: components["parameters"]["templateID"];
                };
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["TemplateBuildRequest"];
                };
            };
            responses: {
                /** @description The build was accepted */
                202: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["Template"];
                    };
                };
                401: components["responses"]["401"];
                500: components["responses"]["500"];
            };
        };
        /** @description Delete a template */
        delete: {
            parameters: {
                query?: never;
                header?: never;
                path: {
                    templateID: components["parameters"]["templateID"];
                };
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description The template was deleted successfully */
                204: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content?: never;
                };
                401: components["responses"]["401"];
                500: components["responses"]["500"];
            };
        };
        options?: never;
        head?: never;
        /** @description Update template */
        patch: {
            parameters: {
                query?: never;
                header?: never;
                path: {
                    templateID: components["parameters"]["templateID"];
                };
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["TemplateUpdateRequest"];
                };
            };
            responses: {
                /** @description The template was updated successfully */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content?: never;
                };
                400: components["responses"]["400"];
                401: components["responses"]["401"];
                500: components["responses"]["500"];
            };
        };
        trace?: never;
    };
    "/templates/{templateID}/builds/{buildID}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** @description Start the build */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path: {
                    buildID: components["parameters"]["buildID"];
                    templateID: components["parameters"]["templateID"];
                };
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description The build has started */
                202: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content?: never;
                };
                401: components["responses"]["401"];
                500: components["responses"]["500"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/templates/{templateID}/builds/{buildID}/status": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** @description Get template build info */
        get: {
            parameters: {
                query?: {
                    level?: components["schemas"]["LogLevel"];
                    /** @description Index of the starting build log that should be returned with the template */
                    logsOffset?: number;
                };
                header?: never;
                path: {
                    buildID: components["parameters"]["buildID"];
                    templateID: components["parameters"]["templateID"];
                };
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description Successfully returned the template */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["TemplateBuild"];
                    };
                };
                401: components["responses"]["401"];
                404: components["responses"]["404"];
                500: components["responses"]["500"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/templates/{templateID}/files/{hash}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** @description Get an upload link for a tar file containing build layer files */
        get: {
            parameters: {
                query?: never;
                header?: never;
                path: {
                    hash: string;
                    templateID: components["parameters"]["templateID"];
                };
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description The upload link where to upload the tar file */
                201: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["TemplateBuildFileUpload"];
                    };
                };
                400: components["responses"]["400"];
                401: components["responses"]["401"];
                404: components["responses"]["404"];
                500: components["responses"]["500"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/v2/sandboxes": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        /** @description List all sandboxes */
        get: {
            parameters: {
                query?: {
                    /** @description Maximum number of items to return per page */
                    limit?: number;
                    /** @description Metadata query used to filter the sandboxes (e.g. "user=abc&app=prod"). Each key and values must be URL encoded. */
                    metadata?: string;
                    /** @description Cursor to start the list from */
                    nextToken?: string;
                    /** @description Filter sandboxes by one or more states */
                    state?: components["schemas"]["SandboxState"][];
                };
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody?: never;
            responses: {
                /** @description Successfully returned all running sandboxes */
                200: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["ListedSandbox"][];
                    };
                };
                400: components["responses"]["400"];
                401: components["responses"]["401"];
                500: components["responses"]["500"];
            };
        };
        put?: never;
        post?: never;
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/v2/templates": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** @description Create a new template */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path?: never;
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["TemplateBuildRequestV2"];
                };
            };
            responses: {
                /** @description The build was requested successfully */
                202: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content: {
                        "application/json": components["schemas"]["Template"];
                    };
                };
                400: components["responses"]["400"];
                401: components["responses"]["401"];
                500: components["responses"]["500"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
    "/v2/templates/{templateID}/builds/{buildID}": {
        parameters: {
            query?: never;
            header?: never;
            path?: never;
            cookie?: never;
        };
        get?: never;
        put?: never;
        /** @description Start the build */
        post: {
            parameters: {
                query?: never;
                header?: never;
                path: {
                    buildID: components["parameters"]["buildID"];
                    templateID: components["parameters"]["templateID"];
                };
                cookie?: never;
            };
            requestBody: {
                content: {
                    "application/json": components["schemas"]["TemplateBuildStartV2"];
                };
            };
            responses: {
                /** @description The build has started */
                202: {
                    headers: {
                        [name: string]: unknown;
                    };
                    content?: never;
                };
                401: components["responses"]["401"];
                500: components["responses"]["500"];
            };
        };
        delete?: never;
        options?: never;
        head?: never;
        patch?: never;
        trace?: never;
    };
}
interface components {
    schemas: {
        BuildLogEntry: {
            /** @description Log level of the entry */
            level: components["schemas"]["LogLevel"];
            /** @description Log message content */
            message: string;
            /**
             * Format: date-time
             * @description Timestamp of the log entry
             */
            timestamp: string;
        };
        /**
         * Format: int32
         * @description CPU cores for the sandbox
         */
        CPUCount: number;
        CreatedAccessToken: {
            /**
             * Format: date-time
             * @description Timestamp of access token creation
             */
            createdAt: string;
            /**
             * Format: uuid
             * @description Identifier of the access token
             */
            id: string;
            mask: components["schemas"]["IdentifierMaskingDetails"];
            /** @description Name of the access token */
            name: string;
            /** @description The fully created access token */
            token: string;
        };
        CreatedTeamAPIKey: {
            /**
             * Format: date-time
             * @description Timestamp of API key creation
             */
            createdAt: string;
            createdBy?: components["schemas"]["TeamUser"] | null;
            /**
             * Format: uuid
             * @description Identifier of the API key
             */
            id: string;
            /** @description Raw value of the API key */
            key: string;
            /**
             * Format: date-time
             * @description Last time this API key was used
             */
            lastUsed?: string | null;
            mask: components["schemas"]["IdentifierMaskingDetails"];
            /** @description Name of the API key */
            name: string;
        };
        EnvVars: {
            [key: string]: string;
        };
        Error: {
            /**
             * Format: int32
             * @description Error code
             */
            code: number;
            /** @description Error */
            message: string;
        };
        IdentifierMaskingDetails: {
            /** @description Prefix used in masked version of the token or key */
            maskedValuePrefix: string;
            /** @description Suffix used in masked version of the token or key */
            maskedValueSuffix: string;
            /** @description Prefix that identifies the token or key type */
            prefix: string;
            /** @description Length of the token or key */
            valueLength: number;
        };
        ListedSandbox: {
            /** @description Alias of the template */
            alias?: string;
            /**
             * @deprecated
             * @description Identifier of the client
             */
            clientID: string;
            cpuCount: components["schemas"]["CPUCount"];
            /**
             * Format: date-time
             * @description Time when the sandbox will expire
             */
            endAt: string;
            memoryMB: components["schemas"]["MemoryMB"];
            metadata?: components["schemas"]["SandboxMetadata"];
            /** @description Identifier of the sandbox */
            sandboxID: string;
            /**
             * Format: date-time
             * @description Time when the sandbox was started
             */
            startedAt: string;
            state: components["schemas"]["SandboxState"];
            /** @description Identifier of the template from which is the sandbox created */
            templateID: string;
        };
        /**
         * @description State of the sandbox
         * @enum {string}
         */
        LogLevel: "debug" | "info" | "warn" | "error";
        /**
         * Format: int32
         * @description Memory for the sandbox in MB
         */
        MemoryMB: number;
        NewAccessToken: {
            /** @description Name of the access token */
            name: string;
        };
        NewSandbox: {
            /** @description Allow sandbox to access the internet */
            allow_internet_access?: boolean;
            /**
             * @description Automatically pauses the sandbox after the timeout
             * @default false
             */
            autoPause: boolean;
            envVars?: components["schemas"]["EnvVars"];
            metadata?: components["schemas"]["SandboxMetadata"];
            /** @description Secure all system communication with sandbox */
            secure?: boolean;
            /** @description Identifier of the required template */
            templateID: string;
            /**
             * Format: int32
             * @description Time to live for the sandbox in seconds.
             * @default 15
             */
            timeout: number;
        };
        NewTeamAPIKey: {
            /** @description Name of the API key */
            name: string;
        };
        Node: {
            /**
             * Format: int32
             * @description Number of allocated CPU cores
             */
            allocatedCPU: number;
            /**
             * Format: int32
             * @description Amount of allocated memory in MiB
             */
            allocatedMemoryMiB: number;
            /** @description Identifier of the cluster */
            clusterID?: string | null;
            /** @description Commit of the orchestrator */
            commit: string;
            /**
             * Format: uint64
             * @description Number of sandbox create fails
             */
            createFails: number;
            /**
             * Format: uint64
             * @description Number of sandbox create successes
             */
            createSuccesses: number;
            /** @description Identifier of the node */
            nodeID: string;
            /**
             * Format: int32
             * @description Number of sandboxes running on the node
             */
            sandboxCount: number;
            /**
             * Format: int
             * @description Number of starting Sandboxes
             */
            sandboxStartingCount: number;
            status: components["schemas"]["NodeStatus"];
            /** @description Version of the orchestrator */
            version: string;
        };
        NodeDetail: {
            /** @description List of cached builds id on the node */
            cachedBuilds: string[];
            /** @description Identifier of the cluster */
            clusterID?: string | null;
            /** @description Commit of the orchestrator */
            commit: string;
            /**
             * Format: uint64
             * @description Number of sandbox create fails
             */
            createFails: number;
            /**
             * Format: uint64
             * @description Number of sandbox create successes
             */
            createSuccesses: number;
            /** @description Identifier of the node */
            nodeID: string;
            /** @description List of sandboxes running on the node */
            sandboxes: components["schemas"]["ListedSandbox"][];
            status: components["schemas"]["NodeStatus"];
            /** @description Version of the orchestrator */
            version: string;
        };
        /**
         * @description Status of the node
         * @enum {string}
         */
        NodeStatus: "ready" | "draining" | "connecting" | "unhealthy";
        NodeStatusChange: {
            status: components["schemas"]["NodeStatus"];
        };
        ResumedSandbox: {
            /**
             * @description Automatically pauses the sandbox after the timeout
             * @default false
             */
            autoPause: boolean;
            /**
             * Format: int32
             * @description Time to live for the sandbox in seconds.
             * @default 15
             */
            timeout: number;
        };
        Sandbox: {
            /** @description Alias of the template */
            alias?: string;
            /**
             * @deprecated
             * @description Identifier of the client
             */
            clientID: string;
            /** @description Base domain where the sandbox traffic is accessible */
            domain?: string | null;
            /** @description Access token used for envd communication */
            envdAccessToken?: string;
            /** @description Version of the envd running in the sandbox */
            envdVersion: string;
            /** @description Identifier of the sandbox */
            sandboxID: string;
            /** @description Identifier of the template from which is the sandbox created */
            templateID: string;
        };
        SandboxDetail: {
            /** @description Alias of the template */
            alias?: string;
            /**
             * @deprecated
             * @description Identifier of the client
             */
            clientID: string;
            cpuCount: components["schemas"]["CPUCount"];
            /** @description Base domain where the sandbox traffic is accessible */
            domain?: string | null;
            /**
             * Format: date-time
             * @description Time when the sandbox will expire
             */
            endAt: string;
            /** @description Access token used for envd communication */
            envdAccessToken?: string;
            /** @description Version of the envd running in the sandbox */
            envdVersion?: string;
            memoryMB: components["schemas"]["MemoryMB"];
            metadata?: components["schemas"]["SandboxMetadata"];
            /** @description Identifier of the sandbox */
            sandboxID: string;
            /**
             * Format: date-time
             * @description Time when the sandbox was started
             */
            startedAt: string;
            state: components["schemas"]["SandboxState"];
            /** @description Identifier of the template from which is the sandbox created */
            templateID: string;
        };
        SandboxesWithMetrics: {
            sandboxes: {
                [key: string]: components["schemas"]["SandboxMetric"];
            };
        };
        /** @description Log entry with timestamp and line */
        SandboxLog: {
            /** @description Log line content */
            line: string;
            /**
             * Format: date-time
             * @description Timestamp of the log entry
             */
            timestamp: string;
        };
        SandboxLogs: {
            /** @description Logs of the sandbox */
            logs: components["schemas"]["SandboxLog"][];
        };
        SandboxMetadata: {
            [key: string]: string;
        };
        /** @description Metric entry with timestamp and line */
        SandboxMetric: {
            /**
             * Format: int32
             * @description Number of CPU cores
             */
            cpuCount: number;
            /**
             * Format: float
             * @description CPU usage percentage
             */
            cpuUsedPct: number;
            /**
             * Format: int64
             * @description Total disk space in bytes
             */
            diskTotal: number;
            /**
             * Format: int64
             * @description Disk used in bytes
             */
            diskUsed: number;
            /**
             * Format: int64
             * @description Total memory in bytes
             */
            memTotal: number;
            /**
             * Format: int64
             * @description Memory used in bytes
             */
            memUsed: number;
            /**
             * Format: date-time
             * @description Timestamp of the metric entry
             */
            timestamp: string;
        };
        /**
         * @description State of the sandbox
         * @enum {string}
         */
        SandboxState: "running" | "paused";
        Team: {
            /** @description API key for the team */
            apiKey: string;
            /** @description Whether the team is the default team */
            isDefault: boolean;
            /** @description Name of the team */
            name: string;
            /** @description Identifier of the team */
            teamID: string;
        };
        TeamAPIKey: {
            /**
             * Format: date-time
             * @description Timestamp of API key creation
             */
            createdAt: string;
            createdBy?: components["schemas"]["TeamUser"] | null;
            /**
             * Format: uuid
             * @description Identifier of the API key
             */
            id: string;
            /**
             * Format: date-time
             * @description Last time this API key was used
             */
            lastUsed?: string | null;
            mask: components["schemas"]["IdentifierMaskingDetails"];
            /** @description Name of the API key */
            name: string;
        };
        TeamUser: {
            /** @description Email of the user */
            email: string;
            /**
             * Format: uuid
             * @description Identifier of the user
             */
            id: string;
        };
        Template: {
            /** @description Aliases of the template */
            aliases?: string[];
            /**
             * Format: int32
             * @description Number of times the template was built
             */
            buildCount: number;
            /** @description Identifier of the last successful build for given template */
            buildID: string;
            cpuCount: components["schemas"]["CPUCount"];
            /**
             * Format: date-time
             * @description Time when the template was created
             */
            createdAt: string;
            createdBy: components["schemas"]["TeamUser"] | null;
            /**
             * Format: date-time
             * @description Time when the template was last used
             */
            lastSpawnedAt: string;
            memoryMB: components["schemas"]["MemoryMB"];
            /** @description Whether the template is public or only accessible by the team */
            public: boolean;
            /**
             * Format: int64
             * @description Number of times the template was used
             */
            spawnCount: number;
            /** @description Identifier of the template */
            templateID: string;
            /**
             * Format: date-time
             * @description Time when the template was last updated
             */
            updatedAt: string;
        };
        TemplateBuild: {
            /** @description Identifier of the build */
            buildID: string;
            /**
             * @description Build logs structured
             * @default []
             */
            logEntries: components["schemas"]["BuildLogEntry"][];
            /**
             * @description Build logs
             * @default []
             */
            logs: string[];
            /** @description Message with the status reason, currently reporting only for error status */
            reason?: string;
            /**
             * @description Status of the template
             * @enum {string}
             */
            status: "building" | "waiting" | "ready" | "error";
            /** @description Identifier of the template */
            templateID: string;
        };
        TemplateBuildFileUpload: {
            /** @description Whether the file is already present in the cache */
            present: boolean;
            /** @description Url where the file should be uploaded to */
            url?: string;
        };
        TemplateBuildRequest: {
            /** @description Alias of the template */
            alias?: string;
            cpuCount?: components["schemas"]["CPUCount"];
            /** @description Dockerfile for the template */
            dockerfile: string;
            memoryMB?: components["schemas"]["MemoryMB"];
            /** @description Ready check command to execute in the template after the build */
            readyCmd?: string;
            /** @description Start command to execute in the template after the build */
            startCmd?: string;
            /** @description Identifier of the team */
            teamID?: string;
        };
        TemplateBuildRequestV2: {
            /** @description Alias of the template */
            alias: string;
            cpuCount?: components["schemas"]["CPUCount"];
            memoryMB?: components["schemas"]["MemoryMB"];
            /** @description Identifier of the team */
            teamID?: string;
        };
        TemplateBuildStartV2: {
            /**
             * @description Whether the whole build should be forced to run regardless of the cache
             * @default false
             */
            force: boolean;
            /** @description Image to use as a base for the template build */
            fromImage: string;
            /** @description Ready check command to execute in the template after the build */
            readyCmd?: string;
            /** @description Start command to execute in the template after the build */
            startCmd?: string;
            /**
             * @description List of steps to execute in the template build
             * @default []
             */
            steps: components["schemas"]["TemplateStep"][];
        };
        /** @description Step in the template build process */
        TemplateStep: {
            /**
             * @description Arguments for the step
             * @default []
             */
            args: string[];
            /** @description Hash of the files used in the step */
            filesHash?: string;
            /**
             * @description Whether the step should be forced to run regardless of the cache
             * @default false
             */
            force: boolean;
            /** @description Type of the step */
            type: string;
        };
        TemplateUpdateRequest: {
            /** @description Whether the template is public or only accessible by the team */
            public?: boolean;
        };
        UpdateTeamAPIKey: {
            /** @description New name for the API key */
            name: string;
        };
    };
    responses: {
        /** @description Bad request */
        400: {
            headers: {
                [name: string]: unknown;
            };
            content: {
                "application/json": components["schemas"]["Error"];
            };
        };
        /** @description Authentication error */
        401: {
            headers: {
                [name: string]: unknown;
            };
            content: {
                "application/json": components["schemas"]["Error"];
            };
        };
        /** @description Not found */
        404: {
            headers: {
                [name: string]: unknown;
            };
            content: {
                "application/json": components["schemas"]["Error"];
            };
        };
        /** @description Conflict */
        409: {
            headers: {
                [name: string]: unknown;
            };
            content: {
                "application/json": components["schemas"]["Error"];
            };
        };
        /** @description Server error */
        500: {
            headers: {
                [name: string]: unknown;
            };
            content: {
                "application/json": components["schemas"]["Error"];
            };
        };
    };
    parameters: {
        accessTokenID: string;
        apiKeyID: string;
        buildID: string;
        nodeID: string;
        sandboxID: string;
        templateID: string;
    };
    requestBodies: never;
    headers: never;
    pathItems: never;
}

/**
 * Logger interface compatible with {@link console} used for logging Sandbox messages.
 */
interface Logger {
    /**
     * Debug level logging method.
     */
    debug?: (...args: any[]) => void;
    /**
     * Info level logging method.
     */
    info?: (...args: any[]) => void;
    /**
     * Warn level logging method.
     */
    warn?: (...args: any[]) => void;
    /**
     * Error level logging method.
     */
    error?: (...args: any[]) => void;
}

/**
 * Connection options for requests to the API.
 */
interface ConnectionOpts {
    /**
     * E2B API key to use for authentication.
     *
     * @default E2B_API_KEY // environment variable
     */
    apiKey?: string;
    /**
     * E2B access token to use for authentication.
     *
     * @default E2B_ACCESS_TOKEN // environment variable
     */
    accessToken?: string;
    /**
     * Domain to use for the API.
     *
     * @default E2B_DOMAIN // environment variable or `e2b.app`
     */
    domain?: string;
    /**
     * If true the SDK starts in the debug mode and connects to the local envd API server.
     * @internal
     * @default E2B_DEBUG // environment variable or `false`
     */
    debug?: boolean;
    /**
     * Timeout for requests to the API in **milliseconds**.
     *
     * @default 60_000 // 60 seconds
     */
    requestTimeoutMs?: number;
    /**
     * Logger to use for logging messages. It can accept any object that implements `Logger` interface—for example, {@link console}.
     */
    logger?: Logger;
    /**
     * Additional headers to send with the request.
     */
    headers?: Record<string, string>;
}
/**
 * Configuration for connecting to the API.
 */
declare class ConnectionConfig {
    readonly debug: boolean;
    readonly domain: string;
    readonly apiUrl: string;
    readonly logger?: Logger;
    readonly requestTimeoutMs: number;
    readonly apiKey?: string;
    readonly accessToken?: string;
    readonly headers?: Record<string, string>;
    constructor(opts?: ConnectionOpts);
    private static get domain();
    private static get debug();
    private static get apiKey();
    private static get accessToken();
    getSignal(requestTimeoutMs?: number): AbortSignal | undefined;
}
/**
 * User used for the operation in the sandbox.
 */
type Username = 'root' | 'user';

/**
 * Client for interacting with the E2B API.
 */
declare class ApiClient {
    readonly api: ReturnType<typeof createClient<paths>>;
    constructor(config: ConnectionConfig, opts?: {
        requireAccessToken?: boolean;
        requireApiKey?: boolean;
    });
}

/**
 * Base class for all sandbox errors.
 *
 * Thrown when general sandbox errors occur.
 */
declare class SandboxError extends Error {
    constructor(message: any);
}
/**
 * Thrown when a timeout error occurs.
 *
 * The [unavailable] error type is caused by sandbox timeout.
 *
 * The [canceled] error type is caused by exceeding request timeout.
 *
 * The [deadline_exceeded] error type is caused by exceeding the timeout for command execution, watch, etc.
 *
 * The [unknown] error type is sometimes caused by the sandbox timeout when the request is not processed correctly.
 */
declare class TimeoutError extends SandboxError {
    constructor(message: string);
}
/**
 * Thrown when an invalid argument is provided.
 */
declare class InvalidArgumentError extends SandboxError {
    constructor(message: string);
}
/**
 * Thrown when there is not enough disk space.
 */
declare class NotEnoughSpaceError extends SandboxError {
    constructor(message: string);
}
/**
 * Thrown when a resource is not found.
 */
declare class NotFoundError extends SandboxError {
    constructor(message: string);
}
/**
 * Thrown when authentication fails.
 */
declare class AuthenticationError extends SandboxError {
    constructor(message: any);
}
/**
 * Thrown when the template uses old envd version. It isn't compatible with the new SDK.
 */
declare class TemplateError extends SandboxError {
    constructor(message: string);
}
/**
 * Thrown when the API rate limit is exceeded.
 */
declare class RateLimitError extends SandboxError {
    constructor(message: any);
}

/**
 * Get the URL signature for the specified path, operation and user.
 *
 * @param path Path to the file in the sandbox.
 *
 * @param operation File system operation. Can be either `read` or `write`.
 *
 * @param user Sandbox user.
 *
 * @param expirationInSeconds Optional signature expiration time in seconds.
 */
interface SignatureOpts {
    path: string;
    operation: 'read' | 'write';
    user: string;
    expirationInSeconds?: number;
    envdAccessToken?: string;
}
declare function getSignature({ path, operation, user, expirationInSeconds, envdAccessToken, }: SignatureOpts): Promise<{
    signature: string;
    expiration: number | null;
}>;

/**
 * @generated from message process.PTY
 */
type PTY = Message<"process.PTY"> & {
    /**
     * @generated from field: process.PTY.Size size = 1;
     */
    size?: PTY_Size;
};
/**
 * @generated from message process.PTY.Size
 */
type PTY_Size = Message<"process.PTY.Size"> & {
    /**
     * @generated from field: uint32 cols = 1;
     */
    cols: number;
    /**
     * @generated from field: uint32 rows = 2;
     */
    rows: number;
};
/**
 * @generated from message process.ProcessConfig
 */
type ProcessConfig = Message<"process.ProcessConfig"> & {
    /**
     * @generated from field: string cmd = 1;
     */
    cmd: string;
    /**
     * @generated from field: repeated string args = 2;
     */
    args: string[];
    /**
     * @generated from field: map<string, string> envs = 3;
     */
    envs: {
        [key: string]: string;
    };
    /**
     * @generated from field: optional string cwd = 4;
     */
    cwd?: string;
};
/**
 * @generated from message process.ListRequest
 */
type ListRequest = Message<"process.ListRequest"> & {};
/**
 * Describes the message process.ListRequest.
 * Use `create(ListRequestSchema)` to create a new message.
 */
declare const ListRequestSchema: GenMessage<ListRequest>;
/**
 * @generated from message process.ProcessInfo
 */
type ProcessInfo$1 = Message<"process.ProcessInfo"> & {
    /**
     * @generated from field: process.ProcessConfig config = 1;
     */
    config?: ProcessConfig;
    /**
     * @generated from field: uint32 pid = 2;
     */
    pid: number;
    /**
     * @generated from field: optional string tag = 3;
     */
    tag?: string;
};
/**
 * @generated from message process.ListResponse
 */
type ListResponse = Message<"process.ListResponse"> & {
    /**
     * @generated from field: repeated process.ProcessInfo processes = 1;
     */
    processes: ProcessInfo$1[];
};
/**
 * Describes the message process.ListResponse.
 * Use `create(ListResponseSchema)` to create a new message.
 */
declare const ListResponseSchema: GenMessage<ListResponse>;
/**
 * @generated from message process.StartRequest
 */
type StartRequest = Message<"process.StartRequest"> & {
    /**
     * @generated from field: process.ProcessConfig process = 1;
     */
    process?: ProcessConfig;
    /**
     * @generated from field: optional process.PTY pty = 2;
     */
    pty?: PTY;
    /**
     * @generated from field: optional string tag = 3;
     */
    tag?: string;
};
/**
 * Describes the message process.StartRequest.
 * Use `create(StartRequestSchema)` to create a new message.
 */
declare const StartRequestSchema: GenMessage<StartRequest>;
/**
 * @generated from message process.UpdateRequest
 */
type UpdateRequest = Message<"process.UpdateRequest"> & {
    /**
     * @generated from field: process.ProcessSelector process = 1;
     */
    process?: ProcessSelector;
    /**
     * @generated from field: optional process.PTY pty = 2;
     */
    pty?: PTY;
};
/**
 * Describes the message process.UpdateRequest.
 * Use `create(UpdateRequestSchema)` to create a new message.
 */
declare const UpdateRequestSchema: GenMessage<UpdateRequest>;
/**
 * @generated from message process.UpdateResponse
 */
type UpdateResponse = Message<"process.UpdateResponse"> & {};
/**
 * Describes the message process.UpdateResponse.
 * Use `create(UpdateResponseSchema)` to create a new message.
 */
declare const UpdateResponseSchema: GenMessage<UpdateResponse>;
/**
 * @generated from message process.ProcessEvent
 */
type ProcessEvent = Message<"process.ProcessEvent"> & {
    /**
     * @generated from oneof process.ProcessEvent.event
     */
    event: {
        /**
         * @generated from field: process.ProcessEvent.StartEvent start = 1;
         */
        value: ProcessEvent_StartEvent;
        case: "start";
    } | {
        /**
         * @generated from field: process.ProcessEvent.DataEvent data = 2;
         */
        value: ProcessEvent_DataEvent;
        case: "data";
    } | {
        /**
         * @generated from field: process.ProcessEvent.EndEvent end = 3;
         */
        value: ProcessEvent_EndEvent;
        case: "end";
    } | {
        /**
         * @generated from field: process.ProcessEvent.KeepAlive keepalive = 4;
         */
        value: ProcessEvent_KeepAlive;
        case: "keepalive";
    } | {
        case: undefined;
        value?: undefined;
    };
};
/**
 * @generated from message process.ProcessEvent.StartEvent
 */
type ProcessEvent_StartEvent = Message<"process.ProcessEvent.StartEvent"> & {
    /**
     * @generated from field: uint32 pid = 1;
     */
    pid: number;
};
/**
 * @generated from message process.ProcessEvent.DataEvent
 */
type ProcessEvent_DataEvent = Message<"process.ProcessEvent.DataEvent"> & {
    /**
     * @generated from oneof process.ProcessEvent.DataEvent.output
     */
    output: {
        /**
         * @generated from field: bytes stdout = 1;
         */
        value: Uint8Array;
        case: "stdout";
    } | {
        /**
         * @generated from field: bytes stderr = 2;
         */
        value: Uint8Array;
        case: "stderr";
    } | {
        /**
         * @generated from field: bytes pty = 3;
         */
        value: Uint8Array;
        case: "pty";
    } | {
        case: undefined;
        value?: undefined;
    };
};
/**
 * @generated from message process.ProcessEvent.EndEvent
 */
type ProcessEvent_EndEvent = Message<"process.ProcessEvent.EndEvent"> & {
    /**
     * @generated from field: sint32 exit_code = 1;
     */
    exitCode: number;
    /**
     * @generated from field: bool exited = 2;
     */
    exited: boolean;
    /**
     * @generated from field: string status = 3;
     */
    status: string;
    /**
     * @generated from field: optional string error = 4;
     */
    error?: string;
};
/**
 * @generated from message process.ProcessEvent.KeepAlive
 */
type ProcessEvent_KeepAlive = Message<"process.ProcessEvent.KeepAlive"> & {};
/**
 * @generated from message process.StartResponse
 */
type StartResponse = Message<"process.StartResponse"> & {
    /**
     * @generated from field: process.ProcessEvent event = 1;
     */
    event?: ProcessEvent;
};
/**
 * Describes the message process.StartResponse.
 * Use `create(StartResponseSchema)` to create a new message.
 */
declare const StartResponseSchema: GenMessage<StartResponse>;
/**
 * @generated from message process.ConnectResponse
 */
type ConnectResponse = Message<"process.ConnectResponse"> & {
    /**
     * @generated from field: process.ProcessEvent event = 1;
     */
    event?: ProcessEvent;
};
/**
 * Describes the message process.ConnectResponse.
 * Use `create(ConnectResponseSchema)` to create a new message.
 */
declare const ConnectResponseSchema: GenMessage<ConnectResponse>;
/**
 * @generated from message process.SendInputRequest
 */
type SendInputRequest = Message<"process.SendInputRequest"> & {
    /**
     * @generated from field: process.ProcessSelector process = 1;
     */
    process?: ProcessSelector;
    /**
     * @generated from field: process.ProcessInput input = 2;
     */
    input?: ProcessInput;
};
/**
 * Describes the message process.SendInputRequest.
 * Use `create(SendInputRequestSchema)` to create a new message.
 */
declare const SendInputRequestSchema: GenMessage<SendInputRequest>;
/**
 * @generated from message process.SendInputResponse
 */
type SendInputResponse = Message<"process.SendInputResponse"> & {};
/**
 * Describes the message process.SendInputResponse.
 * Use `create(SendInputResponseSchema)` to create a new message.
 */
declare const SendInputResponseSchema: GenMessage<SendInputResponse>;
/**
 * @generated from message process.ProcessInput
 */
type ProcessInput = Message<"process.ProcessInput"> & {
    /**
     * @generated from oneof process.ProcessInput.input
     */
    input: {
        /**
         * @generated from field: bytes stdin = 1;
         */
        value: Uint8Array;
        case: "stdin";
    } | {
        /**
         * @generated from field: bytes pty = 2;
         */
        value: Uint8Array;
        case: "pty";
    } | {
        case: undefined;
        value?: undefined;
    };
};
/**
 * @generated from message process.StreamInputRequest
 */
type StreamInputRequest = Message<"process.StreamInputRequest"> & {
    /**
     * @generated from oneof process.StreamInputRequest.event
     */
    event: {
        /**
         * @generated from field: process.StreamInputRequest.StartEvent start = 1;
         */
        value: StreamInputRequest_StartEvent;
        case: "start";
    } | {
        /**
         * @generated from field: process.StreamInputRequest.DataEvent data = 2;
         */
        value: StreamInputRequest_DataEvent;
        case: "data";
    } | {
        /**
         * @generated from field: process.StreamInputRequest.KeepAlive keepalive = 3;
         */
        value: StreamInputRequest_KeepAlive;
        case: "keepalive";
    } | {
        case: undefined;
        value?: undefined;
    };
};
/**
 * Describes the message process.StreamInputRequest.
 * Use `create(StreamInputRequestSchema)` to create a new message.
 */
declare const StreamInputRequestSchema: GenMessage<StreamInputRequest>;
/**
 * @generated from message process.StreamInputRequest.StartEvent
 */
type StreamInputRequest_StartEvent = Message<"process.StreamInputRequest.StartEvent"> & {
    /**
     * @generated from field: process.ProcessSelector process = 1;
     */
    process?: ProcessSelector;
};
/**
 * @generated from message process.StreamInputRequest.DataEvent
 */
type StreamInputRequest_DataEvent = Message<"process.StreamInputRequest.DataEvent"> & {
    /**
     * @generated from field: process.ProcessInput input = 2;
     */
    input?: ProcessInput;
};
/**
 * @generated from message process.StreamInputRequest.KeepAlive
 */
type StreamInputRequest_KeepAlive = Message<"process.StreamInputRequest.KeepAlive"> & {};
/**
 * @generated from message process.StreamInputResponse
 */
type StreamInputResponse = Message<"process.StreamInputResponse"> & {};
/**
 * Describes the message process.StreamInputResponse.
 * Use `create(StreamInputResponseSchema)` to create a new message.
 */
declare const StreamInputResponseSchema: GenMessage<StreamInputResponse>;
/**
 * @generated from message process.SendSignalRequest
 */
type SendSignalRequest = Message<"process.SendSignalRequest"> & {
    /**
     * @generated from field: process.ProcessSelector process = 1;
     */
    process?: ProcessSelector;
    /**
     * @generated from field: process.Signal signal = 2;
     */
    signal: Signal;
};
/**
 * Describes the message process.SendSignalRequest.
 * Use `create(SendSignalRequestSchema)` to create a new message.
 */
declare const SendSignalRequestSchema: GenMessage<SendSignalRequest>;
/**
 * @generated from message process.SendSignalResponse
 */
type SendSignalResponse = Message<"process.SendSignalResponse"> & {};
/**
 * Describes the message process.SendSignalResponse.
 * Use `create(SendSignalResponseSchema)` to create a new message.
 */
declare const SendSignalResponseSchema: GenMessage<SendSignalResponse>;
/**
 * @generated from message process.ConnectRequest
 */
type ConnectRequest = Message<"process.ConnectRequest"> & {
    /**
     * @generated from field: process.ProcessSelector process = 1;
     */
    process?: ProcessSelector;
};
/**
 * Describes the message process.ConnectRequest.
 * Use `create(ConnectRequestSchema)` to create a new message.
 */
declare const ConnectRequestSchema: GenMessage<ConnectRequest>;
/**
 * @generated from message process.ProcessSelector
 */
type ProcessSelector = Message<"process.ProcessSelector"> & {
    /**
     * @generated from oneof process.ProcessSelector.selector
     */
    selector: {
        /**
         * @generated from field: uint32 pid = 1;
         */
        value: number;
        case: "pid";
    } | {
        /**
         * @generated from field: string tag = 2;
         */
        value: string;
        case: "tag";
    } | {
        case: undefined;
        value?: undefined;
    };
};
/**
 * @generated from enum process.Signal
 */
declare enum Signal {
    /**
     * @generated from enum value: SIGNAL_UNSPECIFIED = 0;
     */
    UNSPECIFIED = 0,
    /**
     * @generated from enum value: SIGNAL_SIGTERM = 15;
     */
    SIGTERM = 15,
    /**
     * @generated from enum value: SIGNAL_SIGKILL = 9;
     */
    SIGKILL = 9
}
/**
 * @generated from service process.Process
 */
declare const Process: GenService<{
    /**
     * @generated from rpc process.Process.List
     */
    list: {
        methodKind: "unary";
        input: typeof ListRequestSchema;
        output: typeof ListResponseSchema;
    };
    /**
     * @generated from rpc process.Process.Connect
     */
    connect: {
        methodKind: "server_streaming";
        input: typeof ConnectRequestSchema;
        output: typeof ConnectResponseSchema;
    };
    /**
     * @generated from rpc process.Process.Start
     */
    start: {
        methodKind: "server_streaming";
        input: typeof StartRequestSchema;
        output: typeof StartResponseSchema;
    };
    /**
     * @generated from rpc process.Process.Update
     */
    update: {
        methodKind: "unary";
        input: typeof UpdateRequestSchema;
        output: typeof UpdateResponseSchema;
    };
    /**
     * Client input stream ensures ordering of messages
     *
     * @generated from rpc process.Process.StreamInput
     */
    streamInput: {
        methodKind: "client_streaming";
        input: typeof StreamInputRequestSchema;
        output: typeof StreamInputResponseSchema;
    };
    /**
     * @generated from rpc process.Process.SendInput
     */
    sendInput: {
        methodKind: "unary";
        input: typeof SendInputRequestSchema;
        output: typeof SendInputResponseSchema;
    };
    /**
     * @generated from rpc process.Process.SendSignal
     */
    sendSignal: {
        methodKind: "unary";
        input: typeof SendSignalRequestSchema;
        output: typeof SendSignalResponseSchema;
    };
}>;

/**
 * @generated from message filesystem.FilesystemEvent
 */
type FilesystemEvent$1 = Message<"filesystem.FilesystemEvent"> & {
    /**
     * @generated from field: string name = 1;
     */
    name: string;
    /**
     * @generated from field: filesystem.EventType type = 2;
     */
    type: EventType;
};
/**
 * @generated from message filesystem.WatchDirResponse
 */
type WatchDirResponse = Message<"filesystem.WatchDirResponse"> & {
    /**
     * @generated from oneof filesystem.WatchDirResponse.event
     */
    event: {
        /**
         * @generated from field: filesystem.WatchDirResponse.StartEvent start = 1;
         */
        value: WatchDirResponse_StartEvent;
        case: "start";
    } | {
        /**
         * @generated from field: filesystem.FilesystemEvent filesystem = 2;
         */
        value: FilesystemEvent$1;
        case: "filesystem";
    } | {
        /**
         * @generated from field: filesystem.WatchDirResponse.KeepAlive keepalive = 3;
         */
        value: WatchDirResponse_KeepAlive;
        case: "keepalive";
    } | {
        case: undefined;
        value?: undefined;
    };
};
/**
 * @generated from message filesystem.WatchDirResponse.StartEvent
 */
type WatchDirResponse_StartEvent = Message<"filesystem.WatchDirResponse.StartEvent"> & {};
/**
 * @generated from message filesystem.WatchDirResponse.KeepAlive
 */
type WatchDirResponse_KeepAlive = Message<"filesystem.WatchDirResponse.KeepAlive"> & {};
/**
 * @generated from enum filesystem.EventType
 */
declare enum EventType {
    /**
     * @generated from enum value: EVENT_TYPE_UNSPECIFIED = 0;
     */
    UNSPECIFIED = 0,
    /**
     * @generated from enum value: EVENT_TYPE_CREATE = 1;
     */
    CREATE = 1,
    /**
     * @generated from enum value: EVENT_TYPE_WRITE = 2;
     */
    WRITE = 2,
    /**
     * @generated from enum value: EVENT_TYPE_REMOVE = 3;
     */
    REMOVE = 3,
    /**
     * @generated from enum value: EVENT_TYPE_RENAME = 4;
     */
    RENAME = 4,
    /**
     * @generated from enum value: EVENT_TYPE_CHMOD = 5;
     */
    CHMOD = 5
}

declare class EnvdApiClient {
    readonly api: ReturnType<typeof createClient<paths>>;
    readonly version: string | undefined;
    constructor(config: Pick<ConnectionConfig, 'apiUrl' | 'logger' | 'accessToken'> & {
        fetch?: (request: Request) => ReturnType<typeof fetch>;
        headers?: Record<string, string>;
    }, metadata: {
        version?: string;
    });
}

/**
 * Sandbox filesystem event types.
 */
declare enum FilesystemEventType {
    /**
     * Filesystem object permissions were changed.
     */
    CHMOD = "chmod",
    /**
     * Filesystem object was created.
     */
    CREATE = "create",
    /**
     * Filesystem object was removed.
     */
    REMOVE = "remove",
    /**
     * Filesystem object was renamed.
     */
    RENAME = "rename",
    /**
     * Filesystem object was written to.
     */
    WRITE = "write"
}
/**
 * Information about a filesystem event.
 */
interface FilesystemEvent {
    /**
     * Relative path to the filesystem object.
     */
    name: string;
    /**
     * Filesystem operation event type.
     */
    type: FilesystemEventType;
}
/**
 * Handle for watching a directory in the sandbox filesystem.
 *
 * Use {@link WatchHandle.stop} to stop watching the directory.
 */
declare class WatchHandle {
    private readonly handleStop;
    private readonly events;
    private readonly onEvent?;
    private readonly onExit?;
    constructor(handleStop: () => void, events: AsyncIterable<WatchDirResponse>, onEvent?: ((event: FilesystemEvent) => void | Promise<void>) | undefined, onExit?: ((err?: Error) => void | Promise<void>) | undefined);
    /**
     * Stop watching the directory.
     */
    stop(): Promise<void>;
    private iterateEvents;
    private handleEvents;
}

/**
 * Sandbox filesystem object information.
 */
interface WriteInfo {
    /**
     * Name of the filesystem object.
     */
    name: string;
    /**
     * Type of the filesystem object.
     */
    type?: FileType;
    /**
     * Path to the filesystem object.
     */
    path: string;
}
interface EntryInfo extends WriteInfo {
    /**
     * Size of the filesystem object in bytes.
     */
    size: number;
    /**
     * File mode and permission bits.
     */
    mode: number;
    /**
     * String representation of file permissions (e.g. 'rwxr-xr-x').
     */
    permissions: string;
    /**
     * Owner of the filesystem object.
     */
    owner: string;
    /**
     * Group owner of the filesystem object.
     */
    group: string;
    /**
     * Last modification time of the filesystem object.
     */
    modifiedTime?: Date;
    /**
     * If the filesystem object is a symlink, this is the target of the symlink.
     */
    symlinkTarget?: string;
}
/**
 * Sandbox filesystem object type.
 */
declare enum FileType {
    /**
     * Filesystem object is a file.
     */
    FILE = "file",
    /**
     * Filesystem object is a directory.
     */
    DIR = "dir"
}
type WriteEntry = {
    path: string;
    data: string | ArrayBuffer | Blob | ReadableStream;
};
/**
 * Options for the sandbox filesystem operations.
 */
interface FilesystemRequestOpts extends Partial<Pick<ConnectionOpts, 'requestTimeoutMs'>> {
    /**
     * User to use for the operation in the sandbox.
     * This affects the resolution of relative paths and ownership of the created filesystem objects.
     */
    user?: Username;
}
interface FilesystemListOpts extends FilesystemRequestOpts {
    /**
     * Depth of the directory to list.
     */
    depth?: number;
}
/**
 * Options for watching a directory.
 */
interface WatchOpts extends FilesystemRequestOpts {
    /**
     * Timeout for the watch operation in **milliseconds**.
     * You can pass `0` to disable the timeout.
     *
     * @default 60_000 // 60 seconds
     */
    timeoutMs?: number;
    /**
     * Callback to call when the watch operation stops.
     */
    onExit?: (err?: Error) => void | Promise<void>;
    /**
     * Watch the directory recursively
     */
    recursive?: boolean;
}
/**
 * Module for interacting with the sandbox filesystem.
 */
declare class Filesystem {
    private readonly envdApi;
    private readonly connectionConfig;
    private readonly rpc;
    private readonly defaultWatchTimeout;
    private readonly defaultWatchRecursive;
    constructor(transport: Transport, envdApi: EnvdApiClient, connectionConfig: ConnectionConfig);
    /**
     * Read file content as a `string`.
     *
     * You can pass `text`, `bytes`, `blob`, or `stream` to `opts.format` to change the return type.
     *
     * @param path path to the file.
     * @param opts connection options.
     * @param [opts.format] format of the file content—`text` by default.
     *
     * @returns file content as string
     */
    read(path: string, opts?: FilesystemRequestOpts & {
        format?: 'text';
    }): Promise<string>;
    /**
     * Read file content as a `Uint8Array`.
     *
     * You can pass `text`, `bytes`, `blob`, or `stream` to `opts.format` to change the return type.
     *
     * @param path path to the file.
     * @param opts connection options.
     * @param [opts.format] format of the file content—`bytes`.
     *
     * @returns file content as `Uint8Array`
     */
    read(path: string, opts?: FilesystemRequestOpts & {
        format: 'bytes';
    }): Promise<Uint8Array>;
    /**
     * Read file content as a `Blob`.
     *
     * You can pass `text`, `bytes`, `blob`, or `stream` to `opts.format` to change the return type.
     *
     * @param path path to the file.
     * @param opts connection options.
     * @param [opts.format] format of the file content—`blob`.
     *
     * @returns file content as `Blob`
     */
    read(path: string, opts?: FilesystemRequestOpts & {
        format: 'blob';
    }): Promise<Blob>;
    /**
     * Read file content as a `ReadableStream`.
     *
     * You can pass `text`, `bytes`, `blob`, or `stream` to `opts.format` to change the return type.
     *
     * @param path path to the file.
     * @param opts connection options.
     * @param [opts.format] format of the file content—`stream`.
     *
     * @returns file content as `ReadableStream`
     */
    read(path: string, opts?: FilesystemRequestOpts & {
        format: 'stream';
    }): Promise<ReadableStream<Uint8Array>>;
    /**
     * Write content to a file.
     *
     *
     * Writing to a file that doesn't exist creates the file.
     *
     * Writing to a file that already exists overwrites the file.
     *
     * Writing to a file at path that doesn't exist creates the necessary directories.
     *
     * @param path path to file.
     * @param data data to write to the file. Data can be a string, `ArrayBuffer`, `Blob`, or `ReadableStream`.
     * @param opts connection options.
     *
     * @returns information about the written file
     */
    write(path: string, data: string | ArrayBuffer | Blob | ReadableStream, opts?: FilesystemRequestOpts): Promise<WriteInfo>;
    write(files: WriteEntry[], opts?: FilesystemRequestOpts): Promise<WriteInfo[]>;
    /**
     * List entries in a directory.
     *
     * @param path path to the directory.
     * @param opts connection options.
     *
     * @returns list of entries in the sandbox filesystem directory.
     */
    list(path: string, opts?: FilesystemListOpts): Promise<EntryInfo[]>;
    /**
     * Create a new directory and all directories along the way if needed on the specified path.
     *
     * @param path path to a new directory. For example '/dirA/dirB' when creating 'dirB'.
     * @param opts connection options.
     *
     * @returns `true` if the directory was created, `false` if it already exists.
     */
    makeDir(path: string, opts?: FilesystemRequestOpts): Promise<boolean>;
    /**
     * Rename a file or directory.
     *
     * @param oldPath path to the file or directory to rename.
     * @param newPath new path for the file or directory.
     * @param opts connection options.
     *
     * @returns information about renamed file or directory.
     */
    rename(oldPath: string, newPath: string, opts?: FilesystemRequestOpts): Promise<EntryInfo>;
    /**
     * Remove a file or directory.
     *
     * @param path path to a file or directory.
     * @param opts connection options.
     */
    remove(path: string, opts?: FilesystemRequestOpts): Promise<void>;
    /**
     * Check if a file or a directory exists.
     *
     * @param path path to a file or a directory
     * @param opts connection options.
     *
     * @returns `true` if the file or directory exists, `false` otherwise
     */
    exists(path: string, opts?: FilesystemRequestOpts): Promise<boolean>;
    /**
     * Get information about a file or directory.
     *
     * @param path path to a file or directory.
     * @param opts connection options.
     *
     * @returns information about the file or directory like name, type, and path.
     */
    getInfo(path: string, opts?: FilesystemRequestOpts): Promise<EntryInfo>;
    /**
     * Start watching a directory for filesystem events.
     *
     * @param path path to directory to watch.
     * @param onEvent callback to call when an event in the directory occurs.
     * @param opts connection options.
     *
     * @returns `WatchHandle` object for stopping watching directory.
     */
    watchDir(path: string, onEvent: (event: FilesystemEvent) => void | Promise<void>, opts?: WatchOpts & {
        onExit?: (err?: Error) => void | Promise<void>;
    }): Promise<WatchHandle>;
}

declare const __brand: unique symbol;
type Brand<B> = {
    [__brand]: B;
};
type Branded<T, B> = T & Brand<B>;
type Stdout = Branded<string, 'stdout'>;
type Stderr = Branded<string, 'stderr'>;
type PtyOutput = Branded<Uint8Array, 'pty'>;
/**
 * Command execution result.
 */
interface CommandResult {
    /**
     * Command execution exit code.
     * `0` if the command finished successfully.
     */
    exitCode: number;
    /**
     * Error message from command execution if it failed.
     */
    error?: string;
    /**
     * Command stdout output.
     */
    stdout: string;
    /**
     * Command stderr output.
     */
    stderr: string;
}
/**
 * Error thrown when a command exits with a non-zero exit code.
 */
declare class CommandExitError extends SandboxError implements CommandResult {
    private readonly result;
    constructor(result: CommandResult);
    /**
     * Command execution exit code.
     * `0` if the command finished successfully.
     */
    get exitCode(): number;
    /**
     * Error message from command execution.
     */
    get error(): string | undefined;
    /**
     * Command execution stdout output.
     */
    get stdout(): string;
    /**
     * Command execution stderr output.
     */
    get stderr(): string;
}
/**
 * Command execution handle.
 *
 * It provides methods for waiting for the command to finish, retrieving stdout/stderr, and killing the command.
 *
 * @property {number} pid process ID of the command.
 */
declare class CommandHandle implements Omit<CommandResult, 'exitCode' | 'error'>, Partial<Pick<CommandResult, 'exitCode' | 'error'>> {
    readonly pid: number;
    private readonly handleDisconnect;
    private readonly handleKill;
    private readonly events;
    private readonly onStdout?;
    private readonly onStderr?;
    private readonly onPty?;
    private _stdout;
    private _stderr;
    private result?;
    private iterationError?;
    private readonly _wait;
    /**
     * @hidden
     * @internal
     * @access protected
     */
    constructor(pid: number, handleDisconnect: () => void, handleKill: () => Promise<boolean>, events: AsyncIterable<ConnectResponse | StartResponse>, onStdout?: ((stdout: string) => void | Promise<void>) | undefined, onStderr?: ((stderr: string) => void | Promise<void>) | undefined, onPty?: ((pty: Uint8Array) => void | Promise<void>) | undefined);
    /**
     * Command execution exit code.
     * `0` if the command finished successfully.
     *
     * It is `undefined` if the command is still running.
     */
    get exitCode(): number | undefined;
    /**
     * Error message from command execution.
     */
    get error(): string | undefined;
    /**
     * Command execution stderr output.
     */
    get stderr(): string;
    /**
     * Command execution stdout output.
     */
    get stdout(): string;
    /**
     * Wait for the command to finish and return the result.
     * If the command exits with a non-zero exit code, it throws a `CommandExitError`.
     *
     * @returns `CommandResult` result of command execution.
     */
    wait(): Promise<CommandResult>;
    /**
     * Disconnect from the command.
     *
     * The command is not killed, but SDK stops receiving events from the command.
     * You can reconnect to the command using {@link Commands.connect}.
     */
    disconnect(): Promise<void>;
    /**
     * Kill the command.
     * It uses `SIGKILL` signal to kill the command.
     *
     * @returns `true` if the command was killed successfully, `false` if the command was not found.
     */
    kill(): Promise<boolean>;
    private iterateEvents;
    private handleEvents;
}

/**
 * Options for request to the Sandbox API.
 */
interface SandboxApiOpts extends Partial<Pick<ConnectionOpts, 'apiKey' | 'headers' | 'debug' | 'domain' | 'requestTimeoutMs'>> {
}
/**
 * Options for create sandbox request.
 */
interface SandboxCreateOpts extends SandboxApiOpts {
    /**
     * Custom metadata for the sandbox
     */
    metadata?: Record<string, string>;
    /**
     * Custom environment variables for the sandbox
     */
    envs?: Record<string, string>;
    /**
     * Envd is secured with access token and cannot be used without it
     */
    secure?: boolean;
    /**
     * Allow sandbox to access the internet, defaults to `true`.
     */
    allowInternetAccess?: boolean;
}
interface SandboxListOpts extends SandboxApiOpts {
    /**
     * Filter the list of sandboxes, e.g. by metadata `metadata:{"key": "value"}`, if there are multiple filters they are combined with AND.
     */
    query?: {
        metadata?: Record<string, string>;
    };
}
interface SandboxMetricsOpts extends SandboxApiOpts {
    /**
     * Start time for the metrics, defaults to the start of the sandbox
     */
    start?: string | Date;
    /**
     * End time for the metrics, defaults to the current time
     */
    end?: string | Date;
}
/**
 * Information about a sandbox.
 */
interface SandboxInfo {
    /**
     * Sandbox ID.
     */
    sandboxId: string;
    /**
     * Domain where the sandbox is hosted.
     */
    sandboxDomain?: string;
    /**
     * Template ID.
     */
    templateId: string;
    /**
     * Template name.
     */
    name?: string;
    /**
     * Envd access token.
     */
    envdAccessToken?: string;
    /**
     * Envd version.
     */
    envdVersion?: string;
    /**
     * Saved sandbox metadata.
     */
    metadata: Record<string, string>;
    /**
     * Sandbox start time.
     */
    startedAt: Date;
    /**
     * Sandbox expiration date.
     */
    endAt: Date;
}
interface ListedSandbox {
    /**
     * Sandbox ID.
     */
    sandboxId: string;
    /**
     * Template ID alias.
     */
    alias?: string;
    /**
     * Template ID.
     */
    templateId: string;
    /**
     * Client ID.
     * @deprecated
     */
    clientId: string;
    /**
     * Sandbox state.
     */
    state: 'running' | 'paused';
    /**
     * Sandbox CPU count.
     */
    cpuCount: number;
    /**
     * Sandbox Memory size in MB.
     */
    memoryMB: number;
    /**
     * Saved sandbox metadata.
     */
    metadata?: Record<string, string>;
    /**
     * Sandbox expected end time.
     */
    endAt: Date;
    /**
     * Sandbox start time.
     */
    startedAt: Date;
}
/**
 * Sandbox resource usage metrics.
 */
interface SandboxMetrics {
    /**
     * Timestamp of the metrics.
     */
    timestamp: Date;
    /**
     * CPU usage in percentage.
     */
    cpuUsedPct: number;
    /**
     * Number of CPU cores.
     */
    cpuCount: number;
    /**
     * Memory usage in bytes.
     */
    memUsed: number;
    /**
     * Total memory available in bytes.
     */
    memTotal: number;
    /**
     * Used disk space in bytes.
     */
    diskUsed: number;
    /**
     * Total disk space available in bytes.
     */
    diskTotal: number;
}
declare class SandboxApi {
    protected constructor();
    /**
     * Kill the sandbox specified by sandbox ID.
     *
     * @param sandboxId sandbox ID.
     * @param opts connection options.
     *
     * @returns `true` if the sandbox was found and killed, `false` otherwise.
     */
    static kill(sandboxId: string, opts?: SandboxApiOpts): Promise<boolean>;
    /**
     * List all running sandboxes.
     *
     * @param opts connection options.
     *
     * @returns list of running sandboxes.
     */
    static list(opts?: SandboxListOpts): Promise<ListedSandbox[]>;
    /**
     * Get sandbox information like sandbox ID, template, metadata, started at/end at date.
     *
     * @param sandboxId sandbox ID.
     * @param opts connection options.
     *
     * @returns sandbox information.
     */
    static getInfo(sandboxId: string, opts?: SandboxApiOpts): Promise<SandboxInfo>;
    /**
     * Get the metrics of the sandbox.
     *
     * @param sandboxId sandbox ID.
     * @param opts sandbox metrics options.
     *
     * @returns  List of sandbox metrics containing CPU, memory and disk usage information.
     */
    static getMetrics(sandboxId: string, opts?: SandboxMetricsOpts): Promise<SandboxMetrics[]>;
    /**
     * Set the timeout of the specified sandbox.
     * After the timeout expires the sandbox will be automatically killed.
     *
     * This method can extend or reduce the sandbox timeout set when creating the sandbox or from the last call to {@link Sandbox.setTimeout}.
     *
     * Maximum time a sandbox can be kept alive is 24 hours (86_400_000 milliseconds) for Pro users and 1 hour (3_600_000 milliseconds) for Hobby users.
     *
     * @param sandboxId sandbox ID.
     * @param timeoutMs timeout in **milliseconds**.
     * @param opts connection options.
     */
    static setTimeout(sandboxId: string, timeoutMs: number, opts?: SandboxApiOpts): Promise<void>;
    protected static createSandbox(template: string, timeoutMs: number, opts?: SandboxCreateOpts): Promise<{
        sandboxId: string;
        sandboxDomain?: string;
        envdVersion: string;
        envdAccessToken?: string;
    }>;
    private static timeoutToSeconds;
}

interface PtyCreateOpts extends Pick<ConnectionOpts, 'requestTimeoutMs'> {
    /**
     * Number of columns for the PTY.
     */
    cols: number;
    /**
     * Number of rows for the PTY.
     */
    rows: number;
    /**
     * Callback to handle PTY data.
     */
    onData: (data: Uint8Array) => void | Promise<void>;
    /**
     * Timeout for the PTY in **milliseconds**.
     *
     * @default 60_000 // 60 seconds
     */
    timeoutMs?: number;
    /**
     * User to use for the PTY.
     *
     * @default `user`
     */
    user?: Username;
    /**
     * Environment variables for the PTY.
     *
     * @default {}
     */
    envs?: Record<string, string>;
    /**
     * Working directory for the PTY.
     *
     * @default // home directory of the user used to start the PTY
     */
    cwd?: string;
}
/**
 * Module for interacting with PTYs (pseudo-terminals) in the sandbox.
 */
declare class Pty {
    private readonly transport;
    private readonly connectionConfig;
    private readonly rpc;
    constructor(transport: Transport, connectionConfig: ConnectionConfig);
    /**
     * Create a new PTY (pseudo-terminal).
     *
     * @param opts options for creating the PTY.
     *
     * @returns handle to interact with the PTY.
     */
    create(opts: PtyCreateOpts): Promise<CommandHandle>;
    /**
     * Send input to a PTY.
     *
     * @param pid process ID of the PTY.
     * @param data input data to send to the PTY.
     * @param opts connection options.
     */
    sendInput(pid: number, data: Uint8Array, opts?: Pick<ConnectionOpts, 'requestTimeoutMs'>): Promise<void>;
    /**
     * Resize PTY.
     * Call this when the terminal window is resized and the number of columns and rows has changed.
     *
     * @param pid process ID of the PTY.
     * @param size new size of the PTY.
     * @param opts connection options.
     */
    resize(pid: number, size: {
        cols: number;
        rows: number;
    }, opts?: Pick<ConnectionOpts, 'requestTimeoutMs'>): Promise<void>;
    /**
     * Kill a running PTY specified by process ID.
     * It uses `SIGKILL` signal to kill the PTY.
     *
     * @param pid process ID of the PTY.
     * @param opts connection options.
     *
     * @returns `true` if the PTY was killed, `false` if the PTY was not found.
     */
    kill(pid: number, opts?: Pick<ConnectionOpts, 'requestTimeoutMs'>): Promise<boolean>;
}

/**
 * Options for sending a command request.
 */
interface CommandRequestOpts extends Partial<Pick<ConnectionOpts, 'requestTimeoutMs'>> {
}
/**
 * Options for starting a new command.
 */
interface CommandStartOpts extends CommandRequestOpts {
    /**
     * If true, starts command in the background and the method returns immediately.
     * You can use {@link CommandHandle.wait} to wait for the command to finish.
     */
    background?: boolean;
    /**
     * Working directory for the command.
     *
     * @default // home directory of the user used to start the command
     */
    cwd?: string;
    /**
     * User to run the command as.
     *
     * @default `user`
     */
    user?: Username;
    /**
     * Environment variables used for the command.
     *
     * This overrides the default environment variables from `Sandbox` constructor.
     *
     * @default `{}`
     */
    envs?: Record<string, string>;
    /**
     * Callback for command stdout output.
     */
    onStdout?: (data: string) => void | Promise<void>;
    /**
     * Callback for command stderr output.
     */
    onStderr?: (data: string) => void | Promise<void>;
    /**
     * Timeout for the command in **milliseconds**.
     *
     * @default 60_000 // 60 seconds
     */
    timeoutMs?: number;
}
/**
 * Options for connecting to a command.
 */
type CommandConnectOpts = Pick<CommandStartOpts, 'onStderr' | 'onStdout' | 'timeoutMs'> & CommandRequestOpts;
/**
 * Information about a command, PTY session or start command running in the sandbox as process.
 */
interface ProcessInfo {
    /**
     * Process ID.
     */
    pid: number;
    /**
     * Custom tag used for identifying special commands like start command in the custom template.
     */
    tag?: string;
    /**
     * Command that was executed.
     */
    cmd: string;
    /**
     * Command arguments.
     */
    args: string[];
    /**
     * Environment variables used for the command.
     */
    envs: Record<string, string>;
    /**
     * Executed command working directory.
     */
    cwd?: string;
}
/**
 * Module for starting and interacting with commands in the sandbox.
 */
declare class Commands {
    private readonly connectionConfig;
    protected readonly rpc: Client<typeof Process>;
    private readonly defaultProcessConnectionTimeout;
    constructor(transport: Transport, connectionConfig: ConnectionConfig);
    /**
     * List all running commands and PTY sessions.
     *
     * @param opts connection options.
     *
     * @returns list of running commands and PTY sessions.
     */
    list(opts?: CommandRequestOpts): Promise<ProcessInfo[]>;
    /**
     * Send data to command stdin.
     *
     * @param pid process ID of the command. You can get the list of running commands using {@link Commands.list}.
     * @param data data to send to the command.
     * @param opts connection options.
     */
    sendStdin(pid: number, data: string, opts?: CommandRequestOpts): Promise<void>;
    /**
     * Kill a running command specified by its process ID.
     * It uses `SIGKILL` signal to kill the command.
     *
     * @param pid process ID of the command. You can get the list of running commands using {@link Commands.list}.
     * @param opts connection options.
     *
     * @returns `true` if the command was killed, `false` if the command was not found.
     */
    kill(pid: number, opts?: CommandRequestOpts): Promise<boolean>;
    /**
     * Connect to a running command.
     * You can use {@link CommandHandle.wait} to wait for the command to finish and get execution results.
     *
     * @param pid process ID of the command to connect to. You can get the list of running commands using {@link Commands.list}.
     * @param opts connection options.
     *
     * @returns `CommandHandle` handle to interact with the running command.
     */
    connect(pid: number, opts?: CommandConnectOpts): Promise<CommandHandle>;
    /**
     * Start a new command and wait until it finishes executing.
     *
     * @param cmd command to execute.
     * @param opts options for starting the command.
     *
     * @returns `CommandResult` result of the command execution.
     */
    run(cmd: string, opts?: CommandStartOpts & {
        background?: false;
    }): Promise<CommandResult>;
    /**
     * Start a new command in the background.
     * You can use {@link CommandHandle.wait} to wait for the command to finish and get its result.
     *
     * @param cmd command to execute.
     * @param opts options for starting the command
     *
     * @returns `CommandHandle` handle to interact with the running command.
     */
    run(cmd: string, opts: CommandStartOpts & {
        background: true;
    }): Promise<CommandHandle>;
    /**
     * Start a new command.
     *
     * @param cmd command to execute.
     * @param opts options for starting the command.
     *   - `opts.background: true` - runs in background, returns `CommandHandle`
     *   - `opts.background: false | undefined` - waits for completion, returns `CommandResult`
     *
     * @returns Either a `CommandHandle` or a `CommandResult` (depending on `opts.background`).
     */
    run(cmd: string, opts?: CommandStartOpts & {
        background?: boolean;
    }): Promise<CommandHandle | CommandResult>;
    private start;
}

/**
 * Options for creating a new Sandbox.
 */
interface SandboxOpts extends ConnectionOpts {
    /**
     * Custom metadata for the sandbox.
     *
     * @default {}
     */
    metadata?: Record<string, string>;
    /**
     * Custom environment variables for the sandbox.
     *
     * Used when executing commands and code in the sandbox.
     * Can be overridden with the `envs` argument when executing commands or code.
     *
     * @default {}
     */
    envs?: Record<string, string>;
    /**
     * Timeout for the sandbox in **milliseconds**.
     * Maximum time a sandbox can be kept alive is 24 hours (86_400_000 milliseconds) for Pro users and 1 hour (3_600_000 milliseconds) for Hobby users.
     *
     * @default 300_000 // 5 minutes
     */
    timeoutMs?: number;
    /**
     * Secure all traffic coming to the sandbox controller with auth token
     *
     * @default false
     */
    secure?: boolean;
    /**
     * Allow sandbox to access the internet
     *
     * @default true
     */
    allowInternetAccess?: boolean;
}
/**
 * Options for sandbox upload/download URL generation.
 */
interface SandboxUrlOpts {
    /**
     * Use signature expiration for the URL.
     * Optional parameter to set the expiration time for the signature in seconds.
     */
    useSignatureExpiration?: number;
    /**
     * User that will be used to access the file.
     */
    user?: Username;
}
/**
 * E2B cloud sandbox is a secure and isolated cloud environment.
 *
 * The sandbox allows you to:
 * - Access Linux OS
 * - Create, list, and delete files and directories
 * - Run commands
 * - Run isolated code
 * - Access the internet
 *
 * Check docs [here](https://e2b.dev/docs).
 *
 * Use {@link Sandbox.create} to create a new sandbox.
 *
 * @example
 * ```ts
 * import { Sandbox } from 'e2b'
 *
 * const sandbox = await Sandbox.create()
 * ```
 */
declare class Sandbox extends SandboxApi {
    protected static readonly defaultTemplate: string;
    protected static readonly defaultSandboxTimeoutMs = 300000;
    /**
     * Module for interacting with the sandbox filesystem
     */
    readonly files: Filesystem;
    /**
     * Module for running commands in the sandbox
     */
    readonly commands: Commands;
    /**
     * Module for interacting with the sandbox pseudo-terminals
     */
    readonly pty: Pty;
    /**
     * Unique identifier of the sandbox.
     */
    readonly sandboxId: string;
    /**
     * Domain where the sandbox is hosted.
     */
    readonly sandboxDomain: string;
    protected readonly envdPort = 49983;
    protected readonly connectionConfig: ConnectionConfig;
    private readonly envdApiUrl;
    private readonly envdAccessToken?;
    private readonly envdApi;
    /**
     * Use {@link Sandbox.create} to create a new Sandbox instead.
     *
     * @hidden
     * @hide
     * @internal
     * @access protected
     */
    constructor(opts: Omit<SandboxOpts, 'timeoutMs' | 'envs' | 'metadata'> & {
        sandboxId: string;
        sandboxDomain?: string;
        envdVersion?: string;
        envdAccessToken?: string;
    });
    /**
     * Create a new sandbox from the default `base` sandbox template.
     *
     * @param opts connection options.
     *
     * @returns sandbox instance for the new sandbox.
     *
     * @example
     * ```ts
     * const sandbox = await Sandbox.create()
     * ```
     * @constructs Sandbox
     */
    static create<S extends typeof Sandbox>(this: S, opts?: SandboxOpts): Promise<InstanceType<S>>;
    /**
     * Create a new sandbox from the specified sandbox template.
     *
     * @param template sandbox template name or ID.
     * @param opts connection options.
     *
     * @returns sandbox instance for the new sandbox.
     *
     * @example
     * ```ts
     * const sandbox = await Sandbox.create('<template-name-or-id>')
     * ```
     * @constructs Sandbox
     */
    static create<S extends typeof Sandbox>(this: S, template: string, opts?: SandboxOpts): Promise<InstanceType<S>>;
    /**
     * Connect to an existing sandbox.
     * With sandbox ID you can connect to the same sandbox from different places or environments (serverless functions, etc).
     *
     * @param sandboxId sandbox ID.
     * @param opts connection options.
     *
     * @returns sandbox instance for the existing sandbox.
     *
     * @example
     * ```ts
     * const sandbox = await Sandbox.create()
     * const sandboxId = sandbox.sandboxId
     *
     * // Connect to the same sandbox.
     * const sameSandbox = await Sandbox.connect(sandboxId)
     * ```
     */
    static connect<S extends typeof Sandbox>(this: S, sandboxId: string, opts?: Omit<SandboxOpts, 'metadata' | 'envs' | 'timeoutMs'>): Promise<InstanceType<S>>;
    /**
     * Get the host address for the specified sandbox port.
     * You can then use this address to connect to the sandbox port from outside the sandbox via HTTP or WebSocket.
     *
     * @param port number of the port in the sandbox.
     *
     * @returns host address of the sandbox port.
     *
     * @example
     * ```ts
     * const sandbox = await Sandbox.create()
     * // Start an HTTP server
     * await sandbox.commands.exec('python3 -m http.server 3000')
     * // Get the hostname of the HTTP server
     * const serverURL = sandbox.getHost(3000)
     * ```
     */
    getHost(port: number): string;
    /**
     * Check if the sandbox is running.
     *
     * @returns `true` if the sandbox is running, `false` otherwise.
     *
     * @example
     * ```ts
     * const sandbox = await Sandbox.create()
     * await sandbox.isRunning() // Returns true
     *
     * await sandbox.kill()
     * await sandbox.isRunning() // Returns false
     * ```
     */
    isRunning(opts?: Pick<ConnectionOpts, 'requestTimeoutMs'>): Promise<boolean>;
    /**
     * Set the timeout of the sandbox.
     * After the timeout expires the sandbox will be automatically killed.
     *
     * This method can extend or reduce the sandbox timeout set when creating the sandbox or from the last call to `.setTimeout`.
     * Maximum time a sandbox can be kept alive is 24 hours (86_400_000 milliseconds) for Pro users and 1 hour (3_600_000 milliseconds) for Hobby users.
     *
     * @param timeoutMs timeout in **milliseconds**.
     * @param opts connection options.
     */
    setTimeout(timeoutMs: number, opts?: Pick<SandboxOpts, 'requestTimeoutMs'>): Promise<void>;
    /**
     * Kill the sandbox.
     *
     * @param opts connection options.
     */
    kill(opts?: Pick<SandboxOpts, 'requestTimeoutMs'>): Promise<void>;
    /**
     * Get the URL to upload a file to the sandbox.
     *
     * You have to send a POST request to this URL with the file as multipart/form-data.
     *
     * @param path path to the file in the sandbox.
     *
     * @param opts download url options.
     *
     * @returns URL for uploading file.
     */
    uploadUrl(path?: string, opts?: SandboxUrlOpts): Promise<string>;
    /**
     * Get the URL to download a file from the sandbox.
     *
     * @param path path to the file in the sandbox.
     *
     * @param opts download url options.
     *
     * @returns URL for downloading file.
     */
    downloadUrl(path: string, opts?: SandboxUrlOpts): Promise<string>;
    /**
     * Get sandbox information like sandbox ID, template, metadata, started at/end at date.
     *
     * @param opts connection options.
     *
     * @returns information about the sandbox
     */
    getInfo(opts?: Pick<SandboxOpts, 'requestTimeoutMs'>): Promise<SandboxInfo>;
    /**
     * Get the metrics of the sandbox.
     *
     * @param opts connection options.
     *
     * @returns  List of sandbox metrics containing CPU, memory and disk usage information.
     */
    getMetrics(opts?: Pick<SandboxMetricsOpts, 'start' | 'end' | 'requestTimeoutMs'>): Promise<SandboxMetrics[]>;
    private fileUrl;
}

export { ApiClient, AuthenticationError, type CommandConnectOpts, CommandExitError, CommandHandle, type CommandRequestOpts, type CommandResult, type CommandStartOpts, Commands, ConnectionConfig, type ConnectionOpts, type EntryInfo, FileType, Filesystem, type FilesystemEvent, FilesystemEventType, InvalidArgumentError, type Logger, NotEnoughSpaceError, NotFoundError, type ProcessInfo, Pty, type PtyOutput, RateLimitError, Sandbox, type SandboxApiOpts, type SandboxCreateOpts, SandboxError, type SandboxInfo, type SandboxMetrics, type SandboxOpts, type Stderr, type Stdout, TemplateError, TimeoutError, type Username, WatchHandle, type WriteInfo, type components, Sandbox as default, getSignature, type paths };
