/* Fengari specific functions
 *
 * This file includes fengari-specific data or and functionality for users to
 * manipulate fengari's string type.
 * The fields are exposed to the user on the 'fengari' entry point; however to
 * avoid a dependency on defs.js from lauxlib.js they are defined in this file.
 */

const defs = require("./defs.js");

const FENGARI_VERSION_MAJOR   = "0";
const FENGARI_VERSION_MINOR   = "1";
const FENGARI_VERSION_NUM     = 1;
const FENGARI_VERSION_RELEASE = "4";
const FENGARI_VERSION         = "Fengari " + FENGARI_VERSION_MAJOR + "." + FENGARI_VERSION_MINOR;
const FENGARI_RELEASE         = FENGARI_VERSION + "." + FENGARI_VERSION_RELEASE;
const FENGARI_AUTHORS         = "B. Giannangeli, Daurnimator";
const FENGARI_COPYRIGHT       = FENGARI_RELEASE + "  Copyright (C) 2017-2018 " + FENGARI_AUTHORS + "\nBased on: " + defs.LUA_COPYRIGHT;

module.exports.FENGARI_AUTHORS         = FENGARI_AUTHORS;
module.exports.FENGARI_COPYRIGHT       = FENGARI_COPYRIGHT;
module.exports.FENGARI_RELEASE         = FENGARI_RELEASE;
module.exports.FENGARI_VERSION         = FENGARI_VERSION;
module.exports.FENGARI_VERSION_MAJOR   = FENGARI_VERSION_MAJOR;
module.exports.FENGARI_VERSION_MINOR   = FENGARI_VERSION_MINOR;
module.exports.FENGARI_VERSION_NUM     = FENGARI_VERSION_NUM;
module.exports.FENGARI_VERSION_RELEASE = FENGARI_VERSION_RELEASE;
module.exports.is_luastring            = defs.is_luastring;
module.exports.luastring_eq            = defs.luastring_eq;
module.exports.luastring_from          = defs.luastring_from;
module.exports.luastring_indexOf       = defs.luastring_indexOf;
module.exports.luastring_of            = defs.luastring_of;
module.exports.to_jsstring             = defs.to_jsstring;
module.exports.to_luastring            = defs.to_luastring;
module.exports.to_uristring            = defs.to_uristring;
module.exports.from_userstring         = defs.from_userstring;
