import { OAuth2Client, JWT, Compute, UserRefreshClient, BaseExternalAccountClient, GaxiosResponseWithHTTP2, GoogleConfigurable, MethodOptions, StreamMethodOptions, GlobalOptions, GoogleAuth, BodyResponseCallback, APIRequestContext } from 'googleapis-common';
import { Readable } from 'stream';
export declare namespace chromewebstore_v2 {
    export interface Options extends GlobalOptions {
        version: 'v2';
    }
    interface StandardParameters {
        /**
         * Auth client or API Key for the request
         */
        auth?: string | OAuth2Client | JWT | Compute | UserRefreshClient | BaseExternalAccountClient | GoogleAuth;
        /**
         * V1 error format.
         */
        '$.xgafv'?: string;
        /**
         * OAuth access token.
         */
        access_token?: string;
        /**
         * Data format for response.
         */
        alt?: string;
        /**
         * JSONP
         */
        callback?: string;
        /**
         * Selector specifying which fields to include in a partial response.
         */
        fields?: string;
        /**
         * API key. Your API key identifies your project and provides you with API access, quota, and reports. Required unless you provide an OAuth 2.0 token.
         */
        key?: string;
        /**
         * OAuth 2.0 token for the current user.
         */
        oauth_token?: string;
        /**
         * Returns response with indentations and line breaks.
         */
        prettyPrint?: boolean;
        /**
         * Available to use for quota purposes for server-side applications. Can be any arbitrary string assigned to a user, but should not exceed 40 characters.
         */
        quotaUser?: string;
        /**
         * Legacy upload protocol for media (e.g. "media", "multipart").
         */
        uploadType?: string;
        /**
         * Upload protocol for media (e.g. "raw", "multipart").
         */
        upload_protocol?: string;
    }
    /**
     * Chrome Web Store API
     *
     * The Chrome Web Store API provides access to data about apps and extensions, as well as developer tools for managing them.
     *
     * @example
     * ```js
     * const {google} = require('googleapis');
     * const chromewebstore = google.chromewebstore('v2');
     * ```
     */
    export class Chromewebstore {
        context: APIRequestContext;
        media: Resource$Media;
        publishers: Resource$Publishers;
        constructor(options: GlobalOptions, google?: GoogleConfigurable);
    }
    /**
     * Request message for CancelSubmission.
     */
    export interface Schema$CancelSubmissionRequest {
    }
    /**
     * Response message for `CancelSubmission`.
     */
    export interface Schema$CancelSubmissionResponse {
    }
    /**
     * Deployment information for a specific release channel. Used in requests to update deployment parameters.
     */
    export interface Schema$DeployInfo {
        /**
         * Required. The current deploy percentage for the release channel (nonnegative number between 0 and 100).
         */
        deployPercentage?: number | null;
    }
    /**
     * Deployment information for a specific release channel
     */
    export interface Schema$DistributionChannel {
        /**
         * The extension version provided in the manifest of the uploaded package.
         */
        crxVersion?: string | null;
        /**
         * The current deploy percentage for the release channel (nonnegative number between 0 and 100).
         */
        deployPercentage?: number | null;
    }
    /**
     * Response message for `FetchItemStatus`.
     */
    export interface Schema$FetchItemStatusResponse {
        /**
         * Output only. The ID of the item.
         */
        itemId?: string | null;
        /**
         * Output only. The state of the last async upload for an item. Only set when there has been an async upload for the item in the past 24 hours.
         */
        lastAsyncUploadState?: string | null;
        /**
         * The name of the requested item.
         */
        name?: string | null;
        /**
         * The public key of the item, which may be generated by the store.
         */
        publicKey?: string | null;
        /**
         * Output only. Status of the current published revision of the item. Will be unset if the item is not published.
         */
        publishedItemRevisionStatus?: Schema$ItemRevisionStatus;
        /**
         * Status of the item revision submitted to be published. Will be unset if the item has not been submitted for publishing since the last successful publish.
         */
        submittedItemRevisionStatus?: Schema$ItemRevisionStatus;
        /**
         * If true, the item has been taken down for a policy violation. Check the developer dashboard for details.
         */
        takenDown?: boolean | null;
        /**
         * If true, the item has been warned for a policy violation and will be taken down if not resolved. Check the developer dashboard for details.
         */
        warned?: boolean | null;
    }
    /**
     * Details on the status of an item revision.
     */
    export interface Schema$ItemRevisionStatus {
        /**
         * Details on the package of the item
         */
        distributionChannels?: Schema$DistributionChannel[];
        /**
         * Output only. Current state of the item
         */
        state?: string | null;
    }
    /**
     * Request message for PublishItem.
     */
    export interface Schema$PublishItemRequest {
        /**
         * Optional. Additional deploy information including the desired initial percentage rollout. Defaults to the current value saved in the developer dashboard if unset.
         */
        deployInfos?: Schema$DeployInfo[];
        /**
         * Optional. Use this to control if the item is published immediately on approval or staged for publishing in the future. Defaults to `DEFAULT_PUBLISH` if unset.
         */
        publishType?: string | null;
        /**
         * Optional. Whether to attempt to skip item review. The API will validate if the item qualifies and return a validation error if the item requires review. Defaults to `false` if unset.
         */
        skipReview?: boolean | null;
    }
    /**
     * Response message for `PublishItem`.
     */
    export interface Schema$PublishItemResponse {
        /**
         * Output only. The ID of the item.
         */
        itemId?: string | null;
        /**
         * The name of the item that was submitted
         */
        name?: string | null;
        /**
         * Output only. The current state of the submission.
         */
        state?: string | null;
    }
    /**
     * Request message for SetPublishedDeployPercentage.
     */
    export interface Schema$SetPublishedDeployPercentageRequest {
        /**
         * Required. Unscaled percentage value for the publised revision (nonnegative number between 0 and 100). It must be larger than the existing target percentage.
         */
        deployPercentage?: number | null;
    }
    /**
     * Response message for `SetPublishedDeployPercentage`.
     */
    export interface Schema$SetPublishedDeployPercentageResponse {
    }
    /**
     * Request message for UploadItemPackage.
     */
    export interface Schema$UploadItemPackageRequest {
    }
    /**
     * Response message for `UploadItemPackage`.
     */
    export interface Schema$UploadItemPackageResponse {
        /**
         * The extension version provided in the manifest of the uploaded package. This will not be set if the upload is still in progress (`upload_state` is `UPLOAD_IN_PROGRESS`).
         */
        crxVersion?: string | null;
        /**
         * Output only. The ID of the item the package was uploaded to.
         */
        itemId?: string | null;
        /**
         * The name of the item the package was uploaded to.
         */
        name?: string | null;
        /**
         * Output only. The state of the upload. If `upload_state` is `UPLOAD_IN_PROGRESS`, you can poll for updates using the fetchStatus method.
         */
        uploadState?: string | null;
    }
    export class Resource$Media {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Upload a new package to an existing item.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chromewebstore.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const chromewebstore = google.chromewebstore('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/chromewebstore'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chromewebstore.media.upload({
         *     // Required. Name of the item to upload the new package to in the form `publishers/{publisherId\}/items/{itemId\}`
         *     name: 'publishers/my-publisher/items/my-item',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {}
         *     },
         *     media: {
         *       mimeType: 'placeholder-value',
         *       body: 'placeholder-value',
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "crxVersion": "my_crxVersion",
         *   //   "itemId": "my_itemId",
         *   //   "name": "my_name",
         *   //   "uploadState": "my_uploadState"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        upload(params: Params$Resource$Media$Upload, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        upload(params?: Params$Resource$Media$Upload, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$UploadItemPackageResponse>>;
        upload(params: Params$Resource$Media$Upload, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        upload(params: Params$Resource$Media$Upload, options: MethodOptions | BodyResponseCallback<Schema$UploadItemPackageResponse>, callback: BodyResponseCallback<Schema$UploadItemPackageResponse>): void;
        upload(params: Params$Resource$Media$Upload, callback: BodyResponseCallback<Schema$UploadItemPackageResponse>): void;
        upload(callback: BodyResponseCallback<Schema$UploadItemPackageResponse>): void;
    }
    export interface Params$Resource$Media$Upload extends StandardParameters {
        /**
         * Required. Name of the item to upload the new package to in the form `publishers/{publisherId\}/items/{itemId\}`
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$UploadItemPackageRequest;
        /**
         * Media metadata
         */
        media?: {
            /**
             * Media mime-type
             */
            mimeType?: string;
            /**
             * Media body contents
             */
            body?: any;
        };
    }
    export class Resource$Publishers {
        context: APIRequestContext;
        items: Resource$Publishers$Items;
        constructor(context: APIRequestContext);
    }
    export class Resource$Publishers$Items {
        context: APIRequestContext;
        constructor(context: APIRequestContext);
        /**
         * Cancel the current active submission of an item if present. This can be used to cancel the review of a pending submission.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chromewebstore.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const chromewebstore = google.chromewebstore('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/chromewebstore'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chromewebstore.publishers.items.cancelSubmission({
         *     // Required. Name of the item to cancel the submission of in the form `publishers/{publisherId\}/items/{itemId\}`
         *     name: 'publishers/my-publisher/items/my-item',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {}
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        cancelSubmission(params: Params$Resource$Publishers$Items$Cancelsubmission, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        cancelSubmission(params?: Params$Resource$Publishers$Items$Cancelsubmission, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$CancelSubmissionResponse>>;
        cancelSubmission(params: Params$Resource$Publishers$Items$Cancelsubmission, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        cancelSubmission(params: Params$Resource$Publishers$Items$Cancelsubmission, options: MethodOptions | BodyResponseCallback<Schema$CancelSubmissionResponse>, callback: BodyResponseCallback<Schema$CancelSubmissionResponse>): void;
        cancelSubmission(params: Params$Resource$Publishers$Items$Cancelsubmission, callback: BodyResponseCallback<Schema$CancelSubmissionResponse>): void;
        cancelSubmission(callback: BodyResponseCallback<Schema$CancelSubmissionResponse>): void;
        /**
         * Fetch the status of an item.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chromewebstore.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const chromewebstore = google.chromewebstore('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: [
         *       'https://www.googleapis.com/auth/chromewebstore',
         *       'https://www.googleapis.com/auth/chromewebstore.readonly',
         *     ],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chromewebstore.publishers.items.fetchStatus({
         *     // Required. Name of the item to retrieve the status of in the form `publishers/{publisherId\}/items/{itemId\}`
         *     name: 'publishers/my-publisher/items/my-item',
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "itemId": "my_itemId",
         *   //   "lastAsyncUploadState": "my_lastAsyncUploadState",
         *   //   "name": "my_name",
         *   //   "publicKey": "my_publicKey",
         *   //   "publishedItemRevisionStatus": {},
         *   //   "submittedItemRevisionStatus": {},
         *   //   "takenDown": false,
         *   //   "warned": false
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        fetchStatus(params: Params$Resource$Publishers$Items$Fetchstatus, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        fetchStatus(params?: Params$Resource$Publishers$Items$Fetchstatus, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$FetchItemStatusResponse>>;
        fetchStatus(params: Params$Resource$Publishers$Items$Fetchstatus, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        fetchStatus(params: Params$Resource$Publishers$Items$Fetchstatus, options: MethodOptions | BodyResponseCallback<Schema$FetchItemStatusResponse>, callback: BodyResponseCallback<Schema$FetchItemStatusResponse>): void;
        fetchStatus(params: Params$Resource$Publishers$Items$Fetchstatus, callback: BodyResponseCallback<Schema$FetchItemStatusResponse>): void;
        fetchStatus(callback: BodyResponseCallback<Schema$FetchItemStatusResponse>): void;
        /**
         * Submit the item to be published in the store. The item will be submitted for review unless `skip_review` is set to true, or the item is staged from a previous submission with `publish_type` set to `STAGED_PUBLISH`.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chromewebstore.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const chromewebstore = google.chromewebstore('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/chromewebstore'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res = await chromewebstore.publishers.items.publish({
         *     // Required. Name of the item in the form `publishers/{publisherId\}/items/{itemId\}`
         *     name: 'publishers/my-publisher/items/my-item',
         *
         *     // Request body metadata
         *     requestBody: {
         *       // request body parameters
         *       // {
         *       //   "deployInfos": [],
         *       //   "publishType": "my_publishType",
         *       //   "skipReview": false
         *       // }
         *     },
         *   });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {
         *   //   "itemId": "my_itemId",
         *   //   "name": "my_name",
         *   //   "state": "my_state"
         *   // }
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        publish(params: Params$Resource$Publishers$Items$Publish, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        publish(params?: Params$Resource$Publishers$Items$Publish, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$PublishItemResponse>>;
        publish(params: Params$Resource$Publishers$Items$Publish, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        publish(params: Params$Resource$Publishers$Items$Publish, options: MethodOptions | BodyResponseCallback<Schema$PublishItemResponse>, callback: BodyResponseCallback<Schema$PublishItemResponse>): void;
        publish(params: Params$Resource$Publishers$Items$Publish, callback: BodyResponseCallback<Schema$PublishItemResponse>): void;
        publish(callback: BodyResponseCallback<Schema$PublishItemResponse>): void;
        /**
         * Set a higher target deploy percentage for the item's published revision. This will be updated without the item being submitted for review. This is only available to items with over 10,000 seven-day active users.
         * @example
         * ```js
         * // Before running the sample:
         * // - Enable the API at:
         * //   https://console.developers.google.com/apis/api/chromewebstore.googleapis.com
         * // - Login into gcloud by running:
         * //   ```sh
         * //   $ gcloud auth application-default login
         * //   ```
         * // - Install the npm module by running:
         * //   ```sh
         * //   $ npm install googleapis
         * //   ```
         *
         * const {google} = require('googleapis');
         * const chromewebstore = google.chromewebstore('v2');
         *
         * async function main() {
         *   const auth = new google.auth.GoogleAuth({
         *     // Scopes can be specified either as an array or as a single, space-delimited string.
         *     scopes: ['https://www.googleapis.com/auth/chromewebstore'],
         *   });
         *
         *   // Acquire an auth client, and bind it to all future calls
         *   const authClient = await auth.getClient();
         *   google.options({auth: authClient});
         *
         *   // Do the magic
         *   const res =
         *     await chromewebstore.publishers.items.setPublishedDeployPercentage({
         *       // Required. Name of the item to update the published revision of in the form `publishers/{publisherId\}/items/{itemId\}`
         *       name: 'publishers/my-publisher/items/my-item',
         *
         *       // Request body metadata
         *       requestBody: {
         *         // request body parameters
         *         // {
         *         //   "deployPercentage": 0
         *         // }
         *       },
         *     });
         *   console.log(res.data);
         *
         *   // Example response
         *   // {}
         * }
         *
         * main().catch(e => {
         *   console.error(e);
         *   throw e;
         * });
         *
         * ```
         *
         * @param params - Parameters for request
         * @param options - Optionally override request options, such as `url`, `method`, and `encoding`.
         * @param callback - Optional callback that handles the response.
         * @returns A promise if used with async/await, or void if used with a callback.
         */
        setPublishedDeployPercentage(params: Params$Resource$Publishers$Items$Setpublisheddeploypercentage, options: StreamMethodOptions): Promise<GaxiosResponseWithHTTP2<Readable>>;
        setPublishedDeployPercentage(params?: Params$Resource$Publishers$Items$Setpublisheddeploypercentage, options?: MethodOptions): Promise<GaxiosResponseWithHTTP2<Schema$SetPublishedDeployPercentageResponse>>;
        setPublishedDeployPercentage(params: Params$Resource$Publishers$Items$Setpublisheddeploypercentage, options: StreamMethodOptions | BodyResponseCallback<Readable>, callback: BodyResponseCallback<Readable>): void;
        setPublishedDeployPercentage(params: Params$Resource$Publishers$Items$Setpublisheddeploypercentage, options: MethodOptions | BodyResponseCallback<Schema$SetPublishedDeployPercentageResponse>, callback: BodyResponseCallback<Schema$SetPublishedDeployPercentageResponse>): void;
        setPublishedDeployPercentage(params: Params$Resource$Publishers$Items$Setpublisheddeploypercentage, callback: BodyResponseCallback<Schema$SetPublishedDeployPercentageResponse>): void;
        setPublishedDeployPercentage(callback: BodyResponseCallback<Schema$SetPublishedDeployPercentageResponse>): void;
    }
    export interface Params$Resource$Publishers$Items$Cancelsubmission extends StandardParameters {
        /**
         * Required. Name of the item to cancel the submission of in the form `publishers/{publisherId\}/items/{itemId\}`
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$CancelSubmissionRequest;
    }
    export interface Params$Resource$Publishers$Items$Fetchstatus extends StandardParameters {
        /**
         * Required. Name of the item to retrieve the status of in the form `publishers/{publisherId\}/items/{itemId\}`
         */
        name?: string;
    }
    export interface Params$Resource$Publishers$Items$Publish extends StandardParameters {
        /**
         * Required. Name of the item in the form `publishers/{publisherId\}/items/{itemId\}`
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$PublishItemRequest;
    }
    export interface Params$Resource$Publishers$Items$Setpublisheddeploypercentage extends StandardParameters {
        /**
         * Required. Name of the item to update the published revision of in the form `publishers/{publisherId\}/items/{itemId\}`
         */
        name?: string;
        /**
         * Request body metadata
         */
        requestBody?: Schema$SetPublishedDeployPercentageRequest;
    }
    export {};
}
